(ns antifessional.libmisc.col
  "two helper functions from O'reilly and more
  
    ![](images/antifessional.libmisc.col.png)
  ")


(defn reduce-by
  "Reduce `col` with `f` and `init` collated by key `k`.  
   (Oreilly 120)" 
  [k f init col]
  (reduce (fn [acc x]
            (let [k (k x)]
              (assoc acc 
                     k 
                     (f (acc k init) x))))
          {} col))


(defn reduce-in
  "Reduce `col` with `f` and `init` collated by keys `ks`.  
   (Oreilly 121)"
  [ks f init col]  
  (reduce (fn [acc x]  
            (let [ks ((apply juxt ks) x)]     
              (assoc-in acc 
                        ks
                        (f (get-in acc ks init) x))))
          {} col))


(defmacro mapmap
  "returns a map with the same keys as `m` and values mapped by `f`"
   [f m ] 
 `(into (empty ~m)
    (for [[ k# v# ] ~m] [ k# (~f v#) ] )))


