;  Copyright (C) 2020 Gabriel Ash

; This program and the accompanying materials are made available under
; the terms of the Eclipse Public License 2.0 which is available at
; http://www.eclipse.org/legal/epl-2.0 .

; This code is provided as is, without any guarantee whatsoever.

(ns antifessional.libmisc.ex
  "easy Error handling
  
    ![](images/antifessional.libmisc.ex.png)
  "
  (:require [antifessional.libmisc.printf :refer [sprintf]]
            [clojure.spec.alpha :as s]))


(defn ex
  "generates an [ExceptionInfo](https://clojuredocs.org/clojure.core/ex-info)
   with a sprintf (template + args) message + optional structured data (map) as last argument.  
   an optional Throwable `cause` can be included in the `data-map` and ex will externalize it.
   "
  [msg & argv]
  (let [m (last argv)
        data (if (map? m) m {})
        args (if (map? m) (butlast argv) argv)]
    (if-let [cause (:cause data)]
      (ex-info (apply sprintf msg args) data cause)
      (ex-info (apply sprintf msg args) data ))))



(defn throw-ex
  "throws an exception. see [[ex]]"

  [& argv]
  (throw (apply ex argv)))
  

(defn valid?
  "[s/valid?](https://clojuredocs.org/clojure.spec.alpha/valid_q)
   that also explains on fail, unless third arg is :silent"
  [spec value & [silent?]]

  (if (s/valid? spec value)
    true
    (do
      (when-not (= silent? :silent)
        (println "ex-valid? explains:")
        (s/explain spec value))
      false)))


