(ns {{prefix}}.config.pedestal-adapter
  (:require
   [com.stuartsierra.component :as component]
   [io.pedestal.http :as pedestal.http]
   [{{prefix}}.config.kws :as config]
   [{{prefix}}.config.protocols.config :as protocols.config]
   [{{prefix}}.environment.kws :as environment]
   [nedap.speced.def :as speced]
   [nedap.utils.modular.api :refer [implement]]))

(speced/defn ^map? start [{^::config/component config ::config/component
                           ^::environment/component env ::environment/component}]
  {::pedestal.http/port   (protocols.config/server-port config)
   ::pedestal.http/host   (protocols.config/server-address config)
   ::pedestal.http/join?  false
   :env                   env})

(defn stop [_]
  {})

(defn new []
  (implement {}
    component/start start
    component/stop  stop))
