(ns {{prefix}}.config.protocols.config
  (:require
   [clojure.spec.alpha :as spec]
   [{{prefix}}.config.kws :as config]
   [nedap.speced.def :as speced]))

(spec/def :timbre/level #{:trace :debug :info :warn :error :fatal :report})
(spec/def :timbre/ns-whitelist (spec/coll-of string?))
(spec/def :timbre/ns-blacklist (spec/coll-of string?))
(spec/def :timbre/ns-greylist (spec/map-of string? :timbre/level))

(spec/def ::timbre-config
  (spec/keys :req-un [:timbre/level]
    :opt-un [:timbre/ns-whitelist
             :timbre/ns-blacklist
             :timbre/ns-greylist]))

(speced/defprotocol Config
  "Getters for this app's most used paths."
  (^::config/value value [this] "The whole config map")
  (^::timbre-config log-config [this] "Additional timbre config"){{#web?}}
  (^pos-int? server-port [this] "port to bind webserver to")
  (^string? server-address [this] "address to bind webserver to"){{/web?}})
