{{! Change mustache delimiter to <% and %> }}
{{=<% %>=}}
(ns <%prefix%>.layout.component
  (:require
   [hiccup.core :refer [html]]
   [<%prefix%>.assets.kws :as assets]
   [<%prefix%>.assets.protocols.assets :as protocols.assets]
   [<%prefix%>.layout.kws :as layout]
   [<%prefix%>.layout.protocols.layout :as protocols.layout]
   [<%prefix%>.layout.views.main :as views.main]
   [nedap.speced.def :as speced]
   [nedap.utils.modular.api :refer [implement]]))

(speced/defn main-layout [{{^::assets/javascripts javascripts ::assets/javascripts
                            ^::assets/stylesheets stylesheets ::assets/stylesheets
                            :as                               assets} ::assets/component
                           :as                                        ^::layout/component this}
                          {::protocols.layout/keys [body] :as ^::protocols.layout/opts opts}]
  (html
   (views.main/render {:body        body
                       :javascripts (mapv (partial protocols.assets/link-to-asset assets)
                                          javascripts)
                       :stylesheets (mapv (partial protocols.assets/link-to-asset assets)
                                          stylesheets)})))

(defn new []
  (implement {}
    protocols.layout/--main-layout main-layout))
