(ns dev
  (:require
   [clj-java-decompiler.core :refer [decompile]]
   [clojure.java.javadoc :refer [javadoc]]
   [clojure.pprint :refer [pprint]]
   [clojure.repl :refer [apropos dir doc find-doc pst source]]
   [clojure.test :refer [run-all-tests run-tests]]
   [clojure.tools.namespace.repl :refer [clear refresh refresh-dirs set-refresh-dirs]]
   {{#system?}}
   [com.stuartsierra.component.repl :refer [reset set-init start stop system]]
   [formatting-stack.component]
   [{{system-ns}}]
   {{/system?}}
   [criterium.core :refer [quick-bench]]
   [formatting-stack.branch-formatter :refer [format-and-lint-branch! lint-branch!]]
   [formatting-stack.processors.test-runner :refer [test!]]
   [formatting-stack.project-formatter :refer [format-and-lint-project! lint-project!]]
   [lambdaisland.deep-diff]))

{{^monorepo-subproject?}}
(set-refresh-dirs {{{dev-source-paths}}})
{{/monorepo-subproject?}}
{{#monorepo-subproject?}}
(->> ".."
     java.io.File.
     .listFiles
     (filter (fn [x]
               (and (-> x .isDirectory)
                    (-> x (java.io.File. "project.clj") .exists)
                    (not= (-> "user.dir" System/getProperty)
                          (-> x .getCanonicalPath (doto println))))))
     (mapv (fn [x]
             (-> x (java.io.File. "src") str)))
     (into [{{{dev-source-paths}}}])
     (apply set-refresh-dirs))
{{/monorepo-subproject?}}

{{#system?}}
(defn dev-system []
  ({{system-ns}}/create
   {:additional-components {:formatting-stack (formatting-stack.component/new {})}
    {{#web?}}
    :environment           :dev
    {{/web?}}}))

(set-init (fn [_]
            (dev-system)))
{{/system?}}

(defn suite []
  (refresh)
  (run-all-tests #".*\.{{escaped-prefix}}.*"))

(defn unit []
  (refresh)
  (run-all-tests #"unit\.{{escaped-prefix}}.*"))

(defn slow []
  (refresh)
  (run-all-tests #"integration\.{{escaped-prefix}}.*"))

(defn diff [x y]
  (-> x
      (lambdaisland.deep-diff/diff y)
      (lambdaisland.deep-diff/pretty-print)))

(defn gt
  "gt stands for git tests"
  []
  (refresh)
  (test!))
