(ns {{prefix}}.assets.kws
  (:require
   [clojure.spec.alpha :as spec]
   [nedap.speced.def :as speced]))

(spec/def ::assets (spec/coll-of string?))

(speced/def-with-doc ::javascripts
  "The set of javascript assets names for this application."
  ::assets)

(speced/def-with-doc ::stylesheets
  "The set of stylesheet assets names for this application."
  ::assets)

(speced/def-with-doc ::component
  "A component providing application-specific code for the asset pipeline.

Do not mistake with `nedap.components.assets.component`, which is generic and exclusively concerned with _compiling_ assets."
  (spec/keys :req [::javascripts ::stylesheets]))
