(ns {{system-ns}}
  (:require
   {{#web?}}
   [com.grzm.component.pedestal :refer [using-component]]
   [{{prefix}}.config.component :as config.component]
   [{{prefix}}.config.kws :as config]
   [{{prefix}}.config.pedestal-adapter :as config.pedestal-adapter]
   [{{prefix}}.environment.kws :as environment]
   [{{prefix}}.router.component :as router.component]
   [{{prefix}}.router.kws :as {{prefix}}.router]
   [nedap.components.pedestal.interceptors.component-injector :refer [component-injector]]
   [nedap.components.pedestal.router.kws :as components.pedestal.router]
   [nedap.components.pedestal.server.component :as server.component]
   [nedap.components.pedestal.server.kws :as server]
   [nedap.components.pedestal.service.component :as service.component]
   [nedap.components.pedestal.service.kws :as service]
   {{#nedap?}}
   [{{prefix}}.config.legacy-adapter :as config.legacy-adapter]
   [nedap.components.uncaught-exception-handler.component :as uncaught-exception-handler.component]
   [nedap.components.uncaught-exception-handler.kws :as uncaught-exception-handler]
   [pep-rollbar-clj.core :as pep-rollbar]
   {{/nedap?}}
   {{/web?}}
   [com.stuartsierra.component :as component]
   [nedap.speced.def :as speced])
  (:gen-class))
{{#web?}}

(def common-dependencies
  "The dependencies all domain-specific modules can be presumed to depend on."
  [::environment/component
   ::config/component])

(def domain-specific-dependencies
  [])

(def components-to-inject
  (into common-dependencies domain-specific-dependencies))

(defn adapters []
  {
   {{#nedap?}}
   ::legacy-config    (-> (config.legacy-adapter/new)
                          (component/using [::config/component]))
   {{/nedap?}}
   ::pedestal-adapter (-> (config.pedestal-adapter/new)
                          (component/using [::config/component ::environment/component]))})

(speced/defn create [{:keys [additional-components, ^::environment/component environment]}]
  (let [component-interceptors (conj (mapv using-component components-to-inject)
                                     (component-injector components-to-inject))
        defaults-kind (if (#{:dev :test} environment)
                        :dev
                        :production)
        server-dependencies (into server/dependencies components-to-inject)]
    (-> (component/system-map
         ::environment/component                environment
         ::config/component                     (-> (config.component/new)
                                                    (component/using config/dependencies))
         ::components.pedestal.router/component (-> (router.component/new component-interceptors)
                                                    (component/using {{prefix}}.router/dependencies))

         ::service/component                    (-> (service.component/new {::service/defaults-kind  defaults-kind
                                                                            ::service/expand-routes? false})
                                                    (component/using {::components.pedestal.router/component
                                                                      ::components.pedestal.router/component
                                                                      ::service/pedestal-options
                                                                      ::pedestal-adapter}))
         ::server/component                     (-> (server.component/new)
                                                    (component/using server-dependencies))
         {{#nedap?}}
         ::uncaught-exception-handler/component (-> (uncaught-exception-handler.component/new)
                                                    (component/using {::uncaught-exception-handler/notifier
                                                                      ::notifier}))
         ::notifier                             (-> (pep-rollbar/create-rollbar-notifier)
                                                    (component/using {:config      ::legacy-config
                                                                      :environment ::environment/component}))
         {{/nedap?}})
        (merge (adapters) additional-components))))

(defn -main [& args]
  (-> (create {:environment :production})
      (component/start)))
{{/web?}}
{{^web?}}
(speced/defn create [{:keys [additional-components]}]
  (-> (component/system-map)
      (merge additional-components)))

(defn -main [& args]
  (-> (create {})
      (component/start)))
{{/web?}}
