(ns dev
  (:require
   [clj-java-decompiler.core :refer [decompile]]
   [clojure.java.javadoc :refer [javadoc]]
   [clojure.pprint :refer [pprint]]
   [clojure.repl :refer [apropos dir doc find-doc pst source]]
   [clojure.test :refer [run-all-tests run-tests]]
   [clojure.tools.namespace.repl :refer [clear refresh set-refresh-dirs]]
   {{#system?}}
   [com.stuartsierra.component.repl :refer [reset set-init start stop system]]
   [formatting-stack.component]
   [{{system-ns}}]
   {{/system?}}
   [criterium.core :refer [quick-bench]]
   [formatting-stack.branch-formatter :refer [format-and-lint-branch! lint-branch!]]
   [formatting-stack.compilers.test-runner :refer [test!]]
   [formatting-stack.project-formatter :refer [format-and-lint-project! lint-project!]]
   [lambdaisland.deep-diff]))

(set-refresh-dirs "src" "test" "dev" {{#web?}}"modules"{{/web?}})

{{#system?}}
(defn dev-system []
  ({{system-ns}}/create
   {:additional-components {:formatting-stack (formatting-stack.component/map->Formatter {})}
    {{#web?}}
    :environment           :dev
    {{/web?}}}))

(set-init (fn [_]
            (dev-system)))
{{/system?}}

(defn suite []
  (refresh)
  (run-all-tests #".*\.{{escaped-prefix}}.*"))

(defn unit []
  (refresh)
  (run-all-tests #"unit\.{{escaped-prefix}}.*"))

(defn slow []
  (refresh)
  (run-all-tests #"integration\.{{escaped-prefix}}.*"))

(defn diff [x y]
  (-> x
      (lambdaisland.deep-diff/diff y)
      (lambdaisland.deep-diff/pretty-print)))

(defn gt
  "gt stands for git tests"
  []
  (refresh)
  (test!))
