(defproject nedap-lib/lein-template "1.10.0-alpha4"
  :description "A Leiningen template for Nedap Clojure libraries."

  :min-lein-version "2.0.0"

  :license {:name "EPL-2.0"
            :url  "https://www.eclipse.org/legal/epl-2.0/"}

  :signing {:gpg-key "releases-staffingsolutions@nedap.com"}

  :repositories {"releases" {:url      "https://nedap.jfrog.io/nedap/staffing-solutions/"
                             :username :env/artifactory_user
                             :password :env/artifactory_pass}}

  :deploy-repositories {"clojars" {:url      "https://clojars.org/repo"
                                   :username :env/clojars_user
                                   :password :env/clojars_pass}}

  :repository-auth {#"https://nedap.jfrog\.io/nedap/staffing-solutions/"
                    {:username :env/artifactory_user
                     :password :env/artifactory_pass}}

  :dependencies [[org.clojure/clojure "1.10.1"]]

  :url "http://github.com/nedap/lib-template"

  ;; Allows running ci.release-workflow regardless of Lein version (Lein may use Clojure < 1.10, assumed by that dep)
  :eval-in-leiningen ~(not (System/getenv "running_ci_release_workflow"))

  :profiles {:ci {:pedantic?    :abort
                  :jvm-opts     ["-Dclojure.main.report=stderr"]
                  :global-vars  {*assert* true} ;; `ci.release-workflow` relies on runtime assertions
                  :dependencies [[com.nedap.staffing-solutions/ci.release-workflow "1.6.0"]]}})
