# nedap-lib

A Leiningen template for Clojure libraries at Nedap.

Includes boilerplate/defaults related to our usage of Clojure/Script, GitHub, CircleCI and JFrog. 

* See `resources/leiningen/new/nedap_lib/*` for getting an accurate idea of each file's contents.
* See the `leiningen.new.nedap-lib` ns to learn about the values to be templated into each file.

## Usage

```
lein new nedap-lib foo
```

Will generate a `nedap.foo.api` namespace, and a `com.nedap.staffing-solutions/foo` artifact.

This can be tweaked according to a couple env vars, see `leiningen.new.nedap-lib`.

## Clojars

In order to enable releasing to Clojars, please add the following:

**project.clj**

```clojure
  :deploy-repositories {"clojars" {:url      "https://clojars.org/repo"
                                   :username :env/clojars_user
                                   :password :env/clojars_pass}}
```

**.circleci/config.yml**

```
      - run:
          name: release to Clojars
          command: lein deploy clojars
```

## Current version

<!-- This section exists to make com.nedap.staffing-solutions/ci.release-workflow happy -->

The project coordninates are `[nedap-lib/lein-template "0.2.0-alpha2"]`.

However you don't need to use them; `lein new` should fetch the latest version automatically.

## License

Copyright © 2019 Nedap

Distributed under the Eclipse Public License either version 1.0 or (at
your option) any later version.
