/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time.format;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.joda.time.Chronology;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.field.MillisDurationField;
import org.joda.time.field.PreciseDateTimeField;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.DateTimePrinter;
import org.joda.time.format.FormatUtils;

public class DateTimeFormatterBuilder {
    private ArrayList iElementPairs = new ArrayList();
    private Object iFormatter;

    public DateTimeFormatter toFormatter() {
        Object object = this.getFormatter();
        DateTimePrinter dateTimePrinter = null;
        if (this.isPrinter(object)) {
            dateTimePrinter = (DateTimePrinter)object;
        }
        DateTimeParser dateTimeParser = null;
        if (this.isParser(object)) {
            dateTimeParser = (DateTimeParser)object;
        }
        if (dateTimePrinter != null || dateTimeParser != null) {
            return new DateTimeFormatter(dateTimePrinter, dateTimeParser);
        }
        throw new UnsupportedOperationException("Both printing and parsing not supported");
    }

    public DateTimePrinter toPrinter() {
        Object object = this.getFormatter();
        if (this.isPrinter(object)) {
            return (DateTimePrinter)object;
        }
        throw new UnsupportedOperationException("Printing is not supported");
    }

    public DateTimeParser toParser() {
        Object object = this.getFormatter();
        if (this.isParser(object)) {
            return (DateTimeParser)object;
        }
        throw new UnsupportedOperationException("Parsing is not supported");
    }

    public boolean canBuildFormatter() {
        return this.isFormatter(this.getFormatter());
    }

    public boolean canBuildPrinter() {
        return this.isPrinter(this.getFormatter());
    }

    public boolean canBuildParser() {
        return this.isParser(this.getFormatter());
    }

    public void clear() {
        this.iFormatter = null;
        this.iElementPairs.clear();
    }

    public DateTimeFormatterBuilder append(DateTimeFormatter dateTimeFormatter) {
        if (dateTimeFormatter == null) {
            throw new IllegalArgumentException("No formatter supplied");
        }
        return this.append0(dateTimeFormatter.getPrinter(), dateTimeFormatter.getParser());
    }

    public DateTimeFormatterBuilder append(DateTimePrinter dateTimePrinter) {
        this.checkPrinter(dateTimePrinter);
        return this.append0(dateTimePrinter, null);
    }

    public DateTimeFormatterBuilder append(DateTimeParser dateTimeParser) {
        this.checkParser(dateTimeParser);
        return this.append0(null, dateTimeParser);
    }

    public DateTimeFormatterBuilder append(DateTimePrinter dateTimePrinter, DateTimeParser dateTimeParser) {
        this.checkPrinter(dateTimePrinter);
        this.checkParser(dateTimeParser);
        return this.append0(dateTimePrinter, dateTimeParser);
    }

    public DateTimeFormatterBuilder append(DateTimePrinter dateTimePrinter, DateTimeParser[] dateTimeParserArray) {
        int n;
        if (dateTimePrinter != null) {
            this.checkPrinter(dateTimePrinter);
        }
        if (dateTimeParserArray == null) {
            throw new IllegalArgumentException("No parsers supplied");
        }
        int n2 = dateTimeParserArray.length;
        if (n2 == 1) {
            if (dateTimeParserArray[0] == null) {
                throw new IllegalArgumentException("No parser supplied");
            }
            return this.append0(dateTimePrinter, dateTimeParserArray[0]);
        }
        DateTimeParser[] dateTimeParserArray2 = new DateTimeParser[n2];
        for (n = 0; n < n2 - 1; ++n) {
            dateTimeParserArray2[n] = dateTimeParserArray[n];
            if (dateTimeParserArray2[n] != null) continue;
            throw new IllegalArgumentException("Incomplete parser array");
        }
        dateTimeParserArray2[n] = dateTimeParserArray[n];
        return this.append0(dateTimePrinter, new MatchingParser(dateTimeParserArray2));
    }

    public DateTimeFormatterBuilder appendOptional(DateTimeParser dateTimeParser) {
        this.checkParser(dateTimeParser);
        DateTimeParser[] dateTimeParserArray = new DateTimeParser[]{dateTimeParser, null};
        return this.append0(null, new MatchingParser(dateTimeParserArray));
    }

    private void checkParser(DateTimeParser dateTimeParser) {
        if (dateTimeParser == null) {
            throw new IllegalArgumentException("No parser supplied");
        }
    }

    private void checkPrinter(DateTimePrinter dateTimePrinter) {
        if (dateTimePrinter == null) {
            throw new IllegalArgumentException("No printer supplied");
        }
    }

    private DateTimeFormatterBuilder append0(Object object) {
        this.iFormatter = null;
        this.iElementPairs.add(object);
        this.iElementPairs.add(object);
        return this;
    }

    private DateTimeFormatterBuilder append0(DateTimePrinter dateTimePrinter, DateTimeParser dateTimeParser) {
        this.iFormatter = null;
        this.iElementPairs.add(dateTimePrinter);
        this.iElementPairs.add(dateTimeParser);
        return this;
    }

    public DateTimeFormatterBuilder appendLiteral(char c) {
        return this.append0(new CharacterLiteral(c));
    }

    public DateTimeFormatterBuilder appendLiteral(String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("Literal must not be null");
        }
        switch (string2.length()) {
            case 0: {
                return this;
            }
            case 1: {
                return this.append0(new CharacterLiteral(string2.charAt(0)));
            }
        }
        return this.append0(new StringLiteral(string2));
    }

    public DateTimeFormatterBuilder appendDecimal(DateTimeFieldType dateTimeFieldType, int n, int n2) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (n2 < n) {
            n2 = n;
        }
        if (n < 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n <= 1) {
            return this.append0(new UnpaddedNumber(dateTimeFieldType, n2, false));
        }
        return this.append0(new PaddedNumber(dateTimeFieldType, n2, false, n));
    }

    public DateTimeFormatterBuilder appendFixedDecimal(DateTimeFieldType dateTimeFieldType, int n) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Illegal number of digits: " + n);
        }
        return this.append0(new FixedNumber(dateTimeFieldType, n, false));
    }

    public DateTimeFormatterBuilder appendSignedDecimal(DateTimeFieldType dateTimeFieldType, int n, int n2) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (n2 < n) {
            n2 = n;
        }
        if (n < 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        if (n <= 1) {
            return this.append0(new UnpaddedNumber(dateTimeFieldType, n2, true));
        }
        return this.append0(new PaddedNumber(dateTimeFieldType, n2, true, n));
    }

    public DateTimeFormatterBuilder appendFixedSignedDecimal(DateTimeFieldType dateTimeFieldType, int n) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("Illegal number of digits: " + n);
        }
        return this.append0(new FixedNumber(dateTimeFieldType, n, true));
    }

    public DateTimeFormatterBuilder appendText(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        return this.append0(new TextField(dateTimeFieldType, false));
    }

    public DateTimeFormatterBuilder appendShortText(DateTimeFieldType dateTimeFieldType) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        return this.append0(new TextField(dateTimeFieldType, true));
    }

    public DateTimeFormatterBuilder appendFraction(DateTimeFieldType dateTimeFieldType, int n, int n2) {
        if (dateTimeFieldType == null) {
            throw new IllegalArgumentException("Field type must not be null");
        }
        if (n2 < n) {
            n2 = n;
        }
        if (n < 0 || n2 <= 0) {
            throw new IllegalArgumentException();
        }
        return this.append0(new Fraction(dateTimeFieldType, n, n2));
    }

    public DateTimeFormatterBuilder appendFractionOfSecond(int n, int n2) {
        return this.appendFraction(DateTimeFieldType.secondOfDay(), n, n2);
    }

    public DateTimeFormatterBuilder appendFractionOfMinute(int n, int n2) {
        return this.appendFraction(DateTimeFieldType.minuteOfDay(), n, n2);
    }

    public DateTimeFormatterBuilder appendFractionOfHour(int n, int n2) {
        return this.appendFraction(DateTimeFieldType.hourOfDay(), n, n2);
    }

    public DateTimeFormatterBuilder appendFractionOfDay(int n, int n2) {
        return this.appendFraction(DateTimeFieldType.dayOfYear(), n, n2);
    }

    public DateTimeFormatterBuilder appendMillisOfSecond(int n) {
        return this.appendDecimal(DateTimeFieldType.millisOfSecond(), n, 3);
    }

    public DateTimeFormatterBuilder appendMillisOfDay(int n) {
        return this.appendDecimal(DateTimeFieldType.millisOfDay(), n, 8);
    }

    public DateTimeFormatterBuilder appendSecondOfMinute(int n) {
        return this.appendDecimal(DateTimeFieldType.secondOfMinute(), n, 2);
    }

    public DateTimeFormatterBuilder appendSecondOfDay(int n) {
        return this.appendDecimal(DateTimeFieldType.secondOfDay(), n, 5);
    }

    public DateTimeFormatterBuilder appendMinuteOfHour(int n) {
        return this.appendDecimal(DateTimeFieldType.minuteOfHour(), n, 2);
    }

    public DateTimeFormatterBuilder appendMinuteOfDay(int n) {
        return this.appendDecimal(DateTimeFieldType.minuteOfDay(), n, 4);
    }

    public DateTimeFormatterBuilder appendHourOfDay(int n) {
        return this.appendDecimal(DateTimeFieldType.hourOfDay(), n, 2);
    }

    public DateTimeFormatterBuilder appendClockhourOfDay(int n) {
        return this.appendDecimal(DateTimeFieldType.clockhourOfDay(), n, 2);
    }

    public DateTimeFormatterBuilder appendHourOfHalfday(int n) {
        return this.appendDecimal(DateTimeFieldType.hourOfHalfday(), n, 2);
    }

    public DateTimeFormatterBuilder appendClockhourOfHalfday(int n) {
        return this.appendDecimal(DateTimeFieldType.clockhourOfHalfday(), n, 2);
    }

    public DateTimeFormatterBuilder appendDayOfWeek(int n) {
        return this.appendDecimal(DateTimeFieldType.dayOfWeek(), n, 1);
    }

    public DateTimeFormatterBuilder appendDayOfMonth(int n) {
        return this.appendDecimal(DateTimeFieldType.dayOfMonth(), n, 2);
    }

    public DateTimeFormatterBuilder appendDayOfYear(int n) {
        return this.appendDecimal(DateTimeFieldType.dayOfYear(), n, 3);
    }

    public DateTimeFormatterBuilder appendWeekOfWeekyear(int n) {
        return this.appendDecimal(DateTimeFieldType.weekOfWeekyear(), n, 2);
    }

    public DateTimeFormatterBuilder appendWeekyear(int n, int n2) {
        return this.appendSignedDecimal(DateTimeFieldType.weekyear(), n, n2);
    }

    public DateTimeFormatterBuilder appendMonthOfYear(int n) {
        return this.appendDecimal(DateTimeFieldType.monthOfYear(), n, 2);
    }

    public DateTimeFormatterBuilder appendYear(int n, int n2) {
        return this.appendSignedDecimal(DateTimeFieldType.year(), n, n2);
    }

    public DateTimeFormatterBuilder appendTwoDigitYear(int n) {
        return this.appendTwoDigitYear(n, false);
    }

    public DateTimeFormatterBuilder appendTwoDigitYear(int n, boolean bl) {
        return this.append0(new TwoDigitYear(DateTimeFieldType.year(), n, bl));
    }

    public DateTimeFormatterBuilder appendTwoDigitWeekyear(int n) {
        return this.appendTwoDigitWeekyear(n, false);
    }

    public DateTimeFormatterBuilder appendTwoDigitWeekyear(int n, boolean bl) {
        return this.append0(new TwoDigitYear(DateTimeFieldType.weekyear(), n, bl));
    }

    public DateTimeFormatterBuilder appendYearOfEra(int n, int n2) {
        return this.appendDecimal(DateTimeFieldType.yearOfEra(), n, n2);
    }

    public DateTimeFormatterBuilder appendYearOfCentury(int n, int n2) {
        return this.appendDecimal(DateTimeFieldType.yearOfCentury(), n, n2);
    }

    public DateTimeFormatterBuilder appendCenturyOfEra(int n, int n2) {
        return this.appendSignedDecimal(DateTimeFieldType.centuryOfEra(), n, n2);
    }

    public DateTimeFormatterBuilder appendHalfdayOfDayText() {
        return this.appendText(DateTimeFieldType.halfdayOfDay());
    }

    public DateTimeFormatterBuilder appendDayOfWeekText() {
        return this.appendText(DateTimeFieldType.dayOfWeek());
    }

    public DateTimeFormatterBuilder appendDayOfWeekShortText() {
        return this.appendShortText(DateTimeFieldType.dayOfWeek());
    }

    public DateTimeFormatterBuilder appendMonthOfYearText() {
        return this.appendText(DateTimeFieldType.monthOfYear());
    }

    public DateTimeFormatterBuilder appendMonthOfYearShortText() {
        return this.appendShortText(DateTimeFieldType.monthOfYear());
    }

    public DateTimeFormatterBuilder appendEraText() {
        return this.appendText(DateTimeFieldType.era());
    }

    public DateTimeFormatterBuilder appendTimeZoneName() {
        return this.append0(new TimeZoneName(0), null);
    }

    public DateTimeFormatterBuilder appendTimeZoneShortName() {
        return this.append0(new TimeZoneName(1), null);
    }

    public DateTimeFormatterBuilder appendTimeZoneId() {
        return this.append0(new TimeZoneName(2), null);
    }

    public DateTimeFormatterBuilder appendTimeZoneOffset(String string2, boolean bl, int n, int n2) {
        return this.append0(new TimeZoneOffset(string2, bl, n, n2));
    }

    public DateTimeFormatterBuilder appendPattern(String string2) {
        DateTimeFormat.appendPatternTo(this, string2);
        return this;
    }

    private Object getFormatter() {
        Object object = this.iFormatter;
        if (object == null) {
            if (this.iElementPairs.size() == 2) {
                Object e2 = this.iElementPairs.get(0);
                Object e3 = this.iElementPairs.get(1);
                if (e2 != null) {
                    if (e2 == e3 || e3 == null) {
                        object = e2;
                    }
                } else {
                    object = e3;
                }
            }
            if (object == null) {
                object = new Composite(this.iElementPairs);
            }
            this.iFormatter = object;
        }
        return object;
    }

    private boolean isPrinter(Object object) {
        if (object instanceof DateTimePrinter) {
            if (object instanceof Composite) {
                return ((Composite)object).isPrinter();
            }
            return true;
        }
        return false;
    }

    private boolean isParser(Object object) {
        if (object instanceof DateTimeParser) {
            if (object instanceof Composite) {
                return ((Composite)object).isParser();
            }
            return true;
        }
        return false;
    }

    private boolean isFormatter(Object object) {
        return this.isPrinter(object) || this.isParser(object);
    }

    static void appendUnknownString(StringBuffer stringBuffer, int n) {
        int n2 = n;
        while (--n2 >= 0) {
            stringBuffer.append('\ufffd');
        }
    }

    static void printUnknownString(Writer writer2, int n) throws IOException {
        int n2 = n;
        while (--n2 >= 0) {
            writer2.write(65533);
        }
    }

    static class MatchingParser
    implements DateTimeParser {
        private final DateTimeParser[] iParsers;
        private final int iParsedLengthEstimate;

        MatchingParser(DateTimeParser[] dateTimeParserArray) {
            this.iParsers = dateTimeParserArray;
            int n = 0;
            int n2 = dateTimeParserArray.length;
            while (--n2 >= 0) {
                int n3;
                DateTimeParser dateTimeParser = dateTimeParserArray[n2];
                if (dateTimeParser == null || (n3 = dateTimeParser.estimateParsedLength()) <= n) continue;
                n = n3;
            }
            this.iParsedLengthEstimate = n;
        }

        public int estimateParsedLength() {
            return this.iParsedLengthEstimate;
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n) {
            DateTimeParser[] dateTimeParserArray = this.iParsers;
            int n2 = dateTimeParserArray.length;
            Object object = dateTimeParserBucket.saveState();
            boolean bl = false;
            int n3 = n;
            Object object2 = null;
            int n4 = n;
            for (int i = 0; i < n2; ++i) {
                DateTimeParser dateTimeParser = dateTimeParserArray[i];
                if (dateTimeParser == null) {
                    if (n3 <= n) {
                        return n;
                    }
                    bl = true;
                    break;
                }
                int n5 = dateTimeParser.parseInto(dateTimeParserBucket, string2, n);
                if (n5 >= n) {
                    if (n5 > n3) {
                        if (n5 >= string2.length() || i + 1 >= n2 || dateTimeParserArray[i + 1] == null) {
                            return n5;
                        }
                        n3 = n5;
                        object2 = dateTimeParserBucket.saveState();
                    }
                } else if (n5 < 0 && (n5 ^= 0xFFFFFFFF) > n4) {
                    n4 = n5;
                }
                dateTimeParserBucket.restoreState(object);
            }
            if (n3 > n || n3 == n && bl) {
                if (object2 != null) {
                    dateTimeParserBucket.restoreState(object2);
                }
                return n3;
            }
            return ~n4;
        }
    }

    static class Composite
    implements DateTimePrinter,
    DateTimeParser {
        private final DateTimePrinter[] iPrinters;
        private final DateTimeParser[] iParsers;
        private final int iPrintedLengthEstimate;
        private final int iParsedLengthEstimate;

        Composite(List list) {
            Object object;
            int n;
            int n2;
            int n3;
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            this.decompose(list, arrayList, arrayList2);
            if (arrayList.size() <= 0) {
                this.iPrinters = null;
                this.iPrintedLengthEstimate = 0;
            } else {
                n3 = arrayList.size();
                this.iPrinters = new DateTimePrinter[n3];
                n2 = 0;
                for (n = 0; n < n3; ++n) {
                    object = (DateTimePrinter)arrayList.get(n);
                    n2 += object.estimatePrintedLength();
                    this.iPrinters[n] = object;
                }
                this.iPrintedLengthEstimate = n2;
            }
            if (arrayList2.size() <= 0) {
                this.iParsers = null;
                this.iParsedLengthEstimate = 0;
            } else {
                n3 = arrayList2.size();
                this.iParsers = new DateTimeParser[n3];
                n2 = 0;
                for (n = 0; n < n3; ++n) {
                    object = (DateTimeParser)arrayList2.get(n);
                    n2 += object.estimateParsedLength();
                    this.iParsers[n] = object;
                }
                this.iParsedLengthEstimate = n2;
            }
        }

        public int estimatePrintedLength() {
            return this.iPrintedLengthEstimate;
        }

        public void printTo(StringBuffer stringBuffer, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) {
            DateTimePrinter[] dateTimePrinterArray = this.iPrinters;
            if (dateTimePrinterArray == null) {
                throw new UnsupportedOperationException();
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            int n2 = dateTimePrinterArray.length;
            for (int i = 0; i < n2; ++i) {
                dateTimePrinterArray[i].printTo(stringBuffer, l, chronology, n, dateTimeZone, locale);
            }
        }

        public void printTo(Writer writer2, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            DateTimePrinter[] dateTimePrinterArray = this.iPrinters;
            if (dateTimePrinterArray == null) {
                throw new UnsupportedOperationException();
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            int n2 = dateTimePrinterArray.length;
            for (int i = 0; i < n2; ++i) {
                dateTimePrinterArray[i].printTo(writer2, l, chronology, n, dateTimeZone, locale);
            }
        }

        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
            DateTimePrinter[] dateTimePrinterArray = this.iPrinters;
            if (dateTimePrinterArray == null) {
                throw new UnsupportedOperationException();
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            int n = dateTimePrinterArray.length;
            for (int i = 0; i < n; ++i) {
                dateTimePrinterArray[i].printTo(stringBuffer, readablePartial, locale);
            }
        }

        public void printTo(Writer writer2, ReadablePartial readablePartial, Locale locale) throws IOException {
            DateTimePrinter[] dateTimePrinterArray = this.iPrinters;
            if (dateTimePrinterArray == null) {
                throw new UnsupportedOperationException();
            }
            if (locale == null) {
                locale = Locale.getDefault();
            }
            int n = dateTimePrinterArray.length;
            for (int i = 0; i < n; ++i) {
                dateTimePrinterArray[i].printTo(writer2, readablePartial, locale);
            }
        }

        public int estimateParsedLength() {
            return this.iParsedLengthEstimate;
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n) {
            DateTimeParser[] dateTimeParserArray = this.iParsers;
            if (dateTimeParserArray == null) {
                throw new UnsupportedOperationException();
            }
            int n2 = dateTimeParserArray.length;
            for (int i = 0; i < n2 && n >= 0; ++i) {
                n = dateTimeParserArray[i].parseInto(dateTimeParserBucket, string2, n);
            }
            return n;
        }

        boolean isPrinter() {
            return this.iPrinters != null;
        }

        boolean isParser() {
            return this.iParsers != null;
        }

        private void decompose(List list, List list2, List list3) {
            int n = list.size();
            for (int i = 0; i < n; i += 2) {
                Object e2 = list.get(i);
                if (e2 instanceof DateTimePrinter) {
                    if (e2 instanceof Composite) {
                        this.addArrayToList(list2, ((Composite)e2).iPrinters);
                    } else {
                        list2.add(e2);
                    }
                }
                if (!((e2 = list.get(i + 1)) instanceof DateTimeParser)) continue;
                if (e2 instanceof Composite) {
                    this.addArrayToList(list3, ((Composite)e2).iParsers);
                    continue;
                }
                list3.add(e2);
            }
        }

        private void addArrayToList(List list, Object[] objectArray) {
            if (objectArray != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    list.add(objectArray[i]);
                }
            }
        }
    }

    static class TimeZoneName
    implements DateTimePrinter {
        static final int LONG_NAME = 0;
        static final int SHORT_NAME = 1;
        static final int ID = 2;
        private final int iType;

        TimeZoneName(int n) {
            this.iType = n;
        }

        public int estimatePrintedLength() {
            return this.iType == 1 ? 4 : 20;
        }

        public void printTo(StringBuffer stringBuffer, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) {
            stringBuffer.append(this.print(l - (long)n, dateTimeZone, locale));
        }

        public void printTo(Writer writer2, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            writer2.write(this.print(l - (long)n, dateTimeZone, locale));
        }

        private String print(long l, DateTimeZone dateTimeZone, Locale locale) {
            if (dateTimeZone == null) {
                return "";
            }
            switch (this.iType) {
                case 0: {
                    return dateTimeZone.getName(l, locale);
                }
                case 1: {
                    return dateTimeZone.getShortName(l, locale);
                }
                case 2: {
                    return dateTimeZone.getID();
                }
            }
            return "";
        }

        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
        }

        public void printTo(Writer writer2, ReadablePartial readablePartial, Locale locale) throws IOException {
        }
    }

    static class TimeZoneOffset
    implements DateTimePrinter,
    DateTimeParser {
        private final String iZeroOffsetText;
        private final boolean iShowSeparators;
        private final int iMinFields;
        private final int iMaxFields;

        TimeZoneOffset(String string2, boolean bl, int n, int n2) {
            this.iZeroOffsetText = string2;
            this.iShowSeparators = bl;
            if (n <= 0 || n2 < n) {
                throw new IllegalArgumentException();
            }
            if (n > 4) {
                n = 4;
                n2 = 4;
            }
            this.iMinFields = n;
            this.iMaxFields = n2;
        }

        public int estimatePrintedLength() {
            int n = 1 + this.iMinFields << 1;
            if (this.iShowSeparators) {
                n += this.iMinFields - 1;
            }
            if (this.iZeroOffsetText != null && this.iZeroOffsetText.length() > n) {
                n = this.iZeroOffsetText.length();
            }
            return n;
        }

        public void printTo(StringBuffer stringBuffer, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) {
            if (dateTimeZone == null) {
                return;
            }
            if (n == 0 && this.iZeroOffsetText != null) {
                stringBuffer.append(this.iZeroOffsetText);
                return;
            }
            if (n >= 0) {
                stringBuffer.append('+');
            } else {
                stringBuffer.append('-');
                n = -n;
            }
            int n2 = n / 3600000;
            FormatUtils.appendPaddedInteger(stringBuffer, n2, 2);
            if (this.iMaxFields == 1) {
                return;
            }
            if ((n -= n2 * 3600000) == 0 && this.iMinFields <= 1) {
                return;
            }
            int n3 = n / 60000;
            if (this.iShowSeparators) {
                stringBuffer.append(':');
            }
            FormatUtils.appendPaddedInteger(stringBuffer, n3, 2);
            if (this.iMaxFields == 2) {
                return;
            }
            if ((n -= n3 * 60000) == 0 && this.iMinFields <= 2) {
                return;
            }
            int n4 = n / 1000;
            if (this.iShowSeparators) {
                stringBuffer.append(':');
            }
            FormatUtils.appendPaddedInteger(stringBuffer, n4, 2);
            if (this.iMaxFields == 3) {
                return;
            }
            if ((n -= n4 * 1000) == 0 && this.iMinFields <= 3) {
                return;
            }
            if (this.iShowSeparators) {
                stringBuffer.append('.');
            }
            FormatUtils.appendPaddedInteger(stringBuffer, n, 3);
        }

        public void printTo(Writer writer2, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            if (dateTimeZone == null) {
                return;
            }
            if (n == 0 && this.iZeroOffsetText != null) {
                writer2.write(this.iZeroOffsetText);
                return;
            }
            if (n >= 0) {
                writer2.write(43);
            } else {
                writer2.write(45);
                n = -n;
            }
            int n2 = n / 3600000;
            FormatUtils.writePaddedInteger(writer2, n2, 2);
            if (this.iMaxFields == 1) {
                return;
            }
            if ((n -= n2 * 3600000) == 0 && this.iMinFields == 1) {
                return;
            }
            int n3 = n / 60000;
            if (this.iShowSeparators) {
                writer2.write(58);
            }
            FormatUtils.writePaddedInteger(writer2, n3, 2);
            if (this.iMaxFields == 2) {
                return;
            }
            if ((n -= n3 * 60000) == 0 && this.iMinFields == 2) {
                return;
            }
            int n4 = n / 1000;
            if (this.iShowSeparators) {
                writer2.write(58);
            }
            FormatUtils.writePaddedInteger(writer2, n4, 2);
            if (this.iMaxFields == 3) {
                return;
            }
            if ((n -= n4 * 1000) == 0 && this.iMinFields == 3) {
                return;
            }
            if (this.iShowSeparators) {
                writer2.write(46);
            }
            FormatUtils.writePaddedInteger(writer2, n, 3);
        }

        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
        }

        public void printTo(Writer writer2, ReadablePartial readablePartial, Locale locale) throws IOException {
        }

        public int estimateParsedLength() {
            return this.estimatePrintedLength();
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n) {
            int n2;
            char c;
            block24: {
                int n3;
                boolean bl;
                block28: {
                    int n4;
                    block27: {
                        block26: {
                            char c2;
                            block25: {
                                n4 = string2.length() - n;
                                if (this.iZeroOffsetText != null) {
                                    if (this.iZeroOffsetText.length() == 0) {
                                        if (n4 <= 0 || (c = string2.charAt(n)) != '-' && c != '+') {
                                            dateTimeParserBucket.setOffset(0);
                                            return n;
                                        }
                                    } else if (string2.regionMatches(true, n, this.iZeroOffsetText, 0, this.iZeroOffsetText.length())) {
                                        dateTimeParserBucket.setOffset(0);
                                        return n + this.iZeroOffsetText.length();
                                    }
                                }
                                if (n4 <= 1) {
                                    return ~n;
                                }
                                c2 = string2.charAt(n);
                                if (c2 == '-') {
                                    c = '\u0001';
                                } else if (c2 == '+') {
                                    c = '\u0000';
                                } else {
                                    return ~n;
                                }
                                --n4;
                                if (this.digitCount(string2, ++n, 2) < 2) {
                                    return ~n;
                                }
                                int n5 = FormatUtils.parseTwoDigits(string2, n);
                                if (n5 > 23) {
                                    return ~n;
                                }
                                n2 = n5 * 3600000;
                                n += 2;
                                if ((n4 -= 2) <= 0) break block24;
                                c2 = string2.charAt(n);
                                if (c2 != ':') break block25;
                                bl = true;
                                --n4;
                                ++n;
                                break block26;
                            }
                            if (c2 < '0' || c2 > '9') break block24;
                            bl = false;
                        }
                        n3 = this.digitCount(string2, n, 2);
                        if (n3 == 0 && !bl) break block24;
                        if (n3 < 2) {
                            return ~n;
                        }
                        int n6 = FormatUtils.parseTwoDigits(string2, n);
                        if (n6 > 59) {
                            return ~n;
                        }
                        n2 += n6 * 60000;
                        n += 2;
                        if ((n4 -= 2) <= 0) break block24;
                        if (!bl) break block27;
                        if (string2.charAt(n) != ':') break block24;
                        --n4;
                        ++n;
                    }
                    if ((n3 = this.digitCount(string2, n, 2)) == 0 && !bl) break block24;
                    if (n3 < 2) {
                        return ~n;
                    }
                    int n7 = FormatUtils.parseTwoDigits(string2, n);
                    if (n7 > 59) {
                        return ~n;
                    }
                    n2 += n7 * 1000;
                    n += 2;
                    if ((n4 -= 2) <= 0) break block24;
                    if (!bl) break block28;
                    if (string2.charAt(n) != '.' && string2.charAt(n) != ',') break block24;
                    --n4;
                    ++n;
                }
                if ((n3 = this.digitCount(string2, n, 3)) != 0 || bl) {
                    if (n3 < 1) {
                        return ~n;
                    }
                    n2 += (string2.charAt(n++) - 48) * 100;
                    if (n3 > 1) {
                        n2 += (string2.charAt(n++) - 48) * 10;
                        if (n3 > 2) {
                            n2 += string2.charAt(n++) - 48;
                        }
                    }
                }
            }
            dateTimeParserBucket.setOffset(c != '\u0000' ? -n2 : n2);
            return n;
        }

        private int digitCount(String string2, int n, int n2) {
            char c;
            int n3 = Math.min(string2.length() - n, n2);
            n2 = 0;
            while (n3 > 0 && (c = string2.charAt(n + n2)) >= '0' && c <= '9') {
                ++n2;
                --n3;
            }
            return n2;
        }
    }

    static class Fraction
    implements DateTimePrinter,
    DateTimeParser {
        private final DateTimeFieldType iFieldType;
        protected int iMinDigits;
        protected int iMaxDigits;

        protected Fraction(DateTimeFieldType dateTimeFieldType, int n, int n2) {
            this.iFieldType = dateTimeFieldType;
            if (n2 > 18) {
                n2 = 18;
            }
            this.iMinDigits = n;
            this.iMaxDigits = n2;
        }

        public int estimatePrintedLength() {
            return this.iMaxDigits;
        }

        public void printTo(StringBuffer stringBuffer, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) {
            try {
                this.printTo(stringBuffer, null, l, chronology);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void printTo(Writer writer2, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            this.printTo(null, writer2, l, chronology);
        }

        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
            long l = readablePartial.getChronology().set(readablePartial, 0L);
            try {
                this.printTo(stringBuffer, null, l, readablePartial.getChronology());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void printTo(Writer writer2, ReadablePartial readablePartial, Locale locale) throws IOException {
            long l = readablePartial.getChronology().set(readablePartial, 0L);
            this.printTo(null, writer2, l, readablePartial.getChronology());
        }

        protected void printTo(StringBuffer stringBuffer, Writer writer2, long l, Chronology chronology) throws IOException {
            int n;
            long l2;
            DateTimeField dateTimeField = this.iFieldType.getField(chronology);
            int n2 = this.iMinDigits;
            try {
                l2 = dateTimeField.remainder(l);
            }
            catch (RuntimeException runtimeException) {
                if (stringBuffer != null) {
                    DateTimeFormatterBuilder.appendUnknownString(stringBuffer, n2);
                } else {
                    DateTimeFormatterBuilder.printUnknownString(writer2, n2);
                }
                return;
            }
            if (l2 == 0L) {
                if (stringBuffer != null) {
                    while (--n2 >= 0) {
                        stringBuffer.append('0');
                    }
                } else {
                    while (--n2 >= 0) {
                        writer2.write(48);
                    }
                }
                return;
            }
            long[] lArray = this.getFractionData(l2, dateTimeField);
            long l3 = lArray[0];
            int n3 = (int)lArray[1];
            String string2 = (l3 & Integer.MAX_VALUE) == l3 ? Integer.toString((int)l3) : Long.toString(l3);
            int n4 = string2.length();
            for (n = n3; n4 < n; --n) {
                if (stringBuffer != null) {
                    stringBuffer.append('0');
                } else {
                    writer2.write(48);
                }
                --n2;
            }
            if (n2 < n) {
                while (n2 < n && n4 > 1 && string2.charAt(n4 - 1) == '0') {
                    --n;
                    --n4;
                }
                if (n4 < string2.length()) {
                    if (stringBuffer != null) {
                        for (int i = 0; i < n4; ++i) {
                            stringBuffer.append(string2.charAt(i));
                        }
                    } else {
                        for (int i = 0; i < n4; ++i) {
                            writer2.write(string2.charAt(i));
                        }
                    }
                    return;
                }
            }
            if (stringBuffer != null) {
                stringBuffer.append(string2);
            } else {
                writer2.write(string2);
            }
        }

        private long[] getFractionData(long l, DateTimeField dateTimeField) {
            long l2;
            long l3 = dateTimeField.getDurationField().getUnitMillis();
            int n = this.iMaxDigits;
            while (true) {
                switch (n) {
                    default: {
                        l2 = 1L;
                        break;
                    }
                    case 1: {
                        l2 = 10L;
                        break;
                    }
                    case 2: {
                        l2 = 100L;
                        break;
                    }
                    case 3: {
                        l2 = 1000L;
                        break;
                    }
                    case 4: {
                        l2 = 10000L;
                        break;
                    }
                    case 5: {
                        l2 = 100000L;
                        break;
                    }
                    case 6: {
                        l2 = 1000000L;
                        break;
                    }
                    case 7: {
                        l2 = 10000000L;
                        break;
                    }
                    case 8: {
                        l2 = 100000000L;
                        break;
                    }
                    case 9: {
                        l2 = 1000000000L;
                        break;
                    }
                    case 10: {
                        l2 = 10000000000L;
                        break;
                    }
                    case 11: {
                        l2 = 100000000000L;
                        break;
                    }
                    case 12: {
                        l2 = 1000000000000L;
                        break;
                    }
                    case 13: {
                        l2 = 10000000000000L;
                        break;
                    }
                    case 14: {
                        l2 = 100000000000000L;
                        break;
                    }
                    case 15: {
                        l2 = 1000000000000000L;
                        break;
                    }
                    case 16: {
                        l2 = 10000000000000000L;
                        break;
                    }
                    case 17: {
                        l2 = 100000000000000000L;
                        break;
                    }
                    case 18: {
                        l2 = 1000000000000000000L;
                    }
                }
                if (l3 * l2 / l2 == l3) break;
                --n;
            }
            return new long[]{l * l2 / l3, n};
        }

        public int estimateParsedLength() {
            return this.iMaxDigits;
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n) {
            char c;
            DateTimeField dateTimeField = this.iFieldType.getField(dateTimeParserBucket.getChronology());
            int n2 = Math.min(this.iMaxDigits, string2.length() - n);
            long l = 0L;
            long l2 = dateTimeField.getDurationField().getUnitMillis() * 10L;
            int n3 = 0;
            while (n3 < n2 && (c = string2.charAt(n + n3)) >= '0' && c <= '9') {
                ++n3;
                long l3 = l2 / 10L;
                l += (long)(c - 48) * l3;
                l2 = l3;
            }
            l /= 10L;
            if (n3 == 0) {
                return ~n;
            }
            if (l > Integer.MAX_VALUE) {
                return ~n;
            }
            PreciseDateTimeField preciseDateTimeField = new PreciseDateTimeField(DateTimeFieldType.millisOfSecond(), MillisDurationField.INSTANCE, dateTimeField.getDurationField());
            dateTimeParserBucket.saveField(preciseDateTimeField, (int)l);
            return n + n3;
        }
    }

    static class TextField
    implements DateTimePrinter,
    DateTimeParser {
        private static Map cParseCache = new HashMap();
        private final DateTimeFieldType iFieldType;
        private final boolean iShort;

        TextField(DateTimeFieldType dateTimeFieldType, boolean bl) {
            this.iFieldType = dateTimeFieldType;
            this.iShort = bl;
        }

        public int estimatePrintedLength() {
            return this.iShort ? 6 : 20;
        }

        public void printTo(StringBuffer stringBuffer, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) {
            try {
                stringBuffer.append(this.print(l, chronology, locale));
            }
            catch (RuntimeException runtimeException) {
                stringBuffer.append('\ufffd');
            }
        }

        public void printTo(Writer writer2, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            try {
                writer2.write(this.print(l, chronology, locale));
            }
            catch (RuntimeException runtimeException) {
                writer2.write(65533);
            }
        }

        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
            try {
                stringBuffer.append(this.print(readablePartial, locale));
            }
            catch (RuntimeException runtimeException) {
                stringBuffer.append('\ufffd');
            }
        }

        public void printTo(Writer writer2, ReadablePartial readablePartial, Locale locale) throws IOException {
            try {
                writer2.write(this.print(readablePartial, locale));
            }
            catch (RuntimeException runtimeException) {
                writer2.write(65533);
            }
        }

        private String print(long l, Chronology chronology, Locale locale) {
            DateTimeField dateTimeField = this.iFieldType.getField(chronology);
            if (this.iShort) {
                return dateTimeField.getAsShortText(l, locale);
            }
            return dateTimeField.getAsText(l, locale);
        }

        private String print(ReadablePartial readablePartial, Locale locale) {
            if (readablePartial.isSupported(this.iFieldType)) {
                DateTimeField dateTimeField = this.iFieldType.getField(readablePartial.getChronology());
                if (this.iShort) {
                    return dateTimeField.getAsShortText(readablePartial, locale);
                }
                return dateTimeField.getAsText(readablePartial, locale);
            }
            return "\ufffd";
        }

        public int estimateParsedLength() {
            return this.estimatePrintedLength();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n) {
            int n2;
            Object object;
            Locale locale = dateTimeParserBucket.getLocale();
            Set<String> set2 = null;
            int n3 = 0;
            Map map2 = cParseCache;
            synchronized (map2) {
                HashMap<DateTimeFieldType, Object[]> hashMap = (HashMap<DateTimeFieldType, Object[]>)cParseCache.get(locale);
                if (hashMap == null) {
                    hashMap = new HashMap<DateTimeFieldType, Object[]>();
                    cParseCache.put(locale, hashMap);
                }
                if ((object = (Object[])hashMap.get(this.iFieldType)) == null) {
                    set2 = new HashSet(32);
                    MutableDateTime mutableDateTime = new MutableDateTime(0L, DateTimeZone.UTC);
                    MutableDateTime.Property property = mutableDateTime.property(this.iFieldType);
                    int n4 = property.getMinimumValueOverall();
                    int n5 = property.getMaximumValueOverall();
                    if (n5 - n4 > 32) {
                        return ~n;
                    }
                    n3 = property.getMaximumTextLength(locale);
                    for (int i = n4; i <= n5; ++i) {
                        property.set(i);
                        set2.add(property.getAsShortText(locale));
                        set2.add(property.getAsShortText(locale).toLowerCase(locale));
                        set2.add(property.getAsShortText(locale).toUpperCase(locale));
                        set2.add(property.getAsText(locale));
                        set2.add(property.getAsText(locale).toLowerCase(locale));
                        set2.add(property.getAsText(locale).toUpperCase(locale));
                    }
                    if ("en".equals(locale.getLanguage()) && this.iFieldType == DateTimeFieldType.era()) {
                        set2.add("BCE");
                        set2.add("bce");
                        set2.add("CE");
                        set2.add("ce");
                        n3 = 3;
                    }
                    object = new Object[]{set2, new Integer(n3)};
                    hashMap.put(this.iFieldType, (Object[])object);
                } else {
                    set2 = (Set)object[0];
                    n3 = (Integer)object[1];
                }
            }
            for (int i = n2 = Math.min(string2.length(), n + n3); i > n; --i) {
                object = string2.substring(n, i);
                if (!set2.contains(object)) continue;
                dateTimeParserBucket.saveField(this.iFieldType, (String)object, locale);
                return i;
            }
            return ~n;
        }
    }

    static class TwoDigitYear
    implements DateTimePrinter,
    DateTimeParser {
        private final DateTimeFieldType iType;
        private final int iPivot;
        private final boolean iLenientParse;

        TwoDigitYear(DateTimeFieldType dateTimeFieldType, int n, boolean bl) {
            this.iType = dateTimeFieldType;
            this.iPivot = n;
            this.iLenientParse = bl;
        }

        public int estimateParsedLength() {
            return this.iLenientParse ? 4 : 2;
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n) {
            int n2;
            int n3;
            char c;
            int n4;
            int n5 = string2.length() - n;
            if (!this.iLenientParse) {
                if ((n5 = Math.min(2, n5)) < 2) {
                    return ~n;
                }
            } else {
                n4 = 0;
                c = '\u0000';
                n3 = 0;
                while (n3 < n5) {
                    n2 = string2.charAt(n + n3);
                    if (n3 == 0 && (n2 == 45 || n2 == 43)) {
                        n4 = 1;
                        char c2 = c = n2 == 45 ? (char)'\u0001' : '\u0000';
                        if (c != '\u0000') {
                            ++n3;
                            continue;
                        }
                        ++n;
                        --n5;
                        continue;
                    }
                    if (n2 < 48 || n2 > 57) break;
                    ++n3;
                }
                if (n3 == 0) {
                    return ~n;
                }
                if (n4 != 0 || n3 != 2) {
                    if (n3 >= 9) {
                        n2 = Integer.parseInt(string2.substring(n, n += n3));
                    } else {
                        int n6 = n;
                        if (c != '\u0000') {
                            ++n6;
                        }
                        try {
                            n2 = string2.charAt(n6++) - 48;
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                            return ~n;
                        }
                        n += n3;
                        while (n6 < n) {
                            n2 = (n2 << 3) + (n2 << 1) + string2.charAt(n6++) - 48;
                        }
                        if (c != '\u0000') {
                            n2 = -n2;
                        }
                    }
                    dateTimeParserBucket.saveField(this.iType, n2);
                    return n;
                }
            }
            if ((c = string2.charAt(n)) < '0' || c > '9') {
                return ~n;
            }
            n4 = c - 48;
            c = string2.charAt(n + 1);
            if (c < '0' || c > '9') {
                return ~n;
            }
            n4 = (n4 << 3) + (n4 << 1) + c - 48;
            n3 = this.iPivot;
            if (dateTimeParserBucket.getPivotYear() != null) {
                n3 = dateTimeParserBucket.getPivotYear();
            }
            int n7 = (n2 = n3 - 50) >= 0 ? n2 % 100 : 99 + (n2 + 1) % 100;
            dateTimeParserBucket.saveField(this.iType, n4 += n2 + (n4 < n7 ? 100 : 0) - n7);
            return n + 2;
        }

        public int estimatePrintedLength() {
            return 2;
        }

        public void printTo(StringBuffer stringBuffer, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) {
            int n2 = this.getTwoDigitYear(l, chronology);
            if (n2 < 0) {
                stringBuffer.append('\ufffd');
                stringBuffer.append('\ufffd');
            } else {
                FormatUtils.appendPaddedInteger(stringBuffer, n2, 2);
            }
        }

        public void printTo(Writer writer2, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            int n2 = this.getTwoDigitYear(l, chronology);
            if (n2 < 0) {
                writer2.write(65533);
                writer2.write(65533);
            } else {
                FormatUtils.writePaddedInteger(writer2, n2, 2);
            }
        }

        private int getTwoDigitYear(long l, Chronology chronology) {
            try {
                int n = this.iType.getField(chronology).get(l);
                if (n < 0) {
                    n = -n;
                }
                return n % 100;
            }
            catch (RuntimeException runtimeException) {
                return -1;
            }
        }

        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
            int n = this.getTwoDigitYear(readablePartial);
            if (n < 0) {
                stringBuffer.append('\ufffd');
                stringBuffer.append('\ufffd');
            } else {
                FormatUtils.appendPaddedInteger(stringBuffer, n, 2);
            }
        }

        public void printTo(Writer writer2, ReadablePartial readablePartial, Locale locale) throws IOException {
            int n = this.getTwoDigitYear(readablePartial);
            if (n < 0) {
                writer2.write(65533);
                writer2.write(65533);
            } else {
                FormatUtils.writePaddedInteger(writer2, n, 2);
            }
        }

        private int getTwoDigitYear(ReadablePartial readablePartial) {
            if (readablePartial.isSupported(this.iType)) {
                try {
                    int n = readablePartial.get(this.iType);
                    if (n < 0) {
                        n = -n;
                    }
                    return n % 100;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return -1;
        }
    }

    static class FixedNumber
    extends PaddedNumber {
        protected FixedNumber(DateTimeFieldType dateTimeFieldType, int n, boolean bl) {
            super(dateTimeFieldType, n, bl, n);
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n) {
            int n2 = super.parseInto(dateTimeParserBucket, string2, n);
            if (n2 < 0) {
                return n2;
            }
            int n3 = n + this.iMaxParsedDigits;
            if (n2 != n3) {
                char c;
                if (this.iSigned && ((c = string2.charAt(n)) == '-' || c == '+')) {
                    ++n3;
                }
                if (n2 > n3) {
                    return ~(n3 + 1);
                }
                if (n2 < n3) {
                    return ~n2;
                }
            }
            return n2;
        }
    }

    static class PaddedNumber
    extends NumberFormatter {
        protected final int iMinPrintedDigits;

        protected PaddedNumber(DateTimeFieldType dateTimeFieldType, int n, boolean bl, int n2) {
            super(dateTimeFieldType, n, bl);
            this.iMinPrintedDigits = n2;
        }

        public int estimatePrintedLength() {
            return this.iMaxParsedDigits;
        }

        public void printTo(StringBuffer stringBuffer, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) {
            try {
                DateTimeField dateTimeField = this.iFieldType.getField(chronology);
                FormatUtils.appendPaddedInteger(stringBuffer, dateTimeField.get(l), this.iMinPrintedDigits);
            }
            catch (RuntimeException runtimeException) {
                DateTimeFormatterBuilder.appendUnknownString(stringBuffer, this.iMinPrintedDigits);
            }
        }

        public void printTo(Writer writer2, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            try {
                DateTimeField dateTimeField = this.iFieldType.getField(chronology);
                FormatUtils.writePaddedInteger(writer2, dateTimeField.get(l), this.iMinPrintedDigits);
            }
            catch (RuntimeException runtimeException) {
                DateTimeFormatterBuilder.printUnknownString(writer2, this.iMinPrintedDigits);
            }
        }

        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
            if (readablePartial.isSupported(this.iFieldType)) {
                try {
                    FormatUtils.appendPaddedInteger(stringBuffer, readablePartial.get(this.iFieldType), this.iMinPrintedDigits);
                }
                catch (RuntimeException runtimeException) {
                    DateTimeFormatterBuilder.appendUnknownString(stringBuffer, this.iMinPrintedDigits);
                }
            } else {
                DateTimeFormatterBuilder.appendUnknownString(stringBuffer, this.iMinPrintedDigits);
            }
        }

        public void printTo(Writer writer2, ReadablePartial readablePartial, Locale locale) throws IOException {
            if (readablePartial.isSupported(this.iFieldType)) {
                try {
                    FormatUtils.writePaddedInteger(writer2, readablePartial.get(this.iFieldType), this.iMinPrintedDigits);
                }
                catch (RuntimeException runtimeException) {
                    DateTimeFormatterBuilder.printUnknownString(writer2, this.iMinPrintedDigits);
                }
            } else {
                DateTimeFormatterBuilder.printUnknownString(writer2, this.iMinPrintedDigits);
            }
        }
    }

    static class UnpaddedNumber
    extends NumberFormatter {
        protected UnpaddedNumber(DateTimeFieldType dateTimeFieldType, int n, boolean bl) {
            super(dateTimeFieldType, n, bl);
        }

        public int estimatePrintedLength() {
            return this.iMaxParsedDigits;
        }

        public void printTo(StringBuffer stringBuffer, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) {
            try {
                DateTimeField dateTimeField = this.iFieldType.getField(chronology);
                FormatUtils.appendUnpaddedInteger(stringBuffer, dateTimeField.get(l));
            }
            catch (RuntimeException runtimeException) {
                stringBuffer.append('\ufffd');
            }
        }

        public void printTo(Writer writer2, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            try {
                DateTimeField dateTimeField = this.iFieldType.getField(chronology);
                FormatUtils.writeUnpaddedInteger(writer2, dateTimeField.get(l));
            }
            catch (RuntimeException runtimeException) {
                writer2.write(65533);
            }
        }

        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
            if (readablePartial.isSupported(this.iFieldType)) {
                try {
                    FormatUtils.appendUnpaddedInteger(stringBuffer, readablePartial.get(this.iFieldType));
                }
                catch (RuntimeException runtimeException) {
                    stringBuffer.append('\ufffd');
                }
            } else {
                stringBuffer.append('\ufffd');
            }
        }

        public void printTo(Writer writer2, ReadablePartial readablePartial, Locale locale) throws IOException {
            if (readablePartial.isSupported(this.iFieldType)) {
                try {
                    FormatUtils.writeUnpaddedInteger(writer2, readablePartial.get(this.iFieldType));
                }
                catch (RuntimeException runtimeException) {
                    writer2.write(65533);
                }
            } else {
                writer2.write(65533);
            }
        }
    }

    static abstract class NumberFormatter
    implements DateTimePrinter,
    DateTimeParser {
        protected final DateTimeFieldType iFieldType;
        protected final int iMaxParsedDigits;
        protected final boolean iSigned;

        NumberFormatter(DateTimeFieldType dateTimeFieldType, int n, boolean bl) {
            this.iFieldType = dateTimeFieldType;
            this.iMaxParsedDigits = n;
            this.iSigned = bl;
        }

        public int estimateParsedLength() {
            return this.iMaxParsedDigits;
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n) {
            int n2;
            int n3 = Math.min(this.iMaxParsedDigits, string2.length() - n);
            boolean bl = false;
            int n4 = 0;
            while (n4 < n3) {
                n2 = string2.charAt(n + n4);
                if (n4 == 0 && (n2 == 45 || n2 == 43) && this.iSigned) {
                    boolean bl2 = bl = n2 == 45;
                    if (n4 + 1 >= n3) break;
                    char c = string2.charAt(n + n4 + 1);
                    n2 = c;
                    if (c < '0' || n2 > 57) break;
                    if (bl) {
                        ++n4;
                    } else {
                        ++n;
                    }
                    n3 = Math.min(n3 + 1, string2.length() - n);
                    continue;
                }
                if (n2 < 48 || n2 > 57) break;
                ++n4;
            }
            if (n4 == 0) {
                return ~n;
            }
            if (n4 >= 9) {
                n2 = Integer.parseInt(string2.substring(n, n += n4));
            } else {
                int n5 = n;
                if (bl) {
                    ++n5;
                }
                try {
                    n2 = string2.charAt(n5++) - 48;
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    return ~n;
                }
                n += n4;
                while (n5 < n) {
                    n2 = (n2 << 3) + (n2 << 1) + string2.charAt(n5++) - 48;
                }
                if (bl) {
                    n2 = -n2;
                }
            }
            dateTimeParserBucket.saveField(this.iFieldType, n2);
            return n;
        }
    }

    static class StringLiteral
    implements DateTimePrinter,
    DateTimeParser {
        private final String iValue;

        StringLiteral(String string2) {
            this.iValue = string2;
        }

        public int estimatePrintedLength() {
            return this.iValue.length();
        }

        public void printTo(StringBuffer stringBuffer, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) {
            stringBuffer.append(this.iValue);
        }

        public void printTo(Writer writer2, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            writer2.write(this.iValue);
        }

        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
            stringBuffer.append(this.iValue);
        }

        public void printTo(Writer writer2, ReadablePartial readablePartial, Locale locale) throws IOException {
            writer2.write(this.iValue);
        }

        public int estimateParsedLength() {
            return this.iValue.length();
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n) {
            if (string2.regionMatches(true, n, this.iValue, 0, this.iValue.length())) {
                return n + this.iValue.length();
            }
            return ~n;
        }
    }

    static class CharacterLiteral
    implements DateTimePrinter,
    DateTimeParser {
        private final char iValue;

        CharacterLiteral(char c) {
            this.iValue = c;
        }

        public int estimatePrintedLength() {
            return 1;
        }

        public void printTo(StringBuffer stringBuffer, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) {
            stringBuffer.append(this.iValue);
        }

        public void printTo(Writer writer2, long l, Chronology chronology, int n, DateTimeZone dateTimeZone, Locale locale) throws IOException {
            writer2.write(this.iValue);
        }

        public void printTo(StringBuffer stringBuffer, ReadablePartial readablePartial, Locale locale) {
            stringBuffer.append(this.iValue);
        }

        public void printTo(Writer writer2, ReadablePartial readablePartial, Locale locale) throws IOException {
            writer2.write(this.iValue);
        }

        public int estimateParsedLength() {
            return 1;
        }

        public int parseInto(DateTimeParserBucket dateTimeParserBucket, String string2, int n) {
            char c;
            if (n >= string2.length()) {
                return ~n;
            }
            char c2 = string2.charAt(n);
            if (c2 != (c = this.iValue) && (c2 = Character.toUpperCase(c2)) != (c = Character.toUpperCase(c)) && (c2 = Character.toLowerCase(c2)) != (c = Character.toLowerCase(c))) {
                return ~n;
            }
            return n + 1;
        }
    }
}

