/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

class IntHashMap {
    private transient Entry[] table;
    private transient int count;
    private int threshold;
    private final float loadFactor;

    public IntHashMap() {
        this(20, 0.75f);
    }

    public IntHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public IntHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        Entry[] tab = this.table;
        int i = tab.length;
        while (i-- > 0) {
            Entry e2 = tab[i];
            while (e2 != null) {
                if (e2.value.equals(value)) {
                    return true;
                }
                e2 = e2.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    public boolean containsKey(int key2) {
        Entry[] tab = this.table;
        int hash2 = key2;
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        Entry e2 = tab[index2];
        while (e2 != null) {
            if (e2.hash == hash2) {
                return true;
            }
            e2 = e2.next;
        }
        return false;
    }

    public Object get(int key2) {
        Entry[] tab = this.table;
        int hash2 = key2;
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        Entry e2 = tab[index2];
        while (e2 != null) {
            if (e2.hash == hash2) {
                return e2.value;
            }
            e2 = e2.next;
        }
        return null;
    }

    protected void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e2 = old;
                old = old.next;
                int index2 = (e2.hash & Integer.MAX_VALUE) % newCapacity;
                e2.next = newMap[index2];
                newMap[index2] = e2;
            }
        }
    }

    public Object put(int key2, Object value) {
        Entry[] tab = this.table;
        int hash2 = key2;
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        Entry e2 = tab[index2];
        while (e2 != null) {
            if (e2.hash == hash2) {
                Object old = e2.value;
                e2.value = value;
                return old;
            }
            e2 = e2.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        }
        tab[index2] = e2 = new Entry(hash2, key2, value, tab[index2]);
        ++this.count;
        return null;
    }

    public Object remove(int key2) {
        Entry[] tab = this.table;
        int hash2 = key2;
        int index2 = (hash2 & Integer.MAX_VALUE) % tab.length;
        Entry e2 = tab[index2];
        Entry prev2 = null;
        while (e2 != null) {
            if (e2.hash == hash2) {
                if (prev2 != null) {
                    prev2.next = e2.next;
                } else {
                    tab[index2] = e2.next;
                }
                --this.count;
                Object oldValue = e2.value;
                e2.value = null;
                return oldValue;
            }
            prev2 = e2;
            e2 = e2.next;
        }
        return null;
    }

    public synchronized void clear() {
        Entry[] tab = this.table;
        int index2 = tab.length;
        while (--index2 >= 0) {
            tab[index2] = null;
        }
        this.count = 0;
    }

    private static class Entry {
        final int hash;
        final int key;
        Object value;
        Entry next;

        protected Entry(int hash2, int key2, Object value, Entry next2) {
            this.hash = hash2;
            this.key = key2;
            this.value = value;
            this.next = next2;
        }
    }
}

