(ns nearinfinity.clj-faker.lorem
  (:require [nearinfinity.clj-faker.core :refer :all]
            [clojure.string :as s]))

(def word (fake-picker [:lorem :words]))

(defn sentence [& {:keys [words]
                   :or {words (+ 7 (rand-int 12))}
                   :as args}]
  (let [word-gen #(apply word (flatten (seq args)))
        words (take words (repeatedly word-gen))]
    (str (s/join " " (conj (rest words) (s/capitalize (first words))))
         ".")))

(defn paragraph [& {:keys [sentences]
                   :or {sentences (+ 3 (rand-int 4))}
                   :as args}]
  (let [sentence-gen #(apply sentence (flatten (seq args)))
        sentences (take sentences (repeatedly sentence-gen))]
    (str (s/join "  " sentences)
         "\n")))
