(ns nearinfinity.clj-faker.core
  (:require [clojure.string :as s]
            [clojure.java.io :as io]))

(def get-fakes
  (memoize
    (fn [locale]
      (condp = locale
        :en (read-string (slurp (io/resource "en.edn")))
        :en-us (merge-with
                 merge
                 (get-fakes :en)
                 (read-string (slurp (io/resource "en-us.edn"))))))))

(defn- format-fake [fake]
  {:pre [(string? fake)]}
  "Substitute special characters into fake data."
  ;; TODO: integer replacement should be done multiple digits at a time.
  ;; The single-digit substitution is slower, and the resulting random
  ;; numbers do not follow Benford's 'Law'.
  (cond
    (re-find #"#" fake) (-> fake
                            (s/replace-first #"#" (str (rand-int 10)))
                            recur)
    :else fake))

(defn- get-fake
  [fakes keys]
  (letfn [(eval-fake [fake]
            (cond
              (string? fake) (format-fake fake)
              (vector? fake) (apply str (map eval-elem fake))))
          (eval-elem [elem]
            (cond
              (string? elem) (eval-fake elem)
              (vector? elem) (get-fake fakes elem)))]
    (-> (get-in fakes keys)
        rand-nth
        eval-fake)))

(defn fake-picker
  [keys]
  (fn [& {:keys [locale] :or {locale :en-us}}]
    (let [fakes (get-fakes locale)]
      (get-fake fakes keys))))
