(ns leiningen.new.ncljs
  (:require [leiningen.new.templates :refer [renderer name-to-path ->files]]
            [leiningen.core.main :as main]))

(def render (renderer "ncljs"))

(defn ncljs
  "
  Creates the project with the specified name.
  Type must either be `:standalone` or `:module` 
  which respectively create a standalone node.js app 
  or a module.
  "
  [name type]
  (let [data {:name name
              :sanitized (name-to-path name)}]
    (main/info "Generating fresh 'lein new' ncljs project.")
    (->files data
             ["project.clj" (render (str "project-" type ".clj") data)]
             ["src/{{sanitized}}/core.cljs" (render (str "core-" type ".cljs")  data)])))
