// Compiled by ClojureScript 1.9.473 {}
goog.provide('untangled.websockets.networking');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('cognitect.transit');
goog.require('taoensso.sente');
goog.require('taoensso.sente.packers.transit');
goog.require('om.next');
goog.require('om.transit');
goog.require('untangled.client.impl.network');
goog.require('untangled.client.logging');
goog.require('untangled.websockets.transit_packer');

/**
 * @interface
 */
untangled.websockets.networking.ChannelSocket = function(){};

/**
 * Reconnect the socket
 */
untangled.websockets.networking.reconnect = (function untangled$websockets$networking$reconnect(this$){
if((!((this$ == null))) && (!((this$.untangled$websockets$networking$ChannelSocket$reconnect$arity$1 == null)))){
return this$.untangled$websockets$networking$ChannelSocket$reconnect$arity$1(this$);
} else {
var x__8220__auto__ = (((this$ == null))?null:this$);
var m__8221__auto__ = (untangled.websockets.networking.reconnect[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,this$);
} else {
var m__8221__auto____$1 = (untangled.websockets.networking.reconnect["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"ChannelSocket.reconnect",this$);
}
}
}
});

if(typeof untangled.websockets.networking.router_ !== 'undefined'){
} else {
untangled.websockets.networking.router_ = cljs.core.atom.call(null,null);
}
untangled.websockets.networking.stop_router_BANG_ = (function untangled$websockets$networking$stop_router_BANG_(){
var temp__6753__auto__ = cljs.core.deref.call(null,untangled.websockets.networking.router_);
if(cljs.core.truth_(temp__6753__auto__)){
var stop_f = temp__6753__auto__;
return stop_f.call(null);
} else {
return null;
}
});
untangled.websockets.networking.start_router_BANG_ = (function untangled$websockets$networking$start_router_BANG_(ch_recv,msg_handler){
untangled.client.logging.info.call(null,"Starting websocket router.");

untangled.websockets.networking.stop_router_BANG_.call(null);

return cljs.core.reset_BANG_.call(null,untangled.websockets.networking.router_,taoensso.sente.start_chsk_router_BANG_.call(null,ch_recv,msg_handler));
});
if(typeof untangled.websockets.networking.message_received !== 'undefined'){
} else {
/**
 * Multimethod to handle Sente `event-msg`s
 */
untangled.websockets.networking.message_received = (function (){var method_table__8533__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__8534__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__8535__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__8536__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__8537__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"untangled.websockets.networking","message-received"),new cljs.core.Keyword(null,"id","id",-1388402092),new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__8537__auto__,method_table__8533__auto__,prefer_table__8534__auto__,method_cache__8535__auto__,cached_hierarchy__8536__auto__));
})();
}
if(typeof untangled.websockets.networking.push_received !== 'undefined'){
} else {
/**
 * Multimethod to handle push events
 */
untangled.websockets.networking.push_received = (function (){var method_table__8533__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__8534__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__8535__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__8536__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__8537__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"untangled.websockets.networking","push-received"),((function (method_table__8533__auto__,prefer_table__8534__auto__,method_cache__8535__auto__,cached_hierarchy__8536__auto__,hierarchy__8537__auto__){
return (function (app,msg){
return new cljs.core.Keyword(null,"topic","topic",-1960480691).cljs$core$IFn$_invoke$arity$1(msg);
});})(method_table__8533__auto__,prefer_table__8534__auto__,method_cache__8535__auto__,cached_hierarchy__8536__auto__,hierarchy__8537__auto__))
,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__8537__auto__,method_table__8533__auto__,prefer_table__8534__auto__,method_cache__8535__auto__,cached_hierarchy__8536__auto__));
})();
}
cljs.core._add_method.call(null,untangled.websockets.networking.push_received,new cljs.core.Keyword(null,"default","default",-1987822328),(function (app,msg){
return untangled.client.logging.error.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Received and unhandled message: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(msg)].join(''));
}));

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {untangled.client.impl.network.UntangledNetwork}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
 * @implements {untangled.websockets.networking.ChannelSocket}
*/
untangled.websockets.networking.ChannelClient = (function (ch_recv,url,init_chan,channel_socket,send_fn,global_error_callback,req_params,parse_queue,completed_app,__meta,__extmap,__hash){
this.ch_recv = ch_recv;
this.url = url;
this.init_chan = init_chan;
this.channel_socket = channel_socket;
this.send_fn = send_fn;
this.global_error_callback = global_error_callback;
this.req_params = req_params;
this.parse_queue = parse_queue;
this.completed_app = completed_app;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})

untangled.websockets.networking.ChannelClient.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8177__auto__,k__8178__auto__){
var self__ = this;
var this__8177__auto____$1 = this;
return this__8177__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8178__auto__,null);
});


untangled.websockets.networking.ChannelClient.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8179__auto__,k48553,else__8180__auto__){
var self__ = this;
var this__8179__auto____$1 = this;
var G__48555 = (((k48553 instanceof cljs.core.Keyword))?k48553.fqn:null);
switch (G__48555) {
case "ch-recv":
return self__.ch_recv;

break;
case "url":
return self__.url;

break;
case "init-chan":
return self__.init_chan;

break;
case "channel-socket":
return self__.channel_socket;

break;
case "send-fn":
return self__.send_fn;

break;
case "global-error-callback":
return self__.global_error_callback;

break;
case "req-params":
return self__.req_params;

break;
case "parse-queue":
return self__.parse_queue;

break;
case "completed-app":
return self__.completed_app;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k48553,else__8180__auto__);

}
});


untangled.websockets.networking.ChannelClient.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8191__auto__,writer__8192__auto__,opts__8193__auto__){
var self__ = this;
var this__8191__auto____$1 = this;
var pr_pair__8194__auto__ = ((function (this__8191__auto____$1){
return (function (keyval__8195__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8192__auto__,cljs.core.pr_writer,""," ","",opts__8193__auto__,keyval__8195__auto__);
});})(this__8191__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8192__auto__,pr_pair__8194__auto__,"#untangled.websockets.networking.ChannelClient{",", ","}",opts__8193__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),self__.ch_recv],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),self__.init_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),self__.channel_socket],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"send-fn","send-fn",351002041),self__.send_fn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),self__.global_error_callback],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-params","req-params",2117077454),self__.req_params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),self__.parse_queue],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"completed-app","completed-app",-635152970),self__.completed_app],null))], null),self__.__extmap));
});


untangled.websockets.networking.ChannelClient.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;


untangled.websockets.networking.ChannelClient.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__48552){
var self__ = this;
var G__48552__$1 = this;
return (new cljs.core.RecordIter((0),G__48552__$1,9,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),new cljs.core.Keyword(null,"send-fn","send-fn",351002041),new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),new cljs.core.Keyword(null,"req-params","req-params",2117077454),new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),new cljs.core.Keyword(null,"completed-app","completed-app",-635152970)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


untangled.websockets.networking.ChannelClient.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8175__auto__){
var self__ = this;
var this__8175__auto____$1 = this;
return self__.__meta;
});


untangled.websockets.networking.ChannelClient.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8171__auto__){
var self__ = this;
var this__8171__auto____$1 = this;
return (new untangled.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,self__.__hash));
});


untangled.websockets.networking.ChannelClient.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8181__auto__){
var self__ = this;
var this__8181__auto____$1 = this;
return (9 + cljs.core.count.call(null,self__.__extmap));
});


untangled.websockets.networking.ChannelClient.prototype.untangled$websockets$networking$ChannelSocket$ = cljs.core.PROTOCOL_SENTINEL;


untangled.websockets.networking.ChannelClient.prototype.untangled$websockets$networking$ChannelSocket$reconnect$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return taoensso.sente.chsk_reconnect_BANG_.call(null,self__.channel_socket);
});


untangled.websockets.networking.ChannelClient.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8172__auto__){
var self__ = this;
var this__8172__auto____$1 = this;
var h__7944__auto__ = self__.__hash;
if(!((h__7944__auto__ == null))){
return h__7944__auto__;
} else {
var h__7944__auto____$1 = cljs.core.hash_imap.call(null,this__8172__auto____$1);
self__.__hash = h__7944__auto____$1;

return h__7944__auto____$1;
}
});


untangled.websockets.networking.ChannelClient.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8173__auto__,other__8174__auto__){
var self__ = this;
var this__8173__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7490__auto__ = other__8174__auto__;
if(cljs.core.truth_(and__7490__auto__)){
return ((this__8173__auto____$1.constructor === other__8174__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8173__auto____$1,other__8174__auto__));
} else {
return and__7490__auto__;
}
})())){
return true;
} else {
return false;
}
});


untangled.websockets.networking.ChannelClient.prototype.untangled$client$impl$network$UntangledNetwork$ = cljs.core.PROTOCOL_SENTINEL;


untangled.websockets.networking.ChannelClient.prototype.untangled$client$impl$network$UntangledNetwork$send$arity$4 = (function (this$,edn,ok,err){
var self__ = this;
var this$__$1 = this;
var c__42603__auto___48677 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto___48677,this$__$1){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto___48677,this$__$1){
return (function (state_48598){
var state_val_48599 = (state_48598[(1)]);
if((state_val_48599 === (7))){
var state_48598__$1 = state_48598;
var statearr_48600_48678 = state_48598__$1;
(statearr_48600_48678[(2)] = false);

(statearr_48600_48678[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48599 === (1))){
var state_48598__$1 = state_48598;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48598__$1,(2),self__.parse_queue);
} else {
if((state_val_48599 === (4))){
var state_48598__$1 = state_48598;
var statearr_48601_48679 = state_48598__$1;
(statearr_48601_48679[(2)] = false);

(statearr_48601_48679[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48599 === (15))){
var inst_48581 = (state_48598[(7)]);
var inst_48580 = (state_48598[(8)]);
var inst_48590 = self__.global_error_callback.call(null,inst_48580,inst_48581);
var state_48598__$1 = state_48598;
var statearr_48602_48680 = state_48598__$1;
(statearr_48602_48680[(2)] = inst_48590);

(statearr_48602_48680[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48599 === (13))){
var inst_48580 = (state_48598[(8)]);
var inst_48587 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("SERVER ERROR CODE: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_48580)].join('');
var inst_48588 = untangled.client.logging.debug.call(null,inst_48587);
var state_48598__$1 = (function (){var statearr_48603 = state_48598;
(statearr_48603[(9)] = inst_48588);

return statearr_48603;
})();
if(cljs.core.truth_(self__.global_error_callback)){
var statearr_48604_48681 = state_48598__$1;
(statearr_48604_48681[(1)] = (15));

} else {
var statearr_48605_48682 = state_48598__$1;
(statearr_48605_48682[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48599 === (6))){
var state_48598__$1 = state_48598;
var statearr_48606_48683 = state_48598__$1;
(statearr_48606_48683[(2)] = true);

(statearr_48606_48683[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48599 === (17))){
var inst_48581 = (state_48598[(7)]);
var inst_48593 = (state_48598[(2)]);
var inst_48594 = err.call(null,inst_48581);
var state_48598__$1 = (function (){var statearr_48607 = state_48598;
(statearr_48607[(10)] = inst_48593);

return statearr_48607;
})();
var statearr_48608_48684 = state_48598__$1;
(statearr_48608_48684[(2)] = inst_48594);

(statearr_48608_48684[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48599 === (3))){
var inst_48558 = (state_48598[(11)]);
var inst_48563 = inst_48558.cljs$lang$protocol_mask$partition0$;
var inst_48564 = (inst_48563 & (64));
var inst_48565 = inst_48558.cljs$core$ISeq$;
var inst_48566 = (cljs.core.PROTOCOL_SENTINEL === inst_48565);
var inst_48567 = (inst_48564) || (inst_48566);
var state_48598__$1 = state_48598;
if(cljs.core.truth_(inst_48567)){
var statearr_48609_48685 = state_48598__$1;
(statearr_48609_48685[(1)] = (6));

} else {
var statearr_48610_48686 = state_48598__$1;
(statearr_48610_48686[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48599 === (12))){
var inst_48581 = (state_48598[(7)]);
var inst_48585 = ok.call(null,inst_48581);
var state_48598__$1 = state_48598;
var statearr_48611_48687 = state_48598__$1;
(statearr_48611_48687[(2)] = inst_48585);

(statearr_48611_48687[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48599 === (2))){
var inst_48558 = (state_48598[(11)]);
var inst_48558__$1 = (state_48598[(2)]);
var inst_48560 = (inst_48558__$1 == null);
var inst_48561 = cljs.core.not.call(null,inst_48560);
var state_48598__$1 = (function (){var statearr_48612 = state_48598;
(statearr_48612[(11)] = inst_48558__$1);

return statearr_48612;
})();
if(inst_48561){
var statearr_48613_48688 = state_48598__$1;
(statearr_48613_48688[(1)] = (3));

} else {
var statearr_48614_48689 = state_48598__$1;
(statearr_48614_48689[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48599 === (11))){
var inst_48581 = (state_48598[(7)]);
var inst_48580 = (state_48598[(8)]);
var inst_48579 = (state_48598[(2)]);
var inst_48580__$1 = cljs.core.get.call(null,inst_48579,new cljs.core.Keyword(null,"status","status",-1997798413));
var inst_48581__$1 = cljs.core.get.call(null,inst_48579,new cljs.core.Keyword(null,"body","body",-2049205669));
var inst_48582 = untangled.client.logging.debug.call(null,"Receiving ",inst_48581__$1);
var inst_48583 = cljs.core._EQ_.call(null,inst_48580__$1,(200));
var state_48598__$1 = (function (){var statearr_48615 = state_48598;
(statearr_48615[(7)] = inst_48581__$1);

(statearr_48615[(8)] = inst_48580__$1);

(statearr_48615[(12)] = inst_48582);

return statearr_48615;
})();
if(inst_48583){
var statearr_48616_48690 = state_48598__$1;
(statearr_48616_48690[(1)] = (12));

} else {
var statearr_48617_48691 = state_48598__$1;
(statearr_48617_48691[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48599 === (9))){
var inst_48558 = (state_48598[(11)]);
var inst_48576 = cljs.core.apply.call(null,cljs.core.hash_map,inst_48558);
var state_48598__$1 = state_48598;
var statearr_48618_48692 = state_48598__$1;
(statearr_48618_48692[(2)] = inst_48576);

(statearr_48618_48692[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48599 === (5))){
var inst_48574 = (state_48598[(2)]);
var state_48598__$1 = state_48598;
if(cljs.core.truth_(inst_48574)){
var statearr_48619_48693 = state_48598__$1;
(statearr_48619_48693[(1)] = (9));

} else {
var statearr_48620_48694 = state_48598__$1;
(statearr_48620_48694[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48599 === (14))){
var inst_48596 = (state_48598[(2)]);
var state_48598__$1 = (function (){var statearr_48621 = state_48598;
(statearr_48621[(13)] = inst_48596);

return statearr_48621;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48598__$1,self__.parse_queue);
} else {
if((state_val_48599 === (16))){
var state_48598__$1 = state_48598;
var statearr_48622_48695 = state_48598__$1;
(statearr_48622_48695[(2)] = null);

(statearr_48622_48695[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48599 === (10))){
var inst_48558 = (state_48598[(11)]);
var state_48598__$1 = state_48598;
var statearr_48623_48696 = state_48598__$1;
(statearr_48623_48696[(2)] = inst_48558);

(statearr_48623_48696[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48599 === (8))){
var inst_48571 = (state_48598[(2)]);
var state_48598__$1 = state_48598;
var statearr_48624_48697 = state_48598__$1;
(statearr_48624_48697[(2)] = inst_48571);

(statearr_48624_48697[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto___48677,this$__$1))
;
return ((function (switch__42489__auto__,c__42603__auto___48677,this$__$1){
return (function() {
var untangled$websockets$networking$state_machine__42490__auto__ = null;
var untangled$websockets$networking$state_machine__42490__auto____0 = (function (){
var statearr_48628 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48628[(0)] = untangled$websockets$networking$state_machine__42490__auto__);

(statearr_48628[(1)] = (1));

return statearr_48628;
});
var untangled$websockets$networking$state_machine__42490__auto____1 = (function (state_48598){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_48598);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e48629){if((e48629 instanceof Object)){
var ex__42493__auto__ = e48629;
var statearr_48630_48698 = state_48598;
(statearr_48630_48698[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48598);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48629;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48699 = state_48598;
state_48598 = G__48699;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
untangled$websockets$networking$state_machine__42490__auto__ = function(state_48598){
switch(arguments.length){
case 0:
return untangled$websockets$networking$state_machine__42490__auto____0.call(this);
case 1:
return untangled$websockets$networking$state_machine__42490__auto____1.call(this,state_48598);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$websockets$networking$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$websockets$networking$state_machine__42490__auto____0;
untangled$websockets$networking$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$websockets$networking$state_machine__42490__auto____1;
return untangled$websockets$networking$state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto___48677,this$__$1))
})();
var state__42605__auto__ = (function (){var statearr_48631 = f__42604__auto__.call(null);
(statearr_48631[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___48677);

return statearr_48631;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto___48677,this$__$1))
);


var c__42603__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto__,this$__$1){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto__,this$__$1){
return (function (state_48648){
var state_val_48649 = (state_48648[(1)]);
if((state_val_48649 === (1))){
var state_48648__$1 = state_48648;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_48648__$1,(2),self__.init_chan);
} else {
if((state_val_48649 === (2))){
var inst_48633 = (state_48648[(2)]);
var inst_48634 = untangled.client.logging.debug.call(null,"Sending ",edn);
var inst_48635 = cljs.core.List.EMPTY;
var inst_48636 = cljs.core._conj.call(null,inst_48635,new cljs.core.Keyword("api","parse","api/parse",-1162064757));
var inst_48637 = [new cljs.core.Keyword(null,"action","action",-811238024),new cljs.core.Keyword(null,"command","command",-894540724),new cljs.core.Keyword(null,"content","content",15833224)];
var inst_48638 = [new cljs.core.Keyword(null,"send-message","send-message",185030731),new cljs.core.Keyword(null,"send-om-request","send-om-request",-1867228457),edn];
var inst_48639 = cljs.core.PersistentHashMap.fromArrays(inst_48637,inst_48638);
var inst_48640 = cljs.core.List.EMPTY;
var inst_48641 = cljs.core._conj.call(null,inst_48640,inst_48639);
var inst_48642 = cljs.core.concat.call(null,inst_48636,inst_48641);
var inst_48643 = cljs.core.seq.call(null,inst_48642);
var inst_48644 = cljs.core.sequence.call(null,inst_48643);
var inst_48645 = cljs.core.vec.call(null,inst_48644);
var inst_48646 = self__.send_fn.call(null,inst_48645);
var state_48648__$1 = (function (){var statearr_48650 = state_48648;
(statearr_48650[(7)] = inst_48633);

(statearr_48650[(8)] = inst_48634);

return statearr_48650;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48648__$1,inst_48646);
} else {
return null;
}
}
});})(c__42603__auto__,this$__$1))
;
return ((function (switch__42489__auto__,c__42603__auto__,this$__$1){
return (function() {
var untangled$websockets$networking$state_machine__42490__auto__ = null;
var untangled$websockets$networking$state_machine__42490__auto____0 = (function (){
var statearr_48654 = [null,null,null,null,null,null,null,null,null];
(statearr_48654[(0)] = untangled$websockets$networking$state_machine__42490__auto__);

(statearr_48654[(1)] = (1));

return statearr_48654;
});
var untangled$websockets$networking$state_machine__42490__auto____1 = (function (state_48648){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_48648);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e48655){if((e48655 instanceof Object)){
var ex__42493__auto__ = e48655;
var statearr_48656_48700 = state_48648;
(statearr_48656_48700[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48648);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48655;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48701 = state_48648;
state_48648 = G__48701;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
untangled$websockets$networking$state_machine__42490__auto__ = function(state_48648){
switch(arguments.length){
case 0:
return untangled$websockets$networking$state_machine__42490__auto____0.call(this);
case 1:
return untangled$websockets$networking$state_machine__42490__auto____1.call(this,state_48648);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$websockets$networking$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$websockets$networking$state_machine__42490__auto____0;
untangled$websockets$networking$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$websockets$networking$state_machine__42490__auto____1;
return untangled$websockets$networking$state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto__,this$__$1))
})();
var state__42605__auto__ = (function (){var statearr_48657 = f__42604__auto__.call(null);
(statearr_48657[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto__);

return statearr_48657;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto__,this$__$1))
);

return c__42603__auto__;
});


untangled.websockets.networking.ChannelClient.prototype.untangled$client$impl$network$UntangledNetwork$start$arity$2 = (function (this$,app){
var self__ = this;
var this$__$1 = this;
var this_48702__$2 = cljs.core.assoc.call(null,this$__$1,new cljs.core.Keyword(null,"completed-app","completed-app",-635152970),app);
untangled.websockets.networking.message_received.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword(null,"default","default",-1987822328),((function (this_48702__$2,this$__$1){
return (function (p__48658){
var map__48659 = p__48658;
var map__48659__$1 = ((((!((map__48659 == null)))?((((map__48659.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48659.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48659):map__48659);
var ch_recv__$1 = cljs.core.get.call(null,map__48659__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn__$1 = cljs.core.get.call(null,map__48659__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var state = cljs.core.get.call(null,map__48659__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var event = cljs.core.get.call(null,map__48659__$1,new cljs.core.Keyword(null,"event","event",301435442));
var id = cljs.core.get.call(null,map__48659__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var _QMARK_data = cljs.core.get.call(null,map__48659__$1,new cljs.core.Keyword(null,"?data","?data",-9471433));
var command = new cljs.core.Keyword(null,"command","command",-894540724).cljs$core$IFn$_invoke$arity$1(_QMARK_data);
return untangled.client.logging.debug.call(null,"Message Routed to default handler ",command);
});})(this_48702__$2,this$__$1))
);

untangled.websockets.networking.message_received.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword("api","parse","api/parse",-1162064757),((function (this_48702__$2,this$__$1){
return (function (p__48661){
var map__48662 = p__48661;
var map__48662__$1 = ((((!((map__48662 == null)))?((((map__48662.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48662.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48662):map__48662);
var _QMARK_data = cljs.core.get.call(null,map__48662__$1,new cljs.core.Keyword(null,"?data","?data",-9471433));
return cljs.core.async.put_BANG_.call(null,self__.parse_queue,_QMARK_data);
});})(this_48702__$2,this$__$1))
);

untangled.websockets.networking.message_received.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword("api","server-push","api/server-push",-1185983895),((function (this_48702__$2,this$__$1){
return (function (p__48664){
var map__48665 = p__48664;
var map__48665__$1 = ((((!((map__48665 == null)))?((((map__48665.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48665.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48665):map__48665);
var msg = map__48665__$1;
var _QMARK_data = cljs.core.get.call(null,map__48665__$1,new cljs.core.Keyword(null,"?data","?data",-9471433));
var app__$1 = new cljs.core.Keyword(null,"completed-app","completed-app",-635152970).cljs$core$IFn$_invoke$arity$1(this_48702__$2);
return untangled.websockets.networking.push_received.call(null,app__$1,_QMARK_data);
});})(this_48702__$2,this$__$1))
);

untangled.websockets.networking.message_received.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686),((function (this_48702__$2,this$__$1){
return (function (p__48667){
var map__48668 = p__48667;
var map__48668__$1 = ((((!((map__48668 == null)))?((((map__48668.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48668.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48668):map__48668);
var message = map__48668__$1;
var ch_recv__$1 = cljs.core.get.call(null,map__48668__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn__$1 = cljs.core.get.call(null,map__48668__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var state = cljs.core.get.call(null,map__48668__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var event = cljs.core.get.call(null,map__48668__$1,new cljs.core.Keyword(null,"event","event",301435442));
var id = cljs.core.get.call(null,map__48668__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var _QMARK_data = cljs.core.get.call(null,map__48668__$1,new cljs.core.Keyword(null,"?data","?data",-9471433));
return untangled.client.logging.debug.call(null,"Message Routed to handshake handler ",state);
});})(this_48702__$2,this$__$1))
);

untangled.websockets.networking.message_received.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.Keyword("chsk","state","chsk/state",-1991397620),((function (this_48702__$2,this$__$1){
return (function (p__48670){
var map__48671 = p__48670;
var map__48671__$1 = ((((!((map__48671 == null)))?((((map__48671.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48671.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48671):map__48671);
var message = map__48671__$1;
var ch_recv__$1 = cljs.core.get.call(null,map__48671__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn__$1 = cljs.core.get.call(null,map__48671__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var state = cljs.core.get.call(null,map__48671__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var event = cljs.core.get.call(null,map__48671__$1,new cljs.core.Keyword(null,"event","event",301435442));
var id = cljs.core.get.call(null,map__48671__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var _QMARK_data = cljs.core.get.call(null,map__48671__$1,new cljs.core.Keyword(null,"?data","?data",-9471433));
untangled.client.logging.debug.call(null,"Message Routed to state handler",cljs.core.keys.call(null,message));

untangled.client.logging.debug.call(null,"Event",event);

untangled.client.logging.debug.call(null,"State",state);

if(cljs.core.truth_(new cljs.core.Keyword(null,"ever-opened?","ever-opened?",1128459732).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,state)))){
return cljs.core.async.put_BANG_.call(null,self__.init_chan,true);
} else {
return null;
}
});})(this_48702__$2,this$__$1))
);

return untangled.websockets.networking.start_router_BANG_.call(null,self__.ch_recv,untangled.websockets.networking.message_received);
});


untangled.websockets.networking.ChannelClient.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8186__auto__,k__8187__auto__){
var self__ = this;
var this__8186__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),null,new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),null,new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),null,new cljs.core.Keyword(null,"req-params","req-params",2117077454),null,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),null,new cljs.core.Keyword(null,"url","url",276297046),null,new cljs.core.Keyword(null,"completed-app","completed-app",-635152970),null,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),null,new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),null], null), null),k__8187__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8186__auto____$1),self__.__meta),k__8187__auto__);
} else {
return (new untangled.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8187__auto__)),null));
}
});


untangled.websockets.networking.ChannelClient.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8184__auto__,k__8185__auto__,G__48552){
var self__ = this;
var this__8184__auto____$1 = this;
var pred__48673 = cljs.core.keyword_identical_QMARK_;
var expr__48674 = k__8185__auto__;
if(cljs.core.truth_(pred__48673.call(null,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),expr__48674))){
return (new untangled.websockets.networking.ChannelClient(G__48552,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48673.call(null,new cljs.core.Keyword(null,"url","url",276297046),expr__48674))){
return (new untangled.websockets.networking.ChannelClient(self__.ch_recv,G__48552,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48673.call(null,new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),expr__48674))){
return (new untangled.websockets.networking.ChannelClient(self__.ch_recv,self__.url,G__48552,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48673.call(null,new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),expr__48674))){
return (new untangled.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,G__48552,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48673.call(null,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),expr__48674))){
return (new untangled.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,G__48552,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48673.call(null,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),expr__48674))){
return (new untangled.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,G__48552,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48673.call(null,new cljs.core.Keyword(null,"req-params","req-params",2117077454),expr__48674))){
return (new untangled.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,G__48552,self__.parse_queue,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48673.call(null,new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),expr__48674))){
return (new untangled.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,G__48552,self__.completed_app,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48673.call(null,new cljs.core.Keyword(null,"completed-app","completed-app",-635152970),expr__48674))){
return (new untangled.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,G__48552,self__.__meta,self__.__extmap,null));
} else {
return (new untangled.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8185__auto__,G__48552),null));
}
}
}
}
}
}
}
}
}
});


untangled.websockets.networking.ChannelClient.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8189__auto__){
var self__ = this;
var this__8189__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),self__.ch_recv],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),self__.init_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),self__.channel_socket],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"send-fn","send-fn",351002041),self__.send_fn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),self__.global_error_callback],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"req-params","req-params",2117077454),self__.req_params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),self__.parse_queue],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"completed-app","completed-app",-635152970),self__.completed_app],null))], null),self__.__extmap));
});


untangled.websockets.networking.ChannelClient.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8176__auto__,G__48552){
var self__ = this;
var this__8176__auto____$1 = this;
return (new untangled.websockets.networking.ChannelClient(self__.ch_recv,self__.url,self__.init_chan,self__.channel_socket,self__.send_fn,self__.global_error_callback,self__.req_params,self__.parse_queue,self__.completed_app,G__48552,self__.__extmap,self__.__hash));
});


untangled.websockets.networking.ChannelClient.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8182__auto__,entry__8183__auto__){
var self__ = this;
var this__8182__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8183__auto__)){
return this__8182__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8183__auto__,(0)),cljs.core._nth.call(null,entry__8183__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8182__auto____$1,entry__8183__auto__);
}
});

untangled.websockets.networking.ChannelClient.getBasis = (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch-recv","ch-recv",649614666,null),new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.Symbol(null,"init-chan","init-chan",-509721969,null),new cljs.core.Symbol(null,"channel-socket","channel-socket",2056793990,null),new cljs.core.Symbol(null,"send-fn","send-fn",1991533568,null),new cljs.core.Symbol(null,"global-error-callback","global-error-callback",-1753008138,null),new cljs.core.Symbol(null,"req-params","req-params",-537358315,null),new cljs.core.Symbol(null,"parse-queue","parse-queue",-725824080,null),new cljs.core.Symbol(null,"completed-app","completed-app",1005378557,null)], null);
});

untangled.websockets.networking.ChannelClient.cljs$lang$type = true;

untangled.websockets.networking.ChannelClient.cljs$lang$ctorPrSeq = (function (this__8213__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"untangled.websockets.networking/ChannelClient");
});

untangled.websockets.networking.ChannelClient.cljs$lang$ctorPrWriter = (function (this__8213__auto__,writer__8214__auto__){
return cljs.core._write.call(null,writer__8214__auto__,"untangled.websockets.networking/ChannelClient");
});

untangled.websockets.networking.__GT_ChannelClient = (function untangled$websockets$networking$__GT_ChannelClient(ch_recv,url,init_chan,channel_socket,send_fn,global_error_callback,req_params,parse_queue,completed_app){
return (new untangled.websockets.networking.ChannelClient(ch_recv,url,init_chan,channel_socket,send_fn,global_error_callback,req_params,parse_queue,completed_app,null,null,null));
});

untangled.websockets.networking.map__GT_ChannelClient = (function untangled$websockets$networking$map__GT_ChannelClient(G__48554){
return (new untangled.websockets.networking.ChannelClient(new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861).cljs$core$IFn$_invoke$arity$1(G__48554),new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(G__48554),new cljs.core.Keyword(null,"init-chan","init-chan",2144713800).cljs$core$IFn$_invoke$arity$1(G__48554),new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463).cljs$core$IFn$_invoke$arity$1(G__48554),new cljs.core.Keyword(null,"send-fn","send-fn",351002041).cljs$core$IFn$_invoke$arity$1(G__48554),new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631).cljs$core$IFn$_invoke$arity$1(G__48554),new cljs.core.Keyword(null,"req-params","req-params",2117077454).cljs$core$IFn$_invoke$arity$1(G__48554),new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689).cljs$core$IFn$_invoke$arity$1(G__48554),new cljs.core.Keyword(null,"completed-app","completed-app",-635152970).cljs$core$IFn$_invoke$arity$1(G__48554),null,cljs.core.dissoc.call(null,G__48554,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),new cljs.core.Keyword(null,"send-fn","send-fn",351002041),new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),new cljs.core.Keyword(null,"req-params","req-params",2117077454),new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),new cljs.core.Keyword(null,"completed-app","completed-app",-635152970)),null));
});

/**
 * Creates a client side networking component for use in place of the default untangled networking component.
 * 
 *   Params:
 *   - `url` - The url to handle websocket traffic on. (ex. "\chsk")
 *   - `host` (Optional) - server that is hosting the websocket server
 *   - `global-error-callback` (Optional) - Analagous to the global error callback in untangled client.
 *   - `req-params` (Optional) - Params to be attached to the initial request.
 *   - `state-callback` (Optional) - Callback that runs when the websocket state of the websocket changes.
 *    The function takes an old state parameter and a new state parameter (arity 2 function).
 *    `state-callback` can be either a function, or an atom containing a function.
 *   - `transit-handlers` (Optional) - Expects a map with `:read` and/or `:write` key containing a map of transit handlers,
 *   
 */
untangled.websockets.networking.make_channel_client = (function untangled$websockets$networking$make_channel_client(var_args){
var args__8730__auto__ = [];
var len__8723__auto___48710 = arguments.length;
var i__8724__auto___48711 = (0);
while(true){
if((i__8724__auto___48711 < len__8723__auto___48710)){
args__8730__auto__.push((arguments[i__8724__auto___48711]));

var G__48712 = (i__8724__auto___48711 + (1));
i__8724__auto___48711 = G__48712;
continue;
} else {
}
break;
}

var argseq__8731__auto__ = ((((1) < args__8730__auto__.length))?(new cljs.core.IndexedSeq(args__8730__auto__.slice((1)),(0),null)):null);
return untangled.websockets.networking.make_channel_client.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8731__auto__);
});

untangled.websockets.networking.make_channel_client.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__48705){
var map__48706 = p__48705;
var map__48706__$1 = ((((!((map__48706 == null)))?((((map__48706.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48706.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48706):map__48706);
var global_error_callback = cljs.core.get.call(null,map__48706__$1,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631));
var host = cljs.core.get.call(null,map__48706__$1,new cljs.core.Keyword(null,"host","host",-1558485167));
var req_params = cljs.core.get.call(null,map__48706__$1,new cljs.core.Keyword(null,"req-params","req-params",2117077454));
var state_callback = cljs.core.get.call(null,map__48706__$1,new cljs.core.Keyword(null,"state-callback","state-callback",-1311788585));
var transit_handlers = cljs.core.get.call(null,map__48706__$1,new cljs.core.Keyword(null,"transit-handlers","transit-handlers",-1206080791));
var parse_queue = cljs.core.async.chan.call(null);
var map__48708 = taoensso.sente.make_channel_socket_BANG_.call(null,url,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"packer","packer",66077544),untangled.websockets.transit_packer.make_packer.call(null,transit_handlers),new cljs.core.Keyword(null,"host","host",-1558485167),host,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"params","params",710516235),req_params,new cljs.core.Keyword(null,"wrap-recv-evs?","wrap-recv-evs?",-1996694153),false], null));
var map__48708__$1 = ((((!((map__48708 == null)))?((((map__48708.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48708.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48708):map__48708);
var chsk = cljs.core.get.call(null,map__48708__$1,new cljs.core.Keyword(null,"chsk","chsk",-863703081));
var ch_recv = cljs.core.get.call(null,map__48708__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn = cljs.core.get.call(null,map__48708__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var state = cljs.core.get.call(null,map__48708__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var channel_client = untangled.websockets.networking.map__GT_ChannelClient.call(null,new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),ch_recv,new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"init-chan","init-chan",2144713800),cljs.core.async.promise_chan.call(null),new cljs.core.Keyword(null,"channel-socket","channel-socket",416262463),chsk,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631),global_error_callback,new cljs.core.Keyword(null,"req-params","req-params",2117077454),req_params,new cljs.core.Keyword(null,"parse-queue","parse-queue",1928611689),parse_queue], null));
if(cljs.core.fn_QMARK_.call(null,state_callback)){
cljs.core.add_watch.call(null,state,new cljs.core.Keyword("untangled.websockets.networking","state-callback","untangled.websockets.networking/state-callback",-1707463549),((function (parse_queue,map__48708,map__48708__$1,chsk,ch_recv,send_fn,state,channel_client,map__48706,map__48706__$1,global_error_callback,host,req_params,state_callback,transit_handlers){
return (function (a,k,o,n){
return state_callback.call(null,o,n);
});})(parse_queue,map__48708,map__48708__$1,chsk,ch_recv,send_fn,state,channel_client,map__48706,map__48706__$1,global_error_callback,host,req_params,state_callback,transit_handlers))
);
} else {
if((state_callback instanceof cljs.core.Atom)){
cljs.core.add_watch.call(null,state,new cljs.core.Keyword("untangled.websockets.networking","state-callback","untangled.websockets.networking/state-callback",-1707463549),((function (parse_queue,map__48708,map__48708__$1,chsk,ch_recv,send_fn,state,channel_client,map__48706,map__48706__$1,global_error_callback,host,req_params,state_callback,transit_handlers){
return (function (a,k,o,n){
return cljs.core.deref.call(null,state_callback).call(null,o,n);
});})(parse_queue,map__48708,map__48708__$1,chsk,ch_recv,send_fn,state,channel_client,map__48706,map__48706__$1,global_error_callback,host,req_params,state_callback,transit_handlers))
);
} else {
}
}

return channel_client;
});

untangled.websockets.networking.make_channel_client.cljs$lang$maxFixedArity = (1);

untangled.websockets.networking.make_channel_client.cljs$lang$applyTo = (function (seq48703){
var G__48704 = cljs.core.first.call(null,seq48703);
var seq48703__$1 = cljs.core.next.call(null,seq48703);
return untangled.websockets.networking.make_channel_client.cljs$core$IFn$_invoke$arity$variadic(G__48704,seq48703__$1);
});

