// Compiled by ClojureScript 1.9.473 {}
goog.provide('untangled.ui.elements');
goog.require('cljs.core');
goog.require('om.dom');
goog.require('om.next');
goog.require('untangled.ui.menu');
goog.require('untangled.icons');
goog.require('untangled.events');
goog.require('untangled.client.logging');
/**
 * Wrap children in a span where the :visible attribute
 *   is a boolean indicating the visibility of the children.
 * 
 *   Props is a clj(s) map of normal React attributes.
 * 
 *   `:inline?` - A boolean (default false). When true, emits a `span`, else `div`.
 * 
 *   You can get this same effect using the `u-fade-in` and `u-fade-out` CSS classes. See the CSS Guide.
 * 
 *   When the resulting span becomes visible it fades in, and when it becomes hidden it fades out.
 */
untangled.ui.elements.ui_fader = (function untangled$ui$elements$ui_fader(var_args){
var args__8730__auto__ = [];
var len__8723__auto___49054 = arguments.length;
var i__8724__auto___49055 = (0);
while(true){
if((i__8724__auto___49055 < len__8723__auto___49054)){
args__8730__auto__.push((arguments[i__8724__auto___49055]));

var G__49056 = (i__8724__auto___49055 + (1));
i__8724__auto___49055 = G__49056;
continue;
} else {
}
break;
}

var argseq__8731__auto__ = ((((1) < args__8730__auto__.length))?(new cljs.core.IndexedSeq(args__8730__auto__.slice((1)),(0),null)):null);
return untangled.ui.elements.ui_fader.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8731__auto__);
});

untangled.ui.elements.ui_fader.cljs$core$IFn$_invoke$arity$variadic = (function (p__49051,children){
var map__49052 = p__49051;
var map__49052__$1 = ((((!((map__49052 == null)))?((((map__49052.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49052.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49052):map__49052);
var props = map__49052__$1;
var inline_QMARK_ = cljs.core.get.call(null,map__49052__$1,new cljs.core.Keyword(null,"inline?","inline?",-1674483791));
var visible = cljs.core.get.call(null,map__49052__$1,new cljs.core.Keyword(null,"visible","visible",-1024216805));
var className = (function (){var or__7502__auto__ = new cljs.core.Keyword(null,"className","className",-1983287057).cljs$core$IFn$_invoke$arity$1(props);
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
return "";
}
})();
var classes = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(className),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" u-fade-out"),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(visible)?" u-fade-in":null))].join('');
var wrapper = (cljs.core.truth_(inline_QMARK_)?om.dom.span:om.dom.div);
var attrs = cljs.core.clj__GT_js.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,props,new cljs.core.Keyword(null,"visible","visible",-1024216805)),new cljs.core.Keyword(null,"className","className",-1983287057),classes));
return cljs.core.apply.call(null,wrapper,attrs,children);
});

untangled.ui.elements.ui_fader.cljs$lang$maxFixedArity = (1);

untangled.ui.elements.ui_fader.cljs$lang$applyTo = (function (seq49049){
var G__49050 = cljs.core.first.call(null,seq49049);
var seq49049__$1 = cljs.core.next.call(null,seq49049);
return untangled.ui.elements.ui_fader.cljs$core$IFn$_invoke$arity$variadic(G__49050,seq49049__$1);
});

/**
 * Returns the react-instance (which is logically true) iff the given react instance is an instance of the given react class.
 *   Otherwise returns nil.
 */
untangled.ui.elements.react_instance_QMARK_ = (function untangled$ui$elements$react_instance_QMARK_(react_class,react_instance){
if(cljs.core.truth_(react_class)){
} else {
throw (new Error("Assert failed: react-class"));
}

if(cljs.core.truth_(react_instance)){
} else {
throw (new Error("Assert failed: react-instance"));
}

if(cljs.core._EQ_.call(null,react_instance.type,react_class)){
return react_instance;
} else {
return null;
}
});
/**
 * Finds (and returns) the first child that is an instance of the given React class (or nil if not found).
 */
untangled.ui.elements.first_node = (function untangled$ui$elements$first_node(react_class,sequence_of_react_instances){
return cljs.core.some.call(null,(function (p1__49057_SHARP_){
return untangled.ui.elements.react_instance_QMARK_.call(null,react_class,p1__49057_SHARP_);
}),sequence_of_react_instances);
});
untangled.ui.elements.update_frame_content = (function untangled$ui$elements$update_frame_content(this$,child){
var frame_component = om.next.get_state.call(null,this$,new cljs.core.Keyword(null,"frame-component","frame-component",-1147234187));
if(cljs.core.truth_(frame_component)){
return ReactDOM.render(child,frame_component);
} else {
return null;
}
});
/**
 * @constructor
 */
untangled.ui.elements.IFrame = (function untangled$ui$elements$IFrame(){
var this__37311__auto__ = this;
React.Component.apply(this__37311__auto__,arguments);

if(!((this__37311__auto__.initLocalState == null))){
this__37311__auto__.state = this__37311__auto__.initLocalState();
} else {
this__37311__auto__.state = {};
}

return this__37311__auto__;
});

untangled.ui.elements.IFrame.prototype = goog.object.clone(React.Component.prototype);

var x49062_49074 = untangled.ui.elements.IFrame.prototype;
x49062_49074.componentWillUpdate = ((function (x49062_49074){
return (function (next_props__37157__auto__,next_state__37158__auto__){
var this__37156__auto__ = this;
if(((!((this__37156__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__37156__auto__.om$next$Ident$)))?true:false):false)){
var ident__37160__auto___49075 = om.next.ident.call(null,this__37156__auto__,om.next.props.call(null,this__37156__auto__));
var next_ident__37161__auto___49076 = om.next.ident.call(null,this__37156__auto__,om.next._next_props.call(null,next_props__37157__auto__,this__37156__auto__));
if(cljs.core.not_EQ_.call(null,ident__37160__auto___49075,next_ident__37161__auto___49076)){
var idxr__37162__auto___49077 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__37162__auto___49077 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__37162__auto___49077),((function (idxr__37162__auto___49077,ident__37160__auto___49075,next_ident__37161__auto___49076,this__37156__auto__,x49062_49074){
return (function (indexes__37163__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__37163__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__37160__auto___49075], null),cljs.core.disj,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__37161__auto___49076], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__37156__auto__);
});})(idxr__37162__auto___49077,ident__37160__auto___49075,next_ident__37161__auto___49076,this__37156__auto__,x49062_49074))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__37156__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__37156__auto__);
});})(x49062_49074))
;

x49062_49074.shouldComponentUpdate = ((function (x49062_49074){
return (function (next_props__37157__auto__,next_state__37158__auto__){
var this__37156__auto__ = this;
var next_children__37159__auto__ = next_props__37157__auto__.children;
var next_props__37157__auto____$1 = goog.object.get(next_props__37157__auto__,"omcljs$value");
var next_props__37157__auto____$2 = (function (){var G__49064 = next_props__37157__auto____$1;
if((next_props__37157__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__49064);
} else {
return G__49064;
}
})();
var or__7502__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__37156__auto__),next_props__37157__auto____$2);
if(or__7502__auto__){
return or__7502__auto__;
} else {
var or__7502__auto____$1 = (function (){var and__7490__auto__ = this__37156__auto__.state;
if(cljs.core.truth_(and__7490__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__37156__auto__.state,"omcljs$state"),goog.object.get(next_state__37158__auto__,"omcljs$state"));
} else {
return and__7490__auto__;
}
})();
if(cljs.core.truth_(or__7502__auto____$1)){
return or__7502__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__37156__auto__.props.children,next_children__37159__auto__);
}
}
});})(x49062_49074))
;

x49062_49074.componentWillUnmount = ((function (x49062_49074){
return (function (){
var this__37156__auto__ = this;
var r__37167__auto__ = om.next.get_reconciler.call(null,this__37156__auto__);
var cfg__37168__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__37167__auto__);
var st__37169__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__37168__auto__);
var indexer__37166__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__37168__auto__);
if(cljs.core.truth_((function (){var and__7490__auto__ = !((st__37169__auto__ == null));
if(and__7490__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__37169__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__37156__auto__], null));
} else {
return and__7490__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__37169__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__37156__auto__);
} else {
}

if((indexer__37166__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__37166__auto__,this__37156__auto__);
}
});})(x49062_49074))
;

x49062_49074.isMounted = ((function (x49062_49074){
return (function (){
var this__37156__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__37156__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x49062_49074))
;

x49062_49074.componentWillMount = ((function (x49062_49074){
return (function (){
var this__37156__auto__ = this;
var indexer__37166__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__37166__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__37166__auto__,this__37156__auto__);
}
});})(x49062_49074))
;

x49062_49074.initLocalState = ((function (x49062_49074){
return (function (){
var this$ = this;
var ret__37134__auto__ = new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"border","border",1444987323),(0)], null);
var obj49066 = {"omcljs$state":ret__37134__auto__};
return obj49066;
});})(x49062_49074))
;

x49062_49074.componentDidMount = ((function (x49062_49074){
return (function (){
var this$ = this;
var frame_body = ReactDOM.findDOMNode(this$).contentDocument.body;
var child = new cljs.core.Keyword(null,"child","child",623967545).cljs$core$IFn$_invoke$arity$1(om.next.props.call(null,this$));
var e1 = document.createElement("div");
frame_body.appendChild(e1);

om.next.update_state_BANG_.call(null,this$,cljs.core.assoc,new cljs.core.Keyword(null,"frame-component","frame-component",-1147234187),e1);

return untangled.ui.elements.update_frame_content.call(null,this$,child);
});})(x49062_49074))
;

x49062_49074.componentDidUpdate = ((function (x49062_49074){
return (function (prev_props__37146__auto__,prev_state__37147__auto__){
var this__37145__auto__ = this;
var this$ = this__37145__auto__;
var pprops = om.next._prev_props.call(null,prev_props__37146__auto__,this__37145__auto__);
var pstate = goog.object.get(prev_state__37147__auto__,"omcljs$previousState");
var child_49078 = new cljs.core.Keyword(null,"child","child",623967545).cljs$core$IFn$_invoke$arity$1(om.next.props.call(null,this$));
untangled.ui.elements.update_frame_content.call(null,this$,child_49078);

return om.next.clear_prev_props_BANG_.call(null,this__37145__auto__);
});})(x49062_49074))
;

x49062_49074.render = ((function (x49062_49074){
return (function (){
var this__37155__auto__ = this;
var this$ = this__37155__auto__;
var _STAR_reconciler_STAR_49067 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_49068 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_49069 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_49070 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_49071 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__37155__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__37155__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__37155__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__37155__auto__);

om.next._STAR_parent_STAR_ = this__37155__auto__;

try{return om.dom.iframe.call(null,cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,om.next.props.call(null,this$),new cljs.core.Keyword(null,"child","child",623967545))));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_49071;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_49070;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_49069;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_49068;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_49067;
}});})(x49062_49074))
;


untangled.ui.elements.IFrame.prototype.constructor = untangled.ui.elements.IFrame;

untangled.ui.elements.IFrame.prototype.constructor.displayName = "untangled.ui.elements/IFrame";

untangled.ui.elements.IFrame.prototype.om$isComponent = true;

var x49072_49079 = untangled.ui.elements.IFrame;


var x49073_49080 = untangled.ui.elements.IFrame.prototype;


untangled.ui.elements.IFrame.cljs$lang$type = true;

untangled.ui.elements.IFrame.cljs$lang$ctorStr = "untangled.ui.elements/IFrame";

untangled.ui.elements.IFrame.cljs$lang$ctorPrWriter = (function (this__37314__auto__,writer__37315__auto__,opt__37316__auto__){
return cljs.core._write.call(null,writer__37315__auto__,"untangled.ui.elements/IFrame");
});
untangled.ui.elements.ui_iframe = (function untangled$ui$elements$ui_iframe(props,child){
return om.next.factory.call(null,untangled.ui.elements.IFrame).call(null,cljs.core.assoc.call(null,props,new cljs.core.Keyword(null,"child","child",623967545),child));
});
/**
 * Render an icon or a short string within an avatar. Normal HTML/React attributes can be included, and should be a cljs map (not a js object).
 * 
 *   `:color` - :none (default), :primary, :accent
 *   `:size` - :regular (default), :medium, :large, :xlarge:, :huge
 *   `:kind` - :none (default), :bordered
 *   
 */
untangled.ui.elements.ui_avatar = (function untangled$ui$elements$ui_avatar(p__49081,child){
var map__49085 = p__49081;
var map__49085__$1 = ((((!((map__49085 == null)))?((((map__49085.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49085.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49085):map__49085);
var props = map__49085__$1;
var className = cljs.core.get.call(null,map__49085__$1,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var color = cljs.core.get.call(null,map__49085__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var size = cljs.core.get.call(null,map__49085__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var kind = cljs.core.get.call(null,map__49085__$1,new cljs.core.Keyword(null,"kind","kind",-717265803));
var legal_colors = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"primary","primary",817773892),null,new cljs.core.Keyword(null,"accent","accent",-1826298468),null], null), null);
var legal_sizes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"large","large",-196820544),null,new cljs.core.Keyword(null,"huge","huge",1683634816),null,new cljs.core.Keyword(null,"xlarge","xlarge",-905930014),null,new cljs.core.Keyword(null,"medium","medium",-1864319384),null], null), null);
var legal_kinds = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"bordered","bordered",-832486681),null], null), null);
var user_classes = cljs.core.get.call(null,props,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var classes = (function (){var G__49087 = user_classes;
var G__49087__$1 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49087),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-avatar")].join('')
;
var G__49087__$2 = ((cljs.core.contains_QMARK_.call(null,legal_colors,color))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49087__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-avatar--"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,color))].join(''):G__49087__$1);
var G__49087__$3 = ((cljs.core.contains_QMARK_.call(null,legal_sizes,size))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49087__$2),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-avatar--"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,size))].join(''):G__49087__$2);
if(cljs.core.contains_QMARK_.call(null,legal_kinds,kind)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49087__$3),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-avatar--"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,kind))].join('');
} else {
return G__49087__$3;
}
})();
var props__$1 = cljs.core.dissoc.call(null,cljs.core.assoc.call(null,props,new cljs.core.Keyword(null,"className","className",-1983287057),classes),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"kind","kind",-717265803));
return om.dom.span.call(null,cljs.core.clj__GT_js.call(null,props__$1),child);
});
/**
 * Render the given children within a badge. Normal HTML/React attributes can be included, and should be a cljs map (not a js object).
 * 
 *   `(ui-badge {} "7")`
 *   
 */
untangled.ui.elements.ui_badge = (function untangled$ui$elements$ui_badge(var_args){
var args__8730__auto__ = [];
var len__8723__auto___49093 = arguments.length;
var i__8724__auto___49094 = (0);
while(true){
if((i__8724__auto___49094 < len__8723__auto___49093)){
args__8730__auto__.push((arguments[i__8724__auto___49094]));

var G__49095 = (i__8724__auto___49094 + (1));
i__8724__auto___49094 = G__49095;
continue;
} else {
}
break;
}

var argseq__8731__auto__ = ((((1) < args__8730__auto__.length))?(new cljs.core.IndexedSeq(args__8730__auto__.slice((1)),(0),null)):null);
return untangled.ui.elements.ui_badge.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8731__auto__);
});

untangled.ui.elements.ui_badge.cljs$core$IFn$_invoke$arity$variadic = (function (p__49090,children){
var map__49091 = p__49090;
var map__49091__$1 = ((((!((map__49091 == null)))?((((map__49091.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49091.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49091):map__49091);
var props = map__49091__$1;
var className = cljs.core.get.call(null,map__49091__$1,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var props__$1 = cljs.core.update.call(null,props,new cljs.core.Keyword(null,"className","className",-1983287057),cljs.core.str," c-badge");
return cljs.core.apply.call(null,om.dom.span,cljs.core.clj__GT_js.call(null,props__$1),children);
});

untangled.ui.elements.ui_badge.cljs$lang$maxFixedArity = (1);

untangled.ui.elements.ui_badge.cljs$lang$applyTo = (function (seq49088){
var G__49089 = cljs.core.first.call(null,seq49088);
var seq49088__$1 = cljs.core.next.call(null,seq49088);
return untangled.ui.elements.ui_badge.cljs$core$IFn$_invoke$arity$variadic(G__49089,seq49088__$1);
});

/**
 * Render a button that looks more like a link that a button (it is just the children), but renders the hover shape
 *   of a more traditional button when the mouse is over it.
 * 
 *   `:color` - :neutral (default), :primary, :accent
 *   `:shape` - :rect (default), :round, or :wide.  The shape when the mouse is over the button.
 *   `:size` - :normal (default), :small.  Small buttons are a bit more condensed.
 *   `:active` - true or false (default).  Causes the button to look highlighted.
 * 
 *   Any normal HTML/React properties are allowed, including additional CSS classes.
 *   
 */
untangled.ui.elements.ui_flat_button = (function untangled$ui$elements$ui_flat_button(var_args){
var args__8730__auto__ = [];
var len__8723__auto___49103 = arguments.length;
var i__8724__auto___49104 = (0);
while(true){
if((i__8724__auto___49104 < len__8723__auto___49103)){
args__8730__auto__.push((arguments[i__8724__auto___49104]));

var G__49105 = (i__8724__auto___49104 + (1));
i__8724__auto___49104 = G__49105;
continue;
} else {
}
break;
}

var argseq__8731__auto__ = ((((1) < args__8730__auto__.length))?(new cljs.core.IndexedSeq(args__8730__auto__.slice((1)),(0),null)):null);
return untangled.ui.elements.ui_flat_button.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8731__auto__);
});

untangled.ui.elements.ui_flat_button.cljs$core$IFn$_invoke$arity$variadic = (function (p__49098,children){
var map__49099 = p__49098;
var map__49099__$1 = ((((!((map__49099 == null)))?((((map__49099.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49099.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49099):map__49099);
var attrs = map__49099__$1;
var className = cljs.core.get.call(null,map__49099__$1,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var size = cljs.core.get.call(null,map__49099__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var color = cljs.core.get.call(null,map__49099__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var shape = cljs.core.get.call(null,map__49099__$1,new cljs.core.Keyword(null,"shape","shape",1190694006));
var disabled = cljs.core.get.call(null,map__49099__$1,new cljs.core.Keyword(null,"disabled","disabled",-1529784218));
var active = cljs.core.get.call(null,map__49099__$1,new cljs.core.Keyword(null,"active","active",1895962068));
var legal_colors = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"primary","primary",817773892),null,new cljs.core.Keyword(null,"accent","accent",-1826298468),null], null), null);
var legal_shapes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"round","round",2009433328),null,new cljs.core.Keyword(null,"wide","wide",-151772487),null], null), null);
var legal_sizes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"small","small",2133478704),null], null), null);
var button_label = ((function (legal_colors,legal_shapes,legal_sizes,map__49099,map__49099__$1,attrs,className,size,color,shape,disabled,active){
return (function (text){
return om.dom.span.call(null,({"className": "c-button__content"}),text);
});})(legal_colors,legal_shapes,legal_sizes,map__49099,map__49099__$1,attrs,className,size,color,shape,disabled,active))
;
var fixed_children = cljs.core.map.call(null,((function (legal_colors,legal_shapes,legal_sizes,button_label,map__49099,map__49099__$1,attrs,className,size,color,shape,disabled,active){
return (function (c){
if(typeof c === 'string'){
return button_label.call(null,c);
} else {
return c;
}
});})(legal_colors,legal_shapes,legal_sizes,button_label,map__49099,map__49099__$1,attrs,className,size,color,shape,disabled,active))
,children);
var classes = (function (){var G__49101 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(className),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-button")].join('');
var G__49101__$1 = (cljs.core.truth_(active)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49101),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" is-active")].join(''):G__49101);
var G__49101__$2 = ((cljs.core.contains_QMARK_.call(null,legal_colors,color))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49101__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-button--"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,color))].join(''):G__49101__$1);
var G__49101__$3 = ((cljs.core.contains_QMARK_.call(null,legal_shapes,shape))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49101__$2),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-button--"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,shape))].join(''):G__49101__$2);
if(cljs.core.contains_QMARK_.call(null,legal_sizes,size)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49101__$3),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-button--"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,size))].join('');
} else {
return G__49101__$3;
}
})();
var attrs__$1 = (function (){var G__49102 = cljs.core.assoc.call(null,attrs,new cljs.core.Keyword(null,"className","className",-1983287057),classes,new cljs.core.Keyword(null,"type","type",1174270348),"button");
var G__49102__$1 = (cljs.core.truth_(disabled)?cljs.core.assoc.call(null,G__49102,new cljs.core.Keyword(null,"aria-disabled","aria-disabled",-667357160),"true"):G__49102);
return cljs.core.dissoc.call(null,G__49102__$1,new cljs.core.Keyword(null,"active","active",1895962068),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"shape","shape",1190694006),new cljs.core.Keyword(null,"size","size",1098693007));

})();
return cljs.core.apply.call(null,om.dom.button,cljs.core.clj__GT_js.call(null,attrs__$1),fixed_children);
});

untangled.ui.elements.ui_flat_button.cljs$lang$maxFixedArity = (1);

untangled.ui.elements.ui_flat_button.cljs$lang$applyTo = (function (seq49096){
var G__49097 = cljs.core.first.call(null,seq49096);
var seq49096__$1 = cljs.core.next.call(null,seq49096);
return untangled.ui.elements.ui_flat_button.cljs$core$IFn$_invoke$arity$variadic(G__49097,seq49096__$1);
});

/**
 * Render a raised button. Props is a normal clj(s) map with React/HTML attributes plus:
 * 
 *   `:color` - :neutral (default), :primary, :accent
 *   `:shape` - :rect (default), :round, or :wide
 *   `:size` - :normal (default), :small
 *   `:active` - true or false (default), Causes the button to look highlighted.
 * 
 *   Any other React properties are allowed, including additional CSS classes.
 *   
 */
untangled.ui.elements.ui_button = (function untangled$ui$elements$ui_button(var_args){
var args__8730__auto__ = [];
var len__8723__auto___49111 = arguments.length;
var i__8724__auto___49112 = (0);
while(true){
if((i__8724__auto___49112 < len__8723__auto___49111)){
args__8730__auto__.push((arguments[i__8724__auto___49112]));

var G__49113 = (i__8724__auto___49112 + (1));
i__8724__auto___49112 = G__49113;
continue;
} else {
}
break;
}

var argseq__8731__auto__ = ((((1) < args__8730__auto__.length))?(new cljs.core.IndexedSeq(args__8730__auto__.slice((1)),(0),null)):null);
return untangled.ui.elements.ui_button.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8731__auto__);
});

untangled.ui.elements.ui_button.cljs$core$IFn$_invoke$arity$variadic = (function (p__49108,children){
var map__49109 = p__49108;
var map__49109__$1 = ((((!((map__49109 == null)))?((((map__49109.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49109.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49109):map__49109);
var props = map__49109__$1;
var className = cljs.core.get.call(null,map__49109__$1,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var size = cljs.core.get.call(null,map__49109__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var color = cljs.core.get.call(null,map__49109__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var shape = cljs.core.get.call(null,map__49109__$1,new cljs.core.Keyword(null,"shape","shape",1190694006));
var disabled = cljs.core.get.call(null,map__49109__$1,new cljs.core.Keyword(null,"disabled","disabled",-1529784218));
var active = cljs.core.get.call(null,map__49109__$1,new cljs.core.Keyword(null,"active","active",1895962068));
return cljs.core.apply.call(null,untangled.ui.elements.ui_flat_button,cljs.core.update.call(null,props,new cljs.core.Keyword(null,"className","className",-1983287057),cljs.core.str," c-button--raised"),children);
});

untangled.ui.elements.ui_button.cljs$lang$maxFixedArity = (1);

untangled.ui.elements.ui_button.cljs$lang$applyTo = (function (seq49106){
var G__49107 = cljs.core.first.call(null,seq49106);
var seq49106__$1 = cljs.core.next.call(null,seq49106);
return untangled.ui.elements.ui_button.cljs$core$IFn$_invoke$arity$variadic(G__49107,seq49106__$1);
});

/**
 * Render a raised circle button of fixed size (configurable in CSS variables, see CSS guide).
 *   Extra content will overflow out of the cirle. Props is a normal clj(s) map with React/HTML attributes plus:
 * 
 *   `:color` - :neutral (default), :primary, :accent
 *   `:size` - :normal (default), :small
 *   `:active` - true or false (default), Causes the button to look highlighted.
 * 
 *   Any other React properties are allowed, including additional CSS classes.
 * 
 *   Note that you will typically only be able to fit something like an icon in this kind of button, which is a perfect
 *   circle.
 *   
 */
untangled.ui.elements.ui_circular_button = (function untangled$ui$elements$ui_circular_button(var_args){
var args__8730__auto__ = [];
var len__8723__auto___49119 = arguments.length;
var i__8724__auto___49120 = (0);
while(true){
if((i__8724__auto___49120 < len__8723__auto___49119)){
args__8730__auto__.push((arguments[i__8724__auto___49120]));

var G__49121 = (i__8724__auto___49120 + (1));
i__8724__auto___49120 = G__49121;
continue;
} else {
}
break;
}

var argseq__8731__auto__ = ((((1) < args__8730__auto__.length))?(new cljs.core.IndexedSeq(args__8730__auto__.slice((1)),(0),null)):null);
return untangled.ui.elements.ui_circular_button.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8731__auto__);
});

untangled.ui.elements.ui_circular_button.cljs$core$IFn$_invoke$arity$variadic = (function (p__49116,children){
var map__49117 = p__49116;
var map__49117__$1 = ((((!((map__49117 == null)))?((((map__49117.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49117.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49117):map__49117);
var props = map__49117__$1;
var className = cljs.core.get.call(null,map__49117__$1,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var size = cljs.core.get.call(null,map__49117__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var color = cljs.core.get.call(null,map__49117__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var disabled = cljs.core.get.call(null,map__49117__$1,new cljs.core.Keyword(null,"disabled","disabled",-1529784218));
var active = cljs.core.get.call(null,map__49117__$1,new cljs.core.Keyword(null,"active","active",1895962068));
return cljs.core.apply.call(null,untangled.ui.elements.ui_flat_button,cljs.core.update.call(null,props,new cljs.core.Keyword(null,"className","className",-1983287057),cljs.core.str," c-button--circular"),children);
});

untangled.ui.elements.ui_circular_button.cljs$lang$maxFixedArity = (1);

untangled.ui.elements.ui_circular_button.cljs$lang$applyTo = (function (seq49114){
var G__49115 = cljs.core.first.call(null,seq49114);
var seq49114__$1 = cljs.core.next.call(null,seq49114);
return untangled.ui.elements.ui_circular_button.cljs$core$IFn$_invoke$arity$variadic(G__49115,seq49114__$1);
});

/**
 * Render a card component
 * 
 * `:title` - "Some Title"
 * `:color` - :primary | :accent
 * `:kind` - :bordered | :transparent | :square
 * `:size` - :expand | :wide
 * `:image` - "path/to/image/file.jpeg"
 * `:image-position` - :cover | :top-left | :top-right | :bottom-left | :bottom-right
 * `:actions` - (ui-button "Some Action")
 * `:media` - URL
 * `:media-type` - :image | :video (TODO Youtube?)
 * 
 * all paramters optional
 *  
 */
untangled.ui.elements.ui_card = (function untangled$ui$elements$ui_card(var_args){
var args__8730__auto__ = [];
var len__8723__auto___49128 = arguments.length;
var i__8724__auto___49129 = (0);
while(true){
if((i__8724__auto___49129 < len__8723__auto___49128)){
args__8730__auto__.push((arguments[i__8724__auto___49129]));

var G__49130 = (i__8724__auto___49129 + (1));
i__8724__auto___49129 = G__49130;
continue;
} else {
}
break;
}

var argseq__8731__auto__ = ((((1) < args__8730__auto__.length))?(new cljs.core.IndexedSeq(args__8730__auto__.slice((1)),(0),null)):null);
return untangled.ui.elements.ui_card.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8731__auto__);
});

untangled.ui.elements.ui_card.cljs$core$IFn$_invoke$arity$variadic = (function (p__49124,children){
var map__49125 = p__49124;
var map__49125__$1 = ((((!((map__49125 == null)))?((((map__49125.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49125.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49125):map__49125);
var attrs = map__49125__$1;
var media = cljs.core.get.call(null,map__49125__$1,new cljs.core.Keyword(null,"media","media",-1066138403));
var menu = cljs.core.get.call(null,map__49125__$1,new cljs.core.Keyword(null,"menu","menu",352255198));
var media_type = cljs.core.get.call(null,map__49125__$1,new cljs.core.Keyword(null,"media-type","media-type",-764436129));
var color = cljs.core.get.call(null,map__49125__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var actions = cljs.core.get.call(null,map__49125__$1,new cljs.core.Keyword(null,"actions","actions",-812656882));
var title = cljs.core.get.call(null,map__49125__$1,new cljs.core.Keyword(null,"title","title",636505583));
var className = cljs.core.get.call(null,map__49125__$1,new cljs.core.Keyword(null,"className","className",-1983287057));
var size = cljs.core.get.call(null,map__49125__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var kind = cljs.core.get.call(null,map__49125__$1,new cljs.core.Keyword(null,"kind","kind",-717265803));
var image_position = cljs.core.get.call(null,map__49125__$1,new cljs.core.Keyword(null,"image-position","image-position",-2131640298));
var image = cljs.core.get.call(null,map__49125__$1,new cljs.core.Keyword(null,"image","image",-58725096));
if(((kind == null)) || ((kind instanceof cljs.core.Keyword))){
} else {
throw (new Error("Assert failed: (or (nil? kind) (keyword? kind))"));
}

if(((title == null)) || (typeof title === 'string')){
} else {
throw (new Error("Assert failed: (or (nil? title) (string? title))"));
}

var legal_kinds = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"transparent","transparent",-2073609949),null,new cljs.core.Keyword(null,"bordered","bordered",-832486681),null,new cljs.core.Keyword(null,"square","square",812434677),null], null), null);
var legal_colors = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"primary","primary",817773892),null,new cljs.core.Keyword(null,"accent","accent",-1826298468),null], null), null);
var legal_sizes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"wide","wide",-151772487),null,new cljs.core.Keyword(null,"expand","expand",595248157),null], null), null);
var id_class = cljs.core.gensym.call(null,"c-card--");
var className__$1 = (function (){var or__7502__auto__ = className;
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
return "";
}
})();
var classes = (function (){var G__49127 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("c-card "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(id_class),cljs.core.str.cljs$core$IFn$_invoke$arity$1(className__$1)].join('');
var G__49127__$1 = ((cljs.core.contains_QMARK_.call(null,legal_kinds,kind))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49127),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-card--"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,kind))].join(''):G__49127);
var G__49127__$2 = ((cljs.core.contains_QMARK_.call(null,legal_colors,color))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49127__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-card--"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,color))].join(''):G__49127__$1);
if(cljs.core.contains_QMARK_.call(null,legal_sizes,size)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49127__$2),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-card--"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,size))].join('');
} else {
return G__49127__$2;
}
})();
var attributes = cljs.core.clj__GT_js.call(null,cljs.core.dissoc.call(null,cljs.core.merge.call(null,attrs,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"className","className",-1983287057),classes], null)),new cljs.core.Keyword(null,"title","title",636505583),new cljs.core.Keyword(null,"kind","kind",-717265803),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"actions","actions",-812656882),new cljs.core.Keyword(null,"image","image",-58725096),new cljs.core.Keyword(null,"image-position","image-position",-2131640298),new cljs.core.Keyword(null,"media-type","media-type",-764436129),new cljs.core.Keyword(null,"media","media",-1066138403),new cljs.core.Keyword(null,"menu","menu",352255198)));
var image_src = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("url("),cljs.core.str.cljs$core$IFn$_invoke$arity$1(image),cljs.core.str.cljs$core$IFn$_invoke$arity$1(")")].join('');
var background_image = cljs.core.clj__GT_js.call(null,(cljs.core.truth_(image)?cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"backgroundImage","backgroundImage",1109094965),image_src], null)):null));
return om.dom.div.call(null,attributes,(cljs.core.truth_(media)?om.dom.div.call(null,({"className": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("c-card__media")].join('')}),((cljs.core._EQ_.call(null,media_type,new cljs.core.Keyword(null,"image","image",-58725096)))?om.dom.img.call(null,({"className": "c-card__media-content", "src": media})):null)):null),(cljs.core.truth_(title)?om.dom.div.call(null,({"className": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("c-card__title"),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(image)?" c-card__title--image":null)),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(image_position)?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-card__title--image-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,image_position))].join(''):null))].join('')}),om.dom.h1.call(null,({"className": "c-card__title-text"}),title)):null),(cljs.core.truth_(children)?cljs.core.apply.call(null,om.dom.div,({"className": "c-card__supporting-text"}),children):null),(cljs.core.truth_(actions)?om.dom.div.call(null,({"className": "c-card__actions"}),actions):null),(cljs.core.truth_(menu)?om.dom.div.call(null,({"className": "c-card__menu"}),untangled.ui.menu.ui_menu.call(null,menu,new cljs.core.Keyword(null,"style","style",-496642736),new cljs.core.Keyword(null,"icon","icon",1679606541))):null),om.dom.style.call(null,null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("."),cljs.core.str.cljs$core$IFn$_invoke$arity$1(id_class),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" .c-card__title { background-image: url("),cljs.core.str.cljs$core$IFn$_invoke$arity$1(image),cljs.core.str.cljs$core$IFn$_invoke$arity$1("); }")].join('')));
});

untangled.ui.elements.ui_card.cljs$lang$maxFixedArity = (1);

untangled.ui.elements.ui_card.cljs$lang$applyTo = (function (seq49122){
var G__49123 = cljs.core.first.call(null,seq49122);
var seq49122__$1 = cljs.core.next.call(null,seq49122);
return untangled.ui.elements.ui_card.cljs$core$IFn$_invoke$arity$variadic(G__49123,seq49122__$1);
});

var render_input_49144 = (function (p__49131){
var map__49132 = p__49131;
var map__49132__$1 = ((((!((map__49132 == null)))?((((map__49132.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49132.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49132):map__49132);
var props = map__49132__$1;
var type = cljs.core.get.call(null,map__49132__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var id = cljs.core.get.call(null,map__49132__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
return om.dom.span.call(null,null,om.dom.input.call(null,cljs.core.clj__GT_js.call(null,props)),om.dom.label.call(null,({"htmlFor": id}),"\u00A0"));
});
/**
 * Render a HTML radio (without the label). Props is a normal clj(s) map with React/HTML attributes plus:
 * 
 *  `:className` - additional class stylings to apply to the top level of the checkbox
 *  `:id` - Required. A unique ID. Will not render correctly without one.
 *  
 */
untangled.ui.elements.ui_radio = ((function (render_input_49144){
return (function untangled$ui$elements$ui_radio(p__49134){
var map__49137 = p__49134;
var map__49137__$1 = ((((!((map__49137 == null)))?((((map__49137.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49137.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49137):map__49137);
var props = map__49137__$1;
var className = cljs.core.get.call(null,map__49137__$1,new cljs.core.Keyword(null,"className","className",-1983287057));
var id = cljs.core.get.call(null,map__49137__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
if(cljs.core.truth_(id)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("DOM ID is required on radio"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("id")].join('')));
}

var classes = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(className),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-radio")].join('');
var attrs = cljs.core.assoc.call(null,props,new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"className","className",-1983287057),classes);
return render_input_49144.call(null,attrs);
});})(render_input_49144))
;

/**
 * Render a checkbox (not the label). Props is a normal clj(s) map with React/HTML attributes plus:
 * 
 *  `:className` - additional class stylings to apply to the top level of the checkbox
 *  `:id` string - Unique DOM ID. Required for correct rendering.
 *  `:checked` - true, false, or :partial
 *  
 */
untangled.ui.elements.ui_checkbox = ((function (render_input_49144){
return (function untangled$ui$elements$ui_checkbox(p__49139){
var map__49142 = p__49139;
var map__49142__$1 = ((((!((map__49142 == null)))?((((map__49142.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49142.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49142):map__49142);
var props = map__49142__$1;
var id = cljs.core.get.call(null,map__49142__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var state = cljs.core.get.call(null,map__49142__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var checked = cljs.core.get.call(null,map__49142__$1,new cljs.core.Keyword(null,"checked","checked",-50955819));
var className = cljs.core.get.call(null,map__49142__$1,new cljs.core.Keyword(null,"className","className",-1983287057));
if(cljs.core.truth_(id)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("DOM ID is required on checkbox"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("id")].join('')));
}

var classes = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(className),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-checkbox"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(((cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"partial","partial",241141745),checked))?" is-indeterminate":null))].join('');
var checked__$1 = cljs.core.boolean$.call(null,checked);
var attrs = cljs.core.assoc.call(null,props,new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"checked","checked",-50955819),checked__$1,new cljs.core.Keyword(null,"className","className",-1983287057),classes);
return render_input_49144.call(null,attrs);
});})(render_input_49144))
;
/**
 * Render a checkbox (not the label). Props is a normal clj(s) map with React/HTML attributes plus:
 * 
 *  `:className` - additional class stylings to apply to the top level of the checkbox
 *  `:id` string - Unique DOM ID. Required for correct rendering.
 *  `:checked` - true, false, or :partial
 *  
 */
untangled.ui.elements.ui_switch = (function untangled$ui$elements$ui_switch(p__49145){
var map__49148 = p__49145;
var map__49148__$1 = ((((!((map__49148 == null)))?((((map__49148.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49148.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49148):map__49148);
var props = map__49148__$1;
var id = cljs.core.get.call(null,map__49148__$1,new cljs.core.Keyword(null,"id","id",-1388402092));
var state = cljs.core.get.call(null,map__49148__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var checked = cljs.core.get.call(null,map__49148__$1,new cljs.core.Keyword(null,"checked","checked",-50955819));
var className = cljs.core.get.call(null,map__49148__$1,new cljs.core.Keyword(null,"className","className",-1983287057));
var disabled = cljs.core.get.call(null,map__49148__$1,new cljs.core.Keyword(null,"disabled","disabled",-1529784218));
if(cljs.core.truth_(id)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("DOM ID is required on checkbox"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("id")].join('')));
}

var classes = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(className),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-switch__input")].join('');
var type = "checkbox";
var checked__$1 = cljs.core.boolean$.call(null,checked);
var attrs = cljs.core.assoc.call(null,props,new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"checked","checked",-50955819),checked__$1,new cljs.core.Keyword(null,"className","className",-1983287057),classes);
return om.dom.div.call(null,({"className": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("c-switch"),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(disabled)?" is-disabled":null))].join('')}),om.dom.input.call(null,cljs.core.clj__GT_js.call(null,attrs)),om.dom.label.call(null,({"className": "c-switch__paddle", "htmlFor": id, "aria-hidden": false})));
});
/**
 * Render an input field. Normal HTML/React attributes can be included, and should be a cljs map (not a js object).
 * 
 *   `:size` :regular (default), :small, :medium, :large
 *   `:state` :valid (default), :invalid, or :error
 *   
 */
untangled.ui.elements.ui_field = (function untangled$ui$elements$ui_field(p__49150,placeholder){
var map__49154 = p__49150;
var map__49154__$1 = ((((!((map__49154 == null)))?((((map__49154.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49154.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49154):map__49154);
var attrs = map__49154__$1;
var size = cljs.core.get.call(null,map__49154__$1,new cljs.core.Keyword(null,"size","size",1098693007),"");
var state = cljs.core.get.call(null,map__49154__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var type = cljs.core.get.call(null,map__49154__$1,new cljs.core.Keyword(null,"type","type",1174270348));
var legal_sizes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"large","large",-196820544),null,new cljs.core.Keyword(null,"medium","medium",-1864319384),null,new cljs.core.Keyword(null,"small","small",2133478704),null], null), null);
var legal_states = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"invalid","invalid",412869516),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
var user_classes = cljs.core.get.call(null,attrs,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var user_type = (cljs.core.truth_(type)?type:"text");
var has = ((function (legal_sizes,legal_states,user_classes,user_type,map__49154,map__49154__$1,attrs,size,state,type){
return (function (s){
return cljs.core.contains_QMARK_.call(null,state,s);
});})(legal_sizes,legal_states,user_classes,user_type,map__49154,map__49154__$1,attrs,size,state,type))
;
var classes = (function (){var G__49156 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(user_classes),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-field ")].join('');
var G__49156__$1 = ((cljs.core.contains_QMARK_.call(null,legal_sizes,size))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49156),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-field--"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,size))].join(''):G__49156);
if(cljs.core.contains_QMARK_.call(null,legal_states,state)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49156__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" is-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,state))].join('');
} else {
return G__49156__$1;
}
})();
var attrs__$1 = cljs.core.dissoc.call(null,cljs.core.assoc.call(null,attrs,new cljs.core.Keyword(null,"className","className",-1983287057),classes,new cljs.core.Keyword(null,"placeholder","placeholder",-104873083),cljs.core.name.call(null,placeholder),new cljs.core.Keyword(null,"aria-label","aria-label",455891514),cljs.core.name.call(null,placeholder),new cljs.core.Keyword(null,"type","type",1174270348),user_type),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"state","state",-1988618099));
return om.dom.input.call(null,cljs.core.clj__GT_js.call(null,attrs__$1));
});
/**
 * Render an icon. Normal HTML/React attributes can be included, and should be a cljs map (not a js object).
 * 
 *   `:color` :none (default), :active, :passive
 *   `:size` :regular (default), :small, :medium, :large, :xlarge, :huge
 *   `:glyph` - Instructs `ui-icon` to render an icon from the built-in set. See `untangled.icons/icon`.
 * 
 *   The child (optional) should be some kind of icon, for example the SVG generated by the `untangled.icons/icon` function.
 *   
 */
untangled.ui.elements.ui_icon = (function untangled$ui$elements$ui_icon(var_args){
var args49157 = [];
var len__8723__auto___49167 = arguments.length;
var i__8724__auto___49168 = (0);
while(true){
if((i__8724__auto___49168 < len__8723__auto___49167)){
args49157.push((arguments[i__8724__auto___49168]));

var G__49169 = (i__8724__auto___49168 + (1));
i__8724__auto___49168 = G__49169;
continue;
} else {
}
break;
}

var G__49159 = args49157.length;
switch (G__49159) {
case 1:
return untangled.ui.elements.ui_icon.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return untangled.ui.elements.ui_icon.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49157.length)].join('')));

}
});

untangled.ui.elements.ui_icon.cljs$core$IFn$_invoke$arity$1 = (function (p__49160){
var map__49161 = p__49160;
var map__49161__$1 = ((((!((map__49161 == null)))?((((map__49161.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49161.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49161):map__49161);
var props = map__49161__$1;
var className = cljs.core.get.call(null,map__49161__$1,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var color = cljs.core.get.call(null,map__49161__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var size = cljs.core.get.call(null,map__49161__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var glyph = cljs.core.get.call(null,map__49161__$1,new cljs.core.Keyword(null,"glyph","glyph",2119448117));
return untangled.ui.elements.ui_icon.call(null,props,null);
});

untangled.ui.elements.ui_icon.cljs$core$IFn$_invoke$arity$2 = (function (p__49163,child){
var map__49164 = p__49163;
var map__49164__$1 = ((((!((map__49164 == null)))?((((map__49164.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49164.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49164):map__49164);
var props = map__49164__$1;
var className = cljs.core.get.call(null,map__49164__$1,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var color = cljs.core.get.call(null,map__49164__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var size = cljs.core.get.call(null,map__49164__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var glyph = cljs.core.get.call(null,map__49164__$1,new cljs.core.Keyword(null,"glyph","glyph",2119448117));
var legal_colors = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"passive","passive",252884080),null,new cljs.core.Keyword(null,"active","active",1895962068),null], null), null);
var legal_sizes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"large","large",-196820544),null,new cljs.core.Keyword(null,"huge","huge",1683634816),null,new cljs.core.Keyword(null,"xlarge","xlarge",-905930014),null,new cljs.core.Keyword(null,"medium","medium",-1864319384),null,new cljs.core.Keyword(null,"small","small",2133478704),null], null), null);
var user_classes = cljs.core.get.call(null,props,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var classes = (function (){var G__49166 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(user_classes),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-icon")].join('');
var G__49166__$1 = ((cljs.core.contains_QMARK_.call(null,legal_colors,color))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49166),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" is-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,color))].join(''):G__49166);
if(cljs.core.contains_QMARK_.call(null,legal_sizes,size)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49166__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-icon--"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,size))].join('');
} else {
return G__49166__$1;
}
})();
var props__$1 = cljs.core.dissoc.call(null,cljs.core.assoc.call(null,props,new cljs.core.Keyword(null,"className","className",-1983287057),classes),new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"glyph","glyph",2119448117));
return om.dom.span.call(null,cljs.core.clj__GT_js.call(null,props__$1),(cljs.core.truth_(glyph)?untangled.icons.icon.call(null,glyph):child));
});

untangled.ui.elements.ui_icon.cljs$lang$maxFixedArity = 2;

/**
 * Render an icon bar using a vector of icons (each a map of attributes).
 * Can optionally render vertically and/or shifting.
 * Normal HTML/React attributes can be included, and should be a cljs map (not a js object).
 * 
 * `:orientation` :vertical or :horizontal (default)
 * `:shifting` true or false (default)
 * 
 * TODO: Example, talk about children
 * 
 * all parameters are optional
 * 
 */
untangled.ui.elements.ui_icon_bar = (function untangled$ui$elements$ui_icon_bar(var_args){
var args__8730__auto__ = [];
var len__8723__auto___49177 = arguments.length;
var i__8724__auto___49178 = (0);
while(true){
if((i__8724__auto___49178 < len__8723__auto___49177)){
args__8730__auto__.push((arguments[i__8724__auto___49178]));

var G__49179 = (i__8724__auto___49178 + (1));
i__8724__auto___49178 = G__49179;
continue;
} else {
}
break;
}

var argseq__8731__auto__ = ((((1) < args__8730__auto__.length))?(new cljs.core.IndexedSeq(args__8730__auto__.slice((1)),(0),null)):null);
return untangled.ui.elements.ui_icon_bar.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8731__auto__);
});

untangled.ui.elements.ui_icon_bar.cljs$core$IFn$_invoke$arity$variadic = (function (p__49173,children){
var map__49174 = p__49173;
var map__49174__$1 = ((((!((map__49174 == null)))?((((map__49174.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49174.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49174):map__49174);
var props = map__49174__$1;
var className = cljs.core.get.call(null,map__49174__$1,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var orientation = cljs.core.get.call(null,map__49174__$1,new cljs.core.Keyword(null,"orientation","orientation",623557579));
var shifting = cljs.core.get.call(null,map__49174__$1,new cljs.core.Keyword(null,"shifting","shifting",-1091369273));
var user_classes = cljs.core.get.call(null,props,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var top_level_class = (function (){var G__49176 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(user_classes),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-iconbar")].join('');
var G__49176__$1 = ((cljs.core._EQ_.call(null,orientation,new cljs.core.Keyword(null,"vertical","vertical",718696748)))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49176),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-iconbar--rail")].join(''):G__49176);
if(cljs.core.truth_(shifting)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49176__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-iconbar--shifting")].join('');
} else {
return G__49176__$1;
}
})();
return om.dom.div.call(null,({}),cljs.core.apply.call(null,om.dom.nav,({"className": top_level_class}),children));
});

untangled.ui.elements.ui_icon_bar.cljs$lang$maxFixedArity = (1);

untangled.ui.elements.ui_icon_bar.cljs$lang$applyTo = (function (seq49171){
var G__49172 = cljs.core.first.call(null,seq49171);
var seq49171__$1 = cljs.core.next.call(null,seq49171);
return untangled.ui.elements.ui_icon_bar.cljs$core$IFn$_invoke$arity$variadic(G__49172,seq49171__$1);
});

/**
 * Render an icon button for use inside an icon bar.
 * 
 *   `:glyph` - An icon glyph name to render that given icon.
 *   `:label` - A string to label that icon.
 *   `:active` true or false (default) - Usually used to show that your in that action's view.
 */
untangled.ui.elements.ui_icon_bar_item = (function untangled$ui$elements$ui_icon_bar_item(p__49180){
var map__49183 = p__49180;
var map__49183__$1 = ((((!((map__49183 == null)))?((((map__49183.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49183.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49183):map__49183);
var props = map__49183__$1;
var className = cljs.core.get.call(null,map__49183__$1,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var glyph = cljs.core.get.call(null,map__49183__$1,new cljs.core.Keyword(null,"glyph","glyph",2119448117));
var label = cljs.core.get.call(null,map__49183__$1,new cljs.core.Keyword(null,"label","label",1718410804),"");
var active = cljs.core.get.call(null,map__49183__$1,new cljs.core.Keyword(null,"active","active",1895962068));
return om.dom.button.call(null,({"className": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("c-iconbar__item "),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(active)?"is-active":null))].join(''), "type": "button"}),untangled.ui.elements.ui_icon.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"glyph","glyph",2119448117),glyph], null)),om.dom.span.call(null,({"className": "c-iconbar__label"}),label));
});
/**
 * Render the given children within a label. Normal HTML/React attributes can be included, and should be a cljs map (not a js object).
 * 
 *   `:color` :none (default), :primary, :accent
 *   
 */
untangled.ui.elements.ui_label = (function untangled$ui$elements$ui_label(var_args){
var args__8730__auto__ = [];
var len__8723__auto___49191 = arguments.length;
var i__8724__auto___49192 = (0);
while(true){
if((i__8724__auto___49192 < len__8723__auto___49191)){
args__8730__auto__.push((arguments[i__8724__auto___49192]));

var G__49193 = (i__8724__auto___49192 + (1));
i__8724__auto___49192 = G__49193;
continue;
} else {
}
break;
}

var argseq__8731__auto__ = ((((1) < args__8730__auto__.length))?(new cljs.core.IndexedSeq(args__8730__auto__.slice((1)),(0),null)):null);
return untangled.ui.elements.ui_label.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8731__auto__);
});

untangled.ui.elements.ui_label.cljs$core$IFn$_invoke$arity$variadic = (function (p__49187,children){
var map__49188 = p__49187;
var map__49188__$1 = ((((!((map__49188 == null)))?((((map__49188.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49188.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49188):map__49188);
var props = map__49188__$1;
var className = cljs.core.get.call(null,map__49188__$1,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var color = cljs.core.get.call(null,map__49188__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var legal_colors = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"primary","primary",817773892),null,new cljs.core.Keyword(null,"accent","accent",-1826298468),null], null), null);
var classes = (function (){var G__49190 = className;
var G__49190__$1 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49190),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-label")].join('')
;
if(cljs.core.contains_QMARK_.call(null,legal_colors,color)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49190__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-label--"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,color))].join('');
} else {
return G__49190__$1;
}
})();
var props__$1 = cljs.core.assoc.call(null,cljs.core.dissoc.call(null,props,new cljs.core.Keyword(null,"color","color",1011675173)),new cljs.core.Keyword(null,"className","className",-1983287057),classes);
return cljs.core.apply.call(null,om.dom.span,cljs.core.clj__GT_js.call(null,props__$1),children);
});

untangled.ui.elements.ui_label.cljs$lang$maxFixedArity = (1);

untangled.ui.elements.ui_label.cljs$lang$applyTo = (function (seq49185){
var G__49186 = cljs.core.first.call(null,seq49185);
var seq49185__$1 = cljs.core.next.call(null,seq49185);
return untangled.ui.elements.ui_label.cljs$core$IFn$_invoke$arity$variadic(G__49186,seq49185__$1);
});

/**
 * Render an icon or a short string within an avatar. Normal HTML/React attributes can be included, and should be a cljs map (not a js object).
 * 
 *   `:color` :none (default), :primary :accent
 */
untangled.ui.elements.ui_loader = (function untangled$ui$elements$ui_loader(p__49194){
var map__49198 = p__49194;
var map__49198__$1 = ((((!((map__49198 == null)))?((((map__49198.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49198.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49198):map__49198);
var props = map__49198__$1;
var className = cljs.core.get.call(null,map__49198__$1,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var color = cljs.core.get.call(null,map__49198__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var legal_colors = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"primary","primary",817773892),null,new cljs.core.Keyword(null,"accent","accent",-1826298468),null], null), null);
var user_classes = cljs.core.get.call(null,props,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var classes = (function (){var G__49200 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(user_classes),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-loader")].join('');
if(cljs.core.contains_QMARK_.call(null,legal_colors,color)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49200),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-loader--"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,color))].join('');
} else {
return G__49200;
}
})();
var props__$1 = cljs.core.dissoc.call(null,cljs.core.assoc.call(null,props,new cljs.core.Keyword(null,"className","className",-1983287057),classes,new cljs.core.Keyword(null,"aria-hidden","aria-hidden",399337029),false),new cljs.core.Keyword(null,"color","color",1011675173));
return om.dom.div.call(null,cljs.core.clj__GT_js.call(null,props__$1));
});
/**
 * Render the given children within a message. Normal HTML/React attributes can be included, and should be a cljs map (not a js object).
 * 
 *   `:color` :none(default), :alert, :success, :warning, :informative
 *   
 */
untangled.ui.elements.ui_message = (function untangled$ui$elements$ui_message(var_args){
var args__8730__auto__ = [];
var len__8723__auto___49207 = arguments.length;
var i__8724__auto___49208 = (0);
while(true){
if((i__8724__auto___49208 < len__8723__auto___49207)){
args__8730__auto__.push((arguments[i__8724__auto___49208]));

var G__49209 = (i__8724__auto___49208 + (1));
i__8724__auto___49208 = G__49209;
continue;
} else {
}
break;
}

var argseq__8731__auto__ = ((((1) < args__8730__auto__.length))?(new cljs.core.IndexedSeq(args__8730__auto__.slice((1)),(0),null)):null);
return untangled.ui.elements.ui_message.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8731__auto__);
});

untangled.ui.elements.ui_message.cljs$core$IFn$_invoke$arity$variadic = (function (p__49203,children){
var map__49204 = p__49203;
var map__49204__$1 = ((((!((map__49204 == null)))?((((map__49204.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49204.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49204):map__49204);
var props = map__49204__$1;
var className = cljs.core.get.call(null,map__49204__$1,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var color = cljs.core.get.call(null,map__49204__$1,new cljs.core.Keyword(null,"color","color",1011675173));
var legal_colors = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"primary","primary",817773892),null,new cljs.core.Keyword(null,"accent","accent",-1826298468),null], null), null);
var classes = (function (){var G__49206 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(className),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-message")].join('');
if(cljs.core.contains_QMARK_.call(null,legal_colors,color)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49206),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-message--"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,color))].join('');
} else {
return G__49206;
}
})();
var props__$1 = cljs.core.dissoc.call(null,cljs.core.assoc.call(null,props,new cljs.core.Keyword(null,"className","className",-1983287057),classes),new cljs.core.Keyword(null,"color","color",1011675173));
return cljs.core.apply.call(null,om.dom.div,cljs.core.clj__GT_js.call(null,props__$1),children);
});

untangled.ui.elements.ui_message.cljs$lang$maxFixedArity = (1);

untangled.ui.elements.ui_message.cljs$lang$applyTo = (function (seq49201){
var G__49202 = cljs.core.first.call(null,seq49201);
var seq49201__$1 = cljs.core.next.call(null,seq49201);
return untangled.ui.elements.ui_message.cljs$core$IFn$_invoke$arity$variadic(G__49202,seq49201__$1);
});

/**
 * @constructor
 */
untangled.ui.elements.DialogTitle = (function untangled$ui$elements$DialogTitle(){
var this__37311__auto__ = this;
React.Component.apply(this__37311__auto__,arguments);

if(!((this__37311__auto__.initLocalState == null))){
this__37311__auto__.state = this__37311__auto__.initLocalState();
} else {
this__37311__auto__.state = {};
}

return this__37311__auto__;
});

untangled.ui.elements.DialogTitle.prototype = goog.object.clone(React.Component.prototype);

var x49214_49224 = untangled.ui.elements.DialogTitle.prototype;
x49214_49224.componentWillUpdate = ((function (x49214_49224){
return (function (next_props__37157__auto__,next_state__37158__auto__){
var this__37156__auto__ = this;
if(((!((this__37156__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__37156__auto__.om$next$Ident$)))?true:false):false)){
var ident__37160__auto___49225 = om.next.ident.call(null,this__37156__auto__,om.next.props.call(null,this__37156__auto__));
var next_ident__37161__auto___49226 = om.next.ident.call(null,this__37156__auto__,om.next._next_props.call(null,next_props__37157__auto__,this__37156__auto__));
if(cljs.core.not_EQ_.call(null,ident__37160__auto___49225,next_ident__37161__auto___49226)){
var idxr__37162__auto___49227 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__37162__auto___49227 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__37162__auto___49227),((function (idxr__37162__auto___49227,ident__37160__auto___49225,next_ident__37161__auto___49226,this__37156__auto__,x49214_49224){
return (function (indexes__37163__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__37163__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__37160__auto___49225], null),cljs.core.disj,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__37161__auto___49226], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__37156__auto__);
});})(idxr__37162__auto___49227,ident__37160__auto___49225,next_ident__37161__auto___49226,this__37156__auto__,x49214_49224))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__37156__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__37156__auto__);
});})(x49214_49224))
;

x49214_49224.shouldComponentUpdate = ((function (x49214_49224){
return (function (next_props__37157__auto__,next_state__37158__auto__){
var this__37156__auto__ = this;
var next_children__37159__auto__ = next_props__37157__auto__.children;
var next_props__37157__auto____$1 = goog.object.get(next_props__37157__auto__,"omcljs$value");
var next_props__37157__auto____$2 = (function (){var G__49216 = next_props__37157__auto____$1;
if((next_props__37157__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__49216);
} else {
return G__49216;
}
})();
var or__7502__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__37156__auto__),next_props__37157__auto____$2);
if(or__7502__auto__){
return or__7502__auto__;
} else {
var or__7502__auto____$1 = (function (){var and__7490__auto__ = this__37156__auto__.state;
if(cljs.core.truth_(and__7490__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__37156__auto__.state,"omcljs$state"),goog.object.get(next_state__37158__auto__,"omcljs$state"));
} else {
return and__7490__auto__;
}
})();
if(cljs.core.truth_(or__7502__auto____$1)){
return or__7502__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__37156__auto__.props.children,next_children__37159__auto__);
}
}
});})(x49214_49224))
;

x49214_49224.componentWillUnmount = ((function (x49214_49224){
return (function (){
var this__37156__auto__ = this;
var r__37167__auto__ = om.next.get_reconciler.call(null,this__37156__auto__);
var cfg__37168__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__37167__auto__);
var st__37169__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__37168__auto__);
var indexer__37166__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__37168__auto__);
if(cljs.core.truth_((function (){var and__7490__auto__ = !((st__37169__auto__ == null));
if(and__7490__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__37169__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__37156__auto__], null));
} else {
return and__7490__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__37169__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__37156__auto__);
} else {
}

if((indexer__37166__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__37166__auto__,this__37156__auto__);
}
});})(x49214_49224))
;

x49214_49224.componentDidUpdate = ((function (x49214_49224){
return (function (prev_props__37164__auto__,prev_state__37165__auto__){
var this__37156__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__37156__auto__);
});})(x49214_49224))
;

x49214_49224.isMounted = ((function (x49214_49224){
return (function (){
var this__37156__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__37156__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x49214_49224))
;

x49214_49224.componentWillMount = ((function (x49214_49224){
return (function (){
var this__37156__auto__ = this;
var indexer__37166__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__37166__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__37166__auto__,this__37156__auto__);
}
});})(x49214_49224))
;

x49214_49224.render = ((function (x49214_49224){
return (function (){
var this__37155__auto__ = this;
var this$ = this__37155__auto__;
var _STAR_reconciler_STAR_49217 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_49218 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_49219 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_49220 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_49221 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__37155__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__37155__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__37155__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__37155__auto__);

om.next._STAR_parent_STAR_ = this__37155__auto__;

try{return om.dom.div.call(null,({"className": "c-dialog__title"}),om.next.children.call(null,this$));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_49221;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_49220;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_49219;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_49218;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_49217;
}});})(x49214_49224))
;


untangled.ui.elements.DialogTitle.prototype.constructor = untangled.ui.elements.DialogTitle;

untangled.ui.elements.DialogTitle.prototype.constructor.displayName = "untangled.ui.elements/DialogTitle";

untangled.ui.elements.DialogTitle.prototype.om$isComponent = true;

var x49222_49228 = untangled.ui.elements.DialogTitle;


var x49223_49229 = untangled.ui.elements.DialogTitle.prototype;


untangled.ui.elements.DialogTitle.cljs$lang$type = true;

untangled.ui.elements.DialogTitle.cljs$lang$ctorStr = "untangled.ui.elements/DialogTitle";

untangled.ui.elements.DialogTitle.cljs$lang$ctorPrWriter = (function (this__37314__auto__,writer__37315__auto__,opt__37316__auto__){
return cljs.core._write.call(null,writer__37315__auto__,"untangled.ui.elements/DialogTitle");
});
/**
 * Render a dialog's title (using supplied DOM children). Should only be used in a ui-dialog
 */
untangled.ui.elements.ui_dialog_title = om.next.factory.call(null,untangled.ui.elements.DialogTitle);
/**
 * @constructor
 */
untangled.ui.elements.DialogBody = (function untangled$ui$elements$DialogBody(){
var this__37311__auto__ = this;
React.Component.apply(this__37311__auto__,arguments);

if(!((this__37311__auto__.initLocalState == null))){
this__37311__auto__.state = this__37311__auto__.initLocalState();
} else {
this__37311__auto__.state = {};
}

return this__37311__auto__;
});

untangled.ui.elements.DialogBody.prototype = goog.object.clone(React.Component.prototype);

var x49234_49244 = untangled.ui.elements.DialogBody.prototype;
x49234_49244.componentWillUpdate = ((function (x49234_49244){
return (function (next_props__37157__auto__,next_state__37158__auto__){
var this__37156__auto__ = this;
if(((!((this__37156__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__37156__auto__.om$next$Ident$)))?true:false):false)){
var ident__37160__auto___49245 = om.next.ident.call(null,this__37156__auto__,om.next.props.call(null,this__37156__auto__));
var next_ident__37161__auto___49246 = om.next.ident.call(null,this__37156__auto__,om.next._next_props.call(null,next_props__37157__auto__,this__37156__auto__));
if(cljs.core.not_EQ_.call(null,ident__37160__auto___49245,next_ident__37161__auto___49246)){
var idxr__37162__auto___49247 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__37162__auto___49247 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__37162__auto___49247),((function (idxr__37162__auto___49247,ident__37160__auto___49245,next_ident__37161__auto___49246,this__37156__auto__,x49234_49244){
return (function (indexes__37163__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__37163__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__37160__auto___49245], null),cljs.core.disj,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__37161__auto___49246], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__37156__auto__);
});})(idxr__37162__auto___49247,ident__37160__auto___49245,next_ident__37161__auto___49246,this__37156__auto__,x49234_49244))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__37156__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__37156__auto__);
});})(x49234_49244))
;

x49234_49244.shouldComponentUpdate = ((function (x49234_49244){
return (function (next_props__37157__auto__,next_state__37158__auto__){
var this__37156__auto__ = this;
var next_children__37159__auto__ = next_props__37157__auto__.children;
var next_props__37157__auto____$1 = goog.object.get(next_props__37157__auto__,"omcljs$value");
var next_props__37157__auto____$2 = (function (){var G__49236 = next_props__37157__auto____$1;
if((next_props__37157__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__49236);
} else {
return G__49236;
}
})();
var or__7502__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__37156__auto__),next_props__37157__auto____$2);
if(or__7502__auto__){
return or__7502__auto__;
} else {
var or__7502__auto____$1 = (function (){var and__7490__auto__ = this__37156__auto__.state;
if(cljs.core.truth_(and__7490__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__37156__auto__.state,"omcljs$state"),goog.object.get(next_state__37158__auto__,"omcljs$state"));
} else {
return and__7490__auto__;
}
})();
if(cljs.core.truth_(or__7502__auto____$1)){
return or__7502__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__37156__auto__.props.children,next_children__37159__auto__);
}
}
});})(x49234_49244))
;

x49234_49244.componentWillUnmount = ((function (x49234_49244){
return (function (){
var this__37156__auto__ = this;
var r__37167__auto__ = om.next.get_reconciler.call(null,this__37156__auto__);
var cfg__37168__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__37167__auto__);
var st__37169__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__37168__auto__);
var indexer__37166__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__37168__auto__);
if(cljs.core.truth_((function (){var and__7490__auto__ = !((st__37169__auto__ == null));
if(and__7490__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__37169__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__37156__auto__], null));
} else {
return and__7490__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__37169__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__37156__auto__);
} else {
}

if((indexer__37166__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__37166__auto__,this__37156__auto__);
}
});})(x49234_49244))
;

x49234_49244.componentDidUpdate = ((function (x49234_49244){
return (function (prev_props__37164__auto__,prev_state__37165__auto__){
var this__37156__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__37156__auto__);
});})(x49234_49244))
;

x49234_49244.isMounted = ((function (x49234_49244){
return (function (){
var this__37156__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__37156__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x49234_49244))
;

x49234_49244.componentWillMount = ((function (x49234_49244){
return (function (){
var this__37156__auto__ = this;
var indexer__37166__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__37166__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__37166__auto__,this__37156__auto__);
}
});})(x49234_49244))
;

x49234_49244.render = ((function (x49234_49244){
return (function (){
var this__37155__auto__ = this;
var this$ = this__37155__auto__;
var _STAR_reconciler_STAR_49237 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_49238 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_49239 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_49240 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_49241 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__37155__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__37155__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__37155__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__37155__auto__);

om.next._STAR_parent_STAR_ = this__37155__auto__;

try{return om.dom.div.call(null,({"className": "c-dialog__content"}),om.next.children.call(null,this$));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_49241;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_49240;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_49239;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_49238;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_49237;
}});})(x49234_49244))
;


untangled.ui.elements.DialogBody.prototype.constructor = untangled.ui.elements.DialogBody;

untangled.ui.elements.DialogBody.prototype.constructor.displayName = "untangled.ui.elements/DialogBody";

untangled.ui.elements.DialogBody.prototype.om$isComponent = true;

var x49242_49248 = untangled.ui.elements.DialogBody;


var x49243_49249 = untangled.ui.elements.DialogBody.prototype;


untangled.ui.elements.DialogBody.cljs$lang$type = true;

untangled.ui.elements.DialogBody.cljs$lang$ctorStr = "untangled.ui.elements/DialogBody";

untangled.ui.elements.DialogBody.cljs$lang$ctorPrWriter = (function (this__37314__auto__,writer__37315__auto__,opt__37316__auto__){
return cljs.core._write.call(null,writer__37315__auto__,"untangled.ui.elements/DialogBody");
});
/**
 * Render the body of a dialog (using the supplied DOM children). Should only be used in a ui-dialog
 */
untangled.ui.elements.ui_dialog_body = om.next.factory.call(null,untangled.ui.elements.DialogBody);
/**
 * @constructor
 */
untangled.ui.elements.DialogActions = (function untangled$ui$elements$DialogActions(){
var this__37311__auto__ = this;
React.Component.apply(this__37311__auto__,arguments);

if(!((this__37311__auto__.initLocalState == null))){
this__37311__auto__.state = this__37311__auto__.initLocalState();
} else {
this__37311__auto__.state = {};
}

return this__37311__auto__;
});

untangled.ui.elements.DialogActions.prototype = goog.object.clone(React.Component.prototype);

var x49254_49264 = untangled.ui.elements.DialogActions.prototype;
x49254_49264.componentWillUpdate = ((function (x49254_49264){
return (function (next_props__37157__auto__,next_state__37158__auto__){
var this__37156__auto__ = this;
if(((!((this__37156__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__37156__auto__.om$next$Ident$)))?true:false):false)){
var ident__37160__auto___49265 = om.next.ident.call(null,this__37156__auto__,om.next.props.call(null,this__37156__auto__));
var next_ident__37161__auto___49266 = om.next.ident.call(null,this__37156__auto__,om.next._next_props.call(null,next_props__37157__auto__,this__37156__auto__));
if(cljs.core.not_EQ_.call(null,ident__37160__auto___49265,next_ident__37161__auto___49266)){
var idxr__37162__auto___49267 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__37162__auto___49267 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__37162__auto___49267),((function (idxr__37162__auto___49267,ident__37160__auto___49265,next_ident__37161__auto___49266,this__37156__auto__,x49254_49264){
return (function (indexes__37163__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__37163__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__37160__auto___49265], null),cljs.core.disj,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__37161__auto___49266], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__37156__auto__);
});})(idxr__37162__auto___49267,ident__37160__auto___49265,next_ident__37161__auto___49266,this__37156__auto__,x49254_49264))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__37156__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__37156__auto__);
});})(x49254_49264))
;

x49254_49264.shouldComponentUpdate = ((function (x49254_49264){
return (function (next_props__37157__auto__,next_state__37158__auto__){
var this__37156__auto__ = this;
var next_children__37159__auto__ = next_props__37157__auto__.children;
var next_props__37157__auto____$1 = goog.object.get(next_props__37157__auto__,"omcljs$value");
var next_props__37157__auto____$2 = (function (){var G__49256 = next_props__37157__auto____$1;
if((next_props__37157__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__49256);
} else {
return G__49256;
}
})();
var or__7502__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__37156__auto__),next_props__37157__auto____$2);
if(or__7502__auto__){
return or__7502__auto__;
} else {
var or__7502__auto____$1 = (function (){var and__7490__auto__ = this__37156__auto__.state;
if(cljs.core.truth_(and__7490__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__37156__auto__.state,"omcljs$state"),goog.object.get(next_state__37158__auto__,"omcljs$state"));
} else {
return and__7490__auto__;
}
})();
if(cljs.core.truth_(or__7502__auto____$1)){
return or__7502__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__37156__auto__.props.children,next_children__37159__auto__);
}
}
});})(x49254_49264))
;

x49254_49264.componentWillUnmount = ((function (x49254_49264){
return (function (){
var this__37156__auto__ = this;
var r__37167__auto__ = om.next.get_reconciler.call(null,this__37156__auto__);
var cfg__37168__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__37167__auto__);
var st__37169__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__37168__auto__);
var indexer__37166__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__37168__auto__);
if(cljs.core.truth_((function (){var and__7490__auto__ = !((st__37169__auto__ == null));
if(and__7490__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__37169__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__37156__auto__], null));
} else {
return and__7490__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__37169__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__37156__auto__);
} else {
}

if((indexer__37166__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__37166__auto__,this__37156__auto__);
}
});})(x49254_49264))
;

x49254_49264.componentDidUpdate = ((function (x49254_49264){
return (function (prev_props__37164__auto__,prev_state__37165__auto__){
var this__37156__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__37156__auto__);
});})(x49254_49264))
;

x49254_49264.isMounted = ((function (x49254_49264){
return (function (){
var this__37156__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__37156__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x49254_49264))
;

x49254_49264.componentWillMount = ((function (x49254_49264){
return (function (){
var this__37156__auto__ = this;
var indexer__37166__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__37166__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__37166__auto__,this__37156__auto__);
}
});})(x49254_49264))
;

x49254_49264.render = ((function (x49254_49264){
return (function (){
var this__37155__auto__ = this;
var this$ = this__37155__auto__;
var _STAR_reconciler_STAR_49257 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_49258 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_49259 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_49260 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_49261 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__37155__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__37155__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__37155__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__37155__auto__);

om.next._STAR_parent_STAR_ = this__37155__auto__;

try{return om.dom.div.call(null,({"className": "c-dialog__actions"}),om.next.children.call(null,this$));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_49261;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_49260;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_49259;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_49258;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_49257;
}});})(x49254_49264))
;


untangled.ui.elements.DialogActions.prototype.constructor = untangled.ui.elements.DialogActions;

untangled.ui.elements.DialogActions.prototype.constructor.displayName = "untangled.ui.elements/DialogActions";

untangled.ui.elements.DialogActions.prototype.om$isComponent = true;

var x49262_49268 = untangled.ui.elements.DialogActions;


var x49263_49269 = untangled.ui.elements.DialogActions.prototype;


untangled.ui.elements.DialogActions.cljs$lang$type = true;

untangled.ui.elements.DialogActions.cljs$lang$ctorStr = "untangled.ui.elements/DialogActions";

untangled.ui.elements.DialogActions.cljs$lang$ctorPrWriter = (function (this__37314__auto__,writer__37315__auto__,opt__37316__auto__){
return cljs.core._write.call(null,writer__37315__auto__,"untangled.ui.elements/DialogActions");
});
/**
 * Render one or more action elements (e.g. buttons) in the action area of the dialog. Should only be used in a ui-dialog
 */
untangled.ui.elements.ui_dialog_actions = om.next.factory.call(null,untangled.ui.elements.DialogActions);
/**
 * @constructor
 */
untangled.ui.elements.Dialog = (function untangled$ui$elements$Dialog(){
var this__37311__auto__ = this;
React.Component.apply(this__37311__auto__,arguments);

if(!((this__37311__auto__.initLocalState == null))){
this__37311__auto__.state = this__37311__auto__.initLocalState();
} else {
this__37311__auto__.state = {};
}

return this__37311__auto__;
});

untangled.ui.elements.Dialog.prototype = goog.object.clone(React.Component.prototype);

var x49274_49286 = untangled.ui.elements.Dialog.prototype;
x49274_49286.componentWillUpdate = ((function (x49274_49286){
return (function (next_props__37157__auto__,next_state__37158__auto__){
var this__37156__auto__ = this;
if(((!((this__37156__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__37156__auto__.om$next$Ident$)))?true:false):false)){
var ident__37160__auto___49287 = om.next.ident.call(null,this__37156__auto__,om.next.props.call(null,this__37156__auto__));
var next_ident__37161__auto___49288 = om.next.ident.call(null,this__37156__auto__,om.next._next_props.call(null,next_props__37157__auto__,this__37156__auto__));
if(cljs.core.not_EQ_.call(null,ident__37160__auto___49287,next_ident__37161__auto___49288)){
var idxr__37162__auto___49289 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__37162__auto___49289 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__37162__auto___49289),((function (idxr__37162__auto___49289,ident__37160__auto___49287,next_ident__37161__auto___49288,this__37156__auto__,x49274_49286){
return (function (indexes__37163__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__37163__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__37160__auto___49287], null),cljs.core.disj,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__37161__auto___49288], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__37156__auto__);
});})(idxr__37162__auto___49289,ident__37160__auto___49287,next_ident__37161__auto___49288,this__37156__auto__,x49274_49286))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__37156__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__37156__auto__);
});})(x49274_49286))
;

x49274_49286.shouldComponentUpdate = ((function (x49274_49286){
return (function (next_props__37157__auto__,next_state__37158__auto__){
var this__37156__auto__ = this;
var next_children__37159__auto__ = next_props__37157__auto__.children;
var next_props__37157__auto____$1 = goog.object.get(next_props__37157__auto__,"omcljs$value");
var next_props__37157__auto____$2 = (function (){var G__49276 = next_props__37157__auto____$1;
if((next_props__37157__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__49276);
} else {
return G__49276;
}
})();
var or__7502__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__37156__auto__),next_props__37157__auto____$2);
if(or__7502__auto__){
return or__7502__auto__;
} else {
var or__7502__auto____$1 = (function (){var and__7490__auto__ = this__37156__auto__.state;
if(cljs.core.truth_(and__7490__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__37156__auto__.state,"omcljs$state"),goog.object.get(next_state__37158__auto__,"omcljs$state"));
} else {
return and__7490__auto__;
}
})();
if(cljs.core.truth_(or__7502__auto____$1)){
return or__7502__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__37156__auto__.props.children,next_children__37159__auto__);
}
}
});})(x49274_49286))
;

x49274_49286.componentWillUnmount = ((function (x49274_49286){
return (function (){
var this__37156__auto__ = this;
var r__37167__auto__ = om.next.get_reconciler.call(null,this__37156__auto__);
var cfg__37168__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__37167__auto__);
var st__37169__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__37168__auto__);
var indexer__37166__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__37168__auto__);
if(cljs.core.truth_((function (){var and__7490__auto__ = !((st__37169__auto__ == null));
if(and__7490__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__37169__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__37156__auto__], null));
} else {
return and__7490__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__37169__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__37156__auto__);
} else {
}

if((indexer__37166__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__37166__auto__,this__37156__auto__);
}
});})(x49274_49286))
;

x49274_49286.componentDidUpdate = ((function (x49274_49286){
return (function (prev_props__37164__auto__,prev_state__37165__auto__){
var this__37156__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__37156__auto__);
});})(x49274_49286))
;

x49274_49286.isMounted = ((function (x49274_49286){
return (function (){
var this__37156__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__37156__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x49274_49286))
;

x49274_49286.componentWillMount = ((function (x49274_49286){
return (function (){
var this__37156__auto__ = this;
var indexer__37166__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__37166__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__37166__auto__,this__37156__auto__);
}
});})(x49274_49286))
;

x49274_49286.render = ((function (x49274_49286){
return (function (){
var this__37155__auto__ = this;
var this$ = this__37155__auto__;
var _STAR_reconciler_STAR_49277 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_49278 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_49279 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_49280 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_49281 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__37155__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__37155__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__37155__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__37155__auto__);

om.next._STAR_parent_STAR_ = this__37155__auto__;

try{var map__49282 = om.next.props.call(null,this$);
var map__49282__$1 = ((((!((map__49282 == null)))?((((map__49282.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49282.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49282):map__49282);
var props = map__49282__$1;
var key = cljs.core.get.call(null,map__49282__$1,new cljs.core.Keyword(null,"key","key",-1516042587),"");
var full_screen = cljs.core.get.call(null,map__49282__$1,new cljs.core.Keyword(null,"full-screen","full-screen",-1144598281));
var visible = cljs.core.get.call(null,map__49282__$1,new cljs.core.Keyword(null,"visible","visible",-1024216805));
var modal = cljs.core.get.call(null,map__49282__$1,new cljs.core.Keyword(null,"modal","modal",-1031880850));
var onClose = cljs.core.get.call(null,map__49282__$1,new cljs.core.Keyword(null,"onClose","onClose",1513531338));
var children = om.next.children.call(null,this$);
var title = untangled.ui.elements.first_node.call(null,untangled.ui.elements.DialogTitle,children);
var content = untangled.ui.elements.first_node.call(null,untangled.ui.elements.DialogBody,children);
var actions = untangled.ui.elements.first_node.call(null,untangled.ui.elements.DialogActions,children);
var state = (cljs.core.truth_(visible)?" is-active":null);
var user_classes = cljs.core.get.call(null,props,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var classes = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(user_classes),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-dialog"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(state),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(full_screen)?" c-dialog--fullscreen":null))].join('');
var dialog_dom = om.dom.div.call(null,({"key": [cljs.core.str.cljs$core$IFn$_invoke$arity$1(key),cljs.core.str.cljs$core$IFn$_invoke$arity$1("-dialog")].join(''), "className": classes}),om.dom.div.call(null,({"className": "c-dialog__card"}),(cljs.core.truth_(title)?title:null),(cljs.core.truth_(content)?content:null),(cljs.core.truth_(actions)?actions:null)));
if(cljs.core.truth_(modal)){
return om.dom.div.call(null,({"key": key}),dialog_dom,om.dom.div.call(null,({"onKeyPress": ((function (map__49282,map__49282__$1,props,key,full_screen,visible,modal,onClose,children,title,content,actions,state,user_classes,classes,dialog_dom,_STAR_reconciler_STAR_49277,_STAR_depth_STAR_49278,_STAR_shared_STAR_49279,_STAR_instrument_STAR_49280,_STAR_parent_STAR_49281,this$,this__37155__auto__,x49274_49286){
return (function (evt){
if(cljs.core.truth_((function (){var and__7490__auto__ = visible;
if(cljs.core.truth_(and__7490__auto__)){
var and__7490__auto____$1 = onClose;
if(cljs.core.truth_(and__7490__auto____$1)){
return untangled.events.escape_key_QMARK_.call(null,evt);
} else {
return and__7490__auto____$1;
}
} else {
return and__7490__auto__;
}
})())){
return onClose.call(null);
} else {
return null;
}
});})(map__49282,map__49282__$1,props,key,full_screen,visible,modal,onClose,children,title,content,actions,state,user_classes,classes,dialog_dom,_STAR_reconciler_STAR_49277,_STAR_depth_STAR_49278,_STAR_shared_STAR_49279,_STAR_instrument_STAR_49280,_STAR_parent_STAR_49281,this$,this__37155__auto__,x49274_49286))
, "onClick": ((function (map__49282,map__49282__$1,props,key,full_screen,visible,modal,onClose,children,title,content,actions,state,user_classes,classes,dialog_dom,_STAR_reconciler_STAR_49277,_STAR_depth_STAR_49278,_STAR_shared_STAR_49279,_STAR_instrument_STAR_49280,_STAR_parent_STAR_49281,this$,this__37155__auto__,x49274_49286){
return (function (){
if(cljs.core.truth_((function (){var and__7490__auto__ = visible;
if(cljs.core.truth_(and__7490__auto__)){
return onClose;
} else {
return and__7490__auto__;
}
})())){
return onClose.call(null);
} else {
return null;
}
});})(map__49282,map__49282__$1,props,key,full_screen,visible,modal,onClose,children,title,content,actions,state,user_classes,classes,dialog_dom,_STAR_reconciler_STAR_49277,_STAR_depth_STAR_49278,_STAR_shared_STAR_49279,_STAR_instrument_STAR_49280,_STAR_parent_STAR_49281,this$,this__37155__auto__,x49274_49286))
, "className": [cljs.core.str.cljs$core$IFn$_invoke$arity$1("c-backdrop"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(state)].join('')})));
} else {
return dialog_dom;
}
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_49281;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_49280;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_49279;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_49278;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_49277;
}});})(x49274_49286))
;


untangled.ui.elements.Dialog.prototype.constructor = untangled.ui.elements.Dialog;

untangled.ui.elements.Dialog.prototype.constructor.displayName = "untangled.ui.elements/Dialog";

untangled.ui.elements.Dialog.prototype.om$isComponent = true;

var x49284_49290 = untangled.ui.elements.Dialog;


var x49285_49291 = untangled.ui.elements.Dialog.prototype;


untangled.ui.elements.Dialog.cljs$lang$type = true;

untangled.ui.elements.Dialog.cljs$lang$ctorStr = "untangled.ui.elements/Dialog";

untangled.ui.elements.Dialog.cljs$lang$ctorPrWriter = (function (this__37314__auto__,writer__37315__auto__,opt__37316__auto__){
return cljs.core._write.call(null,writer__37315__auto__,"untangled.ui.elements/Dialog");
});
/**
 * Render a dialog. Normal HTML/React attributes can be included, and should be a cljs map (not a js object).
 * 
 *   Options:
 * 
 *   `:visible` - A boolean. When true the dialog is on-screen. When not, it is hidden. Allows you to keep the dialog
 *   in the DOM.
 *   `:full-screen` - A boolean. Renders the dialog to consume the entire screen when true. (useful for mobile).
 *   `:modal` - A boolean. When true the dialog will block the rest of the UI.
 *   `:className` - Additional CSS classes to place on the dialog.
 *   `:key` - React key
 *   `:onClose` - A callback that advises *your* code that the user is indicating a desire to be out of the dialog
 *   (e.g. the clicked on the modal backdrop). You must still set the visible flag since this is a stateless
 *   rendering of a dialog UI, not an active stateful component.
 * 
 *   You should include at most one of each of three following children for this node:
 * 
 *   (ui-dialog {}
 *  (ui-dialog-title {} title-nodes)
 *  (ui-dialog-body {} body-nodes)
 *  (ui-dialog-actions {} action-nodes)
 * 
 *   The `title-nodes` can be any inline DOM (or just a string), as can body-nodes.  Action-notes must include at least one button that
 *   closes the dialog or redirects the user.
 */
untangled.ui.elements.ui_dialog = om.next.factory.call(null,untangled.ui.elements.Dialog);
/**
 * @constructor
 */
untangled.ui.elements.NotificationTitle = (function untangled$ui$elements$NotificationTitle(){
var this__37311__auto__ = this;
React.Component.apply(this__37311__auto__,arguments);

if(!((this__37311__auto__.initLocalState == null))){
this__37311__auto__.state = this__37311__auto__.initLocalState();
} else {
this__37311__auto__.state = {};
}

return this__37311__auto__;
});

untangled.ui.elements.NotificationTitle.prototype = goog.object.clone(React.Component.prototype);

var x49296_49308 = untangled.ui.elements.NotificationTitle.prototype;
x49296_49308.componentWillUpdate = ((function (x49296_49308){
return (function (next_props__37157__auto__,next_state__37158__auto__){
var this__37156__auto__ = this;
if(((!((this__37156__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__37156__auto__.om$next$Ident$)))?true:false):false)){
var ident__37160__auto___49309 = om.next.ident.call(null,this__37156__auto__,om.next.props.call(null,this__37156__auto__));
var next_ident__37161__auto___49310 = om.next.ident.call(null,this__37156__auto__,om.next._next_props.call(null,next_props__37157__auto__,this__37156__auto__));
if(cljs.core.not_EQ_.call(null,ident__37160__auto___49309,next_ident__37161__auto___49310)){
var idxr__37162__auto___49311 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__37162__auto___49311 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__37162__auto___49311),((function (idxr__37162__auto___49311,ident__37160__auto___49309,next_ident__37161__auto___49310,this__37156__auto__,x49296_49308){
return (function (indexes__37163__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__37163__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__37160__auto___49309], null),cljs.core.disj,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__37161__auto___49310], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__37156__auto__);
});})(idxr__37162__auto___49311,ident__37160__auto___49309,next_ident__37161__auto___49310,this__37156__auto__,x49296_49308))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__37156__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__37156__auto__);
});})(x49296_49308))
;

x49296_49308.shouldComponentUpdate = ((function (x49296_49308){
return (function (next_props__37157__auto__,next_state__37158__auto__){
var this__37156__auto__ = this;
var next_children__37159__auto__ = next_props__37157__auto__.children;
var next_props__37157__auto____$1 = goog.object.get(next_props__37157__auto__,"omcljs$value");
var next_props__37157__auto____$2 = (function (){var G__49298 = next_props__37157__auto____$1;
if((next_props__37157__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__49298);
} else {
return G__49298;
}
})();
var or__7502__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__37156__auto__),next_props__37157__auto____$2);
if(or__7502__auto__){
return or__7502__auto__;
} else {
var or__7502__auto____$1 = (function (){var and__7490__auto__ = this__37156__auto__.state;
if(cljs.core.truth_(and__7490__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__37156__auto__.state,"omcljs$state"),goog.object.get(next_state__37158__auto__,"omcljs$state"));
} else {
return and__7490__auto__;
}
})();
if(cljs.core.truth_(or__7502__auto____$1)){
return or__7502__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__37156__auto__.props.children,next_children__37159__auto__);
}
}
});})(x49296_49308))
;

x49296_49308.componentWillUnmount = ((function (x49296_49308){
return (function (){
var this__37156__auto__ = this;
var r__37167__auto__ = om.next.get_reconciler.call(null,this__37156__auto__);
var cfg__37168__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__37167__auto__);
var st__37169__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__37168__auto__);
var indexer__37166__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__37168__auto__);
if(cljs.core.truth_((function (){var and__7490__auto__ = !((st__37169__auto__ == null));
if(and__7490__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__37169__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__37156__auto__], null));
} else {
return and__7490__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__37169__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__37156__auto__);
} else {
}

if((indexer__37166__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__37166__auto__,this__37156__auto__);
}
});})(x49296_49308))
;

x49296_49308.componentDidUpdate = ((function (x49296_49308){
return (function (prev_props__37164__auto__,prev_state__37165__auto__){
var this__37156__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__37156__auto__);
});})(x49296_49308))
;

x49296_49308.isMounted = ((function (x49296_49308){
return (function (){
var this__37156__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__37156__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x49296_49308))
;

x49296_49308.componentWillMount = ((function (x49296_49308){
return (function (){
var this__37156__auto__ = this;
var indexer__37166__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__37166__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__37166__auto__,this__37156__auto__);
}
});})(x49296_49308))
;

x49296_49308.render = ((function (x49296_49308){
return (function (){
var this__37155__auto__ = this;
var this$ = this__37155__auto__;
var _STAR_reconciler_STAR_49299 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_49300 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_49301 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_49302 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_49303 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__37155__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__37155__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__37155__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__37155__auto__);

om.next._STAR_parent_STAR_ = this__37155__auto__;

try{var map__49304 = om.next.props.call(null,this$);
var map__49304__$1 = ((((!((map__49304 == null)))?((((map__49304.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49304.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49304):map__49304);
var props = map__49304__$1;
var key = cljs.core.get.call(null,map__49304__$1,new cljs.core.Keyword(null,"key","key",-1516042587),"");
return om.dom.h1.call(null,({"className": "c-notification_heading", "key": key}),om.next.children.call(null,this$));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_49303;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_49302;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_49301;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_49300;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_49299;
}});})(x49296_49308))
;


untangled.ui.elements.NotificationTitle.prototype.constructor = untangled.ui.elements.NotificationTitle;

untangled.ui.elements.NotificationTitle.prototype.constructor.displayName = "untangled.ui.elements/NotificationTitle";

untangled.ui.elements.NotificationTitle.prototype.om$isComponent = true;

var x49306_49312 = untangled.ui.elements.NotificationTitle;


var x49307_49313 = untangled.ui.elements.NotificationTitle.prototype;


untangled.ui.elements.NotificationTitle.cljs$lang$type = true;

untangled.ui.elements.NotificationTitle.cljs$lang$ctorStr = "untangled.ui.elements/NotificationTitle";

untangled.ui.elements.NotificationTitle.cljs$lang$ctorPrWriter = (function (this__37314__auto__,writer__37315__auto__,opt__37316__auto__){
return cljs.core._write.call(null,writer__37315__auto__,"untangled.ui.elements/NotificationTitle");
});
/**
 * Render a notification title. Should only be used in a ui-notification
 */
untangled.ui.elements.ui_notification_title = om.next.factory.call(null,untangled.ui.elements.NotificationTitle);
/**
 * @constructor
 */
untangled.ui.elements.NotificationBody = (function untangled$ui$elements$NotificationBody(){
var this__37311__auto__ = this;
React.Component.apply(this__37311__auto__,arguments);

if(!((this__37311__auto__.initLocalState == null))){
this__37311__auto__.state = this__37311__auto__.initLocalState();
} else {
this__37311__auto__.state = {};
}

return this__37311__auto__;
});

untangled.ui.elements.NotificationBody.prototype = goog.object.clone(React.Component.prototype);

var x49318_49328 = untangled.ui.elements.NotificationBody.prototype;
x49318_49328.componentWillUpdate = ((function (x49318_49328){
return (function (next_props__37157__auto__,next_state__37158__auto__){
var this__37156__auto__ = this;
if(((!((this__37156__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__37156__auto__.om$next$Ident$)))?true:false):false)){
var ident__37160__auto___49329 = om.next.ident.call(null,this__37156__auto__,om.next.props.call(null,this__37156__auto__));
var next_ident__37161__auto___49330 = om.next.ident.call(null,this__37156__auto__,om.next._next_props.call(null,next_props__37157__auto__,this__37156__auto__));
if(cljs.core.not_EQ_.call(null,ident__37160__auto___49329,next_ident__37161__auto___49330)){
var idxr__37162__auto___49331 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__37162__auto___49331 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__37162__auto___49331),((function (idxr__37162__auto___49331,ident__37160__auto___49329,next_ident__37161__auto___49330,this__37156__auto__,x49318_49328){
return (function (indexes__37163__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__37163__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__37160__auto___49329], null),cljs.core.disj,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__37161__auto___49330], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__37156__auto__);
});})(idxr__37162__auto___49331,ident__37160__auto___49329,next_ident__37161__auto___49330,this__37156__auto__,x49318_49328))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__37156__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__37156__auto__);
});})(x49318_49328))
;

x49318_49328.shouldComponentUpdate = ((function (x49318_49328){
return (function (next_props__37157__auto__,next_state__37158__auto__){
var this__37156__auto__ = this;
var next_children__37159__auto__ = next_props__37157__auto__.children;
var next_props__37157__auto____$1 = goog.object.get(next_props__37157__auto__,"omcljs$value");
var next_props__37157__auto____$2 = (function (){var G__49320 = next_props__37157__auto____$1;
if((next_props__37157__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__49320);
} else {
return G__49320;
}
})();
var or__7502__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__37156__auto__),next_props__37157__auto____$2);
if(or__7502__auto__){
return or__7502__auto__;
} else {
var or__7502__auto____$1 = (function (){var and__7490__auto__ = this__37156__auto__.state;
if(cljs.core.truth_(and__7490__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__37156__auto__.state,"omcljs$state"),goog.object.get(next_state__37158__auto__,"omcljs$state"));
} else {
return and__7490__auto__;
}
})();
if(cljs.core.truth_(or__7502__auto____$1)){
return or__7502__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__37156__auto__.props.children,next_children__37159__auto__);
}
}
});})(x49318_49328))
;

x49318_49328.componentWillUnmount = ((function (x49318_49328){
return (function (){
var this__37156__auto__ = this;
var r__37167__auto__ = om.next.get_reconciler.call(null,this__37156__auto__);
var cfg__37168__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__37167__auto__);
var st__37169__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__37168__auto__);
var indexer__37166__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__37168__auto__);
if(cljs.core.truth_((function (){var and__7490__auto__ = !((st__37169__auto__ == null));
if(and__7490__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__37169__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__37156__auto__], null));
} else {
return and__7490__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__37169__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__37156__auto__);
} else {
}

if((indexer__37166__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__37166__auto__,this__37156__auto__);
}
});})(x49318_49328))
;

x49318_49328.componentDidUpdate = ((function (x49318_49328){
return (function (prev_props__37164__auto__,prev_state__37165__auto__){
var this__37156__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__37156__auto__);
});})(x49318_49328))
;

x49318_49328.isMounted = ((function (x49318_49328){
return (function (){
var this__37156__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__37156__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x49318_49328))
;

x49318_49328.componentWillMount = ((function (x49318_49328){
return (function (){
var this__37156__auto__ = this;
var indexer__37166__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__37166__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__37166__auto__,this__37156__auto__);
}
});})(x49318_49328))
;

x49318_49328.render = ((function (x49318_49328){
return (function (){
var this__37155__auto__ = this;
var this$ = this__37155__auto__;
var _STAR_reconciler_STAR_49321 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_49322 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_49323 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_49324 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_49325 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__37155__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__37155__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__37155__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__37155__auto__);

om.next._STAR_parent_STAR_ = this__37155__auto__;

try{return om.dom.p.call(null,({}),om.next.children.call(null,this$));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_49325;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_49324;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_49323;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_49322;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_49321;
}});})(x49318_49328))
;


untangled.ui.elements.NotificationBody.prototype.constructor = untangled.ui.elements.NotificationBody;

untangled.ui.elements.NotificationBody.prototype.constructor.displayName = "untangled.ui.elements/NotificationBody";

untangled.ui.elements.NotificationBody.prototype.om$isComponent = true;

var x49326_49332 = untangled.ui.elements.NotificationBody;


var x49327_49333 = untangled.ui.elements.NotificationBody.prototype;


untangled.ui.elements.NotificationBody.cljs$lang$type = true;

untangled.ui.elements.NotificationBody.cljs$lang$ctorStr = "untangled.ui.elements/NotificationBody";

untangled.ui.elements.NotificationBody.cljs$lang$ctorPrWriter = (function (this__37314__auto__,writer__37315__auto__,opt__37316__auto__){
return cljs.core._write.call(null,writer__37315__auto__,"untangled.ui.elements/NotificationBody");
});
/**
 * Render a notification body. Should only be used in a ui-notification
 */
untangled.ui.elements.ui_notification_body = om.next.factory.call(null,untangled.ui.elements.NotificationBody);
/**
 * @constructor
 */
untangled.ui.elements.Notification = (function untangled$ui$elements$Notification(){
var this__37311__auto__ = this;
React.Component.apply(this__37311__auto__,arguments);

if(!((this__37311__auto__.initLocalState == null))){
this__37311__auto__.state = this__37311__auto__.initLocalState();
} else {
this__37311__auto__.state = {};
}

return this__37311__auto__;
});

untangled.ui.elements.Notification.prototype = goog.object.clone(React.Component.prototype);

var x49338_49352 = untangled.ui.elements.Notification.prototype;
x49338_49352.componentWillUpdate = ((function (x49338_49352){
return (function (next_props__37157__auto__,next_state__37158__auto__){
var this__37156__auto__ = this;
if(((!((this__37156__auto__ == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === this__37156__auto__.om$next$Ident$)))?true:false):false)){
var ident__37160__auto___49353 = om.next.ident.call(null,this__37156__auto__,om.next.props.call(null,this__37156__auto__));
var next_ident__37161__auto___49354 = om.next.ident.call(null,this__37156__auto__,om.next._next_props.call(null,next_props__37157__auto__,this__37156__auto__));
if(cljs.core.not_EQ_.call(null,ident__37160__auto___49353,next_ident__37161__auto___49354)){
var idxr__37162__auto___49355 = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((idxr__37162__auto___49355 == null)){
} else {
cljs.core.swap_BANG_.call(null,new cljs.core.Keyword(null,"indexes","indexes",1496475545).cljs$core$IFn$_invoke$arity$1(idxr__37162__auto___49355),((function (idxr__37162__auto___49355,ident__37160__auto___49353,next_ident__37161__auto___49354,this__37156__auto__,x49338_49352){
return (function (indexes__37163__auto__){
return cljs.core.update_in.call(null,cljs.core.update_in.call(null,indexes__37163__auto__,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),ident__37160__auto___49353], null),cljs.core.disj,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ref->components","ref->components",-303587249),next_ident__37161__auto___49354], null),cljs.core.fnil.call(null,cljs.core.conj,cljs.core.PersistentHashSet.EMPTY),this__37156__auto__);
});})(idxr__37162__auto___49355,ident__37160__auto___49353,next_ident__37161__auto___49354,this__37156__auto__,x49338_49352))
);
}
} else {
}
} else {
}

om.next.merge_pending_props_BANG_.call(null,this__37156__auto__);

return om.next.merge_pending_state_BANG_.call(null,this__37156__auto__);
});})(x49338_49352))
;

x49338_49352.shouldComponentUpdate = ((function (x49338_49352){
return (function (next_props__37157__auto__,next_state__37158__auto__){
var this__37156__auto__ = this;
var next_children__37159__auto__ = next_props__37157__auto__.children;
var next_props__37157__auto____$1 = goog.object.get(next_props__37157__auto__,"omcljs$value");
var next_props__37157__auto____$2 = (function (){var G__49340 = next_props__37157__auto____$1;
if((next_props__37157__auto____$1 instanceof om.next.OmProps)){
return om.next.unwrap.call(null,G__49340);
} else {
return G__49340;
}
})();
var or__7502__auto__ = cljs.core.not_EQ_.call(null,om.next.props.call(null,this__37156__auto__),next_props__37157__auto____$2);
if(or__7502__auto__){
return or__7502__auto__;
} else {
var or__7502__auto____$1 = (function (){var and__7490__auto__ = this__37156__auto__.state;
if(cljs.core.truth_(and__7490__auto__)){
return cljs.core.not_EQ_.call(null,goog.object.get(this__37156__auto__.state,"omcljs$state"),goog.object.get(next_state__37158__auto__,"omcljs$state"));
} else {
return and__7490__auto__;
}
})();
if(cljs.core.truth_(or__7502__auto____$1)){
return or__7502__auto____$1;
} else {
return cljs.core.not_EQ_.call(null,this__37156__auto__.props.children,next_children__37159__auto__);
}
}
});})(x49338_49352))
;

x49338_49352.componentWillUnmount = ((function (x49338_49352){
return (function (){
var this__37156__auto__ = this;
var r__37167__auto__ = om.next.get_reconciler.call(null,this__37156__auto__);
var cfg__37168__auto__ = new cljs.core.Keyword(null,"config","config",994861415).cljs$core$IFn$_invoke$arity$1(r__37167__auto__);
var st__37169__auto__ = new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(cfg__37168__auto__);
var indexer__37166__auto__ = new cljs.core.Keyword(null,"indexer","indexer",-1774914315).cljs$core$IFn$_invoke$arity$1(cfg__37168__auto__);
if(cljs.core.truth_((function (){var and__7490__auto__ = !((st__37169__auto__ == null));
if(and__7490__auto__){
return cljs.core.get_in.call(null,cljs.core.deref.call(null,st__37169__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146),this__37156__auto__], null));
} else {
return and__7490__auto__;
}
})())){
cljs.core.swap_BANG_.call(null,st__37169__auto__,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("om.next","queries","om.next/queries",-22717146)], null),cljs.core.dissoc,this__37156__auto__);
} else {
}

if((indexer__37166__auto__ == null)){
return null;
} else {
return om.next.protocols.drop_component_BANG_.call(null,indexer__37166__auto__,this__37156__auto__);
}
});})(x49338_49352))
;

x49338_49352.componentDidUpdate = ((function (x49338_49352){
return (function (prev_props__37164__auto__,prev_state__37165__auto__){
var this__37156__auto__ = this;
return om.next.clear_prev_props_BANG_.call(null,this__37156__auto__);
});})(x49338_49352))
;

x49338_49352.isMounted = ((function (x49338_49352){
return (function (){
var this__37156__auto__ = this;
return cljs.core.boolean$.call(null,goog.object.getValueByKeys(this__37156__auto__,"_reactInternalInstance","_renderedComponent"));
});})(x49338_49352))
;

x49338_49352.componentWillMount = ((function (x49338_49352){
return (function (){
var this__37156__auto__ = this;
var indexer__37166__auto__ = cljs.core.get_in.call(null,om.next.get_reconciler.call(null,this__37156__auto__),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"config","config",994861415),new cljs.core.Keyword(null,"indexer","indexer",-1774914315)], null));
if((indexer__37166__auto__ == null)){
return null;
} else {
return om.next.protocols.index_component_BANG_.call(null,indexer__37166__auto__,this__37156__auto__);
}
});})(x49338_49352))
;

x49338_49352.render = ((function (x49338_49352){
return (function (){
var this__37155__auto__ = this;
var this$ = this__37155__auto__;
var _STAR_reconciler_STAR_49341 = om.next._STAR_reconciler_STAR_;
var _STAR_depth_STAR_49342 = om.next._STAR_depth_STAR_;
var _STAR_shared_STAR_49343 = om.next._STAR_shared_STAR_;
var _STAR_instrument_STAR_49344 = om.next._STAR_instrument_STAR_;
var _STAR_parent_STAR_49345 = om.next._STAR_parent_STAR_;
om.next._STAR_reconciler_STAR_ = om.next.get_reconciler.call(null,this__37155__auto__);

om.next._STAR_depth_STAR_ = (om.next.depth.call(null,this__37155__auto__) + (1));

om.next._STAR_shared_STAR_ = om.next.shared.call(null,this__37155__auto__);

om.next._STAR_instrument_STAR_ = om.next.instrument.call(null,this__37155__auto__);

om.next._STAR_parent_STAR_ = this__37155__auto__;

try{var map__49346 = om.next.props.call(null,this$);
var map__49346__$1 = ((((!((map__49346 == null)))?((((map__49346.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49346.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49346):map__49346);
var props = map__49346__$1;
var key = cljs.core.get.call(null,map__49346__$1,new cljs.core.Keyword(null,"key","key",-1516042587),"");
var width = cljs.core.get.call(null,map__49346__$1,new cljs.core.Keyword(null,"width","width",-384071477));
var kind = cljs.core.get.call(null,map__49346__$1,new cljs.core.Keyword(null,"kind","kind",-717265803));
var onClose = cljs.core.get.call(null,map__49346__$1,new cljs.core.Keyword(null,"onClose","onClose",1513531338));
var children = om.next.children.call(null,this$);
var title = untangled.ui.elements.first_node.call(null,untangled.ui.elements.NotificationTitle,children);
var content = untangled.ui.elements.first_node.call(null,untangled.ui.elements.NotificationBody,children);
var legal_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"informative","informative",1852560673),null,new cljs.core.Keyword(null,"warning","warning",-1685650671),null,new cljs.core.Keyword(null,"success","success",1890645906),null,new cljs.core.Keyword(null,"error","error",-978969032),null], null), null);
var legal_widths = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"wide","wide",-151772487),null], null), null);
var user_classes = cljs.core.get.call(null,props,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var classes = (function (){var G__49348 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(user_classes),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-notification")].join('');
var G__49348__$1 = ((cljs.core.contains_QMARK_.call(null,legal_types,kind))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49348),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-notification--"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,kind))].join(''):G__49348);
if(cljs.core.contains_QMARK_.call(null,legal_widths,width)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49348__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-notification--"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,width))].join('');
} else {
return G__49348__$1;
}
})();
var type_icon = (function (){var G__49349 = (((kind instanceof cljs.core.Keyword))?kind.fqn:null);
switch (G__49349) {
case "success":
return untangled.icons.icon.call(null,new cljs.core.Keyword(null,"check_circle","check_circle",1774895320),new cljs.core.Keyword(null,"states","states",1389013542),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"positive","positive",1112941866)], null));

break;
case "warning":
return untangled.icons.icon.call(null,new cljs.core.Keyword(null,"warning","warning",-1685650671));

break;
case "error":
return untangled.icons.icon.call(null,new cljs.core.Keyword(null,"error","error",-978969032));

break;
default:
return untangled.icons.icon.call(null,new cljs.core.Keyword(null,"info","info",-317069002));

}
})();
return om.dom.div.call(null,({"className": classes, "key": key}),type_icon,om.dom.div.call(null,({"className": "c-notification_content"}),(cljs.core.truth_(title)?title:null),(cljs.core.truth_(content)?content:null)),om.dom.button.call(null,({"onClick": ((function (map__49346,map__49346__$1,props,key,width,kind,onClose,children,title,content,legal_types,legal_widths,user_classes,classes,type_icon,_STAR_reconciler_STAR_49341,_STAR_depth_STAR_49342,_STAR_shared_STAR_49343,_STAR_instrument_STAR_49344,_STAR_parent_STAR_49345,this$,this__37155__auto__,x49338_49352){
return (function (evt){
if(cljs.core.truth_(onClose)){
return onClose.call(null);
} else {
return null;
}
});})(map__49346,map__49346__$1,props,key,width,kind,onClose,children,title,content,legal_types,legal_widths,user_classes,classes,type_icon,_STAR_reconciler_STAR_49341,_STAR_depth_STAR_49342,_STAR_shared_STAR_49343,_STAR_instrument_STAR_49344,_STAR_parent_STAR_49345,this$,this__37155__auto__,x49338_49352))
, "type": "button", "className": "c-button c-button--icon"}),untangled.icons.icon.call(null,new cljs.core.Keyword(null,"close","close",1835149582))));
}finally {om.next._STAR_parent_STAR_ = _STAR_parent_STAR_49345;

om.next._STAR_instrument_STAR_ = _STAR_instrument_STAR_49344;

om.next._STAR_shared_STAR_ = _STAR_shared_STAR_49343;

om.next._STAR_depth_STAR_ = _STAR_depth_STAR_49342;

om.next._STAR_reconciler_STAR_ = _STAR_reconciler_STAR_49341;
}});})(x49338_49352))
;


untangled.ui.elements.Notification.prototype.constructor = untangled.ui.elements.Notification;

untangled.ui.elements.Notification.prototype.constructor.displayName = "untangled.ui.elements/Notification";

untangled.ui.elements.Notification.prototype.om$isComponent = true;

var x49350_49357 = untangled.ui.elements.Notification;


var x49351_49358 = untangled.ui.elements.Notification.prototype;


untangled.ui.elements.Notification.cljs$lang$type = true;

untangled.ui.elements.Notification.cljs$lang$ctorStr = "untangled.ui.elements/Notification";

untangled.ui.elements.Notification.cljs$lang$ctorPrWriter = (function (this__37314__auto__,writer__37315__auto__,opt__37316__auto__){
return cljs.core._write.call(null,writer__37315__auto__,"untangled.ui.elements/Notification");
});
/**
 * Render a notification. Normal HTML/React attributes can be included, and should be a cljs map (not a js object).
 * 
 *   `:onClose` (optional) - A function to call when the notification's close button is pressed
 *   `:type` :none (default), :success, :warning, :error, :informative
 *   `:size` :normal (default), :wide
 * 
 *   You should include two children of this node:
 * 
 *   (when show-notification?
 *  (ui-notification {:onClose (fn [] (om/transact! this `[(my-close-notification-mutation)]))}
 *    (ui-notification-title {} title-nodes)
 *    (ui-notification-body {} body-nodes)))
 * 
 *   The `title-nodes` can be any inline DOM (or just a string), as can body-nodes.
 */
untangled.ui.elements.ui_notification = om.next.factory.call(null,untangled.ui.elements.Notification);
/**
 * Render an HTML progress element. Props is a normal clj(s) map with React/HTML attributes plus:
 * 
 *   `:className` - additional class stylings to apply to the progress element
 *   `:max` - The integer value that we're targeting for completion
 *   `:value` - The integer value of where we're at
 *   `:size` :regular (default), :dense
 * 
 *   If neither max or value are given, it will render as an indeterminate progress (in progress, but not complete).
 *   
 */
untangled.ui.elements.ui_progress = (function untangled$ui$elements$ui_progress(p__49359){
var map__49363 = p__49359;
var map__49363__$1 = ((((!((map__49363 == null)))?((((map__49363.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49363.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49363):map__49363);
var props = map__49363__$1;
var max = cljs.core.get.call(null,map__49363__$1,new cljs.core.Keyword(null,"max","max",61366548));
var value = cljs.core.get.call(null,map__49363__$1,new cljs.core.Keyword(null,"value","value",305978217));
var className = cljs.core.get.call(null,map__49363__$1,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var size = cljs.core.get.call(null,map__49363__$1,new cljs.core.Keyword(null,"size","size",1098693007));
var legal_sizes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"dense","dense",-1352835783),null], null), null);
var classes = (function (){var G__49365 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(className),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-progress ")].join('');
if(cljs.core.contains_QMARK_.call(null,legal_sizes,size)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49365),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-progress--"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,size))].join('');
} else {
return G__49365;
}
})();
var attrs = cljs.core.assoc.call(null,props,new cljs.core.Keyword(null,"className","className",-1983287057),classes,new cljs.core.Keyword(null,"aria-hidden","aria-hidden",399337029),false);
return om.dom.progress.call(null,cljs.core.clj__GT_js.call(null,attrs));
});
/**
 * Render a container for tabs using a vector of icons (each a map of attributes).
 * Normal HTML/React attributes can be included, and should be a cljs map (not a js object).
 * 
 * all parameters are optional
 * 
 */
untangled.ui.elements.ui_tabs = (function untangled$ui$elements$ui_tabs(var_args){
var args__8730__auto__ = [];
var len__8723__auto___49372 = arguments.length;
var i__8724__auto___49373 = (0);
while(true){
if((i__8724__auto___49373 < len__8723__auto___49372)){
args__8730__auto__.push((arguments[i__8724__auto___49373]));

var G__49374 = (i__8724__auto___49373 + (1));
i__8724__auto___49373 = G__49374;
continue;
} else {
}
break;
}

var argseq__8731__auto__ = ((((1) < args__8730__auto__.length))?(new cljs.core.IndexedSeq(args__8730__auto__.slice((1)),(0),null)):null);
return untangled.ui.elements.ui_tabs.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8731__auto__);
});

untangled.ui.elements.ui_tabs.cljs$core$IFn$_invoke$arity$variadic = (function (p__49368,children){
var map__49369 = p__49368;
var map__49369__$1 = ((((!((map__49369 == null)))?((((map__49369.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49369.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49369):map__49369);
var props = map__49369__$1;
var className = cljs.core.get.call(null,map__49369__$1,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var user_classes = cljs.core.get.call(null,props,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var top_level_class = (function (){var G__49371 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(user_classes),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-tabs")].join('');
return G__49371;
})();
return cljs.core.apply.call(null,om.dom.div,({"className": top_level_class}),children);
});

untangled.ui.elements.ui_tabs.cljs$lang$maxFixedArity = (1);

untangled.ui.elements.ui_tabs.cljs$lang$applyTo = (function (seq49366){
var G__49367 = cljs.core.first.call(null,seq49366);
var seq49366__$1 = cljs.core.next.call(null,seq49366);
return untangled.ui.elements.ui_tabs.cljs$core$IFn$_invoke$arity$variadic(G__49367,seq49366__$1);
});

/**
 * Render an icon button for use inside an icon bar.
 * 
 *   `:label` - A string of text to describe the tab action
 *   `:kind` :default, :primary, or :contrast - changes the aesthetic style of a tab
 *   `:active` true or false (default) - Usually used to show that your in that tab's view.
 * 
 *   TODO: Add the ability to wrap this in a menu so you can show more than just the text.
 *   
 */
untangled.ui.elements.ui_tab = (function untangled$ui$elements$ui_tab(p__49375){
var map__49379 = p__49375;
var map__49379__$1 = ((((!((map__49379 == null)))?((((map__49379.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49379.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49379):map__49379);
var props = map__49379__$1;
var className = cljs.core.get.call(null,map__49379__$1,new cljs.core.Keyword(null,"className","className",-1983287057),"");
var label = cljs.core.get.call(null,map__49379__$1,new cljs.core.Keyword(null,"label","label",1718410804),"");
var kind = cljs.core.get.call(null,map__49379__$1,new cljs.core.Keyword(null,"kind","kind",-717265803));
var active = cljs.core.get.call(null,map__49379__$1,new cljs.core.Keyword(null,"active","active",1895962068));
var legal_kinds = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"primary","primary",817773892),null,new cljs.core.Keyword(null,"contrast","contrast",568337131),null], null), null);
var classes = (function (){var G__49381 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(className),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-tab "),cljs.core.str.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(active)?" is-active ":null))].join('');
if(cljs.core.contains_QMARK_.call(null,legal_kinds,kind)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__49381),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" c-tab--"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.name.call(null,kind))].join('');
} else {
return G__49381;
}
})();
return om.dom.button.call(null,({"className": classes, "type": "button"}),label);
});
/**
 * Render an icon and text for when you can't display anything when you normally would have a collection of things.
 * 
 *   `:glyph` - An icon glyph name to render a given icon.
 *   `:title` - A string to announce what's missing
 *   `:message` - A string to instruct the user what to do next
 *   
 */
untangled.ui.elements.ui_empty_state = (function untangled$ui$elements$ui_empty_state(p__49382){
var map__49385 = p__49382;
var map__49385__$1 = ((((!((map__49385 == null)))?((((map__49385.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49385.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49385):map__49385);
var props = map__49385__$1;
var className = cljs.core.get.call(null,map__49385__$1,new cljs.core.Keyword(null,"className","className",-1983287057),"u-absolute--middle-center");
var glyph = cljs.core.get.call(null,map__49385__$1,new cljs.core.Keyword(null,"glyph","glyph",2119448117),new cljs.core.Keyword(null,"help","help",-439233446));
var title = cljs.core.get.call(null,map__49385__$1,new cljs.core.Keyword(null,"title","title",636505583),"Nothing to see yet");
var message = cljs.core.get.call(null,map__49385__$1,new cljs.core.Keyword(null,"message","message",-406056002),"");
return om.dom.div.call(null,({"className": className}),untangled.ui.elements.ui_icon.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"size","size",1098693007),new cljs.core.Keyword(null,"huge","huge",1683634816),new cljs.core.Keyword(null,"color","color",1011675173),new cljs.core.Keyword(null,"passive","passive",252884080)], null),untangled.icons.icon.call(null,glyph)),om.dom.h1.call(null,null,title),om.dom.p.call(null,({"className": "c-message"}),message));
});
