// Compiled by ClojureScript 1.9.473 {}
goog.provide('untangled.client.impl.application');
goog.require('cljs.core');
goog.require('untangled.client.logging');
goog.require('om.next');
goog.require('untangled.client.impl.data_fetch');
goog.require('untangled.client.impl.util');
goog.require('cljs.core.async');
goog.require('untangled.client.impl.network');
goog.require('untangled.client.impl.om_plumbing');
goog.require('untangled.i18n.core');
/**
 * This internal function is responsible for generating and returning a function that can accomplish calling the fallbacks that
 *   appear in an incoming Om transaction, which is in turn used by the error-handling logic of the plumbing.
 */
untangled.client.impl.application.fallback_handler = (function untangled$client$impl$application$fallback_handler(p__45781,query){
var map__45784 = p__45781;
var map__45784__$1 = ((((!((map__45784 == null)))?((((map__45784.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45784.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45784):map__45784);
var reconciler = cljs.core.get.call(null,map__45784__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
return ((function (map__45784,map__45784__$1,reconciler){
return (function (error){
cljs.core.swap_BANG_.call(null,om.next.app_state.call(null,reconciler),cljs.core.assoc,new cljs.core.Keyword("untangled","server-error","untangled/server-error",1542377811),error);

var temp__6751__auto__ = untangled.client.impl.om_plumbing.fallback_query.call(null,query,error);
if(cljs.core.truth_(temp__6751__auto__)){
var q = temp__6751__auto__;
untangled.client.logging.warn.call(null,untangled.client.logging.value_message.call(null,"Transaction failed. Running fallback.",q));

return om.next.transact_BANG_.call(null,reconciler,q);
} else {
return untangled.client.logging.warn.call(null,"Fallback triggered, but no fallbacks were defined.");
}
});
;})(map__45784,map__45784__$1,reconciler))
});
/**
 * Enqueue a send to the network queue. This is a standalone function because we cannot mock core async functions.
 */
untangled.client.impl.application.enqueue = (function untangled$client$impl$application$enqueue(q,v){
var c__42603__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto__){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto__){
return (function (state_45801){
var state_val_45802 = (state_45801[(1)]);
if((state_val_45802 === (1))){
var state_45801__$1 = state_45801;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_45801__$1,(2),q,v);
} else {
if((state_val_45802 === (2))){
var inst_45799 = (state_45801[(2)]);
var state_45801__$1 = state_45801;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_45801__$1,inst_45799);
} else {
return null;
}
}
});})(c__42603__auto__))
;
return ((function (switch__42489__auto__,c__42603__auto__){
return (function() {
var untangled$client$impl$application$enqueue_$_state_machine__42490__auto__ = null;
var untangled$client$impl$application$enqueue_$_state_machine__42490__auto____0 = (function (){
var statearr_45806 = [null,null,null,null,null,null,null];
(statearr_45806[(0)] = untangled$client$impl$application$enqueue_$_state_machine__42490__auto__);

(statearr_45806[(1)] = (1));

return statearr_45806;
});
var untangled$client$impl$application$enqueue_$_state_machine__42490__auto____1 = (function (state_45801){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_45801);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e45807){if((e45807 instanceof Object)){
var ex__42493__auto__ = e45807;
var statearr_45808_45810 = state_45801;
(statearr_45808_45810[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_45801);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e45807;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__45811 = state_45801;
state_45801 = G__45811;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
untangled$client$impl$application$enqueue_$_state_machine__42490__auto__ = function(state_45801){
switch(arguments.length){
case 0:
return untangled$client$impl$application$enqueue_$_state_machine__42490__auto____0.call(this);
case 1:
return untangled$client$impl$application$enqueue_$_state_machine__42490__auto____1.call(this,state_45801);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$enqueue_$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$enqueue_$_state_machine__42490__auto____0;
untangled$client$impl$application$enqueue_$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$enqueue_$_state_machine__42490__auto____1;
return untangled$client$impl$application$enqueue_$_state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto__))
})();
var state__42605__auto__ = (function (){var statearr_45809 = f__42604__auto__.call(null);
(statearr_45809[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto__);

return statearr_45809;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto__))
);

return c__42603__auto__;
});
/**
 * Do a properly-plumbed network send. This function recursively strips ui attributes from the tx and pushes the tx over
 *   the network. It installs the given on-load and on-error handlers to deal with the network response.
 */
untangled.client.impl.application.real_send = (function untangled$client$impl$application$real_send(net,tx,on_done,on_error,on_load){
if(((!((net == null)))?(((false) || ((cljs.core.PROTOCOL_SENTINEL === net.untangled$client$impl$network$ProgressiveTransfer$)))?true:false):false)){
return untangled.client.impl.network.updating_send.call(null,net,untangled.client.impl.om_plumbing.strip_ui.call(null,tx),on_done,on_error,on_load);
} else {
return untangled.client.impl.network.send.call(null,net,untangled.client.impl.om_plumbing.strip_ui.call(null,tx),on_done,on_error);
}
});
/**
 * Splits out the (remote) mutations and fallbacks in a transaction, creates an error handler that can
 * trigger fallbacks, and enqueues the remote mutations on the network queue.
 */
untangled.client.impl.application.enqueue_mutations = (function untangled$client$impl$application$enqueue_mutations(p__45815,remote_tx_map,cb){
var map__45822 = p__45815;
var map__45822__$1 = ((((!((map__45822 == null)))?((((map__45822.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45822.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45822):map__45822);
var app = map__45822__$1;
var send_queues = cljs.core.get.call(null,map__45822__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var networking = cljs.core.get.call(null,map__45822__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var seq__45824 = cljs.core.seq.call(null,cljs.core.keys.call(null,remote_tx_map));
var chunk__45825 = null;
var count__45826 = (0);
var i__45827 = (0);
while(true){
if((i__45827 < count__45826)){
var remote = cljs.core._nth.call(null,chunk__45825,i__45827);
var queue_45828 = cljs.core.get.call(null,send_queues,remote);
var full_remote_transaction_45829 = cljs.core.get.call(null,remote_tx_map,remote);
var fallback_45830 = untangled.client.impl.application.fallback_handler.call(null,app,full_remote_transaction_45829);
var desired_remote_mutations_45831 = untangled.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,full_remote_transaction_45829);
var has_mutations_QMARK__45832 = (cljs.core.count.call(null,desired_remote_mutations_45831) > (0));
var payload_45833 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"query","query",-1288509510),desired_remote_mutations_45831,new cljs.core.Keyword(null,"on-load","on-load",1415151594),cb,new cljs.core.Keyword(null,"on-error","on-error",1728533530),((function (seq__45824,chunk__45825,count__45826,i__45827,queue_45828,full_remote_transaction_45829,fallback_45830,desired_remote_mutations_45831,has_mutations_QMARK__45832,remote,map__45822,map__45822__$1,app,send_queues,networking){
return (function (p1__45814_SHARP_){
return fallback_45830.call(null,p1__45814_SHARP_);
});})(seq__45824,chunk__45825,count__45826,i__45827,queue_45828,full_remote_transaction_45829,fallback_45830,desired_remote_mutations_45831,has_mutations_QMARK__45832,remote,map__45822,map__45822__$1,app,send_queues,networking))
], null);
if(has_mutations_QMARK__45832){
untangled.client.impl.application.enqueue.call(null,queue_45828,payload_45833);
} else {
}

var G__45834 = seq__45824;
var G__45835 = chunk__45825;
var G__45836 = count__45826;
var G__45837 = (i__45827 + (1));
seq__45824 = G__45834;
chunk__45825 = G__45835;
count__45826 = G__45836;
i__45827 = G__45837;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__45824);
if(temp__6753__auto__){
var seq__45824__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__45824__$1)){
var c__8413__auto__ = cljs.core.chunk_first.call(null,seq__45824__$1);
var G__45838 = cljs.core.chunk_rest.call(null,seq__45824__$1);
var G__45839 = c__8413__auto__;
var G__45840 = cljs.core.count.call(null,c__8413__auto__);
var G__45841 = (0);
seq__45824 = G__45838;
chunk__45825 = G__45839;
count__45826 = G__45840;
i__45827 = G__45841;
continue;
} else {
var remote = cljs.core.first.call(null,seq__45824__$1);
var queue_45842 = cljs.core.get.call(null,send_queues,remote);
var full_remote_transaction_45843 = cljs.core.get.call(null,remote_tx_map,remote);
var fallback_45844 = untangled.client.impl.application.fallback_handler.call(null,app,full_remote_transaction_45843);
var desired_remote_mutations_45845 = untangled.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,full_remote_transaction_45843);
var has_mutations_QMARK__45846 = (cljs.core.count.call(null,desired_remote_mutations_45845) > (0));
var payload_45847 = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"query","query",-1288509510),desired_remote_mutations_45845,new cljs.core.Keyword(null,"on-load","on-load",1415151594),cb,new cljs.core.Keyword(null,"on-error","on-error",1728533530),((function (seq__45824,chunk__45825,count__45826,i__45827,queue_45842,full_remote_transaction_45843,fallback_45844,desired_remote_mutations_45845,has_mutations_QMARK__45846,remote,seq__45824__$1,temp__6753__auto__,map__45822,map__45822__$1,app,send_queues,networking){
return (function (p1__45814_SHARP_){
return fallback_45844.call(null,p1__45814_SHARP_);
});})(seq__45824,chunk__45825,count__45826,i__45827,queue_45842,full_remote_transaction_45843,fallback_45844,desired_remote_mutations_45845,has_mutations_QMARK__45846,remote,seq__45824__$1,temp__6753__auto__,map__45822,map__45822__$1,app,send_queues,networking))
], null);
if(has_mutations_QMARK__45846){
untangled.client.impl.application.enqueue.call(null,queue_45842,payload_45847);
} else {
}

var G__45848 = cljs.core.next.call(null,seq__45824__$1);
var G__45849 = null;
var G__45850 = (0);
var G__45851 = (0);
seq__45824 = G__45848;
chunk__45825 = G__45849;
count__45826 = G__45850;
i__45827 = G__45851;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Finds any loads marked `parallel` and triggers real network requests immediately. Remaining loads
 *   are pulled into a single fetch payload (combined into one query) and enqueued behind any prior mutations/reads that
 *   were already requested in a prior UI/event cycle. Thus non-parallel reads are processed in clusters grouped due to UI
 *   events (a single event might trigger many reads which will all go to the server as a single combined request).
 *   Further UI events that trigger remote interaction will end up waiting until prior network request(s) are complete.
 * 
 *   This ensures that default reasoning is simple and sequential in the face of optimistic UI updates (real network
 *   traffic characteristics could cause out of order processing, and you would not want
 *   a 'create list' to be processed on the server *after* an 'add an item to the list'). 
 */
untangled.client.impl.application.enqueue_reads = (function untangled$client$impl$application$enqueue_reads(p__45854){
var map__45877 = p__45854;
var map__45877__$1 = ((((!((map__45877 == null)))?((((map__45877.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45877.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45877):map__45877);
var send_queues = cljs.core.get.call(null,map__45877__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var reconciler = cljs.core.get.call(null,map__45877__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var networking = cljs.core.get.call(null,map__45877__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var seq__45879 = cljs.core.seq.call(null,cljs.core.keys.call(null,send_queues));
var chunk__45880 = null;
var count__45881 = (0);
var i__45882 = (0);
while(true){
if((i__45882 < count__45881)){
var remote = cljs.core._nth.call(null,chunk__45880,i__45882);
var queue_45899 = cljs.core.get.call(null,send_queues,remote);
var network_45900 = cljs.core.get.call(null,networking,remote);
var parallel_payload_45901 = untangled.client.impl.data_fetch.mark_parallel_loading.call(null,remote,reconciler);
var seq__45883_45902 = cljs.core.seq.call(null,parallel_payload_45901);
var chunk__45884_45903 = null;
var count__45885_45904 = (0);
var i__45886_45905 = (0);
while(true){
if((i__45886_45905 < count__45885_45904)){
var map__45887_45906 = cljs.core._nth.call(null,chunk__45884_45903,i__45886_45905);
var map__45887_45907__$1 = ((((!((map__45887_45906 == null)))?((((map__45887_45906.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45887_45906.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45887_45906):map__45887_45906);
var query_45908 = cljs.core.get.call(null,map__45887_45907__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_45909 = cljs.core.get.call(null,map__45887_45907__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_45910 = cljs.core.get.call(null,map__45887_45907__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors_45911 = cljs.core.get.call(null,map__45887_45907__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var on_load_SINGLEQUOTE__45912 = ((function (seq__45883_45902,chunk__45884_45903,count__45885_45904,i__45886_45905,seq__45879,chunk__45880,count__45881,i__45882,map__45887_45906,map__45887_45907__$1,query_45908,on_load_45909,on_error_45910,load_descriptors_45911,queue_45899,network_45900,parallel_payload_45901,remote,map__45877,map__45877__$1,send_queues,reconciler,networking){
return (function (p1__45852_SHARP_){
return on_load_45909.call(null,p1__45852_SHARP_,load_descriptors_45911);
});})(seq__45883_45902,chunk__45884_45903,count__45885_45904,i__45886_45905,seq__45879,chunk__45880,count__45881,i__45882,map__45887_45906,map__45887_45907__$1,query_45908,on_load_45909,on_error_45910,load_descriptors_45911,queue_45899,network_45900,parallel_payload_45901,remote,map__45877,map__45877__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__45913 = ((function (seq__45883_45902,chunk__45884_45903,count__45885_45904,i__45886_45905,seq__45879,chunk__45880,count__45881,i__45882,on_load_SINGLEQUOTE__45912,map__45887_45906,map__45887_45907__$1,query_45908,on_load_45909,on_error_45910,load_descriptors_45911,queue_45899,network_45900,parallel_payload_45901,remote,map__45877,map__45877__$1,send_queues,reconciler,networking){
return (function (p1__45853_SHARP_){
return on_error_45910.call(null,p1__45853_SHARP_,load_descriptors_45911);
});})(seq__45883_45902,chunk__45884_45903,count__45885_45904,i__45886_45905,seq__45879,chunk__45880,count__45881,i__45882,on_load_SINGLEQUOTE__45912,map__45887_45906,map__45887_45907__$1,query_45908,on_load_45909,on_error_45910,load_descriptors_45911,queue_45899,network_45900,parallel_payload_45901,remote,map__45877,map__45877__$1,send_queues,reconciler,networking))
;
untangled.client.impl.application.real_send.call(null,network_45900,query_45908,on_load_SINGLEQUOTE__45912,on_error_SINGLEQUOTE__45913,null);

var G__45914 = seq__45883_45902;
var G__45915 = chunk__45884_45903;
var G__45916 = count__45885_45904;
var G__45917 = (i__45886_45905 + (1));
seq__45883_45902 = G__45914;
chunk__45884_45903 = G__45915;
count__45885_45904 = G__45916;
i__45886_45905 = G__45917;
continue;
} else {
var temp__6753__auto___45918 = cljs.core.seq.call(null,seq__45883_45902);
if(temp__6753__auto___45918){
var seq__45883_45919__$1 = temp__6753__auto___45918;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__45883_45919__$1)){
var c__8413__auto___45920 = cljs.core.chunk_first.call(null,seq__45883_45919__$1);
var G__45921 = cljs.core.chunk_rest.call(null,seq__45883_45919__$1);
var G__45922 = c__8413__auto___45920;
var G__45923 = cljs.core.count.call(null,c__8413__auto___45920);
var G__45924 = (0);
seq__45883_45902 = G__45921;
chunk__45884_45903 = G__45922;
count__45885_45904 = G__45923;
i__45886_45905 = G__45924;
continue;
} else {
var map__45889_45925 = cljs.core.first.call(null,seq__45883_45919__$1);
var map__45889_45926__$1 = ((((!((map__45889_45925 == null)))?((((map__45889_45925.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45889_45925.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45889_45925):map__45889_45925);
var query_45927 = cljs.core.get.call(null,map__45889_45926__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_45928 = cljs.core.get.call(null,map__45889_45926__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_45929 = cljs.core.get.call(null,map__45889_45926__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors_45930 = cljs.core.get.call(null,map__45889_45926__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var on_load_SINGLEQUOTE__45931 = ((function (seq__45883_45902,chunk__45884_45903,count__45885_45904,i__45886_45905,seq__45879,chunk__45880,count__45881,i__45882,map__45889_45925,map__45889_45926__$1,query_45927,on_load_45928,on_error_45929,load_descriptors_45930,seq__45883_45919__$1,temp__6753__auto___45918,queue_45899,network_45900,parallel_payload_45901,remote,map__45877,map__45877__$1,send_queues,reconciler,networking){
return (function (p1__45852_SHARP_){
return on_load_45928.call(null,p1__45852_SHARP_,load_descriptors_45930);
});})(seq__45883_45902,chunk__45884_45903,count__45885_45904,i__45886_45905,seq__45879,chunk__45880,count__45881,i__45882,map__45889_45925,map__45889_45926__$1,query_45927,on_load_45928,on_error_45929,load_descriptors_45930,seq__45883_45919__$1,temp__6753__auto___45918,queue_45899,network_45900,parallel_payload_45901,remote,map__45877,map__45877__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__45932 = ((function (seq__45883_45902,chunk__45884_45903,count__45885_45904,i__45886_45905,seq__45879,chunk__45880,count__45881,i__45882,on_load_SINGLEQUOTE__45931,map__45889_45925,map__45889_45926__$1,query_45927,on_load_45928,on_error_45929,load_descriptors_45930,seq__45883_45919__$1,temp__6753__auto___45918,queue_45899,network_45900,parallel_payload_45901,remote,map__45877,map__45877__$1,send_queues,reconciler,networking){
return (function (p1__45853_SHARP_){
return on_error_45929.call(null,p1__45853_SHARP_,load_descriptors_45930);
});})(seq__45883_45902,chunk__45884_45903,count__45885_45904,i__45886_45905,seq__45879,chunk__45880,count__45881,i__45882,on_load_SINGLEQUOTE__45931,map__45889_45925,map__45889_45926__$1,query_45927,on_load_45928,on_error_45929,load_descriptors_45930,seq__45883_45919__$1,temp__6753__auto___45918,queue_45899,network_45900,parallel_payload_45901,remote,map__45877,map__45877__$1,send_queues,reconciler,networking))
;
untangled.client.impl.application.real_send.call(null,network_45900,query_45927,on_load_SINGLEQUOTE__45931,on_error_SINGLEQUOTE__45932,null);

var G__45933 = cljs.core.next.call(null,seq__45883_45919__$1);
var G__45934 = null;
var G__45935 = (0);
var G__45936 = (0);
seq__45883_45902 = G__45933;
chunk__45884_45903 = G__45934;
count__45885_45904 = G__45935;
i__45886_45905 = G__45936;
continue;
}
} else {
}
}
break;
}

var fetch_payload_45937 = untangled.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
while(true){
if(cljs.core.truth_(fetch_payload_45937)){
untangled.client.impl.application.enqueue.call(null,queue_45899,cljs.core.assoc.call(null,fetch_payload_45937,new cljs.core.Keyword(null,"networking","networking",586110628),network_45900));

var G__45938 = untangled.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
fetch_payload_45937 = G__45938;
continue;
} else {
}
break;
}

var G__45939 = seq__45879;
var G__45940 = chunk__45880;
var G__45941 = count__45881;
var G__45942 = (i__45882 + (1));
seq__45879 = G__45939;
chunk__45880 = G__45940;
count__45881 = G__45941;
i__45882 = G__45942;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__45879);
if(temp__6753__auto__){
var seq__45879__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__45879__$1)){
var c__8413__auto__ = cljs.core.chunk_first.call(null,seq__45879__$1);
var G__45943 = cljs.core.chunk_rest.call(null,seq__45879__$1);
var G__45944 = c__8413__auto__;
var G__45945 = cljs.core.count.call(null,c__8413__auto__);
var G__45946 = (0);
seq__45879 = G__45943;
chunk__45880 = G__45944;
count__45881 = G__45945;
i__45882 = G__45946;
continue;
} else {
var remote = cljs.core.first.call(null,seq__45879__$1);
var queue_45947 = cljs.core.get.call(null,send_queues,remote);
var network_45948 = cljs.core.get.call(null,networking,remote);
var parallel_payload_45949 = untangled.client.impl.data_fetch.mark_parallel_loading.call(null,remote,reconciler);
var seq__45891_45950 = cljs.core.seq.call(null,parallel_payload_45949);
var chunk__45892_45951 = null;
var count__45893_45952 = (0);
var i__45894_45953 = (0);
while(true){
if((i__45894_45953 < count__45893_45952)){
var map__45895_45954 = cljs.core._nth.call(null,chunk__45892_45951,i__45894_45953);
var map__45895_45955__$1 = ((((!((map__45895_45954 == null)))?((((map__45895_45954.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45895_45954.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45895_45954):map__45895_45954);
var query_45956 = cljs.core.get.call(null,map__45895_45955__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_45957 = cljs.core.get.call(null,map__45895_45955__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_45958 = cljs.core.get.call(null,map__45895_45955__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors_45959 = cljs.core.get.call(null,map__45895_45955__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var on_load_SINGLEQUOTE__45960 = ((function (seq__45891_45950,chunk__45892_45951,count__45893_45952,i__45894_45953,seq__45879,chunk__45880,count__45881,i__45882,map__45895_45954,map__45895_45955__$1,query_45956,on_load_45957,on_error_45958,load_descriptors_45959,queue_45947,network_45948,parallel_payload_45949,remote,seq__45879__$1,temp__6753__auto__,map__45877,map__45877__$1,send_queues,reconciler,networking){
return (function (p1__45852_SHARP_){
return on_load_45957.call(null,p1__45852_SHARP_,load_descriptors_45959);
});})(seq__45891_45950,chunk__45892_45951,count__45893_45952,i__45894_45953,seq__45879,chunk__45880,count__45881,i__45882,map__45895_45954,map__45895_45955__$1,query_45956,on_load_45957,on_error_45958,load_descriptors_45959,queue_45947,network_45948,parallel_payload_45949,remote,seq__45879__$1,temp__6753__auto__,map__45877,map__45877__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__45961 = ((function (seq__45891_45950,chunk__45892_45951,count__45893_45952,i__45894_45953,seq__45879,chunk__45880,count__45881,i__45882,on_load_SINGLEQUOTE__45960,map__45895_45954,map__45895_45955__$1,query_45956,on_load_45957,on_error_45958,load_descriptors_45959,queue_45947,network_45948,parallel_payload_45949,remote,seq__45879__$1,temp__6753__auto__,map__45877,map__45877__$1,send_queues,reconciler,networking){
return (function (p1__45853_SHARP_){
return on_error_45958.call(null,p1__45853_SHARP_,load_descriptors_45959);
});})(seq__45891_45950,chunk__45892_45951,count__45893_45952,i__45894_45953,seq__45879,chunk__45880,count__45881,i__45882,on_load_SINGLEQUOTE__45960,map__45895_45954,map__45895_45955__$1,query_45956,on_load_45957,on_error_45958,load_descriptors_45959,queue_45947,network_45948,parallel_payload_45949,remote,seq__45879__$1,temp__6753__auto__,map__45877,map__45877__$1,send_queues,reconciler,networking))
;
untangled.client.impl.application.real_send.call(null,network_45948,query_45956,on_load_SINGLEQUOTE__45960,on_error_SINGLEQUOTE__45961,null);

var G__45962 = seq__45891_45950;
var G__45963 = chunk__45892_45951;
var G__45964 = count__45893_45952;
var G__45965 = (i__45894_45953 + (1));
seq__45891_45950 = G__45962;
chunk__45892_45951 = G__45963;
count__45893_45952 = G__45964;
i__45894_45953 = G__45965;
continue;
} else {
var temp__6753__auto___45966__$1 = cljs.core.seq.call(null,seq__45891_45950);
if(temp__6753__auto___45966__$1){
var seq__45891_45967__$1 = temp__6753__auto___45966__$1;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__45891_45967__$1)){
var c__8413__auto___45968 = cljs.core.chunk_first.call(null,seq__45891_45967__$1);
var G__45969 = cljs.core.chunk_rest.call(null,seq__45891_45967__$1);
var G__45970 = c__8413__auto___45968;
var G__45971 = cljs.core.count.call(null,c__8413__auto___45968);
var G__45972 = (0);
seq__45891_45950 = G__45969;
chunk__45892_45951 = G__45970;
count__45893_45952 = G__45971;
i__45894_45953 = G__45972;
continue;
} else {
var map__45897_45973 = cljs.core.first.call(null,seq__45891_45967__$1);
var map__45897_45974__$1 = ((((!((map__45897_45973 == null)))?((((map__45897_45973.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45897_45973.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45897_45973):map__45897_45973);
var query_45975 = cljs.core.get.call(null,map__45897_45974__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_45976 = cljs.core.get.call(null,map__45897_45974__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_45977 = cljs.core.get.call(null,map__45897_45974__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors_45978 = cljs.core.get.call(null,map__45897_45974__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var on_load_SINGLEQUOTE__45979 = ((function (seq__45891_45950,chunk__45892_45951,count__45893_45952,i__45894_45953,seq__45879,chunk__45880,count__45881,i__45882,map__45897_45973,map__45897_45974__$1,query_45975,on_load_45976,on_error_45977,load_descriptors_45978,seq__45891_45967__$1,temp__6753__auto___45966__$1,queue_45947,network_45948,parallel_payload_45949,remote,seq__45879__$1,temp__6753__auto__,map__45877,map__45877__$1,send_queues,reconciler,networking){
return (function (p1__45852_SHARP_){
return on_load_45976.call(null,p1__45852_SHARP_,load_descriptors_45978);
});})(seq__45891_45950,chunk__45892_45951,count__45893_45952,i__45894_45953,seq__45879,chunk__45880,count__45881,i__45882,map__45897_45973,map__45897_45974__$1,query_45975,on_load_45976,on_error_45977,load_descriptors_45978,seq__45891_45967__$1,temp__6753__auto___45966__$1,queue_45947,network_45948,parallel_payload_45949,remote,seq__45879__$1,temp__6753__auto__,map__45877,map__45877__$1,send_queues,reconciler,networking))
;
var on_error_SINGLEQUOTE__45980 = ((function (seq__45891_45950,chunk__45892_45951,count__45893_45952,i__45894_45953,seq__45879,chunk__45880,count__45881,i__45882,on_load_SINGLEQUOTE__45979,map__45897_45973,map__45897_45974__$1,query_45975,on_load_45976,on_error_45977,load_descriptors_45978,seq__45891_45967__$1,temp__6753__auto___45966__$1,queue_45947,network_45948,parallel_payload_45949,remote,seq__45879__$1,temp__6753__auto__,map__45877,map__45877__$1,send_queues,reconciler,networking){
return (function (p1__45853_SHARP_){
return on_error_45977.call(null,p1__45853_SHARP_,load_descriptors_45978);
});})(seq__45891_45950,chunk__45892_45951,count__45893_45952,i__45894_45953,seq__45879,chunk__45880,count__45881,i__45882,on_load_SINGLEQUOTE__45979,map__45897_45973,map__45897_45974__$1,query_45975,on_load_45976,on_error_45977,load_descriptors_45978,seq__45891_45967__$1,temp__6753__auto___45966__$1,queue_45947,network_45948,parallel_payload_45949,remote,seq__45879__$1,temp__6753__auto__,map__45877,map__45877__$1,send_queues,reconciler,networking))
;
untangled.client.impl.application.real_send.call(null,network_45948,query_45975,on_load_SINGLEQUOTE__45979,on_error_SINGLEQUOTE__45980,null);

var G__45981 = cljs.core.next.call(null,seq__45891_45967__$1);
var G__45982 = null;
var G__45983 = (0);
var G__45984 = (0);
seq__45891_45950 = G__45981;
chunk__45892_45951 = G__45982;
count__45893_45952 = G__45983;
i__45894_45953 = G__45984;
continue;
}
} else {
}
}
break;
}

var fetch_payload_45985 = untangled.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
while(true){
if(cljs.core.truth_(fetch_payload_45985)){
untangled.client.impl.application.enqueue.call(null,queue_45947,cljs.core.assoc.call(null,fetch_payload_45985,new cljs.core.Keyword(null,"networking","networking",586110628),network_45948));

var G__45986 = untangled.client.impl.data_fetch.mark_loading.call(null,remote,reconciler);
fetch_payload_45985 = G__45986;
continue;
} else {
}
break;
}

var G__45987 = cljs.core.next.call(null,seq__45879__$1);
var G__45988 = null;
var G__45989 = (0);
var G__45990 = (0);
seq__45879 = G__45987;
chunk__45880 = G__45988;
count__45881 = G__45989;
i__45882 = G__45990;
continue;
}
} else {
return null;
}
}
break;
}
});
untangled.client.impl.application.detect_errant_remotes = (function untangled$client$impl$application$detect_errant_remotes(p__45991){
var map__45994 = p__45991;
var map__45994__$1 = ((((!((map__45994 == null)))?((((map__45994.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__45994.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__45994):map__45994);
var app = map__45994__$1;
var reconciler = cljs.core.get.call(null,map__45994__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var send_queues = cljs.core.get.call(null,map__45994__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var state = om.next.app_state.call(null,reconciler);
var all_items = cljs.core.get.call(null,cljs.core.deref.call(null,state),new cljs.core.Keyword("untangled","ready-to-load","untangled/ready-to-load",-617804257));
var item_remotes = cljs.core.into.call(null,cljs.core.PersistentHashSet.EMPTY,cljs.core.map.call(null,untangled.client.impl.data_fetch.data_remote,all_items));
var all_remotes = cljs.core.set.call(null,cljs.core.keys.call(null,send_queues));
var invalid_remotes = clojure.set.difference.call(null,item_remotes,all_remotes);
if(cljs.core.truth_(cljs.core.not_empty.call(null,invalid_remotes))){
return untangled.client.logging.error.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Use of invalid remote(s) detected! "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(invalid_remotes)].join(''));
} else {
return null;
}
});
/**
 * Puts queries/mutations (and their corresponding callbacks) onto the send queue. The networking code will pull these
 *   off one at a time and send them through the real networking layer. Reads are guaranteed to *follow* writes.
 */
untangled.client.impl.application.server_send = (function untangled$client$impl$application$server_send(app,remote_tx_map,cb){
untangled.client.impl.application.detect_errant_remotes.call(null,app);

untangled.client.impl.application.enqueue_mutations.call(null,app,remote_tx_map,cb);

return untangled.client.impl.application.enqueue_reads.call(null,app);
});
/**
 * Sends a network payload. There are two kinds of payloads in Untanged. The first is
 *   for reads, which are tracked by load descriptors in the app state. These load descriptors
 *   tell the plumbing how to handle the response, and expect to only be merged in once. Mutations
 *   do not have a payload, and can technically received progress updates from the network. The built-in
 *   networking does not (currently) give progress events, but plugin networking can. It is currently not
 *   supported to give an update on a load, so this function is careful to detect that a payload is a send
 *   and turns all but the last update into a no-op. The send-complete function comes from the
 *   network sequential processing loop, and when called unblocks the network processing to allow the
 *   next request to go. Be very careful with this code, as bugs will cause applications to stop responding
 *   to remote requests.
 */
untangled.client.impl.application.send_payload = (function untangled$client$impl$application$send_payload(network,payload,send_complete){
var map__46000 = payload;
var map__46000__$1 = ((((!((map__46000 == null)))?((((map__46000.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46000.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46000):map__46000);
var query = cljs.core.get.call(null,map__46000__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load = cljs.core.get.call(null,map__46000__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error = cljs.core.get.call(null,map__46000__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var load_descriptors = cljs.core.get.call(null,map__46000__$1,new cljs.core.Keyword(null,"load-descriptors","load-descriptors",391720681));
var merge_data = (cljs.core.truth_(load_descriptors)?((function (map__46000,map__46000__$1,query,on_load,on_error,load_descriptors){
return (function (p1__45996_SHARP_){
return on_load.call(null,p1__45996_SHARP_,load_descriptors);
});})(map__46000,map__46000__$1,query,on_load,on_error,load_descriptors))
:on_load);
var on_update = (cljs.core.truth_(load_descriptors)?cljs.core.identity:merge_data);
var on_error__$1 = (cljs.core.truth_(load_descriptors)?((function (map__46000,map__46000__$1,query,on_load,on_error,load_descriptors,merge_data,on_update){
return (function (p1__45997_SHARP_){
return on_error.call(null,p1__45997_SHARP_,load_descriptors);
});})(map__46000,map__46000__$1,query,on_load,on_error,load_descriptors,merge_data,on_update))
:on_error);
var on_error__$2 = cljs.core.comp.call(null,send_complete,on_error__$1);
var on_done = cljs.core.comp.call(null,send_complete,merge_data);
return untangled.client.impl.application.real_send.call(null,network,query,on_done,on_error__$2,on_update);
});
/**
 * Starts a async go loop that sends network requests on a networking object's request queue. Must be called once and only
 *   once for each active networking object on the UI. Each iteration of the loop pulls off a
 *   single request, sends it, waits for the response, and then repeats. Gives the appearance of a separate networking
 *   'thread' using core async.
 */
untangled.client.impl.application.start_network_sequential_processing = (function untangled$client$impl$application$start_network_sequential_processing(p__46002){
var map__46089 = p__46002;
var map__46089__$1 = ((((!((map__46089 == null)))?((((map__46089.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46089.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46089):map__46089);
var networking = cljs.core.get.call(null,map__46089__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var send_queues = cljs.core.get.call(null,map__46089__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var response_channels = cljs.core.get.call(null,map__46089__$1,new cljs.core.Keyword(null,"response-channels","response-channels",-1871059128));
var seq__46091 = cljs.core.seq.call(null,cljs.core.keys.call(null,send_queues));
var chunk__46092 = null;
var count__46093 = (0);
var i__46094 = (0);
while(true){
if((i__46094 < count__46093)){
var remote = cljs.core._nth.call(null,chunk__46092,i__46094);
var queue_46175 = cljs.core.get.call(null,send_queues,remote);
var network_46176 = cljs.core.get.call(null,networking,remote);
var response_channel_46177 = cljs.core.get.call(null,response_channels,remote);
var send_complete_46178 = ((function (seq__46091,chunk__46092,count__46093,i__46094,queue_46175,network_46176,response_channel_46177,remote,map__46089,map__46089__$1,networking,send_queues,response_channels){
return (function (){
var c__42603__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__46091,chunk__46092,count__46093,i__46094,c__42603__auto__,queue_46175,network_46176,response_channel_46177,remote,map__46089,map__46089__$1,networking,send_queues,response_channels){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (seq__46091,chunk__46092,count__46093,i__46094,c__42603__auto__,queue_46175,network_46176,response_channel_46177,remote,map__46089,map__46089__$1,networking,send_queues,response_channels){
return (function (state_46098){
var state_val_46099 = (state_46098[(1)]);
if((state_val_46099 === (1))){
var state_46098__$1 = state_46098;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46098__$1,(2),response_channel_46177,new cljs.core.Keyword(null,"complete","complete",-500388775));
} else {
if((state_val_46099 === (2))){
var inst_46096 = (state_46098[(2)]);
var state_46098__$1 = state_46098;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46098__$1,inst_46096);
} else {
return null;
}
}
});})(seq__46091,chunk__46092,count__46093,i__46094,c__42603__auto__,queue_46175,network_46176,response_channel_46177,remote,map__46089,map__46089__$1,networking,send_queues,response_channels))
;
return ((function (seq__46091,chunk__46092,count__46093,i__46094,switch__42489__auto__,c__42603__auto__,queue_46175,network_46176,response_channel_46177,remote,map__46089,map__46089__$1,networking,send_queues,response_channels){
return (function() {
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__ = null;
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____0 = (function (){
var statearr_46103 = [null,null,null,null,null,null,null];
(statearr_46103[(0)] = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__);

(statearr_46103[(1)] = (1));

return statearr_46103;
});
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____1 = (function (state_46098){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_46098);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e46104){if((e46104 instanceof Object)){
var ex__42493__auto__ = e46104;
var statearr_46105_46179 = state_46098;
(statearr_46105_46179[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46098);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46104;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46180 = state_46098;
state_46098 = G__46180;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__ = function(state_46098){
switch(arguments.length){
case 0:
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____0.call(this);
case 1:
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____1.call(this,state_46098);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____0;
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____1;
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__;
})()
;})(seq__46091,chunk__46092,count__46093,i__46094,switch__42489__auto__,c__42603__auto__,queue_46175,network_46176,response_channel_46177,remote,map__46089,map__46089__$1,networking,send_queues,response_channels))
})();
var state__42605__auto__ = (function (){var statearr_46106 = f__42604__auto__.call(null);
(statearr_46106[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto__);

return statearr_46106;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(seq__46091,chunk__46092,count__46093,i__46094,c__42603__auto__,queue_46175,network_46176,response_channel_46177,remote,map__46089,map__46089__$1,networking,send_queues,response_channels))
);

return c__42603__auto__;
});})(seq__46091,chunk__46092,count__46093,i__46094,queue_46175,network_46176,response_channel_46177,remote,map__46089,map__46089__$1,networking,send_queues,response_channels))
;
var c__42603__auto___46181 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__46091,chunk__46092,count__46093,i__46094,c__42603__auto___46181,queue_46175,network_46176,response_channel_46177,send_complete_46178,remote,map__46089,map__46089__$1,networking,send_queues,response_channels){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (seq__46091,chunk__46092,count__46093,i__46094,c__42603__auto___46181,queue_46175,network_46176,response_channel_46177,send_complete_46178,remote,map__46089,map__46089__$1,networking,send_queues,response_channels){
return (function (state_46120){
var state_val_46121 = (state_46120[(1)]);
if((state_val_46121 === (1))){
var state_46120__$1 = state_46120;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46120__$1,(2),queue_46175);
} else {
if((state_val_46121 === (2))){
var inst_46108 = (state_46120[(2)]);
var inst_46109 = inst_46108;
var state_46120__$1 = (function (){var statearr_46122 = state_46120;
(statearr_46122[(7)] = inst_46109);

return statearr_46122;
})();
var statearr_46123_46182 = state_46120__$1;
(statearr_46123_46182[(2)] = null);

(statearr_46123_46182[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46121 === (3))){
var inst_46109 = (state_46120[(7)]);
var inst_46111 = untangled.client.impl.application.send_payload.call(null,network_46176,inst_46109,send_complete_46178);
var state_46120__$1 = (function (){var statearr_46124 = state_46120;
(statearr_46124[(8)] = inst_46111);

return statearr_46124;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46120__$1,(5),response_channel_46177);
} else {
if((state_val_46121 === (4))){
var inst_46118 = (state_46120[(2)]);
var state_46120__$1 = state_46120;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46120__$1,inst_46118);
} else {
if((state_val_46121 === (5))){
var inst_46113 = (state_46120[(2)]);
var state_46120__$1 = (function (){var statearr_46125 = state_46120;
(statearr_46125[(9)] = inst_46113);

return statearr_46125;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46120__$1,(6),queue_46175);
} else {
if((state_val_46121 === (6))){
var inst_46115 = (state_46120[(2)]);
var inst_46109 = inst_46115;
var state_46120__$1 = (function (){var statearr_46126 = state_46120;
(statearr_46126[(7)] = inst_46109);

return statearr_46126;
})();
var statearr_46127_46183 = state_46120__$1;
(statearr_46127_46183[(2)] = null);

(statearr_46127_46183[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});})(seq__46091,chunk__46092,count__46093,i__46094,c__42603__auto___46181,queue_46175,network_46176,response_channel_46177,send_complete_46178,remote,map__46089,map__46089__$1,networking,send_queues,response_channels))
;
return ((function (seq__46091,chunk__46092,count__46093,i__46094,switch__42489__auto__,c__42603__auto___46181,queue_46175,network_46176,response_channel_46177,send_complete_46178,remote,map__46089,map__46089__$1,networking,send_queues,response_channels){
return (function() {
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__ = null;
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____0 = (function (){
var statearr_46131 = [null,null,null,null,null,null,null,null,null,null];
(statearr_46131[(0)] = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__);

(statearr_46131[(1)] = (1));

return statearr_46131;
});
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____1 = (function (state_46120){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_46120);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e46132){if((e46132 instanceof Object)){
var ex__42493__auto__ = e46132;
var statearr_46133_46184 = state_46120;
(statearr_46133_46184[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46120);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46132;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46185 = state_46120;
state_46120 = G__46185;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__ = function(state_46120){
switch(arguments.length){
case 0:
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____0.call(this);
case 1:
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____1.call(this,state_46120);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____0;
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____1;
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__;
})()
;})(seq__46091,chunk__46092,count__46093,i__46094,switch__42489__auto__,c__42603__auto___46181,queue_46175,network_46176,response_channel_46177,send_complete_46178,remote,map__46089,map__46089__$1,networking,send_queues,response_channels))
})();
var state__42605__auto__ = (function (){var statearr_46134 = f__42604__auto__.call(null);
(statearr_46134[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___46181);

return statearr_46134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(seq__46091,chunk__46092,count__46093,i__46094,c__42603__auto___46181,queue_46175,network_46176,response_channel_46177,send_complete_46178,remote,map__46089,map__46089__$1,networking,send_queues,response_channels))
);


var G__46186 = seq__46091;
var G__46187 = chunk__46092;
var G__46188 = count__46093;
var G__46189 = (i__46094 + (1));
seq__46091 = G__46186;
chunk__46092 = G__46187;
count__46093 = G__46188;
i__46094 = G__46189;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__46091);
if(temp__6753__auto__){
var seq__46091__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46091__$1)){
var c__8413__auto__ = cljs.core.chunk_first.call(null,seq__46091__$1);
var G__46190 = cljs.core.chunk_rest.call(null,seq__46091__$1);
var G__46191 = c__8413__auto__;
var G__46192 = cljs.core.count.call(null,c__8413__auto__);
var G__46193 = (0);
seq__46091 = G__46190;
chunk__46092 = G__46191;
count__46093 = G__46192;
i__46094 = G__46193;
continue;
} else {
var remote = cljs.core.first.call(null,seq__46091__$1);
var queue_46194 = cljs.core.get.call(null,send_queues,remote);
var network_46195 = cljs.core.get.call(null,networking,remote);
var response_channel_46196 = cljs.core.get.call(null,response_channels,remote);
var send_complete_46197 = ((function (seq__46091,chunk__46092,count__46093,i__46094,queue_46194,network_46195,response_channel_46196,remote,seq__46091__$1,temp__6753__auto__,map__46089,map__46089__$1,networking,send_queues,response_channels){
return (function (){
var c__42603__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__46091,chunk__46092,count__46093,i__46094,c__42603__auto__,queue_46194,network_46195,response_channel_46196,remote,seq__46091__$1,temp__6753__auto__,map__46089,map__46089__$1,networking,send_queues,response_channels){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (seq__46091,chunk__46092,count__46093,i__46094,c__42603__auto__,queue_46194,network_46195,response_channel_46196,remote,seq__46091__$1,temp__6753__auto__,map__46089,map__46089__$1,networking,send_queues,response_channels){
return (function (state_46138){
var state_val_46139 = (state_46138[(1)]);
if((state_val_46139 === (1))){
var state_46138__$1 = state_46138;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_46138__$1,(2),response_channel_46196,new cljs.core.Keyword(null,"complete","complete",-500388775));
} else {
if((state_val_46139 === (2))){
var inst_46136 = (state_46138[(2)]);
var state_46138__$1 = state_46138;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46138__$1,inst_46136);
} else {
return null;
}
}
});})(seq__46091,chunk__46092,count__46093,i__46094,c__42603__auto__,queue_46194,network_46195,response_channel_46196,remote,seq__46091__$1,temp__6753__auto__,map__46089,map__46089__$1,networking,send_queues,response_channels))
;
return ((function (seq__46091,chunk__46092,count__46093,i__46094,switch__42489__auto__,c__42603__auto__,queue_46194,network_46195,response_channel_46196,remote,seq__46091__$1,temp__6753__auto__,map__46089,map__46089__$1,networking,send_queues,response_channels){
return (function() {
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__ = null;
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____0 = (function (){
var statearr_46143 = [null,null,null,null,null,null,null];
(statearr_46143[(0)] = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__);

(statearr_46143[(1)] = (1));

return statearr_46143;
});
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____1 = (function (state_46138){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_46138);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e46144){if((e46144 instanceof Object)){
var ex__42493__auto__ = e46144;
var statearr_46145_46198 = state_46138;
(statearr_46145_46198[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46138);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46144;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46199 = state_46138;
state_46138 = G__46199;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__ = function(state_46138){
switch(arguments.length){
case 0:
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____0.call(this);
case 1:
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____1.call(this,state_46138);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____0;
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____1;
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__;
})()
;})(seq__46091,chunk__46092,count__46093,i__46094,switch__42489__auto__,c__42603__auto__,queue_46194,network_46195,response_channel_46196,remote,seq__46091__$1,temp__6753__auto__,map__46089,map__46089__$1,networking,send_queues,response_channels))
})();
var state__42605__auto__ = (function (){var statearr_46146 = f__42604__auto__.call(null);
(statearr_46146[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto__);

return statearr_46146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(seq__46091,chunk__46092,count__46093,i__46094,c__42603__auto__,queue_46194,network_46195,response_channel_46196,remote,seq__46091__$1,temp__6753__auto__,map__46089,map__46089__$1,networking,send_queues,response_channels))
);

return c__42603__auto__;
});})(seq__46091,chunk__46092,count__46093,i__46094,queue_46194,network_46195,response_channel_46196,remote,seq__46091__$1,temp__6753__auto__,map__46089,map__46089__$1,networking,send_queues,response_channels))
;
var c__42603__auto___46200 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (seq__46091,chunk__46092,count__46093,i__46094,c__42603__auto___46200,queue_46194,network_46195,response_channel_46196,send_complete_46197,remote,seq__46091__$1,temp__6753__auto__,map__46089,map__46089__$1,networking,send_queues,response_channels){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (seq__46091,chunk__46092,count__46093,i__46094,c__42603__auto___46200,queue_46194,network_46195,response_channel_46196,send_complete_46197,remote,seq__46091__$1,temp__6753__auto__,map__46089,map__46089__$1,networking,send_queues,response_channels){
return (function (state_46160){
var state_val_46161 = (state_46160[(1)]);
if((state_val_46161 === (1))){
var state_46160__$1 = state_46160;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46160__$1,(2),queue_46194);
} else {
if((state_val_46161 === (2))){
var inst_46148 = (state_46160[(2)]);
var inst_46149 = inst_46148;
var state_46160__$1 = (function (){var statearr_46162 = state_46160;
(statearr_46162[(7)] = inst_46149);

return statearr_46162;
})();
var statearr_46163_46201 = state_46160__$1;
(statearr_46163_46201[(2)] = null);

(statearr_46163_46201[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_46161 === (3))){
var inst_46149 = (state_46160[(7)]);
var inst_46151 = untangled.client.impl.application.send_payload.call(null,network_46195,inst_46149,send_complete_46197);
var state_46160__$1 = (function (){var statearr_46164 = state_46160;
(statearr_46164[(8)] = inst_46151);

return statearr_46164;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46160__$1,(5),response_channel_46196);
} else {
if((state_val_46161 === (4))){
var inst_46158 = (state_46160[(2)]);
var state_46160__$1 = state_46160;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_46160__$1,inst_46158);
} else {
if((state_val_46161 === (5))){
var inst_46153 = (state_46160[(2)]);
var state_46160__$1 = (function (){var statearr_46165 = state_46160;
(statearr_46165[(9)] = inst_46153);

return statearr_46165;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_46160__$1,(6),queue_46194);
} else {
if((state_val_46161 === (6))){
var inst_46155 = (state_46160[(2)]);
var inst_46149 = inst_46155;
var state_46160__$1 = (function (){var statearr_46166 = state_46160;
(statearr_46166[(7)] = inst_46149);

return statearr_46166;
})();
var statearr_46167_46202 = state_46160__$1;
(statearr_46167_46202[(2)] = null);

(statearr_46167_46202[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
});})(seq__46091,chunk__46092,count__46093,i__46094,c__42603__auto___46200,queue_46194,network_46195,response_channel_46196,send_complete_46197,remote,seq__46091__$1,temp__6753__auto__,map__46089,map__46089__$1,networking,send_queues,response_channels))
;
return ((function (seq__46091,chunk__46092,count__46093,i__46094,switch__42489__auto__,c__42603__auto___46200,queue_46194,network_46195,response_channel_46196,send_complete_46197,remote,seq__46091__$1,temp__6753__auto__,map__46089,map__46089__$1,networking,send_queues,response_channels){
return (function() {
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__ = null;
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____0 = (function (){
var statearr_46171 = [null,null,null,null,null,null,null,null,null,null];
(statearr_46171[(0)] = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__);

(statearr_46171[(1)] = (1));

return statearr_46171;
});
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____1 = (function (state_46160){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_46160);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e46172){if((e46172 instanceof Object)){
var ex__42493__auto__ = e46172;
var statearr_46173_46203 = state_46160;
(statearr_46173_46203[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_46160);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e46172;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__46204 = state_46160;
state_46160 = G__46204;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__ = function(state_46160){
switch(arguments.length){
case 0:
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____0.call(this);
case 1:
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____1.call(this,state_46160);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____0;
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto____1;
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__42490__auto__;
})()
;})(seq__46091,chunk__46092,count__46093,i__46094,switch__42489__auto__,c__42603__auto___46200,queue_46194,network_46195,response_channel_46196,send_complete_46197,remote,seq__46091__$1,temp__6753__auto__,map__46089,map__46089__$1,networking,send_queues,response_channels))
})();
var state__42605__auto__ = (function (){var statearr_46174 = f__42604__auto__.call(null);
(statearr_46174[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___46200);

return statearr_46174;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(seq__46091,chunk__46092,count__46093,i__46094,c__42603__auto___46200,queue_46194,network_46195,response_channel_46196,send_complete_46197,remote,seq__46091__$1,temp__6753__auto__,map__46089,map__46089__$1,networking,send_queues,response_channels))
);


var G__46205 = cljs.core.next.call(null,seq__46091__$1);
var G__46206 = null;
var G__46207 = (0);
var G__46208 = (0);
seq__46091 = G__46205;
chunk__46092 = G__46206;
count__46093 = G__46207;
i__46094 = G__46208;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Configure a re-render when the locale changes. During startup this function will be called once for each
 *   reconciler that is running on a page.
 */
untangled.client.impl.application.initialize_internationalization = (function untangled$client$impl$application$initialize_internationalization(reconciler){
cljs.core.remove_watch.call(null,untangled.i18n.core._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697));

return cljs.core.add_watch.call(null,untangled.i18n.core._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697),(function (k,r,o,n){
if(om.next.mounted_QMARK_.call(null,om.next.app_root.call(null,reconciler))){
return om.next.force_root_render_BANG_.call(null,reconciler);
} else {
return null;
}
}));
});
/**
 * Remove not-found keys from m (non-recursive)
 */
untangled.client.impl.application.sweep_one = (function untangled$client$impl$application$sweep_one(m){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__46213){
var vec__46214 = p__46213;
var k = cljs.core.nth.call(null,vec__46214,(0),null);
var v = cljs.core.nth.call(null,vec__46214,(1),null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494),v)){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,v);
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,untangled.client.impl.application.sweep_one,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
});
/**
 * Remove all of the not-found keys (recursively) from v, stopping at marked leaves (if present)
 */
untangled.client.impl.application.sweep = (function untangled$client$impl$application$sweep(m){
if(cljs.core.truth_(untangled.client.impl.om_plumbing.leaf_QMARK_.call(null,m))){
return untangled.client.impl.application.sweep_one.call(null,m);
} else {
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__46221){
var vec__46222 = p__46221;
var k = cljs.core.nth.call(null,vec__46222,(0),null);
var v = cljs.core.nth.call(null,vec__46222,(1),null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494),v)){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep.call(null,v));
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,untangled.client.impl.application.sweep,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
}
});
/**
 * Do a recursive merge of source into target, but remove any target data that is marked as missing in the response. The
 *   missing marker is generated in the source when something has been asked for in the query, but had no value in the
 *   response. This allows us to correctly remove 'empty' data from the database without accidentally removing something
 *   that may still exist on the server (in truth we don't know its status, since it wasn't asked for, but we leave
 *   it as our 'best guess')
 */
untangled.client.impl.application.sweep_merge = (function untangled$client$impl$application$sweep_merge(target,source){
return cljs.core.reduce.call(null,(function (acc,p__46229){
var vec__46230 = p__46229;
var k = cljs.core.nth.call(null,vec__46230,(0),null);
var v = cljs.core.nth.call(null,vec__46230,(1),null);
if(cljs.core._EQ_.call(null,v,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494))){
return cljs.core.dissoc.call(null,acc,k);
} else {
if(cljs.core.truth_(untangled.client.impl.om_plumbing.leaf_QMARK_.call(null,v))){
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep_one.call(null,v));
} else {
if((cljs.core.map_QMARK_.call(null,cljs.core.get.call(null,acc,k))) && (cljs.core.map_QMARK_.call(null,v))){
return cljs.core.update.call(null,acc,k,untangled.client.impl.application.sweep_merge,v);
} else {
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep.call(null,v));

}
}
}
}),target,source);
});
untangled.client.impl.application.merge_handler = (function untangled$client$impl$application$merge_handler(mutation_merge,target,source){
var source_to_merge = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,(function (p__46241){
var vec__46242 = p__46241;
var k = cljs.core.nth.call(null,vec__46242,(0),null);
var _ = cljs.core.nth.call(null,vec__46242,(1),null);
return !((k instanceof cljs.core.Symbol));
}),source));
var merged_state = untangled.client.impl.application.sweep_merge.call(null,target,source_to_merge);
return cljs.core.reduce.call(null,((function (source_to_merge,merged_state){
return (function (acc,p__46245){
var vec__46246 = p__46245;
var k = cljs.core.nth.call(null,vec__46246,(0),null);
var v = cljs.core.nth.call(null,vec__46246,(1),null);
if(cljs.core.truth_((function (){var and__7490__auto__ = mutation_merge;
if(cljs.core.truth_(and__7490__auto__)){
return (k instanceof cljs.core.Symbol);
} else {
return and__7490__auto__;
}
})())){
var temp__6751__auto__ = mutation_merge.call(null,acc,k,cljs.core.dissoc.call(null,v,new cljs.core.Keyword(null,"tempids","tempids",1767509089)));
if(cljs.core.truth_(temp__6751__auto__)){
var updated_state = temp__6751__auto__;
return updated_state;
} else {
untangled.client.logging.info.call(null,"Return value handler for",k,"returned nil. Ignored.");

return acc;
}
} else {
return acc;
}
});})(source_to_merge,merged_state))
,merged_state,source);
});
/**
 * The reconciler's send method calls UntangledApplication/server-send, which itself requires a reconciler with a
 *   send method already defined. This creates a catch-22 / circular dependency on the reconciler and :send field within
 *   the reconciler.
 * 
 *   To resolve the issue, we def an atom pointing to the reconciler that the send method will deref each time it is
 *   called. This allows us to define the reconciler with a send method that, at the time of initialization, has an app
 *   that points to a nil reconciler. By the end of this function, the app's reconciler reference has been properly set.
 */
untangled.client.impl.application.generate_reconciler = (function untangled$client$impl$application$generate_reconciler(p__46249,initial_state,parser,p__46250){
var map__46259 = p__46249;
var map__46259__$1 = ((((!((map__46259 == null)))?((((map__46259.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46259.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46259):map__46259);
var app = map__46259__$1;
var send_queues = cljs.core.get.call(null,map__46259__$1,new cljs.core.Keyword(null,"send-queues","send-queues",-212336330));
var mutation_merge = cljs.core.get.call(null,map__46259__$1,new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322));
var map__46260 = p__46250;
var map__46260__$1 = ((((!((map__46260 == null)))?((((map__46260.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46260.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__46260):map__46260);
var pathopt = cljs.core.get.call(null,map__46260__$1,new cljs.core.Keyword(null,"pathopt","pathopt",-61073149),true);
var migrate = cljs.core.get.call(null,map__46260__$1,new cljs.core.Keyword(null,"migrate","migrate",-207110743),null);
var shared = cljs.core.get.call(null,map__46260__$1,new cljs.core.Keyword(null,"shared","shared",-384145993),null);
var rec_atom = cljs.core.atom.call(null,null);
var remotes = cljs.core.keys.call(null,send_queues);
var tempid_migrate = ((function (rec_atom,remotes,map__46259,map__46259__$1,app,send_queues,mutation_merge,map__46260,map__46260__$1,pathopt,migrate,shared){
return (function (pure,_,tempids,___$1){
var seq__46263_46267 = cljs.core.seq.call(null,cljs.core.vals.call(null,send_queues));
var chunk__46264_46268 = null;
var count__46265_46269 = (0);
var i__46266_46270 = (0);
while(true){
if((i__46266_46270 < count__46265_46269)){
var queue_46271 = cljs.core._nth.call(null,chunk__46264_46268,i__46266_46270);
untangled.client.impl.om_plumbing.rewrite_tempids_in_request_queue.call(null,queue_46271,tempids);

var G__46272 = seq__46263_46267;
var G__46273 = chunk__46264_46268;
var G__46274 = count__46265_46269;
var G__46275 = (i__46266_46270 + (1));
seq__46263_46267 = G__46272;
chunk__46264_46268 = G__46273;
count__46265_46269 = G__46274;
i__46266_46270 = G__46275;
continue;
} else {
var temp__6753__auto___46276 = cljs.core.seq.call(null,seq__46263_46267);
if(temp__6753__auto___46276){
var seq__46263_46277__$1 = temp__6753__auto___46276;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46263_46277__$1)){
var c__8413__auto___46278 = cljs.core.chunk_first.call(null,seq__46263_46277__$1);
var G__46279 = cljs.core.chunk_rest.call(null,seq__46263_46277__$1);
var G__46280 = c__8413__auto___46278;
var G__46281 = cljs.core.count.call(null,c__8413__auto___46278);
var G__46282 = (0);
seq__46263_46267 = G__46279;
chunk__46264_46268 = G__46280;
count__46265_46269 = G__46281;
i__46266_46270 = G__46282;
continue;
} else {
var queue_46283 = cljs.core.first.call(null,seq__46263_46277__$1);
untangled.client.impl.om_plumbing.rewrite_tempids_in_request_queue.call(null,queue_46283,tempids);

var G__46284 = cljs.core.next.call(null,seq__46263_46277__$1);
var G__46285 = null;
var G__46286 = (0);
var G__46287 = (0);
seq__46263_46267 = G__46284;
chunk__46264_46268 = G__46285;
count__46265_46269 = G__46286;
i__46266_46270 = G__46287;
continue;
}
} else {
}
}
break;
}

var state_migrate = (function (){var or__7502__auto__ = migrate;
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
return untangled.client.impl.om_plumbing.resolve_tempids;
}
})();
return state_migrate.call(null,pure,tempids);
});})(rec_atom,remotes,map__46259,map__46259__$1,app,send_queues,mutation_merge,map__46260,map__46260__$1,pathopt,migrate,shared))
;
var initial_state_with_locale = (cljs.core.truth_(untangled.client.impl.util.atom_QMARK_.call(null,initial_state))?(function (){
cljs.core.swap_BANG_.call(null,initial_state,cljs.core.assoc,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),"en-US");

return initial_state;
})()
:cljs.core.assoc.call(null,initial_state,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),"en-US"));
var config = cljs.core.PersistentHashMap.fromArrays([new cljs.core.Keyword(null,"pathopt","pathopt",-61073149),new cljs.core.Keyword(null,"merge-ident","merge-ident",1040841862),new cljs.core.Keyword(null,"remotes","remotes",1132366312),new cljs.core.Keyword(null,"migrate","migrate",-207110743),new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"parser","parser",-1543495310),new cljs.core.Keyword(null,"send","send",-652151114),new cljs.core.Keyword(null,"shared","shared",-384145993),new cljs.core.Keyword(null,"merge-tree","merge-tree",-127861161),new cljs.core.Keyword(null,"normalize","normalize",-1904390051)],[pathopt,((function (rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__46259,map__46259__$1,app,send_queues,mutation_merge,map__46260,map__46260__$1,pathopt,migrate,shared){
return (function (reconciler,app_state,ident,props){
return cljs.core.update_in.call(null,app_state,ident,cljs.core.comp.call(null,untangled.client.impl.application.sweep_one,cljs.core.merge),props);
});})(rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__46259,map__46259__$1,app,send_queues,mutation_merge,map__46260,map__46260__$1,pathopt,migrate,shared))
,remotes,(function (){var or__7502__auto__ = migrate;
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
return tempid_migrate;
}
})(),initial_state_with_locale,parser,((function (rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__46259,map__46259__$1,app,send_queues,mutation_merge,map__46260,map__46260__$1,pathopt,migrate,shared){
return (function (tx,cb){
return untangled.client.impl.application.server_send.call(null,cljs.core.assoc.call(null,app,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),cljs.core.deref.call(null,rec_atom)),tx,cb);
});})(rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__46259,map__46259__$1,app,send_queues,mutation_merge,map__46260,map__46260__$1,pathopt,migrate,shared))
,shared,((function (rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__46259,map__46259__$1,app,send_queues,mutation_merge,map__46260,map__46260__$1,pathopt,migrate,shared){
return (function (target,source){
return untangled.client.impl.application.merge_handler.call(null,mutation_merge,target,source);
});})(rec_atom,remotes,tempid_migrate,initial_state_with_locale,map__46259,map__46259__$1,app,send_queues,mutation_merge,map__46260,map__46260__$1,pathopt,migrate,shared))
,true]);
var rec = om.next.reconciler.call(null,config);
cljs.core.reset_BANG_.call(null,rec_atom,rec);

return rec;
});
untangled.client.impl.application.initialize_global_error_callbacks = (function untangled$client$impl$application$initialize_global_error_callbacks(app){
var seq__46293 = cljs.core.seq.call(null,cljs.core.keys.call(null,new cljs.core.Keyword(null,"networking","networking",586110628).cljs$core$IFn$_invoke$arity$1(app)));
var chunk__46294 = null;
var count__46295 = (0);
var i__46296 = (0);
while(true){
if((i__46296 < count__46295)){
var remote = cljs.core._nth.call(null,chunk__46294,i__46296);
var cb_atom_46297 = cljs.core.get_in.call(null,app,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"networking","networking",586110628),remote,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631)], null));
if(cljs.core.truth_(untangled.client.impl.util.atom_QMARK_.call(null,cb_atom_46297))){
cljs.core.swap_BANG_.call(null,cb_atom_46297,((function (seq__46293,chunk__46294,count__46295,i__46296,cb_atom_46297,remote){
return (function (p1__46288_SHARP_){
if(cljs.core.fn_QMARK_.call(null,p1__46288_SHARP_)){
return cljs.core.partial.call(null,p1__46288_SHARP_,om.next.app_state.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app)));
} else {
throw cljs.core.ex_info.call(null,"Networking error callback must be a function.",cljs.core.PersistentArrayMap.EMPTY);
}
});})(seq__46293,chunk__46294,count__46295,i__46296,cb_atom_46297,remote))
);
} else {
}

var G__46298 = seq__46293;
var G__46299 = chunk__46294;
var G__46300 = count__46295;
var G__46301 = (i__46296 + (1));
seq__46293 = G__46298;
chunk__46294 = G__46299;
count__46295 = G__46300;
i__46296 = G__46301;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__46293);
if(temp__6753__auto__){
var seq__46293__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__46293__$1)){
var c__8413__auto__ = cljs.core.chunk_first.call(null,seq__46293__$1);
var G__46302 = cljs.core.chunk_rest.call(null,seq__46293__$1);
var G__46303 = c__8413__auto__;
var G__46304 = cljs.core.count.call(null,c__8413__auto__);
var G__46305 = (0);
seq__46293 = G__46302;
chunk__46294 = G__46303;
count__46295 = G__46304;
i__46296 = G__46305;
continue;
} else {
var remote = cljs.core.first.call(null,seq__46293__$1);
var cb_atom_46306 = cljs.core.get_in.call(null,app,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"networking","networking",586110628),remote,new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631)], null));
if(cljs.core.truth_(untangled.client.impl.util.atom_QMARK_.call(null,cb_atom_46306))){
cljs.core.swap_BANG_.call(null,cb_atom_46306,((function (seq__46293,chunk__46294,count__46295,i__46296,cb_atom_46306,remote,seq__46293__$1,temp__6753__auto__){
return (function (p1__46288_SHARP_){
if(cljs.core.fn_QMARK_.call(null,p1__46288_SHARP_)){
return cljs.core.partial.call(null,p1__46288_SHARP_,om.next.app_state.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app)));
} else {
throw cljs.core.ex_info.call(null,"Networking error callback must be a function.",cljs.core.PersistentArrayMap.EMPTY);
}
});})(seq__46293,chunk__46294,count__46295,i__46296,cb_atom_46306,remote,seq__46293__$1,temp__6753__auto__))
);
} else {
}

var G__46307 = cljs.core.next.call(null,seq__46293__$1);
var G__46308 = null;
var G__46309 = (0);
var G__46310 = (0);
seq__46293 = G__46307;
chunk__46294 = G__46308;
count__46295 = G__46309;
i__46296 = G__46310;
continue;
}
} else {
return null;
}
}
break;
}
});
