// Compiled by ClojureScript 1.9.473 {}
goog.provide('pushy.core');
goog.require('cljs.core');
goog.require('goog.events');
goog.require('goog.History');
goog.require('goog.history.Html5History');
goog.require('goog.history.Html5History.TokenTransformer');
goog.require('goog.history.EventType');
goog.require('goog.Uri');
pushy.core.on_click = (function pushy$core$on_click(funk){
return goog.events.listen(document,"click",funk);
});
/**
 * Traverses up the DOM tree and returns the first node that contains a href attr
 */
pushy.core.recur_href = (function pushy$core$recur_href(target){
if(cljs.core.truth_(target.href)){
return target;
} else {
if(cljs.core.truth_(target.parentNode)){
return pushy.core.recur_href.call(null,target.parentNode);
} else {
return null;
}
}
});
pushy.core.update_history_BANG_ = (function pushy$core$update_history_BANG_(h){
var G__49632 = h;
G__49632.setUseFragment(false);

G__49632.setPathPrefix("");

G__49632.setEnabled(true);

return G__49632;
});
pushy.core.set_retrieve_token_BANG_ = (function pushy$core$set_retrieve_token_BANG_(t){
t.retrieveToken = (function (path_prefix,location){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.pathname),cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.search)].join('');
});

return t;
});
pushy.core.set_create_url_BANG_ = (function pushy$core$set_create_url_BANG_(t){
t.createUrl = (function (token,path_prefix,location){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path_prefix),cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join('');
});

return t;
});
pushy.core.new_history = (function pushy$core$new_history(var_args){
var args49633 = [];
var len__8723__auto___49636 = arguments.length;
var i__8724__auto___49637 = (0);
while(true){
if((i__8724__auto___49637 < len__8723__auto___49636)){
args49633.push((arguments[i__8724__auto___49637]));

var G__49638 = (i__8724__auto___49637 + (1));
i__8724__auto___49637 = G__49638;
continue;
} else {
}
break;
}

var G__49635 = args49633.length;
switch (G__49635) {
case 0:
return pushy.core.new_history.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return pushy.core.new_history.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49633.length)].join('')));

}
});

pushy.core.new_history.cljs$core$IFn$_invoke$arity$0 = (function (){
return pushy.core.new_history.call(null,pushy.core.set_create_url_BANG_.call(null,pushy.core.set_retrieve_token_BANG_.call(null,(new goog.history.Html5History.TokenTransformer()))));
});

pushy.core.new_history.cljs$core$IFn$_invoke$arity$1 = (function (transformer){
return pushy.core.update_history_BANG_.call(null,(new goog.history.Html5History(window,transformer)));
});

pushy.core.new_history.cljs$lang$maxFixedArity = 1;


/**
 * @interface
 */
pushy.core.IHistory = function(){};

pushy.core.set_token_BANG_ = (function pushy$core$set_token_BANG_(var_args){
var args49640 = [];
var len__8723__auto___49646 = arguments.length;
var i__8724__auto___49647 = (0);
while(true){
if((i__8724__auto___49647 < len__8723__auto___49646)){
args49640.push((arguments[i__8724__auto___49647]));

var G__49648 = (i__8724__auto___49647 + (1));
i__8724__auto___49647 = G__49648;
continue;
} else {
}
break;
}

var G__49642 = args49640.length;
switch (G__49642) {
case 2:
return pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49640.length)].join('')));

}
});

pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,token){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$set_token_BANG_$arity$2 == null)))){
return this$.pushy$core$IHistory$set_token_BANG_$arity$2(this$,token);
} else {
var x__8220__auto__ = (((this$ == null))?null:this$);
var m__8221__auto__ = (pushy.core.set_token_BANG_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,this$,token);
} else {
var m__8221__auto____$1 = (pushy.core.set_token_BANG_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,this$,token);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.set-token!",this$);
}
}
}
});

pushy.core.set_token_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (this$,token,title){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$set_token_BANG_$arity$3 == null)))){
return this$.pushy$core$IHistory$set_token_BANG_$arity$3(this$,token,title);
} else {
var x__8220__auto__ = (((this$ == null))?null:this$);
var m__8221__auto__ = (pushy.core.set_token_BANG_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,this$,token,title);
} else {
var m__8221__auto____$1 = (pushy.core.set_token_BANG_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,this$,token,title);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.set-token!",this$);
}
}
}
});

pushy.core.set_token_BANG_.cljs$lang$maxFixedArity = 3;


pushy.core.replace_token_BANG_ = (function pushy$core$replace_token_BANG_(var_args){
var args49643 = [];
var len__8723__auto___49650 = arguments.length;
var i__8724__auto___49651 = (0);
while(true){
if((i__8724__auto___49651 < len__8723__auto___49650)){
args49643.push((arguments[i__8724__auto___49651]));

var G__49652 = (i__8724__auto___49651 + (1));
i__8724__auto___49651 = G__49652;
continue;
} else {
}
break;
}

var G__49645 = args49643.length;
switch (G__49645) {
case 2:
return pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49643.length)].join('')));

}
});

pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (this$,token){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$replace_token_BANG_$arity$2 == null)))){
return this$.pushy$core$IHistory$replace_token_BANG_$arity$2(this$,token);
} else {
var x__8220__auto__ = (((this$ == null))?null:this$);
var m__8221__auto__ = (pushy.core.replace_token_BANG_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,this$,token);
} else {
var m__8221__auto____$1 = (pushy.core.replace_token_BANG_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,this$,token);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.replace-token!",this$);
}
}
}
});

pushy.core.replace_token_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (this$,token,title){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$replace_token_BANG_$arity$3 == null)))){
return this$.pushy$core$IHistory$replace_token_BANG_$arity$3(this$,token,title);
} else {
var x__8220__auto__ = (((this$ == null))?null:this$);
var m__8221__auto__ = (pushy.core.replace_token_BANG_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,this$,token,title);
} else {
var m__8221__auto____$1 = (pushy.core.replace_token_BANG_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,this$,token,title);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.replace-token!",this$);
}
}
}
});

pushy.core.replace_token_BANG_.cljs$lang$maxFixedArity = 3;


pushy.core.get_token = (function pushy$core$get_token(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$get_token$arity$1 == null)))){
return this$.pushy$core$IHistory$get_token$arity$1(this$);
} else {
var x__8220__auto__ = (((this$ == null))?null:this$);
var m__8221__auto__ = (pushy.core.get_token[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,this$);
} else {
var m__8221__auto____$1 = (pushy.core.get_token["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.get-token",this$);
}
}
}
});

pushy.core.start_BANG_ = (function pushy$core$start_BANG_(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$start_BANG_$arity$1 == null)))){
return this$.pushy$core$IHistory$start_BANG_$arity$1(this$);
} else {
var x__8220__auto__ = (((this$ == null))?null:this$);
var m__8221__auto__ = (pushy.core.start_BANG_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,this$);
} else {
var m__8221__auto____$1 = (pushy.core.start_BANG_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.start!",this$);
}
}
}
});

pushy.core.stop_BANG_ = (function pushy$core$stop_BANG_(this$){
if((!((this$ == null))) && (!((this$.pushy$core$IHistory$stop_BANG_$arity$1 == null)))){
return this$.pushy$core$IHistory$stop_BANG_$arity$1(this$);
} else {
var x__8220__auto__ = (((this$ == null))?null:this$);
var m__8221__auto__ = (pushy.core.stop_BANG_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,this$);
} else {
var m__8221__auto____$1 = (pushy.core.stop_BANG_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,this$);
} else {
throw cljs.core.missing_protocol.call(null,"IHistory.stop!",this$);
}
}
}
});

pushy.core.processable_url_QMARK_ = (function pushy$core$processable_url_QMARK_(uri){
return (!(clojure.string.blank_QMARK_.call(null,uri))) && (((cljs.core.not.call(null,uri.hasScheme())) && (cljs.core.not.call(null,uri.hasDomain()))) || (!((cljs.core.re_matches.call(null,cljs.core.re_pattern.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("^"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(location.origin),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".*$")].join('')),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(uri)].join('')) == null))));
});
pushy.core.get_token_from_uri = (function pushy$core$get_token_from_uri(uri){
var path = uri.getPath();
var query = uri.getQuery();
if(cljs.core.empty_QMARK_.call(null,query)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),cljs.core.str.cljs$core$IFn$_invoke$arity$1("?"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(query)].join('');
}
});
/**
 * Takes in three functions:
 *  * dispatch-fn: the function that dispatches when a match is found
 *  * match-fn: the function used to check if a particular route exists
 *  * identity-fn: (optional) extract the route from value returned by match-fn
 */
pushy.core.pushy = (function pushy$core$pushy(var_args){
var args__8730__auto__ = [];
var len__8723__auto___49667 = arguments.length;
var i__8724__auto___49668 = (0);
while(true){
if((i__8724__auto___49668 < len__8723__auto___49667)){
args__8730__auto__.push((arguments[i__8724__auto___49668]));

var G__49669 = (i__8724__auto___49668 + (1));
i__8724__auto___49668 = G__49669;
continue;
} else {
}
break;
}

var argseq__8731__auto__ = ((((2) < args__8730__auto__.length))?(new cljs.core.IndexedSeq(args__8730__auto__.slice((2)),(0),null)):null);
return pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8731__auto__);
});

pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic = (function (dispatch_fn,match_fn,p__49657){
var map__49658 = p__49657;
var map__49658__$1 = ((((!((map__49658 == null)))?((((map__49658.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49658.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49658):map__49658);
var processable_url_QMARK_ = cljs.core.get.call(null,map__49658__$1,new cljs.core.Keyword(null,"processable-url?","processable-url?",1865408336),pushy.core.processable_url_QMARK_);
var identity_fn = cljs.core.get.call(null,map__49658__$1,new cljs.core.Keyword(null,"identity-fn","identity-fn",-884182627),cljs.core.identity);
var history = pushy.core.new_history.call(null);
var event_keys = cljs.core.atom.call(null,null);
if(typeof pushy.core.t_pushy$core49660 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {pushy.core.IHistory}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
pushy.core.t_pushy$core49660 = (function (dispatch_fn,match_fn,p__49657,map__49658,processable_url_QMARK_,identity_fn,history,event_keys,meta49661){
this.dispatch_fn = dispatch_fn;
this.match_fn = match_fn;
this.p__49657 = p__49657;
this.map__49658 = map__49658;
this.processable_url_QMARK_ = processable_url_QMARK_;
this.identity_fn = identity_fn;
this.history = history;
this.event_keys = event_keys;
this.meta49661 = meta49661;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

pushy.core.t_pushy$core49660.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn){
return (function (_49662,meta49661__$1){
var self__ = this;
var _49662__$1 = this;
return (new pushy.core.t_pushy$core49660(self__.dispatch_fn,self__.match_fn,self__.p__49657,self__.map__49658,self__.processable_url_QMARK_,self__.identity_fn,self__.history,self__.event_keys,meta49661__$1));
});})(history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core49660.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn){
return (function (_49662){
var self__ = this;
var _49662__$1 = this;
return self__.meta49661;
});})(history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core49660.prototype.pushy$core$IHistory$ = cljs.core.PROTOCOL_SENTINEL;


pushy.core.t_pushy$core49660.prototype.pushy$core$IHistory$set_token_BANG_$arity$2 = ((function (history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn){
return (function (_,token){
var self__ = this;
var ___$1 = this;
return self__.history.setToken(token);
});})(history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core49660.prototype.pushy$core$IHistory$set_token_BANG_$arity$3 = ((function (history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn){
return (function (_,token,title){
var self__ = this;
var ___$1 = this;
return self__.history.setToken(token,title);
});})(history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core49660.prototype.pushy$core$IHistory$replace_token_BANG_$arity$2 = ((function (history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn){
return (function (_,token){
var self__ = this;
var ___$1 = this;
return self__.history.replaceToken(token);
});})(history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core49660.prototype.pushy$core$IHistory$replace_token_BANG_$arity$3 = ((function (history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn){
return (function (_,token,title){
var self__ = this;
var ___$1 = this;
return self__.history.replaceToken(token,title);
});})(history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core49660.prototype.pushy$core$IHistory$get_token$arity$1 = ((function (history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.history.getToken();
});})(history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core49660.prototype.pushy$core$IHistory$start_BANG_$arity$1 = ((function (history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn){
return (function (this$){
var self__ = this;
var this$__$1 = this;
pushy.core.stop_BANG_.call(null,this$__$1);

cljs.core.swap_BANG_.call(null,self__.event_keys,cljs.core.conj,goog.events.listen(self__.history,goog.history.EventType.NAVIGATE,((function (this$__$1,history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn){
return (function (e){
var temp__6753__auto__ = self__.identity_fn.call(null,self__.match_fn.call(null,e.token));
if(cljs.core.truth_(temp__6753__auto__)){
var match = temp__6753__auto__;
return self__.dispatch_fn.call(null,match);
} else {
return null;
}
});})(this$__$1,history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn))
));

var temp__6753__auto___49670 = self__.identity_fn.call(null,self__.match_fn.call(null,pushy.core.get_token.call(null,this$__$1)));
if(cljs.core.truth_(temp__6753__auto___49670)){
var match_49671 = temp__6753__auto___49670;
self__.dispatch_fn.call(null,match_49671);
} else {
}

cljs.core.swap_BANG_.call(null,self__.event_keys,cljs.core.conj,pushy.core.on_click.call(null,((function (this$__$1,history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn){
return (function (e){
var temp__6753__auto__ = pushy.core.recur_href.call(null,e.target);
if(cljs.core.truth_(temp__6753__auto__)){
var el = temp__6753__auto__;
var uri = goog.Uri.parse(el.href);
if(cljs.core.truth_((function (){var and__7490__auto__ = self__.processable_url_QMARK_.call(null,uri);
if(cljs.core.truth_(and__7490__auto__)){
return (cljs.core.not.call(null,e.altKey)) && (cljs.core.not.call(null,e.ctrlKey)) && (cljs.core.not.call(null,e.metaKey)) && (cljs.core.not.call(null,e.shiftKey)) && (cljs.core.not.call(null,cljs.core.get.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["_self",null,"_blank",null], null), null),el.getAttribute("target")))) && (cljs.core.not_EQ_.call(null,(1),e.button));
} else {
return and__7490__auto__;
}
})())){
var next_token = pushy.core.get_token_from_uri.call(null,uri);
if(cljs.core.truth_(self__.identity_fn.call(null,self__.match_fn.call(null,next_token)))){
var temp__6751__auto___49672 = el.title;
if(cljs.core.truth_(temp__6751__auto___49672)){
var title_49673 = temp__6751__auto___49672;
pushy.core.set_token_BANG_.call(null,this$__$1,next_token,title_49673);
} else {
pushy.core.set_token_BANG_.call(null,this$__$1,next_token);
}

return e.preventDefault();
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
});})(this$__$1,history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn))
));

return null;
});})(history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn))
;


pushy.core.t_pushy$core49660.prototype.pushy$core$IHistory$stop_BANG_$arity$1 = ((function (history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn){
return (function (this$){
var self__ = this;
var this$__$1 = this;
var seq__49663_49674 = cljs.core.seq.call(null,cljs.core.deref.call(null,self__.event_keys));
var chunk__49664_49675 = null;
var count__49665_49676 = (0);
var i__49666_49677 = (0);
while(true){
if((i__49666_49677 < count__49665_49676)){
var key_49678 = cljs.core._nth.call(null,chunk__49664_49675,i__49666_49677);
goog.events.unlistenByKey(key_49678);

var G__49679 = seq__49663_49674;
var G__49680 = chunk__49664_49675;
var G__49681 = count__49665_49676;
var G__49682 = (i__49666_49677 + (1));
seq__49663_49674 = G__49679;
chunk__49664_49675 = G__49680;
count__49665_49676 = G__49681;
i__49666_49677 = G__49682;
continue;
} else {
var temp__6753__auto___49683 = cljs.core.seq.call(null,seq__49663_49674);
if(temp__6753__auto___49683){
var seq__49663_49684__$1 = temp__6753__auto___49683;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__49663_49684__$1)){
var c__8413__auto___49685 = cljs.core.chunk_first.call(null,seq__49663_49684__$1);
var G__49686 = cljs.core.chunk_rest.call(null,seq__49663_49684__$1);
var G__49687 = c__8413__auto___49685;
var G__49688 = cljs.core.count.call(null,c__8413__auto___49685);
var G__49689 = (0);
seq__49663_49674 = G__49686;
chunk__49664_49675 = G__49687;
count__49665_49676 = G__49688;
i__49666_49677 = G__49689;
continue;
} else {
var key_49690 = cljs.core.first.call(null,seq__49663_49684__$1);
goog.events.unlistenByKey(key_49690);

var G__49691 = cljs.core.next.call(null,seq__49663_49684__$1);
var G__49692 = null;
var G__49693 = (0);
var G__49694 = (0);
seq__49663_49674 = G__49691;
chunk__49664_49675 = G__49692;
count__49665_49676 = G__49693;
i__49666_49677 = G__49694;
continue;
}
} else {
}
}
break;
}

return cljs.core.reset_BANG_.call(null,self__.event_keys,null);
});})(history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core49660.getBasis = ((function (history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn){
return (function (){
return new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"dispatch-fn","dispatch-fn",-1401088155,null),new cljs.core.Symbol(null,"match-fn","match-fn",-795226853,null),new cljs.core.Symbol(null,"p__49657","p__49657",-1396162194,null),new cljs.core.Symbol(null,"map__49658","map__49658",-477246825,null),new cljs.core.Symbol(null,"processable-url?","processable-url?",-789027433,null),new cljs.core.Symbol(null,"identity-fn","identity-fn",756348900,null),new cljs.core.Symbol(null,"history","history",1393136307,null),new cljs.core.Symbol(null,"event-keys","event-keys",804564896,null),new cljs.core.Symbol(null,"meta49661","meta49661",-733696813,null)], null);
});})(history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.t_pushy$core49660.cljs$lang$type = true;

pushy.core.t_pushy$core49660.cljs$lang$ctorStr = "pushy.core/t_pushy$core49660";

pushy.core.t_pushy$core49660.cljs$lang$ctorPrWriter = ((function (history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn){
return (function (this__8159__auto__,writer__8160__auto__,opt__8161__auto__){
return cljs.core._write.call(null,writer__8160__auto__,"pushy.core/t_pushy$core49660");
});})(history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn))
;

pushy.core.__GT_t_pushy$core49660 = ((function (history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn){
return (function pushy$core$__GT_t_pushy$core49660(dispatch_fn__$1,match_fn__$1,p__49657__$1,map__49658__$2,processable_url_QMARK___$1,identity_fn__$1,history__$1,event_keys__$1,meta49661){
return (new pushy.core.t_pushy$core49660(dispatch_fn__$1,match_fn__$1,p__49657__$1,map__49658__$2,processable_url_QMARK___$1,identity_fn__$1,history__$1,event_keys__$1,meta49661));
});})(history,event_keys,map__49658,map__49658__$1,processable_url_QMARK_,identity_fn))
;

}

return (new pushy.core.t_pushy$core49660(dispatch_fn,match_fn,p__49657,map__49658__$1,processable_url_QMARK_,identity_fn,history,event_keys,cljs.core.PersistentArrayMap.EMPTY));
});

pushy.core.pushy.cljs$lang$maxFixedArity = (2);

pushy.core.pushy.cljs$lang$applyTo = (function (seq49654){
var G__49655 = cljs.core.first.call(null,seq49654);
var seq49654__$1 = cljs.core.next.call(null,seq49654);
var G__49656 = cljs.core.first.call(null,seq49654__$1);
var seq49654__$2 = cljs.core.next.call(null,seq49654__$1);
return pushy.core.pushy.cljs$core$IFn$_invoke$arity$variadic(G__49655,G__49656,seq49654__$2);
});

/**
 * Returns whether Html5History is supported
 */
pushy.core.supported_QMARK_ = (function pushy$core$supported_QMARK_(var_args){
var args49695 = [];
var len__8723__auto___49698 = arguments.length;
var i__8724__auto___49699 = (0);
while(true){
if((i__8724__auto___49699 < len__8723__auto___49698)){
args49695.push((arguments[i__8724__auto___49699]));

var G__49700 = (i__8724__auto___49699 + (1));
i__8724__auto___49699 = G__49700;
continue;
} else {
}
break;
}

var G__49697 = args49695.length;
switch (G__49697) {
case 0:
return pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49695.length)].join('')));

}
});

pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$0 = (function (){
return pushy.core.supported_QMARK_.call(null,window);
});

pushy.core.supported_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (window){
return goog.history.Html5History.isSupported(window);
});

pushy.core.supported_QMARK_.cljs$lang$maxFixedArity = 1;

pushy.core.push_state_BANG_ = (function pushy$core$push_state_BANG_(var_args){
var args49702 = [];
var len__8723__auto___49705 = arguments.length;
var i__8724__auto___49706 = (0);
while(true){
if((i__8724__auto___49706 < len__8723__auto___49705)){
args49702.push((arguments[i__8724__auto___49706]));

var G__49707 = (i__8724__auto___49706 + (1));
i__8724__auto___49706 = G__49707;
continue;
} else {
}
break;
}

var G__49704 = args49702.length;
switch (G__49704) {
case 2:
return pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49702.length)].join('')));

}
});

pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (dispatch_fn,match_fn){
return pushy.core.push_state_BANG_.call(null,dispatch_fn,match_fn,cljs.core.identity);
});

pushy.core.push_state_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (dispatch_fn,match_fn,identity_fn){
var h = pushy.core.pushy.call(null,dispatch_fn,match_fn,new cljs.core.Keyword(null,"identity-fn","identity-fn",-884182627),identity_fn);
pushy.core.start_BANG_.call(null,h);

return h;
});

pushy.core.push_state_BANG_.cljs$lang$maxFixedArity = 3;

