// Compiled by ClojureScript 1.9.473 {}
goog.provide('untangled_spec.reporter');
goog.require('cljs.core');
goog.require('cljs_uuid_utils.core');
goog.require('cljs.stacktrace');
goog.require('clojure.set');
goog.require('cljs.test');
goog.require('com.stuartsierra.component');
goog.require('untangled_spec.diff');
goog.require('goog.date.Date');
untangled_spec.reporter.new_uuid = (function untangled_spec$reporter$new_uuid(){
return cljs_uuid_utils.core.uuid_string.call(null,cljs_uuid_utils.core.make_random_uuid.call(null));
});
untangled_spec.reporter.fix_str = (function untangled_spec$reporter$fix_str(s){
var G__49983 = s;
if(cljs.core._EQ_.call(null,"",G__49983)){
return "\"\"";
} else {
if(cljs.core._EQ_.call(null,null,G__49983)){
return "nil";
} else {
return s;

}
}
});
untangled_spec.reporter.now_time = (function untangled_spec$reporter$now_time(){
return Date.now();
});
untangled_spec.reporter.make_testreport = (function untangled_spec$reporter$make_testreport(var_args){
var args49984 = [];
var len__8723__auto___49987 = arguments.length;
var i__8724__auto___49988 = (0);
while(true){
if((i__8724__auto___49988 < len__8723__auto___49987)){
args49984.push((arguments[i__8724__auto___49988]));

var G__49989 = (i__8724__auto___49988 + (1));
i__8724__auto___49988 = G__49989;
continue;
} else {
}
break;
}

var G__49986 = args49984.length;
switch (G__49986) {
case 0:
return untangled_spec.reporter.make_testreport.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return untangled_spec.reporter.make_testreport.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args49984.length)].join('')));

}
});

untangled_spec.reporter.make_testreport.cljs$core$IFn$_invoke$arity$0 = (function (){
return untangled_spec.reporter.make_testreport.call(null,cljs.core.PersistentVector.EMPTY);
});

untangled_spec.reporter.make_testreport.cljs$core$IFn$_invoke$arity$1 = (function (initial_items){
return new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"id","id",-1388402092),untangled_spec.reporter.new_uuid.call(null),new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"start-time","start-time",814801386),untangled_spec.reporter.now_time.call(null),new cljs.core.Keyword(null,"test","test",577538877),(0),new cljs.core.Keyword(null,"pass","pass",1574159993),(0),new cljs.core.Keyword(null,"fail","fail",1706214930),(0),new cljs.core.Keyword(null,"error","error",-978969032),(0)], null);
});

untangled_spec.reporter.make_testreport.cljs$lang$maxFixedArity = 1;

untangled_spec.reporter.make_testitem = (function untangled_spec$reporter$make_testitem(test_name){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"id","id",-1388402092),untangled_spec.reporter.new_uuid.call(null),new cljs.core.Keyword(null,"name","name",1843675177),test_name,new cljs.core.Keyword(null,"status","status",-1997798413),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"test-items","test-items",1900391985),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"test-results","test-results",575566942),cljs.core.PersistentVector.EMPTY], null);
});
untangled_spec.reporter.make_manual = (function untangled_spec$reporter$make_manual(test_name){
return untangled_spec.reporter.make_testitem.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(test_name),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" (MANUAL TEST)")].join(''));
});
untangled_spec.reporter.stack__GT_trace = (function untangled_spec$reporter$stack__GT_trace(st){
return cljs.stacktrace.parse_stacktrace.call(null,cljs.core.PersistentArrayMap.EMPTY,st,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
});
untangled_spec.reporter.merge_in_diff_results = (function untangled_spec$reporter$merge_in_diff_results(p__49991){
var map__49995 = p__49991;
var map__49995__$1 = ((((!((map__49995 == null)))?((((map__49995.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__49995.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__49995):map__49995);
var test_result = map__49995__$1;
var actual = cljs.core.get.call(null,map__49995__$1,new cljs.core.Keyword(null,"actual","actual",107306363));
var expected = cljs.core.get.call(null,map__49995__$1,new cljs.core.Keyword(null,"expected","expected",1583670997));
var assert_type = cljs.core.get.call(null,map__49995__$1,new cljs.core.Keyword(null,"assert-type","assert-type",-1787842052));
var G__49997 = test_result;
if(cljs.core.truth_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Symbol(null,"eq","eq",1021992460,null),null], null), null).call(null,assert_type))){
return cljs.core.assoc.call(null,G__49997,new cljs.core.Keyword(null,"diff","diff",2135942783),untangled_spec.diff.diff.call(null,expected,actual));
} else {
return G__49997;
}
});
untangled_spec.reporter.make_test_result = (function untangled_spec$reporter$make_test_result(status,t){
return cljs.core.update.call(null,cljs.core.update.call(null,(function (p1__49998_SHARP_){
if(cljs.core.truth_((function (){var G__50000 = p1__49998_SHARP_;
var G__50000__$1 = (((G__50000 == null))?null:new cljs.core.Keyword(null,"actual","actual",107306363).cljs$core$IFn$_invoke$arity$1(G__50000));
if((G__50000__$1 == null)){
return null;
} else {
return G__50000__$1.stack;
}
})())){
return cljs.core.assoc.call(null,p1__49998_SHARP_,new cljs.core.Keyword(null,"stack","stack",-793405930),untangled_spec.reporter.stack__GT_trace.call(null,new cljs.core.Keyword(null,"actual","actual",107306363).cljs$core$IFn$_invoke$arity$1(p1__49998_SHARP_).stack));
} else {
return p1__49998_SHARP_;
}
}).call(null,untangled_spec.reporter.merge_in_diff_results.call(null,cljs.core.merge.call(null,t,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"id","id",-1388402092),untangled_spec.reporter.new_uuid.call(null),new cljs.core.Keyword(null,"status","status",-1997798413),status,new cljs.core.Keyword(null,"where","where",-2044795965),cljs.test.testing_vars_str.call(null,t)], null)))),new cljs.core.Keyword(null,"actual","actual",107306363),untangled_spec.reporter.fix_str),new cljs.core.Keyword(null,"expected","expected",1583670997),untangled_spec.reporter.fix_str);
});
untangled_spec.reporter.make_tests_by_namespace = (function untangled_spec$reporter$make_tests_by_namespace(test_name){
return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"id","id",-1388402092),untangled_spec.reporter.new_uuid.call(null),new cljs.core.Keyword(null,"name","name",1843675177),test_name,new cljs.core.Keyword(null,"test-items","test-items",1900391985),cljs.core.PersistentVector.EMPTY,new cljs.core.Keyword(null,"status","status",-1997798413),cljs.core.PersistentArrayMap.EMPTY], null);
});
untangled_spec.reporter.set_test_result = (function untangled_spec$reporter$set_test_result(p__50001,status){
var map__50004 = p__50001;
var map__50004__$1 = ((((!((map__50004 == null)))?((((map__50004.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50004.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50004):map__50004);
var state = cljs.core.get.call(null,map__50004__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var path = cljs.core.get.call(null,map__50004__$1,new cljs.core.Keyword(null,"path","path",-188191168));
var all_paths = cljs.core.sequence.call(null,cljs.core.comp.call(null,cljs.core.take_while.call(null,cljs.core.seq),cljs.core.map.call(null,cljs.core.vec)),cljs.core.iterate.call(null,cljs.core.partial.call(null,cljs.core.drop_last,(2)),cljs.core.deref.call(null,path)));
return cljs.core.swap_BANG_.call(null,state,((function (all_paths,map__50004,map__50004__$1,state,path){
return (function (state__$1){
return cljs.core.reduce.call(null,((function (all_paths,map__50004,map__50004__$1,state,path){
return (function (state__$2,path__$1){
return cljs.core.update_in.call(null,state__$2,cljs.core.conj.call(null,path__$1,new cljs.core.Keyword(null,"status","status",-1997798413),status),cljs.core.fnil.call(null,cljs.core.inc,(0)));
});})(all_paths,map__50004,map__50004__$1,state,path))
,state__$1,all_paths);
});})(all_paths,map__50004,map__50004__$1,state,path))
);
});
untangled_spec.reporter.begin_STAR_ = (function untangled_spec$reporter$begin_STAR_(p__50006,t){
var map__50009 = p__50006;
var map__50009__$1 = ((((!((map__50009 == null)))?((((map__50009.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50009.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50009):map__50009);
var state = cljs.core.get.call(null,map__50009__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var path = cljs.core.get.call(null,map__50009__$1,new cljs.core.Keyword(null,"path","path",-188191168));
var path__$1 = cljs.core.deref.call(null,path);
var test_item = untangled_spec.reporter.make_testitem.call(null,new cljs.core.Keyword(null,"string","string",-1989541586).cljs$core$IFn$_invoke$arity$1(t));
var test_items_count = cljs.core.count.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,state),cljs.core.conj.call(null,path__$1,new cljs.core.Keyword(null,"test-items","test-items",1900391985))));
cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,cljs.core.conj.call(null,path__$1,new cljs.core.Keyword(null,"test-items","test-items",1900391985),test_items_count),test_item);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [test_item,test_items_count], null);
});
untangled_spec.reporter.get_namespace_location = (function untangled_spec$reporter$get_namespace_location(namespaces,nsname){
var namespace_index = cljs.core.first.call(null,cljs.core.keep_indexed.call(null,(function (idx,val){
if(cljs.core._EQ_.call(null,new cljs.core.Keyword(null,"name","name",1843675177).cljs$core$IFn$_invoke$arity$1(val),nsname)){
return idx;
} else {
return null;
}
}),namespaces));
var or__7502__auto__ = namespace_index;
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
return cljs.core.count.call(null,namespaces);
}
});
untangled_spec.reporter.inc_report_counter = (function untangled_spec$reporter$inc_report_counter(type){
return cljs.test.inc_report_counter_BANG_.call(null,type);
});
untangled_spec.reporter.failure_STAR_ = (function untangled_spec$reporter$failure_STAR_(p__50011,t,failure_type){
var map__50016 = p__50011;
var map__50016__$1 = ((((!((map__50016 == null)))?((((map__50016.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50016.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50016):map__50016);
var this$ = map__50016__$1;
var state = cljs.core.get.call(null,map__50016__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var path = cljs.core.get.call(null,map__50016__$1,new cljs.core.Keyword(null,"path","path",-188191168));
untangled_spec.reporter.inc_report_counter.call(null,failure_type);

var path__$1 = cljs.core.deref.call(null,path);
var map__50018 = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),path__$1);
var map__50018__$1 = ((((!((map__50018 == null)))?((((map__50018.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50018.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50018):map__50018);
var test_results = cljs.core.get.call(null,map__50018__$1,new cljs.core.Keyword(null,"test-results","test-results",575566942));
var new_result = untangled_spec.reporter.make_test_result.call(null,failure_type,t);
untangled_spec.reporter.set_test_result.call(null,this$,failure_type);

cljs.core.swap_BANG_.call(null,state,cljs.core.update_in,cljs.core.conj.call(null,path__$1,new cljs.core.Keyword(null,"test-results","test-results",575566942)),cljs.core.conj,new_result);

return new_result;
});
untangled_spec.reporter.error = (function untangled_spec$reporter$error(this$,t){
return untangled_spec.reporter.failure_STAR_.call(null,this$,t,new cljs.core.Keyword(null,"error","error",-978969032));
});
untangled_spec.reporter.fail = (function untangled_spec$reporter$fail(this$,t){
return untangled_spec.reporter.failure_STAR_.call(null,this$,t,new cljs.core.Keyword(null,"fail","fail",1706214930));
});
untangled_spec.reporter.pass = (function untangled_spec$reporter$pass(this$,t){
untangled_spec.reporter.inc_report_counter.call(null,new cljs.core.Keyword(null,"pass","pass",1574159993));

return untangled_spec.reporter.set_test_result.call(null,this$,new cljs.core.Keyword(null,"pass","pass",1574159993));
});
untangled_spec.reporter.push_test_item_path = (function untangled_spec$reporter$push_test_item_path(p__50020,test_item,index){
var map__50023 = p__50020;
var map__50023__$1 = ((((!((map__50023 == null)))?((((map__50023.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50023.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50023):map__50023);
var path = cljs.core.get.call(null,map__50023__$1,new cljs.core.Keyword(null,"path","path",-188191168));
return cljs.core.swap_BANG_.call(null,path,cljs.core.conj,new cljs.core.Keyword(null,"test-items","test-items",1900391985),index);
});
untangled_spec.reporter.pop_test_item_path = (function untangled_spec$reporter$pop_test_item_path(p__50025){
var map__50028 = p__50025;
var map__50028__$1 = ((((!((map__50028 == null)))?((((map__50028.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50028.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50028):map__50028);
var path = cljs.core.get.call(null,map__50028__$1,new cljs.core.Keyword(null,"path","path",-188191168));
return cljs.core.swap_BANG_.call(null,path,cljs.core.comp.call(null,cljs.core.pop,cljs.core.pop));
});
untangled_spec.reporter.begin_namespace = (function untangled_spec$reporter$begin_namespace(p__50030,t){
var map__50033 = p__50030;
var map__50033__$1 = ((((!((map__50033 == null)))?((((map__50033.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50033.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50033):map__50033);
var state = cljs.core.get.call(null,map__50033__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var path = cljs.core.get.call(null,map__50033__$1,new cljs.core.Keyword(null,"path","path",-188191168));
var test_name = cljs.core.ns_name.call(null,new cljs.core.Keyword(null,"ns","ns",441598760).cljs$core$IFn$_invoke$arity$1(t));
var namespaces = cljs.core.get_in.call(null,cljs.core.deref.call(null,state),cljs.core.conj.call(null,cljs.core.deref.call(null,path),new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469)));
var name_space_location = untangled_spec.reporter.get_namespace_location.call(null,namespaces,test_name);
cljs.core.swap_BANG_.call(null,path,cljs.core.conj,new cljs.core.Keyword(null,"namespaces","namespaces",-1444157469),name_space_location);

return cljs.core.swap_BANG_.call(null,state,cljs.core.assoc_in,cljs.core.deref.call(null,path),untangled_spec.reporter.make_tests_by_namespace.call(null,test_name));
});
untangled_spec.reporter.end_namespace = (function untangled_spec$reporter$end_namespace(this$,t){
return untangled_spec.reporter.pop_test_item_path.call(null,this$);
});
untangled_spec.reporter.begin_specification = (function untangled_spec$reporter$begin_specification(this$,t){
return cljs.core.apply.call(null,untangled_spec.reporter.push_test_item_path,this$,untangled_spec.reporter.begin_STAR_.call(null,this$,t));
});
untangled_spec.reporter.end_specification = (function untangled_spec$reporter$end_specification(this$,t){
return untangled_spec.reporter.pop_test_item_path.call(null,this$);
});
untangled_spec.reporter.begin_behavior = (function untangled_spec$reporter$begin_behavior(this$,t){
return cljs.core.apply.call(null,untangled_spec.reporter.push_test_item_path,this$,untangled_spec.reporter.begin_STAR_.call(null,this$,t));
});
untangled_spec.reporter.end_behavior = (function untangled_spec$reporter$end_behavior(this$,t){
return untangled_spec.reporter.pop_test_item_path.call(null,this$);
});
untangled_spec.reporter.begin_manual = (function untangled_spec$reporter$begin_manual(this$,t){
return cljs.core.apply.call(null,untangled_spec.reporter.push_test_item_path,this$,untangled_spec.reporter.begin_STAR_.call(null,this$,t));
});
untangled_spec.reporter.end_manual = (function untangled_spec$reporter$end_manual(this$,t){
untangled_spec.reporter.set_test_result.call(null,this$,new cljs.core.Keyword(null,"manual","manual",-237370608));

return untangled_spec.reporter.pop_test_item_path.call(null,this$);
});
untangled_spec.reporter.begin_provided = (function untangled_spec$reporter$begin_provided(this$,t){
return cljs.core.apply.call(null,untangled_spec.reporter.push_test_item_path,this$,untangled_spec.reporter.begin_STAR_.call(null,this$,t));
});
untangled_spec.reporter.end_provided = (function untangled_spec$reporter$end_provided(this$,t){
return untangled_spec.reporter.pop_test_item_path.call(null,this$);
});
untangled_spec.reporter.summary = (function untangled_spec$reporter$summary(p__50035,t){
var map__50041 = p__50035;
var map__50041__$1 = ((((!((map__50041 == null)))?((((map__50041.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50041.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50041):map__50041);
var state = cljs.core.get.call(null,map__50041__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var end_time_50046 = untangled_spec.reporter.now_time.call(null);
var end_date_50047 = (new goog.date.Date()).getTime();
cljs.core.swap_BANG_.call(null,state,((function (end_time_50046,end_date_50047,map__50041,map__50041__$1,state){
return (function (p__50043){
var map__50044 = p__50043;
var map__50044__$1 = ((((!((map__50044 == null)))?((((map__50044.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50044.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50044):map__50044);
var st = map__50044__$1;
var start_time = cljs.core.get.call(null,map__50044__$1,new cljs.core.Keyword(null,"start-time","start-time",814801386));
return cljs.core.assoc.call(null,cljs.core.assoc.call(null,st,new cljs.core.Keyword(null,"end-time","end-time",-1849817460),end_date_50047),new cljs.core.Keyword(null,"run-time","run-time",-1231674133),(end_time_50046 - start_time));
});})(end_time_50046,end_date_50047,map__50041,map__50041__$1,state))
);

return cljs.core.swap_BANG_.call(null,state,cljs.core.merge,t);
});
untangled_spec.reporter.reset_test_report_BANG_ = (function untangled_spec$reporter$reset_test_report_BANG_(p__50048){
var map__50051 = p__50048;
var map__50051__$1 = ((((!((map__50051 == null)))?((((map__50051.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50051.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50051):map__50051);
var state = cljs.core.get.call(null,map__50051__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var path = cljs.core.get.call(null,map__50051__$1,new cljs.core.Keyword(null,"path","path",-188191168));
cljs.core.reset_BANG_.call(null,state,untangled_spec.reporter.make_testreport.call(null));

return cljs.core.reset_BANG_.call(null,path,cljs.core.PersistentVector.EMPTY);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {com.stuartsierra.component.Lifecycle}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
untangled_spec.reporter.TestReporter = (function (state,path,__meta,__extmap,__hash){
this.state = state;
this.path = path;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})

untangled_spec.reporter.TestReporter.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8177__auto__,k__8178__auto__){
var self__ = this;
var this__8177__auto____$1 = this;
return this__8177__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8178__auto__,null);
});


untangled_spec.reporter.TestReporter.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8179__auto__,k50054,else__8180__auto__){
var self__ = this;
var this__8179__auto____$1 = this;
var G__50056 = (((k50054 instanceof cljs.core.Keyword))?k50054.fqn:null);
switch (G__50056) {
case "state":
return self__.state;

break;
case "path":
return self__.path;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k50054,else__8180__auto__);

}
});


untangled_spec.reporter.TestReporter.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8191__auto__,writer__8192__auto__,opts__8193__auto__){
var self__ = this;
var this__8191__auto____$1 = this;
var pr_pair__8194__auto__ = ((function (this__8191__auto____$1){
return (function (keyval__8195__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8192__auto__,cljs.core.pr_writer,""," ","",opts__8193__auto__,keyval__8195__auto__);
});})(this__8191__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8192__auto__,pr_pair__8194__auto__,"#untangled-spec.reporter.TestReporter{",", ","}",opts__8193__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"path","path",-188191168),self__.path],null))], null),self__.__extmap));
});


untangled_spec.reporter.TestReporter.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;


untangled_spec.reporter.TestReporter.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__50053){
var self__ = this;
var G__50053__$1 = this;
return (new cljs.core.RecordIter((0),G__50053__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"path","path",-188191168)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


untangled_spec.reporter.TestReporter.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8175__auto__){
var self__ = this;
var this__8175__auto____$1 = this;
return self__.__meta;
});


untangled_spec.reporter.TestReporter.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8171__auto__){
var self__ = this;
var this__8171__auto____$1 = this;
return (new untangled_spec.reporter.TestReporter(self__.state,self__.path,self__.__meta,self__.__extmap,self__.__hash));
});


untangled_spec.reporter.TestReporter.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8181__auto__){
var self__ = this;
var this__8181__auto____$1 = this;
return (2 + cljs.core.count.call(null,self__.__extmap));
});


untangled_spec.reporter.TestReporter.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8172__auto__){
var self__ = this;
var this__8172__auto____$1 = this;
var h__7944__auto__ = self__.__hash;
if(!((h__7944__auto__ == null))){
return h__7944__auto__;
} else {
var h__7944__auto____$1 = cljs.core.hash_imap.call(null,this__8172__auto____$1);
self__.__hash = h__7944__auto____$1;

return h__7944__auto____$1;
}
});


untangled_spec.reporter.TestReporter.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8173__auto__,other__8174__auto__){
var self__ = this;
var this__8173__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7490__auto__ = other__8174__auto__;
if(cljs.core.truth_(and__7490__auto__)){
return ((this__8173__auto____$1.constructor === other__8174__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8173__auto____$1,other__8174__auto__));
} else {
return and__7490__auto__;
}
})())){
return true;
} else {
return false;
}
});


untangled_spec.reporter.TestReporter.prototype.com$stuartsierra$component$Lifecycle$ = cljs.core.PROTOCOL_SENTINEL;


untangled_spec.reporter.TestReporter.prototype.com$stuartsierra$component$Lifecycle$start$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});


untangled_spec.reporter.TestReporter.prototype.com$stuartsierra$component$Lifecycle$stop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
untangled_spec.reporter.reset_test_report_BANG_.call(null,this$__$1);

return this$__$1;
});


untangled_spec.reporter.TestReporter.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8186__auto__,k__8187__auto__){
var self__ = this;
var this__8186__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"path","path",-188191168),null,new cljs.core.Keyword(null,"state","state",-1988618099),null], null), null),k__8187__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8186__auto____$1),self__.__meta),k__8187__auto__);
} else {
return (new untangled_spec.reporter.TestReporter(self__.state,self__.path,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8187__auto__)),null));
}
});


untangled_spec.reporter.TestReporter.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8184__auto__,k__8185__auto__,G__50053){
var self__ = this;
var this__8184__auto____$1 = this;
var pred__50057 = cljs.core.keyword_identical_QMARK_;
var expr__50058 = k__8185__auto__;
if(cljs.core.truth_(pred__50057.call(null,new cljs.core.Keyword(null,"state","state",-1988618099),expr__50058))){
return (new untangled_spec.reporter.TestReporter(G__50053,self__.path,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__50057.call(null,new cljs.core.Keyword(null,"path","path",-188191168),expr__50058))){
return (new untangled_spec.reporter.TestReporter(self__.state,G__50053,self__.__meta,self__.__extmap,null));
} else {
return (new untangled_spec.reporter.TestReporter(self__.state,self__.path,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8185__auto__,G__50053),null));
}
}
});


untangled_spec.reporter.TestReporter.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8189__auto__){
var self__ = this;
var this__8189__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state","state",-1988618099),self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"path","path",-188191168),self__.path],null))], null),self__.__extmap));
});


untangled_spec.reporter.TestReporter.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8176__auto__,G__50053){
var self__ = this;
var this__8176__auto____$1 = this;
return (new untangled_spec.reporter.TestReporter(self__.state,self__.path,G__50053,self__.__extmap,self__.__hash));
});


untangled_spec.reporter.TestReporter.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8182__auto__,entry__8183__auto__){
var self__ = this;
var this__8182__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8183__auto__)){
return this__8182__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8183__auto__,(0)),cljs.core._nth.call(null,entry__8183__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8182__auto____$1,entry__8183__auto__);
}
});

untangled_spec.reporter.TestReporter.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"state","state",-348086572,null),new cljs.core.Symbol(null,"path","path",1452340359,null)], null);
});

untangled_spec.reporter.TestReporter.cljs$lang$type = true;

untangled_spec.reporter.TestReporter.cljs$lang$ctorPrSeq = (function (this__8213__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"untangled-spec.reporter/TestReporter");
});

untangled_spec.reporter.TestReporter.cljs$lang$ctorPrWriter = (function (this__8213__auto__,writer__8214__auto__){
return cljs.core._write.call(null,writer__8214__auto__,"untangled-spec.reporter/TestReporter");
});

untangled_spec.reporter.__GT_TestReporter = (function untangled_spec$reporter$__GT_TestReporter(state,path){
return (new untangled_spec.reporter.TestReporter(state,path,null,null,null));
});

untangled_spec.reporter.map__GT_TestReporter = (function untangled_spec$reporter$map__GT_TestReporter(G__50055){
return (new untangled_spec.reporter.TestReporter(new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(G__50055),new cljs.core.Keyword(null,"path","path",-188191168).cljs$core$IFn$_invoke$arity$1(G__50055),null,cljs.core.dissoc.call(null,G__50055,new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"path","path",-188191168)),null));
});

/**
 * Just a shell to contain minimum state necessary for reporting
 */
untangled_spec.reporter.make_test_reporter = (function untangled_spec$reporter$make_test_reporter(){
return untangled_spec.reporter.map__GT_TestReporter.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"state","state",-1988618099),cljs.core.atom.call(null,untangled_spec.reporter.make_testreport.call(null)),new cljs.core.Keyword(null,"path","path",-188191168),cljs.core.atom.call(null,cljs.core.PersistentVector.EMPTY)], null));
});
untangled_spec.reporter.get_test_report = (function untangled_spec$reporter$get_test_report(reporter){
return cljs.core.deref.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(reporter));
});
untangled_spec.reporter.untangled_report = (function untangled_spec$reporter$untangled_report(p__50061,on_complete){
var map__50065 = p__50061;
var map__50065__$1 = ((((!((map__50065 == null)))?((((map__50065.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__50065.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__50065):map__50065);
var system = map__50065__$1;
var reporter = cljs.core.get.call(null,map__50065__$1,new cljs.core.Keyword("test","reporter","test/reporter",-867863647));
return ((function (map__50065,map__50065__$1,system,reporter){
return (function (t){
var G__50067 = (((new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(t) instanceof cljs.core.Keyword))?new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(t).fqn:null);
switch (G__50067) {
case "begin-provided":
return untangled_spec.reporter.begin_provided.call(null,reporter,t);

break;
case "begin-specification":
return untangled_spec.reporter.begin_specification.call(null,reporter,t);

break;
case "end-behavior":
return untangled_spec.reporter.end_behavior.call(null,reporter,t);

break;
case "summary":
return untangled_spec.reporter.summary.call(null,reporter,t);

break;
case "end-manual":
return untangled_spec.reporter.end_manual.call(null,reporter,t);

break;
case "begin-manual":
return untangled_spec.reporter.begin_manual.call(null,reporter,t);

break;
case "fail":
return untangled_spec.reporter.fail.call(null,reporter,t);

break;
case "end-run-tests":
return on_complete.call(null,system);

break;
case "end-specification":
return untangled_spec.reporter.end_specification.call(null,reporter,t);

break;
case "begin-test-ns":
return untangled_spec.reporter.begin_namespace.call(null,reporter,t);

break;
case "error":
return untangled_spec.reporter.error.call(null,reporter,t);

break;
case "pass":
return untangled_spec.reporter.pass.call(null,reporter,t);

break;
case "end-provided":
return untangled_spec.reporter.end_provided.call(null,reporter,t);

break;
case "end-test-ns":
return untangled_spec.reporter.end_namespace.call(null,reporter,t);

break;
case "begin-behavior":
return untangled_spec.reporter.begin_behavior.call(null,reporter,t);

break;
default:
return null;

}
});
;})(map__50065,map__50065__$1,system,reporter))
});
