// Compiled by ClojureScript 1.9.473 {}
goog.provide('taoensso.sente');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('taoensso.encore');
goog.require('taoensso.timbre');
goog.require('taoensso.sente.interfaces');
if(cljs.core.vector_QMARK_.call(null,taoensso.encore.encore_version)){
taoensso.encore.assert_min_encore_version.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(2),(67),(1)], null));
} else {
taoensso.encore.assert_min_encore_version.call(null,2.67);
}
taoensso.sente.node_target_QMARK_ = cljs.core._EQ_.call(null,cljs.core._STAR_target_STAR_,"nodejs");
if(typeof taoensso.sente.debug_mode_QMARK__ !== 'undefined'){
} else {
taoensso.sente.debug_mode_QMARK__ = cljs.core.atom.call(null,false);
}
taoensso.sente.validate_event = (function taoensso$sente$validate_event(x){
if(!(cljs.core.vector_QMARK_.call(null,x))){
return new cljs.core.Keyword(null,"wrong-type","wrong-type",929556915);
} else {
if(cljs.core.not.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [(1),null,(2),null], null), null).call(null,cljs.core.count.call(null,x)))){
return new cljs.core.Keyword(null,"wrong-length","wrong-length",1367572281);
} else {
var vec__47082 = x;
var ev_id = cljs.core.nth.call(null,vec__47082,(0),null);
var _ = cljs.core.nth.call(null,vec__47082,(1),null);
if(!((ev_id instanceof cljs.core.Keyword))){
return new cljs.core.Keyword(null,"wrong-id-type","wrong-id-type",-1213601689);
} else {
if(cljs.core.not.call(null,cljs.core.namespace.call(null,ev_id))){
return new cljs.core.Keyword(null,"unnamespaced-id","unnamespaced-id",1976189772);
} else {
return null;

}
}

}
}
});
/**
 * Valid [ev-id ?ev-data] form?
 */
taoensso.sente.event_QMARK_ = (function taoensso$sente$event_QMARK_(x){
return (taoensso.sente.validate_event.call(null,x) == null);
});
taoensso.sente.as_event = (function taoensso$sente$as_event(x){
if(cljs.core.truth_(taoensso.sente.event_QMARK_.call(null,x))){
return x;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","bad-event","chsk/bad-event",-565206930),x], null);
}
});
taoensso.sente.assert_event = (function taoensso$sente$assert_event(x){
var temp__6753__auto__ = taoensso.sente.validate_event.call(null,x);
if(cljs.core.truth_(temp__6753__auto__)){
var _QMARK_err = temp__6753__auto__;
var err_msg = [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__47086 = (((_QMARK_err instanceof cljs.core.Keyword))?_QMARK_err.fqn:null);
switch (G__47086) {
case "wrong-type":
return "Malformed event (wrong type).";

break;
case "wrong-length":
return "Malformed event (wrong length).";

break;
case "wrong-id-type":
return "Malformed event (`ev-id` should be a namespaced keyword).";

break;
case "unnamespaced-id":
return "Malformed event (`ev-id` should be a namespaced keyword).";

break;
case "else":
return "Malformed event (unknown error).";

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_err)].join('')));

}
})()),cljs.core.str.cljs$core$IFn$_invoke$arity$1(" Event should be of `[ev-id ?ev-data]` form: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join('');
throw cljs.core.ex_info.call(null,err_msg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"malformed-event","malformed-event",-2090896605),x], null));
} else {
return null;
}
});
taoensso.sente.client_event_msg_QMARK_ = (function taoensso$sente$client_event_msg_QMARK_(x){
var and__7490__auto__ = cljs.core.map_QMARK_.call(null,x);
if(and__7490__auto__){
var and__7490__auto____$1 = taoensso.encore.ks_EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),null,new cljs.core.Keyword(null,"state","state",-1988618099),null,new cljs.core.Keyword(null,"event","event",301435442),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"?data","?data",-9471433),null,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),null], null), null),x);
if(and__7490__auto____$1){
var map__47098 = x;
var map__47098__$1 = ((((!((map__47098 == null)))?((((map__47098.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47098.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47098):map__47098);
var ch_recv = cljs.core.get.call(null,map__47098__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn = cljs.core.get.call(null,map__47098__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var state = cljs.core.get.call(null,map__47098__$1,new cljs.core.Keyword(null,"state","state",-1988618099));
var event = cljs.core.get.call(null,map__47098__$1,new cljs.core.Keyword(null,"event","event",301435442));
var and__7490__auto____$2 = taoensso.encore.chan_QMARK_.call(null,ch_recv);
if(and__7490__auto____$2){
var and__7490__auto____$3 = cljs.core.ifn_QMARK_.call(null,send_fn);
if(and__7490__auto____$3){
var and__7490__auto____$4 = taoensso.encore.atom_QMARK_.call(null,state);
if(and__7490__auto____$4){
return taoensso.sente.event_QMARK_.call(null,event);
} else {
return and__7490__auto____$4;
}
} else {
return and__7490__auto____$3;
}
} else {
return and__7490__auto____$2;
}
} else {
return and__7490__auto____$1;
}
} else {
return and__7490__auto__;
}
});
taoensso.sente.server_event_msg_QMARK_ = (function taoensso$sente$server_event_msg_QMARK_(x){
var and__7490__auto__ = cljs.core.map_QMARK_.call(null,x);
if(and__7490__auto__){
var and__7490__auto____$1 = taoensso.encore.ks_EQ_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 10, [new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592),null,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),null,new cljs.core.Keyword(null,"connected-uids","connected-uids",1454332231),null,new cljs.core.Keyword(null,"uid","uid",-1447769400),null,new cljs.core.Keyword(null,"event","event",301435442),null,new cljs.core.Keyword(null,"id","id",-1388402092),null,new cljs.core.Keyword(null,"ring-req","ring-req",-747861961),null,new cljs.core.Keyword(null,"?data","?data",-9471433),null,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),null], null), null),x);
if(and__7490__auto____$1){
var map__47110 = x;
var map__47110__$1 = ((((!((map__47110 == null)))?((((map__47110.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47110.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47110):map__47110);
var ch_recv = cljs.core.get.call(null,map__47110__$1,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861));
var send_fn = cljs.core.get.call(null,map__47110__$1,new cljs.core.Keyword(null,"send-fn","send-fn",351002041));
var connected_uids = cljs.core.get.call(null,map__47110__$1,new cljs.core.Keyword(null,"connected-uids","connected-uids",1454332231));
var ring_req = cljs.core.get.call(null,map__47110__$1,new cljs.core.Keyword(null,"ring-req","ring-req",-747861961));
var client_id = cljs.core.get.call(null,map__47110__$1,new cljs.core.Keyword(null,"client-id","client-id",-464622140));
var event = cljs.core.get.call(null,map__47110__$1,new cljs.core.Keyword(null,"event","event",301435442));
var _QMARK_reply_fn = cljs.core.get.call(null,map__47110__$1,new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592));
var and__7490__auto____$2 = taoensso.encore.chan_QMARK_.call(null,ch_recv);
if(and__7490__auto____$2){
var and__7490__auto____$3 = cljs.core.ifn_QMARK_.call(null,send_fn);
if(and__7490__auto____$3){
var and__7490__auto____$4 = taoensso.encore.atom_QMARK_.call(null,connected_uids);
if(and__7490__auto____$4){
var and__7490__auto____$5 = cljs.core.map_QMARK_.call(null,ring_req);
if(and__7490__auto____$5){
var and__7490__auto____$6 = taoensso.encore.nblank_str_QMARK_.call(null,client_id);
if(and__7490__auto____$6){
var and__7490__auto____$7 = taoensso.sente.event_QMARK_.call(null,event);
if(cljs.core.truth_(and__7490__auto____$7)){
return ((_QMARK_reply_fn == null)) || (cljs.core.ifn_QMARK_.call(null,_QMARK_reply_fn));
} else {
return and__7490__auto____$7;
}
} else {
return and__7490__auto____$6;
}
} else {
return and__7490__auto____$5;
}
} else {
return and__7490__auto____$4;
}
} else {
return and__7490__auto____$3;
}
} else {
return and__7490__auto____$2;
}
} else {
return and__7490__auto____$1;
}
} else {
return and__7490__auto__;
}
});
/**
 * All server `event-msg`s go through this
 */
taoensso.sente.put_server_event_msg_GT_ch_recv_BANG_ = (function taoensso$sente$put_server_event_msg_GT_ch_recv_BANG_(ch_recv,p__47112){
var map__47118 = p__47112;
var map__47118__$1 = ((((!((map__47118 == null)))?((((map__47118.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47118.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47118):map__47118);
var ev_msg = map__47118__$1;
var event = cljs.core.get.call(null,map__47118__$1,new cljs.core.Keyword(null,"event","event",301435442));
var _QMARK_reply_fn = cljs.core.get.call(null,map__47118__$1,new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592));
var vec__47120 = taoensso.sente.as_event.call(null,event);
var ev_id = cljs.core.nth.call(null,vec__47120,(0),null);
var ev__QMARK_data = cljs.core.nth.call(null,vec__47120,(1),null);
var valid_event = vec__47120;
var ev_msg_STAR_ = cljs.core.merge.call(null,ev_msg,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"event","event",301435442),valid_event,new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592),_QMARK_reply_fn,new cljs.core.Keyword(null,"id","id",-1388402092),ev_id,new cljs.core.Keyword(null,"?data","?data",-9471433),ev__QMARK_data], null));
if(cljs.core.not.call(null,taoensso.sente.server_event_msg_QMARK_.call(null,ev_msg_STAR_))){
return taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",163,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__47120,ev_id,ev__QMARK_data,valid_event,ev_msg_STAR_,map__47118,map__47118__$1,ev_msg,event,_QMARK_reply_fn){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Bad ev-msg: %s",ev_msg], null);
});})(vec__47120,ev_id,ev__QMARK_data,valid_event,ev_msg_STAR_,map__47118,map__47118__$1,ev_msg,event,_QMARK_reply_fn))
,null)),null,150704164);
} else {
return cljs.core.async.put_BANG_.call(null,ch_recv,ev_msg_STAR_);
}
});
taoensso.sente.cb_error_QMARK_ = (function taoensso$sente$cb_error_QMARK_(cb_reply_clj){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword("chsk","closed","chsk/closed",-922855264),null,new cljs.core.Keyword("chsk","error","chsk/error",-984175439),null,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489),null], null), null).call(null,cb_reply_clj);
});
taoensso.sente.cb_success_QMARK_ = (function taoensso$sente$cb_success_QMARK_(cb_reply_clj){
return cljs.core.not.call(null,taoensso.sente.cb_error_QMARK_.call(null,cb_reply_clj));
});
/**
 * prefixed-pstr->[clj ?cb-uuid]
 */
taoensso.sente.unpack = (function taoensso$sente$unpack(packer,prefixed_pstr){
if(typeof prefixed_pstr === 'string'){
} else {
taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",177,"(string? prefixed-pstr)",prefixed_pstr,null,null);
}

var wrapped_QMARK_ = taoensso.encore.str_starts_with_QMARK_.call(null,prefixed_pstr,"+");
var pstr = cljs.core.subs.call(null,prefixed_pstr,(1));
var clj = (function (){try{return taoensso.sente.interfaces.unpack.call(null,packer,pstr);
}catch (e47130){var t = e47130;
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",184,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (t,wrapped_QMARK_,pstr){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Bad package: %s (%s)",pstr,t], null);
});})(t,wrapped_QMARK_,pstr))
,null)),null,1300881712);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","bad-package","chsk/bad-package",501893679),pstr], null);
}})();
var vec__47127 = ((wrapped_QMARK_)?clj:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj,null], null));
var clj__$1 = cljs.core.nth.call(null,vec__47127,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.call(null,vec__47127,(1),null);
var _QMARK_cb_uuid__$1 = ((cljs.core._EQ_.call(null,(0),_QMARK_cb_uuid))?new cljs.core.Keyword(null,"ajax-cb","ajax-cb",-807060321):_QMARK_cb_uuid);
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",190,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (wrapped_QMARK_,pstr,clj,vec__47127,clj__$1,_QMARK_cb_uuid,_QMARK_cb_uuid__$1){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Unpacking: %s -> %s",prefixed_pstr,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj__$1,_QMARK_cb_uuid__$1], null)], null);
});})(wrapped_QMARK_,pstr,clj,vec__47127,clj__$1,_QMARK_cb_uuid,_QMARK_cb_uuid__$1))
,null)),null,1125106311);

return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj__$1,_QMARK_cb_uuid__$1], null);
});
taoensso.sente.with__QMARK_meta = (function taoensso$sente$with__QMARK_meta(x,_QMARK_m){
if(cljs.core.seq.call(null,_QMARK_m)){
return cljs.core.with_meta.call(null,x,_QMARK_m);
} else {
return x;
}
});
/**
 * clj->prefixed-pstr
 */
taoensso.sente.pack = (function taoensso$sente$pack(var_args){
var args47131 = [];
var len__8723__auto___47134 = arguments.length;
var i__8724__auto___47135 = (0);
while(true){
if((i__8724__auto___47135 < len__8723__auto___47134)){
args47131.push((arguments[i__8724__auto___47135]));

var G__47136 = (i__8724__auto___47135 + (1));
i__8724__auto___47135 = G__47136;
continue;
} else {
}
break;
}

var G__47133 = args47131.length;
switch (G__47133) {
case 3:
return taoensso.sente.pack.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return taoensso.sente.pack.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47131.length)].join('')));

}
});

taoensso.sente.pack.cljs$core$IFn$_invoke$arity$3 = (function (packer,_QMARK_packer_meta,clj){
var pstr = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("-"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.sente.interfaces.pack.call(null,packer,taoensso.sente.with__QMARK_meta.call(null,clj,_QMARK_packer_meta)))].join('');
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",200,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (pstr){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Packing (unwrapped): %s -> %s",new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_packer_meta,clj], null),pstr], null);
});})(pstr))
,null)),null,-1767980457);

return pstr;
});

taoensso.sente.pack.cljs$core$IFn$_invoke$arity$4 = (function (packer,_QMARK_packer_meta,clj,_QMARK_cb_uuid){
var _QMARK_cb_uuid__$1 = ((cljs.core._EQ_.call(null,_QMARK_cb_uuid,new cljs.core.Keyword(null,"ajax-cb","ajax-cb",-807060321)))?(0):_QMARK_cb_uuid);
var wrapped_clj = (cljs.core.truth_(_QMARK_cb_uuid__$1)?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj,_QMARK_cb_uuid__$1], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [clj], null));
var pstr = [cljs.core.str.cljs$core$IFn$_invoke$arity$1("+"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.sente.interfaces.pack.call(null,packer,taoensso.sente.with__QMARK_meta.call(null,wrapped_clj,_QMARK_packer_meta)))].join('');
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",210,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (_QMARK_cb_uuid__$1,wrapped_clj,pstr){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Packing (wrapped): %s -> %s",new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_packer_meta,clj,_QMARK_cb_uuid__$1], null),pstr], null);
});})(_QMARK_cb_uuid__$1,wrapped_clj,pstr))
,null)),null,425459445);

return pstr;
});

taoensso.sente.pack.cljs$lang$maxFixedArity = 4;


/**
* @constructor
 * @implements {taoensso.sente.interfaces.IPacker}
*/
taoensso.sente.EdnPacker = (function (){
})

taoensso.sente.EdnPacker.prototype.taoensso$sente$interfaces$IPacker$ = cljs.core.PROTOCOL_SENTINEL;


taoensso.sente.EdnPacker.prototype.taoensso$sente$interfaces$IPacker$pack$arity$2 = (function (_,x){
var self__ = this;
var ___$1 = this;
return taoensso.encore.pr_edn.call(null,x);
});


taoensso.sente.EdnPacker.prototype.taoensso$sente$interfaces$IPacker$unpack$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return taoensso.encore.read_edn.call(null,s);
});

taoensso.sente.EdnPacker.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

taoensso.sente.EdnPacker.cljs$lang$type = true;

taoensso.sente.EdnPacker.cljs$lang$ctorStr = "taoensso.sente/EdnPacker";

taoensso.sente.EdnPacker.cljs$lang$ctorPrWriter = (function (this__8159__auto__,writer__8160__auto__,opt__8161__auto__){
return cljs.core._write.call(null,writer__8160__auto__,"taoensso.sente/EdnPacker");
});

taoensso.sente.__GT_EdnPacker = (function taoensso$sente$__GT_EdnPacker(){
return (new taoensso.sente.EdnPacker());
});

taoensso.sente.default_edn_packer = (new taoensso.sente.EdnPacker());
taoensso.sente.coerce_packer = (function taoensso$sente$coerce_packer(x){
if(cljs.core._EQ_.call(null,x,new cljs.core.Keyword(null,"edn","edn",1317840885))){
return taoensso.sente.default_edn_packer;
} else {
var e = (function (){try{if((function (p1__47138_SHARP_){
if(!((p1__47138_SHARP_ == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === p1__47138_SHARP_.taoensso$sente$interfaces$IPacker$))){
return true;
} else {
if((!p1__47138_SHARP_.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,taoensso.sente.interfaces.IPacker,p1__47138_SHARP_);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,taoensso.sente.interfaces.IPacker,p1__47138_SHARP_);
}
}).call(null,x)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e47141){if((e47141 instanceof Error)){
var e = e47141;
return e;
} else {
throw e47141;

}
}})();
if((e == null)){
return x;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",223,"((fn* [p1__47138#] (satisfies? interfaces/IPacker p1__47138#)) x)",x,e,null);
}
}
});


/**
 * Takes a web server adapter[1] and returns a map with keys:
 *  :ch-recv ; core.async channel to receive `event-msg`s (internal or from clients).
 *  :send-fn ; (fn [user-id ev] for server>user push.
 *  :ajax-post-fn                ; (fn [ring-req]) for Ring CSRF-POST + chsk URL.
 *  :ajax-get-or-ws-handshake-fn ; (fn [ring-req]) for Ring GET + chsk URL.
 *  :connected-uids ; Watchable, read-only (atom {:ws #{_} :ajax #{_} :any #{_}}).
 * 
 *   Common options:
 *  :user-id-fn        ; (fn [ring-req]) -> unique user-id for server>user push.
 *  :csrf-token-fn     ; (fn [ring-req]) -> CSRF token for Ajax POSTs.
 *  :handshake-data-fn ; (fn [ring-req]) -> arb user data to append to handshake evs.
 *  :ws-kalive-ms      ; Ping to keep a WebSocket conn alive if no activity
 *                     ; w/in given msecs.
 *  :lp-timeout-ms     ; Timeout (repoll) long-polling Ajax conns after given msecs.
 *  :send-buf-ms-ajax  ; [2]
 *  :send-buf-ms-ws    ; [2]
 *  :packer            ; :edn (default), or an IPacker implementation.
 * 
 *   [1] e.g. `(taoensso.sente.server-adapters.http-kit/get-sch-adapter)` or
 *         `(taoensso.sente.server-adapters.immutant/get-sch-adapter)`.
 *    You must have the necessary web-server dependency in your project.clj and
 *    the necessary entry in your namespace's `ns` form.
 * 
 *   [2] Optimization to allow transparent batching of rapidly-triggered
 *    server>user pushes. This is esp. important for Ajax clients which use a
 *    (slow) reconnecting poller. Actual event dispatch may occur <= given ms
 *    after send call (larger values => larger batch windows).
 */
taoensso.sente.make_channel_socket_server_BANG_ = (function taoensso$sente$make_channel_socket_server_BANG_(var_args){
var args__8730__auto__ = [];
var len__8723__auto___47449 = arguments.length;
var i__8724__auto___47450 = (0);
while(true){
if((i__8724__auto___47450 < len__8723__auto___47449)){
args__8730__auto__.push((arguments[i__8724__auto___47450]));

var G__47451 = (i__8724__auto___47450 + (1));
i__8724__auto___47450 = G__47451;
continue;
} else {
}
break;
}

var argseq__8731__auto__ = ((((1) < args__8730__auto__.length))?(new cljs.core.IndexedSeq(args__8730__auto__.slice((1)),(0),null)):null);
return taoensso.sente.make_channel_socket_server_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8731__auto__);
});

taoensso.sente.make_channel_socket_server_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (web_server_ch_adapter,p__47146){
var vec__47147 = p__47146;
var map__47150 = cljs.core.nth.call(null,vec__47147,(0),null);
var map__47150__$1 = ((((!((map__47150 == null)))?((((map__47150.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47150.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47150):map__47150);
var recv_buf_or_n = cljs.core.get.call(null,map__47150__$1,new cljs.core.Keyword(null,"recv-buf-or-n","recv-buf-or-n",1363950355),cljs.core.async.sliding_buffer.call(null,(1000)));
var ws_kalive_ms = cljs.core.get.call(null,map__47150__$1,new cljs.core.Keyword(null,"ws-kalive-ms","ws-kalive-ms",1442179968),taoensso.encore.ms.call(null,new cljs.core.Keyword(null,"secs","secs",1532330091),(25)));
var lp_timeout_ms = cljs.core.get.call(null,map__47150__$1,new cljs.core.Keyword(null,"lp-timeout-ms","lp-timeout-ms",-1451963133),taoensso.encore.ms.call(null,new cljs.core.Keyword(null,"secs","secs",1532330091),(20)));
var send_buf_ms_ajax = cljs.core.get.call(null,map__47150__$1,new cljs.core.Keyword(null,"send-buf-ms-ajax","send-buf-ms-ajax",1546129037),(100));
var send_buf_ms_ws = cljs.core.get.call(null,map__47150__$1,new cljs.core.Keyword(null,"send-buf-ms-ws","send-buf-ms-ws",-1149586238),(30));
var user_id_fn = cljs.core.get.call(null,map__47150__$1,new cljs.core.Keyword(null,"user-id-fn","user-id-fn",-1532150029),((function (vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws){
return (function (ring_req){
return cljs.core.get_in.call(null,ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword(null,"uid","uid",-1447769400)], null));
});})(vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws))
);
var csrf_token_fn = cljs.core.get.call(null,map__47150__$1,new cljs.core.Keyword(null,"csrf-token-fn","csrf-token-fn",-1846298394),((function (vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn){
return (function (ring_req){
var or__7502__auto__ = cljs.core.get_in.call(null,ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856)], null));
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
var or__7502__auto____$1 = cljs.core.get_in.call(null,ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"session","session",1008279103),new cljs.core.Keyword("ring.middleware.anti-forgery","anti-forgery-token","ring.middleware.anti-forgery/anti-forgery-token",571563484)], null));
if(cljs.core.truth_(or__7502__auto____$1)){
return or__7502__auto____$1;
} else {
return cljs.core.get_in.call(null,ring_req,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"session","session",1008279103),"__anti-forgery-token"], null));
}
}
});})(vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn))
);
var handshake_data_fn = cljs.core.get.call(null,map__47150__$1,new cljs.core.Keyword(null,"handshake-data-fn","handshake-data-fn",2011983089),((function (vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn){
return (function (ring_req){
return null;
});})(vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn))
);
var packer = cljs.core.get.call(null,map__47150__$1,new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"edn","edn",1317840885));
new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var e = (function (){try{if(taoensso.encore.pos_int_QMARK_.call(null,send_buf_ms_ajax)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e47152){if((e47152 instanceof Error)){
var e = e47152;
return e;
} else {
throw e47152;

}
}})();
if((e == null)){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",291,"(enc/pos-int? send-buf-ms-ajax)",send_buf_ms_ajax,e,null);
}
})(),(function (){var e = (function (){try{if(taoensso.encore.pos_int_QMARK_.call(null,send_buf_ms_ws)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e47153){if((e47153 instanceof Error)){
var e = e47153;
return e;
} else {
throw e47153;

}
}})();
if((e == null)){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",291,"(enc/pos-int? send-buf-ms-ws)",send_buf_ms_ws,e,null);
}
})()], null);

var e_47452 = (function (){try{if(((function (vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (p1__47143_SHARP_){
if(!((p1__47143_SHARP_ == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === p1__47143_SHARP_.taoensso$sente$interfaces$IServerChanAdapter$))){
return true;
} else {
if((!p1__47143_SHARP_.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,taoensso.sente.interfaces.IServerChanAdapter,p1__47143_SHARP_);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,taoensso.sente.interfaces.IServerChanAdapter,p1__47143_SHARP_);
}
});})(vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
.call(null,web_server_ch_adapter)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e47154){if((e47154 instanceof Error)){
var e = e47154;
return e;
} else {
throw e47154;

}
}})();
if((e_47452 == null)){
} else {
taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",292,"((fn* [p1__47143#] (satisfies? interfaces/IServerChanAdapter p1__47143#)) web-server-ch-adapter)",web_server_ch_adapter,e_47452,null);
}

var max_ms_47453 = taoensso.sente.default_client_side_ajax_timeout_ms;
if((lp_timeout_ms >= max_ms_47453)){
throw cljs.core.ex_info.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(":lp-timeout-ms must be < "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_ms_47453)].join(''),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"lp-timeout-ms","lp-timeout-ms",-1451963133),lp_timeout_ms,new cljs.core.Keyword(null,"default-client-side-ajax-timeout-ms","default-client-side-ajax-timeout-ms",1149929762),max_ms_47453], null));
} else {
}

var packer__$1 = taoensso.sente.coerce_packer.call(null,packer);
var ch_recv = cljs.core.async.chan.call(null,recv_buf_or_n);
var user_id_fn__$1 = ((function (packer__$1,ch_recv,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (ring_req,client_id){
var or__7502__auto__ = user_id_fn.call(null,cljs.core.assoc.call(null,ring_req,new cljs.core.Keyword(null,"client-id","client-id",-464622140),client_id));
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
return new cljs.core.Keyword("taoensso.sente","nil-uid","taoensso.sente/nil-uid",-2111603486);
}
});})(packer__$1,ch_recv,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var conns_ = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ws","ws",86841443),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ajax","ajax",814345549),cljs.core.PersistentArrayMap.EMPTY], null));
var send_buffers_ = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ws","ws",86841443),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ajax","ajax",814345549),cljs.core.PersistentArrayMap.EMPTY], null));
var connected_uids_ = cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"ajax","ajax",814345549),cljs.core.PersistentHashSet.EMPTY,new cljs.core.Keyword(null,"any","any",1705907423),cljs.core.PersistentHashSet.EMPTY], null));
var upd_conn_BANG_ = ((function (packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() {
var G__47454 = null;
var G__47454__3 = (function (conn_type,uid,client_id){
return taoensso.encore.swap_in_BANG_.call(null,conns_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_type,uid,client_id], null),((function (packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (_QMARK_v){
var vec__47156 = _QMARK_v;
var _QMARK_sch = cljs.core.nth.call(null,vec__47156,(0),null);
var _udt = cljs.core.nth.call(null,vec__47156,(1),null);
var new_udt = taoensso.encore.now_udt.call(null);
return taoensso.encore.swapped.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_sch,new_udt], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"init?","init?",438181499),(_QMARK_v == null),new cljs.core.Keyword(null,"udt","udt",2011712751),new_udt,new cljs.core.Keyword(null,"?sch","?sch",2064493898),_QMARK_sch], null));
});})(packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);
});
var G__47454__4 = (function (conn_type,uid,client_id,new__QMARK_sch){
return taoensso.encore.swap_in_BANG_.call(null,conns_,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_type,uid,client_id], null),((function (packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (_QMARK_v){
var new_udt = taoensso.encore.now_udt.call(null);
return taoensso.encore.swapped.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new__QMARK_sch,new_udt], null),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"init?","init?",438181499),(_QMARK_v == null),new cljs.core.Keyword(null,"udt","udt",2011712751),new_udt,new cljs.core.Keyword(null,"?sch","?sch",2064493898),new__QMARK_sch], null));
});})(packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);
});
G__47454 = function(conn_type,uid,client_id,new__QMARK_sch){
switch(arguments.length){
case 3:
return G__47454__3.call(this,conn_type,uid,client_id);
case 4:
return G__47454__4.call(this,conn_type,uid,client_id,new__QMARK_sch);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__47454.cljs$core$IFn$_invoke$arity$3 = G__47454__3;
G__47454.cljs$core$IFn$_invoke$arity$4 = G__47454__4;
return G__47454;
})()
;})(packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var connect_uid_BANG_ = ((function (packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (conn_type,uid){
if(cljs.core.truth_((function (){var e = (function (){try{if(taoensso.truss.impl.some_QMARK_.call(null,uid)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e47159){if((e47159 instanceof Error)){
var e = e47159;
return e;
} else {
throw e47159;

}
}})();
if((e == null)){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",336,"(taoensso.truss.impl/some? uid)",uid,e,null);
}
})())){
} else {
throw (new Error("Assert failed: (have? uid)"));
}

var newly_connected_QMARK_ = taoensso.encore.swap_in_BANG_.call(null,connected_uids_,cljs.core.PersistentVector.EMPTY,((function (packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (p__47160){
var map__47161 = p__47160;
var map__47161__$1 = ((((!((map__47161 == null)))?((((map__47161.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47161.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47161):map__47161);
var old_m = map__47161__$1;
var ws = cljs.core.get.call(null,map__47161__$1,new cljs.core.Keyword(null,"ws","ws",86841443));
var ajax = cljs.core.get.call(null,map__47161__$1,new cljs.core.Keyword(null,"ajax","ajax",814345549));
var any = cljs.core.get.call(null,map__47161__$1,new cljs.core.Keyword(null,"any","any",1705907423));
var new_m = (function (){var G__47163 = (((conn_type instanceof cljs.core.Keyword))?conn_type.fqn:null);
switch (G__47163) {
case "ws":
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),cljs.core.conj.call(null,ws,uid),new cljs.core.Keyword(null,"ajax","ajax",814345549),ajax,new cljs.core.Keyword(null,"any","any",1705907423),cljs.core.conj.call(null,any,uid)], null);

break;
case "ajax":
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),ws,new cljs.core.Keyword(null,"ajax","ajax",814345549),cljs.core.conj.call(null,ajax,uid),new cljs.core.Keyword(null,"any","any",1705907423),cljs.core.conj.call(null,any,uid)], null);

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(conn_type)].join('')));

}
})();
return taoensso.encore.swapped.call(null,new_m,(function (){var old_any = new cljs.core.Keyword(null,"any","any",1705907423).cljs$core$IFn$_invoke$arity$1(old_m);
var new_any = new cljs.core.Keyword(null,"any","any",1705907423).cljs$core$IFn$_invoke$arity$1(new_m);
if((!(cljs.core.contains_QMARK_.call(null,old_any,uid))) && (cljs.core.contains_QMARK_.call(null,new_any,uid))){
return new cljs.core.Keyword(null,"newly-connected","newly-connected",-2029862681);
} else {
return null;
}
})());
});})(packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);
return newly_connected_QMARK_;
});})(packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var upd_connected_uid_BANG_ = ((function (packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (uid){
if(cljs.core.truth_((function (){var e = (function (){try{if(taoensso.truss.impl.some_QMARK_.call(null,uid)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e47164){if((e47164 instanceof Error)){
var e = e47164;
return e;
} else {
throw e47164;

}
}})();
if((e == null)){
return true;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",353,"(taoensso.truss.impl/some? uid)",uid,e,null);
}
})())){
} else {
throw (new Error("Assert failed: (have? uid)"));
}

var newly_disconnected_QMARK_ = taoensso.encore.swap_in_BANG_.call(null,connected_uids_,cljs.core.PersistentVector.EMPTY,((function (packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (p__47165){
var map__47166 = p__47165;
var map__47166__$1 = ((((!((map__47166 == null)))?((((map__47166.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47166.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47166):map__47166);
var old_m = map__47166__$1;
var ws = cljs.core.get.call(null,map__47166__$1,new cljs.core.Keyword(null,"ws","ws",86841443));
var ajax = cljs.core.get.call(null,map__47166__$1,new cljs.core.Keyword(null,"ajax","ajax",814345549));
var any = cljs.core.get.call(null,map__47166__$1,new cljs.core.Keyword(null,"any","any",1705907423));
var conns_SINGLEQUOTE_ = cljs.core.deref.call(null,conns_);
var any_ws_clients_QMARK_ = cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"ws","ws",86841443).cljs$core$IFn$_invoke$arity$1(conns_SINGLEQUOTE_),uid);
var any_ajax_clients_QMARK_ = cljs.core.contains_QMARK_.call(null,new cljs.core.Keyword(null,"ajax","ajax",814345549).cljs$core$IFn$_invoke$arity$1(conns_SINGLEQUOTE_),uid);
var any_clients_QMARK_ = (any_ws_clients_QMARK_) || (any_ajax_clients_QMARK_);
var new_m = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),((any_ws_clients_QMARK_)?cljs.core.conj.call(null,ws,uid):cljs.core.disj.call(null,ws,uid)),new cljs.core.Keyword(null,"ajax","ajax",814345549),((any_ajax_clients_QMARK_)?cljs.core.conj.call(null,ajax,uid):cljs.core.disj.call(null,ajax,uid)),new cljs.core.Keyword(null,"any","any",1705907423),((any_clients_QMARK_)?cljs.core.conj.call(null,any,uid):cljs.core.disj.call(null,any,uid))], null);
return taoensso.encore.swapped.call(null,new_m,(function (){var old_any = new cljs.core.Keyword(null,"any","any",1705907423).cljs$core$IFn$_invoke$arity$1(old_m);
var new_any = new cljs.core.Keyword(null,"any","any",1705907423).cljs$core$IFn$_invoke$arity$1(new_m);
if((cljs.core.contains_QMARK_.call(null,old_any,uid)) && (!(cljs.core.contains_QMARK_.call(null,new_any,uid)))){
return new cljs.core.Keyword(null,"newly-disconnected","newly-disconnected",-1586164962);
} else {
return null;
}
})());
});})(packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);
return newly_disconnected_QMARK_;
});})(packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var send_fn = ((function (packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() { 
var G__47456__delegate = function (user_id,ev,p__47168){
var vec__47169 = p__47168;
var map__47172 = cljs.core.nth.call(null,vec__47169,(0),null);
var map__47172__$1 = ((((!((map__47172 == null)))?((((map__47172.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47172.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47172):map__47172);
var opts = map__47172__$1;
var flush_QMARK_ = cljs.core.get.call(null,map__47172__$1,new cljs.core.Keyword(null,"flush?","flush?",-108887231));
var uid_47457 = ((cljs.core._EQ_.call(null,user_id,new cljs.core.Keyword("sente","all-users-without-uid","sente/all-users-without-uid",-42979578)))?new cljs.core.Keyword("taoensso.sente","nil-uid","taoensso.sente/nil-uid",-2111603486):user_id);
var __47458 = taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",379,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (uid_47457,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send: (->uid %s) %s",uid_47457,ev], null);
});})(uid_47457,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null,-2002097253);
var __47459__$1 = (cljs.core.truth_(uid_47457)?null:(function(){throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Support for sending to `nil` user-ids has been REMOVED. "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("Please send to `:sente/all-users-without-uid` instead.")].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("uid")].join('')))})());
var __47460__$2 = taoensso.sente.assert_event.call(null,ev);
var ev_uuid_47461 = taoensso.encore.uuid_str.call(null);
var flush_buffer_BANG__47462 = ((function (uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (conn_type){
var temp__6753__auto__ = taoensso.encore.swap_in_BANG_.call(null,send_buffers_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_type], null),((function (uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (m){
var vec__47174 = cljs.core.get.call(null,m,uid_47457);
var ___$3 = cljs.core.nth.call(null,vec__47174,(0),null);
var ev_uuids = cljs.core.nth.call(null,vec__47174,(1),null);
if(cljs.core.contains_QMARK_.call(null,ev_uuids,ev_uuid_47461)){
return taoensso.encore.swapped.call(null,cljs.core.dissoc.call(null,m,uid_47457),cljs.core.get.call(null,m,uid_47457));
} else {
return taoensso.encore.swapped.call(null,m,null);
}
});})(uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);
if(cljs.core.truth_(temp__6753__auto__)){
var pulled = temp__6753__auto__;
var vec__47177 = pulled;
var buffered_evs = cljs.core.nth.call(null,vec__47177,(0),null);
var ev_uuids = cljs.core.nth.call(null,vec__47177,(1),null);
if(cljs.core.vector_QMARK_.call(null,buffered_evs)){
} else {
taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",406,"(vector? buffered-evs)",buffered_evs,null,null);
}

if(cljs.core.set_QMARK_.call(null,ev_uuids)){
} else {
taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",407,"(set? ev-uuids)",ev_uuids,null,null);
}

var packer_metas = cljs.core.mapv.call(null,cljs.core.meta,buffered_evs);
var combined_packer_meta = cljs.core.reduce.call(null,cljs.core.merge,cljs.core.PersistentArrayMap.EMPTY,packer_metas);
var buffered_evs_ppstr = taoensso.sente.pack.call(null,packer__$1,combined_packer_meta,buffered_evs);
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",415,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (packer_metas,combined_packer_meta,buffered_evs_ppstr,vec__47177,buffered_evs,ev_uuids,pulled,temp__6753__auto__,uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["buffered-evs-ppstr: %s (with meta %s)",buffered_evs_ppstr,combined_packer_meta], null);
});})(packer_metas,combined_packer_meta,buffered_evs_ppstr,vec__47177,buffered_evs,ev_uuids,pulled,temp__6753__auto__,uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null,-1019418487);

var G__47180 = (((conn_type instanceof cljs.core.Keyword))?conn_type.fqn:null);
switch (G__47180) {
case "ws":
return taoensso.sente.send_buffered_server_evs_GT_ws_clients_BANG_.call(null,conns_,uid_47457,buffered_evs_ppstr,upd_conn_BANG_);

break;
case "ajax":
return taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_.call(null,conns_,uid_47457,buffered_evs_ppstr);

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(conn_type)].join('')));

}
} else {
return null;
}
});})(uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
if(cljs.core._EQ_.call(null,ev,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","close","chsk/close",1840295819)], null))){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",426,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,flush_buffer_BANG__47462,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk closing (client may reconnect): %s",uid_47457], null);
});})(uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,flush_buffer_BANG__47462,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null,172272725);

if(cljs.core.truth_(flush_QMARK_)){
flush_buffer_BANG__47462.call(null,new cljs.core.Keyword(null,"ws","ws",86841443));

flush_buffer_BANG__47462.call(null,new cljs.core.Keyword(null,"ajax","ajax",814345549));
} else {
}

var seq__47181_47464 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,conns_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),uid_47457], null))));
var chunk__47182_47465 = null;
var count__47183_47466 = (0);
var i__47184_47467 = (0);
while(true){
if((i__47184_47467 < count__47183_47466)){
var vec__47185_47468 = cljs.core._nth.call(null,chunk__47182_47465,i__47184_47467);
var _QMARK_sch_47469 = cljs.core.nth.call(null,vec__47185_47468,(0),null);
var _udt_47470 = cljs.core.nth.call(null,vec__47185_47468,(1),null);
var temp__6753__auto___47471 = _QMARK_sch_47469;
if(cljs.core.truth_(temp__6753__auto___47471)){
var sch_47472 = temp__6753__auto___47471;
taoensso.sente.interfaces.sch_close_BANG_.call(null,sch_47472);
} else {
}

var G__47473 = seq__47181_47464;
var G__47474 = chunk__47182_47465;
var G__47475 = count__47183_47466;
var G__47476 = (i__47184_47467 + (1));
seq__47181_47464 = G__47473;
chunk__47182_47465 = G__47474;
count__47183_47466 = G__47475;
i__47184_47467 = G__47476;
continue;
} else {
var temp__6753__auto___47477 = cljs.core.seq.call(null,seq__47181_47464);
if(temp__6753__auto___47477){
var seq__47181_47478__$1 = temp__6753__auto___47477;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47181_47478__$1)){
var c__8413__auto___47479 = cljs.core.chunk_first.call(null,seq__47181_47478__$1);
var G__47480 = cljs.core.chunk_rest.call(null,seq__47181_47478__$1);
var G__47481 = c__8413__auto___47479;
var G__47482 = cljs.core.count.call(null,c__8413__auto___47479);
var G__47483 = (0);
seq__47181_47464 = G__47480;
chunk__47182_47465 = G__47481;
count__47183_47466 = G__47482;
i__47184_47467 = G__47483;
continue;
} else {
var vec__47188_47484 = cljs.core.first.call(null,seq__47181_47478__$1);
var _QMARK_sch_47485 = cljs.core.nth.call(null,vec__47188_47484,(0),null);
var _udt_47486 = cljs.core.nth.call(null,vec__47188_47484,(1),null);
var temp__6753__auto___47487__$1 = _QMARK_sch_47485;
if(cljs.core.truth_(temp__6753__auto___47487__$1)){
var sch_47488 = temp__6753__auto___47487__$1;
taoensso.sente.interfaces.sch_close_BANG_.call(null,sch_47488);
} else {
}

var G__47489 = cljs.core.next.call(null,seq__47181_47478__$1);
var G__47490 = null;
var G__47491 = (0);
var G__47492 = (0);
seq__47181_47464 = G__47489;
chunk__47182_47465 = G__47490;
count__47183_47466 = G__47491;
i__47184_47467 = G__47492;
continue;
}
} else {
}
}
break;
}

var seq__47191_47493 = cljs.core.seq.call(null,cljs.core.vals.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,conns_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid_47457], null))));
var chunk__47192_47494 = null;
var count__47193_47495 = (0);
var i__47194_47496 = (0);
while(true){
if((i__47194_47496 < count__47193_47495)){
var vec__47195_47497 = cljs.core._nth.call(null,chunk__47192_47494,i__47194_47496);
var _QMARK_sch_47498 = cljs.core.nth.call(null,vec__47195_47497,(0),null);
var _udt_47499 = cljs.core.nth.call(null,vec__47195_47497,(1),null);
var temp__6753__auto___47500 = _QMARK_sch_47498;
if(cljs.core.truth_(temp__6753__auto___47500)){
var sch_47501 = temp__6753__auto___47500;
taoensso.sente.interfaces.sch_close_BANG_.call(null,sch_47501);
} else {
}

var G__47502 = seq__47191_47493;
var G__47503 = chunk__47192_47494;
var G__47504 = count__47193_47495;
var G__47505 = (i__47194_47496 + (1));
seq__47191_47493 = G__47502;
chunk__47192_47494 = G__47503;
count__47193_47495 = G__47504;
i__47194_47496 = G__47505;
continue;
} else {
var temp__6753__auto___47506 = cljs.core.seq.call(null,seq__47191_47493);
if(temp__6753__auto___47506){
var seq__47191_47507__$1 = temp__6753__auto___47506;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47191_47507__$1)){
var c__8413__auto___47508 = cljs.core.chunk_first.call(null,seq__47191_47507__$1);
var G__47509 = cljs.core.chunk_rest.call(null,seq__47191_47507__$1);
var G__47510 = c__8413__auto___47508;
var G__47511 = cljs.core.count.call(null,c__8413__auto___47508);
var G__47512 = (0);
seq__47191_47493 = G__47509;
chunk__47192_47494 = G__47510;
count__47193_47495 = G__47511;
i__47194_47496 = G__47512;
continue;
} else {
var vec__47198_47513 = cljs.core.first.call(null,seq__47191_47507__$1);
var _QMARK_sch_47514 = cljs.core.nth.call(null,vec__47198_47513,(0),null);
var _udt_47515 = cljs.core.nth.call(null,vec__47198_47513,(1),null);
var temp__6753__auto___47516__$1 = _QMARK_sch_47514;
if(cljs.core.truth_(temp__6753__auto___47516__$1)){
var sch_47517 = temp__6753__auto___47516__$1;
taoensso.sente.interfaces.sch_close_BANG_.call(null,sch_47517);
} else {
}

var G__47518 = cljs.core.next.call(null,seq__47191_47507__$1);
var G__47519 = null;
var G__47520 = (0);
var G__47521 = (0);
seq__47191_47493 = G__47518;
chunk__47192_47494 = G__47519;
count__47193_47495 = G__47520;
i__47194_47496 = G__47521;
continue;
}
} else {
}
}
break;
}
} else {
var seq__47201_47522 = cljs.core.seq.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"ajax","ajax",814345549)], null));
var chunk__47202_47523 = null;
var count__47203_47524 = (0);
var i__47204_47525 = (0);
while(true){
if((i__47204_47525 < count__47203_47524)){
var conn_type_47526 = cljs.core._nth.call(null,chunk__47202_47523,i__47204_47525);
taoensso.encore.swap_in_BANG_.call(null,send_buffers_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_type_47526,uid_47457], null),((function (seq__47201_47522,chunk__47202_47523,count__47203_47524,i__47204_47525,conn_type_47526,uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,flush_buffer_BANG__47462,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (_QMARK_v){
if(cljs.core.not.call(null,_QMARK_v)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ev], null),cljs.core.PersistentHashSet.createAsIfByAssoc([ev_uuid_47461], true)], null);
} else {
var vec__47205 = _QMARK_v;
var buffered_evs = cljs.core.nth.call(null,vec__47205,(0),null);
var ev_uuids = cljs.core.nth.call(null,vec__47205,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,buffered_evs,ev),cljs.core.conj.call(null,ev_uuids,ev_uuid_47461)], null);
}
});})(seq__47201_47522,chunk__47202_47523,count__47203_47524,i__47204_47525,conn_type_47526,uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,flush_buffer_BANG__47462,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

var G__47527 = seq__47201_47522;
var G__47528 = chunk__47202_47523;
var G__47529 = count__47203_47524;
var G__47530 = (i__47204_47525 + (1));
seq__47201_47522 = G__47527;
chunk__47202_47523 = G__47528;
count__47203_47524 = G__47529;
i__47204_47525 = G__47530;
continue;
} else {
var temp__6753__auto___47531 = cljs.core.seq.call(null,seq__47201_47522);
if(temp__6753__auto___47531){
var seq__47201_47532__$1 = temp__6753__auto___47531;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47201_47532__$1)){
var c__8413__auto___47533 = cljs.core.chunk_first.call(null,seq__47201_47532__$1);
var G__47534 = cljs.core.chunk_rest.call(null,seq__47201_47532__$1);
var G__47535 = c__8413__auto___47533;
var G__47536 = cljs.core.count.call(null,c__8413__auto___47533);
var G__47537 = (0);
seq__47201_47522 = G__47534;
chunk__47202_47523 = G__47535;
count__47203_47524 = G__47536;
i__47204_47525 = G__47537;
continue;
} else {
var conn_type_47538 = cljs.core.first.call(null,seq__47201_47532__$1);
taoensso.encore.swap_in_BANG_.call(null,send_buffers_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_type_47538,uid_47457], null),((function (seq__47201_47522,chunk__47202_47523,count__47203_47524,i__47204_47525,conn_type_47538,seq__47201_47532__$1,temp__6753__auto___47531,uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,flush_buffer_BANG__47462,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (_QMARK_v){
if(cljs.core.not.call(null,_QMARK_v)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [ev], null),cljs.core.PersistentHashSet.createAsIfByAssoc([ev_uuid_47461], true)], null);
} else {
var vec__47208 = _QMARK_v;
var buffered_evs = cljs.core.nth.call(null,vec__47208,(0),null);
var ev_uuids = cljs.core.nth.call(null,vec__47208,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.call(null,buffered_evs,ev),cljs.core.conj.call(null,ev_uuids,ev_uuid_47461)], null);
}
});})(seq__47201_47522,chunk__47202_47523,count__47203_47524,i__47204_47525,conn_type_47538,seq__47201_47532__$1,temp__6753__auto___47531,uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,flush_buffer_BANG__47462,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

var G__47539 = cljs.core.next.call(null,seq__47201_47532__$1);
var G__47540 = null;
var G__47541 = (0);
var G__47542 = (0);
seq__47201_47522 = G__47539;
chunk__47202_47523 = G__47540;
count__47203_47524 = G__47541;
i__47204_47525 = G__47542;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(flush_QMARK_)){
flush_buffer_BANG__47462.call(null,new cljs.core.Keyword(null,"ws","ws",86841443));

flush_buffer_BANG__47462.call(null,new cljs.core.Keyword(null,"ajax","ajax",814345549));
} else {
var ws_timeout_47543 = cljs.core.async.timeout.call(null,send_buf_ms_ws);
var ajax_timeout_47544 = cljs.core.async.timeout.call(null,send_buf_ms_ajax);
var c__42603__auto___47545 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto___47545,ws_timeout_47543,ajax_timeout_47544,uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,flush_buffer_BANG__47462,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto___47545,ws_timeout_47543,ajax_timeout_47544,uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,flush_buffer_BANG__47462,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (state_47215){
var state_val_47216 = (state_47215[(1)]);
if((state_val_47216 === (1))){
var state_47215__$1 = state_47215;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47215__$1,(2),ws_timeout_47543);
} else {
if((state_val_47216 === (2))){
var inst_47212 = (state_47215[(2)]);
var inst_47213 = flush_buffer_BANG__47462.call(null,new cljs.core.Keyword(null,"ws","ws",86841443));
var state_47215__$1 = (function (){var statearr_47217 = state_47215;
(statearr_47217[(7)] = inst_47212);

return statearr_47217;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47215__$1,inst_47213);
} else {
return null;
}
}
});})(c__42603__auto___47545,ws_timeout_47543,ajax_timeout_47544,uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,flush_buffer_BANG__47462,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
return ((function (switch__42489__auto__,c__42603__auto___47545,ws_timeout_47543,ajax_timeout_47544,uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,flush_buffer_BANG__47462,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() {
var taoensso$sente$state_machine__42490__auto__ = null;
var taoensso$sente$state_machine__42490__auto____0 = (function (){
var statearr_47221 = [null,null,null,null,null,null,null,null];
(statearr_47221[(0)] = taoensso$sente$state_machine__42490__auto__);

(statearr_47221[(1)] = (1));

return statearr_47221;
});
var taoensso$sente$state_machine__42490__auto____1 = (function (state_47215){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_47215);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e47222){if((e47222 instanceof Object)){
var ex__42493__auto__ = e47222;
var statearr_47223_47546 = state_47215;
(statearr_47223_47546[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47215);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47222;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47547 = state_47215;
state_47215 = G__47547;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
taoensso$sente$state_machine__42490__auto__ = function(state_47215){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__42490__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__42490__auto____1.call(this,state_47215);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__42490__auto____0;
taoensso$sente$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__42490__auto____1;
return taoensso$sente$state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto___47545,ws_timeout_47543,ajax_timeout_47544,uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,flush_buffer_BANG__47462,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var state__42605__auto__ = (function (){var statearr_47224 = f__42604__auto__.call(null);
(statearr_47224[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___47545);

return statearr_47224;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto___47545,ws_timeout_47543,ajax_timeout_47544,uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,flush_buffer_BANG__47462,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);


var c__42603__auto___47548 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto___47548,ws_timeout_47543,ajax_timeout_47544,uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,flush_buffer_BANG__47462,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto___47548,ws_timeout_47543,ajax_timeout_47544,uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,flush_buffer_BANG__47462,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (state_47229){
var state_val_47230 = (state_47229[(1)]);
if((state_val_47230 === (1))){
var state_47229__$1 = state_47229;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47229__$1,(2),ajax_timeout_47544);
} else {
if((state_val_47230 === (2))){
var inst_47226 = (state_47229[(2)]);
var inst_47227 = flush_buffer_BANG__47462.call(null,new cljs.core.Keyword(null,"ajax","ajax",814345549));
var state_47229__$1 = (function (){var statearr_47231 = state_47229;
(statearr_47231[(7)] = inst_47226);

return statearr_47231;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47229__$1,inst_47227);
} else {
return null;
}
}
});})(c__42603__auto___47548,ws_timeout_47543,ajax_timeout_47544,uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,flush_buffer_BANG__47462,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
return ((function (switch__42489__auto__,c__42603__auto___47548,ws_timeout_47543,ajax_timeout_47544,uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,flush_buffer_BANG__47462,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() {
var taoensso$sente$state_machine__42490__auto__ = null;
var taoensso$sente$state_machine__42490__auto____0 = (function (){
var statearr_47235 = [null,null,null,null,null,null,null,null];
(statearr_47235[(0)] = taoensso$sente$state_machine__42490__auto__);

(statearr_47235[(1)] = (1));

return statearr_47235;
});
var taoensso$sente$state_machine__42490__auto____1 = (function (state_47229){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_47229);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e47236){if((e47236 instanceof Object)){
var ex__42493__auto__ = e47236;
var statearr_47237_47549 = state_47229;
(statearr_47237_47549[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47229);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47236;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47550 = state_47229;
state_47229 = G__47550;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
taoensso$sente$state_machine__42490__auto__ = function(state_47229){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__42490__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__42490__auto____1.call(this,state_47229);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__42490__auto____0;
taoensso$sente$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__42490__auto____1;
return taoensso$sente$state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto___47548,ws_timeout_47543,ajax_timeout_47544,uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,flush_buffer_BANG__47462,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var state__42605__auto__ = (function (){var statearr_47238 = f__42604__auto__.call(null);
(statearr_47238[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___47548);

return statearr_47238;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto___47548,ws_timeout_47543,ajax_timeout_47544,uid_47457,__47458,__47459__$1,__47460__$2,ev_uuid_47461,flush_buffer_BANG__47462,vec__47169,map__47172,map__47172__$1,opts,flush_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

}
}

return null;
};
var G__47456 = function (user_id,ev,var_args){
var p__47168 = null;
if (arguments.length > 2) {
var G__47551__i = 0, G__47551__a = new Array(arguments.length -  2);
while (G__47551__i < G__47551__a.length) {G__47551__a[G__47551__i] = arguments[G__47551__i + 2]; ++G__47551__i;}
  p__47168 = new cljs.core.IndexedSeq(G__47551__a,0);
} 
return G__47456__delegate.call(this,user_id,ev,p__47168);};
G__47456.cljs$lang$maxFixedArity = 2;
G__47456.cljs$lang$applyTo = (function (arglist__47552){
var user_id = cljs.core.first(arglist__47552);
arglist__47552 = cljs.core.next(arglist__47552);
var ev = cljs.core.first(arglist__47552);
var p__47168 = cljs.core.rest(arglist__47552);
return G__47456__delegate(user_id,ev,p__47168);
});
G__47456.cljs$core$IFn$_invoke$arity$variadic = G__47456__delegate;
return G__47456;
})()
;})(packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var ev_msg_const = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),ch_recv,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"connected-uids","connected-uids",1454332231),connected_uids_], null);
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),ch_recv,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"connected-uids","connected-uids",1454332231),connected_uids_,new cljs.core.Keyword(null,"ajax-post-fn","ajax-post-fn",1830071264),((function (packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (ring_req){
return taoensso.sente.interfaces.ring_req__GT_server_ch_resp.call(null,web_server_ch_adapter,ring_req,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-open","on-open",-1391088163),((function (packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch,websocket_QMARK_){
if(cljs.core.not.call(null,websocket_QMARK_)){
} else {
throw (new Error("Assert failed: (not websocket?)"));
}

var params = cljs.core.get.call(null,ring_req,new cljs.core.Keyword(null,"params","params",710516235));
var ppstr = cljs.core.get.call(null,params,new cljs.core.Keyword(null,"ppstr","ppstr",1557495252));
var client_id = cljs.core.get.call(null,params,new cljs.core.Keyword(null,"client-id","client-id",-464622140));
var vec__47239 = taoensso.sente.unpack.call(null,packer__$1,ppstr);
var clj = cljs.core.nth.call(null,vec__47239,(0),null);
var has_cb_QMARK_ = cljs.core.nth.call(null,vec__47239,(1),null);
var reply_fn = (function (){var replied_QMARK__ = cljs.core.atom.call(null,false);
return ((function (replied_QMARK__,params,ppstr,client_id,vec__47239,clj,has_cb_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (resp_clj){
if(cljs.core.truth_(cljs.core.compare_and_set_BANG_.call(null,replied_QMARK__,false,true))){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",495,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (replied_QMARK__,params,ppstr,client_id,vec__47239,clj,has_cb_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send (ajax post reply): %s",resp_clj], null);
});})(replied_QMARK__,params,ppstr,client_id,vec__47239,clj,has_cb_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null,-974115958);

return taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,websocket_QMARK_,taoensso.sente.pack.call(null,packer__$1,cljs.core.meta.call(null,resp_clj),resp_clj));
} else {
return null;
}
});
;})(replied_QMARK__,params,ppstr,client_id,vec__47239,clj,has_cb_QMARK_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
taoensso.sente.put_server_event_msg_GT_ch_recv_BANG_.call(null,ch_recv,cljs.core.merge.call(null,ev_msg_const,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),client_id,new cljs.core.Keyword(null,"ring-req","ring-req",-747861961),ring_req,new cljs.core.Keyword(null,"event","event",301435442),clj,new cljs.core.Keyword(null,"uid","uid",-1447769400),user_id_fn__$1.call(null,ring_req,client_id),new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592),(cljs.core.truth_(has_cb_QMARK_)?reply_fn:null)], null)));

if(cljs.core.truth_(has_cb_QMARK_)){
var temp__6753__auto__ = lp_timeout_ms;
if(cljs.core.truth_(temp__6753__auto__)){
var ms = temp__6753__auto__;
var c__42603__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto__,ms,temp__6753__auto__,params,ppstr,client_id,vec__47239,clj,has_cb_QMARK_,reply_fn,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto__,ms,temp__6753__auto__,params,ppstr,client_id,vec__47239,clj,has_cb_QMARK_,reply_fn,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (state_47247){
var state_val_47248 = (state_47247[(1)]);
if((state_val_47248 === (1))){
var inst_47242 = cljs.core.async.timeout.call(null,ms);
var state_47247__$1 = state_47247;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47247__$1,(2),inst_47242);
} else {
if((state_val_47248 === (2))){
var inst_47244 = (state_47247[(2)]);
var inst_47245 = reply_fn.call(null,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489));
var state_47247__$1 = (function (){var statearr_47249 = state_47247;
(statearr_47249[(7)] = inst_47244);

return statearr_47249;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47247__$1,inst_47245);
} else {
return null;
}
}
});})(c__42603__auto__,ms,temp__6753__auto__,params,ppstr,client_id,vec__47239,clj,has_cb_QMARK_,reply_fn,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
return ((function (switch__42489__auto__,c__42603__auto__,ms,temp__6753__auto__,params,ppstr,client_id,vec__47239,clj,has_cb_QMARK_,reply_fn,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() {
var taoensso$sente$state_machine__42490__auto__ = null;
var taoensso$sente$state_machine__42490__auto____0 = (function (){
var statearr_47253 = [null,null,null,null,null,null,null,null];
(statearr_47253[(0)] = taoensso$sente$state_machine__42490__auto__);

(statearr_47253[(1)] = (1));

return statearr_47253;
});
var taoensso$sente$state_machine__42490__auto____1 = (function (state_47247){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_47247);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e47254){if((e47254 instanceof Object)){
var ex__42493__auto__ = e47254;
var statearr_47255_47553 = state_47247;
(statearr_47255_47553[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47247);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47254;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47554 = state_47247;
state_47247 = G__47554;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
taoensso$sente$state_machine__42490__auto__ = function(state_47247){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__42490__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__42490__auto____1.call(this,state_47247);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__42490__auto____0;
taoensso$sente$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__42490__auto____1;
return taoensso$sente$state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto__,ms,temp__6753__auto__,params,ppstr,client_id,vec__47239,clj,has_cb_QMARK_,reply_fn,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var state__42605__auto__ = (function (){var statearr_47256 = f__42604__auto__.call(null);
(statearr_47256[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto__);

return statearr_47256;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto__,ms,temp__6753__auto__,params,ppstr,client_id,vec__47239,clj,has_cb_QMARK_,reply_fn,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

return c__42603__auto__;
} else {
return null;
}
} else {
return reply_fn.call(null,new cljs.core.Keyword("chsk","dummy-cb-200","chsk/dummy-cb-200",-1663130337));
}
});})(packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
], null));
});})(packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,new cljs.core.Keyword(null,"ajax-get-or-ws-handshake-fn","ajax-get-or-ws-handshake-fn",-1210409233),((function (packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (ring_req){
var sch_uuid = taoensso.encore.uuid_str.call(null,(6));
var params = cljs.core.get.call(null,ring_req,new cljs.core.Keyword(null,"params","params",710516235));
var client_id = cljs.core.get.call(null,params,new cljs.core.Keyword(null,"client-id","client-id",-464622140));
var csrf_token = csrf_token_fn.call(null,ring_req);
var uid = user_id_fn__$1.call(null,ring_req,client_id);
var receive_event_msg_BANG_ = ((function (sch_uuid,params,client_id,csrf_token,uid,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() {
var taoensso$sente$self = null;
var taoensso$sente$self__1 = (function (event){
return taoensso$sente$self.call(null,event,null);
});
var taoensso$sente$self__2 = (function (event,_QMARK_reply_fn){
return taoensso.sente.put_server_event_msg_GT_ch_recv_BANG_.call(null,ch_recv,cljs.core.merge.call(null,ev_msg_const,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),client_id,new cljs.core.Keyword(null,"ring-req","ring-req",-747861961),ring_req,new cljs.core.Keyword(null,"event","event",301435442),event,new cljs.core.Keyword(null,"?reply-fn","?reply-fn",-1479510592),_QMARK_reply_fn,new cljs.core.Keyword(null,"uid","uid",-1447769400),uid], null)));
});
taoensso$sente$self = function(event,_QMARK_reply_fn){
switch(arguments.length){
case 1:
return taoensso$sente$self__1.call(this,event);
case 2:
return taoensso$sente$self__2.call(this,event,_QMARK_reply_fn);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$self.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$self__1;
taoensso$sente$self.cljs$core$IFn$_invoke$arity$2 = taoensso$sente$self__2;
return taoensso$sente$self;
})()
;})(sch_uuid,params,client_id,csrf_token,uid,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
var send_handshake_BANG_ = ((function (sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch,websocket_QMARK_){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",540,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["send-handshake!"], null);
});})(sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null,126620251);

var _QMARK_handshake_data = handshake_data_fn.call(null,ring_req);
var handshake_ev = (((_QMARK_handshake_data == null))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [uid,csrf_token], null)], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [uid,csrf_token,_QMARK_handshake_data], null)], null));
return taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,websocket_QMARK_,taoensso.sente.pack.call(null,packer__$1,null,handshake_ev));
});})(sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
if(clojure.string.blank_QMARK_.call(null,client_id)){
var err_msg = "Client's Ring request doesn't have a client id. Does your server have the necessary keyword Ring middleware (`wrap-params` & `wrap-keyword-params`)?";
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",551,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (err_msg,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),cljs.core.str.cljs$core$IFn$_invoke$arity$1(": %s")].join(''),ring_req], null);
});})(err_msg,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null,1371946885);

throw cljs.core.ex_info.call(null,err_msg,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"ring-req","ring-req",-747861961),ring_req], null));
} else {
return taoensso.sente.interfaces.ring_req__GT_server_ch_resp.call(null,web_server_ch_adapter,ring_req,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"on-open","on-open",-1391088163),((function (sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch,websocket_QMARK_){
if(cljs.core.truth_(websocket_QMARK_)){
var _ = taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",560,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["New WebSocket channel: %s (%s)",uid,sch_uuid], null);
});})(sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null,-262328543);
var updated_conn = upd_conn_BANG_.call(null,new cljs.core.Keyword(null,"ws","ws",86841443),uid,client_id,server_ch);
var udt_open = new cljs.core.Keyword(null,"udt","udt",2011712751).cljs$core$IFn$_invoke$arity$1(updated_conn);
if(cljs.core.truth_(connect_uid_BANG_.call(null,new cljs.core.Keyword(null,"ws","ws",86841443),uid))){
receive_event_msg_BANG_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","uidport-open","chsk/uidport-open",1685786954),uid], null));
} else {
}

send_handshake_BANG_.call(null,server_ch,websocket_QMARK_);

var temp__6753__auto__ = ws_kalive_ms;
if(cljs.core.truth_(temp__6753__auto__)){
var ms = temp__6753__auto__;
var c__42603__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto__,ms,temp__6753__auto__,_,updated_conn,udt_open,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto__,ms,temp__6753__auto__,_,updated_conn,udt_open,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (state_47292){
var state_val_47293 = (state_47292[(1)]);
if((state_val_47293 === (7))){
var inst_47288 = (state_47292[(2)]);
var state_47292__$1 = state_47292;
var statearr_47294_47555 = state_47292__$1;
(statearr_47294_47555[(2)] = inst_47288);

(statearr_47294_47555[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47293 === (1))){
var inst_47257 = udt_open;
var state_47292__$1 = (function (){var statearr_47295 = state_47292;
(statearr_47295[(7)] = inst_47257);

return statearr_47295;
})();
var statearr_47296_47556 = state_47292__$1;
(statearr_47296_47556[(2)] = null);

(statearr_47296_47556[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47293 === (4))){
var inst_47266 = (state_47292[(8)]);
var inst_47261 = (state_47292[(2)]);
var inst_47262 = cljs.core.deref.call(null,conns_);
var inst_47263 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47264 = [new cljs.core.Keyword(null,"ws","ws",86841443),uid,client_id];
var inst_47265 = (new cljs.core.PersistentVector(null,3,(5),inst_47263,inst_47264,null));
var inst_47266__$1 = cljs.core.get_in.call(null,inst_47262,inst_47265);
var state_47292__$1 = (function (){var statearr_47297 = state_47292;
(statearr_47297[(9)] = inst_47261);

(statearr_47297[(8)] = inst_47266__$1);

return statearr_47297;
})();
if(cljs.core.truth_(inst_47266__$1)){
var statearr_47298_47557 = state_47292__$1;
(statearr_47298_47557[(1)] = (5));

} else {
var statearr_47299_47558 = state_47292__$1;
(statearr_47299_47558[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47293 === (13))){
var inst_47272 = (state_47292[(10)]);
var inst_47281 = (state_47292[(2)]);
var inst_47257 = inst_47272;
var state_47292__$1 = (function (){var statearr_47300 = state_47292;
(statearr_47300[(11)] = inst_47281);

(statearr_47300[(7)] = inst_47257);

return statearr_47300;
})();
var statearr_47301_47559 = state_47292__$1;
(statearr_47301_47559[(2)] = null);

(statearr_47301_47559[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47293 === (6))){
var state_47292__$1 = state_47292;
var statearr_47302_47560 = state_47292__$1;
(statearr_47302_47560[(2)] = null);

(statearr_47302_47560[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47293 === (3))){
var inst_47290 = (state_47292[(2)]);
var state_47292__$1 = state_47292;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47292__$1,inst_47290);
} else {
if((state_val_47293 === (12))){
var state_47292__$1 = state_47292;
var statearr_47303_47561 = state_47292__$1;
(statearr_47303_47561[(2)] = null);

(statearr_47303_47561[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47293 === (2))){
var inst_47259 = cljs.core.async.timeout.call(null,ms);
var state_47292__$1 = state_47292;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47292__$1,(4),inst_47259);
} else {
if((state_val_47293 === (11))){
var inst_47277 = taoensso.sente.pack.call(null,packer__$1,null,new cljs.core.Keyword("chsk","ws-ping","chsk/ws-ping",191675304));
var inst_47278 = taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,websocket_QMARK_,inst_47277);
var state_47292__$1 = state_47292;
var statearr_47304_47562 = state_47292__$1;
(statearr_47304_47562[(2)] = inst_47278);

(statearr_47304_47562[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47293 === (9))){
var state_47292__$1 = state_47292;
var statearr_47305_47563 = state_47292__$1;
(statearr_47305_47563[(2)] = null);

(statearr_47305_47563[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47293 === (5))){
var inst_47266 = (state_47292[(8)]);
var inst_47271 = cljs.core.nth.call(null,inst_47266,(0),null);
var inst_47272 = cljs.core.nth.call(null,inst_47266,(1),null);
var inst_47273 = taoensso.sente.interfaces.sch_open_QMARK_.call(null,server_ch);
var state_47292__$1 = (function (){var statearr_47306 = state_47292;
(statearr_47306[(12)] = inst_47271);

(statearr_47306[(10)] = inst_47272);

return statearr_47306;
})();
if(cljs.core.truth_(inst_47273)){
var statearr_47307_47564 = state_47292__$1;
(statearr_47307_47564[(1)] = (8));

} else {
var statearr_47308_47565 = state_47292__$1;
(statearr_47308_47565[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47293 === (10))){
var inst_47285 = (state_47292[(2)]);
var state_47292__$1 = state_47292;
var statearr_47309_47566 = state_47292__$1;
(statearr_47309_47566[(2)] = inst_47285);

(statearr_47309_47566[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47293 === (8))){
var inst_47272 = (state_47292[(10)]);
var inst_47257 = (state_47292[(7)]);
var inst_47275 = cljs.core._EQ_.call(null,inst_47272,inst_47257);
var state_47292__$1 = state_47292;
if(inst_47275){
var statearr_47310_47567 = state_47292__$1;
(statearr_47310_47567[(1)] = (11));

} else {
var statearr_47311_47568 = state_47292__$1;
(statearr_47311_47568[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto__,ms,temp__6753__auto__,_,updated_conn,udt_open,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
return ((function (switch__42489__auto__,c__42603__auto__,ms,temp__6753__auto__,_,updated_conn,udt_open,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() {
var taoensso$sente$state_machine__42490__auto__ = null;
var taoensso$sente$state_machine__42490__auto____0 = (function (){
var statearr_47315 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47315[(0)] = taoensso$sente$state_machine__42490__auto__);

(statearr_47315[(1)] = (1));

return statearr_47315;
});
var taoensso$sente$state_machine__42490__auto____1 = (function (state_47292){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_47292);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e47316){if((e47316 instanceof Object)){
var ex__42493__auto__ = e47316;
var statearr_47317_47569 = state_47292;
(statearr_47317_47569[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47292);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47316;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47570 = state_47292;
state_47292 = G__47570;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
taoensso$sente$state_machine__42490__auto__ = function(state_47292){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__42490__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__42490__auto____1.call(this,state_47292);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__42490__auto____0;
taoensso$sente$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__42490__auto____1;
return taoensso$sente$state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto__,ms,temp__6753__auto__,_,updated_conn,udt_open,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var state__42605__auto__ = (function (){var statearr_47318 = f__42604__auto__.call(null);
(statearr_47318[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto__);

return statearr_47318;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto__,ms,temp__6753__auto__,_,updated_conn,udt_open,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

return c__42603__auto__;
} else {
return null;
}
} else {
var _ = taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",588,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["New Ajax handshake/poll: %s (%s)",uid,sch_uuid], null);
});})(sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null,514468371);
var updated_conn = upd_conn_BANG_.call(null,new cljs.core.Keyword(null,"ajax","ajax",814345549),uid,client_id,server_ch);
var udt_open = new cljs.core.Keyword(null,"udt","udt",2011712751).cljs$core$IFn$_invoke$arity$1(updated_conn);
var handshake_QMARK_ = (function (){var or__7502__auto__ = new cljs.core.Keyword(null,"init?","init?",438181499).cljs$core$IFn$_invoke$arity$1(updated_conn);
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
return new cljs.core.Keyword(null,"handshake?","handshake?",-423743093).cljs$core$IFn$_invoke$arity$1(params);
}
})();
if(cljs.core.truth_(connect_uid_BANG_.call(null,new cljs.core.Keyword(null,"ajax","ajax",814345549),uid))){
receive_event_msg_BANG_.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","uidport-open","chsk/uidport-open",1685786954),uid], null));
} else {
}

if(cljs.core.truth_(handshake_QMARK_)){
return send_handshake_BANG_.call(null,server_ch,websocket_QMARK_);
} else {
var temp__6753__auto__ = lp_timeout_ms;
if(cljs.core.truth_(temp__6753__auto__)){
var ms = temp__6753__auto__;
var c__42603__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto__,ms,temp__6753__auto__,_,updated_conn,udt_open,handshake_QMARK_,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto__,ms,temp__6753__auto__,_,updated_conn,udt_open,handshake_QMARK_,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (state_47344){
var state_val_47345 = (state_47344[(1)]);
if((state_val_47345 === (1))){
var inst_47319 = cljs.core.async.timeout.call(null,ms);
var state_47344__$1 = state_47344;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47344__$1,(2),inst_47319);
} else {
if((state_val_47345 === (2))){
var inst_47326 = (state_47344[(7)]);
var inst_47321 = (state_47344[(2)]);
var inst_47322 = cljs.core.deref.call(null,conns_);
var inst_47323 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47324 = [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid,client_id];
var inst_47325 = (new cljs.core.PersistentVector(null,3,(5),inst_47323,inst_47324,null));
var inst_47326__$1 = cljs.core.get_in.call(null,inst_47322,inst_47325);
var state_47344__$1 = (function (){var statearr_47346 = state_47344;
(statearr_47346[(7)] = inst_47326__$1);

(statearr_47346[(8)] = inst_47321);

return statearr_47346;
})();
if(cljs.core.truth_(inst_47326__$1)){
var statearr_47347_47571 = state_47344__$1;
(statearr_47347_47571[(1)] = (3));

} else {
var statearr_47348_47572 = state_47344__$1;
(statearr_47348_47572[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47345 === (3))){
var inst_47326 = (state_47344[(7)]);
var inst_47331 = cljs.core.nth.call(null,inst_47326,(0),null);
var inst_47332 = cljs.core.nth.call(null,inst_47326,(1),null);
var inst_47333 = cljs.core._EQ_.call(null,inst_47332,udt_open);
var state_47344__$1 = (function (){var statearr_47349 = state_47344;
(statearr_47349[(9)] = inst_47331);

return statearr_47349;
})();
if(inst_47333){
var statearr_47350_47573 = state_47344__$1;
(statearr_47350_47573[(1)] = (6));

} else {
var statearr_47351_47574 = state_47344__$1;
(statearr_47351_47574[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47345 === (4))){
var state_47344__$1 = state_47344;
var statearr_47352_47575 = state_47344__$1;
(statearr_47352_47575[(2)] = null);

(statearr_47352_47575[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47345 === (5))){
var inst_47342 = (state_47344[(2)]);
var state_47344__$1 = state_47344;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47344__$1,inst_47342);
} else {
if((state_val_47345 === (6))){
var inst_47335 = taoensso.sente.pack.call(null,packer__$1,null,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489));
var inst_47336 = taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,websocket_QMARK_,inst_47335);
var state_47344__$1 = state_47344;
var statearr_47353_47576 = state_47344__$1;
(statearr_47353_47576[(2)] = inst_47336);

(statearr_47353_47576[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47345 === (7))){
var state_47344__$1 = state_47344;
var statearr_47354_47577 = state_47344__$1;
(statearr_47354_47577[(2)] = null);

(statearr_47354_47577[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47345 === (8))){
var inst_47339 = (state_47344[(2)]);
var state_47344__$1 = state_47344;
var statearr_47355_47578 = state_47344__$1;
(statearr_47355_47578[(2)] = inst_47339);

(statearr_47355_47578[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__42603__auto__,ms,temp__6753__auto__,_,updated_conn,udt_open,handshake_QMARK_,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
return ((function (switch__42489__auto__,c__42603__auto__,ms,temp__6753__auto__,_,updated_conn,udt_open,handshake_QMARK_,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() {
var taoensso$sente$state_machine__42490__auto__ = null;
var taoensso$sente$state_machine__42490__auto____0 = (function (){
var statearr_47359 = [null,null,null,null,null,null,null,null,null,null];
(statearr_47359[(0)] = taoensso$sente$state_machine__42490__auto__);

(statearr_47359[(1)] = (1));

return statearr_47359;
});
var taoensso$sente$state_machine__42490__auto____1 = (function (state_47344){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_47344);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e47360){if((e47360 instanceof Object)){
var ex__42493__auto__ = e47360;
var statearr_47361_47579 = state_47344;
(statearr_47361_47579[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47344);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47360;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47580 = state_47344;
state_47344 = G__47580;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
taoensso$sente$state_machine__42490__auto__ = function(state_47344){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__42490__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__42490__auto____1.call(this,state_47344);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__42490__auto____0;
taoensso$sente$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__42490__auto____1;
return taoensso$sente$state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto__,ms,temp__6753__auto__,_,updated_conn,udt_open,handshake_QMARK_,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var state__42605__auto__ = (function (){var statearr_47362 = f__42604__auto__.call(null);
(statearr_47362[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto__);

return statearr_47362;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto__,ms,temp__6753__auto__,_,updated_conn,udt_open,handshake_QMARK_,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

return c__42603__auto__;
} else {
return null;
}
}
}
});})(sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,new cljs.core.Keyword(null,"on-msg","on-msg",-2021925279),((function (sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch,websocket_QMARK_,req_ppstr){
if(cljs.core.truth_(websocket_QMARK_)){
} else {
throw (new Error("Assert failed: websocket?"));
}

upd_conn_BANG_.call(null,new cljs.core.Keyword(null,"ws","ws",86841443),uid,client_id);

var vec__47363 = taoensso.sente.unpack.call(null,packer__$1,req_ppstr);
var clj = cljs.core.nth.call(null,vec__47363,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.call(null,vec__47363,(1),null);
return receive_event_msg_BANG_.call(null,clj,(cljs.core.truth_(_QMARK_cb_uuid)?((function (vec__47363,clj,_QMARK_cb_uuid,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function taoensso$sente$reply_fn(resp_clj){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",618,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__47363,clj,_QMARK_cb_uuid,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send (ws reply): %s",resp_clj], null);
});})(vec__47363,clj,_QMARK_cb_uuid,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null,-407133517);

return taoensso.sente.interfaces.sch_send_BANG_.call(null,server_ch,websocket_QMARK_,taoensso.sente.pack.call(null,packer__$1,cljs.core.meta.call(null,resp_clj),resp_clj,_QMARK_cb_uuid));
});})(vec__47363,clj,_QMARK_cb_uuid,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
:null));
});})(sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,new cljs.core.Keyword(null,"on-close","on-close",-761178394),((function (sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch,websocket_QMARK_,_status){
var conn_type = (cljs.core.truth_(websocket_QMARK_)?new cljs.core.Keyword(null,"ws","ws",86841443):new cljs.core.Keyword(null,"ajax","ajax",814345549));
var _ = taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",627,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (conn_type,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["%s channel closed: %s (%s)",(cljs.core.truth_(websocket_QMARK_)?"WebSocket":"Ajax"),uid,sch_uuid], null);
});})(conn_type,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null,538844437);
var updated_conn = upd_conn_BANG_.call(null,conn_type,uid,client_id,null);
var udt_close = new cljs.core.Keyword(null,"udt","udt",2011712751).cljs$core$IFn$_invoke$arity$1(updated_conn);
var c__42603__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (state_47417){
var state_val_47418 = (state_47417[(1)]);
if((state_val_47418 === (7))){
var state_47417__$1 = state_47417;
var statearr_47419_47581 = state_47417__$1;
(statearr_47419_47581[(2)] = null);

(statearr_47419_47581[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47418 === (1))){
var inst_47366 = cljs.core.async.timeout.call(null,(5000));
var state_47417__$1 = state_47417;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47417__$1,(2),inst_47366);
} else {
if((state_val_47418 === (4))){
var state_47417__$1 = state_47417;
var statearr_47420_47582 = state_47417__$1;
(statearr_47420_47582[(2)] = null);

(statearr_47420_47582[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47418 === (13))){
var state_47417__$1 = state_47417;
var statearr_47421_47583 = state_47417__$1;
(statearr_47421_47583[(2)] = null);

(statearr_47421_47583[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47418 === (6))){
var inst_47394 = (state_47417[(7)]);
var inst_47377 = (state_47417[(8)]);
var inst_47378 = (state_47417[(9)]);
var inst_47376 = (state_47417[(10)]);
var inst_47389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47390 = [conn_type,uid,client_id];
var inst_47391 = (new cljs.core.PersistentVector(null,3,(5),inst_47389,inst_47390,null));
var inst_47393 = (function (){var vec__47369 = inst_47376;
var __QMARK_sch = inst_47377;
var udt_t1 = inst_47378;
return ((function (vec__47369,__QMARK_sch,udt_t1,inst_47394,inst_47377,inst_47378,inst_47376,inst_47389,inst_47390,inst_47391,state_val_47418,c__42603__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (p__47392){
var vec__47422 = p__47392;
var _sch = cljs.core.nth.call(null,vec__47422,(0),null);
var udt_t1__$1 = cljs.core.nth.call(null,vec__47422,(1),null);
if(cljs.core._EQ_.call(null,udt_t1__$1,udt_close)){
return taoensso.encore.swapped.call(null,new cljs.core.Keyword("swap","dissoc","swap/dissoc",-605373782),true);
} else {
return taoensso.encore.swapped.call(null,udt_t1__$1,false);
}
});
;})(vec__47369,__QMARK_sch,udt_t1,inst_47394,inst_47377,inst_47378,inst_47376,inst_47389,inst_47390,inst_47391,state_val_47418,c__42603__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var inst_47394__$1 = taoensso.encore.swap_in_BANG_.call(null,conns_,inst_47391,inst_47393);
var state_47417__$1 = (function (){var statearr_47425 = state_47417;
(statearr_47425[(7)] = inst_47394__$1);

return statearr_47425;
})();
if(cljs.core.truth_(inst_47394__$1)){
var statearr_47426_47584 = state_47417__$1;
(statearr_47426_47584[(1)] = (9));

} else {
var statearr_47427_47585 = state_47417__$1;
(statearr_47427_47585[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47418 === (3))){
var inst_47377 = (state_47417[(8)]);
var inst_47378 = (state_47417[(9)]);
var inst_47376 = (state_47417[(10)]);
var inst_47381 = (function (){var vec__47369 = inst_47376;
var __QMARK_sch = inst_47377;
var udt_t1 = inst_47378;
return ((function (vec__47369,__QMARK_sch,udt_t1,inst_47377,inst_47378,inst_47376,state_val_47418,c__42603__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, ["close-timeout: %s %s %s %s",conn_type,uid,sch_uuid,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._EQ_.call(null,udt_t1,udt_close),udt_t1,udt_close], null)], null);
});
;})(vec__47369,__QMARK_sch,udt_t1,inst_47377,inst_47378,inst_47376,state_val_47418,c__42603__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var inst_47382 = (new cljs.core.Delay(inst_47381,null));
var inst_47383 = taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",641,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_47382,null,-1730787694);
var state_47417__$1 = state_47417;
var statearr_47428_47586 = state_47417__$1;
(statearr_47428_47586[(2)] = inst_47383);

(statearr_47428_47586[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47418 === (12))){
var inst_47403 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47404 = [new cljs.core.Keyword("chsk","uidport-close","chsk/uidport-close",901058678),uid];
var inst_47405 = (new cljs.core.PersistentVector(null,2,(5),inst_47403,inst_47404,null));
var inst_47406 = receive_event_msg_BANG_.call(null,inst_47405);
var state_47417__$1 = state_47417;
var statearr_47429_47587 = state_47417__$1;
(statearr_47429_47587[(2)] = inst_47406);

(statearr_47429_47587[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47418 === (2))){
var inst_47376 = (state_47417[(10)]);
var inst_47368 = (state_47417[(2)]);
var inst_47372 = cljs.core.deref.call(null,conns_);
var inst_47373 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47374 = [conn_type,uid,client_id];
var inst_47375 = (new cljs.core.PersistentVector(null,3,(5),inst_47373,inst_47374,null));
var inst_47376__$1 = cljs.core.get_in.call(null,inst_47372,inst_47375);
var inst_47377 = cljs.core.nth.call(null,inst_47376__$1,(0),null);
var inst_47378 = cljs.core.nth.call(null,inst_47376__$1,(1),null);
var inst_47379 = cljs.core.deref.call(null,taoensso.sente.debug_mode_QMARK__);
var state_47417__$1 = (function (){var statearr_47430 = state_47417;
(statearr_47430[(11)] = inst_47368);

(statearr_47430[(8)] = inst_47377);

(statearr_47430[(9)] = inst_47378);

(statearr_47430[(10)] = inst_47376__$1);

return statearr_47430;
})();
if(cljs.core.truth_(inst_47379)){
var statearr_47431_47588 = state_47417__$1;
(statearr_47431_47588[(1)] = (3));

} else {
var statearr_47432_47589 = state_47417__$1;
(statearr_47432_47589[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47418 === (11))){
var inst_47412 = (state_47417[(2)]);
var state_47417__$1 = state_47417;
var statearr_47433_47590 = state_47417__$1;
(statearr_47433_47590[(2)] = inst_47412);

(statearr_47433_47590[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47418 === (9))){
var inst_47394 = (state_47417[(7)]);
var inst_47377 = (state_47417[(8)]);
var inst_47378 = (state_47417[(9)]);
var inst_47376 = (state_47417[(10)]);
var inst_47396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47397 = [conn_type,uid];
var inst_47398 = (new cljs.core.PersistentVector(null,2,(5),inst_47396,inst_47397,null));
var inst_47399 = (function (){var vec__47369 = inst_47376;
var __QMARK_sch = inst_47377;
var udt_t1 = inst_47378;
var disconnect_QMARK_ = inst_47394;
return ((function (vec__47369,__QMARK_sch,udt_t1,disconnect_QMARK_,inst_47394,inst_47377,inst_47378,inst_47376,inst_47396,inst_47397,inst_47398,state_val_47418,c__42603__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (_QMARK_m){
if(cljs.core.empty_QMARK_.call(null,_QMARK_m)){
return new cljs.core.Keyword("swap","dissoc","swap/dissoc",-605373782);
} else {
return _QMARK_m;
}
});
;})(vec__47369,__QMARK_sch,udt_t1,disconnect_QMARK_,inst_47394,inst_47377,inst_47378,inst_47376,inst_47396,inst_47397,inst_47398,state_val_47418,c__42603__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var inst_47400 = taoensso.encore.swap_in_BANG_.call(null,conns_,inst_47398,inst_47399);
var inst_47401 = upd_connected_uid_BANG_.call(null,uid);
var state_47417__$1 = (function (){var statearr_47434 = state_47417;
(statearr_47434[(12)] = inst_47400);

return statearr_47434;
})();
if(cljs.core.truth_(inst_47401)){
var statearr_47435_47591 = state_47417__$1;
(statearr_47435_47591[(1)] = (12));

} else {
var statearr_47436_47592 = state_47417__$1;
(statearr_47436_47592[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47418 === (5))){
var inst_47378 = (state_47417[(9)]);
var inst_47386 = (state_47417[(2)]);
var inst_47387 = cljs.core._EQ_.call(null,inst_47378,udt_close);
var state_47417__$1 = (function (){var statearr_47437 = state_47417;
(statearr_47437[(13)] = inst_47386);

return statearr_47437;
})();
if(inst_47387){
var statearr_47438_47593 = state_47417__$1;
(statearr_47438_47593[(1)] = (6));

} else {
var statearr_47439_47594 = state_47417__$1;
(statearr_47439_47594[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47418 === (14))){
var inst_47409 = (state_47417[(2)]);
var state_47417__$1 = state_47417;
var statearr_47440_47595 = state_47417__$1;
(statearr_47440_47595[(2)] = inst_47409);

(statearr_47440_47595[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47418 === (10))){
var state_47417__$1 = state_47417;
var statearr_47441_47596 = state_47417__$1;
(statearr_47441_47596[(2)] = null);

(statearr_47441_47596[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47418 === (8))){
var inst_47415 = (state_47417[(2)]);
var state_47417__$1 = state_47417;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47417__$1,inst_47415);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
;
return ((function (switch__42489__auto__,c__42603__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function() {
var taoensso$sente$state_machine__42490__auto__ = null;
var taoensso$sente$state_machine__42490__auto____0 = (function (){
var statearr_47445 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47445[(0)] = taoensso$sente$state_machine__42490__auto__);

(statearr_47445[(1)] = (1));

return statearr_47445;
});
var taoensso$sente$state_machine__42490__auto____1 = (function (state_47417){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_47417);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e47446){if((e47446 instanceof Object)){
var ex__42493__auto__ = e47446;
var statearr_47447_47597 = state_47417;
(statearr_47447_47597[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47417);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47446;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47598 = state_47417;
state_47417 = G__47598;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
taoensso$sente$state_machine__42490__auto__ = function(state_47417){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__42490__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__42490__auto____1.call(this,state_47417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__42490__auto____0;
taoensso$sente$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__42490__auto____1;
return taoensso$sente$state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
})();
var state__42605__auto__ = (function (){var statearr_47448 = f__42604__auto__.call(null);
(statearr_47448[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto__);

return statearr_47448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto__,conn_type,_,updated_conn,udt_close,sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
);

return c__42603__auto__;
});})(sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,new cljs.core.Keyword(null,"on-error","on-error",1728533530),((function (sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (server_ch,websocket_QMARK_,error){
return taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",663,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer){
return (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ring-req->server-ch-resp error: %s (%s)",error,uid,sch_uuid], null);
});})(sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
,null)),null,323472440);
});})(sch_uuid,params,client_id,csrf_token,uid,receive_event_msg_BANG_,send_handshake_BANG_,packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
], null));
}
});})(packer__$1,ch_recv,user_id_fn__$1,conns_,send_buffers_,connected_uids_,upd_conn_BANG_,connect_uid_BANG_,upd_connected_uid_BANG_,send_fn,ev_msg_const,vec__47147,map__47150,map__47150__$1,recv_buf_or_n,ws_kalive_ms,lp_timeout_ms,send_buf_ms_ajax,send_buf_ms_ws,user_id_fn,csrf_token_fn,handshake_data_fn,packer))
], null);
});

taoensso.sente.make_channel_socket_server_BANG_.cljs$lang$maxFixedArity = (1);

taoensso.sente.make_channel_socket_server_BANG_.cljs$lang$applyTo = (function (seq47144){
var G__47145 = cljs.core.first.call(null,seq47144);
var seq47144__$1 = cljs.core.next.call(null,seq47144);
return taoensso.sente.make_channel_socket_server_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__47145,seq47144__$1);
});

/**
 * Actually pushes buffered events (as packed-str) to all uid's WebSocket conns.
 */
taoensso.sente.send_buffered_server_evs_GT_ws_clients_BANG_ = (function taoensso$sente$send_buffered_server_evs_GT_ws_clients_BANG_(conns_,uid,buffered_evs_pstr,upd_conn_BANG_){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",669,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["send-buffered-server-evs>ws-clients!: %s",buffered_evs_pstr], null);
}),null)),null,72365745);

var seq__47615 = cljs.core.seq.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,conns_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws","ws",86841443),uid], null)));
var chunk__47616 = null;
var count__47617 = (0);
var i__47618 = (0);
while(true){
if((i__47618 < count__47617)){
var vec__47619 = cljs.core._nth.call(null,chunk__47616,i__47618);
var client_id = cljs.core.nth.call(null,vec__47619,(0),null);
var vec__47622 = cljs.core.nth.call(null,vec__47619,(1),null);
var _QMARK_sch = cljs.core.nth.call(null,vec__47622,(0),null);
var _udt = cljs.core.nth.call(null,vec__47622,(1),null);
var temp__6753__auto___47631 = _QMARK_sch;
if(cljs.core.truth_(temp__6753__auto___47631)){
var sch_47632 = temp__6753__auto___47631;
upd_conn_BANG_.call(null,new cljs.core.Keyword(null,"ws","ws",86841443),uid,client_id);

taoensso.sente.interfaces.sch_send_BANG_.call(null,sch_47632,new cljs.core.Keyword(null,"websocket","websocket",-1714963101),buffered_evs_pstr);
} else {
}

var G__47633 = seq__47615;
var G__47634 = chunk__47616;
var G__47635 = count__47617;
var G__47636 = (i__47618 + (1));
seq__47615 = G__47633;
chunk__47616 = G__47634;
count__47617 = G__47635;
i__47618 = G__47636;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__47615);
if(temp__6753__auto__){
var seq__47615__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47615__$1)){
var c__8413__auto__ = cljs.core.chunk_first.call(null,seq__47615__$1);
var G__47637 = cljs.core.chunk_rest.call(null,seq__47615__$1);
var G__47638 = c__8413__auto__;
var G__47639 = cljs.core.count.call(null,c__8413__auto__);
var G__47640 = (0);
seq__47615 = G__47637;
chunk__47616 = G__47638;
count__47617 = G__47639;
i__47618 = G__47640;
continue;
} else {
var vec__47625 = cljs.core.first.call(null,seq__47615__$1);
var client_id = cljs.core.nth.call(null,vec__47625,(0),null);
var vec__47628 = cljs.core.nth.call(null,vec__47625,(1),null);
var _QMARK_sch = cljs.core.nth.call(null,vec__47628,(0),null);
var _udt = cljs.core.nth.call(null,vec__47628,(1),null);
var temp__6753__auto___47641__$1 = _QMARK_sch;
if(cljs.core.truth_(temp__6753__auto___47641__$1)){
var sch_47642 = temp__6753__auto___47641__$1;
upd_conn_BANG_.call(null,new cljs.core.Keyword(null,"ws","ws",86841443),uid,client_id);

taoensso.sente.interfaces.sch_send_BANG_.call(null,sch_47642,new cljs.core.Keyword(null,"websocket","websocket",-1714963101),buffered_evs_pstr);
} else {
}

var G__47643 = cljs.core.next.call(null,seq__47615__$1);
var G__47644 = null;
var G__47645 = (0);
var G__47646 = (0);
seq__47615 = G__47643;
chunk__47616 = G__47644;
count__47617 = G__47645;
i__47618 = G__47646;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Actually pushes buffered events (as packed-str) to all uid's Ajax conns.
 *   Allows some time for possible Ajax poller reconnects.
 */
taoensso.sente.send_buffered_server_evs_GT_ajax_clients_BANG_ = (function taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG_(conns_,uid,buffered_evs_pstr){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",679,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["send-buffered-server-evs>ajax-clients!: %s",buffered_evs_pstr], null);
}),null)),null,-954810602);

var nmax_attempts = (7);
var ms_base = (90);
var ms_rand = (90);
var client_ids_unsatisfied = cljs.core.keys.call(null,cljs.core.get_in.call(null,cljs.core.deref.call(null,conns_),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid], null)));
if(cljs.core.empty_QMARK_.call(null,client_ids_unsatisfied)){
return null;
} else {
var c__42603__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto__,nmax_attempts,ms_base,ms_rand,client_ids_unsatisfied){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto__,nmax_attempts,ms_base,ms_rand,client_ids_unsatisfied){
return (function (state_47777){
var state_val_47778 = (state_47777[(1)]);
if((state_val_47778 === (7))){
var inst_47732 = (state_47777[(7)]);
var inst_47733 = (state_47777[(8)]);
var inst_47739 = (state_47777[(9)]);
var inst_47749 = (function (){var n = inst_47732;
var client_ids_satisfied = inst_47733;
var _QMARK_pulled = inst_47739;
return ((function (n,client_ids_satisfied,_QMARK_pulled,inst_47732,inst_47733,inst_47739,state_val_47778,c__42603__auto__,nmax_attempts,ms_base,ms_rand,client_ids_unsatisfied){
return (function (s,client_id,p__47748){
var vec__47779 = p__47748;
var _QMARK_sch = cljs.core.nth.call(null,vec__47779,(0),null);
var _udt = cljs.core.nth.call(null,vec__47779,(1),null);
var sent_QMARK_ = (function (){var temp__6753__auto__ = _QMARK_sch;
if(cljs.core.truth_(temp__6753__auto__)){
var sch = temp__6753__auto__;
return taoensso.sente.interfaces.sch_send_BANG_.call(null,_QMARK_sch,cljs.core.not.call(null,new cljs.core.Keyword(null,"websocket","websocket",-1714963101)),buffered_evs_pstr);
} else {
return null;
}
})();
if(cljs.core.truth_(sent_QMARK_)){
return cljs.core.conj.call(null,s,client_id);
} else {
return s;
}
});
;})(n,client_ids_satisfied,_QMARK_pulled,inst_47732,inst_47733,inst_47739,state_val_47778,c__42603__auto__,nmax_attempts,ms_base,ms_rand,client_ids_unsatisfied))
})();
var inst_47750 = cljs.core.PersistentHashSet.EMPTY;
var inst_47751 = cljs.core.reduce_kv.call(null,inst_47749,inst_47750,inst_47739);
var state_47777__$1 = state_47777;
var statearr_47782_47815 = state_47777__$1;
(statearr_47782_47815[(2)] = inst_47751);

(statearr_47782_47815[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47778 === (1))){
var inst_47731 = cljs.core.PersistentHashSet.EMPTY;
var inst_47732 = (0);
var inst_47733 = inst_47731;
var state_47777__$1 = (function (){var statearr_47783 = state_47777;
(statearr_47783[(7)] = inst_47732);

(statearr_47783[(8)] = inst_47733);

return statearr_47783;
})();
var statearr_47784_47816 = state_47777__$1;
(statearr_47784_47816[(2)] = null);

(statearr_47784_47816[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47778 === (4))){
var state_47777__$1 = state_47777;
var statearr_47785_47817 = state_47777__$1;
(statearr_47785_47817[(2)] = true);

(statearr_47785_47817[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47778 === (15))){
var inst_47773 = (state_47777[(2)]);
var state_47777__$1 = state_47777;
var statearr_47786_47818 = state_47777__$1;
(statearr_47786_47818[(2)] = inst_47773);

(statearr_47786_47818[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47778 === (13))){
var inst_47764 = cljs.core.rand_int.call(null,ms_rand);
var inst_47765 = (ms_base + inst_47764);
var inst_47766 = cljs.core.async.timeout.call(null,inst_47765);
var state_47777__$1 = state_47777;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47777__$1,(16),inst_47766);
} else {
if((state_val_47778 === (6))){
var inst_47739 = (state_47777[(9)]);
var inst_47746 = (state_47777[(2)]);
var state_47777__$1 = (function (){var statearr_47787 = state_47777;
(statearr_47787[(10)] = inst_47746);

return statearr_47787;
})();
if(cljs.core.truth_(inst_47739)){
var statearr_47788_47819 = state_47777__$1;
(statearr_47788_47819[(1)] = (7));

} else {
var statearr_47789_47820 = state_47777__$1;
(statearr_47789_47820[(1)] = (8));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47778 === (3))){
var inst_47775 = (state_47777[(2)]);
var state_47777__$1 = state_47777;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47777__$1,inst_47775);
} else {
if((state_val_47778 === (12))){
var inst_47762 = (state_47777[(2)]);
var state_47777__$1 = state_47777;
if(cljs.core.truth_(inst_47762)){
var statearr_47790_47821 = state_47777__$1;
(statearr_47790_47821[(1)] = (13));

} else {
var statearr_47791_47822 = state_47777__$1;
(statearr_47791_47822[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47778 === (2))){
var inst_47732 = (state_47777[(7)]);
var inst_47733 = (state_47777[(8)]);
var inst_47739 = (state_47777[(9)]);
var inst_47735 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_47736 = [new cljs.core.Keyword(null,"ajax","ajax",814345549),uid];
var inst_47737 = (new cljs.core.PersistentVector(null,2,(5),inst_47735,inst_47736,null));
var inst_47738 = (function (){var n = inst_47732;
var client_ids_satisfied = inst_47733;
return ((function (n,client_ids_satisfied,inst_47732,inst_47733,inst_47739,inst_47735,inst_47736,inst_47737,state_val_47778,c__42603__auto__,nmax_attempts,ms_base,ms_rand,client_ids_unsatisfied){
return (function (m){
var ks_to_pull = cljs.core.remove.call(null,client_ids_satisfied,cljs.core.keys.call(null,m));
if(cljs.core.empty_QMARK_.call(null,ks_to_pull)){
return taoensso.encore.swapped.call(null,m,null);
} else {
return taoensso.encore.swapped.call(null,cljs.core.reduce.call(null,((function (ks_to_pull,n,client_ids_satisfied,inst_47732,inst_47733,inst_47739,inst_47735,inst_47736,inst_47737,state_val_47778,c__42603__auto__,nmax_attempts,ms_base,ms_rand,client_ids_unsatisfied){
return (function (m__$1,k){
var vec__47792 = cljs.core.get.call(null,m__$1,k);
var _QMARK_sch = cljs.core.nth.call(null,vec__47792,(0),null);
var udt = cljs.core.nth.call(null,vec__47792,(1),null);
return cljs.core.assoc.call(null,m__$1,k,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,udt], null));
});})(ks_to_pull,n,client_ids_satisfied,inst_47732,inst_47733,inst_47739,inst_47735,inst_47736,inst_47737,state_val_47778,c__42603__auto__,nmax_attempts,ms_base,ms_rand,client_ids_unsatisfied))
,m,ks_to_pull),cljs.core.select_keys.call(null,m,ks_to_pull));
}
});
;})(n,client_ids_satisfied,inst_47732,inst_47733,inst_47739,inst_47735,inst_47736,inst_47737,state_val_47778,c__42603__auto__,nmax_attempts,ms_base,ms_rand,client_ids_unsatisfied))
})();
var inst_47739__$1 = taoensso.encore.swap_in_BANG_.call(null,conns_,inst_47737,inst_47738);
var inst_47740 = (function (){var n = inst_47732;
var client_ids_satisfied = inst_47733;
var _QMARK_pulled = inst_47739__$1;
return ((function (n,client_ids_satisfied,_QMARK_pulled,inst_47732,inst_47733,inst_47739,inst_47735,inst_47736,inst_47737,inst_47738,inst_47739__$1,state_val_47778,c__42603__auto__,nmax_attempts,ms_base,ms_rand,client_ids_unsatisfied){
return (function (x){
var or__7502__auto__ = (x == null);
if(or__7502__auto__){
return or__7502__auto__;
} else {
return taoensso.truss.impl.non_throwing.call(null,cljs.core.map_QMARK_).call(null,x);
}
});
;})(n,client_ids_satisfied,_QMARK_pulled,inst_47732,inst_47733,inst_47739,inst_47735,inst_47736,inst_47737,inst_47738,inst_47739__$1,state_val_47778,c__42603__auto__,nmax_attempts,ms_base,ms_rand,client_ids_unsatisfied))
})();
var inst_47741 = inst_47740.call(null,inst_47739__$1);
var state_47777__$1 = (function (){var statearr_47795 = state_47777;
(statearr_47795[(9)] = inst_47739__$1);

return statearr_47795;
})();
if(cljs.core.truth_(inst_47741)){
var statearr_47796_47823 = state_47777__$1;
(statearr_47796_47823[(1)] = (4));

} else {
var statearr_47797_47824 = state_47777__$1;
(statearr_47797_47824[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47778 === (11))){
var inst_47756 = (state_47777[(11)]);
var state_47777__$1 = state_47777;
var statearr_47798_47825 = state_47777__$1;
(statearr_47798_47825[(2)] = inst_47756);

(statearr_47798_47825[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47778 === (9))){
var inst_47756 = (state_47777[(11)]);
var inst_47732 = (state_47777[(7)]);
var inst_47733 = (state_47777[(8)]);
var inst_47754 = (state_47777[(2)]);
var inst_47755 = cljs.core.into.call(null,inst_47733,inst_47754);
var inst_47756__$1 = (inst_47732 < nmax_attempts);
var state_47777__$1 = (function (){var statearr_47799 = state_47777;
(statearr_47799[(11)] = inst_47756__$1);

(statearr_47799[(12)] = inst_47755);

return statearr_47799;
})();
if(cljs.core.truth_(inst_47756__$1)){
var statearr_47800_47826 = state_47777__$1;
(statearr_47800_47826[(1)] = (10));

} else {
var statearr_47801_47827 = state_47777__$1;
(statearr_47801_47827[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47778 === (5))){
var inst_47739 = (state_47777[(9)]);
var inst_47744 = taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",710,"([:or nil? map?] ?pulled)",inst_47739,null,null);
var state_47777__$1 = state_47777;
var statearr_47802_47828 = state_47777__$1;
(statearr_47802_47828[(2)] = inst_47744);

(statearr_47802_47828[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47778 === (14))){
var state_47777__$1 = state_47777;
var statearr_47803_47829 = state_47777__$1;
(statearr_47803_47829[(2)] = null);

(statearr_47803_47829[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47778 === (16))){
var inst_47732 = (state_47777[(7)]);
var inst_47755 = (state_47777[(12)]);
var inst_47768 = (state_47777[(2)]);
var inst_47769 = (inst_47732 + (1));
var inst_47732__$1 = inst_47769;
var inst_47733 = inst_47755;
var state_47777__$1 = (function (){var statearr_47804 = state_47777;
(statearr_47804[(7)] = inst_47732__$1);

(statearr_47804[(13)] = inst_47768);

(statearr_47804[(8)] = inst_47733);

return statearr_47804;
})();
var statearr_47805_47830 = state_47777__$1;
(statearr_47805_47830[(2)] = null);

(statearr_47805_47830[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47778 === (10))){
var inst_47755 = (state_47777[(12)]);
var inst_47758 = cljs.core.complement.call(null,inst_47755);
var inst_47759 = cljs.core.some.call(null,inst_47758,client_ids_unsatisfied);
var state_47777__$1 = state_47777;
var statearr_47806_47831 = state_47777__$1;
(statearr_47806_47831[(2)] = inst_47759);

(statearr_47806_47831[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47778 === (8))){
var state_47777__$1 = state_47777;
var statearr_47807_47832 = state_47777__$1;
(statearr_47807_47832[(2)] = null);

(statearr_47807_47832[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto__,nmax_attempts,ms_base,ms_rand,client_ids_unsatisfied))
;
return ((function (switch__42489__auto__,c__42603__auto__,nmax_attempts,ms_base,ms_rand,client_ids_unsatisfied){
return (function() {
var taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__42490__auto__ = null;
var taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__42490__auto____0 = (function (){
var statearr_47811 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_47811[(0)] = taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__42490__auto__);

(statearr_47811[(1)] = (1));

return statearr_47811;
});
var taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__42490__auto____1 = (function (state_47777){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_47777);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e47812){if((e47812 instanceof Object)){
var ex__42493__auto__ = e47812;
var statearr_47813_47833 = state_47777;
(statearr_47813_47833[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47777);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47812;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47834 = state_47777;
state_47777 = G__47834;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__42490__auto__ = function(state_47777){
switch(arguments.length){
case 0:
return taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__42490__auto____0.call(this);
case 1:
return taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__42490__auto____1.call(this,state_47777);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__42490__auto____0;
taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__42490__auto____1;
return taoensso$sente$send_buffered_server_evs_GT_ajax_clients_BANG__$_state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto__,nmax_attempts,ms_base,ms_rand,client_ids_unsatisfied))
})();
var state__42605__auto__ = (function (){var statearr_47814 = f__42604__auto__.call(null);
(statearr_47814[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto__);

return statearr_47814;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto__,nmax_attempts,ms_base,ms_rand,client_ids_unsatisfied))
);

return c__42603__auto__;
}
});
/**
 * Alias of `taoensso.encore/ajax-lite`
 */
taoensso.sente.ajax_lite = taoensso.encore.ajax_lite;

/**
 * @interface
 */
taoensso.sente.IChSocket = function(){};

taoensso.sente._chsk_connect_BANG_ = (function taoensso$sente$_chsk_connect_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1(chsk);
} else {
var x__8220__auto__ = (((chsk == null))?null:chsk);
var m__8221__auto__ = (taoensso.sente._chsk_connect_BANG_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,chsk);
} else {
var m__8221__auto____$1 = (taoensso.sente._chsk_connect_BANG_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,chsk);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.-chsk-connect!",chsk);
}
}
}
});

taoensso.sente._chsk_disconnect_BANG_ = (function taoensso$sente$_chsk_disconnect_BANG_(chsk,reconn_QMARK_){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$_chsk_disconnect_BANG_$arity$2 == null)))){
return chsk.taoensso$sente$IChSocket$_chsk_disconnect_BANG_$arity$2(chsk,reconn_QMARK_);
} else {
var x__8220__auto__ = (((chsk == null))?null:chsk);
var m__8221__auto__ = (taoensso.sente._chsk_disconnect_BANG_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,chsk,reconn_QMARK_);
} else {
var m__8221__auto____$1 = (taoensso.sente._chsk_disconnect_BANG_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,chsk,reconn_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.-chsk-disconnect!",chsk);
}
}
}
});

taoensso.sente._chsk_reconnect_BANG_ = (function taoensso$sente$_chsk_reconnect_BANG_(chsk){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$_chsk_reconnect_BANG_$arity$1 == null)))){
return chsk.taoensso$sente$IChSocket$_chsk_reconnect_BANG_$arity$1(chsk);
} else {
var x__8220__auto__ = (((chsk == null))?null:chsk);
var m__8221__auto__ = (taoensso.sente._chsk_reconnect_BANG_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,chsk);
} else {
var m__8221__auto____$1 = (taoensso.sente._chsk_reconnect_BANG_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,chsk);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.-chsk-reconnect!",chsk);
}
}
}
});

taoensso.sente._chsk_send_BANG_ = (function taoensso$sente$_chsk_send_BANG_(chsk,ev,opts){
if((!((chsk == null))) && (!((chsk.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3 == null)))){
return chsk.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3(chsk,ev,opts);
} else {
var x__8220__auto__ = (((chsk == null))?null:chsk);
var m__8221__auto__ = (taoensso.sente._chsk_send_BANG_[goog.typeOf(x__8220__auto__)]);
if(!((m__8221__auto__ == null))){
return m__8221__auto__.call(null,chsk,ev,opts);
} else {
var m__8221__auto____$1 = (taoensso.sente._chsk_send_BANG_["_"]);
if(!((m__8221__auto____$1 == null))){
return m__8221__auto____$1.call(null,chsk,ev,opts);
} else {
throw cljs.core.missing_protocol.call(null,"IChSocket.-chsk-send!",chsk);
}
}
}
});

taoensso.sente.chsk_connect_BANG_ = (function taoensso$sente$chsk_connect_BANG_(chsk){
return taoensso.sente._chsk_connect_BANG_.call(null,chsk);
});

/**
 * Deprecated
 */
taoensso.sente.chsk_destroy_BANG_ = (function taoensso$sente$chsk_destroy_BANG_(chsk){
return taoensso.sente._chsk_disconnect_BANG_.call(null,chsk,false);
});

taoensso.sente.chsk_disconnect_BANG_ = (function taoensso$sente$chsk_disconnect_BANG_(chsk){
return taoensso.sente._chsk_disconnect_BANG_.call(null,chsk,false);
});

/**
 * Useful for reauthenticating after login/logout, etc.
 */
taoensso.sente.chsk_reconnect_BANG_ = (function taoensso$sente$chsk_reconnect_BANG_(chsk){
return taoensso.sente._chsk_reconnect_BANG_.call(null,chsk);
});
/**
 * Sends `[ev-id ev-?data :as event]`, returns true on apparent success.
 */
taoensso.sente.chsk_send_BANG_ = (function taoensso$sente$chsk_send_BANG_(var_args){
var args47835 = [];
var len__8723__auto___47838 = arguments.length;
var i__8724__auto___47839 = (0);
while(true){
if((i__8724__auto___47839 < len__8723__auto___47838)){
args47835.push((arguments[i__8724__auto___47839]));

var G__47840 = (i__8724__auto___47839 + (1));
i__8724__auto___47839 = G__47840;
continue;
} else {
}
break;
}

var G__47837 = args47835.length;
switch (G__47837) {
case 2:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 3:
return taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args47835.length)].join('')));

}
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (chsk,ev){
return taoensso.sente.chsk_send_BANG_.call(null,chsk,ev,cljs.core.PersistentArrayMap.EMPTY);
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (chsk,ev,_QMARK_timeout_ms,_QMARK_cb){
return taoensso.sente.chsk_send_BANG_.call(null,chsk,ev,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),_QMARK_timeout_ms,new cljs.core.Keyword(null,"cb","cb",589947841),_QMARK_cb], null));
});

taoensso.sente.chsk_send_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (chsk,ev,opts){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",759,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send: (%s) %s",cljs.core.assoc.call(null,opts,new cljs.core.Keyword(null,"cb","cb",589947841),cljs.core.boolean$.call(null,new cljs.core.Keyword(null,"cb","cb",589947841).cljs$core$IFn$_invoke$arity$1(opts))),ev], null);
}),null)),null,1807904868);

return taoensso.sente._chsk_send_BANG_.call(null,chsk,ev,opts);
});

taoensso.sente.chsk_send_BANG_.cljs$lang$maxFixedArity = 4;

taoensso.sente.chsk_send__GT_closed_BANG_ = (function taoensso$sente$chsk_send__GT_closed_BANG_(_QMARK_cb_fn){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",764,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk send against closed chsk."], null);
}),null)),null,-1214821764);

if(cljs.core.truth_(_QMARK_cb_fn)){
_QMARK_cb_fn.call(null,new cljs.core.Keyword("chsk","closed","chsk/closed",-922855264));
} else {
}

return false;
});
taoensso.sente.assert_send_args = (function taoensso$sente$assert_send_args(x,_QMARK_timeout_ms,_QMARK_cb){
taoensso.sente.assert_event.call(null,x);

if((((_QMARK_timeout_ms == null)) && ((_QMARK_cb == null))) || (taoensso.encore.nat_int_QMARK_.call(null,_QMARK_timeout_ms))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("cb requires a timeout; timeout-ms should be a +ive integer: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(_QMARK_timeout_ms)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(or (and (nil? ?timeout-ms) (nil? ?cb)) (and (enc/nat-int? ?timeout-ms)))")].join('')));
}

if(((_QMARK_cb == null)) || (cljs.core.ifn_QMARK_.call(null,_QMARK_cb)) || (taoensso.encore.chan_QMARK_.call(null,_QMARK_cb))){
return null;
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("cb should be nil, an ifn, or a channel: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type.call(null,_QMARK_cb))].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(or (nil? ?cb) (ifn? ?cb) (enc/chan? ?cb))")].join('')));
}
});
taoensso.sente.pull_unused_cb_fn_BANG_ = (function taoensso$sente$pull_unused_cb_fn_BANG_(cbs_waiting_,_QMARK_cb_uuid){
var temp__6753__auto__ = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__6753__auto__)){
var cb_uuid = temp__6753__auto__;
return taoensso.encore.swap_in_BANG_.call(null,cbs_waiting_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cb_uuid], null),((function (cb_uuid,temp__6753__auto__){
return (function (_QMARK_f){
return taoensso.encore.swapped.call(null,new cljs.core.Keyword("swap","dissoc","swap/dissoc",-605373782),_QMARK_f);
});})(cb_uuid,temp__6753__auto__))
);
} else {
return null;
}
});
taoensso.sente.merge_GT_chsk_state_BANG_ = (function taoensso$sente$merge_GT_chsk_state_BANG_(p__47842,merge_state){
var map__47848 = p__47842;
var map__47848__$1 = ((((!((map__47848 == null)))?((((map__47848.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47848.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47848):map__47848);
var chsk = map__47848__$1;
var chs = cljs.core.get.call(null,map__47848__$1,new cljs.core.Keyword(null,"chs","chs",376886120));
var state_ = cljs.core.get.call(null,map__47848__$1,new cljs.core.Keyword(null,"state_","state_",957667102));
var vec__47850 = taoensso.encore.swap_in_BANG_.call(null,state_,cljs.core.PersistentVector.EMPTY,((function (map__47848,map__47848__$1,chsk,chs,state_){
return (function (old_state){
var new_state = cljs.core.merge.call(null,old_state,merge_state);
var requested_reconnect_QMARK_ = (function (){var and__7490__auto__ = new cljs.core.Keyword(null,"requested-reconnect-pending?","requested-reconnect-pending?",-299841116).cljs$core$IFn$_invoke$arity$1(old_state);
if(cljs.core.truth_(and__7490__auto__)){
var and__7490__auto____$1 = new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(new_state);
if(cljs.core.truth_(and__7490__auto____$1)){
return cljs.core.not.call(null,new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(old_state));
} else {
return and__7490__auto____$1;
}
} else {
return and__7490__auto__;
}
})();
var new_state__$1 = (cljs.core.truth_(new cljs.core.Keyword(null,"first-open?","first-open?",396686530).cljs$core$IFn$_invoke$arity$1(old_state))?cljs.core.assoc.call(null,new_state,new cljs.core.Keyword(null,"first-open?","first-open?",396686530),false):new_state);
var new_state__$2 = (cljs.core.truth_(requested_reconnect_QMARK_)?cljs.core.assoc.call(null,cljs.core.dissoc.call(null,new_state__$1,new cljs.core.Keyword(null,"requested-reconnect-pending?","requested-reconnect-pending?",-299841116)),new cljs.core.Keyword(null,"requested-reconnect?","requested-reconnect?",-1504983666),true):cljs.core.dissoc.call(null,new_state__$1,new cljs.core.Keyword(null,"requested-reconnect?","requested-reconnect?",-1504983666)));
return taoensso.encore.swapped.call(null,new_state__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_state,new_state__$2], null));
});})(map__47848,map__47848__$1,chsk,chs,state_))
);
var old_state = cljs.core.nth.call(null,vec__47850,(0),null);
var new_state = cljs.core.nth.call(null,vec__47850,(1),null);
if(cljs.core.not_EQ_.call(null,old_state,new_state)){
var output = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [old_state,new_state], null);
cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(chs),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","state","chsk/state",-1991397620),output], null));

return output;
} else {
return null;
}
});
/**
 * Experimental, undocumented. Allows a core.async channel to be provided
 *   instead of a cb-fn. The channel will receive values of form
 *   [<event-id>.cb <reply>].
 */
taoensso.sente.cb_chan_as_fn = (function taoensso$sente$cb_chan_as_fn(_QMARK_cb,ev){
if(((_QMARK_cb == null)) || (cljs.core.ifn_QMARK_.call(null,_QMARK_cb))){
return _QMARK_cb;
} else {
var e_47861 = (function (){try{if(taoensso.encore.chan_QMARK_.call(null,_QMARK_cb)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e47857){if((e47857 instanceof Error)){
var e = e47857;
return e;
} else {
throw e47857;

}
}})();
if((e_47861 == null)){
} else {
taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",827,"(enc/chan? ?cb)",_QMARK_cb,e_47861,null);
}

taoensso.sente.assert_event.call(null,ev);

var vec__47858 = ev;
var ev_id = cljs.core.nth.call(null,vec__47858,(0),null);
var _ = cljs.core.nth.call(null,vec__47858,(1),null);
var cb_ch = _QMARK_cb;
return ((function (vec__47858,ev_id,_,cb_ch){
return (function (reply){
return cljs.core.async.put_BANG_.call(null,cb_ch,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.encore.as_qname.call(null,ev_id)),cljs.core.str.cljs$core$IFn$_invoke$arity$1(".cb")].join('')),reply], null));
});
;})(vec__47858,ev_id,_,cb_ch))
}
});
taoensso.sente.receive_buffered_evs_BANG_ = (function taoensso$sente$receive_buffered_evs_BANG_(chs,clj){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",838,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["receive-buffered-evs!: %s",clj], null);
}),null)),null,-506165261);

var buffered_evs = ((cljs.core.vector_QMARK_.call(null,clj))?clj:taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",839,"(vector? clj)",clj,null,null));
var seq__47872 = cljs.core.seq.call(null,buffered_evs);
var chunk__47873 = null;
var count__47874 = (0);
var i__47875 = (0);
while(true){
if((i__47875 < count__47874)){
var ev = cljs.core._nth.call(null,chunk__47873,i__47875);
taoensso.sente.assert_event.call(null,ev);

var vec__47876_47882 = ev;
var id_47883 = cljs.core.nth.call(null,vec__47876_47882,(0),null);
if(cljs.core.not_EQ_.call(null,cljs.core.namespace.call(null,id_47883),"chsk")){
} else {
throw (new Error("Assert failed: (not= (namespace id) \"chsk\")"));
}

cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"<server","<server",-2135373537).cljs$core$IFn$_invoke$arity$1(chs),ev);

var G__47884 = seq__47872;
var G__47885 = chunk__47873;
var G__47886 = count__47874;
var G__47887 = (i__47875 + (1));
seq__47872 = G__47884;
chunk__47873 = G__47885;
count__47874 = G__47886;
i__47875 = G__47887;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__47872);
if(temp__6753__auto__){
var seq__47872__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__47872__$1)){
var c__8413__auto__ = cljs.core.chunk_first.call(null,seq__47872__$1);
var G__47888 = cljs.core.chunk_rest.call(null,seq__47872__$1);
var G__47889 = c__8413__auto__;
var G__47890 = cljs.core.count.call(null,c__8413__auto__);
var G__47891 = (0);
seq__47872 = G__47888;
chunk__47873 = G__47889;
count__47874 = G__47890;
i__47875 = G__47891;
continue;
} else {
var ev = cljs.core.first.call(null,seq__47872__$1);
taoensso.sente.assert_event.call(null,ev);

var vec__47879_47892 = ev;
var id_47893 = cljs.core.nth.call(null,vec__47879_47892,(0),null);
if(cljs.core.not_EQ_.call(null,cljs.core.namespace.call(null,id_47893),"chsk")){
} else {
throw (new Error("Assert failed: (not= (namespace id) \"chsk\")"));
}

cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"<server","<server",-2135373537).cljs$core$IFn$_invoke$arity$1(chs),ev);

var G__47894 = cljs.core.next.call(null,seq__47872__$1);
var G__47895 = null;
var G__47896 = (0);
var G__47897 = (0);
seq__47872 = G__47894;
chunk__47873 = G__47895;
count__47874 = G__47896;
i__47875 = G__47897;
continue;
}
} else {
return null;
}
}
break;
}
});
taoensso.sente.handshake_QMARK_ = (function taoensso$sente$handshake_QMARK_(x){
var and__7490__auto__ = cljs.core.vector_QMARK_.call(null,x);
if(and__7490__auto__){
var vec__47907 = x;
var x1 = cljs.core.nth.call(null,vec__47907,(0),null);
return cljs.core._EQ_.call(null,x1,new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686));
} else {
return and__7490__auto__;
}
});
taoensso.sente.receive_handshake_BANG_ = (function taoensso$sente$receive_handshake_BANG_(chsk_type,chsk,clj){
var e_47930 = (function (){try{if((function (x){
return cljs.core.contains_QMARK_.call(null,taoensso.truss.impl.set_STAR_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ws","ws",86841443),null,new cljs.core.Keyword(null,"ajax","ajax",814345549),null], null), null)),x);
}).call(null,chsk_type)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e47920){if((e47920 instanceof Error)){
var e = e47920;
return e;
} else {
throw e47920;

}
}})();
if((e_47930 == null)){
} else {
taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",853,"([:el #{:ws :ajax}] chsk-type)",chsk_type,e_47930,null);
}

var e_47931 = (function (){try{if(cljs.core.truth_(taoensso.sente.handshake_QMARK_.call(null,clj))){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e47921){if((e47921 instanceof Error)){
var e = e47921;
return e;
} else {
throw e47921;

}
}})();
if((e_47931 == null)){
} else {
taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",854,"(handshake? clj)",clj,e_47931,null);
}

taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",855,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay((function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["receive-handshake! (%s): %s",chsk_type,clj], null);
}),null)),null,-111587268);

var vec__47922 = clj;
var _ = cljs.core.nth.call(null,vec__47922,(0),null);
var vec__47925 = cljs.core.nth.call(null,vec__47922,(1),null);
var _QMARK_uid = cljs.core.nth.call(null,vec__47925,(0),null);
var _QMARK_csrf_token = cljs.core.nth.call(null,vec__47925,(1),null);
var _QMARK_handshake_data = cljs.core.nth.call(null,vec__47925,(2),null);
var map__47928 = chsk;
var map__47928__$1 = ((((!((map__47928 == null)))?((((map__47928.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47928.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47928):map__47928);
var chs = cljs.core.get.call(null,map__47928__$1,new cljs.core.Keyword(null,"chs","chs",376886120));
var ever_opened_QMARK__ = cljs.core.get.call(null,map__47928__$1,new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913));
var first_handshake_QMARK_ = cljs.core.compare_and_set_BANG_.call(null,ever_opened_QMARK__,false,true);
var new_state = new cljs.core.PersistentArrayMap(null, 7, [new cljs.core.Keyword(null,"type","type",1174270348),chsk_type,new cljs.core.Keyword(null,"open?","open?",1238443125),true,new cljs.core.Keyword(null,"ever-opened?","ever-opened?",1128459732),true,new cljs.core.Keyword(null,"uid","uid",-1447769400),_QMARK_uid,new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856),_QMARK_csrf_token,new cljs.core.Keyword(null,"handshake-data","handshake-data",-278378864),_QMARK_handshake_data,new cljs.core.Keyword(null,"first-open?","first-open?",396686530),first_handshake_QMARK_], null);
var handshake_ev = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","handshake","chsk/handshake",64910686),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_uid,_QMARK_csrf_token,_QMARK_handshake_data,first_handshake_QMARK_], null)], null);
taoensso.sente.assert_event.call(null,handshake_ev);

if(clojure.string.blank_QMARK_.call(null,_QMARK_csrf_token)){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",874,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__47922,_,vec__47925,_QMARK_uid,_QMARK_csrf_token,_QMARK_handshake_data,map__47928,map__47928__$1,chs,ever_opened_QMARK__,first_handshake_QMARK_,new_state,handshake_ev){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["SECURITY WARNING: no CSRF token available for use by Sente"], null);
});})(vec__47922,_,vec__47925,_QMARK_uid,_QMARK_csrf_token,_QMARK_handshake_data,map__47928,map__47928__$1,chs,ever_opened_QMARK__,first_handshake_QMARK_,new_state,handshake_ev))
,null)),null,1503403084);
} else {
}

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk,new_state);

cljs.core.async.put_BANG_.call(null,new cljs.core.Keyword(null,"internal","internal",-854870097).cljs$core$IFn$_invoke$arity$1(chs),handshake_ev);

return new cljs.core.Keyword(null,"handled","handled",1889700151);
});
/**
 * nnil iff the websocket npm library[1] is available.
 *   Easiest way to install:
 *     1. Add the lein-npm[2] plugin to your `project.clj`,
 *     2. Add: `:npm {:dependencies [[websocket "1.0.23"]]}`
 * 
 *   [1] Ref. https://www.npmjs.com/package/websocket
 *   [2] Ref. https://github.com/RyanMcG/lein-npm
 */
taoensso.sente._QMARK_node_npm_websocket_ = (new cljs.core.Delay((function (){
if((taoensso.sente.node_target_QMARK_) && (typeof require !== 'undefined')){
try{return require("websocket");
}catch (e47932){var e = e47932;
return null;
}} else {
return null;
}
}),null));

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {taoensso.sente.IChSocket}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.sente.ChWebSocket = (function (client_id,chs,params,packer,url,state_,active_retry_id_,retry_count_,ever_opened_QMARK__,backoff_ms_fn,cbs_waiting_,socket_,__meta,__extmap,__hash){
this.client_id = client_id;
this.chs = chs;
this.params = params;
this.packer = packer;
this.url = url;
this.state_ = state_;
this.active_retry_id_ = active_retry_id_;
this.retry_count_ = retry_count_;
this.ever_opened_QMARK__ = ever_opened_QMARK__;
this.backoff_ms_fn = backoff_ms_fn;
this.cbs_waiting_ = cbs_waiting_;
this.socket_ = socket_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})

taoensso.sente.ChWebSocket.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8177__auto__,k__8178__auto__){
var self__ = this;
var this__8177__auto____$1 = this;
return this__8177__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8178__auto__,null);
});


taoensso.sente.ChWebSocket.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8179__auto__,k47934,else__8180__auto__){
var self__ = this;
var this__8179__auto____$1 = this;
var G__47936 = (((k47934 instanceof cljs.core.Keyword))?k47934.fqn:null);
switch (G__47936) {
case "ever-opened?_":
return self__.ever_opened_QMARK__;

break;
case "client-id":
return self__.client_id;

break;
case "packer":
return self__.packer;

break;
case "chs":
return self__.chs;

break;
case "params":
return self__.params;

break;
case "retry-count_":
return self__.retry_count_;

break;
case "backoff-ms-fn":
return self__.backoff_ms_fn;

break;
case "socket_":
return self__.socket_;

break;
case "url":
return self__.url;

break;
case "active-retry-id_":
return self__.active_retry_id_;

break;
case "cbs-waiting_":
return self__.cbs_waiting_;

break;
case "state_":
return self__.state_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k47934,else__8180__auto__);

}
});


taoensso.sente.ChWebSocket.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8191__auto__,writer__8192__auto__,opts__8193__auto__){
var self__ = this;
var this__8191__auto____$1 = this;
var pr_pair__8194__auto__ = ((function (this__8191__auto____$1){
return (function (keyval__8195__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8192__auto__,cljs.core.pr_writer,""," ","",opts__8193__auto__,keyval__8195__auto__);
});})(this__8191__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8192__auto__,pr_pair__8194__auto__,"#taoensso.sente.ChWebSocket{",", ","}",opts__8193__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),self__.active_retry_id_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),self__.retry_count_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),self__.ever_opened_QMARK__],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),self__.cbs_waiting_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"socket_","socket_",-361048908),self__.socket_],null))], null),self__.__extmap));
});


taoensso.sente.ChWebSocket.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;


taoensso.sente.ChWebSocket.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__47933){
var self__ = this;
var G__47933__$1 = this;
return (new cljs.core.RecordIter((0),G__47933__$1,12,new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),new cljs.core.Keyword(null,"socket_","socket_",-361048908)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


taoensso.sente.ChWebSocket.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8175__auto__){
var self__ = this;
var this__8175__auto____$1 = this;
return self__.__meta;
});


taoensso.sente.ChWebSocket.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8171__auto__){
var self__ = this;
var this__8171__auto____$1 = this;
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.__meta,self__.__extmap,self__.__hash));
});


taoensso.sente.ChWebSocket.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8181__auto__){
var self__ = this;
var this__8181__auto____$1 = this;
return (12 + cljs.core.count.call(null,self__.__extmap));
});


taoensso.sente.ChWebSocket.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8172__auto__){
var self__ = this;
var this__8172__auto____$1 = this;
var h__7944__auto__ = self__.__hash;
if(!((h__7944__auto__ == null))){
return h__7944__auto__;
} else {
var h__7944__auto____$1 = cljs.core.hash_imap.call(null,this__8172__auto____$1);
self__.__hash = h__7944__auto____$1;

return h__7944__auto____$1;
}
});


taoensso.sente.ChWebSocket.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8173__auto__,other__8174__auto__){
var self__ = this;
var this__8173__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7490__auto__ = other__8174__auto__;
if(cljs.core.truth_(and__7490__auto__)){
return ((this__8173__auto____$1.constructor === other__8174__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8173__auto____$1,other__8174__auto__));
} else {
return and__7490__auto__;
}
})())){
return true;
} else {
return false;
}
});


taoensso.sente.ChWebSocket.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8186__auto__,k__8187__auto__){
var self__ = this;
var this__8186__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 12, [new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),null,new cljs.core.Keyword(null,"packer","packer",66077544),null,new cljs.core.Keyword(null,"chs","chs",376886120),null,new cljs.core.Keyword(null,"params","params",710516235),null,new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),null,new cljs.core.Keyword(null,"socket_","socket_",-361048908),null,new cljs.core.Keyword(null,"url","url",276297046),null,new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),null,new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),null,new cljs.core.Keyword(null,"state_","state_",957667102),null], null), null),k__8187__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8186__auto____$1),self__.__meta),k__8187__auto__);
} else {
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8187__auto__)),null));
}
});


taoensso.sente.ChWebSocket.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8184__auto__,k__8185__auto__,G__47933){
var self__ = this;
var this__8184__auto____$1 = this;
var pred__47937 = cljs.core.keyword_identical_QMARK_;
var expr__47938 = k__8185__auto__;
if(cljs.core.truth_(pred__47937.call(null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),expr__47938))){
return (new taoensso.sente.ChWebSocket(G__47933,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__47937.call(null,new cljs.core.Keyword(null,"chs","chs",376886120),expr__47938))){
return (new taoensso.sente.ChWebSocket(self__.client_id,G__47933,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__47937.call(null,new cljs.core.Keyword(null,"params","params",710516235),expr__47938))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,G__47933,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__47937.call(null,new cljs.core.Keyword(null,"packer","packer",66077544),expr__47938))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,G__47933,self__.url,self__.state_,self__.active_retry_id_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__47937.call(null,new cljs.core.Keyword(null,"url","url",276297046),expr__47938))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,G__47933,self__.state_,self__.active_retry_id_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__47937.call(null,new cljs.core.Keyword(null,"state_","state_",957667102),expr__47938))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,G__47933,self__.active_retry_id_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__47937.call(null,new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),expr__47938))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,G__47933,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__47937.call(null,new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),expr__47938))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,G__47933,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__47937.call(null,new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),expr__47938))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.retry_count_,G__47933,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__47937.call(null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),expr__47938))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.retry_count_,self__.ever_opened_QMARK__,G__47933,self__.cbs_waiting_,self__.socket_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__47937.call(null,new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),expr__47938))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,G__47933,self__.socket_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__47937.call(null,new cljs.core.Keyword(null,"socket_","socket_",-361048908),expr__47938))){
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,G__47933,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8185__auto__,G__47933),null));
}
}
}
}
}
}
}
}
}
}
}
}
});


taoensso.sente.ChWebSocket.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8189__auto__){
var self__ = this;
var this__8189__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),self__.active_retry_id_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),self__.retry_count_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),self__.ever_opened_QMARK__],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),self__.cbs_waiting_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"socket_","socket_",-361048908),self__.socket_],null))], null),self__.__extmap));
});


taoensso.sente.ChWebSocket.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8176__auto__,G__47933){
var self__ = this;
var this__8176__auto____$1 = this;
return (new taoensso.sente.ChWebSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.retry_count_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.cbs_waiting_,self__.socket_,G__47933,self__.__extmap,self__.__hash));
});


taoensso.sente.ChWebSocket.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8182__auto__,entry__8183__auto__){
var self__ = this;
var this__8182__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8183__auto__)){
return this__8182__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8183__auto__,(0)),cljs.core._nth.call(null,entry__8183__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8182__auto____$1,entry__8183__auto__);
}
});


taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$ = cljs.core.PROTOCOL_SENTINEL;


taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$_chsk_disconnect_BANG_$arity$2 = (function (chsk,reconn_QMARK_){
var self__ = this;
var chsk__$1 = this;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,"_disable-auto-retry");

if(cljs.core.truth_(reconn_QMARK_)){
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"open?","open?",1238443125),false,new cljs.core.Keyword(null,"requested-reconnect-pending?","requested-reconnect-pending?",-299841116),true], null));
} else {
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));
}

var temp__6753__auto__ = cljs.core.deref.call(null,self__.socket_);
if(cljs.core.truth_(temp__6753__auto__)){
var s = temp__6753__auto__;
return s.close((1000),"CLOSE_NORMAL");
} else {
return null;
}
});


taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$_chsk_reconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
chsk__$1.taoensso$sente$IChSocket$_chsk_disconnect_BANG_$arity$2(null,new cljs.core.Keyword(null,"reconn","reconn",-807347633));

return chsk__$1.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1(null);
});


taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3 = (function (chsk,ev,opts){
var self__ = this;
var chsk__$1 = this;
var map__47940 = opts;
var map__47940__$1 = ((((!((map__47940 == null)))?((((map__47940.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__47940.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__47940):map__47940);
var _QMARK_timeout_ms = cljs.core.get.call(null,map__47940__$1,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406));
var _QMARK_cb = cljs.core.get.call(null,map__47940__$1,new cljs.core.Keyword(null,"cb","cb",589947841));
var flush_QMARK_ = cljs.core.get.call(null,map__47940__$1,new cljs.core.Keyword(null,"flush?","flush?",-108887231));
var _ = taoensso.sente.assert_send_args.call(null,ev,_QMARK_timeout_ms,_QMARK_cb);
var _QMARK_cb_fn = taoensso.sente.cb_chan_as_fn.call(null,_QMARK_cb,ev);
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_)))){
return taoensso.sente.chsk_send__GT_closed_BANG_.call(null,_QMARK_cb_fn);
} else {
var _QMARK_cb_uuid = (cljs.core.truth_(_QMARK_cb_fn)?taoensso.encore.uuid_str.call(null,(6)):null);
var ppstr = taoensso.sente.pack.call(null,self__.packer,cljs.core.meta.call(null,ev),ev,_QMARK_cb_uuid);
var temp__6753__auto___47982 = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__6753__auto___47982)){
var cb_uuid_47983 = temp__6753__auto___47982;
taoensso.encore.reset_in_BANG_.call(null,self__.cbs_waiting_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cb_uuid_47983], null),(function (){var e = (function (){try{if(taoensso.truss.impl.some_QMARK_.call(null,_QMARK_cb_fn)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e47942){if((e47942 instanceof Error)){
var e = e47942;
return e;
} else {
throw e47942;

}
}})();
if((e == null)){
return _QMARK_cb_fn;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",945,"(taoensso.truss.impl/some? ?cb-fn)",_QMARK_cb_fn,e,null);
}
})());

var temp__6753__auto___47984__$1 = _QMARK_timeout_ms;
if(cljs.core.truth_(temp__6753__auto___47984__$1)){
var timeout_ms_47985 = temp__6753__auto___47984__$1;
var c__42603__auto___47986 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto___47986,timeout_ms_47985,temp__6753__auto___47984__$1,cb_uuid_47983,temp__6753__auto___47982,_QMARK_cb_uuid,ppstr,map__47940,map__47940__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto___47986,timeout_ms_47985,temp__6753__auto___47984__$1,cb_uuid_47983,temp__6753__auto___47982,_QMARK_cb_uuid,ppstr,map__47940,map__47940__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1){
return (function (state_47953){
var state_val_47954 = (state_47953[(1)]);
if((state_val_47954 === (1))){
var inst_47943 = cljs.core.async.timeout.call(null,timeout_ms_47985);
var state_47953__$1 = state_47953;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_47953__$1,(2),inst_47943);
} else {
if((state_val_47954 === (2))){
var inst_47946 = (state_47953[(7)]);
var inst_47945 = (state_47953[(2)]);
var inst_47946__$1 = taoensso.sente.pull_unused_cb_fn_BANG_.call(null,self__.cbs_waiting_,_QMARK_cb_uuid);
var state_47953__$1 = (function (){var statearr_47955 = state_47953;
(statearr_47955[(8)] = inst_47945);

(statearr_47955[(7)] = inst_47946__$1);

return statearr_47955;
})();
if(cljs.core.truth_(inst_47946__$1)){
var statearr_47956_47987 = state_47953__$1;
(statearr_47956_47987[(1)] = (3));

} else {
var statearr_47957_47988 = state_47953__$1;
(statearr_47957_47988[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47954 === (3))){
var inst_47946 = (state_47953[(7)]);
var inst_47948 = inst_47946.call(null,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489));
var state_47953__$1 = state_47953;
var statearr_47958_47989 = state_47953__$1;
(statearr_47958_47989[(2)] = inst_47948);

(statearr_47958_47989[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47954 === (4))){
var state_47953__$1 = state_47953;
var statearr_47959_47990 = state_47953__$1;
(statearr_47959_47990[(2)] = null);

(statearr_47959_47990[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_47954 === (5))){
var inst_47951 = (state_47953[(2)]);
var state_47953__$1 = state_47953;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_47953__$1,inst_47951);
} else {
return null;
}
}
}
}
}
});})(c__42603__auto___47986,timeout_ms_47985,temp__6753__auto___47984__$1,cb_uuid_47983,temp__6753__auto___47982,_QMARK_cb_uuid,ppstr,map__47940,map__47940__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1))
;
return ((function (switch__42489__auto__,c__42603__auto___47986,timeout_ms_47985,temp__6753__auto___47984__$1,cb_uuid_47983,temp__6753__auto___47982,_QMARK_cb_uuid,ppstr,map__47940,map__47940__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1){
return (function() {
var taoensso$sente$state_machine__42490__auto__ = null;
var taoensso$sente$state_machine__42490__auto____0 = (function (){
var statearr_47963 = [null,null,null,null,null,null,null,null,null];
(statearr_47963[(0)] = taoensso$sente$state_machine__42490__auto__);

(statearr_47963[(1)] = (1));

return statearr_47963;
});
var taoensso$sente$state_machine__42490__auto____1 = (function (state_47953){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_47953);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e47964){if((e47964 instanceof Object)){
var ex__42493__auto__ = e47964;
var statearr_47965_47991 = state_47953;
(statearr_47965_47991[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_47953);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e47964;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__47992 = state_47953;
state_47953 = G__47992;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
taoensso$sente$state_machine__42490__auto__ = function(state_47953){
switch(arguments.length){
case 0:
return taoensso$sente$state_machine__42490__auto____0.call(this);
case 1:
return taoensso$sente$state_machine__42490__auto____1.call(this,state_47953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$state_machine__42490__auto____0;
taoensso$sente$state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$state_machine__42490__auto____1;
return taoensso$sente$state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto___47986,timeout_ms_47985,temp__6753__auto___47984__$1,cb_uuid_47983,temp__6753__auto___47982,_QMARK_cb_uuid,ppstr,map__47940,map__47940__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1))
})();
var state__42605__auto__ = (function (){var statearr_47966 = f__42604__auto__.call(null);
(statearr_47966[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___47986);

return statearr_47966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto___47986,timeout_ms_47985,temp__6753__auto___47984__$1,cb_uuid_47983,temp__6753__auto___47982,_QMARK_cb_uuid,ppstr,map__47940,map__47940__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1))
);

} else {
}
} else {
}

try{cljs.core.deref.call(null,self__.socket_).send(ppstr);

return new cljs.core.Keyword(null,"apparent-success","apparent-success",242592222);
}catch (e47967){var e = e47967;
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",955,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (e,_QMARK_cb_uuid,ppstr,map__47940,map__47940__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,"Chsk send error"], null);
});})(e,_QMARK_cb_uuid,ppstr,map__47940,map__47940__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1))
,null)),null,1343541927);

var temp__6753__auto___47993 = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__6753__auto___47993)){
var cb_uuid_47994 = temp__6753__auto___47993;
var cb_fn_STAR__47995 = (function (){var or__7502__auto__ = taoensso.sente.pull_unused_cb_fn_BANG_.call(null,self__.cbs_waiting_,cb_uuid_47994);
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
var e__$1 = (function (){try{if(taoensso.truss.impl.some_QMARK_.call(null,_QMARK_cb_fn)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e47968){if((e47968 instanceof Error)){
var e__$1 = e47968;
return e__$1;
} else {
throw e47968;

}
}})();
if((e__$1 == null)){
return _QMARK_cb_fn;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",958,"(taoensso.truss.impl/some? ?cb-fn)",_QMARK_cb_fn,e__$1,null);
}
}
})();
cb_fn_STAR__47995.call(null,new cljs.core.Keyword("chsk","error","chsk/error",-984175439));
} else {
}

return false;
}}
});


taoensso.sente.ChWebSocket.prototype.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
var temp__6753__auto__ = (function (){var or__7502__auto__ = taoensso.encore.oget.call(null,goog.global,"WebSocket");
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
var or__7502__auto____$1 = taoensso.encore.oget.call(null,goog.global,"MozWebSocket");
if(cljs.core.truth_(or__7502__auto____$1)){
return or__7502__auto____$1;
} else {
return taoensso.encore.oget.call(null,cljs.core.deref.call(null,taoensso.sente._QMARK_node_npm_websocket_),"w3cwebsocket");
}
}
})();
if(cljs.core.truth_(temp__6753__auto__)){
var WebSocket = temp__6753__auto__;
var retry_id = taoensso.encore.uuid_str.call(null);
var connect_fn = ((function (retry_id,WebSocket,temp__6753__auto__,chsk__$1){
return (function taoensso$sente$connect_fn(){
var retry_fn = ((function (retry_id,WebSocket,temp__6753__auto__,chsk__$1){
return (function (){
if(cljs.core._EQ_.call(null,cljs.core.deref.call(null,self__.active_retry_id_),retry_id)){
var retry_count_STAR_ = cljs.core.swap_BANG_.call(null,self__.retry_count_,cljs.core.inc);
var backoff_ms = self__.backoff_ms_fn.call(null,retry_count_STAR_);
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",977,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (retry_count_STAR_,backoff_ms,retry_id,WebSocket,temp__6753__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk is closed: will try reconnect (%s)",retry_count_STAR_], null);
});})(retry_count_STAR_,backoff_ms,retry_id,WebSocket,temp__6753__auto__,chsk__$1))
,null)),null,-373348876);

return goog.global.setTimeout(taoensso$sente$connect_fn,backoff_ms);
} else {
return null;
}
});})(retry_id,WebSocket,temp__6753__auto__,chsk__$1))
;
var _QMARK_socket = (function (){try{return (new WebSocket(taoensso.encore.merge_url_with_query_string.call(null,self__.url,cljs.core.merge.call(null,self__.params,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id], null)))));
}catch (e47975){var e = e47975;
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",988,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (e,retry_fn,retry_id,WebSocket,temp__6753__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [e,"WebSocket error"], null);
});})(e,retry_fn,retry_id,WebSocket,temp__6753__auto__,chsk__$1))
,null)),null,823837233);

return null;
}})();
if(cljs.core.not.call(null,_QMARK_socket)){
return retry_fn.call(null);
} else {
return cljs.core.reset_BANG_.call(null,self__.socket_,(function (){var G__47976 = _QMARK_socket;
(G__47976["onerror"] = ((function (G__47976,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__6753__auto__,chsk__$1){
return (function (ws_ev){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",998,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (G__47976,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__6753__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["WebSocket error: %s",(function (){try{return cljs.core.js__GT_clj.call(null,ws_ev);
}catch (e47977){var _ = e47977;
return ws_ev;
}})()], null);
});})(G__47976,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__6753__auto__,chsk__$1))
,null)),null,107223790);

var last_ws_error = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"uuid","uuid",-2145095719),taoensso.encore.uuid_str.call(null),new cljs.core.Keyword(null,"ev","ev",-406827324),ws_ev], null);
return taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"last-ws-error","last-ws-error",-820288502),last_ws_error], null));
});})(G__47976,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__6753__auto__,chsk__$1))
);

(G__47976["onmessage"] = ((function (G__47976,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__6753__auto__,chsk__$1){
return (function (ws_ev){
var ppstr = taoensso.encore.oget.call(null,ws_ev,"data");
var vec__47978 = taoensso.sente.unpack.call(null,self__.packer,ppstr);
var clj = cljs.core.nth.call(null,vec__47978,(0),null);
var _QMARK_cb_uuid = cljs.core.nth.call(null,vec__47978,(1),null);
var or__7502__auto__ = (cljs.core.truth_(taoensso.sente.handshake_QMARK_.call(null,clj))?(function (){
taoensso.sente.receive_handshake_BANG_.call(null,new cljs.core.Keyword(null,"ws","ws",86841443),chsk__$1,clj);

return cljs.core.reset_BANG_.call(null,self__.retry_count_,(0));
})()
:null);
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
var or__7502__auto____$1 = ((cljs.core._EQ_.call(null,clj,new cljs.core.Keyword("chsk","ws-ping","chsk/ws-ping",191675304)))?(function (){
if(cljs.core.truth_(cljs.core.deref.call(null,taoensso.sente.debug_mode_QMARK__))){
taoensso.sente.receive_buffered_evs_BANG_.call(null,self__.chs,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("debug","ws-ping","debug/ws-ping",-168903566)], null)], null));
} else {
}

return new cljs.core.Keyword(null,"noop","noop",-673731258);
})()
:null);
if(cljs.core.truth_(or__7502__auto____$1)){
return or__7502__auto____$1;
} else {
var temp__6751__auto__ = _QMARK_cb_uuid;
if(cljs.core.truth_(temp__6751__auto__)){
var cb_uuid = temp__6751__auto__;
var temp__6751__auto____$1 = taoensso.sente.pull_unused_cb_fn_BANG_.call(null,self__.cbs_waiting_,cb_uuid);
if(cljs.core.truth_(temp__6751__auto____$1)){
var cb_fn = temp__6751__auto____$1;
return cb_fn.call(null,clj);
} else {
return taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",1037,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (temp__6751__auto____$1,cb_uuid,temp__6751__auto__,or__7502__auto____$1,or__7502__auto__,ppstr,vec__47978,clj,_QMARK_cb_uuid,G__47976,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__6753__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cb reply w/o local cb-fn: %s",clj], null);
});})(temp__6751__auto____$1,cb_uuid,temp__6751__auto__,or__7502__auto____$1,or__7502__auto__,ppstr,vec__47978,clj,_QMARK_cb_uuid,G__47976,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__6753__auto__,chsk__$1))
,null)),null,-1550272424);
}
} else {
var buffered_evs = clj;
return taoensso.sente.receive_buffered_evs_BANG_.call(null,self__.chs,buffered_evs);
}
}
}
});})(G__47976,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__6753__auto__,chsk__$1))
);

(G__47976["onclose"] = ((function (G__47976,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__6753__auto__,chsk__$1){
return (function (ws_ev){
var clean_QMARK_ = taoensso.encore.oget.call(null,ws_ev,"wasClean");
var code = taoensso.encore.oget.call(null,ws_ev,"code");
var reason = taoensso.encore.oget.call(null,ws_ev,"reason");
var last_ws_close = new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"uuid","uuid",-2145095719),taoensso.encore.uuid_str.call(null),new cljs.core.Keyword(null,"ev","ev",-406827324),ws_ev,new cljs.core.Keyword(null,"clean?","clean?",-1675631009),clean_QMARK_,new cljs.core.Keyword(null,"code","code",1586293142),code,new cljs.core.Keyword(null,"reason","reason",-2070751759),reason], null);
if(cljs.core.truth_(clean_QMARK_)){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"debug","debug",-1608172596),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",1065,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (clean_QMARK_,code,reason,last_ws_close,G__47976,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__6753__auto__,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Clean WebSocket close, will not attempt reconnect"], null);
});})(clean_QMARK_,code,reason,last_ws_close,G__47976,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__6753__auto__,chsk__$1))
,null)),null,376398880);

return taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"last-ws-close","last-ws-close",-798104932),last_ws_close], null));
} else {
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"last-ws-close","last-ws-close",-798104932),last_ws_close,new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

return retry_fn.call(null);
}
});})(G__47976,retry_fn,_QMARK_socket,retry_id,WebSocket,temp__6753__auto__,chsk__$1))
);

return G__47976;
})());
}
});})(retry_id,WebSocket,temp__6753__auto__,chsk__$1))
;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,retry_id);

cljs.core.reset_BANG_.call(null,self__.retry_count_,(0));

connect_fn.call(null);

return chsk__$1;
} else {
return null;
}
});

taoensso.sente.ChWebSocket.getBasis = (function (){
return new cljs.core.PersistentVector(null, 12, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"client-id","client-id",1175909387,null),new cljs.core.Symbol(null,"chs","chs",2017417647,null),new cljs.core.Symbol(null,"params","params",-1943919534,null),new cljs.core.Symbol(null,"packer","packer",1706609071,null),new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.Symbol(null,"state_","state_",-1696768667,null),new cljs.core.Symbol(null,"active-retry-id_","active-retry-id_",1468292413,null),new cljs.core.Symbol(null,"retry-count_","retry-count_",1660769620,null),new cljs.core.Symbol(null,"ever-opened?_","ever-opened?_",-1013096856,null),new cljs.core.Symbol(null,"backoff-ms-fn","backoff-ms-fn",-1881539814,null),new cljs.core.Symbol(null,"cbs-waiting_","cbs-waiting_",121502466,null),new cljs.core.Symbol(null,"socket_","socket_",1279482619,null)], null);
});

taoensso.sente.ChWebSocket.cljs$lang$type = true;

taoensso.sente.ChWebSocket.cljs$lang$ctorPrSeq = (function (this__8213__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"taoensso.sente/ChWebSocket");
});

taoensso.sente.ChWebSocket.cljs$lang$ctorPrWriter = (function (this__8213__auto__,writer__8214__auto__){
return cljs.core._write.call(null,writer__8214__auto__,"taoensso.sente/ChWebSocket");
});

taoensso.sente.__GT_ChWebSocket = (function taoensso$sente$__GT_ChWebSocket(client_id,chs,params,packer,url,state_,active_retry_id_,retry_count_,ever_opened_QMARK__,backoff_ms_fn,cbs_waiting_,socket_){
return (new taoensso.sente.ChWebSocket(client_id,chs,params,packer,url,state_,active_retry_id_,retry_count_,ever_opened_QMARK__,backoff_ms_fn,cbs_waiting_,socket_,null,null,null));
});

taoensso.sente.map__GT_ChWebSocket = (function taoensso$sente$map__GT_ChWebSocket(G__47935){
return (new taoensso.sente.ChWebSocket(new cljs.core.Keyword(null,"client-id","client-id",-464622140).cljs$core$IFn$_invoke$arity$1(G__47935),new cljs.core.Keyword(null,"chs","chs",376886120).cljs$core$IFn$_invoke$arity$1(G__47935),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(G__47935),new cljs.core.Keyword(null,"packer","packer",66077544).cljs$core$IFn$_invoke$arity$1(G__47935),new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(G__47935),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(G__47935),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114).cljs$core$IFn$_invoke$arity$1(G__47935),new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093).cljs$core$IFn$_invoke$arity$1(G__47935),new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913).cljs$core$IFn$_invoke$arity$1(G__47935),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955).cljs$core$IFn$_invoke$arity$1(G__47935),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061).cljs$core$IFn$_invoke$arity$1(G__47935),new cljs.core.Keyword(null,"socket_","socket_",-361048908).cljs$core$IFn$_invoke$arity$1(G__47935),null,cljs.core.dissoc.call(null,G__47935,new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),new cljs.core.Keyword(null,"socket_","socket_",-361048908)),null));
});

taoensso.sente.new_ChWebSocket = (function taoensso$sente$new_ChWebSocket(opts){
return taoensso.sente.map__GT_ChWebSocket.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"state_","state_",957667102),cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ws","ws",86841443),new cljs.core.Keyword(null,"open?","open?",1238443125),false], null)),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),cljs.core.atom.call(null,"_pending"),new cljs.core.Keyword(null,"retry-count_","retry-count_",20238093),cljs.core.atom.call(null,(0)),new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),cljs.core.atom.call(null,false),new cljs.core.Keyword(null,"cbs-waiting_","cbs-waiting_",-1519029061),cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY),new cljs.core.Keyword(null,"socket_","socket_",-361048908),cljs.core.atom.call(null,null)], null),opts));
});
/**
 * We must set *some* client-side timeout otherwise an unpredictable (and
 *   probably too short) browser default will be used. Must be > server's
 *   :lp-timeout-ms.
 */
taoensso.sente.default_client_side_ajax_timeout_ms = taoensso.encore.ms.call(null,new cljs.core.Keyword(null,"secs","secs",1532330091),(60));

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {taoensso.sente.IChSocket}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.sente.ChAjaxSocket = (function (client_id,chs,params,packer,url,state_,active_retry_id_,ever_opened_QMARK__,backoff_ms_fn,ajax_opts,curr_xhr_,__meta,__extmap,__hash){
this.client_id = client_id;
this.chs = chs;
this.params = params;
this.packer = packer;
this.url = url;
this.state_ = state_;
this.active_retry_id_ = active_retry_id_;
this.ever_opened_QMARK__ = ever_opened_QMARK__;
this.backoff_ms_fn = backoff_ms_fn;
this.ajax_opts = ajax_opts;
this.curr_xhr_ = curr_xhr_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})

taoensso.sente.ChAjaxSocket.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8177__auto__,k__8178__auto__){
var self__ = this;
var this__8177__auto____$1 = this;
return this__8177__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8178__auto__,null);
});


taoensso.sente.ChAjaxSocket.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8179__auto__,k47997,else__8180__auto__){
var self__ = this;
var this__8179__auto____$1 = this;
var G__47999 = (((k47997 instanceof cljs.core.Keyword))?k47997.fqn:null);
switch (G__47999) {
case "curr-xhr_":
return self__.curr_xhr_;

break;
case "ever-opened?_":
return self__.ever_opened_QMARK__;

break;
case "client-id":
return self__.client_id;

break;
case "packer":
return self__.packer;

break;
case "chs":
return self__.chs;

break;
case "params":
return self__.params;

break;
case "backoff-ms-fn":
return self__.backoff_ms_fn;

break;
case "url":
return self__.url;

break;
case "active-retry-id_":
return self__.active_retry_id_;

break;
case "ajax-opts":
return self__.ajax_opts;

break;
case "state_":
return self__.state_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k47997,else__8180__auto__);

}
});


taoensso.sente.ChAjaxSocket.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8191__auto__,writer__8192__auto__,opts__8193__auto__){
var self__ = this;
var this__8191__auto____$1 = this;
var pr_pair__8194__auto__ = ((function (this__8191__auto____$1){
return (function (keyval__8195__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8192__auto__,cljs.core.pr_writer,""," ","",opts__8193__auto__,keyval__8195__auto__);
});})(this__8191__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8192__auto__,pr_pair__8194__auto__,"#taoensso.sente.ChAjaxSocket{",", ","}",opts__8193__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),self__.active_retry_id_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),self__.ever_opened_QMARK__],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),self__.ajax_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),self__.curr_xhr_],null))], null),self__.__extmap));
});


taoensso.sente.ChAjaxSocket.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;


taoensso.sente.ChAjaxSocket.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__47996){
var self__ = this;
var G__47996__$1 = this;
return (new cljs.core.RecordIter((0),G__47996__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


taoensso.sente.ChAjaxSocket.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8175__auto__){
var self__ = this;
var this__8175__auto____$1 = this;
return self__.__meta;
});


taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8171__auto__){
var self__ = this;
var this__8171__auto____$1 = this;
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,self__.__extmap,self__.__hash));
});


taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8181__auto__){
var self__ = this;
var this__8181__auto____$1 = this;
return (11 + cljs.core.count.call(null,self__.__extmap));
});


taoensso.sente.ChAjaxSocket.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8172__auto__){
var self__ = this;
var this__8172__auto____$1 = this;
var h__7944__auto__ = self__.__hash;
if(!((h__7944__auto__ == null))){
return h__7944__auto__;
} else {
var h__7944__auto____$1 = cljs.core.hash_imap.call(null,this__8172__auto____$1);
self__.__hash = h__7944__auto____$1;

return h__7944__auto____$1;
}
});


taoensso.sente.ChAjaxSocket.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8173__auto__,other__8174__auto__){
var self__ = this;
var this__8173__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7490__auto__ = other__8174__auto__;
if(cljs.core.truth_(and__7490__auto__)){
return ((this__8173__auto____$1.constructor === other__8174__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8173__auto____$1,other__8174__auto__));
} else {
return and__7490__auto__;
}
})())){
return true;
} else {
return false;
}
});


taoensso.sente.ChAjaxSocket.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8186__auto__,k__8187__auto__){
var self__ = this;
var this__8186__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),null,new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),null,new cljs.core.Keyword(null,"packer","packer",66077544),null,new cljs.core.Keyword(null,"chs","chs",376886120),null,new cljs.core.Keyword(null,"params","params",710516235),null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),null,new cljs.core.Keyword(null,"url","url",276297046),null,new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),null,new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),null,new cljs.core.Keyword(null,"state_","state_",957667102),null], null), null),k__8187__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8186__auto____$1),self__.__meta),k__8187__auto__);
} else {
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8187__auto__)),null));
}
});


taoensso.sente.ChAjaxSocket.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8184__auto__,k__8185__auto__,G__47996){
var self__ = this;
var this__8184__auto____$1 = this;
var pred__48000 = cljs.core.keyword_identical_QMARK_;
var expr__48001 = k__8185__auto__;
if(cljs.core.truth_(pred__48000.call(null,new cljs.core.Keyword(null,"client-id","client-id",-464622140),expr__48001))){
return (new taoensso.sente.ChAjaxSocket(G__47996,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48000.call(null,new cljs.core.Keyword(null,"chs","chs",376886120),expr__48001))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,G__47996,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48000.call(null,new cljs.core.Keyword(null,"params","params",710516235),expr__48001))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,G__47996,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48000.call(null,new cljs.core.Keyword(null,"packer","packer",66077544),expr__48001))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,G__47996,self__.url,self__.state_,self__.active_retry_id_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48000.call(null,new cljs.core.Keyword(null,"url","url",276297046),expr__48001))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,G__47996,self__.state_,self__.active_retry_id_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48000.call(null,new cljs.core.Keyword(null,"state_","state_",957667102),expr__48001))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,G__47996,self__.active_retry_id_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48000.call(null,new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),expr__48001))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,G__47996,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48000.call(null,new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),expr__48001))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,G__47996,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48000.call(null,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),expr__48001))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.ever_opened_QMARK__,G__47996,self__.ajax_opts,self__.curr_xhr_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48000.call(null,new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),expr__48001))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,G__47996,self__.curr_xhr_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48000.call(null,new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),expr__48001))){
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,G__47996,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8185__auto__,G__47996),null));
}
}
}
}
}
}
}
}
}
}
}
});


taoensso.sente.ChAjaxSocket.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8189__auto__){
var self__ = this;
var this__8189__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"chs","chs",376886120),self__.chs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"params","params",710516235),self__.params],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"packer","packer",66077544),self__.packer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"url","url",276297046),self__.url],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),self__.active_retry_id_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),self__.ever_opened_QMARK__],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),self__.backoff_ms_fn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),self__.ajax_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),self__.curr_xhr_],null))], null),self__.__extmap));
});


taoensso.sente.ChAjaxSocket.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8176__auto__,G__47996){
var self__ = this;
var this__8176__auto____$1 = this;
return (new taoensso.sente.ChAjaxSocket(self__.client_id,self__.chs,self__.params,self__.packer,self__.url,self__.state_,self__.active_retry_id_,self__.ever_opened_QMARK__,self__.backoff_ms_fn,self__.ajax_opts,self__.curr_xhr_,G__47996,self__.__extmap,self__.__hash));
});


taoensso.sente.ChAjaxSocket.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8182__auto__,entry__8183__auto__){
var self__ = this;
var this__8182__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8183__auto__)){
return this__8182__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8183__auto__,(0)),cljs.core._nth.call(null,entry__8183__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8182__auto____$1,entry__8183__auto__);
}
});


taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$ = cljs.core.PROTOCOL_SENTINEL;


taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$_chsk_disconnect_BANG_$arity$2 = (function (chsk,reconn_QMARK_){
var self__ = this;
var chsk__$1 = this;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,"_disable-auto-retry");

if(cljs.core.truth_(reconn_QMARK_)){
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"open?","open?",1238443125),false,new cljs.core.Keyword(null,"requested-reconnect-pending?","requested-reconnect-pending?",-299841116),true], null));
} else {
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));
}

var temp__6753__auto__ = cljs.core.deref.call(null,self__.curr_xhr_);
if(cljs.core.truth_(temp__6753__auto__)){
var x = temp__6753__auto__;
return x.abort();
} else {
return null;
}
});


taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$_chsk_reconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
chsk__$1.taoensso$sente$IChSocket$_chsk_disconnect_BANG_$arity$2(null,new cljs.core.Keyword(null,"reconn","reconn",-807347633));

return chsk__$1.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1(null);
});


taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3 = (function (chsk,ev,opts){
var self__ = this;
var chsk__$1 = this;
var map__48003 = opts;
var map__48003__$1 = ((((!((map__48003 == null)))?((((map__48003.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48003.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48003):map__48003);
var _QMARK_timeout_ms = cljs.core.get.call(null,map__48003__$1,new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406));
var _QMARK_cb = cljs.core.get.call(null,map__48003__$1,new cljs.core.Keyword(null,"cb","cb",589947841));
var flush_QMARK_ = cljs.core.get.call(null,map__48003__$1,new cljs.core.Keyword(null,"flush?","flush?",-108887231));
var _ = taoensso.sente.assert_send_args.call(null,ev,_QMARK_timeout_ms,_QMARK_cb);
var _QMARK_cb_fn = taoensso.sente.cb_chan_as_fn.call(null,_QMARK_cb,ev);
if(cljs.core.not.call(null,new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_)))){
return taoensso.sente.chsk_send__GT_closed_BANG_.call(null,_QMARK_cb_fn);
} else {
var csrf_token = new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_));
taoensso.sente.ajax_lite.call(null,self__.url,cljs.core.merge.call(null,self__.ajax_opts,new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),(function (){var or__7502__auto__ = _QMARK_timeout_ms;
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
var or__7502__auto____$1 = new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406).cljs$core$IFn$_invoke$arity$1(self__.ajax_opts);
if(cljs.core.truth_(or__7502__auto____$1)){
return or__7502__auto____$1;
} else {
return taoensso.sente.default_client_side_ajax_timeout_ms;
}
}
})(),new cljs.core.Keyword(null,"resp-type","resp-type",1050675962),new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"headers","headers",-835030129),cljs.core.merge.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(self__.ajax_opts),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"X-CSRF-Token","X-CSRF-Token",1562992453),csrf_token], null)),new cljs.core.Keyword(null,"params","params",710516235),(function (){var ppstr = taoensso.sente.pack.call(null,self__.packer,cljs.core.meta.call(null,ev),ev,(cljs.core.truth_(_QMARK_cb_fn)?new cljs.core.Keyword(null,"ajax-cb","ajax-cb",-807060321):null));
return cljs.core.merge.call(null,self__.params,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"udt","udt",2011712751),taoensso.encore.now_udt.call(null),new cljs.core.Keyword(null,"csrf-token","csrf-token",-1872302856),csrf_token,new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id,new cljs.core.Keyword(null,"ppstr","ppstr",1557495252),ppstr], null));
})()], null)),((function (csrf_token,map__48003,map__48003__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1){
return (function taoensso$sente$ajax_cb(p__48005){
var map__48011 = p__48005;
var map__48011__$1 = ((((!((map__48011 == null)))?((((map__48011.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48011.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48011):map__48011);
var _QMARK_error = cljs.core.get.call(null,map__48011__$1,new cljs.core.Keyword(null,"?error","?error",1070752222));
var _QMARK_content = cljs.core.get.call(null,map__48011__$1,new cljs.core.Keyword(null,"?content","?content",1697782054));
if(cljs.core.truth_(_QMARK_error)){
if(cljs.core._EQ_.call(null,_QMARK_error,new cljs.core.Keyword(null,"timeout","timeout",-318625318))){
if(cljs.core.truth_(_QMARK_cb_fn)){
return _QMARK_cb_fn.call(null,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489));
} else {
return null;
}
} else {
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

if(cljs.core.truth_(_QMARK_cb_fn)){
return _QMARK_cb_fn.call(null,new cljs.core.Keyword("chsk","error","chsk/error",-984175439));
} else {
return null;
}
}
} else {
var content = _QMARK_content;
var resp_ppstr = content;
var vec__48013 = taoensso.sente.unpack.call(null,self__.packer,resp_ppstr);
var resp_clj = cljs.core.nth.call(null,vec__48013,(0),null);
var ___$1 = cljs.core.nth.call(null,vec__48013,(1),null);
if(cljs.core.truth_(_QMARK_cb_fn)){
_QMARK_cb_fn.call(null,resp_clj);
} else {
if(cljs.core.not_EQ_.call(null,resp_clj,new cljs.core.Keyword("chsk","dummy-cb-200","chsk/dummy-cb-200",-1663130337))){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",1166,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (content,resp_ppstr,vec__48013,resp_clj,___$1,map__48011,map__48011__$1,_QMARK_error,_QMARK_content,csrf_token,map__48003,map__48003__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Cb reply w/o local cb-fn: %s",resp_clj], null);
});})(content,resp_ppstr,vec__48013,resp_clj,___$1,map__48011,map__48011__$1,_QMARK_error,_QMARK_content,csrf_token,map__48003,map__48003__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1))
,null)),null,1471794700);
} else {
}
}

return taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),true], null));
}
});})(csrf_token,map__48003,map__48003__$1,_QMARK_timeout_ms,_QMARK_cb,flush_QMARK_,_,_QMARK_cb_fn,chsk__$1))
);

return new cljs.core.Keyword(null,"apparent-success","apparent-success",242592222);
}
});


taoensso.sente.ChAjaxSocket.prototype.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
var retry_id = taoensso.encore.uuid_str.call(null);
var poll_fn = ((function (retry_id,chsk__$1){
return (function taoensso$sente$poll_fn(retry_count){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",1175,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (retry_id,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["async-poll-for-update!"], null);
});})(retry_id,chsk__$1))
,null)),null,-1460414740);

var retry_fn = ((function (retry_id,chsk__$1){
return (function (){
if(cljs.core._EQ_.call(null,cljs.core.deref.call(null,self__.active_retry_id_),retry_id)){
var retry_count_STAR_ = (retry_count + (1));
var backoff_ms = self__.backoff_ms_fn.call(null,retry_count_STAR_);
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",1181,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (retry_count_STAR_,backoff_ms,retry_id,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Chsk is closed: will try reconnect (%s)",retry_count_STAR_], null);
});})(retry_count_STAR_,backoff_ms,retry_id,chsk__$1))
,null)),null,-2063922002);

return goog.global.setTimeout(((function (retry_count_STAR_,backoff_ms,retry_id,chsk__$1){
return (function (){
return taoensso$sente$poll_fn.call(null,retry_count_STAR_);
});})(retry_count_STAR_,backoff_ms,retry_id,chsk__$1))
,backoff_ms);
} else {
return null;
}
});})(retry_id,chsk__$1))
;
return cljs.core.reset_BANG_.call(null,self__.curr_xhr_,taoensso.sente.ajax_lite.call(null,self__.url,cljs.core.merge.call(null,self__.ajax_opts,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406),(function (){var or__7502__auto__ = new cljs.core.Keyword(null,"timeout-ms","timeout-ms",754221406).cljs$core$IFn$_invoke$arity$1(self__.ajax_opts);
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
return taoensso.sente.default_client_side_ajax_timeout_ms;
}
})(),new cljs.core.Keyword(null,"resp-type","resp-type",1050675962),new cljs.core.Keyword(null,"text","text",-1790561697),new cljs.core.Keyword(null,"params","params",710516235),cljs.core.merge.call(null,self__.params,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"udt","udt",2011712751),taoensso.encore.now_udt.call(null),new cljs.core.Keyword(null,"client-id","client-id",-464622140),self__.client_id], null),(cljs.core.truth_(new cljs.core.Keyword(null,"open?","open?",1238443125).cljs$core$IFn$_invoke$arity$1(cljs.core.deref.call(null,self__.state_)))?null:new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"handshake?","handshake?",-423743093),true], null)))], null)),((function (retry_fn,retry_id,chsk__$1){
return (function taoensso$sente$poll_fn_$_ajax_cb(p__48027){
var map__48033 = p__48027;
var map__48033__$1 = ((((!((map__48033 == null)))?((((map__48033.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48033.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48033):map__48033);
var _QMARK_error = cljs.core.get.call(null,map__48033__$1,new cljs.core.Keyword(null,"?error","?error",1070752222));
var _QMARK_content = cljs.core.get.call(null,map__48033__$1,new cljs.core.Keyword(null,"?content","?content",1697782054));
if(cljs.core.truth_(_QMARK_error)){
if(cljs.core._EQ_.call(null,_QMARK_error,new cljs.core.Keyword(null,"timeout","timeout",-318625318))){
return taoensso$sente$poll_fn.call(null,(0));
} else {
taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),false], null));

return retry_fn.call(null);

}
} else {
var content = _QMARK_content;
var ppstr = content;
var vec__48035 = taoensso.sente.unpack.call(null,self__.packer,ppstr);
var clj = cljs.core.nth.call(null,vec__48035,(0),null);
var handshake_QMARK_ = taoensso.sente.handshake_QMARK_.call(null,clj);
if(cljs.core.truth_(handshake_QMARK_)){
taoensso.sente.receive_handshake_BANG_.call(null,new cljs.core.Keyword(null,"ajax","ajax",814345549),chsk__$1,clj);
} else {
}

taoensso.sente.merge_GT_chsk_state_BANG_.call(null,chsk__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"open?","open?",1238443125),true], null));

taoensso$sente$poll_fn.call(null,(0));

if(cljs.core.truth_(handshake_QMARK_)){
return null;
} else {
var or__7502__auto__ = ((cljs.core._EQ_.call(null,clj,new cljs.core.Keyword("chsk","timeout","chsk/timeout",-319776489)))?(function (){
if(cljs.core.truth_(cljs.core.deref.call(null,taoensso.sente.debug_mode_QMARK__))){
taoensso.sente.receive_buffered_evs_BANG_.call(null,self__.chs,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("debug","timeout","debug/timeout",309499949)], null)], null));
} else {
}

return new cljs.core.Keyword(null,"noop","noop",-673731258);
})()
:null);
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
var buffered_evs = clj;
return taoensso.sente.receive_buffered_evs_BANG_.call(null,self__.chs,buffered_evs);
}
}
}
});})(retry_fn,retry_id,chsk__$1))
));
});})(retry_id,chsk__$1))
;
cljs.core.reset_BANG_.call(null,self__.active_retry_id_,retry_id);

poll_fn.call(null,(0));

return chsk__$1;
});

taoensso.sente.ChAjaxSocket.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"client-id","client-id",1175909387,null),new cljs.core.Symbol(null,"chs","chs",2017417647,null),new cljs.core.Symbol(null,"params","params",-1943919534,null),new cljs.core.Symbol(null,"packer","packer",1706609071,null),new cljs.core.Symbol(null,"url","url",1916828573,null),new cljs.core.Symbol(null,"state_","state_",-1696768667,null),new cljs.core.Symbol(null,"active-retry-id_","active-retry-id_",1468292413,null),new cljs.core.Symbol(null,"ever-opened?_","ever-opened?_",-1013096856,null),new cljs.core.Symbol(null,"backoff-ms-fn","backoff-ms-fn",-1881539814,null),new cljs.core.Symbol(null,"ajax-opts","ajax-opts",1122292418,null),new cljs.core.Symbol(null,"curr-xhr_","curr-xhr_",321757831,null)], null);
});

taoensso.sente.ChAjaxSocket.cljs$lang$type = true;

taoensso.sente.ChAjaxSocket.cljs$lang$ctorPrSeq = (function (this__8213__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"taoensso.sente/ChAjaxSocket");
});

taoensso.sente.ChAjaxSocket.cljs$lang$ctorPrWriter = (function (this__8213__auto__,writer__8214__auto__){
return cljs.core._write.call(null,writer__8214__auto__,"taoensso.sente/ChAjaxSocket");
});

taoensso.sente.__GT_ChAjaxSocket = (function taoensso$sente$__GT_ChAjaxSocket(client_id,chs,params,packer,url,state_,active_retry_id_,ever_opened_QMARK__,backoff_ms_fn,ajax_opts,curr_xhr_){
return (new taoensso.sente.ChAjaxSocket(client_id,chs,params,packer,url,state_,active_retry_id_,ever_opened_QMARK__,backoff_ms_fn,ajax_opts,curr_xhr_,null,null,null));
});

taoensso.sente.map__GT_ChAjaxSocket = (function taoensso$sente$map__GT_ChAjaxSocket(G__47998){
return (new taoensso.sente.ChAjaxSocket(new cljs.core.Keyword(null,"client-id","client-id",-464622140).cljs$core$IFn$_invoke$arity$1(G__47998),new cljs.core.Keyword(null,"chs","chs",376886120).cljs$core$IFn$_invoke$arity$1(G__47998),new cljs.core.Keyword(null,"params","params",710516235).cljs$core$IFn$_invoke$arity$1(G__47998),new cljs.core.Keyword(null,"packer","packer",66077544).cljs$core$IFn$_invoke$arity$1(G__47998),new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(G__47998),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(G__47998),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114).cljs$core$IFn$_invoke$arity$1(G__47998),new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913).cljs$core$IFn$_invoke$arity$1(G__47998),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955).cljs$core$IFn$_invoke$arity$1(G__47998),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109).cljs$core$IFn$_invoke$arity$1(G__47998),new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696).cljs$core$IFn$_invoke$arity$1(G__47998),null,cljs.core.dissoc.call(null,G__47998,new cljs.core.Keyword(null,"client-id","client-id",-464622140),new cljs.core.Keyword(null,"chs","chs",376886120),new cljs.core.Keyword(null,"params","params",710516235),new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"url","url",276297046),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696)),null));
});

taoensso.sente.new_ChAjaxSocket = (function taoensso$sente$new_ChAjaxSocket(opts){
return taoensso.sente.map__GT_ChAjaxSocket.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"state_","state_",957667102),cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"ajax","ajax",814345549),new cljs.core.Keyword(null,"open?","open?",1238443125),false], null)),new cljs.core.Keyword(null,"active-retry-id_","active-retry-id_",-172239114),cljs.core.atom.call(null,"_pending"),new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913),cljs.core.atom.call(null,false),new cljs.core.Keyword(null,"curr-xhr_","curr-xhr_",-1318773696),cljs.core.atom.call(null,null)], null),opts));
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {taoensso.sente.IChSocket}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
taoensso.sente.ChAutoSocket = (function (ws_chsk_opts,ajax_chsk_opts,state_,impl_,__meta,__extmap,__hash){
this.ws_chsk_opts = ws_chsk_opts;
this.ajax_chsk_opts = ajax_chsk_opts;
this.state_ = state_;
this.impl_ = impl_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})

taoensso.sente.ChAutoSocket.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__8177__auto__,k__8178__auto__){
var self__ = this;
var this__8177__auto____$1 = this;
return this__8177__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__8178__auto__,null);
});


taoensso.sente.ChAutoSocket.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__8179__auto__,k48040,else__8180__auto__){
var self__ = this;
var this__8179__auto____$1 = this;
var G__48042 = (((k48040 instanceof cljs.core.Keyword))?k48040.fqn:null);
switch (G__48042) {
case "ws-chsk-opts":
return self__.ws_chsk_opts;

break;
case "ajax-chsk-opts":
return self__.ajax_chsk_opts;

break;
case "state_":
return self__.state_;

break;
case "impl_":
return self__.impl_;

break;
default:
return cljs.core.get.call(null,self__.__extmap,k48040,else__8180__auto__);

}
});


taoensso.sente.ChAutoSocket.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__8191__auto__,writer__8192__auto__,opts__8193__auto__){
var self__ = this;
var this__8191__auto____$1 = this;
var pr_pair__8194__auto__ = ((function (this__8191__auto____$1){
return (function (keyval__8195__auto__){
return cljs.core.pr_sequential_writer.call(null,writer__8192__auto__,cljs.core.pr_writer,""," ","",opts__8193__auto__,keyval__8195__auto__);
});})(this__8191__auto____$1))
;
return cljs.core.pr_sequential_writer.call(null,writer__8192__auto__,pr_pair__8194__auto__,"#taoensso.sente.ChAutoSocket{",", ","}",opts__8193__auto__,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ws-chsk-opts","ws-chsk-opts",-1990170104),self__.ws_chsk_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ajax-chsk-opts","ajax-chsk-opts",1602591327),self__.ajax_chsk_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"impl_","impl_",1218818179),self__.impl_],null))], null),self__.__extmap));
});


taoensso.sente.ChAutoSocket.prototype.cljs$core$IIterable$ = cljs.core.PROTOCOL_SENTINEL;


taoensso.sente.ChAutoSocket.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__48039){
var self__ = this;
var G__48039__$1 = this;
return (new cljs.core.RecordIter((0),G__48039__$1,4,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ws-chsk-opts","ws-chsk-opts",-1990170104),new cljs.core.Keyword(null,"ajax-chsk-opts","ajax-chsk-opts",1602591327),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"impl_","impl_",1218818179)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator.call(null,self__.__extmap):cljs.core.nil_iter.call(null))));
});


taoensso.sente.ChAutoSocket.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__8175__auto__){
var self__ = this;
var this__8175__auto____$1 = this;
return self__.__meta;
});


taoensso.sente.ChAutoSocket.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__8171__auto__){
var self__ = this;
var this__8171__auto____$1 = this;
return (new taoensso.sente.ChAutoSocket(self__.ws_chsk_opts,self__.ajax_chsk_opts,self__.state_,self__.impl_,self__.__meta,self__.__extmap,self__.__hash));
});


taoensso.sente.ChAutoSocket.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__8181__auto__){
var self__ = this;
var this__8181__auto____$1 = this;
return (4 + cljs.core.count.call(null,self__.__extmap));
});


taoensso.sente.ChAutoSocket.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__8172__auto__){
var self__ = this;
var this__8172__auto____$1 = this;
var h__7944__auto__ = self__.__hash;
if(!((h__7944__auto__ == null))){
return h__7944__auto__;
} else {
var h__7944__auto____$1 = cljs.core.hash_imap.call(null,this__8172__auto____$1);
self__.__hash = h__7944__auto____$1;

return h__7944__auto____$1;
}
});


taoensso.sente.ChAutoSocket.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__8173__auto__,other__8174__auto__){
var self__ = this;
var this__8173__auto____$1 = this;
if(cljs.core.truth_((function (){var and__7490__auto__ = other__8174__auto__;
if(cljs.core.truth_(and__7490__auto__)){
return ((this__8173__auto____$1.constructor === other__8174__auto__.constructor)) && (cljs.core.equiv_map.call(null,this__8173__auto____$1,other__8174__auto__));
} else {
return and__7490__auto__;
}
})())){
return true;
} else {
return false;
}
});


taoensso.sente.ChAutoSocket.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__8186__auto__,k__8187__auto__){
var self__ = this;
var this__8186__auto____$1 = this;
if(cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"impl_","impl_",1218818179),null,new cljs.core.Keyword(null,"ws-chsk-opts","ws-chsk-opts",-1990170104),null,new cljs.core.Keyword(null,"state_","state_",957667102),null,new cljs.core.Keyword(null,"ajax-chsk-opts","ajax-chsk-opts",1602591327),null], null), null),k__8187__auto__)){
return cljs.core.dissoc.call(null,cljs.core.with_meta.call(null,cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,this__8186__auto____$1),self__.__meta),k__8187__auto__);
} else {
return (new taoensso.sente.ChAutoSocket(self__.ws_chsk_opts,self__.ajax_chsk_opts,self__.state_,self__.impl_,self__.__meta,cljs.core.not_empty.call(null,cljs.core.dissoc.call(null,self__.__extmap,k__8187__auto__)),null));
}
});


taoensso.sente.ChAutoSocket.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__8184__auto__,k__8185__auto__,G__48039){
var self__ = this;
var this__8184__auto____$1 = this;
var pred__48043 = cljs.core.keyword_identical_QMARK_;
var expr__48044 = k__8185__auto__;
if(cljs.core.truth_(pred__48043.call(null,new cljs.core.Keyword(null,"ws-chsk-opts","ws-chsk-opts",-1990170104),expr__48044))){
return (new taoensso.sente.ChAutoSocket(G__48039,self__.ajax_chsk_opts,self__.state_,self__.impl_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48043.call(null,new cljs.core.Keyword(null,"ajax-chsk-opts","ajax-chsk-opts",1602591327),expr__48044))){
return (new taoensso.sente.ChAutoSocket(self__.ws_chsk_opts,G__48039,self__.state_,self__.impl_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48043.call(null,new cljs.core.Keyword(null,"state_","state_",957667102),expr__48044))){
return (new taoensso.sente.ChAutoSocket(self__.ws_chsk_opts,self__.ajax_chsk_opts,G__48039,self__.impl_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_(pred__48043.call(null,new cljs.core.Keyword(null,"impl_","impl_",1218818179),expr__48044))){
return (new taoensso.sente.ChAutoSocket(self__.ws_chsk_opts,self__.ajax_chsk_opts,self__.state_,G__48039,self__.__meta,self__.__extmap,null));
} else {
return (new taoensso.sente.ChAutoSocket(self__.ws_chsk_opts,self__.ajax_chsk_opts,self__.state_,self__.impl_,self__.__meta,cljs.core.assoc.call(null,self__.__extmap,k__8185__auto__,G__48039),null));
}
}
}
}
});


taoensso.sente.ChAutoSocket.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__8189__auto__){
var self__ = this;
var this__8189__auto____$1 = this;
return cljs.core.seq.call(null,cljs.core.concat.call(null,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ws-chsk-opts","ws-chsk-opts",-1990170104),self__.ws_chsk_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"ajax-chsk-opts","ajax-chsk-opts",1602591327),self__.ajax_chsk_opts],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"impl_","impl_",1218818179),self__.impl_],null))], null),self__.__extmap));
});


taoensso.sente.ChAutoSocket.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__8176__auto__,G__48039){
var self__ = this;
var this__8176__auto____$1 = this;
return (new taoensso.sente.ChAutoSocket(self__.ws_chsk_opts,self__.ajax_chsk_opts,self__.state_,self__.impl_,G__48039,self__.__extmap,self__.__hash));
});


taoensso.sente.ChAutoSocket.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__8182__auto__,entry__8183__auto__){
var self__ = this;
var this__8182__auto____$1 = this;
if(cljs.core.vector_QMARK_.call(null,entry__8183__auto__)){
return this__8182__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.call(null,entry__8183__auto__,(0)),cljs.core._nth.call(null,entry__8183__auto__,(1)));
} else {
return cljs.core.reduce.call(null,cljs.core._conj,this__8182__auto____$1,entry__8183__auto__);
}
});


taoensso.sente.ChAutoSocket.prototype.taoensso$sente$IChSocket$ = cljs.core.PROTOCOL_SENTINEL;


taoensso.sente.ChAutoSocket.prototype.taoensso$sente$IChSocket$_chsk_disconnect_BANG_$arity$2 = (function (chsk,reconn_QMARK_){
var self__ = this;
var chsk__$1 = this;
var temp__6753__auto__ = cljs.core.deref.call(null,self__.impl_);
if(cljs.core.truth_(temp__6753__auto__)){
var impl = temp__6753__auto__;
return taoensso.sente._chsk_disconnect_BANG_.call(null,impl,reconn_QMARK_);
} else {
return null;
}
});


taoensso.sente.ChAutoSocket.prototype.taoensso$sente$IChSocket$_chsk_reconnect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
var temp__6753__auto__ = cljs.core.deref.call(null,self__.impl_);
if(cljs.core.truth_(temp__6753__auto__)){
var impl = temp__6753__auto__;
taoensso.sente._chsk_disconnect_BANG_.call(null,impl,new cljs.core.Keyword(null,"reconn","reconn",-807347633));

return chsk__$1.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1(null);
} else {
return null;
}
});


taoensso.sente.ChAutoSocket.prototype.taoensso$sente$IChSocket$_chsk_send_BANG_$arity$3 = (function (chsk,ev,opts){
var self__ = this;
var chsk__$1 = this;
var temp__6751__auto__ = cljs.core.deref.call(null,self__.impl_);
if(cljs.core.truth_(temp__6751__auto__)){
var impl = temp__6751__auto__;
return taoensso.sente._chsk_send_BANG_.call(null,impl,ev,opts);
} else {
var map__48046 = opts;
var map__48046__$1 = ((((!((map__48046 == null)))?((((map__48046.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48046.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48046):map__48046);
var _QMARK_cb = cljs.core.get.call(null,map__48046__$1,new cljs.core.Keyword(null,"cb","cb",589947841));
var _QMARK_cb_fn = taoensso.sente.cb_chan_as_fn.call(null,_QMARK_cb,ev);
return taoensso.sente.chsk_send__GT_closed_BANG_.call(null,_QMARK_cb_fn);
}
});


taoensso.sente.ChAutoSocket.prototype.taoensso$sente$IChSocket$_chsk_connect_BANG_$arity$1 = (function (chsk){
var self__ = this;
var chsk__$1 = this;
var ajax_chsk_opts__$1 = cljs.core.assoc.call(null,self__.ajax_chsk_opts,new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_);
var ws_chsk_opts__$1 = cljs.core.assoc.call(null,self__.ws_chsk_opts,new cljs.core.Keyword(null,"state_","state_",957667102),self__.state_);
var ajax_conn_BANG_ = ((function (ajax_chsk_opts__$1,ws_chsk_opts__$1,chsk__$1){
return (function (){
cljs.core.remove_watch.call(null,self__.state_,new cljs.core.Keyword("chsk","auto-ajax-downgrade","chsk/auto-ajax-downgrade",-831528080));

return taoensso.sente._chsk_connect_BANG_.call(null,taoensso.sente.new_ChAjaxSocket.call(null,ajax_chsk_opts__$1));
});})(ajax_chsk_opts__$1,ws_chsk_opts__$1,chsk__$1))
;
var ws_conn_BANG_ = ((function (ajax_chsk_opts__$1,ws_chsk_opts__$1,ajax_conn_BANG_,chsk__$1){
return (function (){
var downgraded_QMARK___48049 = cljs.core.atom.call(null,false);
cljs.core.add_watch.call(null,self__.state_,new cljs.core.Keyword("chsk","auto-ajax-downgrade","chsk/auto-ajax-downgrade",-831528080),((function (downgraded_QMARK___48049,ajax_chsk_opts__$1,ws_chsk_opts__$1,ajax_conn_BANG_,chsk__$1){
return (function (_,___$1,old_state,new_state){
var temp__6753__auto__ = cljs.core.deref.call(null,self__.impl_);
if(cljs.core.truth_(temp__6753__auto__)){
var impl = temp__6753__auto__;
var temp__6753__auto____$1 = new cljs.core.Keyword(null,"ever-opened?_","ever-opened?_",1641338913).cljs$core$IFn$_invoke$arity$1(impl);
if(cljs.core.truth_(temp__6753__auto____$1)){
var ever_opened_QMARK__ = temp__6753__auto____$1;
if(cljs.core.truth_(cljs.core.deref.call(null,ever_opened_QMARK__))){
return null;
} else {
if(cljs.core.truth_(new cljs.core.Keyword(null,"last-error","last-error",1848699973).cljs$core$IFn$_invoke$arity$1(new_state))){
if(cljs.core.truth_(cljs.core.compare_and_set_BANG_.call(null,downgraded_QMARK___48049,false,true))){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",1304,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (ever_opened_QMARK__,temp__6753__auto____$1,impl,temp__6753__auto__,downgraded_QMARK___48049,ajax_chsk_opts__$1,ws_chsk_opts__$1,ajax_conn_BANG_,chsk__$1){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Permanently downgrading :auto chsk -> :ajax"], null);
});})(ever_opened_QMARK__,temp__6753__auto____$1,impl,temp__6753__auto__,downgraded_QMARK___48049,ajax_chsk_opts__$1,ws_chsk_opts__$1,ajax_conn_BANG_,chsk__$1))
,null)),null,-1197452758);

taoensso.sente._chsk_disconnect_BANG_.call(null,impl,false);

return cljs.core.reset_BANG_.call(null,self__.impl_,ajax_conn_BANG_.call(null));
} else {
return null;
}
} else {
return null;
}
}
} else {
return null;
}
} else {
return null;
}
});})(downgraded_QMARK___48049,ajax_chsk_opts__$1,ws_chsk_opts__$1,ajax_conn_BANG_,chsk__$1))
);

return taoensso.sente._chsk_connect_BANG_.call(null,taoensso.sente.new_ChWebSocket.call(null,ws_chsk_opts__$1));
});})(ajax_chsk_opts__$1,ws_chsk_opts__$1,ajax_conn_BANG_,chsk__$1))
;
cljs.core.reset_BANG_.call(null,self__.impl_,(function (){var or__7502__auto__ = ws_conn_BANG_.call(null);
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
return ajax_conn_BANG_.call(null);
}
})());

return chsk__$1;
});

taoensso.sente.ChAutoSocket.getBasis = (function (){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ws-chsk-opts","ws-chsk-opts",-349638577,null),new cljs.core.Symbol(null,"ajax-chsk-opts","ajax-chsk-opts",-1051844442,null),new cljs.core.Symbol(null,"state_","state_",-1696768667,null),new cljs.core.Symbol(null,"impl_","impl_",-1435617590,null)], null);
});

taoensso.sente.ChAutoSocket.cljs$lang$type = true;

taoensso.sente.ChAutoSocket.cljs$lang$ctorPrSeq = (function (this__8213__auto__){
return cljs.core._conj.call(null,cljs.core.List.EMPTY,"taoensso.sente/ChAutoSocket");
});

taoensso.sente.ChAutoSocket.cljs$lang$ctorPrWriter = (function (this__8213__auto__,writer__8214__auto__){
return cljs.core._write.call(null,writer__8214__auto__,"taoensso.sente/ChAutoSocket");
});

taoensso.sente.__GT_ChAutoSocket = (function taoensso$sente$__GT_ChAutoSocket(ws_chsk_opts,ajax_chsk_opts,state_,impl_){
return (new taoensso.sente.ChAutoSocket(ws_chsk_opts,ajax_chsk_opts,state_,impl_,null,null,null));
});

taoensso.sente.map__GT_ChAutoSocket = (function taoensso$sente$map__GT_ChAutoSocket(G__48041){
return (new taoensso.sente.ChAutoSocket(new cljs.core.Keyword(null,"ws-chsk-opts","ws-chsk-opts",-1990170104).cljs$core$IFn$_invoke$arity$1(G__48041),new cljs.core.Keyword(null,"ajax-chsk-opts","ajax-chsk-opts",1602591327).cljs$core$IFn$_invoke$arity$1(G__48041),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(G__48041),new cljs.core.Keyword(null,"impl_","impl_",1218818179).cljs$core$IFn$_invoke$arity$1(G__48041),null,cljs.core.dissoc.call(null,G__48041,new cljs.core.Keyword(null,"ws-chsk-opts","ws-chsk-opts",-1990170104),new cljs.core.Keyword(null,"ajax-chsk-opts","ajax-chsk-opts",1602591327),new cljs.core.Keyword(null,"state_","state_",957667102),new cljs.core.Keyword(null,"impl_","impl_",1218818179)),null));
});

taoensso.sente.new_ChAutoSocket = (function taoensso$sente$new_ChAutoSocket(opts){
return taoensso.sente.map__GT_ChAutoSocket.call(null,cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"state_","state_",957667102),cljs.core.atom.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"auto","auto",-566279492),new cljs.core.Keyword(null,"open?","open?",1238443125),false], null)),new cljs.core.Keyword(null,"impl_","impl_",1218818179),cljs.core.atom.call(null,null)], null),opts));
});
taoensso.sente.get_chsk_url = (function taoensso$sente$get_chsk_url(protocol,host,path,type){
var protocol__$1 = (function (){var G__48054 = (((protocol instanceof cljs.core.Keyword))?protocol.fqn:null);
switch (G__48054) {
case "http":
return "http:";

break;
case "https":
return "https:";

break;
default:
return protocol;

}
})();
var protocol__$2 = (function (){var e = (function (){try{if(((function (protocol__$1){
return (function (x){
return cljs.core.contains_QMARK_.call(null,taoensso.truss.impl.set_STAR_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["https:",null,"http:",null], null), null)),x);
});})(protocol__$1))
.call(null,protocol__$1)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e48055){if((e48055 instanceof Error)){
var e = e48055;
return e;
} else {
throw e48055;

}
}})();
if((e == null)){
return protocol__$1;
} else {
return taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",1324,"([:el #{\"https:\" \"http:\"}] protocol)",protocol__$1,e,null);
}
})();
var protocol__$3 = (function (){var G__48056 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__48056) {
case "ajax":
return protocol__$2;

break;
case "ws":
var G__48057 = protocol__$2;
switch (G__48057) {
case "https:":
return "wss:";

break;
case "http:":
return "ws:";

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol__$2)].join('')));

}

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}
})();
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol__$3),cljs.core.str.cljs$core$IFn$_invoke$arity$1("//"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(taoensso.encore.path.call(null,host,path))].join('');
});
/**
 * Returns nil on failure, or a map with keys:
 *     :ch-recv ; core.async channel to receive `event-msg`s (internal or from
 *              ; clients). May `put!` (inject) arbitrary `event`s to this channel.
 *     :send-fn ; (fn [event & [?timeout-ms ?cb-fn]]) for client>server send.
 *     :state   ; Watchable, read-only (atom {:type _ :open? _ :uid _ :csrf-token _}).
 *     :chsk    ; IChSocket implementer. You can usu. ignore this.
 * 
 *   Common options:
 *     :type           ; e/o #{:auto :ws :ajax}. You'll usually want the default (:auto).
 *     :protocol       ; Server protocol, e/o #{:http :https}.
 *     :host           ; Server host (defaults to current page's host).
 *     :params         ; Map of any params to incl. in chsk Ring requests (handy
 *                     ; for application-level auth, etc.).
 *     :packer         ; :edn (default), or an IPacker implementation.
 *     :ajax-opts      ; Base opts map provided to `taoensso.encore/ajax-lite`.
 *     :wrap-recv-evs? ; Should events from server be wrapped in [:chsk/recv _]?
 */
taoensso.sente.make_channel_socket_client_BANG_ = (function taoensso$sente$make_channel_socket_client_BANG_(var_args){
var args__8730__auto__ = [];
var len__8723__auto___48078 = arguments.length;
var i__8724__auto___48079 = (0);
while(true){
if((i__8724__auto___48079 < len__8723__auto___48078)){
args__8730__auto__.push((arguments[i__8724__auto___48079]));

var G__48080 = (i__8724__auto___48079 + (1));
i__8724__auto___48079 = G__48080;
continue;
} else {
}
break;
}

var argseq__8731__auto__ = ((((1) < args__8730__auto__.length))?(new cljs.core.IndexedSeq(args__8730__auto__.slice((1)),(0),null)):null);
return taoensso.sente.make_channel_socket_client_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__8731__auto__);
});

taoensso.sente.make_channel_socket_client_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (path,p__48063){
var vec__48064 = p__48063;
var map__48067 = cljs.core.nth.call(null,vec__48064,(0),null);
var map__48067__$1 = ((((!((map__48067 == null)))?((((map__48067.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48067.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48067):map__48067);
var opts = map__48067__$1;
var ajax_opts = cljs.core.get.call(null,map__48067__$1,new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109));
var client_id = cljs.core.get.call(null,map__48067__$1,new cljs.core.Keyword(null,"client-id","client-id",-464622140),(function (){var or__7502__auto__ = new cljs.core.Keyword(null,"client-uuid","client-uuid",-1717531965).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
return taoensso.encore.uuid_str.call(null);
}
})());
var protocol = cljs.core.get.call(null,map__48067__$1,new cljs.core.Keyword(null,"protocol","protocol",652470118));
var packer = cljs.core.get.call(null,map__48067__$1,new cljs.core.Keyword(null,"packer","packer",66077544),new cljs.core.Keyword(null,"edn","edn",1317840885));
var params = cljs.core.get.call(null,map__48067__$1,new cljs.core.Keyword(null,"params","params",710516235));
var type = cljs.core.get.call(null,map__48067__$1,new cljs.core.Keyword(null,"type","type",1174270348),new cljs.core.Keyword(null,"auto","auto",-566279492));
var host = cljs.core.get.call(null,map__48067__$1,new cljs.core.Keyword(null,"host","host",-1558485167));
var recv_buf_or_n = cljs.core.get.call(null,map__48067__$1,new cljs.core.Keyword(null,"recv-buf-or-n","recv-buf-or-n",1363950355),cljs.core.async.sliding_buffer.call(null,(2048)));
var backoff_ms_fn = cljs.core.get.call(null,map__48067__$1,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),taoensso.encore.exp_backoff);
var wrap_recv_evs_QMARK_ = cljs.core.get.call(null,map__48067__$1,new cljs.core.Keyword(null,"wrap-recv-evs?","wrap-recv-evs?",-1996694153),true);
var _deprecated_more_opts = cljs.core.nth.call(null,vec__48064,(1),null);
var e_48081 = (function (){try{if(((function (vec__48064,map__48067,map__48067__$1,opts,ajax_opts,client_id,protocol,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (x){
return cljs.core.contains_QMARK_.call(null,taoensso.truss.impl.set_STAR_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"ws","ws",86841443),null,new cljs.core.Keyword(null,"ajax","ajax",814345549),null,new cljs.core.Keyword(null,"auto","auto",-566279492),null], null), null)),x);
});})(vec__48064,map__48067,map__48067__$1,opts,ajax_opts,client_id,protocol,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
.call(null,type)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e48069){if((e48069 instanceof Error)){
var e = e48069;
return e;
} else {
throw e48069;

}
}})();
if((e_48081 == null)){
} else {
taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",1363,"([:in #{:ws :ajax :auto}] type)",type,e_48081,null);
}

var e_48082 = (function (){try{if(taoensso.encore.nblank_str_QMARK_.call(null,client_id)){
return null;
} else {
return taoensso.truss.impl._dummy_error;
}
}catch (e48070){if((e48070 instanceof Error)){
var e = e48070;
return e;
} else {
throw e48070;

}
}})();
if((e_48082 == null)){
} else {
taoensso.truss.impl._invar_violation_BANG_.call(null,true,"taoensso.sente",1364,"(enc/nblank-str? client-id)",client_id,e_48082,null);
}

if(!((_deprecated_more_opts == null))){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",1366,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__48064,map__48067,map__48067__$1,opts,ajax_opts,client_id,protocol,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["`make-channel-socket-client!` fn signature CHANGED with Sente v0.10.0."], null);
});})(vec__48064,map__48067,map__48067__$1,opts,ajax_opts,client_id,protocol,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,null)),null,1172558870);
} else {
}

if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"lp-timeout","lp-timeout",1149461302))){
taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",1367,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (vec__48064,map__48067,map__48067__$1,opts,ajax_opts,client_id,protocol,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [":lp-timeout opt has CHANGED; please use :lp-timout-ms."], null);
});})(vec__48064,map__48067,map__48067__$1,opts,ajax_opts,client_id,protocol,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,null)),null,-1504051119);
} else {
}

var packer__$1 = taoensso.sente.coerce_packer.call(null,packer);
var vec__48071 = (function (){var win_loc = taoensso.encore.get_win_loc.call(null);
var path__$1 = (function (){var or__7502__auto__ = path;
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
return new cljs.core.Keyword(null,"pathname","pathname",-1420497528).cljs$core$IFn$_invoke$arity$1(win_loc);
}
})();
var temp__6751__auto__ = new cljs.core.Keyword(null,"chsk-url-fn","chsk-url-fn",1968894294).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__6751__auto__)){
var f = temp__6751__auto__;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.call(null,path__$1,win_loc,new cljs.core.Keyword(null,"ws","ws",86841443)),f.call(null,path__$1,win_loc,new cljs.core.Keyword(null,"ajax","ajax",814345549))], null);
} else {
var protocol__$1 = (function (){var or__7502__auto__ = protocol;
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
return new cljs.core.Keyword(null,"protocol","protocol",652470118).cljs$core$IFn$_invoke$arity$1(win_loc);
}
})();
var host__$1 = (function (){var or__7502__auto__ = host;
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
return new cljs.core.Keyword(null,"host","host",-1558485167).cljs$core$IFn$_invoke$arity$1(win_loc);
}
})();
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [taoensso.sente.get_chsk_url.call(null,protocol__$1,host__$1,path__$1,new cljs.core.Keyword(null,"ws","ws",86841443)),taoensso.sente.get_chsk_url.call(null,protocol__$1,host__$1,path__$1,new cljs.core.Keyword(null,"ajax","ajax",814345549))], null);
}
})();
var ws_url = cljs.core.nth.call(null,vec__48071,(0),null);
var ajax_url = cljs.core.nth.call(null,vec__48071,(1),null);
var private_chs = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"internal","internal",-854870097),cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(128))),new cljs.core.Keyword(null,"state","state",-1988618099),cljs.core.async.chan.call(null,cljs.core.async.sliding_buffer.call(null,(10))),new cljs.core.Keyword(null,"<server","<server",-2135373537),(function (){var buf = cljs.core.async.sliding_buffer.call(null,(512));
if(cljs.core.truth_(wrap_recv_evs_QMARK_)){
return cljs.core.async.chan.call(null,buf,cljs.core.map.call(null,((function (buf,packer__$1,vec__48071,ws_url,ajax_url,vec__48064,map__48067,map__48067__$1,opts,ajax_opts,client_id,protocol,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (ev){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword("chsk","recv","chsk/recv",561097091),ev], null);
});})(buf,packer__$1,vec__48071,ws_url,ajax_url,vec__48064,map__48067,map__48067__$1,opts,ajax_opts,client_id,protocol,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
));
} else {
return cljs.core.async.chan.call(null,buf);
}
})()], null);
var common_chsk_opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"client-id","client-id",-464622140),client_id,new cljs.core.Keyword(null,"chs","chs",376886120),private_chs,new cljs.core.Keyword(null,"params","params",710516235),params,new cljs.core.Keyword(null,"packer","packer",66077544),packer__$1], null);
var ws_chsk_opts = cljs.core.merge.call(null,common_chsk_opts,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),ws_url,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),backoff_ms_fn], null));
var ajax_chsk_opts = cljs.core.merge.call(null,common_chsk_opts,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"url","url",276297046),ajax_url,new cljs.core.Keyword(null,"ajax-opts","ajax-opts",-518239109),ajax_opts,new cljs.core.Keyword(null,"backoff-ms-fn","backoff-ms-fn",772895955),backoff_ms_fn], null));
var auto_chsk_opts = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"ws-chsk-opts","ws-chsk-opts",-1990170104),ws_chsk_opts,new cljs.core.Keyword(null,"ajax-chsk-opts","ajax-chsk-opts",1602591327),ajax_chsk_opts], null);
var _QMARK_chsk = taoensso.sente._chsk_connect_BANG_.call(null,(function (){var G__48074 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__48074) {
case "ws":
return taoensso.sente.new_ChWebSocket.call(null,ws_chsk_opts);

break;
case "ajax":
return taoensso.sente.new_ChAjaxSocket.call(null,ajax_chsk_opts);

break;
case "auto":
return taoensso.sente.new_ChAutoSocket.call(null,auto_chsk_opts);

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}
})());
var temp__6751__auto__ = _QMARK_chsk;
if(cljs.core.truth_(temp__6751__auto__)){
var chsk = temp__6751__auto__;
var chsk_state_ = new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(chsk);
var internal_ch = new cljs.core.Keyword(null,"internal","internal",-854870097).cljs$core$IFn$_invoke$arity$1(private_chs);
var send_fn = cljs.core.partial.call(null,taoensso.sente.chsk_send_BANG_,chsk);
var ev_ch = cljs.core.async.merge.call(null,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"internal","internal",-854870097).cljs$core$IFn$_invoke$arity$1(private_chs),new cljs.core.Keyword(null,"state","state",-1988618099).cljs$core$IFn$_invoke$arity$1(private_chs),new cljs.core.Keyword(null,"<server","<server",-2135373537).cljs$core$IFn$_invoke$arity$1(private_chs)], null),recv_buf_or_n);
var ev_msg_ch = cljs.core.async.chan.call(null,(1),cljs.core.map.call(null,((function (chsk_state_,internal_ch,send_fn,ev_ch,chsk,temp__6751__auto__,packer__$1,vec__48071,ws_url,ajax_url,private_chs,common_chsk_opts,ws_chsk_opts,ajax_chsk_opts,auto_chsk_opts,_QMARK_chsk,vec__48064,map__48067,map__48067__$1,opts,ajax_opts,client_id,protocol,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (ev){
var vec__48075 = taoensso.sente.as_event.call(null,ev);
var ev_id = cljs.core.nth.call(null,vec__48075,(0),null);
var ev__QMARK_data = cljs.core.nth.call(null,vec__48075,(1),null);
var ev__$1 = vec__48075;
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),internal_ch,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"state","state",-1988618099),chsk_state_,new cljs.core.Keyword(null,"event","event",301435442),ev__$1,new cljs.core.Keyword(null,"id","id",-1388402092),ev_id,new cljs.core.Keyword(null,"?data","?data",-9471433),ev__QMARK_data], null);
});})(chsk_state_,internal_ch,send_fn,ev_ch,chsk,temp__6751__auto__,packer__$1,vec__48071,ws_url,ajax_url,private_chs,common_chsk_opts,ws_chsk_opts,ajax_chsk_opts,auto_chsk_opts,_QMARK_chsk,vec__48064,map__48067,map__48067__$1,opts,ajax_opts,client_id,protocol,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
));
cljs.core.async.pipe.call(null,ev_ch,ev_msg_ch);

return new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"chsk","chsk",-863703081),chsk,new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861),ev_msg_ch,new cljs.core.Keyword(null,"send-fn","send-fn",351002041),send_fn,new cljs.core.Keyword(null,"state","state",-1988618099),new cljs.core.Keyword(null,"state_","state_",957667102).cljs$core$IFn$_invoke$arity$1(chsk)], null);
} else {
return taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"warn","warn",-436710552),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",1454,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),(new cljs.core.Delay(((function (temp__6751__auto__,packer__$1,vec__48071,ws_url,ajax_url,private_chs,common_chsk_opts,ws_chsk_opts,ajax_chsk_opts,auto_chsk_opts,_QMARK_chsk,vec__48064,map__48067,map__48067__$1,opts,ajax_opts,client_id,protocol,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts){
return (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Failed to create channel socket"], null);
});})(temp__6751__auto__,packer__$1,vec__48071,ws_url,ajax_url,private_chs,common_chsk_opts,ws_chsk_opts,ajax_chsk_opts,auto_chsk_opts,_QMARK_chsk,vec__48064,map__48067,map__48067__$1,opts,ajax_opts,client_id,protocol,packer,params,type,host,recv_buf_or_n,backoff_ms_fn,wrap_recv_evs_QMARK_,_deprecated_more_opts))
,null)),null,-1076320195);
}
});

taoensso.sente.make_channel_socket_client_BANG_.cljs$lang$maxFixedArity = (1);

taoensso.sente.make_channel_socket_client_BANG_.cljs$lang$applyTo = (function (seq48061){
var G__48062 = cljs.core.first.call(null,seq48061);
var seq48061__$1 = cljs.core.next.call(null,seq48061);
return taoensso.sente.make_channel_socket_client_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__48062,seq48061__$1);
});

taoensso.sente._start_chsk_router_BANG_ = (function taoensso$sente$_start_chsk_router_BANG_(server_QMARK_,ch_recv,event_msg_handler,opts){
var map__48272 = opts;
var map__48272__$1 = ((((!((map__48272 == null)))?((((map__48272.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48272.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48272):map__48272);
var trace_evs_QMARK_ = cljs.core.get.call(null,map__48272__$1,new cljs.core.Keyword(null,"trace-evs?","trace-evs?",1502453512));
var error_handler = cljs.core.get.call(null,map__48272__$1,new cljs.core.Keyword(null,"error-handler","error-handler",-484945776));
var ch_ctrl = cljs.core.async.chan.call(null);
var c__42603__auto___48460 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__42603__auto___48460,map__48272,map__48272__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (){
var f__42604__auto__ = (function (){var switch__42489__auto__ = ((function (c__42603__auto___48460,map__48272,map__48272__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (state_48386){
var state_val_48387 = (state_48386[(1)]);
if((state_val_48387 === (7))){
var inst_48382 = (state_48386[(2)]);
var state_48386__$1 = state_48386;
var statearr_48388_48461 = state_48386__$1;
(statearr_48388_48461[(2)] = inst_48382);

(statearr_48388_48461[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (20))){
var inst_48309 = (state_48386[(7)]);
var inst_48282 = (state_48386[(8)]);
var inst_48284 = (state_48386[(9)]);
var inst_48311 = (state_48386[(10)]);
var inst_48285 = (state_48386[(11)]);
var inst_48283 = (state_48386[(12)]);
var inst_48310 = (state_48386[(13)]);
var inst_48312 = (state_48386[(2)]);
var inst_48313 = (function (){var vec__48275 = inst_48282;
var v = inst_48283;
var p = inst_48284;
var stop_QMARK_ = inst_48285;
var map__48288 = inst_48309;
var event_msg = inst_48309;
var event = inst_48310;
var e1 = inst_48311;
var e2 = inst_48312;
return ((function (vec__48275,v,p,stop_QMARK_,map__48288,event_msg,event,e1,e2,inst_48309,inst_48282,inst_48284,inst_48311,inst_48285,inst_48283,inst_48310,inst_48312,state_val_48387,c__42603__auto___48460,map__48272,map__48272__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [e2,"Chsk router `error-handler` error: %s",event], null);
});
;})(vec__48275,v,p,stop_QMARK_,map__48288,event_msg,event,e1,e2,inst_48309,inst_48282,inst_48284,inst_48311,inst_48285,inst_48283,inst_48310,inst_48312,state_val_48387,c__42603__auto___48460,map__48272,map__48272__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
})();
var inst_48314 = (new cljs.core.Delay(inst_48313,null));
var inst_48315 = taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",1482,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_48314,null,86600440);
var state_48386__$1 = state_48386;
var statearr_48389_48462 = state_48386__$1;
(statearr_48389_48462[(2)] = inst_48315);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48386__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (27))){
var state_48386__$1 = state_48386;
var statearr_48390_48463 = state_48386__$1;
(statearr_48390_48463[(2)] = null);

(statearr_48390_48463[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (1))){
var state_48386__$1 = state_48386;
var statearr_48391_48464 = state_48386__$1;
(statearr_48391_48464[(2)] = null);

(statearr_48391_48464[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (24))){
var inst_48326 = (state_48386[(2)]);
var state_48386__$1 = state_48386;
var statearr_48392_48465 = state_48386__$1;
(statearr_48392_48465[(2)] = inst_48326);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48386__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (39))){
var inst_48309 = (state_48386[(7)]);
var inst_48350 = (state_48386[(14)]);
var inst_48354 = taoensso.truss.impl._invar_violation_BANG_.call(null,null,"taoensso.sente",1475,"(server-event-msg? event-msg)",inst_48309,inst_48350,null);
var state_48386__$1 = state_48386;
var statearr_48393_48466 = state_48386__$1;
(statearr_48393_48466[(2)] = inst_48354);

(statearr_48393_48466[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (46))){
var inst_48366 = (state_48386[(2)]);
var state_48386__$1 = state_48386;
var statearr_48394_48467 = state_48386__$1;
(statearr_48394_48467[(2)] = inst_48366);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48386__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (4))){
var inst_48282 = (state_48386[(8)]);
var inst_48284 = (state_48386[(9)]);
var inst_48285 = (state_48386[(11)]);
var inst_48282__$1 = (state_48386[(2)]);
var inst_48283 = cljs.core.nth.call(null,inst_48282__$1,(0),null);
var inst_48284__$1 = cljs.core.nth.call(null,inst_48282__$1,(1),null);
var inst_48285__$1 = cljs.core._EQ_.call(null,inst_48284__$1,ch_ctrl);
var state_48386__$1 = (function (){var statearr_48395 = state_48386;
(statearr_48395[(8)] = inst_48282__$1);

(statearr_48395[(9)] = inst_48284__$1);

(statearr_48395[(11)] = inst_48285__$1);

(statearr_48395[(12)] = inst_48283);

return statearr_48395;
})();
if(inst_48285__$1){
var statearr_48396_48468 = state_48386__$1;
(statearr_48396_48468[(1)] = (5));

} else {
var statearr_48397_48469 = state_48386__$1;
(statearr_48397_48469[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (15))){
var inst_48283 = (state_48386[(12)]);
var state_48386__$1 = state_48386;
var statearr_48398_48470 = state_48386__$1;
(statearr_48398_48470[(2)] = inst_48283);

(statearr_48398_48470[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (48))){
var inst_48309 = (state_48386[(7)]);
var inst_48368 = (state_48386[(15)]);
var inst_48372 = taoensso.truss.impl._invar_violation_BANG_.call(null,null,"taoensso.sente",1476,"(client-event-msg? event-msg)",inst_48309,inst_48368,null);
var state_48386__$1 = state_48386;
var statearr_48399_48471 = state_48386__$1;
(statearr_48399_48471[(2)] = inst_48372);

(statearr_48399_48471[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (21))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_48386,(20),Error,null,(19));
var state_48386__$1 = state_48386;
if(cljs.core.truth_(error_handler)){
var statearr_48400_48472 = state_48386__$1;
(statearr_48400_48472[(1)] = (22));

} else {
var statearr_48401_48473 = state_48386__$1;
(statearr_48401_48473[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (31))){
var inst_48376 = (state_48386[(2)]);
var inst_48377 = event_msg_handler.call(null,inst_48376);
var state_48386__$1 = state_48386;
var statearr_48402_48474 = state_48386__$1;
(statearr_48402_48474[(2)] = inst_48377);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48386__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (32))){
var inst_48350 = (state_48386[(14)]);
var inst_48350__$1 = (state_48386[(2)]);
var inst_48351 = (inst_48350__$1 == null);
var state_48386__$1 = (function (){var statearr_48403 = state_48386;
(statearr_48403[(14)] = inst_48350__$1);

return statearr_48403;
})();
if(cljs.core.truth_(inst_48351)){
var statearr_48404_48475 = state_48386__$1;
(statearr_48404_48475[(1)] = (38));

} else {
var statearr_48405_48476 = state_48386__$1;
(statearr_48405_48476[(1)] = (39));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (40))){
var inst_48356 = (state_48386[(2)]);
var state_48386__$1 = state_48386;
var statearr_48406_48477 = state_48386__$1;
(statearr_48406_48477[(2)] = inst_48356);

(statearr_48406_48477[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (33))){
var inst_48340 = (state_48386[(2)]);
var state_48386__$1 = state_48386;
var statearr_48407_48478 = state_48386__$1;
(statearr_48407_48478[(2)] = inst_48340);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48386__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (13))){
var inst_48301 = (state_48386[(2)]);
var state_48386__$1 = state_48386;
var statearr_48408_48479 = state_48386__$1;
(statearr_48408_48479[(2)] = inst_48301);

(statearr_48408_48479[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (22))){
var inst_48309 = (state_48386[(7)]);
var inst_48311 = (state_48386[(10)]);
var inst_48320 = error_handler.call(null,inst_48311,inst_48309);
var state_48386__$1 = state_48386;
var statearr_48409_48480 = state_48386__$1;
(statearr_48409_48480[(2)] = inst_48320);

(statearr_48409_48480[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (36))){
var state_48386__$1 = state_48386;
var statearr_48410_48481 = state_48386__$1;
(statearr_48410_48481[(2)] = taoensso.truss.impl._dummy_error);

(statearr_48410_48481[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (41))){
var inst_48368 = (state_48386[(15)]);
var inst_48368__$1 = (state_48386[(2)]);
var inst_48369 = (inst_48368__$1 == null);
var state_48386__$1 = (function (){var statearr_48411 = state_48386;
(statearr_48411[(15)] = inst_48368__$1);

return statearr_48411;
})();
if(cljs.core.truth_(inst_48369)){
var statearr_48412_48482 = state_48386__$1;
(statearr_48412_48482[(1)] = (47));

} else {
var statearr_48413_48483 = state_48386__$1;
(statearr_48413_48483[(1)] = (48));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (43))){
var inst_48309 = (state_48386[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_48386,(42),Error,null,(41));
var inst_48362 = taoensso.sente.client_event_msg_QMARK_.call(null,inst_48309);
var state_48386__$1 = state_48386;
if(cljs.core.truth_(inst_48362)){
var statearr_48414_48484 = state_48386__$1;
(statearr_48414_48484[(1)] = (44));

} else {
var statearr_48415_48485 = state_48386__$1;
(statearr_48415_48485[(1)] = (45));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (29))){
var state_48386__$1 = state_48386;
var statearr_48416_48486 = state_48386__$1;
(statearr_48416_48486[(2)] = null);

(statearr_48416_48486[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (44))){
var state_48386__$1 = state_48386;
var statearr_48417_48487 = state_48386__$1;
(statearr_48417_48487[(2)] = null);

(statearr_48417_48487[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (6))){
var inst_48283 = (state_48386[(12)]);
var inst_48290 = (inst_48283 == null);
var inst_48291 = cljs.core.not.call(null,inst_48290);
var state_48386__$1 = state_48386;
if(inst_48291){
var statearr_48418_48488 = state_48386__$1;
(statearr_48418_48488[(1)] = (8));

} else {
var statearr_48419_48489 = state_48386__$1;
(statearr_48419_48489[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (28))){
var inst_48338 = (state_48386[(2)]);
var state_48386__$1 = (function (){var statearr_48420 = state_48386;
(statearr_48420[(16)] = inst_48338);

return statearr_48420;
})();
if(cljs.core.truth_(server_QMARK_)){
var statearr_48421_48490 = state_48386__$1;
(statearr_48421_48490[(1)] = (29));

} else {
var statearr_48422_48491 = state_48386__$1;
(statearr_48422_48491[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (25))){
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_48386,(18),Error,null,(17));
var state_48386__$1 = state_48386;
if(cljs.core.truth_(trace_evs_QMARK_)){
var statearr_48423_48492 = state_48386__$1;
(statearr_48423_48492[(1)] = (26));

} else {
var statearr_48424_48493 = state_48386__$1;
(statearr_48424_48493[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (34))){
var inst_48309 = (state_48386[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_48386,(33),Error,null,(32));
var inst_48344 = taoensso.sente.server_event_msg_QMARK_.call(null,inst_48309);
var state_48386__$1 = state_48386;
if(cljs.core.truth_(inst_48344)){
var statearr_48425_48494 = state_48386__$1;
(statearr_48425_48494[(1)] = (35));

} else {
var statearr_48426_48495 = state_48386__$1;
(statearr_48426_48495[(1)] = (36));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (17))){
var inst_48379 = (state_48386[(2)]);
var state_48386__$1 = (function (){var statearr_48427 = state_48386;
(statearr_48427[(17)] = inst_48379);

return statearr_48427;
})();
var statearr_48428_48496 = state_48386__$1;
(statearr_48428_48496[(2)] = null);

(statearr_48428_48496[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (3))){
var inst_48384 = (state_48386[(2)]);
var state_48386__$1 = state_48386;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_48386__$1,inst_48384);
} else {
if((state_val_48387 === (12))){
var state_48386__$1 = state_48386;
var statearr_48429_48497 = state_48386__$1;
(statearr_48429_48497[(2)] = false);

(statearr_48429_48497[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (2))){
var inst_48278 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_48279 = [ch_recv,ch_ctrl];
var inst_48280 = (new cljs.core.PersistentVector(null,2,(5),inst_48278,inst_48279,null));
var state_48386__$1 = state_48386;
return cljs.core.async.ioc_alts_BANG_.call(null,state_48386__$1,(4),inst_48280);
} else {
if((state_val_48387 === (23))){
var inst_48309 = (state_48386[(7)]);
var inst_48282 = (state_48386[(8)]);
var inst_48284 = (state_48386[(9)]);
var inst_48311 = (state_48386[(10)]);
var inst_48285 = (state_48386[(11)]);
var inst_48283 = (state_48386[(12)]);
var inst_48310 = (state_48386[(13)]);
var inst_48322 = (function (){var vec__48275 = inst_48282;
var v = inst_48283;
var p = inst_48284;
var stop_QMARK_ = inst_48285;
var map__48288 = inst_48309;
var event_msg = inst_48309;
var event = inst_48310;
var e1 = inst_48311;
var temp__6751__auto__ = error_handler;
return ((function (vec__48275,v,p,stop_QMARK_,map__48288,event_msg,event,e1,temp__6751__auto__,inst_48309,inst_48282,inst_48284,inst_48311,inst_48285,inst_48283,inst_48310,state_val_48387,c__42603__auto___48460,map__48272,map__48272__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [e1,"Chsk router `event-msg-handler` error: %s",event], null);
});
;})(vec__48275,v,p,stop_QMARK_,map__48288,event_msg,event,e1,temp__6751__auto__,inst_48309,inst_48282,inst_48284,inst_48311,inst_48285,inst_48283,inst_48310,state_val_48387,c__42603__auto___48460,map__48272,map__48272__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
})();
var inst_48323 = (new cljs.core.Delay(inst_48322,null));
var inst_48324 = taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"error","error",-978969032),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",1481,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_48323,null,-1513505291);
var state_48386__$1 = state_48386;
var statearr_48430_48498 = state_48386__$1;
(statearr_48430_48498[(2)] = inst_48324);

(statearr_48430_48498[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (47))){
var inst_48309 = (state_48386[(7)]);
var state_48386__$1 = state_48386;
var statearr_48431_48499 = state_48386__$1;
(statearr_48431_48499[(2)] = inst_48309);

(statearr_48431_48499[(1)] = (49));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (35))){
var state_48386__$1 = state_48386;
var statearr_48432_48500 = state_48386__$1;
(statearr_48432_48500[(2)] = null);

(statearr_48432_48500[(1)] = (37));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (19))){
var inst_48328 = (state_48386[(2)]);
var state_48386__$1 = state_48386;
var statearr_48433_48501 = state_48386__$1;
(statearr_48433_48501[(2)] = inst_48328);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48386__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (11))){
var state_48386__$1 = state_48386;
var statearr_48434_48502 = state_48386__$1;
(statearr_48434_48502[(2)] = true);

(statearr_48434_48502[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (9))){
var state_48386__$1 = state_48386;
var statearr_48435_48503 = state_48386__$1;
(statearr_48435_48503[(2)] = false);

(statearr_48435_48503[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (5))){
var state_48386__$1 = state_48386;
var statearr_48436_48504 = state_48386__$1;
(statearr_48436_48504[(2)] = null);

(statearr_48436_48504[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (14))){
var inst_48283 = (state_48386[(12)]);
var inst_48306 = cljs.core.apply.call(null,cljs.core.hash_map,inst_48283);
var state_48386__$1 = state_48386;
var statearr_48437_48505 = state_48386__$1;
(statearr_48437_48505[(2)] = inst_48306);

(statearr_48437_48505[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (45))){
var state_48386__$1 = state_48386;
var statearr_48438_48506 = state_48386__$1;
(statearr_48438_48506[(2)] = taoensso.truss.impl._dummy_error);

(statearr_48438_48506[(1)] = (46));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (26))){
var inst_48309 = (state_48386[(7)]);
var inst_48282 = (state_48386[(8)]);
var inst_48284 = (state_48386[(9)]);
var inst_48285 = (state_48386[(11)]);
var inst_48283 = (state_48386[(12)]);
var inst_48310 = (state_48386[(13)]);
var inst_48333 = (function (){var vec__48275 = inst_48282;
var v = inst_48283;
var p = inst_48284;
var stop_QMARK_ = inst_48285;
var map__48288 = inst_48309;
var event_msg = inst_48309;
var event = inst_48310;
return ((function (vec__48275,v,p,stop_QMARK_,map__48288,event_msg,event,inst_48309,inst_48282,inst_48284,inst_48285,inst_48283,inst_48310,state_val_48387,c__42603__auto___48460,map__48272,map__48272__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["Pre-handler event: %s",event], null);
});
;})(vec__48275,v,p,stop_QMARK_,map__48288,event_msg,event,inst_48309,inst_48282,inst_48284,inst_48285,inst_48283,inst_48310,state_val_48387,c__42603__auto___48460,map__48272,map__48272__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
})();
var inst_48334 = (new cljs.core.Delay(inst_48333,null));
var inst_48335 = taoensso.timbre._log_BANG_.call(null,taoensso.timbre._STAR_config_STAR_,new cljs.core.Keyword(null,"trace","trace",-1082747415),"taoensso.sente","/private/var/folders/2t/fpmjn4650xb4b4pjtsl39ry00000gp/T/form-init9065621590771689793.clj",1472,new cljs.core.Keyword(null,"f","f",-1597136552),new cljs.core.Keyword(null,"auto","auto",-566279492),inst_48334,null,-1570384680);
var state_48386__$1 = state_48386;
var statearr_48439_48507 = state_48386__$1;
(statearr_48439_48507[(2)] = inst_48335);

(statearr_48439_48507[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (16))){
var inst_48309 = (state_48386[(7)]);
var inst_48309__$1 = (state_48386[(2)]);
var inst_48310 = cljs.core.get.call(null,inst_48309__$1,new cljs.core.Keyword(null,"event","event",301435442));
var state_48386__$1 = (function (){var statearr_48440 = state_48386;
(statearr_48440[(7)] = inst_48309__$1);

(statearr_48440[(13)] = inst_48310);

return statearr_48440;
})();
var statearr_48441_48508 = state_48386__$1;
(statearr_48441_48508[(2)] = null);

(statearr_48441_48508[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (38))){
var inst_48309 = (state_48386[(7)]);
var state_48386__$1 = state_48386;
var statearr_48442_48509 = state_48386__$1;
(statearr_48442_48509[(2)] = inst_48309);

(statearr_48442_48509[(1)] = (40));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (30))){
var state_48386__$1 = state_48386;
var statearr_48443_48510 = state_48386__$1;
(statearr_48443_48510[(2)] = null);

(statearr_48443_48510[(1)] = (43));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (10))){
var inst_48304 = (state_48386[(2)]);
var state_48386__$1 = state_48386;
if(cljs.core.truth_(inst_48304)){
var statearr_48444_48511 = state_48386__$1;
(statearr_48444_48511[(1)] = (14));

} else {
var statearr_48445_48512 = state_48386__$1;
(statearr_48445_48512[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (18))){
var inst_48311 = (state_48386[(2)]);
var state_48386__$1 = (function (){var statearr_48446 = state_48386;
(statearr_48446[(10)] = inst_48311);

return statearr_48446;
})();
var statearr_48447_48513 = state_48386__$1;
(statearr_48447_48513[(2)] = null);

(statearr_48447_48513[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (42))){
var inst_48358 = (state_48386[(2)]);
var state_48386__$1 = state_48386;
var statearr_48448_48514 = state_48386__$1;
(statearr_48448_48514[(2)] = inst_48358);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48386__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (37))){
var inst_48348 = (state_48386[(2)]);
var state_48386__$1 = state_48386;
var statearr_48449_48515 = state_48386__$1;
(statearr_48449_48515[(2)] = inst_48348);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48386__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (8))){
var inst_48283 = (state_48386[(12)]);
var inst_48293 = inst_48283.cljs$lang$protocol_mask$partition0$;
var inst_48294 = (inst_48293 & (64));
var inst_48295 = inst_48283.cljs$core$ISeq$;
var inst_48296 = (cljs.core.PROTOCOL_SENTINEL === inst_48295);
var inst_48297 = (inst_48294) || (inst_48296);
var state_48386__$1 = state_48386;
if(cljs.core.truth_(inst_48297)){
var statearr_48450_48516 = state_48386__$1;
(statearr_48450_48516[(1)] = (11));

} else {
var statearr_48451_48517 = state_48386__$1;
(statearr_48451_48517[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_48387 === (49))){
var inst_48374 = (state_48386[(2)]);
var state_48386__$1 = state_48386;
var statearr_48452_48518 = state_48386__$1;
(statearr_48452_48518[(2)] = inst_48374);

(statearr_48452_48518[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__42603__auto___48460,map__48272,map__48272__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
;
return ((function (switch__42489__auto__,c__42603__auto___48460,map__48272,map__48272__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function() {
var taoensso$sente$_start_chsk_router_BANG__$_state_machine__42490__auto__ = null;
var taoensso$sente$_start_chsk_router_BANG__$_state_machine__42490__auto____0 = (function (){
var statearr_48456 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_48456[(0)] = taoensso$sente$_start_chsk_router_BANG__$_state_machine__42490__auto__);

(statearr_48456[(1)] = (1));

return statearr_48456;
});
var taoensso$sente$_start_chsk_router_BANG__$_state_machine__42490__auto____1 = (function (state_48386){
while(true){
var ret_value__42491__auto__ = (function (){try{while(true){
var result__42492__auto__ = switch__42489__auto__.call(null,state_48386);
if(cljs.core.keyword_identical_QMARK_.call(null,result__42492__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__42492__auto__;
}
break;
}
}catch (e48457){if((e48457 instanceof Object)){
var ex__42493__auto__ = e48457;
var statearr_48458_48519 = state_48386;
(statearr_48458_48519[(5)] = ex__42493__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_48386);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e48457;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__42491__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48520 = state_48386;
state_48386 = G__48520;
continue;
} else {
return ret_value__42491__auto__;
}
break;
}
});
taoensso$sente$_start_chsk_router_BANG__$_state_machine__42490__auto__ = function(state_48386){
switch(arguments.length){
case 0:
return taoensso$sente$_start_chsk_router_BANG__$_state_machine__42490__auto____0.call(this);
case 1:
return taoensso$sente$_start_chsk_router_BANG__$_state_machine__42490__auto____1.call(this,state_48386);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
taoensso$sente$_start_chsk_router_BANG__$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$0 = taoensso$sente$_start_chsk_router_BANG__$_state_machine__42490__auto____0;
taoensso$sente$_start_chsk_router_BANG__$_state_machine__42490__auto__.cljs$core$IFn$_invoke$arity$1 = taoensso$sente$_start_chsk_router_BANG__$_state_machine__42490__auto____1;
return taoensso$sente$_start_chsk_router_BANG__$_state_machine__42490__auto__;
})()
;})(switch__42489__auto__,c__42603__auto___48460,map__48272,map__48272__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
})();
var state__42605__auto__ = (function (){var statearr_48459 = f__42604__auto__.call(null);
(statearr_48459[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__42603__auto___48460);

return statearr_48459;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__42605__auto__);
});})(c__42603__auto___48460,map__48272,map__48272__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
);


return ((function (map__48272,map__48272__$1,trace_evs_QMARK_,error_handler,ch_ctrl){
return (function taoensso$sente$_start_chsk_router_BANG__$_stop_BANG_(){
return cljs.core.async.close_BANG_.call(null,ch_ctrl);
});
;})(map__48272,map__48272__$1,trace_evs_QMARK_,error_handler,ch_ctrl))
});
/**
 * Creates a go-loop to call `(event-msg-handler <server-event-msg>)` and
 *   log any errors. Returns a `(fn stop! [])`.
 * 
 *   For performance, you'll likely want your `event-msg-handler` fn to be
 *   non-blocking (at least for slow handling operations). Clojure offers
 *   a rich variety of tools here including futures, agents, core.async,
 *   etc.
 * 
 *   Advanced users may also prefer to write their own loop against `ch-recv`.
 */
taoensso.sente.start_server_chsk_router_BANG_ = (function taoensso$sente$start_server_chsk_router_BANG_(var_args){
var args__8730__auto__ = [];
var len__8723__auto___48530 = arguments.length;
var i__8724__auto___48531 = (0);
while(true){
if((i__8724__auto___48531 < len__8723__auto___48530)){
args__8730__auto__.push((arguments[i__8724__auto___48531]));

var G__48532 = (i__8724__auto___48531 + (1));
i__8724__auto___48531 = G__48532;
continue;
} else {
}
break;
}

var argseq__8731__auto__ = ((((2) < args__8730__auto__.length))?(new cljs.core.IndexedSeq(args__8730__auto__.slice((2)),(0),null)):null);
return taoensso.sente.start_server_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8731__auto__);
});

taoensso.sente.start_server_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ch_recv,event_msg_handler,p__48524){
var vec__48525 = p__48524;
var map__48528 = cljs.core.nth.call(null,vec__48525,(0),null);
var map__48528__$1 = ((((!((map__48528 == null)))?((((map__48528.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48528.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48528):map__48528);
var opts = map__48528__$1;
var trace_evs_QMARK_ = cljs.core.get.call(null,map__48528__$1,new cljs.core.Keyword(null,"trace-evs?","trace-evs?",1502453512));
var error_handler = cljs.core.get.call(null,map__48528__$1,new cljs.core.Keyword(null,"error-handler","error-handler",-484945776));
return taoensso.sente._start_chsk_router_BANG_.call(null,new cljs.core.Keyword(null,"server","server",1499190120),ch_recv,event_msg_handler,opts);
});

taoensso.sente.start_server_chsk_router_BANG_.cljs$lang$maxFixedArity = (2);

taoensso.sente.start_server_chsk_router_BANG_.cljs$lang$applyTo = (function (seq48521){
var G__48522 = cljs.core.first.call(null,seq48521);
var seq48521__$1 = cljs.core.next.call(null,seq48521);
var G__48523 = cljs.core.first.call(null,seq48521__$1);
var seq48521__$2 = cljs.core.next.call(null,seq48521__$1);
return taoensso.sente.start_server_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__48522,G__48523,seq48521__$2);
});

/**
 * Creates a go-loop to call `(event-msg-handler <client-event-msg>)` and
 *   log any errors. Returns a `(fn stop! [])`.
 * 
 *   For performance, you'll likely want your `event-msg-handler` fn to be
 *   non-blocking (at least for slow handling operations). Clojure offers
 *   a rich variety of tools here including futures, agents, core.async,
 *   etc.
 * 
 *   Advanced users may also prefer to write their own loop against `ch-recv`.
 */
taoensso.sente.start_client_chsk_router_BANG_ = (function taoensso$sente$start_client_chsk_router_BANG_(var_args){
var args__8730__auto__ = [];
var len__8723__auto___48542 = arguments.length;
var i__8724__auto___48543 = (0);
while(true){
if((i__8724__auto___48543 < len__8723__auto___48542)){
args__8730__auto__.push((arguments[i__8724__auto___48543]));

var G__48544 = (i__8724__auto___48543 + (1));
i__8724__auto___48543 = G__48544;
continue;
} else {
}
break;
}

var argseq__8731__auto__ = ((((2) < args__8730__auto__.length))?(new cljs.core.IndexedSeq(args__8730__auto__.slice((2)),(0),null)):null);
return taoensso.sente.start_client_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__8731__auto__);
});

taoensso.sente.start_client_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ch_recv,event_msg_handler,p__48536){
var vec__48537 = p__48536;
var map__48540 = cljs.core.nth.call(null,vec__48537,(0),null);
var map__48540__$1 = ((((!((map__48540 == null)))?((((map__48540.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48540.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48540):map__48540);
var opts = map__48540__$1;
var trace_evs_QMARK_ = cljs.core.get.call(null,map__48540__$1,new cljs.core.Keyword(null,"trace-evs?","trace-evs?",1502453512));
var error_handler = cljs.core.get.call(null,map__48540__$1,new cljs.core.Keyword(null,"error-handler","error-handler",-484945776));
return taoensso.sente._start_chsk_router_BANG_.call(null,cljs.core.not.call(null,new cljs.core.Keyword(null,"server","server",1499190120)),ch_recv,event_msg_handler,opts);
});

taoensso.sente.start_client_chsk_router_BANG_.cljs$lang$maxFixedArity = (2);

taoensso.sente.start_client_chsk_router_BANG_.cljs$lang$applyTo = (function (seq48533){
var G__48534 = cljs.core.first.call(null,seq48533);
var seq48533__$1 = cljs.core.next.call(null,seq48533);
var G__48535 = cljs.core.first.call(null,seq48533__$1);
var seq48533__$2 = cljs.core.next.call(null,seq48533__$1);
return taoensso.sente.start_client_chsk_router_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__48534,G__48535,seq48533__$2);
});

taoensso.sente.event_msg_QMARK_ = taoensso.sente.client_event_msg_QMARK_;
taoensso.sente.make_channel_socket_BANG_ = taoensso.sente.make_channel_socket_client_BANG_;
taoensso.sente.start_chsk_router_BANG_ = taoensso.sente.start_client_chsk_router_BANG_;
/**
 * DEPRECATED: Please use `start-chsk-router!` instead
 */
taoensso.sente.start_chsk_router_loop_BANG_ = (function taoensso$sente$start_chsk_router_loop_BANG_(event_handler,ch_recv){
return taoensso.sente.start_client_chsk_router_BANG_.call(null,ch_recv,(function (ev_msg){
return event_handler.call(null,new cljs.core.Keyword(null,"event","event",301435442).cljs$core$IFn$_invoke$arity$1(ev_msg),new cljs.core.Keyword(null,"ch-recv","ch-recv",-990916861).cljs$core$IFn$_invoke$arity$1(ev_msg));
}));
});

/**
 * DEPRECATED. Please use `timbre/set-level!` instead
 */
taoensso.sente.set_logging_level_BANG_ = taoensso.timbre.set_level_BANG_;

/**
 * DEPRECATED: Please use `ajax-lite` instead
 */
taoensso.sente.ajax_call = taoensso.encore.ajax_lite;

/**
 * DEPRECATED
 */
taoensso.sente.default_chsk_url_fn = (function taoensso$sente$default_chsk_url_fn(path,p__48545,websocket_QMARK_){
var map__48548 = p__48545;
var map__48548__$1 = ((((!((map__48548 == null)))?((((map__48548.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__48548.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__48548):map__48548);
var location = map__48548__$1;
var protocol = cljs.core.get.call(null,map__48548__$1,new cljs.core.Keyword(null,"protocol","protocol",652470118));
var host = cljs.core.get.call(null,map__48548__$1,new cljs.core.Keyword(null,"host","host",-1558485167));
var pathname = cljs.core.get.call(null,map__48548__$1,new cljs.core.Keyword(null,"pathname","pathname",-1420497528));
var protocol__$1 = (cljs.core.truth_(websocket_QMARK_)?((cljs.core._EQ_.call(null,protocol,"https:"))?"wss:":"ws:"):protocol);
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol__$1),cljs.core.str.cljs$core$IFn$_invoke$arity$1("//"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(host),cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__7502__auto__ = path;
if(cljs.core.truth_(or__7502__auto__)){
return or__7502__auto__;
} else {
return pathname;
}
})())].join('');
});
