// Compiled by ClojureScript 1.9.293 {}
goog.provide('untangled.client.mutations');
goog.require('cljs.core');
goog.require('om.next');
if(typeof untangled.client.mutations.mutate !== 'undefined'){
} else {
untangled.client.mutations.mutate = (function (){var method_table__11793__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__11794__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__11795__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__11796__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__11797__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"untangled.client.mutations","mutate"),om.next.dispatch,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__11797__auto__,method_table__11793__auto__,prefer_table__11794__auto__,method_cache__11795__auto__,cached_hierarchy__11796__auto__));
})();
}
if(typeof untangled.client.mutations.post_mutate !== 'undefined'){
} else {
untangled.client.mutations.post_mutate = (function (){var method_table__11793__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__11794__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var method_cache__11795__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__11796__auto__ = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__11797__auto__ = cljs.core.get.call(null,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"hierarchy","hierarchy",-1053470341),cljs.core.get_global_hierarchy.call(null));
return (new cljs.core.MultiFn(cljs.core.symbol.call(null,"untangled.client.mutations","post-mutate"),om.next.dispatch,new cljs.core.Keyword(null,"default","default",-1987822328),hierarchy__11797__auto__,method_table__11793__auto__,prefer_table__11794__auto__,method_cache__11795__auto__,cached_hierarchy__11796__auto__));
})();
}
/**
 * Toggle the given boolean `field` on the specified component. It is recommended you use this function only on
 *   UI-related data (e.g. form checkbox checked status) and write clear top-level transactions for anything more complicated.
 */
untangled.client.mutations.toggle_BANG_ = (function untangled$client$mutations$toggle_BANG_(comp,field){
return om.next.transact_BANG_.call(null,comp,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__11736__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("ui","toggle","ui/toggle",-1362596183,null)),(function (){var x__11736__auto__ = cljs.core.apply.call(null,cljs.core.array_map,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Keyword(null,"field","field",-1302436500)),(function (){var x__11736__auto__ = field;
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__11736__auto__);
})()))));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__11736__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__11736__auto__);
})())))));
});
/**
 * Set a raw value on the given `field` of a `component`. It is recommended you use this function only on
 *   UI-related data (e.g. form inputs that are used by the UI, and not persisted data).
 */
untangled.client.mutations.set_value_BANG_ = (function untangled$client$mutations$set_value_BANG_(component,field,value){
return om.next.transact_BANG_.call(null,component,cljs.core.vec.call(null,cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,(function (){var x__11736__auto__ = cljs.core.sequence.call(null,cljs.core.seq.call(null,cljs.core.concat.call(null,cljs.core._conj.call(null,cljs.core.List.EMPTY,new cljs.core.Symbol("ui","set-props","ui/set-props",-1564556899,null)),(function (){var x__11736__auto__ = cljs.core.PersistentArrayMap.fromArray([field,value], true, false);
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__11736__auto__);
})())));
return cljs.core._conj.call(null,cljs.core.List.EMPTY,x__11736__auto__);
})())))));
});
/**
 * Helper for set-integer!, use that instead. It is recommended you use this function only on UI-related
 *   data (e.g. data that is used for display purposes) and write clear top-level transactions for anything else.
 */
untangled.client.mutations.ensure_integer = (function untangled$client$mutations$ensure_integer(v){
var rv = parseInt(v);
if(cljs.core.truth_(isNaN(v))){
return (0);
} else {
return rv;
}
});
untangled.client.mutations.target_value = (function untangled$client$mutations$target_value(evt){
return evt.target.value;
});
/**
 * Set the given integer on the given `field` of a `component`. Allows same parameters as `set-string!`.
 * 
 * It is recommended you use this function only on UI-related data (e.g. data that is used for display purposes)
 * and write clear top-level transactions for anything else.
 */
untangled.client.mutations.set_integer_BANG_ = (function untangled$client$mutations$set_integer_BANG_(var_args){
var args__11898__auto__ = [];
var len__11895__auto___21936 = arguments.length;
var i__11896__auto___21937 = (0);
while(true){
if((i__11896__auto___21937 < len__11895__auto___21936)){
args__11898__auto__.push((arguments[i__11896__auto___21937]));

var G__21938 = (i__11896__auto___21937 + (1));
i__11896__auto___21937 = G__21938;
continue;
} else {
}
break;
}

var argseq__11899__auto__ = ((((2) < args__11898__auto__.length))?(new cljs.core.IndexedSeq(args__11898__auto__.slice((2)),(0),null)):null);
return untangled.client.mutations.set_integer_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__11899__auto__);
});

untangled.client.mutations.set_integer_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (component,field,p__21933){
var map__21934 = p__21933;
var map__21934__$1 = ((((!((map__21934 == null)))?((((map__21934.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21934.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21934):map__21934);
var event = cljs.core.get.call(null,map__21934__$1,new cljs.core.Keyword(null,"event","event",301435442));
var value = cljs.core.get.call(null,map__21934__$1,new cljs.core.Keyword(null,"value","value",305978217));
if(cljs.core.truth_((function (){var and__11239__auto__ = (function (){var or__11247__auto__ = event;
if(cljs.core.truth_(or__11247__auto__)){
return or__11247__auto__;
} else {
return value;
}
})();
if(cljs.core.truth_(and__11239__auto__)){
return cljs.core.not.call(null,(function (){var and__11239__auto____$1 = event;
if(cljs.core.truth_(and__11239__auto____$1)){
return value;
} else {
return and__11239__auto____$1;
}
})());
} else {
return and__11239__auto__;
}
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Supply either :event or :value"),cljs.core.str("\n"),cljs.core.str("(and (or event value) (not (and event value)))")].join('')));
}

var value__$1 = untangled.client.mutations.ensure_integer.call(null,(cljs.core.truth_(event)?untangled.client.mutations.target_value.call(null,event):value));
return untangled.client.mutations.set_value_BANG_.call(null,component,field,value__$1);
});

untangled.client.mutations.set_integer_BANG_.cljs$lang$maxFixedArity = (2);

untangled.client.mutations.set_integer_BANG_.cljs$lang$applyTo = (function (seq21930){
var G__21931 = cljs.core.first.call(null,seq21930);
var seq21930__$1 = cljs.core.next.call(null,seq21930);
var G__21932 = cljs.core.first.call(null,seq21930__$1);
var seq21930__$2 = cljs.core.next.call(null,seq21930__$1);
return untangled.client.mutations.set_integer_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21931,G__21932,seq21930__$2);
});

/**
 * Set a string on the given `field` of a `component`. The string can be literal via named parameter `:value` or
 *   can be auto-extracted from a UI event using the named parameter `:event`
 * 
 *   Examples
 * 
 *   ```
 *   (set-string! this :ui/name :value "Hello") ; set from literal (or var)
 *   (set-string! this :ui/name :event evt) ; extract from UI event target value
 *   ```
 * 
 *   It is recommended you use this function only on UI-related
 *   data (e.g. data that is used for display purposes) and write clear top-level transactions for anything else.
 */
untangled.client.mutations.set_string_BANG_ = (function untangled$client$mutations$set_string_BANG_(var_args){
var args__11898__auto__ = [];
var len__11895__auto___21945 = arguments.length;
var i__11896__auto___21946 = (0);
while(true){
if((i__11896__auto___21946 < len__11895__auto___21945)){
args__11898__auto__.push((arguments[i__11896__auto___21946]));

var G__21947 = (i__11896__auto___21946 + (1));
i__11896__auto___21946 = G__21947;
continue;
} else {
}
break;
}

var argseq__11899__auto__ = ((((2) < args__11898__auto__.length))?(new cljs.core.IndexedSeq(args__11898__auto__.slice((2)),(0),null)):null);
return untangled.client.mutations.set_string_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__11899__auto__);
});

untangled.client.mutations.set_string_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (component,field,p__21942){
var map__21943 = p__21942;
var map__21943__$1 = ((((!((map__21943 == null)))?((((map__21943.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__21943.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__21943):map__21943);
var event = cljs.core.get.call(null,map__21943__$1,new cljs.core.Keyword(null,"event","event",301435442));
var value = cljs.core.get.call(null,map__21943__$1,new cljs.core.Keyword(null,"value","value",305978217));
if(cljs.core.truth_((function (){var and__11239__auto__ = (function (){var or__11247__auto__ = event;
if(cljs.core.truth_(or__11247__auto__)){
return or__11247__auto__;
} else {
return value;
}
})();
if(cljs.core.truth_(and__11239__auto__)){
return cljs.core.not.call(null,(function (){var and__11239__auto____$1 = event;
if(cljs.core.truth_(and__11239__auto____$1)){
return value;
} else {
return and__11239__auto____$1;
}
})());
} else {
return and__11239__auto__;
}
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Supply either :event or :value"),cljs.core.str("\n"),cljs.core.str("(and (or event value) (not (and event value)))")].join('')));
}

var value__$1 = (cljs.core.truth_(event)?untangled.client.mutations.target_value.call(null,event):value);
return untangled.client.mutations.set_value_BANG_.call(null,component,field,value__$1);
});

untangled.client.mutations.set_string_BANG_.cljs$lang$maxFixedArity = (2);

untangled.client.mutations.set_string_BANG_.cljs$lang$applyTo = (function (seq21939){
var G__21940 = cljs.core.first.call(null,seq21939);
var seq21939__$1 = cljs.core.next.call(null,seq21939);
var G__21941 = cljs.core.first.call(null,seq21939__$1);
var seq21939__$2 = cljs.core.next.call(null,seq21939__$1);
return untangled.client.mutations.set_string_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__21940,G__21941,seq21939__$2);
});


//# sourceMappingURL=mutations.js.map?rel=1485292055260