// Compiled by ClojureScript 1.9.293 {}
goog.provide('untangled.client.impl.application');
goog.require('cljs.core');
goog.require('untangled.client.logging');
goog.require('untangled.i18n.core');
goog.require('untangled.client.impl.network');
goog.require('untangled.client.impl.om_plumbing');
goog.require('cljs.core.async');
goog.require('untangled.client.impl.util');
goog.require('untangled.client.impl.data_fetch');
goog.require('om.next');
/**
 * This internal function is responsible for generating and returning a function that can accomplish calling the fallbacks that
 *   appear in an incoming Om transaction, which is in turn used by the error-handling logic of the plumbing.
 */
untangled.client.impl.application.fallback_handler = (function untangled$client$impl$application$fallback_handler(p__22316,query){
var map__22319 = p__22316;
var map__22319__$1 = ((((!((map__22319 == null)))?((((map__22319.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22319.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22319):map__22319);
var reconciler = cljs.core.get.call(null,map__22319__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
return ((function (map__22319,map__22319__$1,reconciler){
return (function (error){
cljs.core.swap_BANG_.call(null,om.next.app_state.call(null,reconciler),cljs.core.assoc,new cljs.core.Keyword("untangled","server-error","untangled/server-error",1542377811),error);

var temp__6751__auto__ = untangled.client.impl.om_plumbing.fallback_query.call(null,query,error);
if(cljs.core.truth_(temp__6751__auto__)){
var q = temp__6751__auto__;
untangled.client.logging.warn.call(null,untangled.client.logging.value_message.call(null,"Transaction failed. Running fallback.",q));

return om.next.transact_BANG_.call(null,reconciler,q);
} else {
return untangled.client.logging.warn.call(null,"Fallback triggered, but no fallbacks were defined.");
}
});
;})(map__22319,map__22319__$1,reconciler))
});
/**
 * Enqueue a send to the network queue. This is a standalone function because we cannot mock core async functions.
 */
untangled.client.impl.application.enqueue = (function untangled$client$impl$application$enqueue(q,v){
var c__10775__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10775__auto__){
return (function (){
var f__10776__auto__ = (function (){var switch__10661__auto__ = ((function (c__10775__auto__){
return (function (state_22336){
var state_val_22337 = (state_22336[(1)]);
if((state_val_22337 === (1))){
var state_22336__$1 = state_22336;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22336__$1,(2),q,v);
} else {
if((state_val_22337 === (2))){
var inst_22334 = (state_22336[(2)]);
var state_22336__$1 = state_22336;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22336__$1,inst_22334);
} else {
return null;
}
}
});})(c__10775__auto__))
;
return ((function (switch__10661__auto__,c__10775__auto__){
return (function() {
var untangled$client$impl$application$enqueue_$_state_machine__10662__auto__ = null;
var untangled$client$impl$application$enqueue_$_state_machine__10662__auto____0 = (function (){
var statearr_22341 = [null,null,null,null,null,null,null];
(statearr_22341[(0)] = untangled$client$impl$application$enqueue_$_state_machine__10662__auto__);

(statearr_22341[(1)] = (1));

return statearr_22341;
});
var untangled$client$impl$application$enqueue_$_state_machine__10662__auto____1 = (function (state_22336){
while(true){
var ret_value__10663__auto__ = (function (){try{while(true){
var result__10664__auto__ = switch__10661__auto__.call(null,state_22336);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10664__auto__;
}
break;
}
}catch (e22342){if((e22342 instanceof Object)){
var ex__10665__auto__ = e22342;
var statearr_22343_22345 = state_22336;
(statearr_22343_22345[(5)] = ex__10665__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22336);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22342;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10663__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22346 = state_22336;
state_22336 = G__22346;
continue;
} else {
return ret_value__10663__auto__;
}
break;
}
});
untangled$client$impl$application$enqueue_$_state_machine__10662__auto__ = function(state_22336){
switch(arguments.length){
case 0:
return untangled$client$impl$application$enqueue_$_state_machine__10662__auto____0.call(this);
case 1:
return untangled$client$impl$application$enqueue_$_state_machine__10662__auto____1.call(this,state_22336);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$enqueue_$_state_machine__10662__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$enqueue_$_state_machine__10662__auto____0;
untangled$client$impl$application$enqueue_$_state_machine__10662__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$enqueue_$_state_machine__10662__auto____1;
return untangled$client$impl$application$enqueue_$_state_machine__10662__auto__;
})()
;})(switch__10661__auto__,c__10775__auto__))
})();
var state__10777__auto__ = (function (){var statearr_22344 = f__10776__auto__.call(null);
(statearr_22344[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10775__auto__);

return statearr_22344;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10777__auto__);
});})(c__10775__auto__))
);

return c__10775__auto__;
});
/**
 * Do a properly-plumbed network send. This function recursively strips ui attributes from the tx and pushes the tx over
 *   the network. It installs the given on-load and on-error handlers to deal with the network response.
 */
untangled.client.impl.application.real_send = (function untangled$client$impl$application$real_send(net,tx,on_load,on_error){
return untangled.client.impl.network.send.call(null,net,untangled.client.impl.om_plumbing.strip_ui.call(null,tx),on_load,on_error);
});
/**
 * Splits out the (remote) mutations and fallbacks in a transaction, creates an error handler that can
 * trigger fallbacks, and enqueues the remote mutations on the network queue.
 */
untangled.client.impl.application.enqueue_mutations = (function untangled$client$impl$application$enqueue_mutations(p__22348,remote_tx_map,cb){
var map__22351 = p__22348;
var map__22351__$1 = ((((!((map__22351 == null)))?((((map__22351.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22351.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22351):map__22351);
var app = map__22351__$1;
var queue = cljs.core.get.call(null,map__22351__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var full_remote_transaction = new cljs.core.Keyword(null,"remote","remote",-1593576576).cljs$core$IFn$_invoke$arity$1(remote_tx_map);
var fallback = untangled.client.impl.application.fallback_handler.call(null,app,full_remote_transaction);
var desired_remote_mutations = untangled.client.impl.om_plumbing.remove_loads_and_fallbacks.call(null,full_remote_transaction);
var has_mutations_QMARK_ = (cljs.core.count.call(null,desired_remote_mutations) > (0));
var payload = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"query","query",-1288509510),desired_remote_mutations,new cljs.core.Keyword(null,"on-load","on-load",1415151594),cb,new cljs.core.Keyword(null,"on-error","on-error",1728533530),((function (full_remote_transaction,fallback,desired_remote_mutations,has_mutations_QMARK_,map__22351,map__22351__$1,app,queue){
return (function (p1__22347_SHARP_){
return fallback.call(null,p1__22347_SHARP_);
});})(full_remote_transaction,fallback,desired_remote_mutations,has_mutations_QMARK_,map__22351,map__22351__$1,app,queue))
], null);
if(has_mutations_QMARK_){
return untangled.client.impl.application.enqueue.call(null,queue,payload);
} else {
return null;
}
});
/**
 * Finds any loads marked `parallel` and triggers real network requests immediately. Remaining loads
 *   are pulled into a single fetch payload (combined into one query) and enqueued behind any prior mutations/reads that
 *   were already requested in a prior UI/event cycle. Thus non-parallel reads are processed in clusters grouped due to UI
 *   events (a single event might trigger many reads which will all go to the server as a single combined request).
 *   Further UI events that trigger remote interaction will end up waiting until prior network request(s) are complete.
 * 
 *   This ensures that default reasoning is simple and sequential in the face of optimistic UI updates (real network
 *   traffic characteristics could cause out of order processing, and you would not want
 *   a 'create list' to be processed on the server *after* an 'add an item to the list'). 
 */
untangled.client.impl.application.enqueue_reads = (function untangled$client$impl$application$enqueue_reads(p__22355){
var map__22366 = p__22355;
var map__22366__$1 = ((((!((map__22366 == null)))?((((map__22366.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22366.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22366):map__22366);
var queue = cljs.core.get.call(null,map__22366__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var reconciler = cljs.core.get.call(null,map__22366__$1,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966));
var networking = cljs.core.get.call(null,map__22366__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var parallel_payload = untangled.client.impl.data_fetch.mark_parallel_loading.call(null,reconciler);
var seq__22368_22376 = cljs.core.seq.call(null,parallel_payload);
var chunk__22369_22377 = null;
var count__22370_22378 = (0);
var i__22371_22379 = (0);
while(true){
if((i__22371_22379 < count__22370_22378)){
var map__22372_22380 = cljs.core._nth.call(null,chunk__22369_22377,i__22371_22379);
var map__22372_22381__$1 = ((((!((map__22372_22380 == null)))?((((map__22372_22380.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22372_22380.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22372_22380):map__22372_22380);
var query_22382 = cljs.core.get.call(null,map__22372_22381__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_22383 = cljs.core.get.call(null,map__22372_22381__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_22384 = cljs.core.get.call(null,map__22372_22381__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var callback_args_22385 = cljs.core.get.call(null,map__22372_22381__$1,new cljs.core.Keyword(null,"callback-args","callback-args",1117743591));
var on_load_SINGLEQUOTE__22386 = ((function (seq__22368_22376,chunk__22369_22377,count__22370_22378,i__22371_22379,map__22372_22380,map__22372_22381__$1,query_22382,on_load_22383,on_error_22384,callback_args_22385,parallel_payload,map__22366,map__22366__$1,queue,reconciler,networking){
return (function (p1__22353_SHARP_){
return on_load_22383.call(null,p1__22353_SHARP_,callback_args_22385);
});})(seq__22368_22376,chunk__22369_22377,count__22370_22378,i__22371_22379,map__22372_22380,map__22372_22381__$1,query_22382,on_load_22383,on_error_22384,callback_args_22385,parallel_payload,map__22366,map__22366__$1,queue,reconciler,networking))
;
var on_error_SINGLEQUOTE__22387 = ((function (seq__22368_22376,chunk__22369_22377,count__22370_22378,i__22371_22379,on_load_SINGLEQUOTE__22386,map__22372_22380,map__22372_22381__$1,query_22382,on_load_22383,on_error_22384,callback_args_22385,parallel_payload,map__22366,map__22366__$1,queue,reconciler,networking){
return (function (p1__22354_SHARP_){
return on_error_22384.call(null,p1__22354_SHARP_,callback_args_22385);
});})(seq__22368_22376,chunk__22369_22377,count__22370_22378,i__22371_22379,on_load_SINGLEQUOTE__22386,map__22372_22380,map__22372_22381__$1,query_22382,on_load_22383,on_error_22384,callback_args_22385,parallel_payload,map__22366,map__22366__$1,queue,reconciler,networking))
;
untangled.client.impl.application.real_send.call(null,networking,query_22382,on_load_SINGLEQUOTE__22386,on_error_SINGLEQUOTE__22387);

var G__22388 = seq__22368_22376;
var G__22389 = chunk__22369_22377;
var G__22390 = count__22370_22378;
var G__22391 = (i__22371_22379 + (1));
seq__22368_22376 = G__22388;
chunk__22369_22377 = G__22389;
count__22370_22378 = G__22390;
i__22371_22379 = G__22391;
continue;
} else {
var temp__6753__auto___22392 = cljs.core.seq.call(null,seq__22368_22376);
if(temp__6753__auto___22392){
var seq__22368_22393__$1 = temp__6753__auto___22392;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__22368_22393__$1)){
var c__11725__auto___22394 = cljs.core.chunk_first.call(null,seq__22368_22393__$1);
var G__22395 = cljs.core.chunk_rest.call(null,seq__22368_22393__$1);
var G__22396 = c__11725__auto___22394;
var G__22397 = cljs.core.count.call(null,c__11725__auto___22394);
var G__22398 = (0);
seq__22368_22376 = G__22395;
chunk__22369_22377 = G__22396;
count__22370_22378 = G__22397;
i__22371_22379 = G__22398;
continue;
} else {
var map__22374_22399 = cljs.core.first.call(null,seq__22368_22393__$1);
var map__22374_22400__$1 = ((((!((map__22374_22399 == null)))?((((map__22374_22399.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22374_22399.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22374_22399):map__22374_22399);
var query_22401 = cljs.core.get.call(null,map__22374_22400__$1,new cljs.core.Keyword(null,"query","query",-1288509510));
var on_load_22402 = cljs.core.get.call(null,map__22374_22400__$1,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var on_error_22403 = cljs.core.get.call(null,map__22374_22400__$1,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var callback_args_22404 = cljs.core.get.call(null,map__22374_22400__$1,new cljs.core.Keyword(null,"callback-args","callback-args",1117743591));
var on_load_SINGLEQUOTE__22405 = ((function (seq__22368_22376,chunk__22369_22377,count__22370_22378,i__22371_22379,map__22374_22399,map__22374_22400__$1,query_22401,on_load_22402,on_error_22403,callback_args_22404,seq__22368_22393__$1,temp__6753__auto___22392,parallel_payload,map__22366,map__22366__$1,queue,reconciler,networking){
return (function (p1__22353_SHARP_){
return on_load_22402.call(null,p1__22353_SHARP_,callback_args_22404);
});})(seq__22368_22376,chunk__22369_22377,count__22370_22378,i__22371_22379,map__22374_22399,map__22374_22400__$1,query_22401,on_load_22402,on_error_22403,callback_args_22404,seq__22368_22393__$1,temp__6753__auto___22392,parallel_payload,map__22366,map__22366__$1,queue,reconciler,networking))
;
var on_error_SINGLEQUOTE__22406 = ((function (seq__22368_22376,chunk__22369_22377,count__22370_22378,i__22371_22379,on_load_SINGLEQUOTE__22405,map__22374_22399,map__22374_22400__$1,query_22401,on_load_22402,on_error_22403,callback_args_22404,seq__22368_22393__$1,temp__6753__auto___22392,parallel_payload,map__22366,map__22366__$1,queue,reconciler,networking){
return (function (p1__22354_SHARP_){
return on_error_22403.call(null,p1__22354_SHARP_,callback_args_22404);
});})(seq__22368_22376,chunk__22369_22377,count__22370_22378,i__22371_22379,on_load_SINGLEQUOTE__22405,map__22374_22399,map__22374_22400__$1,query_22401,on_load_22402,on_error_22403,callback_args_22404,seq__22368_22393__$1,temp__6753__auto___22392,parallel_payload,map__22366,map__22366__$1,queue,reconciler,networking))
;
untangled.client.impl.application.real_send.call(null,networking,query_22401,on_load_SINGLEQUOTE__22405,on_error_SINGLEQUOTE__22406);

var G__22407 = cljs.core.next.call(null,seq__22368_22393__$1);
var G__22408 = null;
var G__22409 = (0);
var G__22410 = (0);
seq__22368_22376 = G__22407;
chunk__22369_22377 = G__22408;
count__22370_22378 = G__22409;
i__22371_22379 = G__22410;
continue;
}
} else {
}
}
break;
}

var fetch_payload = untangled.client.impl.data_fetch.mark_loading.call(null,reconciler);
while(true){
if(cljs.core.truth_(fetch_payload)){
untangled.client.impl.application.enqueue.call(null,queue,cljs.core.assoc.call(null,fetch_payload,new cljs.core.Keyword(null,"networking","networking",586110628),networking));

var G__22411 = untangled.client.impl.data_fetch.mark_loading.call(null,reconciler);
fetch_payload = G__22411;
continue;
} else {
return null;
}
break;
}
});
/**
 * Puts queries/mutations (and their corresponding callbacks) onto the send queue. The networking code will pull these
 *   off one at a time and send them through the real networking layer. Reads are guaranteed to *follow* writes.
 */
untangled.client.impl.application.server_send = (function untangled$client$impl$application$server_send(app,remote_tx_map,cb){
untangled.client.impl.application.enqueue_mutations.call(null,app,remote_tx_map,cb);

return untangled.client.impl.application.enqueue_reads.call(null,app);
});
/**
 * Starts a async go loop that sends network requests on a networking object's request queue. Must be called once and only
 *   once for each active networking object on the UI. Each iteration of the loop pulls off a
 *   single request, sends it, waits for the response, and then repeats. Gives the appearance of a separate networking
 *   'thread' using core async.
 */
untangled.client.impl.application.start_network_sequential_processing = (function untangled$client$impl$application$start_network_sequential_processing(p__22412){
var map__22531 = p__22412;
var map__22531__$1 = ((((!((map__22531 == null)))?((((map__22531.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22531.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22531):map__22531);
var networking = cljs.core.get.call(null,map__22531__$1,new cljs.core.Keyword(null,"networking","networking",586110628));
var queue = cljs.core.get.call(null,map__22531__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var response_channel = cljs.core.get.call(null,map__22531__$1,new cljs.core.Keyword(null,"response-channel","response-channel",1395191493));
var make_process_response = ((function (map__22531,map__22531__$1,networking,queue,response_channel){
return (function untangled$client$impl$application$start_network_sequential_processing_$_make_process_response(action,callback_args){
return ((function (map__22531,map__22531__$1,networking,queue,response_channel){
return (function (resp){
try{return action.call(null,resp,callback_args);
}finally {var c__10775__auto___22649 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10775__auto___22649,map__22531,map__22531__$1,networking,queue,response_channel){
return (function (){
var f__10776__auto__ = (function (){var switch__10661__auto__ = ((function (c__10775__auto___22649,map__22531,map__22531__$1,networking,queue,response_channel){
return (function (state_22572){
var state_val_22573 = (state_22572[(1)]);
if((state_val_22573 === (1))){
var state_22572__$1 = state_22572;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_22572__$1,(2),response_channel,new cljs.core.Keyword(null,"complete","complete",-500388775));
} else {
if((state_val_22573 === (2))){
var inst_22570 = (state_22572[(2)]);
var state_22572__$1 = state_22572;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22572__$1,inst_22570);
} else {
return null;
}
}
});})(c__10775__auto___22649,map__22531,map__22531__$1,networking,queue,response_channel))
;
return ((function (switch__10661__auto__,c__10775__auto___22649,map__22531,map__22531__$1,networking,queue,response_channel){
return (function() {
var untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__10662__auto__ = null;
var untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__10662__auto____0 = (function (){
var statearr_22577 = [null,null,null,null,null,null,null];
(statearr_22577[(0)] = untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__10662__auto__);

(statearr_22577[(1)] = (1));

return statearr_22577;
});
var untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__10662__auto____1 = (function (state_22572){
while(true){
var ret_value__10663__auto__ = (function (){try{while(true){
var result__10664__auto__ = switch__10661__auto__.call(null,state_22572);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10664__auto__;
}
break;
}
}catch (e22578){if((e22578 instanceof Object)){
var ex__10665__auto__ = e22578;
var statearr_22579_22650 = state_22572;
(statearr_22579_22650[(5)] = ex__10665__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22572);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22578;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10663__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22651 = state_22572;
state_22572 = G__22651;
continue;
} else {
return ret_value__10663__auto__;
}
break;
}
});
untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__10662__auto__ = function(state_22572){
switch(arguments.length){
case 0:
return untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__10662__auto____0.call(this);
case 1:
return untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__10662__auto____1.call(this,state_22572);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__10662__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__10662__auto____0;
untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__10662__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__10662__auto____1;
return untangled$client$impl$application$start_network_sequential_processing_$_make_process_response_$_state_machine__10662__auto__;
})()
;})(switch__10661__auto__,c__10775__auto___22649,map__22531,map__22531__$1,networking,queue,response_channel))
})();
var state__10777__auto__ = (function (){var statearr_22580 = f__10776__auto__.call(null);
(statearr_22580[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10775__auto___22649);

return statearr_22580;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10777__auto__);
});})(c__10775__auto___22649,map__22531,map__22531__$1,networking,queue,response_channel))
);

}});
;})(map__22531,map__22531__$1,networking,queue,response_channel))
});})(map__22531,map__22531__$1,networking,queue,response_channel))
;
var c__10775__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__10775__auto__,map__22531,map__22531__$1,networking,queue,response_channel){
return (function (){
var f__10776__auto__ = (function (){var switch__10661__auto__ = ((function (c__10775__auto__,map__22531,map__22531__$1,networking,queue,response_channel){
return (function (state_22622){
var state_val_22623 = (state_22622[(1)]);
if((state_val_22623 === (7))){
var inst_22601 = (state_22622[(2)]);
var state_22622__$1 = state_22622;
if(cljs.core.truth_(inst_22601)){
var statearr_22624_22652 = state_22622__$1;
(statearr_22624_22652[(1)] = (11));

} else {
var statearr_22625_22653 = state_22622__$1;
(statearr_22625_22653[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22623 === (1))){
var state_22622__$1 = state_22622;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22622__$1,(2),queue);
} else {
if((state_val_22623 === (4))){
var inst_22620 = (state_22622[(2)]);
var state_22622__$1 = state_22622;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_22622__$1,inst_22620);
} else {
if((state_val_22623 === (15))){
var inst_22617 = (state_22622[(2)]);
var inst_22583 = inst_22617;
var state_22622__$1 = (function (){var statearr_22626 = state_22622;
(statearr_22626[(7)] = inst_22583);

return statearr_22626;
})();
var statearr_22627_22654 = state_22622__$1;
(statearr_22627_22654[(2)] = null);

(statearr_22627_22654[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22623 === (13))){
var inst_22606 = (state_22622[(2)]);
var inst_22607 = cljs.core.get.call(null,inst_22606,new cljs.core.Keyword(null,"query","query",-1288509510));
var inst_22608 = cljs.core.get.call(null,inst_22606,new cljs.core.Keyword(null,"on-load","on-load",1415151594));
var inst_22609 = cljs.core.get.call(null,inst_22606,new cljs.core.Keyword(null,"on-error","on-error",1728533530));
var inst_22610 = cljs.core.get.call(null,inst_22606,new cljs.core.Keyword(null,"callback-args","callback-args",1117743591));
var inst_22611 = make_process_response.call(null,inst_22608,inst_22610);
var inst_22612 = make_process_response.call(null,inst_22609,inst_22610);
var inst_22613 = untangled.client.impl.application.real_send.call(null,networking,inst_22607,inst_22611,inst_22612);
var state_22622__$1 = (function (){var statearr_22628 = state_22622;
(statearr_22628[(8)] = inst_22613);

return statearr_22628;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22622__$1,(14),response_channel);
} else {
if((state_val_22623 === (6))){
var state_22622__$1 = state_22622;
var statearr_22629_22655 = state_22622__$1;
(statearr_22629_22655[(2)] = false);

(statearr_22629_22655[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22623 === (3))){
var inst_22583 = (state_22622[(7)]);
var inst_22587 = (inst_22583 == null);
var inst_22588 = cljs.core.not.call(null,inst_22587);
var state_22622__$1 = state_22622;
if(inst_22588){
var statearr_22630_22656 = state_22622__$1;
(statearr_22630_22656[(1)] = (5));

} else {
var statearr_22631_22657 = state_22622__$1;
(statearr_22631_22657[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22623 === (12))){
var inst_22583 = (state_22622[(7)]);
var state_22622__$1 = state_22622;
var statearr_22632_22658 = state_22622__$1;
(statearr_22632_22658[(2)] = inst_22583);

(statearr_22632_22658[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22623 === (2))){
var inst_22582 = (state_22622[(2)]);
var inst_22583 = inst_22582;
var state_22622__$1 = (function (){var statearr_22633 = state_22622;
(statearr_22633[(7)] = inst_22583);

return statearr_22633;
})();
var statearr_22634_22659 = state_22622__$1;
(statearr_22634_22659[(2)] = null);

(statearr_22634_22659[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22623 === (11))){
var inst_22583 = (state_22622[(7)]);
var inst_22603 = cljs.core.apply.call(null,cljs.core.hash_map,inst_22583);
var state_22622__$1 = state_22622;
var statearr_22635_22660 = state_22622__$1;
(statearr_22635_22660[(2)] = inst_22603);

(statearr_22635_22660[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22623 === (9))){
var state_22622__$1 = state_22622;
var statearr_22636_22661 = state_22622__$1;
(statearr_22636_22661[(2)] = false);

(statearr_22636_22661[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22623 === (5))){
var inst_22583 = (state_22622[(7)]);
var inst_22590 = inst_22583.cljs$lang$protocol_mask$partition0$;
var inst_22591 = (inst_22590 & (64));
var inst_22592 = inst_22583.cljs$core$ISeq$;
var inst_22593 = (cljs.core.PROTOCOL_SENTINEL === inst_22592);
var inst_22594 = (inst_22591) || (inst_22593);
var state_22622__$1 = state_22622;
if(cljs.core.truth_(inst_22594)){
var statearr_22637_22662 = state_22622__$1;
(statearr_22637_22662[(1)] = (8));

} else {
var statearr_22638_22663 = state_22622__$1;
(statearr_22638_22663[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22623 === (14))){
var inst_22615 = (state_22622[(2)]);
var state_22622__$1 = (function (){var statearr_22639 = state_22622;
(statearr_22639[(9)] = inst_22615);

return statearr_22639;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_22622__$1,(15),queue);
} else {
if((state_val_22623 === (10))){
var inst_22598 = (state_22622[(2)]);
var state_22622__$1 = state_22622;
var statearr_22640_22664 = state_22622__$1;
(statearr_22640_22664[(2)] = inst_22598);

(statearr_22640_22664[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_22623 === (8))){
var state_22622__$1 = state_22622;
var statearr_22641_22665 = state_22622__$1;
(statearr_22641_22665[(2)] = true);

(statearr_22641_22665[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__10775__auto__,map__22531,map__22531__$1,networking,queue,response_channel))
;
return ((function (switch__10661__auto__,c__10775__auto__,map__22531,map__22531__$1,networking,queue,response_channel){
return (function() {
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__10662__auto__ = null;
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__10662__auto____0 = (function (){
var statearr_22645 = [null,null,null,null,null,null,null,null,null,null];
(statearr_22645[(0)] = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__10662__auto__);

(statearr_22645[(1)] = (1));

return statearr_22645;
});
var untangled$client$impl$application$start_network_sequential_processing_$_state_machine__10662__auto____1 = (function (state_22622){
while(true){
var ret_value__10663__auto__ = (function (){try{while(true){
var result__10664__auto__ = switch__10661__auto__.call(null,state_22622);
if(cljs.core.keyword_identical_QMARK_.call(null,result__10664__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__10664__auto__;
}
break;
}
}catch (e22646){if((e22646 instanceof Object)){
var ex__10665__auto__ = e22646;
var statearr_22647_22666 = state_22622;
(statearr_22647_22666[(5)] = ex__10665__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_22622);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e22646;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__10663__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__22667 = state_22622;
state_22622 = G__22667;
continue;
} else {
return ret_value__10663__auto__;
}
break;
}
});
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__10662__auto__ = function(state_22622){
switch(arguments.length){
case 0:
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__10662__auto____0.call(this);
case 1:
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__10662__auto____1.call(this,state_22622);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__10662__auto__.cljs$core$IFn$_invoke$arity$0 = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__10662__auto____0;
untangled$client$impl$application$start_network_sequential_processing_$_state_machine__10662__auto__.cljs$core$IFn$_invoke$arity$1 = untangled$client$impl$application$start_network_sequential_processing_$_state_machine__10662__auto____1;
return untangled$client$impl$application$start_network_sequential_processing_$_state_machine__10662__auto__;
})()
;})(switch__10661__auto__,c__10775__auto__,map__22531,map__22531__$1,networking,queue,response_channel))
})();
var state__10777__auto__ = (function (){var statearr_22648 = f__10776__auto__.call(null);
(statearr_22648[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__10775__auto__);

return statearr_22648;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__10777__auto__);
});})(c__10775__auto__,map__22531,map__22531__$1,networking,queue,response_channel))
);

return c__10775__auto__;
});
/**
 * Configure a re-render when the locale changes. During startup this function will be called once for each
 *   reconciler that is running on a page.
 */
untangled.client.impl.application.initialize_internationalization = (function untangled$client$impl$application$initialize_internationalization(reconciler){
cljs.core.remove_watch.call(null,untangled.i18n.core._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697));

return cljs.core.add_watch.call(null,untangled.i18n.core._STAR_current_locale_STAR_,new cljs.core.Keyword(null,"locale","locale",-2115712697),(function (k,r,o,n){
if(om.next.mounted_QMARK_.call(null,om.next.app_root.call(null,reconciler))){
return om.next.force_root_render_BANG_.call(null,reconciler);
} else {
return null;
}
}));
});
/**
 * Remove not-found keys from m (non-recursive)
 */
untangled.client.impl.application.sweep_one = (function untangled$client$impl$application$sweep_one(m){
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__22672){
var vec__22673 = p__22672;
var k = cljs.core.nth.call(null,vec__22673,(0),null);
var v = cljs.core.nth.call(null,vec__22673,(1),null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494),v)){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,v);
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,untangled.client.impl.application.sweep_one,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
});
/**
 * Remove all of the not-found keys (recursively) from v, stopping at marked leaves (if present)
 */
untangled.client.impl.application.sweep = (function untangled$client$impl$application$sweep(m){
if(cljs.core.truth_(untangled.client.impl.om_plumbing.leaf_QMARK_.call(null,m))){
return untangled.client.impl.application.sweep_one.call(null,m);
} else {
if(cljs.core.map_QMARK_.call(null,m)){
return cljs.core.reduce.call(null,(function (acc,p__22680){
var vec__22681 = p__22680;
var k = cljs.core.nth.call(null,vec__22681,(0),null);
var v = cljs.core.nth.call(null,vec__22681,(1),null);
if(cljs.core._EQ_.call(null,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494),v)){
return acc;
} else {
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep.call(null,v));
}
}),cljs.core.with_meta.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.meta.call(null,m)),m);
} else {
if(cljs.core.vector_QMARK_.call(null,m)){
return cljs.core.with_meta.call(null,cljs.core.mapv.call(null,untangled.client.impl.application.sweep,m),cljs.core.meta.call(null,m));
} else {
return m;

}
}
}
});
/**
 * Do a recursive merge of source into target, but remove any target data that is marked as missing in the response. The
 *   missing marker is generated in the source when something has been asked for in the query, but had no value in the
 *   response. This allows us to correctly remove 'empty' data from the database without accidentally removing something
 *   that may still exist on the server (in truth we don't know its status, since it wasn't asked for, but we leave
 *   it as our 'best guess')
 */
untangled.client.impl.application.sweep_merge = (function untangled$client$impl$application$sweep_merge(target,source){
return cljs.core.reduce.call(null,(function (acc,p__22688){
var vec__22689 = p__22688;
var k = cljs.core.nth.call(null,vec__22689,(0),null);
var v = cljs.core.nth.call(null,vec__22689,(1),null);
if(cljs.core._EQ_.call(null,v,new cljs.core.Keyword("untangled.client.impl.om-plumbing","not-found","untangled.client.impl.om-plumbing/not-found",-1009851494))){
return cljs.core.dissoc.call(null,acc,k);
} else {
if(cljs.core.truth_(untangled.client.impl.om_plumbing.leaf_QMARK_.call(null,v))){
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep_one.call(null,v));
} else {
if((cljs.core.map_QMARK_.call(null,cljs.core.get.call(null,acc,k))) && (cljs.core.map_QMARK_.call(null,v))){
return cljs.core.update.call(null,acc,k,untangled.client.impl.application.sweep_merge,v);
} else {
return cljs.core.assoc.call(null,acc,k,untangled.client.impl.application.sweep.call(null,v));

}
}
}
}),target,source);
});
untangled.client.impl.application.merge_handler = (function untangled$client$impl$application$merge_handler(mutation_merge,target,source){
var source_to_merge = cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.filter.call(null,(function (p__22700){
var vec__22701 = p__22700;
var k = cljs.core.nth.call(null,vec__22701,(0),null);
var _ = cljs.core.nth.call(null,vec__22701,(1),null);
return !((k instanceof cljs.core.Symbol));
}),source));
var merged_state = untangled.client.impl.application.sweep_merge.call(null,target,source_to_merge);
return cljs.core.reduce.call(null,((function (source_to_merge,merged_state){
return (function (acc,p__22704){
var vec__22705 = p__22704;
var k = cljs.core.nth.call(null,vec__22705,(0),null);
var v = cljs.core.nth.call(null,vec__22705,(1),null);
if(cljs.core.truth_((function (){var and__11239__auto__ = mutation_merge;
if(cljs.core.truth_(and__11239__auto__)){
return (k instanceof cljs.core.Symbol);
} else {
return and__11239__auto__;
}
})())){
var temp__6751__auto__ = mutation_merge.call(null,acc,k,cljs.core.dissoc.call(null,v,new cljs.core.Keyword(null,"tempids","tempids",1767509089)));
if(cljs.core.truth_(temp__6751__auto__)){
var updated_state = temp__6751__auto__;
return updated_state;
} else {
untangled.client.logging.info.call(null,"Return value handler for",k,"returned nil. Ignored.");

return acc;
}
} else {
return acc;
}
});})(source_to_merge,merged_state))
,merged_state,source);
});
/**
 * The reconciler's send method calls UntangledApplication/server-send, which itself requires a reconciler with a
 *   send method already defined. This creates a catch-22 / circular dependency on the reconciler and :send field within
 *   the reconciler.
 * 
 *   To resolve the issue, we def an atom pointing to the reconciler that the send method will deref each time it is
 *   called. This allows us to define the reconciler with a send method that, at the time of initialization, has an app
 *   that points to a nil reconciler. By the end of this function, the app's reconciler reference has been properly set.
 */
untangled.client.impl.application.generate_reconciler = (function untangled$client$impl$application$generate_reconciler(p__22708,initial_state,parser,p__22709){
var map__22714 = p__22708;
var map__22714__$1 = ((((!((map__22714 == null)))?((((map__22714.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22714.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22714):map__22714);
var app = map__22714__$1;
var queue = cljs.core.get.call(null,map__22714__$1,new cljs.core.Keyword(null,"queue","queue",1455835879));
var mutation_merge = cljs.core.get.call(null,map__22714__$1,new cljs.core.Keyword(null,"mutation-merge","mutation-merge",-2131743322));
var map__22715 = p__22709;
var map__22715__$1 = ((((!((map__22715 == null)))?((((map__22715.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__22715.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__22715):map__22715);
var pathopt = cljs.core.get.call(null,map__22715__$1,new cljs.core.Keyword(null,"pathopt","pathopt",-61073149),true);
var migrate = cljs.core.get.call(null,map__22715__$1,new cljs.core.Keyword(null,"migrate","migrate",-207110743),null);
var shared = cljs.core.get.call(null,map__22715__$1,new cljs.core.Keyword(null,"shared","shared",-384145993),null);
var rec_atom = cljs.core.atom.call(null,null);
var state_migrate = (function (){var or__11247__auto__ = migrate;
if(cljs.core.truth_(or__11247__auto__)){
return or__11247__auto__;
} else {
return untangled.client.impl.om_plumbing.resolve_tempids;
}
})();
var tempid_migrate = ((function (rec_atom,state_migrate,map__22714,map__22714__$1,app,queue,mutation_merge,map__22715,map__22715__$1,pathopt,migrate,shared){
return (function (pure,_,tempids,___$1){
untangled.client.impl.om_plumbing.rewrite_tempids_in_request_queue.call(null,queue,tempids);

return state_migrate.call(null,pure,tempids);
});})(rec_atom,state_migrate,map__22714,map__22714__$1,app,queue,mutation_merge,map__22715,map__22715__$1,pathopt,migrate,shared))
;
var initial_state_with_locale = (cljs.core.truth_(untangled.client.impl.util.atom_QMARK_.call(null,initial_state))?(function (){
cljs.core.swap_BANG_.call(null,initial_state,cljs.core.assoc,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),"en-US");

return initial_state;
})()
:cljs.core.assoc.call(null,initial_state,new cljs.core.Keyword("ui","locale","ui/locale",-2115717461),"en-US"));
var config = new cljs.core.PersistentArrayMap(null, 8, [new cljs.core.Keyword(null,"state","state",-1988618099),initial_state_with_locale,new cljs.core.Keyword(null,"send","send",-652151114),((function (rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__22714,map__22714__$1,app,queue,mutation_merge,map__22715,map__22715__$1,pathopt,migrate,shared){
return (function (tx,cb){
return untangled.client.impl.application.server_send.call(null,cljs.core.assoc.call(null,app,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966),cljs.core.deref.call(null,rec_atom)),tx,cb);
});})(rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__22714,map__22714__$1,app,queue,mutation_merge,map__22715,map__22715__$1,pathopt,migrate,shared))
,new cljs.core.Keyword(null,"migrate","migrate",-207110743),(function (){var or__11247__auto__ = migrate;
if(cljs.core.truth_(or__11247__auto__)){
return or__11247__auto__;
} else {
return tempid_migrate;
}
})(),new cljs.core.Keyword(null,"normalize","normalize",-1904390051),true,new cljs.core.Keyword(null,"pathopt","pathopt",-61073149),pathopt,new cljs.core.Keyword(null,"merge-tree","merge-tree",-127861161),((function (rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__22714,map__22714__$1,app,queue,mutation_merge,map__22715,map__22715__$1,pathopt,migrate,shared){
return (function (target,source){
return untangled.client.impl.application.merge_handler.call(null,mutation_merge,target,source);
});})(rec_atom,state_migrate,tempid_migrate,initial_state_with_locale,map__22714,map__22714__$1,app,queue,mutation_merge,map__22715,map__22715__$1,pathopt,migrate,shared))
,new cljs.core.Keyword(null,"parser","parser",-1543495310),parser,new cljs.core.Keyword(null,"shared","shared",-384145993),shared], null);
var rec = om.next.reconciler.call(null,config);
cljs.core.reset_BANG_.call(null,rec_atom,rec);

return rec;
});
untangled.client.impl.application.initialize_global_error_callback = (function untangled$client$impl$application$initialize_global_error_callback(app){
var cb_atom = cljs.core.get_in.call(null,app,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"networking","networking",586110628),new cljs.core.Keyword(null,"global-error-callback","global-error-callback",901427631)], null));
if(cljs.core.truth_(untangled.client.impl.util.atom_QMARK_.call(null,cb_atom))){
return cljs.core.swap_BANG_.call(null,cb_atom,((function (cb_atom){
return (function (p1__22718_SHARP_){
if(cljs.core.fn_QMARK_.call(null,p1__22718_SHARP_)){
return cljs.core.partial.call(null,p1__22718_SHARP_,om.next.app_state.call(null,new cljs.core.Keyword(null,"reconciler","reconciler",-1832826966).cljs$core$IFn$_invoke$arity$1(app)));
} else {
throw cljs.core.ex_info.call(null,"Networking error callback must be a function.",cljs.core.PersistentArrayMap.EMPTY);
}
});})(cb_atom))
);
} else {
return null;
}
});

//# sourceMappingURL=application.js.map?rel=1485292055849