// Compiled by ClojureScript 1.9.293 {}
goog.provide('sablono.core');
goog.require('cljs.core');
goog.require('goog.dom');
goog.require('goog.string');
goog.require('sablono.normalize');
goog.require('sablono.util');
goog.require('sablono.interpreter');
goog.require('cljsjs.react');
goog.require('cljsjs.react.dom');
goog.require('clojure.string');
/**
 * Add an optional attribute argument to a function that returns a element vector.
 */
sablono.core.wrap_attrs = (function sablono$core$wrap_attrs(func){
return (function() { 
var G__94859__delegate = function (args){
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,args))){
var vec__94856 = cljs.core.apply.call(null,func,cljs.core.rest.call(null,args));
var seq__94857 = cljs.core.seq.call(null,vec__94856);
var first__94858 = cljs.core.first.call(null,seq__94857);
var seq__94857__$1 = cljs.core.next.call(null,seq__94857);
var tag = first__94858;
var body = seq__94857__$1;
if(cljs.core.map_QMARK_.call(null,cljs.core.first.call(null,body))){
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.merge.call(null,cljs.core.first.call(null,body),cljs.core.first.call(null,args)),cljs.core.rest.call(null,body));
} else {
return cljs.core.apply.call(null,cljs.core.vector,tag,cljs.core.first.call(null,args),body);
}
} else {
return cljs.core.apply.call(null,func,args);
}
};
var G__94859 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__94860__i = 0, G__94860__a = new Array(arguments.length -  0);
while (G__94860__i < G__94860__a.length) {G__94860__a[G__94860__i] = arguments[G__94860__i + 0]; ++G__94860__i;}
  args = new cljs.core.IndexedSeq(G__94860__a,0);
} 
return G__94859__delegate.call(this,args);};
G__94859.cljs$lang$maxFixedArity = 0;
G__94859.cljs$lang$applyTo = (function (arglist__94861){
var args = cljs.core.seq(arglist__94861);
return G__94859__delegate(args);
});
G__94859.cljs$core$IFn$_invoke$arity$variadic = G__94859__delegate;
return G__94859;
})()
;
});
sablono.core.update_arglists = (function sablono$core$update_arglists(arglists){
var iter__28137__auto__ = (function sablono$core$update_arglists_$_iter__94866(s__94867){
return (new cljs.core.LazySeq(null,(function (){
var s__94867__$1 = s__94867;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__94867__$1);
if(temp__6753__auto__){
var s__94867__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__94867__$2)){
var c__28135__auto__ = cljs.core.chunk_first.call(null,s__94867__$2);
var size__28136__auto__ = cljs.core.count.call(null,c__28135__auto__);
var b__94869 = cljs.core.chunk_buffer.call(null,size__28136__auto__);
if((function (){var i__94868 = (0);
while(true){
if((i__94868 < size__28136__auto__)){
var args = cljs.core._nth.call(null,c__28135__auto__,i__94868);
cljs.core.chunk_append.call(null,b__94869,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)));

var G__94870 = (i__94868 + (1));
i__94868 = G__94870;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__94869),sablono$core$update_arglists_$_iter__94866.call(null,cljs.core.chunk_rest.call(null,s__94867__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__94869),null);
}
} else {
var args = cljs.core.first.call(null,s__94867__$2);
return cljs.core.cons.call(null,cljs.core.vec.call(null,cljs.core.cons.call(null,new cljs.core.Symbol(null,"attr-map?","attr-map?",116307443,null),args)),sablono$core$update_arglists_$_iter__94866.call(null,cljs.core.rest.call(null,s__94867__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28137__auto__.call(null,arglists);
});
/**
 * Include a list of external stylesheet files.
 */
sablono.core.include_css = (function sablono$core$include_css(var_args){
var args__28503__auto__ = [];
var len__28496__auto___94876 = arguments.length;
var i__28497__auto___94877 = (0);
while(true){
if((i__28497__auto___94877 < len__28496__auto___94876)){
args__28503__auto__.push((arguments[i__28497__auto___94877]));

var G__94878 = (i__28497__auto___94877 + (1));
i__28497__auto___94877 = G__94878;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((0) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((0)),(0),null)):null);
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(argseq__28504__auto__);
});

sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic = (function (styles){
var iter__28137__auto__ = (function sablono$core$iter__94872(s__94873){
return (new cljs.core.LazySeq(null,(function (){
var s__94873__$1 = s__94873;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__94873__$1);
if(temp__6753__auto__){
var s__94873__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__94873__$2)){
var c__28135__auto__ = cljs.core.chunk_first.call(null,s__94873__$2);
var size__28136__auto__ = cljs.core.count.call(null,c__28135__auto__);
var b__94875 = cljs.core.chunk_buffer.call(null,size__28136__auto__);
if((function (){var i__94874 = (0);
while(true){
if((i__94874 < size__28136__auto__)){
var style = cljs.core._nth.call(null,c__28135__auto__,i__94874);
cljs.core.chunk_append.call(null,b__94875,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null));

var G__94879 = (i__94874 + (1));
i__94874 = G__94879;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__94875),sablono$core$iter__94872.call(null,cljs.core.chunk_rest.call(null,s__94873__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__94875),null);
}
} else {
var style = cljs.core.first.call(null,s__94873__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"link","link",-1769163468),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"type","type",1174270348),"text/css",new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,style),new cljs.core.Keyword(null,"rel","rel",1378823488),"stylesheet"], null)], null),sablono$core$iter__94872.call(null,cljs.core.rest.call(null,s__94873__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28137__auto__.call(null,styles);
});

sablono.core.include_css.cljs$lang$maxFixedArity = (0);

sablono.core.include_css.cljs$lang$applyTo = (function (seq94871){
return sablono.core.include_css.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq94871));
});

/**
 * Include the JavaScript library at `src`.
 */
sablono.core.include_js = (function sablono$core$include_js(src){
return goog.dom.appendChild(goog.dom.getDocument().body,goog.dom.createDom("script",({"src": src})));
});
/**
 * Include Facebook's React JavaScript library.
 */
sablono.core.include_react = (function sablono$core$include_react(){
return sablono.core.include_js.call(null,"http://fb.me/react-0.12.2.js");
});
/**
 * Wraps some content in a HTML hyperlink with the supplied URL.
 */
sablono.core.link_to94880 = (function sablono$core$link_to94880(var_args){
var args__28503__auto__ = [];
var len__28496__auto___94883 = arguments.length;
var i__28497__auto___94884 = (0);
while(true){
if((i__28497__auto___94884 < len__28496__auto___94883)){
args__28503__auto__.push((arguments[i__28497__auto___94884]));

var G__94885 = (i__28497__auto___94884 + (1));
i__28497__auto___94884 = G__94885;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((1) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((1)),(0),null)):null);
return sablono.core.link_to94880.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28504__auto__);
});

sablono.core.link_to94880.cljs$core$IFn$_invoke$arity$variadic = (function (url,content){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),sablono.util.as_str.call(null,url)], null),content], null);
});

sablono.core.link_to94880.cljs$lang$maxFixedArity = (1);

sablono.core.link_to94880.cljs$lang$applyTo = (function (seq94881){
var G__94882 = cljs.core.first.call(null,seq94881);
var seq94881__$1 = cljs.core.next.call(null,seq94881);
return sablono.core.link_to94880.cljs$core$IFn$_invoke$arity$variadic(G__94882,seq94881__$1);
});


sablono.core.link_to = sablono.core.wrap_attrs.call(null,sablono.core.link_to94880);
/**
 * Wraps some content in a HTML hyperlink with the supplied e-mail
 *   address. If no content provided use the e-mail address as content.
 */
sablono.core.mail_to94886 = (function sablono$core$mail_to94886(var_args){
var args__28503__auto__ = [];
var len__28496__auto___94893 = arguments.length;
var i__28497__auto___94894 = (0);
while(true){
if((i__28497__auto___94894 < len__28496__auto___94893)){
args__28503__auto__.push((arguments[i__28497__auto___94894]));

var G__94895 = (i__28497__auto___94894 + (1));
i__28497__auto___94894 = G__94895;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((1) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((1)),(0),null)):null);
return sablono.core.mail_to94886.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28504__auto__);
});

sablono.core.mail_to94886.cljs$core$IFn$_invoke$arity$variadic = (function (e_mail,p__94889){
var vec__94890 = p__94889;
var content = cljs.core.nth.call(null,vec__94890,(0),null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"a","a",-2123407586),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"href","href",-793805698),[cljs.core.str("mailto:"),cljs.core.str(e_mail)].join('')], null),(function (){var or__27280__auto__ = content;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return e_mail;
}
})()], null);
});

sablono.core.mail_to94886.cljs$lang$maxFixedArity = (1);

sablono.core.mail_to94886.cljs$lang$applyTo = (function (seq94887){
var G__94888 = cljs.core.first.call(null,seq94887);
var seq94887__$1 = cljs.core.next.call(null,seq94887);
return sablono.core.mail_to94886.cljs$core$IFn$_invoke$arity$variadic(G__94888,seq94887__$1);
});


sablono.core.mail_to = sablono.core.wrap_attrs.call(null,sablono.core.mail_to94886);
/**
 * Wrap a collection in an unordered list.
 */
sablono.core.unordered_list94896 = (function sablono$core$unordered_list94896(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ul","ul",-1349521403),(function (){var iter__28137__auto__ = (function sablono$core$unordered_list94896_$_iter__94901(s__94902){
return (new cljs.core.LazySeq(null,(function (){
var s__94902__$1 = s__94902;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__94902__$1);
if(temp__6753__auto__){
var s__94902__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__94902__$2)){
var c__28135__auto__ = cljs.core.chunk_first.call(null,s__94902__$2);
var size__28136__auto__ = cljs.core.count.call(null,c__28135__auto__);
var b__94904 = cljs.core.chunk_buffer.call(null,size__28136__auto__);
if((function (){var i__94903 = (0);
while(true){
if((i__94903 < size__28136__auto__)){
var x = cljs.core._nth.call(null,c__28135__auto__,i__94903);
cljs.core.chunk_append.call(null,b__94904,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__94905 = (i__94903 + (1));
i__94903 = G__94905;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__94904),sablono$core$unordered_list94896_$_iter__94901.call(null,cljs.core.chunk_rest.call(null,s__94902__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__94904),null);
}
} else {
var x = cljs.core.first.call(null,s__94902__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$unordered_list94896_$_iter__94901.call(null,cljs.core.rest.call(null,s__94902__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28137__auto__.call(null,coll);
})()], null);
});

sablono.core.unordered_list = sablono.core.wrap_attrs.call(null,sablono.core.unordered_list94896);
/**
 * Wrap a collection in an ordered list.
 */
sablono.core.ordered_list94906 = (function sablono$core$ordered_list94906(coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"ol","ol",932524051),(function (){var iter__28137__auto__ = (function sablono$core$ordered_list94906_$_iter__94911(s__94912){
return (new cljs.core.LazySeq(null,(function (){
var s__94912__$1 = s__94912;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__94912__$1);
if(temp__6753__auto__){
var s__94912__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__94912__$2)){
var c__28135__auto__ = cljs.core.chunk_first.call(null,s__94912__$2);
var size__28136__auto__ = cljs.core.count.call(null,c__28135__auto__);
var b__94914 = cljs.core.chunk_buffer.call(null,size__28136__auto__);
if((function (){var i__94913 = (0);
while(true){
if((i__94913 < size__28136__auto__)){
var x = cljs.core._nth.call(null,c__28135__auto__,i__94913);
cljs.core.chunk_append.call(null,b__94914,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null));

var G__94915 = (i__94913 + (1));
i__94913 = G__94915;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__94914),sablono$core$ordered_list94906_$_iter__94911.call(null,cljs.core.chunk_rest.call(null,s__94912__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__94914),null);
}
} else {
var x = cljs.core.first.call(null,s__94912__$2);
return cljs.core.cons.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"li","li",723558921),x], null),sablono$core$ordered_list94906_$_iter__94911.call(null,cljs.core.rest.call(null,s__94912__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28137__auto__.call(null,coll);
})()], null);
});

sablono.core.ordered_list = sablono.core.wrap_attrs.call(null,sablono.core.ordered_list94906);
/**
 * Create an image element.
 */
sablono.core.image94916 = (function sablono$core$image94916(var_args){
var args94917 = [];
var len__28496__auto___94920 = arguments.length;
var i__28497__auto___94921 = (0);
while(true){
if((i__28497__auto___94921 < len__28496__auto___94920)){
args94917.push((arguments[i__28497__auto___94921]));

var G__94922 = (i__28497__auto___94921 + (1));
i__28497__auto___94921 = G__94922;
continue;
} else {
}
break;
}

var G__94919 = args94917.length;
switch (G__94919) {
case 1:
return sablono.core.image94916.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.image94916.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94917.length)].join('')));

}
});

sablono.core.image94916.cljs$core$IFn$_invoke$arity$1 = (function (src){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src)], null)], null);
});

sablono.core.image94916.cljs$core$IFn$_invoke$arity$2 = (function (src,alt){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"img","img",1442687358),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"src","src",-1651076051),sablono.util.as_str.call(null,src),new cljs.core.Keyword(null,"alt","alt",-3214426),alt], null)], null);
});

sablono.core.image94916.cljs$lang$maxFixedArity = 2;


sablono.core.image = sablono.core.wrap_attrs.call(null,sablono.core.image94916);
sablono.core._STAR_group_STAR_ = cljs.core.PersistentVector.EMPTY;
/**
 * Create a field name from the supplied argument the current field group.
 */
sablono.core.make_name = (function sablono$core$make_name(name){
return cljs.core.reduce.call(null,(function (p1__94924_SHARP_,p2__94925_SHARP_){
return [cljs.core.str(p1__94924_SHARP_),cljs.core.str("["),cljs.core.str(p2__94925_SHARP_),cljs.core.str("]")].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Create a field id from the supplied argument and current field group.
 */
sablono.core.make_id = (function sablono$core$make_id(name){
return cljs.core.reduce.call(null,(function (p1__94926_SHARP_,p2__94927_SHARP_){
return [cljs.core.str(p1__94926_SHARP_),cljs.core.str("-"),cljs.core.str(p2__94927_SHARP_)].join('');
}),cljs.core.conj.call(null,sablono.core._STAR_group_STAR_,sablono.util.as_str.call(null,name)));
});
/**
 * Creates a new <input> element.
 */
sablono.core.input_field_STAR_ = (function sablono$core$input_field_STAR_(type,name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"type","type",1174270348),type,new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__27280__auto__ = value;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return undefined;
}
})()], null)], null);
});
/**
 * Creates a color input field.
 */
sablono.core.color_field94928 = (function sablono$core$color_field94928(var_args){
var args94929 = [];
var len__28496__auto___94996 = arguments.length;
var i__28497__auto___94997 = (0);
while(true){
if((i__28497__auto___94997 < len__28496__auto___94996)){
args94929.push((arguments[i__28497__auto___94997]));

var G__94998 = (i__28497__auto___94997 + (1));
i__28497__auto___94997 = G__94998;
continue;
} else {
}
break;
}

var G__94931 = args94929.length;
switch (G__94931) {
case 1:
return sablono.core.color_field94928.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.color_field94928.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94929.length)].join('')));

}
});

sablono.core.color_field94928.cljs$core$IFn$_invoke$arity$1 = (function (name__46585__auto__){
return sablono.core.color_field94928.call(null,name__46585__auto__,null);
});

sablono.core.color_field94928.cljs$core$IFn$_invoke$arity$2 = (function (name__46585__auto__,value__46586__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"color","color",-1642760596,null))].join(''),name__46585__auto__,value__46586__auto__);
});

sablono.core.color_field94928.cljs$lang$maxFixedArity = 2;


sablono.core.color_field = sablono.core.wrap_attrs.call(null,sablono.core.color_field94928);

/**
 * Creates a date input field.
 */
sablono.core.date_field94932 = (function sablono$core$date_field94932(var_args){
var args94933 = [];
var len__28496__auto___95000 = arguments.length;
var i__28497__auto___95001 = (0);
while(true){
if((i__28497__auto___95001 < len__28496__auto___95000)){
args94933.push((arguments[i__28497__auto___95001]));

var G__95002 = (i__28497__auto___95001 + (1));
i__28497__auto___95001 = G__95002;
continue;
} else {
}
break;
}

var G__94935 = args94933.length;
switch (G__94935) {
case 1:
return sablono.core.date_field94932.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.date_field94932.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94933.length)].join('')));

}
});

sablono.core.date_field94932.cljs$core$IFn$_invoke$arity$1 = (function (name__46585__auto__){
return sablono.core.date_field94932.call(null,name__46585__auto__,null);
});

sablono.core.date_field94932.cljs$core$IFn$_invoke$arity$2 = (function (name__46585__auto__,value__46586__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"date","date",177097065,null))].join(''),name__46585__auto__,value__46586__auto__);
});

sablono.core.date_field94932.cljs$lang$maxFixedArity = 2;


sablono.core.date_field = sablono.core.wrap_attrs.call(null,sablono.core.date_field94932);

/**
 * Creates a datetime input field.
 */
sablono.core.datetime_field94936 = (function sablono$core$datetime_field94936(var_args){
var args94937 = [];
var len__28496__auto___95004 = arguments.length;
var i__28497__auto___95005 = (0);
while(true){
if((i__28497__auto___95005 < len__28496__auto___95004)){
args94937.push((arguments[i__28497__auto___95005]));

var G__95006 = (i__28497__auto___95005 + (1));
i__28497__auto___95005 = G__95006;
continue;
} else {
}
break;
}

var G__94939 = args94937.length;
switch (G__94939) {
case 1:
return sablono.core.datetime_field94936.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_field94936.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94937.length)].join('')));

}
});

sablono.core.datetime_field94936.cljs$core$IFn$_invoke$arity$1 = (function (name__46585__auto__){
return sablono.core.datetime_field94936.call(null,name__46585__auto__,null);
});

sablono.core.datetime_field94936.cljs$core$IFn$_invoke$arity$2 = (function (name__46585__auto__,value__46586__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime","datetime",2135207229,null))].join(''),name__46585__auto__,value__46586__auto__);
});

sablono.core.datetime_field94936.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_field94936);

/**
 * Creates a datetime-local input field.
 */
sablono.core.datetime_local_field94940 = (function sablono$core$datetime_local_field94940(var_args){
var args94941 = [];
var len__28496__auto___95008 = arguments.length;
var i__28497__auto___95009 = (0);
while(true){
if((i__28497__auto___95009 < len__28496__auto___95008)){
args94941.push((arguments[i__28497__auto___95009]));

var G__95010 = (i__28497__auto___95009 + (1));
i__28497__auto___95009 = G__95010;
continue;
} else {
}
break;
}

var G__94943 = args94941.length;
switch (G__94943) {
case 1:
return sablono.core.datetime_local_field94940.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.datetime_local_field94940.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94941.length)].join('')));

}
});

sablono.core.datetime_local_field94940.cljs$core$IFn$_invoke$arity$1 = (function (name__46585__auto__){
return sablono.core.datetime_local_field94940.call(null,name__46585__auto__,null);
});

sablono.core.datetime_local_field94940.cljs$core$IFn$_invoke$arity$2 = (function (name__46585__auto__,value__46586__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"datetime-local","datetime-local",-507312697,null))].join(''),name__46585__auto__,value__46586__auto__);
});

sablono.core.datetime_local_field94940.cljs$lang$maxFixedArity = 2;


sablono.core.datetime_local_field = sablono.core.wrap_attrs.call(null,sablono.core.datetime_local_field94940);

/**
 * Creates a email input field.
 */
sablono.core.email_field94944 = (function sablono$core$email_field94944(var_args){
var args94945 = [];
var len__28496__auto___95012 = arguments.length;
var i__28497__auto___95013 = (0);
while(true){
if((i__28497__auto___95013 < len__28496__auto___95012)){
args94945.push((arguments[i__28497__auto___95013]));

var G__95014 = (i__28497__auto___95013 + (1));
i__28497__auto___95013 = G__95014;
continue;
} else {
}
break;
}

var G__94947 = args94945.length;
switch (G__94947) {
case 1:
return sablono.core.email_field94944.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.email_field94944.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94945.length)].join('')));

}
});

sablono.core.email_field94944.cljs$core$IFn$_invoke$arity$1 = (function (name__46585__auto__){
return sablono.core.email_field94944.call(null,name__46585__auto__,null);
});

sablono.core.email_field94944.cljs$core$IFn$_invoke$arity$2 = (function (name__46585__auto__,value__46586__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"email","email",-1238619063,null))].join(''),name__46585__auto__,value__46586__auto__);
});

sablono.core.email_field94944.cljs$lang$maxFixedArity = 2;


sablono.core.email_field = sablono.core.wrap_attrs.call(null,sablono.core.email_field94944);

/**
 * Creates a file input field.
 */
sablono.core.file_field94948 = (function sablono$core$file_field94948(var_args){
var args94949 = [];
var len__28496__auto___95016 = arguments.length;
var i__28497__auto___95017 = (0);
while(true){
if((i__28497__auto___95017 < len__28496__auto___95016)){
args94949.push((arguments[i__28497__auto___95017]));

var G__95018 = (i__28497__auto___95017 + (1));
i__28497__auto___95017 = G__95018;
continue;
} else {
}
break;
}

var G__94951 = args94949.length;
switch (G__94951) {
case 1:
return sablono.core.file_field94948.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.file_field94948.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94949.length)].join('')));

}
});

sablono.core.file_field94948.cljs$core$IFn$_invoke$arity$1 = (function (name__46585__auto__){
return sablono.core.file_field94948.call(null,name__46585__auto__,null);
});

sablono.core.file_field94948.cljs$core$IFn$_invoke$arity$2 = (function (name__46585__auto__,value__46586__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"file","file",370885649,null))].join(''),name__46585__auto__,value__46586__auto__);
});

sablono.core.file_field94948.cljs$lang$maxFixedArity = 2;


sablono.core.file_field = sablono.core.wrap_attrs.call(null,sablono.core.file_field94948);

/**
 * Creates a hidden input field.
 */
sablono.core.hidden_field94952 = (function sablono$core$hidden_field94952(var_args){
var args94953 = [];
var len__28496__auto___95020 = arguments.length;
var i__28497__auto___95021 = (0);
while(true){
if((i__28497__auto___95021 < len__28496__auto___95020)){
args94953.push((arguments[i__28497__auto___95021]));

var G__95022 = (i__28497__auto___95021 + (1));
i__28497__auto___95021 = G__95022;
continue;
} else {
}
break;
}

var G__94955 = args94953.length;
switch (G__94955) {
case 1:
return sablono.core.hidden_field94952.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.hidden_field94952.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94953.length)].join('')));

}
});

sablono.core.hidden_field94952.cljs$core$IFn$_invoke$arity$1 = (function (name__46585__auto__){
return sablono.core.hidden_field94952.call(null,name__46585__auto__,null);
});

sablono.core.hidden_field94952.cljs$core$IFn$_invoke$arity$2 = (function (name__46585__auto__,value__46586__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"hidden","hidden",1328025435,null))].join(''),name__46585__auto__,value__46586__auto__);
});

sablono.core.hidden_field94952.cljs$lang$maxFixedArity = 2;


sablono.core.hidden_field = sablono.core.wrap_attrs.call(null,sablono.core.hidden_field94952);

/**
 * Creates a month input field.
 */
sablono.core.month_field94956 = (function sablono$core$month_field94956(var_args){
var args94957 = [];
var len__28496__auto___95024 = arguments.length;
var i__28497__auto___95025 = (0);
while(true){
if((i__28497__auto___95025 < len__28496__auto___95024)){
args94957.push((arguments[i__28497__auto___95025]));

var G__95026 = (i__28497__auto___95025 + (1));
i__28497__auto___95025 = G__95026;
continue;
} else {
}
break;
}

var G__94959 = args94957.length;
switch (G__94959) {
case 1:
return sablono.core.month_field94956.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.month_field94956.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94957.length)].join('')));

}
});

sablono.core.month_field94956.cljs$core$IFn$_invoke$arity$1 = (function (name__46585__auto__){
return sablono.core.month_field94956.call(null,name__46585__auto__,null);
});

sablono.core.month_field94956.cljs$core$IFn$_invoke$arity$2 = (function (name__46585__auto__,value__46586__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"month","month",-319717006,null))].join(''),name__46585__auto__,value__46586__auto__);
});

sablono.core.month_field94956.cljs$lang$maxFixedArity = 2;


sablono.core.month_field = sablono.core.wrap_attrs.call(null,sablono.core.month_field94956);

/**
 * Creates a number input field.
 */
sablono.core.number_field94960 = (function sablono$core$number_field94960(var_args){
var args94961 = [];
var len__28496__auto___95028 = arguments.length;
var i__28497__auto___95029 = (0);
while(true){
if((i__28497__auto___95029 < len__28496__auto___95028)){
args94961.push((arguments[i__28497__auto___95029]));

var G__95030 = (i__28497__auto___95029 + (1));
i__28497__auto___95029 = G__95030;
continue;
} else {
}
break;
}

var G__94963 = args94961.length;
switch (G__94963) {
case 1:
return sablono.core.number_field94960.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.number_field94960.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94961.length)].join('')));

}
});

sablono.core.number_field94960.cljs$core$IFn$_invoke$arity$1 = (function (name__46585__auto__){
return sablono.core.number_field94960.call(null,name__46585__auto__,null);
});

sablono.core.number_field94960.cljs$core$IFn$_invoke$arity$2 = (function (name__46585__auto__,value__46586__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"number","number",-1084057331,null))].join(''),name__46585__auto__,value__46586__auto__);
});

sablono.core.number_field94960.cljs$lang$maxFixedArity = 2;


sablono.core.number_field = sablono.core.wrap_attrs.call(null,sablono.core.number_field94960);

/**
 * Creates a password input field.
 */
sablono.core.password_field94964 = (function sablono$core$password_field94964(var_args){
var args94965 = [];
var len__28496__auto___95032 = arguments.length;
var i__28497__auto___95033 = (0);
while(true){
if((i__28497__auto___95033 < len__28496__auto___95032)){
args94965.push((arguments[i__28497__auto___95033]));

var G__95034 = (i__28497__auto___95033 + (1));
i__28497__auto___95033 = G__95034;
continue;
} else {
}
break;
}

var G__94967 = args94965.length;
switch (G__94967) {
case 1:
return sablono.core.password_field94964.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.password_field94964.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94965.length)].join('')));

}
});

sablono.core.password_field94964.cljs$core$IFn$_invoke$arity$1 = (function (name__46585__auto__){
return sablono.core.password_field94964.call(null,name__46585__auto__,null);
});

sablono.core.password_field94964.cljs$core$IFn$_invoke$arity$2 = (function (name__46585__auto__,value__46586__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"password","password",2057553998,null))].join(''),name__46585__auto__,value__46586__auto__);
});

sablono.core.password_field94964.cljs$lang$maxFixedArity = 2;


sablono.core.password_field = sablono.core.wrap_attrs.call(null,sablono.core.password_field94964);

/**
 * Creates a range input field.
 */
sablono.core.range_field94968 = (function sablono$core$range_field94968(var_args){
var args94969 = [];
var len__28496__auto___95036 = arguments.length;
var i__28497__auto___95037 = (0);
while(true){
if((i__28497__auto___95037 < len__28496__auto___95036)){
args94969.push((arguments[i__28497__auto___95037]));

var G__95038 = (i__28497__auto___95037 + (1));
i__28497__auto___95037 = G__95038;
continue;
} else {
}
break;
}

var G__94971 = args94969.length;
switch (G__94971) {
case 1:
return sablono.core.range_field94968.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.range_field94968.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94969.length)].join('')));

}
});

sablono.core.range_field94968.cljs$core$IFn$_invoke$arity$1 = (function (name__46585__auto__){
return sablono.core.range_field94968.call(null,name__46585__auto__,null);
});

sablono.core.range_field94968.cljs$core$IFn$_invoke$arity$2 = (function (name__46585__auto__,value__46586__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"range","range",-1014743483,null))].join(''),name__46585__auto__,value__46586__auto__);
});

sablono.core.range_field94968.cljs$lang$maxFixedArity = 2;


sablono.core.range_field = sablono.core.wrap_attrs.call(null,sablono.core.range_field94968);

/**
 * Creates a search input field.
 */
sablono.core.search_field94972 = (function sablono$core$search_field94972(var_args){
var args94973 = [];
var len__28496__auto___95040 = arguments.length;
var i__28497__auto___95041 = (0);
while(true){
if((i__28497__auto___95041 < len__28496__auto___95040)){
args94973.push((arguments[i__28497__auto___95041]));

var G__95042 = (i__28497__auto___95041 + (1));
i__28497__auto___95041 = G__95042;
continue;
} else {
}
break;
}

var G__94975 = args94973.length;
switch (G__94975) {
case 1:
return sablono.core.search_field94972.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.search_field94972.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94973.length)].join('')));

}
});

sablono.core.search_field94972.cljs$core$IFn$_invoke$arity$1 = (function (name__46585__auto__){
return sablono.core.search_field94972.call(null,name__46585__auto__,null);
});

sablono.core.search_field94972.cljs$core$IFn$_invoke$arity$2 = (function (name__46585__auto__,value__46586__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"search","search",-1089495947,null))].join(''),name__46585__auto__,value__46586__auto__);
});

sablono.core.search_field94972.cljs$lang$maxFixedArity = 2;


sablono.core.search_field = sablono.core.wrap_attrs.call(null,sablono.core.search_field94972);

/**
 * Creates a tel input field.
 */
sablono.core.tel_field94976 = (function sablono$core$tel_field94976(var_args){
var args94977 = [];
var len__28496__auto___95044 = arguments.length;
var i__28497__auto___95045 = (0);
while(true){
if((i__28497__auto___95045 < len__28496__auto___95044)){
args94977.push((arguments[i__28497__auto___95045]));

var G__95046 = (i__28497__auto___95045 + (1));
i__28497__auto___95045 = G__95046;
continue;
} else {
}
break;
}

var G__94979 = args94977.length;
switch (G__94979) {
case 1:
return sablono.core.tel_field94976.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.tel_field94976.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94977.length)].join('')));

}
});

sablono.core.tel_field94976.cljs$core$IFn$_invoke$arity$1 = (function (name__46585__auto__){
return sablono.core.tel_field94976.call(null,name__46585__auto__,null);
});

sablono.core.tel_field94976.cljs$core$IFn$_invoke$arity$2 = (function (name__46585__auto__,value__46586__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"tel","tel",1864669686,null))].join(''),name__46585__auto__,value__46586__auto__);
});

sablono.core.tel_field94976.cljs$lang$maxFixedArity = 2;


sablono.core.tel_field = sablono.core.wrap_attrs.call(null,sablono.core.tel_field94976);

/**
 * Creates a text input field.
 */
sablono.core.text_field94980 = (function sablono$core$text_field94980(var_args){
var args94981 = [];
var len__28496__auto___95048 = arguments.length;
var i__28497__auto___95049 = (0);
while(true){
if((i__28497__auto___95049 < len__28496__auto___95048)){
args94981.push((arguments[i__28497__auto___95049]));

var G__95050 = (i__28497__auto___95049 + (1));
i__28497__auto___95049 = G__95050;
continue;
} else {
}
break;
}

var G__94983 = args94981.length;
switch (G__94983) {
case 1:
return sablono.core.text_field94980.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_field94980.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94981.length)].join('')));

}
});

sablono.core.text_field94980.cljs$core$IFn$_invoke$arity$1 = (function (name__46585__auto__){
return sablono.core.text_field94980.call(null,name__46585__auto__,null);
});

sablono.core.text_field94980.cljs$core$IFn$_invoke$arity$2 = (function (name__46585__auto__,value__46586__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"text","text",-150030170,null))].join(''),name__46585__auto__,value__46586__auto__);
});

sablono.core.text_field94980.cljs$lang$maxFixedArity = 2;


sablono.core.text_field = sablono.core.wrap_attrs.call(null,sablono.core.text_field94980);

/**
 * Creates a time input field.
 */
sablono.core.time_field94984 = (function sablono$core$time_field94984(var_args){
var args94985 = [];
var len__28496__auto___95052 = arguments.length;
var i__28497__auto___95053 = (0);
while(true){
if((i__28497__auto___95053 < len__28496__auto___95052)){
args94985.push((arguments[i__28497__auto___95053]));

var G__95054 = (i__28497__auto___95053 + (1));
i__28497__auto___95053 = G__95054;
continue;
} else {
}
break;
}

var G__94987 = args94985.length;
switch (G__94987) {
case 1:
return sablono.core.time_field94984.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.time_field94984.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94985.length)].join('')));

}
});

sablono.core.time_field94984.cljs$core$IFn$_invoke$arity$1 = (function (name__46585__auto__){
return sablono.core.time_field94984.call(null,name__46585__auto__,null);
});

sablono.core.time_field94984.cljs$core$IFn$_invoke$arity$2 = (function (name__46585__auto__,value__46586__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"time","time",-1268547887,null))].join(''),name__46585__auto__,value__46586__auto__);
});

sablono.core.time_field94984.cljs$lang$maxFixedArity = 2;


sablono.core.time_field = sablono.core.wrap_attrs.call(null,sablono.core.time_field94984);

/**
 * Creates a url input field.
 */
sablono.core.url_field94988 = (function sablono$core$url_field94988(var_args){
var args94989 = [];
var len__28496__auto___95056 = arguments.length;
var i__28497__auto___95057 = (0);
while(true){
if((i__28497__auto___95057 < len__28496__auto___95056)){
args94989.push((arguments[i__28497__auto___95057]));

var G__95058 = (i__28497__auto___95057 + (1));
i__28497__auto___95057 = G__95058;
continue;
} else {
}
break;
}

var G__94991 = args94989.length;
switch (G__94991) {
case 1:
return sablono.core.url_field94988.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.url_field94988.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94989.length)].join('')));

}
});

sablono.core.url_field94988.cljs$core$IFn$_invoke$arity$1 = (function (name__46585__auto__){
return sablono.core.url_field94988.call(null,name__46585__auto__,null);
});

sablono.core.url_field94988.cljs$core$IFn$_invoke$arity$2 = (function (name__46585__auto__,value__46586__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"url","url",1916828573,null))].join(''),name__46585__auto__,value__46586__auto__);
});

sablono.core.url_field94988.cljs$lang$maxFixedArity = 2;


sablono.core.url_field = sablono.core.wrap_attrs.call(null,sablono.core.url_field94988);

/**
 * Creates a week input field.
 */
sablono.core.week_field94992 = (function sablono$core$week_field94992(var_args){
var args94993 = [];
var len__28496__auto___95060 = arguments.length;
var i__28497__auto___95061 = (0);
while(true){
if((i__28497__auto___95061 < len__28496__auto___95060)){
args94993.push((arguments[i__28497__auto___95061]));

var G__95062 = (i__28497__auto___95061 + (1));
i__28497__auto___95061 = G__95062;
continue;
} else {
}
break;
}

var G__94995 = args94993.length;
switch (G__94995) {
case 1:
return sablono.core.week_field94992.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.week_field94992.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args94993.length)].join('')));

}
});

sablono.core.week_field94992.cljs$core$IFn$_invoke$arity$1 = (function (name__46585__auto__){
return sablono.core.week_field94992.call(null,name__46585__auto__,null);
});

sablono.core.week_field94992.cljs$core$IFn$_invoke$arity$2 = (function (name__46585__auto__,value__46586__auto__){
return sablono.core.input_field_STAR_.call(null,[cljs.core.str(new cljs.core.Symbol(null,"week","week",314058249,null))].join(''),name__46585__auto__,value__46586__auto__);
});

sablono.core.week_field94992.cljs$lang$maxFixedArity = 2;


sablono.core.week_field = sablono.core.wrap_attrs.call(null,sablono.core.week_field94992);
sablono.core.file_upload = sablono.core.file_field;
/**
 * Creates a check box.
 */
sablono.core.check_box95064 = (function sablono$core$check_box95064(var_args){
var args95065 = [];
var len__28496__auto___95068 = arguments.length;
var i__28497__auto___95069 = (0);
while(true){
if((i__28497__auto___95069 < len__28496__auto___95068)){
args95065.push((arguments[i__28497__auto___95069]));

var G__95070 = (i__28497__auto___95069 + (1));
i__28497__auto___95069 = G__95070;
continue;
} else {
}
break;
}

var G__95067 = args95065.length;
switch (G__95067) {
case 1:
return sablono.core.check_box95064.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.check_box95064.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.check_box95064.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args95065.length)].join('')));

}
});

sablono.core.check_box95064.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.check_box95064.call(null,name,null);
});

sablono.core.check_box95064.cljs$core$IFn$_invoke$arity$2 = (function (name,checked_QMARK_){
return sablono.core.check_box95064.call(null,name,checked_QMARK_,"true");
});

sablono.core.check_box95064.cljs$core$IFn$_invoke$arity$3 = (function (name,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"checkbox",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__27280__auto__ = value;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.check_box95064.cljs$lang$maxFixedArity = 3;


sablono.core.check_box = sablono.core.wrap_attrs.call(null,sablono.core.check_box95064);
/**
 * Creates a radio button.
 */
sablono.core.radio_button95072 = (function sablono$core$radio_button95072(var_args){
var args95073 = [];
var len__28496__auto___95076 = arguments.length;
var i__28497__auto___95077 = (0);
while(true){
if((i__28497__auto___95077 < len__28496__auto___95076)){
args95073.push((arguments[i__28497__auto___95077]));

var G__95078 = (i__28497__auto___95077 + (1));
i__28497__auto___95077 = G__95078;
continue;
} else {
}
break;
}

var G__95075 = args95073.length;
switch (G__95075) {
case 1:
return sablono.core.radio_button95072.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.radio_button95072.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.radio_button95072.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args95073.length)].join('')));

}
});

sablono.core.radio_button95072.cljs$core$IFn$_invoke$arity$1 = (function (group){
return sablono.core.radio_button95072.call(null,group,null);
});

sablono.core.radio_button95072.cljs$core$IFn$_invoke$arity$2 = (function (group,checked_QMARK_){
return sablono.core.radio_button95072.call(null,group,checked_QMARK_,"true");
});

sablono.core.radio_button95072.cljs$core$IFn$_invoke$arity$3 = (function (group,checked_QMARK_,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"type","type",1174270348),"radio",new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,group),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,[cljs.core.str(sablono.util.as_str.call(null,group)),cljs.core.str("-"),cljs.core.str(sablono.util.as_str.call(null,value))].join('')),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__27280__auto__ = value;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return undefined;
}
})(),new cljs.core.Keyword(null,"checked","checked",-50955819),checked_QMARK_], null)], null);
});

sablono.core.radio_button95072.cljs$lang$maxFixedArity = 3;


sablono.core.radio_button = sablono.core.wrap_attrs.call(null,sablono.core.radio_button95072);
sablono.core.hash_key = (function sablono$core$hash_key(x){
return goog.string.hashCode(cljs.core.pr_str.call(null,x));
});
/**
 * Creates a seq of option tags from a collection.
 */
sablono.core.select_options95080 = (function sablono$core$select_options95080(coll){
var iter__28137__auto__ = (function sablono$core$select_options95080_$_iter__95097(s__95098){
return (new cljs.core.LazySeq(null,(function (){
var s__95098__$1 = s__95098;
while(true){
var temp__6753__auto__ = cljs.core.seq.call(null,s__95098__$1);
if(temp__6753__auto__){
var s__95098__$2 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,s__95098__$2)){
var c__28135__auto__ = cljs.core.chunk_first.call(null,s__95098__$2);
var size__28136__auto__ = cljs.core.count.call(null,c__28135__auto__);
var b__95100 = cljs.core.chunk_buffer.call(null,size__28136__auto__);
if((function (){var i__95099 = (0);
while(true){
if((i__95099 < size__28136__auto__)){
var x = cljs.core._nth.call(null,c__28135__auto__,i__95099);
cljs.core.chunk_append.call(null,b__95100,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__95107 = x;
var text = cljs.core.nth.call(null,vec__95107,(0),null);
var val = cljs.core.nth.call(null,vec__95107,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__95107,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options95080.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)));

var G__95113 = (i__95099 + (1));
i__95099 = G__95113;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__95100),sablono$core$select_options95080_$_iter__95097.call(null,cljs.core.chunk_rest.call(null,s__95098__$2)));
} else {
return cljs.core.chunk_cons.call(null,cljs.core.chunk.call(null,b__95100),null);
}
} else {
var x = cljs.core.first.call(null,s__95098__$2);
return cljs.core.cons.call(null,((cljs.core.sequential_QMARK_.call(null,x))?(function (){var vec__95110 = x;
var text = cljs.core.nth.call(null,vec__95110,(0),null);
var val = cljs.core.nth.call(null,vec__95110,(1),null);
var disabled_QMARK_ = cljs.core.nth.call(null,vec__95110,(2),null);
var disabled_QMARK___$1 = cljs.core.boolean$.call(null,disabled_QMARK_);
if(cljs.core.sequential_QMARK_.call(null,val)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"optgroup","optgroup",1738282218),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,text),new cljs.core.Keyword(null,"label","label",1718410804),text], null),sablono.core.select_options95080.call(null,val)], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"disabled","disabled",-1529784218),disabled_QMARK___$1,new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,val),new cljs.core.Keyword(null,"value","value",305978217),val], null),text], null);
}
})():new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"option","option",65132272),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"key","key",-1516042587),sablono.core.hash_key.call(null,x),new cljs.core.Keyword(null,"value","value",305978217),x], null),x], null)),sablono$core$select_options95080_$_iter__95097.call(null,cljs.core.rest.call(null,s__95098__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__28137__auto__.call(null,coll);
});

sablono.core.select_options = sablono.core.wrap_attrs.call(null,sablono.core.select_options95080);
/**
 * Creates a drop-down box using the <select> tag.
 */
sablono.core.drop_down95114 = (function sablono$core$drop_down95114(var_args){
var args95115 = [];
var len__28496__auto___95118 = arguments.length;
var i__28497__auto___95119 = (0);
while(true){
if((i__28497__auto___95119 < len__28496__auto___95118)){
args95115.push((arguments[i__28497__auto___95119]));

var G__95120 = (i__28497__auto___95119 + (1));
i__28497__auto___95119 = G__95120;
continue;
} else {
}
break;
}

var G__95117 = args95115.length;
switch (G__95117) {
case 2:
return sablono.core.drop_down95114.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return sablono.core.drop_down95114.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args95115.length)].join('')));

}
});

sablono.core.drop_down95114.cljs$core$IFn$_invoke$arity$2 = (function (name,options){
return sablono.core.drop_down95114.call(null,name,options,null);
});

sablono.core.drop_down95114.cljs$core$IFn$_invoke$arity$3 = (function (name,options,selected){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"select","select",1147833503),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name)], null),sablono.core.select_options.call(null,options,selected)], null);
});

sablono.core.drop_down95114.cljs$lang$maxFixedArity = 3;


sablono.core.drop_down = sablono.core.wrap_attrs.call(null,sablono.core.drop_down95114);
/**
 * Creates a text area element.
 */
sablono.core.text_area95122 = (function sablono$core$text_area95122(var_args){
var args95123 = [];
var len__28496__auto___95126 = arguments.length;
var i__28497__auto___95127 = (0);
while(true){
if((i__28497__auto___95127 < len__28496__auto___95126)){
args95123.push((arguments[i__28497__auto___95127]));

var G__95128 = (i__28497__auto___95127 + (1));
i__28497__auto___95127 = G__95128;
continue;
} else {
}
break;
}

var G__95125 = args95123.length;
switch (G__95125) {
case 1:
return sablono.core.text_area95122.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return sablono.core.text_area95122.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args95123.length)].join('')));

}
});

sablono.core.text_area95122.cljs$core$IFn$_invoke$arity$1 = (function (name){
return sablono.core.text_area95122.call(null,name,null);
});

sablono.core.text_area95122.cljs$core$IFn$_invoke$arity$2 = (function (name,value){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"textarea","textarea",-650375824),new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"name","name",1843675177),sablono.core.make_name.call(null,name),new cljs.core.Keyword(null,"id","id",-1388402092),sablono.core.make_id.call(null,name),new cljs.core.Keyword(null,"value","value",305978217),(function (){var or__27280__auto__ = value;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return undefined;
}
})()], null)], null);
});

sablono.core.text_area95122.cljs$lang$maxFixedArity = 2;


sablono.core.text_area = sablono.core.wrap_attrs.call(null,sablono.core.text_area95122);
/**
 * Creates a label for an input field with the supplied name.
 */
sablono.core.label95130 = (function sablono$core$label95130(name,text){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"label","label",1718410804),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"htmlFor","htmlFor",-1050291720),sablono.core.make_id.call(null,name)], null),text], null);
});

sablono.core.label = sablono.core.wrap_attrs.call(null,sablono.core.label95130);
/**
 * Creates a submit button.
 */
sablono.core.submit_button95131 = (function sablono$core$submit_button95131(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"submit",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.submit_button = sablono.core.wrap_attrs.call(null,sablono.core.submit_button95131);
/**
 * Creates a form reset button.
 */
sablono.core.reset_button95132 = (function sablono$core$reset_button95132(text){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"input","input",556931961),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"type","type",1174270348),"reset",new cljs.core.Keyword(null,"value","value",305978217),text], null)], null);
});

sablono.core.reset_button = sablono.core.wrap_attrs.call(null,sablono.core.reset_button95132);
/**
 * Create a form that points to a particular method and route.
 *   e.g. (form-to [:put "/post"]
 *       ...)
 */
sablono.core.form_to95133 = (function sablono$core$form_to95133(var_args){
var args__28503__auto__ = [];
var len__28496__auto___95140 = arguments.length;
var i__28497__auto___95141 = (0);
while(true){
if((i__28497__auto___95141 < len__28496__auto___95140)){
args__28503__auto__.push((arguments[i__28497__auto___95141]));

var G__95142 = (i__28497__auto___95141 + (1));
i__28497__auto___95141 = G__95142;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((1) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((1)),(0),null)):null);
return sablono.core.form_to95133.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28504__auto__);
});

sablono.core.form_to95133.cljs$core$IFn$_invoke$arity$variadic = (function (p__95136,body){
var vec__95137 = p__95136;
var method = cljs.core.nth.call(null,vec__95137,(0),null);
var action = cljs.core.nth.call(null,vec__95137,(1),null);
var method_str = clojure.string.upper_case.call(null,cljs.core.name.call(null,method));
var action_uri = sablono.util.to_uri.call(null,action);
return cljs.core.vec.call(null,cljs.core.concat.call(null,((cljs.core.contains_QMARK_.call(null,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"get","get",1683182755),null,new cljs.core.Keyword(null,"post","post",269697687),null], null), null),method))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),method_str,new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null)], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"form","form",-1624062471),new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),"POST",new cljs.core.Keyword(null,"action","action",-811238024),action_uri], null),sablono.core.hidden_field.call(null,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"key","key",-1516042587),(3735928559)], null),"_method",method_str)], null)),body));
});

sablono.core.form_to95133.cljs$lang$maxFixedArity = (1);

sablono.core.form_to95133.cljs$lang$applyTo = (function (seq95134){
var G__95135 = cljs.core.first.call(null,seq95134);
var seq95134__$1 = cljs.core.next.call(null,seq95134);
return sablono.core.form_to95133.cljs$core$IFn$_invoke$arity$variadic(G__95135,seq95134__$1);
});


sablono.core.form_to = sablono.core.wrap_attrs.call(null,sablono.core.form_to95133);

//# sourceMappingURL=core.js.map?rel=1483479079798