// Compiled by ClojureScript 1.9.293 {}
goog.provide('devtools.core');
goog.require('cljs.core');
goog.require('devtools.prefs');
goog.require('devtools.sanity_hints');
goog.require('devtools.dirac');
goog.require('devtools.custom_formatters');
goog.require('devtools.util');
goog.require('goog.userAgent');
devtools.core.known_features = new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"custom-formatters","custom-formatters",-863243779),new cljs.core.Keyword(null,"install-custom-formatters","install-custom-formatters",-1653731327),new cljs.core.Keyword(null,"dirac","dirac",1785994033),new cljs.core.Keyword(null,"install-dirac-support","install-dirac-support",-949928649),new cljs.core.Keyword(null,"sanity-hints","sanity-hints",1201436858),new cljs.core.Keyword(null,"install-sanity-hints","install-sanity-hints",72546145)], null);
devtools.core.missing_feature_warning = (function devtools$core$missing_feature_warning(feature,known_features){
return [cljs.core.str("No such feature '"),cljs.core.str(feature),cljs.core.str("' is currently available in cljs-devtools. "),cljs.core.str("List of supported features:"),cljs.core.str(cljs.core.keys.call(null,known_features))].join('');
});
devtools.core.warn_feature_not_available = (function devtools$core$warn_feature_not_available(feature){
return console.warn([cljs.core.str("Feature '"),cljs.core.str(cljs.core.name.call(null,feature)),cljs.core.str("' cannot be installed. Unsupported browser "),cljs.core.str(goog.userAgent.getUserAgentString()),cljs.core.str(".")].join(''));
});
devtools.core.install_BANG_ = (function devtools$core$install_BANG_(){
devtools.util.display_banner.call(null,"Installing cljs-devtools:",devtools.core.known_features);

if(cljs.core.truth_(devtools.prefs.pref.call(null,new cljs.core.Keyword(null,"install-custom-formatters","install-custom-formatters",-1653731327)))){
if(cljs.core.truth_(devtools.custom_formatters.available_QMARK_.call(null))){
devtools.custom_formatters.install_BANG_.call(null);
} else {
devtools.core.warn_feature_not_available.call(null,new cljs.core.Keyword(null,"custom-formatters","custom-formatters",-863243779));
}
} else {
}

if(cljs.core.truth_(devtools.prefs.pref.call(null,new cljs.core.Keyword(null,"install-sanity-hints","install-sanity-hints",72546145)))){
if(cljs.core.truth_(devtools.sanity_hints.available_QMARK_.call(null))){
devtools.sanity_hints.install_BANG_.call(null);
} else {
devtools.core.warn_feature_not_available.call(null,new cljs.core.Keyword(null,"sanity-hints","sanity-hints",1201436858));
}
} else {
}

if(cljs.core.truth_(devtools.prefs.pref.call(null,new cljs.core.Keyword(null,"install-dirac-support","install-dirac-support",-949928649)))){
if(cljs.core.truth_(devtools.dirac.available_QMARK_.call(null))){
return devtools.dirac.install_BANG_.call(null);
} else {
return devtools.core.warn_feature_not_available.call(null,new cljs.core.Keyword(null,"dirac","dirac",1785994033));
}
} else {
return null;
}
});
devtools.core.uninstall_BANG_ = (function devtools$core$uninstall_BANG_(){
devtools.custom_formatters.uninstall_BANG_.call(null);

devtools.sanity_hints.uninstall_BANG_.call(null);

return devtools.dirac.uninstall_BANG_.call(null);
});
devtools.core.set_prefs_BANG_ = (function devtools$core$set_prefs_BANG_(new_prefs){
return devtools.prefs.set_prefs_BANG_.call(null,new_prefs);
});
devtools.core.get_prefs = (function devtools$core$get_prefs(){
return devtools.prefs.get_prefs.call(null);
});
devtools.core.set_pref_BANG_ = (function devtools$core$set_pref_BANG_(pref,val){
return devtools.prefs.set_pref_BANG_.call(null,pref,val);
});
devtools.core.set_single_feature_BANG_ = (function devtools$core$set_single_feature_BANG_(feature,val){
var temp__6751__auto__ = feature.call(null,devtools.core.known_features);
if(cljs.core.truth_(temp__6751__auto__)){
var feature_installation_key = temp__6751__auto__;
return devtools.core.set_pref_BANG_.call(null,feature_installation_key,val);
} else {
return console.warn(devtools.core.missing_feature_warning.call(null,feature,devtools.core.known_features));
}
});
devtools.core.enable_single_feature_BANG_ = (function devtools$core$enable_single_feature_BANG_(feature){
return devtools.core.set_single_feature_BANG_.call(null,feature,true);
});
devtools.core.disable_single_feature_BANG_ = (function devtools$core$disable_single_feature_BANG_(feature){
return devtools.core.set_single_feature_BANG_.call(null,feature,false);
});
devtools.core.enable_feature_BANG_ = (function devtools$core$enable_feature_BANG_(var_args){
var args__28503__auto__ = [];
var len__28496__auto___100036 = arguments.length;
var i__28497__auto___100037 = (0);
while(true){
if((i__28497__auto___100037 < len__28496__auto___100036)){
args__28503__auto__.push((arguments[i__28497__auto___100037]));

var G__100038 = (i__28497__auto___100037 + (1));
i__28497__auto___100037 = G__100038;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((0) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((0)),(0),null)):null);
return devtools.core.enable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__28504__auto__);
});

devtools.core.enable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (features){
var seq__100032 = cljs.core.seq.call(null,features);
var chunk__100033 = null;
var count__100034 = (0);
var i__100035 = (0);
while(true){
if((i__100035 < count__100034)){
var feature = cljs.core._nth.call(null,chunk__100033,i__100035);
devtools.core.enable_single_feature_BANG_.call(null,feature);

var G__100039 = seq__100032;
var G__100040 = chunk__100033;
var G__100041 = count__100034;
var G__100042 = (i__100035 + (1));
seq__100032 = G__100039;
chunk__100033 = G__100040;
count__100034 = G__100041;
i__100035 = G__100042;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__100032);
if(temp__6753__auto__){
var seq__100032__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__100032__$1)){
var c__28186__auto__ = cljs.core.chunk_first.call(null,seq__100032__$1);
var G__100043 = cljs.core.chunk_rest.call(null,seq__100032__$1);
var G__100044 = c__28186__auto__;
var G__100045 = cljs.core.count.call(null,c__28186__auto__);
var G__100046 = (0);
seq__100032 = G__100043;
chunk__100033 = G__100044;
count__100034 = G__100045;
i__100035 = G__100046;
continue;
} else {
var feature = cljs.core.first.call(null,seq__100032__$1);
devtools.core.enable_single_feature_BANG_.call(null,feature);

var G__100047 = cljs.core.next.call(null,seq__100032__$1);
var G__100048 = null;
var G__100049 = (0);
var G__100050 = (0);
seq__100032 = G__100047;
chunk__100033 = G__100048;
count__100034 = G__100049;
i__100035 = G__100050;
continue;
}
} else {
return null;
}
}
break;
}
});

devtools.core.enable_feature_BANG_.cljs$lang$maxFixedArity = (0);

devtools.core.enable_feature_BANG_.cljs$lang$applyTo = (function (seq100031){
return devtools.core.enable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq100031));
});

devtools.core.disable_feature_BANG_ = (function devtools$core$disable_feature_BANG_(var_args){
var args__28503__auto__ = [];
var len__28496__auto___100056 = arguments.length;
var i__28497__auto___100057 = (0);
while(true){
if((i__28497__auto___100057 < len__28496__auto___100056)){
args__28503__auto__.push((arguments[i__28497__auto___100057]));

var G__100058 = (i__28497__auto___100057 + (1));
i__28497__auto___100057 = G__100058;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((0) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((0)),(0),null)):null);
return devtools.core.disable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic(argseq__28504__auto__);
});

devtools.core.disable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (features){
var seq__100052 = cljs.core.seq.call(null,features);
var chunk__100053 = null;
var count__100054 = (0);
var i__100055 = (0);
while(true){
if((i__100055 < count__100054)){
var feature = cljs.core._nth.call(null,chunk__100053,i__100055);
devtools.core.disable_single_feature_BANG_.call(null,feature);

var G__100059 = seq__100052;
var G__100060 = chunk__100053;
var G__100061 = count__100054;
var G__100062 = (i__100055 + (1));
seq__100052 = G__100059;
chunk__100053 = G__100060;
count__100054 = G__100061;
i__100055 = G__100062;
continue;
} else {
var temp__6753__auto__ = cljs.core.seq.call(null,seq__100052);
if(temp__6753__auto__){
var seq__100052__$1 = temp__6753__auto__;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__100052__$1)){
var c__28186__auto__ = cljs.core.chunk_first.call(null,seq__100052__$1);
var G__100063 = cljs.core.chunk_rest.call(null,seq__100052__$1);
var G__100064 = c__28186__auto__;
var G__100065 = cljs.core.count.call(null,c__28186__auto__);
var G__100066 = (0);
seq__100052 = G__100063;
chunk__100053 = G__100064;
count__100054 = G__100065;
i__100055 = G__100066;
continue;
} else {
var feature = cljs.core.first.call(null,seq__100052__$1);
devtools.core.disable_single_feature_BANG_.call(null,feature);

var G__100067 = cljs.core.next.call(null,seq__100052__$1);
var G__100068 = null;
var G__100069 = (0);
var G__100070 = (0);
seq__100052 = G__100067;
chunk__100053 = G__100068;
count__100054 = G__100069;
i__100055 = G__100070;
continue;
}
} else {
return null;
}
}
break;
}
});

devtools.core.disable_feature_BANG_.cljs$lang$maxFixedArity = (0);

devtools.core.disable_feature_BANG_.cljs$lang$applyTo = (function (seq100051){
return devtools.core.disable_feature_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq100051));
});

devtools.core.single_feature_available_QMARK_ = (function devtools$core$single_feature_available_QMARK_(feature){
var G__100072 = (((feature instanceof cljs.core.Keyword))?feature.fqn:null);
switch (G__100072) {
case "custom-formatters":
return devtools.custom_formatters.available_QMARK_.call(null);

break;
case "dirac":
return devtools.dirac.available_QMARK_.call(null);

break;
case "sanity-hints":
return devtools.sanity_hints.available_QMARK_.call(null);

break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(feature)].join('')));

}
});
devtools.core.feature_available_QMARK_ = (function devtools$core$feature_available_QMARK_(var_args){
var args__28503__auto__ = [];
var len__28496__auto___100075 = arguments.length;
var i__28497__auto___100076 = (0);
while(true){
if((i__28497__auto___100076 < len__28496__auto___100075)){
args__28503__auto__.push((arguments[i__28497__auto___100076]));

var G__100077 = (i__28497__auto___100076 + (1));
i__28497__auto___100076 = G__100077;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((0) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((0)),(0),null)):null);
return devtools.core.feature_available_QMARK_.cljs$core$IFn$_invoke$arity$variadic(argseq__28504__auto__);
});

devtools.core.feature_available_QMARK_.cljs$core$IFn$_invoke$arity$variadic = (function (features){
return cljs.core.every_QMARK_.call(null,devtools.core.single_feature_available_QMARK_,features);
});

devtools.core.feature_available_QMARK_.cljs$lang$maxFixedArity = (0);

devtools.core.feature_available_QMARK_.cljs$lang$applyTo = (function (seq100074){
return devtools.core.feature_available_QMARK_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq.call(null,seq100074));
});

devtools.core.enable_BANG_ = (function devtools$core$enable_BANG_(){
return console.warn([cljs.core.str("devtools.core/enable! was deprecated "),cljs.core.str("and has no effect in current version of cljs-devtools "),cljs.core.str("=> remove the call")].join(''));
});
devtools.core.disable_BANG_ = (function devtools$core$disable_BANG_(){
return console.warn([cljs.core.str("devtools.core/disable! was deprecated "),cljs.core.str("and has no effect in current version of cljs-devtools "),cljs.core.str("=> remove the call")].join(''));
});

//# sourceMappingURL=core.js.map?rel=1483479085346