// Compiled by ClojureScript 1.9.293 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args90800 = [];
var len__28496__auto___90806 = arguments.length;
var i__28497__auto___90807 = (0);
while(true){
if((i__28497__auto___90807 < len__28496__auto___90806)){
args90800.push((arguments[i__28497__auto___90807]));

var G__90808 = (i__28497__auto___90807 + (1));
i__28497__auto___90807 = G__90808;
continue;
} else {
}
break;
}

var G__90802 = args90800.length;
switch (G__90802) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args90800.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async90803 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async90803 = (function (f,blockable,meta90804){
this.f = f;
this.blockable = blockable;
this.meta90804 = meta90804;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async90803.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_90805,meta90804__$1){
var self__ = this;
var _90805__$1 = this;
return (new cljs.core.async.t_cljs$core$async90803(self__.f,self__.blockable,meta90804__$1));
});


cljs.core.async.t_cljs$core$async90803.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_90805){
var self__ = this;
var _90805__$1 = this;
return self__.meta90804;
});


cljs.core.async.t_cljs$core$async90803.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async90803.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});


cljs.core.async.t_cljs$core$async90803.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});


cljs.core.async.t_cljs$core$async90803.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async90803.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta90804","meta90804",1306803371,null)], null);
});

cljs.core.async.t_cljs$core$async90803.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async90803.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async90803";

cljs.core.async.t_cljs$core$async90803.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async90803");
});

cljs.core.async.__GT_t_cljs$core$async90803 = (function cljs$core$async$__GT_t_cljs$core$async90803(f__$1,blockable__$1,meta90804){
return (new cljs.core.async.t_cljs$core$async90803(f__$1,blockable__$1,meta90804));
});

}

return (new cljs.core.async.t_cljs$core$async90803(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args90812 = [];
var len__28496__auto___90815 = arguments.length;
var i__28497__auto___90816 = (0);
while(true){
if((i__28497__auto___90816 < len__28496__auto___90815)){
args90812.push((arguments[i__28497__auto___90816]));

var G__90817 = (i__28497__auto___90816 + (1));
i__28497__auto___90816 = G__90817;
continue;
} else {
}
break;
}

var G__90814 = args90812.length;
switch (G__90814) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args90812.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("buffer must be supplied when transducer is"),cljs.core.str("\n"),cljs.core.str("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args90819 = [];
var len__28496__auto___90822 = arguments.length;
var i__28497__auto___90823 = (0);
while(true){
if((i__28497__auto___90823 < len__28496__auto___90822)){
args90819.push((arguments[i__28497__auto___90823]));

var G__90824 = (i__28497__auto___90823 + (1));
i__28497__auto___90823 = G__90824;
continue;
} else {
}
break;
}

var G__90821 = args90819.length;
switch (G__90821) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args90819.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args90826 = [];
var len__28496__auto___90829 = arguments.length;
var i__28497__auto___90830 = (0);
while(true){
if((i__28497__auto___90830 < len__28496__auto___90829)){
args90826.push((arguments[i__28497__auto___90830]));

var G__90831 = (i__28497__auto___90830 + (1));
i__28497__auto___90830 = G__90831;
continue;
} else {
}
break;
}

var G__90828 = args90826.length;
switch (G__90828) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args90826.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_90833 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_90833);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_90833,ret){
return (function (){
return fn1.call(null,val_90833);
});})(val_90833,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args90834 = [];
var len__28496__auto___90837 = arguments.length;
var i__28497__auto___90838 = (0);
while(true){
if((i__28497__auto___90838 < len__28496__auto___90837)){
args90834.push((arguments[i__28497__auto___90838]));

var G__90839 = (i__28497__auto___90838 + (1));
i__28497__auto___90838 = G__90839;
continue;
} else {
}
break;
}

var G__90836 = args90834.length;
switch (G__90836) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args90834.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__6751__auto__)){
var ret = temp__6751__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__6751__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__6751__auto__)){
var retb = temp__6751__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__6751__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__6751__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__28296__auto___90841 = n;
var x_90842 = (0);
while(true){
if((x_90842 < n__28296__auto___90841)){
(a[x_90842] = (0));

var G__90843 = (x_90842 + (1));
x_90842 = G__90843;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__90844 = (i + (1));
i = G__90844;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async90848 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async90848 = (function (flag,meta90849){
this.flag = flag;
this.meta90849 = meta90849;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async90848.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_90850,meta90849__$1){
var self__ = this;
var _90850__$1 = this;
return (new cljs.core.async.t_cljs$core$async90848(self__.flag,meta90849__$1));
});})(flag))
;


cljs.core.async.t_cljs$core$async90848.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_90850){
var self__ = this;
var _90850__$1 = this;
return self__.meta90849;
});})(flag))
;


cljs.core.async.t_cljs$core$async90848.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async90848.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;


cljs.core.async.t_cljs$core$async90848.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;


cljs.core.async.t_cljs$core$async90848.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async90848.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta90849","meta90849",653041735,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async90848.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async90848.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async90848";

cljs.core.async.t_cljs$core$async90848.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async90848");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async90848 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async90848(flag__$1,meta90849){
return (new cljs.core.async.t_cljs$core$async90848(flag__$1,meta90849));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async90848(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async90854 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async90854 = (function (flag,cb,meta90855){
this.flag = flag;
this.cb = cb;
this.meta90855 = meta90855;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async90854.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_90856,meta90855__$1){
var self__ = this;
var _90856__$1 = this;
return (new cljs.core.async.t_cljs$core$async90854(self__.flag,self__.cb,meta90855__$1));
});


cljs.core.async.t_cljs$core$async90854.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_90856){
var self__ = this;
var _90856__$1 = this;
return self__.meta90855;
});


cljs.core.async.t_cljs$core$async90854.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async90854.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});


cljs.core.async.t_cljs$core$async90854.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});


cljs.core.async.t_cljs$core$async90854.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async90854.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta90855","meta90855",807668564,null)], null);
});

cljs.core.async.t_cljs$core$async90854.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async90854.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async90854";

cljs.core.async.t_cljs$core$async90854.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async90854");
});

cljs.core.async.__GT_t_cljs$core$async90854 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async90854(flag__$1,cb__$1,meta90855){
return (new cljs.core.async.t_cljs$core$async90854(flag__$1,cb__$1,meta90855));
});

}

return (new cljs.core.async.t_cljs$core$async90854(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__90857_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__90857_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__90858_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__90858_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__27280__auto__ = wport;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return port;
}
})()], null));
} else {
var G__90859 = (i + (1));
i = G__90859;
continue;
}
} else {
return null;
}
break;
}
})();
var or__27280__auto__ = ret;
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__6753__auto__ = (function (){var and__27268__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__27268__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__27268__auto__;
}
})();
if(cljs.core.truth_(temp__6753__auto__)){
var got = temp__6753__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__28503__auto__ = [];
var len__28496__auto___90865 = arguments.length;
var i__28497__auto___90866 = (0);
while(true){
if((i__28497__auto___90866 < len__28496__auto___90865)){
args__28503__auto__.push((arguments[i__28497__auto___90866]));

var G__90867 = (i__28497__auto___90866 + (1));
i__28497__auto___90866 = G__90867;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((1) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__28504__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__90862){
var map__90863 = p__90862;
var map__90863__$1 = ((((!((map__90863 == null)))?((((map__90863.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__90863.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__90863):map__90863);
var opts = map__90863__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq90860){
var G__90861 = cljs.core.first.call(null,seq90860);
var seq90860__$1 = cljs.core.next.call(null,seq90860);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__90861,seq90860__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args90868 = [];
var len__28496__auto___90918 = arguments.length;
var i__28497__auto___90919 = (0);
while(true){
if((i__28497__auto___90919 < len__28496__auto___90918)){
args90868.push((arguments[i__28497__auto___90919]));

var G__90920 = (i__28497__auto___90919 + (1));
i__28497__auto___90919 = G__90920;
continue;
} else {
}
break;
}

var G__90870 = args90868.length;
switch (G__90870) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args90868.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__41974__auto___90922 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto___90922){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto___90922){
return (function (state_90894){
var state_val_90895 = (state_90894[(1)]);
if((state_val_90895 === (7))){
var inst_90890 = (state_90894[(2)]);
var state_90894__$1 = state_90894;
var statearr_90896_90923 = state_90894__$1;
(statearr_90896_90923[(2)] = inst_90890);

(statearr_90896_90923[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_90895 === (1))){
var state_90894__$1 = state_90894;
var statearr_90897_90924 = state_90894__$1;
(statearr_90897_90924[(2)] = null);

(statearr_90897_90924[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_90895 === (4))){
var inst_90873 = (state_90894[(7)]);
var inst_90873__$1 = (state_90894[(2)]);
var inst_90874 = (inst_90873__$1 == null);
var state_90894__$1 = (function (){var statearr_90898 = state_90894;
(statearr_90898[(7)] = inst_90873__$1);

return statearr_90898;
})();
if(cljs.core.truth_(inst_90874)){
var statearr_90899_90925 = state_90894__$1;
(statearr_90899_90925[(1)] = (5));

} else {
var statearr_90900_90926 = state_90894__$1;
(statearr_90900_90926[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_90895 === (13))){
var state_90894__$1 = state_90894;
var statearr_90901_90927 = state_90894__$1;
(statearr_90901_90927[(2)] = null);

(statearr_90901_90927[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_90895 === (6))){
var inst_90873 = (state_90894[(7)]);
var state_90894__$1 = state_90894;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_90894__$1,(11),to,inst_90873);
} else {
if((state_val_90895 === (3))){
var inst_90892 = (state_90894[(2)]);
var state_90894__$1 = state_90894;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_90894__$1,inst_90892);
} else {
if((state_val_90895 === (12))){
var state_90894__$1 = state_90894;
var statearr_90902_90928 = state_90894__$1;
(statearr_90902_90928[(2)] = null);

(statearr_90902_90928[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_90895 === (2))){
var state_90894__$1 = state_90894;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_90894__$1,(4),from);
} else {
if((state_val_90895 === (11))){
var inst_90883 = (state_90894[(2)]);
var state_90894__$1 = state_90894;
if(cljs.core.truth_(inst_90883)){
var statearr_90903_90929 = state_90894__$1;
(statearr_90903_90929[(1)] = (12));

} else {
var statearr_90904_90930 = state_90894__$1;
(statearr_90904_90930[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_90895 === (9))){
var state_90894__$1 = state_90894;
var statearr_90905_90931 = state_90894__$1;
(statearr_90905_90931[(2)] = null);

(statearr_90905_90931[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_90895 === (5))){
var state_90894__$1 = state_90894;
if(cljs.core.truth_(close_QMARK_)){
var statearr_90906_90932 = state_90894__$1;
(statearr_90906_90932[(1)] = (8));

} else {
var statearr_90907_90933 = state_90894__$1;
(statearr_90907_90933[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_90895 === (14))){
var inst_90888 = (state_90894[(2)]);
var state_90894__$1 = state_90894;
var statearr_90908_90934 = state_90894__$1;
(statearr_90908_90934[(2)] = inst_90888);

(statearr_90908_90934[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_90895 === (10))){
var inst_90880 = (state_90894[(2)]);
var state_90894__$1 = state_90894;
var statearr_90909_90935 = state_90894__$1;
(statearr_90909_90935[(2)] = inst_90880);

(statearr_90909_90935[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_90895 === (8))){
var inst_90877 = cljs.core.async.close_BANG_.call(null,to);
var state_90894__$1 = state_90894;
var statearr_90910_90936 = state_90894__$1;
(statearr_90910_90936[(2)] = inst_90877);

(statearr_90910_90936[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41974__auto___90922))
;
return ((function (switch__41860__auto__,c__41974__auto___90922){
return (function() {
var cljs$core$async$state_machine__41861__auto__ = null;
var cljs$core$async$state_machine__41861__auto____0 = (function (){
var statearr_90914 = [null,null,null,null,null,null,null,null];
(statearr_90914[(0)] = cljs$core$async$state_machine__41861__auto__);

(statearr_90914[(1)] = (1));

return statearr_90914;
});
var cljs$core$async$state_machine__41861__auto____1 = (function (state_90894){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_90894);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e90915){if((e90915 instanceof Object)){
var ex__41864__auto__ = e90915;
var statearr_90916_90937 = state_90894;
(statearr_90916_90937[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_90894);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e90915;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__90938 = state_90894;
state_90894 = G__90938;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
cljs$core$async$state_machine__41861__auto__ = function(state_90894){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41861__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41861__auto____1.call(this,state_90894);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41861__auto____0;
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41861__auto____1;
return cljs$core$async$state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto___90922))
})();
var state__41976__auto__ = (function (){var statearr_90917 = f__41975__auto__.call(null);
(statearr_90917[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto___90922);

return statearr_90917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto___90922))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__91126){
var vec__91127 = p__91126;
var v = cljs.core.nth.call(null,vec__91127,(0),null);
var p = cljs.core.nth.call(null,vec__91127,(1),null);
var job = vec__91127;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__41974__auto___91313 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto___91313,res,vec__91127,v,p,job,jobs,results){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto___91313,res,vec__91127,v,p,job,jobs,results){
return (function (state_91134){
var state_val_91135 = (state_91134[(1)]);
if((state_val_91135 === (1))){
var state_91134__$1 = state_91134;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_91134__$1,(2),res,v);
} else {
if((state_val_91135 === (2))){
var inst_91131 = (state_91134[(2)]);
var inst_91132 = cljs.core.async.close_BANG_.call(null,res);
var state_91134__$1 = (function (){var statearr_91136 = state_91134;
(statearr_91136[(7)] = inst_91131);

return statearr_91136;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_91134__$1,inst_91132);
} else {
return null;
}
}
});})(c__41974__auto___91313,res,vec__91127,v,p,job,jobs,results))
;
return ((function (switch__41860__auto__,c__41974__auto___91313,res,vec__91127,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____0 = (function (){
var statearr_91140 = [null,null,null,null,null,null,null,null];
(statearr_91140[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__);

(statearr_91140[(1)] = (1));

return statearr_91140;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____1 = (function (state_91134){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_91134);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e91141){if((e91141 instanceof Object)){
var ex__41864__auto__ = e91141;
var statearr_91142_91314 = state_91134;
(statearr_91142_91314[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_91134);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e91141;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__91315 = state_91134;
state_91134 = G__91315;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__ = function(state_91134){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____1.call(this,state_91134);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto___91313,res,vec__91127,v,p,job,jobs,results))
})();
var state__41976__auto__ = (function (){var statearr_91143 = f__41975__auto__.call(null);
(statearr_91143[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto___91313);

return statearr_91143;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto___91313,res,vec__91127,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__91144){
var vec__91145 = p__91144;
var v = cljs.core.nth.call(null,vec__91145,(0),null);
var p = cljs.core.nth.call(null,vec__91145,(1),null);
var job = vec__91145;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__28296__auto___91316 = n;
var __91317 = (0);
while(true){
if((__91317 < n__28296__auto___91316)){
var G__91148_91318 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__91148_91318) {
case "compute":
var c__41974__auto___91320 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__91317,c__41974__auto___91320,G__91148_91318,n__28296__auto___91316,jobs,results,process,async){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (__91317,c__41974__auto___91320,G__91148_91318,n__28296__auto___91316,jobs,results,process,async){
return (function (state_91161){
var state_val_91162 = (state_91161[(1)]);
if((state_val_91162 === (1))){
var state_91161__$1 = state_91161;
var statearr_91163_91321 = state_91161__$1;
(statearr_91163_91321[(2)] = null);

(statearr_91163_91321[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91162 === (2))){
var state_91161__$1 = state_91161;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_91161__$1,(4),jobs);
} else {
if((state_val_91162 === (3))){
var inst_91159 = (state_91161[(2)]);
var state_91161__$1 = state_91161;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_91161__$1,inst_91159);
} else {
if((state_val_91162 === (4))){
var inst_91151 = (state_91161[(2)]);
var inst_91152 = process.call(null,inst_91151);
var state_91161__$1 = state_91161;
if(cljs.core.truth_(inst_91152)){
var statearr_91164_91322 = state_91161__$1;
(statearr_91164_91322[(1)] = (5));

} else {
var statearr_91165_91323 = state_91161__$1;
(statearr_91165_91323[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91162 === (5))){
var state_91161__$1 = state_91161;
var statearr_91166_91324 = state_91161__$1;
(statearr_91166_91324[(2)] = null);

(statearr_91166_91324[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91162 === (6))){
var state_91161__$1 = state_91161;
var statearr_91167_91325 = state_91161__$1;
(statearr_91167_91325[(2)] = null);

(statearr_91167_91325[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91162 === (7))){
var inst_91157 = (state_91161[(2)]);
var state_91161__$1 = state_91161;
var statearr_91168_91326 = state_91161__$1;
(statearr_91168_91326[(2)] = inst_91157);

(statearr_91168_91326[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__91317,c__41974__auto___91320,G__91148_91318,n__28296__auto___91316,jobs,results,process,async))
;
return ((function (__91317,switch__41860__auto__,c__41974__auto___91320,G__91148_91318,n__28296__auto___91316,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____0 = (function (){
var statearr_91172 = [null,null,null,null,null,null,null];
(statearr_91172[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__);

(statearr_91172[(1)] = (1));

return statearr_91172;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____1 = (function (state_91161){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_91161);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e91173){if((e91173 instanceof Object)){
var ex__41864__auto__ = e91173;
var statearr_91174_91327 = state_91161;
(statearr_91174_91327[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_91161);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e91173;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__91328 = state_91161;
state_91161 = G__91328;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__ = function(state_91161){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____1.call(this,state_91161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__;
})()
;})(__91317,switch__41860__auto__,c__41974__auto___91320,G__91148_91318,n__28296__auto___91316,jobs,results,process,async))
})();
var state__41976__auto__ = (function (){var statearr_91175 = f__41975__auto__.call(null);
(statearr_91175[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto___91320);

return statearr_91175;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(__91317,c__41974__auto___91320,G__91148_91318,n__28296__auto___91316,jobs,results,process,async))
);


break;
case "async":
var c__41974__auto___91329 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__91317,c__41974__auto___91329,G__91148_91318,n__28296__auto___91316,jobs,results,process,async){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (__91317,c__41974__auto___91329,G__91148_91318,n__28296__auto___91316,jobs,results,process,async){
return (function (state_91188){
var state_val_91189 = (state_91188[(1)]);
if((state_val_91189 === (1))){
var state_91188__$1 = state_91188;
var statearr_91190_91330 = state_91188__$1;
(statearr_91190_91330[(2)] = null);

(statearr_91190_91330[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91189 === (2))){
var state_91188__$1 = state_91188;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_91188__$1,(4),jobs);
} else {
if((state_val_91189 === (3))){
var inst_91186 = (state_91188[(2)]);
var state_91188__$1 = state_91188;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_91188__$1,inst_91186);
} else {
if((state_val_91189 === (4))){
var inst_91178 = (state_91188[(2)]);
var inst_91179 = async.call(null,inst_91178);
var state_91188__$1 = state_91188;
if(cljs.core.truth_(inst_91179)){
var statearr_91191_91331 = state_91188__$1;
(statearr_91191_91331[(1)] = (5));

} else {
var statearr_91192_91332 = state_91188__$1;
(statearr_91192_91332[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91189 === (5))){
var state_91188__$1 = state_91188;
var statearr_91193_91333 = state_91188__$1;
(statearr_91193_91333[(2)] = null);

(statearr_91193_91333[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91189 === (6))){
var state_91188__$1 = state_91188;
var statearr_91194_91334 = state_91188__$1;
(statearr_91194_91334[(2)] = null);

(statearr_91194_91334[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91189 === (7))){
var inst_91184 = (state_91188[(2)]);
var state_91188__$1 = state_91188;
var statearr_91195_91335 = state_91188__$1;
(statearr_91195_91335[(2)] = inst_91184);

(statearr_91195_91335[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__91317,c__41974__auto___91329,G__91148_91318,n__28296__auto___91316,jobs,results,process,async))
;
return ((function (__91317,switch__41860__auto__,c__41974__auto___91329,G__91148_91318,n__28296__auto___91316,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____0 = (function (){
var statearr_91199 = [null,null,null,null,null,null,null];
(statearr_91199[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__);

(statearr_91199[(1)] = (1));

return statearr_91199;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____1 = (function (state_91188){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_91188);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e91200){if((e91200 instanceof Object)){
var ex__41864__auto__ = e91200;
var statearr_91201_91336 = state_91188;
(statearr_91201_91336[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_91188);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e91200;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__91337 = state_91188;
state_91188 = G__91337;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__ = function(state_91188){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____1.call(this,state_91188);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__;
})()
;})(__91317,switch__41860__auto__,c__41974__auto___91329,G__91148_91318,n__28296__auto___91316,jobs,results,process,async))
})();
var state__41976__auto__ = (function (){var statearr_91202 = f__41975__auto__.call(null);
(statearr_91202[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto___91329);

return statearr_91202;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(__91317,c__41974__auto___91329,G__91148_91318,n__28296__auto___91316,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(type)].join('')));

}

var G__91338 = (__91317 + (1));
__91317 = G__91338;
continue;
} else {
}
break;
}

var c__41974__auto___91339 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto___91339,jobs,results,process,async){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto___91339,jobs,results,process,async){
return (function (state_91224){
var state_val_91225 = (state_91224[(1)]);
if((state_val_91225 === (1))){
var state_91224__$1 = state_91224;
var statearr_91226_91340 = state_91224__$1;
(statearr_91226_91340[(2)] = null);

(statearr_91226_91340[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91225 === (2))){
var state_91224__$1 = state_91224;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_91224__$1,(4),from);
} else {
if((state_val_91225 === (3))){
var inst_91222 = (state_91224[(2)]);
var state_91224__$1 = state_91224;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_91224__$1,inst_91222);
} else {
if((state_val_91225 === (4))){
var inst_91205 = (state_91224[(7)]);
var inst_91205__$1 = (state_91224[(2)]);
var inst_91206 = (inst_91205__$1 == null);
var state_91224__$1 = (function (){var statearr_91227 = state_91224;
(statearr_91227[(7)] = inst_91205__$1);

return statearr_91227;
})();
if(cljs.core.truth_(inst_91206)){
var statearr_91228_91341 = state_91224__$1;
(statearr_91228_91341[(1)] = (5));

} else {
var statearr_91229_91342 = state_91224__$1;
(statearr_91229_91342[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91225 === (5))){
var inst_91208 = cljs.core.async.close_BANG_.call(null,jobs);
var state_91224__$1 = state_91224;
var statearr_91230_91343 = state_91224__$1;
(statearr_91230_91343[(2)] = inst_91208);

(statearr_91230_91343[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91225 === (6))){
var inst_91210 = (state_91224[(8)]);
var inst_91205 = (state_91224[(7)]);
var inst_91210__$1 = cljs.core.async.chan.call(null,(1));
var inst_91211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_91212 = [inst_91205,inst_91210__$1];
var inst_91213 = (new cljs.core.PersistentVector(null,2,(5),inst_91211,inst_91212,null));
var state_91224__$1 = (function (){var statearr_91231 = state_91224;
(statearr_91231[(8)] = inst_91210__$1);

return statearr_91231;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_91224__$1,(8),jobs,inst_91213);
} else {
if((state_val_91225 === (7))){
var inst_91220 = (state_91224[(2)]);
var state_91224__$1 = state_91224;
var statearr_91232_91344 = state_91224__$1;
(statearr_91232_91344[(2)] = inst_91220);

(statearr_91232_91344[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91225 === (8))){
var inst_91210 = (state_91224[(8)]);
var inst_91215 = (state_91224[(2)]);
var state_91224__$1 = (function (){var statearr_91233 = state_91224;
(statearr_91233[(9)] = inst_91215);

return statearr_91233;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_91224__$1,(9),results,inst_91210);
} else {
if((state_val_91225 === (9))){
var inst_91217 = (state_91224[(2)]);
var state_91224__$1 = (function (){var statearr_91234 = state_91224;
(statearr_91234[(10)] = inst_91217);

return statearr_91234;
})();
var statearr_91235_91345 = state_91224__$1;
(statearr_91235_91345[(2)] = null);

(statearr_91235_91345[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__41974__auto___91339,jobs,results,process,async))
;
return ((function (switch__41860__auto__,c__41974__auto___91339,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____0 = (function (){
var statearr_91239 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_91239[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__);

(statearr_91239[(1)] = (1));

return statearr_91239;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____1 = (function (state_91224){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_91224);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e91240){if((e91240 instanceof Object)){
var ex__41864__auto__ = e91240;
var statearr_91241_91346 = state_91224;
(statearr_91241_91346[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_91224);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e91240;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__91347 = state_91224;
state_91224 = G__91347;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__ = function(state_91224){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____1.call(this,state_91224);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto___91339,jobs,results,process,async))
})();
var state__41976__auto__ = (function (){var statearr_91242 = f__41975__auto__.call(null);
(statearr_91242[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto___91339);

return statearr_91242;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto___91339,jobs,results,process,async))
);


var c__41974__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto__,jobs,results,process,async){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto__,jobs,results,process,async){
return (function (state_91280){
var state_val_91281 = (state_91280[(1)]);
if((state_val_91281 === (7))){
var inst_91276 = (state_91280[(2)]);
var state_91280__$1 = state_91280;
var statearr_91282_91348 = state_91280__$1;
(statearr_91282_91348[(2)] = inst_91276);

(statearr_91282_91348[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91281 === (20))){
var state_91280__$1 = state_91280;
var statearr_91283_91349 = state_91280__$1;
(statearr_91283_91349[(2)] = null);

(statearr_91283_91349[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91281 === (1))){
var state_91280__$1 = state_91280;
var statearr_91284_91350 = state_91280__$1;
(statearr_91284_91350[(2)] = null);

(statearr_91284_91350[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91281 === (4))){
var inst_91245 = (state_91280[(7)]);
var inst_91245__$1 = (state_91280[(2)]);
var inst_91246 = (inst_91245__$1 == null);
var state_91280__$1 = (function (){var statearr_91285 = state_91280;
(statearr_91285[(7)] = inst_91245__$1);

return statearr_91285;
})();
if(cljs.core.truth_(inst_91246)){
var statearr_91286_91351 = state_91280__$1;
(statearr_91286_91351[(1)] = (5));

} else {
var statearr_91287_91352 = state_91280__$1;
(statearr_91287_91352[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91281 === (15))){
var inst_91258 = (state_91280[(8)]);
var state_91280__$1 = state_91280;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_91280__$1,(18),to,inst_91258);
} else {
if((state_val_91281 === (21))){
var inst_91271 = (state_91280[(2)]);
var state_91280__$1 = state_91280;
var statearr_91288_91353 = state_91280__$1;
(statearr_91288_91353[(2)] = inst_91271);

(statearr_91288_91353[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91281 === (13))){
var inst_91273 = (state_91280[(2)]);
var state_91280__$1 = (function (){var statearr_91289 = state_91280;
(statearr_91289[(9)] = inst_91273);

return statearr_91289;
})();
var statearr_91290_91354 = state_91280__$1;
(statearr_91290_91354[(2)] = null);

(statearr_91290_91354[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91281 === (6))){
var inst_91245 = (state_91280[(7)]);
var state_91280__$1 = state_91280;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_91280__$1,(11),inst_91245);
} else {
if((state_val_91281 === (17))){
var inst_91266 = (state_91280[(2)]);
var state_91280__$1 = state_91280;
if(cljs.core.truth_(inst_91266)){
var statearr_91291_91355 = state_91280__$1;
(statearr_91291_91355[(1)] = (19));

} else {
var statearr_91292_91356 = state_91280__$1;
(statearr_91292_91356[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91281 === (3))){
var inst_91278 = (state_91280[(2)]);
var state_91280__$1 = state_91280;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_91280__$1,inst_91278);
} else {
if((state_val_91281 === (12))){
var inst_91255 = (state_91280[(10)]);
var state_91280__$1 = state_91280;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_91280__$1,(14),inst_91255);
} else {
if((state_val_91281 === (2))){
var state_91280__$1 = state_91280;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_91280__$1,(4),results);
} else {
if((state_val_91281 === (19))){
var state_91280__$1 = state_91280;
var statearr_91293_91357 = state_91280__$1;
(statearr_91293_91357[(2)] = null);

(statearr_91293_91357[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91281 === (11))){
var inst_91255 = (state_91280[(2)]);
var state_91280__$1 = (function (){var statearr_91294 = state_91280;
(statearr_91294[(10)] = inst_91255);

return statearr_91294;
})();
var statearr_91295_91358 = state_91280__$1;
(statearr_91295_91358[(2)] = null);

(statearr_91295_91358[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91281 === (9))){
var state_91280__$1 = state_91280;
var statearr_91296_91359 = state_91280__$1;
(statearr_91296_91359[(2)] = null);

(statearr_91296_91359[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91281 === (5))){
var state_91280__$1 = state_91280;
if(cljs.core.truth_(close_QMARK_)){
var statearr_91297_91360 = state_91280__$1;
(statearr_91297_91360[(1)] = (8));

} else {
var statearr_91298_91361 = state_91280__$1;
(statearr_91298_91361[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91281 === (14))){
var inst_91260 = (state_91280[(11)]);
var inst_91258 = (state_91280[(8)]);
var inst_91258__$1 = (state_91280[(2)]);
var inst_91259 = (inst_91258__$1 == null);
var inst_91260__$1 = cljs.core.not.call(null,inst_91259);
var state_91280__$1 = (function (){var statearr_91299 = state_91280;
(statearr_91299[(11)] = inst_91260__$1);

(statearr_91299[(8)] = inst_91258__$1);

return statearr_91299;
})();
if(inst_91260__$1){
var statearr_91300_91362 = state_91280__$1;
(statearr_91300_91362[(1)] = (15));

} else {
var statearr_91301_91363 = state_91280__$1;
(statearr_91301_91363[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91281 === (16))){
var inst_91260 = (state_91280[(11)]);
var state_91280__$1 = state_91280;
var statearr_91302_91364 = state_91280__$1;
(statearr_91302_91364[(2)] = inst_91260);

(statearr_91302_91364[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91281 === (10))){
var inst_91252 = (state_91280[(2)]);
var state_91280__$1 = state_91280;
var statearr_91303_91365 = state_91280__$1;
(statearr_91303_91365[(2)] = inst_91252);

(statearr_91303_91365[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91281 === (18))){
var inst_91263 = (state_91280[(2)]);
var state_91280__$1 = state_91280;
var statearr_91304_91366 = state_91280__$1;
(statearr_91304_91366[(2)] = inst_91263);

(statearr_91304_91366[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91281 === (8))){
var inst_91249 = cljs.core.async.close_BANG_.call(null,to);
var state_91280__$1 = state_91280;
var statearr_91305_91367 = state_91280__$1;
(statearr_91305_91367[(2)] = inst_91249);

(statearr_91305_91367[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41974__auto__,jobs,results,process,async))
;
return ((function (switch__41860__auto__,c__41974__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____0 = (function (){
var statearr_91309 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_91309[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__);

(statearr_91309[(1)] = (1));

return statearr_91309;
});
var cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____1 = (function (state_91280){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_91280);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e91310){if((e91310 instanceof Object)){
var ex__41864__auto__ = e91310;
var statearr_91311_91368 = state_91280;
(statearr_91311_91368[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_91280);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e91310;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__91369 = state_91280;
state_91280 = G__91369;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__ = function(state_91280){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____1.call(this,state_91280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__41861__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto__,jobs,results,process,async))
})();
var state__41976__auto__ = (function (){var statearr_91312 = f__41975__auto__.call(null);
(statearr_91312[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto__);

return statearr_91312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto__,jobs,results,process,async))
);

return c__41974__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args91370 = [];
var len__28496__auto___91373 = arguments.length;
var i__28497__auto___91374 = (0);
while(true){
if((i__28497__auto___91374 < len__28496__auto___91373)){
args91370.push((arguments[i__28497__auto___91374]));

var G__91375 = (i__28497__auto___91374 + (1));
i__28497__auto___91374 = G__91375;
continue;
} else {
}
break;
}

var G__91372 = args91370.length;
switch (G__91372) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args91370.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args91377 = [];
var len__28496__auto___91380 = arguments.length;
var i__28497__auto___91381 = (0);
while(true){
if((i__28497__auto___91381 < len__28496__auto___91380)){
args91377.push((arguments[i__28497__auto___91381]));

var G__91382 = (i__28497__auto___91381 + (1));
i__28497__auto___91381 = G__91382;
continue;
} else {
}
break;
}

var G__91379 = args91377.length;
switch (G__91379) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args91377.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args91384 = [];
var len__28496__auto___91437 = arguments.length;
var i__28497__auto___91438 = (0);
while(true){
if((i__28497__auto___91438 < len__28496__auto___91437)){
args91384.push((arguments[i__28497__auto___91438]));

var G__91439 = (i__28497__auto___91438 + (1));
i__28497__auto___91438 = G__91439;
continue;
} else {
}
break;
}

var G__91386 = args91384.length;
switch (G__91386) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args91384.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__41974__auto___91441 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto___91441,tc,fc){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto___91441,tc,fc){
return (function (state_91412){
var state_val_91413 = (state_91412[(1)]);
if((state_val_91413 === (7))){
var inst_91408 = (state_91412[(2)]);
var state_91412__$1 = state_91412;
var statearr_91414_91442 = state_91412__$1;
(statearr_91414_91442[(2)] = inst_91408);

(statearr_91414_91442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91413 === (1))){
var state_91412__$1 = state_91412;
var statearr_91415_91443 = state_91412__$1;
(statearr_91415_91443[(2)] = null);

(statearr_91415_91443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91413 === (4))){
var inst_91389 = (state_91412[(7)]);
var inst_91389__$1 = (state_91412[(2)]);
var inst_91390 = (inst_91389__$1 == null);
var state_91412__$1 = (function (){var statearr_91416 = state_91412;
(statearr_91416[(7)] = inst_91389__$1);

return statearr_91416;
})();
if(cljs.core.truth_(inst_91390)){
var statearr_91417_91444 = state_91412__$1;
(statearr_91417_91444[(1)] = (5));

} else {
var statearr_91418_91445 = state_91412__$1;
(statearr_91418_91445[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91413 === (13))){
var state_91412__$1 = state_91412;
var statearr_91419_91446 = state_91412__$1;
(statearr_91419_91446[(2)] = null);

(statearr_91419_91446[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91413 === (6))){
var inst_91389 = (state_91412[(7)]);
var inst_91395 = p.call(null,inst_91389);
var state_91412__$1 = state_91412;
if(cljs.core.truth_(inst_91395)){
var statearr_91420_91447 = state_91412__$1;
(statearr_91420_91447[(1)] = (9));

} else {
var statearr_91421_91448 = state_91412__$1;
(statearr_91421_91448[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91413 === (3))){
var inst_91410 = (state_91412[(2)]);
var state_91412__$1 = state_91412;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_91412__$1,inst_91410);
} else {
if((state_val_91413 === (12))){
var state_91412__$1 = state_91412;
var statearr_91422_91449 = state_91412__$1;
(statearr_91422_91449[(2)] = null);

(statearr_91422_91449[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91413 === (2))){
var state_91412__$1 = state_91412;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_91412__$1,(4),ch);
} else {
if((state_val_91413 === (11))){
var inst_91389 = (state_91412[(7)]);
var inst_91399 = (state_91412[(2)]);
var state_91412__$1 = state_91412;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_91412__$1,(8),inst_91399,inst_91389);
} else {
if((state_val_91413 === (9))){
var state_91412__$1 = state_91412;
var statearr_91423_91450 = state_91412__$1;
(statearr_91423_91450[(2)] = tc);

(statearr_91423_91450[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91413 === (5))){
var inst_91392 = cljs.core.async.close_BANG_.call(null,tc);
var inst_91393 = cljs.core.async.close_BANG_.call(null,fc);
var state_91412__$1 = (function (){var statearr_91424 = state_91412;
(statearr_91424[(8)] = inst_91392);

return statearr_91424;
})();
var statearr_91425_91451 = state_91412__$1;
(statearr_91425_91451[(2)] = inst_91393);

(statearr_91425_91451[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91413 === (14))){
var inst_91406 = (state_91412[(2)]);
var state_91412__$1 = state_91412;
var statearr_91426_91452 = state_91412__$1;
(statearr_91426_91452[(2)] = inst_91406);

(statearr_91426_91452[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91413 === (10))){
var state_91412__$1 = state_91412;
var statearr_91427_91453 = state_91412__$1;
(statearr_91427_91453[(2)] = fc);

(statearr_91427_91453[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91413 === (8))){
var inst_91401 = (state_91412[(2)]);
var state_91412__$1 = state_91412;
if(cljs.core.truth_(inst_91401)){
var statearr_91428_91454 = state_91412__$1;
(statearr_91428_91454[(1)] = (12));

} else {
var statearr_91429_91455 = state_91412__$1;
(statearr_91429_91455[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41974__auto___91441,tc,fc))
;
return ((function (switch__41860__auto__,c__41974__auto___91441,tc,fc){
return (function() {
var cljs$core$async$state_machine__41861__auto__ = null;
var cljs$core$async$state_machine__41861__auto____0 = (function (){
var statearr_91433 = [null,null,null,null,null,null,null,null,null];
(statearr_91433[(0)] = cljs$core$async$state_machine__41861__auto__);

(statearr_91433[(1)] = (1));

return statearr_91433;
});
var cljs$core$async$state_machine__41861__auto____1 = (function (state_91412){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_91412);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e91434){if((e91434 instanceof Object)){
var ex__41864__auto__ = e91434;
var statearr_91435_91456 = state_91412;
(statearr_91435_91456[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_91412);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e91434;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__91457 = state_91412;
state_91412 = G__91457;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
cljs$core$async$state_machine__41861__auto__ = function(state_91412){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41861__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41861__auto____1.call(this,state_91412);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41861__auto____0;
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41861__auto____1;
return cljs$core$async$state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto___91441,tc,fc))
})();
var state__41976__auto__ = (function (){var statearr_91436 = f__41975__auto__.call(null);
(statearr_91436[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto___91441);

return statearr_91436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto___91441,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__41974__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto__){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto__){
return (function (state_91521){
var state_val_91522 = (state_91521[(1)]);
if((state_val_91522 === (7))){
var inst_91517 = (state_91521[(2)]);
var state_91521__$1 = state_91521;
var statearr_91523_91544 = state_91521__$1;
(statearr_91523_91544[(2)] = inst_91517);

(statearr_91523_91544[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91522 === (1))){
var inst_91501 = init;
var state_91521__$1 = (function (){var statearr_91524 = state_91521;
(statearr_91524[(7)] = inst_91501);

return statearr_91524;
})();
var statearr_91525_91545 = state_91521__$1;
(statearr_91525_91545[(2)] = null);

(statearr_91525_91545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91522 === (4))){
var inst_91504 = (state_91521[(8)]);
var inst_91504__$1 = (state_91521[(2)]);
var inst_91505 = (inst_91504__$1 == null);
var state_91521__$1 = (function (){var statearr_91526 = state_91521;
(statearr_91526[(8)] = inst_91504__$1);

return statearr_91526;
})();
if(cljs.core.truth_(inst_91505)){
var statearr_91527_91546 = state_91521__$1;
(statearr_91527_91546[(1)] = (5));

} else {
var statearr_91528_91547 = state_91521__$1;
(statearr_91528_91547[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91522 === (6))){
var inst_91504 = (state_91521[(8)]);
var inst_91508 = (state_91521[(9)]);
var inst_91501 = (state_91521[(7)]);
var inst_91508__$1 = f.call(null,inst_91501,inst_91504);
var inst_91509 = cljs.core.reduced_QMARK_.call(null,inst_91508__$1);
var state_91521__$1 = (function (){var statearr_91529 = state_91521;
(statearr_91529[(9)] = inst_91508__$1);

return statearr_91529;
})();
if(inst_91509){
var statearr_91530_91548 = state_91521__$1;
(statearr_91530_91548[(1)] = (8));

} else {
var statearr_91531_91549 = state_91521__$1;
(statearr_91531_91549[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91522 === (3))){
var inst_91519 = (state_91521[(2)]);
var state_91521__$1 = state_91521;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_91521__$1,inst_91519);
} else {
if((state_val_91522 === (2))){
var state_91521__$1 = state_91521;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_91521__$1,(4),ch);
} else {
if((state_val_91522 === (9))){
var inst_91508 = (state_91521[(9)]);
var inst_91501 = inst_91508;
var state_91521__$1 = (function (){var statearr_91532 = state_91521;
(statearr_91532[(7)] = inst_91501);

return statearr_91532;
})();
var statearr_91533_91550 = state_91521__$1;
(statearr_91533_91550[(2)] = null);

(statearr_91533_91550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91522 === (5))){
var inst_91501 = (state_91521[(7)]);
var state_91521__$1 = state_91521;
var statearr_91534_91551 = state_91521__$1;
(statearr_91534_91551[(2)] = inst_91501);

(statearr_91534_91551[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91522 === (10))){
var inst_91515 = (state_91521[(2)]);
var state_91521__$1 = state_91521;
var statearr_91535_91552 = state_91521__$1;
(statearr_91535_91552[(2)] = inst_91515);

(statearr_91535_91552[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91522 === (8))){
var inst_91508 = (state_91521[(9)]);
var inst_91511 = cljs.core.deref.call(null,inst_91508);
var state_91521__$1 = state_91521;
var statearr_91536_91553 = state_91521__$1;
(statearr_91536_91553[(2)] = inst_91511);

(statearr_91536_91553[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__41974__auto__))
;
return ((function (switch__41860__auto__,c__41974__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__41861__auto__ = null;
var cljs$core$async$reduce_$_state_machine__41861__auto____0 = (function (){
var statearr_91540 = [null,null,null,null,null,null,null,null,null,null];
(statearr_91540[(0)] = cljs$core$async$reduce_$_state_machine__41861__auto__);

(statearr_91540[(1)] = (1));

return statearr_91540;
});
var cljs$core$async$reduce_$_state_machine__41861__auto____1 = (function (state_91521){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_91521);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e91541){if((e91541 instanceof Object)){
var ex__41864__auto__ = e91541;
var statearr_91542_91554 = state_91521;
(statearr_91542_91554[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_91521);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e91541;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__91555 = state_91521;
state_91521 = G__91555;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__41861__auto__ = function(state_91521){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__41861__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__41861__auto____1.call(this,state_91521);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__41861__auto____0;
cljs$core$async$reduce_$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__41861__auto____1;
return cljs$core$async$reduce_$_state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto__))
})();
var state__41976__auto__ = (function (){var statearr_91543 = f__41975__auto__.call(null);
(statearr_91543[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto__);

return statearr_91543;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto__))
);

return c__41974__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args91556 = [];
var len__28496__auto___91608 = arguments.length;
var i__28497__auto___91609 = (0);
while(true){
if((i__28497__auto___91609 < len__28496__auto___91608)){
args91556.push((arguments[i__28497__auto___91609]));

var G__91610 = (i__28497__auto___91609 + (1));
i__28497__auto___91609 = G__91610;
continue;
} else {
}
break;
}

var G__91558 = args91556.length;
switch (G__91558) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args91556.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__41974__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto__){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto__){
return (function (state_91583){
var state_val_91584 = (state_91583[(1)]);
if((state_val_91584 === (7))){
var inst_91565 = (state_91583[(2)]);
var state_91583__$1 = state_91583;
var statearr_91585_91612 = state_91583__$1;
(statearr_91585_91612[(2)] = inst_91565);

(statearr_91585_91612[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91584 === (1))){
var inst_91559 = cljs.core.seq.call(null,coll);
var inst_91560 = inst_91559;
var state_91583__$1 = (function (){var statearr_91586 = state_91583;
(statearr_91586[(7)] = inst_91560);

return statearr_91586;
})();
var statearr_91587_91613 = state_91583__$1;
(statearr_91587_91613[(2)] = null);

(statearr_91587_91613[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91584 === (4))){
var inst_91560 = (state_91583[(7)]);
var inst_91563 = cljs.core.first.call(null,inst_91560);
var state_91583__$1 = state_91583;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_91583__$1,(7),ch,inst_91563);
} else {
if((state_val_91584 === (13))){
var inst_91577 = (state_91583[(2)]);
var state_91583__$1 = state_91583;
var statearr_91588_91614 = state_91583__$1;
(statearr_91588_91614[(2)] = inst_91577);

(statearr_91588_91614[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91584 === (6))){
var inst_91568 = (state_91583[(2)]);
var state_91583__$1 = state_91583;
if(cljs.core.truth_(inst_91568)){
var statearr_91589_91615 = state_91583__$1;
(statearr_91589_91615[(1)] = (8));

} else {
var statearr_91590_91616 = state_91583__$1;
(statearr_91590_91616[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91584 === (3))){
var inst_91581 = (state_91583[(2)]);
var state_91583__$1 = state_91583;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_91583__$1,inst_91581);
} else {
if((state_val_91584 === (12))){
var state_91583__$1 = state_91583;
var statearr_91591_91617 = state_91583__$1;
(statearr_91591_91617[(2)] = null);

(statearr_91591_91617[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91584 === (2))){
var inst_91560 = (state_91583[(7)]);
var state_91583__$1 = state_91583;
if(cljs.core.truth_(inst_91560)){
var statearr_91592_91618 = state_91583__$1;
(statearr_91592_91618[(1)] = (4));

} else {
var statearr_91593_91619 = state_91583__$1;
(statearr_91593_91619[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91584 === (11))){
var inst_91574 = cljs.core.async.close_BANG_.call(null,ch);
var state_91583__$1 = state_91583;
var statearr_91594_91620 = state_91583__$1;
(statearr_91594_91620[(2)] = inst_91574);

(statearr_91594_91620[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91584 === (9))){
var state_91583__$1 = state_91583;
if(cljs.core.truth_(close_QMARK_)){
var statearr_91595_91621 = state_91583__$1;
(statearr_91595_91621[(1)] = (11));

} else {
var statearr_91596_91622 = state_91583__$1;
(statearr_91596_91622[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91584 === (5))){
var inst_91560 = (state_91583[(7)]);
var state_91583__$1 = state_91583;
var statearr_91597_91623 = state_91583__$1;
(statearr_91597_91623[(2)] = inst_91560);

(statearr_91597_91623[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91584 === (10))){
var inst_91579 = (state_91583[(2)]);
var state_91583__$1 = state_91583;
var statearr_91598_91624 = state_91583__$1;
(statearr_91598_91624[(2)] = inst_91579);

(statearr_91598_91624[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91584 === (8))){
var inst_91560 = (state_91583[(7)]);
var inst_91570 = cljs.core.next.call(null,inst_91560);
var inst_91560__$1 = inst_91570;
var state_91583__$1 = (function (){var statearr_91599 = state_91583;
(statearr_91599[(7)] = inst_91560__$1);

return statearr_91599;
})();
var statearr_91600_91625 = state_91583__$1;
(statearr_91600_91625[(2)] = null);

(statearr_91600_91625[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41974__auto__))
;
return ((function (switch__41860__auto__,c__41974__auto__){
return (function() {
var cljs$core$async$state_machine__41861__auto__ = null;
var cljs$core$async$state_machine__41861__auto____0 = (function (){
var statearr_91604 = [null,null,null,null,null,null,null,null];
(statearr_91604[(0)] = cljs$core$async$state_machine__41861__auto__);

(statearr_91604[(1)] = (1));

return statearr_91604;
});
var cljs$core$async$state_machine__41861__auto____1 = (function (state_91583){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_91583);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e91605){if((e91605 instanceof Object)){
var ex__41864__auto__ = e91605;
var statearr_91606_91626 = state_91583;
(statearr_91606_91626[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_91583);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e91605;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__91627 = state_91583;
state_91583 = G__91627;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
cljs$core$async$state_machine__41861__auto__ = function(state_91583){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41861__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41861__auto____1.call(this,state_91583);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41861__auto____0;
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41861__auto____1;
return cljs$core$async$state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto__))
})();
var state__41976__auto__ = (function (){var statearr_91607 = f__41975__auto__.call(null);
(statearr_91607[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto__);

return statearr_91607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto__))
);

return c__41974__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__27993__auto__ = (((_ == null))?null:_);
var m__27994__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,_);
} else {
var m__27994__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__27994__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m,ch);
} else {
var m__27994__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m);
} else {
var m__27994__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async91853 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async91853 = (function (ch,cs,meta91854){
this.ch = ch;
this.cs = cs;
this.meta91854 = meta91854;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async91853.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_91855,meta91854__$1){
var self__ = this;
var _91855__$1 = this;
return (new cljs.core.async.t_cljs$core$async91853(self__.ch,self__.cs,meta91854__$1));
});})(cs))
;


cljs.core.async.t_cljs$core$async91853.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_91855){
var self__ = this;
var _91855__$1 = this;
return self__.meta91854;
});})(cs))
;


cljs.core.async.t_cljs$core$async91853.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async91853.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;


cljs.core.async.t_cljs$core$async91853.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async91853.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;


cljs.core.async.t_cljs$core$async91853.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;


cljs.core.async.t_cljs$core$async91853.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async91853.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta91854","meta91854",4184189,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async91853.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async91853.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async91853";

cljs.core.async.t_cljs$core$async91853.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async91853");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async91853 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async91853(ch__$1,cs__$1,meta91854){
return (new cljs.core.async.t_cljs$core$async91853(ch__$1,cs__$1,meta91854));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async91853(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__41974__auto___92078 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto___92078,cs,m,dchan,dctr,done){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto___92078,cs,m,dchan,dctr,done){
return (function (state_91990){
var state_val_91991 = (state_91990[(1)]);
if((state_val_91991 === (7))){
var inst_91986 = (state_91990[(2)]);
var state_91990__$1 = state_91990;
var statearr_91992_92079 = state_91990__$1;
(statearr_91992_92079[(2)] = inst_91986);

(statearr_91992_92079[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (20))){
var inst_91889 = (state_91990[(7)]);
var inst_91901 = cljs.core.first.call(null,inst_91889);
var inst_91902 = cljs.core.nth.call(null,inst_91901,(0),null);
var inst_91903 = cljs.core.nth.call(null,inst_91901,(1),null);
var state_91990__$1 = (function (){var statearr_91993 = state_91990;
(statearr_91993[(8)] = inst_91902);

return statearr_91993;
})();
if(cljs.core.truth_(inst_91903)){
var statearr_91994_92080 = state_91990__$1;
(statearr_91994_92080[(1)] = (22));

} else {
var statearr_91995_92081 = state_91990__$1;
(statearr_91995_92081[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (27))){
var inst_91933 = (state_91990[(9)]);
var inst_91858 = (state_91990[(10)]);
var inst_91931 = (state_91990[(11)]);
var inst_91938 = (state_91990[(12)]);
var inst_91938__$1 = cljs.core._nth.call(null,inst_91931,inst_91933);
var inst_91939 = cljs.core.async.put_BANG_.call(null,inst_91938__$1,inst_91858,done);
var state_91990__$1 = (function (){var statearr_91996 = state_91990;
(statearr_91996[(12)] = inst_91938__$1);

return statearr_91996;
})();
if(cljs.core.truth_(inst_91939)){
var statearr_91997_92082 = state_91990__$1;
(statearr_91997_92082[(1)] = (30));

} else {
var statearr_91998_92083 = state_91990__$1;
(statearr_91998_92083[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (1))){
var state_91990__$1 = state_91990;
var statearr_91999_92084 = state_91990__$1;
(statearr_91999_92084[(2)] = null);

(statearr_91999_92084[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (24))){
var inst_91889 = (state_91990[(7)]);
var inst_91908 = (state_91990[(2)]);
var inst_91909 = cljs.core.next.call(null,inst_91889);
var inst_91867 = inst_91909;
var inst_91868 = null;
var inst_91869 = (0);
var inst_91870 = (0);
var state_91990__$1 = (function (){var statearr_92000 = state_91990;
(statearr_92000[(13)] = inst_91868);

(statearr_92000[(14)] = inst_91867);

(statearr_92000[(15)] = inst_91870);

(statearr_92000[(16)] = inst_91908);

(statearr_92000[(17)] = inst_91869);

return statearr_92000;
})();
var statearr_92001_92085 = state_91990__$1;
(statearr_92001_92085[(2)] = null);

(statearr_92001_92085[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (39))){
var state_91990__$1 = state_91990;
var statearr_92005_92086 = state_91990__$1;
(statearr_92005_92086[(2)] = null);

(statearr_92005_92086[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (4))){
var inst_91858 = (state_91990[(10)]);
var inst_91858__$1 = (state_91990[(2)]);
var inst_91859 = (inst_91858__$1 == null);
var state_91990__$1 = (function (){var statearr_92006 = state_91990;
(statearr_92006[(10)] = inst_91858__$1);

return statearr_92006;
})();
if(cljs.core.truth_(inst_91859)){
var statearr_92007_92087 = state_91990__$1;
(statearr_92007_92087[(1)] = (5));

} else {
var statearr_92008_92088 = state_91990__$1;
(statearr_92008_92088[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (15))){
var inst_91868 = (state_91990[(13)]);
var inst_91867 = (state_91990[(14)]);
var inst_91870 = (state_91990[(15)]);
var inst_91869 = (state_91990[(17)]);
var inst_91885 = (state_91990[(2)]);
var inst_91886 = (inst_91870 + (1));
var tmp92002 = inst_91868;
var tmp92003 = inst_91867;
var tmp92004 = inst_91869;
var inst_91867__$1 = tmp92003;
var inst_91868__$1 = tmp92002;
var inst_91869__$1 = tmp92004;
var inst_91870__$1 = inst_91886;
var state_91990__$1 = (function (){var statearr_92009 = state_91990;
(statearr_92009[(13)] = inst_91868__$1);

(statearr_92009[(14)] = inst_91867__$1);

(statearr_92009[(15)] = inst_91870__$1);

(statearr_92009[(18)] = inst_91885);

(statearr_92009[(17)] = inst_91869__$1);

return statearr_92009;
})();
var statearr_92010_92089 = state_91990__$1;
(statearr_92010_92089[(2)] = null);

(statearr_92010_92089[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (21))){
var inst_91912 = (state_91990[(2)]);
var state_91990__$1 = state_91990;
var statearr_92014_92090 = state_91990__$1;
(statearr_92014_92090[(2)] = inst_91912);

(statearr_92014_92090[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (31))){
var inst_91938 = (state_91990[(12)]);
var inst_91942 = done.call(null,null);
var inst_91943 = cljs.core.async.untap_STAR_.call(null,m,inst_91938);
var state_91990__$1 = (function (){var statearr_92015 = state_91990;
(statearr_92015[(19)] = inst_91942);

return statearr_92015;
})();
var statearr_92016_92091 = state_91990__$1;
(statearr_92016_92091[(2)] = inst_91943);

(statearr_92016_92091[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (32))){
var inst_91933 = (state_91990[(9)]);
var inst_91932 = (state_91990[(20)]);
var inst_91930 = (state_91990[(21)]);
var inst_91931 = (state_91990[(11)]);
var inst_91945 = (state_91990[(2)]);
var inst_91946 = (inst_91933 + (1));
var tmp92011 = inst_91932;
var tmp92012 = inst_91930;
var tmp92013 = inst_91931;
var inst_91930__$1 = tmp92012;
var inst_91931__$1 = tmp92013;
var inst_91932__$1 = tmp92011;
var inst_91933__$1 = inst_91946;
var state_91990__$1 = (function (){var statearr_92017 = state_91990;
(statearr_92017[(9)] = inst_91933__$1);

(statearr_92017[(20)] = inst_91932__$1);

(statearr_92017[(21)] = inst_91930__$1);

(statearr_92017[(22)] = inst_91945);

(statearr_92017[(11)] = inst_91931__$1);

return statearr_92017;
})();
var statearr_92018_92092 = state_91990__$1;
(statearr_92018_92092[(2)] = null);

(statearr_92018_92092[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (40))){
var inst_91958 = (state_91990[(23)]);
var inst_91962 = done.call(null,null);
var inst_91963 = cljs.core.async.untap_STAR_.call(null,m,inst_91958);
var state_91990__$1 = (function (){var statearr_92019 = state_91990;
(statearr_92019[(24)] = inst_91962);

return statearr_92019;
})();
var statearr_92020_92093 = state_91990__$1;
(statearr_92020_92093[(2)] = inst_91963);

(statearr_92020_92093[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (33))){
var inst_91949 = (state_91990[(25)]);
var inst_91951 = cljs.core.chunked_seq_QMARK_.call(null,inst_91949);
var state_91990__$1 = state_91990;
if(inst_91951){
var statearr_92021_92094 = state_91990__$1;
(statearr_92021_92094[(1)] = (36));

} else {
var statearr_92022_92095 = state_91990__$1;
(statearr_92022_92095[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (13))){
var inst_91879 = (state_91990[(26)]);
var inst_91882 = cljs.core.async.close_BANG_.call(null,inst_91879);
var state_91990__$1 = state_91990;
var statearr_92023_92096 = state_91990__$1;
(statearr_92023_92096[(2)] = inst_91882);

(statearr_92023_92096[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (22))){
var inst_91902 = (state_91990[(8)]);
var inst_91905 = cljs.core.async.close_BANG_.call(null,inst_91902);
var state_91990__$1 = state_91990;
var statearr_92024_92097 = state_91990__$1;
(statearr_92024_92097[(2)] = inst_91905);

(statearr_92024_92097[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (36))){
var inst_91949 = (state_91990[(25)]);
var inst_91953 = cljs.core.chunk_first.call(null,inst_91949);
var inst_91954 = cljs.core.chunk_rest.call(null,inst_91949);
var inst_91955 = cljs.core.count.call(null,inst_91953);
var inst_91930 = inst_91954;
var inst_91931 = inst_91953;
var inst_91932 = inst_91955;
var inst_91933 = (0);
var state_91990__$1 = (function (){var statearr_92025 = state_91990;
(statearr_92025[(9)] = inst_91933);

(statearr_92025[(20)] = inst_91932);

(statearr_92025[(21)] = inst_91930);

(statearr_92025[(11)] = inst_91931);

return statearr_92025;
})();
var statearr_92026_92098 = state_91990__$1;
(statearr_92026_92098[(2)] = null);

(statearr_92026_92098[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (41))){
var inst_91949 = (state_91990[(25)]);
var inst_91965 = (state_91990[(2)]);
var inst_91966 = cljs.core.next.call(null,inst_91949);
var inst_91930 = inst_91966;
var inst_91931 = null;
var inst_91932 = (0);
var inst_91933 = (0);
var state_91990__$1 = (function (){var statearr_92027 = state_91990;
(statearr_92027[(9)] = inst_91933);

(statearr_92027[(27)] = inst_91965);

(statearr_92027[(20)] = inst_91932);

(statearr_92027[(21)] = inst_91930);

(statearr_92027[(11)] = inst_91931);

return statearr_92027;
})();
var statearr_92028_92099 = state_91990__$1;
(statearr_92028_92099[(2)] = null);

(statearr_92028_92099[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (43))){
var state_91990__$1 = state_91990;
var statearr_92029_92100 = state_91990__$1;
(statearr_92029_92100[(2)] = null);

(statearr_92029_92100[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (29))){
var inst_91974 = (state_91990[(2)]);
var state_91990__$1 = state_91990;
var statearr_92030_92101 = state_91990__$1;
(statearr_92030_92101[(2)] = inst_91974);

(statearr_92030_92101[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (44))){
var inst_91983 = (state_91990[(2)]);
var state_91990__$1 = (function (){var statearr_92031 = state_91990;
(statearr_92031[(28)] = inst_91983);

return statearr_92031;
})();
var statearr_92032_92102 = state_91990__$1;
(statearr_92032_92102[(2)] = null);

(statearr_92032_92102[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (6))){
var inst_91922 = (state_91990[(29)]);
var inst_91921 = cljs.core.deref.call(null,cs);
var inst_91922__$1 = cljs.core.keys.call(null,inst_91921);
var inst_91923 = cljs.core.count.call(null,inst_91922__$1);
var inst_91924 = cljs.core.reset_BANG_.call(null,dctr,inst_91923);
var inst_91929 = cljs.core.seq.call(null,inst_91922__$1);
var inst_91930 = inst_91929;
var inst_91931 = null;
var inst_91932 = (0);
var inst_91933 = (0);
var state_91990__$1 = (function (){var statearr_92033 = state_91990;
(statearr_92033[(9)] = inst_91933);

(statearr_92033[(29)] = inst_91922__$1);

(statearr_92033[(20)] = inst_91932);

(statearr_92033[(21)] = inst_91930);

(statearr_92033[(30)] = inst_91924);

(statearr_92033[(11)] = inst_91931);

return statearr_92033;
})();
var statearr_92034_92103 = state_91990__$1;
(statearr_92034_92103[(2)] = null);

(statearr_92034_92103[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (28))){
var inst_91949 = (state_91990[(25)]);
var inst_91930 = (state_91990[(21)]);
var inst_91949__$1 = cljs.core.seq.call(null,inst_91930);
var state_91990__$1 = (function (){var statearr_92035 = state_91990;
(statearr_92035[(25)] = inst_91949__$1);

return statearr_92035;
})();
if(inst_91949__$1){
var statearr_92036_92104 = state_91990__$1;
(statearr_92036_92104[(1)] = (33));

} else {
var statearr_92037_92105 = state_91990__$1;
(statearr_92037_92105[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (25))){
var inst_91933 = (state_91990[(9)]);
var inst_91932 = (state_91990[(20)]);
var inst_91935 = (inst_91933 < inst_91932);
var inst_91936 = inst_91935;
var state_91990__$1 = state_91990;
if(cljs.core.truth_(inst_91936)){
var statearr_92038_92106 = state_91990__$1;
(statearr_92038_92106[(1)] = (27));

} else {
var statearr_92039_92107 = state_91990__$1;
(statearr_92039_92107[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (34))){
var state_91990__$1 = state_91990;
var statearr_92040_92108 = state_91990__$1;
(statearr_92040_92108[(2)] = null);

(statearr_92040_92108[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (17))){
var state_91990__$1 = state_91990;
var statearr_92041_92109 = state_91990__$1;
(statearr_92041_92109[(2)] = null);

(statearr_92041_92109[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (3))){
var inst_91988 = (state_91990[(2)]);
var state_91990__$1 = state_91990;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_91990__$1,inst_91988);
} else {
if((state_val_91991 === (12))){
var inst_91917 = (state_91990[(2)]);
var state_91990__$1 = state_91990;
var statearr_92042_92110 = state_91990__$1;
(statearr_92042_92110[(2)] = inst_91917);

(statearr_92042_92110[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (2))){
var state_91990__$1 = state_91990;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_91990__$1,(4),ch);
} else {
if((state_val_91991 === (23))){
var state_91990__$1 = state_91990;
var statearr_92043_92111 = state_91990__$1;
(statearr_92043_92111[(2)] = null);

(statearr_92043_92111[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (35))){
var inst_91972 = (state_91990[(2)]);
var state_91990__$1 = state_91990;
var statearr_92044_92112 = state_91990__$1;
(statearr_92044_92112[(2)] = inst_91972);

(statearr_92044_92112[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (19))){
var inst_91889 = (state_91990[(7)]);
var inst_91893 = cljs.core.chunk_first.call(null,inst_91889);
var inst_91894 = cljs.core.chunk_rest.call(null,inst_91889);
var inst_91895 = cljs.core.count.call(null,inst_91893);
var inst_91867 = inst_91894;
var inst_91868 = inst_91893;
var inst_91869 = inst_91895;
var inst_91870 = (0);
var state_91990__$1 = (function (){var statearr_92045 = state_91990;
(statearr_92045[(13)] = inst_91868);

(statearr_92045[(14)] = inst_91867);

(statearr_92045[(15)] = inst_91870);

(statearr_92045[(17)] = inst_91869);

return statearr_92045;
})();
var statearr_92046_92113 = state_91990__$1;
(statearr_92046_92113[(2)] = null);

(statearr_92046_92113[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (11))){
var inst_91889 = (state_91990[(7)]);
var inst_91867 = (state_91990[(14)]);
var inst_91889__$1 = cljs.core.seq.call(null,inst_91867);
var state_91990__$1 = (function (){var statearr_92047 = state_91990;
(statearr_92047[(7)] = inst_91889__$1);

return statearr_92047;
})();
if(inst_91889__$1){
var statearr_92048_92114 = state_91990__$1;
(statearr_92048_92114[(1)] = (16));

} else {
var statearr_92049_92115 = state_91990__$1;
(statearr_92049_92115[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (9))){
var inst_91919 = (state_91990[(2)]);
var state_91990__$1 = state_91990;
var statearr_92050_92116 = state_91990__$1;
(statearr_92050_92116[(2)] = inst_91919);

(statearr_92050_92116[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (5))){
var inst_91865 = cljs.core.deref.call(null,cs);
var inst_91866 = cljs.core.seq.call(null,inst_91865);
var inst_91867 = inst_91866;
var inst_91868 = null;
var inst_91869 = (0);
var inst_91870 = (0);
var state_91990__$1 = (function (){var statearr_92051 = state_91990;
(statearr_92051[(13)] = inst_91868);

(statearr_92051[(14)] = inst_91867);

(statearr_92051[(15)] = inst_91870);

(statearr_92051[(17)] = inst_91869);

return statearr_92051;
})();
var statearr_92052_92117 = state_91990__$1;
(statearr_92052_92117[(2)] = null);

(statearr_92052_92117[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (14))){
var state_91990__$1 = state_91990;
var statearr_92053_92118 = state_91990__$1;
(statearr_92053_92118[(2)] = null);

(statearr_92053_92118[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (45))){
var inst_91980 = (state_91990[(2)]);
var state_91990__$1 = state_91990;
var statearr_92054_92119 = state_91990__$1;
(statearr_92054_92119[(2)] = inst_91980);

(statearr_92054_92119[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (26))){
var inst_91922 = (state_91990[(29)]);
var inst_91976 = (state_91990[(2)]);
var inst_91977 = cljs.core.seq.call(null,inst_91922);
var state_91990__$1 = (function (){var statearr_92055 = state_91990;
(statearr_92055[(31)] = inst_91976);

return statearr_92055;
})();
if(inst_91977){
var statearr_92056_92120 = state_91990__$1;
(statearr_92056_92120[(1)] = (42));

} else {
var statearr_92057_92121 = state_91990__$1;
(statearr_92057_92121[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (16))){
var inst_91889 = (state_91990[(7)]);
var inst_91891 = cljs.core.chunked_seq_QMARK_.call(null,inst_91889);
var state_91990__$1 = state_91990;
if(inst_91891){
var statearr_92058_92122 = state_91990__$1;
(statearr_92058_92122[(1)] = (19));

} else {
var statearr_92059_92123 = state_91990__$1;
(statearr_92059_92123[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (38))){
var inst_91969 = (state_91990[(2)]);
var state_91990__$1 = state_91990;
var statearr_92060_92124 = state_91990__$1;
(statearr_92060_92124[(2)] = inst_91969);

(statearr_92060_92124[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (30))){
var state_91990__$1 = state_91990;
var statearr_92061_92125 = state_91990__$1;
(statearr_92061_92125[(2)] = null);

(statearr_92061_92125[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (10))){
var inst_91868 = (state_91990[(13)]);
var inst_91870 = (state_91990[(15)]);
var inst_91878 = cljs.core._nth.call(null,inst_91868,inst_91870);
var inst_91879 = cljs.core.nth.call(null,inst_91878,(0),null);
var inst_91880 = cljs.core.nth.call(null,inst_91878,(1),null);
var state_91990__$1 = (function (){var statearr_92062 = state_91990;
(statearr_92062[(26)] = inst_91879);

return statearr_92062;
})();
if(cljs.core.truth_(inst_91880)){
var statearr_92063_92126 = state_91990__$1;
(statearr_92063_92126[(1)] = (13));

} else {
var statearr_92064_92127 = state_91990__$1;
(statearr_92064_92127[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (18))){
var inst_91915 = (state_91990[(2)]);
var state_91990__$1 = state_91990;
var statearr_92065_92128 = state_91990__$1;
(statearr_92065_92128[(2)] = inst_91915);

(statearr_92065_92128[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (42))){
var state_91990__$1 = state_91990;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_91990__$1,(45),dchan);
} else {
if((state_val_91991 === (37))){
var inst_91858 = (state_91990[(10)]);
var inst_91949 = (state_91990[(25)]);
var inst_91958 = (state_91990[(23)]);
var inst_91958__$1 = cljs.core.first.call(null,inst_91949);
var inst_91959 = cljs.core.async.put_BANG_.call(null,inst_91958__$1,inst_91858,done);
var state_91990__$1 = (function (){var statearr_92066 = state_91990;
(statearr_92066[(23)] = inst_91958__$1);

return statearr_92066;
})();
if(cljs.core.truth_(inst_91959)){
var statearr_92067_92129 = state_91990__$1;
(statearr_92067_92129[(1)] = (39));

} else {
var statearr_92068_92130 = state_91990__$1;
(statearr_92068_92130[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_91991 === (8))){
var inst_91870 = (state_91990[(15)]);
var inst_91869 = (state_91990[(17)]);
var inst_91872 = (inst_91870 < inst_91869);
var inst_91873 = inst_91872;
var state_91990__$1 = state_91990;
if(cljs.core.truth_(inst_91873)){
var statearr_92069_92131 = state_91990__$1;
(statearr_92069_92131[(1)] = (10));

} else {
var statearr_92070_92132 = state_91990__$1;
(statearr_92070_92132[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41974__auto___92078,cs,m,dchan,dctr,done))
;
return ((function (switch__41860__auto__,c__41974__auto___92078,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__41861__auto__ = null;
var cljs$core$async$mult_$_state_machine__41861__auto____0 = (function (){
var statearr_92074 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_92074[(0)] = cljs$core$async$mult_$_state_machine__41861__auto__);

(statearr_92074[(1)] = (1));

return statearr_92074;
});
var cljs$core$async$mult_$_state_machine__41861__auto____1 = (function (state_91990){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_91990);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e92075){if((e92075 instanceof Object)){
var ex__41864__auto__ = e92075;
var statearr_92076_92133 = state_91990;
(statearr_92076_92133[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_91990);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e92075;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__92134 = state_91990;
state_91990 = G__92134;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__41861__auto__ = function(state_91990){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__41861__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__41861__auto____1.call(this,state_91990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__41861__auto____0;
cljs$core$async$mult_$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__41861__auto____1;
return cljs$core$async$mult_$_state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto___92078,cs,m,dchan,dctr,done))
})();
var state__41976__auto__ = (function (){var statearr_92077 = f__41975__auto__.call(null);
(statearr_92077[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto___92078);

return statearr_92077;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto___92078,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args92135 = [];
var len__28496__auto___92138 = arguments.length;
var i__28497__auto___92139 = (0);
while(true){
if((i__28497__auto___92139 < len__28496__auto___92138)){
args92135.push((arguments[i__28497__auto___92139]));

var G__92140 = (i__28497__auto___92139 + (1));
i__28497__auto___92139 = G__92140;
continue;
} else {
}
break;
}

var G__92137 = args92135.length;
switch (G__92137) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args92135.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m,ch);
} else {
var m__27994__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m,ch);
} else {
var m__27994__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m);
} else {
var m__27994__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m,state_map);
} else {
var m__27994__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__27993__auto__ = (((m == null))?null:m);
var m__27994__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,m,mode);
} else {
var m__27994__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__28503__auto__ = [];
var len__28496__auto___92152 = arguments.length;
var i__28497__auto___92153 = (0);
while(true){
if((i__28497__auto___92153 < len__28496__auto___92152)){
args__28503__auto__.push((arguments[i__28497__auto___92153]));

var G__92154 = (i__28497__auto___92153 + (1));
i__28497__auto___92153 = G__92154;
continue;
} else {
}
break;
}

var argseq__28504__auto__ = ((((3) < args__28503__auto__.length))?(new cljs.core.IndexedSeq(args__28503__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__28504__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__92146){
var map__92147 = p__92146;
var map__92147__$1 = ((((!((map__92147 == null)))?((((map__92147.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__92147.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__92147):map__92147);
var opts = map__92147__$1;
var statearr_92149_92155 = state;
(statearr_92149_92155[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__6753__auto__ = cljs.core.async.do_alts.call(null,((function (map__92147,map__92147__$1,opts){
return (function (val){
var statearr_92150_92156 = state;
(statearr_92150_92156[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__92147,map__92147__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__6753__auto__)){
var cb = temp__6753__auto__;
var statearr_92151_92157 = state;
(statearr_92151_92157[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq92142){
var G__92143 = cljs.core.first.call(null,seq92142);
var seq92142__$1 = cljs.core.next.call(null,seq92142);
var G__92144 = cljs.core.first.call(null,seq92142__$1);
var seq92142__$2 = cljs.core.next.call(null,seq92142__$1);
var G__92145 = cljs.core.first.call(null,seq92142__$2);
var seq92142__$3 = cljs.core.next.call(null,seq92142__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__92143,G__92144,G__92145,seq92142__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async92325 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async92325 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta92326){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta92326 = meta92326;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async92325.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_92327,meta92326__$1){
var self__ = this;
var _92327__$1 = this;
return (new cljs.core.async.t_cljs$core$async92325(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta92326__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async92325.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_92327){
var self__ = this;
var _92327__$1 = this;
return self__.meta92326;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async92325.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async92325.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async92325.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async92325.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async92325.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async92325.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async92325.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;


cljs.core.async.t_cljs$core$async92325.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str([cljs.core.str("mode must be one of: "),cljs.core.str(self__.solo_modes)].join('')),cljs.core.str("\n"),cljs.core.str("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async92325.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta92326","meta92326",312075603,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async92325.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async92325.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async92325";

cljs.core.async.t_cljs$core$async92325.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async92325");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async92325 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async92325(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta92326){
return (new cljs.core.async.t_cljs$core$async92325(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta92326));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async92325(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__41974__auto___92492 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto___92492,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto___92492,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_92429){
var state_val_92430 = (state_92429[(1)]);
if((state_val_92430 === (7))){
var inst_92344 = (state_92429[(2)]);
var state_92429__$1 = state_92429;
var statearr_92431_92493 = state_92429__$1;
(statearr_92431_92493[(2)] = inst_92344);

(statearr_92431_92493[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (20))){
var inst_92356 = (state_92429[(7)]);
var state_92429__$1 = state_92429;
var statearr_92432_92494 = state_92429__$1;
(statearr_92432_92494[(2)] = inst_92356);

(statearr_92432_92494[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (27))){
var state_92429__$1 = state_92429;
var statearr_92433_92495 = state_92429__$1;
(statearr_92433_92495[(2)] = null);

(statearr_92433_92495[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (1))){
var inst_92331 = (state_92429[(8)]);
var inst_92331__$1 = calc_state.call(null);
var inst_92333 = (inst_92331__$1 == null);
var inst_92334 = cljs.core.not.call(null,inst_92333);
var state_92429__$1 = (function (){var statearr_92434 = state_92429;
(statearr_92434[(8)] = inst_92331__$1);

return statearr_92434;
})();
if(inst_92334){
var statearr_92435_92496 = state_92429__$1;
(statearr_92435_92496[(1)] = (2));

} else {
var statearr_92436_92497 = state_92429__$1;
(statearr_92436_92497[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (24))){
var inst_92403 = (state_92429[(9)]);
var inst_92380 = (state_92429[(10)]);
var inst_92389 = (state_92429[(11)]);
var inst_92403__$1 = inst_92380.call(null,inst_92389);
var state_92429__$1 = (function (){var statearr_92437 = state_92429;
(statearr_92437[(9)] = inst_92403__$1);

return statearr_92437;
})();
if(cljs.core.truth_(inst_92403__$1)){
var statearr_92438_92498 = state_92429__$1;
(statearr_92438_92498[(1)] = (29));

} else {
var statearr_92439_92499 = state_92429__$1;
(statearr_92439_92499[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (4))){
var inst_92347 = (state_92429[(2)]);
var state_92429__$1 = state_92429;
if(cljs.core.truth_(inst_92347)){
var statearr_92440_92500 = state_92429__$1;
(statearr_92440_92500[(1)] = (8));

} else {
var statearr_92441_92501 = state_92429__$1;
(statearr_92441_92501[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (15))){
var inst_92374 = (state_92429[(2)]);
var state_92429__$1 = state_92429;
if(cljs.core.truth_(inst_92374)){
var statearr_92442_92502 = state_92429__$1;
(statearr_92442_92502[(1)] = (19));

} else {
var statearr_92443_92503 = state_92429__$1;
(statearr_92443_92503[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (21))){
var inst_92379 = (state_92429[(12)]);
var inst_92379__$1 = (state_92429[(2)]);
var inst_92380 = cljs.core.get.call(null,inst_92379__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_92381 = cljs.core.get.call(null,inst_92379__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_92382 = cljs.core.get.call(null,inst_92379__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_92429__$1 = (function (){var statearr_92444 = state_92429;
(statearr_92444[(10)] = inst_92380);

(statearr_92444[(13)] = inst_92381);

(statearr_92444[(12)] = inst_92379__$1);

return statearr_92444;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_92429__$1,(22),inst_92382);
} else {
if((state_val_92430 === (31))){
var inst_92411 = (state_92429[(2)]);
var state_92429__$1 = state_92429;
if(cljs.core.truth_(inst_92411)){
var statearr_92445_92504 = state_92429__$1;
(statearr_92445_92504[(1)] = (32));

} else {
var statearr_92446_92505 = state_92429__$1;
(statearr_92446_92505[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (32))){
var inst_92388 = (state_92429[(14)]);
var state_92429__$1 = state_92429;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_92429__$1,(35),out,inst_92388);
} else {
if((state_val_92430 === (33))){
var inst_92379 = (state_92429[(12)]);
var inst_92356 = inst_92379;
var state_92429__$1 = (function (){var statearr_92447 = state_92429;
(statearr_92447[(7)] = inst_92356);

return statearr_92447;
})();
var statearr_92448_92506 = state_92429__$1;
(statearr_92448_92506[(2)] = null);

(statearr_92448_92506[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (13))){
var inst_92356 = (state_92429[(7)]);
var inst_92363 = inst_92356.cljs$lang$protocol_mask$partition0$;
var inst_92364 = (inst_92363 & (64));
var inst_92365 = inst_92356.cljs$core$ISeq$;
var inst_92366 = (cljs.core.PROTOCOL_SENTINEL === inst_92365);
var inst_92367 = (inst_92364) || (inst_92366);
var state_92429__$1 = state_92429;
if(cljs.core.truth_(inst_92367)){
var statearr_92449_92507 = state_92429__$1;
(statearr_92449_92507[(1)] = (16));

} else {
var statearr_92450_92508 = state_92429__$1;
(statearr_92450_92508[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (22))){
var inst_92388 = (state_92429[(14)]);
var inst_92389 = (state_92429[(11)]);
var inst_92387 = (state_92429[(2)]);
var inst_92388__$1 = cljs.core.nth.call(null,inst_92387,(0),null);
var inst_92389__$1 = cljs.core.nth.call(null,inst_92387,(1),null);
var inst_92390 = (inst_92388__$1 == null);
var inst_92391 = cljs.core._EQ_.call(null,inst_92389__$1,change);
var inst_92392 = (inst_92390) || (inst_92391);
var state_92429__$1 = (function (){var statearr_92451 = state_92429;
(statearr_92451[(14)] = inst_92388__$1);

(statearr_92451[(11)] = inst_92389__$1);

return statearr_92451;
})();
if(cljs.core.truth_(inst_92392)){
var statearr_92452_92509 = state_92429__$1;
(statearr_92452_92509[(1)] = (23));

} else {
var statearr_92453_92510 = state_92429__$1;
(statearr_92453_92510[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (36))){
var inst_92379 = (state_92429[(12)]);
var inst_92356 = inst_92379;
var state_92429__$1 = (function (){var statearr_92454 = state_92429;
(statearr_92454[(7)] = inst_92356);

return statearr_92454;
})();
var statearr_92455_92511 = state_92429__$1;
(statearr_92455_92511[(2)] = null);

(statearr_92455_92511[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (29))){
var inst_92403 = (state_92429[(9)]);
var state_92429__$1 = state_92429;
var statearr_92456_92512 = state_92429__$1;
(statearr_92456_92512[(2)] = inst_92403);

(statearr_92456_92512[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (6))){
var state_92429__$1 = state_92429;
var statearr_92457_92513 = state_92429__$1;
(statearr_92457_92513[(2)] = false);

(statearr_92457_92513[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (28))){
var inst_92399 = (state_92429[(2)]);
var inst_92400 = calc_state.call(null);
var inst_92356 = inst_92400;
var state_92429__$1 = (function (){var statearr_92458 = state_92429;
(statearr_92458[(15)] = inst_92399);

(statearr_92458[(7)] = inst_92356);

return statearr_92458;
})();
var statearr_92459_92514 = state_92429__$1;
(statearr_92459_92514[(2)] = null);

(statearr_92459_92514[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (25))){
var inst_92425 = (state_92429[(2)]);
var state_92429__$1 = state_92429;
var statearr_92460_92515 = state_92429__$1;
(statearr_92460_92515[(2)] = inst_92425);

(statearr_92460_92515[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (34))){
var inst_92423 = (state_92429[(2)]);
var state_92429__$1 = state_92429;
var statearr_92461_92516 = state_92429__$1;
(statearr_92461_92516[(2)] = inst_92423);

(statearr_92461_92516[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (17))){
var state_92429__$1 = state_92429;
var statearr_92462_92517 = state_92429__$1;
(statearr_92462_92517[(2)] = false);

(statearr_92462_92517[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (3))){
var state_92429__$1 = state_92429;
var statearr_92463_92518 = state_92429__$1;
(statearr_92463_92518[(2)] = false);

(statearr_92463_92518[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (12))){
var inst_92427 = (state_92429[(2)]);
var state_92429__$1 = state_92429;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_92429__$1,inst_92427);
} else {
if((state_val_92430 === (2))){
var inst_92331 = (state_92429[(8)]);
var inst_92336 = inst_92331.cljs$lang$protocol_mask$partition0$;
var inst_92337 = (inst_92336 & (64));
var inst_92338 = inst_92331.cljs$core$ISeq$;
var inst_92339 = (cljs.core.PROTOCOL_SENTINEL === inst_92338);
var inst_92340 = (inst_92337) || (inst_92339);
var state_92429__$1 = state_92429;
if(cljs.core.truth_(inst_92340)){
var statearr_92464_92519 = state_92429__$1;
(statearr_92464_92519[(1)] = (5));

} else {
var statearr_92465_92520 = state_92429__$1;
(statearr_92465_92520[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (23))){
var inst_92388 = (state_92429[(14)]);
var inst_92394 = (inst_92388 == null);
var state_92429__$1 = state_92429;
if(cljs.core.truth_(inst_92394)){
var statearr_92466_92521 = state_92429__$1;
(statearr_92466_92521[(1)] = (26));

} else {
var statearr_92467_92522 = state_92429__$1;
(statearr_92467_92522[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (35))){
var inst_92414 = (state_92429[(2)]);
var state_92429__$1 = state_92429;
if(cljs.core.truth_(inst_92414)){
var statearr_92468_92523 = state_92429__$1;
(statearr_92468_92523[(1)] = (36));

} else {
var statearr_92469_92524 = state_92429__$1;
(statearr_92469_92524[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (19))){
var inst_92356 = (state_92429[(7)]);
var inst_92376 = cljs.core.apply.call(null,cljs.core.hash_map,inst_92356);
var state_92429__$1 = state_92429;
var statearr_92470_92525 = state_92429__$1;
(statearr_92470_92525[(2)] = inst_92376);

(statearr_92470_92525[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (11))){
var inst_92356 = (state_92429[(7)]);
var inst_92360 = (inst_92356 == null);
var inst_92361 = cljs.core.not.call(null,inst_92360);
var state_92429__$1 = state_92429;
if(inst_92361){
var statearr_92471_92526 = state_92429__$1;
(statearr_92471_92526[(1)] = (13));

} else {
var statearr_92472_92527 = state_92429__$1;
(statearr_92472_92527[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (9))){
var inst_92331 = (state_92429[(8)]);
var state_92429__$1 = state_92429;
var statearr_92473_92528 = state_92429__$1;
(statearr_92473_92528[(2)] = inst_92331);

(statearr_92473_92528[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (5))){
var state_92429__$1 = state_92429;
var statearr_92474_92529 = state_92429__$1;
(statearr_92474_92529[(2)] = true);

(statearr_92474_92529[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (14))){
var state_92429__$1 = state_92429;
var statearr_92475_92530 = state_92429__$1;
(statearr_92475_92530[(2)] = false);

(statearr_92475_92530[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (26))){
var inst_92389 = (state_92429[(11)]);
var inst_92396 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_92389);
var state_92429__$1 = state_92429;
var statearr_92476_92531 = state_92429__$1;
(statearr_92476_92531[(2)] = inst_92396);

(statearr_92476_92531[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (16))){
var state_92429__$1 = state_92429;
var statearr_92477_92532 = state_92429__$1;
(statearr_92477_92532[(2)] = true);

(statearr_92477_92532[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (38))){
var inst_92419 = (state_92429[(2)]);
var state_92429__$1 = state_92429;
var statearr_92478_92533 = state_92429__$1;
(statearr_92478_92533[(2)] = inst_92419);

(statearr_92478_92533[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (30))){
var inst_92380 = (state_92429[(10)]);
var inst_92381 = (state_92429[(13)]);
var inst_92389 = (state_92429[(11)]);
var inst_92406 = cljs.core.empty_QMARK_.call(null,inst_92380);
var inst_92407 = inst_92381.call(null,inst_92389);
var inst_92408 = cljs.core.not.call(null,inst_92407);
var inst_92409 = (inst_92406) && (inst_92408);
var state_92429__$1 = state_92429;
var statearr_92479_92534 = state_92429__$1;
(statearr_92479_92534[(2)] = inst_92409);

(statearr_92479_92534[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (10))){
var inst_92331 = (state_92429[(8)]);
var inst_92352 = (state_92429[(2)]);
var inst_92353 = cljs.core.get.call(null,inst_92352,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_92354 = cljs.core.get.call(null,inst_92352,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_92355 = cljs.core.get.call(null,inst_92352,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_92356 = inst_92331;
var state_92429__$1 = (function (){var statearr_92480 = state_92429;
(statearr_92480[(16)] = inst_92353);

(statearr_92480[(17)] = inst_92354);

(statearr_92480[(7)] = inst_92356);

(statearr_92480[(18)] = inst_92355);

return statearr_92480;
})();
var statearr_92481_92535 = state_92429__$1;
(statearr_92481_92535[(2)] = null);

(statearr_92481_92535[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (18))){
var inst_92371 = (state_92429[(2)]);
var state_92429__$1 = state_92429;
var statearr_92482_92536 = state_92429__$1;
(statearr_92482_92536[(2)] = inst_92371);

(statearr_92482_92536[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (37))){
var state_92429__$1 = state_92429;
var statearr_92483_92537 = state_92429__$1;
(statearr_92483_92537[(2)] = null);

(statearr_92483_92537[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92430 === (8))){
var inst_92331 = (state_92429[(8)]);
var inst_92349 = cljs.core.apply.call(null,cljs.core.hash_map,inst_92331);
var state_92429__$1 = state_92429;
var statearr_92484_92538 = state_92429__$1;
(statearr_92484_92538[(2)] = inst_92349);

(statearr_92484_92538[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41974__auto___92492,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__41860__auto__,c__41974__auto___92492,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__41861__auto__ = null;
var cljs$core$async$mix_$_state_machine__41861__auto____0 = (function (){
var statearr_92488 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_92488[(0)] = cljs$core$async$mix_$_state_machine__41861__auto__);

(statearr_92488[(1)] = (1));

return statearr_92488;
});
var cljs$core$async$mix_$_state_machine__41861__auto____1 = (function (state_92429){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_92429);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e92489){if((e92489 instanceof Object)){
var ex__41864__auto__ = e92489;
var statearr_92490_92539 = state_92429;
(statearr_92490_92539[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_92429);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e92489;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__92540 = state_92429;
state_92429 = G__92540;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__41861__auto__ = function(state_92429){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__41861__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__41861__auto____1.call(this,state_92429);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__41861__auto____0;
cljs$core$async$mix_$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__41861__auto____1;
return cljs$core$async$mix_$_state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto___92492,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__41976__auto__ = (function (){var statearr_92491 = f__41975__auto__.call(null);
(statearr_92491[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto___92492);

return statearr_92491;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto___92492,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__27993__auto__ = (((p == null))?null:p);
var m__27994__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__27994__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__27993__auto__ = (((p == null))?null:p);
var m__27994__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,p,v,ch);
} else {
var m__27994__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args92541 = [];
var len__28496__auto___92544 = arguments.length;
var i__28497__auto___92545 = (0);
while(true){
if((i__28497__auto___92545 < len__28496__auto___92544)){
args92541.push((arguments[i__28497__auto___92545]));

var G__92546 = (i__28497__auto___92545 + (1));
i__28497__auto___92545 = G__92546;
continue;
} else {
}
break;
}

var G__92543 = args92541.length;
switch (G__92543) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args92541.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__27993__auto__ = (((p == null))?null:p);
var m__27994__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,p);
} else {
var m__27994__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__27993__auto__ = (((p == null))?null:p);
var m__27994__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__27993__auto__)]);
if(!((m__27994__auto__ == null))){
return m__27994__auto__.call(null,p,v);
} else {
var m__27994__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__27994__auto____$1 == null))){
return m__27994__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args92549 = [];
var len__28496__auto___92674 = arguments.length;
var i__28497__auto___92675 = (0);
while(true){
if((i__28497__auto___92675 < len__28496__auto___92674)){
args92549.push((arguments[i__28497__auto___92675]));

var G__92676 = (i__28497__auto___92675 + (1));
i__28497__auto___92675 = G__92676;
continue;
} else {
}
break;
}

var G__92551 = args92549.length;
switch (G__92551) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args92549.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__27280__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__27280__auto__)){
return or__27280__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__27280__auto__,mults){
return (function (p1__92548_SHARP_){
if(cljs.core.truth_(p1__92548_SHARP_.call(null,topic))){
return p1__92548_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__92548_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__27280__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async92552 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async92552 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta92553){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta92553 = meta92553;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async92552.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_92554,meta92553__$1){
var self__ = this;
var _92554__$1 = this;
return (new cljs.core.async.t_cljs$core$async92552(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta92553__$1));
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async92552.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_92554){
var self__ = this;
var _92554__$1 = this;
return self__.meta92553;
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async92552.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async92552.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async92552.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async92552.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async92552.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__6753__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__6753__auto__)){
var m = temp__6753__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async92552.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;


cljs.core.async.t_cljs$core$async92552.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async92552.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta92553","meta92553",-111060278,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async92552.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async92552.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async92552";

cljs.core.async.t_cljs$core$async92552.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async92552");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async92552 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async92552(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta92553){
return (new cljs.core.async.t_cljs$core$async92552(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta92553));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async92552(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__41974__auto___92678 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto___92678,mults,ensure_mult,p){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto___92678,mults,ensure_mult,p){
return (function (state_92626){
var state_val_92627 = (state_92626[(1)]);
if((state_val_92627 === (7))){
var inst_92622 = (state_92626[(2)]);
var state_92626__$1 = state_92626;
var statearr_92628_92679 = state_92626__$1;
(statearr_92628_92679[(2)] = inst_92622);

(statearr_92628_92679[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (20))){
var state_92626__$1 = state_92626;
var statearr_92629_92680 = state_92626__$1;
(statearr_92629_92680[(2)] = null);

(statearr_92629_92680[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (1))){
var state_92626__$1 = state_92626;
var statearr_92630_92681 = state_92626__$1;
(statearr_92630_92681[(2)] = null);

(statearr_92630_92681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (24))){
var inst_92605 = (state_92626[(7)]);
var inst_92614 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_92605);
var state_92626__$1 = state_92626;
var statearr_92631_92682 = state_92626__$1;
(statearr_92631_92682[(2)] = inst_92614);

(statearr_92631_92682[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (4))){
var inst_92557 = (state_92626[(8)]);
var inst_92557__$1 = (state_92626[(2)]);
var inst_92558 = (inst_92557__$1 == null);
var state_92626__$1 = (function (){var statearr_92632 = state_92626;
(statearr_92632[(8)] = inst_92557__$1);

return statearr_92632;
})();
if(cljs.core.truth_(inst_92558)){
var statearr_92633_92683 = state_92626__$1;
(statearr_92633_92683[(1)] = (5));

} else {
var statearr_92634_92684 = state_92626__$1;
(statearr_92634_92684[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (15))){
var inst_92599 = (state_92626[(2)]);
var state_92626__$1 = state_92626;
var statearr_92635_92685 = state_92626__$1;
(statearr_92635_92685[(2)] = inst_92599);

(statearr_92635_92685[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (21))){
var inst_92619 = (state_92626[(2)]);
var state_92626__$1 = (function (){var statearr_92636 = state_92626;
(statearr_92636[(9)] = inst_92619);

return statearr_92636;
})();
var statearr_92637_92686 = state_92626__$1;
(statearr_92637_92686[(2)] = null);

(statearr_92637_92686[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (13))){
var inst_92581 = (state_92626[(10)]);
var inst_92583 = cljs.core.chunked_seq_QMARK_.call(null,inst_92581);
var state_92626__$1 = state_92626;
if(inst_92583){
var statearr_92638_92687 = state_92626__$1;
(statearr_92638_92687[(1)] = (16));

} else {
var statearr_92639_92688 = state_92626__$1;
(statearr_92639_92688[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (22))){
var inst_92611 = (state_92626[(2)]);
var state_92626__$1 = state_92626;
if(cljs.core.truth_(inst_92611)){
var statearr_92640_92689 = state_92626__$1;
(statearr_92640_92689[(1)] = (23));

} else {
var statearr_92641_92690 = state_92626__$1;
(statearr_92641_92690[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (6))){
var inst_92607 = (state_92626[(11)]);
var inst_92557 = (state_92626[(8)]);
var inst_92605 = (state_92626[(7)]);
var inst_92605__$1 = topic_fn.call(null,inst_92557);
var inst_92606 = cljs.core.deref.call(null,mults);
var inst_92607__$1 = cljs.core.get.call(null,inst_92606,inst_92605__$1);
var state_92626__$1 = (function (){var statearr_92642 = state_92626;
(statearr_92642[(11)] = inst_92607__$1);

(statearr_92642[(7)] = inst_92605__$1);

return statearr_92642;
})();
if(cljs.core.truth_(inst_92607__$1)){
var statearr_92643_92691 = state_92626__$1;
(statearr_92643_92691[(1)] = (19));

} else {
var statearr_92644_92692 = state_92626__$1;
(statearr_92644_92692[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (25))){
var inst_92616 = (state_92626[(2)]);
var state_92626__$1 = state_92626;
var statearr_92645_92693 = state_92626__$1;
(statearr_92645_92693[(2)] = inst_92616);

(statearr_92645_92693[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (17))){
var inst_92581 = (state_92626[(10)]);
var inst_92590 = cljs.core.first.call(null,inst_92581);
var inst_92591 = cljs.core.async.muxch_STAR_.call(null,inst_92590);
var inst_92592 = cljs.core.async.close_BANG_.call(null,inst_92591);
var inst_92593 = cljs.core.next.call(null,inst_92581);
var inst_92567 = inst_92593;
var inst_92568 = null;
var inst_92569 = (0);
var inst_92570 = (0);
var state_92626__$1 = (function (){var statearr_92646 = state_92626;
(statearr_92646[(12)] = inst_92568);

(statearr_92646[(13)] = inst_92569);

(statearr_92646[(14)] = inst_92592);

(statearr_92646[(15)] = inst_92567);

(statearr_92646[(16)] = inst_92570);

return statearr_92646;
})();
var statearr_92647_92694 = state_92626__$1;
(statearr_92647_92694[(2)] = null);

(statearr_92647_92694[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (3))){
var inst_92624 = (state_92626[(2)]);
var state_92626__$1 = state_92626;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_92626__$1,inst_92624);
} else {
if((state_val_92627 === (12))){
var inst_92601 = (state_92626[(2)]);
var state_92626__$1 = state_92626;
var statearr_92648_92695 = state_92626__$1;
(statearr_92648_92695[(2)] = inst_92601);

(statearr_92648_92695[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (2))){
var state_92626__$1 = state_92626;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_92626__$1,(4),ch);
} else {
if((state_val_92627 === (23))){
var state_92626__$1 = state_92626;
var statearr_92649_92696 = state_92626__$1;
(statearr_92649_92696[(2)] = null);

(statearr_92649_92696[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (19))){
var inst_92607 = (state_92626[(11)]);
var inst_92557 = (state_92626[(8)]);
var inst_92609 = cljs.core.async.muxch_STAR_.call(null,inst_92607);
var state_92626__$1 = state_92626;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_92626__$1,(22),inst_92609,inst_92557);
} else {
if((state_val_92627 === (11))){
var inst_92567 = (state_92626[(15)]);
var inst_92581 = (state_92626[(10)]);
var inst_92581__$1 = cljs.core.seq.call(null,inst_92567);
var state_92626__$1 = (function (){var statearr_92650 = state_92626;
(statearr_92650[(10)] = inst_92581__$1);

return statearr_92650;
})();
if(inst_92581__$1){
var statearr_92651_92697 = state_92626__$1;
(statearr_92651_92697[(1)] = (13));

} else {
var statearr_92652_92698 = state_92626__$1;
(statearr_92652_92698[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (9))){
var inst_92603 = (state_92626[(2)]);
var state_92626__$1 = state_92626;
var statearr_92653_92699 = state_92626__$1;
(statearr_92653_92699[(2)] = inst_92603);

(statearr_92653_92699[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (5))){
var inst_92564 = cljs.core.deref.call(null,mults);
var inst_92565 = cljs.core.vals.call(null,inst_92564);
var inst_92566 = cljs.core.seq.call(null,inst_92565);
var inst_92567 = inst_92566;
var inst_92568 = null;
var inst_92569 = (0);
var inst_92570 = (0);
var state_92626__$1 = (function (){var statearr_92654 = state_92626;
(statearr_92654[(12)] = inst_92568);

(statearr_92654[(13)] = inst_92569);

(statearr_92654[(15)] = inst_92567);

(statearr_92654[(16)] = inst_92570);

return statearr_92654;
})();
var statearr_92655_92700 = state_92626__$1;
(statearr_92655_92700[(2)] = null);

(statearr_92655_92700[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (14))){
var state_92626__$1 = state_92626;
var statearr_92659_92701 = state_92626__$1;
(statearr_92659_92701[(2)] = null);

(statearr_92659_92701[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (16))){
var inst_92581 = (state_92626[(10)]);
var inst_92585 = cljs.core.chunk_first.call(null,inst_92581);
var inst_92586 = cljs.core.chunk_rest.call(null,inst_92581);
var inst_92587 = cljs.core.count.call(null,inst_92585);
var inst_92567 = inst_92586;
var inst_92568 = inst_92585;
var inst_92569 = inst_92587;
var inst_92570 = (0);
var state_92626__$1 = (function (){var statearr_92660 = state_92626;
(statearr_92660[(12)] = inst_92568);

(statearr_92660[(13)] = inst_92569);

(statearr_92660[(15)] = inst_92567);

(statearr_92660[(16)] = inst_92570);

return statearr_92660;
})();
var statearr_92661_92702 = state_92626__$1;
(statearr_92661_92702[(2)] = null);

(statearr_92661_92702[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (10))){
var inst_92568 = (state_92626[(12)]);
var inst_92569 = (state_92626[(13)]);
var inst_92567 = (state_92626[(15)]);
var inst_92570 = (state_92626[(16)]);
var inst_92575 = cljs.core._nth.call(null,inst_92568,inst_92570);
var inst_92576 = cljs.core.async.muxch_STAR_.call(null,inst_92575);
var inst_92577 = cljs.core.async.close_BANG_.call(null,inst_92576);
var inst_92578 = (inst_92570 + (1));
var tmp92656 = inst_92568;
var tmp92657 = inst_92569;
var tmp92658 = inst_92567;
var inst_92567__$1 = tmp92658;
var inst_92568__$1 = tmp92656;
var inst_92569__$1 = tmp92657;
var inst_92570__$1 = inst_92578;
var state_92626__$1 = (function (){var statearr_92662 = state_92626;
(statearr_92662[(12)] = inst_92568__$1);

(statearr_92662[(13)] = inst_92569__$1);

(statearr_92662[(15)] = inst_92567__$1);

(statearr_92662[(16)] = inst_92570__$1);

(statearr_92662[(17)] = inst_92577);

return statearr_92662;
})();
var statearr_92663_92703 = state_92626__$1;
(statearr_92663_92703[(2)] = null);

(statearr_92663_92703[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (18))){
var inst_92596 = (state_92626[(2)]);
var state_92626__$1 = state_92626;
var statearr_92664_92704 = state_92626__$1;
(statearr_92664_92704[(2)] = inst_92596);

(statearr_92664_92704[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92627 === (8))){
var inst_92569 = (state_92626[(13)]);
var inst_92570 = (state_92626[(16)]);
var inst_92572 = (inst_92570 < inst_92569);
var inst_92573 = inst_92572;
var state_92626__$1 = state_92626;
if(cljs.core.truth_(inst_92573)){
var statearr_92665_92705 = state_92626__$1;
(statearr_92665_92705[(1)] = (10));

} else {
var statearr_92666_92706 = state_92626__$1;
(statearr_92666_92706[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41974__auto___92678,mults,ensure_mult,p))
;
return ((function (switch__41860__auto__,c__41974__auto___92678,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__41861__auto__ = null;
var cljs$core$async$state_machine__41861__auto____0 = (function (){
var statearr_92670 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_92670[(0)] = cljs$core$async$state_machine__41861__auto__);

(statearr_92670[(1)] = (1));

return statearr_92670;
});
var cljs$core$async$state_machine__41861__auto____1 = (function (state_92626){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_92626);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e92671){if((e92671 instanceof Object)){
var ex__41864__auto__ = e92671;
var statearr_92672_92707 = state_92626;
(statearr_92672_92707[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_92626);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e92671;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__92708 = state_92626;
state_92626 = G__92708;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
cljs$core$async$state_machine__41861__auto__ = function(state_92626){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41861__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41861__auto____1.call(this,state_92626);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41861__auto____0;
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41861__auto____1;
return cljs$core$async$state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto___92678,mults,ensure_mult,p))
})();
var state__41976__auto__ = (function (){var statearr_92673 = f__41975__auto__.call(null);
(statearr_92673[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto___92678);

return statearr_92673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto___92678,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args92709 = [];
var len__28496__auto___92712 = arguments.length;
var i__28497__auto___92713 = (0);
while(true){
if((i__28497__auto___92713 < len__28496__auto___92712)){
args92709.push((arguments[i__28497__auto___92713]));

var G__92714 = (i__28497__auto___92713 + (1));
i__28497__auto___92713 = G__92714;
continue;
} else {
}
break;
}

var G__92711 = args92709.length;
switch (G__92711) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args92709.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args92716 = [];
var len__28496__auto___92719 = arguments.length;
var i__28497__auto___92720 = (0);
while(true){
if((i__28497__auto___92720 < len__28496__auto___92719)){
args92716.push((arguments[i__28497__auto___92720]));

var G__92721 = (i__28497__auto___92720 + (1));
i__28497__auto___92720 = G__92721;
continue;
} else {
}
break;
}

var G__92718 = args92716.length;
switch (G__92718) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args92716.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args92723 = [];
var len__28496__auto___92794 = arguments.length;
var i__28497__auto___92795 = (0);
while(true){
if((i__28497__auto___92795 < len__28496__auto___92794)){
args92723.push((arguments[i__28497__auto___92795]));

var G__92796 = (i__28497__auto___92795 + (1));
i__28497__auto___92795 = G__92796;
continue;
} else {
}
break;
}

var G__92725 = args92723.length;
switch (G__92725) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args92723.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__41974__auto___92798 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto___92798,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto___92798,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_92764){
var state_val_92765 = (state_92764[(1)]);
if((state_val_92765 === (7))){
var state_92764__$1 = state_92764;
var statearr_92766_92799 = state_92764__$1;
(statearr_92766_92799[(2)] = null);

(statearr_92766_92799[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92765 === (1))){
var state_92764__$1 = state_92764;
var statearr_92767_92800 = state_92764__$1;
(statearr_92767_92800[(2)] = null);

(statearr_92767_92800[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92765 === (4))){
var inst_92728 = (state_92764[(7)]);
var inst_92730 = (inst_92728 < cnt);
var state_92764__$1 = state_92764;
if(cljs.core.truth_(inst_92730)){
var statearr_92768_92801 = state_92764__$1;
(statearr_92768_92801[(1)] = (6));

} else {
var statearr_92769_92802 = state_92764__$1;
(statearr_92769_92802[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92765 === (15))){
var inst_92760 = (state_92764[(2)]);
var state_92764__$1 = state_92764;
var statearr_92770_92803 = state_92764__$1;
(statearr_92770_92803[(2)] = inst_92760);

(statearr_92770_92803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92765 === (13))){
var inst_92753 = cljs.core.async.close_BANG_.call(null,out);
var state_92764__$1 = state_92764;
var statearr_92771_92804 = state_92764__$1;
(statearr_92771_92804[(2)] = inst_92753);

(statearr_92771_92804[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92765 === (6))){
var state_92764__$1 = state_92764;
var statearr_92772_92805 = state_92764__$1;
(statearr_92772_92805[(2)] = null);

(statearr_92772_92805[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92765 === (3))){
var inst_92762 = (state_92764[(2)]);
var state_92764__$1 = state_92764;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_92764__$1,inst_92762);
} else {
if((state_val_92765 === (12))){
var inst_92750 = (state_92764[(8)]);
var inst_92750__$1 = (state_92764[(2)]);
var inst_92751 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_92750__$1);
var state_92764__$1 = (function (){var statearr_92773 = state_92764;
(statearr_92773[(8)] = inst_92750__$1);

return statearr_92773;
})();
if(cljs.core.truth_(inst_92751)){
var statearr_92774_92806 = state_92764__$1;
(statearr_92774_92806[(1)] = (13));

} else {
var statearr_92775_92807 = state_92764__$1;
(statearr_92775_92807[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92765 === (2))){
var inst_92727 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_92728 = (0);
var state_92764__$1 = (function (){var statearr_92776 = state_92764;
(statearr_92776[(7)] = inst_92728);

(statearr_92776[(9)] = inst_92727);

return statearr_92776;
})();
var statearr_92777_92808 = state_92764__$1;
(statearr_92777_92808[(2)] = null);

(statearr_92777_92808[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92765 === (11))){
var inst_92728 = (state_92764[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_92764,(10),Object,null,(9));
var inst_92737 = chs__$1.call(null,inst_92728);
var inst_92738 = done.call(null,inst_92728);
var inst_92739 = cljs.core.async.take_BANG_.call(null,inst_92737,inst_92738);
var state_92764__$1 = state_92764;
var statearr_92778_92809 = state_92764__$1;
(statearr_92778_92809[(2)] = inst_92739);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_92764__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92765 === (9))){
var inst_92728 = (state_92764[(7)]);
var inst_92741 = (state_92764[(2)]);
var inst_92742 = (inst_92728 + (1));
var inst_92728__$1 = inst_92742;
var state_92764__$1 = (function (){var statearr_92779 = state_92764;
(statearr_92779[(7)] = inst_92728__$1);

(statearr_92779[(10)] = inst_92741);

return statearr_92779;
})();
var statearr_92780_92810 = state_92764__$1;
(statearr_92780_92810[(2)] = null);

(statearr_92780_92810[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92765 === (5))){
var inst_92748 = (state_92764[(2)]);
var state_92764__$1 = (function (){var statearr_92781 = state_92764;
(statearr_92781[(11)] = inst_92748);

return statearr_92781;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_92764__$1,(12),dchan);
} else {
if((state_val_92765 === (14))){
var inst_92750 = (state_92764[(8)]);
var inst_92755 = cljs.core.apply.call(null,f,inst_92750);
var state_92764__$1 = state_92764;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_92764__$1,(16),out,inst_92755);
} else {
if((state_val_92765 === (16))){
var inst_92757 = (state_92764[(2)]);
var state_92764__$1 = (function (){var statearr_92782 = state_92764;
(statearr_92782[(12)] = inst_92757);

return statearr_92782;
})();
var statearr_92783_92811 = state_92764__$1;
(statearr_92783_92811[(2)] = null);

(statearr_92783_92811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92765 === (10))){
var inst_92732 = (state_92764[(2)]);
var inst_92733 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_92764__$1 = (function (){var statearr_92784 = state_92764;
(statearr_92784[(13)] = inst_92732);

return statearr_92784;
})();
var statearr_92785_92812 = state_92764__$1;
(statearr_92785_92812[(2)] = inst_92733);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_92764__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92765 === (8))){
var inst_92746 = (state_92764[(2)]);
var state_92764__$1 = state_92764;
var statearr_92786_92813 = state_92764__$1;
(statearr_92786_92813[(2)] = inst_92746);

(statearr_92786_92813[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41974__auto___92798,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__41860__auto__,c__41974__auto___92798,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__41861__auto__ = null;
var cljs$core$async$state_machine__41861__auto____0 = (function (){
var statearr_92790 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_92790[(0)] = cljs$core$async$state_machine__41861__auto__);

(statearr_92790[(1)] = (1));

return statearr_92790;
});
var cljs$core$async$state_machine__41861__auto____1 = (function (state_92764){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_92764);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e92791){if((e92791 instanceof Object)){
var ex__41864__auto__ = e92791;
var statearr_92792_92814 = state_92764;
(statearr_92792_92814[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_92764);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e92791;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__92815 = state_92764;
state_92764 = G__92815;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
cljs$core$async$state_machine__41861__auto__ = function(state_92764){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41861__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41861__auto____1.call(this,state_92764);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41861__auto____0;
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41861__auto____1;
return cljs$core$async$state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto___92798,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__41976__auto__ = (function (){var statearr_92793 = f__41975__auto__.call(null);
(statearr_92793[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto___92798);

return statearr_92793;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto___92798,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args92817 = [];
var len__28496__auto___92875 = arguments.length;
var i__28497__auto___92876 = (0);
while(true){
if((i__28497__auto___92876 < len__28496__auto___92875)){
args92817.push((arguments[i__28497__auto___92876]));

var G__92877 = (i__28497__auto___92876 + (1));
i__28497__auto___92876 = G__92877;
continue;
} else {
}
break;
}

var G__92819 = args92817.length;
switch (G__92819) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args92817.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__41974__auto___92879 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto___92879,out){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto___92879,out){
return (function (state_92851){
var state_val_92852 = (state_92851[(1)]);
if((state_val_92852 === (7))){
var inst_92831 = (state_92851[(7)]);
var inst_92830 = (state_92851[(8)]);
var inst_92830__$1 = (state_92851[(2)]);
var inst_92831__$1 = cljs.core.nth.call(null,inst_92830__$1,(0),null);
var inst_92832 = cljs.core.nth.call(null,inst_92830__$1,(1),null);
var inst_92833 = (inst_92831__$1 == null);
var state_92851__$1 = (function (){var statearr_92853 = state_92851;
(statearr_92853[(9)] = inst_92832);

(statearr_92853[(7)] = inst_92831__$1);

(statearr_92853[(8)] = inst_92830__$1);

return statearr_92853;
})();
if(cljs.core.truth_(inst_92833)){
var statearr_92854_92880 = state_92851__$1;
(statearr_92854_92880[(1)] = (8));

} else {
var statearr_92855_92881 = state_92851__$1;
(statearr_92855_92881[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92852 === (1))){
var inst_92820 = cljs.core.vec.call(null,chs);
var inst_92821 = inst_92820;
var state_92851__$1 = (function (){var statearr_92856 = state_92851;
(statearr_92856[(10)] = inst_92821);

return statearr_92856;
})();
var statearr_92857_92882 = state_92851__$1;
(statearr_92857_92882[(2)] = null);

(statearr_92857_92882[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92852 === (4))){
var inst_92821 = (state_92851[(10)]);
var state_92851__$1 = state_92851;
return cljs.core.async.ioc_alts_BANG_.call(null,state_92851__$1,(7),inst_92821);
} else {
if((state_val_92852 === (6))){
var inst_92847 = (state_92851[(2)]);
var state_92851__$1 = state_92851;
var statearr_92858_92883 = state_92851__$1;
(statearr_92858_92883[(2)] = inst_92847);

(statearr_92858_92883[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92852 === (3))){
var inst_92849 = (state_92851[(2)]);
var state_92851__$1 = state_92851;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_92851__$1,inst_92849);
} else {
if((state_val_92852 === (2))){
var inst_92821 = (state_92851[(10)]);
var inst_92823 = cljs.core.count.call(null,inst_92821);
var inst_92824 = (inst_92823 > (0));
var state_92851__$1 = state_92851;
if(cljs.core.truth_(inst_92824)){
var statearr_92860_92884 = state_92851__$1;
(statearr_92860_92884[(1)] = (4));

} else {
var statearr_92861_92885 = state_92851__$1;
(statearr_92861_92885[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92852 === (11))){
var inst_92821 = (state_92851[(10)]);
var inst_92840 = (state_92851[(2)]);
var tmp92859 = inst_92821;
var inst_92821__$1 = tmp92859;
var state_92851__$1 = (function (){var statearr_92862 = state_92851;
(statearr_92862[(11)] = inst_92840);

(statearr_92862[(10)] = inst_92821__$1);

return statearr_92862;
})();
var statearr_92863_92886 = state_92851__$1;
(statearr_92863_92886[(2)] = null);

(statearr_92863_92886[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92852 === (9))){
var inst_92831 = (state_92851[(7)]);
var state_92851__$1 = state_92851;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_92851__$1,(11),out,inst_92831);
} else {
if((state_val_92852 === (5))){
var inst_92845 = cljs.core.async.close_BANG_.call(null,out);
var state_92851__$1 = state_92851;
var statearr_92864_92887 = state_92851__$1;
(statearr_92864_92887[(2)] = inst_92845);

(statearr_92864_92887[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92852 === (10))){
var inst_92843 = (state_92851[(2)]);
var state_92851__$1 = state_92851;
var statearr_92865_92888 = state_92851__$1;
(statearr_92865_92888[(2)] = inst_92843);

(statearr_92865_92888[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92852 === (8))){
var inst_92832 = (state_92851[(9)]);
var inst_92831 = (state_92851[(7)]);
var inst_92830 = (state_92851[(8)]);
var inst_92821 = (state_92851[(10)]);
var inst_92835 = (function (){var cs = inst_92821;
var vec__92826 = inst_92830;
var v = inst_92831;
var c = inst_92832;
return ((function (cs,vec__92826,v,c,inst_92832,inst_92831,inst_92830,inst_92821,state_val_92852,c__41974__auto___92879,out){
return (function (p1__92816_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__92816_SHARP_);
});
;})(cs,vec__92826,v,c,inst_92832,inst_92831,inst_92830,inst_92821,state_val_92852,c__41974__auto___92879,out))
})();
var inst_92836 = cljs.core.filterv.call(null,inst_92835,inst_92821);
var inst_92821__$1 = inst_92836;
var state_92851__$1 = (function (){var statearr_92866 = state_92851;
(statearr_92866[(10)] = inst_92821__$1);

return statearr_92866;
})();
var statearr_92867_92889 = state_92851__$1;
(statearr_92867_92889[(2)] = null);

(statearr_92867_92889[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__41974__auto___92879,out))
;
return ((function (switch__41860__auto__,c__41974__auto___92879,out){
return (function() {
var cljs$core$async$state_machine__41861__auto__ = null;
var cljs$core$async$state_machine__41861__auto____0 = (function (){
var statearr_92871 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_92871[(0)] = cljs$core$async$state_machine__41861__auto__);

(statearr_92871[(1)] = (1));

return statearr_92871;
});
var cljs$core$async$state_machine__41861__auto____1 = (function (state_92851){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_92851);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e92872){if((e92872 instanceof Object)){
var ex__41864__auto__ = e92872;
var statearr_92873_92890 = state_92851;
(statearr_92873_92890[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_92851);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e92872;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__92891 = state_92851;
state_92851 = G__92891;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
cljs$core$async$state_machine__41861__auto__ = function(state_92851){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41861__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41861__auto____1.call(this,state_92851);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41861__auto____0;
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41861__auto____1;
return cljs$core$async$state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto___92879,out))
})();
var state__41976__auto__ = (function (){var statearr_92874 = f__41975__auto__.call(null);
(statearr_92874[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto___92879);

return statearr_92874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto___92879,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args92892 = [];
var len__28496__auto___92941 = arguments.length;
var i__28497__auto___92942 = (0);
while(true){
if((i__28497__auto___92942 < len__28496__auto___92941)){
args92892.push((arguments[i__28497__auto___92942]));

var G__92943 = (i__28497__auto___92942 + (1));
i__28497__auto___92942 = G__92943;
continue;
} else {
}
break;
}

var G__92894 = args92892.length;
switch (G__92894) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args92892.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__41974__auto___92945 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto___92945,out){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto___92945,out){
return (function (state_92918){
var state_val_92919 = (state_92918[(1)]);
if((state_val_92919 === (7))){
var inst_92900 = (state_92918[(7)]);
var inst_92900__$1 = (state_92918[(2)]);
var inst_92901 = (inst_92900__$1 == null);
var inst_92902 = cljs.core.not.call(null,inst_92901);
var state_92918__$1 = (function (){var statearr_92920 = state_92918;
(statearr_92920[(7)] = inst_92900__$1);

return statearr_92920;
})();
if(inst_92902){
var statearr_92921_92946 = state_92918__$1;
(statearr_92921_92946[(1)] = (8));

} else {
var statearr_92922_92947 = state_92918__$1;
(statearr_92922_92947[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92919 === (1))){
var inst_92895 = (0);
var state_92918__$1 = (function (){var statearr_92923 = state_92918;
(statearr_92923[(8)] = inst_92895);

return statearr_92923;
})();
var statearr_92924_92948 = state_92918__$1;
(statearr_92924_92948[(2)] = null);

(statearr_92924_92948[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92919 === (4))){
var state_92918__$1 = state_92918;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_92918__$1,(7),ch);
} else {
if((state_val_92919 === (6))){
var inst_92913 = (state_92918[(2)]);
var state_92918__$1 = state_92918;
var statearr_92925_92949 = state_92918__$1;
(statearr_92925_92949[(2)] = inst_92913);

(statearr_92925_92949[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92919 === (3))){
var inst_92915 = (state_92918[(2)]);
var inst_92916 = cljs.core.async.close_BANG_.call(null,out);
var state_92918__$1 = (function (){var statearr_92926 = state_92918;
(statearr_92926[(9)] = inst_92915);

return statearr_92926;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_92918__$1,inst_92916);
} else {
if((state_val_92919 === (2))){
var inst_92895 = (state_92918[(8)]);
var inst_92897 = (inst_92895 < n);
var state_92918__$1 = state_92918;
if(cljs.core.truth_(inst_92897)){
var statearr_92927_92950 = state_92918__$1;
(statearr_92927_92950[(1)] = (4));

} else {
var statearr_92928_92951 = state_92918__$1;
(statearr_92928_92951[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92919 === (11))){
var inst_92895 = (state_92918[(8)]);
var inst_92905 = (state_92918[(2)]);
var inst_92906 = (inst_92895 + (1));
var inst_92895__$1 = inst_92906;
var state_92918__$1 = (function (){var statearr_92929 = state_92918;
(statearr_92929[(8)] = inst_92895__$1);

(statearr_92929[(10)] = inst_92905);

return statearr_92929;
})();
var statearr_92930_92952 = state_92918__$1;
(statearr_92930_92952[(2)] = null);

(statearr_92930_92952[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92919 === (9))){
var state_92918__$1 = state_92918;
var statearr_92931_92953 = state_92918__$1;
(statearr_92931_92953[(2)] = null);

(statearr_92931_92953[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92919 === (5))){
var state_92918__$1 = state_92918;
var statearr_92932_92954 = state_92918__$1;
(statearr_92932_92954[(2)] = null);

(statearr_92932_92954[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92919 === (10))){
var inst_92910 = (state_92918[(2)]);
var state_92918__$1 = state_92918;
var statearr_92933_92955 = state_92918__$1;
(statearr_92933_92955[(2)] = inst_92910);

(statearr_92933_92955[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_92919 === (8))){
var inst_92900 = (state_92918[(7)]);
var state_92918__$1 = state_92918;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_92918__$1,(11),out,inst_92900);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__41974__auto___92945,out))
;
return ((function (switch__41860__auto__,c__41974__auto___92945,out){
return (function() {
var cljs$core$async$state_machine__41861__auto__ = null;
var cljs$core$async$state_machine__41861__auto____0 = (function (){
var statearr_92937 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_92937[(0)] = cljs$core$async$state_machine__41861__auto__);

(statearr_92937[(1)] = (1));

return statearr_92937;
});
var cljs$core$async$state_machine__41861__auto____1 = (function (state_92918){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_92918);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e92938){if((e92938 instanceof Object)){
var ex__41864__auto__ = e92938;
var statearr_92939_92956 = state_92918;
(statearr_92939_92956[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_92918);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e92938;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__92957 = state_92918;
state_92918 = G__92957;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
cljs$core$async$state_machine__41861__auto__ = function(state_92918){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41861__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41861__auto____1.call(this,state_92918);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41861__auto____0;
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41861__auto____1;
return cljs$core$async$state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto___92945,out))
})();
var state__41976__auto__ = (function (){var statearr_92940 = f__41975__auto__.call(null);
(statearr_92940[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto___92945);

return statearr_92940;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto___92945,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async92965 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async92965 = (function (f,ch,meta92966){
this.f = f;
this.ch = ch;
this.meta92966 = meta92966;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async92965.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_92967,meta92966__$1){
var self__ = this;
var _92967__$1 = this;
return (new cljs.core.async.t_cljs$core$async92965(self__.f,self__.ch,meta92966__$1));
});


cljs.core.async.t_cljs$core$async92965.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_92967){
var self__ = this;
var _92967__$1 = this;
return self__.meta92966;
});


cljs.core.async.t_cljs$core$async92965.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async92965.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async92965.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async92965.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async92965.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async92968 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async92968 = (function (f,ch,meta92966,_,fn1,meta92969){
this.f = f;
this.ch = ch;
this.meta92966 = meta92966;
this._ = _;
this.fn1 = fn1;
this.meta92969 = meta92969;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async92968.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_92970,meta92969__$1){
var self__ = this;
var _92970__$1 = this;
return (new cljs.core.async.t_cljs$core$async92968(self__.f,self__.ch,self__.meta92966,self__._,self__.fn1,meta92969__$1));
});})(___$1))
;


cljs.core.async.t_cljs$core$async92968.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_92970){
var self__ = this;
var _92970__$1 = this;
return self__.meta92969;
});})(___$1))
;


cljs.core.async.t_cljs$core$async92968.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async92968.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;


cljs.core.async.t_cljs$core$async92968.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;


cljs.core.async.t_cljs$core$async92968.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__92958_SHARP_){
return f1.call(null,(((p1__92958_SHARP_ == null))?null:self__.f.call(null,p1__92958_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async92968.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta92966","meta92966",-1196847926,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async92965","cljs.core.async/t_cljs$core$async92965",-1473806435,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta92969","meta92969",296338016,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async92968.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async92968.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async92968";

cljs.core.async.t_cljs$core$async92968.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async92968");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async92968 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async92968(f__$1,ch__$1,meta92966__$1,___$2,fn1__$1,meta92969){
return (new cljs.core.async.t_cljs$core$async92968(f__$1,ch__$1,meta92966__$1,___$2,fn1__$1,meta92969));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async92968(self__.f,self__.ch,self__.meta92966,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__27268__auto__ = ret;
if(cljs.core.truth_(and__27268__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__27268__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});


cljs.core.async.t_cljs$core$async92965.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async92965.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async92965.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta92966","meta92966",-1196847926,null)], null);
});

cljs.core.async.t_cljs$core$async92965.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async92965.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async92965";

cljs.core.async.t_cljs$core$async92965.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async92965");
});

cljs.core.async.__GT_t_cljs$core$async92965 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async92965(f__$1,ch__$1,meta92966){
return (new cljs.core.async.t_cljs$core$async92965(f__$1,ch__$1,meta92966));
});

}

return (new cljs.core.async.t_cljs$core$async92965(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async92974 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async92974 = (function (f,ch,meta92975){
this.f = f;
this.ch = ch;
this.meta92975 = meta92975;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async92974.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_92976,meta92975__$1){
var self__ = this;
var _92976__$1 = this;
return (new cljs.core.async.t_cljs$core$async92974(self__.f,self__.ch,meta92975__$1));
});


cljs.core.async.t_cljs$core$async92974.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_92976){
var self__ = this;
var _92976__$1 = this;
return self__.meta92975;
});


cljs.core.async.t_cljs$core$async92974.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async92974.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async92974.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async92974.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});


cljs.core.async.t_cljs$core$async92974.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async92974.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async92974.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta92975","meta92975",-1502805186,null)], null);
});

cljs.core.async.t_cljs$core$async92974.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async92974.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async92974";

cljs.core.async.t_cljs$core$async92974.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async92974");
});

cljs.core.async.__GT_t_cljs$core$async92974 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async92974(f__$1,ch__$1,meta92975){
return (new cljs.core.async.t_cljs$core$async92974(f__$1,ch__$1,meta92975));
});

}

return (new cljs.core.async.t_cljs$core$async92974(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async92980 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async92980 = (function (p,ch,meta92981){
this.p = p;
this.ch = ch;
this.meta92981 = meta92981;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})

cljs.core.async.t_cljs$core$async92980.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_92982,meta92981__$1){
var self__ = this;
var _92982__$1 = this;
return (new cljs.core.async.t_cljs$core$async92980(self__.p,self__.ch,meta92981__$1));
});


cljs.core.async.t_cljs$core$async92980.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_92982){
var self__ = this;
var _92982__$1 = this;
return self__.meta92981;
});


cljs.core.async.t_cljs$core$async92980.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async92980.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async92980.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});


cljs.core.async.t_cljs$core$async92980.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async92980.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});


cljs.core.async.t_cljs$core$async92980.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;


cljs.core.async.t_cljs$core$async92980.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async92980.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta92981","meta92981",52935713,null)], null);
});

cljs.core.async.t_cljs$core$async92980.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async92980.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async92980";

cljs.core.async.t_cljs$core$async92980.cljs$lang$ctorPrWriter = (function (this__27932__auto__,writer__27933__auto__,opt__27934__auto__){
return cljs.core._write.call(null,writer__27933__auto__,"cljs.core.async/t_cljs$core$async92980");
});

cljs.core.async.__GT_t_cljs$core$async92980 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async92980(p__$1,ch__$1,meta92981){
return (new cljs.core.async.t_cljs$core$async92980(p__$1,ch__$1,meta92981));
});

}

return (new cljs.core.async.t_cljs$core$async92980(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args92983 = [];
var len__28496__auto___93027 = arguments.length;
var i__28497__auto___93028 = (0);
while(true){
if((i__28497__auto___93028 < len__28496__auto___93027)){
args92983.push((arguments[i__28497__auto___93028]));

var G__93029 = (i__28497__auto___93028 + (1));
i__28497__auto___93028 = G__93029;
continue;
} else {
}
break;
}

var G__92985 = args92983.length;
switch (G__92985) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args92983.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__41974__auto___93031 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto___93031,out){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto___93031,out){
return (function (state_93006){
var state_val_93007 = (state_93006[(1)]);
if((state_val_93007 === (7))){
var inst_93002 = (state_93006[(2)]);
var state_93006__$1 = state_93006;
var statearr_93008_93032 = state_93006__$1;
(statearr_93008_93032[(2)] = inst_93002);

(statearr_93008_93032[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93007 === (1))){
var state_93006__$1 = state_93006;
var statearr_93009_93033 = state_93006__$1;
(statearr_93009_93033[(2)] = null);

(statearr_93009_93033[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93007 === (4))){
var inst_92988 = (state_93006[(7)]);
var inst_92988__$1 = (state_93006[(2)]);
var inst_92989 = (inst_92988__$1 == null);
var state_93006__$1 = (function (){var statearr_93010 = state_93006;
(statearr_93010[(7)] = inst_92988__$1);

return statearr_93010;
})();
if(cljs.core.truth_(inst_92989)){
var statearr_93011_93034 = state_93006__$1;
(statearr_93011_93034[(1)] = (5));

} else {
var statearr_93012_93035 = state_93006__$1;
(statearr_93012_93035[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93007 === (6))){
var inst_92988 = (state_93006[(7)]);
var inst_92993 = p.call(null,inst_92988);
var state_93006__$1 = state_93006;
if(cljs.core.truth_(inst_92993)){
var statearr_93013_93036 = state_93006__$1;
(statearr_93013_93036[(1)] = (8));

} else {
var statearr_93014_93037 = state_93006__$1;
(statearr_93014_93037[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93007 === (3))){
var inst_93004 = (state_93006[(2)]);
var state_93006__$1 = state_93006;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_93006__$1,inst_93004);
} else {
if((state_val_93007 === (2))){
var state_93006__$1 = state_93006;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_93006__$1,(4),ch);
} else {
if((state_val_93007 === (11))){
var inst_92996 = (state_93006[(2)]);
var state_93006__$1 = state_93006;
var statearr_93015_93038 = state_93006__$1;
(statearr_93015_93038[(2)] = inst_92996);

(statearr_93015_93038[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93007 === (9))){
var state_93006__$1 = state_93006;
var statearr_93016_93039 = state_93006__$1;
(statearr_93016_93039[(2)] = null);

(statearr_93016_93039[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93007 === (5))){
var inst_92991 = cljs.core.async.close_BANG_.call(null,out);
var state_93006__$1 = state_93006;
var statearr_93017_93040 = state_93006__$1;
(statearr_93017_93040[(2)] = inst_92991);

(statearr_93017_93040[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93007 === (10))){
var inst_92999 = (state_93006[(2)]);
var state_93006__$1 = (function (){var statearr_93018 = state_93006;
(statearr_93018[(8)] = inst_92999);

return statearr_93018;
})();
var statearr_93019_93041 = state_93006__$1;
(statearr_93019_93041[(2)] = null);

(statearr_93019_93041[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93007 === (8))){
var inst_92988 = (state_93006[(7)]);
var state_93006__$1 = state_93006;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_93006__$1,(11),out,inst_92988);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__41974__auto___93031,out))
;
return ((function (switch__41860__auto__,c__41974__auto___93031,out){
return (function() {
var cljs$core$async$state_machine__41861__auto__ = null;
var cljs$core$async$state_machine__41861__auto____0 = (function (){
var statearr_93023 = [null,null,null,null,null,null,null,null,null];
(statearr_93023[(0)] = cljs$core$async$state_machine__41861__auto__);

(statearr_93023[(1)] = (1));

return statearr_93023;
});
var cljs$core$async$state_machine__41861__auto____1 = (function (state_93006){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_93006);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e93024){if((e93024 instanceof Object)){
var ex__41864__auto__ = e93024;
var statearr_93025_93042 = state_93006;
(statearr_93025_93042[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_93006);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e93024;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__93043 = state_93006;
state_93006 = G__93043;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
cljs$core$async$state_machine__41861__auto__ = function(state_93006){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41861__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41861__auto____1.call(this,state_93006);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41861__auto____0;
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41861__auto____1;
return cljs$core$async$state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto___93031,out))
})();
var state__41976__auto__ = (function (){var statearr_93026 = f__41975__auto__.call(null);
(statearr_93026[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto___93031);

return statearr_93026;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto___93031,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args93044 = [];
var len__28496__auto___93047 = arguments.length;
var i__28497__auto___93048 = (0);
while(true){
if((i__28497__auto___93048 < len__28496__auto___93047)){
args93044.push((arguments[i__28497__auto___93048]));

var G__93049 = (i__28497__auto___93048 + (1));
i__28497__auto___93048 = G__93049;
continue;
} else {
}
break;
}

var G__93046 = args93044.length;
switch (G__93046) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args93044.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__41974__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto__){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto__){
return (function (state_93216){
var state_val_93217 = (state_93216[(1)]);
if((state_val_93217 === (7))){
var inst_93212 = (state_93216[(2)]);
var state_93216__$1 = state_93216;
var statearr_93218_93259 = state_93216__$1;
(statearr_93218_93259[(2)] = inst_93212);

(statearr_93218_93259[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93217 === (20))){
var inst_93182 = (state_93216[(7)]);
var inst_93193 = (state_93216[(2)]);
var inst_93194 = cljs.core.next.call(null,inst_93182);
var inst_93168 = inst_93194;
var inst_93169 = null;
var inst_93170 = (0);
var inst_93171 = (0);
var state_93216__$1 = (function (){var statearr_93219 = state_93216;
(statearr_93219[(8)] = inst_93168);

(statearr_93219[(9)] = inst_93193);

(statearr_93219[(10)] = inst_93169);

(statearr_93219[(11)] = inst_93171);

(statearr_93219[(12)] = inst_93170);

return statearr_93219;
})();
var statearr_93220_93260 = state_93216__$1;
(statearr_93220_93260[(2)] = null);

(statearr_93220_93260[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93217 === (1))){
var state_93216__$1 = state_93216;
var statearr_93221_93261 = state_93216__$1;
(statearr_93221_93261[(2)] = null);

(statearr_93221_93261[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93217 === (4))){
var inst_93157 = (state_93216[(13)]);
var inst_93157__$1 = (state_93216[(2)]);
var inst_93158 = (inst_93157__$1 == null);
var state_93216__$1 = (function (){var statearr_93222 = state_93216;
(statearr_93222[(13)] = inst_93157__$1);

return statearr_93222;
})();
if(cljs.core.truth_(inst_93158)){
var statearr_93223_93262 = state_93216__$1;
(statearr_93223_93262[(1)] = (5));

} else {
var statearr_93224_93263 = state_93216__$1;
(statearr_93224_93263[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93217 === (15))){
var state_93216__$1 = state_93216;
var statearr_93228_93264 = state_93216__$1;
(statearr_93228_93264[(2)] = null);

(statearr_93228_93264[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93217 === (21))){
var state_93216__$1 = state_93216;
var statearr_93229_93265 = state_93216__$1;
(statearr_93229_93265[(2)] = null);

(statearr_93229_93265[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93217 === (13))){
var inst_93168 = (state_93216[(8)]);
var inst_93169 = (state_93216[(10)]);
var inst_93171 = (state_93216[(11)]);
var inst_93170 = (state_93216[(12)]);
var inst_93178 = (state_93216[(2)]);
var inst_93179 = (inst_93171 + (1));
var tmp93225 = inst_93168;
var tmp93226 = inst_93169;
var tmp93227 = inst_93170;
var inst_93168__$1 = tmp93225;
var inst_93169__$1 = tmp93226;
var inst_93170__$1 = tmp93227;
var inst_93171__$1 = inst_93179;
var state_93216__$1 = (function (){var statearr_93230 = state_93216;
(statearr_93230[(14)] = inst_93178);

(statearr_93230[(8)] = inst_93168__$1);

(statearr_93230[(10)] = inst_93169__$1);

(statearr_93230[(11)] = inst_93171__$1);

(statearr_93230[(12)] = inst_93170__$1);

return statearr_93230;
})();
var statearr_93231_93266 = state_93216__$1;
(statearr_93231_93266[(2)] = null);

(statearr_93231_93266[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93217 === (22))){
var state_93216__$1 = state_93216;
var statearr_93232_93267 = state_93216__$1;
(statearr_93232_93267[(2)] = null);

(statearr_93232_93267[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93217 === (6))){
var inst_93157 = (state_93216[(13)]);
var inst_93166 = f.call(null,inst_93157);
var inst_93167 = cljs.core.seq.call(null,inst_93166);
var inst_93168 = inst_93167;
var inst_93169 = null;
var inst_93170 = (0);
var inst_93171 = (0);
var state_93216__$1 = (function (){var statearr_93233 = state_93216;
(statearr_93233[(8)] = inst_93168);

(statearr_93233[(10)] = inst_93169);

(statearr_93233[(11)] = inst_93171);

(statearr_93233[(12)] = inst_93170);

return statearr_93233;
})();
var statearr_93234_93268 = state_93216__$1;
(statearr_93234_93268[(2)] = null);

(statearr_93234_93268[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93217 === (17))){
var inst_93182 = (state_93216[(7)]);
var inst_93186 = cljs.core.chunk_first.call(null,inst_93182);
var inst_93187 = cljs.core.chunk_rest.call(null,inst_93182);
var inst_93188 = cljs.core.count.call(null,inst_93186);
var inst_93168 = inst_93187;
var inst_93169 = inst_93186;
var inst_93170 = inst_93188;
var inst_93171 = (0);
var state_93216__$1 = (function (){var statearr_93235 = state_93216;
(statearr_93235[(8)] = inst_93168);

(statearr_93235[(10)] = inst_93169);

(statearr_93235[(11)] = inst_93171);

(statearr_93235[(12)] = inst_93170);

return statearr_93235;
})();
var statearr_93236_93269 = state_93216__$1;
(statearr_93236_93269[(2)] = null);

(statearr_93236_93269[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93217 === (3))){
var inst_93214 = (state_93216[(2)]);
var state_93216__$1 = state_93216;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_93216__$1,inst_93214);
} else {
if((state_val_93217 === (12))){
var inst_93202 = (state_93216[(2)]);
var state_93216__$1 = state_93216;
var statearr_93237_93270 = state_93216__$1;
(statearr_93237_93270[(2)] = inst_93202);

(statearr_93237_93270[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93217 === (2))){
var state_93216__$1 = state_93216;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_93216__$1,(4),in$);
} else {
if((state_val_93217 === (23))){
var inst_93210 = (state_93216[(2)]);
var state_93216__$1 = state_93216;
var statearr_93238_93271 = state_93216__$1;
(statearr_93238_93271[(2)] = inst_93210);

(statearr_93238_93271[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93217 === (19))){
var inst_93197 = (state_93216[(2)]);
var state_93216__$1 = state_93216;
var statearr_93239_93272 = state_93216__$1;
(statearr_93239_93272[(2)] = inst_93197);

(statearr_93239_93272[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93217 === (11))){
var inst_93182 = (state_93216[(7)]);
var inst_93168 = (state_93216[(8)]);
var inst_93182__$1 = cljs.core.seq.call(null,inst_93168);
var state_93216__$1 = (function (){var statearr_93240 = state_93216;
(statearr_93240[(7)] = inst_93182__$1);

return statearr_93240;
})();
if(inst_93182__$1){
var statearr_93241_93273 = state_93216__$1;
(statearr_93241_93273[(1)] = (14));

} else {
var statearr_93242_93274 = state_93216__$1;
(statearr_93242_93274[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93217 === (9))){
var inst_93204 = (state_93216[(2)]);
var inst_93205 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_93216__$1 = (function (){var statearr_93243 = state_93216;
(statearr_93243[(15)] = inst_93204);

return statearr_93243;
})();
if(cljs.core.truth_(inst_93205)){
var statearr_93244_93275 = state_93216__$1;
(statearr_93244_93275[(1)] = (21));

} else {
var statearr_93245_93276 = state_93216__$1;
(statearr_93245_93276[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93217 === (5))){
var inst_93160 = cljs.core.async.close_BANG_.call(null,out);
var state_93216__$1 = state_93216;
var statearr_93246_93277 = state_93216__$1;
(statearr_93246_93277[(2)] = inst_93160);

(statearr_93246_93277[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93217 === (14))){
var inst_93182 = (state_93216[(7)]);
var inst_93184 = cljs.core.chunked_seq_QMARK_.call(null,inst_93182);
var state_93216__$1 = state_93216;
if(inst_93184){
var statearr_93247_93278 = state_93216__$1;
(statearr_93247_93278[(1)] = (17));

} else {
var statearr_93248_93279 = state_93216__$1;
(statearr_93248_93279[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93217 === (16))){
var inst_93200 = (state_93216[(2)]);
var state_93216__$1 = state_93216;
var statearr_93249_93280 = state_93216__$1;
(statearr_93249_93280[(2)] = inst_93200);

(statearr_93249_93280[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93217 === (10))){
var inst_93169 = (state_93216[(10)]);
var inst_93171 = (state_93216[(11)]);
var inst_93176 = cljs.core._nth.call(null,inst_93169,inst_93171);
var state_93216__$1 = state_93216;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_93216__$1,(13),out,inst_93176);
} else {
if((state_val_93217 === (18))){
var inst_93182 = (state_93216[(7)]);
var inst_93191 = cljs.core.first.call(null,inst_93182);
var state_93216__$1 = state_93216;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_93216__$1,(20),out,inst_93191);
} else {
if((state_val_93217 === (8))){
var inst_93171 = (state_93216[(11)]);
var inst_93170 = (state_93216[(12)]);
var inst_93173 = (inst_93171 < inst_93170);
var inst_93174 = inst_93173;
var state_93216__$1 = state_93216;
if(cljs.core.truth_(inst_93174)){
var statearr_93250_93281 = state_93216__$1;
(statearr_93250_93281[(1)] = (10));

} else {
var statearr_93251_93282 = state_93216__$1;
(statearr_93251_93282[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41974__auto__))
;
return ((function (switch__41860__auto__,c__41974__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__41861__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__41861__auto____0 = (function (){
var statearr_93255 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_93255[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__41861__auto__);

(statearr_93255[(1)] = (1));

return statearr_93255;
});
var cljs$core$async$mapcat_STAR__$_state_machine__41861__auto____1 = (function (state_93216){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_93216);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e93256){if((e93256 instanceof Object)){
var ex__41864__auto__ = e93256;
var statearr_93257_93283 = state_93216;
(statearr_93257_93283[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_93216);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e93256;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__93284 = state_93216;
state_93216 = G__93284;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__41861__auto__ = function(state_93216){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__41861__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__41861__auto____1.call(this,state_93216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__41861__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__41861__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto__))
})();
var state__41976__auto__ = (function (){var statearr_93258 = f__41975__auto__.call(null);
(statearr_93258[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto__);

return statearr_93258;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto__))
);

return c__41974__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args93285 = [];
var len__28496__auto___93288 = arguments.length;
var i__28497__auto___93289 = (0);
while(true){
if((i__28497__auto___93289 < len__28496__auto___93288)){
args93285.push((arguments[i__28497__auto___93289]));

var G__93290 = (i__28497__auto___93289 + (1));
i__28497__auto___93289 = G__93290;
continue;
} else {
}
break;
}

var G__93287 = args93285.length;
switch (G__93287) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args93285.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args93292 = [];
var len__28496__auto___93295 = arguments.length;
var i__28497__auto___93296 = (0);
while(true){
if((i__28497__auto___93296 < len__28496__auto___93295)){
args93292.push((arguments[i__28497__auto___93296]));

var G__93297 = (i__28497__auto___93296 + (1));
i__28497__auto___93296 = G__93297;
continue;
} else {
}
break;
}

var G__93294 = args93292.length;
switch (G__93294) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args93292.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args93299 = [];
var len__28496__auto___93350 = arguments.length;
var i__28497__auto___93351 = (0);
while(true){
if((i__28497__auto___93351 < len__28496__auto___93350)){
args93299.push((arguments[i__28497__auto___93351]));

var G__93352 = (i__28497__auto___93351 + (1));
i__28497__auto___93351 = G__93352;
continue;
} else {
}
break;
}

var G__93301 = args93299.length;
switch (G__93301) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args93299.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__41974__auto___93354 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto___93354,out){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto___93354,out){
return (function (state_93325){
var state_val_93326 = (state_93325[(1)]);
if((state_val_93326 === (7))){
var inst_93320 = (state_93325[(2)]);
var state_93325__$1 = state_93325;
var statearr_93327_93355 = state_93325__$1;
(statearr_93327_93355[(2)] = inst_93320);

(statearr_93327_93355[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93326 === (1))){
var inst_93302 = null;
var state_93325__$1 = (function (){var statearr_93328 = state_93325;
(statearr_93328[(7)] = inst_93302);

return statearr_93328;
})();
var statearr_93329_93356 = state_93325__$1;
(statearr_93329_93356[(2)] = null);

(statearr_93329_93356[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93326 === (4))){
var inst_93305 = (state_93325[(8)]);
var inst_93305__$1 = (state_93325[(2)]);
var inst_93306 = (inst_93305__$1 == null);
var inst_93307 = cljs.core.not.call(null,inst_93306);
var state_93325__$1 = (function (){var statearr_93330 = state_93325;
(statearr_93330[(8)] = inst_93305__$1);

return statearr_93330;
})();
if(inst_93307){
var statearr_93331_93357 = state_93325__$1;
(statearr_93331_93357[(1)] = (5));

} else {
var statearr_93332_93358 = state_93325__$1;
(statearr_93332_93358[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93326 === (6))){
var state_93325__$1 = state_93325;
var statearr_93333_93359 = state_93325__$1;
(statearr_93333_93359[(2)] = null);

(statearr_93333_93359[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93326 === (3))){
var inst_93322 = (state_93325[(2)]);
var inst_93323 = cljs.core.async.close_BANG_.call(null,out);
var state_93325__$1 = (function (){var statearr_93334 = state_93325;
(statearr_93334[(9)] = inst_93322);

return statearr_93334;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_93325__$1,inst_93323);
} else {
if((state_val_93326 === (2))){
var state_93325__$1 = state_93325;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_93325__$1,(4),ch);
} else {
if((state_val_93326 === (11))){
var inst_93305 = (state_93325[(8)]);
var inst_93314 = (state_93325[(2)]);
var inst_93302 = inst_93305;
var state_93325__$1 = (function (){var statearr_93335 = state_93325;
(statearr_93335[(10)] = inst_93314);

(statearr_93335[(7)] = inst_93302);

return statearr_93335;
})();
var statearr_93336_93360 = state_93325__$1;
(statearr_93336_93360[(2)] = null);

(statearr_93336_93360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93326 === (9))){
var inst_93305 = (state_93325[(8)]);
var state_93325__$1 = state_93325;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_93325__$1,(11),out,inst_93305);
} else {
if((state_val_93326 === (5))){
var inst_93302 = (state_93325[(7)]);
var inst_93305 = (state_93325[(8)]);
var inst_93309 = cljs.core._EQ_.call(null,inst_93305,inst_93302);
var state_93325__$1 = state_93325;
if(inst_93309){
var statearr_93338_93361 = state_93325__$1;
(statearr_93338_93361[(1)] = (8));

} else {
var statearr_93339_93362 = state_93325__$1;
(statearr_93339_93362[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93326 === (10))){
var inst_93317 = (state_93325[(2)]);
var state_93325__$1 = state_93325;
var statearr_93340_93363 = state_93325__$1;
(statearr_93340_93363[(2)] = inst_93317);

(statearr_93340_93363[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93326 === (8))){
var inst_93302 = (state_93325[(7)]);
var tmp93337 = inst_93302;
var inst_93302__$1 = tmp93337;
var state_93325__$1 = (function (){var statearr_93341 = state_93325;
(statearr_93341[(7)] = inst_93302__$1);

return statearr_93341;
})();
var statearr_93342_93364 = state_93325__$1;
(statearr_93342_93364[(2)] = null);

(statearr_93342_93364[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__41974__auto___93354,out))
;
return ((function (switch__41860__auto__,c__41974__auto___93354,out){
return (function() {
var cljs$core$async$state_machine__41861__auto__ = null;
var cljs$core$async$state_machine__41861__auto____0 = (function (){
var statearr_93346 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_93346[(0)] = cljs$core$async$state_machine__41861__auto__);

(statearr_93346[(1)] = (1));

return statearr_93346;
});
var cljs$core$async$state_machine__41861__auto____1 = (function (state_93325){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_93325);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e93347){if((e93347 instanceof Object)){
var ex__41864__auto__ = e93347;
var statearr_93348_93365 = state_93325;
(statearr_93348_93365[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_93325);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e93347;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__93366 = state_93325;
state_93325 = G__93366;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
cljs$core$async$state_machine__41861__auto__ = function(state_93325){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41861__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41861__auto____1.call(this,state_93325);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41861__auto____0;
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41861__auto____1;
return cljs$core$async$state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto___93354,out))
})();
var state__41976__auto__ = (function (){var statearr_93349 = f__41975__auto__.call(null);
(statearr_93349[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto___93354);

return statearr_93349;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto___93354,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args93367 = [];
var len__28496__auto___93437 = arguments.length;
var i__28497__auto___93438 = (0);
while(true){
if((i__28497__auto___93438 < len__28496__auto___93437)){
args93367.push((arguments[i__28497__auto___93438]));

var G__93439 = (i__28497__auto___93438 + (1));
i__28497__auto___93438 = G__93439;
continue;
} else {
}
break;
}

var G__93369 = args93367.length;
switch (G__93369) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args93367.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__41974__auto___93441 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto___93441,out){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto___93441,out){
return (function (state_93407){
var state_val_93408 = (state_93407[(1)]);
if((state_val_93408 === (7))){
var inst_93403 = (state_93407[(2)]);
var state_93407__$1 = state_93407;
var statearr_93409_93442 = state_93407__$1;
(statearr_93409_93442[(2)] = inst_93403);

(statearr_93409_93442[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93408 === (1))){
var inst_93370 = (new Array(n));
var inst_93371 = inst_93370;
var inst_93372 = (0);
var state_93407__$1 = (function (){var statearr_93410 = state_93407;
(statearr_93410[(7)] = inst_93372);

(statearr_93410[(8)] = inst_93371);

return statearr_93410;
})();
var statearr_93411_93443 = state_93407__$1;
(statearr_93411_93443[(2)] = null);

(statearr_93411_93443[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93408 === (4))){
var inst_93375 = (state_93407[(9)]);
var inst_93375__$1 = (state_93407[(2)]);
var inst_93376 = (inst_93375__$1 == null);
var inst_93377 = cljs.core.not.call(null,inst_93376);
var state_93407__$1 = (function (){var statearr_93412 = state_93407;
(statearr_93412[(9)] = inst_93375__$1);

return statearr_93412;
})();
if(inst_93377){
var statearr_93413_93444 = state_93407__$1;
(statearr_93413_93444[(1)] = (5));

} else {
var statearr_93414_93445 = state_93407__$1;
(statearr_93414_93445[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93408 === (15))){
var inst_93397 = (state_93407[(2)]);
var state_93407__$1 = state_93407;
var statearr_93415_93446 = state_93407__$1;
(statearr_93415_93446[(2)] = inst_93397);

(statearr_93415_93446[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93408 === (13))){
var state_93407__$1 = state_93407;
var statearr_93416_93447 = state_93407__$1;
(statearr_93416_93447[(2)] = null);

(statearr_93416_93447[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93408 === (6))){
var inst_93372 = (state_93407[(7)]);
var inst_93393 = (inst_93372 > (0));
var state_93407__$1 = state_93407;
if(cljs.core.truth_(inst_93393)){
var statearr_93417_93448 = state_93407__$1;
(statearr_93417_93448[(1)] = (12));

} else {
var statearr_93418_93449 = state_93407__$1;
(statearr_93418_93449[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93408 === (3))){
var inst_93405 = (state_93407[(2)]);
var state_93407__$1 = state_93407;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_93407__$1,inst_93405);
} else {
if((state_val_93408 === (12))){
var inst_93371 = (state_93407[(8)]);
var inst_93395 = cljs.core.vec.call(null,inst_93371);
var state_93407__$1 = state_93407;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_93407__$1,(15),out,inst_93395);
} else {
if((state_val_93408 === (2))){
var state_93407__$1 = state_93407;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_93407__$1,(4),ch);
} else {
if((state_val_93408 === (11))){
var inst_93387 = (state_93407[(2)]);
var inst_93388 = (new Array(n));
var inst_93371 = inst_93388;
var inst_93372 = (0);
var state_93407__$1 = (function (){var statearr_93419 = state_93407;
(statearr_93419[(10)] = inst_93387);

(statearr_93419[(7)] = inst_93372);

(statearr_93419[(8)] = inst_93371);

return statearr_93419;
})();
var statearr_93420_93450 = state_93407__$1;
(statearr_93420_93450[(2)] = null);

(statearr_93420_93450[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93408 === (9))){
var inst_93371 = (state_93407[(8)]);
var inst_93385 = cljs.core.vec.call(null,inst_93371);
var state_93407__$1 = state_93407;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_93407__$1,(11),out,inst_93385);
} else {
if((state_val_93408 === (5))){
var inst_93372 = (state_93407[(7)]);
var inst_93375 = (state_93407[(9)]);
var inst_93371 = (state_93407[(8)]);
var inst_93380 = (state_93407[(11)]);
var inst_93379 = (inst_93371[inst_93372] = inst_93375);
var inst_93380__$1 = (inst_93372 + (1));
var inst_93381 = (inst_93380__$1 < n);
var state_93407__$1 = (function (){var statearr_93421 = state_93407;
(statearr_93421[(12)] = inst_93379);

(statearr_93421[(11)] = inst_93380__$1);

return statearr_93421;
})();
if(cljs.core.truth_(inst_93381)){
var statearr_93422_93451 = state_93407__$1;
(statearr_93422_93451[(1)] = (8));

} else {
var statearr_93423_93452 = state_93407__$1;
(statearr_93423_93452[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93408 === (14))){
var inst_93400 = (state_93407[(2)]);
var inst_93401 = cljs.core.async.close_BANG_.call(null,out);
var state_93407__$1 = (function (){var statearr_93425 = state_93407;
(statearr_93425[(13)] = inst_93400);

return statearr_93425;
})();
var statearr_93426_93453 = state_93407__$1;
(statearr_93426_93453[(2)] = inst_93401);

(statearr_93426_93453[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93408 === (10))){
var inst_93391 = (state_93407[(2)]);
var state_93407__$1 = state_93407;
var statearr_93427_93454 = state_93407__$1;
(statearr_93427_93454[(2)] = inst_93391);

(statearr_93427_93454[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93408 === (8))){
var inst_93371 = (state_93407[(8)]);
var inst_93380 = (state_93407[(11)]);
var tmp93424 = inst_93371;
var inst_93371__$1 = tmp93424;
var inst_93372 = inst_93380;
var state_93407__$1 = (function (){var statearr_93428 = state_93407;
(statearr_93428[(7)] = inst_93372);

(statearr_93428[(8)] = inst_93371__$1);

return statearr_93428;
})();
var statearr_93429_93455 = state_93407__$1;
(statearr_93429_93455[(2)] = null);

(statearr_93429_93455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41974__auto___93441,out))
;
return ((function (switch__41860__auto__,c__41974__auto___93441,out){
return (function() {
var cljs$core$async$state_machine__41861__auto__ = null;
var cljs$core$async$state_machine__41861__auto____0 = (function (){
var statearr_93433 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_93433[(0)] = cljs$core$async$state_machine__41861__auto__);

(statearr_93433[(1)] = (1));

return statearr_93433;
});
var cljs$core$async$state_machine__41861__auto____1 = (function (state_93407){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_93407);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e93434){if((e93434 instanceof Object)){
var ex__41864__auto__ = e93434;
var statearr_93435_93456 = state_93407;
(statearr_93435_93456[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_93407);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e93434;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__93457 = state_93407;
state_93407 = G__93457;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
cljs$core$async$state_machine__41861__auto__ = function(state_93407){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41861__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41861__auto____1.call(this,state_93407);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41861__auto____0;
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41861__auto____1;
return cljs$core$async$state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto___93441,out))
})();
var state__41976__auto__ = (function (){var statearr_93436 = f__41975__auto__.call(null);
(statearr_93436[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto___93441);

return statearr_93436;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto___93441,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args93458 = [];
var len__28496__auto___93532 = arguments.length;
var i__28497__auto___93533 = (0);
while(true){
if((i__28497__auto___93533 < len__28496__auto___93532)){
args93458.push((arguments[i__28497__auto___93533]));

var G__93534 = (i__28497__auto___93533 + (1));
i__28497__auto___93533 = G__93534;
continue;
} else {
}
break;
}

var G__93460 = args93458.length;
switch (G__93460) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str("Invalid arity: "),cljs.core.str(args93458.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__41974__auto___93536 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__41974__auto___93536,out){
return (function (){
var f__41975__auto__ = (function (){var switch__41860__auto__ = ((function (c__41974__auto___93536,out){
return (function (state_93502){
var state_val_93503 = (state_93502[(1)]);
if((state_val_93503 === (7))){
var inst_93498 = (state_93502[(2)]);
var state_93502__$1 = state_93502;
var statearr_93504_93537 = state_93502__$1;
(statearr_93504_93537[(2)] = inst_93498);

(statearr_93504_93537[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93503 === (1))){
var inst_93461 = [];
var inst_93462 = inst_93461;
var inst_93463 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_93502__$1 = (function (){var statearr_93505 = state_93502;
(statearr_93505[(7)] = inst_93462);

(statearr_93505[(8)] = inst_93463);

return statearr_93505;
})();
var statearr_93506_93538 = state_93502__$1;
(statearr_93506_93538[(2)] = null);

(statearr_93506_93538[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93503 === (4))){
var inst_93466 = (state_93502[(9)]);
var inst_93466__$1 = (state_93502[(2)]);
var inst_93467 = (inst_93466__$1 == null);
var inst_93468 = cljs.core.not.call(null,inst_93467);
var state_93502__$1 = (function (){var statearr_93507 = state_93502;
(statearr_93507[(9)] = inst_93466__$1);

return statearr_93507;
})();
if(inst_93468){
var statearr_93508_93539 = state_93502__$1;
(statearr_93508_93539[(1)] = (5));

} else {
var statearr_93509_93540 = state_93502__$1;
(statearr_93509_93540[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93503 === (15))){
var inst_93492 = (state_93502[(2)]);
var state_93502__$1 = state_93502;
var statearr_93510_93541 = state_93502__$1;
(statearr_93510_93541[(2)] = inst_93492);

(statearr_93510_93541[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93503 === (13))){
var state_93502__$1 = state_93502;
var statearr_93511_93542 = state_93502__$1;
(statearr_93511_93542[(2)] = null);

(statearr_93511_93542[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93503 === (6))){
var inst_93462 = (state_93502[(7)]);
var inst_93487 = inst_93462.length;
var inst_93488 = (inst_93487 > (0));
var state_93502__$1 = state_93502;
if(cljs.core.truth_(inst_93488)){
var statearr_93512_93543 = state_93502__$1;
(statearr_93512_93543[(1)] = (12));

} else {
var statearr_93513_93544 = state_93502__$1;
(statearr_93513_93544[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93503 === (3))){
var inst_93500 = (state_93502[(2)]);
var state_93502__$1 = state_93502;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_93502__$1,inst_93500);
} else {
if((state_val_93503 === (12))){
var inst_93462 = (state_93502[(7)]);
var inst_93490 = cljs.core.vec.call(null,inst_93462);
var state_93502__$1 = state_93502;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_93502__$1,(15),out,inst_93490);
} else {
if((state_val_93503 === (2))){
var state_93502__$1 = state_93502;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_93502__$1,(4),ch);
} else {
if((state_val_93503 === (11))){
var inst_93466 = (state_93502[(9)]);
var inst_93470 = (state_93502[(10)]);
var inst_93480 = (state_93502[(2)]);
var inst_93481 = [];
var inst_93482 = inst_93481.push(inst_93466);
var inst_93462 = inst_93481;
var inst_93463 = inst_93470;
var state_93502__$1 = (function (){var statearr_93514 = state_93502;
(statearr_93514[(11)] = inst_93480);

(statearr_93514[(12)] = inst_93482);

(statearr_93514[(7)] = inst_93462);

(statearr_93514[(8)] = inst_93463);

return statearr_93514;
})();
var statearr_93515_93545 = state_93502__$1;
(statearr_93515_93545[(2)] = null);

(statearr_93515_93545[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93503 === (9))){
var inst_93462 = (state_93502[(7)]);
var inst_93478 = cljs.core.vec.call(null,inst_93462);
var state_93502__$1 = state_93502;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_93502__$1,(11),out,inst_93478);
} else {
if((state_val_93503 === (5))){
var inst_93463 = (state_93502[(8)]);
var inst_93466 = (state_93502[(9)]);
var inst_93470 = (state_93502[(10)]);
var inst_93470__$1 = f.call(null,inst_93466);
var inst_93471 = cljs.core._EQ_.call(null,inst_93470__$1,inst_93463);
var inst_93472 = cljs.core.keyword_identical_QMARK_.call(null,inst_93463,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_93473 = (inst_93471) || (inst_93472);
var state_93502__$1 = (function (){var statearr_93516 = state_93502;
(statearr_93516[(10)] = inst_93470__$1);

return statearr_93516;
})();
if(cljs.core.truth_(inst_93473)){
var statearr_93517_93546 = state_93502__$1;
(statearr_93517_93546[(1)] = (8));

} else {
var statearr_93518_93547 = state_93502__$1;
(statearr_93518_93547[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93503 === (14))){
var inst_93495 = (state_93502[(2)]);
var inst_93496 = cljs.core.async.close_BANG_.call(null,out);
var state_93502__$1 = (function (){var statearr_93520 = state_93502;
(statearr_93520[(13)] = inst_93495);

return statearr_93520;
})();
var statearr_93521_93548 = state_93502__$1;
(statearr_93521_93548[(2)] = inst_93496);

(statearr_93521_93548[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93503 === (10))){
var inst_93485 = (state_93502[(2)]);
var state_93502__$1 = state_93502;
var statearr_93522_93549 = state_93502__$1;
(statearr_93522_93549[(2)] = inst_93485);

(statearr_93522_93549[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_93503 === (8))){
var inst_93462 = (state_93502[(7)]);
var inst_93466 = (state_93502[(9)]);
var inst_93470 = (state_93502[(10)]);
var inst_93475 = inst_93462.push(inst_93466);
var tmp93519 = inst_93462;
var inst_93462__$1 = tmp93519;
var inst_93463 = inst_93470;
var state_93502__$1 = (function (){var statearr_93523 = state_93502;
(statearr_93523[(7)] = inst_93462__$1);

(statearr_93523[(14)] = inst_93475);

(statearr_93523[(8)] = inst_93463);

return statearr_93523;
})();
var statearr_93524_93550 = state_93502__$1;
(statearr_93524_93550[(2)] = null);

(statearr_93524_93550[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__41974__auto___93536,out))
;
return ((function (switch__41860__auto__,c__41974__auto___93536,out){
return (function() {
var cljs$core$async$state_machine__41861__auto__ = null;
var cljs$core$async$state_machine__41861__auto____0 = (function (){
var statearr_93528 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_93528[(0)] = cljs$core$async$state_machine__41861__auto__);

(statearr_93528[(1)] = (1));

return statearr_93528;
});
var cljs$core$async$state_machine__41861__auto____1 = (function (state_93502){
while(true){
var ret_value__41862__auto__ = (function (){try{while(true){
var result__41863__auto__ = switch__41860__auto__.call(null,state_93502);
if(cljs.core.keyword_identical_QMARK_.call(null,result__41863__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__41863__auto__;
}
break;
}
}catch (e93529){if((e93529 instanceof Object)){
var ex__41864__auto__ = e93529;
var statearr_93530_93551 = state_93502;
(statearr_93530_93551[(5)] = ex__41864__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_93502);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e93529;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__41862__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__93552 = state_93502;
state_93502 = G__93552;
continue;
} else {
return ret_value__41862__auto__;
}
break;
}
});
cljs$core$async$state_machine__41861__auto__ = function(state_93502){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__41861__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__41861__auto____1.call(this,state_93502);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__41861__auto____0;
cljs$core$async$state_machine__41861__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__41861__auto____1;
return cljs$core$async$state_machine__41861__auto__;
})()
;})(switch__41860__auto__,c__41974__auto___93536,out))
})();
var state__41976__auto__ = (function (){var statearr_93531 = f__41975__auto__.call(null);
(statearr_93531[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__41974__auto___93536);

return statearr_93531;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__41976__auto__);
});})(c__41974__auto___93536,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map?rel=1483479078323