var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.DEBUG = true;
goog.LOCALE = "en";
goog.provide = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while(namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if(goog.getObjectByName(namespace)) {
        break
      }
      goog.implicitNamespaces_[namespace] = true
    }
  }
  goog.exportPath_(name)
};
goog.setTestOnly = function(opt_message) {
  if(COMPILED && !goog.DEBUG) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + opt_message ? ": " + opt_message : ".");
  }
};
if(!COMPILED) {
  goog.isProvided_ = function(name) {
    return!goog.implicitNamespaces_[name] && !!goog.getObjectByName(name)
  };
  goog.implicitNamespaces_ = {}
}
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if(!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0])
  }
  for(var part;parts.length && (part = parts.shift());) {
    if(!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object
    }else {
      if(cur[part]) {
        cur = cur[part]
      }else {
        cur = cur[part] = {}
      }
    }
  }
};
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for(var part;part = parts.shift();) {
    if(goog.isDefAndNotNull(cur[part])) {
      cur = cur[part]
    }else {
      return null
    }
  }
  return cur
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for(var x in obj) {
    global[x] = obj[x]
  }
};
goog.addDependency = function(relPath, provides, requires) {
  if(!COMPILED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    for(var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      if(!(path in deps.pathToNames)) {
        deps.pathToNames[path] = {}
      }
      deps.pathToNames[path][provide] = true
    }
    for(var j = 0;require = requires[j];j++) {
      if(!(path in deps.requires)) {
        deps.requires[path] = {}
      }
      deps.requires[path][require] = true
    }
  }
};
goog.ENABLE_DEBUG_LOADER = true;
goog.require = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      return
    }
    if(goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if(path) {
        goog.included_[path] = true;
        goog.writeScripts_();
        return
      }
    }
    var errorMessage = "goog.require could not find: " + name;
    if(goog.global.console) {
      goog.global.console["error"](errorMessage)
    }
    throw Error(errorMessage);
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.identityFunction = function(var_args) {
  return arguments[0]
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    return ctor.instance_ || (ctor.instance_ = new ctor)
  }
};
if(!COMPILED && goog.ENABLE_DEBUG_LOADER) {
  goog.included_ = {};
  goog.dependencies_ = {pathToNames:{}, nameToPath:{}, requires:{}, visited:{}, written:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return typeof doc != "undefined" && "write" in doc
  };
  goog.findBasePath_ = function() {
    if(goog.global.CLOSURE_BASE_PATH) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return
    }else {
      if(!goog.inHtmlDocument_()) {
        return
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("script");
    for(var i = scripts.length - 1;i >= 0;--i) {
      var src = scripts[i].src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if(src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return
      }
    }
  };
  goog.importScript_ = function(src) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if(!goog.dependencies_.written[src] && importScript(src)) {
      goog.dependencies_.written[src] = true
    }
  };
  goog.writeScriptTag_ = function(src) {
    if(goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      doc.write('<script type="text/javascript" src="' + src + '"></' + "script>");
      return true
    }else {
      return false
    }
  };
  goog.writeScripts_ = function() {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if(path in deps.written) {
        return
      }
      if(path in deps.visited) {
        if(!(path in seenScript)) {
          seenScript[path] = true;
          scripts.push(path)
        }
        return
      }
      deps.visited[path] = true;
      if(path in deps.requires) {
        for(var requireName in deps.requires[path]) {
          if(!goog.isProvided_(requireName)) {
            if(requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName])
            }else {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if(!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path)
      }
    }
    for(var path in goog.included_) {
      if(!deps.written[path]) {
        visitNode(path)
      }
    }
    for(var i = 0;i < scripts.length;i++) {
      if(scripts[i]) {
        goog.importScript_(goog.basePath + scripts[i])
      }else {
        throw Error("Undefined script input");
      }
    }
  };
  goog.getPathFromDeps_ = function(rule) {
    if(rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule]
    }else {
      return null
    }
  };
  goog.findBasePath_();
  if(!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js")
  }
}
goog.typeOf = function(value) {
  var s = typeof value;
  if(s == "object") {
    if(value) {
      if(value instanceof Array) {
        return"array"
      }else {
        if(value instanceof Object) {
          return s
        }
      }
      var className = Object.prototype.toString.call(value);
      if(className == "[object Window]") {
        return"object"
      }
      if(className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return"array"
      }
      if(className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return"function"
      }
    }else {
      return"null"
    }
  }else {
    if(s == "function" && typeof value.call == "undefined") {
      return"object"
    }
  }
  return s
};
goog.propertyIsEnumerableCustom_ = function(object, propName) {
  if(propName in object) {
    for(var key in object) {
      if(key == propName && Object.prototype.hasOwnProperty.call(object, propName)) {
        return true
      }
    }
  }
  return false
};
goog.propertyIsEnumerable_ = function(object, propName) {
  if(object instanceof Object) {
    return Object.prototype.propertyIsEnumerable.call(object, propName)
  }else {
    return goog.propertyIsEnumerableCustom_(object, propName)
  }
};
goog.isDef = function(val) {
  return val !== undefined
};
goog.isNull = function(val) {
  return val === null
};
goog.isDefAndNotNull = function(val) {
  return val != null
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array"
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number"
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function"
};
goog.isString = function(val) {
  return typeof val == "string"
};
goog.isBoolean = function(val) {
  return typeof val == "boolean"
};
goog.isNumber = function(val) {
  return typeof val == "number"
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function"
};
goog.isObject = function(val) {
  var type = goog.typeOf(val);
  return type == "object" || type == "array" || type == "function"
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_)
};
goog.removeUid = function(obj) {
  if("removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_)
  }
  try {
    delete obj[goog.UID_PROPERTY_]
  }catch(ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + Math.floor(Math.random() * 2147483648).toString(36);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.cloneObject(obj[key])
    }
    return clone
  }
  return obj
};
Object.prototype.clone;
goog.bindNative_ = function(fn, selfObj, var_args) {
  return fn.call.apply(fn.bind, arguments)
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if(!fn) {
    throw new Error;
  }
  if(arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs)
    }
  }else {
    return function() {
      return fn.apply(selfObj, arguments)
    }
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if(Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_
  }else {
    goog.bind = goog.bindJs_
  }
  return goog.bind.apply(null, arguments)
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = Array.prototype.slice.call(arguments);
    newArgs.unshift.apply(newArgs, args);
    return fn.apply(this, newArgs)
  }
};
goog.mixin = function(target, source) {
  for(var x in source) {
    target[x] = source[x]
  }
};
goog.now = Date.now || function() {
  return+new Date
};
goog.globalEval = function(script) {
  if(goog.global.execScript) {
    goog.global.execScript(script, "JavaScript")
  }else {
    if(goog.global.eval) {
      if(goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _et_ = 1;");
        if(typeof goog.global["_et_"] != "undefined") {
          delete goog.global["_et_"];
          goog.evalWorksForGlobals_ = true
        }else {
          goog.evalWorksForGlobals_ = false
        }
      }
      if(goog.evalWorksForGlobals_) {
        goog.global.eval(script)
      }else {
        var doc = goog.global.document;
        var scriptElt = doc.createElement("script");
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt)
      }
    }else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for(var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]))
    }
    return mapped.join("-")
  };
  var rename;
  if(goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts
  }else {
    rename = function(a) {
      return a
    }
  }
  if(opt_modifier) {
    return className + "-" + rename(opt_modifier)
  }else {
    return rename(className)
  }
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if(!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING
}
goog.getMsg = function(str, opt_values) {
  var values = opt_values || {};
  for(var key in values) {
    var value = ("" + values[key]).replace(/\$/g, "$$$$");
    str = str.replace(new RegExp("\\{\\$" + key + "\\}", "gi"), value)
  }
  return str
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo)
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if(caller.superClass_) {
    return caller.superClass_.constructor.apply(me, Array.prototype.slice.call(arguments, 1))
  }
  var args = Array.prototype.slice.call(arguments, 2);
  var foundCaller = false;
  for(var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if(ctor.prototype[opt_methodName] === caller) {
      foundCaller = true
    }else {
      if(foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args)
      }
    }
  }
  if(me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args)
  }else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  fn.call(goog.global)
};
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.string.Unicode = {NBSP:"\u00a0"};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0
};
goog.string.subs = function(str, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var replacement = String(arguments[i]).replace(/\$/g, "$$$$");
    str = str.replace(/\%s/, replacement)
  }
  return str
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "")
};
goog.string.isEmpty = function(str) {
  return/^[\s\xa0]*$/.test(str)
};
goog.string.isEmptySafe = function(str) {
  return goog.string.isEmpty(goog.string.makeSafe(str))
};
goog.string.isBreakingWhitespace = function(str) {
  return!/[^\t\n\r ]/.test(str)
};
goog.string.isAlpha = function(str) {
  return!/[^a-zA-Z]/.test(str)
};
goog.string.isNumeric = function(str) {
  return!/[^0-9]/.test(str)
};
goog.string.isAlphaNumeric = function(str) {
  return!/[^a-zA-Z0-9]/.test(str)
};
goog.string.isSpace = function(ch) {
  return ch == " "
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "\u0080" && ch <= "\ufffd"
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ")
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n")
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ")
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ")
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "")
};
goog.string.trim = function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "")
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "")
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "")
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if(test1 < test2) {
    return-1
  }else {
    if(test1 == test2) {
      return 0
    }else {
      return 1
    }
  }
};
goog.string.numerateCompareRegExp_ = /(\.\d+)|(\d+)|(\D+)/g;
goog.string.numerateCompare = function(str1, str2) {
  if(str1 == str2) {
    return 0
  }
  if(!str1) {
    return-1
  }
  if(!str2) {
    return 1
  }
  var tokens1 = str1.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var tokens2 = str2.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var count = Math.min(tokens1.length, tokens2.length);
  for(var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if(a != b) {
      var num1 = parseInt(a, 10);
      if(!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if(!isNaN(num2) && num1 - num2) {
          return num1 - num2
        }
      }
      return a < b ? -1 : 1
    }
  }
  if(tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length
  }
  return str1 < str2 ? -1 : 1
};
goog.string.encodeUriRegExp_ = /^[a-zA-Z0-9\-_.!~*'()]*$/;
goog.string.urlEncode = function(str) {
  str = String(str);
  if(!goog.string.encodeUriRegExp_.test(str)) {
    return encodeURIComponent(str)
  }
  return str
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "))
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "<br />" : "<br>")
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if(opt_isLikelyToContainHtmlChars) {
    return str.replace(goog.string.amperRe_, "&amp;").replace(goog.string.ltRe_, "&lt;").replace(goog.string.gtRe_, "&gt;").replace(goog.string.quotRe_, "&quot;")
  }else {
    if(!goog.string.allRe_.test(str)) {
      return str
    }
    if(str.indexOf("&") != -1) {
      str = str.replace(goog.string.amperRe_, "&amp;")
    }
    if(str.indexOf("<") != -1) {
      str = str.replace(goog.string.ltRe_, "&lt;")
    }
    if(str.indexOf(">") != -1) {
      str = str.replace(goog.string.gtRe_, "&gt;")
    }
    if(str.indexOf('"') != -1) {
      str = str.replace(goog.string.quotRe_, "&quot;")
    }
    return str
  }
};
goog.string.amperRe_ = /&/g;
goog.string.ltRe_ = /</g;
goog.string.gtRe_ = />/g;
goog.string.quotRe_ = /\"/g;
goog.string.allRe_ = /[&<>\"]/;
goog.string.unescapeEntities = function(str) {
  if(goog.string.contains(str, "&")) {
    if("document" in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str)
    }else {
      return goog.string.unescapePureXmlEntities_(str)
    }
  }
  return str
};
goog.string.unescapeEntitiesUsingDom_ = function(str) {
  var seen = {"&amp;":"&", "&lt;":"<", "&gt;":">", "&quot;":'"'};
  var div = document.createElement("div");
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if(value) {
      return value
    }
    if(entity.charAt(0) == "#") {
      var n = Number("0" + entity.substr(1));
      if(!isNaN(n)) {
        value = String.fromCharCode(n)
      }
    }
    if(!value) {
      div.innerHTML = s + " ";
      value = div.firstChild.nodeValue.slice(0, -1)
    }
    return seen[s] = value
  })
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return"&";
      case "lt":
        return"<";
      case "gt":
        return">";
      case "quot":
        return'"';
      default:
        if(entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if(!isNaN(n)) {
            return String.fromCharCode(n)
          }
        }
        return s
    }
  })
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " &#160;"), opt_xml)
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for(var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if(str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1)
    }
  }
  return str
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(str.length > chars) {
    str = str.substring(0, chars - 3) + "..."
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(opt_trailingChars && str.length > chars) {
    if(opt_trailingChars > chars) {
      opt_trailingChars = chars
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint)
  }else {
    if(str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos)
    }
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\u0008":"\\b", "\u000c":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  if(s.quote) {
    return s.quote()
  }else {
    var sb = ['"'];
    for(var i = 0;i < s.length;i++) {
      var ch = s.charAt(i);
      var cc = ch.charCodeAt(0);
      sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch))
    }
    sb.push('"');
    return sb.join("")
  }
};
goog.string.escapeString = function(str) {
  var sb = [];
  for(var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i))
  }
  return sb.join("")
};
goog.string.escapeChar = function(c) {
  if(c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c]
  }
  if(c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c]
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if(cc > 31 && cc < 127) {
    rv = c
  }else {
    if(cc < 256) {
      rv = "\\x";
      if(cc < 16 || cc > 256) {
        rv += "0"
      }
    }else {
      rv = "\\u";
      if(cc < 4096) {
        rv += "0"
      }
    }
    rv += cc.toString(16).toUpperCase()
  }
  return goog.string.jsEscapeCache_[c] = rv
};
goog.string.toMap = function(s) {
  var rv = {};
  for(var i = 0;i < s.length;i++) {
    rv[s.charAt(i)] = true
  }
  return rv
};
goog.string.contains = function(s, ss) {
  return s.indexOf(ss) != -1
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if(index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength)
  }
  return resultStr
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "")
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "")
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08")
};
goog.string.repeat = function(string, length) {
  return(new Array(length + 1)).join(string)
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if(index == -1) {
    index = s.length
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj)
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "")
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36)
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for(var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if(v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2])
    }while(order == 0)
  }
  return order
};
goog.string.compareElements_ = function(left, right) {
  if(left < right) {
    return-1
  }else {
    if(left > right) {
      return 1
    }
  }
  return 0
};
goog.string.HASHCODE_MAX_ = 4294967296;
goog.string.hashCode = function(str) {
  var result = 0;
  for(var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i);
    result %= goog.string.HASHCODE_MAX_
  }
  return result
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return"goog_" + goog.string.uniqueStringCounter_++
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if(num == 0 && goog.string.isEmpty(str)) {
    return NaN
  }
  return num
};
goog.string.toCamelCaseCache_ = {};
goog.string.toCamelCase = function(str) {
  return goog.string.toCamelCaseCache_[str] || (goog.string.toCamelCaseCache_[str] = String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase()
  }))
};
goog.string.toSelectorCaseCache_ = {};
goog.string.toSelectorCase = function(str) {
  return goog.string.toSelectorCaseCache_[str] || (goog.string.toSelectorCaseCache_[str] = String(str).replace(/([A-Z])/g, "-$1").toLowerCase())
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  this.stack = (new Error).stack || "";
  if(opt_msg) {
    this.message = String(opt_msg)
  }
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.string");
goog.asserts.ENABLE_ASSERTS = goog.DEBUG;
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if(givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs
  }else {
    if(defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs
    }
  }
  throw new goog.asserts.AssertionError("" + message, args || []);
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return condition
};
goog.asserts.fail = function(opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS) {
    throw new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("instanceof check failed.", null, opt_message, Array.prototype.slice.call(arguments, 3))
  }
};
goog.provide("goog.array");
goog.provide("goog.array.ArrayLike");
goog.require("goog.asserts");
goog.NATIVE_ARRAY_PROTOTYPES = true;
goog.array.ArrayLike;
goog.array.peek = function(array) {
  return array[array.length - 1]
};
goog.array.ARRAY_PROTOTYPE_ = Array.prototype;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.indexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.indexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i < arr.length;i++) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.lastIndexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if(fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex)
  }
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.lastIndexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i >= 0;i--) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.forEach ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;--i) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.filter ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      var val = arr2[i];
      if(f.call(opt_obj, val, i, arr)) {
        res[resLength++] = val
      }
    }
  }
  return res
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.map ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      res[i] = f.call(opt_obj, arr2[i], i, arr)
    }
  }
  return res
};
goog.array.reduce = function(arr, f, val, opt_obj) {
  if(arr.reduce) {
    if(opt_obj) {
      return arr.reduce(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduce(f, val)
    }
  }
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.reduceRight = function(arr, f, val, opt_obj) {
  if(arr.reduceRight) {
    if(opt_obj) {
      return arr.reduceRight(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduceRight(f, val)
    }
  }
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.some ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return true
    }
  }
  return false
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.every ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return false
    }
  }
  return true
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;i--) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0
};
goog.array.clear = function(arr) {
  if(!goog.isArray(arr)) {
    for(var i = arr.length - 1;i >= 0;i--) {
      delete arr[i]
    }
  }
  arr.length = 0
};
goog.array.insert = function(arr, obj) {
  if(!goog.array.contains(arr, obj)) {
    arr.push(obj)
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj)
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd)
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if(arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj)
  }else {
    goog.array.insertAt(arr, obj, i)
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if(rv = i >= 0) {
    goog.array.removeAt(arr, i)
  }
  return rv
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if(i >= 0) {
    goog.array.removeAt(arr, i);
    return true
  }
  return false
};
goog.array.concat = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments)
};
goog.array.clone = function(arr) {
  if(goog.isArray(arr)) {
    return goog.array.concat(arr)
  }else {
    var rv = [];
    for(var i = 0, len = arr.length;i < len;i++) {
      rv[i] = arr[i]
    }
    return rv
  }
};
goog.array.toArray = function(object) {
  if(goog.isArray(object)) {
    return goog.array.concat(object)
  }
  return goog.array.clone(object)
};
goog.array.extend = function(arr1, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    var isArrayLike;
    if(goog.isArray(arr2) || (isArrayLike = goog.isArrayLike(arr2)) && arr2.hasOwnProperty("callee")) {
      arr1.push.apply(arr1, arr2)
    }else {
      if(isArrayLike) {
        var len1 = arr1.length;
        var len2 = arr2.length;
        for(var j = 0;j < len2;j++) {
          arr1[len1 + j] = arr2[j]
        }
      }else {
        arr1.push(arr2)
      }
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.apply(arr, goog.array.slice(arguments, 1))
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if(arguments.length <= 2) {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start)
  }else {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end)
  }
};
goog.array.removeDuplicates = function(arr, opt_rv) {
  var returnArray = opt_rv || arr;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while(cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = goog.isObject(current) ? "o" + goog.getUid(current) : (typeof current).charAt(0) + current;
    if(!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current
    }
  }
  returnArray.length = cursorInsert
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target)
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj)
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while(left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if(isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr)
    }else {
      compareResult = compareFn(opt_target, arr[middle])
    }
    if(compareResult > 0) {
      left = middle + 1
    }else {
      right = middle;
      found = !compareResult
    }
  }
  return found ? left : ~left
};
goog.array.sort = function(arr, opt_compareFn) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.sort.call(arr, opt_compareFn || goog.array.defaultCompare)
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for(var i = 0;i < arr.length;i++) {
    arr[i] = {index:i, value:arr[i]}
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index
  }
  goog.array.sort(arr, stableCompareFn);
  for(var i = 0;i < arr.length;i++) {
    arr[i] = arr[i].value
  }
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return compare(a[key], b[key])
  })
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for(var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if(compareResult > 0 || compareResult == 0 && opt_strict) {
      return false
    }
  }
  return true
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if(!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for(var i = 0;i < l;i++) {
    if(!equalsFn(arr1[i], arr2[i])) {
      return false
    }
  }
  return true
};
goog.array.compare = function(arr1, arr2, opt_equalsFn) {
  return goog.array.equals(arr1, arr2, opt_equalsFn)
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for(var i = 0;i < l;i++) {
    var result = compare(arr1[i], arr2[i]);
    if(result != 0) {
      return result
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length)
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if(index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true
  }
  return false
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false
};
goog.array.bucket = function(array, sorter) {
  var buckets = {};
  for(var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter(value, i, array);
    if(goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value)
    }
  }
  return buckets
};
goog.array.repeat = function(value, n) {
  var array = [];
  for(var i = 0;i < n;i++) {
    array[i] = value
  }
  return array
};
goog.array.flatten = function(var_args) {
  var result = [];
  for(var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if(goog.isArray(element)) {
      result.push.apply(result, goog.array.flatten.apply(null, element))
    }else {
      result.push(element)
    }
  }
  return result
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if(array.length) {
    n %= array.length;
    if(n > 0) {
      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n))
    }else {
      if(n < 0) {
        goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n))
      }
    }
  }
  return array
};
goog.array.zip = function(var_args) {
  if(!arguments.length) {
    return[]
  }
  var result = [];
  for(var i = 0;true;i++) {
    var value = [];
    for(var j = 0;j < arguments.length;j++) {
      var arr = arguments[j];
      if(i >= arr.length) {
        return result
      }
      value.push(arr[i])
    }
    result.push(value)
  }
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for(var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp
  }
};
goog.provide("goog.object");
goog.object.forEach = function(obj, f, opt_obj) {
  for(var key in obj) {
    f.call(opt_obj, obj[key], key, obj)
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key]
    }
  }
  return res
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj)
  }
  return res
};
goog.object.some = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      return true
    }
  }
  return false
};
goog.object.every = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(!f.call(opt_obj, obj[key], key, obj)) {
      return false
    }
  }
  return true
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for(var key in obj) {
    rv++
  }
  return rv
};
goog.object.getAnyKey = function(obj) {
  for(var key in obj) {
    return key
  }
};
goog.object.getAnyValue = function(obj) {
  for(var key in obj) {
    return obj[key]
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val)
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = obj[key]
  }
  return res
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = key
  }
  return res
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for(var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if(!goog.isDef(obj)) {
      break
    }
  }
  return obj
};
goog.object.containsKey = function(obj, key) {
  return key in obj
};
goog.object.containsValue = function(obj, val) {
  for(var key in obj) {
    if(obj[key] == val) {
      return true
    }
  }
  return false
};
goog.object.findKey = function(obj, f, opt_this) {
  for(var key in obj) {
    if(f.call(opt_this, obj[key], key, obj)) {
      return key
    }
  }
  return undefined
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key]
};
goog.object.isEmpty = function(obj) {
  for(var key in obj) {
    return false
  }
  return true
};
goog.object.clear = function(obj) {
  for(var i in obj) {
    delete obj[i]
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if(rv = key in obj) {
    delete obj[key]
  }
  return rv
};
goog.object.add = function(obj, key, val) {
  if(key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val)
};
goog.object.get = function(obj, key, opt_val) {
  if(key in obj) {
    return obj[key]
  }
  return opt_val
};
goog.object.set = function(obj, key, value) {
  obj[key] = value
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value
};
goog.object.clone = function(obj) {
  var res = {};
  for(var key in obj) {
    res[key] = obj[key]
  }
  return res
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key])
    }
    return clone
  }
  return obj
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for(var key in obj) {
    transposed[obj[key]] = key
  }
  return transposed
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for(var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for(key in source) {
      target[key] = source[key]
    }
    for(var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if(Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key]
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0])
  }
  if(argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for(var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1]
  }
  return rv
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0])
  }
  var rv = {};
  for(var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true
  }
  return rv
};
goog.provide("goog.string.format");
goog.require("goog.string");
goog.string.format = function(formatString, var_args) {
  var args = Array.prototype.slice.call(arguments);
  var template = args.shift();
  if(typeof template == "undefined") {
    throw Error("[goog.string.format] Template required");
  }
  var formatRe = /%([0\-\ \+]*)(\d+)?(\.(\d+))?([%sfdiu])/g;
  function replacerDemuxer(match, flags, width, dotp, precision, type, offset, wholeString) {
    if(type == "%") {
      return"%"
    }
    var value = args.shift();
    if(typeof value == "undefined") {
      throw Error("[goog.string.format] Not enough arguments");
    }
    arguments[0] = value;
    return goog.string.format.demuxes_[type].apply(null, arguments)
  }
  return template.replace(formatRe, replacerDemuxer)
};
goog.string.format.demuxes_ = {};
goog.string.format.demuxes_["s"] = function(value, flags, width, dotp, precision, type, offset, wholeString) {
  var replacement = value;
  if(isNaN(width) || width == "" || replacement.length >= width) {
    return replacement
  }
  if(flags.indexOf("-", 0) > -1) {
    replacement = replacement + goog.string.repeat(" ", width - replacement.length)
  }else {
    replacement = goog.string.repeat(" ", width - replacement.length) + replacement
  }
  return replacement
};
goog.string.format.demuxes_["f"] = function(value, flags, width, dotp, precision, type, offset, wholeString) {
  var replacement = value.toString();
  if(!(isNaN(precision) || precision == "")) {
    replacement = value.toFixed(precision)
  }
  var sign;
  if(value < 0) {
    sign = "-"
  }else {
    if(flags.indexOf("+") >= 0) {
      sign = "+"
    }else {
      if(flags.indexOf(" ") >= 0) {
        sign = " "
      }else {
        sign = ""
      }
    }
  }
  if(value >= 0) {
    replacement = sign + replacement
  }
  if(isNaN(width) || replacement.length >= width) {
    return replacement
  }
  replacement = isNaN(precision) ? Math.abs(value).toString() : Math.abs(value).toFixed(precision);
  var padCount = width - replacement.length - sign.length;
  if(flags.indexOf("-", 0) >= 0) {
    replacement = sign + replacement + goog.string.repeat(" ", padCount)
  }else {
    var paddingChar = flags.indexOf("0", 0) >= 0 ? "0" : " ";
    replacement = sign + goog.string.repeat(paddingChar, padCount) + replacement
  }
  return replacement
};
goog.string.format.demuxes_["d"] = function(value, flags, width, dotp, precision, type, offset, wholeString) {
  return goog.string.format.demuxes_["f"](parseInt(value, 10), flags, width, dotp, 0, type, offset, wholeString)
};
goog.string.format.demuxes_["i"] = goog.string.format.demuxes_["d"];
goog.string.format.demuxes_["u"] = goog.string.format.demuxes_["d"];
goog.provide("goog.userAgent.jscript");
goog.require("goog.string");
goog.userAgent.jscript.ASSUME_NO_JSCRIPT = false;
goog.userAgent.jscript.init_ = function() {
  var hasScriptEngine = "ScriptEngine" in goog.global;
  goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ = hasScriptEngine && goog.global["ScriptEngine"]() == "JScript";
  goog.userAgent.jscript.DETECTED_VERSION_ = goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ ? goog.global["ScriptEngineMajorVersion"]() + "." + goog.global["ScriptEngineMinorVersion"]() + "." + goog.global["ScriptEngineBuildVersion"]() : "0"
};
if(!goog.userAgent.jscript.ASSUME_NO_JSCRIPT) {
  goog.userAgent.jscript.init_()
}
goog.userAgent.jscript.HAS_JSCRIPT = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? false : goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_;
goog.userAgent.jscript.VERSION = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? "0" : goog.userAgent.jscript.DETECTED_VERSION_;
goog.userAgent.jscript.isVersion = function(version) {
  return goog.string.compareVersions(goog.userAgent.jscript.VERSION, version) >= 0
};
goog.provide("goog.string.StringBuffer");
goog.require("goog.userAgent.jscript");
goog.string.StringBuffer = function(opt_a1, var_args) {
  this.buffer_ = goog.userAgent.jscript.HAS_JSCRIPT ? [] : "";
  if(opt_a1 != null) {
    this.append.apply(this, arguments)
  }
};
goog.string.StringBuffer.prototype.set = function(s) {
  this.clear();
  this.append(s)
};
if(goog.userAgent.jscript.HAS_JSCRIPT) {
  goog.string.StringBuffer.prototype.bufferLength_ = 0;
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    if(opt_a2 == null) {
      this.buffer_[this.bufferLength_++] = a1
    }else {
      this.buffer_.push.apply(this.buffer_, arguments);
      this.bufferLength_ = this.buffer_.length
    }
    return this
  }
}else {
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    this.buffer_ += a1;
    if(opt_a2 != null) {
      for(var i = 1;i < arguments.length;i++) {
        this.buffer_ += arguments[i]
      }
    }
    return this
  }
}
goog.string.StringBuffer.prototype.clear = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    this.buffer_.length = 0;
    this.bufferLength_ = 0
  }else {
    this.buffer_ = ""
  }
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.toString().length
};
goog.string.StringBuffer.prototype.toString = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    var str = this.buffer_.join("");
    this.clear();
    if(str) {
      this.append(str)
    }
    return str
  }else {
    return this.buffer_
  }
};
goog.provide("cljs.core");
goog.require("goog.array");
goog.require("goog.object");
goog.require("goog.string.format");
goog.require("goog.string.StringBuffer");
goog.require("goog.string");
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_print_fn_STAR_ = function _STAR_print_fn_STAR_(_) {
  throw new Error("No *print-fn* fn set for evaluation environment");
};
cljs.core.truth_ = function truth_(x) {
  return x != null && x !== false
};
cljs.core.type_satisfies_ = function type_satisfies_(p, x) {
  var x__33851 = x == null ? null : x;
  if(p[goog.typeOf(x__33851)]) {
    return true
  }else {
    if(p["_"]) {
      return true
    }else {
      if("\ufdd0'else") {
        return false
      }else {
        return null
      }
    }
  }
};
cljs.core.is_proto_ = function is_proto_(x) {
  return x.constructor.prototype === x
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.missing_protocol = function missing_protocol(proto, obj) {
  return Error(["No protocol method ", proto, " defined for type ", goog.typeOf(obj), ": ", obj].join(""))
};
cljs.core.aclone = function aclone(array_like) {
  return array_like.slice()
};
cljs.core.array = function array(var_args) {
  return Array.prototype.slice.call(arguments)
};
cljs.core.make_array = function() {
  var make_array = null;
  var make_array__1 = function(size) {
    return new Array(size)
  };
  var make_array__2 = function(type, size) {
    return make_array.call(null, size)
  };
  make_array = function(type, size) {
    switch(arguments.length) {
      case 1:
        return make_array__1.call(this, type);
      case 2:
        return make_array__2.call(this, type, size)
    }
    throw"Invalid arity: " + arguments.length;
  };
  make_array.cljs$lang$arity$1 = make_array__1;
  make_array.cljs$lang$arity$2 = make_array__2;
  return make_array
}();
cljs.core.aget = function() {
  var aget = null;
  var aget__2 = function(array, i) {
    return array[i]
  };
  var aget__3 = function() {
    var G__33852__delegate = function(array, i, idxs) {
      return cljs.core.apply.call(null, aget, aget.call(null, array, i), idxs)
    };
    var G__33852 = function(array, i, var_args) {
      var idxs = null;
      if(goog.isDef(var_args)) {
        idxs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__33852__delegate.call(this, array, i, idxs)
    };
    G__33852.cljs$lang$maxFixedArity = 2;
    G__33852.cljs$lang$applyTo = function(arglist__33853) {
      var array = cljs.core.first(arglist__33853);
      var i = cljs.core.first(cljs.core.next(arglist__33853));
      var idxs = cljs.core.rest(cljs.core.next(arglist__33853));
      return G__33852__delegate(array, i, idxs)
    };
    G__33852.cljs$lang$arity$variadic = G__33852__delegate;
    return G__33852
  }();
  aget = function(array, i, var_args) {
    var idxs = var_args;
    switch(arguments.length) {
      case 2:
        return aget__2.call(this, array, i);
      default:
        return aget__3.cljs$lang$arity$variadic(array, i, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  aget.cljs$lang$maxFixedArity = 2;
  aget.cljs$lang$applyTo = aget__3.cljs$lang$applyTo;
  aget.cljs$lang$arity$2 = aget__2;
  aget.cljs$lang$arity$variadic = aget__3.cljs$lang$arity$variadic;
  return aget
}();
cljs.core.aset = function aset(array, i, val) {
  return array[i] = val
};
cljs.core.alength = function alength(array) {
  return array.length
};
cljs.core.into_array = function() {
  var into_array = null;
  var into_array__1 = function(aseq) {
    return into_array.call(null, null, aseq)
  };
  var into_array__2 = function(type, aseq) {
    return cljs.core.reduce.call(null, function(a, x) {
      a.push(x);
      return a
    }, [], aseq)
  };
  into_array = function(type, aseq) {
    switch(arguments.length) {
      case 1:
        return into_array__1.call(this, type);
      case 2:
        return into_array__2.call(this, type, aseq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  into_array.cljs$lang$arity$1 = into_array__1;
  into_array.cljs$lang$arity$2 = into_array__2;
  return into_array
}();
cljs.core.IFn = {};
cljs.core._invoke = function() {
  var _invoke = null;
  var _invoke__1 = function(this$) {
    if(function() {
      var and__3822__auto____33938 = this$;
      if(and__3822__auto____33938) {
        return this$.cljs$core$IFn$_invoke$arity$1
      }else {
        return and__3822__auto____33938
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$1(this$)
    }else {
      var x__2363__auto____33939 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____33940 = cljs.core._invoke[goog.typeOf(x__2363__auto____33939)];
        if(or__3824__auto____33940) {
          return or__3824__auto____33940
        }else {
          var or__3824__auto____33941 = cljs.core._invoke["_"];
          if(or__3824__auto____33941) {
            return or__3824__auto____33941
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$)
    }
  };
  var _invoke__2 = function(this$, a) {
    if(function() {
      var and__3822__auto____33942 = this$;
      if(and__3822__auto____33942) {
        return this$.cljs$core$IFn$_invoke$arity$2
      }else {
        return and__3822__auto____33942
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$2(this$, a)
    }else {
      var x__2363__auto____33943 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____33944 = cljs.core._invoke[goog.typeOf(x__2363__auto____33943)];
        if(or__3824__auto____33944) {
          return or__3824__auto____33944
        }else {
          var or__3824__auto____33945 = cljs.core._invoke["_"];
          if(or__3824__auto____33945) {
            return or__3824__auto____33945
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a)
    }
  };
  var _invoke__3 = function(this$, a, b) {
    if(function() {
      var and__3822__auto____33946 = this$;
      if(and__3822__auto____33946) {
        return this$.cljs$core$IFn$_invoke$arity$3
      }else {
        return and__3822__auto____33946
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b)
    }else {
      var x__2363__auto____33947 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____33948 = cljs.core._invoke[goog.typeOf(x__2363__auto____33947)];
        if(or__3824__auto____33948) {
          return or__3824__auto____33948
        }else {
          var or__3824__auto____33949 = cljs.core._invoke["_"];
          if(or__3824__auto____33949) {
            return or__3824__auto____33949
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b)
    }
  };
  var _invoke__4 = function(this$, a, b, c) {
    if(function() {
      var and__3822__auto____33950 = this$;
      if(and__3822__auto____33950) {
        return this$.cljs$core$IFn$_invoke$arity$4
      }else {
        return and__3822__auto____33950
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c)
    }else {
      var x__2363__auto____33951 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____33952 = cljs.core._invoke[goog.typeOf(x__2363__auto____33951)];
        if(or__3824__auto____33952) {
          return or__3824__auto____33952
        }else {
          var or__3824__auto____33953 = cljs.core._invoke["_"];
          if(or__3824__auto____33953) {
            return or__3824__auto____33953
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c)
    }
  };
  var _invoke__5 = function(this$, a, b, c, d) {
    if(function() {
      var and__3822__auto____33954 = this$;
      if(and__3822__auto____33954) {
        return this$.cljs$core$IFn$_invoke$arity$5
      }else {
        return and__3822__auto____33954
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d)
    }else {
      var x__2363__auto____33955 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____33956 = cljs.core._invoke[goog.typeOf(x__2363__auto____33955)];
        if(or__3824__auto____33956) {
          return or__3824__auto____33956
        }else {
          var or__3824__auto____33957 = cljs.core._invoke["_"];
          if(or__3824__auto____33957) {
            return or__3824__auto____33957
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d)
    }
  };
  var _invoke__6 = function(this$, a, b, c, d, e) {
    if(function() {
      var and__3822__auto____33958 = this$;
      if(and__3822__auto____33958) {
        return this$.cljs$core$IFn$_invoke$arity$6
      }else {
        return and__3822__auto____33958
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e)
    }else {
      var x__2363__auto____33959 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____33960 = cljs.core._invoke[goog.typeOf(x__2363__auto____33959)];
        if(or__3824__auto____33960) {
          return or__3824__auto____33960
        }else {
          var or__3824__auto____33961 = cljs.core._invoke["_"];
          if(or__3824__auto____33961) {
            return or__3824__auto____33961
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e)
    }
  };
  var _invoke__7 = function(this$, a, b, c, d, e, f) {
    if(function() {
      var and__3822__auto____33962 = this$;
      if(and__3822__auto____33962) {
        return this$.cljs$core$IFn$_invoke$arity$7
      }else {
        return and__3822__auto____33962
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f)
    }else {
      var x__2363__auto____33963 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____33964 = cljs.core._invoke[goog.typeOf(x__2363__auto____33963)];
        if(or__3824__auto____33964) {
          return or__3824__auto____33964
        }else {
          var or__3824__auto____33965 = cljs.core._invoke["_"];
          if(or__3824__auto____33965) {
            return or__3824__auto____33965
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f)
    }
  };
  var _invoke__8 = function(this$, a, b, c, d, e, f, g) {
    if(function() {
      var and__3822__auto____33966 = this$;
      if(and__3822__auto____33966) {
        return this$.cljs$core$IFn$_invoke$arity$8
      }else {
        return and__3822__auto____33966
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g)
    }else {
      var x__2363__auto____33967 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____33968 = cljs.core._invoke[goog.typeOf(x__2363__auto____33967)];
        if(or__3824__auto____33968) {
          return or__3824__auto____33968
        }else {
          var or__3824__auto____33969 = cljs.core._invoke["_"];
          if(or__3824__auto____33969) {
            return or__3824__auto____33969
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g)
    }
  };
  var _invoke__9 = function(this$, a, b, c, d, e, f, g, h) {
    if(function() {
      var and__3822__auto____33970 = this$;
      if(and__3822__auto____33970) {
        return this$.cljs$core$IFn$_invoke$arity$9
      }else {
        return and__3822__auto____33970
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h)
    }else {
      var x__2363__auto____33971 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____33972 = cljs.core._invoke[goog.typeOf(x__2363__auto____33971)];
        if(or__3824__auto____33972) {
          return or__3824__auto____33972
        }else {
          var or__3824__auto____33973 = cljs.core._invoke["_"];
          if(or__3824__auto____33973) {
            return or__3824__auto____33973
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h)
    }
  };
  var _invoke__10 = function(this$, a, b, c, d, e, f, g, h, i) {
    if(function() {
      var and__3822__auto____33974 = this$;
      if(and__3822__auto____33974) {
        return this$.cljs$core$IFn$_invoke$arity$10
      }else {
        return and__3822__auto____33974
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i)
    }else {
      var x__2363__auto____33975 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____33976 = cljs.core._invoke[goog.typeOf(x__2363__auto____33975)];
        if(or__3824__auto____33976) {
          return or__3824__auto____33976
        }else {
          var or__3824__auto____33977 = cljs.core._invoke["_"];
          if(or__3824__auto____33977) {
            return or__3824__auto____33977
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i)
    }
  };
  var _invoke__11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
    if(function() {
      var and__3822__auto____33978 = this$;
      if(and__3822__auto____33978) {
        return this$.cljs$core$IFn$_invoke$arity$11
      }else {
        return and__3822__auto____33978
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j)
    }else {
      var x__2363__auto____33979 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____33980 = cljs.core._invoke[goog.typeOf(x__2363__auto____33979)];
        if(or__3824__auto____33980) {
          return or__3824__auto____33980
        }else {
          var or__3824__auto____33981 = cljs.core._invoke["_"];
          if(or__3824__auto____33981) {
            return or__3824__auto____33981
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j)
    }
  };
  var _invoke__12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
    if(function() {
      var and__3822__auto____33982 = this$;
      if(and__3822__auto____33982) {
        return this$.cljs$core$IFn$_invoke$arity$12
      }else {
        return and__3822__auto____33982
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k)
    }else {
      var x__2363__auto____33983 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____33984 = cljs.core._invoke[goog.typeOf(x__2363__auto____33983)];
        if(or__3824__auto____33984) {
          return or__3824__auto____33984
        }else {
          var or__3824__auto____33985 = cljs.core._invoke["_"];
          if(or__3824__auto____33985) {
            return or__3824__auto____33985
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k)
    }
  };
  var _invoke__13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
    if(function() {
      var and__3822__auto____33986 = this$;
      if(and__3822__auto____33986) {
        return this$.cljs$core$IFn$_invoke$arity$13
      }else {
        return and__3822__auto____33986
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }else {
      var x__2363__auto____33987 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____33988 = cljs.core._invoke[goog.typeOf(x__2363__auto____33987)];
        if(or__3824__auto____33988) {
          return or__3824__auto____33988
        }else {
          var or__3824__auto____33989 = cljs.core._invoke["_"];
          if(or__3824__auto____33989) {
            return or__3824__auto____33989
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }
  };
  var _invoke__14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    if(function() {
      var and__3822__auto____33990 = this$;
      if(and__3822__auto____33990) {
        return this$.cljs$core$IFn$_invoke$arity$14
      }else {
        return and__3822__auto____33990
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }else {
      var x__2363__auto____33991 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____33992 = cljs.core._invoke[goog.typeOf(x__2363__auto____33991)];
        if(or__3824__auto____33992) {
          return or__3824__auto____33992
        }else {
          var or__3824__auto____33993 = cljs.core._invoke["_"];
          if(or__3824__auto____33993) {
            return or__3824__auto____33993
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }
  };
  var _invoke__15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    if(function() {
      var and__3822__auto____33994 = this$;
      if(and__3822__auto____33994) {
        return this$.cljs$core$IFn$_invoke$arity$15
      }else {
        return and__3822__auto____33994
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }else {
      var x__2363__auto____33995 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____33996 = cljs.core._invoke[goog.typeOf(x__2363__auto____33995)];
        if(or__3824__auto____33996) {
          return or__3824__auto____33996
        }else {
          var or__3824__auto____33997 = cljs.core._invoke["_"];
          if(or__3824__auto____33997) {
            return or__3824__auto____33997
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }
  };
  var _invoke__16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    if(function() {
      var and__3822__auto____33998 = this$;
      if(and__3822__auto____33998) {
        return this$.cljs$core$IFn$_invoke$arity$16
      }else {
        return and__3822__auto____33998
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }else {
      var x__2363__auto____33999 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____34000 = cljs.core._invoke[goog.typeOf(x__2363__auto____33999)];
        if(or__3824__auto____34000) {
          return or__3824__auto____34000
        }else {
          var or__3824__auto____34001 = cljs.core._invoke["_"];
          if(or__3824__auto____34001) {
            return or__3824__auto____34001
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }
  };
  var _invoke__17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    if(function() {
      var and__3822__auto____34002 = this$;
      if(and__3822__auto____34002) {
        return this$.cljs$core$IFn$_invoke$arity$17
      }else {
        return and__3822__auto____34002
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }else {
      var x__2363__auto____34003 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____34004 = cljs.core._invoke[goog.typeOf(x__2363__auto____34003)];
        if(or__3824__auto____34004) {
          return or__3824__auto____34004
        }else {
          var or__3824__auto____34005 = cljs.core._invoke["_"];
          if(or__3824__auto____34005) {
            return or__3824__auto____34005
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }
  };
  var _invoke__18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    if(function() {
      var and__3822__auto____34006 = this$;
      if(and__3822__auto____34006) {
        return this$.cljs$core$IFn$_invoke$arity$18
      }else {
        return and__3822__auto____34006
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }else {
      var x__2363__auto____34007 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____34008 = cljs.core._invoke[goog.typeOf(x__2363__auto____34007)];
        if(or__3824__auto____34008) {
          return or__3824__auto____34008
        }else {
          var or__3824__auto____34009 = cljs.core._invoke["_"];
          if(or__3824__auto____34009) {
            return or__3824__auto____34009
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }
  };
  var _invoke__19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s) {
    if(function() {
      var and__3822__auto____34010 = this$;
      if(and__3822__auto____34010) {
        return this$.cljs$core$IFn$_invoke$arity$19
      }else {
        return and__3822__auto____34010
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }else {
      var x__2363__auto____34011 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____34012 = cljs.core._invoke[goog.typeOf(x__2363__auto____34011)];
        if(or__3824__auto____34012) {
          return or__3824__auto____34012
        }else {
          var or__3824__auto____34013 = cljs.core._invoke["_"];
          if(or__3824__auto____34013) {
            return or__3824__auto____34013
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }
  };
  var _invoke__20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t) {
    if(function() {
      var and__3822__auto____34014 = this$;
      if(and__3822__auto____34014) {
        return this$.cljs$core$IFn$_invoke$arity$20
      }else {
        return and__3822__auto____34014
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }else {
      var x__2363__auto____34015 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____34016 = cljs.core._invoke[goog.typeOf(x__2363__auto____34015)];
        if(or__3824__auto____34016) {
          return or__3824__auto____34016
        }else {
          var or__3824__auto____34017 = cljs.core._invoke["_"];
          if(or__3824__auto____34017) {
            return or__3824__auto____34017
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }
  };
  var _invoke__21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    if(function() {
      var and__3822__auto____34018 = this$;
      if(and__3822__auto____34018) {
        return this$.cljs$core$IFn$_invoke$arity$21
      }else {
        return and__3822__auto____34018
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }else {
      var x__2363__auto____34019 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____34020 = cljs.core._invoke[goog.typeOf(x__2363__auto____34019)];
        if(or__3824__auto____34020) {
          return or__3824__auto____34020
        }else {
          var or__3824__auto____34021 = cljs.core._invoke["_"];
          if(or__3824__auto____34021) {
            return or__3824__auto____34021
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
  };
  _invoke = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return _invoke__1.call(this, this$);
      case 2:
        return _invoke__2.call(this, this$, a);
      case 3:
        return _invoke__3.call(this, this$, a, b);
      case 4:
        return _invoke__4.call(this, this$, a, b, c);
      case 5:
        return _invoke__5.call(this, this$, a, b, c, d);
      case 6:
        return _invoke__6.call(this, this$, a, b, c, d, e);
      case 7:
        return _invoke__7.call(this, this$, a, b, c, d, e, f);
      case 8:
        return _invoke__8.call(this, this$, a, b, c, d, e, f, g);
      case 9:
        return _invoke__9.call(this, this$, a, b, c, d, e, f, g, h);
      case 10:
        return _invoke__10.call(this, this$, a, b, c, d, e, f, g, h, i);
      case 11:
        return _invoke__11.call(this, this$, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return _invoke__12.call(this, this$, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return _invoke__13.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return _invoke__14.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return _invoke__15.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return _invoke__16.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return _invoke__17.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return _invoke__18.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return _invoke__19.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s);
      case 20:
        return _invoke__20.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t);
      case 21:
        return _invoke__21.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _invoke.cljs$lang$arity$1 = _invoke__1;
  _invoke.cljs$lang$arity$2 = _invoke__2;
  _invoke.cljs$lang$arity$3 = _invoke__3;
  _invoke.cljs$lang$arity$4 = _invoke__4;
  _invoke.cljs$lang$arity$5 = _invoke__5;
  _invoke.cljs$lang$arity$6 = _invoke__6;
  _invoke.cljs$lang$arity$7 = _invoke__7;
  _invoke.cljs$lang$arity$8 = _invoke__8;
  _invoke.cljs$lang$arity$9 = _invoke__9;
  _invoke.cljs$lang$arity$10 = _invoke__10;
  _invoke.cljs$lang$arity$11 = _invoke__11;
  _invoke.cljs$lang$arity$12 = _invoke__12;
  _invoke.cljs$lang$arity$13 = _invoke__13;
  _invoke.cljs$lang$arity$14 = _invoke__14;
  _invoke.cljs$lang$arity$15 = _invoke__15;
  _invoke.cljs$lang$arity$16 = _invoke__16;
  _invoke.cljs$lang$arity$17 = _invoke__17;
  _invoke.cljs$lang$arity$18 = _invoke__18;
  _invoke.cljs$lang$arity$19 = _invoke__19;
  _invoke.cljs$lang$arity$20 = _invoke__20;
  _invoke.cljs$lang$arity$21 = _invoke__21;
  return _invoke
}();
cljs.core.ICounted = {};
cljs.core._count = function _count(coll) {
  if(function() {
    var and__3822__auto____34026 = coll;
    if(and__3822__auto____34026) {
      return coll.cljs$core$ICounted$_count$arity$1
    }else {
      return and__3822__auto____34026
    }
  }()) {
    return coll.cljs$core$ICounted$_count$arity$1(coll)
  }else {
    var x__2363__auto____34027 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34028 = cljs.core._count[goog.typeOf(x__2363__auto____34027)];
      if(or__3824__auto____34028) {
        return or__3824__auto____34028
      }else {
        var or__3824__auto____34029 = cljs.core._count["_"];
        if(or__3824__auto____34029) {
          return or__3824__auto____34029
        }else {
          throw cljs.core.missing_protocol.call(null, "ICounted.-count", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.IEmptyableCollection = {};
cljs.core._empty = function _empty(coll) {
  if(function() {
    var and__3822__auto____34034 = coll;
    if(and__3822__auto____34034) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1
    }else {
      return and__3822__auto____34034
    }
  }()) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll)
  }else {
    var x__2363__auto____34035 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34036 = cljs.core._empty[goog.typeOf(x__2363__auto____34035)];
      if(or__3824__auto____34036) {
        return or__3824__auto____34036
      }else {
        var or__3824__auto____34037 = cljs.core._empty["_"];
        if(or__3824__auto____34037) {
          return or__3824__auto____34037
        }else {
          throw cljs.core.missing_protocol.call(null, "IEmptyableCollection.-empty", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.ICollection = {};
cljs.core._conj = function _conj(coll, o) {
  if(function() {
    var and__3822__auto____34042 = coll;
    if(and__3822__auto____34042) {
      return coll.cljs$core$ICollection$_conj$arity$2
    }else {
      return and__3822__auto____34042
    }
  }()) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o)
  }else {
    var x__2363__auto____34043 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34044 = cljs.core._conj[goog.typeOf(x__2363__auto____34043)];
      if(or__3824__auto____34044) {
        return or__3824__auto____34044
      }else {
        var or__3824__auto____34045 = cljs.core._conj["_"];
        if(or__3824__auto____34045) {
          return or__3824__auto____34045
        }else {
          throw cljs.core.missing_protocol.call(null, "ICollection.-conj", coll);
        }
      }
    }().call(null, coll, o)
  }
};
cljs.core.IIndexed = {};
cljs.core._nth = function() {
  var _nth = null;
  var _nth__2 = function(coll, n) {
    if(function() {
      var and__3822__auto____34054 = coll;
      if(and__3822__auto____34054) {
        return coll.cljs$core$IIndexed$_nth$arity$2
      }else {
        return and__3822__auto____34054
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$2(coll, n)
    }else {
      var x__2363__auto____34055 = coll == null ? null : coll;
      return function() {
        var or__3824__auto____34056 = cljs.core._nth[goog.typeOf(x__2363__auto____34055)];
        if(or__3824__auto____34056) {
          return or__3824__auto____34056
        }else {
          var or__3824__auto____34057 = cljs.core._nth["_"];
          if(or__3824__auto____34057) {
            return or__3824__auto____34057
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n)
    }
  };
  var _nth__3 = function(coll, n, not_found) {
    if(function() {
      var and__3822__auto____34058 = coll;
      if(and__3822__auto____34058) {
        return coll.cljs$core$IIndexed$_nth$arity$3
      }else {
        return and__3822__auto____34058
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found)
    }else {
      var x__2363__auto____34059 = coll == null ? null : coll;
      return function() {
        var or__3824__auto____34060 = cljs.core._nth[goog.typeOf(x__2363__auto____34059)];
        if(or__3824__auto____34060) {
          return or__3824__auto____34060
        }else {
          var or__3824__auto____34061 = cljs.core._nth["_"];
          if(or__3824__auto____34061) {
            return or__3824__auto____34061
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n, not_found)
    }
  };
  _nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return _nth__2.call(this, coll, n);
      case 3:
        return _nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _nth.cljs$lang$arity$2 = _nth__2;
  _nth.cljs$lang$arity$3 = _nth__3;
  return _nth
}();
cljs.core.ASeq = {};
cljs.core.ISeq = {};
cljs.core._first = function _first(coll) {
  if(function() {
    var and__3822__auto____34066 = coll;
    if(and__3822__auto____34066) {
      return coll.cljs$core$ISeq$_first$arity$1
    }else {
      return and__3822__auto____34066
    }
  }()) {
    return coll.cljs$core$ISeq$_first$arity$1(coll)
  }else {
    var x__2363__auto____34067 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34068 = cljs.core._first[goog.typeOf(x__2363__auto____34067)];
      if(or__3824__auto____34068) {
        return or__3824__auto____34068
      }else {
        var or__3824__auto____34069 = cljs.core._first["_"];
        if(or__3824__auto____34069) {
          return or__3824__auto____34069
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-first", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._rest = function _rest(coll) {
  if(function() {
    var and__3822__auto____34074 = coll;
    if(and__3822__auto____34074) {
      return coll.cljs$core$ISeq$_rest$arity$1
    }else {
      return and__3822__auto____34074
    }
  }()) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll)
  }else {
    var x__2363__auto____34075 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34076 = cljs.core._rest[goog.typeOf(x__2363__auto____34075)];
      if(or__3824__auto____34076) {
        return or__3824__auto____34076
      }else {
        var or__3824__auto____34077 = cljs.core._rest["_"];
        if(or__3824__auto____34077) {
          return or__3824__auto____34077
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-rest", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.INext = {};
cljs.core._next = function _next(coll) {
  if(function() {
    var and__3822__auto____34082 = coll;
    if(and__3822__auto____34082) {
      return coll.cljs$core$INext$_next$arity$1
    }else {
      return and__3822__auto____34082
    }
  }()) {
    return coll.cljs$core$INext$_next$arity$1(coll)
  }else {
    var x__2363__auto____34083 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34084 = cljs.core._next[goog.typeOf(x__2363__auto____34083)];
      if(or__3824__auto____34084) {
        return or__3824__auto____34084
      }else {
        var or__3824__auto____34085 = cljs.core._next["_"];
        if(or__3824__auto____34085) {
          return or__3824__auto____34085
        }else {
          throw cljs.core.missing_protocol.call(null, "INext.-next", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.ILookup = {};
cljs.core._lookup = function() {
  var _lookup = null;
  var _lookup__2 = function(o, k) {
    if(function() {
      var and__3822__auto____34094 = o;
      if(and__3822__auto____34094) {
        return o.cljs$core$ILookup$_lookup$arity$2
      }else {
        return and__3822__auto____34094
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$2(o, k)
    }else {
      var x__2363__auto____34095 = o == null ? null : o;
      return function() {
        var or__3824__auto____34096 = cljs.core._lookup[goog.typeOf(x__2363__auto____34095)];
        if(or__3824__auto____34096) {
          return or__3824__auto____34096
        }else {
          var or__3824__auto____34097 = cljs.core._lookup["_"];
          if(or__3824__auto____34097) {
            return or__3824__auto____34097
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k)
    }
  };
  var _lookup__3 = function(o, k, not_found) {
    if(function() {
      var and__3822__auto____34098 = o;
      if(and__3822__auto____34098) {
        return o.cljs$core$ILookup$_lookup$arity$3
      }else {
        return and__3822__auto____34098
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found)
    }else {
      var x__2363__auto____34099 = o == null ? null : o;
      return function() {
        var or__3824__auto____34100 = cljs.core._lookup[goog.typeOf(x__2363__auto____34099)];
        if(or__3824__auto____34100) {
          return or__3824__auto____34100
        }else {
          var or__3824__auto____34101 = cljs.core._lookup["_"];
          if(or__3824__auto____34101) {
            return or__3824__auto____34101
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k, not_found)
    }
  };
  _lookup = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return _lookup__2.call(this, o, k);
      case 3:
        return _lookup__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _lookup.cljs$lang$arity$2 = _lookup__2;
  _lookup.cljs$lang$arity$3 = _lookup__3;
  return _lookup
}();
cljs.core.IAssociative = {};
cljs.core._contains_key_QMARK_ = function _contains_key_QMARK_(coll, k) {
  if(function() {
    var and__3822__auto____34106 = coll;
    if(and__3822__auto____34106) {
      return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2
    }else {
      return and__3822__auto____34106
    }
  }()) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k)
  }else {
    var x__2363__auto____34107 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34108 = cljs.core._contains_key_QMARK_[goog.typeOf(x__2363__auto____34107)];
      if(or__3824__auto____34108) {
        return or__3824__auto____34108
      }else {
        var or__3824__auto____34109 = cljs.core._contains_key_QMARK_["_"];
        if(or__3824__auto____34109) {
          return or__3824__auto____34109
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-contains-key?", coll);
        }
      }
    }().call(null, coll, k)
  }
};
cljs.core._assoc = function _assoc(coll, k, v) {
  if(function() {
    var and__3822__auto____34114 = coll;
    if(and__3822__auto____34114) {
      return coll.cljs$core$IAssociative$_assoc$arity$3
    }else {
      return and__3822__auto____34114
    }
  }()) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v)
  }else {
    var x__2363__auto____34115 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34116 = cljs.core._assoc[goog.typeOf(x__2363__auto____34115)];
      if(or__3824__auto____34116) {
        return or__3824__auto____34116
      }else {
        var or__3824__auto____34117 = cljs.core._assoc["_"];
        if(or__3824__auto____34117) {
          return or__3824__auto____34117
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-assoc", coll);
        }
      }
    }().call(null, coll, k, v)
  }
};
cljs.core.IMap = {};
cljs.core._dissoc = function _dissoc(coll, k) {
  if(function() {
    var and__3822__auto____34122 = coll;
    if(and__3822__auto____34122) {
      return coll.cljs$core$IMap$_dissoc$arity$2
    }else {
      return and__3822__auto____34122
    }
  }()) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k)
  }else {
    var x__2363__auto____34123 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34124 = cljs.core._dissoc[goog.typeOf(x__2363__auto____34123)];
      if(or__3824__auto____34124) {
        return or__3824__auto____34124
      }else {
        var or__3824__auto____34125 = cljs.core._dissoc["_"];
        if(or__3824__auto____34125) {
          return or__3824__auto____34125
        }else {
          throw cljs.core.missing_protocol.call(null, "IMap.-dissoc", coll);
        }
      }
    }().call(null, coll, k)
  }
};
cljs.core.IMapEntry = {};
cljs.core._key = function _key(coll) {
  if(function() {
    var and__3822__auto____34130 = coll;
    if(and__3822__auto____34130) {
      return coll.cljs$core$IMapEntry$_key$arity$1
    }else {
      return and__3822__auto____34130
    }
  }()) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll)
  }else {
    var x__2363__auto____34131 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34132 = cljs.core._key[goog.typeOf(x__2363__auto____34131)];
      if(or__3824__auto____34132) {
        return or__3824__auto____34132
      }else {
        var or__3824__auto____34133 = cljs.core._key["_"];
        if(or__3824__auto____34133) {
          return or__3824__auto____34133
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-key", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._val = function _val(coll) {
  if(function() {
    var and__3822__auto____34138 = coll;
    if(and__3822__auto____34138) {
      return coll.cljs$core$IMapEntry$_val$arity$1
    }else {
      return and__3822__auto____34138
    }
  }()) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll)
  }else {
    var x__2363__auto____34139 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34140 = cljs.core._val[goog.typeOf(x__2363__auto____34139)];
      if(or__3824__auto____34140) {
        return or__3824__auto____34140
      }else {
        var or__3824__auto____34141 = cljs.core._val["_"];
        if(or__3824__auto____34141) {
          return or__3824__auto____34141
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-val", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.ISet = {};
cljs.core._disjoin = function _disjoin(coll, v) {
  if(function() {
    var and__3822__auto____34146 = coll;
    if(and__3822__auto____34146) {
      return coll.cljs$core$ISet$_disjoin$arity$2
    }else {
      return and__3822__auto____34146
    }
  }()) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v)
  }else {
    var x__2363__auto____34147 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34148 = cljs.core._disjoin[goog.typeOf(x__2363__auto____34147)];
      if(or__3824__auto____34148) {
        return or__3824__auto____34148
      }else {
        var or__3824__auto____34149 = cljs.core._disjoin["_"];
        if(or__3824__auto____34149) {
          return or__3824__auto____34149
        }else {
          throw cljs.core.missing_protocol.call(null, "ISet.-disjoin", coll);
        }
      }
    }().call(null, coll, v)
  }
};
cljs.core.IStack = {};
cljs.core._peek = function _peek(coll) {
  if(function() {
    var and__3822__auto____34154 = coll;
    if(and__3822__auto____34154) {
      return coll.cljs$core$IStack$_peek$arity$1
    }else {
      return and__3822__auto____34154
    }
  }()) {
    return coll.cljs$core$IStack$_peek$arity$1(coll)
  }else {
    var x__2363__auto____34155 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34156 = cljs.core._peek[goog.typeOf(x__2363__auto____34155)];
      if(or__3824__auto____34156) {
        return or__3824__auto____34156
      }else {
        var or__3824__auto____34157 = cljs.core._peek["_"];
        if(or__3824__auto____34157) {
          return or__3824__auto____34157
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-peek", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._pop = function _pop(coll) {
  if(function() {
    var and__3822__auto____34162 = coll;
    if(and__3822__auto____34162) {
      return coll.cljs$core$IStack$_pop$arity$1
    }else {
      return and__3822__auto____34162
    }
  }()) {
    return coll.cljs$core$IStack$_pop$arity$1(coll)
  }else {
    var x__2363__auto____34163 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34164 = cljs.core._pop[goog.typeOf(x__2363__auto____34163)];
      if(or__3824__auto____34164) {
        return or__3824__auto____34164
      }else {
        var or__3824__auto____34165 = cljs.core._pop["_"];
        if(or__3824__auto____34165) {
          return or__3824__auto____34165
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-pop", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.IVector = {};
cljs.core._assoc_n = function _assoc_n(coll, n, val) {
  if(function() {
    var and__3822__auto____34170 = coll;
    if(and__3822__auto____34170) {
      return coll.cljs$core$IVector$_assoc_n$arity$3
    }else {
      return and__3822__auto____34170
    }
  }()) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val)
  }else {
    var x__2363__auto____34171 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34172 = cljs.core._assoc_n[goog.typeOf(x__2363__auto____34171)];
      if(or__3824__auto____34172) {
        return or__3824__auto____34172
      }else {
        var or__3824__auto____34173 = cljs.core._assoc_n["_"];
        if(or__3824__auto____34173) {
          return or__3824__auto____34173
        }else {
          throw cljs.core.missing_protocol.call(null, "IVector.-assoc-n", coll);
        }
      }
    }().call(null, coll, n, val)
  }
};
cljs.core.IDeref = {};
cljs.core._deref = function _deref(o) {
  if(function() {
    var and__3822__auto____34178 = o;
    if(and__3822__auto____34178) {
      return o.cljs$core$IDeref$_deref$arity$1
    }else {
      return and__3822__auto____34178
    }
  }()) {
    return o.cljs$core$IDeref$_deref$arity$1(o)
  }else {
    var x__2363__auto____34179 = o == null ? null : o;
    return function() {
      var or__3824__auto____34180 = cljs.core._deref[goog.typeOf(x__2363__auto____34179)];
      if(or__3824__auto____34180) {
        return or__3824__auto____34180
      }else {
        var or__3824__auto____34181 = cljs.core._deref["_"];
        if(or__3824__auto____34181) {
          return or__3824__auto____34181
        }else {
          throw cljs.core.missing_protocol.call(null, "IDeref.-deref", o);
        }
      }
    }().call(null, o)
  }
};
cljs.core.IDerefWithTimeout = {};
cljs.core._deref_with_timeout = function _deref_with_timeout(o, msec, timeout_val) {
  if(function() {
    var and__3822__auto____34186 = o;
    if(and__3822__auto____34186) {
      return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3
    }else {
      return and__3822__auto____34186
    }
  }()) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val)
  }else {
    var x__2363__auto____34187 = o == null ? null : o;
    return function() {
      var or__3824__auto____34188 = cljs.core._deref_with_timeout[goog.typeOf(x__2363__auto____34187)];
      if(or__3824__auto____34188) {
        return or__3824__auto____34188
      }else {
        var or__3824__auto____34189 = cljs.core._deref_with_timeout["_"];
        if(or__3824__auto____34189) {
          return or__3824__auto____34189
        }else {
          throw cljs.core.missing_protocol.call(null, "IDerefWithTimeout.-deref-with-timeout", o);
        }
      }
    }().call(null, o, msec, timeout_val)
  }
};
cljs.core.IMeta = {};
cljs.core._meta = function _meta(o) {
  if(function() {
    var and__3822__auto____34194 = o;
    if(and__3822__auto____34194) {
      return o.cljs$core$IMeta$_meta$arity$1
    }else {
      return and__3822__auto____34194
    }
  }()) {
    return o.cljs$core$IMeta$_meta$arity$1(o)
  }else {
    var x__2363__auto____34195 = o == null ? null : o;
    return function() {
      var or__3824__auto____34196 = cljs.core._meta[goog.typeOf(x__2363__auto____34195)];
      if(or__3824__auto____34196) {
        return or__3824__auto____34196
      }else {
        var or__3824__auto____34197 = cljs.core._meta["_"];
        if(or__3824__auto____34197) {
          return or__3824__auto____34197
        }else {
          throw cljs.core.missing_protocol.call(null, "IMeta.-meta", o);
        }
      }
    }().call(null, o)
  }
};
cljs.core.IWithMeta = {};
cljs.core._with_meta = function _with_meta(o, meta) {
  if(function() {
    var and__3822__auto____34202 = o;
    if(and__3822__auto____34202) {
      return o.cljs$core$IWithMeta$_with_meta$arity$2
    }else {
      return and__3822__auto____34202
    }
  }()) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta)
  }else {
    var x__2363__auto____34203 = o == null ? null : o;
    return function() {
      var or__3824__auto____34204 = cljs.core._with_meta[goog.typeOf(x__2363__auto____34203)];
      if(or__3824__auto____34204) {
        return or__3824__auto____34204
      }else {
        var or__3824__auto____34205 = cljs.core._with_meta["_"];
        if(or__3824__auto____34205) {
          return or__3824__auto____34205
        }else {
          throw cljs.core.missing_protocol.call(null, "IWithMeta.-with-meta", o);
        }
      }
    }().call(null, o, meta)
  }
};
cljs.core.IReduce = {};
cljs.core._reduce = function() {
  var _reduce = null;
  var _reduce__2 = function(coll, f) {
    if(function() {
      var and__3822__auto____34214 = coll;
      if(and__3822__auto____34214) {
        return coll.cljs$core$IReduce$_reduce$arity$2
      }else {
        return and__3822__auto____34214
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$2(coll, f)
    }else {
      var x__2363__auto____34215 = coll == null ? null : coll;
      return function() {
        var or__3824__auto____34216 = cljs.core._reduce[goog.typeOf(x__2363__auto____34215)];
        if(or__3824__auto____34216) {
          return or__3824__auto____34216
        }else {
          var or__3824__auto____34217 = cljs.core._reduce["_"];
          if(or__3824__auto____34217) {
            return or__3824__auto____34217
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f)
    }
  };
  var _reduce__3 = function(coll, f, start) {
    if(function() {
      var and__3822__auto____34218 = coll;
      if(and__3822__auto____34218) {
        return coll.cljs$core$IReduce$_reduce$arity$3
      }else {
        return and__3822__auto____34218
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start)
    }else {
      var x__2363__auto____34219 = coll == null ? null : coll;
      return function() {
        var or__3824__auto____34220 = cljs.core._reduce[goog.typeOf(x__2363__auto____34219)];
        if(or__3824__auto____34220) {
          return or__3824__auto____34220
        }else {
          var or__3824__auto____34221 = cljs.core._reduce["_"];
          if(or__3824__auto____34221) {
            return or__3824__auto____34221
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f, start)
    }
  };
  _reduce = function(coll, f, start) {
    switch(arguments.length) {
      case 2:
        return _reduce__2.call(this, coll, f);
      case 3:
        return _reduce__3.call(this, coll, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _reduce.cljs$lang$arity$2 = _reduce__2;
  _reduce.cljs$lang$arity$3 = _reduce__3;
  return _reduce
}();
cljs.core.IKVReduce = {};
cljs.core._kv_reduce = function _kv_reduce(coll, f, init) {
  if(function() {
    var and__3822__auto____34226 = coll;
    if(and__3822__auto____34226) {
      return coll.cljs$core$IKVReduce$_kv_reduce$arity$3
    }else {
      return and__3822__auto____34226
    }
  }()) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init)
  }else {
    var x__2363__auto____34227 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34228 = cljs.core._kv_reduce[goog.typeOf(x__2363__auto____34227)];
      if(or__3824__auto____34228) {
        return or__3824__auto____34228
      }else {
        var or__3824__auto____34229 = cljs.core._kv_reduce["_"];
        if(or__3824__auto____34229) {
          return or__3824__auto____34229
        }else {
          throw cljs.core.missing_protocol.call(null, "IKVReduce.-kv-reduce", coll);
        }
      }
    }().call(null, coll, f, init)
  }
};
cljs.core.IEquiv = {};
cljs.core._equiv = function _equiv(o, other) {
  if(function() {
    var and__3822__auto____34234 = o;
    if(and__3822__auto____34234) {
      return o.cljs$core$IEquiv$_equiv$arity$2
    }else {
      return and__3822__auto____34234
    }
  }()) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other)
  }else {
    var x__2363__auto____34235 = o == null ? null : o;
    return function() {
      var or__3824__auto____34236 = cljs.core._equiv[goog.typeOf(x__2363__auto____34235)];
      if(or__3824__auto____34236) {
        return or__3824__auto____34236
      }else {
        var or__3824__auto____34237 = cljs.core._equiv["_"];
        if(or__3824__auto____34237) {
          return or__3824__auto____34237
        }else {
          throw cljs.core.missing_protocol.call(null, "IEquiv.-equiv", o);
        }
      }
    }().call(null, o, other)
  }
};
cljs.core.IHash = {};
cljs.core._hash = function _hash(o) {
  if(function() {
    var and__3822__auto____34242 = o;
    if(and__3822__auto____34242) {
      return o.cljs$core$IHash$_hash$arity$1
    }else {
      return and__3822__auto____34242
    }
  }()) {
    return o.cljs$core$IHash$_hash$arity$1(o)
  }else {
    var x__2363__auto____34243 = o == null ? null : o;
    return function() {
      var or__3824__auto____34244 = cljs.core._hash[goog.typeOf(x__2363__auto____34243)];
      if(or__3824__auto____34244) {
        return or__3824__auto____34244
      }else {
        var or__3824__auto____34245 = cljs.core._hash["_"];
        if(or__3824__auto____34245) {
          return or__3824__auto____34245
        }else {
          throw cljs.core.missing_protocol.call(null, "IHash.-hash", o);
        }
      }
    }().call(null, o)
  }
};
cljs.core.ISeqable = {};
cljs.core._seq = function _seq(o) {
  if(function() {
    var and__3822__auto____34250 = o;
    if(and__3822__auto____34250) {
      return o.cljs$core$ISeqable$_seq$arity$1
    }else {
      return and__3822__auto____34250
    }
  }()) {
    return o.cljs$core$ISeqable$_seq$arity$1(o)
  }else {
    var x__2363__auto____34251 = o == null ? null : o;
    return function() {
      var or__3824__auto____34252 = cljs.core._seq[goog.typeOf(x__2363__auto____34251)];
      if(or__3824__auto____34252) {
        return or__3824__auto____34252
      }else {
        var or__3824__auto____34253 = cljs.core._seq["_"];
        if(or__3824__auto____34253) {
          return or__3824__auto____34253
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeqable.-seq", o);
        }
      }
    }().call(null, o)
  }
};
cljs.core.ISequential = {};
cljs.core.IList = {};
cljs.core.IRecord = {};
cljs.core.IReversible = {};
cljs.core._rseq = function _rseq(coll) {
  if(function() {
    var and__3822__auto____34258 = coll;
    if(and__3822__auto____34258) {
      return coll.cljs$core$IReversible$_rseq$arity$1
    }else {
      return and__3822__auto____34258
    }
  }()) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll)
  }else {
    var x__2363__auto____34259 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34260 = cljs.core._rseq[goog.typeOf(x__2363__auto____34259)];
      if(or__3824__auto____34260) {
        return or__3824__auto____34260
      }else {
        var or__3824__auto____34261 = cljs.core._rseq["_"];
        if(or__3824__auto____34261) {
          return or__3824__auto____34261
        }else {
          throw cljs.core.missing_protocol.call(null, "IReversible.-rseq", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.ISorted = {};
cljs.core._sorted_seq = function _sorted_seq(coll, ascending_QMARK_) {
  if(function() {
    var and__3822__auto____34266 = coll;
    if(and__3822__auto____34266) {
      return coll.cljs$core$ISorted$_sorted_seq$arity$2
    }else {
      return and__3822__auto____34266
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_)
  }else {
    var x__2363__auto____34267 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34268 = cljs.core._sorted_seq[goog.typeOf(x__2363__auto____34267)];
      if(or__3824__auto____34268) {
        return or__3824__auto____34268
      }else {
        var or__3824__auto____34269 = cljs.core._sorted_seq["_"];
        if(or__3824__auto____34269) {
          return or__3824__auto____34269
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq", coll);
        }
      }
    }().call(null, coll, ascending_QMARK_)
  }
};
cljs.core._sorted_seq_from = function _sorted_seq_from(coll, k, ascending_QMARK_) {
  if(function() {
    var and__3822__auto____34274 = coll;
    if(and__3822__auto____34274) {
      return coll.cljs$core$ISorted$_sorted_seq_from$arity$3
    }else {
      return and__3822__auto____34274
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_)
  }else {
    var x__2363__auto____34275 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34276 = cljs.core._sorted_seq_from[goog.typeOf(x__2363__auto____34275)];
      if(or__3824__auto____34276) {
        return or__3824__auto____34276
      }else {
        var or__3824__auto____34277 = cljs.core._sorted_seq_from["_"];
        if(or__3824__auto____34277) {
          return or__3824__auto____34277
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq-from", coll);
        }
      }
    }().call(null, coll, k, ascending_QMARK_)
  }
};
cljs.core._entry_key = function _entry_key(coll, entry) {
  if(function() {
    var and__3822__auto____34282 = coll;
    if(and__3822__auto____34282) {
      return coll.cljs$core$ISorted$_entry_key$arity$2
    }else {
      return and__3822__auto____34282
    }
  }()) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry)
  }else {
    var x__2363__auto____34283 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34284 = cljs.core._entry_key[goog.typeOf(x__2363__auto____34283)];
      if(or__3824__auto____34284) {
        return or__3824__auto____34284
      }else {
        var or__3824__auto____34285 = cljs.core._entry_key["_"];
        if(or__3824__auto____34285) {
          return or__3824__auto____34285
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-entry-key", coll);
        }
      }
    }().call(null, coll, entry)
  }
};
cljs.core._comparator = function _comparator(coll) {
  if(function() {
    var and__3822__auto____34290 = coll;
    if(and__3822__auto____34290) {
      return coll.cljs$core$ISorted$_comparator$arity$1
    }else {
      return and__3822__auto____34290
    }
  }()) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll)
  }else {
    var x__2363__auto____34291 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34292 = cljs.core._comparator[goog.typeOf(x__2363__auto____34291)];
      if(or__3824__auto____34292) {
        return or__3824__auto____34292
      }else {
        var or__3824__auto____34293 = cljs.core._comparator["_"];
        if(or__3824__auto____34293) {
          return or__3824__auto____34293
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-comparator", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.IPrintable = {};
cljs.core._pr_seq = function _pr_seq(o, opts) {
  if(function() {
    var and__3822__auto____34298 = o;
    if(and__3822__auto____34298) {
      return o.cljs$core$IPrintable$_pr_seq$arity$2
    }else {
      return and__3822__auto____34298
    }
  }()) {
    return o.cljs$core$IPrintable$_pr_seq$arity$2(o, opts)
  }else {
    var x__2363__auto____34299 = o == null ? null : o;
    return function() {
      var or__3824__auto____34300 = cljs.core._pr_seq[goog.typeOf(x__2363__auto____34299)];
      if(or__3824__auto____34300) {
        return or__3824__auto____34300
      }else {
        var or__3824__auto____34301 = cljs.core._pr_seq["_"];
        if(or__3824__auto____34301) {
          return or__3824__auto____34301
        }else {
          throw cljs.core.missing_protocol.call(null, "IPrintable.-pr-seq", o);
        }
      }
    }().call(null, o, opts)
  }
};
cljs.core.IPending = {};
cljs.core._realized_QMARK_ = function _realized_QMARK_(d) {
  if(function() {
    var and__3822__auto____34306 = d;
    if(and__3822__auto____34306) {
      return d.cljs$core$IPending$_realized_QMARK_$arity$1
    }else {
      return and__3822__auto____34306
    }
  }()) {
    return d.cljs$core$IPending$_realized_QMARK_$arity$1(d)
  }else {
    var x__2363__auto____34307 = d == null ? null : d;
    return function() {
      var or__3824__auto____34308 = cljs.core._realized_QMARK_[goog.typeOf(x__2363__auto____34307)];
      if(or__3824__auto____34308) {
        return or__3824__auto____34308
      }else {
        var or__3824__auto____34309 = cljs.core._realized_QMARK_["_"];
        if(or__3824__auto____34309) {
          return or__3824__auto____34309
        }else {
          throw cljs.core.missing_protocol.call(null, "IPending.-realized?", d);
        }
      }
    }().call(null, d)
  }
};
cljs.core.IWatchable = {};
cljs.core._notify_watches = function _notify_watches(this$, oldval, newval) {
  if(function() {
    var and__3822__auto____34314 = this$;
    if(and__3822__auto____34314) {
      return this$.cljs$core$IWatchable$_notify_watches$arity$3
    }else {
      return and__3822__auto____34314
    }
  }()) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval)
  }else {
    var x__2363__auto____34315 = this$ == null ? null : this$;
    return function() {
      var or__3824__auto____34316 = cljs.core._notify_watches[goog.typeOf(x__2363__auto____34315)];
      if(or__3824__auto____34316) {
        return or__3824__auto____34316
      }else {
        var or__3824__auto____34317 = cljs.core._notify_watches["_"];
        if(or__3824__auto____34317) {
          return or__3824__auto____34317
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-notify-watches", this$);
        }
      }
    }().call(null, this$, oldval, newval)
  }
};
cljs.core._add_watch = function _add_watch(this$, key, f) {
  if(function() {
    var and__3822__auto____34322 = this$;
    if(and__3822__auto____34322) {
      return this$.cljs$core$IWatchable$_add_watch$arity$3
    }else {
      return and__3822__auto____34322
    }
  }()) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f)
  }else {
    var x__2363__auto____34323 = this$ == null ? null : this$;
    return function() {
      var or__3824__auto____34324 = cljs.core._add_watch[goog.typeOf(x__2363__auto____34323)];
      if(or__3824__auto____34324) {
        return or__3824__auto____34324
      }else {
        var or__3824__auto____34325 = cljs.core._add_watch["_"];
        if(or__3824__auto____34325) {
          return or__3824__auto____34325
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-add-watch", this$);
        }
      }
    }().call(null, this$, key, f)
  }
};
cljs.core._remove_watch = function _remove_watch(this$, key) {
  if(function() {
    var and__3822__auto____34330 = this$;
    if(and__3822__auto____34330) {
      return this$.cljs$core$IWatchable$_remove_watch$arity$2
    }else {
      return and__3822__auto____34330
    }
  }()) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key)
  }else {
    var x__2363__auto____34331 = this$ == null ? null : this$;
    return function() {
      var or__3824__auto____34332 = cljs.core._remove_watch[goog.typeOf(x__2363__auto____34331)];
      if(or__3824__auto____34332) {
        return or__3824__auto____34332
      }else {
        var or__3824__auto____34333 = cljs.core._remove_watch["_"];
        if(or__3824__auto____34333) {
          return or__3824__auto____34333
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-remove-watch", this$);
        }
      }
    }().call(null, this$, key)
  }
};
cljs.core.IEditableCollection = {};
cljs.core._as_transient = function _as_transient(coll) {
  if(function() {
    var and__3822__auto____34338 = coll;
    if(and__3822__auto____34338) {
      return coll.cljs$core$IEditableCollection$_as_transient$arity$1
    }else {
      return and__3822__auto____34338
    }
  }()) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll)
  }else {
    var x__2363__auto____34339 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34340 = cljs.core._as_transient[goog.typeOf(x__2363__auto____34339)];
      if(or__3824__auto____34340) {
        return or__3824__auto____34340
      }else {
        var or__3824__auto____34341 = cljs.core._as_transient["_"];
        if(or__3824__auto____34341) {
          return or__3824__auto____34341
        }else {
          throw cljs.core.missing_protocol.call(null, "IEditableCollection.-as-transient", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.ITransientCollection = {};
cljs.core._conj_BANG_ = function _conj_BANG_(tcoll, val) {
  if(function() {
    var and__3822__auto____34346 = tcoll;
    if(and__3822__auto____34346) {
      return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2
    }else {
      return and__3822__auto____34346
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val)
  }else {
    var x__2363__auto____34347 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____34348 = cljs.core._conj_BANG_[goog.typeOf(x__2363__auto____34347)];
      if(or__3824__auto____34348) {
        return or__3824__auto____34348
      }else {
        var or__3824__auto____34349 = cljs.core._conj_BANG_["_"];
        if(or__3824__auto____34349) {
          return or__3824__auto____34349
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-conj!", tcoll);
        }
      }
    }().call(null, tcoll, val)
  }
};
cljs.core._persistent_BANG_ = function _persistent_BANG_(tcoll) {
  if(function() {
    var and__3822__auto____34354 = tcoll;
    if(and__3822__auto____34354) {
      return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1
    }else {
      return and__3822__auto____34354
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll)
  }else {
    var x__2363__auto____34355 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____34356 = cljs.core._persistent_BANG_[goog.typeOf(x__2363__auto____34355)];
      if(or__3824__auto____34356) {
        return or__3824__auto____34356
      }else {
        var or__3824__auto____34357 = cljs.core._persistent_BANG_["_"];
        if(or__3824__auto____34357) {
          return or__3824__auto____34357
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-persistent!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
cljs.core.ITransientAssociative = {};
cljs.core._assoc_BANG_ = function _assoc_BANG_(tcoll, key, val) {
  if(function() {
    var and__3822__auto____34362 = tcoll;
    if(and__3822__auto____34362) {
      return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3
    }else {
      return and__3822__auto____34362
    }
  }()) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val)
  }else {
    var x__2363__auto____34363 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____34364 = cljs.core._assoc_BANG_[goog.typeOf(x__2363__auto____34363)];
      if(or__3824__auto____34364) {
        return or__3824__auto____34364
      }else {
        var or__3824__auto____34365 = cljs.core._assoc_BANG_["_"];
        if(or__3824__auto____34365) {
          return or__3824__auto____34365
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientAssociative.-assoc!", tcoll);
        }
      }
    }().call(null, tcoll, key, val)
  }
};
cljs.core.ITransientMap = {};
cljs.core._dissoc_BANG_ = function _dissoc_BANG_(tcoll, key) {
  if(function() {
    var and__3822__auto____34370 = tcoll;
    if(and__3822__auto____34370) {
      return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2
    }else {
      return and__3822__auto____34370
    }
  }()) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key)
  }else {
    var x__2363__auto____34371 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____34372 = cljs.core._dissoc_BANG_[goog.typeOf(x__2363__auto____34371)];
      if(or__3824__auto____34372) {
        return or__3824__auto____34372
      }else {
        var or__3824__auto____34373 = cljs.core._dissoc_BANG_["_"];
        if(or__3824__auto____34373) {
          return or__3824__auto____34373
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientMap.-dissoc!", tcoll);
        }
      }
    }().call(null, tcoll, key)
  }
};
cljs.core.ITransientVector = {};
cljs.core._assoc_n_BANG_ = function _assoc_n_BANG_(tcoll, n, val) {
  if(function() {
    var and__3822__auto____34378 = tcoll;
    if(and__3822__auto____34378) {
      return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3
    }else {
      return and__3822__auto____34378
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val)
  }else {
    var x__2363__auto____34379 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____34380 = cljs.core._assoc_n_BANG_[goog.typeOf(x__2363__auto____34379)];
      if(or__3824__auto____34380) {
        return or__3824__auto____34380
      }else {
        var or__3824__auto____34381 = cljs.core._assoc_n_BANG_["_"];
        if(or__3824__auto____34381) {
          return or__3824__auto____34381
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-assoc-n!", tcoll);
        }
      }
    }().call(null, tcoll, n, val)
  }
};
cljs.core._pop_BANG_ = function _pop_BANG_(tcoll) {
  if(function() {
    var and__3822__auto____34386 = tcoll;
    if(and__3822__auto____34386) {
      return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1
    }else {
      return and__3822__auto____34386
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll)
  }else {
    var x__2363__auto____34387 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____34388 = cljs.core._pop_BANG_[goog.typeOf(x__2363__auto____34387)];
      if(or__3824__auto____34388) {
        return or__3824__auto____34388
      }else {
        var or__3824__auto____34389 = cljs.core._pop_BANG_["_"];
        if(or__3824__auto____34389) {
          return or__3824__auto____34389
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-pop!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
cljs.core.ITransientSet = {};
cljs.core._disjoin_BANG_ = function _disjoin_BANG_(tcoll, v) {
  if(function() {
    var and__3822__auto____34394 = tcoll;
    if(and__3822__auto____34394) {
      return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2
    }else {
      return and__3822__auto____34394
    }
  }()) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v)
  }else {
    var x__2363__auto____34395 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____34396 = cljs.core._disjoin_BANG_[goog.typeOf(x__2363__auto____34395)];
      if(or__3824__auto____34396) {
        return or__3824__auto____34396
      }else {
        var or__3824__auto____34397 = cljs.core._disjoin_BANG_["_"];
        if(or__3824__auto____34397) {
          return or__3824__auto____34397
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientSet.-disjoin!", tcoll);
        }
      }
    }().call(null, tcoll, v)
  }
};
cljs.core.IComparable = {};
cljs.core._compare = function _compare(x, y) {
  if(function() {
    var and__3822__auto____34402 = x;
    if(and__3822__auto____34402) {
      return x.cljs$core$IComparable$_compare$arity$2
    }else {
      return and__3822__auto____34402
    }
  }()) {
    return x.cljs$core$IComparable$_compare$arity$2(x, y)
  }else {
    var x__2363__auto____34403 = x == null ? null : x;
    return function() {
      var or__3824__auto____34404 = cljs.core._compare[goog.typeOf(x__2363__auto____34403)];
      if(or__3824__auto____34404) {
        return or__3824__auto____34404
      }else {
        var or__3824__auto____34405 = cljs.core._compare["_"];
        if(or__3824__auto____34405) {
          return or__3824__auto____34405
        }else {
          throw cljs.core.missing_protocol.call(null, "IComparable.-compare", x);
        }
      }
    }().call(null, x, y)
  }
};
cljs.core.IChunk = {};
cljs.core._drop_first = function _drop_first(coll) {
  if(function() {
    var and__3822__auto____34410 = coll;
    if(and__3822__auto____34410) {
      return coll.cljs$core$IChunk$_drop_first$arity$1
    }else {
      return and__3822__auto____34410
    }
  }()) {
    return coll.cljs$core$IChunk$_drop_first$arity$1(coll)
  }else {
    var x__2363__auto____34411 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34412 = cljs.core._drop_first[goog.typeOf(x__2363__auto____34411)];
      if(or__3824__auto____34412) {
        return or__3824__auto____34412
      }else {
        var or__3824__auto____34413 = cljs.core._drop_first["_"];
        if(or__3824__auto____34413) {
          return or__3824__auto____34413
        }else {
          throw cljs.core.missing_protocol.call(null, "IChunk.-drop-first", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.IChunkedSeq = {};
cljs.core._chunked_first = function _chunked_first(coll) {
  if(function() {
    var and__3822__auto____34418 = coll;
    if(and__3822__auto____34418) {
      return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1
    }else {
      return and__3822__auto____34418
    }
  }()) {
    return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll)
  }else {
    var x__2363__auto____34419 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34420 = cljs.core._chunked_first[goog.typeOf(x__2363__auto____34419)];
      if(or__3824__auto____34420) {
        return or__3824__auto____34420
      }else {
        var or__3824__auto____34421 = cljs.core._chunked_first["_"];
        if(or__3824__auto____34421) {
          return or__3824__auto____34421
        }else {
          throw cljs.core.missing_protocol.call(null, "IChunkedSeq.-chunked-first", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._chunked_rest = function _chunked_rest(coll) {
  if(function() {
    var and__3822__auto____34426 = coll;
    if(and__3822__auto____34426) {
      return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1
    }else {
      return and__3822__auto____34426
    }
  }()) {
    return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll)
  }else {
    var x__2363__auto____34427 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34428 = cljs.core._chunked_rest[goog.typeOf(x__2363__auto____34427)];
      if(or__3824__auto____34428) {
        return or__3824__auto____34428
      }else {
        var or__3824__auto____34429 = cljs.core._chunked_rest["_"];
        if(or__3824__auto____34429) {
          return or__3824__auto____34429
        }else {
          throw cljs.core.missing_protocol.call(null, "IChunkedSeq.-chunked-rest", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.IChunkedNext = {};
cljs.core._chunked_next = function _chunked_next(coll) {
  if(function() {
    var and__3822__auto____34434 = coll;
    if(and__3822__auto____34434) {
      return coll.cljs$core$IChunkedNext$_chunked_next$arity$1
    }else {
      return and__3822__auto____34434
    }
  }()) {
    return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll)
  }else {
    var x__2363__auto____34435 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____34436 = cljs.core._chunked_next[goog.typeOf(x__2363__auto____34435)];
      if(or__3824__auto____34436) {
        return or__3824__auto____34436
      }else {
        var or__3824__auto____34437 = cljs.core._chunked_next["_"];
        if(or__3824__auto____34437) {
          return or__3824__auto____34437
        }else {
          throw cljs.core.missing_protocol.call(null, "IChunkedNext.-chunked-next", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.identical_QMARK_ = function identical_QMARK_(x, y) {
  return x === y
};
cljs.core._EQ_ = function() {
  var _EQ_ = null;
  var _EQ___1 = function(x) {
    return true
  };
  var _EQ___2 = function(x, y) {
    var or__3824__auto____34439 = x === y;
    if(or__3824__auto____34439) {
      return or__3824__auto____34439
    }else {
      return cljs.core._equiv.call(null, x, y)
    }
  };
  var _EQ___3 = function() {
    var G__34440__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ_.call(null, x, y))) {
          if(cljs.core.next.call(null, more)) {
            var G__34441 = y;
            var G__34442 = cljs.core.first.call(null, more);
            var G__34443 = cljs.core.next.call(null, more);
            x = G__34441;
            y = G__34442;
            more = G__34443;
            continue
          }else {
            return _EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__34440 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__34440__delegate.call(this, x, y, more)
    };
    G__34440.cljs$lang$maxFixedArity = 2;
    G__34440.cljs$lang$applyTo = function(arglist__34444) {
      var x = cljs.core.first(arglist__34444);
      var y = cljs.core.first(cljs.core.next(arglist__34444));
      var more = cljs.core.rest(cljs.core.next(arglist__34444));
      return G__34440__delegate(x, y, more)
    };
    G__34440.cljs$lang$arity$variadic = G__34440__delegate;
    return G__34440
  }();
  _EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ___1.call(this, x);
      case 2:
        return _EQ___2.call(this, x, y);
      default:
        return _EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ_.cljs$lang$maxFixedArity = 2;
  _EQ_.cljs$lang$applyTo = _EQ___3.cljs$lang$applyTo;
  _EQ_.cljs$lang$arity$1 = _EQ___1;
  _EQ_.cljs$lang$arity$2 = _EQ___2;
  _EQ_.cljs$lang$arity$variadic = _EQ___3.cljs$lang$arity$variadic;
  return _EQ_
}();
cljs.core.nil_QMARK_ = function nil_QMARK_(x) {
  return x == null
};
cljs.core.type = function type(x) {
  if(x == null) {
    return null
  }else {
    return x.constructor
  }
};
cljs.core.instance_QMARK_ = function instance_QMARK_(t, o) {
  return o instanceof t
};
cljs.core.IHash["null"] = true;
cljs.core._hash["null"] = function(o) {
  return 0
};
cljs.core.ILookup["null"] = true;
cljs.core._lookup["null"] = function() {
  var G__34445 = null;
  var G__34445__2 = function(o, k) {
    return null
  };
  var G__34445__3 = function(o, k, not_found) {
    return not_found
  };
  G__34445 = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__34445__2.call(this, o, k);
      case 3:
        return G__34445__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__34445
}();
cljs.core.IAssociative["null"] = true;
cljs.core._assoc["null"] = function(_, k, v) {
  return cljs.core.hash_map.call(null, k, v)
};
cljs.core.INext["null"] = true;
cljs.core._next["null"] = function(_) {
  return null
};
cljs.core.ICollection["null"] = true;
cljs.core._conj["null"] = function(_, o) {
  return cljs.core.list.call(null, o)
};
cljs.core.IReduce["null"] = true;
cljs.core._reduce["null"] = function() {
  var G__34446 = null;
  var G__34446__2 = function(_, f) {
    return f.call(null)
  };
  var G__34446__3 = function(_, f, start) {
    return start
  };
  G__34446 = function(_, f, start) {
    switch(arguments.length) {
      case 2:
        return G__34446__2.call(this, _, f);
      case 3:
        return G__34446__3.call(this, _, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__34446
}();
cljs.core.IPrintable["null"] = true;
cljs.core._pr_seq["null"] = function(o) {
  return cljs.core.list.call(null, "nil")
};
cljs.core.ISet["null"] = true;
cljs.core._disjoin["null"] = function(_, v) {
  return null
};
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0
};
cljs.core.IStack["null"] = true;
cljs.core._peek["null"] = function(_) {
  return null
};
cljs.core._pop["null"] = function(_) {
  return null
};
cljs.core.ISeq["null"] = true;
cljs.core._first["null"] = function(_) {
  return null
};
cljs.core._rest["null"] = function(_) {
  return cljs.core.list.call(null)
};
cljs.core.IEquiv["null"] = true;
cljs.core._equiv["null"] = function(_, o) {
  return o == null
};
cljs.core.IWithMeta["null"] = true;
cljs.core._with_meta["null"] = function(_, meta) {
  return null
};
cljs.core.IMeta["null"] = true;
cljs.core._meta["null"] = function(_) {
  return null
};
cljs.core.IIndexed["null"] = true;
cljs.core._nth["null"] = function() {
  var G__34447 = null;
  var G__34447__2 = function(_, n) {
    return null
  };
  var G__34447__3 = function(_, n, not_found) {
    return not_found
  };
  G__34447 = function(_, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__34447__2.call(this, _, n);
      case 3:
        return G__34447__3.call(this, _, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__34447
}();
cljs.core.IEmptyableCollection["null"] = true;
cljs.core._empty["null"] = function(_) {
  return null
};
cljs.core.IMap["null"] = true;
cljs.core._dissoc["null"] = function(_, k) {
  return null
};
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var and__3822__auto____34448 = cljs.core.instance_QMARK_.call(null, Date, other);
  if(and__3822__auto____34448) {
    return o.toString() === other.toString()
  }else {
    return and__3822__auto____34448
  }
};
cljs.core.IHash["number"] = true;
cljs.core._hash["number"] = function(o) {
  return o
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o
};
cljs.core.IHash["boolean"] = true;
cljs.core._hash["boolean"] = function(o) {
  if(o === true) {
    return 1
  }else {
    return 0
  }
};
cljs.core.IHash["_"] = true;
cljs.core._hash["_"] = function(o) {
  return goog.getUid(o)
};
cljs.core.inc = function inc(x) {
  return x + 1
};
cljs.core.ci_reduce = function() {
  var ci_reduce = null;
  var ci_reduce__2 = function(cicoll, f) {
    var cnt__34461 = cljs.core._count.call(null, cicoll);
    if(cnt__34461 === 0) {
      return f.call(null)
    }else {
      var val__34462 = cljs.core._nth.call(null, cicoll, 0);
      var n__34463 = 1;
      while(true) {
        if(n__34463 < cnt__34461) {
          var nval__34464 = f.call(null, val__34462, cljs.core._nth.call(null, cicoll, n__34463));
          if(cljs.core.reduced_QMARK_.call(null, nval__34464)) {
            return cljs.core.deref.call(null, nval__34464)
          }else {
            var G__34473 = nval__34464;
            var G__34474 = n__34463 + 1;
            val__34462 = G__34473;
            n__34463 = G__34474;
            continue
          }
        }else {
          return val__34462
        }
        break
      }
    }
  };
  var ci_reduce__3 = function(cicoll, f, val) {
    var cnt__34465 = cljs.core._count.call(null, cicoll);
    var val__34466 = val;
    var n__34467 = 0;
    while(true) {
      if(n__34467 < cnt__34465) {
        var nval__34468 = f.call(null, val__34466, cljs.core._nth.call(null, cicoll, n__34467));
        if(cljs.core.reduced_QMARK_.call(null, nval__34468)) {
          return cljs.core.deref.call(null, nval__34468)
        }else {
          var G__34475 = nval__34468;
          var G__34476 = n__34467 + 1;
          val__34466 = G__34475;
          n__34467 = G__34476;
          continue
        }
      }else {
        return val__34466
      }
      break
    }
  };
  var ci_reduce__4 = function(cicoll, f, val, idx) {
    var cnt__34469 = cljs.core._count.call(null, cicoll);
    var val__34470 = val;
    var n__34471 = idx;
    while(true) {
      if(n__34471 < cnt__34469) {
        var nval__34472 = f.call(null, val__34470, cljs.core._nth.call(null, cicoll, n__34471));
        if(cljs.core.reduced_QMARK_.call(null, nval__34472)) {
          return cljs.core.deref.call(null, nval__34472)
        }else {
          var G__34477 = nval__34472;
          var G__34478 = n__34471 + 1;
          val__34470 = G__34477;
          n__34471 = G__34478;
          continue
        }
      }else {
        return val__34470
      }
      break
    }
  };
  ci_reduce = function(cicoll, f, val, idx) {
    switch(arguments.length) {
      case 2:
        return ci_reduce__2.call(this, cicoll, f);
      case 3:
        return ci_reduce__3.call(this, cicoll, f, val);
      case 4:
        return ci_reduce__4.call(this, cicoll, f, val, idx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ci_reduce.cljs$lang$arity$2 = ci_reduce__2;
  ci_reduce.cljs$lang$arity$3 = ci_reduce__3;
  ci_reduce.cljs$lang$arity$4 = ci_reduce__4;
  return ci_reduce
}();
cljs.core.array_reduce = function() {
  var array_reduce = null;
  var array_reduce__2 = function(arr, f) {
    var cnt__34491 = arr.length;
    if(arr.length === 0) {
      return f.call(null)
    }else {
      var val__34492 = arr[0];
      var n__34493 = 1;
      while(true) {
        if(n__34493 < cnt__34491) {
          var nval__34494 = f.call(null, val__34492, arr[n__34493]);
          if(cljs.core.reduced_QMARK_.call(null, nval__34494)) {
            return cljs.core.deref.call(null, nval__34494)
          }else {
            var G__34503 = nval__34494;
            var G__34504 = n__34493 + 1;
            val__34492 = G__34503;
            n__34493 = G__34504;
            continue
          }
        }else {
          return val__34492
        }
        break
      }
    }
  };
  var array_reduce__3 = function(arr, f, val) {
    var cnt__34495 = arr.length;
    var val__34496 = val;
    var n__34497 = 0;
    while(true) {
      if(n__34497 < cnt__34495) {
        var nval__34498 = f.call(null, val__34496, arr[n__34497]);
        if(cljs.core.reduced_QMARK_.call(null, nval__34498)) {
          return cljs.core.deref.call(null, nval__34498)
        }else {
          var G__34505 = nval__34498;
          var G__34506 = n__34497 + 1;
          val__34496 = G__34505;
          n__34497 = G__34506;
          continue
        }
      }else {
        return val__34496
      }
      break
    }
  };
  var array_reduce__4 = function(arr, f, val, idx) {
    var cnt__34499 = arr.length;
    var val__34500 = val;
    var n__34501 = idx;
    while(true) {
      if(n__34501 < cnt__34499) {
        var nval__34502 = f.call(null, val__34500, arr[n__34501]);
        if(cljs.core.reduced_QMARK_.call(null, nval__34502)) {
          return cljs.core.deref.call(null, nval__34502)
        }else {
          var G__34507 = nval__34502;
          var G__34508 = n__34501 + 1;
          val__34500 = G__34507;
          n__34501 = G__34508;
          continue
        }
      }else {
        return val__34500
      }
      break
    }
  };
  array_reduce = function(arr, f, val, idx) {
    switch(arguments.length) {
      case 2:
        return array_reduce__2.call(this, arr, f);
      case 3:
        return array_reduce__3.call(this, arr, f, val);
      case 4:
        return array_reduce__4.call(this, arr, f, val, idx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  array_reduce.cljs$lang$arity$2 = array_reduce__2;
  array_reduce.cljs$lang$arity$3 = array_reduce__3;
  array_reduce.cljs$lang$arity$4 = array_reduce__4;
  return array_reduce
}();
cljs.core.IndexedSeq = function(a, i) {
  this.a = a;
  this.i = i;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 166199546
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/IndexedSeq")
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__34509 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = function(_) {
  var this__34510 = this;
  if(this__34510.i + 1 < this__34510.a.length) {
    return new cljs.core.IndexedSeq(this__34510.a, this__34510.i + 1)
  }else {
    return null
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__34511 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__34512 = this;
  var c__34513 = coll.cljs$core$ICounted$_count$arity$1(coll);
  if(c__34513 > 0) {
    return new cljs.core.RSeq(coll, c__34513 - 1, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.IndexedSeq.prototype.toString = function() {
  var this__34514 = this;
  var this__34515 = this;
  return cljs.core.pr_str.call(null, this__34515)
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__34516 = this;
  if(cljs.core.counted_QMARK_.call(null, this__34516.a)) {
    return cljs.core.ci_reduce.call(null, this__34516.a, f, this__34516.a[this__34516.i], this__34516.i + 1)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, this__34516.a[this__34516.i], 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__34517 = this;
  if(cljs.core.counted_QMARK_.call(null, this__34517.a)) {
    return cljs.core.ci_reduce.call(null, this__34517.a, f, start, this__34517.i)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, start, 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__34518 = this;
  return this$
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var this__34519 = this;
  return this__34519.a.length - this__34519.i
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var this__34520 = this;
  return this__34520.a[this__34520.i]
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var this__34521 = this;
  if(this__34521.i + 1 < this__34521.a.length) {
    return new cljs.core.IndexedSeq(this__34521.a, this__34521.i + 1)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__34522 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__34523 = this;
  var i__34524 = n + this__34523.i;
  if(i__34524 < this__34523.a.length) {
    return this__34523.a[i__34524]
  }else {
    return null
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__34525 = this;
  var i__34526 = n + this__34525.i;
  if(i__34526 < this__34525.a.length) {
    return this__34525.a[i__34526]
  }else {
    return not_found
  }
};
cljs.core.IndexedSeq;
cljs.core.prim_seq = function() {
  var prim_seq = null;
  var prim_seq__1 = function(prim) {
    return prim_seq.call(null, prim, 0)
  };
  var prim_seq__2 = function(prim, i) {
    if(prim.length === 0) {
      return null
    }else {
      return new cljs.core.IndexedSeq(prim, i)
    }
  };
  prim_seq = function(prim, i) {
    switch(arguments.length) {
      case 1:
        return prim_seq__1.call(this, prim);
      case 2:
        return prim_seq__2.call(this, prim, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  prim_seq.cljs$lang$arity$1 = prim_seq__1;
  prim_seq.cljs$lang$arity$2 = prim_seq__2;
  return prim_seq
}();
cljs.core.array_seq = function() {
  var array_seq = null;
  var array_seq__1 = function(array) {
    return cljs.core.prim_seq.call(null, array, 0)
  };
  var array_seq__2 = function(array, i) {
    return cljs.core.prim_seq.call(null, array, i)
  };
  array_seq = function(array, i) {
    switch(arguments.length) {
      case 1:
        return array_seq__1.call(this, array);
      case 2:
        return array_seq__2.call(this, array, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  array_seq.cljs$lang$arity$1 = array_seq__1;
  array_seq.cljs$lang$arity$2 = array_seq__2;
  return array_seq
}();
cljs.core.IReduce["array"] = true;
cljs.core._reduce["array"] = function() {
  var G__34527 = null;
  var G__34527__2 = function(array, f) {
    return cljs.core.ci_reduce.call(null, array, f)
  };
  var G__34527__3 = function(array, f, start) {
    return cljs.core.ci_reduce.call(null, array, f, start)
  };
  G__34527 = function(array, f, start) {
    switch(arguments.length) {
      case 2:
        return G__34527__2.call(this, array, f);
      case 3:
        return G__34527__3.call(this, array, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__34527
}();
cljs.core.ILookup["array"] = true;
cljs.core._lookup["array"] = function() {
  var G__34528 = null;
  var G__34528__2 = function(array, k) {
    return array[k]
  };
  var G__34528__3 = function(array, k, not_found) {
    return cljs.core._nth.call(null, array, k, not_found)
  };
  G__34528 = function(array, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__34528__2.call(this, array, k);
      case 3:
        return G__34528__3.call(this, array, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__34528
}();
cljs.core.IIndexed["array"] = true;
cljs.core._nth["array"] = function() {
  var G__34529 = null;
  var G__34529__2 = function(array, n) {
    if(n < array.length) {
      return array[n]
    }else {
      return null
    }
  };
  var G__34529__3 = function(array, n, not_found) {
    if(n < array.length) {
      return array[n]
    }else {
      return not_found
    }
  };
  G__34529 = function(array, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__34529__2.call(this, array, n);
      case 3:
        return G__34529__3.call(this, array, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__34529
}();
cljs.core.ICounted["array"] = true;
cljs.core._count["array"] = function(a) {
  return a.length
};
cljs.core.ISeqable["array"] = true;
cljs.core._seq["array"] = function(array) {
  return cljs.core.array_seq.call(null, array, 0)
};
cljs.core.RSeq = function(ci, i, meta) {
  this.ci = ci;
  this.i = i;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31850570
};
cljs.core.RSeq.cljs$lang$type = true;
cljs.core.RSeq.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/RSeq")
};
cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__34530 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__34531 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.RSeq.prototype.toString = function() {
  var this__34532 = this;
  var this__34533 = this;
  return cljs.core.pr_str.call(null, this__34533)
};
cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__34534 = this;
  return coll
};
cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__34535 = this;
  return this__34535.i + 1
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__34536 = this;
  return cljs.core._nth.call(null, this__34536.ci, this__34536.i)
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__34537 = this;
  if(this__34537.i > 0) {
    return new cljs.core.RSeq(this__34537.ci, this__34537.i - 1, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__34538 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var this__34539 = this;
  return new cljs.core.RSeq(this__34539.ci, this__34539.i, new_meta)
};
cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__34540 = this;
  return this__34540.meta
};
cljs.core.RSeq;
cljs.core.seq = function seq(coll) {
  if(coll == null) {
    return null
  }else {
    if(function() {
      var G__34544__34545 = coll;
      if(G__34544__34545) {
        if(function() {
          var or__3824__auto____34546 = G__34544__34545.cljs$lang$protocol_mask$partition0$ & 32;
          if(or__3824__auto____34546) {
            return or__3824__auto____34546
          }else {
            return G__34544__34545.cljs$core$ASeq$
          }
        }()) {
          return true
        }else {
          if(!G__34544__34545.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__34544__34545)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__34544__34545)
      }
    }()) {
      return coll
    }else {
      return cljs.core._seq.call(null, coll)
    }
  }
};
cljs.core.first = function first(coll) {
  if(coll == null) {
    return null
  }else {
    if(function() {
      var G__34551__34552 = coll;
      if(G__34551__34552) {
        if(function() {
          var or__3824__auto____34553 = G__34551__34552.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3824__auto____34553) {
            return or__3824__auto____34553
          }else {
            return G__34551__34552.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__34551__34552.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__34551__34552)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__34551__34552)
      }
    }()) {
      return cljs.core._first.call(null, coll)
    }else {
      var s__34554 = cljs.core.seq.call(null, coll);
      if(s__34554 == null) {
        return null
      }else {
        return cljs.core._first.call(null, s__34554)
      }
    }
  }
};
cljs.core.rest = function rest(coll) {
  if(!(coll == null)) {
    if(function() {
      var G__34559__34560 = coll;
      if(G__34559__34560) {
        if(function() {
          var or__3824__auto____34561 = G__34559__34560.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3824__auto____34561) {
            return or__3824__auto____34561
          }else {
            return G__34559__34560.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__34559__34560.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__34559__34560)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__34559__34560)
      }
    }()) {
      return cljs.core._rest.call(null, coll)
    }else {
      var s__34562 = cljs.core.seq.call(null, coll);
      if(!(s__34562 == null)) {
        return cljs.core._rest.call(null, s__34562)
      }else {
        return cljs.core.List.EMPTY
      }
    }
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.next = function next(coll) {
  if(coll == null) {
    return null
  }else {
    if(function() {
      var G__34566__34567 = coll;
      if(G__34566__34567) {
        if(function() {
          var or__3824__auto____34568 = G__34566__34567.cljs$lang$protocol_mask$partition0$ & 128;
          if(or__3824__auto____34568) {
            return or__3824__auto____34568
          }else {
            return G__34566__34567.cljs$core$INext$
          }
        }()) {
          return true
        }else {
          if(!G__34566__34567.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.INext, G__34566__34567)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.INext, G__34566__34567)
      }
    }()) {
      return cljs.core._next.call(null, coll)
    }else {
      return cljs.core.seq.call(null, cljs.core.rest.call(null, coll))
    }
  }
};
cljs.core.second = function second(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.ffirst = function ffirst(coll) {
  return cljs.core.first.call(null, cljs.core.first.call(null, coll))
};
cljs.core.nfirst = function nfirst(coll) {
  return cljs.core.next.call(null, cljs.core.first.call(null, coll))
};
cljs.core.fnext = function fnext(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.nnext = function nnext(coll) {
  return cljs.core.next.call(null, cljs.core.next.call(null, coll))
};
cljs.core.last = function last(s) {
  while(true) {
    var sn__34570 = cljs.core.next.call(null, s);
    if(!(sn__34570 == null)) {
      var G__34571 = sn__34570;
      s = G__34571;
      continue
    }else {
      return cljs.core.first.call(null, s)
    }
    break
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o
};
cljs.core.not = function not(x) {
  if(cljs.core.truth_(x)) {
    return false
  }else {
    return true
  }
};
cljs.core.conj = function() {
  var conj = null;
  var conj__2 = function(coll, x) {
    return cljs.core._conj.call(null, coll, x)
  };
  var conj__3 = function() {
    var G__34572__delegate = function(coll, x, xs) {
      while(true) {
        if(cljs.core.truth_(xs)) {
          var G__34573 = conj.call(null, coll, x);
          var G__34574 = cljs.core.first.call(null, xs);
          var G__34575 = cljs.core.next.call(null, xs);
          coll = G__34573;
          x = G__34574;
          xs = G__34575;
          continue
        }else {
          return conj.call(null, coll, x)
        }
        break
      }
    };
    var G__34572 = function(coll, x, var_args) {
      var xs = null;
      if(goog.isDef(var_args)) {
        xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__34572__delegate.call(this, coll, x, xs)
    };
    G__34572.cljs$lang$maxFixedArity = 2;
    G__34572.cljs$lang$applyTo = function(arglist__34576) {
      var coll = cljs.core.first(arglist__34576);
      var x = cljs.core.first(cljs.core.next(arglist__34576));
      var xs = cljs.core.rest(cljs.core.next(arglist__34576));
      return G__34572__delegate(coll, x, xs)
    };
    G__34572.cljs$lang$arity$variadic = G__34572__delegate;
    return G__34572
  }();
  conj = function(coll, x, var_args) {
    var xs = var_args;
    switch(arguments.length) {
      case 2:
        return conj__2.call(this, coll, x);
      default:
        return conj__3.cljs$lang$arity$variadic(coll, x, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  conj.cljs$lang$maxFixedArity = 2;
  conj.cljs$lang$applyTo = conj__3.cljs$lang$applyTo;
  conj.cljs$lang$arity$2 = conj__2;
  conj.cljs$lang$arity$variadic = conj__3.cljs$lang$arity$variadic;
  return conj
}();
cljs.core.empty = function empty(coll) {
  return cljs.core._empty.call(null, coll)
};
cljs.core.accumulating_seq_count = function accumulating_seq_count(coll) {
  var s__34579 = cljs.core.seq.call(null, coll);
  var acc__34580 = 0;
  while(true) {
    if(cljs.core.counted_QMARK_.call(null, s__34579)) {
      return acc__34580 + cljs.core._count.call(null, s__34579)
    }else {
      var G__34581 = cljs.core.next.call(null, s__34579);
      var G__34582 = acc__34580 + 1;
      s__34579 = G__34581;
      acc__34580 = G__34582;
      continue
    }
    break
  }
};
cljs.core.count = function count(coll) {
  if(cljs.core.counted_QMARK_.call(null, coll)) {
    return cljs.core._count.call(null, coll)
  }else {
    return cljs.core.accumulating_seq_count.call(null, coll)
  }
};
cljs.core.linear_traversal_nth = function() {
  var linear_traversal_nth = null;
  var linear_traversal_nth__2 = function(coll, n) {
    if(coll == null) {
      throw new Error("Index out of bounds");
    }else {
      if(n === 0) {
        if(cljs.core.seq.call(null, coll)) {
          return cljs.core.first.call(null, coll)
        }else {
          throw new Error("Index out of bounds");
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n)
        }else {
          if(cljs.core.seq.call(null, coll)) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1)
          }else {
            if("\ufdd0'else") {
              throw new Error("Index out of bounds");
            }else {
              return null
            }
          }
        }
      }
    }
  };
  var linear_traversal_nth__3 = function(coll, n, not_found) {
    if(coll == null) {
      return not_found
    }else {
      if(n === 0) {
        if(cljs.core.seq.call(null, coll)) {
          return cljs.core.first.call(null, coll)
        }else {
          return not_found
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n, not_found)
        }else {
          if(cljs.core.seq.call(null, coll)) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1, not_found)
          }else {
            if("\ufdd0'else") {
              return not_found
            }else {
              return null
            }
          }
        }
      }
    }
  };
  linear_traversal_nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return linear_traversal_nth__2.call(this, coll, n);
      case 3:
        return linear_traversal_nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  linear_traversal_nth.cljs$lang$arity$2 = linear_traversal_nth__2;
  linear_traversal_nth.cljs$lang$arity$3 = linear_traversal_nth__3;
  return linear_traversal_nth
}();
cljs.core.nth = function() {
  var nth = null;
  var nth__2 = function(coll, n) {
    if(coll == null) {
      return null
    }else {
      if(function() {
        var G__34589__34590 = coll;
        if(G__34589__34590) {
          if(function() {
            var or__3824__auto____34591 = G__34589__34590.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3824__auto____34591) {
              return or__3824__auto____34591
            }else {
              return G__34589__34590.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__34589__34590.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__34589__34590)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__34589__34590)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n))
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n))
      }
    }
  };
  var nth__3 = function(coll, n, not_found) {
    if(!(coll == null)) {
      if(function() {
        var G__34592__34593 = coll;
        if(G__34592__34593) {
          if(function() {
            var or__3824__auto____34594 = G__34592__34593.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3824__auto____34594) {
              return or__3824__auto____34594
            }else {
              return G__34592__34593.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__34592__34593.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__34592__34593)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__34592__34593)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n), not_found)
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n), not_found)
      }
    }else {
      return not_found
    }
  };
  nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return nth__2.call(this, coll, n);
      case 3:
        return nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  nth.cljs$lang$arity$2 = nth__2;
  nth.cljs$lang$arity$3 = nth__3;
  return nth
}();
cljs.core.get = function() {
  var get = null;
  var get__2 = function(o, k) {
    return cljs.core._lookup.call(null, o, k)
  };
  var get__3 = function(o, k, not_found) {
    return cljs.core._lookup.call(null, o, k, not_found)
  };
  get = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return get__2.call(this, o, k);
      case 3:
        return get__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get.cljs$lang$arity$2 = get__2;
  get.cljs$lang$arity$3 = get__3;
  return get
}();
cljs.core.assoc = function() {
  var assoc = null;
  var assoc__3 = function(coll, k, v) {
    return cljs.core._assoc.call(null, coll, k, v)
  };
  var assoc__4 = function() {
    var G__34597__delegate = function(coll, k, v, kvs) {
      while(true) {
        var ret__34596 = assoc.call(null, coll, k, v);
        if(cljs.core.truth_(kvs)) {
          var G__34598 = ret__34596;
          var G__34599 = cljs.core.first.call(null, kvs);
          var G__34600 = cljs.core.second.call(null, kvs);
          var G__34601 = cljs.core.nnext.call(null, kvs);
          coll = G__34598;
          k = G__34599;
          v = G__34600;
          kvs = G__34601;
          continue
        }else {
          return ret__34596
        }
        break
      }
    };
    var G__34597 = function(coll, k, v, var_args) {
      var kvs = null;
      if(goog.isDef(var_args)) {
        kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__34597__delegate.call(this, coll, k, v, kvs)
    };
    G__34597.cljs$lang$maxFixedArity = 3;
    G__34597.cljs$lang$applyTo = function(arglist__34602) {
      var coll = cljs.core.first(arglist__34602);
      var k = cljs.core.first(cljs.core.next(arglist__34602));
      var v = cljs.core.first(cljs.core.next(cljs.core.next(arglist__34602)));
      var kvs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__34602)));
      return G__34597__delegate(coll, k, v, kvs)
    };
    G__34597.cljs$lang$arity$variadic = G__34597__delegate;
    return G__34597
  }();
  assoc = function(coll, k, v, var_args) {
    var kvs = var_args;
    switch(arguments.length) {
      case 3:
        return assoc__3.call(this, coll, k, v);
      default:
        return assoc__4.cljs$lang$arity$variadic(coll, k, v, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  assoc.cljs$lang$maxFixedArity = 3;
  assoc.cljs$lang$applyTo = assoc__4.cljs$lang$applyTo;
  assoc.cljs$lang$arity$3 = assoc__3;
  assoc.cljs$lang$arity$variadic = assoc__4.cljs$lang$arity$variadic;
  return assoc
}();
cljs.core.dissoc = function() {
  var dissoc = null;
  var dissoc__1 = function(coll) {
    return coll
  };
  var dissoc__2 = function(coll, k) {
    return cljs.core._dissoc.call(null, coll, k)
  };
  var dissoc__3 = function() {
    var G__34605__delegate = function(coll, k, ks) {
      while(true) {
        var ret__34604 = dissoc.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__34606 = ret__34604;
          var G__34607 = cljs.core.first.call(null, ks);
          var G__34608 = cljs.core.next.call(null, ks);
          coll = G__34606;
          k = G__34607;
          ks = G__34608;
          continue
        }else {
          return ret__34604
        }
        break
      }
    };
    var G__34605 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__34605__delegate.call(this, coll, k, ks)
    };
    G__34605.cljs$lang$maxFixedArity = 2;
    G__34605.cljs$lang$applyTo = function(arglist__34609) {
      var coll = cljs.core.first(arglist__34609);
      var k = cljs.core.first(cljs.core.next(arglist__34609));
      var ks = cljs.core.rest(cljs.core.next(arglist__34609));
      return G__34605__delegate(coll, k, ks)
    };
    G__34605.cljs$lang$arity$variadic = G__34605__delegate;
    return G__34605
  }();
  dissoc = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return dissoc__1.call(this, coll);
      case 2:
        return dissoc__2.call(this, coll, k);
      default:
        return dissoc__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  dissoc.cljs$lang$maxFixedArity = 2;
  dissoc.cljs$lang$applyTo = dissoc__3.cljs$lang$applyTo;
  dissoc.cljs$lang$arity$1 = dissoc__1;
  dissoc.cljs$lang$arity$2 = dissoc__2;
  dissoc.cljs$lang$arity$variadic = dissoc__3.cljs$lang$arity$variadic;
  return dissoc
}();
cljs.core.with_meta = function with_meta(o, meta) {
  return cljs.core._with_meta.call(null, o, meta)
};
cljs.core.meta = function meta(o) {
  if(function() {
    var G__34613__34614 = o;
    if(G__34613__34614) {
      if(function() {
        var or__3824__auto____34615 = G__34613__34614.cljs$lang$protocol_mask$partition0$ & 131072;
        if(or__3824__auto____34615) {
          return or__3824__auto____34615
        }else {
          return G__34613__34614.cljs$core$IMeta$
        }
      }()) {
        return true
      }else {
        if(!G__34613__34614.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__34613__34614)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__34613__34614)
    }
  }()) {
    return cljs.core._meta.call(null, o)
  }else {
    return null
  }
};
cljs.core.peek = function peek(coll) {
  return cljs.core._peek.call(null, coll)
};
cljs.core.pop = function pop(coll) {
  return cljs.core._pop.call(null, coll)
};
cljs.core.disj = function() {
  var disj = null;
  var disj__1 = function(coll) {
    return coll
  };
  var disj__2 = function(coll, k) {
    return cljs.core._disjoin.call(null, coll, k)
  };
  var disj__3 = function() {
    var G__34618__delegate = function(coll, k, ks) {
      while(true) {
        var ret__34617 = disj.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__34619 = ret__34617;
          var G__34620 = cljs.core.first.call(null, ks);
          var G__34621 = cljs.core.next.call(null, ks);
          coll = G__34619;
          k = G__34620;
          ks = G__34621;
          continue
        }else {
          return ret__34617
        }
        break
      }
    };
    var G__34618 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__34618__delegate.call(this, coll, k, ks)
    };
    G__34618.cljs$lang$maxFixedArity = 2;
    G__34618.cljs$lang$applyTo = function(arglist__34622) {
      var coll = cljs.core.first(arglist__34622);
      var k = cljs.core.first(cljs.core.next(arglist__34622));
      var ks = cljs.core.rest(cljs.core.next(arglist__34622));
      return G__34618__delegate(coll, k, ks)
    };
    G__34618.cljs$lang$arity$variadic = G__34618__delegate;
    return G__34618
  }();
  disj = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return disj__1.call(this, coll);
      case 2:
        return disj__2.call(this, coll, k);
      default:
        return disj__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  disj.cljs$lang$maxFixedArity = 2;
  disj.cljs$lang$applyTo = disj__3.cljs$lang$applyTo;
  disj.cljs$lang$arity$1 = disj__1;
  disj.cljs$lang$arity$2 = disj__2;
  disj.cljs$lang$arity$variadic = disj__3.cljs$lang$arity$variadic;
  return disj
}();
cljs.core.string_hash_cache = {};
cljs.core.string_hash_cache_count = 0;
cljs.core.add_to_string_hash_cache = function add_to_string_hash_cache(k) {
  var h__34624 = goog.string.hashCode(k);
  cljs.core.string_hash_cache[k] = h__34624;
  cljs.core.string_hash_cache_count = cljs.core.string_hash_cache_count + 1;
  return h__34624
};
cljs.core.check_string_hash_cache = function check_string_hash_cache(k) {
  if(cljs.core.string_hash_cache_count > 255) {
    cljs.core.string_hash_cache = {};
    cljs.core.string_hash_cache_count = 0
  }else {
  }
  var h__34626 = cljs.core.string_hash_cache[k];
  if(!(h__34626 == null)) {
    return h__34626
  }else {
    return cljs.core.add_to_string_hash_cache.call(null, k)
  }
};
cljs.core.hash = function() {
  var hash = null;
  var hash__1 = function(o) {
    return hash.call(null, o, true)
  };
  var hash__2 = function(o, check_cache) {
    if(function() {
      var and__3822__auto____34628 = goog.isString(o);
      if(and__3822__auto____34628) {
        return check_cache
      }else {
        return and__3822__auto____34628
      }
    }()) {
      return cljs.core.check_string_hash_cache.call(null, o)
    }else {
      return cljs.core._hash.call(null, o)
    }
  };
  hash = function(o, check_cache) {
    switch(arguments.length) {
      case 1:
        return hash__1.call(this, o);
      case 2:
        return hash__2.call(this, o, check_cache)
    }
    throw"Invalid arity: " + arguments.length;
  };
  hash.cljs$lang$arity$1 = hash__1;
  hash.cljs$lang$arity$2 = hash__2;
  return hash
}();
cljs.core.empty_QMARK_ = function empty_QMARK_(coll) {
  return cljs.core.not.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.coll_QMARK_ = function coll_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__34632__34633 = x;
    if(G__34632__34633) {
      if(function() {
        var or__3824__auto____34634 = G__34632__34633.cljs$lang$protocol_mask$partition0$ & 8;
        if(or__3824__auto____34634) {
          return or__3824__auto____34634
        }else {
          return G__34632__34633.cljs$core$ICollection$
        }
      }()) {
        return true
      }else {
        if(!G__34632__34633.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__34632__34633)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__34632__34633)
    }
  }
};
cljs.core.set_QMARK_ = function set_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__34638__34639 = x;
    if(G__34638__34639) {
      if(function() {
        var or__3824__auto____34640 = G__34638__34639.cljs$lang$protocol_mask$partition0$ & 4096;
        if(or__3824__auto____34640) {
          return or__3824__auto____34640
        }else {
          return G__34638__34639.cljs$core$ISet$
        }
      }()) {
        return true
      }else {
        if(!G__34638__34639.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__34638__34639)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__34638__34639)
    }
  }
};
cljs.core.associative_QMARK_ = function associative_QMARK_(x) {
  var G__34644__34645 = x;
  if(G__34644__34645) {
    if(function() {
      var or__3824__auto____34646 = G__34644__34645.cljs$lang$protocol_mask$partition0$ & 512;
      if(or__3824__auto____34646) {
        return or__3824__auto____34646
      }else {
        return G__34644__34645.cljs$core$IAssociative$
      }
    }()) {
      return true
    }else {
      if(!G__34644__34645.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__34644__34645)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__34644__34645)
  }
};
cljs.core.sequential_QMARK_ = function sequential_QMARK_(x) {
  var G__34650__34651 = x;
  if(G__34650__34651) {
    if(function() {
      var or__3824__auto____34652 = G__34650__34651.cljs$lang$protocol_mask$partition0$ & 16777216;
      if(or__3824__auto____34652) {
        return or__3824__auto____34652
      }else {
        return G__34650__34651.cljs$core$ISequential$
      }
    }()) {
      return true
    }else {
      if(!G__34650__34651.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__34650__34651)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__34650__34651)
  }
};
cljs.core.counted_QMARK_ = function counted_QMARK_(x) {
  var G__34656__34657 = x;
  if(G__34656__34657) {
    if(function() {
      var or__3824__auto____34658 = G__34656__34657.cljs$lang$protocol_mask$partition0$ & 2;
      if(or__3824__auto____34658) {
        return or__3824__auto____34658
      }else {
        return G__34656__34657.cljs$core$ICounted$
      }
    }()) {
      return true
    }else {
      if(!G__34656__34657.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__34656__34657)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__34656__34657)
  }
};
cljs.core.indexed_QMARK_ = function indexed_QMARK_(x) {
  var G__34662__34663 = x;
  if(G__34662__34663) {
    if(function() {
      var or__3824__auto____34664 = G__34662__34663.cljs$lang$protocol_mask$partition0$ & 16;
      if(or__3824__auto____34664) {
        return or__3824__auto____34664
      }else {
        return G__34662__34663.cljs$core$IIndexed$
      }
    }()) {
      return true
    }else {
      if(!G__34662__34663.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__34662__34663)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__34662__34663)
  }
};
cljs.core.reduceable_QMARK_ = function reduceable_QMARK_(x) {
  var G__34668__34669 = x;
  if(G__34668__34669) {
    if(function() {
      var or__3824__auto____34670 = G__34668__34669.cljs$lang$protocol_mask$partition0$ & 524288;
      if(or__3824__auto____34670) {
        return or__3824__auto____34670
      }else {
        return G__34668__34669.cljs$core$IReduce$
      }
    }()) {
      return true
    }else {
      if(!G__34668__34669.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__34668__34669)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__34668__34669)
  }
};
cljs.core.map_QMARK_ = function map_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__34674__34675 = x;
    if(G__34674__34675) {
      if(function() {
        var or__3824__auto____34676 = G__34674__34675.cljs$lang$protocol_mask$partition0$ & 1024;
        if(or__3824__auto____34676) {
          return or__3824__auto____34676
        }else {
          return G__34674__34675.cljs$core$IMap$
        }
      }()) {
        return true
      }else {
        if(!G__34674__34675.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__34674__34675)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__34674__34675)
    }
  }
};
cljs.core.vector_QMARK_ = function vector_QMARK_(x) {
  var G__34680__34681 = x;
  if(G__34680__34681) {
    if(function() {
      var or__3824__auto____34682 = G__34680__34681.cljs$lang$protocol_mask$partition0$ & 16384;
      if(or__3824__auto____34682) {
        return or__3824__auto____34682
      }else {
        return G__34680__34681.cljs$core$IVector$
      }
    }()) {
      return true
    }else {
      if(!G__34680__34681.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__34680__34681)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__34680__34681)
  }
};
cljs.core.chunked_seq_QMARK_ = function chunked_seq_QMARK_(x) {
  var G__34686__34687 = x;
  if(G__34686__34687) {
    if(cljs.core.truth_(function() {
      var or__3824__auto____34688 = null;
      if(cljs.core.truth_(or__3824__auto____34688)) {
        return or__3824__auto____34688
      }else {
        return G__34686__34687.cljs$core$IChunkedSeq$
      }
    }())) {
      return true
    }else {
      if(!G__34686__34687.cljs$lang$protocol_mask$partition$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IChunkedSeq, G__34686__34687)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IChunkedSeq, G__34686__34687)
  }
};
cljs.core.js_obj = function() {
  var js_obj = null;
  var js_obj__0 = function() {
    return{}
  };
  var js_obj__1 = function() {
    var G__34689__delegate = function(keyvals) {
      return cljs.core.apply.call(null, goog.object.create, keyvals)
    };
    var G__34689 = function(var_args) {
      var keyvals = null;
      if(goog.isDef(var_args)) {
        keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__34689__delegate.call(this, keyvals)
    };
    G__34689.cljs$lang$maxFixedArity = 0;
    G__34689.cljs$lang$applyTo = function(arglist__34690) {
      var keyvals = cljs.core.seq(arglist__34690);
      return G__34689__delegate(keyvals)
    };
    G__34689.cljs$lang$arity$variadic = G__34689__delegate;
    return G__34689
  }();
  js_obj = function(var_args) {
    var keyvals = var_args;
    switch(arguments.length) {
      case 0:
        return js_obj__0.call(this);
      default:
        return js_obj__1.cljs$lang$arity$variadic(cljs.core.array_seq(arguments, 0))
    }
    throw"Invalid arity: " + arguments.length;
  };
  js_obj.cljs$lang$maxFixedArity = 0;
  js_obj.cljs$lang$applyTo = js_obj__1.cljs$lang$applyTo;
  js_obj.cljs$lang$arity$0 = js_obj__0;
  js_obj.cljs$lang$arity$variadic = js_obj__1.cljs$lang$arity$variadic;
  return js_obj
}();
cljs.core.js_keys = function js_keys(obj) {
  var keys__34692 = [];
  goog.object.forEach(obj, function(val, key, obj) {
    return keys__34692.push(key)
  });
  return keys__34692
};
cljs.core.js_delete = function js_delete(obj, key) {
  return delete obj[key]
};
cljs.core.array_copy = function array_copy(from, i, to, j, len) {
  var i__34696 = i;
  var j__34697 = j;
  var len__34698 = len;
  while(true) {
    if(len__34698 === 0) {
      return to
    }else {
      to[j__34697] = from[i__34696];
      var G__34699 = i__34696 + 1;
      var G__34700 = j__34697 + 1;
      var G__34701 = len__34698 - 1;
      i__34696 = G__34699;
      j__34697 = G__34700;
      len__34698 = G__34701;
      continue
    }
    break
  }
};
cljs.core.array_copy_downward = function array_copy_downward(from, i, to, j, len) {
  var i__34705 = i + (len - 1);
  var j__34706 = j + (len - 1);
  var len__34707 = len;
  while(true) {
    if(len__34707 === 0) {
      return to
    }else {
      to[j__34706] = from[i__34705];
      var G__34708 = i__34705 - 1;
      var G__34709 = j__34706 - 1;
      var G__34710 = len__34707 - 1;
      i__34705 = G__34708;
      j__34706 = G__34709;
      len__34707 = G__34710;
      continue
    }
    break
  }
};
cljs.core.lookup_sentinel = {};
cljs.core.false_QMARK_ = function false_QMARK_(x) {
  return x === false
};
cljs.core.true_QMARK_ = function true_QMARK_(x) {
  return x === true
};
cljs.core.undefined_QMARK_ = function undefined_QMARK_(x) {
  return void 0 === x
};
cljs.core.seq_QMARK_ = function seq_QMARK_(s) {
  if(s == null) {
    return false
  }else {
    var G__34714__34715 = s;
    if(G__34714__34715) {
      if(function() {
        var or__3824__auto____34716 = G__34714__34715.cljs$lang$protocol_mask$partition0$ & 64;
        if(or__3824__auto____34716) {
          return or__3824__auto____34716
        }else {
          return G__34714__34715.cljs$core$ISeq$
        }
      }()) {
        return true
      }else {
        if(!G__34714__34715.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__34714__34715)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__34714__34715)
    }
  }
};
cljs.core.seqable_QMARK_ = function seqable_QMARK_(s) {
  var G__34720__34721 = s;
  if(G__34720__34721) {
    if(function() {
      var or__3824__auto____34722 = G__34720__34721.cljs$lang$protocol_mask$partition0$ & 8388608;
      if(or__3824__auto____34722) {
        return or__3824__auto____34722
      }else {
        return G__34720__34721.cljs$core$ISeqable$
      }
    }()) {
      return true
    }else {
      if(!G__34720__34721.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__34720__34721)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__34720__34721)
  }
};
cljs.core.boolean$ = function boolean$(x) {
  if(cljs.core.truth_(x)) {
    return true
  }else {
    return false
  }
};
cljs.core.string_QMARK_ = function string_QMARK_(x) {
  var and__3822__auto____34725 = goog.isString(x);
  if(and__3822__auto____34725) {
    return!function() {
      var or__3824__auto____34726 = x.charAt(0) === "\ufdd0";
      if(or__3824__auto____34726) {
        return or__3824__auto____34726
      }else {
        return x.charAt(0) === "\ufdd1"
      }
    }()
  }else {
    return and__3822__auto____34725
  }
};
cljs.core.keyword_QMARK_ = function keyword_QMARK_(x) {
  var and__3822__auto____34728 = goog.isString(x);
  if(and__3822__auto____34728) {
    return x.charAt(0) === "\ufdd0"
  }else {
    return and__3822__auto____34728
  }
};
cljs.core.symbol_QMARK_ = function symbol_QMARK_(x) {
  var and__3822__auto____34730 = goog.isString(x);
  if(and__3822__auto____34730) {
    return x.charAt(0) === "\ufdd1"
  }else {
    return and__3822__auto____34730
  }
};
cljs.core.number_QMARK_ = function number_QMARK_(n) {
  return goog.isNumber(n)
};
cljs.core.fn_QMARK_ = function fn_QMARK_(f) {
  return goog.isFunction(f)
};
cljs.core.ifn_QMARK_ = function ifn_QMARK_(f) {
  var or__3824__auto____34735 = cljs.core.fn_QMARK_.call(null, f);
  if(or__3824__auto____34735) {
    return or__3824__auto____34735
  }else {
    var G__34736__34737 = f;
    if(G__34736__34737) {
      if(function() {
        var or__3824__auto____34738 = G__34736__34737.cljs$lang$protocol_mask$partition0$ & 1;
        if(or__3824__auto____34738) {
          return or__3824__auto____34738
        }else {
          return G__34736__34737.cljs$core$IFn$
        }
      }()) {
        return true
      }else {
        if(!G__34736__34737.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__34736__34737)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__34736__34737)
    }
  }
};
cljs.core.integer_QMARK_ = function integer_QMARK_(n) {
  var and__3822__auto____34740 = cljs.core.number_QMARK_.call(null, n);
  if(and__3822__auto____34740) {
    return n == n.toFixed()
  }else {
    return and__3822__auto____34740
  }
};
cljs.core.contains_QMARK_ = function contains_QMARK_(coll, v) {
  if(cljs.core._lookup.call(null, coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false
  }else {
    return true
  }
};
cljs.core.find = function find(coll, k) {
  if(cljs.core.truth_(function() {
    var and__3822__auto____34743 = coll;
    if(cljs.core.truth_(and__3822__auto____34743)) {
      var and__3822__auto____34744 = cljs.core.associative_QMARK_.call(null, coll);
      if(and__3822__auto____34744) {
        return cljs.core.contains_QMARK_.call(null, coll, k)
      }else {
        return and__3822__auto____34744
      }
    }else {
      return and__3822__auto____34743
    }
  }())) {
    return cljs.core.PersistentVector.fromArray([k, cljs.core._lookup.call(null, coll, k)], true)
  }else {
    return null
  }
};
cljs.core.distinct_QMARK_ = function() {
  var distinct_QMARK_ = null;
  var distinct_QMARK___1 = function(x) {
    return true
  };
  var distinct_QMARK___2 = function(x, y) {
    return!cljs.core._EQ_.call(null, x, y)
  };
  var distinct_QMARK___3 = function() {
    var G__34753__delegate = function(x, y, more) {
      if(!cljs.core._EQ_.call(null, x, y)) {
        var s__34749 = cljs.core.PersistentHashSet.fromArray([y, x]);
        var xs__34750 = more;
        while(true) {
          var x__34751 = cljs.core.first.call(null, xs__34750);
          var etc__34752 = cljs.core.next.call(null, xs__34750);
          if(cljs.core.truth_(xs__34750)) {
            if(cljs.core.contains_QMARK_.call(null, s__34749, x__34751)) {
              return false
            }else {
              var G__34754 = cljs.core.conj.call(null, s__34749, x__34751);
              var G__34755 = etc__34752;
              s__34749 = G__34754;
              xs__34750 = G__34755;
              continue
            }
          }else {
            return true
          }
          break
        }
      }else {
        return false
      }
    };
    var G__34753 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__34753__delegate.call(this, x, y, more)
    };
    G__34753.cljs$lang$maxFixedArity = 2;
    G__34753.cljs$lang$applyTo = function(arglist__34756) {
      var x = cljs.core.first(arglist__34756);
      var y = cljs.core.first(cljs.core.next(arglist__34756));
      var more = cljs.core.rest(cljs.core.next(arglist__34756));
      return G__34753__delegate(x, y, more)
    };
    G__34753.cljs$lang$arity$variadic = G__34753__delegate;
    return G__34753
  }();
  distinct_QMARK_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return distinct_QMARK___1.call(this, x);
      case 2:
        return distinct_QMARK___2.call(this, x, y);
      default:
        return distinct_QMARK___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  distinct_QMARK_.cljs$lang$maxFixedArity = 2;
  distinct_QMARK_.cljs$lang$applyTo = distinct_QMARK___3.cljs$lang$applyTo;
  distinct_QMARK_.cljs$lang$arity$1 = distinct_QMARK___1;
  distinct_QMARK_.cljs$lang$arity$2 = distinct_QMARK___2;
  distinct_QMARK_.cljs$lang$arity$variadic = distinct_QMARK___3.cljs$lang$arity$variadic;
  return distinct_QMARK_
}();
cljs.core.compare = function compare(x, y) {
  if(x === y) {
    return 0
  }else {
    if(x == null) {
      return-1
    }else {
      if(y == null) {
        return 1
      }else {
        if(cljs.core.type.call(null, x) === cljs.core.type.call(null, y)) {
          if(function() {
            var G__34760__34761 = x;
            if(G__34760__34761) {
              if(cljs.core.truth_(function() {
                var or__3824__auto____34762 = null;
                if(cljs.core.truth_(or__3824__auto____34762)) {
                  return or__3824__auto____34762
                }else {
                  return G__34760__34761.cljs$core$IComparable$
                }
              }())) {
                return true
              }else {
                if(!G__34760__34761.cljs$lang$protocol_mask$partition$) {
                  return cljs.core.type_satisfies_.call(null, cljs.core.IComparable, G__34760__34761)
                }else {
                  return false
                }
              }
            }else {
              return cljs.core.type_satisfies_.call(null, cljs.core.IComparable, G__34760__34761)
            }
          }()) {
            return cljs.core._compare.call(null, x, y)
          }else {
            return goog.array.defaultCompare(x, y)
          }
        }else {
          if("\ufdd0'else") {
            throw new Error("compare on non-nil objects of different types");
          }else {
            return null
          }
        }
      }
    }
  }
};
cljs.core.compare_indexed = function() {
  var compare_indexed = null;
  var compare_indexed__2 = function(xs, ys) {
    var xl__34767 = cljs.core.count.call(null, xs);
    var yl__34768 = cljs.core.count.call(null, ys);
    if(xl__34767 < yl__34768) {
      return-1
    }else {
      if(xl__34767 > yl__34768) {
        return 1
      }else {
        if("\ufdd0'else") {
          return compare_indexed.call(null, xs, ys, xl__34767, 0)
        }else {
          return null
        }
      }
    }
  };
  var compare_indexed__4 = function(xs, ys, len, n) {
    while(true) {
      var d__34769 = cljs.core.compare.call(null, cljs.core.nth.call(null, xs, n), cljs.core.nth.call(null, ys, n));
      if(function() {
        var and__3822__auto____34770 = d__34769 === 0;
        if(and__3822__auto____34770) {
          return n + 1 < len
        }else {
          return and__3822__auto____34770
        }
      }()) {
        var G__34771 = xs;
        var G__34772 = ys;
        var G__34773 = len;
        var G__34774 = n + 1;
        xs = G__34771;
        ys = G__34772;
        len = G__34773;
        n = G__34774;
        continue
      }else {
        return d__34769
      }
      break
    }
  };
  compare_indexed = function(xs, ys, len, n) {
    switch(arguments.length) {
      case 2:
        return compare_indexed__2.call(this, xs, ys);
      case 4:
        return compare_indexed__4.call(this, xs, ys, len, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  compare_indexed.cljs$lang$arity$2 = compare_indexed__2;
  compare_indexed.cljs$lang$arity$4 = compare_indexed__4;
  return compare_indexed
}();
cljs.core.fn__GT_comparator = function fn__GT_comparator(f) {
  if(cljs.core._EQ_.call(null, f, cljs.core.compare)) {
    return cljs.core.compare
  }else {
    return function(x, y) {
      var r__34776 = f.call(null, x, y);
      if(cljs.core.number_QMARK_.call(null, r__34776)) {
        return r__34776
      }else {
        if(cljs.core.truth_(r__34776)) {
          return-1
        }else {
          if(cljs.core.truth_(f.call(null, y, x))) {
            return 1
          }else {
            return 0
          }
        }
      }
    }
  }
};
cljs.core.sort = function() {
  var sort = null;
  var sort__1 = function(coll) {
    return sort.call(null, cljs.core.compare, coll)
  };
  var sort__2 = function(comp, coll) {
    if(cljs.core.seq.call(null, coll)) {
      var a__34778 = cljs.core.to_array.call(null, coll);
      goog.array.stableSort(a__34778, cljs.core.fn__GT_comparator.call(null, comp));
      return cljs.core.seq.call(null, a__34778)
    }else {
      return cljs.core.List.EMPTY
    }
  };
  sort = function(comp, coll) {
    switch(arguments.length) {
      case 1:
        return sort__1.call(this, comp);
      case 2:
        return sort__2.call(this, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort.cljs$lang$arity$1 = sort__1;
  sort.cljs$lang$arity$2 = sort__2;
  return sort
}();
cljs.core.sort_by = function() {
  var sort_by = null;
  var sort_by__2 = function(keyfn, coll) {
    return sort_by.call(null, keyfn, cljs.core.compare, coll)
  };
  var sort_by__3 = function(keyfn, comp, coll) {
    return cljs.core.sort.call(null, function(x, y) {
      return cljs.core.fn__GT_comparator.call(null, comp).call(null, keyfn.call(null, x), keyfn.call(null, y))
    }, coll)
  };
  sort_by = function(keyfn, comp, coll) {
    switch(arguments.length) {
      case 2:
        return sort_by__2.call(this, keyfn, comp);
      case 3:
        return sort_by__3.call(this, keyfn, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort_by.cljs$lang$arity$2 = sort_by__2;
  sort_by.cljs$lang$arity$3 = sort_by__3;
  return sort_by
}();
cljs.core.seq_reduce = function() {
  var seq_reduce = null;
  var seq_reduce__2 = function(f, coll) {
    var temp__3971__auto____34784 = cljs.core.seq.call(null, coll);
    if(temp__3971__auto____34784) {
      var s__34785 = temp__3971__auto____34784;
      return cljs.core.reduce.call(null, f, cljs.core.first.call(null, s__34785), cljs.core.next.call(null, s__34785))
    }else {
      return f.call(null)
    }
  };
  var seq_reduce__3 = function(f, val, coll) {
    var val__34786 = val;
    var coll__34787 = cljs.core.seq.call(null, coll);
    while(true) {
      if(coll__34787) {
        var nval__34788 = f.call(null, val__34786, cljs.core.first.call(null, coll__34787));
        if(cljs.core.reduced_QMARK_.call(null, nval__34788)) {
          return cljs.core.deref.call(null, nval__34788)
        }else {
          var G__34789 = nval__34788;
          var G__34790 = cljs.core.next.call(null, coll__34787);
          val__34786 = G__34789;
          coll__34787 = G__34790;
          continue
        }
      }else {
        return val__34786
      }
      break
    }
  };
  seq_reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return seq_reduce__2.call(this, f, val);
      case 3:
        return seq_reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  seq_reduce.cljs$lang$arity$2 = seq_reduce__2;
  seq_reduce.cljs$lang$arity$3 = seq_reduce__3;
  return seq_reduce
}();
cljs.core.shuffle = function shuffle(coll) {
  var a__34792 = cljs.core.to_array.call(null, coll);
  goog.array.shuffle(a__34792);
  return cljs.core.vec.call(null, a__34792)
};
cljs.core.reduce = function() {
  var reduce = null;
  var reduce__2 = function(f, coll) {
    if(function() {
      var G__34799__34800 = coll;
      if(G__34799__34800) {
        if(function() {
          var or__3824__auto____34801 = G__34799__34800.cljs$lang$protocol_mask$partition0$ & 524288;
          if(or__3824__auto____34801) {
            return or__3824__auto____34801
          }else {
            return G__34799__34800.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__34799__34800.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__34799__34800)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__34799__34800)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f)
    }else {
      return cljs.core.seq_reduce.call(null, f, coll)
    }
  };
  var reduce__3 = function(f, val, coll) {
    if(function() {
      var G__34802__34803 = coll;
      if(G__34802__34803) {
        if(function() {
          var or__3824__auto____34804 = G__34802__34803.cljs$lang$protocol_mask$partition0$ & 524288;
          if(or__3824__auto____34804) {
            return or__3824__auto____34804
          }else {
            return G__34802__34803.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__34802__34803.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__34802__34803)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__34802__34803)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f, val)
    }else {
      return cljs.core.seq_reduce.call(null, f, val, coll)
    }
  };
  reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return reduce__2.call(this, f, val);
      case 3:
        return reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reduce.cljs$lang$arity$2 = reduce__2;
  reduce.cljs$lang$arity$3 = reduce__3;
  return reduce
}();
cljs.core.reduce_kv = function reduce_kv(f, init, coll) {
  return cljs.core._kv_reduce.call(null, coll, f, init)
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32768
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/Reduced")
};
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var this__34805 = this;
  return this__34805.val
};
cljs.core.Reduced;
cljs.core.reduced_QMARK_ = function reduced_QMARK_(r) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Reduced, r)
};
cljs.core.reduced = function reduced(x) {
  return new cljs.core.Reduced(x)
};
cljs.core._PLUS_ = function() {
  var _PLUS_ = null;
  var _PLUS___0 = function() {
    return 0
  };
  var _PLUS___1 = function(x) {
    return x
  };
  var _PLUS___2 = function(x, y) {
    return x + y
  };
  var _PLUS___3 = function() {
    var G__34806__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _PLUS_, x + y, more)
    };
    var G__34806 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__34806__delegate.call(this, x, y, more)
    };
    G__34806.cljs$lang$maxFixedArity = 2;
    G__34806.cljs$lang$applyTo = function(arglist__34807) {
      var x = cljs.core.first(arglist__34807);
      var y = cljs.core.first(cljs.core.next(arglist__34807));
      var more = cljs.core.rest(cljs.core.next(arglist__34807));
      return G__34806__delegate(x, y, more)
    };
    G__34806.cljs$lang$arity$variadic = G__34806__delegate;
    return G__34806
  }();
  _PLUS_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _PLUS___0.call(this);
      case 1:
        return _PLUS___1.call(this, x);
      case 2:
        return _PLUS___2.call(this, x, y);
      default:
        return _PLUS___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _PLUS_.cljs$lang$maxFixedArity = 2;
  _PLUS_.cljs$lang$applyTo = _PLUS___3.cljs$lang$applyTo;
  _PLUS_.cljs$lang$arity$0 = _PLUS___0;
  _PLUS_.cljs$lang$arity$1 = _PLUS___1;
  _PLUS_.cljs$lang$arity$2 = _PLUS___2;
  _PLUS_.cljs$lang$arity$variadic = _PLUS___3.cljs$lang$arity$variadic;
  return _PLUS_
}();
cljs.core._ = function() {
  var _ = null;
  var ___1 = function(x) {
    return-x
  };
  var ___2 = function(x, y) {
    return x - y
  };
  var ___3 = function() {
    var G__34808__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _, x - y, more)
    };
    var G__34808 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__34808__delegate.call(this, x, y, more)
    };
    G__34808.cljs$lang$maxFixedArity = 2;
    G__34808.cljs$lang$applyTo = function(arglist__34809) {
      var x = cljs.core.first(arglist__34809);
      var y = cljs.core.first(cljs.core.next(arglist__34809));
      var more = cljs.core.rest(cljs.core.next(arglist__34809));
      return G__34808__delegate(x, y, more)
    };
    G__34808.cljs$lang$arity$variadic = G__34808__delegate;
    return G__34808
  }();
  _ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return ___1.call(this, x);
      case 2:
        return ___2.call(this, x, y);
      default:
        return ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _.cljs$lang$maxFixedArity = 2;
  _.cljs$lang$applyTo = ___3.cljs$lang$applyTo;
  _.cljs$lang$arity$1 = ___1;
  _.cljs$lang$arity$2 = ___2;
  _.cljs$lang$arity$variadic = ___3.cljs$lang$arity$variadic;
  return _
}();
cljs.core._STAR_ = function() {
  var _STAR_ = null;
  var _STAR___0 = function() {
    return 1
  };
  var _STAR___1 = function(x) {
    return x
  };
  var _STAR___2 = function(x, y) {
    return x * y
  };
  var _STAR___3 = function() {
    var G__34810__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _STAR_, x * y, more)
    };
    var G__34810 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__34810__delegate.call(this, x, y, more)
    };
    G__34810.cljs$lang$maxFixedArity = 2;
    G__34810.cljs$lang$applyTo = function(arglist__34811) {
      var x = cljs.core.first(arglist__34811);
      var y = cljs.core.first(cljs.core.next(arglist__34811));
      var more = cljs.core.rest(cljs.core.next(arglist__34811));
      return G__34810__delegate(x, y, more)
    };
    G__34810.cljs$lang$arity$variadic = G__34810__delegate;
    return G__34810
  }();
  _STAR_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _STAR___0.call(this);
      case 1:
        return _STAR___1.call(this, x);
      case 2:
        return _STAR___2.call(this, x, y);
      default:
        return _STAR___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _STAR_.cljs$lang$maxFixedArity = 2;
  _STAR_.cljs$lang$applyTo = _STAR___3.cljs$lang$applyTo;
  _STAR_.cljs$lang$arity$0 = _STAR___0;
  _STAR_.cljs$lang$arity$1 = _STAR___1;
  _STAR_.cljs$lang$arity$2 = _STAR___2;
  _STAR_.cljs$lang$arity$variadic = _STAR___3.cljs$lang$arity$variadic;
  return _STAR_
}();
cljs.core._SLASH_ = function() {
  var _SLASH_ = null;
  var _SLASH___1 = function(x) {
    return _SLASH_.call(null, 1, x)
  };
  var _SLASH___2 = function(x, y) {
    return x / y
  };
  var _SLASH___3 = function() {
    var G__34812__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _SLASH_, _SLASH_.call(null, x, y), more)
    };
    var G__34812 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__34812__delegate.call(this, x, y, more)
    };
    G__34812.cljs$lang$maxFixedArity = 2;
    G__34812.cljs$lang$applyTo = function(arglist__34813) {
      var x = cljs.core.first(arglist__34813);
      var y = cljs.core.first(cljs.core.next(arglist__34813));
      var more = cljs.core.rest(cljs.core.next(arglist__34813));
      return G__34812__delegate(x, y, more)
    };
    G__34812.cljs$lang$arity$variadic = G__34812__delegate;
    return G__34812
  }();
  _SLASH_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _SLASH___1.call(this, x);
      case 2:
        return _SLASH___2.call(this, x, y);
      default:
        return _SLASH___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _SLASH_.cljs$lang$maxFixedArity = 2;
  _SLASH_.cljs$lang$applyTo = _SLASH___3.cljs$lang$applyTo;
  _SLASH_.cljs$lang$arity$1 = _SLASH___1;
  _SLASH_.cljs$lang$arity$2 = _SLASH___2;
  _SLASH_.cljs$lang$arity$variadic = _SLASH___3.cljs$lang$arity$variadic;
  return _SLASH_
}();
cljs.core._LT_ = function() {
  var _LT_ = null;
  var _LT___1 = function(x) {
    return true
  };
  var _LT___2 = function(x, y) {
    return x < y
  };
  var _LT___3 = function() {
    var G__34814__delegate = function(x, y, more) {
      while(true) {
        if(x < y) {
          if(cljs.core.next.call(null, more)) {
            var G__34815 = y;
            var G__34816 = cljs.core.first.call(null, more);
            var G__34817 = cljs.core.next.call(null, more);
            x = G__34815;
            y = G__34816;
            more = G__34817;
            continue
          }else {
            return y < cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__34814 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__34814__delegate.call(this, x, y, more)
    };
    G__34814.cljs$lang$maxFixedArity = 2;
    G__34814.cljs$lang$applyTo = function(arglist__34818) {
      var x = cljs.core.first(arglist__34818);
      var y = cljs.core.first(cljs.core.next(arglist__34818));
      var more = cljs.core.rest(cljs.core.next(arglist__34818));
      return G__34814__delegate(x, y, more)
    };
    G__34814.cljs$lang$arity$variadic = G__34814__delegate;
    return G__34814
  }();
  _LT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT___1.call(this, x);
      case 2:
        return _LT___2.call(this, x, y);
      default:
        return _LT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT_.cljs$lang$maxFixedArity = 2;
  _LT_.cljs$lang$applyTo = _LT___3.cljs$lang$applyTo;
  _LT_.cljs$lang$arity$1 = _LT___1;
  _LT_.cljs$lang$arity$2 = _LT___2;
  _LT_.cljs$lang$arity$variadic = _LT___3.cljs$lang$arity$variadic;
  return _LT_
}();
cljs.core._LT__EQ_ = function() {
  var _LT__EQ_ = null;
  var _LT__EQ___1 = function(x) {
    return true
  };
  var _LT__EQ___2 = function(x, y) {
    return x <= y
  };
  var _LT__EQ___3 = function() {
    var G__34819__delegate = function(x, y, more) {
      while(true) {
        if(x <= y) {
          if(cljs.core.next.call(null, more)) {
            var G__34820 = y;
            var G__34821 = cljs.core.first.call(null, more);
            var G__34822 = cljs.core.next.call(null, more);
            x = G__34820;
            y = G__34821;
            more = G__34822;
            continue
          }else {
            return y <= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__34819 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__34819__delegate.call(this, x, y, more)
    };
    G__34819.cljs$lang$maxFixedArity = 2;
    G__34819.cljs$lang$applyTo = function(arglist__34823) {
      var x = cljs.core.first(arglist__34823);
      var y = cljs.core.first(cljs.core.next(arglist__34823));
      var more = cljs.core.rest(cljs.core.next(arglist__34823));
      return G__34819__delegate(x, y, more)
    };
    G__34819.cljs$lang$arity$variadic = G__34819__delegate;
    return G__34819
  }();
  _LT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT__EQ___1.call(this, x);
      case 2:
        return _LT__EQ___2.call(this, x, y);
      default:
        return _LT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT__EQ_.cljs$lang$maxFixedArity = 2;
  _LT__EQ_.cljs$lang$applyTo = _LT__EQ___3.cljs$lang$applyTo;
  _LT__EQ_.cljs$lang$arity$1 = _LT__EQ___1;
  _LT__EQ_.cljs$lang$arity$2 = _LT__EQ___2;
  _LT__EQ_.cljs$lang$arity$variadic = _LT__EQ___3.cljs$lang$arity$variadic;
  return _LT__EQ_
}();
cljs.core._GT_ = function() {
  var _GT_ = null;
  var _GT___1 = function(x) {
    return true
  };
  var _GT___2 = function(x, y) {
    return x > y
  };
  var _GT___3 = function() {
    var G__34824__delegate = function(x, y, more) {
      while(true) {
        if(x > y) {
          if(cljs.core.next.call(null, more)) {
            var G__34825 = y;
            var G__34826 = cljs.core.first.call(null, more);
            var G__34827 = cljs.core.next.call(null, more);
            x = G__34825;
            y = G__34826;
            more = G__34827;
            continue
          }else {
            return y > cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__34824 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__34824__delegate.call(this, x, y, more)
    };
    G__34824.cljs$lang$maxFixedArity = 2;
    G__34824.cljs$lang$applyTo = function(arglist__34828) {
      var x = cljs.core.first(arglist__34828);
      var y = cljs.core.first(cljs.core.next(arglist__34828));
      var more = cljs.core.rest(cljs.core.next(arglist__34828));
      return G__34824__delegate(x, y, more)
    };
    G__34824.cljs$lang$arity$variadic = G__34824__delegate;
    return G__34824
  }();
  _GT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT___1.call(this, x);
      case 2:
        return _GT___2.call(this, x, y);
      default:
        return _GT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT_.cljs$lang$maxFixedArity = 2;
  _GT_.cljs$lang$applyTo = _GT___3.cljs$lang$applyTo;
  _GT_.cljs$lang$arity$1 = _GT___1;
  _GT_.cljs$lang$arity$2 = _GT___2;
  _GT_.cljs$lang$arity$variadic = _GT___3.cljs$lang$arity$variadic;
  return _GT_
}();
cljs.core._GT__EQ_ = function() {
  var _GT__EQ_ = null;
  var _GT__EQ___1 = function(x) {
    return true
  };
  var _GT__EQ___2 = function(x, y) {
    return x >= y
  };
  var _GT__EQ___3 = function() {
    var G__34829__delegate = function(x, y, more) {
      while(true) {
        if(x >= y) {
          if(cljs.core.next.call(null, more)) {
            var G__34830 = y;
            var G__34831 = cljs.core.first.call(null, more);
            var G__34832 = cljs.core.next.call(null, more);
            x = G__34830;
            y = G__34831;
            more = G__34832;
            continue
          }else {
            return y >= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__34829 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__34829__delegate.call(this, x, y, more)
    };
    G__34829.cljs$lang$maxFixedArity = 2;
    G__34829.cljs$lang$applyTo = function(arglist__34833) {
      var x = cljs.core.first(arglist__34833);
      var y = cljs.core.first(cljs.core.next(arglist__34833));
      var more = cljs.core.rest(cljs.core.next(arglist__34833));
      return G__34829__delegate(x, y, more)
    };
    G__34829.cljs$lang$arity$variadic = G__34829__delegate;
    return G__34829
  }();
  _GT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT__EQ___1.call(this, x);
      case 2:
        return _GT__EQ___2.call(this, x, y);
      default:
        return _GT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT__EQ_.cljs$lang$maxFixedArity = 2;
  _GT__EQ_.cljs$lang$applyTo = _GT__EQ___3.cljs$lang$applyTo;
  _GT__EQ_.cljs$lang$arity$1 = _GT__EQ___1;
  _GT__EQ_.cljs$lang$arity$2 = _GT__EQ___2;
  _GT__EQ_.cljs$lang$arity$variadic = _GT__EQ___3.cljs$lang$arity$variadic;
  return _GT__EQ_
}();
cljs.core.dec = function dec(x) {
  return x - 1
};
cljs.core.max = function() {
  var max = null;
  var max__1 = function(x) {
    return x
  };
  var max__2 = function(x, y) {
    return x > y ? x : y
  };
  var max__3 = function() {
    var G__34834__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, max, x > y ? x : y, more)
    };
    var G__34834 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__34834__delegate.call(this, x, y, more)
    };
    G__34834.cljs$lang$maxFixedArity = 2;
    G__34834.cljs$lang$applyTo = function(arglist__34835) {
      var x = cljs.core.first(arglist__34835);
      var y = cljs.core.first(cljs.core.next(arglist__34835));
      var more = cljs.core.rest(cljs.core.next(arglist__34835));
      return G__34834__delegate(x, y, more)
    };
    G__34834.cljs$lang$arity$variadic = G__34834__delegate;
    return G__34834
  }();
  max = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return max__1.call(this, x);
      case 2:
        return max__2.call(this, x, y);
      default:
        return max__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max.cljs$lang$maxFixedArity = 2;
  max.cljs$lang$applyTo = max__3.cljs$lang$applyTo;
  max.cljs$lang$arity$1 = max__1;
  max.cljs$lang$arity$2 = max__2;
  max.cljs$lang$arity$variadic = max__3.cljs$lang$arity$variadic;
  return max
}();
cljs.core.min = function() {
  var min = null;
  var min__1 = function(x) {
    return x
  };
  var min__2 = function(x, y) {
    return x < y ? x : y
  };
  var min__3 = function() {
    var G__34836__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, min, x < y ? x : y, more)
    };
    var G__34836 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__34836__delegate.call(this, x, y, more)
    };
    G__34836.cljs$lang$maxFixedArity = 2;
    G__34836.cljs$lang$applyTo = function(arglist__34837) {
      var x = cljs.core.first(arglist__34837);
      var y = cljs.core.first(cljs.core.next(arglist__34837));
      var more = cljs.core.rest(cljs.core.next(arglist__34837));
      return G__34836__delegate(x, y, more)
    };
    G__34836.cljs$lang$arity$variadic = G__34836__delegate;
    return G__34836
  }();
  min = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return min__1.call(this, x);
      case 2:
        return min__2.call(this, x, y);
      default:
        return min__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min.cljs$lang$maxFixedArity = 2;
  min.cljs$lang$applyTo = min__3.cljs$lang$applyTo;
  min.cljs$lang$arity$1 = min__1;
  min.cljs$lang$arity$2 = min__2;
  min.cljs$lang$arity$variadic = min__3.cljs$lang$arity$variadic;
  return min
}();
cljs.core.fix = function fix(q) {
  if(q >= 0) {
    return Math.floor.call(null, q)
  }else {
    return Math.ceil.call(null, q)
  }
};
cljs.core.int$ = function int$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.long$ = function long$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.mod = function mod(n, d) {
  return n % d
};
cljs.core.quot = function quot(n, d) {
  var rem__34839 = n % d;
  return cljs.core.fix.call(null, (n - rem__34839) / d)
};
cljs.core.rem = function rem(n, d) {
  var q__34841 = cljs.core.quot.call(null, n, d);
  return n - d * q__34841
};
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return Math.random.call(null)
  };
  var rand__1 = function(n) {
    return n * rand.call(null)
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return cljs.core.fix.call(null, cljs.core.rand.call(null, n))
};
cljs.core.bit_xor = function bit_xor(x, y) {
  return x ^ y
};
cljs.core.bit_and = function bit_and(x, y) {
  return x & y
};
cljs.core.bit_or = function bit_or(x, y) {
  return x | y
};
cljs.core.bit_and_not = function bit_and_not(x, y) {
  return x & ~y
};
cljs.core.bit_clear = function bit_clear(x, n) {
  return x & ~(1 << n)
};
cljs.core.bit_flip = function bit_flip(x, n) {
  return x ^ 1 << n
};
cljs.core.bit_not = function bit_not(x) {
  return~x
};
cljs.core.bit_set = function bit_set(x, n) {
  return x | 1 << n
};
cljs.core.bit_test = function bit_test(x, n) {
  return(x & 1 << n) != 0
};
cljs.core.bit_shift_left = function bit_shift_left(x, n) {
  return x << n
};
cljs.core.bit_shift_right = function bit_shift_right(x, n) {
  return x >> n
};
cljs.core.bit_shift_right_zero_fill = function bit_shift_right_zero_fill(x, n) {
  return x >>> n
};
cljs.core.bit_count = function bit_count(v) {
  var v__34844 = v - (v >> 1 & 1431655765);
  var v__34845 = (v__34844 & 858993459) + (v__34844 >> 2 & 858993459);
  return(v__34845 + (v__34845 >> 4) & 252645135) * 16843009 >> 24
};
cljs.core._EQ__EQ_ = function() {
  var _EQ__EQ_ = null;
  var _EQ__EQ___1 = function(x) {
    return true
  };
  var _EQ__EQ___2 = function(x, y) {
    return cljs.core._equiv.call(null, x, y)
  };
  var _EQ__EQ___3 = function() {
    var G__34846__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ__EQ_.call(null, x, y))) {
          if(cljs.core.next.call(null, more)) {
            var G__34847 = y;
            var G__34848 = cljs.core.first.call(null, more);
            var G__34849 = cljs.core.next.call(null, more);
            x = G__34847;
            y = G__34848;
            more = G__34849;
            continue
          }else {
            return _EQ__EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__34846 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__34846__delegate.call(this, x, y, more)
    };
    G__34846.cljs$lang$maxFixedArity = 2;
    G__34846.cljs$lang$applyTo = function(arglist__34850) {
      var x = cljs.core.first(arglist__34850);
      var y = cljs.core.first(cljs.core.next(arglist__34850));
      var more = cljs.core.rest(cljs.core.next(arglist__34850));
      return G__34846__delegate(x, y, more)
    };
    G__34846.cljs$lang$arity$variadic = G__34846__delegate;
    return G__34846
  }();
  _EQ__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ__EQ___1.call(this, x);
      case 2:
        return _EQ__EQ___2.call(this, x, y);
      default:
        return _EQ__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ__EQ_.cljs$lang$maxFixedArity = 2;
  _EQ__EQ_.cljs$lang$applyTo = _EQ__EQ___3.cljs$lang$applyTo;
  _EQ__EQ_.cljs$lang$arity$1 = _EQ__EQ___1;
  _EQ__EQ_.cljs$lang$arity$2 = _EQ__EQ___2;
  _EQ__EQ_.cljs$lang$arity$variadic = _EQ__EQ___3.cljs$lang$arity$variadic;
  return _EQ__EQ_
}();
cljs.core.pos_QMARK_ = function pos_QMARK_(n) {
  return n > 0
};
cljs.core.zero_QMARK_ = function zero_QMARK_(n) {
  return n === 0
};
cljs.core.neg_QMARK_ = function neg_QMARK_(x) {
  return x < 0
};
cljs.core.nthnext = function nthnext(coll, n) {
  var n__34854 = n;
  var xs__34855 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3822__auto____34856 = xs__34855;
      if(and__3822__auto____34856) {
        return n__34854 > 0
      }else {
        return and__3822__auto____34856
      }
    }())) {
      var G__34857 = n__34854 - 1;
      var G__34858 = cljs.core.next.call(null, xs__34855);
      n__34854 = G__34857;
      xs__34855 = G__34858;
      continue
    }else {
      return xs__34855
    }
    break
  }
};
cljs.core.str_STAR_ = function() {
  var str_STAR_ = null;
  var str_STAR___0 = function() {
    return""
  };
  var str_STAR___1 = function(x) {
    if(x == null) {
      return""
    }else {
      if("\ufdd0'else") {
        return x.toString()
      }else {
        return null
      }
    }
  };
  var str_STAR___2 = function() {
    var G__34859__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__34860 = sb.append(str_STAR_.call(null, cljs.core.first.call(null, more)));
            var G__34861 = cljs.core.next.call(null, more);
            sb = G__34860;
            more = G__34861;
            continue
          }else {
            return str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str_STAR_.call(null, x)), ys)
    };
    var G__34859 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__34859__delegate.call(this, x, ys)
    };
    G__34859.cljs$lang$maxFixedArity = 1;
    G__34859.cljs$lang$applyTo = function(arglist__34862) {
      var x = cljs.core.first(arglist__34862);
      var ys = cljs.core.rest(arglist__34862);
      return G__34859__delegate(x, ys)
    };
    G__34859.cljs$lang$arity$variadic = G__34859__delegate;
    return G__34859
  }();
  str_STAR_ = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str_STAR___0.call(this);
      case 1:
        return str_STAR___1.call(this, x);
      default:
        return str_STAR___2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str_STAR_.cljs$lang$maxFixedArity = 1;
  str_STAR_.cljs$lang$applyTo = str_STAR___2.cljs$lang$applyTo;
  str_STAR_.cljs$lang$arity$0 = str_STAR___0;
  str_STAR_.cljs$lang$arity$1 = str_STAR___1;
  str_STAR_.cljs$lang$arity$variadic = str_STAR___2.cljs$lang$arity$variadic;
  return str_STAR_
}();
cljs.core.str = function() {
  var str = null;
  var str__0 = function() {
    return""
  };
  var str__1 = function(x) {
    if(cljs.core.symbol_QMARK_.call(null, x)) {
      return x.substring(2, x.length)
    }else {
      if(cljs.core.keyword_QMARK_.call(null, x)) {
        return cljs.core.str_STAR_.call(null, ":", x.substring(2, x.length))
      }else {
        if(x == null) {
          return""
        }else {
          if("\ufdd0'else") {
            return x.toString()
          }else {
            return null
          }
        }
      }
    }
  };
  var str__2 = function() {
    var G__34863__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__34864 = sb.append(str.call(null, cljs.core.first.call(null, more)));
            var G__34865 = cljs.core.next.call(null, more);
            sb = G__34864;
            more = G__34865;
            continue
          }else {
            return cljs.core.str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str.call(null, x)), ys)
    };
    var G__34863 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__34863__delegate.call(this, x, ys)
    };
    G__34863.cljs$lang$maxFixedArity = 1;
    G__34863.cljs$lang$applyTo = function(arglist__34866) {
      var x = cljs.core.first(arglist__34866);
      var ys = cljs.core.rest(arglist__34866);
      return G__34863__delegate(x, ys)
    };
    G__34863.cljs$lang$arity$variadic = G__34863__delegate;
    return G__34863
  }();
  str = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str__0.call(this);
      case 1:
        return str__1.call(this, x);
      default:
        return str__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str.cljs$lang$maxFixedArity = 1;
  str.cljs$lang$applyTo = str__2.cljs$lang$applyTo;
  str.cljs$lang$arity$0 = str__0;
  str.cljs$lang$arity$1 = str__1;
  str.cljs$lang$arity$variadic = str__2.cljs$lang$arity$variadic;
  return str
}();
cljs.core.subs = function() {
  var subs = null;
  var subs__2 = function(s, start) {
    return s.substring(start)
  };
  var subs__3 = function(s, start, end) {
    return s.substring(start, end)
  };
  subs = function(s, start, end) {
    switch(arguments.length) {
      case 2:
        return subs__2.call(this, s, start);
      case 3:
        return subs__3.call(this, s, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subs.cljs$lang$arity$2 = subs__2;
  subs.cljs$lang$arity$3 = subs__3;
  return subs
}();
cljs.core.format = function() {
  var format__delegate = function(fmt, args) {
    return cljs.core.apply.call(null, goog.string.format, fmt, args)
  };
  var format = function(fmt, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return format__delegate.call(this, fmt, args)
  };
  format.cljs$lang$maxFixedArity = 1;
  format.cljs$lang$applyTo = function(arglist__34867) {
    var fmt = cljs.core.first(arglist__34867);
    var args = cljs.core.rest(arglist__34867);
    return format__delegate(fmt, args)
  };
  format.cljs$lang$arity$variadic = format__delegate;
  return format
}();
cljs.core.symbol = function() {
  var symbol = null;
  var symbol__1 = function(name) {
    if(cljs.core.symbol_QMARK_.call(null, name)) {
      name
    }else {
      if(cljs.core.keyword_QMARK_.call(null, name)) {
        cljs.core.str_STAR_.call(null, "\ufdd1", "'", cljs.core.subs.call(null, name, 2))
      }else {
      }
    }
    return cljs.core.str_STAR_.call(null, "\ufdd1", "'", name)
  };
  var symbol__2 = function(ns, name) {
    return symbol.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  symbol = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return symbol__1.call(this, ns);
      case 2:
        return symbol__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  symbol.cljs$lang$arity$1 = symbol__1;
  symbol.cljs$lang$arity$2 = symbol__2;
  return symbol
}();
cljs.core.keyword = function() {
  var keyword = null;
  var keyword__1 = function(name) {
    if(cljs.core.keyword_QMARK_.call(null, name)) {
      return name
    }else {
      if(cljs.core.symbol_QMARK_.call(null, name)) {
        return cljs.core.str_STAR_.call(null, "\ufdd0", "'", cljs.core.subs.call(null, name, 2))
      }else {
        if("\ufdd0'else") {
          return cljs.core.str_STAR_.call(null, "\ufdd0", "'", name)
        }else {
          return null
        }
      }
    }
  };
  var keyword__2 = function(ns, name) {
    return keyword.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  keyword = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return keyword__1.call(this, ns);
      case 2:
        return keyword__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  keyword.cljs$lang$arity$1 = keyword__1;
  keyword.cljs$lang$arity$2 = keyword__2;
  return keyword
}();
cljs.core.equiv_sequential = function equiv_sequential(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.sequential_QMARK_.call(null, y) ? function() {
    var xs__34870 = cljs.core.seq.call(null, x);
    var ys__34871 = cljs.core.seq.call(null, y);
    while(true) {
      if(xs__34870 == null) {
        return ys__34871 == null
      }else {
        if(ys__34871 == null) {
          return false
        }else {
          if(cljs.core._EQ_.call(null, cljs.core.first.call(null, xs__34870), cljs.core.first.call(null, ys__34871))) {
            var G__34872 = cljs.core.next.call(null, xs__34870);
            var G__34873 = cljs.core.next.call(null, ys__34871);
            xs__34870 = G__34872;
            ys__34871 = G__34873;
            continue
          }else {
            if("\ufdd0'else") {
              return false
            }else {
              return null
            }
          }
        }
      }
      break
    }
  }() : null)
};
cljs.core.hash_combine = function hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2)
};
cljs.core.hash_coll = function hash_coll(coll) {
  return cljs.core.reduce.call(null, function(p1__34874_SHARP_, p2__34875_SHARP_) {
    return cljs.core.hash_combine.call(null, p1__34874_SHARP_, cljs.core.hash.call(null, p2__34875_SHARP_, false))
  }, cljs.core.hash.call(null, cljs.core.first.call(null, coll), false), cljs.core.next.call(null, coll))
};
cljs.core.hash_imap = function hash_imap(m) {
  var h__34879 = 0;
  var s__34880 = cljs.core.seq.call(null, m);
  while(true) {
    if(s__34880) {
      var e__34881 = cljs.core.first.call(null, s__34880);
      var G__34882 = (h__34879 + (cljs.core.hash.call(null, cljs.core.key.call(null, e__34881)) ^ cljs.core.hash.call(null, cljs.core.val.call(null, e__34881)))) % 4503599627370496;
      var G__34883 = cljs.core.next.call(null, s__34880);
      h__34879 = G__34882;
      s__34880 = G__34883;
      continue
    }else {
      return h__34879
    }
    break
  }
};
cljs.core.hash_iset = function hash_iset(s) {
  var h__34887 = 0;
  var s__34888 = cljs.core.seq.call(null, s);
  while(true) {
    if(s__34888) {
      var e__34889 = cljs.core.first.call(null, s__34888);
      var G__34890 = (h__34887 + cljs.core.hash.call(null, e__34889)) % 4503599627370496;
      var G__34891 = cljs.core.next.call(null, s__34888);
      h__34887 = G__34890;
      s__34888 = G__34891;
      continue
    }else {
      return h__34887
    }
    break
  }
};
cljs.core.extend_object_BANG_ = function extend_object_BANG_(obj, fn_map) {
  var G__34912__34913 = cljs.core.seq.call(null, fn_map);
  if(G__34912__34913) {
    var G__34915__34917 = cljs.core.first.call(null, G__34912__34913);
    var vec__34916__34918 = G__34915__34917;
    var key_name__34919 = cljs.core.nth.call(null, vec__34916__34918, 0, null);
    var f__34920 = cljs.core.nth.call(null, vec__34916__34918, 1, null);
    var G__34912__34921 = G__34912__34913;
    var G__34915__34922 = G__34915__34917;
    var G__34912__34923 = G__34912__34921;
    while(true) {
      var vec__34924__34925 = G__34915__34922;
      var key_name__34926 = cljs.core.nth.call(null, vec__34924__34925, 0, null);
      var f__34927 = cljs.core.nth.call(null, vec__34924__34925, 1, null);
      var G__34912__34928 = G__34912__34923;
      var str_name__34929 = cljs.core.name.call(null, key_name__34926);
      obj[str_name__34929] = f__34927;
      var temp__3974__auto____34930 = cljs.core.next.call(null, G__34912__34928);
      if(temp__3974__auto____34930) {
        var G__34912__34931 = temp__3974__auto____34930;
        var G__34932 = cljs.core.first.call(null, G__34912__34931);
        var G__34933 = G__34912__34931;
        G__34915__34922 = G__34932;
        G__34912__34923 = G__34933;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return obj
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 65413358
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/List")
};
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__34934 = this;
  var h__2192__auto____34935 = this__34934.__hash;
  if(!(h__2192__auto____34935 == null)) {
    return h__2192__auto____34935
  }else {
    var h__2192__auto____34936 = cljs.core.hash_coll.call(null, coll);
    this__34934.__hash = h__2192__auto____34936;
    return h__2192__auto____34936
  }
};
cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var this__34937 = this;
  if(this__34937.count === 1) {
    return null
  }else {
    return this__34937.rest
  }
};
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__34938 = this;
  return new cljs.core.List(this__34938.meta, o, coll, this__34938.count + 1, null)
};
cljs.core.List.prototype.toString = function() {
  var this__34939 = this;
  var this__34940 = this;
  return cljs.core.pr_str.call(null, this__34940)
};
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__34941 = this;
  return coll
};
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__34942 = this;
  return this__34942.count
};
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__34943 = this;
  return this__34943.first
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__34944 = this;
  return coll.cljs$core$ISeq$_rest$arity$1(coll)
};
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__34945 = this;
  return this__34945.first
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__34946 = this;
  if(this__34946.count === 1) {
    return cljs.core.List.EMPTY
  }else {
    return this__34946.rest
  }
};
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__34947 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__34948 = this;
  return new cljs.core.List(meta, this__34948.first, this__34948.rest, this__34948.count, this__34948.__hash)
};
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__34949 = this;
  return this__34949.meta
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__34950 = this;
  return cljs.core.List.EMPTY
};
cljs.core.List;
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 65413326
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/EmptyList")
};
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__34951 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var this__34952 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__34953 = this;
  return new cljs.core.List(this__34953.meta, o, null, 1, null)
};
cljs.core.EmptyList.prototype.toString = function() {
  var this__34954 = this;
  var this__34955 = this;
  return cljs.core.pr_str.call(null, this__34955)
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__34956 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__34957 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__34958 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__34959 = this;
  throw new Error("Can't pop empty list");
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__34960 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__34961 = this;
  return cljs.core.List.EMPTY
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__34962 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__34963 = this;
  return new cljs.core.EmptyList(meta)
};
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__34964 = this;
  return this__34964.meta
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__34965 = this;
  return coll
};
cljs.core.EmptyList;
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.reversible_QMARK_ = function reversible_QMARK_(coll) {
  var G__34969__34970 = coll;
  if(G__34969__34970) {
    if(function() {
      var or__3824__auto____34971 = G__34969__34970.cljs$lang$protocol_mask$partition0$ & 134217728;
      if(or__3824__auto____34971) {
        return or__3824__auto____34971
      }else {
        return G__34969__34970.cljs$core$IReversible$
      }
    }()) {
      return true
    }else {
      if(!G__34969__34970.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__34969__34970)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__34969__34970)
  }
};
cljs.core.rseq = function rseq(coll) {
  return cljs.core._rseq.call(null, coll)
};
cljs.core.reverse = function reverse(coll) {
  if(cljs.core.reversible_QMARK_.call(null, coll)) {
    return cljs.core.rseq.call(null, coll)
  }else {
    return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
  }
};
cljs.core.list = function() {
  var list = null;
  var list__0 = function() {
    return cljs.core.List.EMPTY
  };
  var list__1 = function(x) {
    return cljs.core.conj.call(null, cljs.core.List.EMPTY, x)
  };
  var list__2 = function(x, y) {
    return cljs.core.conj.call(null, list.call(null, y), x)
  };
  var list__3 = function(x, y, z) {
    return cljs.core.conj.call(null, list.call(null, y, z), x)
  };
  var list__4 = function() {
    var G__34972__delegate = function(x, y, z, items) {
      return cljs.core.conj.call(null, cljs.core.conj.call(null, cljs.core.conj.call(null, cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, cljs.core.reverse.call(null, items)), z), y), x)
    };
    var G__34972 = function(x, y, z, var_args) {
      var items = null;
      if(goog.isDef(var_args)) {
        items = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__34972__delegate.call(this, x, y, z, items)
    };
    G__34972.cljs$lang$maxFixedArity = 3;
    G__34972.cljs$lang$applyTo = function(arglist__34973) {
      var x = cljs.core.first(arglist__34973);
      var y = cljs.core.first(cljs.core.next(arglist__34973));
      var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__34973)));
      var items = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__34973)));
      return G__34972__delegate(x, y, z, items)
    };
    G__34972.cljs$lang$arity$variadic = G__34972__delegate;
    return G__34972
  }();
  list = function(x, y, z, var_args) {
    var items = var_args;
    switch(arguments.length) {
      case 0:
        return list__0.call(this);
      case 1:
        return list__1.call(this, x);
      case 2:
        return list__2.call(this, x, y);
      case 3:
        return list__3.call(this, x, y, z);
      default:
        return list__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  list.cljs$lang$maxFixedArity = 3;
  list.cljs$lang$applyTo = list__4.cljs$lang$applyTo;
  list.cljs$lang$arity$0 = list__0;
  list.cljs$lang$arity$1 = list__1;
  list.cljs$lang$arity$2 = list__2;
  list.cljs$lang$arity$3 = list__3;
  list.cljs$lang$arity$variadic = list__4.cljs$lang$arity$variadic;
  return list
}();
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 65405164
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/Cons")
};
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__34974 = this;
  var h__2192__auto____34975 = this__34974.__hash;
  if(!(h__2192__auto____34975 == null)) {
    return h__2192__auto____34975
  }else {
    var h__2192__auto____34976 = cljs.core.hash_coll.call(null, coll);
    this__34974.__hash = h__2192__auto____34976;
    return h__2192__auto____34976
  }
};
cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var this__34977 = this;
  if(this__34977.rest == null) {
    return null
  }else {
    return cljs.core._seq.call(null, this__34977.rest)
  }
};
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__34978 = this;
  return new cljs.core.Cons(null, o, coll, this__34978.__hash)
};
cljs.core.Cons.prototype.toString = function() {
  var this__34979 = this;
  var this__34980 = this;
  return cljs.core.pr_str.call(null, this__34980)
};
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__34981 = this;
  return coll
};
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__34982 = this;
  return this__34982.first
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__34983 = this;
  if(this__34983.rest == null) {
    return cljs.core.List.EMPTY
  }else {
    return this__34983.rest
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__34984 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__34985 = this;
  return new cljs.core.Cons(meta, this__34985.first, this__34985.rest, this__34985.__hash)
};
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__34986 = this;
  return this__34986.meta
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__34987 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__34987.meta)
};
cljs.core.Cons;
cljs.core.cons = function cons(x, coll) {
  if(function() {
    var or__3824__auto____34992 = coll == null;
    if(or__3824__auto____34992) {
      return or__3824__auto____34992
    }else {
      var G__34993__34994 = coll;
      if(G__34993__34994) {
        if(function() {
          var or__3824__auto____34995 = G__34993__34994.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3824__auto____34995) {
            return or__3824__auto____34995
          }else {
            return G__34993__34994.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__34993__34994.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__34993__34994)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__34993__34994)
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null)
  }else {
    return new cljs.core.Cons(null, x, cljs.core.seq.call(null, coll), null)
  }
};
cljs.core.list_QMARK_ = function list_QMARK_(x) {
  var G__34999__35000 = x;
  if(G__34999__35000) {
    if(function() {
      var or__3824__auto____35001 = G__34999__35000.cljs$lang$protocol_mask$partition0$ & 33554432;
      if(or__3824__auto____35001) {
        return or__3824__auto____35001
      }else {
        return G__34999__35000.cljs$core$IList$
      }
    }()) {
      return true
    }else {
      if(!G__34999__35000.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__34999__35000)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__34999__35000)
  }
};
cljs.core.IReduce["string"] = true;
cljs.core._reduce["string"] = function() {
  var G__35002 = null;
  var G__35002__2 = function(string, f) {
    return cljs.core.ci_reduce.call(null, string, f)
  };
  var G__35002__3 = function(string, f, start) {
    return cljs.core.ci_reduce.call(null, string, f, start)
  };
  G__35002 = function(string, f, start) {
    switch(arguments.length) {
      case 2:
        return G__35002__2.call(this, string, f);
      case 3:
        return G__35002__3.call(this, string, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__35002
}();
cljs.core.ILookup["string"] = true;
cljs.core._lookup["string"] = function() {
  var G__35003 = null;
  var G__35003__2 = function(string, k) {
    return cljs.core._nth.call(null, string, k)
  };
  var G__35003__3 = function(string, k, not_found) {
    return cljs.core._nth.call(null, string, k, not_found)
  };
  G__35003 = function(string, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__35003__2.call(this, string, k);
      case 3:
        return G__35003__3.call(this, string, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__35003
}();
cljs.core.IIndexed["string"] = true;
cljs.core._nth["string"] = function() {
  var G__35004 = null;
  var G__35004__2 = function(string, n) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return null
    }
  };
  var G__35004__3 = function(string, n, not_found) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return not_found
    }
  };
  G__35004 = function(string, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__35004__2.call(this, string, n);
      case 3:
        return G__35004__3.call(this, string, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__35004
}();
cljs.core.ICounted["string"] = true;
cljs.core._count["string"] = function(s) {
  return s.length
};
cljs.core.ISeqable["string"] = true;
cljs.core._seq["string"] = function(string) {
  return cljs.core.prim_seq.call(null, string, 0)
};
cljs.core.IHash["string"] = true;
cljs.core._hash["string"] = function(o) {
  return goog.string.hashCode(o)
};
cljs.core.Keyword = function(k) {
  this.k = k;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1
};
cljs.core.Keyword.cljs$lang$type = true;
cljs.core.Keyword.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/Keyword")
};
cljs.core.Keyword.prototype.call = function() {
  var G__35016 = null;
  var G__35016__2 = function(this_sym35007, coll) {
    var this__35009 = this;
    var this_sym35007__35010 = this;
    var ___35011 = this_sym35007__35010;
    if(coll == null) {
      return null
    }else {
      var strobj__35012 = coll.strobj;
      if(strobj__35012 == null) {
        return cljs.core._lookup.call(null, coll, this__35009.k, null)
      }else {
        return strobj__35012[this__35009.k]
      }
    }
  };
  var G__35016__3 = function(this_sym35008, coll, not_found) {
    var this__35009 = this;
    var this_sym35008__35013 = this;
    var ___35014 = this_sym35008__35013;
    if(coll == null) {
      return not_found
    }else {
      return cljs.core._lookup.call(null, coll, this__35009.k, not_found)
    }
  };
  G__35016 = function(this_sym35008, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__35016__2.call(this, this_sym35008, coll);
      case 3:
        return G__35016__3.call(this, this_sym35008, coll, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__35016
}();
cljs.core.Keyword.prototype.apply = function(this_sym35005, args35006) {
  var this__35015 = this;
  return this_sym35005.call.apply(this_sym35005, [this_sym35005].concat(args35006.slice()))
};
cljs.core.Keyword;
String.prototype.cljs$core$IFn$ = true;
String.prototype.call = function() {
  var G__35025 = null;
  var G__35025__2 = function(this_sym35019, coll) {
    var this_sym35019__35021 = this;
    var this__35022 = this_sym35019__35021;
    return cljs.core._lookup.call(null, coll, this__35022.toString(), null)
  };
  var G__35025__3 = function(this_sym35020, coll, not_found) {
    var this_sym35020__35023 = this;
    var this__35024 = this_sym35020__35023;
    return cljs.core._lookup.call(null, coll, this__35024.toString(), not_found)
  };
  G__35025 = function(this_sym35020, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__35025__2.call(this, this_sym35020, coll);
      case 3:
        return G__35025__3.call(this, this_sym35020, coll, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__35025
}();
String.prototype.apply = function(this_sym35017, args35018) {
  return this_sym35017.call.apply(this_sym35017, [this_sym35017].concat(args35018.slice()))
};
String.prototype.apply = function(s, args) {
  if(cljs.core.count.call(null, args) < 2) {
    return cljs.core._lookup.call(null, args[0], s, null)
  }else {
    return cljs.core._lookup.call(null, args[0], s, args[1])
  }
};
cljs.core.lazy_seq_value = function lazy_seq_value(lazy_seq) {
  var x__35027 = lazy_seq.x;
  if(lazy_seq.realized) {
    return x__35027
  }else {
    lazy_seq.x = x__35027.call(null);
    lazy_seq.realized = true;
    return lazy_seq.x
  }
};
cljs.core.LazySeq = function(meta, realized, x, __hash) {
  this.meta = meta;
  this.realized = realized;
  this.x = x;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31850700
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/LazySeq")
};
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__35028 = this;
  var h__2192__auto____35029 = this__35028.__hash;
  if(!(h__2192__auto____35029 == null)) {
    return h__2192__auto____35029
  }else {
    var h__2192__auto____35030 = cljs.core.hash_coll.call(null, coll);
    this__35028.__hash = h__2192__auto____35030;
    return h__2192__auto____35030
  }
};
cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var this__35031 = this;
  return cljs.core._seq.call(null, coll.cljs$core$ISeq$_rest$arity$1(coll))
};
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__35032 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.LazySeq.prototype.toString = function() {
  var this__35033 = this;
  var this__35034 = this;
  return cljs.core.pr_str.call(null, this__35034)
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__35035 = this;
  return cljs.core.seq.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__35036 = this;
  return cljs.core.first.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__35037 = this;
  return cljs.core.rest.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__35038 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__35039 = this;
  return new cljs.core.LazySeq(meta, this__35039.realized, this__35039.x, this__35039.__hash)
};
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__35040 = this;
  return this__35040.meta
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__35041 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__35041.meta)
};
cljs.core.LazySeq;
cljs.core.ChunkBuffer = function(buf, end) {
  this.buf = buf;
  this.end = end;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2
};
cljs.core.ChunkBuffer.cljs$lang$type = true;
cljs.core.ChunkBuffer.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/ChunkBuffer")
};
cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var this__35042 = this;
  return this__35042.end
};
cljs.core.ChunkBuffer.prototype.add = function(o) {
  var this__35043 = this;
  var ___35044 = this;
  this__35043.buf[this__35043.end] = o;
  return this__35043.end = this__35043.end + 1
};
cljs.core.ChunkBuffer.prototype.chunk = function(o) {
  var this__35045 = this;
  var ___35046 = this;
  var ret__35047 = new cljs.core.ArrayChunk(this__35045.buf, 0, this__35045.end);
  this__35045.buf = null;
  return ret__35047
};
cljs.core.ChunkBuffer;
cljs.core.chunk_buffer = function chunk_buffer(capacity) {
  return new cljs.core.ChunkBuffer(cljs.core.make_array.call(null, capacity), 0)
};
cljs.core.ArrayChunk = function(arr, off, end) {
  this.arr = arr;
  this.off = off;
  this.end = end;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 524306
};
cljs.core.ArrayChunk.cljs$lang$type = true;
cljs.core.ArrayChunk.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/ArrayChunk")
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__35048 = this;
  return cljs.core.ci_reduce.call(null, coll, f, this__35048.arr[this__35048.off], this__35048.off + 1)
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__35049 = this;
  return cljs.core.ci_reduce.call(null, coll, f, start, this__35049.off)
};
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = function(coll) {
  var this__35050 = this;
  if(this__35050.off === this__35050.end) {
    throw new Error("-drop-first of empty chunk");
  }else {
    return new cljs.core.ArrayChunk(this__35050.arr, this__35050.off + 1, this__35050.end)
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, i) {
  var this__35051 = this;
  return this__35051.arr[this__35051.off + i]
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, i, not_found) {
  var this__35052 = this;
  if(function() {
    var and__3822__auto____35053 = i >= 0;
    if(and__3822__auto____35053) {
      return i < this__35052.end - this__35052.off
    }else {
      return and__3822__auto____35053
    }
  }()) {
    return this__35052.arr[this__35052.off + i]
  }else {
    return not_found
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var this__35054 = this;
  return this__35054.end - this__35054.off
};
cljs.core.ArrayChunk;
cljs.core.array_chunk = function() {
  var array_chunk = null;
  var array_chunk__1 = function(arr) {
    return array_chunk.call(null, arr, 0, arr.length)
  };
  var array_chunk__2 = function(arr, off) {
    return array_chunk.call(null, arr, off, arr.length)
  };
  var array_chunk__3 = function(arr, off, end) {
    return new cljs.core.ArrayChunk(arr, off, end)
  };
  array_chunk = function(arr, off, end) {
    switch(arguments.length) {
      case 1:
        return array_chunk__1.call(this, arr);
      case 2:
        return array_chunk__2.call(this, arr, off);
      case 3:
        return array_chunk__3.call(this, arr, off, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  array_chunk.cljs$lang$arity$1 = array_chunk__1;
  array_chunk.cljs$lang$arity$2 = array_chunk__2;
  array_chunk.cljs$lang$arity$3 = array_chunk__3;
  return array_chunk
}();
cljs.core.ChunkedCons = function(chunk, more, meta) {
  this.chunk = chunk;
  this.more = more;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 27656296
};
cljs.core.ChunkedCons.cljs$lang$type = true;
cljs.core.ChunkedCons.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/ChunkedCons")
};
cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {
  var this__35055 = this;
  return cljs.core.cons.call(null, o, this$)
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__35056 = this;
  return coll
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__35057 = this;
  return cljs.core._nth.call(null, this__35057.chunk, 0)
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__35058 = this;
  if(cljs.core._count.call(null, this__35058.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first.call(null, this__35058.chunk), this__35058.more, this__35058.meta)
  }else {
    if(this__35058.more == null) {
      return cljs.core.List.EMPTY
    }else {
      return this__35058.more
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$ = true;
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var this__35059 = this;
  if(this__35059.more == null) {
    return null
  }else {
    return this__35059.more
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__35060 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var this__35061 = this;
  return new cljs.core.ChunkedCons(this__35061.chunk, this__35061.more, m)
};
cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__35062 = this;
  return this__35062.meta
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$ = true;
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var this__35063 = this;
  return this__35063.chunk
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var this__35064 = this;
  if(this__35064.more == null) {
    return cljs.core.List.EMPTY
  }else {
    return this__35064.more
  }
};
cljs.core.ChunkedCons;
cljs.core.chunk_cons = function chunk_cons(chunk, rest) {
  if(cljs.core._count.call(null, chunk) === 0) {
    return rest
  }else {
    return new cljs.core.ChunkedCons(chunk, rest, null)
  }
};
cljs.core.chunk_append = function chunk_append(b, x) {
  return b.add(x)
};
cljs.core.chunk = function chunk(b) {
  return b.chunk()
};
cljs.core.chunk_first = function chunk_first(s) {
  return cljs.core._chunked_first.call(null, s)
};
cljs.core.chunk_rest = function chunk_rest(s) {
  return cljs.core._chunked_rest.call(null, s)
};
cljs.core.chunk_next = function chunk_next(s) {
  if(function() {
    var G__35068__35069 = s;
    if(G__35068__35069) {
      if(cljs.core.truth_(function() {
        var or__3824__auto____35070 = null;
        if(cljs.core.truth_(or__3824__auto____35070)) {
          return or__3824__auto____35070
        }else {
          return G__35068__35069.cljs$core$IChunkedNext$
        }
      }())) {
        return true
      }else {
        if(!G__35068__35069.cljs$lang$protocol_mask$partition$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IChunkedNext, G__35068__35069)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IChunkedNext, G__35068__35069)
    }
  }()) {
    return cljs.core._chunked_next.call(null, s)
  }else {
    return cljs.core.seq.call(null, cljs.core._chunked_rest.call(null, s))
  }
};
cljs.core.to_array = function to_array(s) {
  var ary__35073 = [];
  var s__35074 = s;
  while(true) {
    if(cljs.core.seq.call(null, s__35074)) {
      ary__35073.push(cljs.core.first.call(null, s__35074));
      var G__35075 = cljs.core.next.call(null, s__35074);
      s__35074 = G__35075;
      continue
    }else {
      return ary__35073
    }
    break
  }
};
cljs.core.to_array_2d = function to_array_2d(coll) {
  var ret__35079 = cljs.core.make_array.call(null, cljs.core.count.call(null, coll));
  var i__35080 = 0;
  var xs__35081 = cljs.core.seq.call(null, coll);
  while(true) {
    if(xs__35081) {
      ret__35079[i__35080] = cljs.core.to_array.call(null, cljs.core.first.call(null, xs__35081));
      var G__35082 = i__35080 + 1;
      var G__35083 = cljs.core.next.call(null, xs__35081);
      i__35080 = G__35082;
      xs__35081 = G__35083;
      continue
    }else {
    }
    break
  }
  return ret__35079
};
cljs.core.long_array = function() {
  var long_array = null;
  var long_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return long_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("long-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var long_array__2 = function(size, init_val_or_seq) {
    var a__35091 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__35092 = cljs.core.seq.call(null, init_val_or_seq);
      var i__35093 = 0;
      var s__35094 = s__35092;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3822__auto____35095 = s__35094;
          if(and__3822__auto____35095) {
            return i__35093 < size
          }else {
            return and__3822__auto____35095
          }
        }())) {
          a__35091[i__35093] = cljs.core.first.call(null, s__35094);
          var G__35098 = i__35093 + 1;
          var G__35099 = cljs.core.next.call(null, s__35094);
          i__35093 = G__35098;
          s__35094 = G__35099;
          continue
        }else {
          return a__35091
        }
        break
      }
    }else {
      var n__2527__auto____35096 = size;
      var i__35097 = 0;
      while(true) {
        if(i__35097 < n__2527__auto____35096) {
          a__35091[i__35097] = init_val_or_seq;
          var G__35100 = i__35097 + 1;
          i__35097 = G__35100;
          continue
        }else {
        }
        break
      }
      return a__35091
    }
  };
  long_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return long_array__1.call(this, size);
      case 2:
        return long_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  long_array.cljs$lang$arity$1 = long_array__1;
  long_array.cljs$lang$arity$2 = long_array__2;
  return long_array
}();
cljs.core.double_array = function() {
  var double_array = null;
  var double_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return double_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("double-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var double_array__2 = function(size, init_val_or_seq) {
    var a__35108 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__35109 = cljs.core.seq.call(null, init_val_or_seq);
      var i__35110 = 0;
      var s__35111 = s__35109;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3822__auto____35112 = s__35111;
          if(and__3822__auto____35112) {
            return i__35110 < size
          }else {
            return and__3822__auto____35112
          }
        }())) {
          a__35108[i__35110] = cljs.core.first.call(null, s__35111);
          var G__35115 = i__35110 + 1;
          var G__35116 = cljs.core.next.call(null, s__35111);
          i__35110 = G__35115;
          s__35111 = G__35116;
          continue
        }else {
          return a__35108
        }
        break
      }
    }else {
      var n__2527__auto____35113 = size;
      var i__35114 = 0;
      while(true) {
        if(i__35114 < n__2527__auto____35113) {
          a__35108[i__35114] = init_val_or_seq;
          var G__35117 = i__35114 + 1;
          i__35114 = G__35117;
          continue
        }else {
        }
        break
      }
      return a__35108
    }
  };
  double_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return double_array__1.call(this, size);
      case 2:
        return double_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  double_array.cljs$lang$arity$1 = double_array__1;
  double_array.cljs$lang$arity$2 = double_array__2;
  return double_array
}();
cljs.core.object_array = function() {
  var object_array = null;
  var object_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return object_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("object-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var object_array__2 = function(size, init_val_or_seq) {
    var a__35125 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__35126 = cljs.core.seq.call(null, init_val_or_seq);
      var i__35127 = 0;
      var s__35128 = s__35126;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3822__auto____35129 = s__35128;
          if(and__3822__auto____35129) {
            return i__35127 < size
          }else {
            return and__3822__auto____35129
          }
        }())) {
          a__35125[i__35127] = cljs.core.first.call(null, s__35128);
          var G__35132 = i__35127 + 1;
          var G__35133 = cljs.core.next.call(null, s__35128);
          i__35127 = G__35132;
          s__35128 = G__35133;
          continue
        }else {
          return a__35125
        }
        break
      }
    }else {
      var n__2527__auto____35130 = size;
      var i__35131 = 0;
      while(true) {
        if(i__35131 < n__2527__auto____35130) {
          a__35125[i__35131] = init_val_or_seq;
          var G__35134 = i__35131 + 1;
          i__35131 = G__35134;
          continue
        }else {
        }
        break
      }
      return a__35125
    }
  };
  object_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return object_array__1.call(this, size);
      case 2:
        return object_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  object_array.cljs$lang$arity$1 = object_array__1;
  object_array.cljs$lang$arity$2 = object_array__2;
  return object_array
}();
cljs.core.bounded_count = function bounded_count(s, n) {
  if(cljs.core.counted_QMARK_.call(null, s)) {
    return cljs.core.count.call(null, s)
  }else {
    var s__35139 = s;
    var i__35140 = n;
    var sum__35141 = 0;
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3822__auto____35142 = i__35140 > 0;
        if(and__3822__auto____35142) {
          return cljs.core.seq.call(null, s__35139)
        }else {
          return and__3822__auto____35142
        }
      }())) {
        var G__35143 = cljs.core.next.call(null, s__35139);
        var G__35144 = i__35140 - 1;
        var G__35145 = sum__35141 + 1;
        s__35139 = G__35143;
        i__35140 = G__35144;
        sum__35141 = G__35145;
        continue
      }else {
        return sum__35141
      }
      break
    }
  }
};
cljs.core.spread = function spread(arglist) {
  if(arglist == null) {
    return null
  }else {
    if(cljs.core.next.call(null, arglist) == null) {
      return cljs.core.seq.call(null, cljs.core.first.call(null, arglist))
    }else {
      if("\ufdd0'else") {
        return cljs.core.cons.call(null, cljs.core.first.call(null, arglist), spread.call(null, cljs.core.next.call(null, arglist)))
      }else {
        return null
      }
    }
  }
};
cljs.core.concat = function() {
  var concat = null;
  var concat__0 = function() {
    return new cljs.core.LazySeq(null, false, function() {
      return null
    }, null)
  };
  var concat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return x
    }, null)
  };
  var concat__2 = function(x, y) {
    return new cljs.core.LazySeq(null, false, function() {
      var s__35150 = cljs.core.seq.call(null, x);
      if(s__35150) {
        if(cljs.core.chunked_seq_QMARK_.call(null, s__35150)) {
          return cljs.core.chunk_cons.call(null, cljs.core.chunk_first.call(null, s__35150), concat.call(null, cljs.core.chunk_rest.call(null, s__35150), y))
        }else {
          return cljs.core.cons.call(null, cljs.core.first.call(null, s__35150), concat.call(null, cljs.core.rest.call(null, s__35150), y))
        }
      }else {
        return y
      }
    }, null)
  };
  var concat__3 = function() {
    var G__35154__delegate = function(x, y, zs) {
      var cat__35153 = function cat(xys, zs) {
        return new cljs.core.LazySeq(null, false, function() {
          var xys__35152 = cljs.core.seq.call(null, xys);
          if(xys__35152) {
            if(cljs.core.chunked_seq_QMARK_.call(null, xys__35152)) {
              return cljs.core.chunk_cons.call(null, cljs.core.chunk_first.call(null, xys__35152), cat.call(null, cljs.core.chunk_rest.call(null, xys__35152), zs))
            }else {
              return cljs.core.cons.call(null, cljs.core.first.call(null, xys__35152), cat.call(null, cljs.core.rest.call(null, xys__35152), zs))
            }
          }else {
            if(cljs.core.truth_(zs)) {
              return cat.call(null, cljs.core.first.call(null, zs), cljs.core.next.call(null, zs))
            }else {
              return null
            }
          }
        }, null)
      };
      return cat__35153.call(null, concat.call(null, x, y), zs)
    };
    var G__35154 = function(x, y, var_args) {
      var zs = null;
      if(goog.isDef(var_args)) {
        zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__35154__delegate.call(this, x, y, zs)
    };
    G__35154.cljs$lang$maxFixedArity = 2;
    G__35154.cljs$lang$applyTo = function(arglist__35155) {
      var x = cljs.core.first(arglist__35155);
      var y = cljs.core.first(cljs.core.next(arglist__35155));
      var zs = cljs.core.rest(cljs.core.next(arglist__35155));
      return G__35154__delegate(x, y, zs)
    };
    G__35154.cljs$lang$arity$variadic = G__35154__delegate;
    return G__35154
  }();
  concat = function(x, y, var_args) {
    var zs = var_args;
    switch(arguments.length) {
      case 0:
        return concat__0.call(this);
      case 1:
        return concat__1.call(this, x);
      case 2:
        return concat__2.call(this, x, y);
      default:
        return concat__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  concat.cljs$lang$maxFixedArity = 2;
  concat.cljs$lang$applyTo = concat__3.cljs$lang$applyTo;
  concat.cljs$lang$arity$0 = concat__0;
  concat.cljs$lang$arity$1 = concat__1;
  concat.cljs$lang$arity$2 = concat__2;
  concat.cljs$lang$arity$variadic = concat__3.cljs$lang$arity$variadic;
  return concat
}();
cljs.core.list_STAR_ = function() {
  var list_STAR_ = null;
  var list_STAR___1 = function(args) {
    return cljs.core.seq.call(null, args)
  };
  var list_STAR___2 = function(a, args) {
    return cljs.core.cons.call(null, a, args)
  };
  var list_STAR___3 = function(a, b, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, args))
  };
  var list_STAR___4 = function(a, b, c, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, args)))
  };
  var list_STAR___5 = function() {
    var G__35156__delegate = function(a, b, c, d, more) {
      return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, more)))))
    };
    var G__35156 = function(a, b, c, d, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__35156__delegate.call(this, a, b, c, d, more)
    };
    G__35156.cljs$lang$maxFixedArity = 4;
    G__35156.cljs$lang$applyTo = function(arglist__35157) {
      var a = cljs.core.first(arglist__35157);
      var b = cljs.core.first(cljs.core.next(arglist__35157));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35157)));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__35157))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__35157))));
      return G__35156__delegate(a, b, c, d, more)
    };
    G__35156.cljs$lang$arity$variadic = G__35156__delegate;
    return G__35156
  }();
  list_STAR_ = function(a, b, c, d, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return list_STAR___1.call(this, a);
      case 2:
        return list_STAR___2.call(this, a, b);
      case 3:
        return list_STAR___3.call(this, a, b, c);
      case 4:
        return list_STAR___4.call(this, a, b, c, d);
      default:
        return list_STAR___5.cljs$lang$arity$variadic(a, b, c, d, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  list_STAR_.cljs$lang$maxFixedArity = 4;
  list_STAR_.cljs$lang$applyTo = list_STAR___5.cljs$lang$applyTo;
  list_STAR_.cljs$lang$arity$1 = list_STAR___1;
  list_STAR_.cljs$lang$arity$2 = list_STAR___2;
  list_STAR_.cljs$lang$arity$3 = list_STAR___3;
  list_STAR_.cljs$lang$arity$4 = list_STAR___4;
  list_STAR_.cljs$lang$arity$variadic = list_STAR___5.cljs$lang$arity$variadic;
  return list_STAR_
}();
cljs.core.transient$ = function transient$(coll) {
  return cljs.core._as_transient.call(null, coll)
};
cljs.core.persistent_BANG_ = function persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_.call(null, tcoll)
};
cljs.core.conj_BANG_ = function conj_BANG_(tcoll, val) {
  return cljs.core._conj_BANG_.call(null, tcoll, val)
};
cljs.core.assoc_BANG_ = function assoc_BANG_(tcoll, key, val) {
  return cljs.core._assoc_BANG_.call(null, tcoll, key, val)
};
cljs.core.dissoc_BANG_ = function dissoc_BANG_(tcoll, key) {
  return cljs.core._dissoc_BANG_.call(null, tcoll, key)
};
cljs.core.pop_BANG_ = function pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_.call(null, tcoll)
};
cljs.core.disj_BANG_ = function disj_BANG_(tcoll, val) {
  return cljs.core._disjoin_BANG_.call(null, tcoll, val)
};
cljs.core.apply_to = function apply_to(f, argc, args) {
  var args__35199 = cljs.core.seq.call(null, args);
  if(argc === 0) {
    return f.call(null)
  }else {
    var a__35200 = cljs.core._first.call(null, args__35199);
    var args__35201 = cljs.core._rest.call(null, args__35199);
    if(argc === 1) {
      if(f.cljs$lang$arity$1) {
        return f.cljs$lang$arity$1(a__35200)
      }else {
        return f.call(null, a__35200)
      }
    }else {
      var b__35202 = cljs.core._first.call(null, args__35201);
      var args__35203 = cljs.core._rest.call(null, args__35201);
      if(argc === 2) {
        if(f.cljs$lang$arity$2) {
          return f.cljs$lang$arity$2(a__35200, b__35202)
        }else {
          return f.call(null, a__35200, b__35202)
        }
      }else {
        var c__35204 = cljs.core._first.call(null, args__35203);
        var args__35205 = cljs.core._rest.call(null, args__35203);
        if(argc === 3) {
          if(f.cljs$lang$arity$3) {
            return f.cljs$lang$arity$3(a__35200, b__35202, c__35204)
          }else {
            return f.call(null, a__35200, b__35202, c__35204)
          }
        }else {
          var d__35206 = cljs.core._first.call(null, args__35205);
          var args__35207 = cljs.core._rest.call(null, args__35205);
          if(argc === 4) {
            if(f.cljs$lang$arity$4) {
              return f.cljs$lang$arity$4(a__35200, b__35202, c__35204, d__35206)
            }else {
              return f.call(null, a__35200, b__35202, c__35204, d__35206)
            }
          }else {
            var e__35208 = cljs.core._first.call(null, args__35207);
            var args__35209 = cljs.core._rest.call(null, args__35207);
            if(argc === 5) {
              if(f.cljs$lang$arity$5) {
                return f.cljs$lang$arity$5(a__35200, b__35202, c__35204, d__35206, e__35208)
              }else {
                return f.call(null, a__35200, b__35202, c__35204, d__35206, e__35208)
              }
            }else {
              var f__35210 = cljs.core._first.call(null, args__35209);
              var args__35211 = cljs.core._rest.call(null, args__35209);
              if(argc === 6) {
                if(f__35210.cljs$lang$arity$6) {
                  return f__35210.cljs$lang$arity$6(a__35200, b__35202, c__35204, d__35206, e__35208, f__35210)
                }else {
                  return f__35210.call(null, a__35200, b__35202, c__35204, d__35206, e__35208, f__35210)
                }
              }else {
                var g__35212 = cljs.core._first.call(null, args__35211);
                var args__35213 = cljs.core._rest.call(null, args__35211);
                if(argc === 7) {
                  if(f__35210.cljs$lang$arity$7) {
                    return f__35210.cljs$lang$arity$7(a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212)
                  }else {
                    return f__35210.call(null, a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212)
                  }
                }else {
                  var h__35214 = cljs.core._first.call(null, args__35213);
                  var args__35215 = cljs.core._rest.call(null, args__35213);
                  if(argc === 8) {
                    if(f__35210.cljs$lang$arity$8) {
                      return f__35210.cljs$lang$arity$8(a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214)
                    }else {
                      return f__35210.call(null, a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214)
                    }
                  }else {
                    var i__35216 = cljs.core._first.call(null, args__35215);
                    var args__35217 = cljs.core._rest.call(null, args__35215);
                    if(argc === 9) {
                      if(f__35210.cljs$lang$arity$9) {
                        return f__35210.cljs$lang$arity$9(a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216)
                      }else {
                        return f__35210.call(null, a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216)
                      }
                    }else {
                      var j__35218 = cljs.core._first.call(null, args__35217);
                      var args__35219 = cljs.core._rest.call(null, args__35217);
                      if(argc === 10) {
                        if(f__35210.cljs$lang$arity$10) {
                          return f__35210.cljs$lang$arity$10(a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218)
                        }else {
                          return f__35210.call(null, a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218)
                        }
                      }else {
                        var k__35220 = cljs.core._first.call(null, args__35219);
                        var args__35221 = cljs.core._rest.call(null, args__35219);
                        if(argc === 11) {
                          if(f__35210.cljs$lang$arity$11) {
                            return f__35210.cljs$lang$arity$11(a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218, k__35220)
                          }else {
                            return f__35210.call(null, a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218, k__35220)
                          }
                        }else {
                          var l__35222 = cljs.core._first.call(null, args__35221);
                          var args__35223 = cljs.core._rest.call(null, args__35221);
                          if(argc === 12) {
                            if(f__35210.cljs$lang$arity$12) {
                              return f__35210.cljs$lang$arity$12(a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218, k__35220, l__35222)
                            }else {
                              return f__35210.call(null, a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218, k__35220, l__35222)
                            }
                          }else {
                            var m__35224 = cljs.core._first.call(null, args__35223);
                            var args__35225 = cljs.core._rest.call(null, args__35223);
                            if(argc === 13) {
                              if(f__35210.cljs$lang$arity$13) {
                                return f__35210.cljs$lang$arity$13(a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218, k__35220, l__35222, m__35224)
                              }else {
                                return f__35210.call(null, a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218, k__35220, l__35222, m__35224)
                              }
                            }else {
                              var n__35226 = cljs.core._first.call(null, args__35225);
                              var args__35227 = cljs.core._rest.call(null, args__35225);
                              if(argc === 14) {
                                if(f__35210.cljs$lang$arity$14) {
                                  return f__35210.cljs$lang$arity$14(a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218, k__35220, l__35222, m__35224, n__35226)
                                }else {
                                  return f__35210.call(null, a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218, k__35220, l__35222, m__35224, n__35226)
                                }
                              }else {
                                var o__35228 = cljs.core._first.call(null, args__35227);
                                var args__35229 = cljs.core._rest.call(null, args__35227);
                                if(argc === 15) {
                                  if(f__35210.cljs$lang$arity$15) {
                                    return f__35210.cljs$lang$arity$15(a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218, k__35220, l__35222, m__35224, n__35226, o__35228)
                                  }else {
                                    return f__35210.call(null, a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218, k__35220, l__35222, m__35224, n__35226, o__35228)
                                  }
                                }else {
                                  var p__35230 = cljs.core._first.call(null, args__35229);
                                  var args__35231 = cljs.core._rest.call(null, args__35229);
                                  if(argc === 16) {
                                    if(f__35210.cljs$lang$arity$16) {
                                      return f__35210.cljs$lang$arity$16(a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218, k__35220, l__35222, m__35224, n__35226, o__35228, p__35230)
                                    }else {
                                      return f__35210.call(null, a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218, k__35220, l__35222, m__35224, n__35226, o__35228, p__35230)
                                    }
                                  }else {
                                    var q__35232 = cljs.core._first.call(null, args__35231);
                                    var args__35233 = cljs.core._rest.call(null, args__35231);
                                    if(argc === 17) {
                                      if(f__35210.cljs$lang$arity$17) {
                                        return f__35210.cljs$lang$arity$17(a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218, k__35220, l__35222, m__35224, n__35226, o__35228, p__35230, q__35232)
                                      }else {
                                        return f__35210.call(null, a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218, k__35220, l__35222, m__35224, n__35226, o__35228, p__35230, q__35232)
                                      }
                                    }else {
                                      var r__35234 = cljs.core._first.call(null, args__35233);
                                      var args__35235 = cljs.core._rest.call(null, args__35233);
                                      if(argc === 18) {
                                        if(f__35210.cljs$lang$arity$18) {
                                          return f__35210.cljs$lang$arity$18(a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218, k__35220, l__35222, m__35224, n__35226, o__35228, p__35230, q__35232, r__35234)
                                        }else {
                                          return f__35210.call(null, a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218, k__35220, l__35222, m__35224, n__35226, o__35228, p__35230, q__35232, r__35234)
                                        }
                                      }else {
                                        var s__35236 = cljs.core._first.call(null, args__35235);
                                        var args__35237 = cljs.core._rest.call(null, args__35235);
                                        if(argc === 19) {
                                          if(f__35210.cljs$lang$arity$19) {
                                            return f__35210.cljs$lang$arity$19(a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218, k__35220, l__35222, m__35224, n__35226, o__35228, p__35230, q__35232, r__35234, s__35236)
                                          }else {
                                            return f__35210.call(null, a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218, k__35220, l__35222, m__35224, n__35226, o__35228, p__35230, q__35232, r__35234, s__35236)
                                          }
                                        }else {
                                          var t__35238 = cljs.core._first.call(null, args__35237);
                                          var args__35239 = cljs.core._rest.call(null, args__35237);
                                          if(argc === 20) {
                                            if(f__35210.cljs$lang$arity$20) {
                                              return f__35210.cljs$lang$arity$20(a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218, k__35220, l__35222, m__35224, n__35226, o__35228, p__35230, q__35232, r__35234, s__35236, t__35238)
                                            }else {
                                              return f__35210.call(null, a__35200, b__35202, c__35204, d__35206, e__35208, f__35210, g__35212, h__35214, i__35216, j__35218, k__35220, l__35222, m__35224, n__35226, o__35228, p__35230, q__35232, r__35234, s__35236, t__35238)
                                            }
                                          }else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.apply = function() {
  var apply = null;
  var apply__2 = function(f, args) {
    var fixed_arity__35254 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__35255 = cljs.core.bounded_count.call(null, args, fixed_arity__35254 + 1);
      if(bc__35255 <= fixed_arity__35254) {
        return cljs.core.apply_to.call(null, f, bc__35255, args)
      }else {
        return f.cljs$lang$applyTo(args)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, args))
    }
  };
  var apply__3 = function(f, x, args) {
    var arglist__35256 = cljs.core.list_STAR_.call(null, x, args);
    var fixed_arity__35257 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__35258 = cljs.core.bounded_count.call(null, arglist__35256, fixed_arity__35257 + 1);
      if(bc__35258 <= fixed_arity__35257) {
        return cljs.core.apply_to.call(null, f, bc__35258, arglist__35256)
      }else {
        return f.cljs$lang$applyTo(arglist__35256)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__35256))
    }
  };
  var apply__4 = function(f, x, y, args) {
    var arglist__35259 = cljs.core.list_STAR_.call(null, x, y, args);
    var fixed_arity__35260 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__35261 = cljs.core.bounded_count.call(null, arglist__35259, fixed_arity__35260 + 1);
      if(bc__35261 <= fixed_arity__35260) {
        return cljs.core.apply_to.call(null, f, bc__35261, arglist__35259)
      }else {
        return f.cljs$lang$applyTo(arglist__35259)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__35259))
    }
  };
  var apply__5 = function(f, x, y, z, args) {
    var arglist__35262 = cljs.core.list_STAR_.call(null, x, y, z, args);
    var fixed_arity__35263 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__35264 = cljs.core.bounded_count.call(null, arglist__35262, fixed_arity__35263 + 1);
      if(bc__35264 <= fixed_arity__35263) {
        return cljs.core.apply_to.call(null, f, bc__35264, arglist__35262)
      }else {
        return f.cljs$lang$applyTo(arglist__35262)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__35262))
    }
  };
  var apply__6 = function() {
    var G__35268__delegate = function(f, a, b, c, d, args) {
      var arglist__35265 = cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, args)))));
      var fixed_arity__35266 = f.cljs$lang$maxFixedArity;
      if(cljs.core.truth_(f.cljs$lang$applyTo)) {
        var bc__35267 = cljs.core.bounded_count.call(null, arglist__35265, fixed_arity__35266 + 1);
        if(bc__35267 <= fixed_arity__35266) {
          return cljs.core.apply_to.call(null, f, bc__35267, arglist__35265)
        }else {
          return f.cljs$lang$applyTo(arglist__35265)
        }
      }else {
        return f.apply(f, cljs.core.to_array.call(null, arglist__35265))
      }
    };
    var G__35268 = function(f, a, b, c, d, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__35268__delegate.call(this, f, a, b, c, d, args)
    };
    G__35268.cljs$lang$maxFixedArity = 5;
    G__35268.cljs$lang$applyTo = function(arglist__35269) {
      var f = cljs.core.first(arglist__35269);
      var a = cljs.core.first(cljs.core.next(arglist__35269));
      var b = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35269)));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__35269))));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__35269)))));
      var args = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__35269)))));
      return G__35268__delegate(f, a, b, c, d, args)
    };
    G__35268.cljs$lang$arity$variadic = G__35268__delegate;
    return G__35268
  }();
  apply = function(f, a, b, c, d, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 2:
        return apply__2.call(this, f, a);
      case 3:
        return apply__3.call(this, f, a, b);
      case 4:
        return apply__4.call(this, f, a, b, c);
      case 5:
        return apply__5.call(this, f, a, b, c, d);
      default:
        return apply__6.cljs$lang$arity$variadic(f, a, b, c, d, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  apply.cljs$lang$maxFixedArity = 5;
  apply.cljs$lang$applyTo = apply__6.cljs$lang$applyTo;
  apply.cljs$lang$arity$2 = apply__2;
  apply.cljs$lang$arity$3 = apply__3;
  apply.cljs$lang$arity$4 = apply__4;
  apply.cljs$lang$arity$5 = apply__5;
  apply.cljs$lang$arity$variadic = apply__6.cljs$lang$arity$variadic;
  return apply
}();
cljs.core.vary_meta = function() {
  var vary_meta__delegate = function(obj, f, args) {
    return cljs.core.with_meta.call(null, obj, cljs.core.apply.call(null, f, cljs.core.meta.call(null, obj), args))
  };
  var vary_meta = function(obj, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return vary_meta__delegate.call(this, obj, f, args)
  };
  vary_meta.cljs$lang$maxFixedArity = 2;
  vary_meta.cljs$lang$applyTo = function(arglist__35270) {
    var obj = cljs.core.first(arglist__35270);
    var f = cljs.core.first(cljs.core.next(arglist__35270));
    var args = cljs.core.rest(cljs.core.next(arglist__35270));
    return vary_meta__delegate(obj, f, args)
  };
  vary_meta.cljs$lang$arity$variadic = vary_meta__delegate;
  return vary_meta
}();
cljs.core.not_EQ_ = function() {
  var not_EQ_ = null;
  var not_EQ___1 = function(x) {
    return false
  };
  var not_EQ___2 = function(x, y) {
    return!cljs.core._EQ_.call(null, x, y)
  };
  var not_EQ___3 = function() {
    var G__35271__delegate = function(x, y, more) {
      return cljs.core.not.call(null, cljs.core.apply.call(null, cljs.core._EQ_, x, y, more))
    };
    var G__35271 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__35271__delegate.call(this, x, y, more)
    };
    G__35271.cljs$lang$maxFixedArity = 2;
    G__35271.cljs$lang$applyTo = function(arglist__35272) {
      var x = cljs.core.first(arglist__35272);
      var y = cljs.core.first(cljs.core.next(arglist__35272));
      var more = cljs.core.rest(cljs.core.next(arglist__35272));
      return G__35271__delegate(x, y, more)
    };
    G__35271.cljs$lang$arity$variadic = G__35271__delegate;
    return G__35271
  }();
  not_EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return not_EQ___1.call(this, x);
      case 2:
        return not_EQ___2.call(this, x, y);
      default:
        return not_EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  not_EQ_.cljs$lang$maxFixedArity = 2;
  not_EQ_.cljs$lang$applyTo = not_EQ___3.cljs$lang$applyTo;
  not_EQ_.cljs$lang$arity$1 = not_EQ___1;
  not_EQ_.cljs$lang$arity$2 = not_EQ___2;
  not_EQ_.cljs$lang$arity$variadic = not_EQ___3.cljs$lang$arity$variadic;
  return not_EQ_
}();
cljs.core.not_empty = function not_empty(coll) {
  if(cljs.core.seq.call(null, coll)) {
    return coll
  }else {
    return null
  }
};
cljs.core.every_QMARK_ = function every_QMARK_(pred, coll) {
  while(true) {
    if(cljs.core.seq.call(null, coll) == null) {
      return true
    }else {
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, coll)))) {
        var G__35273 = pred;
        var G__35274 = cljs.core.next.call(null, coll);
        pred = G__35273;
        coll = G__35274;
        continue
      }else {
        if("\ufdd0'else") {
          return false
        }else {
          return null
        }
      }
    }
    break
  }
};
cljs.core.not_every_QMARK_ = function not_every_QMARK_(pred, coll) {
  return!cljs.core.every_QMARK_.call(null, pred, coll)
};
cljs.core.some = function some(pred, coll) {
  while(true) {
    if(cljs.core.seq.call(null, coll)) {
      var or__3824__auto____35276 = pred.call(null, cljs.core.first.call(null, coll));
      if(cljs.core.truth_(or__3824__auto____35276)) {
        return or__3824__auto____35276
      }else {
        var G__35277 = pred;
        var G__35278 = cljs.core.next.call(null, coll);
        pred = G__35277;
        coll = G__35278;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.not_any_QMARK_ = function not_any_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.some.call(null, pred, coll))
};
cljs.core.even_QMARK_ = function even_QMARK_(n) {
  if(cljs.core.integer_QMARK_.call(null, n)) {
    return(n & 1) === 0
  }else {
    throw new Error([cljs.core.str("Argument must be an integer: "), cljs.core.str(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function odd_QMARK_(n) {
  return!cljs.core.even_QMARK_.call(null, n)
};
cljs.core.identity = function identity(x) {
  return x
};
cljs.core.complement = function complement(f) {
  return function() {
    var G__35279 = null;
    var G__35279__0 = function() {
      return cljs.core.not.call(null, f.call(null))
    };
    var G__35279__1 = function(x) {
      return cljs.core.not.call(null, f.call(null, x))
    };
    var G__35279__2 = function(x, y) {
      return cljs.core.not.call(null, f.call(null, x, y))
    };
    var G__35279__3 = function() {
      var G__35280__delegate = function(x, y, zs) {
        return cljs.core.not.call(null, cljs.core.apply.call(null, f, x, y, zs))
      };
      var G__35280 = function(x, y, var_args) {
        var zs = null;
        if(goog.isDef(var_args)) {
          zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
        }
        return G__35280__delegate.call(this, x, y, zs)
      };
      G__35280.cljs$lang$maxFixedArity = 2;
      G__35280.cljs$lang$applyTo = function(arglist__35281) {
        var x = cljs.core.first(arglist__35281);
        var y = cljs.core.first(cljs.core.next(arglist__35281));
        var zs = cljs.core.rest(cljs.core.next(arglist__35281));
        return G__35280__delegate(x, y, zs)
      };
      G__35280.cljs$lang$arity$variadic = G__35280__delegate;
      return G__35280
    }();
    G__35279 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__35279__0.call(this);
        case 1:
          return G__35279__1.call(this, x);
        case 2:
          return G__35279__2.call(this, x, y);
        default:
          return G__35279__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
      }
      throw"Invalid arity: " + arguments.length;
    };
    G__35279.cljs$lang$maxFixedArity = 2;
    G__35279.cljs$lang$applyTo = G__35279__3.cljs$lang$applyTo;
    return G__35279
  }()
};
cljs.core.constantly = function constantly(x) {
  return function() {
    var G__35282__delegate = function(args) {
      return x
    };
    var G__35282 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__35282__delegate.call(this, args)
    };
    G__35282.cljs$lang$maxFixedArity = 0;
    G__35282.cljs$lang$applyTo = function(arglist__35283) {
      var args = cljs.core.seq(arglist__35283);
      return G__35282__delegate(args)
    };
    G__35282.cljs$lang$arity$variadic = G__35282__delegate;
    return G__35282
  }()
};
cljs.core.comp = function() {
  var comp = null;
  var comp__0 = function() {
    return cljs.core.identity
  };
  var comp__1 = function(f) {
    return f
  };
  var comp__2 = function(f, g) {
    return function() {
      var G__35290 = null;
      var G__35290__0 = function() {
        return f.call(null, g.call(null))
      };
      var G__35290__1 = function(x) {
        return f.call(null, g.call(null, x))
      };
      var G__35290__2 = function(x, y) {
        return f.call(null, g.call(null, x, y))
      };
      var G__35290__3 = function(x, y, z) {
        return f.call(null, g.call(null, x, y, z))
      };
      var G__35290__4 = function() {
        var G__35291__delegate = function(x, y, z, args) {
          return f.call(null, cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__35291 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__35291__delegate.call(this, x, y, z, args)
        };
        G__35291.cljs$lang$maxFixedArity = 3;
        G__35291.cljs$lang$applyTo = function(arglist__35292) {
          var x = cljs.core.first(arglist__35292);
          var y = cljs.core.first(cljs.core.next(arglist__35292));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35292)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__35292)));
          return G__35291__delegate(x, y, z, args)
        };
        G__35291.cljs$lang$arity$variadic = G__35291__delegate;
        return G__35291
      }();
      G__35290 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__35290__0.call(this);
          case 1:
            return G__35290__1.call(this, x);
          case 2:
            return G__35290__2.call(this, x, y);
          case 3:
            return G__35290__3.call(this, x, y, z);
          default:
            return G__35290__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__35290.cljs$lang$maxFixedArity = 3;
      G__35290.cljs$lang$applyTo = G__35290__4.cljs$lang$applyTo;
      return G__35290
    }()
  };
  var comp__3 = function(f, g, h) {
    return function() {
      var G__35293 = null;
      var G__35293__0 = function() {
        return f.call(null, g.call(null, h.call(null)))
      };
      var G__35293__1 = function(x) {
        return f.call(null, g.call(null, h.call(null, x)))
      };
      var G__35293__2 = function(x, y) {
        return f.call(null, g.call(null, h.call(null, x, y)))
      };
      var G__35293__3 = function(x, y, z) {
        return f.call(null, g.call(null, h.call(null, x, y, z)))
      };
      var G__35293__4 = function() {
        var G__35294__delegate = function(x, y, z, args) {
          return f.call(null, g.call(null, cljs.core.apply.call(null, h, x, y, z, args)))
        };
        var G__35294 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__35294__delegate.call(this, x, y, z, args)
        };
        G__35294.cljs$lang$maxFixedArity = 3;
        G__35294.cljs$lang$applyTo = function(arglist__35295) {
          var x = cljs.core.first(arglist__35295);
          var y = cljs.core.first(cljs.core.next(arglist__35295));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35295)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__35295)));
          return G__35294__delegate(x, y, z, args)
        };
        G__35294.cljs$lang$arity$variadic = G__35294__delegate;
        return G__35294
      }();
      G__35293 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__35293__0.call(this);
          case 1:
            return G__35293__1.call(this, x);
          case 2:
            return G__35293__2.call(this, x, y);
          case 3:
            return G__35293__3.call(this, x, y, z);
          default:
            return G__35293__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__35293.cljs$lang$maxFixedArity = 3;
      G__35293.cljs$lang$applyTo = G__35293__4.cljs$lang$applyTo;
      return G__35293
    }()
  };
  var comp__4 = function() {
    var G__35296__delegate = function(f1, f2, f3, fs) {
      var fs__35287 = cljs.core.reverse.call(null, cljs.core.list_STAR_.call(null, f1, f2, f3, fs));
      return function() {
        var G__35297__delegate = function(args) {
          var ret__35288 = cljs.core.apply.call(null, cljs.core.first.call(null, fs__35287), args);
          var fs__35289 = cljs.core.next.call(null, fs__35287);
          while(true) {
            if(fs__35289) {
              var G__35298 = cljs.core.first.call(null, fs__35289).call(null, ret__35288);
              var G__35299 = cljs.core.next.call(null, fs__35289);
              ret__35288 = G__35298;
              fs__35289 = G__35299;
              continue
            }else {
              return ret__35288
            }
            break
          }
        };
        var G__35297 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__35297__delegate.call(this, args)
        };
        G__35297.cljs$lang$maxFixedArity = 0;
        G__35297.cljs$lang$applyTo = function(arglist__35300) {
          var args = cljs.core.seq(arglist__35300);
          return G__35297__delegate(args)
        };
        G__35297.cljs$lang$arity$variadic = G__35297__delegate;
        return G__35297
      }()
    };
    var G__35296 = function(f1, f2, f3, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__35296__delegate.call(this, f1, f2, f3, fs)
    };
    G__35296.cljs$lang$maxFixedArity = 3;
    G__35296.cljs$lang$applyTo = function(arglist__35301) {
      var f1 = cljs.core.first(arglist__35301);
      var f2 = cljs.core.first(cljs.core.next(arglist__35301));
      var f3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35301)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__35301)));
      return G__35296__delegate(f1, f2, f3, fs)
    };
    G__35296.cljs$lang$arity$variadic = G__35296__delegate;
    return G__35296
  }();
  comp = function(f1, f2, f3, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 0:
        return comp__0.call(this);
      case 1:
        return comp__1.call(this, f1);
      case 2:
        return comp__2.call(this, f1, f2);
      case 3:
        return comp__3.call(this, f1, f2, f3);
      default:
        return comp__4.cljs$lang$arity$variadic(f1, f2, f3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  comp.cljs$lang$maxFixedArity = 3;
  comp.cljs$lang$applyTo = comp__4.cljs$lang$applyTo;
  comp.cljs$lang$arity$0 = comp__0;
  comp.cljs$lang$arity$1 = comp__1;
  comp.cljs$lang$arity$2 = comp__2;
  comp.cljs$lang$arity$3 = comp__3;
  comp.cljs$lang$arity$variadic = comp__4.cljs$lang$arity$variadic;
  return comp
}();
cljs.core.partial = function() {
  var partial = null;
  var partial__2 = function(f, arg1) {
    return function() {
      var G__35302__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, args)
      };
      var G__35302 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__35302__delegate.call(this, args)
      };
      G__35302.cljs$lang$maxFixedArity = 0;
      G__35302.cljs$lang$applyTo = function(arglist__35303) {
        var args = cljs.core.seq(arglist__35303);
        return G__35302__delegate(args)
      };
      G__35302.cljs$lang$arity$variadic = G__35302__delegate;
      return G__35302
    }()
  };
  var partial__3 = function(f, arg1, arg2) {
    return function() {
      var G__35304__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, args)
      };
      var G__35304 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__35304__delegate.call(this, args)
      };
      G__35304.cljs$lang$maxFixedArity = 0;
      G__35304.cljs$lang$applyTo = function(arglist__35305) {
        var args = cljs.core.seq(arglist__35305);
        return G__35304__delegate(args)
      };
      G__35304.cljs$lang$arity$variadic = G__35304__delegate;
      return G__35304
    }()
  };
  var partial__4 = function(f, arg1, arg2, arg3) {
    return function() {
      var G__35306__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, arg3, args)
      };
      var G__35306 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__35306__delegate.call(this, args)
      };
      G__35306.cljs$lang$maxFixedArity = 0;
      G__35306.cljs$lang$applyTo = function(arglist__35307) {
        var args = cljs.core.seq(arglist__35307);
        return G__35306__delegate(args)
      };
      G__35306.cljs$lang$arity$variadic = G__35306__delegate;
      return G__35306
    }()
  };
  var partial__5 = function() {
    var G__35308__delegate = function(f, arg1, arg2, arg3, more) {
      return function() {
        var G__35309__delegate = function(args) {
          return cljs.core.apply.call(null, f, arg1, arg2, arg3, cljs.core.concat.call(null, more, args))
        };
        var G__35309 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__35309__delegate.call(this, args)
        };
        G__35309.cljs$lang$maxFixedArity = 0;
        G__35309.cljs$lang$applyTo = function(arglist__35310) {
          var args = cljs.core.seq(arglist__35310);
          return G__35309__delegate(args)
        };
        G__35309.cljs$lang$arity$variadic = G__35309__delegate;
        return G__35309
      }()
    };
    var G__35308 = function(f, arg1, arg2, arg3, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__35308__delegate.call(this, f, arg1, arg2, arg3, more)
    };
    G__35308.cljs$lang$maxFixedArity = 4;
    G__35308.cljs$lang$applyTo = function(arglist__35311) {
      var f = cljs.core.first(arglist__35311);
      var arg1 = cljs.core.first(cljs.core.next(arglist__35311));
      var arg2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35311)));
      var arg3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__35311))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__35311))));
      return G__35308__delegate(f, arg1, arg2, arg3, more)
    };
    G__35308.cljs$lang$arity$variadic = G__35308__delegate;
    return G__35308
  }();
  partial = function(f, arg1, arg2, arg3, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return partial__2.call(this, f, arg1);
      case 3:
        return partial__3.call(this, f, arg1, arg2);
      case 4:
        return partial__4.call(this, f, arg1, arg2, arg3);
      default:
        return partial__5.cljs$lang$arity$variadic(f, arg1, arg2, arg3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  partial.cljs$lang$maxFixedArity = 4;
  partial.cljs$lang$applyTo = partial__5.cljs$lang$applyTo;
  partial.cljs$lang$arity$2 = partial__2;
  partial.cljs$lang$arity$3 = partial__3;
  partial.cljs$lang$arity$4 = partial__4;
  partial.cljs$lang$arity$variadic = partial__5.cljs$lang$arity$variadic;
  return partial
}();
cljs.core.fnil = function() {
  var fnil = null;
  var fnil__2 = function(f, x) {
    return function() {
      var G__35312 = null;
      var G__35312__1 = function(a) {
        return f.call(null, a == null ? x : a)
      };
      var G__35312__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b)
      };
      var G__35312__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b, c)
      };
      var G__35312__4 = function() {
        var G__35313__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b, c, ds)
        };
        var G__35313 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__35313__delegate.call(this, a, b, c, ds)
        };
        G__35313.cljs$lang$maxFixedArity = 3;
        G__35313.cljs$lang$applyTo = function(arglist__35314) {
          var a = cljs.core.first(arglist__35314);
          var b = cljs.core.first(cljs.core.next(arglist__35314));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35314)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__35314)));
          return G__35313__delegate(a, b, c, ds)
        };
        G__35313.cljs$lang$arity$variadic = G__35313__delegate;
        return G__35313
      }();
      G__35312 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 1:
            return G__35312__1.call(this, a);
          case 2:
            return G__35312__2.call(this, a, b);
          case 3:
            return G__35312__3.call(this, a, b, c);
          default:
            return G__35312__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__35312.cljs$lang$maxFixedArity = 3;
      G__35312.cljs$lang$applyTo = G__35312__4.cljs$lang$applyTo;
      return G__35312
    }()
  };
  var fnil__3 = function(f, x, y) {
    return function() {
      var G__35315 = null;
      var G__35315__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__35315__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c)
      };
      var G__35315__4 = function() {
        var G__35316__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c, ds)
        };
        var G__35316 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__35316__delegate.call(this, a, b, c, ds)
        };
        G__35316.cljs$lang$maxFixedArity = 3;
        G__35316.cljs$lang$applyTo = function(arglist__35317) {
          var a = cljs.core.first(arglist__35317);
          var b = cljs.core.first(cljs.core.next(arglist__35317));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35317)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__35317)));
          return G__35316__delegate(a, b, c, ds)
        };
        G__35316.cljs$lang$arity$variadic = G__35316__delegate;
        return G__35316
      }();
      G__35315 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__35315__2.call(this, a, b);
          case 3:
            return G__35315__3.call(this, a, b, c);
          default:
            return G__35315__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__35315.cljs$lang$maxFixedArity = 3;
      G__35315.cljs$lang$applyTo = G__35315__4.cljs$lang$applyTo;
      return G__35315
    }()
  };
  var fnil__4 = function(f, x, y, z) {
    return function() {
      var G__35318 = null;
      var G__35318__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__35318__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c == null ? z : c)
      };
      var G__35318__4 = function() {
        var G__35319__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds)
        };
        var G__35319 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__35319__delegate.call(this, a, b, c, ds)
        };
        G__35319.cljs$lang$maxFixedArity = 3;
        G__35319.cljs$lang$applyTo = function(arglist__35320) {
          var a = cljs.core.first(arglist__35320);
          var b = cljs.core.first(cljs.core.next(arglist__35320));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35320)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__35320)));
          return G__35319__delegate(a, b, c, ds)
        };
        G__35319.cljs$lang$arity$variadic = G__35319__delegate;
        return G__35319
      }();
      G__35318 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__35318__2.call(this, a, b);
          case 3:
            return G__35318__3.call(this, a, b, c);
          default:
            return G__35318__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__35318.cljs$lang$maxFixedArity = 3;
      G__35318.cljs$lang$applyTo = G__35318__4.cljs$lang$applyTo;
      return G__35318
    }()
  };
  fnil = function(f, x, y, z) {
    switch(arguments.length) {
      case 2:
        return fnil__2.call(this, f, x);
      case 3:
        return fnil__3.call(this, f, x, y);
      case 4:
        return fnil__4.call(this, f, x, y, z)
    }
    throw"Invalid arity: " + arguments.length;
  };
  fnil.cljs$lang$arity$2 = fnil__2;
  fnil.cljs$lang$arity$3 = fnil__3;
  fnil.cljs$lang$arity$4 = fnil__4;
  return fnil
}();
cljs.core.map_indexed = function map_indexed(f, coll) {
  var mapi__35336 = function mapi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____35344 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____35344) {
        var s__35345 = temp__3974__auto____35344;
        if(cljs.core.chunked_seq_QMARK_.call(null, s__35345)) {
          var c__35346 = cljs.core.chunk_first.call(null, s__35345);
          var size__35347 = cljs.core.count.call(null, c__35346);
          var b__35348 = cljs.core.chunk_buffer.call(null, size__35347);
          var n__2527__auto____35349 = size__35347;
          var i__35350 = 0;
          while(true) {
            if(i__35350 < n__2527__auto____35349) {
              cljs.core.chunk_append.call(null, b__35348, f.call(null, idx + i__35350, cljs.core._nth.call(null, c__35346, i__35350)));
              var G__35351 = i__35350 + 1;
              i__35350 = G__35351;
              continue
            }else {
            }
            break
          }
          return cljs.core.chunk_cons.call(null, cljs.core.chunk.call(null, b__35348), mapi.call(null, idx + size__35347, cljs.core.chunk_rest.call(null, s__35345)))
        }else {
          return cljs.core.cons.call(null, f.call(null, idx, cljs.core.first.call(null, s__35345)), mapi.call(null, idx + 1, cljs.core.rest.call(null, s__35345)))
        }
      }else {
        return null
      }
    }, null)
  };
  return mapi__35336.call(null, 0, coll)
};
cljs.core.keep = function keep(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3974__auto____35361 = cljs.core.seq.call(null, coll);
    if(temp__3974__auto____35361) {
      var s__35362 = temp__3974__auto____35361;
      if(cljs.core.chunked_seq_QMARK_.call(null, s__35362)) {
        var c__35363 = cljs.core.chunk_first.call(null, s__35362);
        var size__35364 = cljs.core.count.call(null, c__35363);
        var b__35365 = cljs.core.chunk_buffer.call(null, size__35364);
        var n__2527__auto____35366 = size__35364;
        var i__35367 = 0;
        while(true) {
          if(i__35367 < n__2527__auto____35366) {
            var x__35368 = f.call(null, cljs.core._nth.call(null, c__35363, i__35367));
            if(x__35368 == null) {
            }else {
              cljs.core.chunk_append.call(null, b__35365, x__35368)
            }
            var G__35370 = i__35367 + 1;
            i__35367 = G__35370;
            continue
          }else {
          }
          break
        }
        return cljs.core.chunk_cons.call(null, cljs.core.chunk.call(null, b__35365), keep.call(null, f, cljs.core.chunk_rest.call(null, s__35362)))
      }else {
        var x__35369 = f.call(null, cljs.core.first.call(null, s__35362));
        if(x__35369 == null) {
          return keep.call(null, f, cljs.core.rest.call(null, s__35362))
        }else {
          return cljs.core.cons.call(null, x__35369, keep.call(null, f, cljs.core.rest.call(null, s__35362)))
        }
      }
    }else {
      return null
    }
  }, null)
};
cljs.core.keep_indexed = function keep_indexed(f, coll) {
  var keepi__35396 = function keepi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____35406 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____35406) {
        var s__35407 = temp__3974__auto____35406;
        if(cljs.core.chunked_seq_QMARK_.call(null, s__35407)) {
          var c__35408 = cljs.core.chunk_first.call(null, s__35407);
          var size__35409 = cljs.core.count.call(null, c__35408);
          var b__35410 = cljs.core.chunk_buffer.call(null, size__35409);
          var n__2527__auto____35411 = size__35409;
          var i__35412 = 0;
          while(true) {
            if(i__35412 < n__2527__auto____35411) {
              var x__35413 = f.call(null, idx + i__35412, cljs.core._nth.call(null, c__35408, i__35412));
              if(x__35413 == null) {
              }else {
                cljs.core.chunk_append.call(null, b__35410, x__35413)
              }
              var G__35415 = i__35412 + 1;
              i__35412 = G__35415;
              continue
            }else {
            }
            break
          }
          return cljs.core.chunk_cons.call(null, cljs.core.chunk.call(null, b__35410), keepi.call(null, idx + size__35409, cljs.core.chunk_rest.call(null, s__35407)))
        }else {
          var x__35414 = f.call(null, idx, cljs.core.first.call(null, s__35407));
          if(x__35414 == null) {
            return keepi.call(null, idx + 1, cljs.core.rest.call(null, s__35407))
          }else {
            return cljs.core.cons.call(null, x__35414, keepi.call(null, idx + 1, cljs.core.rest.call(null, s__35407)))
          }
        }
      }else {
        return null
      }
    }, null)
  };
  return keepi__35396.call(null, 0, coll)
};
cljs.core.every_pred = function() {
  var every_pred = null;
  var every_pred__1 = function(p) {
    return function() {
      var ep1 = null;
      var ep1__0 = function() {
        return true
      };
      var ep1__1 = function(x) {
        return cljs.core.boolean$.call(null, p.call(null, x))
      };
      var ep1__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____35501 = p.call(null, x);
          if(cljs.core.truth_(and__3822__auto____35501)) {
            return p.call(null, y)
          }else {
            return and__3822__auto____35501
          }
        }())
      };
      var ep1__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____35502 = p.call(null, x);
          if(cljs.core.truth_(and__3822__auto____35502)) {
            var and__3822__auto____35503 = p.call(null, y);
            if(cljs.core.truth_(and__3822__auto____35503)) {
              return p.call(null, z)
            }else {
              return and__3822__auto____35503
            }
          }else {
            return and__3822__auto____35502
          }
        }())
      };
      var ep1__4 = function() {
        var G__35572__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3822__auto____35504 = ep1.call(null, x, y, z);
            if(cljs.core.truth_(and__3822__auto____35504)) {
              return cljs.core.every_QMARK_.call(null, p, args)
            }else {
              return and__3822__auto____35504
            }
          }())
        };
        var G__35572 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__35572__delegate.call(this, x, y, z, args)
        };
        G__35572.cljs$lang$maxFixedArity = 3;
        G__35572.cljs$lang$applyTo = function(arglist__35573) {
          var x = cljs.core.first(arglist__35573);
          var y = cljs.core.first(cljs.core.next(arglist__35573));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35573)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__35573)));
          return G__35572__delegate(x, y, z, args)
        };
        G__35572.cljs$lang$arity$variadic = G__35572__delegate;
        return G__35572
      }();
      ep1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep1__0.call(this);
          case 1:
            return ep1__1.call(this, x);
          case 2:
            return ep1__2.call(this, x, y);
          case 3:
            return ep1__3.call(this, x, y, z);
          default:
            return ep1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep1.cljs$lang$maxFixedArity = 3;
      ep1.cljs$lang$applyTo = ep1__4.cljs$lang$applyTo;
      ep1.cljs$lang$arity$0 = ep1__0;
      ep1.cljs$lang$arity$1 = ep1__1;
      ep1.cljs$lang$arity$2 = ep1__2;
      ep1.cljs$lang$arity$3 = ep1__3;
      ep1.cljs$lang$arity$variadic = ep1__4.cljs$lang$arity$variadic;
      return ep1
    }()
  };
  var every_pred__2 = function(p1, p2) {
    return function() {
      var ep2 = null;
      var ep2__0 = function() {
        return true
      };
      var ep2__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____35516 = p1.call(null, x);
          if(cljs.core.truth_(and__3822__auto____35516)) {
            return p2.call(null, x)
          }else {
            return and__3822__auto____35516
          }
        }())
      };
      var ep2__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____35517 = p1.call(null, x);
          if(cljs.core.truth_(and__3822__auto____35517)) {
            var and__3822__auto____35518 = p1.call(null, y);
            if(cljs.core.truth_(and__3822__auto____35518)) {
              var and__3822__auto____35519 = p2.call(null, x);
              if(cljs.core.truth_(and__3822__auto____35519)) {
                return p2.call(null, y)
              }else {
                return and__3822__auto____35519
              }
            }else {
              return and__3822__auto____35518
            }
          }else {
            return and__3822__auto____35517
          }
        }())
      };
      var ep2__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____35520 = p1.call(null, x);
          if(cljs.core.truth_(and__3822__auto____35520)) {
            var and__3822__auto____35521 = p1.call(null, y);
            if(cljs.core.truth_(and__3822__auto____35521)) {
              var and__3822__auto____35522 = p1.call(null, z);
              if(cljs.core.truth_(and__3822__auto____35522)) {
                var and__3822__auto____35523 = p2.call(null, x);
                if(cljs.core.truth_(and__3822__auto____35523)) {
                  var and__3822__auto____35524 = p2.call(null, y);
                  if(cljs.core.truth_(and__3822__auto____35524)) {
                    return p2.call(null, z)
                  }else {
                    return and__3822__auto____35524
                  }
                }else {
                  return and__3822__auto____35523
                }
              }else {
                return and__3822__auto____35522
              }
            }else {
              return and__3822__auto____35521
            }
          }else {
            return and__3822__auto____35520
          }
        }())
      };
      var ep2__4 = function() {
        var G__35574__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3822__auto____35525 = ep2.call(null, x, y, z);
            if(cljs.core.truth_(and__3822__auto____35525)) {
              return cljs.core.every_QMARK_.call(null, function(p1__35371_SHARP_) {
                var and__3822__auto____35526 = p1.call(null, p1__35371_SHARP_);
                if(cljs.core.truth_(and__3822__auto____35526)) {
                  return p2.call(null, p1__35371_SHARP_)
                }else {
                  return and__3822__auto____35526
                }
              }, args)
            }else {
              return and__3822__auto____35525
            }
          }())
        };
        var G__35574 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__35574__delegate.call(this, x, y, z, args)
        };
        G__35574.cljs$lang$maxFixedArity = 3;
        G__35574.cljs$lang$applyTo = function(arglist__35575) {
          var x = cljs.core.first(arglist__35575);
          var y = cljs.core.first(cljs.core.next(arglist__35575));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35575)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__35575)));
          return G__35574__delegate(x, y, z, args)
        };
        G__35574.cljs$lang$arity$variadic = G__35574__delegate;
        return G__35574
      }();
      ep2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep2__0.call(this);
          case 1:
            return ep2__1.call(this, x);
          case 2:
            return ep2__2.call(this, x, y);
          case 3:
            return ep2__3.call(this, x, y, z);
          default:
            return ep2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep2.cljs$lang$maxFixedArity = 3;
      ep2.cljs$lang$applyTo = ep2__4.cljs$lang$applyTo;
      ep2.cljs$lang$arity$0 = ep2__0;
      ep2.cljs$lang$arity$1 = ep2__1;
      ep2.cljs$lang$arity$2 = ep2__2;
      ep2.cljs$lang$arity$3 = ep2__3;
      ep2.cljs$lang$arity$variadic = ep2__4.cljs$lang$arity$variadic;
      return ep2
    }()
  };
  var every_pred__3 = function(p1, p2, p3) {
    return function() {
      var ep3 = null;
      var ep3__0 = function() {
        return true
      };
      var ep3__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____35545 = p1.call(null, x);
          if(cljs.core.truth_(and__3822__auto____35545)) {
            var and__3822__auto____35546 = p2.call(null, x);
            if(cljs.core.truth_(and__3822__auto____35546)) {
              return p3.call(null, x)
            }else {
              return and__3822__auto____35546
            }
          }else {
            return and__3822__auto____35545
          }
        }())
      };
      var ep3__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____35547 = p1.call(null, x);
          if(cljs.core.truth_(and__3822__auto____35547)) {
            var and__3822__auto____35548 = p2.call(null, x);
            if(cljs.core.truth_(and__3822__auto____35548)) {
              var and__3822__auto____35549 = p3.call(null, x);
              if(cljs.core.truth_(and__3822__auto____35549)) {
                var and__3822__auto____35550 = p1.call(null, y);
                if(cljs.core.truth_(and__3822__auto____35550)) {
                  var and__3822__auto____35551 = p2.call(null, y);
                  if(cljs.core.truth_(and__3822__auto____35551)) {
                    return p3.call(null, y)
                  }else {
                    return and__3822__auto____35551
                  }
                }else {
                  return and__3822__auto____35550
                }
              }else {
                return and__3822__auto____35549
              }
            }else {
              return and__3822__auto____35548
            }
          }else {
            return and__3822__auto____35547
          }
        }())
      };
      var ep3__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____35552 = p1.call(null, x);
          if(cljs.core.truth_(and__3822__auto____35552)) {
            var and__3822__auto____35553 = p2.call(null, x);
            if(cljs.core.truth_(and__3822__auto____35553)) {
              var and__3822__auto____35554 = p3.call(null, x);
              if(cljs.core.truth_(and__3822__auto____35554)) {
                var and__3822__auto____35555 = p1.call(null, y);
                if(cljs.core.truth_(and__3822__auto____35555)) {
                  var and__3822__auto____35556 = p2.call(null, y);
                  if(cljs.core.truth_(and__3822__auto____35556)) {
                    var and__3822__auto____35557 = p3.call(null, y);
                    if(cljs.core.truth_(and__3822__auto____35557)) {
                      var and__3822__auto____35558 = p1.call(null, z);
                      if(cljs.core.truth_(and__3822__auto____35558)) {
                        var and__3822__auto____35559 = p2.call(null, z);
                        if(cljs.core.truth_(and__3822__auto____35559)) {
                          return p3.call(null, z)
                        }else {
                          return and__3822__auto____35559
                        }
                      }else {
                        return and__3822__auto____35558
                      }
                    }else {
                      return and__3822__auto____35557
                    }
                  }else {
                    return and__3822__auto____35556
                  }
                }else {
                  return and__3822__auto____35555
                }
              }else {
                return and__3822__auto____35554
              }
            }else {
              return and__3822__auto____35553
            }
          }else {
            return and__3822__auto____35552
          }
        }())
      };
      var ep3__4 = function() {
        var G__35576__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3822__auto____35560 = ep3.call(null, x, y, z);
            if(cljs.core.truth_(and__3822__auto____35560)) {
              return cljs.core.every_QMARK_.call(null, function(p1__35372_SHARP_) {
                var and__3822__auto____35561 = p1.call(null, p1__35372_SHARP_);
                if(cljs.core.truth_(and__3822__auto____35561)) {
                  var and__3822__auto____35562 = p2.call(null, p1__35372_SHARP_);
                  if(cljs.core.truth_(and__3822__auto____35562)) {
                    return p3.call(null, p1__35372_SHARP_)
                  }else {
                    return and__3822__auto____35562
                  }
                }else {
                  return and__3822__auto____35561
                }
              }, args)
            }else {
              return and__3822__auto____35560
            }
          }())
        };
        var G__35576 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__35576__delegate.call(this, x, y, z, args)
        };
        G__35576.cljs$lang$maxFixedArity = 3;
        G__35576.cljs$lang$applyTo = function(arglist__35577) {
          var x = cljs.core.first(arglist__35577);
          var y = cljs.core.first(cljs.core.next(arglist__35577));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35577)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__35577)));
          return G__35576__delegate(x, y, z, args)
        };
        G__35576.cljs$lang$arity$variadic = G__35576__delegate;
        return G__35576
      }();
      ep3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep3__0.call(this);
          case 1:
            return ep3__1.call(this, x);
          case 2:
            return ep3__2.call(this, x, y);
          case 3:
            return ep3__3.call(this, x, y, z);
          default:
            return ep3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep3.cljs$lang$maxFixedArity = 3;
      ep3.cljs$lang$applyTo = ep3__4.cljs$lang$applyTo;
      ep3.cljs$lang$arity$0 = ep3__0;
      ep3.cljs$lang$arity$1 = ep3__1;
      ep3.cljs$lang$arity$2 = ep3__2;
      ep3.cljs$lang$arity$3 = ep3__3;
      ep3.cljs$lang$arity$variadic = ep3__4.cljs$lang$arity$variadic;
      return ep3
    }()
  };
  var every_pred__4 = function() {
    var G__35578__delegate = function(p1, p2, p3, ps) {
      var ps__35563 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var epn = null;
        var epn__0 = function() {
          return true
        };
        var epn__1 = function(x) {
          return cljs.core.every_QMARK_.call(null, function(p1__35373_SHARP_) {
            return p1__35373_SHARP_.call(null, x)
          }, ps__35563)
        };
        var epn__2 = function(x, y) {
          return cljs.core.every_QMARK_.call(null, function(p1__35374_SHARP_) {
            var and__3822__auto____35568 = p1__35374_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3822__auto____35568)) {
              return p1__35374_SHARP_.call(null, y)
            }else {
              return and__3822__auto____35568
            }
          }, ps__35563)
        };
        var epn__3 = function(x, y, z) {
          return cljs.core.every_QMARK_.call(null, function(p1__35375_SHARP_) {
            var and__3822__auto____35569 = p1__35375_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3822__auto____35569)) {
              var and__3822__auto____35570 = p1__35375_SHARP_.call(null, y);
              if(cljs.core.truth_(and__3822__auto____35570)) {
                return p1__35375_SHARP_.call(null, z)
              }else {
                return and__3822__auto____35570
              }
            }else {
              return and__3822__auto____35569
            }
          }, ps__35563)
        };
        var epn__4 = function() {
          var G__35579__delegate = function(x, y, z, args) {
            return cljs.core.boolean$.call(null, function() {
              var and__3822__auto____35571 = epn.call(null, x, y, z);
              if(cljs.core.truth_(and__3822__auto____35571)) {
                return cljs.core.every_QMARK_.call(null, function(p1__35376_SHARP_) {
                  return cljs.core.every_QMARK_.call(null, p1__35376_SHARP_, args)
                }, ps__35563)
              }else {
                return and__3822__auto____35571
              }
            }())
          };
          var G__35579 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__35579__delegate.call(this, x, y, z, args)
          };
          G__35579.cljs$lang$maxFixedArity = 3;
          G__35579.cljs$lang$applyTo = function(arglist__35580) {
            var x = cljs.core.first(arglist__35580);
            var y = cljs.core.first(cljs.core.next(arglist__35580));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35580)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__35580)));
            return G__35579__delegate(x, y, z, args)
          };
          G__35579.cljs$lang$arity$variadic = G__35579__delegate;
          return G__35579
        }();
        epn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return epn__0.call(this);
            case 1:
              return epn__1.call(this, x);
            case 2:
              return epn__2.call(this, x, y);
            case 3:
              return epn__3.call(this, x, y, z);
            default:
              return epn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        epn.cljs$lang$maxFixedArity = 3;
        epn.cljs$lang$applyTo = epn__4.cljs$lang$applyTo;
        epn.cljs$lang$arity$0 = epn__0;
        epn.cljs$lang$arity$1 = epn__1;
        epn.cljs$lang$arity$2 = epn__2;
        epn.cljs$lang$arity$3 = epn__3;
        epn.cljs$lang$arity$variadic = epn__4.cljs$lang$arity$variadic;
        return epn
      }()
    };
    var G__35578 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__35578__delegate.call(this, p1, p2, p3, ps)
    };
    G__35578.cljs$lang$maxFixedArity = 3;
    G__35578.cljs$lang$applyTo = function(arglist__35581) {
      var p1 = cljs.core.first(arglist__35581);
      var p2 = cljs.core.first(cljs.core.next(arglist__35581));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35581)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__35581)));
      return G__35578__delegate(p1, p2, p3, ps)
    };
    G__35578.cljs$lang$arity$variadic = G__35578__delegate;
    return G__35578
  }();
  every_pred = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return every_pred__1.call(this, p1);
      case 2:
        return every_pred__2.call(this, p1, p2);
      case 3:
        return every_pred__3.call(this, p1, p2, p3);
      default:
        return every_pred__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  every_pred.cljs$lang$maxFixedArity = 3;
  every_pred.cljs$lang$applyTo = every_pred__4.cljs$lang$applyTo;
  every_pred.cljs$lang$arity$1 = every_pred__1;
  every_pred.cljs$lang$arity$2 = every_pred__2;
  every_pred.cljs$lang$arity$3 = every_pred__3;
  every_pred.cljs$lang$arity$variadic = every_pred__4.cljs$lang$arity$variadic;
  return every_pred
}();
cljs.core.some_fn = function() {
  var some_fn = null;
  var some_fn__1 = function(p) {
    return function() {
      var sp1 = null;
      var sp1__0 = function() {
        return null
      };
      var sp1__1 = function(x) {
        return p.call(null, x)
      };
      var sp1__2 = function(x, y) {
        var or__3824__auto____35662 = p.call(null, x);
        if(cljs.core.truth_(or__3824__auto____35662)) {
          return or__3824__auto____35662
        }else {
          return p.call(null, y)
        }
      };
      var sp1__3 = function(x, y, z) {
        var or__3824__auto____35663 = p.call(null, x);
        if(cljs.core.truth_(or__3824__auto____35663)) {
          return or__3824__auto____35663
        }else {
          var or__3824__auto____35664 = p.call(null, y);
          if(cljs.core.truth_(or__3824__auto____35664)) {
            return or__3824__auto____35664
          }else {
            return p.call(null, z)
          }
        }
      };
      var sp1__4 = function() {
        var G__35733__delegate = function(x, y, z, args) {
          var or__3824__auto____35665 = sp1.call(null, x, y, z);
          if(cljs.core.truth_(or__3824__auto____35665)) {
            return or__3824__auto____35665
          }else {
            return cljs.core.some.call(null, p, args)
          }
        };
        var G__35733 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__35733__delegate.call(this, x, y, z, args)
        };
        G__35733.cljs$lang$maxFixedArity = 3;
        G__35733.cljs$lang$applyTo = function(arglist__35734) {
          var x = cljs.core.first(arglist__35734);
          var y = cljs.core.first(cljs.core.next(arglist__35734));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35734)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__35734)));
          return G__35733__delegate(x, y, z, args)
        };
        G__35733.cljs$lang$arity$variadic = G__35733__delegate;
        return G__35733
      }();
      sp1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp1__0.call(this);
          case 1:
            return sp1__1.call(this, x);
          case 2:
            return sp1__2.call(this, x, y);
          case 3:
            return sp1__3.call(this, x, y, z);
          default:
            return sp1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp1.cljs$lang$maxFixedArity = 3;
      sp1.cljs$lang$applyTo = sp1__4.cljs$lang$applyTo;
      sp1.cljs$lang$arity$0 = sp1__0;
      sp1.cljs$lang$arity$1 = sp1__1;
      sp1.cljs$lang$arity$2 = sp1__2;
      sp1.cljs$lang$arity$3 = sp1__3;
      sp1.cljs$lang$arity$variadic = sp1__4.cljs$lang$arity$variadic;
      return sp1
    }()
  };
  var some_fn__2 = function(p1, p2) {
    return function() {
      var sp2 = null;
      var sp2__0 = function() {
        return null
      };
      var sp2__1 = function(x) {
        var or__3824__auto____35677 = p1.call(null, x);
        if(cljs.core.truth_(or__3824__auto____35677)) {
          return or__3824__auto____35677
        }else {
          return p2.call(null, x)
        }
      };
      var sp2__2 = function(x, y) {
        var or__3824__auto____35678 = p1.call(null, x);
        if(cljs.core.truth_(or__3824__auto____35678)) {
          return or__3824__auto____35678
        }else {
          var or__3824__auto____35679 = p1.call(null, y);
          if(cljs.core.truth_(or__3824__auto____35679)) {
            return or__3824__auto____35679
          }else {
            var or__3824__auto____35680 = p2.call(null, x);
            if(cljs.core.truth_(or__3824__auto____35680)) {
              return or__3824__auto____35680
            }else {
              return p2.call(null, y)
            }
          }
        }
      };
      var sp2__3 = function(x, y, z) {
        var or__3824__auto____35681 = p1.call(null, x);
        if(cljs.core.truth_(or__3824__auto____35681)) {
          return or__3824__auto____35681
        }else {
          var or__3824__auto____35682 = p1.call(null, y);
          if(cljs.core.truth_(or__3824__auto____35682)) {
            return or__3824__auto____35682
          }else {
            var or__3824__auto____35683 = p1.call(null, z);
            if(cljs.core.truth_(or__3824__auto____35683)) {
              return or__3824__auto____35683
            }else {
              var or__3824__auto____35684 = p2.call(null, x);
              if(cljs.core.truth_(or__3824__auto____35684)) {
                return or__3824__auto____35684
              }else {
                var or__3824__auto____35685 = p2.call(null, y);
                if(cljs.core.truth_(or__3824__auto____35685)) {
                  return or__3824__auto____35685
                }else {
                  return p2.call(null, z)
                }
              }
            }
          }
        }
      };
      var sp2__4 = function() {
        var G__35735__delegate = function(x, y, z, args) {
          var or__3824__auto____35686 = sp2.call(null, x, y, z);
          if(cljs.core.truth_(or__3824__auto____35686)) {
            return or__3824__auto____35686
          }else {
            return cljs.core.some.call(null, function(p1__35416_SHARP_) {
              var or__3824__auto____35687 = p1.call(null, p1__35416_SHARP_);
              if(cljs.core.truth_(or__3824__auto____35687)) {
                return or__3824__auto____35687
              }else {
                return p2.call(null, p1__35416_SHARP_)
              }
            }, args)
          }
        };
        var G__35735 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__35735__delegate.call(this, x, y, z, args)
        };
        G__35735.cljs$lang$maxFixedArity = 3;
        G__35735.cljs$lang$applyTo = function(arglist__35736) {
          var x = cljs.core.first(arglist__35736);
          var y = cljs.core.first(cljs.core.next(arglist__35736));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35736)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__35736)));
          return G__35735__delegate(x, y, z, args)
        };
        G__35735.cljs$lang$arity$variadic = G__35735__delegate;
        return G__35735
      }();
      sp2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp2__0.call(this);
          case 1:
            return sp2__1.call(this, x);
          case 2:
            return sp2__2.call(this, x, y);
          case 3:
            return sp2__3.call(this, x, y, z);
          default:
            return sp2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp2.cljs$lang$maxFixedArity = 3;
      sp2.cljs$lang$applyTo = sp2__4.cljs$lang$applyTo;
      sp2.cljs$lang$arity$0 = sp2__0;
      sp2.cljs$lang$arity$1 = sp2__1;
      sp2.cljs$lang$arity$2 = sp2__2;
      sp2.cljs$lang$arity$3 = sp2__3;
      sp2.cljs$lang$arity$variadic = sp2__4.cljs$lang$arity$variadic;
      return sp2
    }()
  };
  var some_fn__3 = function(p1, p2, p3) {
    return function() {
      var sp3 = null;
      var sp3__0 = function() {
        return null
      };
      var sp3__1 = function(x) {
        var or__3824__auto____35706 = p1.call(null, x);
        if(cljs.core.truth_(or__3824__auto____35706)) {
          return or__3824__auto____35706
        }else {
          var or__3824__auto____35707 = p2.call(null, x);
          if(cljs.core.truth_(or__3824__auto____35707)) {
            return or__3824__auto____35707
          }else {
            return p3.call(null, x)
          }
        }
      };
      var sp3__2 = function(x, y) {
        var or__3824__auto____35708 = p1.call(null, x);
        if(cljs.core.truth_(or__3824__auto____35708)) {
          return or__3824__auto____35708
        }else {
          var or__3824__auto____35709 = p2.call(null, x);
          if(cljs.core.truth_(or__3824__auto____35709)) {
            return or__3824__auto____35709
          }else {
            var or__3824__auto____35710 = p3.call(null, x);
            if(cljs.core.truth_(or__3824__auto____35710)) {
              return or__3824__auto____35710
            }else {
              var or__3824__auto____35711 = p1.call(null, y);
              if(cljs.core.truth_(or__3824__auto____35711)) {
                return or__3824__auto____35711
              }else {
                var or__3824__auto____35712 = p2.call(null, y);
                if(cljs.core.truth_(or__3824__auto____35712)) {
                  return or__3824__auto____35712
                }else {
                  return p3.call(null, y)
                }
              }
            }
          }
        }
      };
      var sp3__3 = function(x, y, z) {
        var or__3824__auto____35713 = p1.call(null, x);
        if(cljs.core.truth_(or__3824__auto____35713)) {
          return or__3824__auto____35713
        }else {
          var or__3824__auto____35714 = p2.call(null, x);
          if(cljs.core.truth_(or__3824__auto____35714)) {
            return or__3824__auto____35714
          }else {
            var or__3824__auto____35715 = p3.call(null, x);
            if(cljs.core.truth_(or__3824__auto____35715)) {
              return or__3824__auto____35715
            }else {
              var or__3824__auto____35716 = p1.call(null, y);
              if(cljs.core.truth_(or__3824__auto____35716)) {
                return or__3824__auto____35716
              }else {
                var or__3824__auto____35717 = p2.call(null, y);
                if(cljs.core.truth_(or__3824__auto____35717)) {
                  return or__3824__auto____35717
                }else {
                  var or__3824__auto____35718 = p3.call(null, y);
                  if(cljs.core.truth_(or__3824__auto____35718)) {
                    return or__3824__auto____35718
                  }else {
                    var or__3824__auto____35719 = p1.call(null, z);
                    if(cljs.core.truth_(or__3824__auto____35719)) {
                      return or__3824__auto____35719
                    }else {
                      var or__3824__auto____35720 = p2.call(null, z);
                      if(cljs.core.truth_(or__3824__auto____35720)) {
                        return or__3824__auto____35720
                      }else {
                        return p3.call(null, z)
                      }
                    }
                  }
                }
              }
            }
          }
        }
      };
      var sp3__4 = function() {
        var G__35737__delegate = function(x, y, z, args) {
          var or__3824__auto____35721 = sp3.call(null, x, y, z);
          if(cljs.core.truth_(or__3824__auto____35721)) {
            return or__3824__auto____35721
          }else {
            return cljs.core.some.call(null, function(p1__35417_SHARP_) {
              var or__3824__auto____35722 = p1.call(null, p1__35417_SHARP_);
              if(cljs.core.truth_(or__3824__auto____35722)) {
                return or__3824__auto____35722
              }else {
                var or__3824__auto____35723 = p2.call(null, p1__35417_SHARP_);
                if(cljs.core.truth_(or__3824__auto____35723)) {
                  return or__3824__auto____35723
                }else {
                  return p3.call(null, p1__35417_SHARP_)
                }
              }
            }, args)
          }
        };
        var G__35737 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__35737__delegate.call(this, x, y, z, args)
        };
        G__35737.cljs$lang$maxFixedArity = 3;
        G__35737.cljs$lang$applyTo = function(arglist__35738) {
          var x = cljs.core.first(arglist__35738);
          var y = cljs.core.first(cljs.core.next(arglist__35738));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35738)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__35738)));
          return G__35737__delegate(x, y, z, args)
        };
        G__35737.cljs$lang$arity$variadic = G__35737__delegate;
        return G__35737
      }();
      sp3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp3__0.call(this);
          case 1:
            return sp3__1.call(this, x);
          case 2:
            return sp3__2.call(this, x, y);
          case 3:
            return sp3__3.call(this, x, y, z);
          default:
            return sp3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp3.cljs$lang$maxFixedArity = 3;
      sp3.cljs$lang$applyTo = sp3__4.cljs$lang$applyTo;
      sp3.cljs$lang$arity$0 = sp3__0;
      sp3.cljs$lang$arity$1 = sp3__1;
      sp3.cljs$lang$arity$2 = sp3__2;
      sp3.cljs$lang$arity$3 = sp3__3;
      sp3.cljs$lang$arity$variadic = sp3__4.cljs$lang$arity$variadic;
      return sp3
    }()
  };
  var some_fn__4 = function() {
    var G__35739__delegate = function(p1, p2, p3, ps) {
      var ps__35724 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var spn = null;
        var spn__0 = function() {
          return null
        };
        var spn__1 = function(x) {
          return cljs.core.some.call(null, function(p1__35418_SHARP_) {
            return p1__35418_SHARP_.call(null, x)
          }, ps__35724)
        };
        var spn__2 = function(x, y) {
          return cljs.core.some.call(null, function(p1__35419_SHARP_) {
            var or__3824__auto____35729 = p1__35419_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3824__auto____35729)) {
              return or__3824__auto____35729
            }else {
              return p1__35419_SHARP_.call(null, y)
            }
          }, ps__35724)
        };
        var spn__3 = function(x, y, z) {
          return cljs.core.some.call(null, function(p1__35420_SHARP_) {
            var or__3824__auto____35730 = p1__35420_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3824__auto____35730)) {
              return or__3824__auto____35730
            }else {
              var or__3824__auto____35731 = p1__35420_SHARP_.call(null, y);
              if(cljs.core.truth_(or__3824__auto____35731)) {
                return or__3824__auto____35731
              }else {
                return p1__35420_SHARP_.call(null, z)
              }
            }
          }, ps__35724)
        };
        var spn__4 = function() {
          var G__35740__delegate = function(x, y, z, args) {
            var or__3824__auto____35732 = spn.call(null, x, y, z);
            if(cljs.core.truth_(or__3824__auto____35732)) {
              return or__3824__auto____35732
            }else {
              return cljs.core.some.call(null, function(p1__35421_SHARP_) {
                return cljs.core.some.call(null, p1__35421_SHARP_, args)
              }, ps__35724)
            }
          };
          var G__35740 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__35740__delegate.call(this, x, y, z, args)
          };
          G__35740.cljs$lang$maxFixedArity = 3;
          G__35740.cljs$lang$applyTo = function(arglist__35741) {
            var x = cljs.core.first(arglist__35741);
            var y = cljs.core.first(cljs.core.next(arglist__35741));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35741)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__35741)));
            return G__35740__delegate(x, y, z, args)
          };
          G__35740.cljs$lang$arity$variadic = G__35740__delegate;
          return G__35740
        }();
        spn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return spn__0.call(this);
            case 1:
              return spn__1.call(this, x);
            case 2:
              return spn__2.call(this, x, y);
            case 3:
              return spn__3.call(this, x, y, z);
            default:
              return spn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        spn.cljs$lang$maxFixedArity = 3;
        spn.cljs$lang$applyTo = spn__4.cljs$lang$applyTo;
        spn.cljs$lang$arity$0 = spn__0;
        spn.cljs$lang$arity$1 = spn__1;
        spn.cljs$lang$arity$2 = spn__2;
        spn.cljs$lang$arity$3 = spn__3;
        spn.cljs$lang$arity$variadic = spn__4.cljs$lang$arity$variadic;
        return spn
      }()
    };
    var G__35739 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__35739__delegate.call(this, p1, p2, p3, ps)
    };
    G__35739.cljs$lang$maxFixedArity = 3;
    G__35739.cljs$lang$applyTo = function(arglist__35742) {
      var p1 = cljs.core.first(arglist__35742);
      var p2 = cljs.core.first(cljs.core.next(arglist__35742));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35742)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__35742)));
      return G__35739__delegate(p1, p2, p3, ps)
    };
    G__35739.cljs$lang$arity$variadic = G__35739__delegate;
    return G__35739
  }();
  some_fn = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return some_fn__1.call(this, p1);
      case 2:
        return some_fn__2.call(this, p1, p2);
      case 3:
        return some_fn__3.call(this, p1, p2, p3);
      default:
        return some_fn__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  some_fn.cljs$lang$maxFixedArity = 3;
  some_fn.cljs$lang$applyTo = some_fn__4.cljs$lang$applyTo;
  some_fn.cljs$lang$arity$1 = some_fn__1;
  some_fn.cljs$lang$arity$2 = some_fn__2;
  some_fn.cljs$lang$arity$3 = some_fn__3;
  some_fn.cljs$lang$arity$variadic = some_fn__4.cljs$lang$arity$variadic;
  return some_fn
}();
cljs.core.map = function() {
  var map = null;
  var map__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____35761 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____35761) {
        var s__35762 = temp__3974__auto____35761;
        if(cljs.core.chunked_seq_QMARK_.call(null, s__35762)) {
          var c__35763 = cljs.core.chunk_first.call(null, s__35762);
          var size__35764 = cljs.core.count.call(null, c__35763);
          var b__35765 = cljs.core.chunk_buffer.call(null, size__35764);
          var n__2527__auto____35766 = size__35764;
          var i__35767 = 0;
          while(true) {
            if(i__35767 < n__2527__auto____35766) {
              cljs.core.chunk_append.call(null, b__35765, f.call(null, cljs.core._nth.call(null, c__35763, i__35767)));
              var G__35779 = i__35767 + 1;
              i__35767 = G__35779;
              continue
            }else {
            }
            break
          }
          return cljs.core.chunk_cons.call(null, cljs.core.chunk.call(null, b__35765), map.call(null, f, cljs.core.chunk_rest.call(null, s__35762)))
        }else {
          return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s__35762)), map.call(null, f, cljs.core.rest.call(null, s__35762)))
        }
      }else {
        return null
      }
    }, null)
  };
  var map__3 = function(f, c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__35768 = cljs.core.seq.call(null, c1);
      var s2__35769 = cljs.core.seq.call(null, c2);
      if(function() {
        var and__3822__auto____35770 = s1__35768;
        if(and__3822__auto____35770) {
          return s2__35769
        }else {
          return and__3822__auto____35770
        }
      }()) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__35768), cljs.core.first.call(null, s2__35769)), map.call(null, f, cljs.core.rest.call(null, s1__35768), cljs.core.rest.call(null, s2__35769)))
      }else {
        return null
      }
    }, null)
  };
  var map__4 = function(f, c1, c2, c3) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__35771 = cljs.core.seq.call(null, c1);
      var s2__35772 = cljs.core.seq.call(null, c2);
      var s3__35773 = cljs.core.seq.call(null, c3);
      if(function() {
        var and__3822__auto____35774 = s1__35771;
        if(and__3822__auto____35774) {
          var and__3822__auto____35775 = s2__35772;
          if(and__3822__auto____35775) {
            return s3__35773
          }else {
            return and__3822__auto____35775
          }
        }else {
          return and__3822__auto____35774
        }
      }()) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__35771), cljs.core.first.call(null, s2__35772), cljs.core.first.call(null, s3__35773)), map.call(null, f, cljs.core.rest.call(null, s1__35771), cljs.core.rest.call(null, s2__35772), cljs.core.rest.call(null, s3__35773)))
      }else {
        return null
      }
    }, null)
  };
  var map__5 = function() {
    var G__35780__delegate = function(f, c1, c2, c3, colls) {
      var step__35778 = function step(cs) {
        return new cljs.core.LazySeq(null, false, function() {
          var ss__35777 = map.call(null, cljs.core.seq, cs);
          if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__35777)) {
            return cljs.core.cons.call(null, map.call(null, cljs.core.first, ss__35777), step.call(null, map.call(null, cljs.core.rest, ss__35777)))
          }else {
            return null
          }
        }, null)
      };
      return map.call(null, function(p1__35582_SHARP_) {
        return cljs.core.apply.call(null, f, p1__35582_SHARP_)
      }, step__35778.call(null, cljs.core.conj.call(null, colls, c3, c2, c1)))
    };
    var G__35780 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__35780__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__35780.cljs$lang$maxFixedArity = 4;
    G__35780.cljs$lang$applyTo = function(arglist__35781) {
      var f = cljs.core.first(arglist__35781);
      var c1 = cljs.core.first(cljs.core.next(arglist__35781));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35781)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__35781))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__35781))));
      return G__35780__delegate(f, c1, c2, c3, colls)
    };
    G__35780.cljs$lang$arity$variadic = G__35780__delegate;
    return G__35780
  }();
  map = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return map__2.call(this, f, c1);
      case 3:
        return map__3.call(this, f, c1, c2);
      case 4:
        return map__4.call(this, f, c1, c2, c3);
      default:
        return map__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  map.cljs$lang$maxFixedArity = 4;
  map.cljs$lang$applyTo = map__5.cljs$lang$applyTo;
  map.cljs$lang$arity$2 = map__2;
  map.cljs$lang$arity$3 = map__3;
  map.cljs$lang$arity$4 = map__4;
  map.cljs$lang$arity$variadic = map__5.cljs$lang$arity$variadic;
  return map
}();
cljs.core.take = function take(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    if(n > 0) {
      var temp__3974__auto____35784 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____35784) {
        var s__35785 = temp__3974__auto____35784;
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__35785), take.call(null, n - 1, cljs.core.rest.call(null, s__35785)))
      }else {
        return null
      }
    }else {
      return null
    }
  }, null)
};
cljs.core.drop = function drop(n, coll) {
  var step__35791 = function(n, coll) {
    while(true) {
      var s__35789 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3822__auto____35790 = n > 0;
        if(and__3822__auto____35790) {
          return s__35789
        }else {
          return and__3822__auto____35790
        }
      }())) {
        var G__35792 = n - 1;
        var G__35793 = cljs.core.rest.call(null, s__35789);
        n = G__35792;
        coll = G__35793;
        continue
      }else {
        return s__35789
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__35791.call(null, n, coll)
  }, null)
};
cljs.core.drop_last = function() {
  var drop_last = null;
  var drop_last__1 = function(s) {
    return drop_last.call(null, 1, s)
  };
  var drop_last__2 = function(n, s) {
    return cljs.core.map.call(null, function(x, _) {
      return x
    }, s, cljs.core.drop.call(null, n, s))
  };
  drop_last = function(n, s) {
    switch(arguments.length) {
      case 1:
        return drop_last__1.call(this, n);
      case 2:
        return drop_last__2.call(this, n, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  drop_last.cljs$lang$arity$1 = drop_last__1;
  drop_last.cljs$lang$arity$2 = drop_last__2;
  return drop_last
}();
cljs.core.take_last = function take_last(n, coll) {
  var s__35796 = cljs.core.seq.call(null, coll);
  var lead__35797 = cljs.core.seq.call(null, cljs.core.drop.call(null, n, coll));
  while(true) {
    if(lead__35797) {
      var G__35798 = cljs.core.next.call(null, s__35796);
      var G__35799 = cljs.core.next.call(null, lead__35797);
      s__35796 = G__35798;
      lead__35797 = G__35799;
      continue
    }else {
      return s__35796
    }
    break
  }
};
cljs.core.drop_while = function drop_while(pred, coll) {
  var step__35805 = function(pred, coll) {
    while(true) {
      var s__35803 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3822__auto____35804 = s__35803;
        if(and__3822__auto____35804) {
          return pred.call(null, cljs.core.first.call(null, s__35803))
        }else {
          return and__3822__auto____35804
        }
      }())) {
        var G__35806 = pred;
        var G__35807 = cljs.core.rest.call(null, s__35803);
        pred = G__35806;
        coll = G__35807;
        continue
      }else {
        return s__35803
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__35805.call(null, pred, coll)
  }, null)
};
cljs.core.cycle = function cycle(coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3974__auto____35810 = cljs.core.seq.call(null, coll);
    if(temp__3974__auto____35810) {
      var s__35811 = temp__3974__auto____35810;
      return cljs.core.concat.call(null, s__35811, cycle.call(null, s__35811))
    }else {
      return null
    }
  }, null)
};
cljs.core.split_at = function split_at(n, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take.call(null, n, coll), cljs.core.drop.call(null, n, coll)], true)
};
cljs.core.repeat = function() {
  var repeat = null;
  var repeat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, x, repeat.call(null, x))
    }, null)
  };
  var repeat__2 = function(n, x) {
    return cljs.core.take.call(null, n, repeat.call(null, x))
  };
  repeat = function(n, x) {
    switch(arguments.length) {
      case 1:
        return repeat__1.call(this, n);
      case 2:
        return repeat__2.call(this, n, x)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeat.cljs$lang$arity$1 = repeat__1;
  repeat.cljs$lang$arity$2 = repeat__2;
  return repeat
}();
cljs.core.replicate = function replicate(n, x) {
  return cljs.core.take.call(null, n, cljs.core.repeat.call(null, x))
};
cljs.core.repeatedly = function() {
  var repeatedly = null;
  var repeatedly__1 = function(f) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, f.call(null), repeatedly.call(null, f))
    }, null)
  };
  var repeatedly__2 = function(n, f) {
    return cljs.core.take.call(null, n, repeatedly.call(null, f))
  };
  repeatedly = function(n, f) {
    switch(arguments.length) {
      case 1:
        return repeatedly__1.call(this, n);
      case 2:
        return repeatedly__2.call(this, n, f)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeatedly.cljs$lang$arity$1 = repeatedly__1;
  repeatedly.cljs$lang$arity$2 = repeatedly__2;
  return repeatedly
}();
cljs.core.iterate = function iterate(f, x) {
  return cljs.core.cons.call(null, x, new cljs.core.LazySeq(null, false, function() {
    return iterate.call(null, f, f.call(null, x))
  }, null))
};
cljs.core.interleave = function() {
  var interleave = null;
  var interleave__2 = function(c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__35816 = cljs.core.seq.call(null, c1);
      var s2__35817 = cljs.core.seq.call(null, c2);
      if(function() {
        var and__3822__auto____35818 = s1__35816;
        if(and__3822__auto____35818) {
          return s2__35817
        }else {
          return and__3822__auto____35818
        }
      }()) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s1__35816), cljs.core.cons.call(null, cljs.core.first.call(null, s2__35817), interleave.call(null, cljs.core.rest.call(null, s1__35816), cljs.core.rest.call(null, s2__35817))))
      }else {
        return null
      }
    }, null)
  };
  var interleave__3 = function() {
    var G__35820__delegate = function(c1, c2, colls) {
      return new cljs.core.LazySeq(null, false, function() {
        var ss__35819 = cljs.core.map.call(null, cljs.core.seq, cljs.core.conj.call(null, colls, c2, c1));
        if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__35819)) {
          return cljs.core.concat.call(null, cljs.core.map.call(null, cljs.core.first, ss__35819), cljs.core.apply.call(null, interleave, cljs.core.map.call(null, cljs.core.rest, ss__35819)))
        }else {
          return null
        }
      }, null)
    };
    var G__35820 = function(c1, c2, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__35820__delegate.call(this, c1, c2, colls)
    };
    G__35820.cljs$lang$maxFixedArity = 2;
    G__35820.cljs$lang$applyTo = function(arglist__35821) {
      var c1 = cljs.core.first(arglist__35821);
      var c2 = cljs.core.first(cljs.core.next(arglist__35821));
      var colls = cljs.core.rest(cljs.core.next(arglist__35821));
      return G__35820__delegate(c1, c2, colls)
    };
    G__35820.cljs$lang$arity$variadic = G__35820__delegate;
    return G__35820
  }();
  interleave = function(c1, c2, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return interleave__2.call(this, c1, c2);
      default:
        return interleave__3.cljs$lang$arity$variadic(c1, c2, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  interleave.cljs$lang$maxFixedArity = 2;
  interleave.cljs$lang$applyTo = interleave__3.cljs$lang$applyTo;
  interleave.cljs$lang$arity$2 = interleave__2;
  interleave.cljs$lang$arity$variadic = interleave__3.cljs$lang$arity$variadic;
  return interleave
}();
cljs.core.interpose = function interpose(sep, coll) {
  return cljs.core.drop.call(null, 1, cljs.core.interleave.call(null, cljs.core.repeat.call(null, sep), coll))
};
cljs.core.flatten1 = function flatten1(colls) {
  var cat__35831 = function cat(coll, colls) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3971__auto____35829 = cljs.core.seq.call(null, coll);
      if(temp__3971__auto____35829) {
        var coll__35830 = temp__3971__auto____35829;
        return cljs.core.cons.call(null, cljs.core.first.call(null, coll__35830), cat.call(null, cljs.core.rest.call(null, coll__35830), colls))
      }else {
        if(cljs.core.seq.call(null, colls)) {
          return cat.call(null, cljs.core.first.call(null, colls), cljs.core.rest.call(null, colls))
        }else {
          return null
        }
      }
    }, null)
  };
  return cat__35831.call(null, null, colls)
};
cljs.core.mapcat = function() {
  var mapcat = null;
  var mapcat__2 = function(f, coll) {
    return cljs.core.flatten1.call(null, cljs.core.map.call(null, f, coll))
  };
  var mapcat__3 = function() {
    var G__35832__delegate = function(f, coll, colls) {
      return cljs.core.flatten1.call(null, cljs.core.apply.call(null, cljs.core.map, f, coll, colls))
    };
    var G__35832 = function(f, coll, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__35832__delegate.call(this, f, coll, colls)
    };
    G__35832.cljs$lang$maxFixedArity = 2;
    G__35832.cljs$lang$applyTo = function(arglist__35833) {
      var f = cljs.core.first(arglist__35833);
      var coll = cljs.core.first(cljs.core.next(arglist__35833));
      var colls = cljs.core.rest(cljs.core.next(arglist__35833));
      return G__35832__delegate(f, coll, colls)
    };
    G__35832.cljs$lang$arity$variadic = G__35832__delegate;
    return G__35832
  }();
  mapcat = function(f, coll, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapcat__2.call(this, f, coll);
      default:
        return mapcat__3.cljs$lang$arity$variadic(f, coll, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapcat.cljs$lang$maxFixedArity = 2;
  mapcat.cljs$lang$applyTo = mapcat__3.cljs$lang$applyTo;
  mapcat.cljs$lang$arity$2 = mapcat__2;
  mapcat.cljs$lang$arity$variadic = mapcat__3.cljs$lang$arity$variadic;
  return mapcat
}();
cljs.core.filter = function filter(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3974__auto____35843 = cljs.core.seq.call(null, coll);
    if(temp__3974__auto____35843) {
      var s__35844 = temp__3974__auto____35843;
      if(cljs.core.chunked_seq_QMARK_.call(null, s__35844)) {
        var c__35845 = cljs.core.chunk_first.call(null, s__35844);
        var size__35846 = cljs.core.count.call(null, c__35845);
        var b__35847 = cljs.core.chunk_buffer.call(null, size__35846);
        var n__2527__auto____35848 = size__35846;
        var i__35849 = 0;
        while(true) {
          if(i__35849 < n__2527__auto____35848) {
            if(cljs.core.truth_(pred.call(null, cljs.core._nth.call(null, c__35845, i__35849)))) {
              cljs.core.chunk_append.call(null, b__35847, cljs.core._nth.call(null, c__35845, i__35849))
            }else {
            }
            var G__35852 = i__35849 + 1;
            i__35849 = G__35852;
            continue
          }else {
          }
          break
        }
        return cljs.core.chunk_cons.call(null, cljs.core.chunk.call(null, b__35847), filter.call(null, pred, cljs.core.chunk_rest.call(null, s__35844)))
      }else {
        var f__35850 = cljs.core.first.call(null, s__35844);
        var r__35851 = cljs.core.rest.call(null, s__35844);
        if(cljs.core.truth_(pred.call(null, f__35850))) {
          return cljs.core.cons.call(null, f__35850, filter.call(null, pred, r__35851))
        }else {
          return filter.call(null, pred, r__35851)
        }
      }
    }else {
      return null
    }
  }, null)
};
cljs.core.remove = function remove(pred, coll) {
  return cljs.core.filter.call(null, cljs.core.complement.call(null, pred), coll)
};
cljs.core.tree_seq = function tree_seq(branch_QMARK_, children, root) {
  var walk__35855 = function walk(node) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, node, cljs.core.truth_(branch_QMARK_.call(null, node)) ? cljs.core.mapcat.call(null, walk, children.call(null, node)) : null)
    }, null)
  };
  return walk__35855.call(null, root)
};
cljs.core.flatten = function flatten(x) {
  return cljs.core.filter.call(null, function(p1__35853_SHARP_) {
    return!cljs.core.sequential_QMARK_.call(null, p1__35853_SHARP_)
  }, cljs.core.rest.call(null, cljs.core.tree_seq.call(null, cljs.core.sequential_QMARK_, cljs.core.seq, x)))
};
cljs.core.into = function into(to, from) {
  if(function() {
    var G__35859__35860 = to;
    if(G__35859__35860) {
      if(function() {
        var or__3824__auto____35861 = G__35859__35860.cljs$lang$protocol_mask$partition1$ & 1;
        if(or__3824__auto____35861) {
          return or__3824__auto____35861
        }else {
          return G__35859__35860.cljs$core$IEditableCollection$
        }
      }()) {
        return true
      }else {
        if(!G__35859__35860.cljs$lang$protocol_mask$partition1$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__35859__35860)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__35859__35860)
    }
  }()) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, cljs.core._conj_BANG_, cljs.core.transient$.call(null, to), from))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, to, from)
  }
};
cljs.core.mapv = function() {
  var mapv = null;
  var mapv__2 = function(f, coll) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
      return cljs.core.conj_BANG_.call(null, v, f.call(null, o))
    }, cljs.core.transient$.call(null, cljs.core.PersistentVector.EMPTY), coll))
  };
  var mapv__3 = function(f, c1, c2) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.EMPTY, cljs.core.map.call(null, f, c1, c2))
  };
  var mapv__4 = function(f, c1, c2, c3) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.EMPTY, cljs.core.map.call(null, f, c1, c2, c3))
  };
  var mapv__5 = function() {
    var G__35862__delegate = function(f, c1, c2, c3, colls) {
      return cljs.core.into.call(null, cljs.core.PersistentVector.EMPTY, cljs.core.apply.call(null, cljs.core.map, f, c1, c2, c3, colls))
    };
    var G__35862 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__35862__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__35862.cljs$lang$maxFixedArity = 4;
    G__35862.cljs$lang$applyTo = function(arglist__35863) {
      var f = cljs.core.first(arglist__35863);
      var c1 = cljs.core.first(cljs.core.next(arglist__35863));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35863)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__35863))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__35863))));
      return G__35862__delegate(f, c1, c2, c3, colls)
    };
    G__35862.cljs$lang$arity$variadic = G__35862__delegate;
    return G__35862
  }();
  mapv = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapv__2.call(this, f, c1);
      case 3:
        return mapv__3.call(this, f, c1, c2);
      case 4:
        return mapv__4.call(this, f, c1, c2, c3);
      default:
        return mapv__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapv.cljs$lang$maxFixedArity = 4;
  mapv.cljs$lang$applyTo = mapv__5.cljs$lang$applyTo;
  mapv.cljs$lang$arity$2 = mapv__2;
  mapv.cljs$lang$arity$3 = mapv__3;
  mapv.cljs$lang$arity$4 = mapv__4;
  mapv.cljs$lang$arity$variadic = mapv__5.cljs$lang$arity$variadic;
  return mapv
}();
cljs.core.filterv = function filterv(pred, coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
    if(cljs.core.truth_(pred.call(null, o))) {
      return cljs.core.conj_BANG_.call(null, v, o)
    }else {
      return v
    }
  }, cljs.core.transient$.call(null, cljs.core.PersistentVector.EMPTY), coll))
};
cljs.core.partition = function() {
  var partition = null;
  var partition__2 = function(n, coll) {
    return partition.call(null, n, n, coll)
  };
  var partition__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____35870 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____35870) {
        var s__35871 = temp__3974__auto____35870;
        var p__35872 = cljs.core.take.call(null, n, s__35871);
        if(n === cljs.core.count.call(null, p__35872)) {
          return cljs.core.cons.call(null, p__35872, partition.call(null, n, step, cljs.core.drop.call(null, step, s__35871)))
        }else {
          return null
        }
      }else {
        return null
      }
    }, null)
  };
  var partition__4 = function(n, step, pad, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____35873 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____35873) {
        var s__35874 = temp__3974__auto____35873;
        var p__35875 = cljs.core.take.call(null, n, s__35874);
        if(n === cljs.core.count.call(null, p__35875)) {
          return cljs.core.cons.call(null, p__35875, partition.call(null, n, step, pad, cljs.core.drop.call(null, step, s__35874)))
        }else {
          return cljs.core.list.call(null, cljs.core.take.call(null, n, cljs.core.concat.call(null, p__35875, pad)))
        }
      }else {
        return null
      }
    }, null)
  };
  partition = function(n, step, pad, coll) {
    switch(arguments.length) {
      case 2:
        return partition__2.call(this, n, step);
      case 3:
        return partition__3.call(this, n, step, pad);
      case 4:
        return partition__4.call(this, n, step, pad, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition.cljs$lang$arity$2 = partition__2;
  partition.cljs$lang$arity$3 = partition__3;
  partition.cljs$lang$arity$4 = partition__4;
  return partition
}();
cljs.core.get_in = function() {
  var get_in = null;
  var get_in__2 = function(m, ks) {
    return cljs.core.reduce.call(null, cljs.core.get, m, ks)
  };
  var get_in__3 = function(m, ks, not_found) {
    var sentinel__35880 = cljs.core.lookup_sentinel;
    var m__35881 = m;
    var ks__35882 = cljs.core.seq.call(null, ks);
    while(true) {
      if(ks__35882) {
        var m__35883 = cljs.core._lookup.call(null, m__35881, cljs.core.first.call(null, ks__35882), sentinel__35880);
        if(sentinel__35880 === m__35883) {
          return not_found
        }else {
          var G__35884 = sentinel__35880;
          var G__35885 = m__35883;
          var G__35886 = cljs.core.next.call(null, ks__35882);
          sentinel__35880 = G__35884;
          m__35881 = G__35885;
          ks__35882 = G__35886;
          continue
        }
      }else {
        return m__35881
      }
      break
    }
  };
  get_in = function(m, ks, not_found) {
    switch(arguments.length) {
      case 2:
        return get_in__2.call(this, m, ks);
      case 3:
        return get_in__3.call(this, m, ks, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get_in.cljs$lang$arity$2 = get_in__2;
  get_in.cljs$lang$arity$3 = get_in__3;
  return get_in
}();
cljs.core.assoc_in = function assoc_in(m, p__35887, v) {
  var vec__35892__35893 = p__35887;
  var k__35894 = cljs.core.nth.call(null, vec__35892__35893, 0, null);
  var ks__35895 = cljs.core.nthnext.call(null, vec__35892__35893, 1);
  if(cljs.core.truth_(ks__35895)) {
    return cljs.core.assoc.call(null, m, k__35894, assoc_in.call(null, cljs.core._lookup.call(null, m, k__35894, null), ks__35895, v))
  }else {
    return cljs.core.assoc.call(null, m, k__35894, v)
  }
};
cljs.core.update_in = function() {
  var update_in__delegate = function(m, p__35896, f, args) {
    var vec__35901__35902 = p__35896;
    var k__35903 = cljs.core.nth.call(null, vec__35901__35902, 0, null);
    var ks__35904 = cljs.core.nthnext.call(null, vec__35901__35902, 1);
    if(cljs.core.truth_(ks__35904)) {
      return cljs.core.assoc.call(null, m, k__35903, cljs.core.apply.call(null, update_in, cljs.core._lookup.call(null, m, k__35903, null), ks__35904, f, args))
    }else {
      return cljs.core.assoc.call(null, m, k__35903, cljs.core.apply.call(null, f, cljs.core._lookup.call(null, m, k__35903, null), args))
    }
  };
  var update_in = function(m, p__35896, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
    }
    return update_in__delegate.call(this, m, p__35896, f, args)
  };
  update_in.cljs$lang$maxFixedArity = 3;
  update_in.cljs$lang$applyTo = function(arglist__35905) {
    var m = cljs.core.first(arglist__35905);
    var p__35896 = cljs.core.first(cljs.core.next(arglist__35905));
    var f = cljs.core.first(cljs.core.next(cljs.core.next(arglist__35905)));
    var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__35905)));
    return update_in__delegate(m, p__35896, f, args)
  };
  update_in.cljs$lang$arity$variadic = update_in__delegate;
  return update_in
}();
cljs.core.Vector = function(meta, array, __hash) {
  this.meta = meta;
  this.array = array;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32400159
};
cljs.core.Vector.cljs$lang$type = true;
cljs.core.Vector.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/Vector")
};
cljs.core.Vector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__35908 = this;
  var h__2192__auto____35909 = this__35908.__hash;
  if(!(h__2192__auto____35909 == null)) {
    return h__2192__auto____35909
  }else {
    var h__2192__auto____35910 = cljs.core.hash_coll.call(null, coll);
    this__35908.__hash = h__2192__auto____35910;
    return h__2192__auto____35910
  }
};
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__35911 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, null)
};
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__35912 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, not_found)
};
cljs.core.Vector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__35913 = this;
  var new_array__35914 = this__35913.array.slice();
  new_array__35914[k] = v;
  return new cljs.core.Vector(this__35913.meta, new_array__35914, null)
};
cljs.core.Vector.prototype.call = function() {
  var G__35945 = null;
  var G__35945__2 = function(this_sym35915, k) {
    var this__35917 = this;
    var this_sym35915__35918 = this;
    var coll__35919 = this_sym35915__35918;
    return coll__35919.cljs$core$ILookup$_lookup$arity$2(coll__35919, k)
  };
  var G__35945__3 = function(this_sym35916, k, not_found) {
    var this__35917 = this;
    var this_sym35916__35920 = this;
    var coll__35921 = this_sym35916__35920;
    return coll__35921.cljs$core$ILookup$_lookup$arity$3(coll__35921, k, not_found)
  };
  G__35945 = function(this_sym35916, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__35945__2.call(this, this_sym35916, k);
      case 3:
        return G__35945__3.call(this, this_sym35916, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__35945
}();
cljs.core.Vector.prototype.apply = function(this_sym35906, args35907) {
  var this__35922 = this;
  return this_sym35906.call.apply(this_sym35906, [this_sym35906].concat(args35907.slice()))
};
cljs.core.Vector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__35923 = this;
  var new_array__35924 = this__35923.array.slice();
  new_array__35924.push(o);
  return new cljs.core.Vector(this__35923.meta, new_array__35924, null)
};
cljs.core.Vector.prototype.toString = function() {
  var this__35925 = this;
  var this__35926 = this;
  return cljs.core.pr_str.call(null, this__35926)
};
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__35927 = this;
  return cljs.core.ci_reduce.call(null, this__35927.array, f)
};
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__35928 = this;
  return cljs.core.ci_reduce.call(null, this__35928.array, f, start)
};
cljs.core.Vector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__35929 = this;
  if(this__35929.array.length > 0) {
    var vector_seq__35930 = function vector_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < this__35929.array.length) {
          return cljs.core.cons.call(null, this__35929.array[i], vector_seq.call(null, i + 1))
        }else {
          return null
        }
      }, null)
    };
    return vector_seq__35930.call(null, 0)
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__35931 = this;
  return this__35931.array.length
};
cljs.core.Vector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__35932 = this;
  var count__35933 = this__35932.array.length;
  if(count__35933 > 0) {
    return this__35932.array[count__35933 - 1]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__35934 = this;
  if(this__35934.array.length > 0) {
    var new_array__35935 = this__35934.array.slice();
    new_array__35935.pop();
    return new cljs.core.Vector(this__35934.meta, new_array__35935, null)
  }else {
    throw new Error("Can't pop empty vector");
  }
};
cljs.core.Vector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__35936 = this;
  return coll.cljs$core$IAssociative$_assoc$arity$3(coll, n, val)
};
cljs.core.Vector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__35937 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Vector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__35938 = this;
  return new cljs.core.Vector(meta, this__35938.array, this__35938.__hash)
};
cljs.core.Vector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__35939 = this;
  return this__35939.meta
};
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__35940 = this;
  if(function() {
    var and__3822__auto____35941 = 0 <= n;
    if(and__3822__auto____35941) {
      return n < this__35940.array.length
    }else {
      return and__3822__auto____35941
    }
  }()) {
    return this__35940.array[n]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__35942 = this;
  if(function() {
    var and__3822__auto____35943 = 0 <= n;
    if(and__3822__auto____35943) {
      return n < this__35942.array.length
    }else {
      return and__3822__auto____35943
    }
  }()) {
    return this__35942.array[n]
  }else {
    return not_found
  }
};
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__35944 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__35944.meta)
};
cljs.core.Vector;
cljs.core.Vector.EMPTY = new cljs.core.Vector(null, [], 0);
cljs.core.Vector.fromArray = function(xs) {
  return new cljs.core.Vector(null, xs, null)
};
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorPrSeq = function(this__2310__auto__) {
  return cljs.core.list.call(null, "cljs.core/VectorNode")
};
cljs.core.VectorNode;
cljs.core.pv_fresh_node = function pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, cljs.core.make_array.call(null, 32))
};
cljs.core.pv_aget = function pv_aget(node, idx) {
  return node.arr[idx]
};
cljs.core.pv_aset = function pv_aset(node, idx, val) {
  return node.arr[idx] = val
};
cljs.core.pv_clone_node = function pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, node.arr.slice())
};
cljs.core.tail_off = function tail_off(pv) {
  var cnt__35947 = pv.cnt;
  if(cnt__35947 < 32) {
    return 0
  }else {
    return cnt__35947 - 1 >>> 5 << 5
  }
};
cljs.core.new_path = function new_path(edit, level, node) {
  var ll__35953 = level;
  var ret__35954 = node;
  while(true) {
    if(ll__35953 === 0) {
      return ret__35954
    }else {
      var embed__35955 = ret__35954;
      var r__35956 = cljs.core.pv_fresh_node.call(null, edit);
      var ___35957 = cljs.core.pv_aset.call(null, r__35956, 0, embed__35955);
      var G__35958 = ll__35953 - 5;
      var G__35959 = r__35956;
      ll__35953 = G__35958;
      ret__35954 = G__35959;
      continue
    }
    break
  }
};
cljs.core.push_tail = function push_tail(pv, level, parent, tailnode) {
  var ret__35965 = cljs.core.pv_clone_node.call(null, parent);
  var subidx__35966 = pv.cnt - 1 >>> level & 31;
  if(5 === level) {
    cljs.core.pv_aset.call(null, ret__35965, subidx__35966, tailnode);
    return ret__35965
  }else {
    var child__35967 = cljs.core.pv_aget.call(null, parent, subidx__35966);
    if(!(child__35967 == null)) {
      var node_to_insert__35968 = push_tail.call(null, pv, level - 5, child__35967, tailnode);
      cljs.core.pv_aset.call(null, ret__35965, subidx__35966, node_to_insert__35968);
      return ret__35965
    }else {
      var node_to_insert__35969 = cljs.core.new_path.call(null, null, level - 5, tailnode);
      cljs.core.pv_aset.call(null, ret__35965, subidx__35966, node_to_insert__35969);
      return ret__35965
    }
  }
};
cljs.core.array_for = function array_for(pv, i) {
  if(function() {
    var and__3822__auto____35973 = 0 <= i;
    if(and__3822__auto____35973) {
      return i < pv.cnt
    }else {
      return and__3822__auto____35973
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, pv)) {
      return pv.tail
    }else {
      var node__35974 = pv.root;
      var level__35975 = pv.shift;
      while(true) {
        if(level__35975 > 0) {
          var G__35976 = cljs.core.pv_aget.call(null, node__35974, i >>> level__35975 & 31);
          var G__35977 = level__35975 - 5;
          node__35974 = G__35976;
          level__35975 = G__35977;
          continue
        }else {
          return node__35974.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in vector of length "), cljs.core.str(pv.cnt)].join(""));
  }
};
cljs.core.do_assoc = function do_assoc(pv, level, node, i, val) {
  var ret__35980 = cljs.core.pv_clone_node.call(null, node);
  if(level === 0) {
    cljs.core.pv_aset.call(null, ret__35980, i & 31, val);
    return ret__35980
  }else {
    var subidx__35981 = i >>> level & 31;
    cljs.core.pv_aset.call(null, ret__35980, subidx__35981, do_assoc.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__35981), i, val));
    return ret__35980
  }
};
cljs.core.pop_tail = function pop_tail(pv, level, node) {
  var subidx__35987 = pv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__35988 = pop_tail.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__35987));
    if(function() {
      var and__3822__auto____35989 = new_child__35988 == null;
      if(and__3822__auto____35989) {
        return subidx__35987 === 0
      }else {
        return and__3822__auto____35989
      }
    }()) {
      return null
    }else {
      var ret__35990 = cljs.core.pv_clone_node.call(null, node);
      cljs.core.pv_aset.call(null, ret__35990, subidx__35987, new_child__35988);
      return ret__35990
    }
  }else {
    if(subidx__35987 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        var ret__35991 = cljs.core.pv_clone_node.call(null, node);
        cljs.core.pv_aset.call(null, ret__35991, subidx__35987, null);
        return ret__35991
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 1;
  this.cljs$lang$protocol_mask$partition0$ = 167668511
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentVector")
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__35994 = this;
  return new cljs.core.TransientVector(this__35994.cnt, this__35994.shift, cljs.core.tv_editable_root.call(null, this__35994.root), cljs.core.tv_editable_tail.call(null, this__35994.tail))
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__35995 = this;
  var h__2192__auto____35996 = this__35995.__hash;
  if(!(h__2192__auto____35996 == null)) {
    return h__2192__auto____35996
  }else {
    var h__2192__auto____35997 = cljs.core.hash_coll.call(null, coll);
    this__35995.__hash = h__2192__auto____35997;
    return h__2192__auto____35997
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__35998 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, null)
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__35999 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, not_found)
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__36000 = this;
  if(function() {
    var and__3822__auto____36001 = 0 <= k;
    if(and__3822__auto____36001) {
      return k < this__36000.cnt
    }else {
      return and__3822__auto____36001
    }
  }()) {
    if(cljs.core.tail_off.call(null, coll) <= k) {
      var new_tail__36002 = this__36000.tail.slice();
      new_tail__36002[k & 31] = v;
      return new cljs.core.PersistentVector(this__36000.meta, this__36000.cnt, this__36000.shift, this__36000.root, new_tail__36002, null)
    }else {
      return new cljs.core.PersistentVector(this__36000.meta, this__36000.cnt, this__36000.shift, cljs.core.do_assoc.call(null, coll, this__36000.shift, this__36000.root, k, v), this__36000.tail, null)
    }
  }else {
    if(k === this__36000.cnt) {
      return coll.cljs$core$ICollection$_conj$arity$2(coll, v)
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Index "), cljs.core.str(k), cljs.core.str(" out of bounds  [0,"), cljs.core.str(this__36000.cnt), cljs.core.str("]")].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentVector.prototype.call = function() {
  var G__36050 = null;
  var G__36050__2 = function(this_sym36003, k) {
    var this__36005 = this;
    var this_sym36003__36006 = this;
    var coll__36007 = this_sym36003__36006;
    return coll__36007.cljs$core$ILookup$_lookup$arity$2(coll__36007, k)
  };
  var G__36050__3 = function(this_sym36004, k, not_found) {
    var this__36005 = this;
    var this_sym36004__36008 = this;
    var coll__36009 = this_sym36004__36008;
    return coll__36009.cljs$core$ILookup$_lookup$arity$3(coll__36009, k, not_found)
  };
  G__36050 = function(this_sym36004, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__36050__2.call(this, this_sym36004, k);
      case 3:
        return G__36050__3.call(this, this_sym36004, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__36050
}();
cljs.core.PersistentVector.prototype.apply = function(this_sym35992, args35993) {
  var this__36010 = this;
  return this_sym35992.call.apply(this_sym35992, [this_sym35992].concat(args35993.slice()))
};
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var this__36011 = this;
  var step_init__36012 = [0, init];
  var i__36013 = 0;
  while(true) {
    if(i__36013 < this__36011.cnt) {
      var arr__36014 = cljs.core.array_for.call(null, v, i__36013);
      var len__36015 = arr__36014.length;
      var init__36019 = function() {
        var j__36016 = 0;
        var init__36017 = step_init__36012[1];
        while(true) {
          if(j__36016 < len__36015) {
            var init__36018 = f.call(null, init__36017, j__36016 + i__36013, arr__36014[j__36016]);
            if(cljs.core.reduced_QMARK_.call(null, init__36018)) {
              return init__36018
            }else {
              var G__36051 = j__36016 + 1;
              var G__36052 = init__36018;
              j__36016 = G__36051;
              init__36017 = G__36052;
              continue
            }
          }else {
            step_init__36012[0] = len__36015;
            step_init__36012[1] = init__36017;
            return init__36017
          }
          break
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__36019)) {
        return cljs.core.deref.call(null, init__36019)
      }else {
        var G__36053 = i__36013 + step_init__36012[0];
        i__36013 = G__36053;
        continue
      }
    }else {
      return step_init__36012[1]
    }
    break
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__36020 = this;
  if(this__36020.cnt - cljs.core.tail_off.call(null, coll) < 32) {
    var new_tail__36021 = this__36020.tail.slice();
    new_tail__36021.push(o);
    return new cljs.core.PersistentVector(this__36020.meta, this__36020.cnt + 1, this__36020.shift, this__36020.root, new_tail__36021, null)
  }else {
    var root_overflow_QMARK___36022 = this__36020.cnt >>> 5 > 1 << this__36020.shift;
    var new_shift__36023 = root_overflow_QMARK___36022 ? this__36020.shift + 5 : this__36020.shift;
    var new_root__36025 = root_overflow_QMARK___36022 ? function() {
      var n_r__36024 = cljs.core.pv_fresh_node.call(null, null);
      cljs.core.pv_aset.call(null, n_r__36024, 0, this__36020.root);
      cljs.core.pv_aset.call(null, n_r__36024, 1, cljs.core.new_path.call(null, null, this__36020.shift, new cljs.core.VectorNode(null, this__36020.tail)));
      return n_r__36024
    }() : cljs.core.push_tail.call(null, coll, this__36020.shift, this__36020.root, new cljs.core.VectorNode(null, this__36020.tail));
    return new cljs.core.PersistentVector(this__36020.meta, this__36020.cnt + 1, new_shift__36023, new_root__36025, [o], null)
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__36026 = this;
  if(this__36026.cnt > 0) {
    return new cljs.core.RSeq(coll, this__36026.cnt - 1, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = function(coll) {
  var this__36027 = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = function(coll) {
  var this__36028 = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(coll, 1)
};
cljs.core.PersistentVector.prototype.toString = function() {
  var this__36029 = this;
  var this__36030 = this;
  return cljs.core.pr_str.call(null, this__36030)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__36031 = this;
  return cljs.core.ci_reduce.call(null, v, f)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__36032 = this;
  return cljs.core.ci_reduce.call(null, v, f, start)
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__36033 = this;
  if(this__36033.cnt === 0) {
    return null
  }else {
    return cljs.core.chunked_seq.call(null, coll, 0, 0)
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__36034 = this;
  return this__36034.cnt
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__36035 = this;
  if(this__36035.cnt > 0) {
    return coll.cljs$core$IIndexed$_nth$arity$2(coll, this__36035.cnt - 1)
  }else {
    return null
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__36036 = this;
  if(this__36036.cnt === 0) {
    throw new Error("Can't pop empty vector");
  }else {
    if(1 === this__36036.cnt) {
      return cljs.core._with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__36036.meta)
    }else {
      if(1 < this__36036.cnt - cljs.core.tail_off.call(null, coll)) {
        return new cljs.core.PersistentVector(this__36036.meta, this__36036.cnt - 1, this__36036.shift, this__36036.root, this__36036.tail.slice(0, -1), null)
      }else {
        if("\ufdd0'else") {
          var new_tail__36037 = cljs.core.array_for.call(null, coll, this__36036.cnt - 2);
          var nr__36038 = cljs.core.pop_tail.call(null, coll, this__36036.shift, this__36036.root);
          var new_root__36039 = nr__36038 == null ? cljs.core.PersistentVector.EMPTY_NODE : nr__36038;
          var cnt_1__36040 = this__36036.cnt - 1;
          if(function() {
            var and__3822__auto____36041 = 5 < this__36036.shift;
            if(and__3822__auto____36041) {
              return cljs.core.pv_aget.call(null, new_root__36039, 1) == null
            }else {
              return and__3822__auto____36041
            }
          }()) {
            return new cljs.core.PersistentVector(this__36036.meta, cnt_1__36040, this__36036.shift - 5, cljs.core.pv_aget.call(null, new_root__36039, 0), new_tail__36037, null)
          }else {
            return new cljs.core.PersistentVector(this__36036.meta, cnt_1__36040, this__36036.shift, new_root__36039, new_tail__36037, null)
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__36042 = this;
  return coll.cljs$core$IAssociative$_assoc$arity$3(coll, n, val)
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__36043 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__36044 = this;
  return new cljs.core.PersistentVector(meta, this__36044.cnt, this__36044.shift, this__36044.root, this__36044.tail, this__36044.__hash)
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__36045 = this;
  return this__36045.meta
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__36046 = this;
  return cljs.core.array_for.call(null, coll, n)[n & 31]
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__36047 = this;
  if(function() {
    var and__3822__auto____36048 = 0 <= n;
    if(and__3822__auto____36048) {
      return n < this__36047.cnt
    }else {
      return and__3822__auto____36048
    }
  }()) {
    return coll.cljs$core$IIndexed$_nth$arity$2(coll, n)
  }else {
    return not_found
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__36049 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__36049.meta)
};
cljs.core.PersistentVector;
cljs.core.PersistentVector.EMPTY_NODE = cljs.core.pv_fresh_node.call(null, null);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], 0);
cljs.core.PersistentVector.fromArray = function(xs, no_clone) {
  var l__36054 = xs.length;
  var xs__36055 = no_clone === true ? xs : xs.slice();
  if(l__36054 < 32) {
    return new cljs.core.PersistentVector(null, l__36054, 5, cljs.core.PersistentVector.EMPTY_NODE, xs__36055, null)
  }else {
    var node__36056 = xs__36055.slice(0, 32);
    var v__36057 = new cljs.core.PersistentVector(null, 32, 5, cljs.core.PersistentVector.EMPTY_NODE, node__36056, null);
    var i__36058 = 32;
    var out__36059 = cljs.core._as_transient.call(null, v__36057);
    while(true) {
      if(i__36058 < l__36054) {
        var G__36060 = i__36058 + 1;
        var G__36061 = cljs.core.conj_BANG_.call(null, out__36059, xs__36055[i__36058]);
        i__36058 = G__36060;
        out__36059 = G__36061;
        continue
      }else {
        return cljs.core.persistent_BANG_.call(null, out__36059)
      }
      break
    }
  }
};
cljs.core.vec = function vec(coll) {
  return cljs.core._persistent_BANG_.call(null, cljs.core.reduce.call(null, cljs.core._conj_BANG_, cljs.core._as_transient.call(null, cljs.core.PersistentVector.EMPTY), coll))
};
cljs.core.vector = function() {
  var vector__delegate = function(args) {
    return cljs.core.vec.call(null, args)
  };
  var vector = function(var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return vector__delegate.call(this, args)
  };
  vector.cljs$lang$maxFixedArity = 0;
  vector.cljs$lang$applyTo = function(arglist__36062) {
    var args = cljs.core.seq(arglist__36062);
    return vector__delegate(args)
  };
  vector.cljs$lang$arity$variadic = vector__delegate;
  return vector
}();
cljs.core.ChunkedSeq = function(vec, node, i, off, meta) {
  this.vec = vec;
  this.node = node;
  this.i = i;
  this.off = off;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 27525356
};
cljs.core.ChunkedSeq.cljs$lang$type = true;
cljs.core.ChunkedSeq.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/ChunkedSeq")
};
cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var this__36063 = this;
  if(this__36063.off + 1 < this__36063.node.length) {
    var s__36064 = cljs.core.chunked_seq.call(null, this__36063.vec, this__36063.node, this__36063.i, this__36063.off + 1);
    if(s__36064 == null) {
      return null
    }else {
      return s__36064
    }
  }else {
    return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll)
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__36065 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__36066 = this;
  return coll
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__36067 = this;
  return this__36067.node[this__36067.off]
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__36068 = this;
  if(this__36068.off + 1 < this__36068.node.length) {
    var s__36069 = cljs.core.chunked_seq.call(null, this__36068.vec, this__36068.node, this__36068.i, this__36068.off + 1);
    if(s__36069 == null) {
      return cljs.core.List.EMPTY
    }else {
      return s__36069
    }
  }else {
    return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll)
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$ = true;
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var this__36070 = this;
  var l__36071 = this__36070.node.length;
  var s__36072 = this__36070.i + l__36071 < cljs.core._count.call(null, this__36070.vec) ? cljs.core.chunked_seq.call(null, this__36070.vec, this__36070.i + l__36071, 0) : null;
  if(s__36072 == null) {
    return null
  }else {
    return s__36072
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__36073 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var this__36074 = this;
  return cljs.core.chunked_seq.call(null, this__36074.vec, this__36074.node, this__36074.i, this__36074.off, m)
};
cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_meta$arity$1 = function(coll) {
  var this__36075 = this;
  return this__36075.meta
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__36076 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__36076.meta)
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$ = true;
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var this__36077 = this;
  return cljs.core.array_chunk.call(null, this__36077.node, this__36077.off)
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var this__36078 = this;
  var l__36079 = this__36078.node.length;
  var s__36080 = this__36078.i + l__36079 < cljs.core._count.call(null, this__36078.vec) ? cljs.core.chunked_seq.call(null, this__36078.vec, this__36078.i + l__36079, 0) : null;
  if(s__36080 == null) {
    return cljs.core.List.EMPTY
  }else {
    return s__36080
  }
};
cljs.core.ChunkedSeq;
cljs.core.chunked_seq = function() {
  var chunked_seq = null;
  var chunked_seq__3 = function(vec, i, off) {
    return chunked_seq.call(null, vec, cljs.core.array_for.call(null, vec, i), i, off, null)
  };
  var chunked_seq__4 = function(vec, node, i, off) {
    return chunked_seq.call(null, vec, node, i, off, null)
  };
  var chunked_seq__5 = function(vec, node, i, off, meta) {
    return new cljs.core.ChunkedSeq(vec, node, i, off, meta)
  };
  chunked_seq = function(vec, node, i, off, meta) {
    switch(arguments.length) {
      case 3:
        return chunked_seq__3.call(this, vec, node, i);
      case 4:
        return chunked_seq__4.call(this, vec, node, i, off);
      case 5:
        return chunked_seq__5.call(this, vec, node, i, off, meta)
    }
    throw"Invalid arity: " + arguments.length;
  };
  chunked_seq.cljs$lang$arity$3 = chunked_seq__3;
  chunked_seq.cljs$lang$arity$4 = chunked_seq__4;
  chunked_seq.cljs$lang$arity$5 = chunked_seq__5;
  return chunked_seq
}();
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32400159
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/Subvec")
};
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__36083 = this;
  var h__2192__auto____36084 = this__36083.__hash;
  if(!(h__2192__auto____36084 == null)) {
    return h__2192__auto____36084
  }else {
    var h__2192__auto____36085 = cljs.core.hash_coll.call(null, coll);
    this__36083.__hash = h__2192__auto____36085;
    return h__2192__auto____36085
  }
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__36086 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, null)
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__36087 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var this__36088 = this;
  var v_pos__36089 = this__36088.start + key;
  return new cljs.core.Subvec(this__36088.meta, cljs.core._assoc.call(null, this__36088.v, v_pos__36089, val), this__36088.start, this__36088.end > v_pos__36089 + 1 ? this__36088.end : v_pos__36089 + 1, null)
};
cljs.core.Subvec.prototype.call = function() {
  var G__36115 = null;
  var G__36115__2 = function(this_sym36090, k) {
    var this__36092 = this;
    var this_sym36090__36093 = this;
    var coll__36094 = this_sym36090__36093;
    return coll__36094.cljs$core$ILookup$_lookup$arity$2(coll__36094, k)
  };
  var G__36115__3 = function(this_sym36091, k, not_found) {
    var this__36092 = this;
    var this_sym36091__36095 = this;
    var coll__36096 = this_sym36091__36095;
    return coll__36096.cljs$core$ILookup$_lookup$arity$3(coll__36096, k, not_found)
  };
  G__36115 = function(this_sym36091, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__36115__2.call(this, this_sym36091, k);
      case 3:
        return G__36115__3.call(this, this_sym36091, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__36115
}();
cljs.core.Subvec.prototype.apply = function(this_sym36081, args36082) {
  var this__36097 = this;
  return this_sym36081.call.apply(this_sym36081, [this_sym36081].concat(args36082.slice()))
};
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__36098 = this;
  return new cljs.core.Subvec(this__36098.meta, cljs.core._assoc_n.call(null, this__36098.v, this__36098.end, o), this__36098.start, this__36098.end + 1, null)
};
cljs.core.Subvec.prototype.toString = function() {
  var this__36099 = this;
  var this__36100 = this;
  return cljs.core.pr_str.call(null, this__36100)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__36101 = this;
  return cljs.core.ci_reduce.call(null, coll, f)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__36102 = this;
  return cljs.core.ci_reduce.call(null, coll, f, start)
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__36103 = this;
  var subvec_seq__36104 = function subvec_seq(i) {
    if(i === this__36103.end) {
      return null
    }else {
      return cljs.core.cons.call(null, cljs.core._nth.call(null, this__36103.v, i), new cljs.core.LazySeq(null, false, function() {
        return subvec_seq.call(null, i + 1)
      }, null))
    }
  };
  return subvec_seq__36104.call(null, this__36103.start)
};
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__36105 = this;
  return this__36105.end - this__36105.start
};
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__36106 = this;
  return cljs.core._nth.call(null, this__36106.v, this__36106.end - 1)
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__36107 = this;
  if(this__36107.start === this__36107.end) {
    throw new Error("Can't pop empty vector");
  }else {
    return new cljs.core.Subvec(this__36107.meta, this__36107.v, this__36107.start, this__36107.end - 1, null)
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__36108 = this;
  return coll.cljs$core$IAssociative$_assoc$arity$3(coll, n, val)
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__36109 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__36110 = this;
  return new cljs.core.Subvec(meta, this__36110.v, this__36110.start, this__36110.end, this__36110.__hash)
};
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__36111 = this;
  return this__36111.meta
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__36112 = this;
  return cljs.core._nth.call(null, this__36112.v, this__36112.start + n)
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__36113 = this;
  return cljs.core._nth.call(null, this__36113.v, this__36113.start + n, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__36114 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__36114.meta)
};
cljs.core.Subvec;
cljs.core.subvec = function() {
  var subvec = null;
  var subvec__2 = function(v, start) {
    return subvec.call(null, v, start, cljs.core.count.call(null, v))
  };
  var subvec__3 = function(v, start, end) {
    return new cljs.core.Subvec(null, v, start, end, null)
  };
  subvec = function(v, start, end) {
    switch(arguments.length) {
      case 2:
        return subvec__2.call(this, v, start);
      case 3:
        return subvec__3.call(this, v, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subvec.cljs$lang$arity$2 = subvec__2;
  subvec.cljs$lang$arity$3 = subvec__3;
  return subvec
}();
cljs.core.tv_ensure_editable = function tv_ensure_editable(edit, node) {
  if(edit === node.edit) {
    return node
  }else {
    return new cljs.core.VectorNode(edit, node.arr.slice())
  }
};
cljs.core.tv_editable_root = function tv_editable_root(node) {
  return new cljs.core.VectorNode({}, node.arr.slice())
};
cljs.core.tv_editable_tail = function tv_editable_tail(tl) {
  var ret__36117 = cljs.core.make_array.call(null, 32);
  cljs.core.array_copy.call(null, tl, 0, ret__36117, 0, tl.length);
  return ret__36117
};
cljs.core.tv_push_tail = function tv_push_tail(tv, level, parent, tail_node) {
  var ret__36121 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, parent);
  var subidx__36122 = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset.call(null, ret__36121, subidx__36122, level === 5 ? tail_node : function() {
    var child__36123 = cljs.core.pv_aget.call(null, ret__36121, subidx__36122);
    if(!(child__36123 == null)) {
      return tv_push_tail.call(null, tv, level - 5, child__36123, tail_node)
    }else {
      return cljs.core.new_path.call(null, tv.root.edit, level - 5, tail_node)
    }
  }());
  return ret__36121
};
cljs.core.tv_pop_tail = function tv_pop_tail(tv, level, node) {
  var node__36128 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, node);
  var subidx__36129 = tv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__36130 = tv_pop_tail.call(null, tv, level - 5, cljs.core.pv_aget.call(null, node__36128, subidx__36129));
    if(function() {
      var and__3822__auto____36131 = new_child__36130 == null;
      if(and__3822__auto____36131) {
        return subidx__36129 === 0
      }else {
        return and__3822__auto____36131
      }
    }()) {
      return null
    }else {
      cljs.core.pv_aset.call(null, node__36128, subidx__36129, new_child__36130);
      return node__36128
    }
  }else {
    if(subidx__36129 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        cljs.core.pv_aset.call(null, node__36128, subidx__36129, null);
        return node__36128
      }else {
        return null
      }
    }
  }
};
cljs.core.editable_array_for = function editable_array_for(tv, i) {
  if(function() {
    var and__3822__auto____36136 = 0 <= i;
    if(and__3822__auto____36136) {
      return i < tv.cnt
    }else {
      return and__3822__auto____36136
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, tv)) {
      return tv.tail
    }else {
      var root__36137 = tv.root;
      var node__36138 = root__36137;
      var level__36139 = tv.shift;
      while(true) {
        if(level__36139 > 0) {
          var G__36140 = cljs.core.tv_ensure_editable.call(null, root__36137.edit, cljs.core.pv_aget.call(null, node__36138, i >>> level__36139 & 31));
          var G__36141 = level__36139 - 5;
          node__36138 = G__36140;
          level__36139 = G__36141;
          continue
        }else {
          return node__36138.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in transient vector of length "), cljs.core.str(tv.cnt)].join(""));
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition0$ = 275;
  this.cljs$lang$protocol_mask$partition1$ = 22
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/TransientVector")
};
cljs.core.TransientVector.prototype.call = function() {
  var G__36181 = null;
  var G__36181__2 = function(this_sym36144, k) {
    var this__36146 = this;
    var this_sym36144__36147 = this;
    var coll__36148 = this_sym36144__36147;
    return coll__36148.cljs$core$ILookup$_lookup$arity$2(coll__36148, k)
  };
  var G__36181__3 = function(this_sym36145, k, not_found) {
    var this__36146 = this;
    var this_sym36145__36149 = this;
    var coll__36150 = this_sym36145__36149;
    return coll__36150.cljs$core$ILookup$_lookup$arity$3(coll__36150, k, not_found)
  };
  G__36181 = function(this_sym36145, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__36181__2.call(this, this_sym36145, k);
      case 3:
        return G__36181__3.call(this, this_sym36145, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__36181
}();
cljs.core.TransientVector.prototype.apply = function(this_sym36142, args36143) {
  var this__36151 = this;
  return this_sym36142.call.apply(this_sym36142, [this_sym36142].concat(args36143.slice()))
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__36152 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, null)
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__36153 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, not_found)
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__36154 = this;
  if(this__36154.root.edit) {
    return cljs.core.array_for.call(null, coll, n)[n & 31]
  }else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__36155 = this;
  if(function() {
    var and__3822__auto____36156 = 0 <= n;
    if(and__3822__auto____36156) {
      return n < this__36155.cnt
    }else {
      return and__3822__auto____36156
    }
  }()) {
    return coll.cljs$core$IIndexed$_nth$arity$2(coll, n)
  }else {
    return not_found
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__36157 = this;
  if(this__36157.root.edit) {
    return this__36157.cnt
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var this__36158 = this;
  if(this__36158.root.edit) {
    if(function() {
      var and__3822__auto____36159 = 0 <= n;
      if(and__3822__auto____36159) {
        return n < this__36158.cnt
      }else {
        return and__3822__auto____36159
      }
    }()) {
      if(cljs.core.tail_off.call(null, tcoll) <= n) {
        this__36158.tail[n & 31] = val;
        return tcoll
      }else {
        var new_root__36164 = function go(level, node) {
          var node__36162 = cljs.core.tv_ensure_editable.call(null, this__36158.root.edit, node);
          if(level === 0) {
            cljs.core.pv_aset.call(null, node__36162, n & 31, val);
            return node__36162
          }else {
            var subidx__36163 = n >>> level & 31;
            cljs.core.pv_aset.call(null, node__36162, subidx__36163, go.call(null, level - 5, cljs.core.pv_aget.call(null, node__36162, subidx__36163)));
            return node__36162
          }
        }.call(null, this__36158.shift, this__36158.root);
        this__36158.root = new_root__36164;
        return tcoll
      }
    }else {
      if(n === this__36158.cnt) {
        return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val)
      }else {
        if("\ufdd0'else") {
          throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds for TransientVector of length"), cljs.core.str(this__36158.cnt)].join(""));
        }else {
          return null
        }
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var this__36165 = this;
  if(this__36165.root.edit) {
    if(this__36165.cnt === 0) {
      throw new Error("Can't pop empty vector");
    }else {
      if(1 === this__36165.cnt) {
        this__36165.cnt = 0;
        return tcoll
      }else {
        if((this__36165.cnt - 1 & 31) > 0) {
          this__36165.cnt = this__36165.cnt - 1;
          return tcoll
        }else {
          if("\ufdd0'else") {
            var new_tail__36166 = cljs.core.editable_array_for.call(null, tcoll, this__36165.cnt - 2);
            var new_root__36168 = function() {
              var nr__36167 = cljs.core.tv_pop_tail.call(null, tcoll, this__36165.shift, this__36165.root);
              if(!(nr__36167 == null)) {
                return nr__36167
              }else {
                return new cljs.core.VectorNode(this__36165.root.edit, cljs.core.make_array.call(null, 32))
              }
            }();
            if(function() {
              var and__3822__auto____36169 = 5 < this__36165.shift;
              if(and__3822__auto____36169) {
                return cljs.core.pv_aget.call(null, new_root__36168, 1) == null
              }else {
                return and__3822__auto____36169
              }
            }()) {
              var new_root__36170 = cljs.core.tv_ensure_editable.call(null, this__36165.root.edit, cljs.core.pv_aget.call(null, new_root__36168, 0));
              this__36165.root = new_root__36170;
              this__36165.shift = this__36165.shift - 5;
              this__36165.cnt = this__36165.cnt - 1;
              this__36165.tail = new_tail__36166;
              return tcoll
            }else {
              this__36165.root = new_root__36168;
              this__36165.cnt = this__36165.cnt - 1;
              this__36165.tail = new_tail__36166;
              return tcoll
            }
          }else {
            return null
          }
        }
      }
    }
  }else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__36171 = this;
  return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, key, val)
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__36172 = this;
  if(this__36172.root.edit) {
    if(this__36172.cnt - cljs.core.tail_off.call(null, tcoll) < 32) {
      this__36172.tail[this__36172.cnt & 31] = o;
      this__36172.cnt = this__36172.cnt + 1;
      return tcoll
    }else {
      var tail_node__36173 = new cljs.core.VectorNode(this__36172.root.edit, this__36172.tail);
      var new_tail__36174 = cljs.core.make_array.call(null, 32);
      new_tail__36174[0] = o;
      this__36172.tail = new_tail__36174;
      if(this__36172.cnt >>> 5 > 1 << this__36172.shift) {
        var new_root_array__36175 = cljs.core.make_array.call(null, 32);
        var new_shift__36176 = this__36172.shift + 5;
        new_root_array__36175[0] = this__36172.root;
        new_root_array__36175[1] = cljs.core.new_path.call(null, this__36172.root.edit, this__36172.shift, tail_node__36173);
        this__36172.root = new cljs.core.VectorNode(this__36172.root.edit, new_root_array__36175);
        this__36172.shift = new_shift__36176;
        this__36172.cnt = this__36172.cnt + 1;
        return tcoll
      }else {
        var new_root__36177 = cljs.core.tv_push_tail.call(null, tcoll, this__36172.shift, this__36172.root, tail_node__36173);
        this__36172.root = new_root__36177;
        this__36172.cnt = this__36172.cnt + 1;
        return tcoll
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__36178 = this;
  if(this__36178.root.edit) {
    this__36178.root.edit = null;
    var len__36179 = this__36178.cnt - cljs.core.tail_off.call(null, tcoll);
    var trimmed_tail__36180 = cljs.core.make_array.call(null, len__36179);
    cljs.core.array_copy.call(null, this__36178.tail, 0, trimmed_tail__36180, 0, len__36179);
    return new cljs.core.PersistentVector(null, this__36178.cnt, this__36178.shift, this__36178.root, trimmed_tail__36180, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector;
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31850572
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentQueueSeq")
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__36182 = this;
  var h__2192__auto____36183 = this__36182.__hash;
  if(!(h__2192__auto____36183 == null)) {
    return h__2192__auto____36183
  }else {
    var h__2192__auto____36184 = cljs.core.hash_coll.call(null, coll);
    this__36182.__hash = h__2192__auto____36184;
    return h__2192__auto____36184
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__36185 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var this__36186 = this;
  var this__36187 = this;
  return cljs.core.pr_str.call(null, this__36187)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__36188 = this;
  return coll
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__36189 = this;
  return cljs.core._first.call(null, this__36189.front)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__36190 = this;
  var temp__3971__auto____36191 = cljs.core.next.call(null, this__36190.front);
  if(temp__3971__auto____36191) {
    var f1__36192 = temp__3971__auto____36191;
    return new cljs.core.PersistentQueueSeq(this__36190.meta, f1__36192, this__36190.rear, null)
  }else {
    if(this__36190.rear == null) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll)
    }else {
      return new cljs.core.PersistentQueueSeq(this__36190.meta, this__36190.rear, null, null)
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__36193 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__36194 = this;
  return new cljs.core.PersistentQueueSeq(meta, this__36194.front, this__36194.rear, this__36194.__hash)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__36195 = this;
  return this__36195.meta
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__36196 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__36196.meta)
};
cljs.core.PersistentQueueSeq;
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31858766
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentQueue")
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__36197 = this;
  var h__2192__auto____36198 = this__36197.__hash;
  if(!(h__2192__auto____36198 == null)) {
    return h__2192__auto____36198
  }else {
    var h__2192__auto____36199 = cljs.core.hash_coll.call(null, coll);
    this__36197.__hash = h__2192__auto____36199;
    return h__2192__auto____36199
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__36200 = this;
  if(cljs.core.truth_(this__36200.front)) {
    return new cljs.core.PersistentQueue(this__36200.meta, this__36200.count + 1, this__36200.front, cljs.core.conj.call(null, function() {
      var or__3824__auto____36201 = this__36200.rear;
      if(cljs.core.truth_(or__3824__auto____36201)) {
        return or__3824__auto____36201
      }else {
        return cljs.core.PersistentVector.EMPTY
      }
    }(), o), null)
  }else {
    return new cljs.core.PersistentQueue(this__36200.meta, this__36200.count + 1, cljs.core.conj.call(null, this__36200.front, o), cljs.core.PersistentVector.EMPTY, null)
  }
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var this__36202 = this;
  var this__36203 = this;
  return cljs.core.pr_str.call(null, this__36203)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__36204 = this;
  var rear__36205 = cljs.core.seq.call(null, this__36204.rear);
  if(cljs.core.truth_(function() {
    var or__3824__auto____36206 = this__36204.front;
    if(cljs.core.truth_(or__3824__auto____36206)) {
      return or__3824__auto____36206
    }else {
      return rear__36205
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, this__36204.front, cljs.core.seq.call(null, rear__36205), null)
  }else {
    return null
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__36207 = this;
  return this__36207.count
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__36208 = this;
  return cljs.core._first.call(null, this__36208.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__36209 = this;
  if(cljs.core.truth_(this__36209.front)) {
    var temp__3971__auto____36210 = cljs.core.next.call(null, this__36209.front);
    if(temp__3971__auto____36210) {
      var f1__36211 = temp__3971__auto____36210;
      return new cljs.core.PersistentQueue(this__36209.meta, this__36209.count - 1, f1__36211, this__36209.rear, null)
    }else {
      return new cljs.core.PersistentQueue(this__36209.meta, this__36209.count - 1, cljs.core.seq.call(null, this__36209.rear), cljs.core.PersistentVector.EMPTY, null)
    }
  }else {
    return coll
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__36212 = this;
  return cljs.core.first.call(null, this__36212.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__36213 = this;
  return cljs.core.rest.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__36214 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__36215 = this;
  return new cljs.core.PersistentQueue(meta, this__36215.count, this__36215.front, this__36215.rear, this__36215.__hash)
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__36216 = this;
  return this__36216.meta
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__36217 = this;
  return cljs.core.PersistentQueue.EMPTY
};
cljs.core.PersistentQueue;
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.EMPTY, 0);
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2097152
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/NeverEquiv")
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__36218 = this;
  return false
};
cljs.core.NeverEquiv;
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function equiv_map(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.map_QMARK_.call(null, y) ? cljs.core.count.call(null, x) === cljs.core.count.call(null, y) ? cljs.core.every_QMARK_.call(null, cljs.core.identity, cljs.core.map.call(null, function(xkv) {
    return cljs.core._EQ_.call(null, cljs.core._lookup.call(null, y, cljs.core.first.call(null, xkv), cljs.core.never_equiv), cljs.core.second.call(null, xkv))
  }, x)) : null : null)
};
cljs.core.scan_array = function scan_array(incr, k, array) {
  var len__36221 = array.length;
  var i__36222 = 0;
  while(true) {
    if(i__36222 < len__36221) {
      if(k === array[i__36222]) {
        return i__36222
      }else {
        var G__36223 = i__36222 + incr;
        i__36222 = G__36223;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.obj_map_compare_keys = function obj_map_compare_keys(a, b) {
  var a__36226 = cljs.core.hash.call(null, a);
  var b__36227 = cljs.core.hash.call(null, b);
  if(a__36226 < b__36227) {
    return-1
  }else {
    if(a__36226 > b__36227) {
      return 1
    }else {
      if("\ufdd0'else") {
        return 0
      }else {
        return null
      }
    }
  }
};
cljs.core.obj_map__GT_hash_map = function obj_map__GT_hash_map(m, k, v) {
  var ks__36235 = m.keys;
  var len__36236 = ks__36235.length;
  var so__36237 = m.strobj;
  var out__36238 = cljs.core.with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, cljs.core.meta.call(null, m));
  var i__36239 = 0;
  var out__36240 = cljs.core.transient$.call(null, out__36238);
  while(true) {
    if(i__36239 < len__36236) {
      var k__36241 = ks__36235[i__36239];
      var G__36242 = i__36239 + 1;
      var G__36243 = cljs.core.assoc_BANG_.call(null, out__36240, k__36241, so__36237[k__36241]);
      i__36239 = G__36242;
      out__36240 = G__36243;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, out__36240, k, v))
    }
    break
  }
};
cljs.core.obj_clone = function obj_clone(obj, ks) {
  var new_obj__36249 = {};
  var l__36250 = ks.length;
  var i__36251 = 0;
  while(true) {
    if(i__36251 < l__36250) {
      var k__36252 = ks[i__36251];
      new_obj__36249[k__36252] = obj[k__36252];
      var G__36253 = i__36251 + 1;
      i__36251 = G__36253;
      continue
    }else {
    }
    break
  }
  return new_obj__36249
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 1;
  this.cljs$lang$protocol_mask$partition0$ = 15075087
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/ObjMap")
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__36256 = this;
  return cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.hash_map.call(null), coll))
};
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__36257 = this;
  var h__2192__auto____36258 = this__36257.__hash;
  if(!(h__2192__auto____36258 == null)) {
    return h__2192__auto____36258
  }else {
    var h__2192__auto____36259 = cljs.core.hash_imap.call(null, coll);
    this__36257.__hash = h__2192__auto____36259;
    return h__2192__auto____36259
  }
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__36260 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, k, null)
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__36261 = this;
  if(function() {
    var and__3822__auto____36262 = goog.isString(k);
    if(and__3822__auto____36262) {
      return!(cljs.core.scan_array.call(null, 1, k, this__36261.keys) == null)
    }else {
      return and__3822__auto____36262
    }
  }()) {
    return this__36261.strobj[k]
  }else {
    return not_found
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__36263 = this;
  if(goog.isString(k)) {
    if(function() {
      var or__3824__auto____36264 = this__36263.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD;
      if(or__3824__auto____36264) {
        return or__3824__auto____36264
      }else {
        return this__36263.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD
      }
    }()) {
      return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
    }else {
      if(!(cljs.core.scan_array.call(null, 1, k, this__36263.keys) == null)) {
        var new_strobj__36265 = cljs.core.obj_clone.call(null, this__36263.strobj, this__36263.keys);
        new_strobj__36265[k] = v;
        return new cljs.core.ObjMap(this__36263.meta, this__36263.keys, new_strobj__36265, this__36263.update_count + 1, null)
      }else {
        var new_strobj__36266 = cljs.core.obj_clone.call(null, this__36263.strobj, this__36263.keys);
        var new_keys__36267 = this__36263.keys.slice();
        new_strobj__36266[k] = v;
        new_keys__36267.push(k);
        return new cljs.core.ObjMap(this__36263.meta, new_keys__36267, new_strobj__36266, this__36263.update_count + 1, null)
      }
    }
  }else {
    return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__36268 = this;
  if(function() {
    var and__3822__auto____36269 = goog.isString(k);
    if(and__3822__auto____36269) {
      return!(cljs.core.scan_array.call(null, 1, k, this__36268.keys) == null)
    }else {
      return and__3822__auto____36269
    }
  }()) {
    return true
  }else {
    return false
  }
};
cljs.core.ObjMap.prototype.call = function() {
  var G__36291 = null;
  var G__36291__2 = function(this_sym36270, k) {
    var this__36272 = this;
    var this_sym36270__36273 = this;
    var coll__36274 = this_sym36270__36273;
    return coll__36274.cljs$core$ILookup$_lookup$arity$2(coll__36274, k)
  };
  var G__36291__3 = function(this_sym36271, k, not_found) {
    var this__36272 = this;
    var this_sym36271__36275 = this;
    var coll__36276 = this_sym36271__36275;
    return coll__36276.cljs$core$ILookup$_lookup$arity$3(coll__36276, k, not_found)
  };
  G__36291 = function(this_sym36271, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__36291__2.call(this, this_sym36271, k);
      case 3:
        return G__36291__3.call(this, this_sym36271, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__36291
}();
cljs.core.ObjMap.prototype.apply = function(this_sym36254, args36255) {
  var this__36277 = this;
  return this_sym36254.call.apply(this_sym36254, [this_sym36254].concat(args36255.slice()))
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__36278 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.ObjMap.prototype.toString = function() {
  var this__36279 = this;
  var this__36280 = this;
  return cljs.core.pr_str.call(null, this__36280)
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__36281 = this;
  if(this__36281.keys.length > 0) {
    return cljs.core.map.call(null, function(p1__36244_SHARP_) {
      return cljs.core.vector.call(null, p1__36244_SHARP_, this__36281.strobj[p1__36244_SHARP_])
    }, this__36281.keys.sort(cljs.core.obj_map_compare_keys))
  }else {
    return null
  }
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__36282 = this;
  return this__36282.keys.length
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__36283 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__36284 = this;
  return new cljs.core.ObjMap(meta, this__36284.keys, this__36284.strobj, this__36284.update_count, this__36284.__hash)
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__36285 = this;
  return this__36285.meta
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__36286 = this;
  return cljs.core.with_meta.call(null, cljs.core.ObjMap.EMPTY, this__36286.meta)
};
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__36287 = this;
  if(function() {
    var and__3822__auto____36288 = goog.isString(k);
    if(and__3822__auto____36288) {
      return!(cljs.core.scan_array.call(null, 1, k, this__36287.keys) == null)
    }else {
      return and__3822__auto____36288
    }
  }()) {
    var new_keys__36289 = this__36287.keys.slice();
    var new_strobj__36290 = cljs.core.obj_clone.call(null, this__36287.strobj, this__36287.keys);
    new_keys__36289.splice(cljs.core.scan_array.call(null, 1, k, new_keys__36289), 1);
    cljs.core.js_delete.call(null, new_strobj__36290, k);
    return new cljs.core.ObjMap(this__36287.meta, new_keys__36289, new_strobj__36290, this__36287.update_count + 1, null)
  }else {
    return coll
  }
};
cljs.core.ObjMap;
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], {}, 0, 0);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 32;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null)
};
cljs.core.HashMap = function(meta, count, hashobj, __hash) {
  this.meta = meta;
  this.count = count;
  this.hashobj = hashobj;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15075087
};
cljs.core.HashMap.cljs$lang$type = true;
cljs.core.HashMap.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/HashMap")
};
cljs.core.HashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__36295 = this;
  var h__2192__auto____36296 = this__36295.__hash;
  if(!(h__2192__auto____36296 == null)) {
    return h__2192__auto____36296
  }else {
    var h__2192__auto____36297 = cljs.core.hash_imap.call(null, coll);
    this__36295.__hash = h__2192__auto____36297;
    return h__2192__auto____36297
  }
};
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__36298 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, k, null)
};
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__36299 = this;
  var bucket__36300 = this__36299.hashobj[cljs.core.hash.call(null, k)];
  var i__36301 = cljs.core.truth_(bucket__36300) ? cljs.core.scan_array.call(null, 2, k, bucket__36300) : null;
  if(cljs.core.truth_(i__36301)) {
    return bucket__36300[i__36301 + 1]
  }else {
    return not_found
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__36302 = this;
  var h__36303 = cljs.core.hash.call(null, k);
  var bucket__36304 = this__36302.hashobj[h__36303];
  if(cljs.core.truth_(bucket__36304)) {
    var new_bucket__36305 = bucket__36304.slice();
    var new_hashobj__36306 = goog.object.clone(this__36302.hashobj);
    new_hashobj__36306[h__36303] = new_bucket__36305;
    var temp__3971__auto____36307 = cljs.core.scan_array.call(null, 2, k, new_bucket__36305);
    if(cljs.core.truth_(temp__3971__auto____36307)) {
      var i__36308 = temp__3971__auto____36307;
      new_bucket__36305[i__36308 + 1] = v;
      return new cljs.core.HashMap(this__36302.meta, this__36302.count, new_hashobj__36306, null)
    }else {
      new_bucket__36305.push(k, v);
      return new cljs.core.HashMap(this__36302.meta, this__36302.count + 1, new_hashobj__36306, null)
    }
  }else {
    var new_hashobj__36309 = goog.object.clone(this__36302.hashobj);
    new_hashobj__36309[h__36303] = [k, v];
    return new cljs.core.HashMap(this__36302.meta, this__36302.count + 1, new_hashobj__36309, null)
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__36310 = this;
  var bucket__36311 = this__36310.hashobj[cljs.core.hash.call(null, k)];
  var i__36312 = cljs.core.truth_(bucket__36311) ? cljs.core.scan_array.call(null, 2, k, bucket__36311) : null;
  if(cljs.core.truth_(i__36312)) {
    return true
  }else {
    return false
  }
};
cljs.core.HashMap.prototype.call = function() {
  var G__36337 = null;
  var G__36337__2 = function(this_sym36313, k) {
    var this__36315 = this;
    var this_sym36313__36316 = this;
    var coll__36317 = this_sym36313__36316;
    return coll__36317.cljs$core$ILookup$_lookup$arity$2(coll__36317, k)
  };
  var G__36337__3 = function(this_sym36314, k, not_found) {
    var this__36315 = this;
    var this_sym36314__36318 = this;
    var coll__36319 = this_sym36314__36318;
    return coll__36319.cljs$core$ILookup$_lookup$arity$3(coll__36319, k, not_found)
  };
  G__36337 = function(this_sym36314, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__36337__2.call(this, this_sym36314, k);
      case 3:
        return G__36337__3.call(this, this_sym36314, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__36337
}();
cljs.core.HashMap.prototype.apply = function(this_sym36293, args36294) {
  var this__36320 = this;
  return this_sym36293.call.apply(this_sym36293, [this_sym36293].concat(args36294.slice()))
};
cljs.core.HashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__36321 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.HashMap.prototype.toString = function() {
  var this__36322 = this;
  var this__36323 = this;
  return cljs.core.pr_str.call(null, this__36323)
};
cljs.core.HashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__36324 = this;
  if(this__36324.count > 0) {
    var hashes__36325 = cljs.core.js_keys.call(null, this__36324.hashobj).sort();
    return cljs.core.mapcat.call(null, function(p1__36292_SHARP_) {
      return cljs.core.map.call(null, cljs.core.vec, cljs.core.partition.call(null, 2, this__36324.hashobj[p1__36292_SHARP_]))
    }, hashes__36325)
  }else {
    return null
  }
};
cljs.core.HashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__36326 = this;
  return this__36326.count
};
cljs.core.HashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__36327 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.HashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__36328 = this;
  return new cljs.core.HashMap(meta, this__36328.count, this__36328.hashobj, this__36328.__hash)
};
cljs.core.HashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__36329 = this;
  return this__36329.meta
};
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__36330 = this;
  return cljs.core.with_meta.call(null, cljs.core.HashMap.EMPTY, this__36330.meta)
};
cljs.core.HashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__36331 = this;
  var h__36332 = cljs.core.hash.call(null, k);
  var bucket__36333 = this__36331.hashobj[h__36332];
  var i__36334 = cljs.core.truth_(bucket__36333) ? cljs.core.scan_array.call(null, 2, k, bucket__36333) : null;
  if(cljs.core.not.call(null, i__36334)) {
    return coll
  }else {
    var new_hashobj__36335 = goog.object.clone(this__36331.hashobj);
    if(3 > bucket__36333.length) {
      cljs.core.js_delete.call(null, new_hashobj__36335, h__36332)
    }else {
      var new_bucket__36336 = bucket__36333.slice();
      new_bucket__36336.splice(i__36334, 2);
      new_hashobj__36335[h__36332] = new_bucket__36336
    }
    return new cljs.core.HashMap(this__36331.meta, this__36331.count - 1, new_hashobj__36335, null)
  }
};
cljs.core.HashMap;
cljs.core.HashMap.EMPTY = new cljs.core.HashMap(null, 0, {}, 0);
cljs.core.HashMap.fromArrays = function(ks, vs) {
  var len__36338 = ks.length;
  var i__36339 = 0;
  var out__36340 = cljs.core.HashMap.EMPTY;
  while(true) {
    if(i__36339 < len__36338) {
      var G__36341 = i__36339 + 1;
      var G__36342 = cljs.core.assoc.call(null, out__36340, ks[i__36339], vs[i__36339]);
      i__36339 = G__36341;
      out__36340 = G__36342;
      continue
    }else {
      return out__36340
    }
    break
  }
};
cljs.core.array_map_index_of = function array_map_index_of(m, k) {
  var arr__36346 = m.arr;
  var len__36347 = arr__36346.length;
  var i__36348 = 0;
  while(true) {
    if(len__36347 <= i__36348) {
      return-1
    }else {
      if(cljs.core._EQ_.call(null, arr__36346[i__36348], k)) {
        return i__36348
      }else {
        if("\ufdd0'else") {
          var G__36349 = i__36348 + 2;
          i__36348 = G__36349;
          continue
        }else {
          return null
        }
      }
    }
    break
  }
};
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 1;
  this.cljs$lang$protocol_mask$partition0$ = 16123663
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentArrayMap")
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__36352 = this;
  return new cljs.core.TransientArrayMap({}, this__36352.arr.length, this__36352.arr.slice())
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__36353 = this;
  var h__2192__auto____36354 = this__36353.__hash;
  if(!(h__2192__auto____36354 == null)) {
    return h__2192__auto____36354
  }else {
    var h__2192__auto____36355 = cljs.core.hash_imap.call(null, coll);
    this__36353.__hash = h__2192__auto____36355;
    return h__2192__auto____36355
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__36356 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, k, null)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__36357 = this;
  var idx__36358 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__36358 === -1) {
    return not_found
  }else {
    return this__36357.arr[idx__36358 + 1]
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__36359 = this;
  var idx__36360 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__36360 === -1) {
    if(this__36359.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      return new cljs.core.PersistentArrayMap(this__36359.meta, this__36359.cnt + 1, function() {
        var G__36361__36362 = this__36359.arr.slice();
        G__36361__36362.push(k);
        G__36361__36362.push(v);
        return G__36361__36362
      }(), null)
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.PersistentHashMap.EMPTY, coll)), k, v))
    }
  }else {
    if(v === this__36359.arr[idx__36360 + 1]) {
      return coll
    }else {
      if("\ufdd0'else") {
        return new cljs.core.PersistentArrayMap(this__36359.meta, this__36359.cnt, function() {
          var G__36363__36364 = this__36359.arr.slice();
          G__36363__36364[idx__36360 + 1] = v;
          return G__36363__36364
        }(), null)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__36365 = this;
  return!(cljs.core.array_map_index_of.call(null, coll, k) === -1)
};
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__36397 = null;
  var G__36397__2 = function(this_sym36366, k) {
    var this__36368 = this;
    var this_sym36366__36369 = this;
    var coll__36370 = this_sym36366__36369;
    return coll__36370.cljs$core$ILookup$_lookup$arity$2(coll__36370, k)
  };
  var G__36397__3 = function(this_sym36367, k, not_found) {
    var this__36368 = this;
    var this_sym36367__36371 = this;
    var coll__36372 = this_sym36367__36371;
    return coll__36372.cljs$core$ILookup$_lookup$arity$3(coll__36372, k, not_found)
  };
  G__36397 = function(this_sym36367, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__36397__2.call(this, this_sym36367, k);
      case 3:
        return G__36397__3.call(this, this_sym36367, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__36397
}();
cljs.core.PersistentArrayMap.prototype.apply = function(this_sym36350, args36351) {
  var this__36373 = this;
  return this_sym36350.call.apply(this_sym36350, [this_sym36350].concat(args36351.slice()))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__36374 = this;
  var len__36375 = this__36374.arr.length;
  var i__36376 = 0;
  var init__36377 = init;
  while(true) {
    if(i__36376 < len__36375) {
      var init__36378 = f.call(null, init__36377, this__36374.arr[i__36376], this__36374.arr[i__36376 + 1]);
      if(cljs.core.reduced_QMARK_.call(null, init__36378)) {
        return cljs.core.deref.call(null, init__36378)
      }else {
        var G__36398 = i__36376 + 2;
        var G__36399 = init__36378;
        i__36376 = G__36398;
        init__36377 = G__36399;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__36379 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var this__36380 = this;
  var this__36381 = this;
  return cljs.core.pr_str.call(null, this__36381)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__36382 = this;
  if(this__36382.cnt > 0) {
    var len__36383 = this__36382.arr.length;
    var array_map_seq__36384 = function array_map_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < len__36383) {
          return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([this__36382.arr[i], this__36382.arr[i + 1]], true), array_map_seq.call(null, i + 2))
        }else {
          return null
        }
      }, null)
    };
    return array_map_seq__36384.call(null, 0)
  }else {
    return null
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__36385 = this;
  return this__36385.cnt
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__36386 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__36387 = this;
  return new cljs.core.PersistentArrayMap(meta, this__36387.cnt, this__36387.arr, this__36387.__hash)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__36388 = this;
  return this__36388.meta
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__36389 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentArrayMap.EMPTY, this__36389.meta)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__36390 = this;
  var idx__36391 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__36391 >= 0) {
    var len__36392 = this__36390.arr.length;
    var new_len__36393 = len__36392 - 2;
    if(new_len__36393 === 0) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll)
    }else {
      var new_arr__36394 = cljs.core.make_array.call(null, new_len__36393);
      var s__36395 = 0;
      var d__36396 = 0;
      while(true) {
        if(s__36395 >= len__36392) {
          return new cljs.core.PersistentArrayMap(this__36390.meta, this__36390.cnt - 1, new_arr__36394, null)
        }else {
          if(cljs.core._EQ_.call(null, k, this__36390.arr[s__36395])) {
            var G__36400 = s__36395 + 2;
            var G__36401 = d__36396;
            s__36395 = G__36400;
            d__36396 = G__36401;
            continue
          }else {
            if("\ufdd0'else") {
              new_arr__36394[d__36396] = this__36390.arr[s__36395];
              new_arr__36394[d__36396 + 1] = this__36390.arr[s__36395 + 1];
              var G__36402 = s__36395 + 2;
              var G__36403 = d__36396 + 2;
              s__36395 = G__36402;
              d__36396 = G__36403;
              continue
            }else {
              return null
            }
          }
        }
        break
      }
    }
  }else {
    return coll
  }
};
cljs.core.PersistentArrayMap;
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], null);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 16;
cljs.core.PersistentArrayMap.fromArrays = function(ks, vs) {
  var len__36404 = cljs.core.count.call(null, ks);
  var i__36405 = 0;
  var out__36406 = cljs.core.transient$.call(null, cljs.core.PersistentArrayMap.EMPTY);
  while(true) {
    if(i__36405 < len__36404) {
      var G__36407 = i__36405 + 1;
      var G__36408 = cljs.core.assoc_BANG_.call(null, out__36406, ks[i__36405], vs[i__36405]);
      i__36405 = G__36407;
      out__36406 = G__36408;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__36406)
    }
    break
  }
};
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition1$ = 14;
  this.cljs$lang$protocol_mask$partition0$ = 258
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/TransientArrayMap")
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__36409 = this;
  if(cljs.core.truth_(this__36409.editable_QMARK_)) {
    var idx__36410 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__36410 >= 0) {
      this__36409.arr[idx__36410] = this__36409.arr[this__36409.len - 2];
      this__36409.arr[idx__36410 + 1] = this__36409.arr[this__36409.len - 1];
      var G__36411__36412 = this__36409.arr;
      G__36411__36412.pop();
      G__36411__36412.pop();
      G__36411__36412;
      this__36409.len = this__36409.len - 2
    }else {
    }
    return tcoll
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__36413 = this;
  if(cljs.core.truth_(this__36413.editable_QMARK_)) {
    var idx__36414 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__36414 === -1) {
      if(this__36413.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        this__36413.len = this__36413.len + 2;
        this__36413.arr.push(key);
        this__36413.arr.push(val);
        return tcoll
      }else {
        return cljs.core.assoc_BANG_.call(null, cljs.core.array__GT_transient_hash_map.call(null, this__36413.len, this__36413.arr), key, val)
      }
    }else {
      if(val === this__36413.arr[idx__36414 + 1]) {
        return tcoll
      }else {
        this__36413.arr[idx__36414 + 1] = val;
        return tcoll
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__36415 = this;
  if(cljs.core.truth_(this__36415.editable_QMARK_)) {
    if(function() {
      var G__36416__36417 = o;
      if(G__36416__36417) {
        if(function() {
          var or__3824__auto____36418 = G__36416__36417.cljs$lang$protocol_mask$partition0$ & 2048;
          if(or__3824__auto____36418) {
            return or__3824__auto____36418
          }else {
            return G__36416__36417.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__36416__36417.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__36416__36417)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__36416__36417)
      }
    }()) {
      return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__36419 = cljs.core.seq.call(null, o);
      var tcoll__36420 = tcoll;
      while(true) {
        var temp__3971__auto____36421 = cljs.core.first.call(null, es__36419);
        if(cljs.core.truth_(temp__3971__auto____36421)) {
          var e__36422 = temp__3971__auto____36421;
          var G__36428 = cljs.core.next.call(null, es__36419);
          var G__36429 = tcoll__36420.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll__36420, cljs.core.key.call(null, e__36422), cljs.core.val.call(null, e__36422));
          es__36419 = G__36428;
          tcoll__36420 = G__36429;
          continue
        }else {
          return tcoll__36420
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__36423 = this;
  if(cljs.core.truth_(this__36423.editable_QMARK_)) {
    this__36423.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, this__36423.len, 2), this__36423.arr, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__36424 = this;
  return tcoll.cljs$core$ILookup$_lookup$arity$3(tcoll, k, null)
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__36425 = this;
  if(cljs.core.truth_(this__36425.editable_QMARK_)) {
    var idx__36426 = cljs.core.array_map_index_of.call(null, tcoll, k);
    if(idx__36426 === -1) {
      return not_found
    }else {
      return this__36425.arr[idx__36426 + 1]
    }
  }else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__36427 = this;
  if(cljs.core.truth_(this__36427.editable_QMARK_)) {
    return cljs.core.quot.call(null, this__36427.len, 2)
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap;
cljs.core.array__GT_transient_hash_map = function array__GT_transient_hash_map(len, arr) {
  var out__36432 = cljs.core.transient$.call(null, cljs.core.ObjMap.EMPTY);
  var i__36433 = 0;
  while(true) {
    if(i__36433 < len) {
      var G__36434 = cljs.core.assoc_BANG_.call(null, out__36432, arr[i__36433], arr[i__36433 + 1]);
      var G__36435 = i__36433 + 2;
      out__36432 = G__36434;
      i__36433 = G__36435;
      continue
    }else {
      return out__36432
    }
    break
  }
};
cljs.core.Box = function(val) {
  this.val = val
};
cljs.core.Box.cljs$lang$type = true;
cljs.core.Box.cljs$lang$ctorPrSeq = function(this__2310__auto__) {
  return cljs.core.list.call(null, "cljs.core/Box")
};
cljs.core.Box;
cljs.core.key_test = function key_test(key, other) {
  if(goog.isString(key)) {
    return key === other
  }else {
    return cljs.core._EQ_.call(null, key, other)
  }
};
cljs.core.mask = function mask(hash, shift) {
  return hash >>> shift & 31
};
cljs.core.clone_and_set = function() {
  var clone_and_set = null;
  var clone_and_set__3 = function(arr, i, a) {
    var G__36440__36441 = arr.slice();
    G__36440__36441[i] = a;
    return G__36440__36441
  };
  var clone_and_set__5 = function(arr, i, a, j, b) {
    var G__36442__36443 = arr.slice();
    G__36442__36443[i] = a;
    G__36442__36443[j] = b;
    return G__36442__36443
  };
  clone_and_set = function(arr, i, a, j, b) {
    switch(arguments.length) {
      case 3:
        return clone_and_set__3.call(this, arr, i, a);
      case 5:
        return clone_and_set__5.call(this, arr, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  clone_and_set.cljs$lang$arity$3 = clone_and_set__3;
  clone_and_set.cljs$lang$arity$5 = clone_and_set__5;
  return clone_and_set
}();
cljs.core.remove_pair = function remove_pair(arr, i) {
  var new_arr__36445 = cljs.core.make_array.call(null, arr.length - 2);
  cljs.core.array_copy.call(null, arr, 0, new_arr__36445, 0, 2 * i);
  cljs.core.array_copy.call(null, arr, 2 * (i + 1), new_arr__36445, 2 * i, new_arr__36445.length - 2 * i);
  return new_arr__36445
};
cljs.core.bitmap_indexed_node_index = function bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count.call(null, bitmap & bit - 1)
};
cljs.core.bitpos = function bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31)
};
cljs.core.edit_and_set = function() {
  var edit_and_set = null;
  var edit_and_set__4 = function(inode, edit, i, a) {
    var editable__36448 = inode.ensure_editable(edit);
    editable__36448.arr[i] = a;
    return editable__36448
  };
  var edit_and_set__6 = function(inode, edit, i, a, j, b) {
    var editable__36449 = inode.ensure_editable(edit);
    editable__36449.arr[i] = a;
    editable__36449.arr[j] = b;
    return editable__36449
  };
  edit_and_set = function(inode, edit, i, a, j, b) {
    switch(arguments.length) {
      case 4:
        return edit_and_set__4.call(this, inode, edit, i, a);
      case 6:
        return edit_and_set__6.call(this, inode, edit, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  edit_and_set.cljs$lang$arity$4 = edit_and_set__4;
  edit_and_set.cljs$lang$arity$6 = edit_and_set__6;
  return edit_and_set
}();
cljs.core.inode_kv_reduce = function inode_kv_reduce(arr, f, init) {
  var len__36456 = arr.length;
  var i__36457 = 0;
  var init__36458 = init;
  while(true) {
    if(i__36457 < len__36456) {
      var init__36461 = function() {
        var k__36459 = arr[i__36457];
        if(!(k__36459 == null)) {
          return f.call(null, init__36458, k__36459, arr[i__36457 + 1])
        }else {
          var node__36460 = arr[i__36457 + 1];
          if(!(node__36460 == null)) {
            return node__36460.kv_reduce(f, init__36458)
          }else {
            return init__36458
          }
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__36461)) {
        return cljs.core.deref.call(null, init__36461)
      }else {
        var G__36462 = i__36457 + 2;
        var G__36463 = init__36461;
        i__36457 = G__36462;
        init__36458 = G__36463;
        continue
      }
    }else {
      return init__36458
    }
    break
  }
};
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr
};
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/BitmapIndexedNode")
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var this__36464 = this;
  var inode__36465 = this;
  if(this__36464.bitmap === bit) {
    return null
  }else {
    var editable__36466 = inode__36465.ensure_editable(e);
    var earr__36467 = editable__36466.arr;
    var len__36468 = earr__36467.length;
    editable__36466.bitmap = bit ^ editable__36466.bitmap;
    cljs.core.array_copy.call(null, earr__36467, 2 * (i + 1), earr__36467, 2 * i, len__36468 - 2 * (i + 1));
    earr__36467[len__36468 - 2] = null;
    earr__36467[len__36468 - 1] = null;
    return editable__36466
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__36469 = this;
  var inode__36470 = this;
  var bit__36471 = 1 << (hash >>> shift & 31);
  var idx__36472 = cljs.core.bitmap_indexed_node_index.call(null, this__36469.bitmap, bit__36471);
  if((this__36469.bitmap & bit__36471) === 0) {
    var n__36473 = cljs.core.bit_count.call(null, this__36469.bitmap);
    if(2 * n__36473 < this__36469.arr.length) {
      var editable__36474 = inode__36470.ensure_editable(edit);
      var earr__36475 = editable__36474.arr;
      added_leaf_QMARK_.val = true;
      cljs.core.array_copy_downward.call(null, earr__36475, 2 * idx__36472, earr__36475, 2 * (idx__36472 + 1), 2 * (n__36473 - idx__36472));
      earr__36475[2 * idx__36472] = key;
      earr__36475[2 * idx__36472 + 1] = val;
      editable__36474.bitmap = editable__36474.bitmap | bit__36471;
      return editable__36474
    }else {
      if(n__36473 >= 16) {
        var nodes__36476 = cljs.core.make_array.call(null, 32);
        var jdx__36477 = hash >>> shift & 31;
        nodes__36476[jdx__36477] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
        var i__36478 = 0;
        var j__36479 = 0;
        while(true) {
          if(i__36478 < 32) {
            if((this__36469.bitmap >>> i__36478 & 1) === 0) {
              var G__36532 = i__36478 + 1;
              var G__36533 = j__36479;
              i__36478 = G__36532;
              j__36479 = G__36533;
              continue
            }else {
              nodes__36476[i__36478] = !(this__36469.arr[j__36479] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, cljs.core.hash.call(null, this__36469.arr[j__36479]), this__36469.arr[j__36479], this__36469.arr[j__36479 + 1], added_leaf_QMARK_) : this__36469.arr[j__36479 + 1];
              var G__36534 = i__36478 + 1;
              var G__36535 = j__36479 + 2;
              i__36478 = G__36534;
              j__36479 = G__36535;
              continue
            }
          }else {
          }
          break
        }
        return new cljs.core.ArrayNode(edit, n__36473 + 1, nodes__36476)
      }else {
        if("\ufdd0'else") {
          var new_arr__36480 = cljs.core.make_array.call(null, 2 * (n__36473 + 4));
          cljs.core.array_copy.call(null, this__36469.arr, 0, new_arr__36480, 0, 2 * idx__36472);
          new_arr__36480[2 * idx__36472] = key;
          new_arr__36480[2 * idx__36472 + 1] = val;
          cljs.core.array_copy.call(null, this__36469.arr, 2 * idx__36472, new_arr__36480, 2 * (idx__36472 + 1), 2 * (n__36473 - idx__36472));
          added_leaf_QMARK_.val = true;
          var editable__36481 = inode__36470.ensure_editable(edit);
          editable__36481.arr = new_arr__36480;
          editable__36481.bitmap = editable__36481.bitmap | bit__36471;
          return editable__36481
        }else {
          return null
        }
      }
    }
  }else {
    var key_or_nil__36482 = this__36469.arr[2 * idx__36472];
    var val_or_node__36483 = this__36469.arr[2 * idx__36472 + 1];
    if(key_or_nil__36482 == null) {
      var n__36484 = val_or_node__36483.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__36484 === val_or_node__36483) {
        return inode__36470
      }else {
        return cljs.core.edit_and_set.call(null, inode__36470, edit, 2 * idx__36472 + 1, n__36484)
      }
    }else {
      if(cljs.core.key_test.call(null, key, key_or_nil__36482)) {
        if(val === val_or_node__36483) {
          return inode__36470
        }else {
          return cljs.core.edit_and_set.call(null, inode__36470, edit, 2 * idx__36472 + 1, val)
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_.val = true;
          return cljs.core.edit_and_set.call(null, inode__36470, edit, 2 * idx__36472, null, 2 * idx__36472 + 1, cljs.core.create_node.call(null, edit, shift + 5, key_or_nil__36482, val_or_node__36483, hash, key, val))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var this__36485 = this;
  var inode__36486 = this;
  return cljs.core.create_inode_seq.call(null, this__36485.arr)
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__36487 = this;
  var inode__36488 = this;
  var bit__36489 = 1 << (hash >>> shift & 31);
  if((this__36487.bitmap & bit__36489) === 0) {
    return inode__36488
  }else {
    var idx__36490 = cljs.core.bitmap_indexed_node_index.call(null, this__36487.bitmap, bit__36489);
    var key_or_nil__36491 = this__36487.arr[2 * idx__36490];
    var val_or_node__36492 = this__36487.arr[2 * idx__36490 + 1];
    if(key_or_nil__36491 == null) {
      var n__36493 = val_or_node__36492.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
      if(n__36493 === val_or_node__36492) {
        return inode__36488
      }else {
        if(!(n__36493 == null)) {
          return cljs.core.edit_and_set.call(null, inode__36488, edit, 2 * idx__36490 + 1, n__36493)
        }else {
          if(this__36487.bitmap === bit__36489) {
            return null
          }else {
            if("\ufdd0'else") {
              return inode__36488.edit_and_remove_pair(edit, bit__36489, idx__36490)
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core.key_test.call(null, key, key_or_nil__36491)) {
        removed_leaf_QMARK_[0] = true;
        return inode__36488.edit_and_remove_pair(edit, bit__36489, idx__36490)
      }else {
        if("\ufdd0'else") {
          return inode__36488
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var this__36494 = this;
  var inode__36495 = this;
  if(e === this__36494.edit) {
    return inode__36495
  }else {
    var n__36496 = cljs.core.bit_count.call(null, this__36494.bitmap);
    var new_arr__36497 = cljs.core.make_array.call(null, n__36496 < 0 ? 4 : 2 * (n__36496 + 1));
    cljs.core.array_copy.call(null, this__36494.arr, 0, new_arr__36497, 0, 2 * n__36496);
    return new cljs.core.BitmapIndexedNode(e, this__36494.bitmap, new_arr__36497)
  }
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var this__36498 = this;
  var inode__36499 = this;
  return cljs.core.inode_kv_reduce.call(null, this__36498.arr, f, init)
};
cljs.core.BitmapIndexedNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var this__36500 = this;
  var inode__36501 = this;
  var bit__36502 = 1 << (hash >>> shift & 31);
  if((this__36500.bitmap & bit__36502) === 0) {
    return not_found
  }else {
    var idx__36503 = cljs.core.bitmap_indexed_node_index.call(null, this__36500.bitmap, bit__36502);
    var key_or_nil__36504 = this__36500.arr[2 * idx__36503];
    var val_or_node__36505 = this__36500.arr[2 * idx__36503 + 1];
    if(key_or_nil__36504 == null) {
      return val_or_node__36505.inode_find(shift + 5, hash, key, not_found)
    }else {
      if(cljs.core.key_test.call(null, key, key_or_nil__36504)) {
        return cljs.core.PersistentVector.fromArray([key_or_nil__36504, val_or_node__36505], true)
      }else {
        if("\ufdd0'else") {
          return not_found
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_without = function(shift, hash, key) {
  var this__36506 = this;
  var inode__36507 = this;
  var bit__36508 = 1 << (hash >>> shift & 31);
  if((this__36506.bitmap & bit__36508) === 0) {
    return inode__36507
  }else {
    var idx__36509 = cljs.core.bitmap_indexed_node_index.call(null, this__36506.bitmap, bit__36508);
    var key_or_nil__36510 = this__36506.arr[2 * idx__36509];
    var val_or_node__36511 = this__36506.arr[2 * idx__36509 + 1];
    if(key_or_nil__36510 == null) {
      var n__36512 = val_or_node__36511.inode_without(shift + 5, hash, key);
      if(n__36512 === val_or_node__36511) {
        return inode__36507
      }else {
        if(!(n__36512 == null)) {
          return new cljs.core.BitmapIndexedNode(null, this__36506.bitmap, cljs.core.clone_and_set.call(null, this__36506.arr, 2 * idx__36509 + 1, n__36512))
        }else {
          if(this__36506.bitmap === bit__36508) {
            return null
          }else {
            if("\ufdd0'else") {
              return new cljs.core.BitmapIndexedNode(null, this__36506.bitmap ^ bit__36508, cljs.core.remove_pair.call(null, this__36506.arr, idx__36509))
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core.key_test.call(null, key, key_or_nil__36510)) {
        return new cljs.core.BitmapIndexedNode(null, this__36506.bitmap ^ bit__36508, cljs.core.remove_pair.call(null, this__36506.arr, idx__36509))
      }else {
        if("\ufdd0'else") {
          return inode__36507
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__36513 = this;
  var inode__36514 = this;
  var bit__36515 = 1 << (hash >>> shift & 31);
  var idx__36516 = cljs.core.bitmap_indexed_node_index.call(null, this__36513.bitmap, bit__36515);
  if((this__36513.bitmap & bit__36515) === 0) {
    var n__36517 = cljs.core.bit_count.call(null, this__36513.bitmap);
    if(n__36517 >= 16) {
      var nodes__36518 = cljs.core.make_array.call(null, 32);
      var jdx__36519 = hash >>> shift & 31;
      nodes__36518[jdx__36519] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      var i__36520 = 0;
      var j__36521 = 0;
      while(true) {
        if(i__36520 < 32) {
          if((this__36513.bitmap >>> i__36520 & 1) === 0) {
            var G__36536 = i__36520 + 1;
            var G__36537 = j__36521;
            i__36520 = G__36536;
            j__36521 = G__36537;
            continue
          }else {
            nodes__36518[i__36520] = !(this__36513.arr[j__36521] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, cljs.core.hash.call(null, this__36513.arr[j__36521]), this__36513.arr[j__36521], this__36513.arr[j__36521 + 1], added_leaf_QMARK_) : this__36513.arr[j__36521 + 1];
            var G__36538 = i__36520 + 1;
            var G__36539 = j__36521 + 2;
            i__36520 = G__36538;
            j__36521 = G__36539;
            continue
          }
        }else {
        }
        break
      }
      return new cljs.core.ArrayNode(null, n__36517 + 1, nodes__36518)
    }else {
      var new_arr__36522 = cljs.core.make_array.call(null, 2 * (n__36517 + 1));
      cljs.core.array_copy.call(null, this__36513.arr, 0, new_arr__36522, 0, 2 * idx__36516);
      new_arr__36522[2 * idx__36516] = key;
      new_arr__36522[2 * idx__36516 + 1] = val;
      cljs.core.array_copy.call(null, this__36513.arr, 2 * idx__36516, new_arr__36522, 2 * (idx__36516 + 1), 2 * (n__36517 - idx__36516));
      added_leaf_QMARK_.val = true;
      return new cljs.core.BitmapIndexedNode(null, this__36513.bitmap | bit__36515, new_arr__36522)
    }
  }else {
    var key_or_nil__36523 = this__36513.arr[2 * idx__36516];
    var val_or_node__36524 = this__36513.arr[2 * idx__36516 + 1];
    if(key_or_nil__36523 == null) {
      var n__36525 = val_or_node__36524.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__36525 === val_or_node__36524) {
        return inode__36514
      }else {
        return new cljs.core.BitmapIndexedNode(null, this__36513.bitmap, cljs.core.clone_and_set.call(null, this__36513.arr, 2 * idx__36516 + 1, n__36525))
      }
    }else {
      if(cljs.core.key_test.call(null, key, key_or_nil__36523)) {
        if(val === val_or_node__36524) {
          return inode__36514
        }else {
          return new cljs.core.BitmapIndexedNode(null, this__36513.bitmap, cljs.core.clone_and_set.call(null, this__36513.arr, 2 * idx__36516 + 1, val))
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_.val = true;
          return new cljs.core.BitmapIndexedNode(null, this__36513.bitmap, cljs.core.clone_and_set.call(null, this__36513.arr, 2 * idx__36516, null, 2 * idx__36516 + 1, cljs.core.create_node.call(null, shift + 5, key_or_nil__36523, val_or_node__36524, hash, key, val)))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var this__36526 = this;
  var inode__36527 = this;
  var bit__36528 = 1 << (hash >>> shift & 31);
  if((this__36526.bitmap & bit__36528) === 0) {
    return not_found
  }else {
    var idx__36529 = cljs.core.bitmap_indexed_node_index.call(null, this__36526.bitmap, bit__36528);
    var key_or_nil__36530 = this__36526.arr[2 * idx__36529];
    var val_or_node__36531 = this__36526.arr[2 * idx__36529 + 1];
    if(key_or_nil__36530 == null) {
      return val_or_node__36531.inode_lookup(shift + 5, hash, key, not_found)
    }else {
      if(cljs.core.key_test.call(null, key, key_or_nil__36530)) {
        return val_or_node__36531
      }else {
        if("\ufdd0'else") {
          return not_found
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode;
cljs.core.BitmapIndexedNode.EMPTY = new cljs.core.BitmapIndexedNode(null, 0, cljs.core.make_array.call(null, 0));
cljs.core.pack_array_node = function pack_array_node(array_node, edit, idx) {
  var arr__36547 = array_node.arr;
  var len__36548 = 2 * (array_node.cnt - 1);
  var new_arr__36549 = cljs.core.make_array.call(null, len__36548);
  var i__36550 = 0;
  var j__36551 = 1;
  var bitmap__36552 = 0;
  while(true) {
    if(i__36550 < len__36548) {
      if(function() {
        var and__3822__auto____36553 = !(i__36550 === idx);
        if(and__3822__auto____36553) {
          return!(arr__36547[i__36550] == null)
        }else {
          return and__3822__auto____36553
        }
      }()) {
        new_arr__36549[j__36551] = arr__36547[i__36550];
        var G__36554 = i__36550 + 1;
        var G__36555 = j__36551 + 2;
        var G__36556 = bitmap__36552 | 1 << i__36550;
        i__36550 = G__36554;
        j__36551 = G__36555;
        bitmap__36552 = G__36556;
        continue
      }else {
        var G__36557 = i__36550 + 1;
        var G__36558 = j__36551;
        var G__36559 = bitmap__36552;
        i__36550 = G__36557;
        j__36551 = G__36558;
        bitmap__36552 = G__36559;
        continue
      }
    }else {
      return new cljs.core.BitmapIndexedNode(edit, bitmap__36552, new_arr__36549)
    }
    break
  }
};
cljs.core.ArrayNode = function(edit, cnt, arr) {
  this.edit = edit;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/ArrayNode")
};
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__36560 = this;
  var inode__36561 = this;
  var idx__36562 = hash >>> shift & 31;
  var node__36563 = this__36560.arr[idx__36562];
  if(node__36563 == null) {
    var editable__36564 = cljs.core.edit_and_set.call(null, inode__36561, edit, idx__36562, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_));
    editable__36564.cnt = editable__36564.cnt + 1;
    return editable__36564
  }else {
    var n__36565 = node__36563.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__36565 === node__36563) {
      return inode__36561
    }else {
      return cljs.core.edit_and_set.call(null, inode__36561, edit, idx__36562, n__36565)
    }
  }
};
cljs.core.ArrayNode.prototype.inode_seq = function() {
  var this__36566 = this;
  var inode__36567 = this;
  return cljs.core.create_array_node_seq.call(null, this__36566.arr)
};
cljs.core.ArrayNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__36568 = this;
  var inode__36569 = this;
  var idx__36570 = hash >>> shift & 31;
  var node__36571 = this__36568.arr[idx__36570];
  if(node__36571 == null) {
    return inode__36569
  }else {
    var n__36572 = node__36571.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
    if(n__36572 === node__36571) {
      return inode__36569
    }else {
      if(n__36572 == null) {
        if(this__36568.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__36569, edit, idx__36570)
        }else {
          var editable__36573 = cljs.core.edit_and_set.call(null, inode__36569, edit, idx__36570, n__36572);
          editable__36573.cnt = editable__36573.cnt - 1;
          return editable__36573
        }
      }else {
        if("\ufdd0'else") {
          return cljs.core.edit_and_set.call(null, inode__36569, edit, idx__36570, n__36572)
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.ArrayNode.prototype.ensure_editable = function(e) {
  var this__36574 = this;
  var inode__36575 = this;
  if(e === this__36574.edit) {
    return inode__36575
  }else {
    return new cljs.core.ArrayNode(e, this__36574.cnt, this__36574.arr.slice())
  }
};
cljs.core.ArrayNode.prototype.kv_reduce = function(f, init) {
  var this__36576 = this;
  var inode__36577 = this;
  var len__36578 = this__36576.arr.length;
  var i__36579 = 0;
  var init__36580 = init;
  while(true) {
    if(i__36579 < len__36578) {
      var node__36581 = this__36576.arr[i__36579];
      if(!(node__36581 == null)) {
        var init__36582 = node__36581.kv_reduce(f, init__36580);
        if(cljs.core.reduced_QMARK_.call(null, init__36582)) {
          return cljs.core.deref.call(null, init__36582)
        }else {
          var G__36601 = i__36579 + 1;
          var G__36602 = init__36582;
          i__36579 = G__36601;
          init__36580 = G__36602;
          continue
        }
      }else {
        return null
      }
    }else {
      return init__36580
    }
    break
  }
};
cljs.core.ArrayNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var this__36583 = this;
  var inode__36584 = this;
  var idx__36585 = hash >>> shift & 31;
  var node__36586 = this__36583.arr[idx__36585];
  if(!(node__36586 == null)) {
    return node__36586.inode_find(shift + 5, hash, key, not_found)
  }else {
    return not_found
  }
};
cljs.core.ArrayNode.prototype.inode_without = function(shift, hash, key) {
  var this__36587 = this;
  var inode__36588 = this;
  var idx__36589 = hash >>> shift & 31;
  var node__36590 = this__36587.arr[idx__36589];
  if(!(node__36590 == null)) {
    var n__36591 = node__36590.inode_without(shift + 5, hash, key);
    if(n__36591 === node__36590) {
      return inode__36588
    }else {
      if(n__36591 == null) {
        if(this__36587.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__36588, null, idx__36589)
        }else {
          return new cljs.core.ArrayNode(null, this__36587.cnt - 1, cljs.core.clone_and_set.call(null, this__36587.arr, idx__36589, n__36591))
        }
      }else {
        if("\ufdd0'else") {
          return new cljs.core.ArrayNode(null, this__36587.cnt, cljs.core.clone_and_set.call(null, this__36587.arr, idx__36589, n__36591))
        }else {
          return null
        }
      }
    }
  }else {
    return inode__36588
  }
};
cljs.core.ArrayNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__36592 = this;
  var inode__36593 = this;
  var idx__36594 = hash >>> shift & 31;
  var node__36595 = this__36592.arr[idx__36594];
  if(node__36595 == null) {
    return new cljs.core.ArrayNode(null, this__36592.cnt + 1, cljs.core.clone_and_set.call(null, this__36592.arr, idx__36594, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_)))
  }else {
    var n__36596 = node__36595.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__36596 === node__36595) {
      return inode__36593
    }else {
      return new cljs.core.ArrayNode(null, this__36592.cnt, cljs.core.clone_and_set.call(null, this__36592.arr, idx__36594, n__36596))
    }
  }
};
cljs.core.ArrayNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var this__36597 = this;
  var inode__36598 = this;
  var idx__36599 = hash >>> shift & 31;
  var node__36600 = this__36597.arr[idx__36599];
  if(!(node__36600 == null)) {
    return node__36600.inode_lookup(shift + 5, hash, key, not_found)
  }else {
    return not_found
  }
};
cljs.core.ArrayNode;
cljs.core.hash_collision_node_find_index = function hash_collision_node_find_index(arr, cnt, key) {
  var lim__36605 = 2 * cnt;
  var i__36606 = 0;
  while(true) {
    if(i__36606 < lim__36605) {
      if(cljs.core.key_test.call(null, key, arr[i__36606])) {
        return i__36606
      }else {
        var G__36607 = i__36606 + 2;
        i__36606 = G__36607;
        continue
      }
    }else {
      return-1
    }
    break
  }
};
cljs.core.HashCollisionNode = function(edit, collision_hash, cnt, arr) {
  this.edit = edit;
  this.collision_hash = collision_hash;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/HashCollisionNode")
};
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__36608 = this;
  var inode__36609 = this;
  if(hash === this__36608.collision_hash) {
    var idx__36610 = cljs.core.hash_collision_node_find_index.call(null, this__36608.arr, this__36608.cnt, key);
    if(idx__36610 === -1) {
      if(this__36608.arr.length > 2 * this__36608.cnt) {
        var editable__36611 = cljs.core.edit_and_set.call(null, inode__36609, edit, 2 * this__36608.cnt, key, 2 * this__36608.cnt + 1, val);
        added_leaf_QMARK_.val = true;
        editable__36611.cnt = editable__36611.cnt + 1;
        return editable__36611
      }else {
        var len__36612 = this__36608.arr.length;
        var new_arr__36613 = cljs.core.make_array.call(null, len__36612 + 2);
        cljs.core.array_copy.call(null, this__36608.arr, 0, new_arr__36613, 0, len__36612);
        new_arr__36613[len__36612] = key;
        new_arr__36613[len__36612 + 1] = val;
        added_leaf_QMARK_.val = true;
        return inode__36609.ensure_editable_array(edit, this__36608.cnt + 1, new_arr__36613)
      }
    }else {
      if(this__36608.arr[idx__36610 + 1] === val) {
        return inode__36609
      }else {
        return cljs.core.edit_and_set.call(null, inode__36609, edit, idx__36610 + 1, val)
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(edit, 1 << (this__36608.collision_hash >>> shift & 31), [null, inode__36609, null, null])).inode_assoc_BANG_(edit, shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_seq = function() {
  var this__36614 = this;
  var inode__36615 = this;
  return cljs.core.create_inode_seq.call(null, this__36614.arr)
};
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__36616 = this;
  var inode__36617 = this;
  var idx__36618 = cljs.core.hash_collision_node_find_index.call(null, this__36616.arr, this__36616.cnt, key);
  if(idx__36618 === -1) {
    return inode__36617
  }else {
    removed_leaf_QMARK_[0] = true;
    if(this__36616.cnt === 1) {
      return null
    }else {
      var editable__36619 = inode__36617.ensure_editable(edit);
      var earr__36620 = editable__36619.arr;
      earr__36620[idx__36618] = earr__36620[2 * this__36616.cnt - 2];
      earr__36620[idx__36618 + 1] = earr__36620[2 * this__36616.cnt - 1];
      earr__36620[2 * this__36616.cnt - 1] = null;
      earr__36620[2 * this__36616.cnt - 2] = null;
      editable__36619.cnt = editable__36619.cnt - 1;
      return editable__36619
    }
  }
};
cljs.core.HashCollisionNode.prototype.ensure_editable = function(e) {
  var this__36621 = this;
  var inode__36622 = this;
  if(e === this__36621.edit) {
    return inode__36622
  }else {
    var new_arr__36623 = cljs.core.make_array.call(null, 2 * (this__36621.cnt + 1));
    cljs.core.array_copy.call(null, this__36621.arr, 0, new_arr__36623, 0, 2 * this__36621.cnt);
    return new cljs.core.HashCollisionNode(e, this__36621.collision_hash, this__36621.cnt, new_arr__36623)
  }
};
cljs.core.HashCollisionNode.prototype.kv_reduce = function(f, init) {
  var this__36624 = this;
  var inode__36625 = this;
  return cljs.core.inode_kv_reduce.call(null, this__36624.arr, f, init)
};
cljs.core.HashCollisionNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var this__36626 = this;
  var inode__36627 = this;
  var idx__36628 = cljs.core.hash_collision_node_find_index.call(null, this__36626.arr, this__36626.cnt, key);
  if(idx__36628 < 0) {
    return not_found
  }else {
    if(cljs.core.key_test.call(null, key, this__36626.arr[idx__36628])) {
      return cljs.core.PersistentVector.fromArray([this__36626.arr[idx__36628], this__36626.arr[idx__36628 + 1]], true)
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_without = function(shift, hash, key) {
  var this__36629 = this;
  var inode__36630 = this;
  var idx__36631 = cljs.core.hash_collision_node_find_index.call(null, this__36629.arr, this__36629.cnt, key);
  if(idx__36631 === -1) {
    return inode__36630
  }else {
    if(this__36629.cnt === 1) {
      return null
    }else {
      if("\ufdd0'else") {
        return new cljs.core.HashCollisionNode(null, this__36629.collision_hash, this__36629.cnt - 1, cljs.core.remove_pair.call(null, this__36629.arr, cljs.core.quot.call(null, idx__36631, 2)))
      }else {
        return null
      }
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__36632 = this;
  var inode__36633 = this;
  if(hash === this__36632.collision_hash) {
    var idx__36634 = cljs.core.hash_collision_node_find_index.call(null, this__36632.arr, this__36632.cnt, key);
    if(idx__36634 === -1) {
      var len__36635 = this__36632.arr.length;
      var new_arr__36636 = cljs.core.make_array.call(null, len__36635 + 2);
      cljs.core.array_copy.call(null, this__36632.arr, 0, new_arr__36636, 0, len__36635);
      new_arr__36636[len__36635] = key;
      new_arr__36636[len__36635 + 1] = val;
      added_leaf_QMARK_.val = true;
      return new cljs.core.HashCollisionNode(null, this__36632.collision_hash, this__36632.cnt + 1, new_arr__36636)
    }else {
      if(cljs.core._EQ_.call(null, this__36632.arr[idx__36634], val)) {
        return inode__36633
      }else {
        return new cljs.core.HashCollisionNode(null, this__36632.collision_hash, this__36632.cnt, cljs.core.clone_and_set.call(null, this__36632.arr, idx__36634 + 1, val))
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(null, 1 << (this__36632.collision_hash >>> shift & 31), [null, inode__36633])).inode_assoc(shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var this__36637 = this;
  var inode__36638 = this;
  var idx__36639 = cljs.core.hash_collision_node_find_index.call(null, this__36637.arr, this__36637.cnt, key);
  if(idx__36639 < 0) {
    return not_found
  }else {
    if(cljs.core.key_test.call(null, key, this__36637.arr[idx__36639])) {
      return this__36637.arr[idx__36639 + 1]
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.HashCollisionNode.prototype.ensure_editable_array = function(e, count, array) {
  var this__36640 = this;
  var inode__36641 = this;
  if(e === this__36640.edit) {
    this__36640.arr = array;
    this__36640.cnt = count;
    return inode__36641
  }else {
    return new cljs.core.HashCollisionNode(this__36640.edit, this__36640.collision_hash, count, array)
  }
};
cljs.core.HashCollisionNode;
cljs.core.create_node = function() {
  var create_node = null;
  var create_node__6 = function(shift, key1, val1, key2hash, key2, val2) {
    var key1hash__36646 = cljs.core.hash.call(null, key1);
    if(key1hash__36646 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__36646, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___36647 = new cljs.core.Box(false);
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift, key1hash__36646, key1, val1, added_leaf_QMARK___36647).inode_assoc(shift, key2hash, key2, val2, added_leaf_QMARK___36647)
    }
  };
  var create_node__7 = function(edit, shift, key1, val1, key2hash, key2, val2) {
    var key1hash__36648 = cljs.core.hash.call(null, key1);
    if(key1hash__36648 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__36648, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___36649 = new cljs.core.Box(false);
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift, key1hash__36648, key1, val1, added_leaf_QMARK___36649).inode_assoc_BANG_(edit, shift, key2hash, key2, val2, added_leaf_QMARK___36649)
    }
  };
  create_node = function(edit, shift, key1, val1, key2hash, key2, val2) {
    switch(arguments.length) {
      case 6:
        return create_node__6.call(this, edit, shift, key1, val1, key2hash, key2);
      case 7:
        return create_node__7.call(this, edit, shift, key1, val1, key2hash, key2, val2)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_node.cljs$lang$arity$6 = create_node__6;
  create_node.cljs$lang$arity$7 = create_node__7;
  return create_node
}();
cljs.core.NodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31850572
};
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/NodeSeq")
};
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__36650 = this;
  var h__2192__auto____36651 = this__36650.__hash;
  if(!(h__2192__auto____36651 == null)) {
    return h__2192__auto____36651
  }else {
    var h__2192__auto____36652 = cljs.core.hash_coll.call(null, coll);
    this__36650.__hash = h__2192__auto____36652;
    return h__2192__auto____36652
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__36653 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.NodeSeq.prototype.toString = function() {
  var this__36654 = this;
  var this__36655 = this;
  return cljs.core.pr_str.call(null, this__36655)
};
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__36656 = this;
  return this$
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__36657 = this;
  if(this__36657.s == null) {
    return cljs.core.PersistentVector.fromArray([this__36657.nodes[this__36657.i], this__36657.nodes[this__36657.i + 1]], true)
  }else {
    return cljs.core.first.call(null, this__36657.s)
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__36658 = this;
  if(this__36658.s == null) {
    return cljs.core.create_inode_seq.call(null, this__36658.nodes, this__36658.i + 2, null)
  }else {
    return cljs.core.create_inode_seq.call(null, this__36658.nodes, this__36658.i, cljs.core.next.call(null, this__36658.s))
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__36659 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__36660 = this;
  return new cljs.core.NodeSeq(meta, this__36660.nodes, this__36660.i, this__36660.s, this__36660.__hash)
};
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__36661 = this;
  return this__36661.meta
};
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__36662 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__36662.meta)
};
cljs.core.NodeSeq;
cljs.core.create_inode_seq = function() {
  var create_inode_seq = null;
  var create_inode_seq__1 = function(nodes) {
    return create_inode_seq.call(null, nodes, 0, null)
  };
  var create_inode_seq__3 = function(nodes, i, s) {
    if(s == null) {
      var len__36669 = nodes.length;
      var j__36670 = i;
      while(true) {
        if(j__36670 < len__36669) {
          if(!(nodes[j__36670] == null)) {
            return new cljs.core.NodeSeq(null, nodes, j__36670, null, null)
          }else {
            var temp__3971__auto____36671 = nodes[j__36670 + 1];
            if(cljs.core.truth_(temp__3971__auto____36671)) {
              var node__36672 = temp__3971__auto____36671;
              var temp__3971__auto____36673 = node__36672.inode_seq();
              if(cljs.core.truth_(temp__3971__auto____36673)) {
                var node_seq__36674 = temp__3971__auto____36673;
                return new cljs.core.NodeSeq(null, nodes, j__36670 + 2, node_seq__36674, null)
              }else {
                var G__36675 = j__36670 + 2;
                j__36670 = G__36675;
                continue
              }
            }else {
              var G__36676 = j__36670 + 2;
              j__36670 = G__36676;
              continue
            }
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.NodeSeq(null, nodes, i, s, null)
    }
  };
  create_inode_seq = function(nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_inode_seq__1.call(this, nodes);
      case 3:
        return create_inode_seq__3.call(this, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_inode_seq.cljs$lang$arity$1 = create_inode_seq__1;
  create_inode_seq.cljs$lang$arity$3 = create_inode_seq__3;
  return create_inode_seq
}();
cljs.core.ArrayNodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31850572
};
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/ArrayNodeSeq")
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__36677 = this;
  var h__2192__auto____36678 = this__36677.__hash;
  if(!(h__2192__auto____36678 == null)) {
    return h__2192__auto____36678
  }else {
    var h__2192__auto____36679 = cljs.core.hash_coll.call(null, coll);
    this__36677.__hash = h__2192__auto____36679;
    return h__2192__auto____36679
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__36680 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.ArrayNodeSeq.prototype.toString = function() {
  var this__36681 = this;
  var this__36682 = this;
  return cljs.core.pr_str.call(null, this__36682)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__36683 = this;
  return this$
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__36684 = this;
  return cljs.core.first.call(null, this__36684.s)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__36685 = this;
  return cljs.core.create_array_node_seq.call(null, null, this__36685.nodes, this__36685.i, cljs.core.next.call(null, this__36685.s))
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__36686 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__36687 = this;
  return new cljs.core.ArrayNodeSeq(meta, this__36687.nodes, this__36687.i, this__36687.s, this__36687.__hash)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__36688 = this;
  return this__36688.meta
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__36689 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__36689.meta)
};
cljs.core.ArrayNodeSeq;
cljs.core.create_array_node_seq = function() {
  var create_array_node_seq = null;
  var create_array_node_seq__1 = function(nodes) {
    return create_array_node_seq.call(null, null, nodes, 0, null)
  };
  var create_array_node_seq__4 = function(meta, nodes, i, s) {
    if(s == null) {
      var len__36696 = nodes.length;
      var j__36697 = i;
      while(true) {
        if(j__36697 < len__36696) {
          var temp__3971__auto____36698 = nodes[j__36697];
          if(cljs.core.truth_(temp__3971__auto____36698)) {
            var nj__36699 = temp__3971__auto____36698;
            var temp__3971__auto____36700 = nj__36699.inode_seq();
            if(cljs.core.truth_(temp__3971__auto____36700)) {
              var ns__36701 = temp__3971__auto____36700;
              return new cljs.core.ArrayNodeSeq(meta, nodes, j__36697 + 1, ns__36701, null)
            }else {
              var G__36702 = j__36697 + 1;
              j__36697 = G__36702;
              continue
            }
          }else {
            var G__36703 = j__36697 + 1;
            j__36697 = G__36703;
            continue
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, null)
    }
  };
  create_array_node_seq = function(meta, nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_array_node_seq__1.call(this, meta);
      case 4:
        return create_array_node_seq__4.call(this, meta, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_array_node_seq.cljs$lang$arity$1 = create_array_node_seq__1;
  create_array_node_seq.cljs$lang$arity$4 = create_array_node_seq__4;
  return create_array_node_seq
}();
cljs.core.PersistentHashMap = function(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.root = root;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 1;
  this.cljs$lang$protocol_mask$partition0$ = 16123663
};
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentHashMap")
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__36706 = this;
  return new cljs.core.TransientHashMap({}, this__36706.root, this__36706.cnt, this__36706.has_nil_QMARK_, this__36706.nil_val)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__36707 = this;
  var h__2192__auto____36708 = this__36707.__hash;
  if(!(h__2192__auto____36708 == null)) {
    return h__2192__auto____36708
  }else {
    var h__2192__auto____36709 = cljs.core.hash_imap.call(null, coll);
    this__36707.__hash = h__2192__auto____36709;
    return h__2192__auto____36709
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__36710 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, k, null)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__36711 = this;
  if(k == null) {
    if(this__36711.has_nil_QMARK_) {
      return this__36711.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__36711.root == null) {
      return not_found
    }else {
      if("\ufdd0'else") {
        return this__36711.root.inode_lookup(0, cljs.core.hash.call(null, k), k, not_found)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__36712 = this;
  if(k == null) {
    if(function() {
      var and__3822__auto____36713 = this__36712.has_nil_QMARK_;
      if(and__3822__auto____36713) {
        return v === this__36712.nil_val
      }else {
        return and__3822__auto____36713
      }
    }()) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__36712.meta, this__36712.has_nil_QMARK_ ? this__36712.cnt : this__36712.cnt + 1, this__36712.root, true, v, null)
    }
  }else {
    var added_leaf_QMARK___36714 = new cljs.core.Box(false);
    var new_root__36715 = (this__36712.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__36712.root).inode_assoc(0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___36714);
    if(new_root__36715 === this__36712.root) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__36712.meta, added_leaf_QMARK___36714.val ? this__36712.cnt + 1 : this__36712.cnt, new_root__36715, this__36712.has_nil_QMARK_, this__36712.nil_val, null)
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__36716 = this;
  if(k == null) {
    return this__36716.has_nil_QMARK_
  }else {
    if(this__36716.root == null) {
      return false
    }else {
      if("\ufdd0'else") {
        return!(this__36716.root.inode_lookup(0, cljs.core.hash.call(null, k), k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.call = function() {
  var G__36739 = null;
  var G__36739__2 = function(this_sym36717, k) {
    var this__36719 = this;
    var this_sym36717__36720 = this;
    var coll__36721 = this_sym36717__36720;
    return coll__36721.cljs$core$ILookup$_lookup$arity$2(coll__36721, k)
  };
  var G__36739__3 = function(this_sym36718, k, not_found) {
    var this__36719 = this;
    var this_sym36718__36722 = this;
    var coll__36723 = this_sym36718__36722;
    return coll__36723.cljs$core$ILookup$_lookup$arity$3(coll__36723, k, not_found)
  };
  G__36739 = function(this_sym36718, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__36739__2.call(this, this_sym36718, k);
      case 3:
        return G__36739__3.call(this, this_sym36718, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__36739
}();
cljs.core.PersistentHashMap.prototype.apply = function(this_sym36704, args36705) {
  var this__36724 = this;
  return this_sym36704.call.apply(this_sym36704, [this_sym36704].concat(args36705.slice()))
};
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__36725 = this;
  var init__36726 = this__36725.has_nil_QMARK_ ? f.call(null, init, null, this__36725.nil_val) : init;
  if(cljs.core.reduced_QMARK_.call(null, init__36726)) {
    return cljs.core.deref.call(null, init__36726)
  }else {
    if(!(this__36725.root == null)) {
      return this__36725.root.kv_reduce(f, init__36726)
    }else {
      if("\ufdd0'else") {
        return init__36726
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__36727 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentHashMap.prototype.toString = function() {
  var this__36728 = this;
  var this__36729 = this;
  return cljs.core.pr_str.call(null, this__36729)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__36730 = this;
  if(this__36730.cnt > 0) {
    var s__36731 = !(this__36730.root == null) ? this__36730.root.inode_seq() : null;
    if(this__36730.has_nil_QMARK_) {
      return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([null, this__36730.nil_val], true), s__36731)
    }else {
      return s__36731
    }
  }else {
    return null
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__36732 = this;
  return this__36732.cnt
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__36733 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__36734 = this;
  return new cljs.core.PersistentHashMap(meta, this__36734.cnt, this__36734.root, this__36734.has_nil_QMARK_, this__36734.nil_val, this__36734.__hash)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__36735 = this;
  return this__36735.meta
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__36736 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, this__36736.meta)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__36737 = this;
  if(k == null) {
    if(this__36737.has_nil_QMARK_) {
      return new cljs.core.PersistentHashMap(this__36737.meta, this__36737.cnt - 1, this__36737.root, false, null, null)
    }else {
      return coll
    }
  }else {
    if(this__36737.root == null) {
      return coll
    }else {
      if("\ufdd0'else") {
        var new_root__36738 = this__36737.root.inode_without(0, cljs.core.hash.call(null, k), k);
        if(new_root__36738 === this__36737.root) {
          return coll
        }else {
          return new cljs.core.PersistentHashMap(this__36737.meta, this__36737.cnt - 1, new_root__36738, this__36737.has_nil_QMARK_, this__36737.nil_val, null)
        }
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap;
cljs.core.PersistentHashMap.EMPTY = new cljs.core.PersistentHashMap(null, 0, null, false, null, 0);
cljs.core.PersistentHashMap.fromArrays = function(ks, vs) {
  var len__36740 = ks.length;
  var i__36741 = 0;
  var out__36742 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
  while(true) {
    if(i__36741 < len__36740) {
      var G__36743 = i__36741 + 1;
      var G__36744 = cljs.core.assoc_BANG_.call(null, out__36742, ks[i__36741], vs[i__36741]);
      i__36741 = G__36743;
      out__36742 = G__36744;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__36742)
    }
    break
  }
};
cljs.core.TransientHashMap = function(edit, root, count, has_nil_QMARK_, nil_val) {
  this.edit = edit;
  this.root = root;
  this.count = count;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.cljs$lang$protocol_mask$partition1$ = 14;
  this.cljs$lang$protocol_mask$partition0$ = 258
};
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/TransientHashMap")
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__36745 = this;
  return tcoll.without_BANG_(key)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__36746 = this;
  return tcoll.assoc_BANG_(key, val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, val) {
  var this__36747 = this;
  return tcoll.conj_BANG_(val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__36748 = this;
  return tcoll.persistent_BANG_()
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__36749 = this;
  if(k == null) {
    if(this__36749.has_nil_QMARK_) {
      return this__36749.nil_val
    }else {
      return null
    }
  }else {
    if(this__36749.root == null) {
      return null
    }else {
      return this__36749.root.inode_lookup(0, cljs.core.hash.call(null, k), k)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__36750 = this;
  if(k == null) {
    if(this__36750.has_nil_QMARK_) {
      return this__36750.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__36750.root == null) {
      return not_found
    }else {
      return this__36750.root.inode_lookup(0, cljs.core.hash.call(null, k), k, not_found)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__36751 = this;
  if(this__36751.edit) {
    return this__36751.count
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.conj_BANG_ = function(o) {
  var this__36752 = this;
  var tcoll__36753 = this;
  if(this__36752.edit) {
    if(function() {
      var G__36754__36755 = o;
      if(G__36754__36755) {
        if(function() {
          var or__3824__auto____36756 = G__36754__36755.cljs$lang$protocol_mask$partition0$ & 2048;
          if(or__3824__auto____36756) {
            return or__3824__auto____36756
          }else {
            return G__36754__36755.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__36754__36755.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__36754__36755)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__36754__36755)
      }
    }()) {
      return tcoll__36753.assoc_BANG_(cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__36757 = cljs.core.seq.call(null, o);
      var tcoll__36758 = tcoll__36753;
      while(true) {
        var temp__3971__auto____36759 = cljs.core.first.call(null, es__36757);
        if(cljs.core.truth_(temp__3971__auto____36759)) {
          var e__36760 = temp__3971__auto____36759;
          var G__36771 = cljs.core.next.call(null, es__36757);
          var G__36772 = tcoll__36758.assoc_BANG_(cljs.core.key.call(null, e__36760), cljs.core.val.call(null, e__36760));
          es__36757 = G__36771;
          tcoll__36758 = G__36772;
          continue
        }else {
          return tcoll__36758
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent");
  }
};
cljs.core.TransientHashMap.prototype.assoc_BANG_ = function(k, v) {
  var this__36761 = this;
  var tcoll__36762 = this;
  if(this__36761.edit) {
    if(k == null) {
      if(this__36761.nil_val === v) {
      }else {
        this__36761.nil_val = v
      }
      if(this__36761.has_nil_QMARK_) {
      }else {
        this__36761.count = this__36761.count + 1;
        this__36761.has_nil_QMARK_ = true
      }
      return tcoll__36762
    }else {
      var added_leaf_QMARK___36763 = new cljs.core.Box(false);
      var node__36764 = (this__36761.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__36761.root).inode_assoc_BANG_(this__36761.edit, 0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___36763);
      if(node__36764 === this__36761.root) {
      }else {
        this__36761.root = node__36764
      }
      if(added_leaf_QMARK___36763.val) {
        this__36761.count = this__36761.count + 1
      }else {
      }
      return tcoll__36762
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.without_BANG_ = function(k) {
  var this__36765 = this;
  var tcoll__36766 = this;
  if(this__36765.edit) {
    if(k == null) {
      if(this__36765.has_nil_QMARK_) {
        this__36765.has_nil_QMARK_ = false;
        this__36765.nil_val = null;
        this__36765.count = this__36765.count - 1;
        return tcoll__36766
      }else {
        return tcoll__36766
      }
    }else {
      if(this__36765.root == null) {
        return tcoll__36766
      }else {
        var removed_leaf_QMARK___36767 = new cljs.core.Box(false);
        var node__36768 = this__36765.root.inode_without_BANG_(this__36765.edit, 0, cljs.core.hash.call(null, k), k, removed_leaf_QMARK___36767);
        if(node__36768 === this__36765.root) {
        }else {
          this__36765.root = node__36768
        }
        if(cljs.core.truth_(removed_leaf_QMARK___36767[0])) {
          this__36765.count = this__36765.count - 1
        }else {
        }
        return tcoll__36766
      }
    }
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.persistent_BANG_ = function() {
  var this__36769 = this;
  var tcoll__36770 = this;
  if(this__36769.edit) {
    this__36769.edit = null;
    return new cljs.core.PersistentHashMap(null, this__36769.count, this__36769.root, this__36769.has_nil_QMARK_, this__36769.nil_val, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientHashMap;
cljs.core.tree_map_seq_push = function tree_map_seq_push(node, stack, ascending_QMARK_) {
  var t__36775 = node;
  var stack__36776 = stack;
  while(true) {
    if(!(t__36775 == null)) {
      var G__36777 = ascending_QMARK_ ? t__36775.left : t__36775.right;
      var G__36778 = cljs.core.conj.call(null, stack__36776, t__36775);
      t__36775 = G__36777;
      stack__36776 = G__36778;
      continue
    }else {
      return stack__36776
    }
    break
  }
};
cljs.core.PersistentTreeMapSeq = function(meta, stack, ascending_QMARK_, cnt, __hash) {
  this.meta = meta;
  this.stack = stack;
  this.ascending_QMARK_ = ascending_QMARK_;
  this.cnt = cnt;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31850570
};
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentTreeMapSeq")
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__36779 = this;
  var h__2192__auto____36780 = this__36779.__hash;
  if(!(h__2192__auto____36780 == null)) {
    return h__2192__auto____36780
  }else {
    var h__2192__auto____36781 = cljs.core.hash_coll.call(null, coll);
    this__36779.__hash = h__2192__auto____36781;
    return h__2192__auto____36781
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__36782 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.toString = function() {
  var this__36783 = this;
  var this__36784 = this;
  return cljs.core.pr_str.call(null, this__36784)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__36785 = this;
  return this$
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__36786 = this;
  if(this__36786.cnt < 0) {
    return cljs.core.count.call(null, cljs.core.next.call(null, coll)) + 1
  }else {
    return this__36786.cnt
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var this__36787 = this;
  return cljs.core.peek.call(null, this__36787.stack)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var this__36788 = this;
  var t__36789 = cljs.core.first.call(null, this__36788.stack);
  var next_stack__36790 = cljs.core.tree_map_seq_push.call(null, this__36788.ascending_QMARK_ ? t__36789.right : t__36789.left, cljs.core.next.call(null, this__36788.stack), this__36788.ascending_QMARK_);
  if(!(next_stack__36790 == null)) {
    return new cljs.core.PersistentTreeMapSeq(null, next_stack__36790, this__36788.ascending_QMARK_, this__36788.cnt - 1, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__36791 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__36792 = this;
  return new cljs.core.PersistentTreeMapSeq(meta, this__36792.stack, this__36792.ascending_QMARK_, this__36792.cnt, this__36792.__hash)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__36793 = this;
  return this__36793.meta
};
cljs.core.PersistentTreeMapSeq;
cljs.core.create_tree_map_seq = function create_tree_map_seq(tree, ascending_QMARK_, cnt) {
  return new cljs.core.PersistentTreeMapSeq(null, cljs.core.tree_map_seq_push.call(null, tree, null, ascending_QMARK_), ascending_QMARK_, cnt, null)
};
cljs.core.balance_left = function balance_left(key, val, ins, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
      return new cljs.core.RedNode(ins.key, ins.val, ins.left.blacken(), new cljs.core.BlackNode(key, val, ins.right, right, null), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
        return new cljs.core.RedNode(ins.right.key, ins.right.val, new cljs.core.BlackNode(ins.key, ins.val, ins.left, ins.right.left, null), new cljs.core.BlackNode(key, val, ins.right.right, right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, ins, right, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, ins, right, null)
  }
};
cljs.core.balance_right = function balance_right(key, val, left, ins) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
      return new cljs.core.RedNode(ins.key, ins.val, new cljs.core.BlackNode(key, val, left, ins.left, null), ins.right.blacken(), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
        return new cljs.core.RedNode(ins.left.key, ins.left.val, new cljs.core.BlackNode(key, val, left, ins.left.left, null), new cljs.core.BlackNode(ins.key, ins.val, ins.left.right, ins.right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, left, ins, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, left, ins, null)
  }
};
cljs.core.balance_left_del = function balance_left_del(key, val, del, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, del.blacken(), right, null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right)) {
      return cljs.core.balance_right.call(null, key, val, del, right.redden())
    }else {
      if(function() {
        var and__3822__auto____36795 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right);
        if(and__3822__auto____36795) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right.left)
        }else {
          return and__3822__auto____36795
        }
      }()) {
        return new cljs.core.RedNode(right.left.key, right.left.val, new cljs.core.BlackNode(key, val, del, right.left.left, null), cljs.core.balance_right.call(null, right.key, right.val, right.left.right, right.right.redden()), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.balance_right_del = function balance_right_del(key, val, left, del) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, left, del.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left)) {
      return cljs.core.balance_left.call(null, key, val, left.redden(), del)
    }else {
      if(function() {
        var and__3822__auto____36797 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left);
        if(and__3822__auto____36797) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left.right)
        }else {
          return and__3822__auto____36797
        }
      }()) {
        return new cljs.core.RedNode(left.right.key, left.right.val, cljs.core.balance_left.call(null, left.key, left.val, left.left.redden(), left.right.left), new cljs.core.BlackNode(key, val, left.right.right, del, null), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_kv_reduce = function tree_map_kv_reduce(node, f, init) {
  var init__36801 = f.call(null, init, node.key, node.val);
  if(cljs.core.reduced_QMARK_.call(null, init__36801)) {
    return cljs.core.deref.call(null, init__36801)
  }else {
    var init__36802 = !(node.left == null) ? tree_map_kv_reduce.call(null, node.left, f, init__36801) : init__36801;
    if(cljs.core.reduced_QMARK_.call(null, init__36802)) {
      return cljs.core.deref.call(null, init__36802)
    }else {
      var init__36803 = !(node.right == null) ? tree_map_kv_reduce.call(null, node.right, f, init__36802) : init__36802;
      if(cljs.core.reduced_QMARK_.call(null, init__36803)) {
        return cljs.core.deref.call(null, init__36803)
      }else {
        return init__36803
      }
    }
  }
};
cljs.core.BlackNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32402207
};
cljs.core.BlackNode.cljs$lang$type = true;
cljs.core.BlackNode.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/BlackNode")
};
cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__36806 = this;
  var h__2192__auto____36807 = this__36806.__hash;
  if(!(h__2192__auto____36807 == null)) {
    return h__2192__auto____36807
  }else {
    var h__2192__auto____36808 = cljs.core.hash_coll.call(null, coll);
    this__36806.__hash = h__2192__auto____36808;
    return h__2192__auto____36808
  }
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__36809 = this;
  return node.cljs$core$IIndexed$_nth$arity$3(node, k, null)
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__36810 = this;
  return node.cljs$core$IIndexed$_nth$arity$3(node, k, not_found)
};
cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__36811 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__36811.key, this__36811.val], true), k, v)
};
cljs.core.BlackNode.prototype.call = function() {
  var G__36859 = null;
  var G__36859__2 = function(this_sym36812, k) {
    var this__36814 = this;
    var this_sym36812__36815 = this;
    var node__36816 = this_sym36812__36815;
    return node__36816.cljs$core$ILookup$_lookup$arity$2(node__36816, k)
  };
  var G__36859__3 = function(this_sym36813, k, not_found) {
    var this__36814 = this;
    var this_sym36813__36817 = this;
    var node__36818 = this_sym36813__36817;
    return node__36818.cljs$core$ILookup$_lookup$arity$3(node__36818, k, not_found)
  };
  G__36859 = function(this_sym36813, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__36859__2.call(this, this_sym36813, k);
      case 3:
        return G__36859__3.call(this, this_sym36813, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__36859
}();
cljs.core.BlackNode.prototype.apply = function(this_sym36804, args36805) {
  var this__36819 = this;
  return this_sym36804.call.apply(this_sym36804, [this_sym36804].concat(args36805.slice()))
};
cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__36820 = this;
  return cljs.core.PersistentVector.fromArray([this__36820.key, this__36820.val, o], true)
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__36821 = this;
  return this__36821.key
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__36822 = this;
  return this__36822.val
};
cljs.core.BlackNode.prototype.add_right = function(ins) {
  var this__36823 = this;
  var node__36824 = this;
  return ins.balance_right(node__36824)
};
cljs.core.BlackNode.prototype.redden = function() {
  var this__36825 = this;
  var node__36826 = this;
  return new cljs.core.RedNode(this__36825.key, this__36825.val, this__36825.left, this__36825.right, null)
};
cljs.core.BlackNode.prototype.remove_right = function(del) {
  var this__36827 = this;
  var node__36828 = this;
  return cljs.core.balance_right_del.call(null, this__36827.key, this__36827.val, this__36827.left, del)
};
cljs.core.BlackNode.prototype.replace = function(key, val, left, right) {
  var this__36829 = this;
  var node__36830 = this;
  return new cljs.core.BlackNode(key, val, left, right, null)
};
cljs.core.BlackNode.prototype.kv_reduce = function(f, init) {
  var this__36831 = this;
  var node__36832 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__36832, f, init)
};
cljs.core.BlackNode.prototype.remove_left = function(del) {
  var this__36833 = this;
  var node__36834 = this;
  return cljs.core.balance_left_del.call(null, this__36833.key, this__36833.val, del, this__36833.right)
};
cljs.core.BlackNode.prototype.add_left = function(ins) {
  var this__36835 = this;
  var node__36836 = this;
  return ins.balance_left(node__36836)
};
cljs.core.BlackNode.prototype.balance_left = function(parent) {
  var this__36837 = this;
  var node__36838 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, node__36838, parent.right, null)
};
cljs.core.BlackNode.prototype.toString = function() {
  var G__36860 = null;
  var G__36860__0 = function() {
    var this__36839 = this;
    var this__36841 = this;
    return cljs.core.pr_str.call(null, this__36841)
  };
  G__36860 = function() {
    switch(arguments.length) {
      case 0:
        return G__36860__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__36860
}();
cljs.core.BlackNode.prototype.balance_right = function(parent) {
  var this__36842 = this;
  var node__36843 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__36843, null)
};
cljs.core.BlackNode.prototype.blacken = function() {
  var this__36844 = this;
  var node__36845 = this;
  return node__36845
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__36846 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__36847 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__36848 = this;
  return cljs.core.list.call(null, this__36848.key, this__36848.val)
};
cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__36849 = this;
  return 2
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__36850 = this;
  return this__36850.val
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__36851 = this;
  return cljs.core.PersistentVector.fromArray([this__36851.key], true)
};
cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__36852 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__36852.key, this__36852.val], true), n, v)
};
cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__36853 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__36854 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__36854.key, this__36854.val], true), meta)
};
cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__36855 = this;
  return null
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__36856 = this;
  if(n === 0) {
    return this__36856.key
  }else {
    if(n === 1) {
      return this__36856.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__36857 = this;
  if(n === 0) {
    return this__36857.key
  }else {
    if(n === 1) {
      return this__36857.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__36858 = this;
  return cljs.core.PersistentVector.EMPTY
};
cljs.core.BlackNode;
cljs.core.RedNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32402207
};
cljs.core.RedNode.cljs$lang$type = true;
cljs.core.RedNode.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/RedNode")
};
cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__36863 = this;
  var h__2192__auto____36864 = this__36863.__hash;
  if(!(h__2192__auto____36864 == null)) {
    return h__2192__auto____36864
  }else {
    var h__2192__auto____36865 = cljs.core.hash_coll.call(null, coll);
    this__36863.__hash = h__2192__auto____36865;
    return h__2192__auto____36865
  }
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__36866 = this;
  return node.cljs$core$IIndexed$_nth$arity$3(node, k, null)
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__36867 = this;
  return node.cljs$core$IIndexed$_nth$arity$3(node, k, not_found)
};
cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__36868 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__36868.key, this__36868.val], true), k, v)
};
cljs.core.RedNode.prototype.call = function() {
  var G__36916 = null;
  var G__36916__2 = function(this_sym36869, k) {
    var this__36871 = this;
    var this_sym36869__36872 = this;
    var node__36873 = this_sym36869__36872;
    return node__36873.cljs$core$ILookup$_lookup$arity$2(node__36873, k)
  };
  var G__36916__3 = function(this_sym36870, k, not_found) {
    var this__36871 = this;
    var this_sym36870__36874 = this;
    var node__36875 = this_sym36870__36874;
    return node__36875.cljs$core$ILookup$_lookup$arity$3(node__36875, k, not_found)
  };
  G__36916 = function(this_sym36870, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__36916__2.call(this, this_sym36870, k);
      case 3:
        return G__36916__3.call(this, this_sym36870, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__36916
}();
cljs.core.RedNode.prototype.apply = function(this_sym36861, args36862) {
  var this__36876 = this;
  return this_sym36861.call.apply(this_sym36861, [this_sym36861].concat(args36862.slice()))
};
cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__36877 = this;
  return cljs.core.PersistentVector.fromArray([this__36877.key, this__36877.val, o], true)
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__36878 = this;
  return this__36878.key
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__36879 = this;
  return this__36879.val
};
cljs.core.RedNode.prototype.add_right = function(ins) {
  var this__36880 = this;
  var node__36881 = this;
  return new cljs.core.RedNode(this__36880.key, this__36880.val, this__36880.left, ins, null)
};
cljs.core.RedNode.prototype.redden = function() {
  var this__36882 = this;
  var node__36883 = this;
  throw new Error("red-black tree invariant violation");
};
cljs.core.RedNode.prototype.remove_right = function(del) {
  var this__36884 = this;
  var node__36885 = this;
  return new cljs.core.RedNode(this__36884.key, this__36884.val, this__36884.left, del, null)
};
cljs.core.RedNode.prototype.replace = function(key, val, left, right) {
  var this__36886 = this;
  var node__36887 = this;
  return new cljs.core.RedNode(key, val, left, right, null)
};
cljs.core.RedNode.prototype.kv_reduce = function(f, init) {
  var this__36888 = this;
  var node__36889 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__36889, f, init)
};
cljs.core.RedNode.prototype.remove_left = function(del) {
  var this__36890 = this;
  var node__36891 = this;
  return new cljs.core.RedNode(this__36890.key, this__36890.val, del, this__36890.right, null)
};
cljs.core.RedNode.prototype.add_left = function(ins) {
  var this__36892 = this;
  var node__36893 = this;
  return new cljs.core.RedNode(this__36892.key, this__36892.val, ins, this__36892.right, null)
};
cljs.core.RedNode.prototype.balance_left = function(parent) {
  var this__36894 = this;
  var node__36895 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__36894.left)) {
    return new cljs.core.RedNode(this__36894.key, this__36894.val, this__36894.left.blacken(), new cljs.core.BlackNode(parent.key, parent.val, this__36894.right, parent.right, null), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__36894.right)) {
      return new cljs.core.RedNode(this__36894.right.key, this__36894.right.val, new cljs.core.BlackNode(this__36894.key, this__36894.val, this__36894.left, this__36894.right.left, null), new cljs.core.BlackNode(parent.key, parent.val, this__36894.right.right, parent.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, node__36895, parent.right, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.toString = function() {
  var G__36917 = null;
  var G__36917__0 = function() {
    var this__36896 = this;
    var this__36898 = this;
    return cljs.core.pr_str.call(null, this__36898)
  };
  G__36917 = function() {
    switch(arguments.length) {
      case 0:
        return G__36917__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__36917
}();
cljs.core.RedNode.prototype.balance_right = function(parent) {
  var this__36899 = this;
  var node__36900 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__36899.right)) {
    return new cljs.core.RedNode(this__36899.key, this__36899.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__36899.left, null), this__36899.right.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__36899.left)) {
      return new cljs.core.RedNode(this__36899.left.key, this__36899.left.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__36899.left.left, null), new cljs.core.BlackNode(this__36899.key, this__36899.val, this__36899.left.right, this__36899.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__36900, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.blacken = function() {
  var this__36901 = this;
  var node__36902 = this;
  return new cljs.core.BlackNode(this__36901.key, this__36901.val, this__36901.left, this__36901.right, null)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__36903 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__36904 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__36905 = this;
  return cljs.core.list.call(null, this__36905.key, this__36905.val)
};
cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__36906 = this;
  return 2
};
cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__36907 = this;
  return this__36907.val
};
cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__36908 = this;
  return cljs.core.PersistentVector.fromArray([this__36908.key], true)
};
cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__36909 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__36909.key, this__36909.val], true), n, v)
};
cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__36910 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__36911 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__36911.key, this__36911.val], true), meta)
};
cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__36912 = this;
  return null
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__36913 = this;
  if(n === 0) {
    return this__36913.key
  }else {
    if(n === 1) {
      return this__36913.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__36914 = this;
  if(n === 0) {
    return this__36914.key
  }else {
    if(n === 1) {
      return this__36914.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__36915 = this;
  return cljs.core.PersistentVector.EMPTY
};
cljs.core.RedNode;
cljs.core.tree_map_add = function tree_map_add(comp, tree, k, v, found) {
  if(tree == null) {
    return new cljs.core.RedNode(k, v, null, null, null)
  }else {
    var c__36921 = comp.call(null, k, tree.key);
    if(c__36921 === 0) {
      found[0] = tree;
      return null
    }else {
      if(c__36921 < 0) {
        var ins__36922 = tree_map_add.call(null, comp, tree.left, k, v, found);
        if(!(ins__36922 == null)) {
          return tree.add_left(ins__36922)
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var ins__36923 = tree_map_add.call(null, comp, tree.right, k, v, found);
          if(!(ins__36923 == null)) {
            return tree.add_right(ins__36923)
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_append = function tree_map_append(left, right) {
  if(left == null) {
    return right
  }else {
    if(right == null) {
      return left
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left)) {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          var app__36926 = tree_map_append.call(null, left.right, right.left);
          if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__36926)) {
            return new cljs.core.RedNode(app__36926.key, app__36926.val, new cljs.core.RedNode(left.key, left.val, left.left, app__36926.left, null), new cljs.core.RedNode(right.key, right.val, app__36926.right, right.right, null), null)
          }else {
            return new cljs.core.RedNode(left.key, left.val, left.left, new cljs.core.RedNode(right.key, right.val, app__36926, right.right, null), null)
          }
        }else {
          return new cljs.core.RedNode(left.key, left.val, left.left, tree_map_append.call(null, left.right, right), null)
        }
      }else {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          return new cljs.core.RedNode(right.key, right.val, tree_map_append.call(null, left, right.left), right.right, null)
        }else {
          if("\ufdd0'else") {
            var app__36927 = tree_map_append.call(null, left.right, right.left);
            if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__36927)) {
              return new cljs.core.RedNode(app__36927.key, app__36927.val, new cljs.core.BlackNode(left.key, left.val, left.left, app__36927.left, null), new cljs.core.BlackNode(right.key, right.val, app__36927.right, right.right, null), null)
            }else {
              return cljs.core.balance_left_del.call(null, left.key, left.val, left.left, new cljs.core.BlackNode(right.key, right.val, app__36927, right.right, null))
            }
          }else {
            return null
          }
        }
      }
    }
  }
};
cljs.core.tree_map_remove = function tree_map_remove(comp, tree, k, found) {
  if(!(tree == null)) {
    var c__36933 = comp.call(null, k, tree.key);
    if(c__36933 === 0) {
      found[0] = tree;
      return cljs.core.tree_map_append.call(null, tree.left, tree.right)
    }else {
      if(c__36933 < 0) {
        var del__36934 = tree_map_remove.call(null, comp, tree.left, k, found);
        if(function() {
          var or__3824__auto____36935 = !(del__36934 == null);
          if(or__3824__auto____36935) {
            return or__3824__auto____36935
          }else {
            return!(found[0] == null)
          }
        }()) {
          if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.left)) {
            return cljs.core.balance_left_del.call(null, tree.key, tree.val, del__36934, tree.right)
          }else {
            return new cljs.core.RedNode(tree.key, tree.val, del__36934, tree.right, null)
          }
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var del__36936 = tree_map_remove.call(null, comp, tree.right, k, found);
          if(function() {
            var or__3824__auto____36937 = !(del__36936 == null);
            if(or__3824__auto____36937) {
              return or__3824__auto____36937
            }else {
              return!(found[0] == null)
            }
          }()) {
            if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.right)) {
              return cljs.core.balance_right_del.call(null, tree.key, tree.val, tree.left, del__36936)
            }else {
              return new cljs.core.RedNode(tree.key, tree.val, tree.left, del__36936, null)
            }
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }else {
    return null
  }
};
cljs.core.tree_map_replace = function tree_map_replace(comp, tree, k, v) {
  var tk__36940 = tree.key;
  var c__36941 = comp.call(null, k, tk__36940);
  if(c__36941 === 0) {
    return tree.replace(tk__36940, v, tree.left, tree.right)
  }else {
    if(c__36941 < 0) {
      return tree.replace(tk__36940, tree.val, tree_map_replace.call(null, comp, tree.left, k, v), tree.right)
    }else {
      if("\ufdd0'else") {
        return tree.replace(tk__36940, tree.val, tree.left, tree_map_replace.call(null, comp, tree.right, k, v))
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentTreeMap = function(comp, tree, cnt, meta, __hash) {
  this.comp = comp;
  this.tree = tree;
  this.cnt = cnt;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 418776847
};
cljs.core.PersistentTreeMap.cljs$lang$type = true;
cljs.core.PersistentTreeMap.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentTreeMap")
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__36944 = this;
  var h__2192__auto____36945 = this__36944.__hash;
  if(!(h__2192__auto____36945 == null)) {
    return h__2192__auto____36945
  }else {
    var h__2192__auto____36946 = cljs.core.hash_imap.call(null, coll);
    this__36944.__hash = h__2192__auto____36946;
    return h__2192__auto____36946
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__36947 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, k, null)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__36948 = this;
  var n__36949 = coll.entry_at(k);
  if(!(n__36949 == null)) {
    return n__36949.val
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__36950 = this;
  var found__36951 = [null];
  var t__36952 = cljs.core.tree_map_add.call(null, this__36950.comp, this__36950.tree, k, v, found__36951);
  if(t__36952 == null) {
    var found_node__36953 = cljs.core.nth.call(null, found__36951, 0);
    if(cljs.core._EQ_.call(null, v, found_node__36953.val)) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__36950.comp, cljs.core.tree_map_replace.call(null, this__36950.comp, this__36950.tree, k, v), this__36950.cnt, this__36950.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__36950.comp, t__36952.blacken(), this__36950.cnt + 1, this__36950.meta, null)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__36954 = this;
  return!(coll.entry_at(k) == null)
};
cljs.core.PersistentTreeMap.prototype.call = function() {
  var G__36988 = null;
  var G__36988__2 = function(this_sym36955, k) {
    var this__36957 = this;
    var this_sym36955__36958 = this;
    var coll__36959 = this_sym36955__36958;
    return coll__36959.cljs$core$ILookup$_lookup$arity$2(coll__36959, k)
  };
  var G__36988__3 = function(this_sym36956, k, not_found) {
    var this__36957 = this;
    var this_sym36956__36960 = this;
    var coll__36961 = this_sym36956__36960;
    return coll__36961.cljs$core$ILookup$_lookup$arity$3(coll__36961, k, not_found)
  };
  G__36988 = function(this_sym36956, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__36988__2.call(this, this_sym36956, k);
      case 3:
        return G__36988__3.call(this, this_sym36956, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__36988
}();
cljs.core.PersistentTreeMap.prototype.apply = function(this_sym36942, args36943) {
  var this__36962 = this;
  return this_sym36942.call.apply(this_sym36942, [this_sym36942].concat(args36943.slice()))
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__36963 = this;
  if(!(this__36963.tree == null)) {
    return cljs.core.tree_map_kv_reduce.call(null, this__36963.tree, f, init)
  }else {
    return init
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__36964 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__36965 = this;
  if(this__36965.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__36965.tree, false, this__36965.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.toString = function() {
  var this__36966 = this;
  var this__36967 = this;
  return cljs.core.pr_str.call(null, this__36967)
};
cljs.core.PersistentTreeMap.prototype.entry_at = function(k) {
  var this__36968 = this;
  var coll__36969 = this;
  var t__36970 = this__36968.tree;
  while(true) {
    if(!(t__36970 == null)) {
      var c__36971 = this__36968.comp.call(null, k, t__36970.key);
      if(c__36971 === 0) {
        return t__36970
      }else {
        if(c__36971 < 0) {
          var G__36989 = t__36970.left;
          t__36970 = G__36989;
          continue
        }else {
          if("\ufdd0'else") {
            var G__36990 = t__36970.right;
            t__36970 = G__36990;
            continue
          }else {
            return null
          }
        }
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__36972 = this;
  if(this__36972.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__36972.tree, ascending_QMARK_, this__36972.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__36973 = this;
  if(this__36973.cnt > 0) {
    var stack__36974 = null;
    var t__36975 = this__36973.tree;
    while(true) {
      if(!(t__36975 == null)) {
        var c__36976 = this__36973.comp.call(null, k, t__36975.key);
        if(c__36976 === 0) {
          return new cljs.core.PersistentTreeMapSeq(null, cljs.core.conj.call(null, stack__36974, t__36975), ascending_QMARK_, -1, null)
        }else {
          if(cljs.core.truth_(ascending_QMARK_)) {
            if(c__36976 < 0) {
              var G__36991 = cljs.core.conj.call(null, stack__36974, t__36975);
              var G__36992 = t__36975.left;
              stack__36974 = G__36991;
              t__36975 = G__36992;
              continue
            }else {
              var G__36993 = stack__36974;
              var G__36994 = t__36975.right;
              stack__36974 = G__36993;
              t__36975 = G__36994;
              continue
            }
          }else {
            if("\ufdd0'else") {
              if(c__36976 > 0) {
                var G__36995 = cljs.core.conj.call(null, stack__36974, t__36975);
                var G__36996 = t__36975.right;
                stack__36974 = G__36995;
                t__36975 = G__36996;
                continue
              }else {
                var G__36997 = stack__36974;
                var G__36998 = t__36975.left;
                stack__36974 = G__36997;
                t__36975 = G__36998;
                continue
              }
            }else {
              return null
            }
          }
        }
      }else {
        if(stack__36974 == null) {
          return new cljs.core.PersistentTreeMapSeq(null, stack__36974, ascending_QMARK_, -1, null)
        }else {
          return null
        }
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__36977 = this;
  return cljs.core.key.call(null, entry)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__36978 = this;
  return this__36978.comp
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__36979 = this;
  if(this__36979.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__36979.tree, true, this__36979.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__36980 = this;
  return this__36980.cnt
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__36981 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__36982 = this;
  return new cljs.core.PersistentTreeMap(this__36982.comp, this__36982.tree, this__36982.cnt, meta, this__36982.__hash)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__36983 = this;
  return this__36983.meta
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__36984 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeMap.EMPTY, this__36984.meta)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__36985 = this;
  var found__36986 = [null];
  var t__36987 = cljs.core.tree_map_remove.call(null, this__36985.comp, this__36985.tree, k, found__36986);
  if(t__36987 == null) {
    if(cljs.core.nth.call(null, found__36986, 0) == null) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__36985.comp, null, 0, this__36985.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__36985.comp, t__36987.blacken(), this__36985.cnt - 1, this__36985.meta, null)
  }
};
cljs.core.PersistentTreeMap;
cljs.core.PersistentTreeMap.EMPTY = new cljs.core.PersistentTreeMap(cljs.core.compare, null, 0, null, 0);
cljs.core.hash_map = function() {
  var hash_map__delegate = function(keyvals) {
    var in__37001 = cljs.core.seq.call(null, keyvals);
    var out__37002 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
    while(true) {
      if(in__37001) {
        var G__37003 = cljs.core.nnext.call(null, in__37001);
        var G__37004 = cljs.core.assoc_BANG_.call(null, out__37002, cljs.core.first.call(null, in__37001), cljs.core.second.call(null, in__37001));
        in__37001 = G__37003;
        out__37002 = G__37004;
        continue
      }else {
        return cljs.core.persistent_BANG_.call(null, out__37002)
      }
      break
    }
  };
  var hash_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return hash_map__delegate.call(this, keyvals)
  };
  hash_map.cljs$lang$maxFixedArity = 0;
  hash_map.cljs$lang$applyTo = function(arglist__37005) {
    var keyvals = cljs.core.seq(arglist__37005);
    return hash_map__delegate(keyvals)
  };
  hash_map.cljs$lang$arity$variadic = hash_map__delegate;
  return hash_map
}();
cljs.core.array_map = function() {
  var array_map__delegate = function(keyvals) {
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, cljs.core.count.call(null, keyvals), 2), cljs.core.apply.call(null, cljs.core.array, keyvals), null)
  };
  var array_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return array_map__delegate.call(this, keyvals)
  };
  array_map.cljs$lang$maxFixedArity = 0;
  array_map.cljs$lang$applyTo = function(arglist__37006) {
    var keyvals = cljs.core.seq(arglist__37006);
    return array_map__delegate(keyvals)
  };
  array_map.cljs$lang$arity$variadic = array_map__delegate;
  return array_map
}();
cljs.core.obj_map = function() {
  var obj_map__delegate = function(keyvals) {
    var ks__37010 = [];
    var obj__37011 = {};
    var kvs__37012 = cljs.core.seq.call(null, keyvals);
    while(true) {
      if(kvs__37012) {
        ks__37010.push(cljs.core.first.call(null, kvs__37012));
        obj__37011[cljs.core.first.call(null, kvs__37012)] = cljs.core.second.call(null, kvs__37012);
        var G__37013 = cljs.core.nnext.call(null, kvs__37012);
        kvs__37012 = G__37013;
        continue
      }else {
        return cljs.core.ObjMap.fromObject.call(null, ks__37010, obj__37011)
      }
      break
    }
  };
  var obj_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return obj_map__delegate.call(this, keyvals)
  };
  obj_map.cljs$lang$maxFixedArity = 0;
  obj_map.cljs$lang$applyTo = function(arglist__37014) {
    var keyvals = cljs.core.seq(arglist__37014);
    return obj_map__delegate(keyvals)
  };
  obj_map.cljs$lang$arity$variadic = obj_map__delegate;
  return obj_map
}();
cljs.core.sorted_map = function() {
  var sorted_map__delegate = function(keyvals) {
    var in__37017 = cljs.core.seq.call(null, keyvals);
    var out__37018 = cljs.core.PersistentTreeMap.EMPTY;
    while(true) {
      if(in__37017) {
        var G__37019 = cljs.core.nnext.call(null, in__37017);
        var G__37020 = cljs.core.assoc.call(null, out__37018, cljs.core.first.call(null, in__37017), cljs.core.second.call(null, in__37017));
        in__37017 = G__37019;
        out__37018 = G__37020;
        continue
      }else {
        return out__37018
      }
      break
    }
  };
  var sorted_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_map__delegate.call(this, keyvals)
  };
  sorted_map.cljs$lang$maxFixedArity = 0;
  sorted_map.cljs$lang$applyTo = function(arglist__37021) {
    var keyvals = cljs.core.seq(arglist__37021);
    return sorted_map__delegate(keyvals)
  };
  sorted_map.cljs$lang$arity$variadic = sorted_map__delegate;
  return sorted_map
}();
cljs.core.sorted_map_by = function() {
  var sorted_map_by__delegate = function(comparator, keyvals) {
    var in__37024 = cljs.core.seq.call(null, keyvals);
    var out__37025 = new cljs.core.PersistentTreeMap(comparator, null, 0, null, 0);
    while(true) {
      if(in__37024) {
        var G__37026 = cljs.core.nnext.call(null, in__37024);
        var G__37027 = cljs.core.assoc.call(null, out__37025, cljs.core.first.call(null, in__37024), cljs.core.second.call(null, in__37024));
        in__37024 = G__37026;
        out__37025 = G__37027;
        continue
      }else {
        return out__37025
      }
      break
    }
  };
  var sorted_map_by = function(comparator, var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_map_by__delegate.call(this, comparator, keyvals)
  };
  sorted_map_by.cljs$lang$maxFixedArity = 1;
  sorted_map_by.cljs$lang$applyTo = function(arglist__37028) {
    var comparator = cljs.core.first(arglist__37028);
    var keyvals = cljs.core.rest(arglist__37028);
    return sorted_map_by__delegate(comparator, keyvals)
  };
  sorted_map_by.cljs$lang$arity$variadic = sorted_map_by__delegate;
  return sorted_map_by
}();
cljs.core.keys = function keys(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.first, hash_map))
};
cljs.core.key = function key(map_entry) {
  return cljs.core._key.call(null, map_entry)
};
cljs.core.vals = function vals(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.second, hash_map))
};
cljs.core.val = function val(map_entry) {
  return cljs.core._val.call(null, map_entry)
};
cljs.core.merge = function() {
  var merge__delegate = function(maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      return cljs.core.reduce.call(null, function(p1__37029_SHARP_, p2__37030_SHARP_) {
        return cljs.core.conj.call(null, function() {
          var or__3824__auto____37032 = p1__37029_SHARP_;
          if(cljs.core.truth_(or__3824__auto____37032)) {
            return or__3824__auto____37032
          }else {
            return cljs.core.ObjMap.EMPTY
          }
        }(), p2__37030_SHARP_)
      }, maps)
    }else {
      return null
    }
  };
  var merge = function(var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return merge__delegate.call(this, maps)
  };
  merge.cljs$lang$maxFixedArity = 0;
  merge.cljs$lang$applyTo = function(arglist__37033) {
    var maps = cljs.core.seq(arglist__37033);
    return merge__delegate(maps)
  };
  merge.cljs$lang$arity$variadic = merge__delegate;
  return merge
}();
cljs.core.merge_with = function() {
  var merge_with__delegate = function(f, maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      var merge_entry__37041 = function(m, e) {
        var k__37039 = cljs.core.first.call(null, e);
        var v__37040 = cljs.core.second.call(null, e);
        if(cljs.core.contains_QMARK_.call(null, m, k__37039)) {
          return cljs.core.assoc.call(null, m, k__37039, f.call(null, cljs.core._lookup.call(null, m, k__37039, null), v__37040))
        }else {
          return cljs.core.assoc.call(null, m, k__37039, v__37040)
        }
      };
      var merge2__37043 = function(m1, m2) {
        return cljs.core.reduce.call(null, merge_entry__37041, function() {
          var or__3824__auto____37042 = m1;
          if(cljs.core.truth_(or__3824__auto____37042)) {
            return or__3824__auto____37042
          }else {
            return cljs.core.ObjMap.EMPTY
          }
        }(), cljs.core.seq.call(null, m2))
      };
      return cljs.core.reduce.call(null, merge2__37043, maps)
    }else {
      return null
    }
  };
  var merge_with = function(f, var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return merge_with__delegate.call(this, f, maps)
  };
  merge_with.cljs$lang$maxFixedArity = 1;
  merge_with.cljs$lang$applyTo = function(arglist__37044) {
    var f = cljs.core.first(arglist__37044);
    var maps = cljs.core.rest(arglist__37044);
    return merge_with__delegate(f, maps)
  };
  merge_with.cljs$lang$arity$variadic = merge_with__delegate;
  return merge_with
}();
cljs.core.select_keys = function select_keys(map, keyseq) {
  var ret__37049 = cljs.core.ObjMap.EMPTY;
  var keys__37050 = cljs.core.seq.call(null, keyseq);
  while(true) {
    if(keys__37050) {
      var key__37051 = cljs.core.first.call(null, keys__37050);
      var entry__37052 = cljs.core._lookup.call(null, map, key__37051, "\ufdd0'cljs.core/not-found");
      var G__37053 = cljs.core.not_EQ_.call(null, entry__37052, "\ufdd0'cljs.core/not-found") ? cljs.core.assoc.call(null, ret__37049, key__37051, entry__37052) : ret__37049;
      var G__37054 = cljs.core.next.call(null, keys__37050);
      ret__37049 = G__37053;
      keys__37050 = G__37054;
      continue
    }else {
      return ret__37049
    }
    break
  }
};
cljs.core.PersistentHashSet = function(meta, hash_map, __hash) {
  this.meta = meta;
  this.hash_map = hash_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 1;
  this.cljs$lang$protocol_mask$partition0$ = 15077647
};
cljs.core.PersistentHashSet.cljs$lang$type = true;
cljs.core.PersistentHashSet.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentHashSet")
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__37058 = this;
  return new cljs.core.TransientHashSet(cljs.core.transient$.call(null, this__37058.hash_map))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__37059 = this;
  var h__2192__auto____37060 = this__37059.__hash;
  if(!(h__2192__auto____37060 == null)) {
    return h__2192__auto____37060
  }else {
    var h__2192__auto____37061 = cljs.core.hash_iset.call(null, coll);
    this__37059.__hash = h__2192__auto____37061;
    return h__2192__auto____37061
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__37062 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, v, null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__37063 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__37063.hash_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentHashSet.prototype.call = function() {
  var G__37084 = null;
  var G__37084__2 = function(this_sym37064, k) {
    var this__37066 = this;
    var this_sym37064__37067 = this;
    var coll__37068 = this_sym37064__37067;
    return coll__37068.cljs$core$ILookup$_lookup$arity$2(coll__37068, k)
  };
  var G__37084__3 = function(this_sym37065, k, not_found) {
    var this__37066 = this;
    var this_sym37065__37069 = this;
    var coll__37070 = this_sym37065__37069;
    return coll__37070.cljs$core$ILookup$_lookup$arity$3(coll__37070, k, not_found)
  };
  G__37084 = function(this_sym37065, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__37084__2.call(this, this_sym37065, k);
      case 3:
        return G__37084__3.call(this, this_sym37065, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__37084
}();
cljs.core.PersistentHashSet.prototype.apply = function(this_sym37056, args37057) {
  var this__37071 = this;
  return this_sym37056.call.apply(this_sym37056, [this_sym37056].concat(args37057.slice()))
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__37072 = this;
  return new cljs.core.PersistentHashSet(this__37072.meta, cljs.core.assoc.call(null, this__37072.hash_map, o, null), null)
};
cljs.core.PersistentHashSet.prototype.toString = function() {
  var this__37073 = this;
  var this__37074 = this;
  return cljs.core.pr_str.call(null, this__37074)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__37075 = this;
  return cljs.core.keys.call(null, this__37075.hash_map)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__37076 = this;
  return new cljs.core.PersistentHashSet(this__37076.meta, cljs.core.dissoc.call(null, this__37076.hash_map, v), null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__37077 = this;
  return cljs.core.count.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__37078 = this;
  var and__3822__auto____37079 = cljs.core.set_QMARK_.call(null, other);
  if(and__3822__auto____37079) {
    var and__3822__auto____37080 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3822__auto____37080) {
      return cljs.core.every_QMARK_.call(null, function(p1__37055_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__37055_SHARP_)
      }, other)
    }else {
      return and__3822__auto____37080
    }
  }else {
    return and__3822__auto____37079
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__37081 = this;
  return new cljs.core.PersistentHashSet(meta, this__37081.hash_map, this__37081.__hash)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__37082 = this;
  return this__37082.meta
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__37083 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentHashSet.EMPTY, this__37083.meta)
};
cljs.core.PersistentHashSet;
cljs.core.PersistentHashSet.EMPTY = new cljs.core.PersistentHashSet(null, cljs.core.hash_map.call(null), 0);
cljs.core.PersistentHashSet.fromArray = function(items) {
  var len__37085 = cljs.core.count.call(null, items);
  var i__37086 = 0;
  var out__37087 = cljs.core.transient$.call(null, cljs.core.PersistentHashSet.EMPTY);
  while(true) {
    if(i__37086 < len__37085) {
      var G__37088 = i__37086 + 1;
      var G__37089 = cljs.core.conj_BANG_.call(null, out__37087, items[i__37086]);
      i__37086 = G__37088;
      out__37087 = G__37089;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__37087)
    }
    break
  }
};
cljs.core.TransientHashSet = function(transient_map) {
  this.transient_map = transient_map;
  this.cljs$lang$protocol_mask$partition0$ = 259;
  this.cljs$lang$protocol_mask$partition1$ = 34
};
cljs.core.TransientHashSet.cljs$lang$type = true;
cljs.core.TransientHashSet.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/TransientHashSet")
};
cljs.core.TransientHashSet.prototype.call = function() {
  var G__37107 = null;
  var G__37107__2 = function(this_sym37093, k) {
    var this__37095 = this;
    var this_sym37093__37096 = this;
    var tcoll__37097 = this_sym37093__37096;
    if(cljs.core._lookup.call(null, this__37095.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return null
    }else {
      return k
    }
  };
  var G__37107__3 = function(this_sym37094, k, not_found) {
    var this__37095 = this;
    var this_sym37094__37098 = this;
    var tcoll__37099 = this_sym37094__37098;
    if(cljs.core._lookup.call(null, this__37095.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return not_found
    }else {
      return k
    }
  };
  G__37107 = function(this_sym37094, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__37107__2.call(this, this_sym37094, k);
      case 3:
        return G__37107__3.call(this, this_sym37094, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__37107
}();
cljs.core.TransientHashSet.prototype.apply = function(this_sym37091, args37092) {
  var this__37100 = this;
  return this_sym37091.call.apply(this_sym37091, [this_sym37091].concat(args37092.slice()))
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, v) {
  var this__37101 = this;
  return tcoll.cljs$core$ILookup$_lookup$arity$3(tcoll, v, null)
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, v, not_found) {
  var this__37102 = this;
  if(cljs.core._lookup.call(null, this__37102.transient_map, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return not_found
  }else {
    return v
  }
};
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__37103 = this;
  return cljs.core.count.call(null, this__37103.transient_map)
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = function(tcoll, v) {
  var this__37104 = this;
  this__37104.transient_map = cljs.core.dissoc_BANG_.call(null, this__37104.transient_map, v);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__37105 = this;
  this__37105.transient_map = cljs.core.assoc_BANG_.call(null, this__37105.transient_map, o, null);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__37106 = this;
  return new cljs.core.PersistentHashSet(null, cljs.core.persistent_BANG_.call(null, this__37106.transient_map), null)
};
cljs.core.TransientHashSet;
cljs.core.PersistentTreeSet = function(meta, tree_map, __hash) {
  this.meta = meta;
  this.tree_map = tree_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 417730831
};
cljs.core.PersistentTreeSet.cljs$lang$type = true;
cljs.core.PersistentTreeSet.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentTreeSet")
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__37110 = this;
  var h__2192__auto____37111 = this__37110.__hash;
  if(!(h__2192__auto____37111 == null)) {
    return h__2192__auto____37111
  }else {
    var h__2192__auto____37112 = cljs.core.hash_iset.call(null, coll);
    this__37110.__hash = h__2192__auto____37112;
    return h__2192__auto____37112
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__37113 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, v, null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__37114 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__37114.tree_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeSet.prototype.call = function() {
  var G__37140 = null;
  var G__37140__2 = function(this_sym37115, k) {
    var this__37117 = this;
    var this_sym37115__37118 = this;
    var coll__37119 = this_sym37115__37118;
    return coll__37119.cljs$core$ILookup$_lookup$arity$2(coll__37119, k)
  };
  var G__37140__3 = function(this_sym37116, k, not_found) {
    var this__37117 = this;
    var this_sym37116__37120 = this;
    var coll__37121 = this_sym37116__37120;
    return coll__37121.cljs$core$ILookup$_lookup$arity$3(coll__37121, k, not_found)
  };
  G__37140 = function(this_sym37116, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__37140__2.call(this, this_sym37116, k);
      case 3:
        return G__37140__3.call(this, this_sym37116, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__37140
}();
cljs.core.PersistentTreeSet.prototype.apply = function(this_sym37108, args37109) {
  var this__37122 = this;
  return this_sym37108.call.apply(this_sym37108, [this_sym37108].concat(args37109.slice()))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__37123 = this;
  return new cljs.core.PersistentTreeSet(this__37123.meta, cljs.core.assoc.call(null, this__37123.tree_map, o, null), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__37124 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core.rseq.call(null, this__37124.tree_map))
};
cljs.core.PersistentTreeSet.prototype.toString = function() {
  var this__37125 = this;
  var this__37126 = this;
  return cljs.core.pr_str.call(null, this__37126)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__37127 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq.call(null, this__37127.tree_map, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__37128 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq_from.call(null, this__37128.tree_map, k, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__37129 = this;
  return entry
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__37130 = this;
  return cljs.core._comparator.call(null, this__37130.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__37131 = this;
  return cljs.core.keys.call(null, this__37131.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__37132 = this;
  return new cljs.core.PersistentTreeSet(this__37132.meta, cljs.core.dissoc.call(null, this__37132.tree_map, v), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__37133 = this;
  return cljs.core.count.call(null, this__37133.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__37134 = this;
  var and__3822__auto____37135 = cljs.core.set_QMARK_.call(null, other);
  if(and__3822__auto____37135) {
    var and__3822__auto____37136 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3822__auto____37136) {
      return cljs.core.every_QMARK_.call(null, function(p1__37090_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__37090_SHARP_)
      }, other)
    }else {
      return and__3822__auto____37136
    }
  }else {
    return and__3822__auto____37135
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__37137 = this;
  return new cljs.core.PersistentTreeSet(meta, this__37137.tree_map, this__37137.__hash)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__37138 = this;
  return this__37138.meta
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__37139 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeSet.EMPTY, this__37139.meta)
};
cljs.core.PersistentTreeSet;
cljs.core.PersistentTreeSet.EMPTY = new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map.call(null), 0);
cljs.core.hash_set = function() {
  var hash_set = null;
  var hash_set__0 = function() {
    return cljs.core.PersistentHashSet.EMPTY
  };
  var hash_set__1 = function() {
    var G__37145__delegate = function(keys) {
      var in__37143 = cljs.core.seq.call(null, keys);
      var out__37144 = cljs.core.transient$.call(null, cljs.core.PersistentHashSet.EMPTY);
      while(true) {
        if(cljs.core.seq.call(null, in__37143)) {
          var G__37146 = cljs.core.next.call(null, in__37143);
          var G__37147 = cljs.core.conj_BANG_.call(null, out__37144, cljs.core.first.call(null, in__37143));
          in__37143 = G__37146;
          out__37144 = G__37147;
          continue
        }else {
          return cljs.core.persistent_BANG_.call(null, out__37144)
        }
        break
      }
    };
    var G__37145 = function(var_args) {
      var keys = null;
      if(goog.isDef(var_args)) {
        keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__37145__delegate.call(this, keys)
    };
    G__37145.cljs$lang$maxFixedArity = 0;
    G__37145.cljs$lang$applyTo = function(arglist__37148) {
      var keys = cljs.core.seq(arglist__37148);
      return G__37145__delegate(keys)
    };
    G__37145.cljs$lang$arity$variadic = G__37145__delegate;
    return G__37145
  }();
  hash_set = function(var_args) {
    var keys = var_args;
    switch(arguments.length) {
      case 0:
        return hash_set__0.call(this);
      default:
        return hash_set__1.cljs$lang$arity$variadic(cljs.core.array_seq(arguments, 0))
    }
    throw"Invalid arity: " + arguments.length;
  };
  hash_set.cljs$lang$maxFixedArity = 0;
  hash_set.cljs$lang$applyTo = hash_set__1.cljs$lang$applyTo;
  hash_set.cljs$lang$arity$0 = hash_set__0;
  hash_set.cljs$lang$arity$variadic = hash_set__1.cljs$lang$arity$variadic;
  return hash_set
}();
cljs.core.set = function set(coll) {
  return cljs.core.apply.call(null, cljs.core.hash_set, coll)
};
cljs.core.sorted_set = function() {
  var sorted_set__delegate = function(keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, cljs.core.PersistentTreeSet.EMPTY, keys)
  };
  var sorted_set = function(var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_set__delegate.call(this, keys)
  };
  sorted_set.cljs$lang$maxFixedArity = 0;
  sorted_set.cljs$lang$applyTo = function(arglist__37149) {
    var keys = cljs.core.seq(arglist__37149);
    return sorted_set__delegate(keys)
  };
  sorted_set.cljs$lang$arity$variadic = sorted_set__delegate;
  return sorted_set
}();
cljs.core.sorted_set_by = function() {
  var sorted_set_by__delegate = function(comparator, keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map_by.call(null, comparator), 0), keys)
  };
  var sorted_set_by = function(comparator, var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_set_by__delegate.call(this, comparator, keys)
  };
  sorted_set_by.cljs$lang$maxFixedArity = 1;
  sorted_set_by.cljs$lang$applyTo = function(arglist__37151) {
    var comparator = cljs.core.first(arglist__37151);
    var keys = cljs.core.rest(arglist__37151);
    return sorted_set_by__delegate(comparator, keys)
  };
  sorted_set_by.cljs$lang$arity$variadic = sorted_set_by__delegate;
  return sorted_set_by
}();
cljs.core.replace = function replace(smap, coll) {
  if(cljs.core.vector_QMARK_.call(null, coll)) {
    var n__37157 = cljs.core.count.call(null, coll);
    return cljs.core.reduce.call(null, function(v, i) {
      var temp__3971__auto____37158 = cljs.core.find.call(null, smap, cljs.core.nth.call(null, v, i));
      if(cljs.core.truth_(temp__3971__auto____37158)) {
        var e__37159 = temp__3971__auto____37158;
        return cljs.core.assoc.call(null, v, i, cljs.core.second.call(null, e__37159))
      }else {
        return v
      }
    }, coll, cljs.core.take.call(null, n__37157, cljs.core.iterate.call(null, cljs.core.inc, 0)))
  }else {
    return cljs.core.map.call(null, function(p1__37150_SHARP_) {
      var temp__3971__auto____37160 = cljs.core.find.call(null, smap, p1__37150_SHARP_);
      if(cljs.core.truth_(temp__3971__auto____37160)) {
        var e__37161 = temp__3971__auto____37160;
        return cljs.core.second.call(null, e__37161)
      }else {
        return p1__37150_SHARP_
      }
    }, coll)
  }
};
cljs.core.distinct = function distinct(coll) {
  var step__37191 = function step(xs, seen) {
    return new cljs.core.LazySeq(null, false, function() {
      return function(p__37184, seen) {
        while(true) {
          var vec__37185__37186 = p__37184;
          var f__37187 = cljs.core.nth.call(null, vec__37185__37186, 0, null);
          var xs__37188 = vec__37185__37186;
          var temp__3974__auto____37189 = cljs.core.seq.call(null, xs__37188);
          if(temp__3974__auto____37189) {
            var s__37190 = temp__3974__auto____37189;
            if(cljs.core.contains_QMARK_.call(null, seen, f__37187)) {
              var G__37192 = cljs.core.rest.call(null, s__37190);
              var G__37193 = seen;
              p__37184 = G__37192;
              seen = G__37193;
              continue
            }else {
              return cljs.core.cons.call(null, f__37187, step.call(null, cljs.core.rest.call(null, s__37190), cljs.core.conj.call(null, seen, f__37187)))
            }
          }else {
            return null
          }
          break
        }
      }.call(null, xs, seen)
    }, null)
  };
  return step__37191.call(null, coll, cljs.core.PersistentHashSet.EMPTY)
};
cljs.core.butlast = function butlast(s) {
  var ret__37196 = cljs.core.PersistentVector.EMPTY;
  var s__37197 = s;
  while(true) {
    if(cljs.core.next.call(null, s__37197)) {
      var G__37198 = cljs.core.conj.call(null, ret__37196, cljs.core.first.call(null, s__37197));
      var G__37199 = cljs.core.next.call(null, s__37197);
      ret__37196 = G__37198;
      s__37197 = G__37199;
      continue
    }else {
      return cljs.core.seq.call(null, ret__37196)
    }
    break
  }
};
cljs.core.name = function name(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(function() {
      var or__3824__auto____37202 = cljs.core.keyword_QMARK_.call(null, x);
      if(or__3824__auto____37202) {
        return or__3824__auto____37202
      }else {
        return cljs.core.symbol_QMARK_.call(null, x)
      }
    }()) {
      var i__37203 = x.lastIndexOf("/");
      if(i__37203 < 0) {
        return cljs.core.subs.call(null, x, 2)
      }else {
        return cljs.core.subs.call(null, x, i__37203 + 1)
      }
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Doesn't support name: "), cljs.core.str(x)].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.namespace = function namespace(x) {
  if(function() {
    var or__3824__auto____37206 = cljs.core.keyword_QMARK_.call(null, x);
    if(or__3824__auto____37206) {
      return or__3824__auto____37206
    }else {
      return cljs.core.symbol_QMARK_.call(null, x)
    }
  }()) {
    var i__37207 = x.lastIndexOf("/");
    if(i__37207 > -1) {
      return cljs.core.subs.call(null, x, 2, i__37207)
    }else {
      return null
    }
  }else {
    throw new Error([cljs.core.str("Doesn't support namespace: "), cljs.core.str(x)].join(""));
  }
};
cljs.core.zipmap = function zipmap(keys, vals) {
  var map__37214 = cljs.core.ObjMap.EMPTY;
  var ks__37215 = cljs.core.seq.call(null, keys);
  var vs__37216 = cljs.core.seq.call(null, vals);
  while(true) {
    if(function() {
      var and__3822__auto____37217 = ks__37215;
      if(and__3822__auto____37217) {
        return vs__37216
      }else {
        return and__3822__auto____37217
      }
    }()) {
      var G__37218 = cljs.core.assoc.call(null, map__37214, cljs.core.first.call(null, ks__37215), cljs.core.first.call(null, vs__37216));
      var G__37219 = cljs.core.next.call(null, ks__37215);
      var G__37220 = cljs.core.next.call(null, vs__37216);
      map__37214 = G__37218;
      ks__37215 = G__37219;
      vs__37216 = G__37220;
      continue
    }else {
      return map__37214
    }
    break
  }
};
cljs.core.max_key = function() {
  var max_key = null;
  var max_key__2 = function(k, x) {
    return x
  };
  var max_key__3 = function(k, x, y) {
    if(k.call(null, x) > k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var max_key__4 = function() {
    var G__37223__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__37208_SHARP_, p2__37209_SHARP_) {
        return max_key.call(null, k, p1__37208_SHARP_, p2__37209_SHARP_)
      }, max_key.call(null, k, x, y), more)
    };
    var G__37223 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__37223__delegate.call(this, k, x, y, more)
    };
    G__37223.cljs$lang$maxFixedArity = 3;
    G__37223.cljs$lang$applyTo = function(arglist__37224) {
      var k = cljs.core.first(arglist__37224);
      var x = cljs.core.first(cljs.core.next(arglist__37224));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__37224)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__37224)));
      return G__37223__delegate(k, x, y, more)
    };
    G__37223.cljs$lang$arity$variadic = G__37223__delegate;
    return G__37223
  }();
  max_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return max_key__2.call(this, k, x);
      case 3:
        return max_key__3.call(this, k, x, y);
      default:
        return max_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max_key.cljs$lang$maxFixedArity = 3;
  max_key.cljs$lang$applyTo = max_key__4.cljs$lang$applyTo;
  max_key.cljs$lang$arity$2 = max_key__2;
  max_key.cljs$lang$arity$3 = max_key__3;
  max_key.cljs$lang$arity$variadic = max_key__4.cljs$lang$arity$variadic;
  return max_key
}();
cljs.core.min_key = function() {
  var min_key = null;
  var min_key__2 = function(k, x) {
    return x
  };
  var min_key__3 = function(k, x, y) {
    if(k.call(null, x) < k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var min_key__4 = function() {
    var G__37225__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__37221_SHARP_, p2__37222_SHARP_) {
        return min_key.call(null, k, p1__37221_SHARP_, p2__37222_SHARP_)
      }, min_key.call(null, k, x, y), more)
    };
    var G__37225 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__37225__delegate.call(this, k, x, y, more)
    };
    G__37225.cljs$lang$maxFixedArity = 3;
    G__37225.cljs$lang$applyTo = function(arglist__37226) {
      var k = cljs.core.first(arglist__37226);
      var x = cljs.core.first(cljs.core.next(arglist__37226));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__37226)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__37226)));
      return G__37225__delegate(k, x, y, more)
    };
    G__37225.cljs$lang$arity$variadic = G__37225__delegate;
    return G__37225
  }();
  min_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return min_key__2.call(this, k, x);
      case 3:
        return min_key__3.call(this, k, x, y);
      default:
        return min_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min_key.cljs$lang$maxFixedArity = 3;
  min_key.cljs$lang$applyTo = min_key__4.cljs$lang$applyTo;
  min_key.cljs$lang$arity$2 = min_key__2;
  min_key.cljs$lang$arity$3 = min_key__3;
  min_key.cljs$lang$arity$variadic = min_key__4.cljs$lang$arity$variadic;
  return min_key
}();
cljs.core.partition_all = function() {
  var partition_all = null;
  var partition_all__2 = function(n, coll) {
    return partition_all.call(null, n, n, coll)
  };
  var partition_all__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____37229 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____37229) {
        var s__37230 = temp__3974__auto____37229;
        return cljs.core.cons.call(null, cljs.core.take.call(null, n, s__37230), partition_all.call(null, n, step, cljs.core.drop.call(null, step, s__37230)))
      }else {
        return null
      }
    }, null)
  };
  partition_all = function(n, step, coll) {
    switch(arguments.length) {
      case 2:
        return partition_all__2.call(this, n, step);
      case 3:
        return partition_all__3.call(this, n, step, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition_all.cljs$lang$arity$2 = partition_all__2;
  partition_all.cljs$lang$arity$3 = partition_all__3;
  return partition_all
}();
cljs.core.take_while = function take_while(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3974__auto____37233 = cljs.core.seq.call(null, coll);
    if(temp__3974__auto____37233) {
      var s__37234 = temp__3974__auto____37233;
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, s__37234)))) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__37234), take_while.call(null, pred, cljs.core.rest.call(null, s__37234)))
      }else {
        return null
      }
    }else {
      return null
    }
  }, null)
};
cljs.core.mk_bound_fn = function mk_bound_fn(sc, test, key) {
  return function(e) {
    var comp__37236 = cljs.core._comparator.call(null, sc);
    return test.call(null, comp__37236.call(null, cljs.core._entry_key.call(null, sc, e), key), 0)
  }
};
cljs.core.subseq = function() {
  var subseq = null;
  var subseq__3 = function(sc, test, key) {
    var include__37248 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_, cljs.core._GT__EQ_]).call(null, test))) {
      var temp__3974__auto____37249 = cljs.core._sorted_seq_from.call(null, sc, key, true);
      if(cljs.core.truth_(temp__3974__auto____37249)) {
        var vec__37250__37251 = temp__3974__auto____37249;
        var e__37252 = cljs.core.nth.call(null, vec__37250__37251, 0, null);
        var s__37253 = vec__37250__37251;
        if(cljs.core.truth_(include__37248.call(null, e__37252))) {
          return s__37253
        }else {
          return cljs.core.next.call(null, s__37253)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__37248, cljs.core._sorted_seq.call(null, sc, true))
    }
  };
  var subseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3974__auto____37254 = cljs.core._sorted_seq_from.call(null, sc, start_key, true);
    if(cljs.core.truth_(temp__3974__auto____37254)) {
      var vec__37255__37256 = temp__3974__auto____37254;
      var e__37257 = cljs.core.nth.call(null, vec__37255__37256, 0, null);
      var s__37258 = vec__37255__37256;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, end_test, end_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, start_test, start_key).call(null, e__37257)) ? s__37258 : cljs.core.next.call(null, s__37258))
    }else {
      return null
    }
  };
  subseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return subseq__3.call(this, sc, start_test, start_key);
      case 5:
        return subseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subseq.cljs$lang$arity$3 = subseq__3;
  subseq.cljs$lang$arity$5 = subseq__5;
  return subseq
}();
cljs.core.rsubseq = function() {
  var rsubseq = null;
  var rsubseq__3 = function(sc, test, key) {
    var include__37270 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_, cljs.core._LT__EQ_]).call(null, test))) {
      var temp__3974__auto____37271 = cljs.core._sorted_seq_from.call(null, sc, key, false);
      if(cljs.core.truth_(temp__3974__auto____37271)) {
        var vec__37272__37273 = temp__3974__auto____37271;
        var e__37274 = cljs.core.nth.call(null, vec__37272__37273, 0, null);
        var s__37275 = vec__37272__37273;
        if(cljs.core.truth_(include__37270.call(null, e__37274))) {
          return s__37275
        }else {
          return cljs.core.next.call(null, s__37275)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__37270, cljs.core._sorted_seq.call(null, sc, false))
    }
  };
  var rsubseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3974__auto____37276 = cljs.core._sorted_seq_from.call(null, sc, end_key, false);
    if(cljs.core.truth_(temp__3974__auto____37276)) {
      var vec__37277__37278 = temp__3974__auto____37276;
      var e__37279 = cljs.core.nth.call(null, vec__37277__37278, 0, null);
      var s__37280 = vec__37277__37278;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, start_test, start_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, end_test, end_key).call(null, e__37279)) ? s__37280 : cljs.core.next.call(null, s__37280))
    }else {
      return null
    }
  };
  rsubseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return rsubseq__3.call(this, sc, start_test, start_key);
      case 5:
        return rsubseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rsubseq.cljs$lang$arity$3 = rsubseq__3;
  rsubseq.cljs$lang$arity$5 = rsubseq__5;
  return rsubseq
}();
cljs.core.Range = function(meta, start, end, step, __hash) {
  this.meta = meta;
  this.start = start;
  this.end = end;
  this.step = step;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32375006
};
cljs.core.Range.cljs$lang$type = true;
cljs.core.Range.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/Range")
};
cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = function(rng) {
  var this__37281 = this;
  var h__2192__auto____37282 = this__37281.__hash;
  if(!(h__2192__auto____37282 == null)) {
    return h__2192__auto____37282
  }else {
    var h__2192__auto____37283 = cljs.core.hash_coll.call(null, rng);
    this__37281.__hash = h__2192__auto____37283;
    return h__2192__auto____37283
  }
};
cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = function(rng) {
  var this__37284 = this;
  if(this__37284.step > 0) {
    if(this__37284.start + this__37284.step < this__37284.end) {
      return new cljs.core.Range(this__37284.meta, this__37284.start + this__37284.step, this__37284.end, this__37284.step, null)
    }else {
      return null
    }
  }else {
    if(this__37284.start + this__37284.step > this__37284.end) {
      return new cljs.core.Range(this__37284.meta, this__37284.start + this__37284.step, this__37284.end, this__37284.step, null)
    }else {
      return null
    }
  }
};
cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = function(rng, o) {
  var this__37285 = this;
  return cljs.core.cons.call(null, o, rng)
};
cljs.core.Range.prototype.toString = function() {
  var this__37286 = this;
  var this__37287 = this;
  return cljs.core.pr_str.call(null, this__37287)
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = function(rng, f) {
  var this__37288 = this;
  return cljs.core.ci_reduce.call(null, rng, f)
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = function(rng, f, s) {
  var this__37289 = this;
  return cljs.core.ci_reduce.call(null, rng, f, s)
};
cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = function(rng) {
  var this__37290 = this;
  if(this__37290.step > 0) {
    if(this__37290.start < this__37290.end) {
      return rng
    }else {
      return null
    }
  }else {
    if(this__37290.start > this__37290.end) {
      return rng
    }else {
      return null
    }
  }
};
cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = function(rng) {
  var this__37291 = this;
  if(cljs.core.not.call(null, rng.cljs$core$ISeqable$_seq$arity$1(rng))) {
    return 0
  }else {
    return Math.ceil((this__37291.end - this__37291.start) / this__37291.step)
  }
};
cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = function(rng) {
  var this__37292 = this;
  return this__37292.start
};
cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = function(rng) {
  var this__37293 = this;
  if(!(rng.cljs$core$ISeqable$_seq$arity$1(rng) == null)) {
    return new cljs.core.Range(this__37293.meta, this__37293.start + this__37293.step, this__37293.end, this__37293.step, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(rng, other) {
  var this__37294 = this;
  return cljs.core.equiv_sequential.call(null, rng, other)
};
cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(rng, meta) {
  var this__37295 = this;
  return new cljs.core.Range(meta, this__37295.start, this__37295.end, this__37295.step, this__37295.__hash)
};
cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = function(rng) {
  var this__37296 = this;
  return this__37296.meta
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = function(rng, n) {
  var this__37297 = this;
  if(n < rng.cljs$core$ICounted$_count$arity$1(rng)) {
    return this__37297.start + n * this__37297.step
  }else {
    if(function() {
      var and__3822__auto____37298 = this__37297.start > this__37297.end;
      if(and__3822__auto____37298) {
        return this__37297.step === 0
      }else {
        return and__3822__auto____37298
      }
    }()) {
      return this__37297.start
    }else {
      throw new Error("Index out of bounds");
    }
  }
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = function(rng, n, not_found) {
  var this__37299 = this;
  if(n < rng.cljs$core$ICounted$_count$arity$1(rng)) {
    return this__37299.start + n * this__37299.step
  }else {
    if(function() {
      var and__3822__auto____37300 = this__37299.start > this__37299.end;
      if(and__3822__auto____37300) {
        return this__37299.step === 0
      }else {
        return and__3822__auto____37300
      }
    }()) {
      return this__37299.start
    }else {
      return not_found
    }
  }
};
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(rng) {
  var this__37301 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__37301.meta)
};
cljs.core.Range;
cljs.core.range = function() {
  var range = null;
  var range__0 = function() {
    return range.call(null, 0, Number.MAX_VALUE, 1)
  };
  var range__1 = function(end) {
    return range.call(null, 0, end, 1)
  };
  var range__2 = function(start, end) {
    return range.call(null, start, end, 1)
  };
  var range__3 = function(start, end, step) {
    return new cljs.core.Range(null, start, end, step, null)
  };
  range = function(start, end, step) {
    switch(arguments.length) {
      case 0:
        return range__0.call(this);
      case 1:
        return range__1.call(this, start);
      case 2:
        return range__2.call(this, start, end);
      case 3:
        return range__3.call(this, start, end, step)
    }
    throw"Invalid arity: " + arguments.length;
  };
  range.cljs$lang$arity$0 = range__0;
  range.cljs$lang$arity$1 = range__1;
  range.cljs$lang$arity$2 = range__2;
  range.cljs$lang$arity$3 = range__3;
  return range
}();
cljs.core.take_nth = function take_nth(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3974__auto____37304 = cljs.core.seq.call(null, coll);
    if(temp__3974__auto____37304) {
      var s__37305 = temp__3974__auto____37304;
      return cljs.core.cons.call(null, cljs.core.first.call(null, s__37305), take_nth.call(null, n, cljs.core.drop.call(null, n, s__37305)))
    }else {
      return null
    }
  }, null)
};
cljs.core.split_with = function split_with(pred, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take_while.call(null, pred, coll), cljs.core.drop_while.call(null, pred, coll)], true)
};
cljs.core.partition_by = function partition_by(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3974__auto____37312 = cljs.core.seq.call(null, coll);
    if(temp__3974__auto____37312) {
      var s__37313 = temp__3974__auto____37312;
      var fst__37314 = cljs.core.first.call(null, s__37313);
      var fv__37315 = f.call(null, fst__37314);
      var run__37316 = cljs.core.cons.call(null, fst__37314, cljs.core.take_while.call(null, function(p1__37306_SHARP_) {
        return cljs.core._EQ_.call(null, fv__37315, f.call(null, p1__37306_SHARP_))
      }, cljs.core.next.call(null, s__37313)));
      return cljs.core.cons.call(null, run__37316, partition_by.call(null, f, cljs.core.seq.call(null, cljs.core.drop.call(null, cljs.core.count.call(null, run__37316), s__37313))))
    }else {
      return null
    }
  }, null)
};
cljs.core.frequencies = function frequencies(coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(counts, x) {
    return cljs.core.assoc_BANG_.call(null, counts, x, cljs.core._lookup.call(null, counts, x, 0) + 1)
  }, cljs.core.transient$.call(null, cljs.core.ObjMap.EMPTY), coll))
};
cljs.core.reductions = function() {
  var reductions = null;
  var reductions__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3971__auto____37331 = cljs.core.seq.call(null, coll);
      if(temp__3971__auto____37331) {
        var s__37332 = temp__3971__auto____37331;
        return reductions.call(null, f, cljs.core.first.call(null, s__37332), cljs.core.rest.call(null, s__37332))
      }else {
        return cljs.core.list.call(null, f.call(null))
      }
    }, null)
  };
  var reductions__3 = function(f, init, coll) {
    return cljs.core.cons.call(null, init, new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____37333 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____37333) {
        var s__37334 = temp__3974__auto____37333;
        return reductions.call(null, f, f.call(null, init, cljs.core.first.call(null, s__37334)), cljs.core.rest.call(null, s__37334))
      }else {
        return null
      }
    }, null))
  };
  reductions = function(f, init, coll) {
    switch(arguments.length) {
      case 2:
        return reductions__2.call(this, f, init);
      case 3:
        return reductions__3.call(this, f, init, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reductions.cljs$lang$arity$2 = reductions__2;
  reductions.cljs$lang$arity$3 = reductions__3;
  return reductions
}();
cljs.core.juxt = function() {
  var juxt = null;
  var juxt__1 = function(f) {
    return function() {
      var G__37337 = null;
      var G__37337__0 = function() {
        return cljs.core.vector.call(null, f.call(null))
      };
      var G__37337__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x))
      };
      var G__37337__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y))
      };
      var G__37337__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z))
      };
      var G__37337__4 = function() {
        var G__37338__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args))
        };
        var G__37338 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__37338__delegate.call(this, x, y, z, args)
        };
        G__37338.cljs$lang$maxFixedArity = 3;
        G__37338.cljs$lang$applyTo = function(arglist__37339) {
          var x = cljs.core.first(arglist__37339);
          var y = cljs.core.first(cljs.core.next(arglist__37339));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__37339)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__37339)));
          return G__37338__delegate(x, y, z, args)
        };
        G__37338.cljs$lang$arity$variadic = G__37338__delegate;
        return G__37338
      }();
      G__37337 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__37337__0.call(this);
          case 1:
            return G__37337__1.call(this, x);
          case 2:
            return G__37337__2.call(this, x, y);
          case 3:
            return G__37337__3.call(this, x, y, z);
          default:
            return G__37337__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__37337.cljs$lang$maxFixedArity = 3;
      G__37337.cljs$lang$applyTo = G__37337__4.cljs$lang$applyTo;
      return G__37337
    }()
  };
  var juxt__2 = function(f, g) {
    return function() {
      var G__37340 = null;
      var G__37340__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null))
      };
      var G__37340__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x))
      };
      var G__37340__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y))
      };
      var G__37340__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z))
      };
      var G__37340__4 = function() {
        var G__37341__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__37341 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__37341__delegate.call(this, x, y, z, args)
        };
        G__37341.cljs$lang$maxFixedArity = 3;
        G__37341.cljs$lang$applyTo = function(arglist__37342) {
          var x = cljs.core.first(arglist__37342);
          var y = cljs.core.first(cljs.core.next(arglist__37342));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__37342)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__37342)));
          return G__37341__delegate(x, y, z, args)
        };
        G__37341.cljs$lang$arity$variadic = G__37341__delegate;
        return G__37341
      }();
      G__37340 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__37340__0.call(this);
          case 1:
            return G__37340__1.call(this, x);
          case 2:
            return G__37340__2.call(this, x, y);
          case 3:
            return G__37340__3.call(this, x, y, z);
          default:
            return G__37340__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__37340.cljs$lang$maxFixedArity = 3;
      G__37340.cljs$lang$applyTo = G__37340__4.cljs$lang$applyTo;
      return G__37340
    }()
  };
  var juxt__3 = function(f, g, h) {
    return function() {
      var G__37343 = null;
      var G__37343__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null), h.call(null))
      };
      var G__37343__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x), h.call(null, x))
      };
      var G__37343__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y), h.call(null, x, y))
      };
      var G__37343__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z), h.call(null, x, y, z))
      };
      var G__37343__4 = function() {
        var G__37344__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args), cljs.core.apply.call(null, h, x, y, z, args))
        };
        var G__37344 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__37344__delegate.call(this, x, y, z, args)
        };
        G__37344.cljs$lang$maxFixedArity = 3;
        G__37344.cljs$lang$applyTo = function(arglist__37345) {
          var x = cljs.core.first(arglist__37345);
          var y = cljs.core.first(cljs.core.next(arglist__37345));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__37345)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__37345)));
          return G__37344__delegate(x, y, z, args)
        };
        G__37344.cljs$lang$arity$variadic = G__37344__delegate;
        return G__37344
      }();
      G__37343 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__37343__0.call(this);
          case 1:
            return G__37343__1.call(this, x);
          case 2:
            return G__37343__2.call(this, x, y);
          case 3:
            return G__37343__3.call(this, x, y, z);
          default:
            return G__37343__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__37343.cljs$lang$maxFixedArity = 3;
      G__37343.cljs$lang$applyTo = G__37343__4.cljs$lang$applyTo;
      return G__37343
    }()
  };
  var juxt__4 = function() {
    var G__37346__delegate = function(f, g, h, fs) {
      var fs__37336 = cljs.core.list_STAR_.call(null, f, g, h, fs);
      return function() {
        var G__37347 = null;
        var G__37347__0 = function() {
          return cljs.core.reduce.call(null, function(p1__37317_SHARP_, p2__37318_SHARP_) {
            return cljs.core.conj.call(null, p1__37317_SHARP_, p2__37318_SHARP_.call(null))
          }, cljs.core.PersistentVector.EMPTY, fs__37336)
        };
        var G__37347__1 = function(x) {
          return cljs.core.reduce.call(null, function(p1__37319_SHARP_, p2__37320_SHARP_) {
            return cljs.core.conj.call(null, p1__37319_SHARP_, p2__37320_SHARP_.call(null, x))
          }, cljs.core.PersistentVector.EMPTY, fs__37336)
        };
        var G__37347__2 = function(x, y) {
          return cljs.core.reduce.call(null, function(p1__37321_SHARP_, p2__37322_SHARP_) {
            return cljs.core.conj.call(null, p1__37321_SHARP_, p2__37322_SHARP_.call(null, x, y))
          }, cljs.core.PersistentVector.EMPTY, fs__37336)
        };
        var G__37347__3 = function(x, y, z) {
          return cljs.core.reduce.call(null, function(p1__37323_SHARP_, p2__37324_SHARP_) {
            return cljs.core.conj.call(null, p1__37323_SHARP_, p2__37324_SHARP_.call(null, x, y, z))
          }, cljs.core.PersistentVector.EMPTY, fs__37336)
        };
        var G__37347__4 = function() {
          var G__37348__delegate = function(x, y, z, args) {
            return cljs.core.reduce.call(null, function(p1__37325_SHARP_, p2__37326_SHARP_) {
              return cljs.core.conj.call(null, p1__37325_SHARP_, cljs.core.apply.call(null, p2__37326_SHARP_, x, y, z, args))
            }, cljs.core.PersistentVector.EMPTY, fs__37336)
          };
          var G__37348 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__37348__delegate.call(this, x, y, z, args)
          };
          G__37348.cljs$lang$maxFixedArity = 3;
          G__37348.cljs$lang$applyTo = function(arglist__37349) {
            var x = cljs.core.first(arglist__37349);
            var y = cljs.core.first(cljs.core.next(arglist__37349));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__37349)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__37349)));
            return G__37348__delegate(x, y, z, args)
          };
          G__37348.cljs$lang$arity$variadic = G__37348__delegate;
          return G__37348
        }();
        G__37347 = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return G__37347__0.call(this);
            case 1:
              return G__37347__1.call(this, x);
            case 2:
              return G__37347__2.call(this, x, y);
            case 3:
              return G__37347__3.call(this, x, y, z);
            default:
              return G__37347__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        G__37347.cljs$lang$maxFixedArity = 3;
        G__37347.cljs$lang$applyTo = G__37347__4.cljs$lang$applyTo;
        return G__37347
      }()
    };
    var G__37346 = function(f, g, h, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__37346__delegate.call(this, f, g, h, fs)
    };
    G__37346.cljs$lang$maxFixedArity = 3;
    G__37346.cljs$lang$applyTo = function(arglist__37350) {
      var f = cljs.core.first(arglist__37350);
      var g = cljs.core.first(cljs.core.next(arglist__37350));
      var h = cljs.core.first(cljs.core.next(cljs.core.next(arglist__37350)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__37350)));
      return G__37346__delegate(f, g, h, fs)
    };
    G__37346.cljs$lang$arity$variadic = G__37346__delegate;
    return G__37346
  }();
  juxt = function(f, g, h, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 1:
        return juxt__1.call(this, f);
      case 2:
        return juxt__2.call(this, f, g);
      case 3:
        return juxt__3.call(this, f, g, h);
      default:
        return juxt__4.cljs$lang$arity$variadic(f, g, h, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  juxt.cljs$lang$maxFixedArity = 3;
  juxt.cljs$lang$applyTo = juxt__4.cljs$lang$applyTo;
  juxt.cljs$lang$arity$1 = juxt__1;
  juxt.cljs$lang$arity$2 = juxt__2;
  juxt.cljs$lang$arity$3 = juxt__3;
  juxt.cljs$lang$arity$variadic = juxt__4.cljs$lang$arity$variadic;
  return juxt
}();
cljs.core.dorun = function() {
  var dorun = null;
  var dorun__1 = function(coll) {
    while(true) {
      if(cljs.core.seq.call(null, coll)) {
        var G__37353 = cljs.core.next.call(null, coll);
        coll = G__37353;
        continue
      }else {
        return null
      }
      break
    }
  };
  var dorun__2 = function(n, coll) {
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3822__auto____37352 = cljs.core.seq.call(null, coll);
        if(and__3822__auto____37352) {
          return n > 0
        }else {
          return and__3822__auto____37352
        }
      }())) {
        var G__37354 = n - 1;
        var G__37355 = cljs.core.next.call(null, coll);
        n = G__37354;
        coll = G__37355;
        continue
      }else {
        return null
      }
      break
    }
  };
  dorun = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return dorun__1.call(this, n);
      case 2:
        return dorun__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  dorun.cljs$lang$arity$1 = dorun__1;
  dorun.cljs$lang$arity$2 = dorun__2;
  return dorun
}();
cljs.core.doall = function() {
  var doall = null;
  var doall__1 = function(coll) {
    cljs.core.dorun.call(null, coll);
    return coll
  };
  var doall__2 = function(n, coll) {
    cljs.core.dorun.call(null, n, coll);
    return coll
  };
  doall = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return doall__1.call(this, n);
      case 2:
        return doall__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  doall.cljs$lang$arity$1 = doall__1;
  doall.cljs$lang$arity$2 = doall__2;
  return doall
}();
cljs.core.regexp_QMARK_ = function regexp_QMARK_(o) {
  return o instanceof RegExp
};
cljs.core.re_matches = function re_matches(re, s) {
  var matches__37357 = re.exec(s);
  if(cljs.core._EQ_.call(null, cljs.core.first.call(null, matches__37357), s)) {
    if(cljs.core.count.call(null, matches__37357) === 1) {
      return cljs.core.first.call(null, matches__37357)
    }else {
      return cljs.core.vec.call(null, matches__37357)
    }
  }else {
    return null
  }
};
cljs.core.re_find = function re_find(re, s) {
  var matches__37359 = re.exec(s);
  if(matches__37359 == null) {
    return null
  }else {
    if(cljs.core.count.call(null, matches__37359) === 1) {
      return cljs.core.first.call(null, matches__37359)
    }else {
      return cljs.core.vec.call(null, matches__37359)
    }
  }
};
cljs.core.re_seq = function re_seq(re, s) {
  var match_data__37364 = cljs.core.re_find.call(null, re, s);
  var match_idx__37365 = s.search(re);
  var match_str__37366 = cljs.core.coll_QMARK_.call(null, match_data__37364) ? cljs.core.first.call(null, match_data__37364) : match_data__37364;
  var post_match__37367 = cljs.core.subs.call(null, s, match_idx__37365 + cljs.core.count.call(null, match_str__37366));
  if(cljs.core.truth_(match_data__37364)) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, match_data__37364, re_seq.call(null, re, post_match__37367))
    }, null)
  }else {
    return null
  }
};
cljs.core.re_pattern = function re_pattern(s) {
  var vec__37374__37375 = cljs.core.re_find.call(null, /^(?:\(\?([idmsux]*)\))?(.*)/, s);
  var ___37376 = cljs.core.nth.call(null, vec__37374__37375, 0, null);
  var flags__37377 = cljs.core.nth.call(null, vec__37374__37375, 1, null);
  var pattern__37378 = cljs.core.nth.call(null, vec__37374__37375, 2, null);
  return new RegExp(pattern__37378, flags__37377)
};
cljs.core.pr_sequential = function pr_sequential(print_one, begin, sep, end, opts, coll) {
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray([begin], true), cljs.core.flatten1.call(null, cljs.core.interpose.call(null, cljs.core.PersistentVector.fromArray([sep], true), cljs.core.map.call(null, function(p1__37368_SHARP_) {
    return print_one.call(null, p1__37368_SHARP_, opts)
  }, coll))), cljs.core.PersistentVector.fromArray([end], true))
};
cljs.core.string_print = function string_print(x) {
  cljs.core._STAR_print_fn_STAR_.call(null, x);
  return null
};
cljs.core.flush = function flush() {
  return null
};
cljs.core.pr_seq = function pr_seq(obj, opts) {
  if(obj == null) {
    return cljs.core.list.call(null, "nil")
  }else {
    if(void 0 === obj) {
      return cljs.core.list.call(null, "#<undefined>")
    }else {
      if("\ufdd0'else") {
        return cljs.core.concat.call(null, cljs.core.truth_(function() {
          var and__3822__auto____37388 = cljs.core._lookup.call(null, opts, "\ufdd0'meta", null);
          if(cljs.core.truth_(and__3822__auto____37388)) {
            var and__3822__auto____37392 = function() {
              var G__37389__37390 = obj;
              if(G__37389__37390) {
                if(function() {
                  var or__3824__auto____37391 = G__37389__37390.cljs$lang$protocol_mask$partition0$ & 131072;
                  if(or__3824__auto____37391) {
                    return or__3824__auto____37391
                  }else {
                    return G__37389__37390.cljs$core$IMeta$
                  }
                }()) {
                  return true
                }else {
                  if(!G__37389__37390.cljs$lang$protocol_mask$partition0$) {
                    return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__37389__37390)
                  }else {
                    return false
                  }
                }
              }else {
                return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__37389__37390)
              }
            }();
            if(cljs.core.truth_(and__3822__auto____37392)) {
              return cljs.core.meta.call(null, obj)
            }else {
              return and__3822__auto____37392
            }
          }else {
            return and__3822__auto____37388
          }
        }()) ? cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["^"], true), pr_seq.call(null, cljs.core.meta.call(null, obj), opts), cljs.core.PersistentVector.fromArray([" "], true)) : null, function() {
          var and__3822__auto____37393 = !(obj == null);
          if(and__3822__auto____37393) {
            return obj.cljs$lang$type
          }else {
            return and__3822__auto____37393
          }
        }() ? obj.cljs$lang$ctorPrSeq(obj) : function() {
          var G__37394__37395 = obj;
          if(G__37394__37395) {
            if(function() {
              var or__3824__auto____37396 = G__37394__37395.cljs$lang$protocol_mask$partition0$ & 536870912;
              if(or__3824__auto____37396) {
                return or__3824__auto____37396
              }else {
                return G__37394__37395.cljs$core$IPrintable$
              }
            }()) {
              return true
            }else {
              if(!G__37394__37395.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__37394__37395)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__37394__37395)
          }
        }() ? cljs.core._pr_seq.call(null, obj, opts) : cljs.core.truth_(cljs.core.regexp_QMARK_.call(null, obj)) ? cljs.core.list.call(null, '#"', obj.source, '"') : "\ufdd0'else" ? cljs.core.list.call(null, "#<", [cljs.core.str(obj)].join(""), ">") : null)
      }else {
        return null
      }
    }
  }
};
cljs.core.pr_sb = function pr_sb(objs, opts) {
  var sb__37416 = new goog.string.StringBuffer;
  var G__37417__37418 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, cljs.core.first.call(null, objs), opts));
  if(G__37417__37418) {
    var string__37419 = cljs.core.first.call(null, G__37417__37418);
    var G__37417__37420 = G__37417__37418;
    while(true) {
      sb__37416.append(string__37419);
      var temp__3974__auto____37421 = cljs.core.next.call(null, G__37417__37420);
      if(temp__3974__auto____37421) {
        var G__37417__37422 = temp__3974__auto____37421;
        var G__37435 = cljs.core.first.call(null, G__37417__37422);
        var G__37436 = G__37417__37422;
        string__37419 = G__37435;
        G__37417__37420 = G__37436;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__37423__37424 = cljs.core.seq.call(null, cljs.core.next.call(null, objs));
  if(G__37423__37424) {
    var obj__37425 = cljs.core.first.call(null, G__37423__37424);
    var G__37423__37426 = G__37423__37424;
    while(true) {
      sb__37416.append(" ");
      var G__37427__37428 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__37425, opts));
      if(G__37427__37428) {
        var string__37429 = cljs.core.first.call(null, G__37427__37428);
        var G__37427__37430 = G__37427__37428;
        while(true) {
          sb__37416.append(string__37429);
          var temp__3974__auto____37431 = cljs.core.next.call(null, G__37427__37430);
          if(temp__3974__auto____37431) {
            var G__37427__37432 = temp__3974__auto____37431;
            var G__37437 = cljs.core.first.call(null, G__37427__37432);
            var G__37438 = G__37427__37432;
            string__37429 = G__37437;
            G__37427__37430 = G__37438;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3974__auto____37433 = cljs.core.next.call(null, G__37423__37426);
      if(temp__3974__auto____37433) {
        var G__37423__37434 = temp__3974__auto____37433;
        var G__37439 = cljs.core.first.call(null, G__37423__37434);
        var G__37440 = G__37423__37434;
        obj__37425 = G__37439;
        G__37423__37426 = G__37440;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return sb__37416
};
cljs.core.pr_str_with_opts = function pr_str_with_opts(objs, opts) {
  return[cljs.core.str(cljs.core.pr_sb.call(null, objs, opts))].join("")
};
cljs.core.prn_str_with_opts = function prn_str_with_opts(objs, opts) {
  var sb__37442 = cljs.core.pr_sb.call(null, objs, opts);
  sb__37442.append("\n");
  return[cljs.core.str(sb__37442)].join("")
};
cljs.core.pr_with_opts = function pr_with_opts(objs, opts) {
  var G__37461__37462 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, cljs.core.first.call(null, objs), opts));
  if(G__37461__37462) {
    var string__37463 = cljs.core.first.call(null, G__37461__37462);
    var G__37461__37464 = G__37461__37462;
    while(true) {
      cljs.core.string_print.call(null, string__37463);
      var temp__3974__auto____37465 = cljs.core.next.call(null, G__37461__37464);
      if(temp__3974__auto____37465) {
        var G__37461__37466 = temp__3974__auto____37465;
        var G__37479 = cljs.core.first.call(null, G__37461__37466);
        var G__37480 = G__37461__37466;
        string__37463 = G__37479;
        G__37461__37464 = G__37480;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__37467__37468 = cljs.core.seq.call(null, cljs.core.next.call(null, objs));
  if(G__37467__37468) {
    var obj__37469 = cljs.core.first.call(null, G__37467__37468);
    var G__37467__37470 = G__37467__37468;
    while(true) {
      cljs.core.string_print.call(null, " ");
      var G__37471__37472 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__37469, opts));
      if(G__37471__37472) {
        var string__37473 = cljs.core.first.call(null, G__37471__37472);
        var G__37471__37474 = G__37471__37472;
        while(true) {
          cljs.core.string_print.call(null, string__37473);
          var temp__3974__auto____37475 = cljs.core.next.call(null, G__37471__37474);
          if(temp__3974__auto____37475) {
            var G__37471__37476 = temp__3974__auto____37475;
            var G__37481 = cljs.core.first.call(null, G__37471__37476);
            var G__37482 = G__37471__37476;
            string__37473 = G__37481;
            G__37471__37474 = G__37482;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3974__auto____37477 = cljs.core.next.call(null, G__37467__37470);
      if(temp__3974__auto____37477) {
        var G__37467__37478 = temp__3974__auto____37477;
        var G__37483 = cljs.core.first.call(null, G__37467__37478);
        var G__37484 = G__37467__37478;
        obj__37469 = G__37483;
        G__37467__37470 = G__37484;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.newline = function newline(opts) {
  cljs.core.string_print.call(null, "\n");
  if(cljs.core.truth_(cljs.core._lookup.call(null, opts, "\ufdd0'flush-on-newline", null))) {
    return cljs.core.flush.call(null)
  }else {
    return null
  }
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core.pr_opts = function pr_opts() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'flush-on-newline", "\ufdd0'readably", "\ufdd0'meta", "\ufdd0'dup"], {"\ufdd0'flush-on-newline":cljs.core._STAR_flush_on_newline_STAR_, "\ufdd0'readably":cljs.core._STAR_print_readably_STAR_, "\ufdd0'meta":cljs.core._STAR_print_meta_STAR_, "\ufdd0'dup":cljs.core._STAR_print_dup_STAR_})
};
cljs.core.pr_str = function() {
  var pr_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr_str__delegate.call(this, objs)
  };
  pr_str.cljs$lang$maxFixedArity = 0;
  pr_str.cljs$lang$applyTo = function(arglist__37485) {
    var objs = cljs.core.seq(arglist__37485);
    return pr_str__delegate(objs)
  };
  pr_str.cljs$lang$arity$variadic = pr_str__delegate;
  return pr_str
}();
cljs.core.prn_str = function() {
  var prn_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var prn_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn_str__delegate.call(this, objs)
  };
  prn_str.cljs$lang$maxFixedArity = 0;
  prn_str.cljs$lang$applyTo = function(arglist__37486) {
    var objs = cljs.core.seq(arglist__37486);
    return prn_str__delegate(objs)
  };
  prn_str.cljs$lang$arity$variadic = prn_str__delegate;
  return prn_str
}();
cljs.core.pr = function() {
  var pr__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr__delegate.call(this, objs)
  };
  pr.cljs$lang$maxFixedArity = 0;
  pr.cljs$lang$applyTo = function(arglist__37487) {
    var objs = cljs.core.seq(arglist__37487);
    return pr__delegate(objs)
  };
  pr.cljs$lang$arity$variadic = pr__delegate;
  return pr
}();
cljs.core.print = function() {
  var cljs_core_print__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var cljs_core_print = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return cljs_core_print__delegate.call(this, objs)
  };
  cljs_core_print.cljs$lang$maxFixedArity = 0;
  cljs_core_print.cljs$lang$applyTo = function(arglist__37488) {
    var objs = cljs.core.seq(arglist__37488);
    return cljs_core_print__delegate(objs)
  };
  cljs_core_print.cljs$lang$arity$variadic = cljs_core_print__delegate;
  return cljs_core_print
}();
cljs.core.print_str = function() {
  var print_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var print_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return print_str__delegate.call(this, objs)
  };
  print_str.cljs$lang$maxFixedArity = 0;
  print_str.cljs$lang$applyTo = function(arglist__37489) {
    var objs = cljs.core.seq(arglist__37489);
    return print_str__delegate(objs)
  };
  print_str.cljs$lang$arity$variadic = print_str__delegate;
  return print_str
}();
cljs.core.println = function() {
  var println__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var println = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println__delegate.call(this, objs)
  };
  println.cljs$lang$maxFixedArity = 0;
  println.cljs$lang$applyTo = function(arglist__37490) {
    var objs = cljs.core.seq(arglist__37490);
    return println__delegate(objs)
  };
  println.cljs$lang$arity$variadic = println__delegate;
  return println
}();
cljs.core.println_str = function() {
  var println_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var println_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println_str__delegate.call(this, objs)
  };
  println_str.cljs$lang$maxFixedArity = 0;
  println_str.cljs$lang$applyTo = function(arglist__37491) {
    var objs = cljs.core.seq(arglist__37491);
    return println_str__delegate(objs)
  };
  println_str.cljs$lang$arity$variadic = println_str__delegate;
  return println_str
}();
cljs.core.prn = function() {
  var prn__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var prn = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn__delegate.call(this, objs)
  };
  prn.cljs$lang$maxFixedArity = 0;
  prn.cljs$lang$applyTo = function(arglist__37492) {
    var objs = cljs.core.seq(arglist__37492);
    return prn__delegate(objs)
  };
  prn.cljs$lang$arity$variadic = prn__delegate;
  return prn
}();
cljs.core.printf = function() {
  var printf__delegate = function(fmt, args) {
    return cljs.core.print.call(null, cljs.core.apply.call(null, cljs.core.format, fmt, args))
  };
  var printf = function(fmt, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return printf__delegate.call(this, fmt, args)
  };
  printf.cljs$lang$maxFixedArity = 1;
  printf.cljs$lang$applyTo = function(arglist__37493) {
    var fmt = cljs.core.first(arglist__37493);
    var args = cljs.core.rest(arglist__37493);
    return printf__delegate(fmt, args)
  };
  printf.cljs$lang$arity$variadic = printf__delegate;
  return printf
}();
cljs.core.HashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.HashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__37494 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__37494, "{", ", ", "}", opts, coll)
};
cljs.core.IPrintable["number"] = true;
cljs.core._pr_seq["number"] = function(n, opts) {
  return cljs.core.list.call(null, [cljs.core.str(n)].join(""))
};
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Subvec.prototype.cljs$core$IPrintable$ = true;
cljs.core.Subvec.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.ChunkedCons.prototype.cljs$core$IPrintable$ = true;
cljs.core.ChunkedCons.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__37495 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__37495, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__37496 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__37496, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#queue [", " ", "]", opts, cljs.core.seq.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.LazySeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.RSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.RSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.IPrintable["boolean"] = true;
cljs.core._pr_seq["boolean"] = function(bool, opts) {
  return cljs.core.list.call(null, [cljs.core.str(bool)].join(""))
};
cljs.core.IPrintable["string"] = true;
cljs.core._pr_seq["string"] = function(obj, opts) {
  if(cljs.core.keyword_QMARK_.call(null, obj)) {
    return cljs.core.list.call(null, [cljs.core.str(":"), cljs.core.str(function() {
      var temp__3974__auto____37497 = cljs.core.namespace.call(null, obj);
      if(cljs.core.truth_(temp__3974__auto____37497)) {
        var nspc__37498 = temp__3974__auto____37497;
        return[cljs.core.str(nspc__37498), cljs.core.str("/")].join("")
      }else {
        return null
      }
    }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
  }else {
    if(cljs.core.symbol_QMARK_.call(null, obj)) {
      return cljs.core.list.call(null, [cljs.core.str(function() {
        var temp__3974__auto____37499 = cljs.core.namespace.call(null, obj);
        if(cljs.core.truth_(temp__3974__auto____37499)) {
          var nspc__37500 = temp__3974__auto____37499;
          return[cljs.core.str(nspc__37500), cljs.core.str("/")].join("")
        }else {
          return null
        }
      }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
    }else {
      if("\ufdd0'else") {
        return cljs.core.list.call(null, cljs.core.truth_((new cljs.core.Keyword("\ufdd0'readably")).call(null, opts)) ? goog.string.quote(obj) : obj)
      }else {
        return null
      }
    }
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.RedNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.RedNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.ChunkedSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.ChunkedSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__37501 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__37501, "{", ", ", "}", opts, coll)
};
cljs.core.Vector.prototype.cljs$core$IPrintable$ = true;
cljs.core.Vector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.List.prototype.cljs$core$IPrintable$ = true;
cljs.core.List.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.IPrintable["array"] = true;
cljs.core._pr_seq["array"] = function(a, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#<Array [", ", ", "]>", opts, a)
};
cljs.core.IPrintable["function"] = true;
cljs.core._pr_seq["function"] = function(this$) {
  return cljs.core.list.call(null, "#<", [cljs.core.str(this$)].join(""), ">")
};
cljs.core.EmptyList.prototype.cljs$core$IPrintable$ = true;
cljs.core.EmptyList.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.list.call(null, "()")
};
cljs.core.BlackNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.BlackNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
Date.prototype.cljs$core$IPrintable$ = true;
Date.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(d, _) {
  var normalize__37503 = function(n, len) {
    var ns__37502 = [cljs.core.str(n)].join("");
    while(true) {
      if(cljs.core.count.call(null, ns__37502) < len) {
        var G__37505 = [cljs.core.str("0"), cljs.core.str(ns__37502)].join("");
        ns__37502 = G__37505;
        continue
      }else {
        return ns__37502
      }
      break
    }
  };
  return cljs.core.list.call(null, [cljs.core.str('#inst "'), cljs.core.str(d.getUTCFullYear()), cljs.core.str("-"), cljs.core.str(normalize__37503.call(null, d.getUTCMonth() + 1, 2)), cljs.core.str("-"), cljs.core.str(normalize__37503.call(null, d.getUTCDate(), 2)), cljs.core.str("T"), cljs.core.str(normalize__37503.call(null, d.getUTCHours(), 2)), cljs.core.str(":"), cljs.core.str(normalize__37503.call(null, d.getUTCMinutes(), 2)), cljs.core.str(":"), cljs.core.str(normalize__37503.call(null, d.getUTCSeconds(), 
  2)), cljs.core.str("."), cljs.core.str(normalize__37503.call(null, d.getUTCMilliseconds(), 3)), cljs.core.str("-"), cljs.core.str('00:00"')].join(""))
};
cljs.core.Cons.prototype.cljs$core$IPrintable$ = true;
cljs.core.Cons.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Range.prototype.cljs$core$IPrintable$ = true;
cljs.core.Range.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ObjMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.ObjMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__37504 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__37504, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentVector.prototype.cljs$core$IComparable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IComparable$_compare$arity$2 = function(x, y) {
  return cljs.core.compare_indexed.call(null, x, y)
};
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2690809856
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/Atom")
};
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__37506 = this;
  return goog.getUid(this$)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var this__37507 = this;
  var G__37508__37509 = cljs.core.seq.call(null, this__37507.watches);
  if(G__37508__37509) {
    var G__37511__37513 = cljs.core.first.call(null, G__37508__37509);
    var vec__37512__37514 = G__37511__37513;
    var key__37515 = cljs.core.nth.call(null, vec__37512__37514, 0, null);
    var f__37516 = cljs.core.nth.call(null, vec__37512__37514, 1, null);
    var G__37508__37517 = G__37508__37509;
    var G__37511__37518 = G__37511__37513;
    var G__37508__37519 = G__37508__37517;
    while(true) {
      var vec__37520__37521 = G__37511__37518;
      var key__37522 = cljs.core.nth.call(null, vec__37520__37521, 0, null);
      var f__37523 = cljs.core.nth.call(null, vec__37520__37521, 1, null);
      var G__37508__37524 = G__37508__37519;
      f__37523.call(null, key__37522, this$, oldval, newval);
      var temp__3974__auto____37525 = cljs.core.next.call(null, G__37508__37524);
      if(temp__3974__auto____37525) {
        var G__37508__37526 = temp__3974__auto____37525;
        var G__37533 = cljs.core.first.call(null, G__37508__37526);
        var G__37534 = G__37508__37526;
        G__37511__37518 = G__37533;
        G__37508__37519 = G__37534;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var this__37527 = this;
  return this$.watches = cljs.core.assoc.call(null, this__37527.watches, key, f)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var this__37528 = this;
  return this$.watches = cljs.core.dissoc.call(null, this__37528.watches, key)
};
cljs.core.Atom.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(a, opts) {
  var this__37529 = this;
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["#<Atom: "], true), cljs.core._pr_seq.call(null, this__37529.state, opts), ">")
};
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var this__37530 = this;
  return this__37530.meta
};
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__37531 = this;
  return this__37531.state
};
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__37532 = this;
  return o === other
};
cljs.core.Atom;
cljs.core.atom = function() {
  var atom = null;
  var atom__1 = function(x) {
    return new cljs.core.Atom(x, null, null, null)
  };
  var atom__2 = function() {
    var G__37546__delegate = function(x, p__37535) {
      var map__37541__37542 = p__37535;
      var map__37541__37543 = cljs.core.seq_QMARK_.call(null, map__37541__37542) ? cljs.core.apply.call(null, cljs.core.hash_map, map__37541__37542) : map__37541__37542;
      var validator__37544 = cljs.core._lookup.call(null, map__37541__37543, "\ufdd0'validator", null);
      var meta__37545 = cljs.core._lookup.call(null, map__37541__37543, "\ufdd0'meta", null);
      return new cljs.core.Atom(x, meta__37545, validator__37544, null)
    };
    var G__37546 = function(x, var_args) {
      var p__37535 = null;
      if(goog.isDef(var_args)) {
        p__37535 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__37546__delegate.call(this, x, p__37535)
    };
    G__37546.cljs$lang$maxFixedArity = 1;
    G__37546.cljs$lang$applyTo = function(arglist__37547) {
      var x = cljs.core.first(arglist__37547);
      var p__37535 = cljs.core.rest(arglist__37547);
      return G__37546__delegate(x, p__37535)
    };
    G__37546.cljs$lang$arity$variadic = G__37546__delegate;
    return G__37546
  }();
  atom = function(x, var_args) {
    var p__37535 = var_args;
    switch(arguments.length) {
      case 1:
        return atom__1.call(this, x);
      default:
        return atom__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  atom.cljs$lang$maxFixedArity = 1;
  atom.cljs$lang$applyTo = atom__2.cljs$lang$applyTo;
  atom.cljs$lang$arity$1 = atom__1;
  atom.cljs$lang$arity$variadic = atom__2.cljs$lang$arity$variadic;
  return atom
}();
cljs.core.reset_BANG_ = function reset_BANG_(a, new_value) {
  var temp__3974__auto____37551 = a.validator;
  if(cljs.core.truth_(temp__3974__auto____37551)) {
    var validate__37552 = temp__3974__auto____37551;
    if(cljs.core.truth_(validate__37552.call(null, new_value))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str("Validator rejected reference state"), cljs.core.str("\n"), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'validate", "\ufdd1'new-value"), cljs.core.hash_map("\ufdd0'line", 6440))))].join(""));
    }
  }else {
  }
  var old_value__37553 = a.state;
  a.state = new_value;
  cljs.core._notify_watches.call(null, a, old_value__37553, new_value);
  return new_value
};
cljs.core.swap_BANG_ = function() {
  var swap_BANG_ = null;
  var swap_BANG___2 = function(a, f) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state))
  };
  var swap_BANG___3 = function(a, f, x) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x))
  };
  var swap_BANG___4 = function(a, f, x, y) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y))
  };
  var swap_BANG___5 = function(a, f, x, y, z) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y, z))
  };
  var swap_BANG___6 = function() {
    var G__37554__delegate = function(a, f, x, y, z, more) {
      return cljs.core.reset_BANG_.call(null, a, cljs.core.apply.call(null, f, a.state, x, y, z, more))
    };
    var G__37554 = function(a, f, x, y, z, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__37554__delegate.call(this, a, f, x, y, z, more)
    };
    G__37554.cljs$lang$maxFixedArity = 5;
    G__37554.cljs$lang$applyTo = function(arglist__37555) {
      var a = cljs.core.first(arglist__37555);
      var f = cljs.core.first(cljs.core.next(arglist__37555));
      var x = cljs.core.first(cljs.core.next(cljs.core.next(arglist__37555)));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__37555))));
      var z = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__37555)))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__37555)))));
      return G__37554__delegate(a, f, x, y, z, more)
    };
    G__37554.cljs$lang$arity$variadic = G__37554__delegate;
    return G__37554
  }();
  swap_BANG_ = function(a, f, x, y, z, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return swap_BANG___2.call(this, a, f);
      case 3:
        return swap_BANG___3.call(this, a, f, x);
      case 4:
        return swap_BANG___4.call(this, a, f, x, y);
      case 5:
        return swap_BANG___5.call(this, a, f, x, y, z);
      default:
        return swap_BANG___6.cljs$lang$arity$variadic(a, f, x, y, z, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  swap_BANG_.cljs$lang$maxFixedArity = 5;
  swap_BANG_.cljs$lang$applyTo = swap_BANG___6.cljs$lang$applyTo;
  swap_BANG_.cljs$lang$arity$2 = swap_BANG___2;
  swap_BANG_.cljs$lang$arity$3 = swap_BANG___3;
  swap_BANG_.cljs$lang$arity$4 = swap_BANG___4;
  swap_BANG_.cljs$lang$arity$5 = swap_BANG___5;
  swap_BANG_.cljs$lang$arity$variadic = swap_BANG___6.cljs$lang$arity$variadic;
  return swap_BANG_
}();
cljs.core.compare_and_set_BANG_ = function compare_and_set_BANG_(a, oldval, newval) {
  if(cljs.core._EQ_.call(null, a.state, oldval)) {
    cljs.core.reset_BANG_.call(null, a, newval);
    return true
  }else {
    return false
  }
};
cljs.core.deref = function deref(o) {
  return cljs.core._deref.call(null, o)
};
cljs.core.set_validator_BANG_ = function set_validator_BANG_(iref, val) {
  return iref.validator = val
};
cljs.core.get_validator = function get_validator(iref) {
  return iref.validator
};
cljs.core.alter_meta_BANG_ = function() {
  var alter_meta_BANG___delegate = function(iref, f, args) {
    return iref.meta = cljs.core.apply.call(null, f, iref.meta, args)
  };
  var alter_meta_BANG_ = function(iref, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return alter_meta_BANG___delegate.call(this, iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
  alter_meta_BANG_.cljs$lang$applyTo = function(arglist__37556) {
    var iref = cljs.core.first(arglist__37556);
    var f = cljs.core.first(cljs.core.next(arglist__37556));
    var args = cljs.core.rest(cljs.core.next(arglist__37556));
    return alter_meta_BANG___delegate(iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$arity$variadic = alter_meta_BANG___delegate;
  return alter_meta_BANG_
}();
cljs.core.reset_meta_BANG_ = function reset_meta_BANG_(iref, m) {
  return iref.meta = m
};
cljs.core.add_watch = function add_watch(iref, key, f) {
  return cljs.core._add_watch.call(null, iref, key, f)
};
cljs.core.remove_watch = function remove_watch(iref, key) {
  return cljs.core._remove_watch.call(null, iref, key)
};
cljs.core.gensym_counter = null;
cljs.core.gensym = function() {
  var gensym = null;
  var gensym__0 = function() {
    return gensym.call(null, "G__")
  };
  var gensym__1 = function(prefix_string) {
    if(cljs.core.gensym_counter == null) {
      cljs.core.gensym_counter = cljs.core.atom.call(null, 0)
    }else {
    }
    return cljs.core.symbol.call(null, [cljs.core.str(prefix_string), cljs.core.str(cljs.core.swap_BANG_.call(null, cljs.core.gensym_counter, cljs.core.inc))].join(""))
  };
  gensym = function(prefix_string) {
    switch(arguments.length) {
      case 0:
        return gensym__0.call(this);
      case 1:
        return gensym__1.call(this, prefix_string)
    }
    throw"Invalid arity: " + arguments.length;
  };
  gensym.cljs$lang$arity$0 = gensym__0;
  gensym.cljs$lang$arity$1 = gensym__1;
  return gensym
}();
cljs.core.fixture1 = 1;
cljs.core.fixture2 = 2;
cljs.core.Delay = function(state, f) {
  this.state = state;
  this.f = f;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1073774592
};
cljs.core.Delay.cljs$lang$type = true;
cljs.core.Delay.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/Delay")
};
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(d) {
  var this__37557 = this;
  return(new cljs.core.Keyword("\ufdd0'done")).call(null, cljs.core.deref.call(null, this__37557.state))
};
cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__37558 = this;
  return(new cljs.core.Keyword("\ufdd0'value")).call(null, cljs.core.swap_BANG_.call(null, this__37558.state, function(p__37559) {
    var map__37560__37561 = p__37559;
    var map__37560__37562 = cljs.core.seq_QMARK_.call(null, map__37560__37561) ? cljs.core.apply.call(null, cljs.core.hash_map, map__37560__37561) : map__37560__37561;
    var curr_state__37563 = map__37560__37562;
    var done__37564 = cljs.core._lookup.call(null, map__37560__37562, "\ufdd0'done", null);
    if(cljs.core.truth_(done__37564)) {
      return curr_state__37563
    }else {
      return cljs.core.ObjMap.fromObject(["\ufdd0'done", "\ufdd0'value"], {"\ufdd0'done":true, "\ufdd0'value":this__37558.f.call(null)})
    }
  }))
};
cljs.core.Delay;
cljs.core.delay_QMARK_ = function delay_QMARK_(x) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Delay, x)
};
cljs.core.force = function force(x) {
  if(cljs.core.delay_QMARK_.call(null, x)) {
    return cljs.core.deref.call(null, x)
  }else {
    return x
  }
};
cljs.core.realized_QMARK_ = function realized_QMARK_(d) {
  return cljs.core._realized_QMARK_.call(null, d)
};
cljs.core.js__GT_clj = function() {
  var js__GT_clj__delegate = function(x, options) {
    var map__37585__37586 = options;
    var map__37585__37587 = cljs.core.seq_QMARK_.call(null, map__37585__37586) ? cljs.core.apply.call(null, cljs.core.hash_map, map__37585__37586) : map__37585__37586;
    var keywordize_keys__37588 = cljs.core._lookup.call(null, map__37585__37587, "\ufdd0'keywordize-keys", null);
    var keyfn__37589 = cljs.core.truth_(keywordize_keys__37588) ? cljs.core.keyword : cljs.core.str;
    var f__37604 = function thisfn(x) {
      if(cljs.core.seq_QMARK_.call(null, x)) {
        return cljs.core.doall.call(null, cljs.core.map.call(null, thisfn, x))
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.into.call(null, cljs.core.empty.call(null, x), cljs.core.map.call(null, thisfn, x))
        }else {
          if(cljs.core.truth_(goog.isArray(x))) {
            return cljs.core.vec.call(null, cljs.core.map.call(null, thisfn, x))
          }else {
            if(cljs.core.type.call(null, x) === Object) {
              return cljs.core.into.call(null, cljs.core.ObjMap.EMPTY, function() {
                var iter__2462__auto____37603 = function iter__37597(s__37598) {
                  return new cljs.core.LazySeq(null, false, function() {
                    var s__37598__37601 = s__37598;
                    while(true) {
                      if(cljs.core.seq.call(null, s__37598__37601)) {
                        var k__37602 = cljs.core.first.call(null, s__37598__37601);
                        return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([keyfn__37589.call(null, k__37602), thisfn.call(null, x[k__37602])], true), iter__37597.call(null, cljs.core.rest.call(null, s__37598__37601)))
                      }else {
                        return null
                      }
                      break
                    }
                  }, null)
                };
                return iter__2462__auto____37603.call(null, cljs.core.js_keys.call(null, x))
              }())
            }else {
              if("\ufdd0'else") {
                return x
              }else {
                return null
              }
            }
          }
        }
      }
    };
    return f__37604.call(null, x)
  };
  var js__GT_clj = function(x, var_args) {
    var options = null;
    if(goog.isDef(var_args)) {
      options = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return js__GT_clj__delegate.call(this, x, options)
  };
  js__GT_clj.cljs$lang$maxFixedArity = 1;
  js__GT_clj.cljs$lang$applyTo = function(arglist__37605) {
    var x = cljs.core.first(arglist__37605);
    var options = cljs.core.rest(arglist__37605);
    return js__GT_clj__delegate(x, options)
  };
  js__GT_clj.cljs$lang$arity$variadic = js__GT_clj__delegate;
  return js__GT_clj
}();
cljs.core.memoize = function memoize(f) {
  var mem__37610 = cljs.core.atom.call(null, cljs.core.ObjMap.EMPTY);
  return function() {
    var G__37614__delegate = function(args) {
      var temp__3971__auto____37611 = cljs.core._lookup.call(null, cljs.core.deref.call(null, mem__37610), args, null);
      if(cljs.core.truth_(temp__3971__auto____37611)) {
        var v__37612 = temp__3971__auto____37611;
        return v__37612
      }else {
        var ret__37613 = cljs.core.apply.call(null, f, args);
        cljs.core.swap_BANG_.call(null, mem__37610, cljs.core.assoc, args, ret__37613);
        return ret__37613
      }
    };
    var G__37614 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__37614__delegate.call(this, args)
    };
    G__37614.cljs$lang$maxFixedArity = 0;
    G__37614.cljs$lang$applyTo = function(arglist__37615) {
      var args = cljs.core.seq(arglist__37615);
      return G__37614__delegate(args)
    };
    G__37614.cljs$lang$arity$variadic = G__37614__delegate;
    return G__37614
  }()
};
cljs.core.trampoline = function() {
  var trampoline = null;
  var trampoline__1 = function(f) {
    while(true) {
      var ret__37617 = f.call(null);
      if(cljs.core.fn_QMARK_.call(null, ret__37617)) {
        var G__37618 = ret__37617;
        f = G__37618;
        continue
      }else {
        return ret__37617
      }
      break
    }
  };
  var trampoline__2 = function() {
    var G__37619__delegate = function(f, args) {
      return trampoline.call(null, function() {
        return cljs.core.apply.call(null, f, args)
      })
    };
    var G__37619 = function(f, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__37619__delegate.call(this, f, args)
    };
    G__37619.cljs$lang$maxFixedArity = 1;
    G__37619.cljs$lang$applyTo = function(arglist__37620) {
      var f = cljs.core.first(arglist__37620);
      var args = cljs.core.rest(arglist__37620);
      return G__37619__delegate(f, args)
    };
    G__37619.cljs$lang$arity$variadic = G__37619__delegate;
    return G__37619
  }();
  trampoline = function(f, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 1:
        return trampoline__1.call(this, f);
      default:
        return trampoline__2.cljs$lang$arity$variadic(f, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  trampoline.cljs$lang$maxFixedArity = 1;
  trampoline.cljs$lang$applyTo = trampoline__2.cljs$lang$applyTo;
  trampoline.cljs$lang$arity$1 = trampoline__1;
  trampoline.cljs$lang$arity$variadic = trampoline__2.cljs$lang$arity$variadic;
  return trampoline
}();
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return rand.call(null, 1)
  };
  var rand__1 = function(n) {
    return Math.random.call(null) * n
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return Math.floor.call(null, Math.random.call(null) * n)
};
cljs.core.rand_nth = function rand_nth(coll) {
  return cljs.core.nth.call(null, coll, cljs.core.rand_int.call(null, cljs.core.count.call(null, coll)))
};
cljs.core.group_by = function group_by(f, coll) {
  return cljs.core.reduce.call(null, function(ret, x) {
    var k__37622 = f.call(null, x);
    return cljs.core.assoc.call(null, ret, k__37622, cljs.core.conj.call(null, cljs.core._lookup.call(null, ret, k__37622, cljs.core.PersistentVector.EMPTY), x))
  }, cljs.core.ObjMap.EMPTY, coll)
};
cljs.core.make_hierarchy = function make_hierarchy() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'descendants", "\ufdd0'ancestors"], {"\ufdd0'parents":cljs.core.ObjMap.EMPTY, "\ufdd0'descendants":cljs.core.ObjMap.EMPTY, "\ufdd0'ancestors":cljs.core.ObjMap.EMPTY})
};
cljs.core.global_hierarchy = cljs.core.atom.call(null, cljs.core.make_hierarchy.call(null));
cljs.core.isa_QMARK_ = function() {
  var isa_QMARK_ = null;
  var isa_QMARK___2 = function(child, parent) {
    return isa_QMARK_.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), child, parent)
  };
  var isa_QMARK___3 = function(h, child, parent) {
    var or__3824__auto____37631 = cljs.core._EQ_.call(null, child, parent);
    if(or__3824__auto____37631) {
      return or__3824__auto____37631
    }else {
      var or__3824__auto____37632 = cljs.core.contains_QMARK_.call(null, (new cljs.core.Keyword("\ufdd0'ancestors")).call(null, h).call(null, child), parent);
      if(or__3824__auto____37632) {
        return or__3824__auto____37632
      }else {
        var and__3822__auto____37633 = cljs.core.vector_QMARK_.call(null, parent);
        if(and__3822__auto____37633) {
          var and__3822__auto____37634 = cljs.core.vector_QMARK_.call(null, child);
          if(and__3822__auto____37634) {
            var and__3822__auto____37635 = cljs.core.count.call(null, parent) === cljs.core.count.call(null, child);
            if(and__3822__auto____37635) {
              var ret__37636 = true;
              var i__37637 = 0;
              while(true) {
                if(function() {
                  var or__3824__auto____37638 = cljs.core.not.call(null, ret__37636);
                  if(or__3824__auto____37638) {
                    return or__3824__auto____37638
                  }else {
                    return i__37637 === cljs.core.count.call(null, parent)
                  }
                }()) {
                  return ret__37636
                }else {
                  var G__37639 = isa_QMARK_.call(null, h, child.call(null, i__37637), parent.call(null, i__37637));
                  var G__37640 = i__37637 + 1;
                  ret__37636 = G__37639;
                  i__37637 = G__37640;
                  continue
                }
                break
              }
            }else {
              return and__3822__auto____37635
            }
          }else {
            return and__3822__auto____37634
          }
        }else {
          return and__3822__auto____37633
        }
      }
    }
  };
  isa_QMARK_ = function(h, child, parent) {
    switch(arguments.length) {
      case 2:
        return isa_QMARK___2.call(this, h, child);
      case 3:
        return isa_QMARK___3.call(this, h, child, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  isa_QMARK_.cljs$lang$arity$2 = isa_QMARK___2;
  isa_QMARK_.cljs$lang$arity$3 = isa_QMARK___3;
  return isa_QMARK_
}();
cljs.core.parents = function() {
  var parents = null;
  var parents__1 = function(tag) {
    return parents.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var parents__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core._lookup.call(null, (new cljs.core.Keyword("\ufdd0'parents")).call(null, h), tag, null))
  };
  parents = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return parents__1.call(this, h);
      case 2:
        return parents__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  parents.cljs$lang$arity$1 = parents__1;
  parents.cljs$lang$arity$2 = parents__2;
  return parents
}();
cljs.core.ancestors = function() {
  var ancestors = null;
  var ancestors__1 = function(tag) {
    return ancestors.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var ancestors__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core._lookup.call(null, (new cljs.core.Keyword("\ufdd0'ancestors")).call(null, h), tag, null))
  };
  ancestors = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return ancestors__1.call(this, h);
      case 2:
        return ancestors__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ancestors.cljs$lang$arity$1 = ancestors__1;
  ancestors.cljs$lang$arity$2 = ancestors__2;
  return ancestors
}();
cljs.core.descendants = function() {
  var descendants = null;
  var descendants__1 = function(tag) {
    return descendants.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var descendants__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core._lookup.call(null, (new cljs.core.Keyword("\ufdd0'descendants")).call(null, h), tag, null))
  };
  descendants = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return descendants__1.call(this, h);
      case 2:
        return descendants__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  descendants.cljs$lang$arity$1 = descendants__1;
  descendants.cljs$lang$arity$2 = descendants__2;
  return descendants
}();
cljs.core.derive = function() {
  var derive = null;
  var derive__2 = function(tag, parent) {
    if(cljs.core.truth_(cljs.core.namespace.call(null, parent))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'namespace", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6724))))].join(""));
    }
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, derive, tag, parent);
    return null
  };
  var derive__3 = function(h, tag, parent) {
    if(cljs.core.not_EQ_.call(null, tag, parent)) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'not=", "\ufdd1'tag", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6728))))].join(""));
    }
    var tp__37649 = (new cljs.core.Keyword("\ufdd0'parents")).call(null, h);
    var td__37650 = (new cljs.core.Keyword("\ufdd0'descendants")).call(null, h);
    var ta__37651 = (new cljs.core.Keyword("\ufdd0'ancestors")).call(null, h);
    var tf__37652 = function(m, source, sources, target, targets) {
      return cljs.core.reduce.call(null, function(ret, k) {
        return cljs.core.assoc.call(null, ret, k, cljs.core.reduce.call(null, cljs.core.conj, cljs.core._lookup.call(null, targets, k, cljs.core.PersistentHashSet.EMPTY), cljs.core.cons.call(null, target, targets.call(null, target))))
      }, m, cljs.core.cons.call(null, source, sources.call(null, source)))
    };
    var or__3824__auto____37653 = cljs.core.contains_QMARK_.call(null, tp__37649.call(null, tag), parent) ? null : function() {
      if(cljs.core.contains_QMARK_.call(null, ta__37651.call(null, tag), parent)) {
        throw new Error([cljs.core.str(tag), cljs.core.str("already has"), cljs.core.str(parent), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      if(cljs.core.contains_QMARK_.call(null, ta__37651.call(null, parent), tag)) {
        throw new Error([cljs.core.str("Cyclic derivation:"), cljs.core.str(parent), cljs.core.str("has"), cljs.core.str(tag), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'ancestors", "\ufdd0'descendants"], {"\ufdd0'parents":cljs.core.assoc.call(null, (new cljs.core.Keyword("\ufdd0'parents")).call(null, h), tag, cljs.core.conj.call(null, cljs.core._lookup.call(null, tp__37649, tag, cljs.core.PersistentHashSet.EMPTY), parent)), "\ufdd0'ancestors":tf__37652.call(null, (new cljs.core.Keyword("\ufdd0'ancestors")).call(null, h), tag, td__37650, parent, ta__37651), "\ufdd0'descendants":tf__37652.call(null, 
      (new cljs.core.Keyword("\ufdd0'descendants")).call(null, h), parent, ta__37651, tag, td__37650)})
    }();
    if(cljs.core.truth_(or__3824__auto____37653)) {
      return or__3824__auto____37653
    }else {
      return h
    }
  };
  derive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return derive__2.call(this, h, tag);
      case 3:
        return derive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  derive.cljs$lang$arity$2 = derive__2;
  derive.cljs$lang$arity$3 = derive__3;
  return derive
}();
cljs.core.underive = function() {
  var underive = null;
  var underive__2 = function(tag, parent) {
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, underive, tag, parent);
    return null
  };
  var underive__3 = function(h, tag, parent) {
    var parentMap__37658 = (new cljs.core.Keyword("\ufdd0'parents")).call(null, h);
    var childsParents__37659 = cljs.core.truth_(parentMap__37658.call(null, tag)) ? cljs.core.disj.call(null, parentMap__37658.call(null, tag), parent) : cljs.core.PersistentHashSet.EMPTY;
    var newParents__37660 = cljs.core.truth_(cljs.core.not_empty.call(null, childsParents__37659)) ? cljs.core.assoc.call(null, parentMap__37658, tag, childsParents__37659) : cljs.core.dissoc.call(null, parentMap__37658, tag);
    var deriv_seq__37661 = cljs.core.flatten.call(null, cljs.core.map.call(null, function(p1__37641_SHARP_) {
      return cljs.core.cons.call(null, cljs.core.first.call(null, p1__37641_SHARP_), cljs.core.interpose.call(null, cljs.core.first.call(null, p1__37641_SHARP_), cljs.core.second.call(null, p1__37641_SHARP_)))
    }, cljs.core.seq.call(null, newParents__37660)));
    if(cljs.core.contains_QMARK_.call(null, parentMap__37658.call(null, tag), parent)) {
      return cljs.core.reduce.call(null, function(p1__37642_SHARP_, p2__37643_SHARP_) {
        return cljs.core.apply.call(null, cljs.core.derive, p1__37642_SHARP_, p2__37643_SHARP_)
      }, cljs.core.make_hierarchy.call(null), cljs.core.partition.call(null, 2, deriv_seq__37661))
    }else {
      return h
    }
  };
  underive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return underive__2.call(this, h, tag);
      case 3:
        return underive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  underive.cljs$lang$arity$2 = underive__2;
  underive.cljs$lang$arity$3 = underive__3;
  return underive
}();
cljs.core.reset_cache = function reset_cache(method_cache, method_table, cached_hierarchy, hierarchy) {
  cljs.core.swap_BANG_.call(null, method_cache, function(_) {
    return cljs.core.deref.call(null, method_table)
  });
  return cljs.core.swap_BANG_.call(null, cached_hierarchy, function(_) {
    return cljs.core.deref.call(null, hierarchy)
  })
};
cljs.core.prefers_STAR_ = function prefers_STAR_(x, y, prefer_table) {
  var xprefs__37669 = cljs.core.deref.call(null, prefer_table).call(null, x);
  var or__3824__auto____37671 = cljs.core.truth_(function() {
    var and__3822__auto____37670 = xprefs__37669;
    if(cljs.core.truth_(and__3822__auto____37670)) {
      return xprefs__37669.call(null, y)
    }else {
      return and__3822__auto____37670
    }
  }()) ? true : null;
  if(cljs.core.truth_(or__3824__auto____37671)) {
    return or__3824__auto____37671
  }else {
    var or__3824__auto____37673 = function() {
      var ps__37672 = cljs.core.parents.call(null, y);
      while(true) {
        if(cljs.core.count.call(null, ps__37672) > 0) {
          if(cljs.core.truth_(prefers_STAR_.call(null, x, cljs.core.first.call(null, ps__37672), prefer_table))) {
          }else {
          }
          var G__37676 = cljs.core.rest.call(null, ps__37672);
          ps__37672 = G__37676;
          continue
        }else {
          return null
        }
        break
      }
    }();
    if(cljs.core.truth_(or__3824__auto____37673)) {
      return or__3824__auto____37673
    }else {
      var or__3824__auto____37675 = function() {
        var ps__37674 = cljs.core.parents.call(null, x);
        while(true) {
          if(cljs.core.count.call(null, ps__37674) > 0) {
            if(cljs.core.truth_(prefers_STAR_.call(null, cljs.core.first.call(null, ps__37674), y, prefer_table))) {
            }else {
            }
            var G__37677 = cljs.core.rest.call(null, ps__37674);
            ps__37674 = G__37677;
            continue
          }else {
            return null
          }
          break
        }
      }();
      if(cljs.core.truth_(or__3824__auto____37675)) {
        return or__3824__auto____37675
      }else {
        return false
      }
    }
  }
};
cljs.core.dominates = function dominates(x, y, prefer_table) {
  var or__3824__auto____37679 = cljs.core.prefers_STAR_.call(null, x, y, prefer_table);
  if(cljs.core.truth_(or__3824__auto____37679)) {
    return or__3824__auto____37679
  }else {
    return cljs.core.isa_QMARK_.call(null, x, y)
  }
};
cljs.core.find_and_cache_best_method = function find_and_cache_best_method(name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  var best_entry__37697 = cljs.core.reduce.call(null, function(be, p__37689) {
    var vec__37690__37691 = p__37689;
    var k__37692 = cljs.core.nth.call(null, vec__37690__37691, 0, null);
    var ___37693 = cljs.core.nth.call(null, vec__37690__37691, 1, null);
    var e__37694 = vec__37690__37691;
    if(cljs.core.isa_QMARK_.call(null, dispatch_val, k__37692)) {
      var be2__37696 = cljs.core.truth_(function() {
        var or__3824__auto____37695 = be == null;
        if(or__3824__auto____37695) {
          return or__3824__auto____37695
        }else {
          return cljs.core.dominates.call(null, k__37692, cljs.core.first.call(null, be), prefer_table)
        }
      }()) ? e__37694 : be;
      if(cljs.core.truth_(cljs.core.dominates.call(null, cljs.core.first.call(null, be2__37696), k__37692, prefer_table))) {
      }else {
        throw new Error([cljs.core.str("Multiple methods in multimethod '"), cljs.core.str(name), cljs.core.str("' match dispatch value: "), cljs.core.str(dispatch_val), cljs.core.str(" -> "), cljs.core.str(k__37692), cljs.core.str(" and "), cljs.core.str(cljs.core.first.call(null, be2__37696)), cljs.core.str(", and neither is preferred")].join(""));
      }
      return be2__37696
    }else {
      return be
    }
  }, null, cljs.core.deref.call(null, method_table));
  if(cljs.core.truth_(best_entry__37697)) {
    if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, cached_hierarchy), cljs.core.deref.call(null, hierarchy))) {
      cljs.core.swap_BANG_.call(null, method_cache, cljs.core.assoc, dispatch_val, cljs.core.second.call(null, best_entry__37697));
      return cljs.core.second.call(null, best_entry__37697)
    }else {
      cljs.core.reset_cache.call(null, method_cache, method_table, cached_hierarchy, hierarchy);
      return find_and_cache_best_method.call(null, name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy)
    }
  }else {
    return null
  }
};
cljs.core.IMultiFn = {};
cljs.core._reset = function _reset(mf) {
  if(function() {
    var and__3822__auto____37702 = mf;
    if(and__3822__auto____37702) {
      return mf.cljs$core$IMultiFn$_reset$arity$1
    }else {
      return and__3822__auto____37702
    }
  }()) {
    return mf.cljs$core$IMultiFn$_reset$arity$1(mf)
  }else {
    var x__2363__auto____37703 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____37704 = cljs.core._reset[goog.typeOf(x__2363__auto____37703)];
      if(or__3824__auto____37704) {
        return or__3824__auto____37704
      }else {
        var or__3824__auto____37705 = cljs.core._reset["_"];
        if(or__3824__auto____37705) {
          return or__3824__auto____37705
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-reset", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._add_method = function _add_method(mf, dispatch_val, method) {
  if(function() {
    var and__3822__auto____37710 = mf;
    if(and__3822__auto____37710) {
      return mf.cljs$core$IMultiFn$_add_method$arity$3
    }else {
      return and__3822__auto____37710
    }
  }()) {
    return mf.cljs$core$IMultiFn$_add_method$arity$3(mf, dispatch_val, method)
  }else {
    var x__2363__auto____37711 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____37712 = cljs.core._add_method[goog.typeOf(x__2363__auto____37711)];
      if(or__3824__auto____37712) {
        return or__3824__auto____37712
      }else {
        var or__3824__auto____37713 = cljs.core._add_method["_"];
        if(or__3824__auto____37713) {
          return or__3824__auto____37713
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-add-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, method)
  }
};
cljs.core._remove_method = function _remove_method(mf, dispatch_val) {
  if(function() {
    var and__3822__auto____37718 = mf;
    if(and__3822__auto____37718) {
      return mf.cljs$core$IMultiFn$_remove_method$arity$2
    }else {
      return and__3822__auto____37718
    }
  }()) {
    return mf.cljs$core$IMultiFn$_remove_method$arity$2(mf, dispatch_val)
  }else {
    var x__2363__auto____37719 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____37720 = cljs.core._remove_method[goog.typeOf(x__2363__auto____37719)];
      if(or__3824__auto____37720) {
        return or__3824__auto____37720
      }else {
        var or__3824__auto____37721 = cljs.core._remove_method["_"];
        if(or__3824__auto____37721) {
          return or__3824__auto____37721
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-remove-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._prefer_method = function _prefer_method(mf, dispatch_val, dispatch_val_y) {
  if(function() {
    var and__3822__auto____37726 = mf;
    if(and__3822__auto____37726) {
      return mf.cljs$core$IMultiFn$_prefer_method$arity$3
    }else {
      return and__3822__auto____37726
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefer_method$arity$3(mf, dispatch_val, dispatch_val_y)
  }else {
    var x__2363__auto____37727 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____37728 = cljs.core._prefer_method[goog.typeOf(x__2363__auto____37727)];
      if(or__3824__auto____37728) {
        return or__3824__auto____37728
      }else {
        var or__3824__auto____37729 = cljs.core._prefer_method["_"];
        if(or__3824__auto____37729) {
          return or__3824__auto____37729
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefer-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, dispatch_val_y)
  }
};
cljs.core._get_method = function _get_method(mf, dispatch_val) {
  if(function() {
    var and__3822__auto____37734 = mf;
    if(and__3822__auto____37734) {
      return mf.cljs$core$IMultiFn$_get_method$arity$2
    }else {
      return and__3822__auto____37734
    }
  }()) {
    return mf.cljs$core$IMultiFn$_get_method$arity$2(mf, dispatch_val)
  }else {
    var x__2363__auto____37735 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____37736 = cljs.core._get_method[goog.typeOf(x__2363__auto____37735)];
      if(or__3824__auto____37736) {
        return or__3824__auto____37736
      }else {
        var or__3824__auto____37737 = cljs.core._get_method["_"];
        if(or__3824__auto____37737) {
          return or__3824__auto____37737
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-get-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._methods = function _methods(mf) {
  if(function() {
    var and__3822__auto____37742 = mf;
    if(and__3822__auto____37742) {
      return mf.cljs$core$IMultiFn$_methods$arity$1
    }else {
      return and__3822__auto____37742
    }
  }()) {
    return mf.cljs$core$IMultiFn$_methods$arity$1(mf)
  }else {
    var x__2363__auto____37743 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____37744 = cljs.core._methods[goog.typeOf(x__2363__auto____37743)];
      if(or__3824__auto____37744) {
        return or__3824__auto____37744
      }else {
        var or__3824__auto____37745 = cljs.core._methods["_"];
        if(or__3824__auto____37745) {
          return or__3824__auto____37745
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-methods", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._prefers = function _prefers(mf) {
  if(function() {
    var and__3822__auto____37750 = mf;
    if(and__3822__auto____37750) {
      return mf.cljs$core$IMultiFn$_prefers$arity$1
    }else {
      return and__3822__auto____37750
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefers$arity$1(mf)
  }else {
    var x__2363__auto____37751 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____37752 = cljs.core._prefers[goog.typeOf(x__2363__auto____37751)];
      if(or__3824__auto____37752) {
        return or__3824__auto____37752
      }else {
        var or__3824__auto____37753 = cljs.core._prefers["_"];
        if(or__3824__auto____37753) {
          return or__3824__auto____37753
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefers", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._dispatch = function _dispatch(mf, args) {
  if(function() {
    var and__3822__auto____37758 = mf;
    if(and__3822__auto____37758) {
      return mf.cljs$core$IMultiFn$_dispatch$arity$2
    }else {
      return and__3822__auto____37758
    }
  }()) {
    return mf.cljs$core$IMultiFn$_dispatch$arity$2(mf, args)
  }else {
    var x__2363__auto____37759 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____37760 = cljs.core._dispatch[goog.typeOf(x__2363__auto____37759)];
      if(or__3824__auto____37760) {
        return or__3824__auto____37760
      }else {
        var or__3824__auto____37761 = cljs.core._dispatch["_"];
        if(or__3824__auto____37761) {
          return or__3824__auto____37761
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-dispatch", mf);
        }
      }
    }().call(null, mf, args)
  }
};
cljs.core.do_dispatch = function do_dispatch(mf, dispatch_fn, args) {
  var dispatch_val__37764 = cljs.core.apply.call(null, dispatch_fn, args);
  var target_fn__37765 = cljs.core._get_method.call(null, mf, dispatch_val__37764);
  if(cljs.core.truth_(target_fn__37765)) {
  }else {
    throw new Error([cljs.core.str("No method in multimethod '"), cljs.core.str(cljs.core.name), cljs.core.str("' for dispatch value: "), cljs.core.str(dispatch_val__37764)].join(""));
  }
  return cljs.core.apply.call(null, target_fn__37765, args)
};
cljs.core.MultiFn = function(name, dispatch_fn, default_dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  this.name = name;
  this.dispatch_fn = dispatch_fn;
  this.default_dispatch_val = default_dispatch_val;
  this.hierarchy = hierarchy;
  this.method_table = method_table;
  this.prefer_table = prefer_table;
  this.method_cache = method_cache;
  this.cached_hierarchy = cached_hierarchy;
  this.cljs$lang$protocol_mask$partition0$ = 4194304;
  this.cljs$lang$protocol_mask$partition1$ = 64
};
cljs.core.MultiFn.cljs$lang$type = true;
cljs.core.MultiFn.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/MultiFn")
};
cljs.core.MultiFn.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__37766 = this;
  return goog.getUid(this$)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_reset$arity$1 = function(mf) {
  var this__37767 = this;
  cljs.core.swap_BANG_.call(null, this__37767.method_table, function(mf) {
    return cljs.core.ObjMap.EMPTY
  });
  cljs.core.swap_BANG_.call(null, this__37767.method_cache, function(mf) {
    return cljs.core.ObjMap.EMPTY
  });
  cljs.core.swap_BANG_.call(null, this__37767.prefer_table, function(mf) {
    return cljs.core.ObjMap.EMPTY
  });
  cljs.core.swap_BANG_.call(null, this__37767.cached_hierarchy, function(mf) {
    return null
  });
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_add_method$arity$3 = function(mf, dispatch_val, method) {
  var this__37768 = this;
  cljs.core.swap_BANG_.call(null, this__37768.method_table, cljs.core.assoc, dispatch_val, method);
  cljs.core.reset_cache.call(null, this__37768.method_cache, this__37768.method_table, this__37768.cached_hierarchy, this__37768.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_remove_method$arity$2 = function(mf, dispatch_val) {
  var this__37769 = this;
  cljs.core.swap_BANG_.call(null, this__37769.method_table, cljs.core.dissoc, dispatch_val);
  cljs.core.reset_cache.call(null, this__37769.method_cache, this__37769.method_table, this__37769.cached_hierarchy, this__37769.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_get_method$arity$2 = function(mf, dispatch_val) {
  var this__37770 = this;
  if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, this__37770.cached_hierarchy), cljs.core.deref.call(null, this__37770.hierarchy))) {
  }else {
    cljs.core.reset_cache.call(null, this__37770.method_cache, this__37770.method_table, this__37770.cached_hierarchy, this__37770.hierarchy)
  }
  var temp__3971__auto____37771 = cljs.core.deref.call(null, this__37770.method_cache).call(null, dispatch_val);
  if(cljs.core.truth_(temp__3971__auto____37771)) {
    var target_fn__37772 = temp__3971__auto____37771;
    return target_fn__37772
  }else {
    var temp__3971__auto____37773 = cljs.core.find_and_cache_best_method.call(null, this__37770.name, dispatch_val, this__37770.hierarchy, this__37770.method_table, this__37770.prefer_table, this__37770.method_cache, this__37770.cached_hierarchy);
    if(cljs.core.truth_(temp__3971__auto____37773)) {
      var target_fn__37774 = temp__3971__auto____37773;
      return target_fn__37774
    }else {
      return cljs.core.deref.call(null, this__37770.method_table).call(null, this__37770.default_dispatch_val)
    }
  }
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefer_method$arity$3 = function(mf, dispatch_val_x, dispatch_val_y) {
  var this__37775 = this;
  if(cljs.core.truth_(cljs.core.prefers_STAR_.call(null, dispatch_val_x, dispatch_val_y, this__37775.prefer_table))) {
    throw new Error([cljs.core.str("Preference conflict in multimethod '"), cljs.core.str(this__37775.name), cljs.core.str("': "), cljs.core.str(dispatch_val_y), cljs.core.str(" is already preferred to "), cljs.core.str(dispatch_val_x)].join(""));
  }else {
  }
  cljs.core.swap_BANG_.call(null, this__37775.prefer_table, function(old) {
    return cljs.core.assoc.call(null, old, dispatch_val_x, cljs.core.conj.call(null, cljs.core._lookup.call(null, old, dispatch_val_x, cljs.core.PersistentHashSet.EMPTY), dispatch_val_y))
  });
  return cljs.core.reset_cache.call(null, this__37775.method_cache, this__37775.method_table, this__37775.cached_hierarchy, this__37775.hierarchy)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_methods$arity$1 = function(mf) {
  var this__37776 = this;
  return cljs.core.deref.call(null, this__37776.method_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefers$arity$1 = function(mf) {
  var this__37777 = this;
  return cljs.core.deref.call(null, this__37777.prefer_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_dispatch$arity$2 = function(mf, args) {
  var this__37778 = this;
  return cljs.core.do_dispatch.call(null, mf, this__37778.dispatch_fn, args)
};
cljs.core.MultiFn;
cljs.core.MultiFn.prototype.call = function() {
  var G__37780__delegate = function(_, args) {
    var self__37779 = this;
    return cljs.core._dispatch.call(null, self__37779, args)
  };
  var G__37780 = function(_, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return G__37780__delegate.call(this, _, args)
  };
  G__37780.cljs$lang$maxFixedArity = 1;
  G__37780.cljs$lang$applyTo = function(arglist__37781) {
    var _ = cljs.core.first(arglist__37781);
    var args = cljs.core.rest(arglist__37781);
    return G__37780__delegate(_, args)
  };
  G__37780.cljs$lang$arity$variadic = G__37780__delegate;
  return G__37780
}();
cljs.core.MultiFn.prototype.apply = function(_, args) {
  var self__37782 = this;
  return cljs.core._dispatch.call(null, self__37782, args)
};
cljs.core.remove_all_methods = function remove_all_methods(multifn) {
  return cljs.core._reset.call(null, multifn)
};
cljs.core.remove_method = function remove_method(multifn, dispatch_val) {
  return cljs.core._remove_method.call(null, multifn, dispatch_val)
};
cljs.core.prefer_method = function prefer_method(multifn, dispatch_val_x, dispatch_val_y) {
  return cljs.core._prefer_method.call(null, multifn, dispatch_val_x, dispatch_val_y)
};
cljs.core.methods$ = function methods$(multifn) {
  return cljs.core._methods.call(null, multifn)
};
cljs.core.get_method = function get_method(multifn, dispatch_val) {
  return cljs.core._get_method.call(null, multifn, dispatch_val)
};
cljs.core.prefers = function prefers(multifn) {
  return cljs.core._prefers.call(null, multifn)
};
cljs.core.UUID = function(uuid) {
  this.uuid = uuid;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 543162368
};
cljs.core.UUID.cljs$lang$type = true;
cljs.core.UUID.cljs$lang$ctorPrSeq = function(this__2309__auto__) {
  return cljs.core.list.call(null, "cljs.core/UUID")
};
cljs.core.UUID.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__37783 = this;
  return goog.string.hashCode(cljs.core.pr_str.call(null, this$))
};
cljs.core.UUID.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(_37785, _) {
  var this__37784 = this;
  return cljs.core.list.call(null, [cljs.core.str('#uuid "'), cljs.core.str(this__37784.uuid), cljs.core.str('"')].join(""))
};
cljs.core.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var this__37786 = this;
  var and__3822__auto____37787 = cljs.core.instance_QMARK_.call(null, cljs.core.UUID, other);
  if(and__3822__auto____37787) {
    return this__37786.uuid === other.uuid
  }else {
    return and__3822__auto____37787
  }
};
cljs.core.UUID.prototype.toString = function() {
  var this__37788 = this;
  var this__37789 = this;
  return cljs.core.pr_str.call(null, this__37789)
};
cljs.core.UUID;
goog.provide("goog.userAgent");
goog.require("goog.string");
goog.userAgent.ASSUME_IE = false;
goog.userAgent.ASSUME_GECKO = false;
goog.userAgent.ASSUME_WEBKIT = false;
goog.userAgent.ASSUME_MOBILE_WEBKIT = false;
goog.userAgent.ASSUME_OPERA = false;
goog.userAgent.BROWSER_KNOWN_ = goog.userAgent.ASSUME_IE || goog.userAgent.ASSUME_GECKO || goog.userAgent.ASSUME_MOBILE_WEBKIT || goog.userAgent.ASSUME_WEBKIT || goog.userAgent.ASSUME_OPERA;
goog.userAgent.getUserAgentString = function() {
  return goog.global["navigator"] ? goog.global["navigator"].userAgent : null
};
goog.userAgent.getNavigator = function() {
  return goog.global["navigator"]
};
goog.userAgent.init_ = function() {
  goog.userAgent.detectedOpera_ = false;
  goog.userAgent.detectedIe_ = false;
  goog.userAgent.detectedWebkit_ = false;
  goog.userAgent.detectedMobile_ = false;
  goog.userAgent.detectedGecko_ = false;
  var ua;
  if(!goog.userAgent.BROWSER_KNOWN_ && (ua = goog.userAgent.getUserAgentString())) {
    var navigator = goog.userAgent.getNavigator();
    goog.userAgent.detectedOpera_ = ua.indexOf("Opera") == 0;
    goog.userAgent.detectedIe_ = !goog.userAgent.detectedOpera_ && ua.indexOf("MSIE") != -1;
    goog.userAgent.detectedWebkit_ = !goog.userAgent.detectedOpera_ && ua.indexOf("WebKit") != -1;
    goog.userAgent.detectedMobile_ = goog.userAgent.detectedWebkit_ && ua.indexOf("Mobile") != -1;
    goog.userAgent.detectedGecko_ = !goog.userAgent.detectedOpera_ && !goog.userAgent.detectedWebkit_ && navigator.product == "Gecko"
  }
};
if(!goog.userAgent.BROWSER_KNOWN_) {
  goog.userAgent.init_()
}
goog.userAgent.OPERA = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_OPERA : goog.userAgent.detectedOpera_;
goog.userAgent.IE = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_IE : goog.userAgent.detectedIe_;
goog.userAgent.GECKO = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_GECKO : goog.userAgent.detectedGecko_;
goog.userAgent.WEBKIT = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_WEBKIT || goog.userAgent.ASSUME_MOBILE_WEBKIT : goog.userAgent.detectedWebkit_;
goog.userAgent.MOBILE = goog.userAgent.ASSUME_MOBILE_WEBKIT || goog.userAgent.detectedMobile_;
goog.userAgent.SAFARI = goog.userAgent.WEBKIT;
goog.userAgent.determinePlatform_ = function() {
  var navigator = goog.userAgent.getNavigator();
  return navigator && navigator.platform || ""
};
goog.userAgent.PLATFORM = goog.userAgent.determinePlatform_();
goog.userAgent.ASSUME_MAC = false;
goog.userAgent.ASSUME_WINDOWS = false;
goog.userAgent.ASSUME_LINUX = false;
goog.userAgent.ASSUME_X11 = false;
goog.userAgent.PLATFORM_KNOWN_ = goog.userAgent.ASSUME_MAC || goog.userAgent.ASSUME_WINDOWS || goog.userAgent.ASSUME_LINUX || goog.userAgent.ASSUME_X11;
goog.userAgent.initPlatform_ = function() {
  goog.userAgent.detectedMac_ = goog.string.contains(goog.userAgent.PLATFORM, "Mac");
  goog.userAgent.detectedWindows_ = goog.string.contains(goog.userAgent.PLATFORM, "Win");
  goog.userAgent.detectedLinux_ = goog.string.contains(goog.userAgent.PLATFORM, "Linux");
  goog.userAgent.detectedX11_ = !!goog.userAgent.getNavigator() && goog.string.contains(goog.userAgent.getNavigator()["appVersion"] || "", "X11")
};
if(!goog.userAgent.PLATFORM_KNOWN_) {
  goog.userAgent.initPlatform_()
}
goog.userAgent.MAC = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_MAC : goog.userAgent.detectedMac_;
goog.userAgent.WINDOWS = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_WINDOWS : goog.userAgent.detectedWindows_;
goog.userAgent.LINUX = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_LINUX : goog.userAgent.detectedLinux_;
goog.userAgent.X11 = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_X11 : goog.userAgent.detectedX11_;
goog.userAgent.determineVersion_ = function() {
  var version = "", re;
  if(goog.userAgent.OPERA && goog.global["opera"]) {
    var operaVersion = goog.global["opera"].version;
    version = typeof operaVersion == "function" ? operaVersion() : operaVersion
  }else {
    if(goog.userAgent.GECKO) {
      re = /rv\:([^\);]+)(\)|;)/
    }else {
      if(goog.userAgent.IE) {
        re = /MSIE\s+([^\);]+)(\)|;)/
      }else {
        if(goog.userAgent.WEBKIT) {
          re = /WebKit\/(\S+)/
        }
      }
    }
    if(re) {
      var arr = re.exec(goog.userAgent.getUserAgentString());
      version = arr ? arr[1] : ""
    }
  }
  if(goog.userAgent.IE) {
    var docMode = goog.userAgent.getDocumentMode_();
    if(docMode > parseFloat(version)) {
      return String(docMode)
    }
  }
  return version
};
goog.userAgent.getDocumentMode_ = function() {
  var doc = goog.global["document"];
  return doc ? doc["documentMode"] : undefined
};
goog.userAgent.VERSION = goog.userAgent.determineVersion_();
goog.userAgent.compare = function(v1, v2) {
  return goog.string.compareVersions(v1, v2)
};
goog.userAgent.isVersionCache_ = {};
goog.userAgent.isVersion = function(version) {
  return goog.userAgent.isVersionCache_[version] || (goog.userAgent.isVersionCache_[version] = goog.string.compareVersions(goog.userAgent.VERSION, version) >= 0)
};
goog.userAgent.isDocumentModeCache_ = {};
goog.userAgent.isDocumentMode = function(documentMode) {
  return goog.userAgent.isDocumentModeCache_[documentMode] || (goog.userAgent.isDocumentModeCache_[documentMode] = goog.userAgent.IE && document.documentMode && document.documentMode >= documentMode)
};
goog.provide("goog.dom.BrowserFeature");
goog.require("goog.userAgent");
goog.dom.BrowserFeature = {CAN_ADD_NAME_OR_TYPE_ATTRIBUTES:!goog.userAgent.IE || goog.userAgent.isDocumentMode(9), CAN_USE_CHILDREN_ATTRIBUTE:!goog.userAgent.GECKO && !goog.userAgent.IE || goog.userAgent.IE && goog.userAgent.isDocumentMode(9) || goog.userAgent.GECKO && goog.userAgent.isVersion("1.9.1"), CAN_USE_INNER_TEXT:goog.userAgent.IE && !goog.userAgent.isVersion("9"), INNER_HTML_NEEDS_SCOPED_ELEMENT:goog.userAgent.IE};
goog.provide("goog.dom.TagName");
goog.dom.TagName = {A:"A", ABBR:"ABBR", ACRONYM:"ACRONYM", ADDRESS:"ADDRESS", APPLET:"APPLET", AREA:"AREA", B:"B", BASE:"BASE", BASEFONT:"BASEFONT", BDO:"BDO", BIG:"BIG", BLOCKQUOTE:"BLOCKQUOTE", BODY:"BODY", BR:"BR", BUTTON:"BUTTON", CANVAS:"CANVAS", CAPTION:"CAPTION", CENTER:"CENTER", CITE:"CITE", CODE:"CODE", COL:"COL", COLGROUP:"COLGROUP", DD:"DD", DEL:"DEL", DFN:"DFN", DIR:"DIR", DIV:"DIV", DL:"DL", DT:"DT", EM:"EM", FIELDSET:"FIELDSET", FONT:"FONT", FORM:"FORM", FRAME:"FRAME", FRAMESET:"FRAMESET", 
H1:"H1", H2:"H2", H3:"H3", H4:"H4", H5:"H5", H6:"H6", HEAD:"HEAD", HR:"HR", HTML:"HTML", I:"I", IFRAME:"IFRAME", IMG:"IMG", INPUT:"INPUT", INS:"INS", ISINDEX:"ISINDEX", KBD:"KBD", LABEL:"LABEL", LEGEND:"LEGEND", LI:"LI", LINK:"LINK", MAP:"MAP", MENU:"MENU", META:"META", NOFRAMES:"NOFRAMES", NOSCRIPT:"NOSCRIPT", OBJECT:"OBJECT", OL:"OL", OPTGROUP:"OPTGROUP", OPTION:"OPTION", P:"P", PARAM:"PARAM", PRE:"PRE", Q:"Q", S:"S", SAMP:"SAMP", SCRIPT:"SCRIPT", SELECT:"SELECT", SMALL:"SMALL", SPAN:"SPAN", STRIKE:"STRIKE", 
STRONG:"STRONG", STYLE:"STYLE", SUB:"SUB", SUP:"SUP", TABLE:"TABLE", TBODY:"TBODY", TD:"TD", TEXTAREA:"TEXTAREA", TFOOT:"TFOOT", TH:"TH", THEAD:"THEAD", TITLE:"TITLE", TR:"TR", TT:"TT", U:"U", UL:"UL", VAR:"VAR"};
goog.provide("goog.dom.classes");
goog.require("goog.array");
goog.dom.classes.set = function(element, className) {
  element.className = className
};
goog.dom.classes.get = function(element) {
  var className = element.className;
  return className && typeof className.split == "function" ? className.split(/\s+/) : []
};
goog.dom.classes.add = function(element, var_args) {
  var classes = goog.dom.classes.get(element);
  var args = goog.array.slice(arguments, 1);
  var b = goog.dom.classes.add_(classes, args);
  element.className = classes.join(" ");
  return b
};
goog.dom.classes.remove = function(element, var_args) {
  var classes = goog.dom.classes.get(element);
  var args = goog.array.slice(arguments, 1);
  var b = goog.dom.classes.remove_(classes, args);
  element.className = classes.join(" ");
  return b
};
goog.dom.classes.add_ = function(classes, args) {
  var rv = 0;
  for(var i = 0;i < args.length;i++) {
    if(!goog.array.contains(classes, args[i])) {
      classes.push(args[i]);
      rv++
    }
  }
  return rv == args.length
};
goog.dom.classes.remove_ = function(classes, args) {
  var rv = 0;
  for(var i = 0;i < classes.length;i++) {
    if(goog.array.contains(args, classes[i])) {
      goog.array.splice(classes, i--, 1);
      rv++
    }
  }
  return rv == args.length
};
goog.dom.classes.swap = function(element, fromClass, toClass) {
  var classes = goog.dom.classes.get(element);
  var removed = false;
  for(var i = 0;i < classes.length;i++) {
    if(classes[i] == fromClass) {
      goog.array.splice(classes, i--, 1);
      removed = true
    }
  }
  if(removed) {
    classes.push(toClass);
    element.className = classes.join(" ")
  }
  return removed
};
goog.dom.classes.addRemove = function(element, classesToRemove, classesToAdd) {
  var classes = goog.dom.classes.get(element);
  if(goog.isString(classesToRemove)) {
    goog.array.remove(classes, classesToRemove)
  }else {
    if(goog.isArray(classesToRemove)) {
      goog.dom.classes.remove_(classes, classesToRemove)
    }
  }
  if(goog.isString(classesToAdd) && !goog.array.contains(classes, classesToAdd)) {
    classes.push(classesToAdd)
  }else {
    if(goog.isArray(classesToAdd)) {
      goog.dom.classes.add_(classes, classesToAdd)
    }
  }
  element.className = classes.join(" ")
};
goog.dom.classes.has = function(element, className) {
  return goog.array.contains(goog.dom.classes.get(element), className)
};
goog.dom.classes.enable = function(element, className, enabled) {
  if(enabled) {
    goog.dom.classes.add(element, className)
  }else {
    goog.dom.classes.remove(element, className)
  }
};
goog.dom.classes.toggle = function(element, className) {
  var add = !goog.dom.classes.has(element, className);
  goog.dom.classes.enable(element, className, add);
  return add
};
goog.provide("goog.math.Coordinate");
goog.math.Coordinate = function(opt_x, opt_y) {
  this.x = goog.isDef(opt_x) ? opt_x : 0;
  this.y = goog.isDef(opt_y) ? opt_y : 0
};
goog.math.Coordinate.prototype.clone = function() {
  return new goog.math.Coordinate(this.x, this.y)
};
if(goog.DEBUG) {
  goog.math.Coordinate.prototype.toString = function() {
    return"(" + this.x + ", " + this.y + ")"
  }
}
goog.math.Coordinate.equals = function(a, b) {
  if(a == b) {
    return true
  }
  if(!a || !b) {
    return false
  }
  return a.x == b.x && a.y == b.y
};
goog.math.Coordinate.distance = function(a, b) {
  var dx = a.x - b.x;
  var dy = a.y - b.y;
  return Math.sqrt(dx * dx + dy * dy)
};
goog.math.Coordinate.squaredDistance = function(a, b) {
  var dx = a.x - b.x;
  var dy = a.y - b.y;
  return dx * dx + dy * dy
};
goog.math.Coordinate.difference = function(a, b) {
  return new goog.math.Coordinate(a.x - b.x, a.y - b.y)
};
goog.math.Coordinate.sum = function(a, b) {
  return new goog.math.Coordinate(a.x + b.x, a.y + b.y)
};
goog.provide("goog.math.Size");
goog.math.Size = function(width, height) {
  this.width = width;
  this.height = height
};
goog.math.Size.equals = function(a, b) {
  if(a == b) {
    return true
  }
  if(!a || !b) {
    return false
  }
  return a.width == b.width && a.height == b.height
};
goog.math.Size.prototype.clone = function() {
  return new goog.math.Size(this.width, this.height)
};
if(goog.DEBUG) {
  goog.math.Size.prototype.toString = function() {
    return"(" + this.width + " x " + this.height + ")"
  }
}
goog.math.Size.prototype.getLongest = function() {
  return Math.max(this.width, this.height)
};
goog.math.Size.prototype.getShortest = function() {
  return Math.min(this.width, this.height)
};
goog.math.Size.prototype.area = function() {
  return this.width * this.height
};
goog.math.Size.prototype.perimeter = function() {
  return(this.width + this.height) * 2
};
goog.math.Size.prototype.aspectRatio = function() {
  return this.width / this.height
};
goog.math.Size.prototype.isEmpty = function() {
  return!this.area()
};
goog.math.Size.prototype.ceil = function() {
  this.width = Math.ceil(this.width);
  this.height = Math.ceil(this.height);
  return this
};
goog.math.Size.prototype.fitsInside = function(target) {
  return this.width <= target.width && this.height <= target.height
};
goog.math.Size.prototype.floor = function() {
  this.width = Math.floor(this.width);
  this.height = Math.floor(this.height);
  return this
};
goog.math.Size.prototype.round = function() {
  this.width = Math.round(this.width);
  this.height = Math.round(this.height);
  return this
};
goog.math.Size.prototype.scale = function(s) {
  this.width *= s;
  this.height *= s;
  return this
};
goog.math.Size.prototype.scaleToFit = function(target) {
  var s = this.aspectRatio() > target.aspectRatio() ? target.width / this.width : target.height / this.height;
  return this.scale(s)
};
goog.provide("goog.dom");
goog.provide("goog.dom.DomHelper");
goog.provide("goog.dom.NodeType");
goog.require("goog.array");
goog.require("goog.dom.BrowserFeature");
goog.require("goog.dom.TagName");
goog.require("goog.dom.classes");
goog.require("goog.math.Coordinate");
goog.require("goog.math.Size");
goog.require("goog.object");
goog.require("goog.string");
goog.require("goog.userAgent");
goog.dom.ASSUME_QUIRKS_MODE = false;
goog.dom.ASSUME_STANDARDS_MODE = false;
goog.dom.COMPAT_MODE_KNOWN_ = goog.dom.ASSUME_QUIRKS_MODE || goog.dom.ASSUME_STANDARDS_MODE;
goog.dom.NodeType = {ELEMENT:1, ATTRIBUTE:2, TEXT:3, CDATA_SECTION:4, ENTITY_REFERENCE:5, ENTITY:6, PROCESSING_INSTRUCTION:7, COMMENT:8, DOCUMENT:9, DOCUMENT_TYPE:10, DOCUMENT_FRAGMENT:11, NOTATION:12};
goog.dom.getDomHelper = function(opt_element) {
  return opt_element ? new goog.dom.DomHelper(goog.dom.getOwnerDocument(opt_element)) : goog.dom.defaultDomHelper_ || (goog.dom.defaultDomHelper_ = new goog.dom.DomHelper)
};
goog.dom.defaultDomHelper_;
goog.dom.getDocument = function() {
  return document
};
goog.dom.getElement = function(element) {
  return goog.isString(element) ? document.getElementById(element) : element
};
goog.dom.$ = goog.dom.getElement;
goog.dom.getElementsByTagNameAndClass = function(opt_tag, opt_class, opt_el) {
  return goog.dom.getElementsByTagNameAndClass_(document, opt_tag, opt_class, opt_el)
};
goog.dom.getElementsByClass = function(className, opt_el) {
  var parent = opt_el || document;
  if(goog.dom.canUseQuerySelector_(parent)) {
    return parent.querySelectorAll("." + className)
  }else {
    if(parent.getElementsByClassName) {
      return parent.getElementsByClassName(className)
    }
  }
  return goog.dom.getElementsByTagNameAndClass_(document, "*", className, opt_el)
};
goog.dom.getElementByClass = function(className, opt_el) {
  var parent = opt_el || document;
  var retVal = null;
  if(goog.dom.canUseQuerySelector_(parent)) {
    retVal = parent.querySelector("." + className)
  }else {
    retVal = goog.dom.getElementsByClass(className, opt_el)[0]
  }
  return retVal || null
};
goog.dom.canUseQuerySelector_ = function(parent) {
  return parent.querySelectorAll && parent.querySelector && (!goog.userAgent.WEBKIT || goog.dom.isCss1CompatMode_(document) || goog.userAgent.isVersion("528"))
};
goog.dom.getElementsByTagNameAndClass_ = function(doc, opt_tag, opt_class, opt_el) {
  var parent = opt_el || doc;
  var tagName = opt_tag && opt_tag != "*" ? opt_tag.toUpperCase() : "";
  if(goog.dom.canUseQuerySelector_(parent) && (tagName || opt_class)) {
    var query = tagName + (opt_class ? "." + opt_class : "");
    return parent.querySelectorAll(query)
  }
  if(opt_class && parent.getElementsByClassName) {
    var els = parent.getElementsByClassName(opt_class);
    if(tagName) {
      var arrayLike = {};
      var len = 0;
      for(var i = 0, el;el = els[i];i++) {
        if(tagName == el.nodeName) {
          arrayLike[len++] = el
        }
      }
      arrayLike.length = len;
      return arrayLike
    }else {
      return els
    }
  }
  var els = parent.getElementsByTagName(tagName || "*");
  if(opt_class) {
    var arrayLike = {};
    var len = 0;
    for(var i = 0, el;el = els[i];i++) {
      var className = el.className;
      if(typeof className.split == "function" && goog.array.contains(className.split(/\s+/), opt_class)) {
        arrayLike[len++] = el
      }
    }
    arrayLike.length = len;
    return arrayLike
  }else {
    return els
  }
};
goog.dom.$$ = goog.dom.getElementsByTagNameAndClass;
goog.dom.setProperties = function(element, properties) {
  goog.object.forEach(properties, function(val, key) {
    if(key == "style") {
      element.style.cssText = val
    }else {
      if(key == "class") {
        element.className = val
      }else {
        if(key == "for") {
          element.htmlFor = val
        }else {
          if(key in goog.dom.DIRECT_ATTRIBUTE_MAP_) {
            element.setAttribute(goog.dom.DIRECT_ATTRIBUTE_MAP_[key], val)
          }else {
            if(goog.string.startsWith(key, "aria-")) {
              element.setAttribute(key, val)
            }else {
              element[key] = val
            }
          }
        }
      }
    }
  })
};
goog.dom.DIRECT_ATTRIBUTE_MAP_ = {"cellpadding":"cellPadding", "cellspacing":"cellSpacing", "colspan":"colSpan", "rowspan":"rowSpan", "valign":"vAlign", "height":"height", "width":"width", "usemap":"useMap", "frameborder":"frameBorder", "maxlength":"maxLength", "type":"type"};
goog.dom.getViewportSize = function(opt_window) {
  return goog.dom.getViewportSize_(opt_window || window)
};
goog.dom.getViewportSize_ = function(win) {
  var doc = win.document;
  if(goog.userAgent.WEBKIT && !goog.userAgent.isVersion("500") && !goog.userAgent.MOBILE) {
    if(typeof win.innerHeight == "undefined") {
      win = window
    }
    var innerHeight = win.innerHeight;
    var scrollHeight = win.document.documentElement.scrollHeight;
    if(win == win.top) {
      if(scrollHeight < innerHeight) {
        innerHeight -= 15
      }
    }
    return new goog.math.Size(win.innerWidth, innerHeight)
  }
  var el = goog.dom.isCss1CompatMode_(doc) ? doc.documentElement : doc.body;
  return new goog.math.Size(el.clientWidth, el.clientHeight)
};
goog.dom.getDocumentHeight = function() {
  return goog.dom.getDocumentHeight_(window)
};
goog.dom.getDocumentHeight_ = function(win) {
  var doc = win.document;
  var height = 0;
  if(doc) {
    var vh = goog.dom.getViewportSize_(win).height;
    var body = doc.body;
    var docEl = doc.documentElement;
    if(goog.dom.isCss1CompatMode_(doc) && docEl.scrollHeight) {
      height = docEl.scrollHeight != vh ? docEl.scrollHeight : docEl.offsetHeight
    }else {
      var sh = docEl.scrollHeight;
      var oh = docEl.offsetHeight;
      if(docEl.clientHeight != oh) {
        sh = body.scrollHeight;
        oh = body.offsetHeight
      }
      if(sh > vh) {
        height = sh > oh ? sh : oh
      }else {
        height = sh < oh ? sh : oh
      }
    }
  }
  return height
};
goog.dom.getPageScroll = function(opt_window) {
  var win = opt_window || goog.global || window;
  return goog.dom.getDomHelper(win.document).getDocumentScroll()
};
goog.dom.getDocumentScroll = function() {
  return goog.dom.getDocumentScroll_(document)
};
goog.dom.getDocumentScroll_ = function(doc) {
  var el = goog.dom.getDocumentScrollElement_(doc);
  var win = goog.dom.getWindow_(doc);
  return new goog.math.Coordinate(win.pageXOffset || el.scrollLeft, win.pageYOffset || el.scrollTop)
};
goog.dom.getDocumentScrollElement = function() {
  return goog.dom.getDocumentScrollElement_(document)
};
goog.dom.getDocumentScrollElement_ = function(doc) {
  return!goog.userAgent.WEBKIT && goog.dom.isCss1CompatMode_(doc) ? doc.documentElement : doc.body
};
goog.dom.getWindow = function(opt_doc) {
  return opt_doc ? goog.dom.getWindow_(opt_doc) : window
};
goog.dom.getWindow_ = function(doc) {
  return doc.parentWindow || doc.defaultView
};
goog.dom.createDom = function(tagName, opt_attributes, var_args) {
  return goog.dom.createDom_(document, arguments)
};
goog.dom.createDom_ = function(doc, args) {
  var tagName = args[0];
  var attributes = args[1];
  if(!goog.dom.BrowserFeature.CAN_ADD_NAME_OR_TYPE_ATTRIBUTES && attributes && (attributes.name || attributes.type)) {
    var tagNameArr = ["<", tagName];
    if(attributes.name) {
      tagNameArr.push(' name="', goog.string.htmlEscape(attributes.name), '"')
    }
    if(attributes.type) {
      tagNameArr.push(' type="', goog.string.htmlEscape(attributes.type), '"');
      var clone = {};
      goog.object.extend(clone, attributes);
      attributes = clone;
      delete attributes.type
    }
    tagNameArr.push(">");
    tagName = tagNameArr.join("")
  }
  var element = doc.createElement(tagName);
  if(attributes) {
    if(goog.isString(attributes)) {
      element.className = attributes
    }else {
      if(goog.isArray(attributes)) {
        goog.dom.classes.add.apply(null, [element].concat(attributes))
      }else {
        goog.dom.setProperties(element, attributes)
      }
    }
  }
  if(args.length > 2) {
    goog.dom.append_(doc, element, args, 2)
  }
  return element
};
goog.dom.append_ = function(doc, parent, args, startIndex) {
  function childHandler(child) {
    if(child) {
      parent.appendChild(goog.isString(child) ? doc.createTextNode(child) : child)
    }
  }
  for(var i = startIndex;i < args.length;i++) {
    var arg = args[i];
    if(goog.isArrayLike(arg) && !goog.dom.isNodeLike(arg)) {
      goog.array.forEach(goog.dom.isNodeList(arg) ? goog.array.clone(arg) : arg, childHandler)
    }else {
      childHandler(arg)
    }
  }
};
goog.dom.$dom = goog.dom.createDom;
goog.dom.createElement = function(name) {
  return document.createElement(name)
};
goog.dom.createTextNode = function(content) {
  return document.createTextNode(content)
};
goog.dom.createTable = function(rows, columns, opt_fillWithNbsp) {
  return goog.dom.createTable_(document, rows, columns, !!opt_fillWithNbsp)
};
goog.dom.createTable_ = function(doc, rows, columns, fillWithNbsp) {
  var rowHtml = ["<tr>"];
  for(var i = 0;i < columns;i++) {
    rowHtml.push(fillWithNbsp ? "<td>&nbsp;</td>" : "<td></td>")
  }
  rowHtml.push("</tr>");
  rowHtml = rowHtml.join("");
  var totalHtml = ["<table>"];
  for(i = 0;i < rows;i++) {
    totalHtml.push(rowHtml)
  }
  totalHtml.push("</table>");
  var elem = doc.createElement(goog.dom.TagName.DIV);
  elem.innerHTML = totalHtml.join("");
  return elem.removeChild(elem.firstChild)
};
goog.dom.htmlToDocumentFragment = function(htmlString) {
  return goog.dom.htmlToDocumentFragment_(document, htmlString)
};
goog.dom.htmlToDocumentFragment_ = function(doc, htmlString) {
  var tempDiv = doc.createElement("div");
  if(goog.dom.BrowserFeature.INNER_HTML_NEEDS_SCOPED_ELEMENT) {
    tempDiv.innerHTML = "<br>" + htmlString;
    tempDiv.removeChild(tempDiv.firstChild)
  }else {
    tempDiv.innerHTML = htmlString
  }
  if(tempDiv.childNodes.length == 1) {
    return tempDiv.removeChild(tempDiv.firstChild)
  }else {
    var fragment = doc.createDocumentFragment();
    while(tempDiv.firstChild) {
      fragment.appendChild(tempDiv.firstChild)
    }
    return fragment
  }
};
goog.dom.getCompatMode = function() {
  return goog.dom.isCss1CompatMode() ? "CSS1Compat" : "BackCompat"
};
goog.dom.isCss1CompatMode = function() {
  return goog.dom.isCss1CompatMode_(document)
};
goog.dom.isCss1CompatMode_ = function(doc) {
  if(goog.dom.COMPAT_MODE_KNOWN_) {
    return goog.dom.ASSUME_STANDARDS_MODE
  }
  return doc.compatMode == "CSS1Compat"
};
goog.dom.canHaveChildren = function(node) {
  if(node.nodeType != goog.dom.NodeType.ELEMENT) {
    return false
  }
  switch(node.tagName) {
    case goog.dom.TagName.APPLET:
    ;
    case goog.dom.TagName.AREA:
    ;
    case goog.dom.TagName.BASE:
    ;
    case goog.dom.TagName.BR:
    ;
    case goog.dom.TagName.COL:
    ;
    case goog.dom.TagName.FRAME:
    ;
    case goog.dom.TagName.HR:
    ;
    case goog.dom.TagName.IMG:
    ;
    case goog.dom.TagName.INPUT:
    ;
    case goog.dom.TagName.IFRAME:
    ;
    case goog.dom.TagName.ISINDEX:
    ;
    case goog.dom.TagName.LINK:
    ;
    case goog.dom.TagName.NOFRAMES:
    ;
    case goog.dom.TagName.NOSCRIPT:
    ;
    case goog.dom.TagName.META:
    ;
    case goog.dom.TagName.OBJECT:
    ;
    case goog.dom.TagName.PARAM:
    ;
    case goog.dom.TagName.SCRIPT:
    ;
    case goog.dom.TagName.STYLE:
      return false
  }
  return true
};
goog.dom.appendChild = function(parent, child) {
  parent.appendChild(child)
};
goog.dom.append = function(parent, var_args) {
  goog.dom.append_(goog.dom.getOwnerDocument(parent), parent, arguments, 1)
};
goog.dom.removeChildren = function(node) {
  var child;
  while(child = node.firstChild) {
    node.removeChild(child)
  }
};
goog.dom.insertSiblingBefore = function(newNode, refNode) {
  if(refNode.parentNode) {
    refNode.parentNode.insertBefore(newNode, refNode)
  }
};
goog.dom.insertSiblingAfter = function(newNode, refNode) {
  if(refNode.parentNode) {
    refNode.parentNode.insertBefore(newNode, refNode.nextSibling)
  }
};
goog.dom.insertChildAt = function(parent, child, index) {
  parent.insertBefore(child, parent.childNodes[index] || null)
};
goog.dom.removeNode = function(node) {
  return node && node.parentNode ? node.parentNode.removeChild(node) : null
};
goog.dom.replaceNode = function(newNode, oldNode) {
  var parent = oldNode.parentNode;
  if(parent) {
    parent.replaceChild(newNode, oldNode)
  }
};
goog.dom.flattenElement = function(element) {
  var child, parent = element.parentNode;
  if(parent && parent.nodeType != goog.dom.NodeType.DOCUMENT_FRAGMENT) {
    if(element.removeNode) {
      return element.removeNode(false)
    }else {
      while(child = element.firstChild) {
        parent.insertBefore(child, element)
      }
      return goog.dom.removeNode(element)
    }
  }
};
goog.dom.getChildren = function(element) {
  if(goog.dom.BrowserFeature.CAN_USE_CHILDREN_ATTRIBUTE && element.children != undefined) {
    return element.children
  }
  return goog.array.filter(element.childNodes, function(node) {
    return node.nodeType == goog.dom.NodeType.ELEMENT
  })
};
goog.dom.getFirstElementChild = function(node) {
  if(node.firstElementChild != undefined) {
    return node.firstElementChild
  }
  return goog.dom.getNextElementNode_(node.firstChild, true)
};
goog.dom.getLastElementChild = function(node) {
  if(node.lastElementChild != undefined) {
    return node.lastElementChild
  }
  return goog.dom.getNextElementNode_(node.lastChild, false)
};
goog.dom.getNextElementSibling = function(node) {
  if(node.nextElementSibling != undefined) {
    return node.nextElementSibling
  }
  return goog.dom.getNextElementNode_(node.nextSibling, true)
};
goog.dom.getPreviousElementSibling = function(node) {
  if(node.previousElementSibling != undefined) {
    return node.previousElementSibling
  }
  return goog.dom.getNextElementNode_(node.previousSibling, false)
};
goog.dom.getNextElementNode_ = function(node, forward) {
  while(node && node.nodeType != goog.dom.NodeType.ELEMENT) {
    node = forward ? node.nextSibling : node.previousSibling
  }
  return node
};
goog.dom.getNextNode = function(node) {
  if(!node) {
    return null
  }
  if(node.firstChild) {
    return node.firstChild
  }
  while(node && !node.nextSibling) {
    node = node.parentNode
  }
  return node ? node.nextSibling : null
};
goog.dom.getPreviousNode = function(node) {
  if(!node) {
    return null
  }
  if(!node.previousSibling) {
    return node.parentNode
  }
  node = node.previousSibling;
  while(node && node.lastChild) {
    node = node.lastChild
  }
  return node
};
goog.dom.isNodeLike = function(obj) {
  return goog.isObject(obj) && obj.nodeType > 0
};
goog.dom.isElement = function(obj) {
  return goog.isObject(obj) && obj.nodeType == goog.dom.NodeType.ELEMENT
};
goog.dom.isWindow = function(obj) {
  return goog.isObject(obj) && obj["window"] == obj
};
goog.dom.contains = function(parent, descendant) {
  if(parent.contains && descendant.nodeType == goog.dom.NodeType.ELEMENT) {
    return parent == descendant || parent.contains(descendant)
  }
  if(typeof parent.compareDocumentPosition != "undefined") {
    return parent == descendant || Boolean(parent.compareDocumentPosition(descendant) & 16)
  }
  while(descendant && parent != descendant) {
    descendant = descendant.parentNode
  }
  return descendant == parent
};
goog.dom.compareNodeOrder = function(node1, node2) {
  if(node1 == node2) {
    return 0
  }
  if(node1.compareDocumentPosition) {
    return node1.compareDocumentPosition(node2) & 2 ? 1 : -1
  }
  if("sourceIndex" in node1 || node1.parentNode && "sourceIndex" in node1.parentNode) {
    var isElement1 = node1.nodeType == goog.dom.NodeType.ELEMENT;
    var isElement2 = node2.nodeType == goog.dom.NodeType.ELEMENT;
    if(isElement1 && isElement2) {
      return node1.sourceIndex - node2.sourceIndex
    }else {
      var parent1 = node1.parentNode;
      var parent2 = node2.parentNode;
      if(parent1 == parent2) {
        return goog.dom.compareSiblingOrder_(node1, node2)
      }
      if(!isElement1 && goog.dom.contains(parent1, node2)) {
        return-1 * goog.dom.compareParentsDescendantNodeIe_(node1, node2)
      }
      if(!isElement2 && goog.dom.contains(parent2, node1)) {
        return goog.dom.compareParentsDescendantNodeIe_(node2, node1)
      }
      return(isElement1 ? node1.sourceIndex : parent1.sourceIndex) - (isElement2 ? node2.sourceIndex : parent2.sourceIndex)
    }
  }
  var doc = goog.dom.getOwnerDocument(node1);
  var range1, range2;
  range1 = doc.createRange();
  range1.selectNode(node1);
  range1.collapse(true);
  range2 = doc.createRange();
  range2.selectNode(node2);
  range2.collapse(true);
  return range1.compareBoundaryPoints(goog.global["Range"].START_TO_END, range2)
};
goog.dom.compareParentsDescendantNodeIe_ = function(textNode, node) {
  var parent = textNode.parentNode;
  if(parent == node) {
    return-1
  }
  var sibling = node;
  while(sibling.parentNode != parent) {
    sibling = sibling.parentNode
  }
  return goog.dom.compareSiblingOrder_(sibling, textNode)
};
goog.dom.compareSiblingOrder_ = function(node1, node2) {
  var s = node2;
  while(s = s.previousSibling) {
    if(s == node1) {
      return-1
    }
  }
  return 1
};
goog.dom.findCommonAncestor = function(var_args) {
  var i, count = arguments.length;
  if(!count) {
    return null
  }else {
    if(count == 1) {
      return arguments[0]
    }
  }
  var paths = [];
  var minLength = Infinity;
  for(i = 0;i < count;i++) {
    var ancestors = [];
    var node = arguments[i];
    while(node) {
      ancestors.unshift(node);
      node = node.parentNode
    }
    paths.push(ancestors);
    minLength = Math.min(minLength, ancestors.length)
  }
  var output = null;
  for(i = 0;i < minLength;i++) {
    var first = paths[0][i];
    for(var j = 1;j < count;j++) {
      if(first != paths[j][i]) {
        return output
      }
    }
    output = first
  }
  return output
};
goog.dom.getOwnerDocument = function(node) {
  return node.nodeType == goog.dom.NodeType.DOCUMENT ? node : node.ownerDocument || node.document
};
goog.dom.getFrameContentDocument = function(frame) {
  var doc = frame.contentDocument || frame.contentWindow.document;
  return doc
};
goog.dom.getFrameContentWindow = function(frame) {
  return frame.contentWindow || goog.dom.getWindow_(goog.dom.getFrameContentDocument(frame))
};
goog.dom.setTextContent = function(element, text) {
  if("textContent" in element) {
    element.textContent = text
  }else {
    if(element.firstChild && element.firstChild.nodeType == goog.dom.NodeType.TEXT) {
      while(element.lastChild != element.firstChild) {
        element.removeChild(element.lastChild)
      }
      element.firstChild.data = text
    }else {
      goog.dom.removeChildren(element);
      var doc = goog.dom.getOwnerDocument(element);
      element.appendChild(doc.createTextNode(text))
    }
  }
};
goog.dom.getOuterHtml = function(element) {
  if("outerHTML" in element) {
    return element.outerHTML
  }else {
    var doc = goog.dom.getOwnerDocument(element);
    var div = doc.createElement("div");
    div.appendChild(element.cloneNode(true));
    return div.innerHTML
  }
};
goog.dom.findNode = function(root, p) {
  var rv = [];
  var found = goog.dom.findNodes_(root, p, rv, true);
  return found ? rv[0] : undefined
};
goog.dom.findNodes = function(root, p) {
  var rv = [];
  goog.dom.findNodes_(root, p, rv, false);
  return rv
};
goog.dom.findNodes_ = function(root, p, rv, findOne) {
  if(root != null) {
    var child = root.firstChild;
    while(child) {
      if(p(child)) {
        rv.push(child);
        if(findOne) {
          return true
        }
      }
      if(goog.dom.findNodes_(child, p, rv, findOne)) {
        return true
      }
      child = child.nextSibling
    }
  }
  return false
};
goog.dom.TAGS_TO_IGNORE_ = {"SCRIPT":1, "STYLE":1, "HEAD":1, "IFRAME":1, "OBJECT":1};
goog.dom.PREDEFINED_TAG_VALUES_ = {"IMG":" ", "BR":"\n"};
goog.dom.isFocusableTabIndex = function(element) {
  var attrNode = element.getAttributeNode("tabindex");
  if(attrNode && attrNode.specified) {
    var index = element.tabIndex;
    return goog.isNumber(index) && index >= 0 && index < 32768
  }
  return false
};
goog.dom.setFocusableTabIndex = function(element, enable) {
  if(enable) {
    element.tabIndex = 0
  }else {
    element.tabIndex = -1;
    element.removeAttribute("tabIndex")
  }
};
goog.dom.getTextContent = function(node) {
  var textContent;
  if(goog.dom.BrowserFeature.CAN_USE_INNER_TEXT && "innerText" in node) {
    textContent = goog.string.canonicalizeNewlines(node.innerText)
  }else {
    var buf = [];
    goog.dom.getTextContent_(node, buf, true);
    textContent = buf.join("")
  }
  textContent = textContent.replace(/ \xAD /g, " ").replace(/\xAD/g, "");
  textContent = textContent.replace(/\u200B/g, "");
  if(!goog.dom.BrowserFeature.CAN_USE_INNER_TEXT) {
    textContent = textContent.replace(/ +/g, " ")
  }
  if(textContent != " ") {
    textContent = textContent.replace(/^\s*/, "")
  }
  return textContent
};
goog.dom.getRawTextContent = function(node) {
  var buf = [];
  goog.dom.getTextContent_(node, buf, false);
  return buf.join("")
};
goog.dom.getTextContent_ = function(node, buf, normalizeWhitespace) {
  if(node.nodeName in goog.dom.TAGS_TO_IGNORE_) {
  }else {
    if(node.nodeType == goog.dom.NodeType.TEXT) {
      if(normalizeWhitespace) {
        buf.push(String(node.nodeValue).replace(/(\r\n|\r|\n)/g, ""))
      }else {
        buf.push(node.nodeValue)
      }
    }else {
      if(node.nodeName in goog.dom.PREDEFINED_TAG_VALUES_) {
        buf.push(goog.dom.PREDEFINED_TAG_VALUES_[node.nodeName])
      }else {
        var child = node.firstChild;
        while(child) {
          goog.dom.getTextContent_(child, buf, normalizeWhitespace);
          child = child.nextSibling
        }
      }
    }
  }
};
goog.dom.getNodeTextLength = function(node) {
  return goog.dom.getTextContent(node).length
};
goog.dom.getNodeTextOffset = function(node, opt_offsetParent) {
  var root = opt_offsetParent || goog.dom.getOwnerDocument(node).body;
  var buf = [];
  while(node && node != root) {
    var cur = node;
    while(cur = cur.previousSibling) {
      buf.unshift(goog.dom.getTextContent(cur))
    }
    node = node.parentNode
  }
  return goog.string.trimLeft(buf.join("")).replace(/ +/g, " ").length
};
goog.dom.getNodeAtOffset = function(parent, offset, opt_result) {
  var stack = [parent], pos = 0, cur;
  while(stack.length > 0 && pos < offset) {
    cur = stack.pop();
    if(cur.nodeName in goog.dom.TAGS_TO_IGNORE_) {
    }else {
      if(cur.nodeType == goog.dom.NodeType.TEXT) {
        var text = cur.nodeValue.replace(/(\r\n|\r|\n)/g, "").replace(/ +/g, " ");
        pos += text.length
      }else {
        if(cur.nodeName in goog.dom.PREDEFINED_TAG_VALUES_) {
          pos += goog.dom.PREDEFINED_TAG_VALUES_[cur.nodeName].length
        }else {
          for(var i = cur.childNodes.length - 1;i >= 0;i--) {
            stack.push(cur.childNodes[i])
          }
        }
      }
    }
  }
  if(goog.isObject(opt_result)) {
    opt_result.remainder = cur ? cur.nodeValue.length + offset - pos - 1 : 0;
    opt_result.node = cur
  }
  return cur
};
goog.dom.isNodeList = function(val) {
  if(val && typeof val.length == "number") {
    if(goog.isObject(val)) {
      return typeof val.item == "function" || typeof val.item == "string"
    }else {
      if(goog.isFunction(val)) {
        return typeof val.item == "function"
      }
    }
  }
  return false
};
goog.dom.getAncestorByTagNameAndClass = function(element, opt_tag, opt_class) {
  var tagName = opt_tag ? opt_tag.toUpperCase() : null;
  return goog.dom.getAncestor(element, function(node) {
    return(!tagName || node.nodeName == tagName) && (!opt_class || goog.dom.classes.has(node, opt_class))
  }, true)
};
goog.dom.getAncestorByClass = function(element, opt_class) {
  return goog.dom.getAncestorByTagNameAndClass(element, null, opt_class)
};
goog.dom.getAncestor = function(element, matcher, opt_includeNode, opt_maxSearchSteps) {
  if(!opt_includeNode) {
    element = element.parentNode
  }
  var ignoreSearchSteps = opt_maxSearchSteps == null;
  var steps = 0;
  while(element && (ignoreSearchSteps || steps <= opt_maxSearchSteps)) {
    if(matcher(element)) {
      return element
    }
    element = element.parentNode;
    steps++
  }
  return null
};
goog.dom.getActiveElement = function(doc) {
  try {
    return doc && doc.activeElement
  }catch(e) {
  }
  return null
};
goog.dom.DomHelper = function(opt_document) {
  this.document_ = opt_document || goog.global.document || document
};
goog.dom.DomHelper.prototype.getDomHelper = goog.dom.getDomHelper;
goog.dom.DomHelper.prototype.setDocument = function(document) {
  this.document_ = document
};
goog.dom.DomHelper.prototype.getDocument = function() {
  return this.document_
};
goog.dom.DomHelper.prototype.getElement = function(element) {
  if(goog.isString(element)) {
    return this.document_.getElementById(element)
  }else {
    return element
  }
};
goog.dom.DomHelper.prototype.$ = goog.dom.DomHelper.prototype.getElement;
goog.dom.DomHelper.prototype.getElementsByTagNameAndClass = function(opt_tag, opt_class, opt_el) {
  return goog.dom.getElementsByTagNameAndClass_(this.document_, opt_tag, opt_class, opt_el)
};
goog.dom.DomHelper.prototype.getElementsByClass = function(className, opt_el) {
  var doc = opt_el || this.document_;
  return goog.dom.getElementsByClass(className, doc)
};
goog.dom.DomHelper.prototype.getElementByClass = function(className, opt_el) {
  var doc = opt_el || this.document_;
  return goog.dom.getElementByClass(className, doc)
};
goog.dom.DomHelper.prototype.$$ = goog.dom.DomHelper.prototype.getElementsByTagNameAndClass;
goog.dom.DomHelper.prototype.setProperties = goog.dom.setProperties;
goog.dom.DomHelper.prototype.getViewportSize = function(opt_window) {
  return goog.dom.getViewportSize(opt_window || this.getWindow())
};
goog.dom.DomHelper.prototype.getDocumentHeight = function() {
  return goog.dom.getDocumentHeight_(this.getWindow())
};
goog.dom.Appendable;
goog.dom.DomHelper.prototype.createDom = function(tagName, opt_attributes, var_args) {
  return goog.dom.createDom_(this.document_, arguments)
};
goog.dom.DomHelper.prototype.$dom = goog.dom.DomHelper.prototype.createDom;
goog.dom.DomHelper.prototype.createElement = function(name) {
  return this.document_.createElement(name)
};
goog.dom.DomHelper.prototype.createTextNode = function(content) {
  return this.document_.createTextNode(content)
};
goog.dom.DomHelper.prototype.createTable = function(rows, columns, opt_fillWithNbsp) {
  return goog.dom.createTable_(this.document_, rows, columns, !!opt_fillWithNbsp)
};
goog.dom.DomHelper.prototype.htmlToDocumentFragment = function(htmlString) {
  return goog.dom.htmlToDocumentFragment_(this.document_, htmlString)
};
goog.dom.DomHelper.prototype.getCompatMode = function() {
  return this.isCss1CompatMode() ? "CSS1Compat" : "BackCompat"
};
goog.dom.DomHelper.prototype.isCss1CompatMode = function() {
  return goog.dom.isCss1CompatMode_(this.document_)
};
goog.dom.DomHelper.prototype.getWindow = function() {
  return goog.dom.getWindow_(this.document_)
};
goog.dom.DomHelper.prototype.getDocumentScrollElement = function() {
  return goog.dom.getDocumentScrollElement_(this.document_)
};
goog.dom.DomHelper.prototype.getDocumentScroll = function() {
  return goog.dom.getDocumentScroll_(this.document_)
};
goog.dom.DomHelper.prototype.appendChild = goog.dom.appendChild;
goog.dom.DomHelper.prototype.append = goog.dom.append;
goog.dom.DomHelper.prototype.removeChildren = goog.dom.removeChildren;
goog.dom.DomHelper.prototype.insertSiblingBefore = goog.dom.insertSiblingBefore;
goog.dom.DomHelper.prototype.insertSiblingAfter = goog.dom.insertSiblingAfter;
goog.dom.DomHelper.prototype.removeNode = goog.dom.removeNode;
goog.dom.DomHelper.prototype.replaceNode = goog.dom.replaceNode;
goog.dom.DomHelper.prototype.flattenElement = goog.dom.flattenElement;
goog.dom.DomHelper.prototype.getFirstElementChild = goog.dom.getFirstElementChild;
goog.dom.DomHelper.prototype.getLastElementChild = goog.dom.getLastElementChild;
goog.dom.DomHelper.prototype.getNextElementSibling = goog.dom.getNextElementSibling;
goog.dom.DomHelper.prototype.getPreviousElementSibling = goog.dom.getPreviousElementSibling;
goog.dom.DomHelper.prototype.getNextNode = goog.dom.getNextNode;
goog.dom.DomHelper.prototype.getPreviousNode = goog.dom.getPreviousNode;
goog.dom.DomHelper.prototype.isNodeLike = goog.dom.isNodeLike;
goog.dom.DomHelper.prototype.contains = goog.dom.contains;
goog.dom.DomHelper.prototype.getOwnerDocument = goog.dom.getOwnerDocument;
goog.dom.DomHelper.prototype.getFrameContentDocument = goog.dom.getFrameContentDocument;
goog.dom.DomHelper.prototype.getFrameContentWindow = goog.dom.getFrameContentWindow;
goog.dom.DomHelper.prototype.setTextContent = goog.dom.setTextContent;
goog.dom.DomHelper.prototype.findNode = goog.dom.findNode;
goog.dom.DomHelper.prototype.findNodes = goog.dom.findNodes;
goog.dom.DomHelper.prototype.getTextContent = goog.dom.getTextContent;
goog.dom.DomHelper.prototype.getNodeTextLength = goog.dom.getNodeTextLength;
goog.dom.DomHelper.prototype.getNodeTextOffset = goog.dom.getNodeTextOffset;
goog.dom.DomHelper.prototype.getAncestorByTagNameAndClass = goog.dom.getAncestorByTagNameAndClass;
goog.dom.DomHelper.prototype.getAncestorByClass = goog.dom.getAncestorByClass;
goog.dom.DomHelper.prototype.getAncestor = goog.dom.getAncestor;
goog.provide("goog.math.Box");
goog.require("goog.math.Coordinate");
goog.math.Box = function(top, right, bottom, left) {
  this.top = top;
  this.right = right;
  this.bottom = bottom;
  this.left = left
};
goog.math.Box.boundingBox = function(var_args) {
  var box = new goog.math.Box(arguments[0].y, arguments[0].x, arguments[0].y, arguments[0].x);
  for(var i = 1;i < arguments.length;i++) {
    var coord = arguments[i];
    box.top = Math.min(box.top, coord.y);
    box.right = Math.max(box.right, coord.x);
    box.bottom = Math.max(box.bottom, coord.y);
    box.left = Math.min(box.left, coord.x)
  }
  return box
};
goog.math.Box.prototype.clone = function() {
  return new goog.math.Box(this.top, this.right, this.bottom, this.left)
};
if(goog.DEBUG) {
  goog.math.Box.prototype.toString = function() {
    return"(" + this.top + "t, " + this.right + "r, " + this.bottom + "b, " + this.left + "l)"
  }
}
goog.math.Box.prototype.contains = function(other) {
  return goog.math.Box.contains(this, other)
};
goog.math.Box.prototype.expand = function(top, opt_right, opt_bottom, opt_left) {
  if(goog.isObject(top)) {
    this.top -= top.top;
    this.right += top.right;
    this.bottom += top.bottom;
    this.left -= top.left
  }else {
    this.top -= top;
    this.right += opt_right;
    this.bottom += opt_bottom;
    this.left -= opt_left
  }
  return this
};
goog.math.Box.prototype.expandToInclude = function(box) {
  this.left = Math.min(this.left, box.left);
  this.top = Math.min(this.top, box.top);
  this.right = Math.max(this.right, box.right);
  this.bottom = Math.max(this.bottom, box.bottom)
};
goog.math.Box.equals = function(a, b) {
  if(a == b) {
    return true
  }
  if(!a || !b) {
    return false
  }
  return a.top == b.top && a.right == b.right && a.bottom == b.bottom && a.left == b.left
};
goog.math.Box.contains = function(box, other) {
  if(!box || !other) {
    return false
  }
  if(other instanceof goog.math.Box) {
    return other.left >= box.left && other.right <= box.right && other.top >= box.top && other.bottom <= box.bottom
  }
  return other.x >= box.left && other.x <= box.right && other.y >= box.top && other.y <= box.bottom
};
goog.math.Box.distance = function(box, coord) {
  if(coord.x >= box.left && coord.x <= box.right) {
    if(coord.y >= box.top && coord.y <= box.bottom) {
      return 0
    }
    return coord.y < box.top ? box.top - coord.y : coord.y - box.bottom
  }
  if(coord.y >= box.top && coord.y <= box.bottom) {
    return coord.x < box.left ? box.left - coord.x : coord.x - box.right
  }
  return goog.math.Coordinate.distance(coord, new goog.math.Coordinate(coord.x < box.left ? box.left : box.right, coord.y < box.top ? box.top : box.bottom))
};
goog.math.Box.intersects = function(a, b) {
  return a.left <= b.right && b.left <= a.right && a.top <= b.bottom && b.top <= a.bottom
};
goog.math.Box.intersectsWithPadding = function(a, b, padding) {
  return a.left <= b.right + padding && b.left <= a.right + padding && a.top <= b.bottom + padding && b.top <= a.bottom + padding
};
goog.provide("goog.math.Rect");
goog.require("goog.math.Box");
goog.require("goog.math.Size");
goog.math.Rect = function(x, y, w, h) {
  this.left = x;
  this.top = y;
  this.width = w;
  this.height = h
};
goog.math.Rect.prototype.clone = function() {
  return new goog.math.Rect(this.left, this.top, this.width, this.height)
};
goog.math.Rect.prototype.toBox = function() {
  var right = this.left + this.width;
  var bottom = this.top + this.height;
  return new goog.math.Box(this.top, right, bottom, this.left)
};
goog.math.Rect.createFromBox = function(box) {
  return new goog.math.Rect(box.left, box.top, box.right - box.left, box.bottom - box.top)
};
if(goog.DEBUG) {
  goog.math.Rect.prototype.toString = function() {
    return"(" + this.left + ", " + this.top + " - " + this.width + "w x " + this.height + "h)"
  }
}
goog.math.Rect.equals = function(a, b) {
  if(a == b) {
    return true
  }
  if(!a || !b) {
    return false
  }
  return a.left == b.left && a.width == b.width && a.top == b.top && a.height == b.height
};
goog.math.Rect.prototype.intersection = function(rect) {
  var x0 = Math.max(this.left, rect.left);
  var x1 = Math.min(this.left + this.width, rect.left + rect.width);
  if(x0 <= x1) {
    var y0 = Math.max(this.top, rect.top);
    var y1 = Math.min(this.top + this.height, rect.top + rect.height);
    if(y0 <= y1) {
      this.left = x0;
      this.top = y0;
      this.width = x1 - x0;
      this.height = y1 - y0;
      return true
    }
  }
  return false
};
goog.math.Rect.intersection = function(a, b) {
  var x0 = Math.max(a.left, b.left);
  var x1 = Math.min(a.left + a.width, b.left + b.width);
  if(x0 <= x1) {
    var y0 = Math.max(a.top, b.top);
    var y1 = Math.min(a.top + a.height, b.top + b.height);
    if(y0 <= y1) {
      return new goog.math.Rect(x0, y0, x1 - x0, y1 - y0)
    }
  }
  return null
};
goog.math.Rect.intersects = function(a, b) {
  return a.left <= b.left + b.width && b.left <= a.left + a.width && a.top <= b.top + b.height && b.top <= a.top + a.height
};
goog.math.Rect.prototype.intersects = function(rect) {
  return goog.math.Rect.intersects(this, rect)
};
goog.math.Rect.difference = function(a, b) {
  var intersection = goog.math.Rect.intersection(a, b);
  if(!intersection || !intersection.height || !intersection.width) {
    return[a.clone()]
  }
  var result = [];
  var top = a.top;
  var height = a.height;
  var ar = a.left + a.width;
  var ab = a.top + a.height;
  var br = b.left + b.width;
  var bb = b.top + b.height;
  if(b.top > a.top) {
    result.push(new goog.math.Rect(a.left, a.top, a.width, b.top - a.top));
    top = b.top;
    height -= b.top - a.top
  }
  if(bb < ab) {
    result.push(new goog.math.Rect(a.left, bb, a.width, ab - bb));
    height = bb - top
  }
  if(b.left > a.left) {
    result.push(new goog.math.Rect(a.left, top, b.left - a.left, height))
  }
  if(br < ar) {
    result.push(new goog.math.Rect(br, top, ar - br, height))
  }
  return result
};
goog.math.Rect.prototype.difference = function(rect) {
  return goog.math.Rect.difference(this, rect)
};
goog.math.Rect.prototype.boundingRect = function(rect) {
  var right = Math.max(this.left + this.width, rect.left + rect.width);
  var bottom = Math.max(this.top + this.height, rect.top + rect.height);
  this.left = Math.min(this.left, rect.left);
  this.top = Math.min(this.top, rect.top);
  this.width = right - this.left;
  this.height = bottom - this.top
};
goog.math.Rect.boundingRect = function(a, b) {
  if(!a || !b) {
    return null
  }
  var clone = a.clone();
  clone.boundingRect(b);
  return clone
};
goog.math.Rect.prototype.contains = function(another) {
  if(another instanceof goog.math.Rect) {
    return this.left <= another.left && this.left + this.width >= another.left + another.width && this.top <= another.top && this.top + this.height >= another.top + another.height
  }else {
    return another.x >= this.left && another.x <= this.left + this.width && another.y >= this.top && another.y <= this.top + this.height
  }
};
goog.math.Rect.prototype.getSize = function() {
  return new goog.math.Size(this.width, this.height)
};
goog.provide("goog.style");
goog.require("goog.array");
goog.require("goog.dom");
goog.require("goog.math.Box");
goog.require("goog.math.Coordinate");
goog.require("goog.math.Rect");
goog.require("goog.math.Size");
goog.require("goog.object");
goog.require("goog.string");
goog.require("goog.userAgent");
goog.style.setStyle = function(element, style, opt_value) {
  if(goog.isString(style)) {
    goog.style.setStyle_(element, opt_value, style)
  }else {
    goog.object.forEach(style, goog.partial(goog.style.setStyle_, element))
  }
};
goog.style.setStyle_ = function(element, value, style) {
  element.style[goog.string.toCamelCase(style)] = value
};
goog.style.getStyle = function(element, property) {
  return element.style[goog.string.toCamelCase(property)] || ""
};
goog.style.getComputedStyle = function(element, property) {
  var doc = goog.dom.getOwnerDocument(element);
  if(doc.defaultView && doc.defaultView.getComputedStyle) {
    var styles = doc.defaultView.getComputedStyle(element, null);
    if(styles) {
      return styles[property] || styles.getPropertyValue(property)
    }
  }
  return""
};
goog.style.getCascadedStyle = function(element, style) {
  return element.currentStyle ? element.currentStyle[style] : null
};
goog.style.getStyle_ = function(element, style) {
  return goog.style.getComputedStyle(element, style) || goog.style.getCascadedStyle(element, style) || element.style[style]
};
goog.style.getComputedPosition = function(element) {
  return goog.style.getStyle_(element, "position")
};
goog.style.getBackgroundColor = function(element) {
  return goog.style.getStyle_(element, "backgroundColor")
};
goog.style.getComputedOverflowX = function(element) {
  return goog.style.getStyle_(element, "overflowX")
};
goog.style.getComputedOverflowY = function(element) {
  return goog.style.getStyle_(element, "overflowY")
};
goog.style.getComputedZIndex = function(element) {
  return goog.style.getStyle_(element, "zIndex")
};
goog.style.getComputedTextAlign = function(element) {
  return goog.style.getStyle_(element, "textAlign")
};
goog.style.getComputedCursor = function(element) {
  return goog.style.getStyle_(element, "cursor")
};
goog.style.setPosition = function(el, arg1, opt_arg2) {
  var x, y;
  var buggyGeckoSubPixelPos = goog.userAgent.GECKO && (goog.userAgent.MAC || goog.userAgent.X11) && goog.userAgent.isVersion("1.9");
  if(arg1 instanceof goog.math.Coordinate) {
    x = arg1.x;
    y = arg1.y
  }else {
    x = arg1;
    y = opt_arg2
  }
  el.style.left = goog.style.getPixelStyleValue_(x, buggyGeckoSubPixelPos);
  el.style.top = goog.style.getPixelStyleValue_(y, buggyGeckoSubPixelPos)
};
goog.style.getPosition = function(element) {
  return new goog.math.Coordinate(element.offsetLeft, element.offsetTop)
};
goog.style.getClientViewportElement = function(opt_node) {
  var doc;
  if(opt_node) {
    if(opt_node.nodeType == goog.dom.NodeType.DOCUMENT) {
      doc = opt_node
    }else {
      doc = goog.dom.getOwnerDocument(opt_node)
    }
  }else {
    doc = goog.dom.getDocument()
  }
  if(goog.userAgent.IE && !goog.userAgent.isDocumentMode(9) && !goog.dom.getDomHelper(doc).isCss1CompatMode()) {
    return doc.body
  }
  return doc.documentElement
};
goog.style.getBoundingClientRect_ = function(el) {
  var rect = el.getBoundingClientRect();
  if(goog.userAgent.IE) {
    var doc = el.ownerDocument;
    rect.left -= doc.documentElement.clientLeft + doc.body.clientLeft;
    rect.top -= doc.documentElement.clientTop + doc.body.clientTop
  }
  return rect
};
goog.style.getOffsetParent = function(element) {
  if(goog.userAgent.IE) {
    return element.offsetParent
  }
  var doc = goog.dom.getOwnerDocument(element);
  var positionStyle = goog.style.getStyle_(element, "position");
  var skipStatic = positionStyle == "fixed" || positionStyle == "absolute";
  for(var parent = element.parentNode;parent && parent != doc;parent = parent.parentNode) {
    positionStyle = goog.style.getStyle_(parent, "position");
    skipStatic = skipStatic && positionStyle == "static" && parent != doc.documentElement && parent != doc.body;
    if(!skipStatic && (parent.scrollWidth > parent.clientWidth || parent.scrollHeight > parent.clientHeight || positionStyle == "fixed" || positionStyle == "absolute" || positionStyle == "relative")) {
      return parent
    }
  }
  return null
};
goog.style.getVisibleRectForElement = function(element) {
  var visibleRect = new goog.math.Box(0, Infinity, Infinity, 0);
  var dom = goog.dom.getDomHelper(element);
  var body = dom.getDocument().body;
  var documentElement = dom.getDocument().documentElement;
  var scrollEl = dom.getDocumentScrollElement();
  for(var el = element;el = goog.style.getOffsetParent(el);) {
    if((!goog.userAgent.IE || el.clientWidth != 0) && (!goog.userAgent.WEBKIT || el.clientHeight != 0 || el != body) && el != body && el != documentElement && goog.style.getStyle_(el, "overflow") != "visible") {
      var pos = goog.style.getPageOffset(el);
      var client = goog.style.getClientLeftTop(el);
      pos.x += client.x;
      pos.y += client.y;
      visibleRect.top = Math.max(visibleRect.top, pos.y);
      visibleRect.right = Math.min(visibleRect.right, pos.x + el.clientWidth);
      visibleRect.bottom = Math.min(visibleRect.bottom, pos.y + el.clientHeight);
      visibleRect.left = Math.max(visibleRect.left, pos.x)
    }
  }
  var scrollX = scrollEl.scrollLeft, scrollY = scrollEl.scrollTop;
  visibleRect.left = Math.max(visibleRect.left, scrollX);
  visibleRect.top = Math.max(visibleRect.top, scrollY);
  var winSize = dom.getViewportSize();
  visibleRect.right = Math.min(visibleRect.right, scrollX + winSize.width);
  visibleRect.bottom = Math.min(visibleRect.bottom, scrollY + winSize.height);
  return visibleRect.top >= 0 && visibleRect.left >= 0 && visibleRect.bottom > visibleRect.top && visibleRect.right > visibleRect.left ? visibleRect : null
};
goog.style.scrollIntoContainerView = function(element, container, opt_center) {
  var elementPos = goog.style.getPageOffset(element);
  var containerPos = goog.style.getPageOffset(container);
  var containerBorder = goog.style.getBorderBox(container);
  var relX = elementPos.x - containerPos.x - containerBorder.left;
  var relY = elementPos.y - containerPos.y - containerBorder.top;
  var spaceX = container.clientWidth - element.offsetWidth;
  var spaceY = container.clientHeight - element.offsetHeight;
  if(opt_center) {
    container.scrollLeft += relX - spaceX / 2;
    container.scrollTop += relY - spaceY / 2
  }else {
    container.scrollLeft += Math.min(relX, Math.max(relX - spaceX, 0));
    container.scrollTop += Math.min(relY, Math.max(relY - spaceY, 0))
  }
};
goog.style.getClientLeftTop = function(el) {
  if(goog.userAgent.GECKO && !goog.userAgent.isVersion("1.9")) {
    var left = parseFloat(goog.style.getComputedStyle(el, "borderLeftWidth"));
    if(goog.style.isRightToLeft(el)) {
      var scrollbarWidth = el.offsetWidth - el.clientWidth - left - parseFloat(goog.style.getComputedStyle(el, "borderRightWidth"));
      left += scrollbarWidth
    }
    return new goog.math.Coordinate(left, parseFloat(goog.style.getComputedStyle(el, "borderTopWidth")))
  }
  return new goog.math.Coordinate(el.clientLeft, el.clientTop)
};
goog.style.getPageOffset = function(el) {
  var box, doc = goog.dom.getOwnerDocument(el);
  var positionStyle = goog.style.getStyle_(el, "position");
  var BUGGY_GECKO_BOX_OBJECT = goog.userAgent.GECKO && doc.getBoxObjectFor && !el.getBoundingClientRect && positionStyle == "absolute" && (box = doc.getBoxObjectFor(el)) && (box.screenX < 0 || box.screenY < 0);
  var pos = new goog.math.Coordinate(0, 0);
  var viewportElement = goog.style.getClientViewportElement(doc);
  if(el == viewportElement) {
    return pos
  }
  if(el.getBoundingClientRect) {
    box = goog.style.getBoundingClientRect_(el);
    var scrollCoord = goog.dom.getDomHelper(doc).getDocumentScroll();
    pos.x = box.left + scrollCoord.x;
    pos.y = box.top + scrollCoord.y
  }else {
    if(doc.getBoxObjectFor && !BUGGY_GECKO_BOX_OBJECT) {
      box = doc.getBoxObjectFor(el);
      var vpBox = doc.getBoxObjectFor(viewportElement);
      pos.x = box.screenX - vpBox.screenX;
      pos.y = box.screenY - vpBox.screenY
    }else {
      var parent = el;
      do {
        pos.x += parent.offsetLeft;
        pos.y += parent.offsetTop;
        if(parent != el) {
          pos.x += parent.clientLeft || 0;
          pos.y += parent.clientTop || 0
        }
        if(goog.userAgent.WEBKIT && goog.style.getComputedPosition(parent) == "fixed") {
          pos.x += doc.body.scrollLeft;
          pos.y += doc.body.scrollTop;
          break
        }
        parent = parent.offsetParent
      }while(parent && parent != el);
      if(goog.userAgent.OPERA || goog.userAgent.WEBKIT && positionStyle == "absolute") {
        pos.y -= doc.body.offsetTop
      }
      for(parent = el;(parent = goog.style.getOffsetParent(parent)) && parent != doc.body && parent != viewportElement;) {
        pos.x -= parent.scrollLeft;
        if(!goog.userAgent.OPERA || parent.tagName != "TR") {
          pos.y -= parent.scrollTop
        }
      }
    }
  }
  return pos
};
goog.style.getPageOffsetLeft = function(el) {
  return goog.style.getPageOffset(el).x
};
goog.style.getPageOffsetTop = function(el) {
  return goog.style.getPageOffset(el).y
};
goog.style.getFramedPageOffset = function(el, relativeWin) {
  var position = new goog.math.Coordinate(0, 0);
  var currentWin = goog.dom.getWindow(goog.dom.getOwnerDocument(el));
  var currentEl = el;
  do {
    var offset = currentWin == relativeWin ? goog.style.getPageOffset(currentEl) : goog.style.getClientPosition(currentEl);
    position.x += offset.x;
    position.y += offset.y
  }while(currentWin && currentWin != relativeWin && (currentEl = currentWin.frameElement) && (currentWin = currentWin.parent));
  return position
};
goog.style.translateRectForAnotherFrame = function(rect, origBase, newBase) {
  if(origBase.getDocument() != newBase.getDocument()) {
    var body = origBase.getDocument().body;
    var pos = goog.style.getFramedPageOffset(body, newBase.getWindow());
    pos = goog.math.Coordinate.difference(pos, goog.style.getPageOffset(body));
    if(goog.userAgent.IE && !origBase.isCss1CompatMode()) {
      pos = goog.math.Coordinate.difference(pos, origBase.getDocumentScroll())
    }
    rect.left += pos.x;
    rect.top += pos.y
  }
};
goog.style.getRelativePosition = function(a, b) {
  var ap = goog.style.getClientPosition(a);
  var bp = goog.style.getClientPosition(b);
  return new goog.math.Coordinate(ap.x - bp.x, ap.y - bp.y)
};
goog.style.getClientPosition = function(el) {
  var pos = new goog.math.Coordinate;
  if(el.nodeType == goog.dom.NodeType.ELEMENT) {
    if(el.getBoundingClientRect) {
      var box = goog.style.getBoundingClientRect_(el);
      pos.x = box.left;
      pos.y = box.top
    }else {
      var scrollCoord = goog.dom.getDomHelper(el).getDocumentScroll();
      var pageCoord = goog.style.getPageOffset(el);
      pos.x = pageCoord.x - scrollCoord.x;
      pos.y = pageCoord.y - scrollCoord.y
    }
  }else {
    var isAbstractedEvent = goog.isFunction(el.getBrowserEvent);
    var targetEvent = el;
    if(el.targetTouches) {
      targetEvent = el.targetTouches[0]
    }else {
      if(isAbstractedEvent && el.getBrowserEvent().targetTouches) {
        targetEvent = el.getBrowserEvent().targetTouches[0]
      }
    }
    pos.x = targetEvent.clientX;
    pos.y = targetEvent.clientY
  }
  return pos
};
goog.style.setPageOffset = function(el, x, opt_y) {
  var cur = goog.style.getPageOffset(el);
  if(x instanceof goog.math.Coordinate) {
    opt_y = x.y;
    x = x.x
  }
  var dx = x - cur.x;
  var dy = opt_y - cur.y;
  goog.style.setPosition(el, el.offsetLeft + dx, el.offsetTop + dy)
};
goog.style.setSize = function(element, w, opt_h) {
  var h;
  if(w instanceof goog.math.Size) {
    h = w.height;
    w = w.width
  }else {
    if(opt_h == undefined) {
      throw Error("missing height argument");
    }
    h = opt_h
  }
  goog.style.setWidth(element, w);
  goog.style.setHeight(element, h)
};
goog.style.getPixelStyleValue_ = function(value, round) {
  if(typeof value == "number") {
    value = (round ? Math.round(value) : value) + "px"
  }
  return value
};
goog.style.setHeight = function(element, height) {
  element.style.height = goog.style.getPixelStyleValue_(height, true)
};
goog.style.setWidth = function(element, width) {
  element.style.width = goog.style.getPixelStyleValue_(width, true)
};
goog.style.getSize = function(element) {
  if(goog.style.getStyle_(element, "display") != "none") {
    return goog.style.getSizeWithDisplay_(element)
  }
  var style = element.style;
  var originalDisplay = style.display;
  var originalVisibility = style.visibility;
  var originalPosition = style.position;
  style.visibility = "hidden";
  style.position = "absolute";
  style.display = "inline";
  var size = goog.style.getSizeWithDisplay_(element);
  style.display = originalDisplay;
  style.position = originalPosition;
  style.visibility = originalVisibility;
  return size
};
goog.style.getSizeWithDisplay_ = function(element) {
  var offsetWidth = element.offsetWidth;
  var offsetHeight = element.offsetHeight;
  var webkitOffsetsZero = goog.userAgent.WEBKIT && !offsetWidth && !offsetHeight;
  if((!goog.isDef(offsetWidth) || webkitOffsetsZero) && element.getBoundingClientRect) {
    var clientRect = goog.style.getBoundingClientRect_(element);
    return new goog.math.Size(clientRect.right - clientRect.left, clientRect.bottom - clientRect.top)
  }
  return new goog.math.Size(offsetWidth, offsetHeight)
};
goog.style.getBounds = function(element) {
  var o = goog.style.getPageOffset(element);
  var s = goog.style.getSize(element);
  return new goog.math.Rect(o.x, o.y, s.width, s.height)
};
goog.style.toCamelCase = function(selector) {
  return goog.string.toCamelCase(String(selector))
};
goog.style.toSelectorCase = function(selector) {
  return goog.string.toSelectorCase(selector)
};
goog.style.getOpacity = function(el) {
  var style = el.style;
  var result = "";
  if("opacity" in style) {
    result = style.opacity
  }else {
    if("MozOpacity" in style) {
      result = style.MozOpacity
    }else {
      if("filter" in style) {
        var match = style.filter.match(/alpha\(opacity=([\d.]+)\)/);
        if(match) {
          result = String(match[1] / 100)
        }
      }
    }
  }
  return result == "" ? result : Number(result)
};
goog.style.setOpacity = function(el, alpha) {
  var style = el.style;
  if("opacity" in style) {
    style.opacity = alpha
  }else {
    if("MozOpacity" in style) {
      style.MozOpacity = alpha
    }else {
      if("filter" in style) {
        if(alpha === "") {
          style.filter = ""
        }else {
          style.filter = "alpha(opacity=" + alpha * 100 + ")"
        }
      }
    }
  }
};
goog.style.setTransparentBackgroundImage = function(el, src) {
  var style = el.style;
  if(goog.userAgent.IE && !goog.userAgent.isVersion("8")) {
    style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(" + 'src="' + src + '", sizingMethod="crop")'
  }else {
    style.backgroundImage = "url(" + src + ")";
    style.backgroundPosition = "top left";
    style.backgroundRepeat = "no-repeat"
  }
};
goog.style.clearTransparentBackgroundImage = function(el) {
  var style = el.style;
  if("filter" in style) {
    style.filter = ""
  }else {
    style.backgroundImage = "none"
  }
};
goog.style.showElement = function(el, display) {
  el.style.display = display ? "" : "none"
};
goog.style.isElementShown = function(el) {
  return el.style.display != "none"
};
goog.style.installStyles = function(stylesString, opt_node) {
  var dh = goog.dom.getDomHelper(opt_node);
  var styleSheet = null;
  if(goog.userAgent.IE) {
    styleSheet = dh.getDocument().createStyleSheet();
    goog.style.setStyles(styleSheet, stylesString)
  }else {
    var head = dh.getElementsByTagNameAndClass("head")[0];
    if(!head) {
      var body = dh.getElementsByTagNameAndClass("body")[0];
      head = dh.createDom("head");
      body.parentNode.insertBefore(head, body)
    }
    styleSheet = dh.createDom("style");
    goog.style.setStyles(styleSheet, stylesString);
    dh.appendChild(head, styleSheet)
  }
  return styleSheet
};
goog.style.uninstallStyles = function(styleSheet) {
  var node = styleSheet.ownerNode || styleSheet.owningElement || styleSheet;
  goog.dom.removeNode(node)
};
goog.style.setStyles = function(element, stylesString) {
  if(goog.userAgent.IE) {
    element.cssText = stylesString
  }else {
    var propToSet = goog.userAgent.WEBKIT ? "innerText" : "innerHTML";
    element[propToSet] = stylesString
  }
};
goog.style.setPreWrap = function(el) {
  var style = el.style;
  if(goog.userAgent.IE && !goog.userAgent.isVersion("8")) {
    style.whiteSpace = "pre";
    style.wordWrap = "break-word"
  }else {
    if(goog.userAgent.GECKO) {
      style.whiteSpace = "-moz-pre-wrap"
    }else {
      style.whiteSpace = "pre-wrap"
    }
  }
};
goog.style.setInlineBlock = function(el) {
  var style = el.style;
  style.position = "relative";
  if(goog.userAgent.IE && !goog.userAgent.isVersion("8")) {
    style.zoom = "1";
    style.display = "inline"
  }else {
    if(goog.userAgent.GECKO) {
      style.display = goog.userAgent.isVersion("1.9a") ? "inline-block" : "-moz-inline-box"
    }else {
      style.display = "inline-block"
    }
  }
};
goog.style.isRightToLeft = function(el) {
  return"rtl" == goog.style.getStyle_(el, "direction")
};
goog.style.unselectableStyle_ = goog.userAgent.GECKO ? "MozUserSelect" : goog.userAgent.WEBKIT ? "WebkitUserSelect" : null;
goog.style.isUnselectable = function(el) {
  if(goog.style.unselectableStyle_) {
    return el.style[goog.style.unselectableStyle_].toLowerCase() == "none"
  }else {
    if(goog.userAgent.IE || goog.userAgent.OPERA) {
      return el.getAttribute("unselectable") == "on"
    }
  }
  return false
};
goog.style.setUnselectable = function(el, unselectable, opt_noRecurse) {
  var descendants = !opt_noRecurse ? el.getElementsByTagName("*") : null;
  var name = goog.style.unselectableStyle_;
  if(name) {
    var value = unselectable ? "none" : "";
    el.style[name] = value;
    if(descendants) {
      for(var i = 0, descendant;descendant = descendants[i];i++) {
        descendant.style[name] = value
      }
    }
  }else {
    if(goog.userAgent.IE || goog.userAgent.OPERA) {
      var value = unselectable ? "on" : "";
      el.setAttribute("unselectable", value);
      if(descendants) {
        for(var i = 0, descendant;descendant = descendants[i];i++) {
          descendant.setAttribute("unselectable", value)
        }
      }
    }
  }
};
goog.style.getBorderBoxSize = function(element) {
  return new goog.math.Size(element.offsetWidth, element.offsetHeight)
};
goog.style.setBorderBoxSize = function(element, size) {
  var doc = goog.dom.getOwnerDocument(element);
  var isCss1CompatMode = goog.dom.getDomHelper(doc).isCss1CompatMode();
  if(goog.userAgent.IE && (!isCss1CompatMode || !goog.userAgent.isVersion("8"))) {
    var style = element.style;
    if(isCss1CompatMode) {
      var paddingBox = goog.style.getPaddingBox(element);
      var borderBox = goog.style.getBorderBox(element);
      style.pixelWidth = size.width - borderBox.left - paddingBox.left - paddingBox.right - borderBox.right;
      style.pixelHeight = size.height - borderBox.top - paddingBox.top - paddingBox.bottom - borderBox.bottom
    }else {
      style.pixelWidth = size.width;
      style.pixelHeight = size.height
    }
  }else {
    goog.style.setBoxSizingSize_(element, size, "border-box")
  }
};
goog.style.getContentBoxSize = function(element) {
  var doc = goog.dom.getOwnerDocument(element);
  var ieCurrentStyle = goog.userAgent.IE && element.currentStyle;
  if(ieCurrentStyle && goog.dom.getDomHelper(doc).isCss1CompatMode() && ieCurrentStyle.width != "auto" && ieCurrentStyle.height != "auto" && !ieCurrentStyle.boxSizing) {
    var width = goog.style.getIePixelValue_(element, ieCurrentStyle.width, "width", "pixelWidth");
    var height = goog.style.getIePixelValue_(element, ieCurrentStyle.height, "height", "pixelHeight");
    return new goog.math.Size(width, height)
  }else {
    var borderBoxSize = goog.style.getBorderBoxSize(element);
    var paddingBox = goog.style.getPaddingBox(element);
    var borderBox = goog.style.getBorderBox(element);
    return new goog.math.Size(borderBoxSize.width - borderBox.left - paddingBox.left - paddingBox.right - borderBox.right, borderBoxSize.height - borderBox.top - paddingBox.top - paddingBox.bottom - borderBox.bottom)
  }
};
goog.style.setContentBoxSize = function(element, size) {
  var doc = goog.dom.getOwnerDocument(element);
  var isCss1CompatMode = goog.dom.getDomHelper(doc).isCss1CompatMode();
  if(goog.userAgent.IE && (!isCss1CompatMode || !goog.userAgent.isVersion("8"))) {
    var style = element.style;
    if(isCss1CompatMode) {
      style.pixelWidth = size.width;
      style.pixelHeight = size.height
    }else {
      var paddingBox = goog.style.getPaddingBox(element);
      var borderBox = goog.style.getBorderBox(element);
      style.pixelWidth = size.width + borderBox.left + paddingBox.left + paddingBox.right + borderBox.right;
      style.pixelHeight = size.height + borderBox.top + paddingBox.top + paddingBox.bottom + borderBox.bottom
    }
  }else {
    goog.style.setBoxSizingSize_(element, size, "content-box")
  }
};
goog.style.setBoxSizingSize_ = function(element, size, boxSizing) {
  var style = element.style;
  if(goog.userAgent.GECKO) {
    style.MozBoxSizing = boxSizing
  }else {
    if(goog.userAgent.WEBKIT) {
      style.WebkitBoxSizing = boxSizing
    }else {
      style.boxSizing = boxSizing
    }
  }
  style.width = size.width + "px";
  style.height = size.height + "px"
};
goog.style.getIePixelValue_ = function(element, value, name, pixelName) {
  if(/^\d+px?$/.test(value)) {
    return parseInt(value, 10)
  }else {
    var oldStyleValue = element.style[name];
    var oldRuntimeValue = element.runtimeStyle[name];
    element.runtimeStyle[name] = element.currentStyle[name];
    element.style[name] = value;
    var pixelValue = element.style[pixelName];
    element.style[name] = oldStyleValue;
    element.runtimeStyle[name] = oldRuntimeValue;
    return pixelValue
  }
};
goog.style.getIePixelDistance_ = function(element, propName) {
  return goog.style.getIePixelValue_(element, goog.style.getCascadedStyle(element, propName), "left", "pixelLeft")
};
goog.style.getBox_ = function(element, stylePrefix) {
  if(goog.userAgent.IE) {
    var left = goog.style.getIePixelDistance_(element, stylePrefix + "Left");
    var right = goog.style.getIePixelDistance_(element, stylePrefix + "Right");
    var top = goog.style.getIePixelDistance_(element, stylePrefix + "Top");
    var bottom = goog.style.getIePixelDistance_(element, stylePrefix + "Bottom");
    return new goog.math.Box(top, right, bottom, left)
  }else {
    var left = goog.style.getComputedStyle(element, stylePrefix + "Left");
    var right = goog.style.getComputedStyle(element, stylePrefix + "Right");
    var top = goog.style.getComputedStyle(element, stylePrefix + "Top");
    var bottom = goog.style.getComputedStyle(element, stylePrefix + "Bottom");
    return new goog.math.Box(parseFloat(top), parseFloat(right), parseFloat(bottom), parseFloat(left))
  }
};
goog.style.getPaddingBox = function(element) {
  return goog.style.getBox_(element, "padding")
};
goog.style.getMarginBox = function(element) {
  return goog.style.getBox_(element, "margin")
};
goog.style.ieBorderWidthKeywords_ = {"thin":2, "medium":4, "thick":6};
goog.style.getIePixelBorder_ = function(element, prop) {
  if(goog.style.getCascadedStyle(element, prop + "Style") == "none") {
    return 0
  }
  var width = goog.style.getCascadedStyle(element, prop + "Width");
  if(width in goog.style.ieBorderWidthKeywords_) {
    return goog.style.ieBorderWidthKeywords_[width]
  }
  return goog.style.getIePixelValue_(element, width, "left", "pixelLeft")
};
goog.style.getBorderBox = function(element) {
  if(goog.userAgent.IE) {
    var left = goog.style.getIePixelBorder_(element, "borderLeft");
    var right = goog.style.getIePixelBorder_(element, "borderRight");
    var top = goog.style.getIePixelBorder_(element, "borderTop");
    var bottom = goog.style.getIePixelBorder_(element, "borderBottom");
    return new goog.math.Box(top, right, bottom, left)
  }else {
    var left = goog.style.getComputedStyle(element, "borderLeftWidth");
    var right = goog.style.getComputedStyle(element, "borderRightWidth");
    var top = goog.style.getComputedStyle(element, "borderTopWidth");
    var bottom = goog.style.getComputedStyle(element, "borderBottomWidth");
    return new goog.math.Box(parseFloat(top), parseFloat(right), parseFloat(bottom), parseFloat(left))
  }
};
goog.style.getFontFamily = function(el) {
  var doc = goog.dom.getOwnerDocument(el);
  var font = "";
  if(doc.body.createTextRange) {
    var range = doc.body.createTextRange();
    range.moveToElementText(el);
    try {
      font = range.queryCommandValue("FontName")
    }catch(e) {
      font = ""
    }
  }
  if(!font) {
    font = goog.style.getStyle_(el, "fontFamily")
  }
  var fontsArray = font.split(",");
  if(fontsArray.length > 1) {
    font = fontsArray[0]
  }
  return goog.string.stripQuotes(font, "\"'")
};
goog.style.lengthUnitRegex_ = /[^\d]+$/;
goog.style.getLengthUnits = function(value) {
  var units = value.match(goog.style.lengthUnitRegex_);
  return units && units[0] || null
};
goog.style.ABSOLUTE_CSS_LENGTH_UNITS_ = {"cm":1, "in":1, "mm":1, "pc":1, "pt":1};
goog.style.CONVERTIBLE_RELATIVE_CSS_UNITS_ = {"em":1, "ex":1};
goog.style.getFontSize = function(el) {
  var fontSize = goog.style.getStyle_(el, "fontSize");
  var sizeUnits = goog.style.getLengthUnits(fontSize);
  if(fontSize && "px" == sizeUnits) {
    return parseInt(fontSize, 10)
  }
  if(goog.userAgent.IE) {
    if(sizeUnits in goog.style.ABSOLUTE_CSS_LENGTH_UNITS_) {
      return goog.style.getIePixelValue_(el, fontSize, "left", "pixelLeft")
    }else {
      if(el.parentNode && el.parentNode.nodeType == goog.dom.NodeType.ELEMENT && sizeUnits in goog.style.CONVERTIBLE_RELATIVE_CSS_UNITS_) {
        var parentElement = el.parentNode;
        var parentSize = goog.style.getStyle_(parentElement, "fontSize");
        return goog.style.getIePixelValue_(parentElement, fontSize == parentSize ? "1em" : fontSize, "left", "pixelLeft")
      }
    }
  }
  var sizeElement = goog.dom.createDom("span", {"style":"visibility:hidden;position:absolute;" + "line-height:0;padding:0;margin:0;border:0;height:1em;"});
  goog.dom.appendChild(el, sizeElement);
  fontSize = sizeElement.offsetHeight;
  goog.dom.removeNode(sizeElement);
  return fontSize
};
goog.style.parseStyleAttribute = function(value) {
  var result = {};
  goog.array.forEach(value.split(/\s*;\s*/), function(pair) {
    var keyValue = pair.split(/\s*:\s*/);
    if(keyValue.length == 2) {
      result[goog.string.toCamelCase(keyValue[0].toLowerCase())] = keyValue[1]
    }
  });
  return result
};
goog.style.toStyleAttribute = function(obj) {
  var buffer = [];
  goog.object.forEach(obj, function(value, key) {
    buffer.push(goog.string.toSelectorCase(key), ":", value, ";")
  });
  return buffer.join("")
};
goog.style.setFloat = function(el, value) {
  el.style[goog.userAgent.IE ? "styleFloat" : "cssFloat"] = value
};
goog.style.getFloat = function(el) {
  return el.style[goog.userAgent.IE ? "styleFloat" : "cssFloat"] || ""
};
goog.style.getScrollbarWidth = function(opt_className) {
  var outerDiv = goog.dom.createElement("div");
  if(opt_className) {
    outerDiv.className = opt_className
  }
  outerDiv.style.cssText = "visiblity:hidden;overflow:auto;" + "position:absolute;top:0;width:100px;height:100px";
  var innerDiv = goog.dom.createElement("div");
  goog.style.setSize(innerDiv, "200px", "200px");
  outerDiv.appendChild(innerDiv);
  goog.dom.appendChild(goog.dom.getDocument().body, outerDiv);
  var width = outerDiv.offsetWidth - outerDiv.clientWidth;
  goog.dom.removeNode(outerDiv);
  return width
};
goog.provide("cljs_d3.tooltip");
goog.require("cljs.core");
goog.require("goog.style");
goog.require("goog.dom");
cljs_d3.tooltip.tooltip_id = "cljs-d3-tooltip";
cljs_d3.tooltip.init_BANG_ = function init_BANG_() {
  if(cljs.core.not.call(null, goog.dom.getElement(cljs_d3.tooltip.tooltip_id))) {
    var tt__33837 = goog.dom.createDom("div", cljs.core.ObjMap.fromObject(["id", "style"], {"id":cljs_d3.tooltip.tooltip_id, "style":"position: absolute;"}).strobj());
    goog.dom.appendChild(document.body(), tt__33837);
    return tt__33837
  }else {
    return null
  }
};
cljs_d3.tooltip.show_BANG_ = function() {
  var show_BANG___delegate = function(left, top, html, p__33838) {
    var map__33844__33845 = p__33838;
    var map__33844__33846 = cljs.core.seq_QMARK_.call(null, map__33844__33845) ? cljs.core.apply.call(null, cljs.core.hash_map, map__33844__33845) : map__33844__33845;
    var margin__33847 = cljs.core._lookup.call(null, map__33844__33846, "\ufdd0'margin", cljs.core.PersistentVector.fromArray([0, 0], true));
    var tt__33848 = goog.dom.getElement(cljs_d3.tooltip.tooltip_id);
    goog.style.setPosition(tt__33848, left + margin__33847.call(null, 0), top + margin__33847.call(null, 1));
    return goog.style.showElement(tt__33848, true)
  };
  var show_BANG_ = function(left, top, html, var_args) {
    var p__33838 = null;
    if(goog.isDef(var_args)) {
      p__33838 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
    }
    return show_BANG___delegate.call(this, left, top, html, p__33838)
  };
  show_BANG_.cljs$lang$maxFixedArity = 3;
  show_BANG_.cljs$lang$applyTo = function(arglist__33849) {
    var left = cljs.core.first(arglist__33849);
    var top = cljs.core.first(cljs.core.next(arglist__33849));
    var html = cljs.core.first(cljs.core.next(cljs.core.next(arglist__33849)));
    var p__33838 = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__33849)));
    return show_BANG___delegate(left, top, html, p__33838)
  };
  show_BANG_.cljs$lang$arity$variadic = show_BANG___delegate;
  return show_BANG_
}();
cljs_d3.tooltip.hide_BANG_ = function hide_BANG_() {
  return goog.style.showElement(goog.dom.getElement(cljs_d3.tooltip.tooltip_id), false)
};
goog.provide("clojure.string");
goog.require("cljs.core");
goog.require("goog.string.StringBuffer");
goog.require("goog.string");
clojure.string.seq_reverse = function seq_reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
clojure.string.reverse = function reverse(s) {
  return s.split("").reverse().join("")
};
clojure.string.replace = function replace(s, match, replacement) {
  if(cljs.core.string_QMARK_.call(null, match)) {
    return s.replace(new RegExp(goog.string.regExpEscape(match), "g"), replacement)
  }else {
    if(cljs.core.truth_(match.hasOwnProperty("source"))) {
      return s.replace(new RegExp(match.source, "g"), replacement)
    }else {
      if("\ufdd0'else") {
        throw[cljs.core.str("Invalid match arg: "), cljs.core.str(match)].join("");
      }else {
        return null
      }
    }
  }
};
clojure.string.replace_first = function replace_first(s, match, replacement) {
  return s.replace(match, replacement)
};
clojure.string.join = function() {
  var join = null;
  var join__1 = function(coll) {
    return cljs.core.apply.call(null, cljs.core.str, coll)
  };
  var join__2 = function(separator, coll) {
    return cljs.core.apply.call(null, cljs.core.str, cljs.core.interpose.call(null, separator, coll))
  };
  join = function(separator, coll) {
    switch(arguments.length) {
      case 1:
        return join__1.call(this, separator);
      case 2:
        return join__2.call(this, separator, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  join.cljs$lang$arity$1 = join__1;
  join.cljs$lang$arity$2 = join__2;
  return join
}();
clojure.string.upper_case = function upper_case(s) {
  return s.toUpperCase()
};
clojure.string.lower_case = function lower_case(s) {
  return s.toLowerCase()
};
clojure.string.capitalize = function capitalize(s) {
  if(cljs.core.count.call(null, s) < 2) {
    return clojure.string.upper_case.call(null, s)
  }else {
    return[cljs.core.str(clojure.string.upper_case.call(null, cljs.core.subs.call(null, s, 0, 1))), cljs.core.str(clojure.string.lower_case.call(null, cljs.core.subs.call(null, s, 1)))].join("")
  }
};
clojure.string.split = function() {
  var split = null;
  var split__2 = function(s, re) {
    return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
  };
  var split__3 = function(s, re, limit) {
    if(limit < 1) {
      return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
    }else {
      var s__37796 = s;
      var limit__37797 = limit;
      var parts__37798 = cljs.core.PersistentVector.EMPTY;
      while(true) {
        if(cljs.core._EQ_.call(null, limit__37797, 1)) {
          return cljs.core.conj.call(null, parts__37798, s__37796)
        }else {
          var temp__3971__auto____37799 = cljs.core.re_find.call(null, re, s__37796);
          if(cljs.core.truth_(temp__3971__auto____37799)) {
            var m__37800 = temp__3971__auto____37799;
            var index__37801 = s__37796.indexOf(m__37800);
            var G__37802 = s__37796.substring(index__37801 + cljs.core.count.call(null, m__37800));
            var G__37803 = limit__37797 - 1;
            var G__37804 = cljs.core.conj.call(null, parts__37798, s__37796.substring(0, index__37801));
            s__37796 = G__37802;
            limit__37797 = G__37803;
            parts__37798 = G__37804;
            continue
          }else {
            return cljs.core.conj.call(null, parts__37798, s__37796)
          }
        }
        break
      }
    }
  };
  split = function(s, re, limit) {
    switch(arguments.length) {
      case 2:
        return split__2.call(this, s, re);
      case 3:
        return split__3.call(this, s, re, limit)
    }
    throw"Invalid arity: " + arguments.length;
  };
  split.cljs$lang$arity$2 = split__2;
  split.cljs$lang$arity$3 = split__3;
  return split
}();
clojure.string.split_lines = function split_lines(s) {
  return clojure.string.split.call(null, s, /\n|\r\n/)
};
clojure.string.trim = function trim(s) {
  return goog.string.trim(s)
};
clojure.string.triml = function triml(s) {
  return goog.string.trimLeft(s)
};
clojure.string.trimr = function trimr(s) {
  return goog.string.trimRight(s)
};
clojure.string.trim_newline = function trim_newline(s) {
  var index__37808 = s.length;
  while(true) {
    if(index__37808 === 0) {
      return""
    }else {
      var ch__37809 = cljs.core._lookup.call(null, s, index__37808 - 1, null);
      if(function() {
        var or__3824__auto____37810 = cljs.core._EQ_.call(null, ch__37809, "\n");
        if(or__3824__auto____37810) {
          return or__3824__auto____37810
        }else {
          return cljs.core._EQ_.call(null, ch__37809, "\r")
        }
      }()) {
        var G__37811 = index__37808 - 1;
        index__37808 = G__37811;
        continue
      }else {
        return s.substring(0, index__37808)
      }
    }
    break
  }
};
clojure.string.blank_QMARK_ = function blank_QMARK_(s) {
  var s__37815 = [cljs.core.str(s)].join("");
  if(cljs.core.truth_(function() {
    var or__3824__auto____37816 = cljs.core.not.call(null, s__37815);
    if(or__3824__auto____37816) {
      return or__3824__auto____37816
    }else {
      var or__3824__auto____37817 = cljs.core._EQ_.call(null, "", s__37815);
      if(or__3824__auto____37817) {
        return or__3824__auto____37817
      }else {
        return cljs.core.re_matches.call(null, /\s+/, s__37815)
      }
    }
  }())) {
    return true
  }else {
    return false
  }
};
clojure.string.escape = function escape(s, cmap) {
  var buffer__37824 = new goog.string.StringBuffer;
  var length__37825 = s.length;
  var index__37826 = 0;
  while(true) {
    if(cljs.core._EQ_.call(null, length__37825, index__37826)) {
      return buffer__37824.toString()
    }else {
      var ch__37827 = s.charAt(index__37826);
      var temp__3971__auto____37828 = cljs.core._lookup.call(null, cmap, ch__37827, null);
      if(cljs.core.truth_(temp__3971__auto____37828)) {
        var replacement__37829 = temp__3971__auto____37828;
        buffer__37824.append([cljs.core.str(replacement__37829)].join(""))
      }else {
        buffer__37824.append(ch__37827)
      }
      var G__37830 = index__37826 + 1;
      index__37826 = G__37830;
      continue
    }
    break
  }
};
goog.provide("cljs_d3.core");
goog.require("cljs.core");
goog.require("clojure.string");
cljs_d3.core.kstr = function kstr(k) {
  if(cljs.core.keyword_QMARK_.call(null, k)) {
    return cljs.core.name.call(null, k)
  }else {
    return k
  }
};
cljs_d3.core.pxstr = function pxstr(v) {
  if(cljs.core.number_QMARK_.call(null, v)) {
    return[cljs.core.str(v), cljs.core.str("px")].join("")
  }else {
    return v
  }
};
cljs_d3.core.jsArr = function() {
  var jsArr = null;
  var jsArr__1 = function(sequ) {
    return cljs.core.vec.call(null, cljs.core.map.call(null, function(p1__33625_SHARP_) {
      if(cljs.core.sequential_QMARK_.call(null, p1__33625_SHARP_)) {
        return jsArr.call(null, p1__33625_SHARP_)
      }else {
        return p1__33625_SHARP_
      }
    }, sequ)).array()
  };
  var jsArr__2 = function(sequ, else$) {
    if(cljs.core.seq.call(null, sequ)) {
      return jsArr.call(null, sequ)
    }else {
      return else$
    }
  };
  jsArr = function(sequ, else$) {
    switch(arguments.length) {
      case 1:
        return jsArr__1.call(this, sequ);
      case 2:
        return jsArr__2.call(this, sequ, else$)
    }
    throw"Invalid arity: " + arguments.length;
  };
  jsArr.cljs$lang$arity$1 = jsArr__1;
  jsArr.cljs$lang$arity$2 = jsArr__2;
  return jsArr
}();
cljs_d3.core.jsArr_QMARK_ = function jsArr_QMARK_(x) {
  return!(x.length() == null)
};
cljs_d3.core.jsObj = function jsObj(obj) {
  return cljs.core.into.call(null, cljs.core.ObjMap.EMPTY, cljs.core.map.call(null, function(p__33633) {
    var vec__33634__33635 = p__33633;
    var k__33636 = cljs.core.nth.call(null, vec__33634__33635, 0, null);
    var v__33637 = cljs.core.nth.call(null, vec__33634__33635, 1, null);
    var k__33638 = cljs.core.keyword_QMARK_.call(null, k__33636) ? cljs.core.name.call(null, k__33636) : k__33636;
    var v__33639 = cljs.core.keyword_QMARK_.call(null, v__33637) ? cljs.core.name.call(null, v__33637) : v__33637;
    if(cljs.core.map_QMARK_.call(null, v__33639)) {
      return cljs.core.PersistentVector.fromArray([k__33638, jsObj.call(null, v__33639)], true)
    }else {
      return cljs.core.PersistentVector.fromArray([k__33638, v__33639], true)
    }
  }, obj))
};
cljs_d3.core.p = function p(x) {
  console.log(cljs.core.sequential_QMARK_.call(null, x) ? cljs_d3.core.jsArr.call(null, x) : cljs.core.map_QMARK_.call(null, x) ? cljs_d3.core.jsObj.call(null, x) : "\ufdd0'else" ? x : null);
  return x
};
cljs_d3.core.d3 = d3;
cljs_d3.core.event = function event() {
  return d3.event()
};
cljs_d3.core.select = function() {
  var select = null;
  var select__1 = function(sel__29796__auto__) {
    return sel__29796__auto__.select()
  };
  var select__2 = function(sel__29796__auto__, a1__29797__auto__) {
    return sel__29796__auto__.select(a1__29797__auto__)
  };
  var select__3 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__) {
    return sel__29796__auto__.select(a1__29797__auto__, a2__29798__auto__)
  };
  var select__4 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    return sel__29796__auto__.select(a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
  };
  select = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    switch(arguments.length) {
      case 1:
        return select__1.call(this, sel__29796__auto__);
      case 2:
        return select__2.call(this, sel__29796__auto__, a1__29797__auto__);
      case 3:
        return select__3.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__);
      case 4:
        return select__4.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  select.cljs$lang$arity$1 = select__1;
  select.cljs$lang$arity$2 = select__2;
  select.cljs$lang$arity$3 = select__3;
  select.cljs$lang$arity$4 = select__4;
  return select
}();
cljs_d3.core.selectAll = function() {
  var selectAll = null;
  var selectAll__1 = function(sel__29796__auto__) {
    return sel__29796__auto__.selectAll()
  };
  var selectAll__2 = function(sel__29796__auto__, a1__29797__auto__) {
    return sel__29796__auto__.selectAll(a1__29797__auto__)
  };
  var selectAll__3 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__) {
    return sel__29796__auto__.selectAll(a1__29797__auto__, a2__29798__auto__)
  };
  var selectAll__4 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    return sel__29796__auto__.selectAll(a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
  };
  selectAll = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    switch(arguments.length) {
      case 1:
        return selectAll__1.call(this, sel__29796__auto__);
      case 2:
        return selectAll__2.call(this, sel__29796__auto__, a1__29797__auto__);
      case 3:
        return selectAll__3.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__);
      case 4:
        return selectAll__4.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  selectAll.cljs$lang$arity$1 = selectAll__1;
  selectAll.cljs$lang$arity$2 = selectAll__2;
  selectAll.cljs$lang$arity$3 = selectAll__3;
  selectAll.cljs$lang$arity$4 = selectAll__4;
  return selectAll
}();
cljs_d3.core.classed = function() {
  var classed = null;
  var classed__1 = function(sel__29796__auto__) {
    return sel__29796__auto__.classed()
  };
  var classed__2 = function(sel__29796__auto__, a1__29797__auto__) {
    return sel__29796__auto__.classed(a1__29797__auto__)
  };
  var classed__3 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__) {
    return sel__29796__auto__.classed(a1__29797__auto__, a2__29798__auto__)
  };
  var classed__4 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    return sel__29796__auto__.classed(a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
  };
  classed = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    switch(arguments.length) {
      case 1:
        return classed__1.call(this, sel__29796__auto__);
      case 2:
        return classed__2.call(this, sel__29796__auto__, a1__29797__auto__);
      case 3:
        return classed__3.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__);
      case 4:
        return classed__4.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  classed.cljs$lang$arity$1 = classed__1;
  classed.cljs$lang$arity$2 = classed__2;
  classed.cljs$lang$arity$3 = classed__3;
  classed.cljs$lang$arity$4 = classed__4;
  return classed
}();
cljs_d3.core.property = function() {
  var property = null;
  var property__1 = function(sel__29796__auto__) {
    return sel__29796__auto__.property()
  };
  var property__2 = function(sel__29796__auto__, a1__29797__auto__) {
    return sel__29796__auto__.property(a1__29797__auto__)
  };
  var property__3 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__) {
    return sel__29796__auto__.property(a1__29797__auto__, a2__29798__auto__)
  };
  var property__4 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    return sel__29796__auto__.property(a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
  };
  property = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    switch(arguments.length) {
      case 1:
        return property__1.call(this, sel__29796__auto__);
      case 2:
        return property__2.call(this, sel__29796__auto__, a1__29797__auto__);
      case 3:
        return property__3.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__);
      case 4:
        return property__4.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  property.cljs$lang$arity$1 = property__1;
  property.cljs$lang$arity$2 = property__2;
  property.cljs$lang$arity$3 = property__3;
  property.cljs$lang$arity$4 = property__4;
  return property
}();
cljs_d3.core.text = function() {
  var text = null;
  var text__1 = function(sel__29796__auto__) {
    return sel__29796__auto__.text()
  };
  var text__2 = function(sel__29796__auto__, a1__29797__auto__) {
    return sel__29796__auto__.text(a1__29797__auto__)
  };
  var text__3 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__) {
    return sel__29796__auto__.text(a1__29797__auto__, a2__29798__auto__)
  };
  var text__4 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    return sel__29796__auto__.text(a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
  };
  text = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    switch(arguments.length) {
      case 1:
        return text__1.call(this, sel__29796__auto__);
      case 2:
        return text__2.call(this, sel__29796__auto__, a1__29797__auto__);
      case 3:
        return text__3.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__);
      case 4:
        return text__4.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  text.cljs$lang$arity$1 = text__1;
  text.cljs$lang$arity$2 = text__2;
  text.cljs$lang$arity$3 = text__3;
  text.cljs$lang$arity$4 = text__4;
  return text
}();
cljs_d3.core.html = function() {
  var html = null;
  var html__1 = function(sel__29796__auto__) {
    return sel__29796__auto__.html()
  };
  var html__2 = function(sel__29796__auto__, a1__29797__auto__) {
    return sel__29796__auto__.html(a1__29797__auto__)
  };
  var html__3 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__) {
    return sel__29796__auto__.html(a1__29797__auto__, a2__29798__auto__)
  };
  var html__4 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    return sel__29796__auto__.html(a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
  };
  html = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    switch(arguments.length) {
      case 1:
        return html__1.call(this, sel__29796__auto__);
      case 2:
        return html__2.call(this, sel__29796__auto__, a1__29797__auto__);
      case 3:
        return html__3.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__);
      case 4:
        return html__4.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  html.cljs$lang$arity$1 = html__1;
  html.cljs$lang$arity$2 = html__2;
  html.cljs$lang$arity$3 = html__3;
  html.cljs$lang$arity$4 = html__4;
  return html
}();
cljs_d3.core.node = function() {
  var node = null;
  var node__1 = function(sel__29796__auto__) {
    return sel__29796__auto__.node()
  };
  var node__2 = function(sel__29796__auto__, a1__29797__auto__) {
    return sel__29796__auto__.node(a1__29797__auto__)
  };
  var node__3 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__) {
    return sel__29796__auto__.node(a1__29797__auto__, a2__29798__auto__)
  };
  var node__4 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    return sel__29796__auto__.node(a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
  };
  node = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    switch(arguments.length) {
      case 1:
        return node__1.call(this, sel__29796__auto__);
      case 2:
        return node__2.call(this, sel__29796__auto__, a1__29797__auto__);
      case 3:
        return node__3.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__);
      case 4:
        return node__4.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  node.cljs$lang$arity$1 = node__1;
  node.cljs$lang$arity$2 = node__2;
  node.cljs$lang$arity$3 = node__3;
  node.cljs$lang$arity$4 = node__4;
  return node
}();
cljs_d3.core.call = function() {
  var call = null;
  var call__1 = function(sel__29796__auto__) {
    return sel__29796__auto__.call()
  };
  var call__2 = function(sel__29796__auto__, a1__29797__auto__) {
    return sel__29796__auto__.call(a1__29797__auto__)
  };
  var call__3 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__) {
    return sel__29796__auto__.call(a1__29797__auto__, a2__29798__auto__)
  };
  var call__4 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    return sel__29796__auto__.call(a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
  };
  call = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    switch(arguments.length) {
      case 1:
        return call__1.call(this, sel__29796__auto__);
      case 2:
        return call__2.call(this, sel__29796__auto__, a1__29797__auto__);
      case 3:
        return call__3.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__);
      case 4:
        return call__4.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  call.cljs$lang$arity$1 = call__1;
  call.cljs$lang$arity$2 = call__2;
  call.cljs$lang$arity$3 = call__3;
  call.cljs$lang$arity$4 = call__4;
  return call
}();
cljs_d3.core.each = function() {
  var each = null;
  var each__1 = function(sel__29796__auto__) {
    return sel__29796__auto__.each()
  };
  var each__2 = function(sel__29796__auto__, a1__29797__auto__) {
    return sel__29796__auto__.each(a1__29797__auto__)
  };
  var each__3 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__) {
    return sel__29796__auto__.each(a1__29797__auto__, a2__29798__auto__)
  };
  var each__4 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    return sel__29796__auto__.each(a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
  };
  each = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    switch(arguments.length) {
      case 1:
        return each__1.call(this, sel__29796__auto__);
      case 2:
        return each__2.call(this, sel__29796__auto__, a1__29797__auto__);
      case 3:
        return each__3.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__);
      case 4:
        return each__4.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  each.cljs$lang$arity$1 = each__1;
  each.cljs$lang$arity$2 = each__2;
  each.cljs$lang$arity$3 = each__3;
  each.cljs$lang$arity$4 = each__4;
  return each
}();
cljs_d3.core.insert = function() {
  var insert = null;
  var insert__1 = function(sel__29796__auto__) {
    return sel__29796__auto__.insert()
  };
  var insert__2 = function(sel__29796__auto__, a1__29797__auto__) {
    return sel__29796__auto__.insert(a1__29797__auto__)
  };
  var insert__3 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__) {
    return sel__29796__auto__.insert(a1__29797__auto__, a2__29798__auto__)
  };
  var insert__4 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    return sel__29796__auto__.insert(a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
  };
  insert = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    switch(arguments.length) {
      case 1:
        return insert__1.call(this, sel__29796__auto__);
      case 2:
        return insert__2.call(this, sel__29796__auto__, a1__29797__auto__);
      case 3:
        return insert__3.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__);
      case 4:
        return insert__4.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  insert.cljs$lang$arity$1 = insert__1;
  insert.cljs$lang$arity$2 = insert__2;
  insert.cljs$lang$arity$3 = insert__3;
  insert.cljs$lang$arity$4 = insert__4;
  return insert
}();
cljs_d3.core.remove = function() {
  var remove = null;
  var remove__1 = function(sel__29796__auto__) {
    return sel__29796__auto__.remove()
  };
  var remove__2 = function(sel__29796__auto__, a1__29797__auto__) {
    return sel__29796__auto__.remove(a1__29797__auto__)
  };
  var remove__3 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__) {
    return sel__29796__auto__.remove(a1__29797__auto__, a2__29798__auto__)
  };
  var remove__4 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    return sel__29796__auto__.remove(a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
  };
  remove = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    switch(arguments.length) {
      case 1:
        return remove__1.call(this, sel__29796__auto__);
      case 2:
        return remove__2.call(this, sel__29796__auto__, a1__29797__auto__);
      case 3:
        return remove__3.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__);
      case 4:
        return remove__4.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  remove.cljs$lang$arity$1 = remove__1;
  remove.cljs$lang$arity$2 = remove__2;
  remove.cljs$lang$arity$3 = remove__3;
  remove.cljs$lang$arity$4 = remove__4;
  return remove
}();
cljs_d3.core.on = function() {
  var on = null;
  var on__1 = function(sel__29796__auto__) {
    return sel__29796__auto__.on()
  };
  var on__2 = function(sel__29796__auto__, a1__29797__auto__) {
    return sel__29796__auto__.on(a1__29797__auto__)
  };
  var on__3 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__) {
    return sel__29796__auto__.on(a1__29797__auto__, a2__29798__auto__)
  };
  var on__4 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    return sel__29796__auto__.on(a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
  };
  on = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    switch(arguments.length) {
      case 1:
        return on__1.call(this, sel__29796__auto__);
      case 2:
        return on__2.call(this, sel__29796__auto__, a1__29797__auto__);
      case 3:
        return on__3.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__);
      case 4:
        return on__4.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  on.cljs$lang$arity$1 = on__1;
  on.cljs$lang$arity$2 = on__2;
  on.cljs$lang$arity$3 = on__3;
  on.cljs$lang$arity$4 = on__4;
  return on
}();
cljs_d3.core.enter = function() {
  var enter = null;
  var enter__1 = function(sel__29796__auto__) {
    return sel__29796__auto__.enter()
  };
  var enter__2 = function(sel__29796__auto__, a1__29797__auto__) {
    return sel__29796__auto__.enter(a1__29797__auto__)
  };
  var enter__3 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__) {
    return sel__29796__auto__.enter(a1__29797__auto__, a2__29798__auto__)
  };
  var enter__4 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    return sel__29796__auto__.enter(a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
  };
  enter = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    switch(arguments.length) {
      case 1:
        return enter__1.call(this, sel__29796__auto__);
      case 2:
        return enter__2.call(this, sel__29796__auto__, a1__29797__auto__);
      case 3:
        return enter__3.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__);
      case 4:
        return enter__4.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  enter.cljs$lang$arity$1 = enter__1;
  enter.cljs$lang$arity$2 = enter__2;
  enter.cljs$lang$arity$3 = enter__3;
  enter.cljs$lang$arity$4 = enter__4;
  return enter
}();
cljs_d3.core.exit = function() {
  var exit = null;
  var exit__1 = function(sel__29796__auto__) {
    return sel__29796__auto__.exit()
  };
  var exit__2 = function(sel__29796__auto__, a1__29797__auto__) {
    return sel__29796__auto__.exit(a1__29797__auto__)
  };
  var exit__3 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__) {
    return sel__29796__auto__.exit(a1__29797__auto__, a2__29798__auto__)
  };
  var exit__4 = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    return sel__29796__auto__.exit(a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
  };
  exit = function(sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__) {
    switch(arguments.length) {
      case 1:
        return exit__1.call(this, sel__29796__auto__);
      case 2:
        return exit__2.call(this, sel__29796__auto__, a1__29797__auto__);
      case 3:
        return exit__3.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__);
      case 4:
        return exit__4.call(this, sel__29796__auto__, a1__29797__auto__, a2__29798__auto__, a3__29799__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  exit.cljs$lang$arity$1 = exit__1;
  exit.cljs$lang$arity$2 = exit__2;
  exit.cljs$lang$arity$3 = exit__3;
  exit.cljs$lang$arity$4 = exit__4;
  return exit
}();
cljs_d3.core.ns_abbv = function ns_abbv(namespace_uri) {
  var pred__33645__33648 = cljs.core._EQ_;
  var expr__33646__33649 = namespace_uri;
  if(pred__33645__33648.call(null, "http://www.w3.org/2000/svg", expr__33646__33649)) {
    return"\ufdd0'svg"
  }else {
    if(pred__33645__33648.call(null, "http://www.w3.org/1999/xhtml", expr__33646__33649)) {
      return"\ufdd0'xhtml"
    }else {
      if(pred__33645__33648.call(null, "http://www.w3.org/1999/xlink", expr__33646__33649)) {
        return"\ufdd0'xlink"
      }else {
        if(pred__33645__33648.call(null, "http://www.w3.org/XML/1998/namespace", expr__33646__33649)) {
          return"\ufdd0'xml"
        }else {
          if(pred__33645__33648.call(null, "http://www.w3.org/2000/xmlns/", expr__33646__33649)) {
            return"\ufdd0'xmlns"
          }else {
            throw[cljs.core.str("No abbreviation for namespace-uri "), cljs.core.str(namespace_uri)].join("");
          }
        }
      }
    }
  }
};
cljs_d3.core.append = function append(sel, node_type, attr_map) {
  var new_el__33660 = cljs.core._EQ_.call(null, "\ufdd0'svg", node_type) ? cljs_d3.core.append_svg.call(null, sel) : cljs.core.truth_(node_type.nodeName()) ? cljs_d3.core.append_node.call(null, sel, node_type) : true ? function() {
    var vec__33656__33657 = cljs.core.truth_(cljs.core.re_find.call(null, /:/, node_type)) ? clojure.string.split.call(null, node_type, /:/, 2) : cljs.core.truth_(sel.node()) ? cljs.core.PersistentVector.fromArray([cljs_d3.core.ns_abbv.call(null, sel.node().namespaceURI()), node_type], true) : true ? cljs.core.PersistentVector.fromArray([null, node_type], true) : null;
    var namespace__33658 = cljs.core.nth.call(null, vec__33656__33657, 0, null);
    var nt__33659 = cljs.core.nth.call(null, vec__33656__33657, 1, null);
    return sel.append(namespace__33658 == null ? nt__33659 : [cljs.core.str(cljs.core.name.call(null, namespace__33658)), cljs.core.str(":"), cljs.core.str(nt__33659)].join(""))
  }() : null;
  return cljs_d3.core.attr.call(null, new_el__33660, function() {
    var or__3824__auto____33661 = attr_map;
    if(cljs.core.truth_(or__3824__auto____33661)) {
      return or__3824__auto____33661
    }else {
      return cljs.core.ObjMap.EMPTY
    }
  }())
};
cljs_d3.core.append_STAR_ = function append_STAR_(sel, node_type, attr_map) {
  cljs_d3.core.append.call(null, sel, node_type, attr_map);
  return sel
};
cljs_d3.core.append_node = function append_node(sel, child) {
  cljs_d3.core.node.call(null, sel).appendChild(child);
  return cljs_d3.core.select.call(null, cljs_d3.core.d3, child)
};
cljs_d3.core.append_svg = function append_svg(sel) {
  return sel.append("svg:svg").attr("xmlns", "http://www.w3.org/2000/svg").attr("xmlns:xmlns:ev", "http://www.w3.org/2001/xml-events").attr("xmlns:xmlns:xlink", "http://www.w3.org/1999/xlink")
};
cljs_d3.core.attr = function() {
  var attr = null;
  var attr__2 = function(sel, x) {
    if(cljs.core.map_QMARK_.call(null, x)) {
      var G__33681__33682 = cljs.core.seq.call(null, x);
      if(G__33681__33682) {
        var G__33684__33686 = cljs.core.first.call(null, G__33681__33682);
        var vec__33685__33687 = G__33684__33686;
        var k__33688 = cljs.core.nth.call(null, vec__33685__33687, 0, null);
        var v__33689 = cljs.core.nth.call(null, vec__33685__33687, 1, null);
        var G__33681__33690 = G__33681__33682;
        var G__33684__33691 = G__33684__33686;
        var G__33681__33692 = G__33681__33690;
        while(true) {
          var vec__33693__33694 = G__33684__33691;
          var k__33695 = cljs.core.nth.call(null, vec__33693__33694, 0, null);
          var v__33696 = cljs.core.nth.call(null, vec__33693__33694, 1, null);
          var G__33681__33697 = G__33681__33692;
          sel.attr(cljs_d3.core.kstr.call(null, k__33695), v__33696);
          var temp__3974__auto____33698 = cljs.core.next.call(null, G__33681__33697);
          if(temp__3974__auto____33698) {
            var G__33681__33699 = temp__3974__auto____33698;
            var G__33700 = cljs.core.first.call(null, G__33681__33699);
            var G__33701 = G__33681__33699;
            G__33684__33691 = G__33700;
            G__33681__33692 = G__33701;
            continue
          }else {
          }
          break
        }
      }else {
      }
    }else {
      sel.attr(x)
    }
    return sel
  };
  var attr__3 = function(sel, k, v) {
    return sel.attr(cljs_d3.core.kstr.call(null, k), v)
  };
  attr = function(sel, k, v) {
    switch(arguments.length) {
      case 2:
        return attr__2.call(this, sel, k);
      case 3:
        return attr__3.call(this, sel, k, v)
    }
    throw"Invalid arity: " + arguments.length;
  };
  attr.cljs$lang$arity$2 = attr__2;
  attr.cljs$lang$arity$3 = attr__3;
  return attr
}();
cljs_d3.core.style = function() {
  var style = null;
  var style__2 = function(sel, x) {
    if(cljs.core.map_QMARK_.call(null, x)) {
      var G__33722__33723 = cljs.core.seq.call(null, x);
      if(G__33722__33723) {
        var G__33725__33727 = cljs.core.first.call(null, G__33722__33723);
        var vec__33726__33728 = G__33725__33727;
        var k__33729 = cljs.core.nth.call(null, vec__33726__33728, 0, null);
        var v__33730 = cljs.core.nth.call(null, vec__33726__33728, 1, null);
        var G__33722__33731 = G__33722__33723;
        var G__33725__33732 = G__33725__33727;
        var G__33722__33733 = G__33722__33731;
        while(true) {
          var vec__33734__33735 = G__33725__33732;
          var k__33736 = cljs.core.nth.call(null, vec__33734__33735, 0, null);
          var v__33737 = cljs.core.nth.call(null, vec__33734__33735, 1, null);
          var G__33722__33738 = G__33722__33733;
          sel.style(cljs_d3.core.kstr.call(null, k__33736), cljs_d3.core.pxstr.call(null, v__33737));
          var temp__3974__auto____33739 = cljs.core.next.call(null, G__33722__33738);
          if(temp__3974__auto____33739) {
            var G__33722__33740 = temp__3974__auto____33739;
            var G__33741 = cljs.core.first.call(null, G__33722__33740);
            var G__33742 = G__33722__33740;
            G__33725__33732 = G__33741;
            G__33722__33733 = G__33742;
            continue
          }else {
          }
          break
        }
      }else {
      }
    }else {
      sel.style(cljs_d3.core.pxstr.call(null, x))
    }
    return sel
  };
  var style__3 = function(sel, k, v) {
    return sel.style(cljs_d3.core.kstr.call(null, k), cljs_d3.core.pxstr.call(null, v))
  };
  style = function(sel, k, v) {
    switch(arguments.length) {
      case 2:
        return style__2.call(this, sel, k);
      case 3:
        return style__3.call(this, sel, k, v)
    }
    throw"Invalid arity: " + arguments.length;
  };
  style.cljs$lang$arity$2 = style__2;
  style.cljs$lang$arity$3 = style__3;
  return style
}();
cljs_d3.core.data = function data(sel, x) {
  return sel.data(cljs.core.fn_QMARK_.call(null, x) ? function() {
    var G__33743__delegate = function(rest__33702_SHARP_) {
      return cljs_d3.core.jsArr.call(null, cljs.core.apply.call(null, x, rest__33702_SHARP_))
    };
    var G__33743 = function(var_args) {
      var rest__33702_SHARP_ = null;
      if(goog.isDef(var_args)) {
        rest__33702_SHARP_ = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__33743__delegate.call(this, rest__33702_SHARP_)
    };
    G__33743.cljs$lang$maxFixedArity = 0;
    G__33743.cljs$lang$applyTo = function(arglist__33744) {
      var rest__33702_SHARP_ = cljs.core.seq(arglist__33744);
      return G__33743__delegate(rest__33702_SHARP_)
    };
    G__33743.cljs$lang$arity$variadic = G__33743__delegate;
    return G__33743
  }() : cljs_d3.core.jsArr.call(null, x))
};
cljs_d3.core.transition = function() {
  var transition__delegate = function(sel, p__33745) {
    var map__33751__33752 = p__33745;
    var map__33751__33753 = cljs.core.seq_QMARK_.call(null, map__33751__33752) ? cljs.core.apply.call(null, cljs.core.hash_map, map__33751__33752) : map__33751__33752;
    var delay__33754 = cljs.core._lookup.call(null, map__33751__33753, "\ufdd0'delay", 0);
    var duration__33755 = cljs.core._lookup.call(null, map__33751__33753, "\ufdd0'duration", 250);
    return sel.transition().duration(duration__33755).delay(delay__33754)
  };
  var transition = function(sel, var_args) {
    var p__33745 = null;
    if(goog.isDef(var_args)) {
      p__33745 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return transition__delegate.call(this, sel, p__33745)
  };
  transition.cljs$lang$maxFixedArity = 1;
  transition.cljs$lang$applyTo = function(arglist__33756) {
    var sel = cljs.core.first(arglist__33756);
    var p__33745 = cljs.core.rest(arglist__33756);
    return transition__delegate(sel, p__33745)
  };
  transition.cljs$lang$arity$variadic = transition__delegate;
  return transition
}();
cljs_d3.core.make_last_child = function make_last_child(el) {
  return el.parentNode().appendChild(el)
};
cljs_d3.core.min_max = function() {
  var min_max__delegate = function(data, p__33757) {
    var map__33763__33764 = p__33757;
    var map__33763__33765 = cljs.core.seq_QMARK_.call(null, map__33763__33764) ? cljs.core.apply.call(null, cljs.core.hash_map, map__33763__33764) : map__33763__33764;
    var dimension__33766 = cljs.core._lookup.call(null, map__33763__33765, "\ufdd0'dimension", null);
    var vals__33767 = cljs.core.truth_(dimension__33766) ? cljs.core.map.call(null, dimension__33766, data) : data;
    return cljs.core.PersistentVector.fromArray([cljs.core.apply.call(null, cljs.core.min, vals__33767), cljs.core.apply.call(null, cljs.core.max, vals__33767)], true)
  };
  var min_max = function(data, var_args) {
    var p__33757 = null;
    if(goog.isDef(var_args)) {
      p__33757 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return min_max__delegate.call(this, data, p__33757)
  };
  min_max.cljs$lang$maxFixedArity = 1;
  min_max.cljs$lang$applyTo = function(arglist__33768) {
    var data = cljs.core.first(arglist__33768);
    var p__33757 = cljs.core.rest(arglist__33768);
    return min_max__delegate(data, p__33757)
  };
  min_max.cljs$lang$arity$variadic = min_max__delegate;
  return min_max
}();
cljs_d3.core.min_0_max = function() {
  var min_0_max__delegate = function(data, p__33769) {
    var map__33775__33776 = p__33769;
    var map__33775__33777 = cljs.core.seq_QMARK_.call(null, map__33775__33776) ? cljs.core.apply.call(null, cljs.core.hash_map, map__33775__33776) : map__33775__33776;
    var dimension__33778 = cljs.core._lookup.call(null, map__33775__33777, "\ufdd0'dimension", null);
    var mm__33779 = cljs_d3.core.min_max.call(null, data, "\ufdd0'dimension", dimension__33778);
    return cljs.core.PersistentVector.fromArray([cljs.core.nth.call(null, mm__33779, 0), 0, cljs.core.nth.call(null, mm__33779, 1)], true)
  };
  var min_0_max = function(data, var_args) {
    var p__33769 = null;
    if(goog.isDef(var_args)) {
      p__33769 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return min_0_max__delegate.call(this, data, p__33769)
  };
  min_0_max.cljs$lang$maxFixedArity = 1;
  min_0_max.cljs$lang$applyTo = function(arglist__33780) {
    var data = cljs.core.first(arglist__33780);
    var p__33769 = cljs.core.rest(arglist__33780);
    return min_0_max__delegate(data, p__33769)
  };
  min_0_max.cljs$lang$arity$variadic = min_0_max__delegate;
  return min_0_max
}();
cljs_d3.core.avg = function() {
  var avg__delegate = function(data, p__33782) {
    var map__33788__33789 = p__33782;
    var map__33788__33790 = cljs.core.seq_QMARK_.call(null, map__33788__33789) ? cljs.core.apply.call(null, cljs.core.hash_map, map__33788__33789) : map__33788__33789;
    var dimension__33791 = cljs.core._lookup.call(null, map__33788__33790, "\ufdd0'dimension", null);
    var vals__33792 = cljs.core.truth_(dimension__33791) ? cljs.core.map.call(null, dimension__33791, data) : data;
    return cljs.core.apply.call(null, cljs.core._PLUS_, vals__33792) / cljs.core.count.call(null, vals__33792)
  };
  var avg = function(data, var_args) {
    var p__33782 = null;
    if(goog.isDef(var_args)) {
      p__33782 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return avg__delegate.call(this, data, p__33782)
  };
  avg.cljs$lang$maxFixedArity = 1;
  avg.cljs$lang$applyTo = function(arglist__33793) {
    var data = cljs.core.first(arglist__33793);
    var p__33782 = cljs.core.rest(arglist__33793);
    return avg__delegate(data, p__33782)
  };
  avg.cljs$lang$arity$variadic = avg__delegate;
  return avg
}();
cljs_d3.core.quantile = function() {
  var quantile__delegate = function(data, p__33794) {
    var map__33806__33807 = p__33794;
    var map__33806__33808 = cljs.core.seq_QMARK_.call(null, map__33806__33807) ? cljs.core.apply.call(null, cljs.core.hash_map, map__33806__33807) : map__33806__33807;
    var probs__33809 = cljs.core._lookup.call(null, map__33806__33808, "\ufdd0'probs", cljs.core.PersistentVector.fromArray([0, 0.25, 0.5, 0.75, 1], true));
    var dimension__33810 = cljs.core._lookup.call(null, map__33806__33808, "\ufdd0'dimension", cljs.core.identity);
    var vals__33811 = cljs.core.into.call(null, cljs.core.PersistentVector.EMPTY, cljs.core.sort.call(null, cljs.core.map.call(null, dimension__33810, data)));
    var n_1__33812 = cljs.core.count.call(null, vals__33811) - 1;
    return cljs.core.map.call(null, function(p1__33781_SHARP_) {
      var index__33813 = 1 + p1__33781_SHARP_ * n_1__33812;
      var lo__33814 = Math.floor(index__33813);
      var h__33815 = index__33813 - lo__33814;
      var a__33816 = vals__33811.call(null, lo__33814 - 1);
      if(cljs.core._EQ_.call(null, h__33815, 0)) {
        return a__33816
      }else {
        return a__33816 + h__33815 * (vals__33811.call(null, lo__33814) - a__33816)
      }
    }, probs__33809)
  };
  var quantile = function(data, var_args) {
    var p__33794 = null;
    if(goog.isDef(var_args)) {
      p__33794 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return quantile__delegate.call(this, data, p__33794)
  };
  quantile.cljs$lang$maxFixedArity = 1;
  quantile.cljs$lang$applyTo = function(arglist__33817) {
    var data = cljs.core.first(arglist__33817);
    var p__33794 = cljs.core.rest(arglist__33817);
    return quantile__delegate(data, p__33794)
  };
  quantile.cljs$lang$arity$variadic = quantile__delegate;
  return quantile
}();
goog.provide("cljs_d3.svg");
goog.require("cljs.core");
goog.require("cljs_d3.core");
cljs_d3.svg.axis = function() {
  var axis__delegate = function(scale, p__33609) {
    var map__33617__33618 = p__33609;
    var map__33617__33619 = cljs.core.seq_QMARK_.call(null, map__33617__33618) ? cljs.core.apply.call(null, cljs.core.hash_map, map__33617__33618) : map__33617__33618;
    var tick_size__33620 = cljs.core._lookup.call(null, map__33617__33619, "\ufdd0'tick-size", null);
    var tick_format__33621 = cljs.core._lookup.call(null, map__33617__33619, "\ufdd0'tick-format", null);
    var ticks__33622 = cljs.core._lookup.call(null, map__33617__33619, "\ufdd0'ticks", null);
    var orient__33623 = cljs.core._lookup.call(null, map__33617__33619, "\ufdd0'orient", null);
    return function(x__29812__auto__, arg__29813__auto__) {
      if(cljs.core.truth_(arg__29813__auto__)) {
        return x__29812__auto__.tickFormat(arg__29813__auto__)
      }else {
        return x__29812__auto__
      }
    }.call(null, function(x__29812__auto__, arg__29813__auto__) {
      if(cljs.core.truth_(arg__29813__auto__)) {
        return x__29812__auto__.ticks(arg__29813__auto__)
      }else {
        return x__29812__auto__
      }
    }.call(null, function(x__29812__auto__, arg__29813__auto__) {
      if(cljs.core.truth_(arg__29813__auto__)) {
        return x__29812__auto__.tickSize(arg__29813__auto__)
      }else {
        return x__29812__auto__
      }
    }.call(null, function(x__29812__auto__, arg__29813__auto__) {
      if(cljs.core.truth_(arg__29813__auto__)) {
        return x__29812__auto__.orient(arg__29813__auto__)
      }else {
        return x__29812__auto__
      }
    }.call(null, cljs_d3.core.d3.svg().axis().scale(scale), orient__33623), tick_size__33620), ticks__33622), tick_format__33621)
  };
  var axis = function(scale, var_args) {
    var p__33609 = null;
    if(goog.isDef(var_args)) {
      p__33609 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return axis__delegate.call(this, scale, p__33609)
  };
  axis.cljs$lang$maxFixedArity = 1;
  axis.cljs$lang$applyTo = function(arglist__33624) {
    var scale = cljs.core.first(arglist__33624);
    var p__33609 = cljs.core.rest(arglist__33624);
    return axis__delegate(scale, p__33609)
  };
  axis.cljs$lang$arity$variadic = axis__delegate;
  return axis
}();
goog.provide("cljs_d3.scale");
goog.require("cljs.core");
goog.require("cljs_d3.core");
cljs_d3.scale.linear = function() {
  var linear__delegate = function(p__33818) {
    var map__33827__33828 = p__33818;
    var map__33827__33829 = cljs.core.seq_QMARK_.call(null, map__33827__33828) ? cljs.core.apply.call(null, cljs.core.hash_map, map__33827__33828) : map__33827__33828;
    var clamp__33830 = cljs.core._lookup.call(null, map__33827__33829, "\ufdd0'clamp", null);
    var range_round__33831 = cljs.core._lookup.call(null, map__33827__33829, "\ufdd0'range-round", null);
    var nice__33832 = cljs.core._lookup.call(null, map__33827__33829, "\ufdd0'nice", null);
    var range__33833 = cljs.core._lookup.call(null, map__33827__33829, "\ufdd0'range", null);
    var domain__33834 = cljs.core._lookup.call(null, map__33827__33829, "\ufdd0'domain", null);
    return function(x__29805__auto__, test__29806__auto__) {
      if(cljs.core.truth_(test__29806__auto__)) {
        return x__29805__auto__.nice()
      }else {
        return x__29805__auto__
      }
    }.call(null, function(x__29812__auto__, arg__29813__auto__) {
      if(cljs.core.truth_(arg__29813__auto__)) {
        return x__29812__auto__.clamp(arg__29813__auto__)
      }else {
        return x__29812__auto__
      }
    }.call(null, function(x__29812__auto__, arg__29813__auto__) {
      if(cljs.core.truth_(arg__29813__auto__)) {
        return x__29812__auto__.rangeRound(arg__29813__auto__)
      }else {
        return x__29812__auto__
      }
    }.call(null, d3.scale(linear.call(null)).domain(cljs_d3.core.jsArr.call(null, domain__33834)).range(cljs_d3.core.jsArr.call(null, range__33833)), cljs_d3.core.jsArr.call(null, range_round__33831, null)), clamp__33830), nice__33832)
  };
  var linear = function(var_args) {
    var p__33818 = null;
    if(goog.isDef(var_args)) {
      p__33818 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return linear__delegate.call(this, p__33818)
  };
  linear.cljs$lang$maxFixedArity = 0;
  linear.cljs$lang$applyTo = function(arglist__33835) {
    var p__33818 = cljs.core.seq(arglist__33835);
    return linear__delegate(p__33818)
  };
  linear.cljs$lang$arity$variadic = linear__delegate;
  return linear
}();
goog.provide("cljs_d3.layout");
goog.require("cljs.core");
goog.require("cljs_d3.core");
cljs_d3.layout.histogram = function() {
  var histogram__delegate = function(p__33581) {
    var map__33595__33596 = p__33581;
    var map__33595__33597 = cljs.core.seq_QMARK_.call(null, map__33595__33596) ? cljs.core.apply.call(null, cljs.core.hash_map, map__33595__33596) : map__33595__33596;
    var frequency__33598 = cljs.core._lookup.call(null, map__33595__33597, "\ufdd0'frequency", null);
    var bins__33599 = cljs.core._lookup.call(null, map__33595__33597, "\ufdd0'bins", null);
    var range__33600 = cljs.core._lookup.call(null, map__33595__33597, "\ufdd0'range", null);
    var value__33601 = cljs.core._lookup.call(null, map__33595__33597, "\ufdd0'value", null);
    var h__33602 = function(x__29812__auto__, arg__29813__auto__) {
      if(cljs.core.truth_(arg__29813__auto__)) {
        return x__29812__auto__.frequency(arg__29813__auto__)
      }else {
        return x__29812__auto__
      }
    }.call(null, function(x__29812__auto__, arg__29813__auto__) {
      if(cljs.core.truth_(arg__29813__auto__)) {
        return x__29812__auto__.bins(arg__29813__auto__)
      }else {
        return x__29812__auto__
      }
    }.call(null, function(x__29812__auto__, arg__29813__auto__) {
      if(cljs.core.truth_(arg__29813__auto__)) {
        return x__29812__auto__.range(arg__29813__auto__)
      }else {
        return x__29812__auto__
      }
    }.call(null, function(x__29812__auto__, arg__29813__auto__) {
      if(cljs.core.truth_(arg__29813__auto__)) {
        return x__29812__auto__.value(arg__29813__auto__)
      }else {
        return x__29812__auto__
      }
    }.call(null, cljs_d3.core.d3.layout().histogram(), value__33601), cljs.core.fn_QMARK_.call(null, range__33600) ? function(vals) {
      return cljs_d3.core.jsArr.call(null, range__33600.call(null, vals), null)
    } : cljs_d3.core.jsArr.call(null, range__33600, null)), cljs.core.number_QMARK_.call(null, bins__33599) ? bins__33599 : cljs_d3.core.jsArr.call(null, bins__33599, null)), frequency__33598);
    return function(x) {
      var pred__33603__33606 = cljs.core._EQ_;
      var expr__33604__33607 = x;
      if(pred__33603__33606.call(null, "\ufdd0'value", expr__33604__33607)) {
        return h__33602.value()
      }else {
        if(pred__33603__33606.call(null, "\ufdd0'range", expr__33604__33607)) {
          return function(p1__33362_SHARP_) {
            return h__33602.range().call(null, cljs_d3.core.jsArr.call(null, p1__33362_SHARP_))
          }
        }else {
          if(pred__33603__33606.call(null, "\ufdd0'bins", expr__33604__33607)) {
            return h__33602.bins()
          }else {
            if(pred__33603__33606.call(null, "\ufdd0'frequency", expr__33604__33607)) {
              return h__33602.frequency()
            }else {
              return h__33602.call(null, cljs_d3.core.jsArr.call(null, x))
            }
          }
        }
      }
    }
  };
  var histogram = function(var_args) {
    var p__33581 = null;
    if(goog.isDef(var_args)) {
      p__33581 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return histogram__delegate.call(this, p__33581)
  };
  histogram.cljs$lang$maxFixedArity = 0;
  histogram.cljs$lang$applyTo = function(arglist__33608) {
    var p__33581 = cljs.core.seq(arglist__33608);
    return histogram__delegate(p__33581)
  };
  histogram.cljs$lang$arity$variadic = histogram__delegate;
  return histogram
}();
