var COMPILED = false;
var goog = goog || {};
goog.global = this;
goog.DEBUG = true;
goog.LOCALE = "en";
goog.provide = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      throw Error('Namespace "' + name + '" already declared.');
    }
    delete goog.implicitNamespaces_[name];
    var namespace = name;
    while(namespace = namespace.substring(0, namespace.lastIndexOf("."))) {
      if(goog.getObjectByName(namespace)) {
        break
      }
      goog.implicitNamespaces_[namespace] = true
    }
  }
  goog.exportPath_(name)
};
goog.setTestOnly = function(opt_message) {
  if(COMPILED && !goog.DEBUG) {
    opt_message = opt_message || "";
    throw Error("Importing test-only code into non-debug environment" + opt_message ? ": " + opt_message : ".");
  }
};
if(!COMPILED) {
  goog.isProvided_ = function(name) {
    return!goog.implicitNamespaces_[name] && !!goog.getObjectByName(name)
  };
  goog.implicitNamespaces_ = {}
}
goog.exportPath_ = function(name, opt_object, opt_objectToExportTo) {
  var parts = name.split(".");
  var cur = opt_objectToExportTo || goog.global;
  if(!(parts[0] in cur) && cur.execScript) {
    cur.execScript("var " + parts[0])
  }
  for(var part;parts.length && (part = parts.shift());) {
    if(!parts.length && goog.isDef(opt_object)) {
      cur[part] = opt_object
    }else {
      if(cur[part]) {
        cur = cur[part]
      }else {
        cur = cur[part] = {}
      }
    }
  }
};
goog.getObjectByName = function(name, opt_obj) {
  var parts = name.split(".");
  var cur = opt_obj || goog.global;
  for(var part;part = parts.shift();) {
    if(goog.isDefAndNotNull(cur[part])) {
      cur = cur[part]
    }else {
      return null
    }
  }
  return cur
};
goog.globalize = function(obj, opt_global) {
  var global = opt_global || goog.global;
  for(var x in obj) {
    global[x] = obj[x]
  }
};
goog.addDependency = function(relPath, provides, requires) {
  if(!COMPILED) {
    var provide, require;
    var path = relPath.replace(/\\/g, "/");
    var deps = goog.dependencies_;
    for(var i = 0;provide = provides[i];i++) {
      deps.nameToPath[provide] = path;
      if(!(path in deps.pathToNames)) {
        deps.pathToNames[path] = {}
      }
      deps.pathToNames[path][provide] = true
    }
    for(var j = 0;require = requires[j];j++) {
      if(!(path in deps.requires)) {
        deps.requires[path] = {}
      }
      deps.requires[path][require] = true
    }
  }
};
goog.ENABLE_DEBUG_LOADER = true;
goog.require = function(name) {
  if(!COMPILED) {
    if(goog.isProvided_(name)) {
      return
    }
    if(goog.ENABLE_DEBUG_LOADER) {
      var path = goog.getPathFromDeps_(name);
      if(path) {
        goog.included_[path] = true;
        goog.writeScripts_();
        return
      }
    }
    var errorMessage = "goog.require could not find: " + name;
    if(goog.global.console) {
      goog.global.console["error"](errorMessage)
    }
    throw Error(errorMessage);
  }
};
goog.basePath = "";
goog.global.CLOSURE_BASE_PATH;
goog.global.CLOSURE_NO_DEPS;
goog.global.CLOSURE_IMPORT_SCRIPT;
goog.nullFunction = function() {
};
goog.identityFunction = function(var_args) {
  return arguments[0]
};
goog.abstractMethod = function() {
  throw Error("unimplemented abstract method");
};
goog.addSingletonGetter = function(ctor) {
  ctor.getInstance = function() {
    return ctor.instance_ || (ctor.instance_ = new ctor)
  }
};
if(!COMPILED && goog.ENABLE_DEBUG_LOADER) {
  goog.included_ = {};
  goog.dependencies_ = {pathToNames:{}, nameToPath:{}, requires:{}, visited:{}, written:{}};
  goog.inHtmlDocument_ = function() {
    var doc = goog.global.document;
    return typeof doc != "undefined" && "write" in doc
  };
  goog.findBasePath_ = function() {
    if(goog.global.CLOSURE_BASE_PATH) {
      goog.basePath = goog.global.CLOSURE_BASE_PATH;
      return
    }else {
      if(!goog.inHtmlDocument_()) {
        return
      }
    }
    var doc = goog.global.document;
    var scripts = doc.getElementsByTagName("script");
    for(var i = scripts.length - 1;i >= 0;--i) {
      var src = scripts[i].src;
      var qmark = src.lastIndexOf("?");
      var l = qmark == -1 ? src.length : qmark;
      if(src.substr(l - 7, 7) == "base.js") {
        goog.basePath = src.substr(0, l - 7);
        return
      }
    }
  };
  goog.importScript_ = function(src) {
    var importScript = goog.global.CLOSURE_IMPORT_SCRIPT || goog.writeScriptTag_;
    if(!goog.dependencies_.written[src] && importScript(src)) {
      goog.dependencies_.written[src] = true
    }
  };
  goog.writeScriptTag_ = function(src) {
    if(goog.inHtmlDocument_()) {
      var doc = goog.global.document;
      doc.write('<script type="text/javascript" src="' + src + '"></' + "script>");
      return true
    }else {
      return false
    }
  };
  goog.writeScripts_ = function() {
    var scripts = [];
    var seenScript = {};
    var deps = goog.dependencies_;
    function visitNode(path) {
      if(path in deps.written) {
        return
      }
      if(path in deps.visited) {
        if(!(path in seenScript)) {
          seenScript[path] = true;
          scripts.push(path)
        }
        return
      }
      deps.visited[path] = true;
      if(path in deps.requires) {
        for(var requireName in deps.requires[path]) {
          if(!goog.isProvided_(requireName)) {
            if(requireName in deps.nameToPath) {
              visitNode(deps.nameToPath[requireName])
            }else {
              throw Error("Undefined nameToPath for " + requireName);
            }
          }
        }
      }
      if(!(path in seenScript)) {
        seenScript[path] = true;
        scripts.push(path)
      }
    }
    for(var path in goog.included_) {
      if(!deps.written[path]) {
        visitNode(path)
      }
    }
    for(var i = 0;i < scripts.length;i++) {
      if(scripts[i]) {
        goog.importScript_(goog.basePath + scripts[i])
      }else {
        throw Error("Undefined script input");
      }
    }
  };
  goog.getPathFromDeps_ = function(rule) {
    if(rule in goog.dependencies_.nameToPath) {
      return goog.dependencies_.nameToPath[rule]
    }else {
      return null
    }
  };
  goog.findBasePath_();
  if(!goog.global.CLOSURE_NO_DEPS) {
    goog.importScript_(goog.basePath + "deps.js")
  }
}
goog.typeOf = function(value) {
  var s = typeof value;
  if(s == "object") {
    if(value) {
      if(value instanceof Array) {
        return"array"
      }else {
        if(value instanceof Object) {
          return s
        }
      }
      var className = Object.prototype.toString.call(value);
      if(className == "[object Window]") {
        return"object"
      }
      if(className == "[object Array]" || typeof value.length == "number" && typeof value.splice != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("splice")) {
        return"array"
      }
      if(className == "[object Function]" || typeof value.call != "undefined" && typeof value.propertyIsEnumerable != "undefined" && !value.propertyIsEnumerable("call")) {
        return"function"
      }
    }else {
      return"null"
    }
  }else {
    if(s == "function" && typeof value.call == "undefined") {
      return"object"
    }
  }
  return s
};
goog.propertyIsEnumerableCustom_ = function(object, propName) {
  if(propName in object) {
    for(var key in object) {
      if(key == propName && Object.prototype.hasOwnProperty.call(object, propName)) {
        return true
      }
    }
  }
  return false
};
goog.propertyIsEnumerable_ = function(object, propName) {
  if(object instanceof Object) {
    return Object.prototype.propertyIsEnumerable.call(object, propName)
  }else {
    return goog.propertyIsEnumerableCustom_(object, propName)
  }
};
goog.isDef = function(val) {
  return val !== undefined
};
goog.isNull = function(val) {
  return val === null
};
goog.isDefAndNotNull = function(val) {
  return val != null
};
goog.isArray = function(val) {
  return goog.typeOf(val) == "array"
};
goog.isArrayLike = function(val) {
  var type = goog.typeOf(val);
  return type == "array" || type == "object" && typeof val.length == "number"
};
goog.isDateLike = function(val) {
  return goog.isObject(val) && typeof val.getFullYear == "function"
};
goog.isString = function(val) {
  return typeof val == "string"
};
goog.isBoolean = function(val) {
  return typeof val == "boolean"
};
goog.isNumber = function(val) {
  return typeof val == "number"
};
goog.isFunction = function(val) {
  return goog.typeOf(val) == "function"
};
goog.isObject = function(val) {
  var type = goog.typeOf(val);
  return type == "object" || type == "array" || type == "function"
};
goog.getUid = function(obj) {
  return obj[goog.UID_PROPERTY_] || (obj[goog.UID_PROPERTY_] = ++goog.uidCounter_)
};
goog.removeUid = function(obj) {
  if("removeAttribute" in obj) {
    obj.removeAttribute(goog.UID_PROPERTY_)
  }
  try {
    delete obj[goog.UID_PROPERTY_]
  }catch(ex) {
  }
};
goog.UID_PROPERTY_ = "closure_uid_" + Math.floor(Math.random() * 2147483648).toString(36);
goog.uidCounter_ = 0;
goog.getHashCode = goog.getUid;
goog.removeHashCode = goog.removeUid;
goog.cloneObject = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.cloneObject(obj[key])
    }
    return clone
  }
  return obj
};
Object.prototype.clone;
goog.bindNative_ = function(fn, selfObj, var_args) {
  return fn.call.apply(fn.bind, arguments)
};
goog.bindJs_ = function(fn, selfObj, var_args) {
  if(!fn) {
    throw new Error;
  }
  if(arguments.length > 2) {
    var boundArgs = Array.prototype.slice.call(arguments, 2);
    return function() {
      var newArgs = Array.prototype.slice.call(arguments);
      Array.prototype.unshift.apply(newArgs, boundArgs);
      return fn.apply(selfObj, newArgs)
    }
  }else {
    return function() {
      return fn.apply(selfObj, arguments)
    }
  }
};
goog.bind = function(fn, selfObj, var_args) {
  if(Function.prototype.bind && Function.prototype.bind.toString().indexOf("native code") != -1) {
    goog.bind = goog.bindNative_
  }else {
    goog.bind = goog.bindJs_
  }
  return goog.bind.apply(null, arguments)
};
goog.partial = function(fn, var_args) {
  var args = Array.prototype.slice.call(arguments, 1);
  return function() {
    var newArgs = Array.prototype.slice.call(arguments);
    newArgs.unshift.apply(newArgs, args);
    return fn.apply(this, newArgs)
  }
};
goog.mixin = function(target, source) {
  for(var x in source) {
    target[x] = source[x]
  }
};
goog.now = Date.now || function() {
  return+new Date
};
goog.globalEval = function(script) {
  if(goog.global.execScript) {
    goog.global.execScript(script, "JavaScript")
  }else {
    if(goog.global.eval) {
      if(goog.evalWorksForGlobals_ == null) {
        goog.global.eval("var _et_ = 1;");
        if(typeof goog.global["_et_"] != "undefined") {
          delete goog.global["_et_"];
          goog.evalWorksForGlobals_ = true
        }else {
          goog.evalWorksForGlobals_ = false
        }
      }
      if(goog.evalWorksForGlobals_) {
        goog.global.eval(script)
      }else {
        var doc = goog.global.document;
        var scriptElt = doc.createElement("script");
        scriptElt.type = "text/javascript";
        scriptElt.defer = false;
        scriptElt.appendChild(doc.createTextNode(script));
        doc.body.appendChild(scriptElt);
        doc.body.removeChild(scriptElt)
      }
    }else {
      throw Error("goog.globalEval not available");
    }
  }
};
goog.evalWorksForGlobals_ = null;
goog.cssNameMapping_;
goog.cssNameMappingStyle_;
goog.getCssName = function(className, opt_modifier) {
  var getMapping = function(cssName) {
    return goog.cssNameMapping_[cssName] || cssName
  };
  var renameByParts = function(cssName) {
    var parts = cssName.split("-");
    var mapped = [];
    for(var i = 0;i < parts.length;i++) {
      mapped.push(getMapping(parts[i]))
    }
    return mapped.join("-")
  };
  var rename;
  if(goog.cssNameMapping_) {
    rename = goog.cssNameMappingStyle_ == "BY_WHOLE" ? getMapping : renameByParts
  }else {
    rename = function(a) {
      return a
    }
  }
  if(opt_modifier) {
    return className + "-" + rename(opt_modifier)
  }else {
    return rename(className)
  }
};
goog.setCssNameMapping = function(mapping, opt_style) {
  goog.cssNameMapping_ = mapping;
  goog.cssNameMappingStyle_ = opt_style
};
goog.global.CLOSURE_CSS_NAME_MAPPING;
if(!COMPILED && goog.global.CLOSURE_CSS_NAME_MAPPING) {
  goog.cssNameMapping_ = goog.global.CLOSURE_CSS_NAME_MAPPING
}
goog.getMsg = function(str, opt_values) {
  var values = opt_values || {};
  for(var key in values) {
    var value = ("" + values[key]).replace(/\$/g, "$$$$");
    str = str.replace(new RegExp("\\{\\$" + key + "\\}", "gi"), value)
  }
  return str
};
goog.exportSymbol = function(publicPath, object, opt_objectToExportTo) {
  goog.exportPath_(publicPath, object, opt_objectToExportTo)
};
goog.exportProperty = function(object, publicName, symbol) {
  object[publicName] = symbol
};
goog.inherits = function(childCtor, parentCtor) {
  function tempCtor() {
  }
  tempCtor.prototype = parentCtor.prototype;
  childCtor.superClass_ = parentCtor.prototype;
  childCtor.prototype = new tempCtor;
  childCtor.prototype.constructor = childCtor
};
goog.base = function(me, opt_methodName, var_args) {
  var caller = arguments.callee.caller;
  if(caller.superClass_) {
    return caller.superClass_.constructor.apply(me, Array.prototype.slice.call(arguments, 1))
  }
  var args = Array.prototype.slice.call(arguments, 2);
  var foundCaller = false;
  for(var ctor = me.constructor;ctor;ctor = ctor.superClass_ && ctor.superClass_.constructor) {
    if(ctor.prototype[opt_methodName] === caller) {
      foundCaller = true
    }else {
      if(foundCaller) {
        return ctor.prototype[opt_methodName].apply(me, args)
      }
    }
  }
  if(me[opt_methodName] === caller) {
    return me.constructor.prototype[opt_methodName].apply(me, args)
  }else {
    throw Error("goog.base called from a method of one name " + "to a method of a different name");
  }
};
goog.scope = function(fn) {
  fn.call(goog.global)
};
goog.provide("goog.string");
goog.provide("goog.string.Unicode");
goog.string.Unicode = {NBSP:"\u00a0"};
goog.string.startsWith = function(str, prefix) {
  return str.lastIndexOf(prefix, 0) == 0
};
goog.string.endsWith = function(str, suffix) {
  var l = str.length - suffix.length;
  return l >= 0 && str.indexOf(suffix, l) == l
};
goog.string.caseInsensitiveStartsWith = function(str, prefix) {
  return goog.string.caseInsensitiveCompare(prefix, str.substr(0, prefix.length)) == 0
};
goog.string.caseInsensitiveEndsWith = function(str, suffix) {
  return goog.string.caseInsensitiveCompare(suffix, str.substr(str.length - suffix.length, suffix.length)) == 0
};
goog.string.subs = function(str, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var replacement = String(arguments[i]).replace(/\$/g, "$$$$");
    str = str.replace(/\%s/, replacement)
  }
  return str
};
goog.string.collapseWhitespace = function(str) {
  return str.replace(/[\s\xa0]+/g, " ").replace(/^\s+|\s+$/g, "")
};
goog.string.isEmpty = function(str) {
  return/^[\s\xa0]*$/.test(str)
};
goog.string.isEmptySafe = function(str) {
  return goog.string.isEmpty(goog.string.makeSafe(str))
};
goog.string.isBreakingWhitespace = function(str) {
  return!/[^\t\n\r ]/.test(str)
};
goog.string.isAlpha = function(str) {
  return!/[^a-zA-Z]/.test(str)
};
goog.string.isNumeric = function(str) {
  return!/[^0-9]/.test(str)
};
goog.string.isAlphaNumeric = function(str) {
  return!/[^a-zA-Z0-9]/.test(str)
};
goog.string.isSpace = function(ch) {
  return ch == " "
};
goog.string.isUnicodeChar = function(ch) {
  return ch.length == 1 && ch >= " " && ch <= "~" || ch >= "\u0080" && ch <= "\ufffd"
};
goog.string.stripNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)+/g, " ")
};
goog.string.canonicalizeNewlines = function(str) {
  return str.replace(/(\r\n|\r|\n)/g, "\n")
};
goog.string.normalizeWhitespace = function(str) {
  return str.replace(/\xa0|\s/g, " ")
};
goog.string.normalizeSpaces = function(str) {
  return str.replace(/\xa0|[ \t]+/g, " ")
};
goog.string.collapseBreakingSpaces = function(str) {
  return str.replace(/[\t\r\n ]+/g, " ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g, "")
};
goog.string.trim = function(str) {
  return str.replace(/^[\s\xa0]+|[\s\xa0]+$/g, "")
};
goog.string.trimLeft = function(str) {
  return str.replace(/^[\s\xa0]+/, "")
};
goog.string.trimRight = function(str) {
  return str.replace(/[\s\xa0]+$/, "")
};
goog.string.caseInsensitiveCompare = function(str1, str2) {
  var test1 = String(str1).toLowerCase();
  var test2 = String(str2).toLowerCase();
  if(test1 < test2) {
    return-1
  }else {
    if(test1 == test2) {
      return 0
    }else {
      return 1
    }
  }
};
goog.string.numerateCompareRegExp_ = /(\.\d+)|(\d+)|(\D+)/g;
goog.string.numerateCompare = function(str1, str2) {
  if(str1 == str2) {
    return 0
  }
  if(!str1) {
    return-1
  }
  if(!str2) {
    return 1
  }
  var tokens1 = str1.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var tokens2 = str2.toLowerCase().match(goog.string.numerateCompareRegExp_);
  var count = Math.min(tokens1.length, tokens2.length);
  for(var i = 0;i < count;i++) {
    var a = tokens1[i];
    var b = tokens2[i];
    if(a != b) {
      var num1 = parseInt(a, 10);
      if(!isNaN(num1)) {
        var num2 = parseInt(b, 10);
        if(!isNaN(num2) && num1 - num2) {
          return num1 - num2
        }
      }
      return a < b ? -1 : 1
    }
  }
  if(tokens1.length != tokens2.length) {
    return tokens1.length - tokens2.length
  }
  return str1 < str2 ? -1 : 1
};
goog.string.encodeUriRegExp_ = /^[a-zA-Z0-9\-_.!~*'()]*$/;
goog.string.urlEncode = function(str) {
  str = String(str);
  if(!goog.string.encodeUriRegExp_.test(str)) {
    return encodeURIComponent(str)
  }
  return str
};
goog.string.urlDecode = function(str) {
  return decodeURIComponent(str.replace(/\+/g, " "))
};
goog.string.newLineToBr = function(str, opt_xml) {
  return str.replace(/(\r\n|\r|\n)/g, opt_xml ? "<br />" : "<br>")
};
goog.string.htmlEscape = function(str, opt_isLikelyToContainHtmlChars) {
  if(opt_isLikelyToContainHtmlChars) {
    return str.replace(goog.string.amperRe_, "&amp;").replace(goog.string.ltRe_, "&lt;").replace(goog.string.gtRe_, "&gt;").replace(goog.string.quotRe_, "&quot;")
  }else {
    if(!goog.string.allRe_.test(str)) {
      return str
    }
    if(str.indexOf("&") != -1) {
      str = str.replace(goog.string.amperRe_, "&amp;")
    }
    if(str.indexOf("<") != -1) {
      str = str.replace(goog.string.ltRe_, "&lt;")
    }
    if(str.indexOf(">") != -1) {
      str = str.replace(goog.string.gtRe_, "&gt;")
    }
    if(str.indexOf('"') != -1) {
      str = str.replace(goog.string.quotRe_, "&quot;")
    }
    return str
  }
};
goog.string.amperRe_ = /&/g;
goog.string.ltRe_ = /</g;
goog.string.gtRe_ = />/g;
goog.string.quotRe_ = /\"/g;
goog.string.allRe_ = /[&<>\"]/;
goog.string.unescapeEntities = function(str) {
  if(goog.string.contains(str, "&")) {
    if("document" in goog.global) {
      return goog.string.unescapeEntitiesUsingDom_(str)
    }else {
      return goog.string.unescapePureXmlEntities_(str)
    }
  }
  return str
};
goog.string.unescapeEntitiesUsingDom_ = function(str) {
  var seen = {"&amp;":"&", "&lt;":"<", "&gt;":">", "&quot;":'"'};
  var div = document.createElement("div");
  return str.replace(goog.string.HTML_ENTITY_PATTERN_, function(s, entity) {
    var value = seen[s];
    if(value) {
      return value
    }
    if(entity.charAt(0) == "#") {
      var n = Number("0" + entity.substr(1));
      if(!isNaN(n)) {
        value = String.fromCharCode(n)
      }
    }
    if(!value) {
      div.innerHTML = s + " ";
      value = div.firstChild.nodeValue.slice(0, -1)
    }
    return seen[s] = value
  })
};
goog.string.unescapePureXmlEntities_ = function(str) {
  return str.replace(/&([^;]+);/g, function(s, entity) {
    switch(entity) {
      case "amp":
        return"&";
      case "lt":
        return"<";
      case "gt":
        return">";
      case "quot":
        return'"';
      default:
        if(entity.charAt(0) == "#") {
          var n = Number("0" + entity.substr(1));
          if(!isNaN(n)) {
            return String.fromCharCode(n)
          }
        }
        return s
    }
  })
};
goog.string.HTML_ENTITY_PATTERN_ = /&([^;\s<&]+);?/g;
goog.string.whitespaceEscape = function(str, opt_xml) {
  return goog.string.newLineToBr(str.replace(/  /g, " &#160;"), opt_xml)
};
goog.string.stripQuotes = function(str, quoteChars) {
  var length = quoteChars.length;
  for(var i = 0;i < length;i++) {
    var quoteChar = length == 1 ? quoteChars : quoteChars.charAt(i);
    if(str.charAt(0) == quoteChar && str.charAt(str.length - 1) == quoteChar) {
      return str.substring(1, str.length - 1)
    }
  }
  return str
};
goog.string.truncate = function(str, chars, opt_protectEscapedCharacters) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(str.length > chars) {
    str = str.substring(0, chars - 3) + "..."
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.truncateMiddle = function(str, chars, opt_protectEscapedCharacters, opt_trailingChars) {
  if(opt_protectEscapedCharacters) {
    str = goog.string.unescapeEntities(str)
  }
  if(opt_trailingChars && str.length > chars) {
    if(opt_trailingChars > chars) {
      opt_trailingChars = chars
    }
    var endPoint = str.length - opt_trailingChars;
    var startPoint = chars - opt_trailingChars;
    str = str.substring(0, startPoint) + "..." + str.substring(endPoint)
  }else {
    if(str.length > chars) {
      var half = Math.floor(chars / 2);
      var endPos = str.length - half;
      half += chars % 2;
      str = str.substring(0, half) + "..." + str.substring(endPos)
    }
  }
  if(opt_protectEscapedCharacters) {
    str = goog.string.htmlEscape(str)
  }
  return str
};
goog.string.specialEscapeChars_ = {"\x00":"\\0", "\u0008":"\\b", "\u000c":"\\f", "\n":"\\n", "\r":"\\r", "\t":"\\t", "\x0B":"\\x0B", '"':'\\"', "\\":"\\\\"};
goog.string.jsEscapeCache_ = {"'":"\\'"};
goog.string.quote = function(s) {
  s = String(s);
  if(s.quote) {
    return s.quote()
  }else {
    var sb = ['"'];
    for(var i = 0;i < s.length;i++) {
      var ch = s.charAt(i);
      var cc = ch.charCodeAt(0);
      sb[i + 1] = goog.string.specialEscapeChars_[ch] || (cc > 31 && cc < 127 ? ch : goog.string.escapeChar(ch))
    }
    sb.push('"');
    return sb.join("")
  }
};
goog.string.escapeString = function(str) {
  var sb = [];
  for(var i = 0;i < str.length;i++) {
    sb[i] = goog.string.escapeChar(str.charAt(i))
  }
  return sb.join("")
};
goog.string.escapeChar = function(c) {
  if(c in goog.string.jsEscapeCache_) {
    return goog.string.jsEscapeCache_[c]
  }
  if(c in goog.string.specialEscapeChars_) {
    return goog.string.jsEscapeCache_[c] = goog.string.specialEscapeChars_[c]
  }
  var rv = c;
  var cc = c.charCodeAt(0);
  if(cc > 31 && cc < 127) {
    rv = c
  }else {
    if(cc < 256) {
      rv = "\\x";
      if(cc < 16 || cc > 256) {
        rv += "0"
      }
    }else {
      rv = "\\u";
      if(cc < 4096) {
        rv += "0"
      }
    }
    rv += cc.toString(16).toUpperCase()
  }
  return goog.string.jsEscapeCache_[c] = rv
};
goog.string.toMap = function(s) {
  var rv = {};
  for(var i = 0;i < s.length;i++) {
    rv[s.charAt(i)] = true
  }
  return rv
};
goog.string.contains = function(s, ss) {
  return s.indexOf(ss) != -1
};
goog.string.removeAt = function(s, index, stringLength) {
  var resultStr = s;
  if(index >= 0 && index < s.length && stringLength > 0) {
    resultStr = s.substr(0, index) + s.substr(index + stringLength, s.length - index - stringLength)
  }
  return resultStr
};
goog.string.remove = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "");
  return s.replace(re, "")
};
goog.string.removeAll = function(s, ss) {
  var re = new RegExp(goog.string.regExpEscape(ss), "g");
  return s.replace(re, "")
};
goog.string.regExpEscape = function(s) {
  return String(s).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g, "\\$1").replace(/\x08/g, "\\x08")
};
goog.string.repeat = function(string, length) {
  return(new Array(length + 1)).join(string)
};
goog.string.padNumber = function(num, length, opt_precision) {
  var s = goog.isDef(opt_precision) ? num.toFixed(opt_precision) : String(num);
  var index = s.indexOf(".");
  if(index == -1) {
    index = s.length
  }
  return goog.string.repeat("0", Math.max(0, length - index)) + s
};
goog.string.makeSafe = function(obj) {
  return obj == null ? "" : String(obj)
};
goog.string.buildString = function(var_args) {
  return Array.prototype.join.call(arguments, "")
};
goog.string.getRandomString = function() {
  var x = 2147483648;
  return Math.floor(Math.random() * x).toString(36) + Math.abs(Math.floor(Math.random() * x) ^ goog.now()).toString(36)
};
goog.string.compareVersions = function(version1, version2) {
  var order = 0;
  var v1Subs = goog.string.trim(String(version1)).split(".");
  var v2Subs = goog.string.trim(String(version2)).split(".");
  var subCount = Math.max(v1Subs.length, v2Subs.length);
  for(var subIdx = 0;order == 0 && subIdx < subCount;subIdx++) {
    var v1Sub = v1Subs[subIdx] || "";
    var v2Sub = v2Subs[subIdx] || "";
    var v1CompParser = new RegExp("(\\d*)(\\D*)", "g");
    var v2CompParser = new RegExp("(\\d*)(\\D*)", "g");
    do {
      var v1Comp = v1CompParser.exec(v1Sub) || ["", "", ""];
      var v2Comp = v2CompParser.exec(v2Sub) || ["", "", ""];
      if(v1Comp[0].length == 0 && v2Comp[0].length == 0) {
        break
      }
      var v1CompNum = v1Comp[1].length == 0 ? 0 : parseInt(v1Comp[1], 10);
      var v2CompNum = v2Comp[1].length == 0 ? 0 : parseInt(v2Comp[1], 10);
      order = goog.string.compareElements_(v1CompNum, v2CompNum) || goog.string.compareElements_(v1Comp[2].length == 0, v2Comp[2].length == 0) || goog.string.compareElements_(v1Comp[2], v2Comp[2])
    }while(order == 0)
  }
  return order
};
goog.string.compareElements_ = function(left, right) {
  if(left < right) {
    return-1
  }else {
    if(left > right) {
      return 1
    }
  }
  return 0
};
goog.string.HASHCODE_MAX_ = 4294967296;
goog.string.hashCode = function(str) {
  var result = 0;
  for(var i = 0;i < str.length;++i) {
    result = 31 * result + str.charCodeAt(i);
    result %= goog.string.HASHCODE_MAX_
  }
  return result
};
goog.string.uniqueStringCounter_ = Math.random() * 2147483648 | 0;
goog.string.createUniqueString = function() {
  return"goog_" + goog.string.uniqueStringCounter_++
};
goog.string.toNumber = function(str) {
  var num = Number(str);
  if(num == 0 && goog.string.isEmpty(str)) {
    return NaN
  }
  return num
};
goog.string.toCamelCaseCache_ = {};
goog.string.toCamelCase = function(str) {
  return goog.string.toCamelCaseCache_[str] || (goog.string.toCamelCaseCache_[str] = String(str).replace(/\-([a-z])/g, function(all, match) {
    return match.toUpperCase()
  }))
};
goog.string.toSelectorCaseCache_ = {};
goog.string.toSelectorCase = function(str) {
  return goog.string.toSelectorCaseCache_[str] || (goog.string.toSelectorCaseCache_[str] = String(str).replace(/([A-Z])/g, "-$1").toLowerCase())
};
goog.provide("goog.debug.Error");
goog.debug.Error = function(opt_msg) {
  this.stack = (new Error).stack || "";
  if(opt_msg) {
    this.message = String(opt_msg)
  }
};
goog.inherits(goog.debug.Error, Error);
goog.debug.Error.prototype.name = "CustomError";
goog.provide("goog.asserts");
goog.provide("goog.asserts.AssertionError");
goog.require("goog.debug.Error");
goog.require("goog.string");
goog.asserts.ENABLE_ASSERTS = goog.DEBUG;
goog.asserts.AssertionError = function(messagePattern, messageArgs) {
  messageArgs.unshift(messagePattern);
  goog.debug.Error.call(this, goog.string.subs.apply(null, messageArgs));
  messageArgs.shift();
  this.messagePattern = messagePattern
};
goog.inherits(goog.asserts.AssertionError, goog.debug.Error);
goog.asserts.AssertionError.prototype.name = "AssertionError";
goog.asserts.doAssertFailure_ = function(defaultMessage, defaultArgs, givenMessage, givenArgs) {
  var message = "Assertion failed";
  if(givenMessage) {
    message += ": " + givenMessage;
    var args = givenArgs
  }else {
    if(defaultMessage) {
      message += ": " + defaultMessage;
      args = defaultArgs
    }
  }
  throw new goog.asserts.AssertionError("" + message, args || []);
};
goog.asserts.assert = function(condition, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !condition) {
    goog.asserts.doAssertFailure_("", null, opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return condition
};
goog.asserts.fail = function(opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS) {
    throw new goog.asserts.AssertionError("Failure" + (opt_message ? ": " + opt_message : ""), Array.prototype.slice.call(arguments, 1));
  }
};
goog.asserts.assertNumber = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isNumber(value)) {
    goog.asserts.doAssertFailure_("Expected number but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertString = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isString(value)) {
    goog.asserts.doAssertFailure_("Expected string but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertFunction = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isFunction(value)) {
    goog.asserts.doAssertFailure_("Expected function but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertObject = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isObject(value)) {
    goog.asserts.doAssertFailure_("Expected object but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertArray = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isArray(value)) {
    goog.asserts.doAssertFailure_("Expected array but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertBoolean = function(value, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !goog.isBoolean(value)) {
    goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.", [goog.typeOf(value), value], opt_message, Array.prototype.slice.call(arguments, 2))
  }
  return value
};
goog.asserts.assertInstanceof = function(value, type, opt_message, var_args) {
  if(goog.asserts.ENABLE_ASSERTS && !(value instanceof type)) {
    goog.asserts.doAssertFailure_("instanceof check failed.", null, opt_message, Array.prototype.slice.call(arguments, 3))
  }
};
goog.provide("goog.array");
goog.provide("goog.array.ArrayLike");
goog.require("goog.asserts");
goog.NATIVE_ARRAY_PROTOTYPES = true;
goog.array.ArrayLike;
goog.array.peek = function(array) {
  return array[array.length - 1]
};
goog.array.ARRAY_PROTOTYPE_ = Array.prototype;
goog.array.indexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.indexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.indexOf.call(arr, obj, opt_fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? 0 : opt_fromIndex < 0 ? Math.max(0, arr.length + opt_fromIndex) : opt_fromIndex;
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.indexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i < arr.length;i++) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.lastIndexOf = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.lastIndexOf ? function(arr, obj, opt_fromIndex) {
  goog.asserts.assert(arr.length != null);
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  return goog.array.ARRAY_PROTOTYPE_.lastIndexOf.call(arr, obj, fromIndex)
} : function(arr, obj, opt_fromIndex) {
  var fromIndex = opt_fromIndex == null ? arr.length - 1 : opt_fromIndex;
  if(fromIndex < 0) {
    fromIndex = Math.max(0, arr.length + fromIndex)
  }
  if(goog.isString(arr)) {
    if(!goog.isString(obj) || obj.length != 1) {
      return-1
    }
    return arr.lastIndexOf(obj, fromIndex)
  }
  for(var i = fromIndex;i >= 0;i--) {
    if(i in arr && arr[i] === obj) {
      return i
    }
  }
  return-1
};
goog.array.forEach = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.forEach ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.forEach.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.forEachRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;--i) {
    if(i in arr2) {
      f.call(opt_obj, arr2[i], i, arr)
    }
  }
};
goog.array.filter = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.filter ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.filter.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = [];
  var resLength = 0;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      var val = arr2[i];
      if(f.call(opt_obj, val, i, arr)) {
        res[resLength++] = val
      }
    }
  }
  return res
};
goog.array.map = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.map ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.map.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var res = new Array(l);
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2) {
      res[i] = f.call(opt_obj, arr2[i], i, arr)
    }
  }
  return res
};
goog.array.reduce = function(arr, f, val, opt_obj) {
  if(arr.reduce) {
    if(opt_obj) {
      return arr.reduce(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduce(f, val)
    }
  }
  var rval = val;
  goog.array.forEach(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.reduceRight = function(arr, f, val, opt_obj) {
  if(arr.reduceRight) {
    if(opt_obj) {
      return arr.reduceRight(goog.bind(f, opt_obj), val)
    }else {
      return arr.reduceRight(f, val)
    }
  }
  var rval = val;
  goog.array.forEachRight(arr, function(val, index) {
    rval = f.call(opt_obj, rval, val, index, arr)
  });
  return rval
};
goog.array.some = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.some ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.some.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return true
    }
  }
  return false
};
goog.array.every = goog.NATIVE_ARRAY_PROTOTYPES && goog.array.ARRAY_PROTOTYPE_.every ? function(arr, f, opt_obj) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.every.call(arr, f, opt_obj)
} : function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && !f.call(opt_obj, arr2[i], i, arr)) {
      return false
    }
  }
  return true
};
goog.array.find = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndex = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = 0;i < l;i++) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.findRight = function(arr, f, opt_obj) {
  var i = goog.array.findIndexRight(arr, f, opt_obj);
  return i < 0 ? null : goog.isString(arr) ? arr.charAt(i) : arr[i]
};
goog.array.findIndexRight = function(arr, f, opt_obj) {
  var l = arr.length;
  var arr2 = goog.isString(arr) ? arr.split("") : arr;
  for(var i = l - 1;i >= 0;i--) {
    if(i in arr2 && f.call(opt_obj, arr2[i], i, arr)) {
      return i
    }
  }
  return-1
};
goog.array.contains = function(arr, obj) {
  return goog.array.indexOf(arr, obj) >= 0
};
goog.array.isEmpty = function(arr) {
  return arr.length == 0
};
goog.array.clear = function(arr) {
  if(!goog.isArray(arr)) {
    for(var i = arr.length - 1;i >= 0;i--) {
      delete arr[i]
    }
  }
  arr.length = 0
};
goog.array.insert = function(arr, obj) {
  if(!goog.array.contains(arr, obj)) {
    arr.push(obj)
  }
};
goog.array.insertAt = function(arr, obj, opt_i) {
  goog.array.splice(arr, opt_i, 0, obj)
};
goog.array.insertArrayAt = function(arr, elementsToAdd, opt_i) {
  goog.partial(goog.array.splice, arr, opt_i, 0).apply(null, elementsToAdd)
};
goog.array.insertBefore = function(arr, obj, opt_obj2) {
  var i;
  if(arguments.length == 2 || (i = goog.array.indexOf(arr, opt_obj2)) < 0) {
    arr.push(obj)
  }else {
    goog.array.insertAt(arr, obj, i)
  }
};
goog.array.remove = function(arr, obj) {
  var i = goog.array.indexOf(arr, obj);
  var rv;
  if(rv = i >= 0) {
    goog.array.removeAt(arr, i)
  }
  return rv
};
goog.array.removeAt = function(arr, i) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.call(arr, i, 1).length == 1
};
goog.array.removeIf = function(arr, f, opt_obj) {
  var i = goog.array.findIndex(arr, f, opt_obj);
  if(i >= 0) {
    goog.array.removeAt(arr, i);
    return true
  }
  return false
};
goog.array.concat = function(var_args) {
  return goog.array.ARRAY_PROTOTYPE_.concat.apply(goog.array.ARRAY_PROTOTYPE_, arguments)
};
goog.array.clone = function(arr) {
  if(goog.isArray(arr)) {
    return goog.array.concat(arr)
  }else {
    var rv = [];
    for(var i = 0, len = arr.length;i < len;i++) {
      rv[i] = arr[i]
    }
    return rv
  }
};
goog.array.toArray = function(object) {
  if(goog.isArray(object)) {
    return goog.array.concat(object)
  }
  return goog.array.clone(object)
};
goog.array.extend = function(arr1, var_args) {
  for(var i = 1;i < arguments.length;i++) {
    var arr2 = arguments[i];
    var isArrayLike;
    if(goog.isArray(arr2) || (isArrayLike = goog.isArrayLike(arr2)) && arr2.hasOwnProperty("callee")) {
      arr1.push.apply(arr1, arr2)
    }else {
      if(isArrayLike) {
        var len1 = arr1.length;
        var len2 = arr2.length;
        for(var j = 0;j < len2;j++) {
          arr1[len1 + j] = arr2[j]
        }
      }else {
        arr1.push(arr2)
      }
    }
  }
};
goog.array.splice = function(arr, index, howMany, var_args) {
  goog.asserts.assert(arr.length != null);
  return goog.array.ARRAY_PROTOTYPE_.splice.apply(arr, goog.array.slice(arguments, 1))
};
goog.array.slice = function(arr, start, opt_end) {
  goog.asserts.assert(arr.length != null);
  if(arguments.length <= 2) {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start)
  }else {
    return goog.array.ARRAY_PROTOTYPE_.slice.call(arr, start, opt_end)
  }
};
goog.array.removeDuplicates = function(arr, opt_rv) {
  var returnArray = opt_rv || arr;
  var seen = {}, cursorInsert = 0, cursorRead = 0;
  while(cursorRead < arr.length) {
    var current = arr[cursorRead++];
    var key = goog.isObject(current) ? "o" + goog.getUid(current) : (typeof current).charAt(0) + current;
    if(!Object.prototype.hasOwnProperty.call(seen, key)) {
      seen[key] = true;
      returnArray[cursorInsert++] = current
    }
  }
  returnArray.length = cursorInsert
};
goog.array.binarySearch = function(arr, target, opt_compareFn) {
  return goog.array.binarySearch_(arr, opt_compareFn || goog.array.defaultCompare, false, target)
};
goog.array.binarySelect = function(arr, evaluator, opt_obj) {
  return goog.array.binarySearch_(arr, evaluator, true, undefined, opt_obj)
};
goog.array.binarySearch_ = function(arr, compareFn, isEvaluator, opt_target, opt_selfObj) {
  var left = 0;
  var right = arr.length;
  var found;
  while(left < right) {
    var middle = left + right >> 1;
    var compareResult;
    if(isEvaluator) {
      compareResult = compareFn.call(opt_selfObj, arr[middle], middle, arr)
    }else {
      compareResult = compareFn(opt_target, arr[middle])
    }
    if(compareResult > 0) {
      left = middle + 1
    }else {
      right = middle;
      found = !compareResult
    }
  }
  return found ? left : ~left
};
goog.array.sort = function(arr, opt_compareFn) {
  goog.asserts.assert(arr.length != null);
  goog.array.ARRAY_PROTOTYPE_.sort.call(arr, opt_compareFn || goog.array.defaultCompare)
};
goog.array.stableSort = function(arr, opt_compareFn) {
  for(var i = 0;i < arr.length;i++) {
    arr[i] = {index:i, value:arr[i]}
  }
  var valueCompareFn = opt_compareFn || goog.array.defaultCompare;
  function stableCompareFn(obj1, obj2) {
    return valueCompareFn(obj1.value, obj2.value) || obj1.index - obj2.index
  }
  goog.array.sort(arr, stableCompareFn);
  for(var i = 0;i < arr.length;i++) {
    arr[i] = arr[i].value
  }
};
goog.array.sortObjectsByKey = function(arr, key, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  goog.array.sort(arr, function(a, b) {
    return compare(a[key], b[key])
  })
};
goog.array.isSorted = function(arr, opt_compareFn, opt_strict) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  for(var i = 1;i < arr.length;i++) {
    var compareResult = compare(arr[i - 1], arr[i]);
    if(compareResult > 0 || compareResult == 0 && opt_strict) {
      return false
    }
  }
  return true
};
goog.array.equals = function(arr1, arr2, opt_equalsFn) {
  if(!goog.isArrayLike(arr1) || !goog.isArrayLike(arr2) || arr1.length != arr2.length) {
    return false
  }
  var l = arr1.length;
  var equalsFn = opt_equalsFn || goog.array.defaultCompareEquality;
  for(var i = 0;i < l;i++) {
    if(!equalsFn(arr1[i], arr2[i])) {
      return false
    }
  }
  return true
};
goog.array.compare = function(arr1, arr2, opt_equalsFn) {
  return goog.array.equals(arr1, arr2, opt_equalsFn)
};
goog.array.compare3 = function(arr1, arr2, opt_compareFn) {
  var compare = opt_compareFn || goog.array.defaultCompare;
  var l = Math.min(arr1.length, arr2.length);
  for(var i = 0;i < l;i++) {
    var result = compare(arr1[i], arr2[i]);
    if(result != 0) {
      return result
    }
  }
  return goog.array.defaultCompare(arr1.length, arr2.length)
};
goog.array.defaultCompare = function(a, b) {
  return a > b ? 1 : a < b ? -1 : 0
};
goog.array.defaultCompareEquality = function(a, b) {
  return a === b
};
goog.array.binaryInsert = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  if(index < 0) {
    goog.array.insertAt(array, value, -(index + 1));
    return true
  }
  return false
};
goog.array.binaryRemove = function(array, value, opt_compareFn) {
  var index = goog.array.binarySearch(array, value, opt_compareFn);
  return index >= 0 ? goog.array.removeAt(array, index) : false
};
goog.array.bucket = function(array, sorter) {
  var buckets = {};
  for(var i = 0;i < array.length;i++) {
    var value = array[i];
    var key = sorter(value, i, array);
    if(goog.isDef(key)) {
      var bucket = buckets[key] || (buckets[key] = []);
      bucket.push(value)
    }
  }
  return buckets
};
goog.array.repeat = function(value, n) {
  var array = [];
  for(var i = 0;i < n;i++) {
    array[i] = value
  }
  return array
};
goog.array.flatten = function(var_args) {
  var result = [];
  for(var i = 0;i < arguments.length;i++) {
    var element = arguments[i];
    if(goog.isArray(element)) {
      result.push.apply(result, goog.array.flatten.apply(null, element))
    }else {
      result.push(element)
    }
  }
  return result
};
goog.array.rotate = function(array, n) {
  goog.asserts.assert(array.length != null);
  if(array.length) {
    n %= array.length;
    if(n > 0) {
      goog.array.ARRAY_PROTOTYPE_.unshift.apply(array, array.splice(-n, n))
    }else {
      if(n < 0) {
        goog.array.ARRAY_PROTOTYPE_.push.apply(array, array.splice(0, -n))
      }
    }
  }
  return array
};
goog.array.zip = function(var_args) {
  if(!arguments.length) {
    return[]
  }
  var result = [];
  for(var i = 0;true;i++) {
    var value = [];
    for(var j = 0;j < arguments.length;j++) {
      var arr = arguments[j];
      if(i >= arr.length) {
        return result
      }
      value.push(arr[i])
    }
    result.push(value)
  }
};
goog.array.shuffle = function(arr, opt_randFn) {
  var randFn = opt_randFn || Math.random;
  for(var i = arr.length - 1;i > 0;i--) {
    var j = Math.floor(randFn() * (i + 1));
    var tmp = arr[i];
    arr[i] = arr[j];
    arr[j] = tmp
  }
};
goog.provide("goog.object");
goog.object.forEach = function(obj, f, opt_obj) {
  for(var key in obj) {
    f.call(opt_obj, obj[key], key, obj)
  }
};
goog.object.filter = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      res[key] = obj[key]
    }
  }
  return res
};
goog.object.map = function(obj, f, opt_obj) {
  var res = {};
  for(var key in obj) {
    res[key] = f.call(opt_obj, obj[key], key, obj)
  }
  return res
};
goog.object.some = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(f.call(opt_obj, obj[key], key, obj)) {
      return true
    }
  }
  return false
};
goog.object.every = function(obj, f, opt_obj) {
  for(var key in obj) {
    if(!f.call(opt_obj, obj[key], key, obj)) {
      return false
    }
  }
  return true
};
goog.object.getCount = function(obj) {
  var rv = 0;
  for(var key in obj) {
    rv++
  }
  return rv
};
goog.object.getAnyKey = function(obj) {
  for(var key in obj) {
    return key
  }
};
goog.object.getAnyValue = function(obj) {
  for(var key in obj) {
    return obj[key]
  }
};
goog.object.contains = function(obj, val) {
  return goog.object.containsValue(obj, val)
};
goog.object.getValues = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = obj[key]
  }
  return res
};
goog.object.getKeys = function(obj) {
  var res = [];
  var i = 0;
  for(var key in obj) {
    res[i++] = key
  }
  return res
};
goog.object.getValueByKeys = function(obj, var_args) {
  var isArrayLike = goog.isArrayLike(var_args);
  var keys = isArrayLike ? var_args : arguments;
  for(var i = isArrayLike ? 0 : 1;i < keys.length;i++) {
    obj = obj[keys[i]];
    if(!goog.isDef(obj)) {
      break
    }
  }
  return obj
};
goog.object.containsKey = function(obj, key) {
  return key in obj
};
goog.object.containsValue = function(obj, val) {
  for(var key in obj) {
    if(obj[key] == val) {
      return true
    }
  }
  return false
};
goog.object.findKey = function(obj, f, opt_this) {
  for(var key in obj) {
    if(f.call(opt_this, obj[key], key, obj)) {
      return key
    }
  }
  return undefined
};
goog.object.findValue = function(obj, f, opt_this) {
  var key = goog.object.findKey(obj, f, opt_this);
  return key && obj[key]
};
goog.object.isEmpty = function(obj) {
  for(var key in obj) {
    return false
  }
  return true
};
goog.object.clear = function(obj) {
  for(var i in obj) {
    delete obj[i]
  }
};
goog.object.remove = function(obj, key) {
  var rv;
  if(rv = key in obj) {
    delete obj[key]
  }
  return rv
};
goog.object.add = function(obj, key, val) {
  if(key in obj) {
    throw Error('The object already contains the key "' + key + '"');
  }
  goog.object.set(obj, key, val)
};
goog.object.get = function(obj, key, opt_val) {
  if(key in obj) {
    return obj[key]
  }
  return opt_val
};
goog.object.set = function(obj, key, value) {
  obj[key] = value
};
goog.object.setIfUndefined = function(obj, key, value) {
  return key in obj ? obj[key] : obj[key] = value
};
goog.object.clone = function(obj) {
  var res = {};
  for(var key in obj) {
    res[key] = obj[key]
  }
  return res
};
goog.object.unsafeClone = function(obj) {
  var type = goog.typeOf(obj);
  if(type == "object" || type == "array") {
    if(obj.clone) {
      return obj.clone()
    }
    var clone = type == "array" ? [] : {};
    for(var key in obj) {
      clone[key] = goog.object.unsafeClone(obj[key])
    }
    return clone
  }
  return obj
};
goog.object.transpose = function(obj) {
  var transposed = {};
  for(var key in obj) {
    transposed[obj[key]] = key
  }
  return transposed
};
goog.object.PROTOTYPE_FIELDS_ = ["constructor", "hasOwnProperty", "isPrototypeOf", "propertyIsEnumerable", "toLocaleString", "toString", "valueOf"];
goog.object.extend = function(target, var_args) {
  var key, source;
  for(var i = 1;i < arguments.length;i++) {
    source = arguments[i];
    for(key in source) {
      target[key] = source[key]
    }
    for(var j = 0;j < goog.object.PROTOTYPE_FIELDS_.length;j++) {
      key = goog.object.PROTOTYPE_FIELDS_[j];
      if(Object.prototype.hasOwnProperty.call(source, key)) {
        target[key] = source[key]
      }
    }
  }
};
goog.object.create = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.create.apply(null, arguments[0])
  }
  if(argLength % 2) {
    throw Error("Uneven number of arguments");
  }
  var rv = {};
  for(var i = 0;i < argLength;i += 2) {
    rv[arguments[i]] = arguments[i + 1]
  }
  return rv
};
goog.object.createSet = function(var_args) {
  var argLength = arguments.length;
  if(argLength == 1 && goog.isArray(arguments[0])) {
    return goog.object.createSet.apply(null, arguments[0])
  }
  var rv = {};
  for(var i = 0;i < argLength;i++) {
    rv[arguments[i]] = true
  }
  return rv
};
goog.provide("goog.string.format");
goog.require("goog.string");
goog.string.format = function(formatString, var_args) {
  var args = Array.prototype.slice.call(arguments);
  var template = args.shift();
  if(typeof template == "undefined") {
    throw Error("[goog.string.format] Template required");
  }
  var formatRe = /%([0\-\ \+]*)(\d+)?(\.(\d+))?([%sfdiu])/g;
  function replacerDemuxer(match, flags, width, dotp, precision, type, offset, wholeString) {
    if(type == "%") {
      return"%"
    }
    var value = args.shift();
    if(typeof value == "undefined") {
      throw Error("[goog.string.format] Not enough arguments");
    }
    arguments[0] = value;
    return goog.string.format.demuxes_[type].apply(null, arguments)
  }
  return template.replace(formatRe, replacerDemuxer)
};
goog.string.format.demuxes_ = {};
goog.string.format.demuxes_["s"] = function(value, flags, width, dotp, precision, type, offset, wholeString) {
  var replacement = value;
  if(isNaN(width) || width == "" || replacement.length >= width) {
    return replacement
  }
  if(flags.indexOf("-", 0) > -1) {
    replacement = replacement + goog.string.repeat(" ", width - replacement.length)
  }else {
    replacement = goog.string.repeat(" ", width - replacement.length) + replacement
  }
  return replacement
};
goog.string.format.demuxes_["f"] = function(value, flags, width, dotp, precision, type, offset, wholeString) {
  var replacement = value.toString();
  if(!(isNaN(precision) || precision == "")) {
    replacement = value.toFixed(precision)
  }
  var sign;
  if(value < 0) {
    sign = "-"
  }else {
    if(flags.indexOf("+") >= 0) {
      sign = "+"
    }else {
      if(flags.indexOf(" ") >= 0) {
        sign = " "
      }else {
        sign = ""
      }
    }
  }
  if(value >= 0) {
    replacement = sign + replacement
  }
  if(isNaN(width) || replacement.length >= width) {
    return replacement
  }
  replacement = isNaN(precision) ? Math.abs(value).toString() : Math.abs(value).toFixed(precision);
  var padCount = width - replacement.length - sign.length;
  if(flags.indexOf("-", 0) >= 0) {
    replacement = sign + replacement + goog.string.repeat(" ", padCount)
  }else {
    var paddingChar = flags.indexOf("0", 0) >= 0 ? "0" : " ";
    replacement = sign + goog.string.repeat(paddingChar, padCount) + replacement
  }
  return replacement
};
goog.string.format.demuxes_["d"] = function(value, flags, width, dotp, precision, type, offset, wholeString) {
  return goog.string.format.demuxes_["f"](parseInt(value, 10), flags, width, dotp, 0, type, offset, wholeString)
};
goog.string.format.demuxes_["i"] = goog.string.format.demuxes_["d"];
goog.string.format.demuxes_["u"] = goog.string.format.demuxes_["d"];
goog.provide("goog.userAgent.jscript");
goog.require("goog.string");
goog.userAgent.jscript.ASSUME_NO_JSCRIPT = false;
goog.userAgent.jscript.init_ = function() {
  var hasScriptEngine = "ScriptEngine" in goog.global;
  goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ = hasScriptEngine && goog.global["ScriptEngine"]() == "JScript";
  goog.userAgent.jscript.DETECTED_VERSION_ = goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_ ? goog.global["ScriptEngineMajorVersion"]() + "." + goog.global["ScriptEngineMinorVersion"]() + "." + goog.global["ScriptEngineBuildVersion"]() : "0"
};
if(!goog.userAgent.jscript.ASSUME_NO_JSCRIPT) {
  goog.userAgent.jscript.init_()
}
goog.userAgent.jscript.HAS_JSCRIPT = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? false : goog.userAgent.jscript.DETECTED_HAS_JSCRIPT_;
goog.userAgent.jscript.VERSION = goog.userAgent.jscript.ASSUME_NO_JSCRIPT ? "0" : goog.userAgent.jscript.DETECTED_VERSION_;
goog.userAgent.jscript.isVersion = function(version) {
  return goog.string.compareVersions(goog.userAgent.jscript.VERSION, version) >= 0
};
goog.provide("goog.string.StringBuffer");
goog.require("goog.userAgent.jscript");
goog.string.StringBuffer = function(opt_a1, var_args) {
  this.buffer_ = goog.userAgent.jscript.HAS_JSCRIPT ? [] : "";
  if(opt_a1 != null) {
    this.append.apply(this, arguments)
  }
};
goog.string.StringBuffer.prototype.set = function(s) {
  this.clear();
  this.append(s)
};
if(goog.userAgent.jscript.HAS_JSCRIPT) {
  goog.string.StringBuffer.prototype.bufferLength_ = 0;
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    if(opt_a2 == null) {
      this.buffer_[this.bufferLength_++] = a1
    }else {
      this.buffer_.push.apply(this.buffer_, arguments);
      this.bufferLength_ = this.buffer_.length
    }
    return this
  }
}else {
  goog.string.StringBuffer.prototype.append = function(a1, opt_a2, var_args) {
    this.buffer_ += a1;
    if(opt_a2 != null) {
      for(var i = 1;i < arguments.length;i++) {
        this.buffer_ += arguments[i]
      }
    }
    return this
  }
}
goog.string.StringBuffer.prototype.clear = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    this.buffer_.length = 0;
    this.bufferLength_ = 0
  }else {
    this.buffer_ = ""
  }
};
goog.string.StringBuffer.prototype.getLength = function() {
  return this.toString().length
};
goog.string.StringBuffer.prototype.toString = function() {
  if(goog.userAgent.jscript.HAS_JSCRIPT) {
    var str = this.buffer_.join("");
    this.clear();
    if(str) {
      this.append(str)
    }
    return str
  }else {
    return this.buffer_
  }
};
goog.provide("cljs.core");
goog.require("goog.array");
goog.require("goog.object");
goog.require("goog.string.format");
goog.require("goog.string.StringBuffer");
goog.require("goog.string");
cljs.core._STAR_unchecked_if_STAR_ = false;
cljs.core._STAR_print_fn_STAR_ = function _STAR_print_fn_STAR_(_) {
  throw new Error("No *print-fn* fn set for evaluation environment");
};
cljs.core.truth_ = function truth_(x) {
  return x != null && x !== false
};
cljs.core.type_satisfies_ = function type_satisfies_(p, x) {
  var x__6770 = x == null ? null : x;
  if(p[goog.typeOf(x__6770)]) {
    return true
  }else {
    if(p["_"]) {
      return true
    }else {
      if("\ufdd0'else") {
        return false
      }else {
        return null
      }
    }
  }
};
cljs.core.is_proto_ = function is_proto_(x) {
  return x.constructor.prototype === x
};
cljs.core._STAR_main_cli_fn_STAR_ = null;
cljs.core.missing_protocol = function missing_protocol(proto, obj) {
  return Error(["No protocol method ", proto, " defined for type ", goog.typeOf(obj), ": ", obj].join(""))
};
cljs.core.aclone = function aclone(array_like) {
  return array_like.slice()
};
cljs.core.array = function array(var_args) {
  return Array.prototype.slice.call(arguments)
};
cljs.core.make_array = function() {
  var make_array = null;
  var make_array__1 = function(size) {
    return new Array(size)
  };
  var make_array__2 = function(type, size) {
    return make_array.call(null, size)
  };
  make_array = function(type, size) {
    switch(arguments.length) {
      case 1:
        return make_array__1.call(this, type);
      case 2:
        return make_array__2.call(this, type, size)
    }
    throw"Invalid arity: " + arguments.length;
  };
  make_array.cljs$lang$arity$1 = make_array__1;
  make_array.cljs$lang$arity$2 = make_array__2;
  return make_array
}();
cljs.core.aget = function() {
  var aget = null;
  var aget__2 = function(array, i) {
    return array[i]
  };
  var aget__3 = function() {
    var G__6771__delegate = function(array, i, idxs) {
      return cljs.core.apply.call(null, aget, aget.call(null, array, i), idxs)
    };
    var G__6771 = function(array, i, var_args) {
      var idxs = null;
      if(goog.isDef(var_args)) {
        idxs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__6771__delegate.call(this, array, i, idxs)
    };
    G__6771.cljs$lang$maxFixedArity = 2;
    G__6771.cljs$lang$applyTo = function(arglist__6772) {
      var array = cljs.core.first(arglist__6772);
      var i = cljs.core.first(cljs.core.next(arglist__6772));
      var idxs = cljs.core.rest(cljs.core.next(arglist__6772));
      return G__6771__delegate(array, i, idxs)
    };
    G__6771.cljs$lang$arity$variadic = G__6771__delegate;
    return G__6771
  }();
  aget = function(array, i, var_args) {
    var idxs = var_args;
    switch(arguments.length) {
      case 2:
        return aget__2.call(this, array, i);
      default:
        return aget__3.cljs$lang$arity$variadic(array, i, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  aget.cljs$lang$maxFixedArity = 2;
  aget.cljs$lang$applyTo = aget__3.cljs$lang$applyTo;
  aget.cljs$lang$arity$2 = aget__2;
  aget.cljs$lang$arity$variadic = aget__3.cljs$lang$arity$variadic;
  return aget
}();
cljs.core.aset = function aset(array, i, val) {
  return array[i] = val
};
cljs.core.alength = function alength(array) {
  return array.length
};
cljs.core.into_array = function() {
  var into_array = null;
  var into_array__1 = function(aseq) {
    return into_array.call(null, null, aseq)
  };
  var into_array__2 = function(type, aseq) {
    return cljs.core.reduce.call(null, function(a, x) {
      a.push(x);
      return a
    }, [], aseq)
  };
  into_array = function(type, aseq) {
    switch(arguments.length) {
      case 1:
        return into_array__1.call(this, type);
      case 2:
        return into_array__2.call(this, type, aseq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  into_array.cljs$lang$arity$1 = into_array__1;
  into_array.cljs$lang$arity$2 = into_array__2;
  return into_array
}();
cljs.core.IFn = {};
cljs.core._invoke = function() {
  var _invoke = null;
  var _invoke__1 = function(this$) {
    if(function() {
      var and__3822__auto____6857 = this$;
      if(and__3822__auto____6857) {
        return this$.cljs$core$IFn$_invoke$arity$1
      }else {
        return and__3822__auto____6857
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$1(this$)
    }else {
      var x__2458__auto____6858 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6859 = cljs.core._invoke[goog.typeOf(x__2458__auto____6858)];
        if(or__3824__auto____6859) {
          return or__3824__auto____6859
        }else {
          var or__3824__auto____6860 = cljs.core._invoke["_"];
          if(or__3824__auto____6860) {
            return or__3824__auto____6860
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$)
    }
  };
  var _invoke__2 = function(this$, a) {
    if(function() {
      var and__3822__auto____6861 = this$;
      if(and__3822__auto____6861) {
        return this$.cljs$core$IFn$_invoke$arity$2
      }else {
        return and__3822__auto____6861
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$2(this$, a)
    }else {
      var x__2458__auto____6862 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6863 = cljs.core._invoke[goog.typeOf(x__2458__auto____6862)];
        if(or__3824__auto____6863) {
          return or__3824__auto____6863
        }else {
          var or__3824__auto____6864 = cljs.core._invoke["_"];
          if(or__3824__auto____6864) {
            return or__3824__auto____6864
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a)
    }
  };
  var _invoke__3 = function(this$, a, b) {
    if(function() {
      var and__3822__auto____6865 = this$;
      if(and__3822__auto____6865) {
        return this$.cljs$core$IFn$_invoke$arity$3
      }else {
        return and__3822__auto____6865
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$3(this$, a, b)
    }else {
      var x__2458__auto____6866 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6867 = cljs.core._invoke[goog.typeOf(x__2458__auto____6866)];
        if(or__3824__auto____6867) {
          return or__3824__auto____6867
        }else {
          var or__3824__auto____6868 = cljs.core._invoke["_"];
          if(or__3824__auto____6868) {
            return or__3824__auto____6868
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b)
    }
  };
  var _invoke__4 = function(this$, a, b, c) {
    if(function() {
      var and__3822__auto____6869 = this$;
      if(and__3822__auto____6869) {
        return this$.cljs$core$IFn$_invoke$arity$4
      }else {
        return and__3822__auto____6869
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$4(this$, a, b, c)
    }else {
      var x__2458__auto____6870 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6871 = cljs.core._invoke[goog.typeOf(x__2458__auto____6870)];
        if(or__3824__auto____6871) {
          return or__3824__auto____6871
        }else {
          var or__3824__auto____6872 = cljs.core._invoke["_"];
          if(or__3824__auto____6872) {
            return or__3824__auto____6872
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c)
    }
  };
  var _invoke__5 = function(this$, a, b, c, d) {
    if(function() {
      var and__3822__auto____6873 = this$;
      if(and__3822__auto____6873) {
        return this$.cljs$core$IFn$_invoke$arity$5
      }else {
        return and__3822__auto____6873
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$5(this$, a, b, c, d)
    }else {
      var x__2458__auto____6874 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6875 = cljs.core._invoke[goog.typeOf(x__2458__auto____6874)];
        if(or__3824__auto____6875) {
          return or__3824__auto____6875
        }else {
          var or__3824__auto____6876 = cljs.core._invoke["_"];
          if(or__3824__auto____6876) {
            return or__3824__auto____6876
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d)
    }
  };
  var _invoke__6 = function(this$, a, b, c, d, e) {
    if(function() {
      var and__3822__auto____6877 = this$;
      if(and__3822__auto____6877) {
        return this$.cljs$core$IFn$_invoke$arity$6
      }else {
        return and__3822__auto____6877
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$6(this$, a, b, c, d, e)
    }else {
      var x__2458__auto____6878 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6879 = cljs.core._invoke[goog.typeOf(x__2458__auto____6878)];
        if(or__3824__auto____6879) {
          return or__3824__auto____6879
        }else {
          var or__3824__auto____6880 = cljs.core._invoke["_"];
          if(or__3824__auto____6880) {
            return or__3824__auto____6880
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e)
    }
  };
  var _invoke__7 = function(this$, a, b, c, d, e, f) {
    if(function() {
      var and__3822__auto____6881 = this$;
      if(and__3822__auto____6881) {
        return this$.cljs$core$IFn$_invoke$arity$7
      }else {
        return and__3822__auto____6881
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$7(this$, a, b, c, d, e, f)
    }else {
      var x__2458__auto____6882 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6883 = cljs.core._invoke[goog.typeOf(x__2458__auto____6882)];
        if(or__3824__auto____6883) {
          return or__3824__auto____6883
        }else {
          var or__3824__auto____6884 = cljs.core._invoke["_"];
          if(or__3824__auto____6884) {
            return or__3824__auto____6884
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f)
    }
  };
  var _invoke__8 = function(this$, a, b, c, d, e, f, g) {
    if(function() {
      var and__3822__auto____6885 = this$;
      if(and__3822__auto____6885) {
        return this$.cljs$core$IFn$_invoke$arity$8
      }else {
        return and__3822__auto____6885
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$8(this$, a, b, c, d, e, f, g)
    }else {
      var x__2458__auto____6886 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6887 = cljs.core._invoke[goog.typeOf(x__2458__auto____6886)];
        if(or__3824__auto____6887) {
          return or__3824__auto____6887
        }else {
          var or__3824__auto____6888 = cljs.core._invoke["_"];
          if(or__3824__auto____6888) {
            return or__3824__auto____6888
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g)
    }
  };
  var _invoke__9 = function(this$, a, b, c, d, e, f, g, h) {
    if(function() {
      var and__3822__auto____6889 = this$;
      if(and__3822__auto____6889) {
        return this$.cljs$core$IFn$_invoke$arity$9
      }else {
        return and__3822__auto____6889
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$9(this$, a, b, c, d, e, f, g, h)
    }else {
      var x__2458__auto____6890 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6891 = cljs.core._invoke[goog.typeOf(x__2458__auto____6890)];
        if(or__3824__auto____6891) {
          return or__3824__auto____6891
        }else {
          var or__3824__auto____6892 = cljs.core._invoke["_"];
          if(or__3824__auto____6892) {
            return or__3824__auto____6892
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h)
    }
  };
  var _invoke__10 = function(this$, a, b, c, d, e, f, g, h, i) {
    if(function() {
      var and__3822__auto____6893 = this$;
      if(and__3822__auto____6893) {
        return this$.cljs$core$IFn$_invoke$arity$10
      }else {
        return and__3822__auto____6893
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$10(this$, a, b, c, d, e, f, g, h, i)
    }else {
      var x__2458__auto____6894 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6895 = cljs.core._invoke[goog.typeOf(x__2458__auto____6894)];
        if(or__3824__auto____6895) {
          return or__3824__auto____6895
        }else {
          var or__3824__auto____6896 = cljs.core._invoke["_"];
          if(or__3824__auto____6896) {
            return or__3824__auto____6896
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i)
    }
  };
  var _invoke__11 = function(this$, a, b, c, d, e, f, g, h, i, j) {
    if(function() {
      var and__3822__auto____6897 = this$;
      if(and__3822__auto____6897) {
        return this$.cljs$core$IFn$_invoke$arity$11
      }else {
        return and__3822__auto____6897
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$11(this$, a, b, c, d, e, f, g, h, i, j)
    }else {
      var x__2458__auto____6898 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6899 = cljs.core._invoke[goog.typeOf(x__2458__auto____6898)];
        if(or__3824__auto____6899) {
          return or__3824__auto____6899
        }else {
          var or__3824__auto____6900 = cljs.core._invoke["_"];
          if(or__3824__auto____6900) {
            return or__3824__auto____6900
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j)
    }
  };
  var _invoke__12 = function(this$, a, b, c, d, e, f, g, h, i, j, k) {
    if(function() {
      var and__3822__auto____6901 = this$;
      if(and__3822__auto____6901) {
        return this$.cljs$core$IFn$_invoke$arity$12
      }else {
        return and__3822__auto____6901
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$12(this$, a, b, c, d, e, f, g, h, i, j, k)
    }else {
      var x__2458__auto____6902 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6903 = cljs.core._invoke[goog.typeOf(x__2458__auto____6902)];
        if(or__3824__auto____6903) {
          return or__3824__auto____6903
        }else {
          var or__3824__auto____6904 = cljs.core._invoke["_"];
          if(or__3824__auto____6904) {
            return or__3824__auto____6904
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k)
    }
  };
  var _invoke__13 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l) {
    if(function() {
      var and__3822__auto____6905 = this$;
      if(and__3822__auto____6905) {
        return this$.cljs$core$IFn$_invoke$arity$13
      }else {
        return and__3822__auto____6905
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$13(this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }else {
      var x__2458__auto____6906 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6907 = cljs.core._invoke[goog.typeOf(x__2458__auto____6906)];
        if(or__3824__auto____6907) {
          return or__3824__auto____6907
        }else {
          var or__3824__auto____6908 = cljs.core._invoke["_"];
          if(or__3824__auto____6908) {
            return or__3824__auto____6908
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l)
    }
  };
  var _invoke__14 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m) {
    if(function() {
      var and__3822__auto____6909 = this$;
      if(and__3822__auto____6909) {
        return this$.cljs$core$IFn$_invoke$arity$14
      }else {
        return and__3822__auto____6909
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$14(this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }else {
      var x__2458__auto____6910 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6911 = cljs.core._invoke[goog.typeOf(x__2458__auto____6910)];
        if(or__3824__auto____6911) {
          return or__3824__auto____6911
        }else {
          var or__3824__auto____6912 = cljs.core._invoke["_"];
          if(or__3824__auto____6912) {
            return or__3824__auto____6912
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m)
    }
  };
  var _invoke__15 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n) {
    if(function() {
      var and__3822__auto____6913 = this$;
      if(and__3822__auto____6913) {
        return this$.cljs$core$IFn$_invoke$arity$15
      }else {
        return and__3822__auto____6913
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$15(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }else {
      var x__2458__auto____6914 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6915 = cljs.core._invoke[goog.typeOf(x__2458__auto____6914)];
        if(or__3824__auto____6915) {
          return or__3824__auto____6915
        }else {
          var or__3824__auto____6916 = cljs.core._invoke["_"];
          if(or__3824__auto____6916) {
            return or__3824__auto____6916
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n)
    }
  };
  var _invoke__16 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o) {
    if(function() {
      var and__3822__auto____6917 = this$;
      if(and__3822__auto____6917) {
        return this$.cljs$core$IFn$_invoke$arity$16
      }else {
        return and__3822__auto____6917
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$16(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }else {
      var x__2458__auto____6918 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6919 = cljs.core._invoke[goog.typeOf(x__2458__auto____6918)];
        if(or__3824__auto____6919) {
          return or__3824__auto____6919
        }else {
          var or__3824__auto____6920 = cljs.core._invoke["_"];
          if(or__3824__auto____6920) {
            return or__3824__auto____6920
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o)
    }
  };
  var _invoke__17 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p) {
    if(function() {
      var and__3822__auto____6921 = this$;
      if(and__3822__auto____6921) {
        return this$.cljs$core$IFn$_invoke$arity$17
      }else {
        return and__3822__auto____6921
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$17(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }else {
      var x__2458__auto____6922 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6923 = cljs.core._invoke[goog.typeOf(x__2458__auto____6922)];
        if(or__3824__auto____6923) {
          return or__3824__auto____6923
        }else {
          var or__3824__auto____6924 = cljs.core._invoke["_"];
          if(or__3824__auto____6924) {
            return or__3824__auto____6924
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p)
    }
  };
  var _invoke__18 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q) {
    if(function() {
      var and__3822__auto____6925 = this$;
      if(and__3822__auto____6925) {
        return this$.cljs$core$IFn$_invoke$arity$18
      }else {
        return and__3822__auto____6925
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$18(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }else {
      var x__2458__auto____6926 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6927 = cljs.core._invoke[goog.typeOf(x__2458__auto____6926)];
        if(or__3824__auto____6927) {
          return or__3824__auto____6927
        }else {
          var or__3824__auto____6928 = cljs.core._invoke["_"];
          if(or__3824__auto____6928) {
            return or__3824__auto____6928
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q)
    }
  };
  var _invoke__19 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s) {
    if(function() {
      var and__3822__auto____6929 = this$;
      if(and__3822__auto____6929) {
        return this$.cljs$core$IFn$_invoke$arity$19
      }else {
        return and__3822__auto____6929
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$19(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }else {
      var x__2458__auto____6930 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6931 = cljs.core._invoke[goog.typeOf(x__2458__auto____6930)];
        if(or__3824__auto____6931) {
          return or__3824__auto____6931
        }else {
          var or__3824__auto____6932 = cljs.core._invoke["_"];
          if(or__3824__auto____6932) {
            return or__3824__auto____6932
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s)
    }
  };
  var _invoke__20 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t) {
    if(function() {
      var and__3822__auto____6933 = this$;
      if(and__3822__auto____6933) {
        return this$.cljs$core$IFn$_invoke$arity$20
      }else {
        return and__3822__auto____6933
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$20(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }else {
      var x__2458__auto____6934 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6935 = cljs.core._invoke[goog.typeOf(x__2458__auto____6934)];
        if(or__3824__auto____6935) {
          return or__3824__auto____6935
        }else {
          var or__3824__auto____6936 = cljs.core._invoke["_"];
          if(or__3824__auto____6936) {
            return or__3824__auto____6936
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t)
    }
  };
  var _invoke__21 = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    if(function() {
      var and__3822__auto____6937 = this$;
      if(and__3822__auto____6937) {
        return this$.cljs$core$IFn$_invoke$arity$21
      }else {
        return and__3822__auto____6937
      }
    }()) {
      return this$.cljs$core$IFn$_invoke$arity$21(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }else {
      var x__2458__auto____6938 = this$ == null ? null : this$;
      return function() {
        var or__3824__auto____6939 = cljs.core._invoke[goog.typeOf(x__2458__auto____6938)];
        if(or__3824__auto____6939) {
          return or__3824__auto____6939
        }else {
          var or__3824__auto____6940 = cljs.core._invoke["_"];
          if(or__3824__auto____6940) {
            return or__3824__auto____6940
          }else {
            throw cljs.core.missing_protocol.call(null, "IFn.-invoke", this$);
          }
        }
      }().call(null, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
  };
  _invoke = function(this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest) {
    switch(arguments.length) {
      case 1:
        return _invoke__1.call(this, this$);
      case 2:
        return _invoke__2.call(this, this$, a);
      case 3:
        return _invoke__3.call(this, this$, a, b);
      case 4:
        return _invoke__4.call(this, this$, a, b, c);
      case 5:
        return _invoke__5.call(this, this$, a, b, c, d);
      case 6:
        return _invoke__6.call(this, this$, a, b, c, d, e);
      case 7:
        return _invoke__7.call(this, this$, a, b, c, d, e, f);
      case 8:
        return _invoke__8.call(this, this$, a, b, c, d, e, f, g);
      case 9:
        return _invoke__9.call(this, this$, a, b, c, d, e, f, g, h);
      case 10:
        return _invoke__10.call(this, this$, a, b, c, d, e, f, g, h, i);
      case 11:
        return _invoke__11.call(this, this$, a, b, c, d, e, f, g, h, i, j);
      case 12:
        return _invoke__12.call(this, this$, a, b, c, d, e, f, g, h, i, j, k);
      case 13:
        return _invoke__13.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l);
      case 14:
        return _invoke__14.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m);
      case 15:
        return _invoke__15.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n);
      case 16:
        return _invoke__16.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o);
      case 17:
        return _invoke__17.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p);
      case 18:
        return _invoke__18.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q);
      case 19:
        return _invoke__19.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s);
      case 20:
        return _invoke__20.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t);
      case 21:
        return _invoke__21.call(this, this$, a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, s, t, rest)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _invoke.cljs$lang$arity$1 = _invoke__1;
  _invoke.cljs$lang$arity$2 = _invoke__2;
  _invoke.cljs$lang$arity$3 = _invoke__3;
  _invoke.cljs$lang$arity$4 = _invoke__4;
  _invoke.cljs$lang$arity$5 = _invoke__5;
  _invoke.cljs$lang$arity$6 = _invoke__6;
  _invoke.cljs$lang$arity$7 = _invoke__7;
  _invoke.cljs$lang$arity$8 = _invoke__8;
  _invoke.cljs$lang$arity$9 = _invoke__9;
  _invoke.cljs$lang$arity$10 = _invoke__10;
  _invoke.cljs$lang$arity$11 = _invoke__11;
  _invoke.cljs$lang$arity$12 = _invoke__12;
  _invoke.cljs$lang$arity$13 = _invoke__13;
  _invoke.cljs$lang$arity$14 = _invoke__14;
  _invoke.cljs$lang$arity$15 = _invoke__15;
  _invoke.cljs$lang$arity$16 = _invoke__16;
  _invoke.cljs$lang$arity$17 = _invoke__17;
  _invoke.cljs$lang$arity$18 = _invoke__18;
  _invoke.cljs$lang$arity$19 = _invoke__19;
  _invoke.cljs$lang$arity$20 = _invoke__20;
  _invoke.cljs$lang$arity$21 = _invoke__21;
  return _invoke
}();
cljs.core.ICounted = {};
cljs.core._count = function _count(coll) {
  if(function() {
    var and__3822__auto____6945 = coll;
    if(and__3822__auto____6945) {
      return coll.cljs$core$ICounted$_count$arity$1
    }else {
      return and__3822__auto____6945
    }
  }()) {
    return coll.cljs$core$ICounted$_count$arity$1(coll)
  }else {
    var x__2458__auto____6946 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6947 = cljs.core._count[goog.typeOf(x__2458__auto____6946)];
      if(or__3824__auto____6947) {
        return or__3824__auto____6947
      }else {
        var or__3824__auto____6948 = cljs.core._count["_"];
        if(or__3824__auto____6948) {
          return or__3824__auto____6948
        }else {
          throw cljs.core.missing_protocol.call(null, "ICounted.-count", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.IEmptyableCollection = {};
cljs.core._empty = function _empty(coll) {
  if(function() {
    var and__3822__auto____6953 = coll;
    if(and__3822__auto____6953) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1
    }else {
      return and__3822__auto____6953
    }
  }()) {
    return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll)
  }else {
    var x__2458__auto____6954 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6955 = cljs.core._empty[goog.typeOf(x__2458__auto____6954)];
      if(or__3824__auto____6955) {
        return or__3824__auto____6955
      }else {
        var or__3824__auto____6956 = cljs.core._empty["_"];
        if(or__3824__auto____6956) {
          return or__3824__auto____6956
        }else {
          throw cljs.core.missing_protocol.call(null, "IEmptyableCollection.-empty", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.ICollection = {};
cljs.core._conj = function _conj(coll, o) {
  if(function() {
    var and__3822__auto____6961 = coll;
    if(and__3822__auto____6961) {
      return coll.cljs$core$ICollection$_conj$arity$2
    }else {
      return and__3822__auto____6961
    }
  }()) {
    return coll.cljs$core$ICollection$_conj$arity$2(coll, o)
  }else {
    var x__2458__auto____6962 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6963 = cljs.core._conj[goog.typeOf(x__2458__auto____6962)];
      if(or__3824__auto____6963) {
        return or__3824__auto____6963
      }else {
        var or__3824__auto____6964 = cljs.core._conj["_"];
        if(or__3824__auto____6964) {
          return or__3824__auto____6964
        }else {
          throw cljs.core.missing_protocol.call(null, "ICollection.-conj", coll);
        }
      }
    }().call(null, coll, o)
  }
};
cljs.core.IIndexed = {};
cljs.core._nth = function() {
  var _nth = null;
  var _nth__2 = function(coll, n) {
    if(function() {
      var and__3822__auto____6973 = coll;
      if(and__3822__auto____6973) {
        return coll.cljs$core$IIndexed$_nth$arity$2
      }else {
        return and__3822__auto____6973
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$2(coll, n)
    }else {
      var x__2458__auto____6974 = coll == null ? null : coll;
      return function() {
        var or__3824__auto____6975 = cljs.core._nth[goog.typeOf(x__2458__auto____6974)];
        if(or__3824__auto____6975) {
          return or__3824__auto____6975
        }else {
          var or__3824__auto____6976 = cljs.core._nth["_"];
          if(or__3824__auto____6976) {
            return or__3824__auto____6976
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n)
    }
  };
  var _nth__3 = function(coll, n, not_found) {
    if(function() {
      var and__3822__auto____6977 = coll;
      if(and__3822__auto____6977) {
        return coll.cljs$core$IIndexed$_nth$arity$3
      }else {
        return and__3822__auto____6977
      }
    }()) {
      return coll.cljs$core$IIndexed$_nth$arity$3(coll, n, not_found)
    }else {
      var x__2458__auto____6978 = coll == null ? null : coll;
      return function() {
        var or__3824__auto____6979 = cljs.core._nth[goog.typeOf(x__2458__auto____6978)];
        if(or__3824__auto____6979) {
          return or__3824__auto____6979
        }else {
          var or__3824__auto____6980 = cljs.core._nth["_"];
          if(or__3824__auto____6980) {
            return or__3824__auto____6980
          }else {
            throw cljs.core.missing_protocol.call(null, "IIndexed.-nth", coll);
          }
        }
      }().call(null, coll, n, not_found)
    }
  };
  _nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return _nth__2.call(this, coll, n);
      case 3:
        return _nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _nth.cljs$lang$arity$2 = _nth__2;
  _nth.cljs$lang$arity$3 = _nth__3;
  return _nth
}();
cljs.core.ASeq = {};
cljs.core.ISeq = {};
cljs.core._first = function _first(coll) {
  if(function() {
    var and__3822__auto____6985 = coll;
    if(and__3822__auto____6985) {
      return coll.cljs$core$ISeq$_first$arity$1
    }else {
      return and__3822__auto____6985
    }
  }()) {
    return coll.cljs$core$ISeq$_first$arity$1(coll)
  }else {
    var x__2458__auto____6986 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6987 = cljs.core._first[goog.typeOf(x__2458__auto____6986)];
      if(or__3824__auto____6987) {
        return or__3824__auto____6987
      }else {
        var or__3824__auto____6988 = cljs.core._first["_"];
        if(or__3824__auto____6988) {
          return or__3824__auto____6988
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-first", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._rest = function _rest(coll) {
  if(function() {
    var and__3822__auto____6993 = coll;
    if(and__3822__auto____6993) {
      return coll.cljs$core$ISeq$_rest$arity$1
    }else {
      return and__3822__auto____6993
    }
  }()) {
    return coll.cljs$core$ISeq$_rest$arity$1(coll)
  }else {
    var x__2458__auto____6994 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____6995 = cljs.core._rest[goog.typeOf(x__2458__auto____6994)];
      if(or__3824__auto____6995) {
        return or__3824__auto____6995
      }else {
        var or__3824__auto____6996 = cljs.core._rest["_"];
        if(or__3824__auto____6996) {
          return or__3824__auto____6996
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeq.-rest", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.INext = {};
cljs.core._next = function _next(coll) {
  if(function() {
    var and__3822__auto____7001 = coll;
    if(and__3822__auto____7001) {
      return coll.cljs$core$INext$_next$arity$1
    }else {
      return and__3822__auto____7001
    }
  }()) {
    return coll.cljs$core$INext$_next$arity$1(coll)
  }else {
    var x__2458__auto____7002 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7003 = cljs.core._next[goog.typeOf(x__2458__auto____7002)];
      if(or__3824__auto____7003) {
        return or__3824__auto____7003
      }else {
        var or__3824__auto____7004 = cljs.core._next["_"];
        if(or__3824__auto____7004) {
          return or__3824__auto____7004
        }else {
          throw cljs.core.missing_protocol.call(null, "INext.-next", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.ILookup = {};
cljs.core._lookup = function() {
  var _lookup = null;
  var _lookup__2 = function(o, k) {
    if(function() {
      var and__3822__auto____7013 = o;
      if(and__3822__auto____7013) {
        return o.cljs$core$ILookup$_lookup$arity$2
      }else {
        return and__3822__auto____7013
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$2(o, k)
    }else {
      var x__2458__auto____7014 = o == null ? null : o;
      return function() {
        var or__3824__auto____7015 = cljs.core._lookup[goog.typeOf(x__2458__auto____7014)];
        if(or__3824__auto____7015) {
          return or__3824__auto____7015
        }else {
          var or__3824__auto____7016 = cljs.core._lookup["_"];
          if(or__3824__auto____7016) {
            return or__3824__auto____7016
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k)
    }
  };
  var _lookup__3 = function(o, k, not_found) {
    if(function() {
      var and__3822__auto____7017 = o;
      if(and__3822__auto____7017) {
        return o.cljs$core$ILookup$_lookup$arity$3
      }else {
        return and__3822__auto____7017
      }
    }()) {
      return o.cljs$core$ILookup$_lookup$arity$3(o, k, not_found)
    }else {
      var x__2458__auto____7018 = o == null ? null : o;
      return function() {
        var or__3824__auto____7019 = cljs.core._lookup[goog.typeOf(x__2458__auto____7018)];
        if(or__3824__auto____7019) {
          return or__3824__auto____7019
        }else {
          var or__3824__auto____7020 = cljs.core._lookup["_"];
          if(or__3824__auto____7020) {
            return or__3824__auto____7020
          }else {
            throw cljs.core.missing_protocol.call(null, "ILookup.-lookup", o);
          }
        }
      }().call(null, o, k, not_found)
    }
  };
  _lookup = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return _lookup__2.call(this, o, k);
      case 3:
        return _lookup__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _lookup.cljs$lang$arity$2 = _lookup__2;
  _lookup.cljs$lang$arity$3 = _lookup__3;
  return _lookup
}();
cljs.core.IAssociative = {};
cljs.core._contains_key_QMARK_ = function _contains_key_QMARK_(coll, k) {
  if(function() {
    var and__3822__auto____7025 = coll;
    if(and__3822__auto____7025) {
      return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2
    }else {
      return and__3822__auto____7025
    }
  }()) {
    return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll, k)
  }else {
    var x__2458__auto____7026 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7027 = cljs.core._contains_key_QMARK_[goog.typeOf(x__2458__auto____7026)];
      if(or__3824__auto____7027) {
        return or__3824__auto____7027
      }else {
        var or__3824__auto____7028 = cljs.core._contains_key_QMARK_["_"];
        if(or__3824__auto____7028) {
          return or__3824__auto____7028
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-contains-key?", coll);
        }
      }
    }().call(null, coll, k)
  }
};
cljs.core._assoc = function _assoc(coll, k, v) {
  if(function() {
    var and__3822__auto____7033 = coll;
    if(and__3822__auto____7033) {
      return coll.cljs$core$IAssociative$_assoc$arity$3
    }else {
      return and__3822__auto____7033
    }
  }()) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, k, v)
  }else {
    var x__2458__auto____7034 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7035 = cljs.core._assoc[goog.typeOf(x__2458__auto____7034)];
      if(or__3824__auto____7035) {
        return or__3824__auto____7035
      }else {
        var or__3824__auto____7036 = cljs.core._assoc["_"];
        if(or__3824__auto____7036) {
          return or__3824__auto____7036
        }else {
          throw cljs.core.missing_protocol.call(null, "IAssociative.-assoc", coll);
        }
      }
    }().call(null, coll, k, v)
  }
};
cljs.core.IMap = {};
cljs.core._dissoc = function _dissoc(coll, k) {
  if(function() {
    var and__3822__auto____7041 = coll;
    if(and__3822__auto____7041) {
      return coll.cljs$core$IMap$_dissoc$arity$2
    }else {
      return and__3822__auto____7041
    }
  }()) {
    return coll.cljs$core$IMap$_dissoc$arity$2(coll, k)
  }else {
    var x__2458__auto____7042 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7043 = cljs.core._dissoc[goog.typeOf(x__2458__auto____7042)];
      if(or__3824__auto____7043) {
        return or__3824__auto____7043
      }else {
        var or__3824__auto____7044 = cljs.core._dissoc["_"];
        if(or__3824__auto____7044) {
          return or__3824__auto____7044
        }else {
          throw cljs.core.missing_protocol.call(null, "IMap.-dissoc", coll);
        }
      }
    }().call(null, coll, k)
  }
};
cljs.core.IMapEntry = {};
cljs.core._key = function _key(coll) {
  if(function() {
    var and__3822__auto____7049 = coll;
    if(and__3822__auto____7049) {
      return coll.cljs$core$IMapEntry$_key$arity$1
    }else {
      return and__3822__auto____7049
    }
  }()) {
    return coll.cljs$core$IMapEntry$_key$arity$1(coll)
  }else {
    var x__2458__auto____7050 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7051 = cljs.core._key[goog.typeOf(x__2458__auto____7050)];
      if(or__3824__auto____7051) {
        return or__3824__auto____7051
      }else {
        var or__3824__auto____7052 = cljs.core._key["_"];
        if(or__3824__auto____7052) {
          return or__3824__auto____7052
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-key", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._val = function _val(coll) {
  if(function() {
    var and__3822__auto____7057 = coll;
    if(and__3822__auto____7057) {
      return coll.cljs$core$IMapEntry$_val$arity$1
    }else {
      return and__3822__auto____7057
    }
  }()) {
    return coll.cljs$core$IMapEntry$_val$arity$1(coll)
  }else {
    var x__2458__auto____7058 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7059 = cljs.core._val[goog.typeOf(x__2458__auto____7058)];
      if(or__3824__auto____7059) {
        return or__3824__auto____7059
      }else {
        var or__3824__auto____7060 = cljs.core._val["_"];
        if(or__3824__auto____7060) {
          return or__3824__auto____7060
        }else {
          throw cljs.core.missing_protocol.call(null, "IMapEntry.-val", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.ISet = {};
cljs.core._disjoin = function _disjoin(coll, v) {
  if(function() {
    var and__3822__auto____7065 = coll;
    if(and__3822__auto____7065) {
      return coll.cljs$core$ISet$_disjoin$arity$2
    }else {
      return and__3822__auto____7065
    }
  }()) {
    return coll.cljs$core$ISet$_disjoin$arity$2(coll, v)
  }else {
    var x__2458__auto____7066 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7067 = cljs.core._disjoin[goog.typeOf(x__2458__auto____7066)];
      if(or__3824__auto____7067) {
        return or__3824__auto____7067
      }else {
        var or__3824__auto____7068 = cljs.core._disjoin["_"];
        if(or__3824__auto____7068) {
          return or__3824__auto____7068
        }else {
          throw cljs.core.missing_protocol.call(null, "ISet.-disjoin", coll);
        }
      }
    }().call(null, coll, v)
  }
};
cljs.core.IStack = {};
cljs.core._peek = function _peek(coll) {
  if(function() {
    var and__3822__auto____7073 = coll;
    if(and__3822__auto____7073) {
      return coll.cljs$core$IStack$_peek$arity$1
    }else {
      return and__3822__auto____7073
    }
  }()) {
    return coll.cljs$core$IStack$_peek$arity$1(coll)
  }else {
    var x__2458__auto____7074 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7075 = cljs.core._peek[goog.typeOf(x__2458__auto____7074)];
      if(or__3824__auto____7075) {
        return or__3824__auto____7075
      }else {
        var or__3824__auto____7076 = cljs.core._peek["_"];
        if(or__3824__auto____7076) {
          return or__3824__auto____7076
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-peek", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._pop = function _pop(coll) {
  if(function() {
    var and__3822__auto____7081 = coll;
    if(and__3822__auto____7081) {
      return coll.cljs$core$IStack$_pop$arity$1
    }else {
      return and__3822__auto____7081
    }
  }()) {
    return coll.cljs$core$IStack$_pop$arity$1(coll)
  }else {
    var x__2458__auto____7082 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7083 = cljs.core._pop[goog.typeOf(x__2458__auto____7082)];
      if(or__3824__auto____7083) {
        return or__3824__auto____7083
      }else {
        var or__3824__auto____7084 = cljs.core._pop["_"];
        if(or__3824__auto____7084) {
          return or__3824__auto____7084
        }else {
          throw cljs.core.missing_protocol.call(null, "IStack.-pop", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.IVector = {};
cljs.core._assoc_n = function _assoc_n(coll, n, val) {
  if(function() {
    var and__3822__auto____7089 = coll;
    if(and__3822__auto____7089) {
      return coll.cljs$core$IVector$_assoc_n$arity$3
    }else {
      return and__3822__auto____7089
    }
  }()) {
    return coll.cljs$core$IVector$_assoc_n$arity$3(coll, n, val)
  }else {
    var x__2458__auto____7090 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7091 = cljs.core._assoc_n[goog.typeOf(x__2458__auto____7090)];
      if(or__3824__auto____7091) {
        return or__3824__auto____7091
      }else {
        var or__3824__auto____7092 = cljs.core._assoc_n["_"];
        if(or__3824__auto____7092) {
          return or__3824__auto____7092
        }else {
          throw cljs.core.missing_protocol.call(null, "IVector.-assoc-n", coll);
        }
      }
    }().call(null, coll, n, val)
  }
};
cljs.core.IDeref = {};
cljs.core._deref = function _deref(o) {
  if(function() {
    var and__3822__auto____7097 = o;
    if(and__3822__auto____7097) {
      return o.cljs$core$IDeref$_deref$arity$1
    }else {
      return and__3822__auto____7097
    }
  }()) {
    return o.cljs$core$IDeref$_deref$arity$1(o)
  }else {
    var x__2458__auto____7098 = o == null ? null : o;
    return function() {
      var or__3824__auto____7099 = cljs.core._deref[goog.typeOf(x__2458__auto____7098)];
      if(or__3824__auto____7099) {
        return or__3824__auto____7099
      }else {
        var or__3824__auto____7100 = cljs.core._deref["_"];
        if(or__3824__auto____7100) {
          return or__3824__auto____7100
        }else {
          throw cljs.core.missing_protocol.call(null, "IDeref.-deref", o);
        }
      }
    }().call(null, o)
  }
};
cljs.core.IDerefWithTimeout = {};
cljs.core._deref_with_timeout = function _deref_with_timeout(o, msec, timeout_val) {
  if(function() {
    var and__3822__auto____7105 = o;
    if(and__3822__auto____7105) {
      return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3
    }else {
      return and__3822__auto____7105
    }
  }()) {
    return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o, msec, timeout_val)
  }else {
    var x__2458__auto____7106 = o == null ? null : o;
    return function() {
      var or__3824__auto____7107 = cljs.core._deref_with_timeout[goog.typeOf(x__2458__auto____7106)];
      if(or__3824__auto____7107) {
        return or__3824__auto____7107
      }else {
        var or__3824__auto____7108 = cljs.core._deref_with_timeout["_"];
        if(or__3824__auto____7108) {
          return or__3824__auto____7108
        }else {
          throw cljs.core.missing_protocol.call(null, "IDerefWithTimeout.-deref-with-timeout", o);
        }
      }
    }().call(null, o, msec, timeout_val)
  }
};
cljs.core.IMeta = {};
cljs.core._meta = function _meta(o) {
  if(function() {
    var and__3822__auto____7113 = o;
    if(and__3822__auto____7113) {
      return o.cljs$core$IMeta$_meta$arity$1
    }else {
      return and__3822__auto____7113
    }
  }()) {
    return o.cljs$core$IMeta$_meta$arity$1(o)
  }else {
    var x__2458__auto____7114 = o == null ? null : o;
    return function() {
      var or__3824__auto____7115 = cljs.core._meta[goog.typeOf(x__2458__auto____7114)];
      if(or__3824__auto____7115) {
        return or__3824__auto____7115
      }else {
        var or__3824__auto____7116 = cljs.core._meta["_"];
        if(or__3824__auto____7116) {
          return or__3824__auto____7116
        }else {
          throw cljs.core.missing_protocol.call(null, "IMeta.-meta", o);
        }
      }
    }().call(null, o)
  }
};
cljs.core.IWithMeta = {};
cljs.core._with_meta = function _with_meta(o, meta) {
  if(function() {
    var and__3822__auto____7121 = o;
    if(and__3822__auto____7121) {
      return o.cljs$core$IWithMeta$_with_meta$arity$2
    }else {
      return and__3822__auto____7121
    }
  }()) {
    return o.cljs$core$IWithMeta$_with_meta$arity$2(o, meta)
  }else {
    var x__2458__auto____7122 = o == null ? null : o;
    return function() {
      var or__3824__auto____7123 = cljs.core._with_meta[goog.typeOf(x__2458__auto____7122)];
      if(or__3824__auto____7123) {
        return or__3824__auto____7123
      }else {
        var or__3824__auto____7124 = cljs.core._with_meta["_"];
        if(or__3824__auto____7124) {
          return or__3824__auto____7124
        }else {
          throw cljs.core.missing_protocol.call(null, "IWithMeta.-with-meta", o);
        }
      }
    }().call(null, o, meta)
  }
};
cljs.core.IReduce = {};
cljs.core._reduce = function() {
  var _reduce = null;
  var _reduce__2 = function(coll, f) {
    if(function() {
      var and__3822__auto____7133 = coll;
      if(and__3822__auto____7133) {
        return coll.cljs$core$IReduce$_reduce$arity$2
      }else {
        return and__3822__auto____7133
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$2(coll, f)
    }else {
      var x__2458__auto____7134 = coll == null ? null : coll;
      return function() {
        var or__3824__auto____7135 = cljs.core._reduce[goog.typeOf(x__2458__auto____7134)];
        if(or__3824__auto____7135) {
          return or__3824__auto____7135
        }else {
          var or__3824__auto____7136 = cljs.core._reduce["_"];
          if(or__3824__auto____7136) {
            return or__3824__auto____7136
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f)
    }
  };
  var _reduce__3 = function(coll, f, start) {
    if(function() {
      var and__3822__auto____7137 = coll;
      if(and__3822__auto____7137) {
        return coll.cljs$core$IReduce$_reduce$arity$3
      }else {
        return and__3822__auto____7137
      }
    }()) {
      return coll.cljs$core$IReduce$_reduce$arity$3(coll, f, start)
    }else {
      var x__2458__auto____7138 = coll == null ? null : coll;
      return function() {
        var or__3824__auto____7139 = cljs.core._reduce[goog.typeOf(x__2458__auto____7138)];
        if(or__3824__auto____7139) {
          return or__3824__auto____7139
        }else {
          var or__3824__auto____7140 = cljs.core._reduce["_"];
          if(or__3824__auto____7140) {
            return or__3824__auto____7140
          }else {
            throw cljs.core.missing_protocol.call(null, "IReduce.-reduce", coll);
          }
        }
      }().call(null, coll, f, start)
    }
  };
  _reduce = function(coll, f, start) {
    switch(arguments.length) {
      case 2:
        return _reduce__2.call(this, coll, f);
      case 3:
        return _reduce__3.call(this, coll, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  _reduce.cljs$lang$arity$2 = _reduce__2;
  _reduce.cljs$lang$arity$3 = _reduce__3;
  return _reduce
}();
cljs.core.IKVReduce = {};
cljs.core._kv_reduce = function _kv_reduce(coll, f, init) {
  if(function() {
    var and__3822__auto____7145 = coll;
    if(and__3822__auto____7145) {
      return coll.cljs$core$IKVReduce$_kv_reduce$arity$3
    }else {
      return and__3822__auto____7145
    }
  }()) {
    return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll, f, init)
  }else {
    var x__2458__auto____7146 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7147 = cljs.core._kv_reduce[goog.typeOf(x__2458__auto____7146)];
      if(or__3824__auto____7147) {
        return or__3824__auto____7147
      }else {
        var or__3824__auto____7148 = cljs.core._kv_reduce["_"];
        if(or__3824__auto____7148) {
          return or__3824__auto____7148
        }else {
          throw cljs.core.missing_protocol.call(null, "IKVReduce.-kv-reduce", coll);
        }
      }
    }().call(null, coll, f, init)
  }
};
cljs.core.IEquiv = {};
cljs.core._equiv = function _equiv(o, other) {
  if(function() {
    var and__3822__auto____7153 = o;
    if(and__3822__auto____7153) {
      return o.cljs$core$IEquiv$_equiv$arity$2
    }else {
      return and__3822__auto____7153
    }
  }()) {
    return o.cljs$core$IEquiv$_equiv$arity$2(o, other)
  }else {
    var x__2458__auto____7154 = o == null ? null : o;
    return function() {
      var or__3824__auto____7155 = cljs.core._equiv[goog.typeOf(x__2458__auto____7154)];
      if(or__3824__auto____7155) {
        return or__3824__auto____7155
      }else {
        var or__3824__auto____7156 = cljs.core._equiv["_"];
        if(or__3824__auto____7156) {
          return or__3824__auto____7156
        }else {
          throw cljs.core.missing_protocol.call(null, "IEquiv.-equiv", o);
        }
      }
    }().call(null, o, other)
  }
};
cljs.core.IHash = {};
cljs.core._hash = function _hash(o) {
  if(function() {
    var and__3822__auto____7161 = o;
    if(and__3822__auto____7161) {
      return o.cljs$core$IHash$_hash$arity$1
    }else {
      return and__3822__auto____7161
    }
  }()) {
    return o.cljs$core$IHash$_hash$arity$1(o)
  }else {
    var x__2458__auto____7162 = o == null ? null : o;
    return function() {
      var or__3824__auto____7163 = cljs.core._hash[goog.typeOf(x__2458__auto____7162)];
      if(or__3824__auto____7163) {
        return or__3824__auto____7163
      }else {
        var or__3824__auto____7164 = cljs.core._hash["_"];
        if(or__3824__auto____7164) {
          return or__3824__auto____7164
        }else {
          throw cljs.core.missing_protocol.call(null, "IHash.-hash", o);
        }
      }
    }().call(null, o)
  }
};
cljs.core.ISeqable = {};
cljs.core._seq = function _seq(o) {
  if(function() {
    var and__3822__auto____7169 = o;
    if(and__3822__auto____7169) {
      return o.cljs$core$ISeqable$_seq$arity$1
    }else {
      return and__3822__auto____7169
    }
  }()) {
    return o.cljs$core$ISeqable$_seq$arity$1(o)
  }else {
    var x__2458__auto____7170 = o == null ? null : o;
    return function() {
      var or__3824__auto____7171 = cljs.core._seq[goog.typeOf(x__2458__auto____7170)];
      if(or__3824__auto____7171) {
        return or__3824__auto____7171
      }else {
        var or__3824__auto____7172 = cljs.core._seq["_"];
        if(or__3824__auto____7172) {
          return or__3824__auto____7172
        }else {
          throw cljs.core.missing_protocol.call(null, "ISeqable.-seq", o);
        }
      }
    }().call(null, o)
  }
};
cljs.core.ISequential = {};
cljs.core.IList = {};
cljs.core.IRecord = {};
cljs.core.IReversible = {};
cljs.core._rseq = function _rseq(coll) {
  if(function() {
    var and__3822__auto____7177 = coll;
    if(and__3822__auto____7177) {
      return coll.cljs$core$IReversible$_rseq$arity$1
    }else {
      return and__3822__auto____7177
    }
  }()) {
    return coll.cljs$core$IReversible$_rseq$arity$1(coll)
  }else {
    var x__2458__auto____7178 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7179 = cljs.core._rseq[goog.typeOf(x__2458__auto____7178)];
      if(or__3824__auto____7179) {
        return or__3824__auto____7179
      }else {
        var or__3824__auto____7180 = cljs.core._rseq["_"];
        if(or__3824__auto____7180) {
          return or__3824__auto____7180
        }else {
          throw cljs.core.missing_protocol.call(null, "IReversible.-rseq", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.ISorted = {};
cljs.core._sorted_seq = function _sorted_seq(coll, ascending_QMARK_) {
  if(function() {
    var and__3822__auto____7185 = coll;
    if(and__3822__auto____7185) {
      return coll.cljs$core$ISorted$_sorted_seq$arity$2
    }else {
      return and__3822__auto____7185
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll, ascending_QMARK_)
  }else {
    var x__2458__auto____7186 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7187 = cljs.core._sorted_seq[goog.typeOf(x__2458__auto____7186)];
      if(or__3824__auto____7187) {
        return or__3824__auto____7187
      }else {
        var or__3824__auto____7188 = cljs.core._sorted_seq["_"];
        if(or__3824__auto____7188) {
          return or__3824__auto____7188
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq", coll);
        }
      }
    }().call(null, coll, ascending_QMARK_)
  }
};
cljs.core._sorted_seq_from = function _sorted_seq_from(coll, k, ascending_QMARK_) {
  if(function() {
    var and__3822__auto____7193 = coll;
    if(and__3822__auto____7193) {
      return coll.cljs$core$ISorted$_sorted_seq_from$arity$3
    }else {
      return and__3822__auto____7193
    }
  }()) {
    return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll, k, ascending_QMARK_)
  }else {
    var x__2458__auto____7194 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7195 = cljs.core._sorted_seq_from[goog.typeOf(x__2458__auto____7194)];
      if(or__3824__auto____7195) {
        return or__3824__auto____7195
      }else {
        var or__3824__auto____7196 = cljs.core._sorted_seq_from["_"];
        if(or__3824__auto____7196) {
          return or__3824__auto____7196
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-sorted-seq-from", coll);
        }
      }
    }().call(null, coll, k, ascending_QMARK_)
  }
};
cljs.core._entry_key = function _entry_key(coll, entry) {
  if(function() {
    var and__3822__auto____7201 = coll;
    if(and__3822__auto____7201) {
      return coll.cljs$core$ISorted$_entry_key$arity$2
    }else {
      return and__3822__auto____7201
    }
  }()) {
    return coll.cljs$core$ISorted$_entry_key$arity$2(coll, entry)
  }else {
    var x__2458__auto____7202 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7203 = cljs.core._entry_key[goog.typeOf(x__2458__auto____7202)];
      if(or__3824__auto____7203) {
        return or__3824__auto____7203
      }else {
        var or__3824__auto____7204 = cljs.core._entry_key["_"];
        if(or__3824__auto____7204) {
          return or__3824__auto____7204
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-entry-key", coll);
        }
      }
    }().call(null, coll, entry)
  }
};
cljs.core._comparator = function _comparator(coll) {
  if(function() {
    var and__3822__auto____7209 = coll;
    if(and__3822__auto____7209) {
      return coll.cljs$core$ISorted$_comparator$arity$1
    }else {
      return and__3822__auto____7209
    }
  }()) {
    return coll.cljs$core$ISorted$_comparator$arity$1(coll)
  }else {
    var x__2458__auto____7210 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7211 = cljs.core._comparator[goog.typeOf(x__2458__auto____7210)];
      if(or__3824__auto____7211) {
        return or__3824__auto____7211
      }else {
        var or__3824__auto____7212 = cljs.core._comparator["_"];
        if(or__3824__auto____7212) {
          return or__3824__auto____7212
        }else {
          throw cljs.core.missing_protocol.call(null, "ISorted.-comparator", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.IPrintable = {};
cljs.core._pr_seq = function _pr_seq(o, opts) {
  if(function() {
    var and__3822__auto____7217 = o;
    if(and__3822__auto____7217) {
      return o.cljs$core$IPrintable$_pr_seq$arity$2
    }else {
      return and__3822__auto____7217
    }
  }()) {
    return o.cljs$core$IPrintable$_pr_seq$arity$2(o, opts)
  }else {
    var x__2458__auto____7218 = o == null ? null : o;
    return function() {
      var or__3824__auto____7219 = cljs.core._pr_seq[goog.typeOf(x__2458__auto____7218)];
      if(or__3824__auto____7219) {
        return or__3824__auto____7219
      }else {
        var or__3824__auto____7220 = cljs.core._pr_seq["_"];
        if(or__3824__auto____7220) {
          return or__3824__auto____7220
        }else {
          throw cljs.core.missing_protocol.call(null, "IPrintable.-pr-seq", o);
        }
      }
    }().call(null, o, opts)
  }
};
cljs.core.IPending = {};
cljs.core._realized_QMARK_ = function _realized_QMARK_(d) {
  if(function() {
    var and__3822__auto____7225 = d;
    if(and__3822__auto____7225) {
      return d.cljs$core$IPending$_realized_QMARK_$arity$1
    }else {
      return and__3822__auto____7225
    }
  }()) {
    return d.cljs$core$IPending$_realized_QMARK_$arity$1(d)
  }else {
    var x__2458__auto____7226 = d == null ? null : d;
    return function() {
      var or__3824__auto____7227 = cljs.core._realized_QMARK_[goog.typeOf(x__2458__auto____7226)];
      if(or__3824__auto____7227) {
        return or__3824__auto____7227
      }else {
        var or__3824__auto____7228 = cljs.core._realized_QMARK_["_"];
        if(or__3824__auto____7228) {
          return or__3824__auto____7228
        }else {
          throw cljs.core.missing_protocol.call(null, "IPending.-realized?", d);
        }
      }
    }().call(null, d)
  }
};
cljs.core.IWatchable = {};
cljs.core._notify_watches = function _notify_watches(this$, oldval, newval) {
  if(function() {
    var and__3822__auto____7233 = this$;
    if(and__3822__auto____7233) {
      return this$.cljs$core$IWatchable$_notify_watches$arity$3
    }else {
      return and__3822__auto____7233
    }
  }()) {
    return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$, oldval, newval)
  }else {
    var x__2458__auto____7234 = this$ == null ? null : this$;
    return function() {
      var or__3824__auto____7235 = cljs.core._notify_watches[goog.typeOf(x__2458__auto____7234)];
      if(or__3824__auto____7235) {
        return or__3824__auto____7235
      }else {
        var or__3824__auto____7236 = cljs.core._notify_watches["_"];
        if(or__3824__auto____7236) {
          return or__3824__auto____7236
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-notify-watches", this$);
        }
      }
    }().call(null, this$, oldval, newval)
  }
};
cljs.core._add_watch = function _add_watch(this$, key, f) {
  if(function() {
    var and__3822__auto____7241 = this$;
    if(and__3822__auto____7241) {
      return this$.cljs$core$IWatchable$_add_watch$arity$3
    }else {
      return and__3822__auto____7241
    }
  }()) {
    return this$.cljs$core$IWatchable$_add_watch$arity$3(this$, key, f)
  }else {
    var x__2458__auto____7242 = this$ == null ? null : this$;
    return function() {
      var or__3824__auto____7243 = cljs.core._add_watch[goog.typeOf(x__2458__auto____7242)];
      if(or__3824__auto____7243) {
        return or__3824__auto____7243
      }else {
        var or__3824__auto____7244 = cljs.core._add_watch["_"];
        if(or__3824__auto____7244) {
          return or__3824__auto____7244
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-add-watch", this$);
        }
      }
    }().call(null, this$, key, f)
  }
};
cljs.core._remove_watch = function _remove_watch(this$, key) {
  if(function() {
    var and__3822__auto____7249 = this$;
    if(and__3822__auto____7249) {
      return this$.cljs$core$IWatchable$_remove_watch$arity$2
    }else {
      return and__3822__auto____7249
    }
  }()) {
    return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$, key)
  }else {
    var x__2458__auto____7250 = this$ == null ? null : this$;
    return function() {
      var or__3824__auto____7251 = cljs.core._remove_watch[goog.typeOf(x__2458__auto____7250)];
      if(or__3824__auto____7251) {
        return or__3824__auto____7251
      }else {
        var or__3824__auto____7252 = cljs.core._remove_watch["_"];
        if(or__3824__auto____7252) {
          return or__3824__auto____7252
        }else {
          throw cljs.core.missing_protocol.call(null, "IWatchable.-remove-watch", this$);
        }
      }
    }().call(null, this$, key)
  }
};
cljs.core.IEditableCollection = {};
cljs.core._as_transient = function _as_transient(coll) {
  if(function() {
    var and__3822__auto____7257 = coll;
    if(and__3822__auto____7257) {
      return coll.cljs$core$IEditableCollection$_as_transient$arity$1
    }else {
      return and__3822__auto____7257
    }
  }()) {
    return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll)
  }else {
    var x__2458__auto____7258 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7259 = cljs.core._as_transient[goog.typeOf(x__2458__auto____7258)];
      if(or__3824__auto____7259) {
        return or__3824__auto____7259
      }else {
        var or__3824__auto____7260 = cljs.core._as_transient["_"];
        if(or__3824__auto____7260) {
          return or__3824__auto____7260
        }else {
          throw cljs.core.missing_protocol.call(null, "IEditableCollection.-as-transient", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.ITransientCollection = {};
cljs.core._conj_BANG_ = function _conj_BANG_(tcoll, val) {
  if(function() {
    var and__3822__auto____7265 = tcoll;
    if(and__3822__auto____7265) {
      return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2
    }else {
      return and__3822__auto____7265
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val)
  }else {
    var x__2458__auto____7266 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____7267 = cljs.core._conj_BANG_[goog.typeOf(x__2458__auto____7266)];
      if(or__3824__auto____7267) {
        return or__3824__auto____7267
      }else {
        var or__3824__auto____7268 = cljs.core._conj_BANG_["_"];
        if(or__3824__auto____7268) {
          return or__3824__auto____7268
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-conj!", tcoll);
        }
      }
    }().call(null, tcoll, val)
  }
};
cljs.core._persistent_BANG_ = function _persistent_BANG_(tcoll) {
  if(function() {
    var and__3822__auto____7273 = tcoll;
    if(and__3822__auto____7273) {
      return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1
    }else {
      return and__3822__auto____7273
    }
  }()) {
    return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll)
  }else {
    var x__2458__auto____7274 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____7275 = cljs.core._persistent_BANG_[goog.typeOf(x__2458__auto____7274)];
      if(or__3824__auto____7275) {
        return or__3824__auto____7275
      }else {
        var or__3824__auto____7276 = cljs.core._persistent_BANG_["_"];
        if(or__3824__auto____7276) {
          return or__3824__auto____7276
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientCollection.-persistent!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
cljs.core.ITransientAssociative = {};
cljs.core._assoc_BANG_ = function _assoc_BANG_(tcoll, key, val) {
  if(function() {
    var and__3822__auto____7281 = tcoll;
    if(and__3822__auto____7281) {
      return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3
    }else {
      return and__3822__auto____7281
    }
  }()) {
    return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, key, val)
  }else {
    var x__2458__auto____7282 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____7283 = cljs.core._assoc_BANG_[goog.typeOf(x__2458__auto____7282)];
      if(or__3824__auto____7283) {
        return or__3824__auto____7283
      }else {
        var or__3824__auto____7284 = cljs.core._assoc_BANG_["_"];
        if(or__3824__auto____7284) {
          return or__3824__auto____7284
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientAssociative.-assoc!", tcoll);
        }
      }
    }().call(null, tcoll, key, val)
  }
};
cljs.core.ITransientMap = {};
cljs.core._dissoc_BANG_ = function _dissoc_BANG_(tcoll, key) {
  if(function() {
    var and__3822__auto____7289 = tcoll;
    if(and__3822__auto____7289) {
      return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2
    }else {
      return and__3822__auto____7289
    }
  }()) {
    return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll, key)
  }else {
    var x__2458__auto____7290 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____7291 = cljs.core._dissoc_BANG_[goog.typeOf(x__2458__auto____7290)];
      if(or__3824__auto____7291) {
        return or__3824__auto____7291
      }else {
        var or__3824__auto____7292 = cljs.core._dissoc_BANG_["_"];
        if(or__3824__auto____7292) {
          return or__3824__auto____7292
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientMap.-dissoc!", tcoll);
        }
      }
    }().call(null, tcoll, key)
  }
};
cljs.core.ITransientVector = {};
cljs.core._assoc_n_BANG_ = function _assoc_n_BANG_(tcoll, n, val) {
  if(function() {
    var and__3822__auto____7297 = tcoll;
    if(and__3822__auto____7297) {
      return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3
    }else {
      return and__3822__auto____7297
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, n, val)
  }else {
    var x__2458__auto____7298 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____7299 = cljs.core._assoc_n_BANG_[goog.typeOf(x__2458__auto____7298)];
      if(or__3824__auto____7299) {
        return or__3824__auto____7299
      }else {
        var or__3824__auto____7300 = cljs.core._assoc_n_BANG_["_"];
        if(or__3824__auto____7300) {
          return or__3824__auto____7300
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-assoc-n!", tcoll);
        }
      }
    }().call(null, tcoll, n, val)
  }
};
cljs.core._pop_BANG_ = function _pop_BANG_(tcoll) {
  if(function() {
    var and__3822__auto____7305 = tcoll;
    if(and__3822__auto____7305) {
      return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1
    }else {
      return and__3822__auto____7305
    }
  }()) {
    return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll)
  }else {
    var x__2458__auto____7306 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____7307 = cljs.core._pop_BANG_[goog.typeOf(x__2458__auto____7306)];
      if(or__3824__auto____7307) {
        return or__3824__auto____7307
      }else {
        var or__3824__auto____7308 = cljs.core._pop_BANG_["_"];
        if(or__3824__auto____7308) {
          return or__3824__auto____7308
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientVector.-pop!", tcoll);
        }
      }
    }().call(null, tcoll)
  }
};
cljs.core.ITransientSet = {};
cljs.core._disjoin_BANG_ = function _disjoin_BANG_(tcoll, v) {
  if(function() {
    var and__3822__auto____7313 = tcoll;
    if(and__3822__auto____7313) {
      return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2
    }else {
      return and__3822__auto____7313
    }
  }()) {
    return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll, v)
  }else {
    var x__2458__auto____7314 = tcoll == null ? null : tcoll;
    return function() {
      var or__3824__auto____7315 = cljs.core._disjoin_BANG_[goog.typeOf(x__2458__auto____7314)];
      if(or__3824__auto____7315) {
        return or__3824__auto____7315
      }else {
        var or__3824__auto____7316 = cljs.core._disjoin_BANG_["_"];
        if(or__3824__auto____7316) {
          return or__3824__auto____7316
        }else {
          throw cljs.core.missing_protocol.call(null, "ITransientSet.-disjoin!", tcoll);
        }
      }
    }().call(null, tcoll, v)
  }
};
cljs.core.IComparable = {};
cljs.core._compare = function _compare(x, y) {
  if(function() {
    var and__3822__auto____7321 = x;
    if(and__3822__auto____7321) {
      return x.cljs$core$IComparable$_compare$arity$2
    }else {
      return and__3822__auto____7321
    }
  }()) {
    return x.cljs$core$IComparable$_compare$arity$2(x, y)
  }else {
    var x__2458__auto____7322 = x == null ? null : x;
    return function() {
      var or__3824__auto____7323 = cljs.core._compare[goog.typeOf(x__2458__auto____7322)];
      if(or__3824__auto____7323) {
        return or__3824__auto____7323
      }else {
        var or__3824__auto____7324 = cljs.core._compare["_"];
        if(or__3824__auto____7324) {
          return or__3824__auto____7324
        }else {
          throw cljs.core.missing_protocol.call(null, "IComparable.-compare", x);
        }
      }
    }().call(null, x, y)
  }
};
cljs.core.IChunk = {};
cljs.core._drop_first = function _drop_first(coll) {
  if(function() {
    var and__3822__auto____7329 = coll;
    if(and__3822__auto____7329) {
      return coll.cljs$core$IChunk$_drop_first$arity$1
    }else {
      return and__3822__auto____7329
    }
  }()) {
    return coll.cljs$core$IChunk$_drop_first$arity$1(coll)
  }else {
    var x__2458__auto____7330 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7331 = cljs.core._drop_first[goog.typeOf(x__2458__auto____7330)];
      if(or__3824__auto____7331) {
        return or__3824__auto____7331
      }else {
        var or__3824__auto____7332 = cljs.core._drop_first["_"];
        if(or__3824__auto____7332) {
          return or__3824__auto____7332
        }else {
          throw cljs.core.missing_protocol.call(null, "IChunk.-drop-first", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.IChunkedSeq = {};
cljs.core._chunked_first = function _chunked_first(coll) {
  if(function() {
    var and__3822__auto____7337 = coll;
    if(and__3822__auto____7337) {
      return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1
    }else {
      return and__3822__auto____7337
    }
  }()) {
    return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll)
  }else {
    var x__2458__auto____7338 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7339 = cljs.core._chunked_first[goog.typeOf(x__2458__auto____7338)];
      if(or__3824__auto____7339) {
        return or__3824__auto____7339
      }else {
        var or__3824__auto____7340 = cljs.core._chunked_first["_"];
        if(or__3824__auto____7340) {
          return or__3824__auto____7340
        }else {
          throw cljs.core.missing_protocol.call(null, "IChunkedSeq.-chunked-first", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core._chunked_rest = function _chunked_rest(coll) {
  if(function() {
    var and__3822__auto____7345 = coll;
    if(and__3822__auto____7345) {
      return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1
    }else {
      return and__3822__auto____7345
    }
  }()) {
    return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll)
  }else {
    var x__2458__auto____7346 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7347 = cljs.core._chunked_rest[goog.typeOf(x__2458__auto____7346)];
      if(or__3824__auto____7347) {
        return or__3824__auto____7347
      }else {
        var or__3824__auto____7348 = cljs.core._chunked_rest["_"];
        if(or__3824__auto____7348) {
          return or__3824__auto____7348
        }else {
          throw cljs.core.missing_protocol.call(null, "IChunkedSeq.-chunked-rest", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.IChunkedNext = {};
cljs.core._chunked_next = function _chunked_next(coll) {
  if(function() {
    var and__3822__auto____7353 = coll;
    if(and__3822__auto____7353) {
      return coll.cljs$core$IChunkedNext$_chunked_next$arity$1
    }else {
      return and__3822__auto____7353
    }
  }()) {
    return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll)
  }else {
    var x__2458__auto____7354 = coll == null ? null : coll;
    return function() {
      var or__3824__auto____7355 = cljs.core._chunked_next[goog.typeOf(x__2458__auto____7354)];
      if(or__3824__auto____7355) {
        return or__3824__auto____7355
      }else {
        var or__3824__auto____7356 = cljs.core._chunked_next["_"];
        if(or__3824__auto____7356) {
          return or__3824__auto____7356
        }else {
          throw cljs.core.missing_protocol.call(null, "IChunkedNext.-chunked-next", coll);
        }
      }
    }().call(null, coll)
  }
};
cljs.core.identical_QMARK_ = function identical_QMARK_(x, y) {
  return x === y
};
cljs.core._EQ_ = function() {
  var _EQ_ = null;
  var _EQ___1 = function(x) {
    return true
  };
  var _EQ___2 = function(x, y) {
    var or__3824__auto____7358 = x === y;
    if(or__3824__auto____7358) {
      return or__3824__auto____7358
    }else {
      return cljs.core._equiv.call(null, x, y)
    }
  };
  var _EQ___3 = function() {
    var G__7359__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ_.call(null, x, y))) {
          if(cljs.core.next.call(null, more)) {
            var G__7360 = y;
            var G__7361 = cljs.core.first.call(null, more);
            var G__7362 = cljs.core.next.call(null, more);
            x = G__7360;
            y = G__7361;
            more = G__7362;
            continue
          }else {
            return _EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__7359 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7359__delegate.call(this, x, y, more)
    };
    G__7359.cljs$lang$maxFixedArity = 2;
    G__7359.cljs$lang$applyTo = function(arglist__7363) {
      var x = cljs.core.first(arglist__7363);
      var y = cljs.core.first(cljs.core.next(arglist__7363));
      var more = cljs.core.rest(cljs.core.next(arglist__7363));
      return G__7359__delegate(x, y, more)
    };
    G__7359.cljs$lang$arity$variadic = G__7359__delegate;
    return G__7359
  }();
  _EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ___1.call(this, x);
      case 2:
        return _EQ___2.call(this, x, y);
      default:
        return _EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ_.cljs$lang$maxFixedArity = 2;
  _EQ_.cljs$lang$applyTo = _EQ___3.cljs$lang$applyTo;
  _EQ_.cljs$lang$arity$1 = _EQ___1;
  _EQ_.cljs$lang$arity$2 = _EQ___2;
  _EQ_.cljs$lang$arity$variadic = _EQ___3.cljs$lang$arity$variadic;
  return _EQ_
}();
cljs.core.nil_QMARK_ = function nil_QMARK_(x) {
  return x == null
};
cljs.core.type = function type(x) {
  if(x == null) {
    return null
  }else {
    return x.constructor
  }
};
cljs.core.instance_QMARK_ = function instance_QMARK_(t, o) {
  return o instanceof t
};
cljs.core.IHash["null"] = true;
cljs.core._hash["null"] = function(o) {
  return 0
};
cljs.core.ILookup["null"] = true;
cljs.core._lookup["null"] = function() {
  var G__7364 = null;
  var G__7364__2 = function(o, k) {
    return null
  };
  var G__7364__3 = function(o, k, not_found) {
    return not_found
  };
  G__7364 = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7364__2.call(this, o, k);
      case 3:
        return G__7364__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7364
}();
cljs.core.IAssociative["null"] = true;
cljs.core._assoc["null"] = function(_, k, v) {
  return cljs.core.hash_map.call(null, k, v)
};
cljs.core.INext["null"] = true;
cljs.core._next["null"] = function(_) {
  return null
};
cljs.core.ICollection["null"] = true;
cljs.core._conj["null"] = function(_, o) {
  return cljs.core.list.call(null, o)
};
cljs.core.IReduce["null"] = true;
cljs.core._reduce["null"] = function() {
  var G__7365 = null;
  var G__7365__2 = function(_, f) {
    return f.call(null)
  };
  var G__7365__3 = function(_, f, start) {
    return start
  };
  G__7365 = function(_, f, start) {
    switch(arguments.length) {
      case 2:
        return G__7365__2.call(this, _, f);
      case 3:
        return G__7365__3.call(this, _, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7365
}();
cljs.core.IPrintable["null"] = true;
cljs.core._pr_seq["null"] = function(o) {
  return cljs.core.list.call(null, "nil")
};
cljs.core.ISet["null"] = true;
cljs.core._disjoin["null"] = function(_, v) {
  return null
};
cljs.core.ICounted["null"] = true;
cljs.core._count["null"] = function(_) {
  return 0
};
cljs.core.IStack["null"] = true;
cljs.core._peek["null"] = function(_) {
  return null
};
cljs.core._pop["null"] = function(_) {
  return null
};
cljs.core.ISeq["null"] = true;
cljs.core._first["null"] = function(_) {
  return null
};
cljs.core._rest["null"] = function(_) {
  return cljs.core.list.call(null)
};
cljs.core.IEquiv["null"] = true;
cljs.core._equiv["null"] = function(_, o) {
  return o == null
};
cljs.core.IWithMeta["null"] = true;
cljs.core._with_meta["null"] = function(_, meta) {
  return null
};
cljs.core.IMeta["null"] = true;
cljs.core._meta["null"] = function(_) {
  return null
};
cljs.core.IIndexed["null"] = true;
cljs.core._nth["null"] = function() {
  var G__7366 = null;
  var G__7366__2 = function(_, n) {
    return null
  };
  var G__7366__3 = function(_, n, not_found) {
    return not_found
  };
  G__7366 = function(_, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7366__2.call(this, _, n);
      case 3:
        return G__7366__3.call(this, _, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7366
}();
cljs.core.IEmptyableCollection["null"] = true;
cljs.core._empty["null"] = function(_) {
  return null
};
cljs.core.IMap["null"] = true;
cljs.core._dissoc["null"] = function(_, k) {
  return null
};
Date.prototype.cljs$core$IEquiv$ = true;
Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var and__3822__auto____7367 = cljs.core.instance_QMARK_.call(null, Date, other);
  if(and__3822__auto____7367) {
    return o.toString() === other.toString()
  }else {
    return and__3822__auto____7367
  }
};
cljs.core.IHash["number"] = true;
cljs.core._hash["number"] = function(o) {
  return o
};
cljs.core.IEquiv["number"] = true;
cljs.core._equiv["number"] = function(x, o) {
  return x === o
};
cljs.core.IHash["boolean"] = true;
cljs.core._hash["boolean"] = function(o) {
  if(o === true) {
    return 1
  }else {
    return 0
  }
};
cljs.core.IHash["_"] = true;
cljs.core._hash["_"] = function(o) {
  return goog.getUid(o)
};
cljs.core.inc = function inc(x) {
  return x + 1
};
cljs.core.ci_reduce = function() {
  var ci_reduce = null;
  var ci_reduce__2 = function(cicoll, f) {
    var cnt__7380 = cljs.core._count.call(null, cicoll);
    if(cnt__7380 === 0) {
      return f.call(null)
    }else {
      var val__7381 = cljs.core._nth.call(null, cicoll, 0);
      var n__7382 = 1;
      while(true) {
        if(n__7382 < cnt__7380) {
          var nval__7383 = f.call(null, val__7381, cljs.core._nth.call(null, cicoll, n__7382));
          if(cljs.core.reduced_QMARK_.call(null, nval__7383)) {
            return cljs.core.deref.call(null, nval__7383)
          }else {
            var G__7392 = nval__7383;
            var G__7393 = n__7382 + 1;
            val__7381 = G__7392;
            n__7382 = G__7393;
            continue
          }
        }else {
          return val__7381
        }
        break
      }
    }
  };
  var ci_reduce__3 = function(cicoll, f, val) {
    var cnt__7384 = cljs.core._count.call(null, cicoll);
    var val__7385 = val;
    var n__7386 = 0;
    while(true) {
      if(n__7386 < cnt__7384) {
        var nval__7387 = f.call(null, val__7385, cljs.core._nth.call(null, cicoll, n__7386));
        if(cljs.core.reduced_QMARK_.call(null, nval__7387)) {
          return cljs.core.deref.call(null, nval__7387)
        }else {
          var G__7394 = nval__7387;
          var G__7395 = n__7386 + 1;
          val__7385 = G__7394;
          n__7386 = G__7395;
          continue
        }
      }else {
        return val__7385
      }
      break
    }
  };
  var ci_reduce__4 = function(cicoll, f, val, idx) {
    var cnt__7388 = cljs.core._count.call(null, cicoll);
    var val__7389 = val;
    var n__7390 = idx;
    while(true) {
      if(n__7390 < cnt__7388) {
        var nval__7391 = f.call(null, val__7389, cljs.core._nth.call(null, cicoll, n__7390));
        if(cljs.core.reduced_QMARK_.call(null, nval__7391)) {
          return cljs.core.deref.call(null, nval__7391)
        }else {
          var G__7396 = nval__7391;
          var G__7397 = n__7390 + 1;
          val__7389 = G__7396;
          n__7390 = G__7397;
          continue
        }
      }else {
        return val__7389
      }
      break
    }
  };
  ci_reduce = function(cicoll, f, val, idx) {
    switch(arguments.length) {
      case 2:
        return ci_reduce__2.call(this, cicoll, f);
      case 3:
        return ci_reduce__3.call(this, cicoll, f, val);
      case 4:
        return ci_reduce__4.call(this, cicoll, f, val, idx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ci_reduce.cljs$lang$arity$2 = ci_reduce__2;
  ci_reduce.cljs$lang$arity$3 = ci_reduce__3;
  ci_reduce.cljs$lang$arity$4 = ci_reduce__4;
  return ci_reduce
}();
cljs.core.array_reduce = function() {
  var array_reduce = null;
  var array_reduce__2 = function(arr, f) {
    var cnt__7410 = arr.length;
    if(arr.length === 0) {
      return f.call(null)
    }else {
      var val__7411 = arr[0];
      var n__7412 = 1;
      while(true) {
        if(n__7412 < cnt__7410) {
          var nval__7413 = f.call(null, val__7411, arr[n__7412]);
          if(cljs.core.reduced_QMARK_.call(null, nval__7413)) {
            return cljs.core.deref.call(null, nval__7413)
          }else {
            var G__7422 = nval__7413;
            var G__7423 = n__7412 + 1;
            val__7411 = G__7422;
            n__7412 = G__7423;
            continue
          }
        }else {
          return val__7411
        }
        break
      }
    }
  };
  var array_reduce__3 = function(arr, f, val) {
    var cnt__7414 = arr.length;
    var val__7415 = val;
    var n__7416 = 0;
    while(true) {
      if(n__7416 < cnt__7414) {
        var nval__7417 = f.call(null, val__7415, arr[n__7416]);
        if(cljs.core.reduced_QMARK_.call(null, nval__7417)) {
          return cljs.core.deref.call(null, nval__7417)
        }else {
          var G__7424 = nval__7417;
          var G__7425 = n__7416 + 1;
          val__7415 = G__7424;
          n__7416 = G__7425;
          continue
        }
      }else {
        return val__7415
      }
      break
    }
  };
  var array_reduce__4 = function(arr, f, val, idx) {
    var cnt__7418 = arr.length;
    var val__7419 = val;
    var n__7420 = idx;
    while(true) {
      if(n__7420 < cnt__7418) {
        var nval__7421 = f.call(null, val__7419, arr[n__7420]);
        if(cljs.core.reduced_QMARK_.call(null, nval__7421)) {
          return cljs.core.deref.call(null, nval__7421)
        }else {
          var G__7426 = nval__7421;
          var G__7427 = n__7420 + 1;
          val__7419 = G__7426;
          n__7420 = G__7427;
          continue
        }
      }else {
        return val__7419
      }
      break
    }
  };
  array_reduce = function(arr, f, val, idx) {
    switch(arguments.length) {
      case 2:
        return array_reduce__2.call(this, arr, f);
      case 3:
        return array_reduce__3.call(this, arr, f, val);
      case 4:
        return array_reduce__4.call(this, arr, f, val, idx)
    }
    throw"Invalid arity: " + arguments.length;
  };
  array_reduce.cljs$lang$arity$2 = array_reduce__2;
  array_reduce.cljs$lang$arity$3 = array_reduce__3;
  array_reduce.cljs$lang$arity$4 = array_reduce__4;
  return array_reduce
}();
cljs.core.IndexedSeq = function(a, i) {
  this.a = a;
  this.i = i;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 166199546
};
cljs.core.IndexedSeq.cljs$lang$type = true;
cljs.core.IndexedSeq.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/IndexedSeq")
};
cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__7428 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = function(_) {
  var this__7429 = this;
  if(this__7429.i + 1 < this__7429.a.length) {
    return new cljs.core.IndexedSeq(this__7429.a, this__7429.i + 1)
  }else {
    return null
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__7430 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__7431 = this;
  var c__7432 = coll.cljs$core$ICounted$_count$arity$1(coll);
  if(c__7432 > 0) {
    return new cljs.core.RSeq(coll, c__7432 - 1, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.IndexedSeq.prototype.toString = function() {
  var this__7433 = this;
  var this__7434 = this;
  return cljs.core.pr_str.call(null, this__7434)
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__7435 = this;
  if(cljs.core.counted_QMARK_.call(null, this__7435.a)) {
    return cljs.core.ci_reduce.call(null, this__7435.a, f, this__7435.a[this__7435.i], this__7435.i + 1)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, this__7435.a[this__7435.i], 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__7436 = this;
  if(cljs.core.counted_QMARK_.call(null, this__7436.a)) {
    return cljs.core.ci_reduce.call(null, this__7436.a, f, start, this__7436.i)
  }else {
    return cljs.core.ci_reduce.call(null, coll, f, start, 0)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__7437 = this;
  return this$
};
cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var this__7438 = this;
  return this__7438.a.length - this__7438.i
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(_) {
  var this__7439 = this;
  return this__7439.a[this__7439.i]
};
cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(_) {
  var this__7440 = this;
  if(this__7440.i + 1 < this__7440.a.length) {
    return new cljs.core.IndexedSeq(this__7440.a, this__7440.i + 1)
  }else {
    return cljs.core.list.call(null)
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__7441 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__7442 = this;
  var i__7443 = n + this__7442.i;
  if(i__7443 < this__7442.a.length) {
    return this__7442.a[i__7443]
  }else {
    return null
  }
};
cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__7444 = this;
  var i__7445 = n + this__7444.i;
  if(i__7445 < this__7444.a.length) {
    return this__7444.a[i__7445]
  }else {
    return not_found
  }
};
cljs.core.IndexedSeq;
cljs.core.prim_seq = function() {
  var prim_seq = null;
  var prim_seq__1 = function(prim) {
    return prim_seq.call(null, prim, 0)
  };
  var prim_seq__2 = function(prim, i) {
    if(prim.length === 0) {
      return null
    }else {
      return new cljs.core.IndexedSeq(prim, i)
    }
  };
  prim_seq = function(prim, i) {
    switch(arguments.length) {
      case 1:
        return prim_seq__1.call(this, prim);
      case 2:
        return prim_seq__2.call(this, prim, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  prim_seq.cljs$lang$arity$1 = prim_seq__1;
  prim_seq.cljs$lang$arity$2 = prim_seq__2;
  return prim_seq
}();
cljs.core.array_seq = function() {
  var array_seq = null;
  var array_seq__1 = function(array) {
    return cljs.core.prim_seq.call(null, array, 0)
  };
  var array_seq__2 = function(array, i) {
    return cljs.core.prim_seq.call(null, array, i)
  };
  array_seq = function(array, i) {
    switch(arguments.length) {
      case 1:
        return array_seq__1.call(this, array);
      case 2:
        return array_seq__2.call(this, array, i)
    }
    throw"Invalid arity: " + arguments.length;
  };
  array_seq.cljs$lang$arity$1 = array_seq__1;
  array_seq.cljs$lang$arity$2 = array_seq__2;
  return array_seq
}();
cljs.core.IReduce["array"] = true;
cljs.core._reduce["array"] = function() {
  var G__7446 = null;
  var G__7446__2 = function(array, f) {
    return cljs.core.ci_reduce.call(null, array, f)
  };
  var G__7446__3 = function(array, f, start) {
    return cljs.core.ci_reduce.call(null, array, f, start)
  };
  G__7446 = function(array, f, start) {
    switch(arguments.length) {
      case 2:
        return G__7446__2.call(this, array, f);
      case 3:
        return G__7446__3.call(this, array, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7446
}();
cljs.core.ILookup["array"] = true;
cljs.core._lookup["array"] = function() {
  var G__7447 = null;
  var G__7447__2 = function(array, k) {
    return array[k]
  };
  var G__7447__3 = function(array, k, not_found) {
    return cljs.core._nth.call(null, array, k, not_found)
  };
  G__7447 = function(array, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7447__2.call(this, array, k);
      case 3:
        return G__7447__3.call(this, array, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7447
}();
cljs.core.IIndexed["array"] = true;
cljs.core._nth["array"] = function() {
  var G__7448 = null;
  var G__7448__2 = function(array, n) {
    if(n < array.length) {
      return array[n]
    }else {
      return null
    }
  };
  var G__7448__3 = function(array, n, not_found) {
    if(n < array.length) {
      return array[n]
    }else {
      return not_found
    }
  };
  G__7448 = function(array, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7448__2.call(this, array, n);
      case 3:
        return G__7448__3.call(this, array, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7448
}();
cljs.core.ICounted["array"] = true;
cljs.core._count["array"] = function(a) {
  return a.length
};
cljs.core.ISeqable["array"] = true;
cljs.core._seq["array"] = function(array) {
  return cljs.core.array_seq.call(null, array, 0)
};
cljs.core.RSeq = function(ci, i, meta) {
  this.ci = ci;
  this.i = i;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31850570
};
cljs.core.RSeq.cljs$lang$type = true;
cljs.core.RSeq.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/RSeq")
};
cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__7449 = this;
  return cljs.core.hash_coll.call(null, coll)
};
cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__7450 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.RSeq.prototype.toString = function() {
  var this__7451 = this;
  var this__7452 = this;
  return cljs.core.pr_str.call(null, this__7452)
};
cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__7453 = this;
  return coll
};
cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__7454 = this;
  return this__7454.i + 1
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__7455 = this;
  return cljs.core._nth.call(null, this__7455.ci, this__7455.i)
};
cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__7456 = this;
  if(this__7456.i > 0) {
    return new cljs.core.RSeq(this__7456.ci, this__7456.i - 1, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__7457 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, new_meta) {
  var this__7458 = this;
  return new cljs.core.RSeq(this__7458.ci, this__7458.i, new_meta)
};
cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__7459 = this;
  return this__7459.meta
};
cljs.core.RSeq;
cljs.core.seq = function seq(coll) {
  if(coll == null) {
    return null
  }else {
    if(function() {
      var G__7463__7464 = coll;
      if(G__7463__7464) {
        if(function() {
          var or__3824__auto____7465 = G__7463__7464.cljs$lang$protocol_mask$partition0$ & 32;
          if(or__3824__auto____7465) {
            return or__3824__auto____7465
          }else {
            return G__7463__7464.cljs$core$ASeq$
          }
        }()) {
          return true
        }else {
          if(!G__7463__7464.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__7463__7464)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ASeq, G__7463__7464)
      }
    }()) {
      return coll
    }else {
      return cljs.core._seq.call(null, coll)
    }
  }
};
cljs.core.first = function first(coll) {
  if(coll == null) {
    return null
  }else {
    if(function() {
      var G__7470__7471 = coll;
      if(G__7470__7471) {
        if(function() {
          var or__3824__auto____7472 = G__7470__7471.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3824__auto____7472) {
            return or__3824__auto____7472
          }else {
            return G__7470__7471.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__7470__7471.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__7470__7471)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__7470__7471)
      }
    }()) {
      return cljs.core._first.call(null, coll)
    }else {
      var s__7473 = cljs.core.seq.call(null, coll);
      if(s__7473 == null) {
        return null
      }else {
        return cljs.core._first.call(null, s__7473)
      }
    }
  }
};
cljs.core.rest = function rest(coll) {
  if(!(coll == null)) {
    if(function() {
      var G__7478__7479 = coll;
      if(G__7478__7479) {
        if(function() {
          var or__3824__auto____7480 = G__7478__7479.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3824__auto____7480) {
            return or__3824__auto____7480
          }else {
            return G__7478__7479.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__7478__7479.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__7478__7479)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__7478__7479)
      }
    }()) {
      return cljs.core._rest.call(null, coll)
    }else {
      var s__7481 = cljs.core.seq.call(null, coll);
      if(!(s__7481 == null)) {
        return cljs.core._rest.call(null, s__7481)
      }else {
        return cljs.core.List.EMPTY
      }
    }
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.next = function next(coll) {
  if(coll == null) {
    return null
  }else {
    if(function() {
      var G__7485__7486 = coll;
      if(G__7485__7486) {
        if(function() {
          var or__3824__auto____7487 = G__7485__7486.cljs$lang$protocol_mask$partition0$ & 128;
          if(or__3824__auto____7487) {
            return or__3824__auto____7487
          }else {
            return G__7485__7486.cljs$core$INext$
          }
        }()) {
          return true
        }else {
          if(!G__7485__7486.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.INext, G__7485__7486)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.INext, G__7485__7486)
      }
    }()) {
      return cljs.core._next.call(null, coll)
    }else {
      return cljs.core.seq.call(null, cljs.core.rest.call(null, coll))
    }
  }
};
cljs.core.second = function second(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.ffirst = function ffirst(coll) {
  return cljs.core.first.call(null, cljs.core.first.call(null, coll))
};
cljs.core.nfirst = function nfirst(coll) {
  return cljs.core.next.call(null, cljs.core.first.call(null, coll))
};
cljs.core.fnext = function fnext(coll) {
  return cljs.core.first.call(null, cljs.core.next.call(null, coll))
};
cljs.core.nnext = function nnext(coll) {
  return cljs.core.next.call(null, cljs.core.next.call(null, coll))
};
cljs.core.last = function last(s) {
  while(true) {
    var sn__7489 = cljs.core.next.call(null, s);
    if(!(sn__7489 == null)) {
      var G__7490 = sn__7489;
      s = G__7490;
      continue
    }else {
      return cljs.core.first.call(null, s)
    }
    break
  }
};
cljs.core.IEquiv["_"] = true;
cljs.core._equiv["_"] = function(x, o) {
  return x === o
};
cljs.core.not = function not(x) {
  if(cljs.core.truth_(x)) {
    return false
  }else {
    return true
  }
};
cljs.core.conj = function() {
  var conj = null;
  var conj__2 = function(coll, x) {
    return cljs.core._conj.call(null, coll, x)
  };
  var conj__3 = function() {
    var G__7491__delegate = function(coll, x, xs) {
      while(true) {
        if(cljs.core.truth_(xs)) {
          var G__7492 = conj.call(null, coll, x);
          var G__7493 = cljs.core.first.call(null, xs);
          var G__7494 = cljs.core.next.call(null, xs);
          coll = G__7492;
          x = G__7493;
          xs = G__7494;
          continue
        }else {
          return conj.call(null, coll, x)
        }
        break
      }
    };
    var G__7491 = function(coll, x, var_args) {
      var xs = null;
      if(goog.isDef(var_args)) {
        xs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7491__delegate.call(this, coll, x, xs)
    };
    G__7491.cljs$lang$maxFixedArity = 2;
    G__7491.cljs$lang$applyTo = function(arglist__7495) {
      var coll = cljs.core.first(arglist__7495);
      var x = cljs.core.first(cljs.core.next(arglist__7495));
      var xs = cljs.core.rest(cljs.core.next(arglist__7495));
      return G__7491__delegate(coll, x, xs)
    };
    G__7491.cljs$lang$arity$variadic = G__7491__delegate;
    return G__7491
  }();
  conj = function(coll, x, var_args) {
    var xs = var_args;
    switch(arguments.length) {
      case 2:
        return conj__2.call(this, coll, x);
      default:
        return conj__3.cljs$lang$arity$variadic(coll, x, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  conj.cljs$lang$maxFixedArity = 2;
  conj.cljs$lang$applyTo = conj__3.cljs$lang$applyTo;
  conj.cljs$lang$arity$2 = conj__2;
  conj.cljs$lang$arity$variadic = conj__3.cljs$lang$arity$variadic;
  return conj
}();
cljs.core.empty = function empty(coll) {
  return cljs.core._empty.call(null, coll)
};
cljs.core.accumulating_seq_count = function accumulating_seq_count(coll) {
  var s__7498 = cljs.core.seq.call(null, coll);
  var acc__7499 = 0;
  while(true) {
    if(cljs.core.counted_QMARK_.call(null, s__7498)) {
      return acc__7499 + cljs.core._count.call(null, s__7498)
    }else {
      var G__7500 = cljs.core.next.call(null, s__7498);
      var G__7501 = acc__7499 + 1;
      s__7498 = G__7500;
      acc__7499 = G__7501;
      continue
    }
    break
  }
};
cljs.core.count = function count(coll) {
  if(cljs.core.counted_QMARK_.call(null, coll)) {
    return cljs.core._count.call(null, coll)
  }else {
    return cljs.core.accumulating_seq_count.call(null, coll)
  }
};
cljs.core.linear_traversal_nth = function() {
  var linear_traversal_nth = null;
  var linear_traversal_nth__2 = function(coll, n) {
    if(coll == null) {
      throw new Error("Index out of bounds");
    }else {
      if(n === 0) {
        if(cljs.core.seq.call(null, coll)) {
          return cljs.core.first.call(null, coll)
        }else {
          throw new Error("Index out of bounds");
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n)
        }else {
          if(cljs.core.seq.call(null, coll)) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1)
          }else {
            if("\ufdd0'else") {
              throw new Error("Index out of bounds");
            }else {
              return null
            }
          }
        }
      }
    }
  };
  var linear_traversal_nth__3 = function(coll, n, not_found) {
    if(coll == null) {
      return not_found
    }else {
      if(n === 0) {
        if(cljs.core.seq.call(null, coll)) {
          return cljs.core.first.call(null, coll)
        }else {
          return not_found
        }
      }else {
        if(cljs.core.indexed_QMARK_.call(null, coll)) {
          return cljs.core._nth.call(null, coll, n, not_found)
        }else {
          if(cljs.core.seq.call(null, coll)) {
            return linear_traversal_nth.call(null, cljs.core.next.call(null, coll), n - 1, not_found)
          }else {
            if("\ufdd0'else") {
              return not_found
            }else {
              return null
            }
          }
        }
      }
    }
  };
  linear_traversal_nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return linear_traversal_nth__2.call(this, coll, n);
      case 3:
        return linear_traversal_nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  linear_traversal_nth.cljs$lang$arity$2 = linear_traversal_nth__2;
  linear_traversal_nth.cljs$lang$arity$3 = linear_traversal_nth__3;
  return linear_traversal_nth
}();
cljs.core.nth = function() {
  var nth = null;
  var nth__2 = function(coll, n) {
    if(coll == null) {
      return null
    }else {
      if(function() {
        var G__7508__7509 = coll;
        if(G__7508__7509) {
          if(function() {
            var or__3824__auto____7510 = G__7508__7509.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3824__auto____7510) {
              return or__3824__auto____7510
            }else {
              return G__7508__7509.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__7508__7509.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__7508__7509)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__7508__7509)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n))
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n))
      }
    }
  };
  var nth__3 = function(coll, n, not_found) {
    if(!(coll == null)) {
      if(function() {
        var G__7511__7512 = coll;
        if(G__7511__7512) {
          if(function() {
            var or__3824__auto____7513 = G__7511__7512.cljs$lang$protocol_mask$partition0$ & 16;
            if(or__3824__auto____7513) {
              return or__3824__auto____7513
            }else {
              return G__7511__7512.cljs$core$IIndexed$
            }
          }()) {
            return true
          }else {
            if(!G__7511__7512.cljs$lang$protocol_mask$partition0$) {
              return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__7511__7512)
            }else {
              return false
            }
          }
        }else {
          return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__7511__7512)
        }
      }()) {
        return cljs.core._nth.call(null, coll, Math.floor(n), not_found)
      }else {
        return cljs.core.linear_traversal_nth.call(null, coll, Math.floor(n), not_found)
      }
    }else {
      return not_found
    }
  };
  nth = function(coll, n, not_found) {
    switch(arguments.length) {
      case 2:
        return nth__2.call(this, coll, n);
      case 3:
        return nth__3.call(this, coll, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  nth.cljs$lang$arity$2 = nth__2;
  nth.cljs$lang$arity$3 = nth__3;
  return nth
}();
cljs.core.get = function() {
  var get = null;
  var get__2 = function(o, k) {
    return cljs.core._lookup.call(null, o, k)
  };
  var get__3 = function(o, k, not_found) {
    return cljs.core._lookup.call(null, o, k, not_found)
  };
  get = function(o, k, not_found) {
    switch(arguments.length) {
      case 2:
        return get__2.call(this, o, k);
      case 3:
        return get__3.call(this, o, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get.cljs$lang$arity$2 = get__2;
  get.cljs$lang$arity$3 = get__3;
  return get
}();
cljs.core.assoc = function() {
  var assoc = null;
  var assoc__3 = function(coll, k, v) {
    return cljs.core._assoc.call(null, coll, k, v)
  };
  var assoc__4 = function() {
    var G__7516__delegate = function(coll, k, v, kvs) {
      while(true) {
        var ret__7515 = assoc.call(null, coll, k, v);
        if(cljs.core.truth_(kvs)) {
          var G__7517 = ret__7515;
          var G__7518 = cljs.core.first.call(null, kvs);
          var G__7519 = cljs.core.second.call(null, kvs);
          var G__7520 = cljs.core.nnext.call(null, kvs);
          coll = G__7517;
          k = G__7518;
          v = G__7519;
          kvs = G__7520;
          continue
        }else {
          return ret__7515
        }
        break
      }
    };
    var G__7516 = function(coll, k, v, var_args) {
      var kvs = null;
      if(goog.isDef(var_args)) {
        kvs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__7516__delegate.call(this, coll, k, v, kvs)
    };
    G__7516.cljs$lang$maxFixedArity = 3;
    G__7516.cljs$lang$applyTo = function(arglist__7521) {
      var coll = cljs.core.first(arglist__7521);
      var k = cljs.core.first(cljs.core.next(arglist__7521));
      var v = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7521)));
      var kvs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7521)));
      return G__7516__delegate(coll, k, v, kvs)
    };
    G__7516.cljs$lang$arity$variadic = G__7516__delegate;
    return G__7516
  }();
  assoc = function(coll, k, v, var_args) {
    var kvs = var_args;
    switch(arguments.length) {
      case 3:
        return assoc__3.call(this, coll, k, v);
      default:
        return assoc__4.cljs$lang$arity$variadic(coll, k, v, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  assoc.cljs$lang$maxFixedArity = 3;
  assoc.cljs$lang$applyTo = assoc__4.cljs$lang$applyTo;
  assoc.cljs$lang$arity$3 = assoc__3;
  assoc.cljs$lang$arity$variadic = assoc__4.cljs$lang$arity$variadic;
  return assoc
}();
cljs.core.dissoc = function() {
  var dissoc = null;
  var dissoc__1 = function(coll) {
    return coll
  };
  var dissoc__2 = function(coll, k) {
    return cljs.core._dissoc.call(null, coll, k)
  };
  var dissoc__3 = function() {
    var G__7524__delegate = function(coll, k, ks) {
      while(true) {
        var ret__7523 = dissoc.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__7525 = ret__7523;
          var G__7526 = cljs.core.first.call(null, ks);
          var G__7527 = cljs.core.next.call(null, ks);
          coll = G__7525;
          k = G__7526;
          ks = G__7527;
          continue
        }else {
          return ret__7523
        }
        break
      }
    };
    var G__7524 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7524__delegate.call(this, coll, k, ks)
    };
    G__7524.cljs$lang$maxFixedArity = 2;
    G__7524.cljs$lang$applyTo = function(arglist__7528) {
      var coll = cljs.core.first(arglist__7528);
      var k = cljs.core.first(cljs.core.next(arglist__7528));
      var ks = cljs.core.rest(cljs.core.next(arglist__7528));
      return G__7524__delegate(coll, k, ks)
    };
    G__7524.cljs$lang$arity$variadic = G__7524__delegate;
    return G__7524
  }();
  dissoc = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return dissoc__1.call(this, coll);
      case 2:
        return dissoc__2.call(this, coll, k);
      default:
        return dissoc__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  dissoc.cljs$lang$maxFixedArity = 2;
  dissoc.cljs$lang$applyTo = dissoc__3.cljs$lang$applyTo;
  dissoc.cljs$lang$arity$1 = dissoc__1;
  dissoc.cljs$lang$arity$2 = dissoc__2;
  dissoc.cljs$lang$arity$variadic = dissoc__3.cljs$lang$arity$variadic;
  return dissoc
}();
cljs.core.with_meta = function with_meta(o, meta) {
  return cljs.core._with_meta.call(null, o, meta)
};
cljs.core.meta = function meta(o) {
  if(function() {
    var G__7532__7533 = o;
    if(G__7532__7533) {
      if(function() {
        var or__3824__auto____7534 = G__7532__7533.cljs$lang$protocol_mask$partition0$ & 131072;
        if(or__3824__auto____7534) {
          return or__3824__auto____7534
        }else {
          return G__7532__7533.cljs$core$IMeta$
        }
      }()) {
        return true
      }else {
        if(!G__7532__7533.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__7532__7533)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__7532__7533)
    }
  }()) {
    return cljs.core._meta.call(null, o)
  }else {
    return null
  }
};
cljs.core.peek = function peek(coll) {
  return cljs.core._peek.call(null, coll)
};
cljs.core.pop = function pop(coll) {
  return cljs.core._pop.call(null, coll)
};
cljs.core.disj = function() {
  var disj = null;
  var disj__1 = function(coll) {
    return coll
  };
  var disj__2 = function(coll, k) {
    return cljs.core._disjoin.call(null, coll, k)
  };
  var disj__3 = function() {
    var G__7537__delegate = function(coll, k, ks) {
      while(true) {
        var ret__7536 = disj.call(null, coll, k);
        if(cljs.core.truth_(ks)) {
          var G__7538 = ret__7536;
          var G__7539 = cljs.core.first.call(null, ks);
          var G__7540 = cljs.core.next.call(null, ks);
          coll = G__7538;
          k = G__7539;
          ks = G__7540;
          continue
        }else {
          return ret__7536
        }
        break
      }
    };
    var G__7537 = function(coll, k, var_args) {
      var ks = null;
      if(goog.isDef(var_args)) {
        ks = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7537__delegate.call(this, coll, k, ks)
    };
    G__7537.cljs$lang$maxFixedArity = 2;
    G__7537.cljs$lang$applyTo = function(arglist__7541) {
      var coll = cljs.core.first(arglist__7541);
      var k = cljs.core.first(cljs.core.next(arglist__7541));
      var ks = cljs.core.rest(cljs.core.next(arglist__7541));
      return G__7537__delegate(coll, k, ks)
    };
    G__7537.cljs$lang$arity$variadic = G__7537__delegate;
    return G__7537
  }();
  disj = function(coll, k, var_args) {
    var ks = var_args;
    switch(arguments.length) {
      case 1:
        return disj__1.call(this, coll);
      case 2:
        return disj__2.call(this, coll, k);
      default:
        return disj__3.cljs$lang$arity$variadic(coll, k, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  disj.cljs$lang$maxFixedArity = 2;
  disj.cljs$lang$applyTo = disj__3.cljs$lang$applyTo;
  disj.cljs$lang$arity$1 = disj__1;
  disj.cljs$lang$arity$2 = disj__2;
  disj.cljs$lang$arity$variadic = disj__3.cljs$lang$arity$variadic;
  return disj
}();
cljs.core.string_hash_cache = {};
cljs.core.string_hash_cache_count = 0;
cljs.core.add_to_string_hash_cache = function add_to_string_hash_cache(k) {
  var h__7543 = goog.string.hashCode(k);
  cljs.core.string_hash_cache[k] = h__7543;
  cljs.core.string_hash_cache_count = cljs.core.string_hash_cache_count + 1;
  return h__7543
};
cljs.core.check_string_hash_cache = function check_string_hash_cache(k) {
  if(cljs.core.string_hash_cache_count > 255) {
    cljs.core.string_hash_cache = {};
    cljs.core.string_hash_cache_count = 0
  }else {
  }
  var h__7545 = cljs.core.string_hash_cache[k];
  if(!(h__7545 == null)) {
    return h__7545
  }else {
    return cljs.core.add_to_string_hash_cache.call(null, k)
  }
};
cljs.core.hash = function() {
  var hash = null;
  var hash__1 = function(o) {
    return hash.call(null, o, true)
  };
  var hash__2 = function(o, check_cache) {
    if(function() {
      var and__3822__auto____7547 = goog.isString(o);
      if(and__3822__auto____7547) {
        return check_cache
      }else {
        return and__3822__auto____7547
      }
    }()) {
      return cljs.core.check_string_hash_cache.call(null, o)
    }else {
      return cljs.core._hash.call(null, o)
    }
  };
  hash = function(o, check_cache) {
    switch(arguments.length) {
      case 1:
        return hash__1.call(this, o);
      case 2:
        return hash__2.call(this, o, check_cache)
    }
    throw"Invalid arity: " + arguments.length;
  };
  hash.cljs$lang$arity$1 = hash__1;
  hash.cljs$lang$arity$2 = hash__2;
  return hash
}();
cljs.core.empty_QMARK_ = function empty_QMARK_(coll) {
  return cljs.core.not.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.coll_QMARK_ = function coll_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__7551__7552 = x;
    if(G__7551__7552) {
      if(function() {
        var or__3824__auto____7553 = G__7551__7552.cljs$lang$protocol_mask$partition0$ & 8;
        if(or__3824__auto____7553) {
          return or__3824__auto____7553
        }else {
          return G__7551__7552.cljs$core$ICollection$
        }
      }()) {
        return true
      }else {
        if(!G__7551__7552.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__7551__7552)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ICollection, G__7551__7552)
    }
  }
};
cljs.core.set_QMARK_ = function set_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__7557__7558 = x;
    if(G__7557__7558) {
      if(function() {
        var or__3824__auto____7559 = G__7557__7558.cljs$lang$protocol_mask$partition0$ & 4096;
        if(or__3824__auto____7559) {
          return or__3824__auto____7559
        }else {
          return G__7557__7558.cljs$core$ISet$
        }
      }()) {
        return true
      }else {
        if(!G__7557__7558.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__7557__7558)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISet, G__7557__7558)
    }
  }
};
cljs.core.associative_QMARK_ = function associative_QMARK_(x) {
  var G__7563__7564 = x;
  if(G__7563__7564) {
    if(function() {
      var or__3824__auto____7565 = G__7563__7564.cljs$lang$protocol_mask$partition0$ & 512;
      if(or__3824__auto____7565) {
        return or__3824__auto____7565
      }else {
        return G__7563__7564.cljs$core$IAssociative$
      }
    }()) {
      return true
    }else {
      if(!G__7563__7564.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__7563__7564)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IAssociative, G__7563__7564)
  }
};
cljs.core.sequential_QMARK_ = function sequential_QMARK_(x) {
  var G__7569__7570 = x;
  if(G__7569__7570) {
    if(function() {
      var or__3824__auto____7571 = G__7569__7570.cljs$lang$protocol_mask$partition0$ & 16777216;
      if(or__3824__auto____7571) {
        return or__3824__auto____7571
      }else {
        return G__7569__7570.cljs$core$ISequential$
      }
    }()) {
      return true
    }else {
      if(!G__7569__7570.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__7569__7570)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISequential, G__7569__7570)
  }
};
cljs.core.counted_QMARK_ = function counted_QMARK_(x) {
  var G__7575__7576 = x;
  if(G__7575__7576) {
    if(function() {
      var or__3824__auto____7577 = G__7575__7576.cljs$lang$protocol_mask$partition0$ & 2;
      if(or__3824__auto____7577) {
        return or__3824__auto____7577
      }else {
        return G__7575__7576.cljs$core$ICounted$
      }
    }()) {
      return true
    }else {
      if(!G__7575__7576.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__7575__7576)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ICounted, G__7575__7576)
  }
};
cljs.core.indexed_QMARK_ = function indexed_QMARK_(x) {
  var G__7581__7582 = x;
  if(G__7581__7582) {
    if(function() {
      var or__3824__auto____7583 = G__7581__7582.cljs$lang$protocol_mask$partition0$ & 16;
      if(or__3824__auto____7583) {
        return or__3824__auto____7583
      }else {
        return G__7581__7582.cljs$core$IIndexed$
      }
    }()) {
      return true
    }else {
      if(!G__7581__7582.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__7581__7582)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IIndexed, G__7581__7582)
  }
};
cljs.core.reduceable_QMARK_ = function reduceable_QMARK_(x) {
  var G__7587__7588 = x;
  if(G__7587__7588) {
    if(function() {
      var or__3824__auto____7589 = G__7587__7588.cljs$lang$protocol_mask$partition0$ & 524288;
      if(or__3824__auto____7589) {
        return or__3824__auto____7589
      }else {
        return G__7587__7588.cljs$core$IReduce$
      }
    }()) {
      return true
    }else {
      if(!G__7587__7588.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__7587__7588)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__7587__7588)
  }
};
cljs.core.map_QMARK_ = function map_QMARK_(x) {
  if(x == null) {
    return false
  }else {
    var G__7593__7594 = x;
    if(G__7593__7594) {
      if(function() {
        var or__3824__auto____7595 = G__7593__7594.cljs$lang$protocol_mask$partition0$ & 1024;
        if(or__3824__auto____7595) {
          return or__3824__auto____7595
        }else {
          return G__7593__7594.cljs$core$IMap$
        }
      }()) {
        return true
      }else {
        if(!G__7593__7594.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__7593__7594)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IMap, G__7593__7594)
    }
  }
};
cljs.core.vector_QMARK_ = function vector_QMARK_(x) {
  var G__7599__7600 = x;
  if(G__7599__7600) {
    if(function() {
      var or__3824__auto____7601 = G__7599__7600.cljs$lang$protocol_mask$partition0$ & 16384;
      if(or__3824__auto____7601) {
        return or__3824__auto____7601
      }else {
        return G__7599__7600.cljs$core$IVector$
      }
    }()) {
      return true
    }else {
      if(!G__7599__7600.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__7599__7600)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IVector, G__7599__7600)
  }
};
cljs.core.chunked_seq_QMARK_ = function chunked_seq_QMARK_(x) {
  var G__7605__7606 = x;
  if(G__7605__7606) {
    if(cljs.core.truth_(function() {
      var or__3824__auto____7607 = null;
      if(cljs.core.truth_(or__3824__auto____7607)) {
        return or__3824__auto____7607
      }else {
        return G__7605__7606.cljs$core$IChunkedSeq$
      }
    }())) {
      return true
    }else {
      if(!G__7605__7606.cljs$lang$protocol_mask$partition$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IChunkedSeq, G__7605__7606)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IChunkedSeq, G__7605__7606)
  }
};
cljs.core.js_obj = function() {
  var js_obj = null;
  var js_obj__0 = function() {
    return{}
  };
  var js_obj__1 = function() {
    var G__7608__delegate = function(keyvals) {
      return cljs.core.apply.call(null, goog.object.create, keyvals)
    };
    var G__7608 = function(var_args) {
      var keyvals = null;
      if(goog.isDef(var_args)) {
        keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__7608__delegate.call(this, keyvals)
    };
    G__7608.cljs$lang$maxFixedArity = 0;
    G__7608.cljs$lang$applyTo = function(arglist__7609) {
      var keyvals = cljs.core.seq(arglist__7609);
      return G__7608__delegate(keyvals)
    };
    G__7608.cljs$lang$arity$variadic = G__7608__delegate;
    return G__7608
  }();
  js_obj = function(var_args) {
    var keyvals = var_args;
    switch(arguments.length) {
      case 0:
        return js_obj__0.call(this);
      default:
        return js_obj__1.cljs$lang$arity$variadic(cljs.core.array_seq(arguments, 0))
    }
    throw"Invalid arity: " + arguments.length;
  };
  js_obj.cljs$lang$maxFixedArity = 0;
  js_obj.cljs$lang$applyTo = js_obj__1.cljs$lang$applyTo;
  js_obj.cljs$lang$arity$0 = js_obj__0;
  js_obj.cljs$lang$arity$variadic = js_obj__1.cljs$lang$arity$variadic;
  return js_obj
}();
cljs.core.js_keys = function js_keys(obj) {
  var keys__7611 = [];
  goog.object.forEach(obj, function(val, key, obj) {
    return keys__7611.push(key)
  });
  return keys__7611
};
cljs.core.js_delete = function js_delete(obj, key) {
  return delete obj[key]
};
cljs.core.array_copy = function array_copy(from, i, to, j, len) {
  var i__7615 = i;
  var j__7616 = j;
  var len__7617 = len;
  while(true) {
    if(len__7617 === 0) {
      return to
    }else {
      to[j__7616] = from[i__7615];
      var G__7618 = i__7615 + 1;
      var G__7619 = j__7616 + 1;
      var G__7620 = len__7617 - 1;
      i__7615 = G__7618;
      j__7616 = G__7619;
      len__7617 = G__7620;
      continue
    }
    break
  }
};
cljs.core.array_copy_downward = function array_copy_downward(from, i, to, j, len) {
  var i__7624 = i + (len - 1);
  var j__7625 = j + (len - 1);
  var len__7626 = len;
  while(true) {
    if(len__7626 === 0) {
      return to
    }else {
      to[j__7625] = from[i__7624];
      var G__7627 = i__7624 - 1;
      var G__7628 = j__7625 - 1;
      var G__7629 = len__7626 - 1;
      i__7624 = G__7627;
      j__7625 = G__7628;
      len__7626 = G__7629;
      continue
    }
    break
  }
};
cljs.core.lookup_sentinel = {};
cljs.core.false_QMARK_ = function false_QMARK_(x) {
  return x === false
};
cljs.core.true_QMARK_ = function true_QMARK_(x) {
  return x === true
};
cljs.core.undefined_QMARK_ = function undefined_QMARK_(x) {
  return void 0 === x
};
cljs.core.seq_QMARK_ = function seq_QMARK_(s) {
  if(s == null) {
    return false
  }else {
    var G__7633__7634 = s;
    if(G__7633__7634) {
      if(function() {
        var or__3824__auto____7635 = G__7633__7634.cljs$lang$protocol_mask$partition0$ & 64;
        if(or__3824__auto____7635) {
          return or__3824__auto____7635
        }else {
          return G__7633__7634.cljs$core$ISeq$
        }
      }()) {
        return true
      }else {
        if(!G__7633__7634.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__7633__7634)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__7633__7634)
    }
  }
};
cljs.core.seqable_QMARK_ = function seqable_QMARK_(s) {
  var G__7639__7640 = s;
  if(G__7639__7640) {
    if(function() {
      var or__3824__auto____7641 = G__7639__7640.cljs$lang$protocol_mask$partition0$ & 8388608;
      if(or__3824__auto____7641) {
        return or__3824__auto____7641
      }else {
        return G__7639__7640.cljs$core$ISeqable$
      }
    }()) {
      return true
    }else {
      if(!G__7639__7640.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__7639__7640)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.ISeqable, G__7639__7640)
  }
};
cljs.core.boolean$ = function boolean$(x) {
  if(cljs.core.truth_(x)) {
    return true
  }else {
    return false
  }
};
cljs.core.string_QMARK_ = function string_QMARK_(x) {
  var and__3822__auto____7644 = goog.isString(x);
  if(and__3822__auto____7644) {
    return!function() {
      var or__3824__auto____7645 = x.charAt(0) === "\ufdd0";
      if(or__3824__auto____7645) {
        return or__3824__auto____7645
      }else {
        return x.charAt(0) === "\ufdd1"
      }
    }()
  }else {
    return and__3822__auto____7644
  }
};
cljs.core.keyword_QMARK_ = function keyword_QMARK_(x) {
  var and__3822__auto____7647 = goog.isString(x);
  if(and__3822__auto____7647) {
    return x.charAt(0) === "\ufdd0"
  }else {
    return and__3822__auto____7647
  }
};
cljs.core.symbol_QMARK_ = function symbol_QMARK_(x) {
  var and__3822__auto____7649 = goog.isString(x);
  if(and__3822__auto____7649) {
    return x.charAt(0) === "\ufdd1"
  }else {
    return and__3822__auto____7649
  }
};
cljs.core.number_QMARK_ = function number_QMARK_(n) {
  return goog.isNumber(n)
};
cljs.core.fn_QMARK_ = function fn_QMARK_(f) {
  return goog.isFunction(f)
};
cljs.core.ifn_QMARK_ = function ifn_QMARK_(f) {
  var or__3824__auto____7654 = cljs.core.fn_QMARK_.call(null, f);
  if(or__3824__auto____7654) {
    return or__3824__auto____7654
  }else {
    var G__7655__7656 = f;
    if(G__7655__7656) {
      if(function() {
        var or__3824__auto____7657 = G__7655__7656.cljs$lang$protocol_mask$partition0$ & 1;
        if(or__3824__auto____7657) {
          return or__3824__auto____7657
        }else {
          return G__7655__7656.cljs$core$IFn$
        }
      }()) {
        return true
      }else {
        if(!G__7655__7656.cljs$lang$protocol_mask$partition0$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__7655__7656)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IFn, G__7655__7656)
    }
  }
};
cljs.core.integer_QMARK_ = function integer_QMARK_(n) {
  var and__3822__auto____7659 = cljs.core.number_QMARK_.call(null, n);
  if(and__3822__auto____7659) {
    return n == n.toFixed()
  }else {
    return and__3822__auto____7659
  }
};
cljs.core.contains_QMARK_ = function contains_QMARK_(coll, v) {
  if(cljs.core._lookup.call(null, coll, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return false
  }else {
    return true
  }
};
cljs.core.find = function find(coll, k) {
  if(cljs.core.truth_(function() {
    var and__3822__auto____7662 = coll;
    if(cljs.core.truth_(and__3822__auto____7662)) {
      var and__3822__auto____7663 = cljs.core.associative_QMARK_.call(null, coll);
      if(and__3822__auto____7663) {
        return cljs.core.contains_QMARK_.call(null, coll, k)
      }else {
        return and__3822__auto____7663
      }
    }else {
      return and__3822__auto____7662
    }
  }())) {
    return cljs.core.PersistentVector.fromArray([k, cljs.core._lookup.call(null, coll, k)], true)
  }else {
    return null
  }
};
cljs.core.distinct_QMARK_ = function() {
  var distinct_QMARK_ = null;
  var distinct_QMARK___1 = function(x) {
    return true
  };
  var distinct_QMARK___2 = function(x, y) {
    return!cljs.core._EQ_.call(null, x, y)
  };
  var distinct_QMARK___3 = function() {
    var G__7672__delegate = function(x, y, more) {
      if(!cljs.core._EQ_.call(null, x, y)) {
        var s__7668 = cljs.core.PersistentHashSet.fromArray([y, x]);
        var xs__7669 = more;
        while(true) {
          var x__7670 = cljs.core.first.call(null, xs__7669);
          var etc__7671 = cljs.core.next.call(null, xs__7669);
          if(cljs.core.truth_(xs__7669)) {
            if(cljs.core.contains_QMARK_.call(null, s__7668, x__7670)) {
              return false
            }else {
              var G__7673 = cljs.core.conj.call(null, s__7668, x__7670);
              var G__7674 = etc__7671;
              s__7668 = G__7673;
              xs__7669 = G__7674;
              continue
            }
          }else {
            return true
          }
          break
        }
      }else {
        return false
      }
    };
    var G__7672 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7672__delegate.call(this, x, y, more)
    };
    G__7672.cljs$lang$maxFixedArity = 2;
    G__7672.cljs$lang$applyTo = function(arglist__7675) {
      var x = cljs.core.first(arglist__7675);
      var y = cljs.core.first(cljs.core.next(arglist__7675));
      var more = cljs.core.rest(cljs.core.next(arglist__7675));
      return G__7672__delegate(x, y, more)
    };
    G__7672.cljs$lang$arity$variadic = G__7672__delegate;
    return G__7672
  }();
  distinct_QMARK_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return distinct_QMARK___1.call(this, x);
      case 2:
        return distinct_QMARK___2.call(this, x, y);
      default:
        return distinct_QMARK___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  distinct_QMARK_.cljs$lang$maxFixedArity = 2;
  distinct_QMARK_.cljs$lang$applyTo = distinct_QMARK___3.cljs$lang$applyTo;
  distinct_QMARK_.cljs$lang$arity$1 = distinct_QMARK___1;
  distinct_QMARK_.cljs$lang$arity$2 = distinct_QMARK___2;
  distinct_QMARK_.cljs$lang$arity$variadic = distinct_QMARK___3.cljs$lang$arity$variadic;
  return distinct_QMARK_
}();
cljs.core.compare = function compare(x, y) {
  if(x === y) {
    return 0
  }else {
    if(x == null) {
      return-1
    }else {
      if(y == null) {
        return 1
      }else {
        if(cljs.core.type.call(null, x) === cljs.core.type.call(null, y)) {
          if(function() {
            var G__7679__7680 = x;
            if(G__7679__7680) {
              if(cljs.core.truth_(function() {
                var or__3824__auto____7681 = null;
                if(cljs.core.truth_(or__3824__auto____7681)) {
                  return or__3824__auto____7681
                }else {
                  return G__7679__7680.cljs$core$IComparable$
                }
              }())) {
                return true
              }else {
                if(!G__7679__7680.cljs$lang$protocol_mask$partition$) {
                  return cljs.core.type_satisfies_.call(null, cljs.core.IComparable, G__7679__7680)
                }else {
                  return false
                }
              }
            }else {
              return cljs.core.type_satisfies_.call(null, cljs.core.IComparable, G__7679__7680)
            }
          }()) {
            return cljs.core._compare.call(null, x, y)
          }else {
            return goog.array.defaultCompare(x, y)
          }
        }else {
          if("\ufdd0'else") {
            throw new Error("compare on non-nil objects of different types");
          }else {
            return null
          }
        }
      }
    }
  }
};
cljs.core.compare_indexed = function() {
  var compare_indexed = null;
  var compare_indexed__2 = function(xs, ys) {
    var xl__7686 = cljs.core.count.call(null, xs);
    var yl__7687 = cljs.core.count.call(null, ys);
    if(xl__7686 < yl__7687) {
      return-1
    }else {
      if(xl__7686 > yl__7687) {
        return 1
      }else {
        if("\ufdd0'else") {
          return compare_indexed.call(null, xs, ys, xl__7686, 0)
        }else {
          return null
        }
      }
    }
  };
  var compare_indexed__4 = function(xs, ys, len, n) {
    while(true) {
      var d__7688 = cljs.core.compare.call(null, cljs.core.nth.call(null, xs, n), cljs.core.nth.call(null, ys, n));
      if(function() {
        var and__3822__auto____7689 = d__7688 === 0;
        if(and__3822__auto____7689) {
          return n + 1 < len
        }else {
          return and__3822__auto____7689
        }
      }()) {
        var G__7690 = xs;
        var G__7691 = ys;
        var G__7692 = len;
        var G__7693 = n + 1;
        xs = G__7690;
        ys = G__7691;
        len = G__7692;
        n = G__7693;
        continue
      }else {
        return d__7688
      }
      break
    }
  };
  compare_indexed = function(xs, ys, len, n) {
    switch(arguments.length) {
      case 2:
        return compare_indexed__2.call(this, xs, ys);
      case 4:
        return compare_indexed__4.call(this, xs, ys, len, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  compare_indexed.cljs$lang$arity$2 = compare_indexed__2;
  compare_indexed.cljs$lang$arity$4 = compare_indexed__4;
  return compare_indexed
}();
cljs.core.fn__GT_comparator = function fn__GT_comparator(f) {
  if(cljs.core._EQ_.call(null, f, cljs.core.compare)) {
    return cljs.core.compare
  }else {
    return function(x, y) {
      var r__7695 = f.call(null, x, y);
      if(cljs.core.number_QMARK_.call(null, r__7695)) {
        return r__7695
      }else {
        if(cljs.core.truth_(r__7695)) {
          return-1
        }else {
          if(cljs.core.truth_(f.call(null, y, x))) {
            return 1
          }else {
            return 0
          }
        }
      }
    }
  }
};
cljs.core.sort = function() {
  var sort = null;
  var sort__1 = function(coll) {
    return sort.call(null, cljs.core.compare, coll)
  };
  var sort__2 = function(comp, coll) {
    if(cljs.core.seq.call(null, coll)) {
      var a__7697 = cljs.core.to_array.call(null, coll);
      goog.array.stableSort(a__7697, cljs.core.fn__GT_comparator.call(null, comp));
      return cljs.core.seq.call(null, a__7697)
    }else {
      return cljs.core.List.EMPTY
    }
  };
  sort = function(comp, coll) {
    switch(arguments.length) {
      case 1:
        return sort__1.call(this, comp);
      case 2:
        return sort__2.call(this, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort.cljs$lang$arity$1 = sort__1;
  sort.cljs$lang$arity$2 = sort__2;
  return sort
}();
cljs.core.sort_by = function() {
  var sort_by = null;
  var sort_by__2 = function(keyfn, coll) {
    return sort_by.call(null, keyfn, cljs.core.compare, coll)
  };
  var sort_by__3 = function(keyfn, comp, coll) {
    return cljs.core.sort.call(null, function(x, y) {
      return cljs.core.fn__GT_comparator.call(null, comp).call(null, keyfn.call(null, x), keyfn.call(null, y))
    }, coll)
  };
  sort_by = function(keyfn, comp, coll) {
    switch(arguments.length) {
      case 2:
        return sort_by__2.call(this, keyfn, comp);
      case 3:
        return sort_by__3.call(this, keyfn, comp, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  sort_by.cljs$lang$arity$2 = sort_by__2;
  sort_by.cljs$lang$arity$3 = sort_by__3;
  return sort_by
}();
cljs.core.seq_reduce = function() {
  var seq_reduce = null;
  var seq_reduce__2 = function(f, coll) {
    var temp__3971__auto____7703 = cljs.core.seq.call(null, coll);
    if(temp__3971__auto____7703) {
      var s__7704 = temp__3971__auto____7703;
      return cljs.core.reduce.call(null, f, cljs.core.first.call(null, s__7704), cljs.core.next.call(null, s__7704))
    }else {
      return f.call(null)
    }
  };
  var seq_reduce__3 = function(f, val, coll) {
    var val__7705 = val;
    var coll__7706 = cljs.core.seq.call(null, coll);
    while(true) {
      if(coll__7706) {
        var nval__7707 = f.call(null, val__7705, cljs.core.first.call(null, coll__7706));
        if(cljs.core.reduced_QMARK_.call(null, nval__7707)) {
          return cljs.core.deref.call(null, nval__7707)
        }else {
          var G__7708 = nval__7707;
          var G__7709 = cljs.core.next.call(null, coll__7706);
          val__7705 = G__7708;
          coll__7706 = G__7709;
          continue
        }
      }else {
        return val__7705
      }
      break
    }
  };
  seq_reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return seq_reduce__2.call(this, f, val);
      case 3:
        return seq_reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  seq_reduce.cljs$lang$arity$2 = seq_reduce__2;
  seq_reduce.cljs$lang$arity$3 = seq_reduce__3;
  return seq_reduce
}();
cljs.core.shuffle = function shuffle(coll) {
  var a__7711 = cljs.core.to_array.call(null, coll);
  goog.array.shuffle(a__7711);
  return cljs.core.vec.call(null, a__7711)
};
cljs.core.reduce = function() {
  var reduce = null;
  var reduce__2 = function(f, coll) {
    if(function() {
      var G__7718__7719 = coll;
      if(G__7718__7719) {
        if(function() {
          var or__3824__auto____7720 = G__7718__7719.cljs$lang$protocol_mask$partition0$ & 524288;
          if(or__3824__auto____7720) {
            return or__3824__auto____7720
          }else {
            return G__7718__7719.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__7718__7719.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__7718__7719)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__7718__7719)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f)
    }else {
      return cljs.core.seq_reduce.call(null, f, coll)
    }
  };
  var reduce__3 = function(f, val, coll) {
    if(function() {
      var G__7721__7722 = coll;
      if(G__7721__7722) {
        if(function() {
          var or__3824__auto____7723 = G__7721__7722.cljs$lang$protocol_mask$partition0$ & 524288;
          if(or__3824__auto____7723) {
            return or__3824__auto____7723
          }else {
            return G__7721__7722.cljs$core$IReduce$
          }
        }()) {
          return true
        }else {
          if(!G__7721__7722.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__7721__7722)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReduce, G__7721__7722)
      }
    }()) {
      return cljs.core._reduce.call(null, coll, f, val)
    }else {
      return cljs.core.seq_reduce.call(null, f, val, coll)
    }
  };
  reduce = function(f, val, coll) {
    switch(arguments.length) {
      case 2:
        return reduce__2.call(this, f, val);
      case 3:
        return reduce__3.call(this, f, val, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reduce.cljs$lang$arity$2 = reduce__2;
  reduce.cljs$lang$arity$3 = reduce__3;
  return reduce
}();
cljs.core.reduce_kv = function reduce_kv(f, init, coll) {
  return cljs.core._kv_reduce.call(null, coll, f, init)
};
cljs.core.Reduced = function(val) {
  this.val = val;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32768
};
cljs.core.Reduced.cljs$lang$type = true;
cljs.core.Reduced.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/Reduced")
};
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = function(o) {
  var this__7724 = this;
  return this__7724.val
};
cljs.core.Reduced;
cljs.core.reduced_QMARK_ = function reduced_QMARK_(r) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Reduced, r)
};
cljs.core.reduced = function reduced(x) {
  return new cljs.core.Reduced(x)
};
cljs.core._PLUS_ = function() {
  var _PLUS_ = null;
  var _PLUS___0 = function() {
    return 0
  };
  var _PLUS___1 = function(x) {
    return x
  };
  var _PLUS___2 = function(x, y) {
    return x + y
  };
  var _PLUS___3 = function() {
    var G__7725__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _PLUS_, x + y, more)
    };
    var G__7725 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7725__delegate.call(this, x, y, more)
    };
    G__7725.cljs$lang$maxFixedArity = 2;
    G__7725.cljs$lang$applyTo = function(arglist__7726) {
      var x = cljs.core.first(arglist__7726);
      var y = cljs.core.first(cljs.core.next(arglist__7726));
      var more = cljs.core.rest(cljs.core.next(arglist__7726));
      return G__7725__delegate(x, y, more)
    };
    G__7725.cljs$lang$arity$variadic = G__7725__delegate;
    return G__7725
  }();
  _PLUS_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _PLUS___0.call(this);
      case 1:
        return _PLUS___1.call(this, x);
      case 2:
        return _PLUS___2.call(this, x, y);
      default:
        return _PLUS___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _PLUS_.cljs$lang$maxFixedArity = 2;
  _PLUS_.cljs$lang$applyTo = _PLUS___3.cljs$lang$applyTo;
  _PLUS_.cljs$lang$arity$0 = _PLUS___0;
  _PLUS_.cljs$lang$arity$1 = _PLUS___1;
  _PLUS_.cljs$lang$arity$2 = _PLUS___2;
  _PLUS_.cljs$lang$arity$variadic = _PLUS___3.cljs$lang$arity$variadic;
  return _PLUS_
}();
cljs.core._ = function() {
  var _ = null;
  var ___1 = function(x) {
    return-x
  };
  var ___2 = function(x, y) {
    return x - y
  };
  var ___3 = function() {
    var G__7727__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _, x - y, more)
    };
    var G__7727 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7727__delegate.call(this, x, y, more)
    };
    G__7727.cljs$lang$maxFixedArity = 2;
    G__7727.cljs$lang$applyTo = function(arglist__7728) {
      var x = cljs.core.first(arglist__7728);
      var y = cljs.core.first(cljs.core.next(arglist__7728));
      var more = cljs.core.rest(cljs.core.next(arglist__7728));
      return G__7727__delegate(x, y, more)
    };
    G__7727.cljs$lang$arity$variadic = G__7727__delegate;
    return G__7727
  }();
  _ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return ___1.call(this, x);
      case 2:
        return ___2.call(this, x, y);
      default:
        return ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _.cljs$lang$maxFixedArity = 2;
  _.cljs$lang$applyTo = ___3.cljs$lang$applyTo;
  _.cljs$lang$arity$1 = ___1;
  _.cljs$lang$arity$2 = ___2;
  _.cljs$lang$arity$variadic = ___3.cljs$lang$arity$variadic;
  return _
}();
cljs.core._STAR_ = function() {
  var _STAR_ = null;
  var _STAR___0 = function() {
    return 1
  };
  var _STAR___1 = function(x) {
    return x
  };
  var _STAR___2 = function(x, y) {
    return x * y
  };
  var _STAR___3 = function() {
    var G__7729__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _STAR_, x * y, more)
    };
    var G__7729 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7729__delegate.call(this, x, y, more)
    };
    G__7729.cljs$lang$maxFixedArity = 2;
    G__7729.cljs$lang$applyTo = function(arglist__7730) {
      var x = cljs.core.first(arglist__7730);
      var y = cljs.core.first(cljs.core.next(arglist__7730));
      var more = cljs.core.rest(cljs.core.next(arglist__7730));
      return G__7729__delegate(x, y, more)
    };
    G__7729.cljs$lang$arity$variadic = G__7729__delegate;
    return G__7729
  }();
  _STAR_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 0:
        return _STAR___0.call(this);
      case 1:
        return _STAR___1.call(this, x);
      case 2:
        return _STAR___2.call(this, x, y);
      default:
        return _STAR___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _STAR_.cljs$lang$maxFixedArity = 2;
  _STAR_.cljs$lang$applyTo = _STAR___3.cljs$lang$applyTo;
  _STAR_.cljs$lang$arity$0 = _STAR___0;
  _STAR_.cljs$lang$arity$1 = _STAR___1;
  _STAR_.cljs$lang$arity$2 = _STAR___2;
  _STAR_.cljs$lang$arity$variadic = _STAR___3.cljs$lang$arity$variadic;
  return _STAR_
}();
cljs.core._SLASH_ = function() {
  var _SLASH_ = null;
  var _SLASH___1 = function(x) {
    return _SLASH_.call(null, 1, x)
  };
  var _SLASH___2 = function(x, y) {
    return x / y
  };
  var _SLASH___3 = function() {
    var G__7731__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, _SLASH_, _SLASH_.call(null, x, y), more)
    };
    var G__7731 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7731__delegate.call(this, x, y, more)
    };
    G__7731.cljs$lang$maxFixedArity = 2;
    G__7731.cljs$lang$applyTo = function(arglist__7732) {
      var x = cljs.core.first(arglist__7732);
      var y = cljs.core.first(cljs.core.next(arglist__7732));
      var more = cljs.core.rest(cljs.core.next(arglist__7732));
      return G__7731__delegate(x, y, more)
    };
    G__7731.cljs$lang$arity$variadic = G__7731__delegate;
    return G__7731
  }();
  _SLASH_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _SLASH___1.call(this, x);
      case 2:
        return _SLASH___2.call(this, x, y);
      default:
        return _SLASH___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _SLASH_.cljs$lang$maxFixedArity = 2;
  _SLASH_.cljs$lang$applyTo = _SLASH___3.cljs$lang$applyTo;
  _SLASH_.cljs$lang$arity$1 = _SLASH___1;
  _SLASH_.cljs$lang$arity$2 = _SLASH___2;
  _SLASH_.cljs$lang$arity$variadic = _SLASH___3.cljs$lang$arity$variadic;
  return _SLASH_
}();
cljs.core._LT_ = function() {
  var _LT_ = null;
  var _LT___1 = function(x) {
    return true
  };
  var _LT___2 = function(x, y) {
    return x < y
  };
  var _LT___3 = function() {
    var G__7733__delegate = function(x, y, more) {
      while(true) {
        if(x < y) {
          if(cljs.core.next.call(null, more)) {
            var G__7734 = y;
            var G__7735 = cljs.core.first.call(null, more);
            var G__7736 = cljs.core.next.call(null, more);
            x = G__7734;
            y = G__7735;
            more = G__7736;
            continue
          }else {
            return y < cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__7733 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7733__delegate.call(this, x, y, more)
    };
    G__7733.cljs$lang$maxFixedArity = 2;
    G__7733.cljs$lang$applyTo = function(arglist__7737) {
      var x = cljs.core.first(arglist__7737);
      var y = cljs.core.first(cljs.core.next(arglist__7737));
      var more = cljs.core.rest(cljs.core.next(arglist__7737));
      return G__7733__delegate(x, y, more)
    };
    G__7733.cljs$lang$arity$variadic = G__7733__delegate;
    return G__7733
  }();
  _LT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT___1.call(this, x);
      case 2:
        return _LT___2.call(this, x, y);
      default:
        return _LT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT_.cljs$lang$maxFixedArity = 2;
  _LT_.cljs$lang$applyTo = _LT___3.cljs$lang$applyTo;
  _LT_.cljs$lang$arity$1 = _LT___1;
  _LT_.cljs$lang$arity$2 = _LT___2;
  _LT_.cljs$lang$arity$variadic = _LT___3.cljs$lang$arity$variadic;
  return _LT_
}();
cljs.core._LT__EQ_ = function() {
  var _LT__EQ_ = null;
  var _LT__EQ___1 = function(x) {
    return true
  };
  var _LT__EQ___2 = function(x, y) {
    return x <= y
  };
  var _LT__EQ___3 = function() {
    var G__7738__delegate = function(x, y, more) {
      while(true) {
        if(x <= y) {
          if(cljs.core.next.call(null, more)) {
            var G__7739 = y;
            var G__7740 = cljs.core.first.call(null, more);
            var G__7741 = cljs.core.next.call(null, more);
            x = G__7739;
            y = G__7740;
            more = G__7741;
            continue
          }else {
            return y <= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__7738 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7738__delegate.call(this, x, y, more)
    };
    G__7738.cljs$lang$maxFixedArity = 2;
    G__7738.cljs$lang$applyTo = function(arglist__7742) {
      var x = cljs.core.first(arglist__7742);
      var y = cljs.core.first(cljs.core.next(arglist__7742));
      var more = cljs.core.rest(cljs.core.next(arglist__7742));
      return G__7738__delegate(x, y, more)
    };
    G__7738.cljs$lang$arity$variadic = G__7738__delegate;
    return G__7738
  }();
  _LT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _LT__EQ___1.call(this, x);
      case 2:
        return _LT__EQ___2.call(this, x, y);
      default:
        return _LT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _LT__EQ_.cljs$lang$maxFixedArity = 2;
  _LT__EQ_.cljs$lang$applyTo = _LT__EQ___3.cljs$lang$applyTo;
  _LT__EQ_.cljs$lang$arity$1 = _LT__EQ___1;
  _LT__EQ_.cljs$lang$arity$2 = _LT__EQ___2;
  _LT__EQ_.cljs$lang$arity$variadic = _LT__EQ___3.cljs$lang$arity$variadic;
  return _LT__EQ_
}();
cljs.core._GT_ = function() {
  var _GT_ = null;
  var _GT___1 = function(x) {
    return true
  };
  var _GT___2 = function(x, y) {
    return x > y
  };
  var _GT___3 = function() {
    var G__7743__delegate = function(x, y, more) {
      while(true) {
        if(x > y) {
          if(cljs.core.next.call(null, more)) {
            var G__7744 = y;
            var G__7745 = cljs.core.first.call(null, more);
            var G__7746 = cljs.core.next.call(null, more);
            x = G__7744;
            y = G__7745;
            more = G__7746;
            continue
          }else {
            return y > cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__7743 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7743__delegate.call(this, x, y, more)
    };
    G__7743.cljs$lang$maxFixedArity = 2;
    G__7743.cljs$lang$applyTo = function(arglist__7747) {
      var x = cljs.core.first(arglist__7747);
      var y = cljs.core.first(cljs.core.next(arglist__7747));
      var more = cljs.core.rest(cljs.core.next(arglist__7747));
      return G__7743__delegate(x, y, more)
    };
    G__7743.cljs$lang$arity$variadic = G__7743__delegate;
    return G__7743
  }();
  _GT_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT___1.call(this, x);
      case 2:
        return _GT___2.call(this, x, y);
      default:
        return _GT___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT_.cljs$lang$maxFixedArity = 2;
  _GT_.cljs$lang$applyTo = _GT___3.cljs$lang$applyTo;
  _GT_.cljs$lang$arity$1 = _GT___1;
  _GT_.cljs$lang$arity$2 = _GT___2;
  _GT_.cljs$lang$arity$variadic = _GT___3.cljs$lang$arity$variadic;
  return _GT_
}();
cljs.core._GT__EQ_ = function() {
  var _GT__EQ_ = null;
  var _GT__EQ___1 = function(x) {
    return true
  };
  var _GT__EQ___2 = function(x, y) {
    return x >= y
  };
  var _GT__EQ___3 = function() {
    var G__7748__delegate = function(x, y, more) {
      while(true) {
        if(x >= y) {
          if(cljs.core.next.call(null, more)) {
            var G__7749 = y;
            var G__7750 = cljs.core.first.call(null, more);
            var G__7751 = cljs.core.next.call(null, more);
            x = G__7749;
            y = G__7750;
            more = G__7751;
            continue
          }else {
            return y >= cljs.core.first.call(null, more)
          }
        }else {
          return false
        }
        break
      }
    };
    var G__7748 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7748__delegate.call(this, x, y, more)
    };
    G__7748.cljs$lang$maxFixedArity = 2;
    G__7748.cljs$lang$applyTo = function(arglist__7752) {
      var x = cljs.core.first(arglist__7752);
      var y = cljs.core.first(cljs.core.next(arglist__7752));
      var more = cljs.core.rest(cljs.core.next(arglist__7752));
      return G__7748__delegate(x, y, more)
    };
    G__7748.cljs$lang$arity$variadic = G__7748__delegate;
    return G__7748
  }();
  _GT__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _GT__EQ___1.call(this, x);
      case 2:
        return _GT__EQ___2.call(this, x, y);
      default:
        return _GT__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _GT__EQ_.cljs$lang$maxFixedArity = 2;
  _GT__EQ_.cljs$lang$applyTo = _GT__EQ___3.cljs$lang$applyTo;
  _GT__EQ_.cljs$lang$arity$1 = _GT__EQ___1;
  _GT__EQ_.cljs$lang$arity$2 = _GT__EQ___2;
  _GT__EQ_.cljs$lang$arity$variadic = _GT__EQ___3.cljs$lang$arity$variadic;
  return _GT__EQ_
}();
cljs.core.dec = function dec(x) {
  return x - 1
};
cljs.core.max = function() {
  var max = null;
  var max__1 = function(x) {
    return x
  };
  var max__2 = function(x, y) {
    return x > y ? x : y
  };
  var max__3 = function() {
    var G__7753__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, max, x > y ? x : y, more)
    };
    var G__7753 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7753__delegate.call(this, x, y, more)
    };
    G__7753.cljs$lang$maxFixedArity = 2;
    G__7753.cljs$lang$applyTo = function(arglist__7754) {
      var x = cljs.core.first(arglist__7754);
      var y = cljs.core.first(cljs.core.next(arglist__7754));
      var more = cljs.core.rest(cljs.core.next(arglist__7754));
      return G__7753__delegate(x, y, more)
    };
    G__7753.cljs$lang$arity$variadic = G__7753__delegate;
    return G__7753
  }();
  max = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return max__1.call(this, x);
      case 2:
        return max__2.call(this, x, y);
      default:
        return max__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max.cljs$lang$maxFixedArity = 2;
  max.cljs$lang$applyTo = max__3.cljs$lang$applyTo;
  max.cljs$lang$arity$1 = max__1;
  max.cljs$lang$arity$2 = max__2;
  max.cljs$lang$arity$variadic = max__3.cljs$lang$arity$variadic;
  return max
}();
cljs.core.min = function() {
  var min = null;
  var min__1 = function(x) {
    return x
  };
  var min__2 = function(x, y) {
    return x < y ? x : y
  };
  var min__3 = function() {
    var G__7755__delegate = function(x, y, more) {
      return cljs.core.reduce.call(null, min, x < y ? x : y, more)
    };
    var G__7755 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7755__delegate.call(this, x, y, more)
    };
    G__7755.cljs$lang$maxFixedArity = 2;
    G__7755.cljs$lang$applyTo = function(arglist__7756) {
      var x = cljs.core.first(arglist__7756);
      var y = cljs.core.first(cljs.core.next(arglist__7756));
      var more = cljs.core.rest(cljs.core.next(arglist__7756));
      return G__7755__delegate(x, y, more)
    };
    G__7755.cljs$lang$arity$variadic = G__7755__delegate;
    return G__7755
  }();
  min = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return min__1.call(this, x);
      case 2:
        return min__2.call(this, x, y);
      default:
        return min__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min.cljs$lang$maxFixedArity = 2;
  min.cljs$lang$applyTo = min__3.cljs$lang$applyTo;
  min.cljs$lang$arity$1 = min__1;
  min.cljs$lang$arity$2 = min__2;
  min.cljs$lang$arity$variadic = min__3.cljs$lang$arity$variadic;
  return min
}();
cljs.core.fix = function fix(q) {
  if(q >= 0) {
    return Math.floor.call(null, q)
  }else {
    return Math.ceil.call(null, q)
  }
};
cljs.core.int$ = function int$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.long$ = function long$(x) {
  return cljs.core.fix.call(null, x)
};
cljs.core.mod = function mod(n, d) {
  return n % d
};
cljs.core.quot = function quot(n, d) {
  var rem__7758 = n % d;
  return cljs.core.fix.call(null, (n - rem__7758) / d)
};
cljs.core.rem = function rem(n, d) {
  var q__7760 = cljs.core.quot.call(null, n, d);
  return n - d * q__7760
};
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return Math.random.call(null)
  };
  var rand__1 = function(n) {
    return n * rand.call(null)
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return cljs.core.fix.call(null, cljs.core.rand.call(null, n))
};
cljs.core.bit_xor = function bit_xor(x, y) {
  return x ^ y
};
cljs.core.bit_and = function bit_and(x, y) {
  return x & y
};
cljs.core.bit_or = function bit_or(x, y) {
  return x | y
};
cljs.core.bit_and_not = function bit_and_not(x, y) {
  return x & ~y
};
cljs.core.bit_clear = function bit_clear(x, n) {
  return x & ~(1 << n)
};
cljs.core.bit_flip = function bit_flip(x, n) {
  return x ^ 1 << n
};
cljs.core.bit_not = function bit_not(x) {
  return~x
};
cljs.core.bit_set = function bit_set(x, n) {
  return x | 1 << n
};
cljs.core.bit_test = function bit_test(x, n) {
  return(x & 1 << n) != 0
};
cljs.core.bit_shift_left = function bit_shift_left(x, n) {
  return x << n
};
cljs.core.bit_shift_right = function bit_shift_right(x, n) {
  return x >> n
};
cljs.core.bit_shift_right_zero_fill = function bit_shift_right_zero_fill(x, n) {
  return x >>> n
};
cljs.core.bit_count = function bit_count(v) {
  var v__7763 = v - (v >> 1 & 1431655765);
  var v__7764 = (v__7763 & 858993459) + (v__7763 >> 2 & 858993459);
  return(v__7764 + (v__7764 >> 4) & 252645135) * 16843009 >> 24
};
cljs.core._EQ__EQ_ = function() {
  var _EQ__EQ_ = null;
  var _EQ__EQ___1 = function(x) {
    return true
  };
  var _EQ__EQ___2 = function(x, y) {
    return cljs.core._equiv.call(null, x, y)
  };
  var _EQ__EQ___3 = function() {
    var G__7765__delegate = function(x, y, more) {
      while(true) {
        if(cljs.core.truth_(_EQ__EQ_.call(null, x, y))) {
          if(cljs.core.next.call(null, more)) {
            var G__7766 = y;
            var G__7767 = cljs.core.first.call(null, more);
            var G__7768 = cljs.core.next.call(null, more);
            x = G__7766;
            y = G__7767;
            more = G__7768;
            continue
          }else {
            return _EQ__EQ_.call(null, y, cljs.core.first.call(null, more))
          }
        }else {
          return false
        }
        break
      }
    };
    var G__7765 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__7765__delegate.call(this, x, y, more)
    };
    G__7765.cljs$lang$maxFixedArity = 2;
    G__7765.cljs$lang$applyTo = function(arglist__7769) {
      var x = cljs.core.first(arglist__7769);
      var y = cljs.core.first(cljs.core.next(arglist__7769));
      var more = cljs.core.rest(cljs.core.next(arglist__7769));
      return G__7765__delegate(x, y, more)
    };
    G__7765.cljs$lang$arity$variadic = G__7765__delegate;
    return G__7765
  }();
  _EQ__EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return _EQ__EQ___1.call(this, x);
      case 2:
        return _EQ__EQ___2.call(this, x, y);
      default:
        return _EQ__EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  _EQ__EQ_.cljs$lang$maxFixedArity = 2;
  _EQ__EQ_.cljs$lang$applyTo = _EQ__EQ___3.cljs$lang$applyTo;
  _EQ__EQ_.cljs$lang$arity$1 = _EQ__EQ___1;
  _EQ__EQ_.cljs$lang$arity$2 = _EQ__EQ___2;
  _EQ__EQ_.cljs$lang$arity$variadic = _EQ__EQ___3.cljs$lang$arity$variadic;
  return _EQ__EQ_
}();
cljs.core.pos_QMARK_ = function pos_QMARK_(n) {
  return n > 0
};
cljs.core.zero_QMARK_ = function zero_QMARK_(n) {
  return n === 0
};
cljs.core.neg_QMARK_ = function neg_QMARK_(x) {
  return x < 0
};
cljs.core.nthnext = function nthnext(coll, n) {
  var n__7773 = n;
  var xs__7774 = cljs.core.seq.call(null, coll);
  while(true) {
    if(cljs.core.truth_(function() {
      var and__3822__auto____7775 = xs__7774;
      if(and__3822__auto____7775) {
        return n__7773 > 0
      }else {
        return and__3822__auto____7775
      }
    }())) {
      var G__7776 = n__7773 - 1;
      var G__7777 = cljs.core.next.call(null, xs__7774);
      n__7773 = G__7776;
      xs__7774 = G__7777;
      continue
    }else {
      return xs__7774
    }
    break
  }
};
cljs.core.str_STAR_ = function() {
  var str_STAR_ = null;
  var str_STAR___0 = function() {
    return""
  };
  var str_STAR___1 = function(x) {
    if(x == null) {
      return""
    }else {
      if("\ufdd0'else") {
        return x.toString()
      }else {
        return null
      }
    }
  };
  var str_STAR___2 = function() {
    var G__7778__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__7779 = sb.append(str_STAR_.call(null, cljs.core.first.call(null, more)));
            var G__7780 = cljs.core.next.call(null, more);
            sb = G__7779;
            more = G__7780;
            continue
          }else {
            return str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str_STAR_.call(null, x)), ys)
    };
    var G__7778 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__7778__delegate.call(this, x, ys)
    };
    G__7778.cljs$lang$maxFixedArity = 1;
    G__7778.cljs$lang$applyTo = function(arglist__7781) {
      var x = cljs.core.first(arglist__7781);
      var ys = cljs.core.rest(arglist__7781);
      return G__7778__delegate(x, ys)
    };
    G__7778.cljs$lang$arity$variadic = G__7778__delegate;
    return G__7778
  }();
  str_STAR_ = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str_STAR___0.call(this);
      case 1:
        return str_STAR___1.call(this, x);
      default:
        return str_STAR___2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str_STAR_.cljs$lang$maxFixedArity = 1;
  str_STAR_.cljs$lang$applyTo = str_STAR___2.cljs$lang$applyTo;
  str_STAR_.cljs$lang$arity$0 = str_STAR___0;
  str_STAR_.cljs$lang$arity$1 = str_STAR___1;
  str_STAR_.cljs$lang$arity$variadic = str_STAR___2.cljs$lang$arity$variadic;
  return str_STAR_
}();
cljs.core.str = function() {
  var str = null;
  var str__0 = function() {
    return""
  };
  var str__1 = function(x) {
    if(cljs.core.symbol_QMARK_.call(null, x)) {
      return x.substring(2, x.length)
    }else {
      if(cljs.core.keyword_QMARK_.call(null, x)) {
        return cljs.core.str_STAR_.call(null, ":", x.substring(2, x.length))
      }else {
        if(x == null) {
          return""
        }else {
          if("\ufdd0'else") {
            return x.toString()
          }else {
            return null
          }
        }
      }
    }
  };
  var str__2 = function() {
    var G__7782__delegate = function(x, ys) {
      return function(sb, more) {
        while(true) {
          if(cljs.core.truth_(more)) {
            var G__7783 = sb.append(str.call(null, cljs.core.first.call(null, more)));
            var G__7784 = cljs.core.next.call(null, more);
            sb = G__7783;
            more = G__7784;
            continue
          }else {
            return cljs.core.str_STAR_.call(null, sb)
          }
          break
        }
      }.call(null, new goog.string.StringBuffer(str.call(null, x)), ys)
    };
    var G__7782 = function(x, var_args) {
      var ys = null;
      if(goog.isDef(var_args)) {
        ys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__7782__delegate.call(this, x, ys)
    };
    G__7782.cljs$lang$maxFixedArity = 1;
    G__7782.cljs$lang$applyTo = function(arglist__7785) {
      var x = cljs.core.first(arglist__7785);
      var ys = cljs.core.rest(arglist__7785);
      return G__7782__delegate(x, ys)
    };
    G__7782.cljs$lang$arity$variadic = G__7782__delegate;
    return G__7782
  }();
  str = function(x, var_args) {
    var ys = var_args;
    switch(arguments.length) {
      case 0:
        return str__0.call(this);
      case 1:
        return str__1.call(this, x);
      default:
        return str__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  str.cljs$lang$maxFixedArity = 1;
  str.cljs$lang$applyTo = str__2.cljs$lang$applyTo;
  str.cljs$lang$arity$0 = str__0;
  str.cljs$lang$arity$1 = str__1;
  str.cljs$lang$arity$variadic = str__2.cljs$lang$arity$variadic;
  return str
}();
cljs.core.subs = function() {
  var subs = null;
  var subs__2 = function(s, start) {
    return s.substring(start)
  };
  var subs__3 = function(s, start, end) {
    return s.substring(start, end)
  };
  subs = function(s, start, end) {
    switch(arguments.length) {
      case 2:
        return subs__2.call(this, s, start);
      case 3:
        return subs__3.call(this, s, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subs.cljs$lang$arity$2 = subs__2;
  subs.cljs$lang$arity$3 = subs__3;
  return subs
}();
cljs.core.format = function() {
  var format__delegate = function(fmt, args) {
    return cljs.core.apply.call(null, goog.string.format, fmt, args)
  };
  var format = function(fmt, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return format__delegate.call(this, fmt, args)
  };
  format.cljs$lang$maxFixedArity = 1;
  format.cljs$lang$applyTo = function(arglist__7786) {
    var fmt = cljs.core.first(arglist__7786);
    var args = cljs.core.rest(arglist__7786);
    return format__delegate(fmt, args)
  };
  format.cljs$lang$arity$variadic = format__delegate;
  return format
}();
cljs.core.symbol = function() {
  var symbol = null;
  var symbol__1 = function(name) {
    if(cljs.core.symbol_QMARK_.call(null, name)) {
      name
    }else {
      if(cljs.core.keyword_QMARK_.call(null, name)) {
        cljs.core.str_STAR_.call(null, "\ufdd1", "'", cljs.core.subs.call(null, name, 2))
      }else {
      }
    }
    return cljs.core.str_STAR_.call(null, "\ufdd1", "'", name)
  };
  var symbol__2 = function(ns, name) {
    return symbol.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  symbol = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return symbol__1.call(this, ns);
      case 2:
        return symbol__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  symbol.cljs$lang$arity$1 = symbol__1;
  symbol.cljs$lang$arity$2 = symbol__2;
  return symbol
}();
cljs.core.keyword = function() {
  var keyword = null;
  var keyword__1 = function(name) {
    if(cljs.core.keyword_QMARK_.call(null, name)) {
      return name
    }else {
      if(cljs.core.symbol_QMARK_.call(null, name)) {
        return cljs.core.str_STAR_.call(null, "\ufdd0", "'", cljs.core.subs.call(null, name, 2))
      }else {
        if("\ufdd0'else") {
          return cljs.core.str_STAR_.call(null, "\ufdd0", "'", name)
        }else {
          return null
        }
      }
    }
  };
  var keyword__2 = function(ns, name) {
    return keyword.call(null, cljs.core.str_STAR_.call(null, ns, "/", name))
  };
  keyword = function(ns, name) {
    switch(arguments.length) {
      case 1:
        return keyword__1.call(this, ns);
      case 2:
        return keyword__2.call(this, ns, name)
    }
    throw"Invalid arity: " + arguments.length;
  };
  keyword.cljs$lang$arity$1 = keyword__1;
  keyword.cljs$lang$arity$2 = keyword__2;
  return keyword
}();
cljs.core.equiv_sequential = function equiv_sequential(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.sequential_QMARK_.call(null, y) ? function() {
    var xs__7789 = cljs.core.seq.call(null, x);
    var ys__7790 = cljs.core.seq.call(null, y);
    while(true) {
      if(xs__7789 == null) {
        return ys__7790 == null
      }else {
        if(ys__7790 == null) {
          return false
        }else {
          if(cljs.core._EQ_.call(null, cljs.core.first.call(null, xs__7789), cljs.core.first.call(null, ys__7790))) {
            var G__7791 = cljs.core.next.call(null, xs__7789);
            var G__7792 = cljs.core.next.call(null, ys__7790);
            xs__7789 = G__7791;
            ys__7790 = G__7792;
            continue
          }else {
            if("\ufdd0'else") {
              return false
            }else {
              return null
            }
          }
        }
      }
      break
    }
  }() : null)
};
cljs.core.hash_combine = function hash_combine(seed, hash) {
  return seed ^ hash + 2654435769 + (seed << 6) + (seed >> 2)
};
cljs.core.hash_coll = function hash_coll(coll) {
  return cljs.core.reduce.call(null, function(p1__7793_SHARP_, p2__7794_SHARP_) {
    return cljs.core.hash_combine.call(null, p1__7793_SHARP_, cljs.core.hash.call(null, p2__7794_SHARP_, false))
  }, cljs.core.hash.call(null, cljs.core.first.call(null, coll), false), cljs.core.next.call(null, coll))
};
cljs.core.hash_imap = function hash_imap(m) {
  var h__7798 = 0;
  var s__7799 = cljs.core.seq.call(null, m);
  while(true) {
    if(s__7799) {
      var e__7800 = cljs.core.first.call(null, s__7799);
      var G__7801 = (h__7798 + (cljs.core.hash.call(null, cljs.core.key.call(null, e__7800)) ^ cljs.core.hash.call(null, cljs.core.val.call(null, e__7800)))) % 4503599627370496;
      var G__7802 = cljs.core.next.call(null, s__7799);
      h__7798 = G__7801;
      s__7799 = G__7802;
      continue
    }else {
      return h__7798
    }
    break
  }
};
cljs.core.hash_iset = function hash_iset(s) {
  var h__7806 = 0;
  var s__7807 = cljs.core.seq.call(null, s);
  while(true) {
    if(s__7807) {
      var e__7808 = cljs.core.first.call(null, s__7807);
      var G__7809 = (h__7806 + cljs.core.hash.call(null, e__7808)) % 4503599627370496;
      var G__7810 = cljs.core.next.call(null, s__7807);
      h__7806 = G__7809;
      s__7807 = G__7810;
      continue
    }else {
      return h__7806
    }
    break
  }
};
cljs.core.extend_object_BANG_ = function extend_object_BANG_(obj, fn_map) {
  var G__7831__7832 = cljs.core.seq.call(null, fn_map);
  if(G__7831__7832) {
    var G__7834__7836 = cljs.core.first.call(null, G__7831__7832);
    var vec__7835__7837 = G__7834__7836;
    var key_name__7838 = cljs.core.nth.call(null, vec__7835__7837, 0, null);
    var f__7839 = cljs.core.nth.call(null, vec__7835__7837, 1, null);
    var G__7831__7840 = G__7831__7832;
    var G__7834__7841 = G__7834__7836;
    var G__7831__7842 = G__7831__7840;
    while(true) {
      var vec__7843__7844 = G__7834__7841;
      var key_name__7845 = cljs.core.nth.call(null, vec__7843__7844, 0, null);
      var f__7846 = cljs.core.nth.call(null, vec__7843__7844, 1, null);
      var G__7831__7847 = G__7831__7842;
      var str_name__7848 = cljs.core.name.call(null, key_name__7845);
      obj[str_name__7848] = f__7846;
      var temp__3974__auto____7849 = cljs.core.next.call(null, G__7831__7847);
      if(temp__3974__auto____7849) {
        var G__7831__7850 = temp__3974__auto____7849;
        var G__7851 = cljs.core.first.call(null, G__7831__7850);
        var G__7852 = G__7831__7850;
        G__7834__7841 = G__7851;
        G__7831__7842 = G__7852;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return obj
};
cljs.core.List = function(meta, first, rest, count, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.count = count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 65413358
};
cljs.core.List.cljs$lang$type = true;
cljs.core.List.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/List")
};
cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__7853 = this;
  var h__2287__auto____7854 = this__7853.__hash;
  if(!(h__2287__auto____7854 == null)) {
    return h__2287__auto____7854
  }else {
    var h__2287__auto____7855 = cljs.core.hash_coll.call(null, coll);
    this__7853.__hash = h__2287__auto____7855;
    return h__2287__auto____7855
  }
};
cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var this__7856 = this;
  if(this__7856.count === 1) {
    return null
  }else {
    return this__7856.rest
  }
};
cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__7857 = this;
  return new cljs.core.List(this__7857.meta, o, coll, this__7857.count + 1, null)
};
cljs.core.List.prototype.toString = function() {
  var this__7858 = this;
  var this__7859 = this;
  return cljs.core.pr_str.call(null, this__7859)
};
cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__7860 = this;
  return coll
};
cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__7861 = this;
  return this__7861.count
};
cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__7862 = this;
  return this__7862.first
};
cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__7863 = this;
  return coll.cljs$core$ISeq$_rest$arity$1(coll)
};
cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__7864 = this;
  return this__7864.first
};
cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__7865 = this;
  if(this__7865.count === 1) {
    return cljs.core.List.EMPTY
  }else {
    return this__7865.rest
  }
};
cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__7866 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__7867 = this;
  return new cljs.core.List(meta, this__7867.first, this__7867.rest, this__7867.count, this__7867.__hash)
};
cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__7868 = this;
  return this__7868.meta
};
cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__7869 = this;
  return cljs.core.List.EMPTY
};
cljs.core.List;
cljs.core.EmptyList = function(meta) {
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 65413326
};
cljs.core.EmptyList.cljs$lang$type = true;
cljs.core.EmptyList.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/EmptyList")
};
cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__7870 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var this__7871 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__7872 = this;
  return new cljs.core.List(this__7872.meta, o, null, 1, null)
};
cljs.core.EmptyList.prototype.toString = function() {
  var this__7873 = this;
  var this__7874 = this;
  return cljs.core.pr_str.call(null, this__7874)
};
cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__7875 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__7876 = this;
  return 0
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__7877 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__7878 = this;
  throw new Error("Can't pop empty list");
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__7879 = this;
  return null
};
cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__7880 = this;
  return cljs.core.List.EMPTY
};
cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__7881 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__7882 = this;
  return new cljs.core.EmptyList(meta)
};
cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__7883 = this;
  return this__7883.meta
};
cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__7884 = this;
  return coll
};
cljs.core.EmptyList;
cljs.core.List.EMPTY = new cljs.core.EmptyList(null);
cljs.core.reversible_QMARK_ = function reversible_QMARK_(coll) {
  var G__7888__7889 = coll;
  if(G__7888__7889) {
    if(function() {
      var or__3824__auto____7890 = G__7888__7889.cljs$lang$protocol_mask$partition0$ & 134217728;
      if(or__3824__auto____7890) {
        return or__3824__auto____7890
      }else {
        return G__7888__7889.cljs$core$IReversible$
      }
    }()) {
      return true
    }else {
      if(!G__7888__7889.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__7888__7889)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IReversible, G__7888__7889)
  }
};
cljs.core.rseq = function rseq(coll) {
  return cljs.core._rseq.call(null, coll)
};
cljs.core.reverse = function reverse(coll) {
  if(cljs.core.reversible_QMARK_.call(null, coll)) {
    return cljs.core.rseq.call(null, coll)
  }else {
    return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
  }
};
cljs.core.list = function() {
  var list = null;
  var list__0 = function() {
    return cljs.core.List.EMPTY
  };
  var list__1 = function(x) {
    return cljs.core.conj.call(null, cljs.core.List.EMPTY, x)
  };
  var list__2 = function(x, y) {
    return cljs.core.conj.call(null, list.call(null, y), x)
  };
  var list__3 = function(x, y, z) {
    return cljs.core.conj.call(null, list.call(null, y, z), x)
  };
  var list__4 = function() {
    var G__7891__delegate = function(x, y, z, items) {
      return cljs.core.conj.call(null, cljs.core.conj.call(null, cljs.core.conj.call(null, cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, cljs.core.reverse.call(null, items)), z), y), x)
    };
    var G__7891 = function(x, y, z, var_args) {
      var items = null;
      if(goog.isDef(var_args)) {
        items = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__7891__delegate.call(this, x, y, z, items)
    };
    G__7891.cljs$lang$maxFixedArity = 3;
    G__7891.cljs$lang$applyTo = function(arglist__7892) {
      var x = cljs.core.first(arglist__7892);
      var y = cljs.core.first(cljs.core.next(arglist__7892));
      var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__7892)));
      var items = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__7892)));
      return G__7891__delegate(x, y, z, items)
    };
    G__7891.cljs$lang$arity$variadic = G__7891__delegate;
    return G__7891
  }();
  list = function(x, y, z, var_args) {
    var items = var_args;
    switch(arguments.length) {
      case 0:
        return list__0.call(this);
      case 1:
        return list__1.call(this, x);
      case 2:
        return list__2.call(this, x, y);
      case 3:
        return list__3.call(this, x, y, z);
      default:
        return list__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  list.cljs$lang$maxFixedArity = 3;
  list.cljs$lang$applyTo = list__4.cljs$lang$applyTo;
  list.cljs$lang$arity$0 = list__0;
  list.cljs$lang$arity$1 = list__1;
  list.cljs$lang$arity$2 = list__2;
  list.cljs$lang$arity$3 = list__3;
  list.cljs$lang$arity$variadic = list__4.cljs$lang$arity$variadic;
  return list
}();
cljs.core.Cons = function(meta, first, rest, __hash) {
  this.meta = meta;
  this.first = first;
  this.rest = rest;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 65405164
};
cljs.core.Cons.cljs$lang$type = true;
cljs.core.Cons.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/Cons")
};
cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__7893 = this;
  var h__2287__auto____7894 = this__7893.__hash;
  if(!(h__2287__auto____7894 == null)) {
    return h__2287__auto____7894
  }else {
    var h__2287__auto____7895 = cljs.core.hash_coll.call(null, coll);
    this__7893.__hash = h__2287__auto____7895;
    return h__2287__auto____7895
  }
};
cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var this__7896 = this;
  if(this__7896.rest == null) {
    return null
  }else {
    return cljs.core._seq.call(null, this__7896.rest)
  }
};
cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__7897 = this;
  return new cljs.core.Cons(null, o, coll, this__7897.__hash)
};
cljs.core.Cons.prototype.toString = function() {
  var this__7898 = this;
  var this__7899 = this;
  return cljs.core.pr_str.call(null, this__7899)
};
cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__7900 = this;
  return coll
};
cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__7901 = this;
  return this__7901.first
};
cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__7902 = this;
  if(this__7902.rest == null) {
    return cljs.core.List.EMPTY
  }else {
    return this__7902.rest
  }
};
cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__7903 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__7904 = this;
  return new cljs.core.Cons(meta, this__7904.first, this__7904.rest, this__7904.__hash)
};
cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__7905 = this;
  return this__7905.meta
};
cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__7906 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__7906.meta)
};
cljs.core.Cons;
cljs.core.cons = function cons(x, coll) {
  if(function() {
    var or__3824__auto____7911 = coll == null;
    if(or__3824__auto____7911) {
      return or__3824__auto____7911
    }else {
      var G__7912__7913 = coll;
      if(G__7912__7913) {
        if(function() {
          var or__3824__auto____7914 = G__7912__7913.cljs$lang$protocol_mask$partition0$ & 64;
          if(or__3824__auto____7914) {
            return or__3824__auto____7914
          }else {
            return G__7912__7913.cljs$core$ISeq$
          }
        }()) {
          return true
        }else {
          if(!G__7912__7913.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__7912__7913)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.ISeq, G__7912__7913)
      }
    }
  }()) {
    return new cljs.core.Cons(null, x, coll, null)
  }else {
    return new cljs.core.Cons(null, x, cljs.core.seq.call(null, coll), null)
  }
};
cljs.core.list_QMARK_ = function list_QMARK_(x) {
  var G__7918__7919 = x;
  if(G__7918__7919) {
    if(function() {
      var or__3824__auto____7920 = G__7918__7919.cljs$lang$protocol_mask$partition0$ & 33554432;
      if(or__3824__auto____7920) {
        return or__3824__auto____7920
      }else {
        return G__7918__7919.cljs$core$IList$
      }
    }()) {
      return true
    }else {
      if(!G__7918__7919.cljs$lang$protocol_mask$partition0$) {
        return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__7918__7919)
      }else {
        return false
      }
    }
  }else {
    return cljs.core.type_satisfies_.call(null, cljs.core.IList, G__7918__7919)
  }
};
cljs.core.IReduce["string"] = true;
cljs.core._reduce["string"] = function() {
  var G__7921 = null;
  var G__7921__2 = function(string, f) {
    return cljs.core.ci_reduce.call(null, string, f)
  };
  var G__7921__3 = function(string, f, start) {
    return cljs.core.ci_reduce.call(null, string, f, start)
  };
  G__7921 = function(string, f, start) {
    switch(arguments.length) {
      case 2:
        return G__7921__2.call(this, string, f);
      case 3:
        return G__7921__3.call(this, string, f, start)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7921
}();
cljs.core.ILookup["string"] = true;
cljs.core._lookup["string"] = function() {
  var G__7922 = null;
  var G__7922__2 = function(string, k) {
    return cljs.core._nth.call(null, string, k)
  };
  var G__7922__3 = function(string, k, not_found) {
    return cljs.core._nth.call(null, string, k, not_found)
  };
  G__7922 = function(string, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7922__2.call(this, string, k);
      case 3:
        return G__7922__3.call(this, string, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7922
}();
cljs.core.IIndexed["string"] = true;
cljs.core._nth["string"] = function() {
  var G__7923 = null;
  var G__7923__2 = function(string, n) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return null
    }
  };
  var G__7923__3 = function(string, n, not_found) {
    if(n < cljs.core._count.call(null, string)) {
      return string.charAt(n)
    }else {
      return not_found
    }
  };
  G__7923 = function(string, n, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7923__2.call(this, string, n);
      case 3:
        return G__7923__3.call(this, string, n, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7923
}();
cljs.core.ICounted["string"] = true;
cljs.core._count["string"] = function(s) {
  return s.length
};
cljs.core.ISeqable["string"] = true;
cljs.core._seq["string"] = function(string) {
  return cljs.core.prim_seq.call(null, string, 0)
};
cljs.core.IHash["string"] = true;
cljs.core._hash["string"] = function(o) {
  return goog.string.hashCode(o)
};
cljs.core.Keyword = function(k) {
  this.k = k;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1
};
cljs.core.Keyword.cljs$lang$type = true;
cljs.core.Keyword.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/Keyword")
};
cljs.core.Keyword.prototype.call = function() {
  var G__7935 = null;
  var G__7935__2 = function(this_sym7926, coll) {
    var this__7928 = this;
    var this_sym7926__7929 = this;
    var ___7930 = this_sym7926__7929;
    if(coll == null) {
      return null
    }else {
      var strobj__7931 = coll.strobj;
      if(strobj__7931 == null) {
        return cljs.core._lookup.call(null, coll, this__7928.k, null)
      }else {
        return strobj__7931[this__7928.k]
      }
    }
  };
  var G__7935__3 = function(this_sym7927, coll, not_found) {
    var this__7928 = this;
    var this_sym7927__7932 = this;
    var ___7933 = this_sym7927__7932;
    if(coll == null) {
      return not_found
    }else {
      return cljs.core._lookup.call(null, coll, this__7928.k, not_found)
    }
  };
  G__7935 = function(this_sym7927, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7935__2.call(this, this_sym7927, coll);
      case 3:
        return G__7935__3.call(this, this_sym7927, coll, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7935
}();
cljs.core.Keyword.prototype.apply = function(this_sym7924, args7925) {
  var this__7934 = this;
  return this_sym7924.call.apply(this_sym7924, [this_sym7924].concat(args7925.slice()))
};
cljs.core.Keyword;
String.prototype.cljs$core$IFn$ = true;
String.prototype.call = function() {
  var G__7944 = null;
  var G__7944__2 = function(this_sym7938, coll) {
    var this_sym7938__7940 = this;
    var this__7941 = this_sym7938__7940;
    return cljs.core._lookup.call(null, coll, this__7941.toString(), null)
  };
  var G__7944__3 = function(this_sym7939, coll, not_found) {
    var this_sym7939__7942 = this;
    var this__7943 = this_sym7939__7942;
    return cljs.core._lookup.call(null, coll, this__7943.toString(), not_found)
  };
  G__7944 = function(this_sym7939, coll, not_found) {
    switch(arguments.length) {
      case 2:
        return G__7944__2.call(this, this_sym7939, coll);
      case 3:
        return G__7944__3.call(this, this_sym7939, coll, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__7944
}();
String.prototype.apply = function(this_sym7936, args7937) {
  return this_sym7936.call.apply(this_sym7936, [this_sym7936].concat(args7937.slice()))
};
String.prototype.apply = function(s, args) {
  if(cljs.core.count.call(null, args) < 2) {
    return cljs.core._lookup.call(null, args[0], s, null)
  }else {
    return cljs.core._lookup.call(null, args[0], s, args[1])
  }
};
cljs.core.lazy_seq_value = function lazy_seq_value(lazy_seq) {
  var x__7946 = lazy_seq.x;
  if(lazy_seq.realized) {
    return x__7946
  }else {
    lazy_seq.x = x__7946.call(null);
    lazy_seq.realized = true;
    return lazy_seq.x
  }
};
cljs.core.LazySeq = function(meta, realized, x, __hash) {
  this.meta = meta;
  this.realized = realized;
  this.x = x;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31850700
};
cljs.core.LazySeq.cljs$lang$type = true;
cljs.core.LazySeq.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/LazySeq")
};
cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__7947 = this;
  var h__2287__auto____7948 = this__7947.__hash;
  if(!(h__2287__auto____7948 == null)) {
    return h__2287__auto____7948
  }else {
    var h__2287__auto____7949 = cljs.core.hash_coll.call(null, coll);
    this__7947.__hash = h__2287__auto____7949;
    return h__2287__auto____7949
  }
};
cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var this__7950 = this;
  return cljs.core._seq.call(null, coll.cljs$core$ISeq$_rest$arity$1(coll))
};
cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__7951 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.LazySeq.prototype.toString = function() {
  var this__7952 = this;
  var this__7953 = this;
  return cljs.core.pr_str.call(null, this__7953)
};
cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__7954 = this;
  return cljs.core.seq.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__7955 = this;
  return cljs.core.first.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__7956 = this;
  return cljs.core.rest.call(null, cljs.core.lazy_seq_value.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__7957 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__7958 = this;
  return new cljs.core.LazySeq(meta, this__7958.realized, this__7958.x, this__7958.__hash)
};
cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__7959 = this;
  return this__7959.meta
};
cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__7960 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__7960.meta)
};
cljs.core.LazySeq;
cljs.core.ChunkBuffer = function(buf, end) {
  this.buf = buf;
  this.end = end;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2
};
cljs.core.ChunkBuffer.cljs$lang$type = true;
cljs.core.ChunkBuffer.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/ChunkBuffer")
};
cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var this__7961 = this;
  return this__7961.end
};
cljs.core.ChunkBuffer.prototype.add = function(o) {
  var this__7962 = this;
  var ___7963 = this;
  this__7962.buf[this__7962.end] = o;
  return this__7962.end = this__7962.end + 1
};
cljs.core.ChunkBuffer.prototype.chunk = function(o) {
  var this__7964 = this;
  var ___7965 = this;
  var ret__7966 = new cljs.core.ArrayChunk(this__7964.buf, 0, this__7964.end);
  this__7964.buf = null;
  return ret__7966
};
cljs.core.ChunkBuffer;
cljs.core.chunk_buffer = function chunk_buffer(capacity) {
  return new cljs.core.ChunkBuffer(cljs.core.make_array.call(null, capacity), 0)
};
cljs.core.ArrayChunk = function(arr, off, end) {
  this.arr = arr;
  this.off = off;
  this.end = end;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 524306
};
cljs.core.ArrayChunk.cljs$lang$type = true;
cljs.core.ArrayChunk.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/ArrayChunk")
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__7967 = this;
  return cljs.core.ci_reduce.call(null, coll, f, this__7967.arr[this__7967.off], this__7967.off + 1)
};
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__7968 = this;
  return cljs.core.ci_reduce.call(null, coll, f, start, this__7968.off)
};
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;
cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = function(coll) {
  var this__7969 = this;
  if(this__7969.off === this__7969.end) {
    throw new Error("-drop-first of empty chunk");
  }else {
    return new cljs.core.ArrayChunk(this__7969.arr, this__7969.off + 1, this__7969.end)
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, i) {
  var this__7970 = this;
  return this__7970.arr[this__7970.off + i]
};
cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, i, not_found) {
  var this__7971 = this;
  if(function() {
    var and__3822__auto____7972 = i >= 0;
    if(and__3822__auto____7972) {
      return i < this__7971.end - this__7971.off
    }else {
      return and__3822__auto____7972
    }
  }()) {
    return this__7971.arr[this__7971.off + i]
  }else {
    return not_found
  }
};
cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = function(_) {
  var this__7973 = this;
  return this__7973.end - this__7973.off
};
cljs.core.ArrayChunk;
cljs.core.array_chunk = function() {
  var array_chunk = null;
  var array_chunk__1 = function(arr) {
    return array_chunk.call(null, arr, 0, arr.length)
  };
  var array_chunk__2 = function(arr, off) {
    return array_chunk.call(null, arr, off, arr.length)
  };
  var array_chunk__3 = function(arr, off, end) {
    return new cljs.core.ArrayChunk(arr, off, end)
  };
  array_chunk = function(arr, off, end) {
    switch(arguments.length) {
      case 1:
        return array_chunk__1.call(this, arr);
      case 2:
        return array_chunk__2.call(this, arr, off);
      case 3:
        return array_chunk__3.call(this, arr, off, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  array_chunk.cljs$lang$arity$1 = array_chunk__1;
  array_chunk.cljs$lang$arity$2 = array_chunk__2;
  array_chunk.cljs$lang$arity$3 = array_chunk__3;
  return array_chunk
}();
cljs.core.ChunkedCons = function(chunk, more, meta) {
  this.chunk = chunk;
  this.more = more;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 27656296
};
cljs.core.ChunkedCons.cljs$lang$type = true;
cljs.core.ChunkedCons.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/ChunkedCons")
};
cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = function(this$, o) {
  var this__7974 = this;
  return cljs.core.cons.call(null, o, this$)
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__7975 = this;
  return coll
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__7976 = this;
  return cljs.core._nth.call(null, this__7976.chunk, 0)
};
cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__7977 = this;
  if(cljs.core._count.call(null, this__7977.chunk) > 1) {
    return new cljs.core.ChunkedCons(cljs.core._drop_first.call(null, this__7977.chunk), this__7977.more, this__7977.meta)
  }else {
    if(this__7977.more == null) {
      return cljs.core.List.EMPTY
    }else {
      return this__7977.more
    }
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$ = true;
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var this__7978 = this;
  if(this__7978.more == null) {
    return null
  }else {
    return this__7978.more
  }
};
cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__7979 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var this__7980 = this;
  return new cljs.core.ChunkedCons(this__7980.chunk, this__7980.more, m)
};
cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__7981 = this;
  return this__7981.meta
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$ = true;
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var this__7982 = this;
  return this__7982.chunk
};
cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var this__7983 = this;
  if(this__7983.more == null) {
    return cljs.core.List.EMPTY
  }else {
    return this__7983.more
  }
};
cljs.core.ChunkedCons;
cljs.core.chunk_cons = function chunk_cons(chunk, rest) {
  if(cljs.core._count.call(null, chunk) === 0) {
    return rest
  }else {
    return new cljs.core.ChunkedCons(chunk, rest, null)
  }
};
cljs.core.chunk_append = function chunk_append(b, x) {
  return b.add(x)
};
cljs.core.chunk = function chunk(b) {
  return b.chunk()
};
cljs.core.chunk_first = function chunk_first(s) {
  return cljs.core._chunked_first.call(null, s)
};
cljs.core.chunk_rest = function chunk_rest(s) {
  return cljs.core._chunked_rest.call(null, s)
};
cljs.core.chunk_next = function chunk_next(s) {
  if(function() {
    var G__7987__7988 = s;
    if(G__7987__7988) {
      if(cljs.core.truth_(function() {
        var or__3824__auto____7989 = null;
        if(cljs.core.truth_(or__3824__auto____7989)) {
          return or__3824__auto____7989
        }else {
          return G__7987__7988.cljs$core$IChunkedNext$
        }
      }())) {
        return true
      }else {
        if(!G__7987__7988.cljs$lang$protocol_mask$partition$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IChunkedNext, G__7987__7988)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IChunkedNext, G__7987__7988)
    }
  }()) {
    return cljs.core._chunked_next.call(null, s)
  }else {
    return cljs.core.seq.call(null, cljs.core._chunked_rest.call(null, s))
  }
};
cljs.core.to_array = function to_array(s) {
  var ary__7992 = [];
  var s__7993 = s;
  while(true) {
    if(cljs.core.seq.call(null, s__7993)) {
      ary__7992.push(cljs.core.first.call(null, s__7993));
      var G__7994 = cljs.core.next.call(null, s__7993);
      s__7993 = G__7994;
      continue
    }else {
      return ary__7992
    }
    break
  }
};
cljs.core.to_array_2d = function to_array_2d(coll) {
  var ret__7998 = cljs.core.make_array.call(null, cljs.core.count.call(null, coll));
  var i__7999 = 0;
  var xs__8000 = cljs.core.seq.call(null, coll);
  while(true) {
    if(xs__8000) {
      ret__7998[i__7999] = cljs.core.to_array.call(null, cljs.core.first.call(null, xs__8000));
      var G__8001 = i__7999 + 1;
      var G__8002 = cljs.core.next.call(null, xs__8000);
      i__7999 = G__8001;
      xs__8000 = G__8002;
      continue
    }else {
    }
    break
  }
  return ret__7998
};
cljs.core.long_array = function() {
  var long_array = null;
  var long_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return long_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("long-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var long_array__2 = function(size, init_val_or_seq) {
    var a__8010 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__8011 = cljs.core.seq.call(null, init_val_or_seq);
      var i__8012 = 0;
      var s__8013 = s__8011;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3822__auto____8014 = s__8013;
          if(and__3822__auto____8014) {
            return i__8012 < size
          }else {
            return and__3822__auto____8014
          }
        }())) {
          a__8010[i__8012] = cljs.core.first.call(null, s__8013);
          var G__8017 = i__8012 + 1;
          var G__8018 = cljs.core.next.call(null, s__8013);
          i__8012 = G__8017;
          s__8013 = G__8018;
          continue
        }else {
          return a__8010
        }
        break
      }
    }else {
      var n__2622__auto____8015 = size;
      var i__8016 = 0;
      while(true) {
        if(i__8016 < n__2622__auto____8015) {
          a__8010[i__8016] = init_val_or_seq;
          var G__8019 = i__8016 + 1;
          i__8016 = G__8019;
          continue
        }else {
        }
        break
      }
      return a__8010
    }
  };
  long_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return long_array__1.call(this, size);
      case 2:
        return long_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  long_array.cljs$lang$arity$1 = long_array__1;
  long_array.cljs$lang$arity$2 = long_array__2;
  return long_array
}();
cljs.core.double_array = function() {
  var double_array = null;
  var double_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return double_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("double-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var double_array__2 = function(size, init_val_or_seq) {
    var a__8027 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__8028 = cljs.core.seq.call(null, init_val_or_seq);
      var i__8029 = 0;
      var s__8030 = s__8028;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3822__auto____8031 = s__8030;
          if(and__3822__auto____8031) {
            return i__8029 < size
          }else {
            return and__3822__auto____8031
          }
        }())) {
          a__8027[i__8029] = cljs.core.first.call(null, s__8030);
          var G__8034 = i__8029 + 1;
          var G__8035 = cljs.core.next.call(null, s__8030);
          i__8029 = G__8034;
          s__8030 = G__8035;
          continue
        }else {
          return a__8027
        }
        break
      }
    }else {
      var n__2622__auto____8032 = size;
      var i__8033 = 0;
      while(true) {
        if(i__8033 < n__2622__auto____8032) {
          a__8027[i__8033] = init_val_or_seq;
          var G__8036 = i__8033 + 1;
          i__8033 = G__8036;
          continue
        }else {
        }
        break
      }
      return a__8027
    }
  };
  double_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return double_array__1.call(this, size);
      case 2:
        return double_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  double_array.cljs$lang$arity$1 = double_array__1;
  double_array.cljs$lang$arity$2 = double_array__2;
  return double_array
}();
cljs.core.object_array = function() {
  var object_array = null;
  var object_array__1 = function(size_or_seq) {
    if(cljs.core.number_QMARK_.call(null, size_or_seq)) {
      return object_array.call(null, size_or_seq, null)
    }else {
      if(cljs.core.seq_QMARK_.call(null, size_or_seq)) {
        return cljs.core.into_array.call(null, size_or_seq)
      }else {
        if("\ufdd0'else") {
          throw new Error("object-array called with something other than size or ISeq");
        }else {
          return null
        }
      }
    }
  };
  var object_array__2 = function(size, init_val_or_seq) {
    var a__8044 = cljs.core.make_array.call(null, size);
    if(cljs.core.seq_QMARK_.call(null, init_val_or_seq)) {
      var s__8045 = cljs.core.seq.call(null, init_val_or_seq);
      var i__8046 = 0;
      var s__8047 = s__8045;
      while(true) {
        if(cljs.core.truth_(function() {
          var and__3822__auto____8048 = s__8047;
          if(and__3822__auto____8048) {
            return i__8046 < size
          }else {
            return and__3822__auto____8048
          }
        }())) {
          a__8044[i__8046] = cljs.core.first.call(null, s__8047);
          var G__8051 = i__8046 + 1;
          var G__8052 = cljs.core.next.call(null, s__8047);
          i__8046 = G__8051;
          s__8047 = G__8052;
          continue
        }else {
          return a__8044
        }
        break
      }
    }else {
      var n__2622__auto____8049 = size;
      var i__8050 = 0;
      while(true) {
        if(i__8050 < n__2622__auto____8049) {
          a__8044[i__8050] = init_val_or_seq;
          var G__8053 = i__8050 + 1;
          i__8050 = G__8053;
          continue
        }else {
        }
        break
      }
      return a__8044
    }
  };
  object_array = function(size, init_val_or_seq) {
    switch(arguments.length) {
      case 1:
        return object_array__1.call(this, size);
      case 2:
        return object_array__2.call(this, size, init_val_or_seq)
    }
    throw"Invalid arity: " + arguments.length;
  };
  object_array.cljs$lang$arity$1 = object_array__1;
  object_array.cljs$lang$arity$2 = object_array__2;
  return object_array
}();
cljs.core.bounded_count = function bounded_count(s, n) {
  if(cljs.core.counted_QMARK_.call(null, s)) {
    return cljs.core.count.call(null, s)
  }else {
    var s__8058 = s;
    var i__8059 = n;
    var sum__8060 = 0;
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3822__auto____8061 = i__8059 > 0;
        if(and__3822__auto____8061) {
          return cljs.core.seq.call(null, s__8058)
        }else {
          return and__3822__auto____8061
        }
      }())) {
        var G__8062 = cljs.core.next.call(null, s__8058);
        var G__8063 = i__8059 - 1;
        var G__8064 = sum__8060 + 1;
        s__8058 = G__8062;
        i__8059 = G__8063;
        sum__8060 = G__8064;
        continue
      }else {
        return sum__8060
      }
      break
    }
  }
};
cljs.core.spread = function spread(arglist) {
  if(arglist == null) {
    return null
  }else {
    if(cljs.core.next.call(null, arglist) == null) {
      return cljs.core.seq.call(null, cljs.core.first.call(null, arglist))
    }else {
      if("\ufdd0'else") {
        return cljs.core.cons.call(null, cljs.core.first.call(null, arglist), spread.call(null, cljs.core.next.call(null, arglist)))
      }else {
        return null
      }
    }
  }
};
cljs.core.concat = function() {
  var concat = null;
  var concat__0 = function() {
    return new cljs.core.LazySeq(null, false, function() {
      return null
    }, null)
  };
  var concat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return x
    }, null)
  };
  var concat__2 = function(x, y) {
    return new cljs.core.LazySeq(null, false, function() {
      var s__8069 = cljs.core.seq.call(null, x);
      if(s__8069) {
        if(cljs.core.chunked_seq_QMARK_.call(null, s__8069)) {
          return cljs.core.chunk_cons.call(null, cljs.core.chunk_first.call(null, s__8069), concat.call(null, cljs.core.chunk_rest.call(null, s__8069), y))
        }else {
          return cljs.core.cons.call(null, cljs.core.first.call(null, s__8069), concat.call(null, cljs.core.rest.call(null, s__8069), y))
        }
      }else {
        return y
      }
    }, null)
  };
  var concat__3 = function() {
    var G__8073__delegate = function(x, y, zs) {
      var cat__8072 = function cat(xys, zs) {
        return new cljs.core.LazySeq(null, false, function() {
          var xys__8071 = cljs.core.seq.call(null, xys);
          if(xys__8071) {
            if(cljs.core.chunked_seq_QMARK_.call(null, xys__8071)) {
              return cljs.core.chunk_cons.call(null, cljs.core.chunk_first.call(null, xys__8071), cat.call(null, cljs.core.chunk_rest.call(null, xys__8071), zs))
            }else {
              return cljs.core.cons.call(null, cljs.core.first.call(null, xys__8071), cat.call(null, cljs.core.rest.call(null, xys__8071), zs))
            }
          }else {
            if(cljs.core.truth_(zs)) {
              return cat.call(null, cljs.core.first.call(null, zs), cljs.core.next.call(null, zs))
            }else {
              return null
            }
          }
        }, null)
      };
      return cat__8072.call(null, concat.call(null, x, y), zs)
    };
    var G__8073 = function(x, y, var_args) {
      var zs = null;
      if(goog.isDef(var_args)) {
        zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__8073__delegate.call(this, x, y, zs)
    };
    G__8073.cljs$lang$maxFixedArity = 2;
    G__8073.cljs$lang$applyTo = function(arglist__8074) {
      var x = cljs.core.first(arglist__8074);
      var y = cljs.core.first(cljs.core.next(arglist__8074));
      var zs = cljs.core.rest(cljs.core.next(arglist__8074));
      return G__8073__delegate(x, y, zs)
    };
    G__8073.cljs$lang$arity$variadic = G__8073__delegate;
    return G__8073
  }();
  concat = function(x, y, var_args) {
    var zs = var_args;
    switch(arguments.length) {
      case 0:
        return concat__0.call(this);
      case 1:
        return concat__1.call(this, x);
      case 2:
        return concat__2.call(this, x, y);
      default:
        return concat__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  concat.cljs$lang$maxFixedArity = 2;
  concat.cljs$lang$applyTo = concat__3.cljs$lang$applyTo;
  concat.cljs$lang$arity$0 = concat__0;
  concat.cljs$lang$arity$1 = concat__1;
  concat.cljs$lang$arity$2 = concat__2;
  concat.cljs$lang$arity$variadic = concat__3.cljs$lang$arity$variadic;
  return concat
}();
cljs.core.list_STAR_ = function() {
  var list_STAR_ = null;
  var list_STAR___1 = function(args) {
    return cljs.core.seq.call(null, args)
  };
  var list_STAR___2 = function(a, args) {
    return cljs.core.cons.call(null, a, args)
  };
  var list_STAR___3 = function(a, b, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, args))
  };
  var list_STAR___4 = function(a, b, c, args) {
    return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, args)))
  };
  var list_STAR___5 = function() {
    var G__8075__delegate = function(a, b, c, d, more) {
      return cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, more)))))
    };
    var G__8075 = function(a, b, c, d, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__8075__delegate.call(this, a, b, c, d, more)
    };
    G__8075.cljs$lang$maxFixedArity = 4;
    G__8075.cljs$lang$applyTo = function(arglist__8076) {
      var a = cljs.core.first(arglist__8076);
      var b = cljs.core.first(cljs.core.next(arglist__8076));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8076)));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__8076))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__8076))));
      return G__8075__delegate(a, b, c, d, more)
    };
    G__8075.cljs$lang$arity$variadic = G__8075__delegate;
    return G__8075
  }();
  list_STAR_ = function(a, b, c, d, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return list_STAR___1.call(this, a);
      case 2:
        return list_STAR___2.call(this, a, b);
      case 3:
        return list_STAR___3.call(this, a, b, c);
      case 4:
        return list_STAR___4.call(this, a, b, c, d);
      default:
        return list_STAR___5.cljs$lang$arity$variadic(a, b, c, d, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  list_STAR_.cljs$lang$maxFixedArity = 4;
  list_STAR_.cljs$lang$applyTo = list_STAR___5.cljs$lang$applyTo;
  list_STAR_.cljs$lang$arity$1 = list_STAR___1;
  list_STAR_.cljs$lang$arity$2 = list_STAR___2;
  list_STAR_.cljs$lang$arity$3 = list_STAR___3;
  list_STAR_.cljs$lang$arity$4 = list_STAR___4;
  list_STAR_.cljs$lang$arity$variadic = list_STAR___5.cljs$lang$arity$variadic;
  return list_STAR_
}();
cljs.core.transient$ = function transient$(coll) {
  return cljs.core._as_transient.call(null, coll)
};
cljs.core.persistent_BANG_ = function persistent_BANG_(tcoll) {
  return cljs.core._persistent_BANG_.call(null, tcoll)
};
cljs.core.conj_BANG_ = function conj_BANG_(tcoll, val) {
  return cljs.core._conj_BANG_.call(null, tcoll, val)
};
cljs.core.assoc_BANG_ = function assoc_BANG_(tcoll, key, val) {
  return cljs.core._assoc_BANG_.call(null, tcoll, key, val)
};
cljs.core.dissoc_BANG_ = function dissoc_BANG_(tcoll, key) {
  return cljs.core._dissoc_BANG_.call(null, tcoll, key)
};
cljs.core.pop_BANG_ = function pop_BANG_(tcoll) {
  return cljs.core._pop_BANG_.call(null, tcoll)
};
cljs.core.disj_BANG_ = function disj_BANG_(tcoll, val) {
  return cljs.core._disjoin_BANG_.call(null, tcoll, val)
};
cljs.core.apply_to = function apply_to(f, argc, args) {
  var args__8118 = cljs.core.seq.call(null, args);
  if(argc === 0) {
    return f.call(null)
  }else {
    var a__8119 = cljs.core._first.call(null, args__8118);
    var args__8120 = cljs.core._rest.call(null, args__8118);
    if(argc === 1) {
      if(f.cljs$lang$arity$1) {
        return f.cljs$lang$arity$1(a__8119)
      }else {
        return f.call(null, a__8119)
      }
    }else {
      var b__8121 = cljs.core._first.call(null, args__8120);
      var args__8122 = cljs.core._rest.call(null, args__8120);
      if(argc === 2) {
        if(f.cljs$lang$arity$2) {
          return f.cljs$lang$arity$2(a__8119, b__8121)
        }else {
          return f.call(null, a__8119, b__8121)
        }
      }else {
        var c__8123 = cljs.core._first.call(null, args__8122);
        var args__8124 = cljs.core._rest.call(null, args__8122);
        if(argc === 3) {
          if(f.cljs$lang$arity$3) {
            return f.cljs$lang$arity$3(a__8119, b__8121, c__8123)
          }else {
            return f.call(null, a__8119, b__8121, c__8123)
          }
        }else {
          var d__8125 = cljs.core._first.call(null, args__8124);
          var args__8126 = cljs.core._rest.call(null, args__8124);
          if(argc === 4) {
            if(f.cljs$lang$arity$4) {
              return f.cljs$lang$arity$4(a__8119, b__8121, c__8123, d__8125)
            }else {
              return f.call(null, a__8119, b__8121, c__8123, d__8125)
            }
          }else {
            var e__8127 = cljs.core._first.call(null, args__8126);
            var args__8128 = cljs.core._rest.call(null, args__8126);
            if(argc === 5) {
              if(f.cljs$lang$arity$5) {
                return f.cljs$lang$arity$5(a__8119, b__8121, c__8123, d__8125, e__8127)
              }else {
                return f.call(null, a__8119, b__8121, c__8123, d__8125, e__8127)
              }
            }else {
              var f__8129 = cljs.core._first.call(null, args__8128);
              var args__8130 = cljs.core._rest.call(null, args__8128);
              if(argc === 6) {
                if(f__8129.cljs$lang$arity$6) {
                  return f__8129.cljs$lang$arity$6(a__8119, b__8121, c__8123, d__8125, e__8127, f__8129)
                }else {
                  return f__8129.call(null, a__8119, b__8121, c__8123, d__8125, e__8127, f__8129)
                }
              }else {
                var g__8131 = cljs.core._first.call(null, args__8130);
                var args__8132 = cljs.core._rest.call(null, args__8130);
                if(argc === 7) {
                  if(f__8129.cljs$lang$arity$7) {
                    return f__8129.cljs$lang$arity$7(a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131)
                  }else {
                    return f__8129.call(null, a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131)
                  }
                }else {
                  var h__8133 = cljs.core._first.call(null, args__8132);
                  var args__8134 = cljs.core._rest.call(null, args__8132);
                  if(argc === 8) {
                    if(f__8129.cljs$lang$arity$8) {
                      return f__8129.cljs$lang$arity$8(a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133)
                    }else {
                      return f__8129.call(null, a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133)
                    }
                  }else {
                    var i__8135 = cljs.core._first.call(null, args__8134);
                    var args__8136 = cljs.core._rest.call(null, args__8134);
                    if(argc === 9) {
                      if(f__8129.cljs$lang$arity$9) {
                        return f__8129.cljs$lang$arity$9(a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135)
                      }else {
                        return f__8129.call(null, a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135)
                      }
                    }else {
                      var j__8137 = cljs.core._first.call(null, args__8136);
                      var args__8138 = cljs.core._rest.call(null, args__8136);
                      if(argc === 10) {
                        if(f__8129.cljs$lang$arity$10) {
                          return f__8129.cljs$lang$arity$10(a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137)
                        }else {
                          return f__8129.call(null, a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137)
                        }
                      }else {
                        var k__8139 = cljs.core._first.call(null, args__8138);
                        var args__8140 = cljs.core._rest.call(null, args__8138);
                        if(argc === 11) {
                          if(f__8129.cljs$lang$arity$11) {
                            return f__8129.cljs$lang$arity$11(a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137, k__8139)
                          }else {
                            return f__8129.call(null, a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137, k__8139)
                          }
                        }else {
                          var l__8141 = cljs.core._first.call(null, args__8140);
                          var args__8142 = cljs.core._rest.call(null, args__8140);
                          if(argc === 12) {
                            if(f__8129.cljs$lang$arity$12) {
                              return f__8129.cljs$lang$arity$12(a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137, k__8139, l__8141)
                            }else {
                              return f__8129.call(null, a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137, k__8139, l__8141)
                            }
                          }else {
                            var m__8143 = cljs.core._first.call(null, args__8142);
                            var args__8144 = cljs.core._rest.call(null, args__8142);
                            if(argc === 13) {
                              if(f__8129.cljs$lang$arity$13) {
                                return f__8129.cljs$lang$arity$13(a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137, k__8139, l__8141, m__8143)
                              }else {
                                return f__8129.call(null, a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137, k__8139, l__8141, m__8143)
                              }
                            }else {
                              var n__8145 = cljs.core._first.call(null, args__8144);
                              var args__8146 = cljs.core._rest.call(null, args__8144);
                              if(argc === 14) {
                                if(f__8129.cljs$lang$arity$14) {
                                  return f__8129.cljs$lang$arity$14(a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137, k__8139, l__8141, m__8143, n__8145)
                                }else {
                                  return f__8129.call(null, a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137, k__8139, l__8141, m__8143, n__8145)
                                }
                              }else {
                                var o__8147 = cljs.core._first.call(null, args__8146);
                                var args__8148 = cljs.core._rest.call(null, args__8146);
                                if(argc === 15) {
                                  if(f__8129.cljs$lang$arity$15) {
                                    return f__8129.cljs$lang$arity$15(a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137, k__8139, l__8141, m__8143, n__8145, o__8147)
                                  }else {
                                    return f__8129.call(null, a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137, k__8139, l__8141, m__8143, n__8145, o__8147)
                                  }
                                }else {
                                  var p__8149 = cljs.core._first.call(null, args__8148);
                                  var args__8150 = cljs.core._rest.call(null, args__8148);
                                  if(argc === 16) {
                                    if(f__8129.cljs$lang$arity$16) {
                                      return f__8129.cljs$lang$arity$16(a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137, k__8139, l__8141, m__8143, n__8145, o__8147, p__8149)
                                    }else {
                                      return f__8129.call(null, a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137, k__8139, l__8141, m__8143, n__8145, o__8147, p__8149)
                                    }
                                  }else {
                                    var q__8151 = cljs.core._first.call(null, args__8150);
                                    var args__8152 = cljs.core._rest.call(null, args__8150);
                                    if(argc === 17) {
                                      if(f__8129.cljs$lang$arity$17) {
                                        return f__8129.cljs$lang$arity$17(a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137, k__8139, l__8141, m__8143, n__8145, o__8147, p__8149, q__8151)
                                      }else {
                                        return f__8129.call(null, a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137, k__8139, l__8141, m__8143, n__8145, o__8147, p__8149, q__8151)
                                      }
                                    }else {
                                      var r__8153 = cljs.core._first.call(null, args__8152);
                                      var args__8154 = cljs.core._rest.call(null, args__8152);
                                      if(argc === 18) {
                                        if(f__8129.cljs$lang$arity$18) {
                                          return f__8129.cljs$lang$arity$18(a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137, k__8139, l__8141, m__8143, n__8145, o__8147, p__8149, q__8151, r__8153)
                                        }else {
                                          return f__8129.call(null, a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137, k__8139, l__8141, m__8143, n__8145, o__8147, p__8149, q__8151, r__8153)
                                        }
                                      }else {
                                        var s__8155 = cljs.core._first.call(null, args__8154);
                                        var args__8156 = cljs.core._rest.call(null, args__8154);
                                        if(argc === 19) {
                                          if(f__8129.cljs$lang$arity$19) {
                                            return f__8129.cljs$lang$arity$19(a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137, k__8139, l__8141, m__8143, n__8145, o__8147, p__8149, q__8151, r__8153, s__8155)
                                          }else {
                                            return f__8129.call(null, a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137, k__8139, l__8141, m__8143, n__8145, o__8147, p__8149, q__8151, r__8153, s__8155)
                                          }
                                        }else {
                                          var t__8157 = cljs.core._first.call(null, args__8156);
                                          var args__8158 = cljs.core._rest.call(null, args__8156);
                                          if(argc === 20) {
                                            if(f__8129.cljs$lang$arity$20) {
                                              return f__8129.cljs$lang$arity$20(a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137, k__8139, l__8141, m__8143, n__8145, o__8147, p__8149, q__8151, r__8153, s__8155, t__8157)
                                            }else {
                                              return f__8129.call(null, a__8119, b__8121, c__8123, d__8125, e__8127, f__8129, g__8131, h__8133, i__8135, j__8137, k__8139, l__8141, m__8143, n__8145, o__8147, p__8149, q__8151, r__8153, s__8155, t__8157)
                                            }
                                          }else {
                                            throw new Error("Only up to 20 arguments supported on functions");
                                          }
                                        }
                                      }
                                    }
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
};
cljs.core.apply = function() {
  var apply = null;
  var apply__2 = function(f, args) {
    var fixed_arity__8173 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__8174 = cljs.core.bounded_count.call(null, args, fixed_arity__8173 + 1);
      if(bc__8174 <= fixed_arity__8173) {
        return cljs.core.apply_to.call(null, f, bc__8174, args)
      }else {
        return f.cljs$lang$applyTo(args)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, args))
    }
  };
  var apply__3 = function(f, x, args) {
    var arglist__8175 = cljs.core.list_STAR_.call(null, x, args);
    var fixed_arity__8176 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__8177 = cljs.core.bounded_count.call(null, arglist__8175, fixed_arity__8176 + 1);
      if(bc__8177 <= fixed_arity__8176) {
        return cljs.core.apply_to.call(null, f, bc__8177, arglist__8175)
      }else {
        return f.cljs$lang$applyTo(arglist__8175)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__8175))
    }
  };
  var apply__4 = function(f, x, y, args) {
    var arglist__8178 = cljs.core.list_STAR_.call(null, x, y, args);
    var fixed_arity__8179 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__8180 = cljs.core.bounded_count.call(null, arglist__8178, fixed_arity__8179 + 1);
      if(bc__8180 <= fixed_arity__8179) {
        return cljs.core.apply_to.call(null, f, bc__8180, arglist__8178)
      }else {
        return f.cljs$lang$applyTo(arglist__8178)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__8178))
    }
  };
  var apply__5 = function(f, x, y, z, args) {
    var arglist__8181 = cljs.core.list_STAR_.call(null, x, y, z, args);
    var fixed_arity__8182 = f.cljs$lang$maxFixedArity;
    if(cljs.core.truth_(f.cljs$lang$applyTo)) {
      var bc__8183 = cljs.core.bounded_count.call(null, arglist__8181, fixed_arity__8182 + 1);
      if(bc__8183 <= fixed_arity__8182) {
        return cljs.core.apply_to.call(null, f, bc__8183, arglist__8181)
      }else {
        return f.cljs$lang$applyTo(arglist__8181)
      }
    }else {
      return f.apply(f, cljs.core.to_array.call(null, arglist__8181))
    }
  };
  var apply__6 = function() {
    var G__8187__delegate = function(f, a, b, c, d, args) {
      var arglist__8184 = cljs.core.cons.call(null, a, cljs.core.cons.call(null, b, cljs.core.cons.call(null, c, cljs.core.cons.call(null, d, cljs.core.spread.call(null, args)))));
      var fixed_arity__8185 = f.cljs$lang$maxFixedArity;
      if(cljs.core.truth_(f.cljs$lang$applyTo)) {
        var bc__8186 = cljs.core.bounded_count.call(null, arglist__8184, fixed_arity__8185 + 1);
        if(bc__8186 <= fixed_arity__8185) {
          return cljs.core.apply_to.call(null, f, bc__8186, arglist__8184)
        }else {
          return f.cljs$lang$applyTo(arglist__8184)
        }
      }else {
        return f.apply(f, cljs.core.to_array.call(null, arglist__8184))
      }
    };
    var G__8187 = function(f, a, b, c, d, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__8187__delegate.call(this, f, a, b, c, d, args)
    };
    G__8187.cljs$lang$maxFixedArity = 5;
    G__8187.cljs$lang$applyTo = function(arglist__8188) {
      var f = cljs.core.first(arglist__8188);
      var a = cljs.core.first(cljs.core.next(arglist__8188));
      var b = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8188)));
      var c = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__8188))));
      var d = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__8188)))));
      var args = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__8188)))));
      return G__8187__delegate(f, a, b, c, d, args)
    };
    G__8187.cljs$lang$arity$variadic = G__8187__delegate;
    return G__8187
  }();
  apply = function(f, a, b, c, d, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 2:
        return apply__2.call(this, f, a);
      case 3:
        return apply__3.call(this, f, a, b);
      case 4:
        return apply__4.call(this, f, a, b, c);
      case 5:
        return apply__5.call(this, f, a, b, c, d);
      default:
        return apply__6.cljs$lang$arity$variadic(f, a, b, c, d, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  apply.cljs$lang$maxFixedArity = 5;
  apply.cljs$lang$applyTo = apply__6.cljs$lang$applyTo;
  apply.cljs$lang$arity$2 = apply__2;
  apply.cljs$lang$arity$3 = apply__3;
  apply.cljs$lang$arity$4 = apply__4;
  apply.cljs$lang$arity$5 = apply__5;
  apply.cljs$lang$arity$variadic = apply__6.cljs$lang$arity$variadic;
  return apply
}();
cljs.core.vary_meta = function() {
  var vary_meta__delegate = function(obj, f, args) {
    return cljs.core.with_meta.call(null, obj, cljs.core.apply.call(null, f, cljs.core.meta.call(null, obj), args))
  };
  var vary_meta = function(obj, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return vary_meta__delegate.call(this, obj, f, args)
  };
  vary_meta.cljs$lang$maxFixedArity = 2;
  vary_meta.cljs$lang$applyTo = function(arglist__8189) {
    var obj = cljs.core.first(arglist__8189);
    var f = cljs.core.first(cljs.core.next(arglist__8189));
    var args = cljs.core.rest(cljs.core.next(arglist__8189));
    return vary_meta__delegate(obj, f, args)
  };
  vary_meta.cljs$lang$arity$variadic = vary_meta__delegate;
  return vary_meta
}();
cljs.core.not_EQ_ = function() {
  var not_EQ_ = null;
  var not_EQ___1 = function(x) {
    return false
  };
  var not_EQ___2 = function(x, y) {
    return!cljs.core._EQ_.call(null, x, y)
  };
  var not_EQ___3 = function() {
    var G__8190__delegate = function(x, y, more) {
      return cljs.core.not.call(null, cljs.core.apply.call(null, cljs.core._EQ_, x, y, more))
    };
    var G__8190 = function(x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__8190__delegate.call(this, x, y, more)
    };
    G__8190.cljs$lang$maxFixedArity = 2;
    G__8190.cljs$lang$applyTo = function(arglist__8191) {
      var x = cljs.core.first(arglist__8191);
      var y = cljs.core.first(cljs.core.next(arglist__8191));
      var more = cljs.core.rest(cljs.core.next(arglist__8191));
      return G__8190__delegate(x, y, more)
    };
    G__8190.cljs$lang$arity$variadic = G__8190__delegate;
    return G__8190
  }();
  not_EQ_ = function(x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 1:
        return not_EQ___1.call(this, x);
      case 2:
        return not_EQ___2.call(this, x, y);
      default:
        return not_EQ___3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  not_EQ_.cljs$lang$maxFixedArity = 2;
  not_EQ_.cljs$lang$applyTo = not_EQ___3.cljs$lang$applyTo;
  not_EQ_.cljs$lang$arity$1 = not_EQ___1;
  not_EQ_.cljs$lang$arity$2 = not_EQ___2;
  not_EQ_.cljs$lang$arity$variadic = not_EQ___3.cljs$lang$arity$variadic;
  return not_EQ_
}();
cljs.core.not_empty = function not_empty(coll) {
  if(cljs.core.seq.call(null, coll)) {
    return coll
  }else {
    return null
  }
};
cljs.core.every_QMARK_ = function every_QMARK_(pred, coll) {
  while(true) {
    if(cljs.core.seq.call(null, coll) == null) {
      return true
    }else {
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, coll)))) {
        var G__8192 = pred;
        var G__8193 = cljs.core.next.call(null, coll);
        pred = G__8192;
        coll = G__8193;
        continue
      }else {
        if("\ufdd0'else") {
          return false
        }else {
          return null
        }
      }
    }
    break
  }
};
cljs.core.not_every_QMARK_ = function not_every_QMARK_(pred, coll) {
  return!cljs.core.every_QMARK_.call(null, pred, coll)
};
cljs.core.some = function some(pred, coll) {
  while(true) {
    if(cljs.core.seq.call(null, coll)) {
      var or__3824__auto____8195 = pred.call(null, cljs.core.first.call(null, coll));
      if(cljs.core.truth_(or__3824__auto____8195)) {
        return or__3824__auto____8195
      }else {
        var G__8196 = pred;
        var G__8197 = cljs.core.next.call(null, coll);
        pred = G__8196;
        coll = G__8197;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.not_any_QMARK_ = function not_any_QMARK_(pred, coll) {
  return cljs.core.not.call(null, cljs.core.some.call(null, pred, coll))
};
cljs.core.even_QMARK_ = function even_QMARK_(n) {
  if(cljs.core.integer_QMARK_.call(null, n)) {
    return(n & 1) === 0
  }else {
    throw new Error([cljs.core.str("Argument must be an integer: "), cljs.core.str(n)].join(""));
  }
};
cljs.core.odd_QMARK_ = function odd_QMARK_(n) {
  return!cljs.core.even_QMARK_.call(null, n)
};
cljs.core.identity = function identity(x) {
  return x
};
cljs.core.complement = function complement(f) {
  return function() {
    var G__8198 = null;
    var G__8198__0 = function() {
      return cljs.core.not.call(null, f.call(null))
    };
    var G__8198__1 = function(x) {
      return cljs.core.not.call(null, f.call(null, x))
    };
    var G__8198__2 = function(x, y) {
      return cljs.core.not.call(null, f.call(null, x, y))
    };
    var G__8198__3 = function() {
      var G__8199__delegate = function(x, y, zs) {
        return cljs.core.not.call(null, cljs.core.apply.call(null, f, x, y, zs))
      };
      var G__8199 = function(x, y, var_args) {
        var zs = null;
        if(goog.isDef(var_args)) {
          zs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
        }
        return G__8199__delegate.call(this, x, y, zs)
      };
      G__8199.cljs$lang$maxFixedArity = 2;
      G__8199.cljs$lang$applyTo = function(arglist__8200) {
        var x = cljs.core.first(arglist__8200);
        var y = cljs.core.first(cljs.core.next(arglist__8200));
        var zs = cljs.core.rest(cljs.core.next(arglist__8200));
        return G__8199__delegate(x, y, zs)
      };
      G__8199.cljs$lang$arity$variadic = G__8199__delegate;
      return G__8199
    }();
    G__8198 = function(x, y, var_args) {
      var zs = var_args;
      switch(arguments.length) {
        case 0:
          return G__8198__0.call(this);
        case 1:
          return G__8198__1.call(this, x);
        case 2:
          return G__8198__2.call(this, x, y);
        default:
          return G__8198__3.cljs$lang$arity$variadic(x, y, cljs.core.array_seq(arguments, 2))
      }
      throw"Invalid arity: " + arguments.length;
    };
    G__8198.cljs$lang$maxFixedArity = 2;
    G__8198.cljs$lang$applyTo = G__8198__3.cljs$lang$applyTo;
    return G__8198
  }()
};
cljs.core.constantly = function constantly(x) {
  return function() {
    var G__8201__delegate = function(args) {
      return x
    };
    var G__8201 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__8201__delegate.call(this, args)
    };
    G__8201.cljs$lang$maxFixedArity = 0;
    G__8201.cljs$lang$applyTo = function(arglist__8202) {
      var args = cljs.core.seq(arglist__8202);
      return G__8201__delegate(args)
    };
    G__8201.cljs$lang$arity$variadic = G__8201__delegate;
    return G__8201
  }()
};
cljs.core.comp = function() {
  var comp = null;
  var comp__0 = function() {
    return cljs.core.identity
  };
  var comp__1 = function(f) {
    return f
  };
  var comp__2 = function(f, g) {
    return function() {
      var G__8209 = null;
      var G__8209__0 = function() {
        return f.call(null, g.call(null))
      };
      var G__8209__1 = function(x) {
        return f.call(null, g.call(null, x))
      };
      var G__8209__2 = function(x, y) {
        return f.call(null, g.call(null, x, y))
      };
      var G__8209__3 = function(x, y, z) {
        return f.call(null, g.call(null, x, y, z))
      };
      var G__8209__4 = function() {
        var G__8210__delegate = function(x, y, z, args) {
          return f.call(null, cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__8210 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__8210__delegate.call(this, x, y, z, args)
        };
        G__8210.cljs$lang$maxFixedArity = 3;
        G__8210.cljs$lang$applyTo = function(arglist__8211) {
          var x = cljs.core.first(arglist__8211);
          var y = cljs.core.first(cljs.core.next(arglist__8211));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8211)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8211)));
          return G__8210__delegate(x, y, z, args)
        };
        G__8210.cljs$lang$arity$variadic = G__8210__delegate;
        return G__8210
      }();
      G__8209 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__8209__0.call(this);
          case 1:
            return G__8209__1.call(this, x);
          case 2:
            return G__8209__2.call(this, x, y);
          case 3:
            return G__8209__3.call(this, x, y, z);
          default:
            return G__8209__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__8209.cljs$lang$maxFixedArity = 3;
      G__8209.cljs$lang$applyTo = G__8209__4.cljs$lang$applyTo;
      return G__8209
    }()
  };
  var comp__3 = function(f, g, h) {
    return function() {
      var G__8212 = null;
      var G__8212__0 = function() {
        return f.call(null, g.call(null, h.call(null)))
      };
      var G__8212__1 = function(x) {
        return f.call(null, g.call(null, h.call(null, x)))
      };
      var G__8212__2 = function(x, y) {
        return f.call(null, g.call(null, h.call(null, x, y)))
      };
      var G__8212__3 = function(x, y, z) {
        return f.call(null, g.call(null, h.call(null, x, y, z)))
      };
      var G__8212__4 = function() {
        var G__8213__delegate = function(x, y, z, args) {
          return f.call(null, g.call(null, cljs.core.apply.call(null, h, x, y, z, args)))
        };
        var G__8213 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__8213__delegate.call(this, x, y, z, args)
        };
        G__8213.cljs$lang$maxFixedArity = 3;
        G__8213.cljs$lang$applyTo = function(arglist__8214) {
          var x = cljs.core.first(arglist__8214);
          var y = cljs.core.first(cljs.core.next(arglist__8214));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8214)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8214)));
          return G__8213__delegate(x, y, z, args)
        };
        G__8213.cljs$lang$arity$variadic = G__8213__delegate;
        return G__8213
      }();
      G__8212 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__8212__0.call(this);
          case 1:
            return G__8212__1.call(this, x);
          case 2:
            return G__8212__2.call(this, x, y);
          case 3:
            return G__8212__3.call(this, x, y, z);
          default:
            return G__8212__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__8212.cljs$lang$maxFixedArity = 3;
      G__8212.cljs$lang$applyTo = G__8212__4.cljs$lang$applyTo;
      return G__8212
    }()
  };
  var comp__4 = function() {
    var G__8215__delegate = function(f1, f2, f3, fs) {
      var fs__8206 = cljs.core.reverse.call(null, cljs.core.list_STAR_.call(null, f1, f2, f3, fs));
      return function() {
        var G__8216__delegate = function(args) {
          var ret__8207 = cljs.core.apply.call(null, cljs.core.first.call(null, fs__8206), args);
          var fs__8208 = cljs.core.next.call(null, fs__8206);
          while(true) {
            if(fs__8208) {
              var G__8217 = cljs.core.first.call(null, fs__8208).call(null, ret__8207);
              var G__8218 = cljs.core.next.call(null, fs__8208);
              ret__8207 = G__8217;
              fs__8208 = G__8218;
              continue
            }else {
              return ret__8207
            }
            break
          }
        };
        var G__8216 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__8216__delegate.call(this, args)
        };
        G__8216.cljs$lang$maxFixedArity = 0;
        G__8216.cljs$lang$applyTo = function(arglist__8219) {
          var args = cljs.core.seq(arglist__8219);
          return G__8216__delegate(args)
        };
        G__8216.cljs$lang$arity$variadic = G__8216__delegate;
        return G__8216
      }()
    };
    var G__8215 = function(f1, f2, f3, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__8215__delegate.call(this, f1, f2, f3, fs)
    };
    G__8215.cljs$lang$maxFixedArity = 3;
    G__8215.cljs$lang$applyTo = function(arglist__8220) {
      var f1 = cljs.core.first(arglist__8220);
      var f2 = cljs.core.first(cljs.core.next(arglist__8220));
      var f3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8220)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8220)));
      return G__8215__delegate(f1, f2, f3, fs)
    };
    G__8215.cljs$lang$arity$variadic = G__8215__delegate;
    return G__8215
  }();
  comp = function(f1, f2, f3, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 0:
        return comp__0.call(this);
      case 1:
        return comp__1.call(this, f1);
      case 2:
        return comp__2.call(this, f1, f2);
      case 3:
        return comp__3.call(this, f1, f2, f3);
      default:
        return comp__4.cljs$lang$arity$variadic(f1, f2, f3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  comp.cljs$lang$maxFixedArity = 3;
  comp.cljs$lang$applyTo = comp__4.cljs$lang$applyTo;
  comp.cljs$lang$arity$0 = comp__0;
  comp.cljs$lang$arity$1 = comp__1;
  comp.cljs$lang$arity$2 = comp__2;
  comp.cljs$lang$arity$3 = comp__3;
  comp.cljs$lang$arity$variadic = comp__4.cljs$lang$arity$variadic;
  return comp
}();
cljs.core.partial = function() {
  var partial = null;
  var partial__2 = function(f, arg1) {
    return function() {
      var G__8221__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, args)
      };
      var G__8221 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__8221__delegate.call(this, args)
      };
      G__8221.cljs$lang$maxFixedArity = 0;
      G__8221.cljs$lang$applyTo = function(arglist__8222) {
        var args = cljs.core.seq(arglist__8222);
        return G__8221__delegate(args)
      };
      G__8221.cljs$lang$arity$variadic = G__8221__delegate;
      return G__8221
    }()
  };
  var partial__3 = function(f, arg1, arg2) {
    return function() {
      var G__8223__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, args)
      };
      var G__8223 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__8223__delegate.call(this, args)
      };
      G__8223.cljs$lang$maxFixedArity = 0;
      G__8223.cljs$lang$applyTo = function(arglist__8224) {
        var args = cljs.core.seq(arglist__8224);
        return G__8223__delegate(args)
      };
      G__8223.cljs$lang$arity$variadic = G__8223__delegate;
      return G__8223
    }()
  };
  var partial__4 = function(f, arg1, arg2, arg3) {
    return function() {
      var G__8225__delegate = function(args) {
        return cljs.core.apply.call(null, f, arg1, arg2, arg3, args)
      };
      var G__8225 = function(var_args) {
        var args = null;
        if(goog.isDef(var_args)) {
          args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
        }
        return G__8225__delegate.call(this, args)
      };
      G__8225.cljs$lang$maxFixedArity = 0;
      G__8225.cljs$lang$applyTo = function(arglist__8226) {
        var args = cljs.core.seq(arglist__8226);
        return G__8225__delegate(args)
      };
      G__8225.cljs$lang$arity$variadic = G__8225__delegate;
      return G__8225
    }()
  };
  var partial__5 = function() {
    var G__8227__delegate = function(f, arg1, arg2, arg3, more) {
      return function() {
        var G__8228__delegate = function(args) {
          return cljs.core.apply.call(null, f, arg1, arg2, arg3, cljs.core.concat.call(null, more, args))
        };
        var G__8228 = function(var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
          }
          return G__8228__delegate.call(this, args)
        };
        G__8228.cljs$lang$maxFixedArity = 0;
        G__8228.cljs$lang$applyTo = function(arglist__8229) {
          var args = cljs.core.seq(arglist__8229);
          return G__8228__delegate(args)
        };
        G__8228.cljs$lang$arity$variadic = G__8228__delegate;
        return G__8228
      }()
    };
    var G__8227 = function(f, arg1, arg2, arg3, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__8227__delegate.call(this, f, arg1, arg2, arg3, more)
    };
    G__8227.cljs$lang$maxFixedArity = 4;
    G__8227.cljs$lang$applyTo = function(arglist__8230) {
      var f = cljs.core.first(arglist__8230);
      var arg1 = cljs.core.first(cljs.core.next(arglist__8230));
      var arg2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8230)));
      var arg3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__8230))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__8230))));
      return G__8227__delegate(f, arg1, arg2, arg3, more)
    };
    G__8227.cljs$lang$arity$variadic = G__8227__delegate;
    return G__8227
  }();
  partial = function(f, arg1, arg2, arg3, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return partial__2.call(this, f, arg1);
      case 3:
        return partial__3.call(this, f, arg1, arg2);
      case 4:
        return partial__4.call(this, f, arg1, arg2, arg3);
      default:
        return partial__5.cljs$lang$arity$variadic(f, arg1, arg2, arg3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  partial.cljs$lang$maxFixedArity = 4;
  partial.cljs$lang$applyTo = partial__5.cljs$lang$applyTo;
  partial.cljs$lang$arity$2 = partial__2;
  partial.cljs$lang$arity$3 = partial__3;
  partial.cljs$lang$arity$4 = partial__4;
  partial.cljs$lang$arity$variadic = partial__5.cljs$lang$arity$variadic;
  return partial
}();
cljs.core.fnil = function() {
  var fnil = null;
  var fnil__2 = function(f, x) {
    return function() {
      var G__8231 = null;
      var G__8231__1 = function(a) {
        return f.call(null, a == null ? x : a)
      };
      var G__8231__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b)
      };
      var G__8231__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b, c)
      };
      var G__8231__4 = function() {
        var G__8232__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b, c, ds)
        };
        var G__8232 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__8232__delegate.call(this, a, b, c, ds)
        };
        G__8232.cljs$lang$maxFixedArity = 3;
        G__8232.cljs$lang$applyTo = function(arglist__8233) {
          var a = cljs.core.first(arglist__8233);
          var b = cljs.core.first(cljs.core.next(arglist__8233));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8233)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8233)));
          return G__8232__delegate(a, b, c, ds)
        };
        G__8232.cljs$lang$arity$variadic = G__8232__delegate;
        return G__8232
      }();
      G__8231 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 1:
            return G__8231__1.call(this, a);
          case 2:
            return G__8231__2.call(this, a, b);
          case 3:
            return G__8231__3.call(this, a, b, c);
          default:
            return G__8231__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__8231.cljs$lang$maxFixedArity = 3;
      G__8231.cljs$lang$applyTo = G__8231__4.cljs$lang$applyTo;
      return G__8231
    }()
  };
  var fnil__3 = function(f, x, y) {
    return function() {
      var G__8234 = null;
      var G__8234__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__8234__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c)
      };
      var G__8234__4 = function() {
        var G__8235__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c, ds)
        };
        var G__8235 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__8235__delegate.call(this, a, b, c, ds)
        };
        G__8235.cljs$lang$maxFixedArity = 3;
        G__8235.cljs$lang$applyTo = function(arglist__8236) {
          var a = cljs.core.first(arglist__8236);
          var b = cljs.core.first(cljs.core.next(arglist__8236));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8236)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8236)));
          return G__8235__delegate(a, b, c, ds)
        };
        G__8235.cljs$lang$arity$variadic = G__8235__delegate;
        return G__8235
      }();
      G__8234 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__8234__2.call(this, a, b);
          case 3:
            return G__8234__3.call(this, a, b, c);
          default:
            return G__8234__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__8234.cljs$lang$maxFixedArity = 3;
      G__8234.cljs$lang$applyTo = G__8234__4.cljs$lang$applyTo;
      return G__8234
    }()
  };
  var fnil__4 = function(f, x, y, z) {
    return function() {
      var G__8237 = null;
      var G__8237__2 = function(a, b) {
        return f.call(null, a == null ? x : a, b == null ? y : b)
      };
      var G__8237__3 = function(a, b, c) {
        return f.call(null, a == null ? x : a, b == null ? y : b, c == null ? z : c)
      };
      var G__8237__4 = function() {
        var G__8238__delegate = function(a, b, c, ds) {
          return cljs.core.apply.call(null, f, a == null ? x : a, b == null ? y : b, c == null ? z : c, ds)
        };
        var G__8238 = function(a, b, c, var_args) {
          var ds = null;
          if(goog.isDef(var_args)) {
            ds = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__8238__delegate.call(this, a, b, c, ds)
        };
        G__8238.cljs$lang$maxFixedArity = 3;
        G__8238.cljs$lang$applyTo = function(arglist__8239) {
          var a = cljs.core.first(arglist__8239);
          var b = cljs.core.first(cljs.core.next(arglist__8239));
          var c = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8239)));
          var ds = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8239)));
          return G__8238__delegate(a, b, c, ds)
        };
        G__8238.cljs$lang$arity$variadic = G__8238__delegate;
        return G__8238
      }();
      G__8237 = function(a, b, c, var_args) {
        var ds = var_args;
        switch(arguments.length) {
          case 2:
            return G__8237__2.call(this, a, b);
          case 3:
            return G__8237__3.call(this, a, b, c);
          default:
            return G__8237__4.cljs$lang$arity$variadic(a, b, c, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__8237.cljs$lang$maxFixedArity = 3;
      G__8237.cljs$lang$applyTo = G__8237__4.cljs$lang$applyTo;
      return G__8237
    }()
  };
  fnil = function(f, x, y, z) {
    switch(arguments.length) {
      case 2:
        return fnil__2.call(this, f, x);
      case 3:
        return fnil__3.call(this, f, x, y);
      case 4:
        return fnil__4.call(this, f, x, y, z)
    }
    throw"Invalid arity: " + arguments.length;
  };
  fnil.cljs$lang$arity$2 = fnil__2;
  fnil.cljs$lang$arity$3 = fnil__3;
  fnil.cljs$lang$arity$4 = fnil__4;
  return fnil
}();
cljs.core.map_indexed = function map_indexed(f, coll) {
  var mapi__8255 = function mapi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____8263 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____8263) {
        var s__8264 = temp__3974__auto____8263;
        if(cljs.core.chunked_seq_QMARK_.call(null, s__8264)) {
          var c__8265 = cljs.core.chunk_first.call(null, s__8264);
          var size__8266 = cljs.core.count.call(null, c__8265);
          var b__8267 = cljs.core.chunk_buffer.call(null, size__8266);
          var n__2622__auto____8268 = size__8266;
          var i__8269 = 0;
          while(true) {
            if(i__8269 < n__2622__auto____8268) {
              cljs.core.chunk_append.call(null, b__8267, f.call(null, idx + i__8269, cljs.core._nth.call(null, c__8265, i__8269)));
              var G__8270 = i__8269 + 1;
              i__8269 = G__8270;
              continue
            }else {
            }
            break
          }
          return cljs.core.chunk_cons.call(null, cljs.core.chunk.call(null, b__8267), mapi.call(null, idx + size__8266, cljs.core.chunk_rest.call(null, s__8264)))
        }else {
          return cljs.core.cons.call(null, f.call(null, idx, cljs.core.first.call(null, s__8264)), mapi.call(null, idx + 1, cljs.core.rest.call(null, s__8264)))
        }
      }else {
        return null
      }
    }, null)
  };
  return mapi__8255.call(null, 0, coll)
};
cljs.core.keep = function keep(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3974__auto____8280 = cljs.core.seq.call(null, coll);
    if(temp__3974__auto____8280) {
      var s__8281 = temp__3974__auto____8280;
      if(cljs.core.chunked_seq_QMARK_.call(null, s__8281)) {
        var c__8282 = cljs.core.chunk_first.call(null, s__8281);
        var size__8283 = cljs.core.count.call(null, c__8282);
        var b__8284 = cljs.core.chunk_buffer.call(null, size__8283);
        var n__2622__auto____8285 = size__8283;
        var i__8286 = 0;
        while(true) {
          if(i__8286 < n__2622__auto____8285) {
            var x__8287 = f.call(null, cljs.core._nth.call(null, c__8282, i__8286));
            if(x__8287 == null) {
            }else {
              cljs.core.chunk_append.call(null, b__8284, x__8287)
            }
            var G__8289 = i__8286 + 1;
            i__8286 = G__8289;
            continue
          }else {
          }
          break
        }
        return cljs.core.chunk_cons.call(null, cljs.core.chunk.call(null, b__8284), keep.call(null, f, cljs.core.chunk_rest.call(null, s__8281)))
      }else {
        var x__8288 = f.call(null, cljs.core.first.call(null, s__8281));
        if(x__8288 == null) {
          return keep.call(null, f, cljs.core.rest.call(null, s__8281))
        }else {
          return cljs.core.cons.call(null, x__8288, keep.call(null, f, cljs.core.rest.call(null, s__8281)))
        }
      }
    }else {
      return null
    }
  }, null)
};
cljs.core.keep_indexed = function keep_indexed(f, coll) {
  var keepi__8315 = function keepi(idx, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____8325 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____8325) {
        var s__8326 = temp__3974__auto____8325;
        if(cljs.core.chunked_seq_QMARK_.call(null, s__8326)) {
          var c__8327 = cljs.core.chunk_first.call(null, s__8326);
          var size__8328 = cljs.core.count.call(null, c__8327);
          var b__8329 = cljs.core.chunk_buffer.call(null, size__8328);
          var n__2622__auto____8330 = size__8328;
          var i__8331 = 0;
          while(true) {
            if(i__8331 < n__2622__auto____8330) {
              var x__8332 = f.call(null, idx + i__8331, cljs.core._nth.call(null, c__8327, i__8331));
              if(x__8332 == null) {
              }else {
                cljs.core.chunk_append.call(null, b__8329, x__8332)
              }
              var G__8334 = i__8331 + 1;
              i__8331 = G__8334;
              continue
            }else {
            }
            break
          }
          return cljs.core.chunk_cons.call(null, cljs.core.chunk.call(null, b__8329), keepi.call(null, idx + size__8328, cljs.core.chunk_rest.call(null, s__8326)))
        }else {
          var x__8333 = f.call(null, idx, cljs.core.first.call(null, s__8326));
          if(x__8333 == null) {
            return keepi.call(null, idx + 1, cljs.core.rest.call(null, s__8326))
          }else {
            return cljs.core.cons.call(null, x__8333, keepi.call(null, idx + 1, cljs.core.rest.call(null, s__8326)))
          }
        }
      }else {
        return null
      }
    }, null)
  };
  return keepi__8315.call(null, 0, coll)
};
cljs.core.every_pred = function() {
  var every_pred = null;
  var every_pred__1 = function(p) {
    return function() {
      var ep1 = null;
      var ep1__0 = function() {
        return true
      };
      var ep1__1 = function(x) {
        return cljs.core.boolean$.call(null, p.call(null, x))
      };
      var ep1__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____8420 = p.call(null, x);
          if(cljs.core.truth_(and__3822__auto____8420)) {
            return p.call(null, y)
          }else {
            return and__3822__auto____8420
          }
        }())
      };
      var ep1__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____8421 = p.call(null, x);
          if(cljs.core.truth_(and__3822__auto____8421)) {
            var and__3822__auto____8422 = p.call(null, y);
            if(cljs.core.truth_(and__3822__auto____8422)) {
              return p.call(null, z)
            }else {
              return and__3822__auto____8422
            }
          }else {
            return and__3822__auto____8421
          }
        }())
      };
      var ep1__4 = function() {
        var G__8491__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3822__auto____8423 = ep1.call(null, x, y, z);
            if(cljs.core.truth_(and__3822__auto____8423)) {
              return cljs.core.every_QMARK_.call(null, p, args)
            }else {
              return and__3822__auto____8423
            }
          }())
        };
        var G__8491 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__8491__delegate.call(this, x, y, z, args)
        };
        G__8491.cljs$lang$maxFixedArity = 3;
        G__8491.cljs$lang$applyTo = function(arglist__8492) {
          var x = cljs.core.first(arglist__8492);
          var y = cljs.core.first(cljs.core.next(arglist__8492));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8492)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8492)));
          return G__8491__delegate(x, y, z, args)
        };
        G__8491.cljs$lang$arity$variadic = G__8491__delegate;
        return G__8491
      }();
      ep1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep1__0.call(this);
          case 1:
            return ep1__1.call(this, x);
          case 2:
            return ep1__2.call(this, x, y);
          case 3:
            return ep1__3.call(this, x, y, z);
          default:
            return ep1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep1.cljs$lang$maxFixedArity = 3;
      ep1.cljs$lang$applyTo = ep1__4.cljs$lang$applyTo;
      ep1.cljs$lang$arity$0 = ep1__0;
      ep1.cljs$lang$arity$1 = ep1__1;
      ep1.cljs$lang$arity$2 = ep1__2;
      ep1.cljs$lang$arity$3 = ep1__3;
      ep1.cljs$lang$arity$variadic = ep1__4.cljs$lang$arity$variadic;
      return ep1
    }()
  };
  var every_pred__2 = function(p1, p2) {
    return function() {
      var ep2 = null;
      var ep2__0 = function() {
        return true
      };
      var ep2__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____8435 = p1.call(null, x);
          if(cljs.core.truth_(and__3822__auto____8435)) {
            return p2.call(null, x)
          }else {
            return and__3822__auto____8435
          }
        }())
      };
      var ep2__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____8436 = p1.call(null, x);
          if(cljs.core.truth_(and__3822__auto____8436)) {
            var and__3822__auto____8437 = p1.call(null, y);
            if(cljs.core.truth_(and__3822__auto____8437)) {
              var and__3822__auto____8438 = p2.call(null, x);
              if(cljs.core.truth_(and__3822__auto____8438)) {
                return p2.call(null, y)
              }else {
                return and__3822__auto____8438
              }
            }else {
              return and__3822__auto____8437
            }
          }else {
            return and__3822__auto____8436
          }
        }())
      };
      var ep2__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____8439 = p1.call(null, x);
          if(cljs.core.truth_(and__3822__auto____8439)) {
            var and__3822__auto____8440 = p1.call(null, y);
            if(cljs.core.truth_(and__3822__auto____8440)) {
              var and__3822__auto____8441 = p1.call(null, z);
              if(cljs.core.truth_(and__3822__auto____8441)) {
                var and__3822__auto____8442 = p2.call(null, x);
                if(cljs.core.truth_(and__3822__auto____8442)) {
                  var and__3822__auto____8443 = p2.call(null, y);
                  if(cljs.core.truth_(and__3822__auto____8443)) {
                    return p2.call(null, z)
                  }else {
                    return and__3822__auto____8443
                  }
                }else {
                  return and__3822__auto____8442
                }
              }else {
                return and__3822__auto____8441
              }
            }else {
              return and__3822__auto____8440
            }
          }else {
            return and__3822__auto____8439
          }
        }())
      };
      var ep2__4 = function() {
        var G__8493__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3822__auto____8444 = ep2.call(null, x, y, z);
            if(cljs.core.truth_(and__3822__auto____8444)) {
              return cljs.core.every_QMARK_.call(null, function(p1__8290_SHARP_) {
                var and__3822__auto____8445 = p1.call(null, p1__8290_SHARP_);
                if(cljs.core.truth_(and__3822__auto____8445)) {
                  return p2.call(null, p1__8290_SHARP_)
                }else {
                  return and__3822__auto____8445
                }
              }, args)
            }else {
              return and__3822__auto____8444
            }
          }())
        };
        var G__8493 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__8493__delegate.call(this, x, y, z, args)
        };
        G__8493.cljs$lang$maxFixedArity = 3;
        G__8493.cljs$lang$applyTo = function(arglist__8494) {
          var x = cljs.core.first(arglist__8494);
          var y = cljs.core.first(cljs.core.next(arglist__8494));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8494)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8494)));
          return G__8493__delegate(x, y, z, args)
        };
        G__8493.cljs$lang$arity$variadic = G__8493__delegate;
        return G__8493
      }();
      ep2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep2__0.call(this);
          case 1:
            return ep2__1.call(this, x);
          case 2:
            return ep2__2.call(this, x, y);
          case 3:
            return ep2__3.call(this, x, y, z);
          default:
            return ep2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep2.cljs$lang$maxFixedArity = 3;
      ep2.cljs$lang$applyTo = ep2__4.cljs$lang$applyTo;
      ep2.cljs$lang$arity$0 = ep2__0;
      ep2.cljs$lang$arity$1 = ep2__1;
      ep2.cljs$lang$arity$2 = ep2__2;
      ep2.cljs$lang$arity$3 = ep2__3;
      ep2.cljs$lang$arity$variadic = ep2__4.cljs$lang$arity$variadic;
      return ep2
    }()
  };
  var every_pred__3 = function(p1, p2, p3) {
    return function() {
      var ep3 = null;
      var ep3__0 = function() {
        return true
      };
      var ep3__1 = function(x) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____8464 = p1.call(null, x);
          if(cljs.core.truth_(and__3822__auto____8464)) {
            var and__3822__auto____8465 = p2.call(null, x);
            if(cljs.core.truth_(and__3822__auto____8465)) {
              return p3.call(null, x)
            }else {
              return and__3822__auto____8465
            }
          }else {
            return and__3822__auto____8464
          }
        }())
      };
      var ep3__2 = function(x, y) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____8466 = p1.call(null, x);
          if(cljs.core.truth_(and__3822__auto____8466)) {
            var and__3822__auto____8467 = p2.call(null, x);
            if(cljs.core.truth_(and__3822__auto____8467)) {
              var and__3822__auto____8468 = p3.call(null, x);
              if(cljs.core.truth_(and__3822__auto____8468)) {
                var and__3822__auto____8469 = p1.call(null, y);
                if(cljs.core.truth_(and__3822__auto____8469)) {
                  var and__3822__auto____8470 = p2.call(null, y);
                  if(cljs.core.truth_(and__3822__auto____8470)) {
                    return p3.call(null, y)
                  }else {
                    return and__3822__auto____8470
                  }
                }else {
                  return and__3822__auto____8469
                }
              }else {
                return and__3822__auto____8468
              }
            }else {
              return and__3822__auto____8467
            }
          }else {
            return and__3822__auto____8466
          }
        }())
      };
      var ep3__3 = function(x, y, z) {
        return cljs.core.boolean$.call(null, function() {
          var and__3822__auto____8471 = p1.call(null, x);
          if(cljs.core.truth_(and__3822__auto____8471)) {
            var and__3822__auto____8472 = p2.call(null, x);
            if(cljs.core.truth_(and__3822__auto____8472)) {
              var and__3822__auto____8473 = p3.call(null, x);
              if(cljs.core.truth_(and__3822__auto____8473)) {
                var and__3822__auto____8474 = p1.call(null, y);
                if(cljs.core.truth_(and__3822__auto____8474)) {
                  var and__3822__auto____8475 = p2.call(null, y);
                  if(cljs.core.truth_(and__3822__auto____8475)) {
                    var and__3822__auto____8476 = p3.call(null, y);
                    if(cljs.core.truth_(and__3822__auto____8476)) {
                      var and__3822__auto____8477 = p1.call(null, z);
                      if(cljs.core.truth_(and__3822__auto____8477)) {
                        var and__3822__auto____8478 = p2.call(null, z);
                        if(cljs.core.truth_(and__3822__auto____8478)) {
                          return p3.call(null, z)
                        }else {
                          return and__3822__auto____8478
                        }
                      }else {
                        return and__3822__auto____8477
                      }
                    }else {
                      return and__3822__auto____8476
                    }
                  }else {
                    return and__3822__auto____8475
                  }
                }else {
                  return and__3822__auto____8474
                }
              }else {
                return and__3822__auto____8473
              }
            }else {
              return and__3822__auto____8472
            }
          }else {
            return and__3822__auto____8471
          }
        }())
      };
      var ep3__4 = function() {
        var G__8495__delegate = function(x, y, z, args) {
          return cljs.core.boolean$.call(null, function() {
            var and__3822__auto____8479 = ep3.call(null, x, y, z);
            if(cljs.core.truth_(and__3822__auto____8479)) {
              return cljs.core.every_QMARK_.call(null, function(p1__8291_SHARP_) {
                var and__3822__auto____8480 = p1.call(null, p1__8291_SHARP_);
                if(cljs.core.truth_(and__3822__auto____8480)) {
                  var and__3822__auto____8481 = p2.call(null, p1__8291_SHARP_);
                  if(cljs.core.truth_(and__3822__auto____8481)) {
                    return p3.call(null, p1__8291_SHARP_)
                  }else {
                    return and__3822__auto____8481
                  }
                }else {
                  return and__3822__auto____8480
                }
              }, args)
            }else {
              return and__3822__auto____8479
            }
          }())
        };
        var G__8495 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__8495__delegate.call(this, x, y, z, args)
        };
        G__8495.cljs$lang$maxFixedArity = 3;
        G__8495.cljs$lang$applyTo = function(arglist__8496) {
          var x = cljs.core.first(arglist__8496);
          var y = cljs.core.first(cljs.core.next(arglist__8496));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8496)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8496)));
          return G__8495__delegate(x, y, z, args)
        };
        G__8495.cljs$lang$arity$variadic = G__8495__delegate;
        return G__8495
      }();
      ep3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return ep3__0.call(this);
          case 1:
            return ep3__1.call(this, x);
          case 2:
            return ep3__2.call(this, x, y);
          case 3:
            return ep3__3.call(this, x, y, z);
          default:
            return ep3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      ep3.cljs$lang$maxFixedArity = 3;
      ep3.cljs$lang$applyTo = ep3__4.cljs$lang$applyTo;
      ep3.cljs$lang$arity$0 = ep3__0;
      ep3.cljs$lang$arity$1 = ep3__1;
      ep3.cljs$lang$arity$2 = ep3__2;
      ep3.cljs$lang$arity$3 = ep3__3;
      ep3.cljs$lang$arity$variadic = ep3__4.cljs$lang$arity$variadic;
      return ep3
    }()
  };
  var every_pred__4 = function() {
    var G__8497__delegate = function(p1, p2, p3, ps) {
      var ps__8482 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var epn = null;
        var epn__0 = function() {
          return true
        };
        var epn__1 = function(x) {
          return cljs.core.every_QMARK_.call(null, function(p1__8292_SHARP_) {
            return p1__8292_SHARP_.call(null, x)
          }, ps__8482)
        };
        var epn__2 = function(x, y) {
          return cljs.core.every_QMARK_.call(null, function(p1__8293_SHARP_) {
            var and__3822__auto____8487 = p1__8293_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3822__auto____8487)) {
              return p1__8293_SHARP_.call(null, y)
            }else {
              return and__3822__auto____8487
            }
          }, ps__8482)
        };
        var epn__3 = function(x, y, z) {
          return cljs.core.every_QMARK_.call(null, function(p1__8294_SHARP_) {
            var and__3822__auto____8488 = p1__8294_SHARP_.call(null, x);
            if(cljs.core.truth_(and__3822__auto____8488)) {
              var and__3822__auto____8489 = p1__8294_SHARP_.call(null, y);
              if(cljs.core.truth_(and__3822__auto____8489)) {
                return p1__8294_SHARP_.call(null, z)
              }else {
                return and__3822__auto____8489
              }
            }else {
              return and__3822__auto____8488
            }
          }, ps__8482)
        };
        var epn__4 = function() {
          var G__8498__delegate = function(x, y, z, args) {
            return cljs.core.boolean$.call(null, function() {
              var and__3822__auto____8490 = epn.call(null, x, y, z);
              if(cljs.core.truth_(and__3822__auto____8490)) {
                return cljs.core.every_QMARK_.call(null, function(p1__8295_SHARP_) {
                  return cljs.core.every_QMARK_.call(null, p1__8295_SHARP_, args)
                }, ps__8482)
              }else {
                return and__3822__auto____8490
              }
            }())
          };
          var G__8498 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__8498__delegate.call(this, x, y, z, args)
          };
          G__8498.cljs$lang$maxFixedArity = 3;
          G__8498.cljs$lang$applyTo = function(arglist__8499) {
            var x = cljs.core.first(arglist__8499);
            var y = cljs.core.first(cljs.core.next(arglist__8499));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8499)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8499)));
            return G__8498__delegate(x, y, z, args)
          };
          G__8498.cljs$lang$arity$variadic = G__8498__delegate;
          return G__8498
        }();
        epn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return epn__0.call(this);
            case 1:
              return epn__1.call(this, x);
            case 2:
              return epn__2.call(this, x, y);
            case 3:
              return epn__3.call(this, x, y, z);
            default:
              return epn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        epn.cljs$lang$maxFixedArity = 3;
        epn.cljs$lang$applyTo = epn__4.cljs$lang$applyTo;
        epn.cljs$lang$arity$0 = epn__0;
        epn.cljs$lang$arity$1 = epn__1;
        epn.cljs$lang$arity$2 = epn__2;
        epn.cljs$lang$arity$3 = epn__3;
        epn.cljs$lang$arity$variadic = epn__4.cljs$lang$arity$variadic;
        return epn
      }()
    };
    var G__8497 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__8497__delegate.call(this, p1, p2, p3, ps)
    };
    G__8497.cljs$lang$maxFixedArity = 3;
    G__8497.cljs$lang$applyTo = function(arglist__8500) {
      var p1 = cljs.core.first(arglist__8500);
      var p2 = cljs.core.first(cljs.core.next(arglist__8500));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8500)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8500)));
      return G__8497__delegate(p1, p2, p3, ps)
    };
    G__8497.cljs$lang$arity$variadic = G__8497__delegate;
    return G__8497
  }();
  every_pred = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return every_pred__1.call(this, p1);
      case 2:
        return every_pred__2.call(this, p1, p2);
      case 3:
        return every_pred__3.call(this, p1, p2, p3);
      default:
        return every_pred__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  every_pred.cljs$lang$maxFixedArity = 3;
  every_pred.cljs$lang$applyTo = every_pred__4.cljs$lang$applyTo;
  every_pred.cljs$lang$arity$1 = every_pred__1;
  every_pred.cljs$lang$arity$2 = every_pred__2;
  every_pred.cljs$lang$arity$3 = every_pred__3;
  every_pred.cljs$lang$arity$variadic = every_pred__4.cljs$lang$arity$variadic;
  return every_pred
}();
cljs.core.some_fn = function() {
  var some_fn = null;
  var some_fn__1 = function(p) {
    return function() {
      var sp1 = null;
      var sp1__0 = function() {
        return null
      };
      var sp1__1 = function(x) {
        return p.call(null, x)
      };
      var sp1__2 = function(x, y) {
        var or__3824__auto____8581 = p.call(null, x);
        if(cljs.core.truth_(or__3824__auto____8581)) {
          return or__3824__auto____8581
        }else {
          return p.call(null, y)
        }
      };
      var sp1__3 = function(x, y, z) {
        var or__3824__auto____8582 = p.call(null, x);
        if(cljs.core.truth_(or__3824__auto____8582)) {
          return or__3824__auto____8582
        }else {
          var or__3824__auto____8583 = p.call(null, y);
          if(cljs.core.truth_(or__3824__auto____8583)) {
            return or__3824__auto____8583
          }else {
            return p.call(null, z)
          }
        }
      };
      var sp1__4 = function() {
        var G__8652__delegate = function(x, y, z, args) {
          var or__3824__auto____8584 = sp1.call(null, x, y, z);
          if(cljs.core.truth_(or__3824__auto____8584)) {
            return or__3824__auto____8584
          }else {
            return cljs.core.some.call(null, p, args)
          }
        };
        var G__8652 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__8652__delegate.call(this, x, y, z, args)
        };
        G__8652.cljs$lang$maxFixedArity = 3;
        G__8652.cljs$lang$applyTo = function(arglist__8653) {
          var x = cljs.core.first(arglist__8653);
          var y = cljs.core.first(cljs.core.next(arglist__8653));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8653)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8653)));
          return G__8652__delegate(x, y, z, args)
        };
        G__8652.cljs$lang$arity$variadic = G__8652__delegate;
        return G__8652
      }();
      sp1 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp1__0.call(this);
          case 1:
            return sp1__1.call(this, x);
          case 2:
            return sp1__2.call(this, x, y);
          case 3:
            return sp1__3.call(this, x, y, z);
          default:
            return sp1__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp1.cljs$lang$maxFixedArity = 3;
      sp1.cljs$lang$applyTo = sp1__4.cljs$lang$applyTo;
      sp1.cljs$lang$arity$0 = sp1__0;
      sp1.cljs$lang$arity$1 = sp1__1;
      sp1.cljs$lang$arity$2 = sp1__2;
      sp1.cljs$lang$arity$3 = sp1__3;
      sp1.cljs$lang$arity$variadic = sp1__4.cljs$lang$arity$variadic;
      return sp1
    }()
  };
  var some_fn__2 = function(p1, p2) {
    return function() {
      var sp2 = null;
      var sp2__0 = function() {
        return null
      };
      var sp2__1 = function(x) {
        var or__3824__auto____8596 = p1.call(null, x);
        if(cljs.core.truth_(or__3824__auto____8596)) {
          return or__3824__auto____8596
        }else {
          return p2.call(null, x)
        }
      };
      var sp2__2 = function(x, y) {
        var or__3824__auto____8597 = p1.call(null, x);
        if(cljs.core.truth_(or__3824__auto____8597)) {
          return or__3824__auto____8597
        }else {
          var or__3824__auto____8598 = p1.call(null, y);
          if(cljs.core.truth_(or__3824__auto____8598)) {
            return or__3824__auto____8598
          }else {
            var or__3824__auto____8599 = p2.call(null, x);
            if(cljs.core.truth_(or__3824__auto____8599)) {
              return or__3824__auto____8599
            }else {
              return p2.call(null, y)
            }
          }
        }
      };
      var sp2__3 = function(x, y, z) {
        var or__3824__auto____8600 = p1.call(null, x);
        if(cljs.core.truth_(or__3824__auto____8600)) {
          return or__3824__auto____8600
        }else {
          var or__3824__auto____8601 = p1.call(null, y);
          if(cljs.core.truth_(or__3824__auto____8601)) {
            return or__3824__auto____8601
          }else {
            var or__3824__auto____8602 = p1.call(null, z);
            if(cljs.core.truth_(or__3824__auto____8602)) {
              return or__3824__auto____8602
            }else {
              var or__3824__auto____8603 = p2.call(null, x);
              if(cljs.core.truth_(or__3824__auto____8603)) {
                return or__3824__auto____8603
              }else {
                var or__3824__auto____8604 = p2.call(null, y);
                if(cljs.core.truth_(or__3824__auto____8604)) {
                  return or__3824__auto____8604
                }else {
                  return p2.call(null, z)
                }
              }
            }
          }
        }
      };
      var sp2__4 = function() {
        var G__8654__delegate = function(x, y, z, args) {
          var or__3824__auto____8605 = sp2.call(null, x, y, z);
          if(cljs.core.truth_(or__3824__auto____8605)) {
            return or__3824__auto____8605
          }else {
            return cljs.core.some.call(null, function(p1__8335_SHARP_) {
              var or__3824__auto____8606 = p1.call(null, p1__8335_SHARP_);
              if(cljs.core.truth_(or__3824__auto____8606)) {
                return or__3824__auto____8606
              }else {
                return p2.call(null, p1__8335_SHARP_)
              }
            }, args)
          }
        };
        var G__8654 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__8654__delegate.call(this, x, y, z, args)
        };
        G__8654.cljs$lang$maxFixedArity = 3;
        G__8654.cljs$lang$applyTo = function(arglist__8655) {
          var x = cljs.core.first(arglist__8655);
          var y = cljs.core.first(cljs.core.next(arglist__8655));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8655)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8655)));
          return G__8654__delegate(x, y, z, args)
        };
        G__8654.cljs$lang$arity$variadic = G__8654__delegate;
        return G__8654
      }();
      sp2 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp2__0.call(this);
          case 1:
            return sp2__1.call(this, x);
          case 2:
            return sp2__2.call(this, x, y);
          case 3:
            return sp2__3.call(this, x, y, z);
          default:
            return sp2__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp2.cljs$lang$maxFixedArity = 3;
      sp2.cljs$lang$applyTo = sp2__4.cljs$lang$applyTo;
      sp2.cljs$lang$arity$0 = sp2__0;
      sp2.cljs$lang$arity$1 = sp2__1;
      sp2.cljs$lang$arity$2 = sp2__2;
      sp2.cljs$lang$arity$3 = sp2__3;
      sp2.cljs$lang$arity$variadic = sp2__4.cljs$lang$arity$variadic;
      return sp2
    }()
  };
  var some_fn__3 = function(p1, p2, p3) {
    return function() {
      var sp3 = null;
      var sp3__0 = function() {
        return null
      };
      var sp3__1 = function(x) {
        var or__3824__auto____8625 = p1.call(null, x);
        if(cljs.core.truth_(or__3824__auto____8625)) {
          return or__3824__auto____8625
        }else {
          var or__3824__auto____8626 = p2.call(null, x);
          if(cljs.core.truth_(or__3824__auto____8626)) {
            return or__3824__auto____8626
          }else {
            return p3.call(null, x)
          }
        }
      };
      var sp3__2 = function(x, y) {
        var or__3824__auto____8627 = p1.call(null, x);
        if(cljs.core.truth_(or__3824__auto____8627)) {
          return or__3824__auto____8627
        }else {
          var or__3824__auto____8628 = p2.call(null, x);
          if(cljs.core.truth_(or__3824__auto____8628)) {
            return or__3824__auto____8628
          }else {
            var or__3824__auto____8629 = p3.call(null, x);
            if(cljs.core.truth_(or__3824__auto____8629)) {
              return or__3824__auto____8629
            }else {
              var or__3824__auto____8630 = p1.call(null, y);
              if(cljs.core.truth_(or__3824__auto____8630)) {
                return or__3824__auto____8630
              }else {
                var or__3824__auto____8631 = p2.call(null, y);
                if(cljs.core.truth_(or__3824__auto____8631)) {
                  return or__3824__auto____8631
                }else {
                  return p3.call(null, y)
                }
              }
            }
          }
        }
      };
      var sp3__3 = function(x, y, z) {
        var or__3824__auto____8632 = p1.call(null, x);
        if(cljs.core.truth_(or__3824__auto____8632)) {
          return or__3824__auto____8632
        }else {
          var or__3824__auto____8633 = p2.call(null, x);
          if(cljs.core.truth_(or__3824__auto____8633)) {
            return or__3824__auto____8633
          }else {
            var or__3824__auto____8634 = p3.call(null, x);
            if(cljs.core.truth_(or__3824__auto____8634)) {
              return or__3824__auto____8634
            }else {
              var or__3824__auto____8635 = p1.call(null, y);
              if(cljs.core.truth_(or__3824__auto____8635)) {
                return or__3824__auto____8635
              }else {
                var or__3824__auto____8636 = p2.call(null, y);
                if(cljs.core.truth_(or__3824__auto____8636)) {
                  return or__3824__auto____8636
                }else {
                  var or__3824__auto____8637 = p3.call(null, y);
                  if(cljs.core.truth_(or__3824__auto____8637)) {
                    return or__3824__auto____8637
                  }else {
                    var or__3824__auto____8638 = p1.call(null, z);
                    if(cljs.core.truth_(or__3824__auto____8638)) {
                      return or__3824__auto____8638
                    }else {
                      var or__3824__auto____8639 = p2.call(null, z);
                      if(cljs.core.truth_(or__3824__auto____8639)) {
                        return or__3824__auto____8639
                      }else {
                        return p3.call(null, z)
                      }
                    }
                  }
                }
              }
            }
          }
        }
      };
      var sp3__4 = function() {
        var G__8656__delegate = function(x, y, z, args) {
          var or__3824__auto____8640 = sp3.call(null, x, y, z);
          if(cljs.core.truth_(or__3824__auto____8640)) {
            return or__3824__auto____8640
          }else {
            return cljs.core.some.call(null, function(p1__8336_SHARP_) {
              var or__3824__auto____8641 = p1.call(null, p1__8336_SHARP_);
              if(cljs.core.truth_(or__3824__auto____8641)) {
                return or__3824__auto____8641
              }else {
                var or__3824__auto____8642 = p2.call(null, p1__8336_SHARP_);
                if(cljs.core.truth_(or__3824__auto____8642)) {
                  return or__3824__auto____8642
                }else {
                  return p3.call(null, p1__8336_SHARP_)
                }
              }
            }, args)
          }
        };
        var G__8656 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__8656__delegate.call(this, x, y, z, args)
        };
        G__8656.cljs$lang$maxFixedArity = 3;
        G__8656.cljs$lang$applyTo = function(arglist__8657) {
          var x = cljs.core.first(arglist__8657);
          var y = cljs.core.first(cljs.core.next(arglist__8657));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8657)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8657)));
          return G__8656__delegate(x, y, z, args)
        };
        G__8656.cljs$lang$arity$variadic = G__8656__delegate;
        return G__8656
      }();
      sp3 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return sp3__0.call(this);
          case 1:
            return sp3__1.call(this, x);
          case 2:
            return sp3__2.call(this, x, y);
          case 3:
            return sp3__3.call(this, x, y, z);
          default:
            return sp3__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      sp3.cljs$lang$maxFixedArity = 3;
      sp3.cljs$lang$applyTo = sp3__4.cljs$lang$applyTo;
      sp3.cljs$lang$arity$0 = sp3__0;
      sp3.cljs$lang$arity$1 = sp3__1;
      sp3.cljs$lang$arity$2 = sp3__2;
      sp3.cljs$lang$arity$3 = sp3__3;
      sp3.cljs$lang$arity$variadic = sp3__4.cljs$lang$arity$variadic;
      return sp3
    }()
  };
  var some_fn__4 = function() {
    var G__8658__delegate = function(p1, p2, p3, ps) {
      var ps__8643 = cljs.core.list_STAR_.call(null, p1, p2, p3, ps);
      return function() {
        var spn = null;
        var spn__0 = function() {
          return null
        };
        var spn__1 = function(x) {
          return cljs.core.some.call(null, function(p1__8337_SHARP_) {
            return p1__8337_SHARP_.call(null, x)
          }, ps__8643)
        };
        var spn__2 = function(x, y) {
          return cljs.core.some.call(null, function(p1__8338_SHARP_) {
            var or__3824__auto____8648 = p1__8338_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3824__auto____8648)) {
              return or__3824__auto____8648
            }else {
              return p1__8338_SHARP_.call(null, y)
            }
          }, ps__8643)
        };
        var spn__3 = function(x, y, z) {
          return cljs.core.some.call(null, function(p1__8339_SHARP_) {
            var or__3824__auto____8649 = p1__8339_SHARP_.call(null, x);
            if(cljs.core.truth_(or__3824__auto____8649)) {
              return or__3824__auto____8649
            }else {
              var or__3824__auto____8650 = p1__8339_SHARP_.call(null, y);
              if(cljs.core.truth_(or__3824__auto____8650)) {
                return or__3824__auto____8650
              }else {
                return p1__8339_SHARP_.call(null, z)
              }
            }
          }, ps__8643)
        };
        var spn__4 = function() {
          var G__8659__delegate = function(x, y, z, args) {
            var or__3824__auto____8651 = spn.call(null, x, y, z);
            if(cljs.core.truth_(or__3824__auto____8651)) {
              return or__3824__auto____8651
            }else {
              return cljs.core.some.call(null, function(p1__8340_SHARP_) {
                return cljs.core.some.call(null, p1__8340_SHARP_, args)
              }, ps__8643)
            }
          };
          var G__8659 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__8659__delegate.call(this, x, y, z, args)
          };
          G__8659.cljs$lang$maxFixedArity = 3;
          G__8659.cljs$lang$applyTo = function(arglist__8660) {
            var x = cljs.core.first(arglist__8660);
            var y = cljs.core.first(cljs.core.next(arglist__8660));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8660)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8660)));
            return G__8659__delegate(x, y, z, args)
          };
          G__8659.cljs$lang$arity$variadic = G__8659__delegate;
          return G__8659
        }();
        spn = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return spn__0.call(this);
            case 1:
              return spn__1.call(this, x);
            case 2:
              return spn__2.call(this, x, y);
            case 3:
              return spn__3.call(this, x, y, z);
            default:
              return spn__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        spn.cljs$lang$maxFixedArity = 3;
        spn.cljs$lang$applyTo = spn__4.cljs$lang$applyTo;
        spn.cljs$lang$arity$0 = spn__0;
        spn.cljs$lang$arity$1 = spn__1;
        spn.cljs$lang$arity$2 = spn__2;
        spn.cljs$lang$arity$3 = spn__3;
        spn.cljs$lang$arity$variadic = spn__4.cljs$lang$arity$variadic;
        return spn
      }()
    };
    var G__8658 = function(p1, p2, p3, var_args) {
      var ps = null;
      if(goog.isDef(var_args)) {
        ps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__8658__delegate.call(this, p1, p2, p3, ps)
    };
    G__8658.cljs$lang$maxFixedArity = 3;
    G__8658.cljs$lang$applyTo = function(arglist__8661) {
      var p1 = cljs.core.first(arglist__8661);
      var p2 = cljs.core.first(cljs.core.next(arglist__8661));
      var p3 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8661)));
      var ps = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8661)));
      return G__8658__delegate(p1, p2, p3, ps)
    };
    G__8658.cljs$lang$arity$variadic = G__8658__delegate;
    return G__8658
  }();
  some_fn = function(p1, p2, p3, var_args) {
    var ps = var_args;
    switch(arguments.length) {
      case 1:
        return some_fn__1.call(this, p1);
      case 2:
        return some_fn__2.call(this, p1, p2);
      case 3:
        return some_fn__3.call(this, p1, p2, p3);
      default:
        return some_fn__4.cljs$lang$arity$variadic(p1, p2, p3, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  some_fn.cljs$lang$maxFixedArity = 3;
  some_fn.cljs$lang$applyTo = some_fn__4.cljs$lang$applyTo;
  some_fn.cljs$lang$arity$1 = some_fn__1;
  some_fn.cljs$lang$arity$2 = some_fn__2;
  some_fn.cljs$lang$arity$3 = some_fn__3;
  some_fn.cljs$lang$arity$variadic = some_fn__4.cljs$lang$arity$variadic;
  return some_fn
}();
cljs.core.map = function() {
  var map = null;
  var map__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____8680 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____8680) {
        var s__8681 = temp__3974__auto____8680;
        if(cljs.core.chunked_seq_QMARK_.call(null, s__8681)) {
          var c__8682 = cljs.core.chunk_first.call(null, s__8681);
          var size__8683 = cljs.core.count.call(null, c__8682);
          var b__8684 = cljs.core.chunk_buffer.call(null, size__8683);
          var n__2622__auto____8685 = size__8683;
          var i__8686 = 0;
          while(true) {
            if(i__8686 < n__2622__auto____8685) {
              cljs.core.chunk_append.call(null, b__8684, f.call(null, cljs.core._nth.call(null, c__8682, i__8686)));
              var G__8698 = i__8686 + 1;
              i__8686 = G__8698;
              continue
            }else {
            }
            break
          }
          return cljs.core.chunk_cons.call(null, cljs.core.chunk.call(null, b__8684), map.call(null, f, cljs.core.chunk_rest.call(null, s__8681)))
        }else {
          return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s__8681)), map.call(null, f, cljs.core.rest.call(null, s__8681)))
        }
      }else {
        return null
      }
    }, null)
  };
  var map__3 = function(f, c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__8687 = cljs.core.seq.call(null, c1);
      var s2__8688 = cljs.core.seq.call(null, c2);
      if(function() {
        var and__3822__auto____8689 = s1__8687;
        if(and__3822__auto____8689) {
          return s2__8688
        }else {
          return and__3822__auto____8689
        }
      }()) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__8687), cljs.core.first.call(null, s2__8688)), map.call(null, f, cljs.core.rest.call(null, s1__8687), cljs.core.rest.call(null, s2__8688)))
      }else {
        return null
      }
    }, null)
  };
  var map__4 = function(f, c1, c2, c3) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__8690 = cljs.core.seq.call(null, c1);
      var s2__8691 = cljs.core.seq.call(null, c2);
      var s3__8692 = cljs.core.seq.call(null, c3);
      if(function() {
        var and__3822__auto____8693 = s1__8690;
        if(and__3822__auto____8693) {
          var and__3822__auto____8694 = s2__8691;
          if(and__3822__auto____8694) {
            return s3__8692
          }else {
            return and__3822__auto____8694
          }
        }else {
          return and__3822__auto____8693
        }
      }()) {
        return cljs.core.cons.call(null, f.call(null, cljs.core.first.call(null, s1__8690), cljs.core.first.call(null, s2__8691), cljs.core.first.call(null, s3__8692)), map.call(null, f, cljs.core.rest.call(null, s1__8690), cljs.core.rest.call(null, s2__8691), cljs.core.rest.call(null, s3__8692)))
      }else {
        return null
      }
    }, null)
  };
  var map__5 = function() {
    var G__8699__delegate = function(f, c1, c2, c3, colls) {
      var step__8697 = function step(cs) {
        return new cljs.core.LazySeq(null, false, function() {
          var ss__8696 = map.call(null, cljs.core.seq, cs);
          if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__8696)) {
            return cljs.core.cons.call(null, map.call(null, cljs.core.first, ss__8696), step.call(null, map.call(null, cljs.core.rest, ss__8696)))
          }else {
            return null
          }
        }, null)
      };
      return map.call(null, function(p1__8501_SHARP_) {
        return cljs.core.apply.call(null, f, p1__8501_SHARP_)
      }, step__8697.call(null, cljs.core.conj.call(null, colls, c3, c2, c1)))
    };
    var G__8699 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__8699__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__8699.cljs$lang$maxFixedArity = 4;
    G__8699.cljs$lang$applyTo = function(arglist__8700) {
      var f = cljs.core.first(arglist__8700);
      var c1 = cljs.core.first(cljs.core.next(arglist__8700));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8700)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__8700))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__8700))));
      return G__8699__delegate(f, c1, c2, c3, colls)
    };
    G__8699.cljs$lang$arity$variadic = G__8699__delegate;
    return G__8699
  }();
  map = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return map__2.call(this, f, c1);
      case 3:
        return map__3.call(this, f, c1, c2);
      case 4:
        return map__4.call(this, f, c1, c2, c3);
      default:
        return map__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  map.cljs$lang$maxFixedArity = 4;
  map.cljs$lang$applyTo = map__5.cljs$lang$applyTo;
  map.cljs$lang$arity$2 = map__2;
  map.cljs$lang$arity$3 = map__3;
  map.cljs$lang$arity$4 = map__4;
  map.cljs$lang$arity$variadic = map__5.cljs$lang$arity$variadic;
  return map
}();
cljs.core.take = function take(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    if(n > 0) {
      var temp__3974__auto____8703 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____8703) {
        var s__8704 = temp__3974__auto____8703;
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__8704), take.call(null, n - 1, cljs.core.rest.call(null, s__8704)))
      }else {
        return null
      }
    }else {
      return null
    }
  }, null)
};
cljs.core.drop = function drop(n, coll) {
  var step__8710 = function(n, coll) {
    while(true) {
      var s__8708 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3822__auto____8709 = n > 0;
        if(and__3822__auto____8709) {
          return s__8708
        }else {
          return and__3822__auto____8709
        }
      }())) {
        var G__8711 = n - 1;
        var G__8712 = cljs.core.rest.call(null, s__8708);
        n = G__8711;
        coll = G__8712;
        continue
      }else {
        return s__8708
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__8710.call(null, n, coll)
  }, null)
};
cljs.core.drop_last = function() {
  var drop_last = null;
  var drop_last__1 = function(s) {
    return drop_last.call(null, 1, s)
  };
  var drop_last__2 = function(n, s) {
    return cljs.core.map.call(null, function(x, _) {
      return x
    }, s, cljs.core.drop.call(null, n, s))
  };
  drop_last = function(n, s) {
    switch(arguments.length) {
      case 1:
        return drop_last__1.call(this, n);
      case 2:
        return drop_last__2.call(this, n, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  drop_last.cljs$lang$arity$1 = drop_last__1;
  drop_last.cljs$lang$arity$2 = drop_last__2;
  return drop_last
}();
cljs.core.take_last = function take_last(n, coll) {
  var s__8715 = cljs.core.seq.call(null, coll);
  var lead__8716 = cljs.core.seq.call(null, cljs.core.drop.call(null, n, coll));
  while(true) {
    if(lead__8716) {
      var G__8717 = cljs.core.next.call(null, s__8715);
      var G__8718 = cljs.core.next.call(null, lead__8716);
      s__8715 = G__8717;
      lead__8716 = G__8718;
      continue
    }else {
      return s__8715
    }
    break
  }
};
cljs.core.drop_while = function drop_while(pred, coll) {
  var step__8724 = function(pred, coll) {
    while(true) {
      var s__8722 = cljs.core.seq.call(null, coll);
      if(cljs.core.truth_(function() {
        var and__3822__auto____8723 = s__8722;
        if(and__3822__auto____8723) {
          return pred.call(null, cljs.core.first.call(null, s__8722))
        }else {
          return and__3822__auto____8723
        }
      }())) {
        var G__8725 = pred;
        var G__8726 = cljs.core.rest.call(null, s__8722);
        pred = G__8725;
        coll = G__8726;
        continue
      }else {
        return s__8722
      }
      break
    }
  };
  return new cljs.core.LazySeq(null, false, function() {
    return step__8724.call(null, pred, coll)
  }, null)
};
cljs.core.cycle = function cycle(coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3974__auto____8729 = cljs.core.seq.call(null, coll);
    if(temp__3974__auto____8729) {
      var s__8730 = temp__3974__auto____8729;
      return cljs.core.concat.call(null, s__8730, cycle.call(null, s__8730))
    }else {
      return null
    }
  }, null)
};
cljs.core.split_at = function split_at(n, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take.call(null, n, coll), cljs.core.drop.call(null, n, coll)], true)
};
cljs.core.repeat = function() {
  var repeat = null;
  var repeat__1 = function(x) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, x, repeat.call(null, x))
    }, null)
  };
  var repeat__2 = function(n, x) {
    return cljs.core.take.call(null, n, repeat.call(null, x))
  };
  repeat = function(n, x) {
    switch(arguments.length) {
      case 1:
        return repeat__1.call(this, n);
      case 2:
        return repeat__2.call(this, n, x)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeat.cljs$lang$arity$1 = repeat__1;
  repeat.cljs$lang$arity$2 = repeat__2;
  return repeat
}();
cljs.core.replicate = function replicate(n, x) {
  return cljs.core.take.call(null, n, cljs.core.repeat.call(null, x))
};
cljs.core.repeatedly = function() {
  var repeatedly = null;
  var repeatedly__1 = function(f) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, f.call(null), repeatedly.call(null, f))
    }, null)
  };
  var repeatedly__2 = function(n, f) {
    return cljs.core.take.call(null, n, repeatedly.call(null, f))
  };
  repeatedly = function(n, f) {
    switch(arguments.length) {
      case 1:
        return repeatedly__1.call(this, n);
      case 2:
        return repeatedly__2.call(this, n, f)
    }
    throw"Invalid arity: " + arguments.length;
  };
  repeatedly.cljs$lang$arity$1 = repeatedly__1;
  repeatedly.cljs$lang$arity$2 = repeatedly__2;
  return repeatedly
}();
cljs.core.iterate = function iterate(f, x) {
  return cljs.core.cons.call(null, x, new cljs.core.LazySeq(null, false, function() {
    return iterate.call(null, f, f.call(null, x))
  }, null))
};
cljs.core.interleave = function() {
  var interleave = null;
  var interleave__2 = function(c1, c2) {
    return new cljs.core.LazySeq(null, false, function() {
      var s1__8735 = cljs.core.seq.call(null, c1);
      var s2__8736 = cljs.core.seq.call(null, c2);
      if(function() {
        var and__3822__auto____8737 = s1__8735;
        if(and__3822__auto____8737) {
          return s2__8736
        }else {
          return and__3822__auto____8737
        }
      }()) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s1__8735), cljs.core.cons.call(null, cljs.core.first.call(null, s2__8736), interleave.call(null, cljs.core.rest.call(null, s1__8735), cljs.core.rest.call(null, s2__8736))))
      }else {
        return null
      }
    }, null)
  };
  var interleave__3 = function() {
    var G__8739__delegate = function(c1, c2, colls) {
      return new cljs.core.LazySeq(null, false, function() {
        var ss__8738 = cljs.core.map.call(null, cljs.core.seq, cljs.core.conj.call(null, colls, c2, c1));
        if(cljs.core.every_QMARK_.call(null, cljs.core.identity, ss__8738)) {
          return cljs.core.concat.call(null, cljs.core.map.call(null, cljs.core.first, ss__8738), cljs.core.apply.call(null, interleave, cljs.core.map.call(null, cljs.core.rest, ss__8738)))
        }else {
          return null
        }
      }, null)
    };
    var G__8739 = function(c1, c2, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__8739__delegate.call(this, c1, c2, colls)
    };
    G__8739.cljs$lang$maxFixedArity = 2;
    G__8739.cljs$lang$applyTo = function(arglist__8740) {
      var c1 = cljs.core.first(arglist__8740);
      var c2 = cljs.core.first(cljs.core.next(arglist__8740));
      var colls = cljs.core.rest(cljs.core.next(arglist__8740));
      return G__8739__delegate(c1, c2, colls)
    };
    G__8739.cljs$lang$arity$variadic = G__8739__delegate;
    return G__8739
  }();
  interleave = function(c1, c2, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return interleave__2.call(this, c1, c2);
      default:
        return interleave__3.cljs$lang$arity$variadic(c1, c2, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  interleave.cljs$lang$maxFixedArity = 2;
  interleave.cljs$lang$applyTo = interleave__3.cljs$lang$applyTo;
  interleave.cljs$lang$arity$2 = interleave__2;
  interleave.cljs$lang$arity$variadic = interleave__3.cljs$lang$arity$variadic;
  return interleave
}();
cljs.core.interpose = function interpose(sep, coll) {
  return cljs.core.drop.call(null, 1, cljs.core.interleave.call(null, cljs.core.repeat.call(null, sep), coll))
};
cljs.core.flatten1 = function flatten1(colls) {
  var cat__8750 = function cat(coll, colls) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3971__auto____8748 = cljs.core.seq.call(null, coll);
      if(temp__3971__auto____8748) {
        var coll__8749 = temp__3971__auto____8748;
        return cljs.core.cons.call(null, cljs.core.first.call(null, coll__8749), cat.call(null, cljs.core.rest.call(null, coll__8749), colls))
      }else {
        if(cljs.core.seq.call(null, colls)) {
          return cat.call(null, cljs.core.first.call(null, colls), cljs.core.rest.call(null, colls))
        }else {
          return null
        }
      }
    }, null)
  };
  return cat__8750.call(null, null, colls)
};
cljs.core.mapcat = function() {
  var mapcat = null;
  var mapcat__2 = function(f, coll) {
    return cljs.core.flatten1.call(null, cljs.core.map.call(null, f, coll))
  };
  var mapcat__3 = function() {
    var G__8751__delegate = function(f, coll, colls) {
      return cljs.core.flatten1.call(null, cljs.core.apply.call(null, cljs.core.map, f, coll, colls))
    };
    var G__8751 = function(f, coll, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
      }
      return G__8751__delegate.call(this, f, coll, colls)
    };
    G__8751.cljs$lang$maxFixedArity = 2;
    G__8751.cljs$lang$applyTo = function(arglist__8752) {
      var f = cljs.core.first(arglist__8752);
      var coll = cljs.core.first(cljs.core.next(arglist__8752));
      var colls = cljs.core.rest(cljs.core.next(arglist__8752));
      return G__8751__delegate(f, coll, colls)
    };
    G__8751.cljs$lang$arity$variadic = G__8751__delegate;
    return G__8751
  }();
  mapcat = function(f, coll, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapcat__2.call(this, f, coll);
      default:
        return mapcat__3.cljs$lang$arity$variadic(f, coll, cljs.core.array_seq(arguments, 2))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapcat.cljs$lang$maxFixedArity = 2;
  mapcat.cljs$lang$applyTo = mapcat__3.cljs$lang$applyTo;
  mapcat.cljs$lang$arity$2 = mapcat__2;
  mapcat.cljs$lang$arity$variadic = mapcat__3.cljs$lang$arity$variadic;
  return mapcat
}();
cljs.core.filter = function filter(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3974__auto____8762 = cljs.core.seq.call(null, coll);
    if(temp__3974__auto____8762) {
      var s__8763 = temp__3974__auto____8762;
      if(cljs.core.chunked_seq_QMARK_.call(null, s__8763)) {
        var c__8764 = cljs.core.chunk_first.call(null, s__8763);
        var size__8765 = cljs.core.count.call(null, c__8764);
        var b__8766 = cljs.core.chunk_buffer.call(null, size__8765);
        var n__2622__auto____8767 = size__8765;
        var i__8768 = 0;
        while(true) {
          if(i__8768 < n__2622__auto____8767) {
            if(cljs.core.truth_(pred.call(null, cljs.core._nth.call(null, c__8764, i__8768)))) {
              cljs.core.chunk_append.call(null, b__8766, cljs.core._nth.call(null, c__8764, i__8768))
            }else {
            }
            var G__8771 = i__8768 + 1;
            i__8768 = G__8771;
            continue
          }else {
          }
          break
        }
        return cljs.core.chunk_cons.call(null, cljs.core.chunk.call(null, b__8766), filter.call(null, pred, cljs.core.chunk_rest.call(null, s__8763)))
      }else {
        var f__8769 = cljs.core.first.call(null, s__8763);
        var r__8770 = cljs.core.rest.call(null, s__8763);
        if(cljs.core.truth_(pred.call(null, f__8769))) {
          return cljs.core.cons.call(null, f__8769, filter.call(null, pred, r__8770))
        }else {
          return filter.call(null, pred, r__8770)
        }
      }
    }else {
      return null
    }
  }, null)
};
cljs.core.remove = function remove(pred, coll) {
  return cljs.core.filter.call(null, cljs.core.complement.call(null, pred), coll)
};
cljs.core.tree_seq = function tree_seq(branch_QMARK_, children, root) {
  var walk__8774 = function walk(node) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, node, cljs.core.truth_(branch_QMARK_.call(null, node)) ? cljs.core.mapcat.call(null, walk, children.call(null, node)) : null)
    }, null)
  };
  return walk__8774.call(null, root)
};
cljs.core.flatten = function flatten(x) {
  return cljs.core.filter.call(null, function(p1__8772_SHARP_) {
    return!cljs.core.sequential_QMARK_.call(null, p1__8772_SHARP_)
  }, cljs.core.rest.call(null, cljs.core.tree_seq.call(null, cljs.core.sequential_QMARK_, cljs.core.seq, x)))
};
cljs.core.into = function into(to, from) {
  if(function() {
    var G__8778__8779 = to;
    if(G__8778__8779) {
      if(function() {
        var or__3824__auto____8780 = G__8778__8779.cljs$lang$protocol_mask$partition1$ & 1;
        if(or__3824__auto____8780) {
          return or__3824__auto____8780
        }else {
          return G__8778__8779.cljs$core$IEditableCollection$
        }
      }()) {
        return true
      }else {
        if(!G__8778__8779.cljs$lang$protocol_mask$partition1$) {
          return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__8778__8779)
        }else {
          return false
        }
      }
    }else {
      return cljs.core.type_satisfies_.call(null, cljs.core.IEditableCollection, G__8778__8779)
    }
  }()) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, cljs.core._conj_BANG_, cljs.core.transient$.call(null, to), from))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, to, from)
  }
};
cljs.core.mapv = function() {
  var mapv = null;
  var mapv__2 = function(f, coll) {
    return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
      return cljs.core.conj_BANG_.call(null, v, f.call(null, o))
    }, cljs.core.transient$.call(null, cljs.core.PersistentVector.EMPTY), coll))
  };
  var mapv__3 = function(f, c1, c2) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.EMPTY, cljs.core.map.call(null, f, c1, c2))
  };
  var mapv__4 = function(f, c1, c2, c3) {
    return cljs.core.into.call(null, cljs.core.PersistentVector.EMPTY, cljs.core.map.call(null, f, c1, c2, c3))
  };
  var mapv__5 = function() {
    var G__8781__delegate = function(f, c1, c2, c3, colls) {
      return cljs.core.into.call(null, cljs.core.PersistentVector.EMPTY, cljs.core.apply.call(null, cljs.core.map, f, c1, c2, c3, colls))
    };
    var G__8781 = function(f, c1, c2, c3, var_args) {
      var colls = null;
      if(goog.isDef(var_args)) {
        colls = cljs.core.array_seq(Array.prototype.slice.call(arguments, 4), 0)
      }
      return G__8781__delegate.call(this, f, c1, c2, c3, colls)
    };
    G__8781.cljs$lang$maxFixedArity = 4;
    G__8781.cljs$lang$applyTo = function(arglist__8782) {
      var f = cljs.core.first(arglist__8782);
      var c1 = cljs.core.first(cljs.core.next(arglist__8782));
      var c2 = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8782)));
      var c3 = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__8782))));
      var colls = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(arglist__8782))));
      return G__8781__delegate(f, c1, c2, c3, colls)
    };
    G__8781.cljs$lang$arity$variadic = G__8781__delegate;
    return G__8781
  }();
  mapv = function(f, c1, c2, c3, var_args) {
    var colls = var_args;
    switch(arguments.length) {
      case 2:
        return mapv__2.call(this, f, c1);
      case 3:
        return mapv__3.call(this, f, c1, c2);
      case 4:
        return mapv__4.call(this, f, c1, c2, c3);
      default:
        return mapv__5.cljs$lang$arity$variadic(f, c1, c2, c3, cljs.core.array_seq(arguments, 4))
    }
    throw"Invalid arity: " + arguments.length;
  };
  mapv.cljs$lang$maxFixedArity = 4;
  mapv.cljs$lang$applyTo = mapv__5.cljs$lang$applyTo;
  mapv.cljs$lang$arity$2 = mapv__2;
  mapv.cljs$lang$arity$3 = mapv__3;
  mapv.cljs$lang$arity$4 = mapv__4;
  mapv.cljs$lang$arity$variadic = mapv__5.cljs$lang$arity$variadic;
  return mapv
}();
cljs.core.filterv = function filterv(pred, coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(v, o) {
    if(cljs.core.truth_(pred.call(null, o))) {
      return cljs.core.conj_BANG_.call(null, v, o)
    }else {
      return v
    }
  }, cljs.core.transient$.call(null, cljs.core.PersistentVector.EMPTY), coll))
};
cljs.core.partition = function() {
  var partition = null;
  var partition__2 = function(n, coll) {
    return partition.call(null, n, n, coll)
  };
  var partition__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____8789 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____8789) {
        var s__8790 = temp__3974__auto____8789;
        var p__8791 = cljs.core.take.call(null, n, s__8790);
        if(n === cljs.core.count.call(null, p__8791)) {
          return cljs.core.cons.call(null, p__8791, partition.call(null, n, step, cljs.core.drop.call(null, step, s__8790)))
        }else {
          return null
        }
      }else {
        return null
      }
    }, null)
  };
  var partition__4 = function(n, step, pad, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____8792 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____8792) {
        var s__8793 = temp__3974__auto____8792;
        var p__8794 = cljs.core.take.call(null, n, s__8793);
        if(n === cljs.core.count.call(null, p__8794)) {
          return cljs.core.cons.call(null, p__8794, partition.call(null, n, step, pad, cljs.core.drop.call(null, step, s__8793)))
        }else {
          return cljs.core.list.call(null, cljs.core.take.call(null, n, cljs.core.concat.call(null, p__8794, pad)))
        }
      }else {
        return null
      }
    }, null)
  };
  partition = function(n, step, pad, coll) {
    switch(arguments.length) {
      case 2:
        return partition__2.call(this, n, step);
      case 3:
        return partition__3.call(this, n, step, pad);
      case 4:
        return partition__4.call(this, n, step, pad, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition.cljs$lang$arity$2 = partition__2;
  partition.cljs$lang$arity$3 = partition__3;
  partition.cljs$lang$arity$4 = partition__4;
  return partition
}();
cljs.core.get_in = function() {
  var get_in = null;
  var get_in__2 = function(m, ks) {
    return cljs.core.reduce.call(null, cljs.core.get, m, ks)
  };
  var get_in__3 = function(m, ks, not_found) {
    var sentinel__8799 = cljs.core.lookup_sentinel;
    var m__8800 = m;
    var ks__8801 = cljs.core.seq.call(null, ks);
    while(true) {
      if(ks__8801) {
        var m__8802 = cljs.core._lookup.call(null, m__8800, cljs.core.first.call(null, ks__8801), sentinel__8799);
        if(sentinel__8799 === m__8802) {
          return not_found
        }else {
          var G__8803 = sentinel__8799;
          var G__8804 = m__8802;
          var G__8805 = cljs.core.next.call(null, ks__8801);
          sentinel__8799 = G__8803;
          m__8800 = G__8804;
          ks__8801 = G__8805;
          continue
        }
      }else {
        return m__8800
      }
      break
    }
  };
  get_in = function(m, ks, not_found) {
    switch(arguments.length) {
      case 2:
        return get_in__2.call(this, m, ks);
      case 3:
        return get_in__3.call(this, m, ks, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  get_in.cljs$lang$arity$2 = get_in__2;
  get_in.cljs$lang$arity$3 = get_in__3;
  return get_in
}();
cljs.core.assoc_in = function assoc_in(m, p__8806, v) {
  var vec__8811__8812 = p__8806;
  var k__8813 = cljs.core.nth.call(null, vec__8811__8812, 0, null);
  var ks__8814 = cljs.core.nthnext.call(null, vec__8811__8812, 1);
  if(cljs.core.truth_(ks__8814)) {
    return cljs.core.assoc.call(null, m, k__8813, assoc_in.call(null, cljs.core._lookup.call(null, m, k__8813, null), ks__8814, v))
  }else {
    return cljs.core.assoc.call(null, m, k__8813, v)
  }
};
cljs.core.update_in = function() {
  var update_in__delegate = function(m, p__8815, f, args) {
    var vec__8820__8821 = p__8815;
    var k__8822 = cljs.core.nth.call(null, vec__8820__8821, 0, null);
    var ks__8823 = cljs.core.nthnext.call(null, vec__8820__8821, 1);
    if(cljs.core.truth_(ks__8823)) {
      return cljs.core.assoc.call(null, m, k__8822, cljs.core.apply.call(null, update_in, cljs.core._lookup.call(null, m, k__8822, null), ks__8823, f, args))
    }else {
      return cljs.core.assoc.call(null, m, k__8822, cljs.core.apply.call(null, f, cljs.core._lookup.call(null, m, k__8822, null), args))
    }
  };
  var update_in = function(m, p__8815, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
    }
    return update_in__delegate.call(this, m, p__8815, f, args)
  };
  update_in.cljs$lang$maxFixedArity = 3;
  update_in.cljs$lang$applyTo = function(arglist__8824) {
    var m = cljs.core.first(arglist__8824);
    var p__8815 = cljs.core.first(cljs.core.next(arglist__8824));
    var f = cljs.core.first(cljs.core.next(cljs.core.next(arglist__8824)));
    var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__8824)));
    return update_in__delegate(m, p__8815, f, args)
  };
  update_in.cljs$lang$arity$variadic = update_in__delegate;
  return update_in
}();
cljs.core.Vector = function(meta, array, __hash) {
  this.meta = meta;
  this.array = array;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32400159
};
cljs.core.Vector.cljs$lang$type = true;
cljs.core.Vector.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/Vector")
};
cljs.core.Vector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__8827 = this;
  var h__2287__auto____8828 = this__8827.__hash;
  if(!(h__2287__auto____8828 == null)) {
    return h__2287__auto____8828
  }else {
    var h__2287__auto____8829 = cljs.core.hash_coll.call(null, coll);
    this__8827.__hash = h__2287__auto____8829;
    return h__2287__auto____8829
  }
};
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__8830 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, null)
};
cljs.core.Vector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__8831 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, not_found)
};
cljs.core.Vector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__8832 = this;
  var new_array__8833 = this__8832.array.slice();
  new_array__8833[k] = v;
  return new cljs.core.Vector(this__8832.meta, new_array__8833, null)
};
cljs.core.Vector.prototype.call = function() {
  var G__8864 = null;
  var G__8864__2 = function(this_sym8834, k) {
    var this__8836 = this;
    var this_sym8834__8837 = this;
    var coll__8838 = this_sym8834__8837;
    return coll__8838.cljs$core$ILookup$_lookup$arity$2(coll__8838, k)
  };
  var G__8864__3 = function(this_sym8835, k, not_found) {
    var this__8836 = this;
    var this_sym8835__8839 = this;
    var coll__8840 = this_sym8835__8839;
    return coll__8840.cljs$core$ILookup$_lookup$arity$3(coll__8840, k, not_found)
  };
  G__8864 = function(this_sym8835, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__8864__2.call(this, this_sym8835, k);
      case 3:
        return G__8864__3.call(this, this_sym8835, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__8864
}();
cljs.core.Vector.prototype.apply = function(this_sym8825, args8826) {
  var this__8841 = this;
  return this_sym8825.call.apply(this_sym8825, [this_sym8825].concat(args8826.slice()))
};
cljs.core.Vector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__8842 = this;
  var new_array__8843 = this__8842.array.slice();
  new_array__8843.push(o);
  return new cljs.core.Vector(this__8842.meta, new_array__8843, null)
};
cljs.core.Vector.prototype.toString = function() {
  var this__8844 = this;
  var this__8845 = this;
  return cljs.core.pr_str.call(null, this__8845)
};
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__8846 = this;
  return cljs.core.ci_reduce.call(null, this__8846.array, f)
};
cljs.core.Vector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__8847 = this;
  return cljs.core.ci_reduce.call(null, this__8847.array, f, start)
};
cljs.core.Vector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__8848 = this;
  if(this__8848.array.length > 0) {
    var vector_seq__8849 = function vector_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < this__8848.array.length) {
          return cljs.core.cons.call(null, this__8848.array[i], vector_seq.call(null, i + 1))
        }else {
          return null
        }
      }, null)
    };
    return vector_seq__8849.call(null, 0)
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__8850 = this;
  return this__8850.array.length
};
cljs.core.Vector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__8851 = this;
  var count__8852 = this__8851.array.length;
  if(count__8852 > 0) {
    return this__8851.array[count__8852 - 1]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__8853 = this;
  if(this__8853.array.length > 0) {
    var new_array__8854 = this__8853.array.slice();
    new_array__8854.pop();
    return new cljs.core.Vector(this__8853.meta, new_array__8854, null)
  }else {
    throw new Error("Can't pop empty vector");
  }
};
cljs.core.Vector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__8855 = this;
  return coll.cljs$core$IAssociative$_assoc$arity$3(coll, n, val)
};
cljs.core.Vector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__8856 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Vector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__8857 = this;
  return new cljs.core.Vector(meta, this__8857.array, this__8857.__hash)
};
cljs.core.Vector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__8858 = this;
  return this__8858.meta
};
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__8859 = this;
  if(function() {
    var and__3822__auto____8860 = 0 <= n;
    if(and__3822__auto____8860) {
      return n < this__8859.array.length
    }else {
      return and__3822__auto____8860
    }
  }()) {
    return this__8859.array[n]
  }else {
    return null
  }
};
cljs.core.Vector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__8861 = this;
  if(function() {
    var and__3822__auto____8862 = 0 <= n;
    if(and__3822__auto____8862) {
      return n < this__8861.array.length
    }else {
      return and__3822__auto____8862
    }
  }()) {
    return this__8861.array[n]
  }else {
    return not_found
  }
};
cljs.core.Vector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__8863 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__8863.meta)
};
cljs.core.Vector;
cljs.core.Vector.EMPTY = new cljs.core.Vector(null, [], 0);
cljs.core.Vector.fromArray = function(xs) {
  return new cljs.core.Vector(null, xs, null)
};
cljs.core.VectorNode = function(edit, arr) {
  this.edit = edit;
  this.arr = arr
};
cljs.core.VectorNode.cljs$lang$type = true;
cljs.core.VectorNode.cljs$lang$ctorPrSeq = function(this__2405__auto__) {
  return cljs.core.list.call(null, "cljs.core/VectorNode")
};
cljs.core.VectorNode;
cljs.core.pv_fresh_node = function pv_fresh_node(edit) {
  return new cljs.core.VectorNode(edit, cljs.core.make_array.call(null, 32))
};
cljs.core.pv_aget = function pv_aget(node, idx) {
  return node.arr[idx]
};
cljs.core.pv_aset = function pv_aset(node, idx, val) {
  return node.arr[idx] = val
};
cljs.core.pv_clone_node = function pv_clone_node(node) {
  return new cljs.core.VectorNode(node.edit, node.arr.slice())
};
cljs.core.tail_off = function tail_off(pv) {
  var cnt__8866 = pv.cnt;
  if(cnt__8866 < 32) {
    return 0
  }else {
    return cnt__8866 - 1 >>> 5 << 5
  }
};
cljs.core.new_path = function new_path(edit, level, node) {
  var ll__8872 = level;
  var ret__8873 = node;
  while(true) {
    if(ll__8872 === 0) {
      return ret__8873
    }else {
      var embed__8874 = ret__8873;
      var r__8875 = cljs.core.pv_fresh_node.call(null, edit);
      var ___8876 = cljs.core.pv_aset.call(null, r__8875, 0, embed__8874);
      var G__8877 = ll__8872 - 5;
      var G__8878 = r__8875;
      ll__8872 = G__8877;
      ret__8873 = G__8878;
      continue
    }
    break
  }
};
cljs.core.push_tail = function push_tail(pv, level, parent, tailnode) {
  var ret__8884 = cljs.core.pv_clone_node.call(null, parent);
  var subidx__8885 = pv.cnt - 1 >>> level & 31;
  if(5 === level) {
    cljs.core.pv_aset.call(null, ret__8884, subidx__8885, tailnode);
    return ret__8884
  }else {
    var child__8886 = cljs.core.pv_aget.call(null, parent, subidx__8885);
    if(!(child__8886 == null)) {
      var node_to_insert__8887 = push_tail.call(null, pv, level - 5, child__8886, tailnode);
      cljs.core.pv_aset.call(null, ret__8884, subidx__8885, node_to_insert__8887);
      return ret__8884
    }else {
      var node_to_insert__8888 = cljs.core.new_path.call(null, null, level - 5, tailnode);
      cljs.core.pv_aset.call(null, ret__8884, subidx__8885, node_to_insert__8888);
      return ret__8884
    }
  }
};
cljs.core.array_for = function array_for(pv, i) {
  if(function() {
    var and__3822__auto____8892 = 0 <= i;
    if(and__3822__auto____8892) {
      return i < pv.cnt
    }else {
      return and__3822__auto____8892
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, pv)) {
      return pv.tail
    }else {
      var node__8893 = pv.root;
      var level__8894 = pv.shift;
      while(true) {
        if(level__8894 > 0) {
          var G__8895 = cljs.core.pv_aget.call(null, node__8893, i >>> level__8894 & 31);
          var G__8896 = level__8894 - 5;
          node__8893 = G__8895;
          level__8894 = G__8896;
          continue
        }else {
          return node__8893.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in vector of length "), cljs.core.str(pv.cnt)].join(""));
  }
};
cljs.core.do_assoc = function do_assoc(pv, level, node, i, val) {
  var ret__8899 = cljs.core.pv_clone_node.call(null, node);
  if(level === 0) {
    cljs.core.pv_aset.call(null, ret__8899, i & 31, val);
    return ret__8899
  }else {
    var subidx__8900 = i >>> level & 31;
    cljs.core.pv_aset.call(null, ret__8899, subidx__8900, do_assoc.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__8900), i, val));
    return ret__8899
  }
};
cljs.core.pop_tail = function pop_tail(pv, level, node) {
  var subidx__8906 = pv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__8907 = pop_tail.call(null, pv, level - 5, cljs.core.pv_aget.call(null, node, subidx__8906));
    if(function() {
      var and__3822__auto____8908 = new_child__8907 == null;
      if(and__3822__auto____8908) {
        return subidx__8906 === 0
      }else {
        return and__3822__auto____8908
      }
    }()) {
      return null
    }else {
      var ret__8909 = cljs.core.pv_clone_node.call(null, node);
      cljs.core.pv_aset.call(null, ret__8909, subidx__8906, new_child__8907);
      return ret__8909
    }
  }else {
    if(subidx__8906 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        var ret__8910 = cljs.core.pv_clone_node.call(null, node);
        cljs.core.pv_aset.call(null, ret__8910, subidx__8906, null);
        return ret__8910
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentVector = function(meta, cnt, shift, root, tail, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 1;
  this.cljs$lang$protocol_mask$partition0$ = 167668511
};
cljs.core.PersistentVector.cljs$lang$type = true;
cljs.core.PersistentVector.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentVector")
};
cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__8913 = this;
  return new cljs.core.TransientVector(this__8913.cnt, this__8913.shift, cljs.core.tv_editable_root.call(null, this__8913.root), cljs.core.tv_editable_tail.call(null, this__8913.tail))
};
cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__8914 = this;
  var h__2287__auto____8915 = this__8914.__hash;
  if(!(h__2287__auto____8915 == null)) {
    return h__2287__auto____8915
  }else {
    var h__2287__auto____8916 = cljs.core.hash_coll.call(null, coll);
    this__8914.__hash = h__2287__auto____8916;
    return h__2287__auto____8916
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__8917 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, null)
};
cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__8918 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, not_found)
};
cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__8919 = this;
  if(function() {
    var and__3822__auto____8920 = 0 <= k;
    if(and__3822__auto____8920) {
      return k < this__8919.cnt
    }else {
      return and__3822__auto____8920
    }
  }()) {
    if(cljs.core.tail_off.call(null, coll) <= k) {
      var new_tail__8921 = this__8919.tail.slice();
      new_tail__8921[k & 31] = v;
      return new cljs.core.PersistentVector(this__8919.meta, this__8919.cnt, this__8919.shift, this__8919.root, new_tail__8921, null)
    }else {
      return new cljs.core.PersistentVector(this__8919.meta, this__8919.cnt, this__8919.shift, cljs.core.do_assoc.call(null, coll, this__8919.shift, this__8919.root, k, v), this__8919.tail, null)
    }
  }else {
    if(k === this__8919.cnt) {
      return coll.cljs$core$ICollection$_conj$arity$2(coll, v)
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Index "), cljs.core.str(k), cljs.core.str(" out of bounds  [0,"), cljs.core.str(this__8919.cnt), cljs.core.str("]")].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentVector.prototype.call = function() {
  var G__8969 = null;
  var G__8969__2 = function(this_sym8922, k) {
    var this__8924 = this;
    var this_sym8922__8925 = this;
    var coll__8926 = this_sym8922__8925;
    return coll__8926.cljs$core$ILookup$_lookup$arity$2(coll__8926, k)
  };
  var G__8969__3 = function(this_sym8923, k, not_found) {
    var this__8924 = this;
    var this_sym8923__8927 = this;
    var coll__8928 = this_sym8923__8927;
    return coll__8928.cljs$core$ILookup$_lookup$arity$3(coll__8928, k, not_found)
  };
  G__8969 = function(this_sym8923, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__8969__2.call(this, this_sym8923, k);
      case 3:
        return G__8969__3.call(this, this_sym8923, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__8969
}();
cljs.core.PersistentVector.prototype.apply = function(this_sym8911, args8912) {
  var this__8929 = this;
  return this_sym8911.call.apply(this_sym8911, [this_sym8911].concat(args8912.slice()))
};
cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(v, f, init) {
  var this__8930 = this;
  var step_init__8931 = [0, init];
  var i__8932 = 0;
  while(true) {
    if(i__8932 < this__8930.cnt) {
      var arr__8933 = cljs.core.array_for.call(null, v, i__8932);
      var len__8934 = arr__8933.length;
      var init__8938 = function() {
        var j__8935 = 0;
        var init__8936 = step_init__8931[1];
        while(true) {
          if(j__8935 < len__8934) {
            var init__8937 = f.call(null, init__8936, j__8935 + i__8932, arr__8933[j__8935]);
            if(cljs.core.reduced_QMARK_.call(null, init__8937)) {
              return init__8937
            }else {
              var G__8970 = j__8935 + 1;
              var G__8971 = init__8937;
              j__8935 = G__8970;
              init__8936 = G__8971;
              continue
            }
          }else {
            step_init__8931[0] = len__8934;
            step_init__8931[1] = init__8936;
            return init__8936
          }
          break
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__8938)) {
        return cljs.core.deref.call(null, init__8938)
      }else {
        var G__8972 = i__8932 + step_init__8931[0];
        i__8932 = G__8972;
        continue
      }
    }else {
      return step_init__8931[1]
    }
    break
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__8939 = this;
  if(this__8939.cnt - cljs.core.tail_off.call(null, coll) < 32) {
    var new_tail__8940 = this__8939.tail.slice();
    new_tail__8940.push(o);
    return new cljs.core.PersistentVector(this__8939.meta, this__8939.cnt + 1, this__8939.shift, this__8939.root, new_tail__8940, null)
  }else {
    var root_overflow_QMARK___8941 = this__8939.cnt >>> 5 > 1 << this__8939.shift;
    var new_shift__8942 = root_overflow_QMARK___8941 ? this__8939.shift + 5 : this__8939.shift;
    var new_root__8944 = root_overflow_QMARK___8941 ? function() {
      var n_r__8943 = cljs.core.pv_fresh_node.call(null, null);
      cljs.core.pv_aset.call(null, n_r__8943, 0, this__8939.root);
      cljs.core.pv_aset.call(null, n_r__8943, 1, cljs.core.new_path.call(null, null, this__8939.shift, new cljs.core.VectorNode(null, this__8939.tail)));
      return n_r__8943
    }() : cljs.core.push_tail.call(null, coll, this__8939.shift, this__8939.root, new cljs.core.VectorNode(null, this__8939.tail));
    return new cljs.core.PersistentVector(this__8939.meta, this__8939.cnt + 1, new_shift__8942, new_root__8944, [o], null)
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__8945 = this;
  if(this__8945.cnt > 0) {
    return new cljs.core.RSeq(coll, this__8945.cnt - 1, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = function(coll) {
  var this__8946 = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(coll, 0)
};
cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = function(coll) {
  var this__8947 = this;
  return coll.cljs$core$IIndexed$_nth$arity$2(coll, 1)
};
cljs.core.PersistentVector.prototype.toString = function() {
  var this__8948 = this;
  var this__8949 = this;
  return cljs.core.pr_str.call(null, this__8949)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = function(v, f) {
  var this__8950 = this;
  return cljs.core.ci_reduce.call(null, v, f)
};
cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = function(v, f, start) {
  var this__8951 = this;
  return cljs.core.ci_reduce.call(null, v, f, start)
};
cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__8952 = this;
  if(this__8952.cnt === 0) {
    return null
  }else {
    return cljs.core.chunked_seq.call(null, coll, 0, 0)
  }
};
cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__8953 = this;
  return this__8953.cnt
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__8954 = this;
  if(this__8954.cnt > 0) {
    return coll.cljs$core$IIndexed$_nth$arity$2(coll, this__8954.cnt - 1)
  }else {
    return null
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__8955 = this;
  if(this__8955.cnt === 0) {
    throw new Error("Can't pop empty vector");
  }else {
    if(1 === this__8955.cnt) {
      return cljs.core._with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__8955.meta)
    }else {
      if(1 < this__8955.cnt - cljs.core.tail_off.call(null, coll)) {
        return new cljs.core.PersistentVector(this__8955.meta, this__8955.cnt - 1, this__8955.shift, this__8955.root, this__8955.tail.slice(0, -1), null)
      }else {
        if("\ufdd0'else") {
          var new_tail__8956 = cljs.core.array_for.call(null, coll, this__8955.cnt - 2);
          var nr__8957 = cljs.core.pop_tail.call(null, coll, this__8955.shift, this__8955.root);
          var new_root__8958 = nr__8957 == null ? cljs.core.PersistentVector.EMPTY_NODE : nr__8957;
          var cnt_1__8959 = this__8955.cnt - 1;
          if(function() {
            var and__3822__auto____8960 = 5 < this__8955.shift;
            if(and__3822__auto____8960) {
              return cljs.core.pv_aget.call(null, new_root__8958, 1) == null
            }else {
              return and__3822__auto____8960
            }
          }()) {
            return new cljs.core.PersistentVector(this__8955.meta, cnt_1__8959, this__8955.shift - 5, cljs.core.pv_aget.call(null, new_root__8958, 0), new_tail__8956, null)
          }else {
            return new cljs.core.PersistentVector(this__8955.meta, cnt_1__8959, this__8955.shift, new_root__8958, new_tail__8956, null)
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__8961 = this;
  return coll.cljs$core$IAssociative$_assoc$arity$3(coll, n, val)
};
cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__8962 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__8963 = this;
  return new cljs.core.PersistentVector(meta, this__8963.cnt, this__8963.shift, this__8963.root, this__8963.tail, this__8963.__hash)
};
cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__8964 = this;
  return this__8964.meta
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__8965 = this;
  return cljs.core.array_for.call(null, coll, n)[n & 31]
};
cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__8966 = this;
  if(function() {
    var and__3822__auto____8967 = 0 <= n;
    if(and__3822__auto____8967) {
      return n < this__8966.cnt
    }else {
      return and__3822__auto____8967
    }
  }()) {
    return coll.cljs$core$IIndexed$_nth$arity$2(coll, n)
  }else {
    return not_found
  }
};
cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__8968 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__8968.meta)
};
cljs.core.PersistentVector;
cljs.core.PersistentVector.EMPTY_NODE = cljs.core.pv_fresh_node.call(null, null);
cljs.core.PersistentVector.EMPTY = new cljs.core.PersistentVector(null, 0, 5, cljs.core.PersistentVector.EMPTY_NODE, [], 0);
cljs.core.PersistentVector.fromArray = function(xs, no_clone) {
  var l__8973 = xs.length;
  var xs__8974 = no_clone === true ? xs : xs.slice();
  if(l__8973 < 32) {
    return new cljs.core.PersistentVector(null, l__8973, 5, cljs.core.PersistentVector.EMPTY_NODE, xs__8974, null)
  }else {
    var node__8975 = xs__8974.slice(0, 32);
    var v__8976 = new cljs.core.PersistentVector(null, 32, 5, cljs.core.PersistentVector.EMPTY_NODE, node__8975, null);
    var i__8977 = 32;
    var out__8978 = cljs.core._as_transient.call(null, v__8976);
    while(true) {
      if(i__8977 < l__8973) {
        var G__8979 = i__8977 + 1;
        var G__8980 = cljs.core.conj_BANG_.call(null, out__8978, xs__8974[i__8977]);
        i__8977 = G__8979;
        out__8978 = G__8980;
        continue
      }else {
        return cljs.core.persistent_BANG_.call(null, out__8978)
      }
      break
    }
  }
};
cljs.core.vec = function vec(coll) {
  return cljs.core._persistent_BANG_.call(null, cljs.core.reduce.call(null, cljs.core._conj_BANG_, cljs.core._as_transient.call(null, cljs.core.PersistentVector.EMPTY), coll))
};
cljs.core.vector = function() {
  var vector__delegate = function(args) {
    return cljs.core.vec.call(null, args)
  };
  var vector = function(var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return vector__delegate.call(this, args)
  };
  vector.cljs$lang$maxFixedArity = 0;
  vector.cljs$lang$applyTo = function(arglist__8981) {
    var args = cljs.core.seq(arglist__8981);
    return vector__delegate(args)
  };
  vector.cljs$lang$arity$variadic = vector__delegate;
  return vector
}();
cljs.core.ChunkedSeq = function(vec, node, i, off, meta) {
  this.vec = vec;
  this.node = node;
  this.i = i;
  this.off = off;
  this.meta = meta;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 27525356
};
cljs.core.ChunkedSeq.cljs$lang$type = true;
cljs.core.ChunkedSeq.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/ChunkedSeq")
};
cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = function(coll) {
  var this__8982 = this;
  if(this__8982.off + 1 < this__8982.node.length) {
    var s__8983 = cljs.core.chunked_seq.call(null, this__8982.vec, this__8982.node, this__8982.i, this__8982.off + 1);
    if(s__8983 == null) {
      return null
    }else {
      return s__8983
    }
  }else {
    return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll)
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__8984 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__8985 = this;
  return coll
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__8986 = this;
  return this__8986.node[this__8986.off]
};
cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__8987 = this;
  if(this__8987.off + 1 < this__8987.node.length) {
    var s__8988 = cljs.core.chunked_seq.call(null, this__8987.vec, this__8987.node, this__8987.i, this__8987.off + 1);
    if(s__8988 == null) {
      return cljs.core.List.EMPTY
    }else {
      return s__8988
    }
  }else {
    return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll)
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$ = true;
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = function(coll) {
  var this__8989 = this;
  var l__8990 = this__8989.node.length;
  var s__8991 = this__8989.i + l__8990 < cljs.core._count.call(null, this__8989.vec) ? cljs.core.chunked_seq.call(null, this__8989.vec, this__8989.i + l__8990, 0) : null;
  if(s__8991 == null) {
    return null
  }else {
    return s__8991
  }
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__8992 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, m) {
  var this__8993 = this;
  return cljs.core.chunked_seq.call(null, this__8993.vec, this__8993.node, this__8993.i, this__8993.off, m)
};
cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_meta$arity$1 = function(coll) {
  var this__8994 = this;
  return this__8994.meta
};
cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__8995 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.EMPTY, this__8995.meta)
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$ = true;
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = function(coll) {
  var this__8996 = this;
  return cljs.core.array_chunk.call(null, this__8996.node, this__8996.off)
};
cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = function(coll) {
  var this__8997 = this;
  var l__8998 = this__8997.node.length;
  var s__8999 = this__8997.i + l__8998 < cljs.core._count.call(null, this__8997.vec) ? cljs.core.chunked_seq.call(null, this__8997.vec, this__8997.i + l__8998, 0) : null;
  if(s__8999 == null) {
    return cljs.core.List.EMPTY
  }else {
    return s__8999
  }
};
cljs.core.ChunkedSeq;
cljs.core.chunked_seq = function() {
  var chunked_seq = null;
  var chunked_seq__3 = function(vec, i, off) {
    return chunked_seq.call(null, vec, cljs.core.array_for.call(null, vec, i), i, off, null)
  };
  var chunked_seq__4 = function(vec, node, i, off) {
    return chunked_seq.call(null, vec, node, i, off, null)
  };
  var chunked_seq__5 = function(vec, node, i, off, meta) {
    return new cljs.core.ChunkedSeq(vec, node, i, off, meta)
  };
  chunked_seq = function(vec, node, i, off, meta) {
    switch(arguments.length) {
      case 3:
        return chunked_seq__3.call(this, vec, node, i);
      case 4:
        return chunked_seq__4.call(this, vec, node, i, off);
      case 5:
        return chunked_seq__5.call(this, vec, node, i, off, meta)
    }
    throw"Invalid arity: " + arguments.length;
  };
  chunked_seq.cljs$lang$arity$3 = chunked_seq__3;
  chunked_seq.cljs$lang$arity$4 = chunked_seq__4;
  chunked_seq.cljs$lang$arity$5 = chunked_seq__5;
  return chunked_seq
}();
cljs.core.Subvec = function(meta, v, start, end, __hash) {
  this.meta = meta;
  this.v = v;
  this.start = start;
  this.end = end;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32400159
};
cljs.core.Subvec.cljs$lang$type = true;
cljs.core.Subvec.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/Subvec")
};
cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9002 = this;
  var h__2287__auto____9003 = this__9002.__hash;
  if(!(h__2287__auto____9003 == null)) {
    return h__2287__auto____9003
  }else {
    var h__2287__auto____9004 = cljs.core.hash_coll.call(null, coll);
    this__9002.__hash = h__2287__auto____9004;
    return h__2287__auto____9004
  }
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__9005 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, null)
};
cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__9006 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, key, val) {
  var this__9007 = this;
  var v_pos__9008 = this__9007.start + key;
  return new cljs.core.Subvec(this__9007.meta, cljs.core._assoc.call(null, this__9007.v, v_pos__9008, val), this__9007.start, this__9007.end > v_pos__9008 + 1 ? this__9007.end : v_pos__9008 + 1, null)
};
cljs.core.Subvec.prototype.call = function() {
  var G__9034 = null;
  var G__9034__2 = function(this_sym9009, k) {
    var this__9011 = this;
    var this_sym9009__9012 = this;
    var coll__9013 = this_sym9009__9012;
    return coll__9013.cljs$core$ILookup$_lookup$arity$2(coll__9013, k)
  };
  var G__9034__3 = function(this_sym9010, k, not_found) {
    var this__9011 = this;
    var this_sym9010__9014 = this;
    var coll__9015 = this_sym9010__9014;
    return coll__9015.cljs$core$ILookup$_lookup$arity$3(coll__9015, k, not_found)
  };
  G__9034 = function(this_sym9010, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__9034__2.call(this, this_sym9010, k);
      case 3:
        return G__9034__3.call(this, this_sym9010, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__9034
}();
cljs.core.Subvec.prototype.apply = function(this_sym9000, args9001) {
  var this__9016 = this;
  return this_sym9000.call.apply(this_sym9000, [this_sym9000].concat(args9001.slice()))
};
cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__9017 = this;
  return new cljs.core.Subvec(this__9017.meta, cljs.core._assoc_n.call(null, this__9017.v, this__9017.end, o), this__9017.start, this__9017.end + 1, null)
};
cljs.core.Subvec.prototype.toString = function() {
  var this__9018 = this;
  var this__9019 = this;
  return cljs.core.pr_str.call(null, this__9019)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = function(coll, f) {
  var this__9020 = this;
  return cljs.core.ci_reduce.call(null, coll, f)
};
cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = function(coll, f, start) {
  var this__9021 = this;
  return cljs.core.ci_reduce.call(null, coll, f, start)
};
cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__9022 = this;
  var subvec_seq__9023 = function subvec_seq(i) {
    if(i === this__9022.end) {
      return null
    }else {
      return cljs.core.cons.call(null, cljs.core._nth.call(null, this__9022.v, i), new cljs.core.LazySeq(null, false, function() {
        return subvec_seq.call(null, i + 1)
      }, null))
    }
  };
  return subvec_seq__9023.call(null, this__9022.start)
};
cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__9024 = this;
  return this__9024.end - this__9024.start
};
cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__9025 = this;
  return cljs.core._nth.call(null, this__9025.v, this__9025.end - 1)
};
cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__9026 = this;
  if(this__9026.start === this__9026.end) {
    throw new Error("Can't pop empty vector");
  }else {
    return new cljs.core.Subvec(this__9026.meta, this__9026.v, this__9026.start, this__9026.end - 1, null)
  }
};
cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(coll, n, val) {
  var this__9027 = this;
  return coll.cljs$core$IAssociative$_assoc$arity$3(coll, n, val)
};
cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9028 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__9029 = this;
  return new cljs.core.Subvec(meta, this__9029.v, this__9029.start, this__9029.end, this__9029.__hash)
};
cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__9030 = this;
  return this__9030.meta
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__9031 = this;
  return cljs.core._nth.call(null, this__9031.v, this__9031.start + n)
};
cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__9032 = this;
  return cljs.core._nth.call(null, this__9032.v, this__9032.start + n, not_found)
};
cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__9033 = this;
  return cljs.core.with_meta.call(null, cljs.core.Vector.EMPTY, this__9033.meta)
};
cljs.core.Subvec;
cljs.core.subvec = function() {
  var subvec = null;
  var subvec__2 = function(v, start) {
    return subvec.call(null, v, start, cljs.core.count.call(null, v))
  };
  var subvec__3 = function(v, start, end) {
    return new cljs.core.Subvec(null, v, start, end, null)
  };
  subvec = function(v, start, end) {
    switch(arguments.length) {
      case 2:
        return subvec__2.call(this, v, start);
      case 3:
        return subvec__3.call(this, v, start, end)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subvec.cljs$lang$arity$2 = subvec__2;
  subvec.cljs$lang$arity$3 = subvec__3;
  return subvec
}();
cljs.core.tv_ensure_editable = function tv_ensure_editable(edit, node) {
  if(edit === node.edit) {
    return node
  }else {
    return new cljs.core.VectorNode(edit, node.arr.slice())
  }
};
cljs.core.tv_editable_root = function tv_editable_root(node) {
  return new cljs.core.VectorNode({}, node.arr.slice())
};
cljs.core.tv_editable_tail = function tv_editable_tail(tl) {
  var ret__9036 = cljs.core.make_array.call(null, 32);
  cljs.core.array_copy.call(null, tl, 0, ret__9036, 0, tl.length);
  return ret__9036
};
cljs.core.tv_push_tail = function tv_push_tail(tv, level, parent, tail_node) {
  var ret__9040 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, parent);
  var subidx__9041 = tv.cnt - 1 >>> level & 31;
  cljs.core.pv_aset.call(null, ret__9040, subidx__9041, level === 5 ? tail_node : function() {
    var child__9042 = cljs.core.pv_aget.call(null, ret__9040, subidx__9041);
    if(!(child__9042 == null)) {
      return tv_push_tail.call(null, tv, level - 5, child__9042, tail_node)
    }else {
      return cljs.core.new_path.call(null, tv.root.edit, level - 5, tail_node)
    }
  }());
  return ret__9040
};
cljs.core.tv_pop_tail = function tv_pop_tail(tv, level, node) {
  var node__9047 = cljs.core.tv_ensure_editable.call(null, tv.root.edit, node);
  var subidx__9048 = tv.cnt - 2 >>> level & 31;
  if(level > 5) {
    var new_child__9049 = tv_pop_tail.call(null, tv, level - 5, cljs.core.pv_aget.call(null, node__9047, subidx__9048));
    if(function() {
      var and__3822__auto____9050 = new_child__9049 == null;
      if(and__3822__auto____9050) {
        return subidx__9048 === 0
      }else {
        return and__3822__auto____9050
      }
    }()) {
      return null
    }else {
      cljs.core.pv_aset.call(null, node__9047, subidx__9048, new_child__9049);
      return node__9047
    }
  }else {
    if(subidx__9048 === 0) {
      return null
    }else {
      if("\ufdd0'else") {
        cljs.core.pv_aset.call(null, node__9047, subidx__9048, null);
        return node__9047
      }else {
        return null
      }
    }
  }
};
cljs.core.editable_array_for = function editable_array_for(tv, i) {
  if(function() {
    var and__3822__auto____9055 = 0 <= i;
    if(and__3822__auto____9055) {
      return i < tv.cnt
    }else {
      return and__3822__auto____9055
    }
  }()) {
    if(i >= cljs.core.tail_off.call(null, tv)) {
      return tv.tail
    }else {
      var root__9056 = tv.root;
      var node__9057 = root__9056;
      var level__9058 = tv.shift;
      while(true) {
        if(level__9058 > 0) {
          var G__9059 = cljs.core.tv_ensure_editable.call(null, root__9056.edit, cljs.core.pv_aget.call(null, node__9057, i >>> level__9058 & 31));
          var G__9060 = level__9058 - 5;
          node__9057 = G__9059;
          level__9058 = G__9060;
          continue
        }else {
          return node__9057.arr
        }
        break
      }
    }
  }else {
    throw new Error([cljs.core.str("No item "), cljs.core.str(i), cljs.core.str(" in transient vector of length "), cljs.core.str(tv.cnt)].join(""));
  }
};
cljs.core.TransientVector = function(cnt, shift, root, tail) {
  this.cnt = cnt;
  this.shift = shift;
  this.root = root;
  this.tail = tail;
  this.cljs$lang$protocol_mask$partition0$ = 275;
  this.cljs$lang$protocol_mask$partition1$ = 22
};
cljs.core.TransientVector.cljs$lang$type = true;
cljs.core.TransientVector.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/TransientVector")
};
cljs.core.TransientVector.prototype.call = function() {
  var G__9100 = null;
  var G__9100__2 = function(this_sym9063, k) {
    var this__9065 = this;
    var this_sym9063__9066 = this;
    var coll__9067 = this_sym9063__9066;
    return coll__9067.cljs$core$ILookup$_lookup$arity$2(coll__9067, k)
  };
  var G__9100__3 = function(this_sym9064, k, not_found) {
    var this__9065 = this;
    var this_sym9064__9068 = this;
    var coll__9069 = this_sym9064__9068;
    return coll__9069.cljs$core$ILookup$_lookup$arity$3(coll__9069, k, not_found)
  };
  G__9100 = function(this_sym9064, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__9100__2.call(this, this_sym9064, k);
      case 3:
        return G__9100__3.call(this, this_sym9064, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__9100
}();
cljs.core.TransientVector.prototype.apply = function(this_sym9061, args9062) {
  var this__9070 = this;
  return this_sym9061.call.apply(this_sym9061, [this_sym9061].concat(args9062.slice()))
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__9071 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, null)
};
cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__9072 = this;
  return coll.cljs$core$IIndexed$_nth$arity$3(coll, k, not_found)
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = function(coll, n) {
  var this__9073 = this;
  if(this__9073.root.edit) {
    return cljs.core.array_for.call(null, coll, n)[n & 31]
  }else {
    throw new Error("nth after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = function(coll, n, not_found) {
  var this__9074 = this;
  if(function() {
    var and__3822__auto____9075 = 0 <= n;
    if(and__3822__auto____9075) {
      return n < this__9074.cnt
    }else {
      return and__3822__auto____9075
    }
  }()) {
    return coll.cljs$core$IIndexed$_nth$arity$2(coll, n)
  }else {
    return not_found
  }
};
cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__9076 = this;
  if(this__9076.root.edit) {
    return this__9076.cnt
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = function(tcoll, n, val) {
  var this__9077 = this;
  if(this__9077.root.edit) {
    if(function() {
      var and__3822__auto____9078 = 0 <= n;
      if(and__3822__auto____9078) {
        return n < this__9077.cnt
      }else {
        return and__3822__auto____9078
      }
    }()) {
      if(cljs.core.tail_off.call(null, tcoll) <= n) {
        this__9077.tail[n & 31] = val;
        return tcoll
      }else {
        var new_root__9083 = function go(level, node) {
          var node__9081 = cljs.core.tv_ensure_editable.call(null, this__9077.root.edit, node);
          if(level === 0) {
            cljs.core.pv_aset.call(null, node__9081, n & 31, val);
            return node__9081
          }else {
            var subidx__9082 = n >>> level & 31;
            cljs.core.pv_aset.call(null, node__9081, subidx__9082, go.call(null, level - 5, cljs.core.pv_aget.call(null, node__9081, subidx__9082)));
            return node__9081
          }
        }.call(null, this__9077.shift, this__9077.root);
        this__9077.root = new_root__9083;
        return tcoll
      }
    }else {
      if(n === this__9077.cnt) {
        return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll, val)
      }else {
        if("\ufdd0'else") {
          throw new Error([cljs.core.str("Index "), cljs.core.str(n), cljs.core.str(" out of bounds for TransientVector of length"), cljs.core.str(this__9077.cnt)].join(""));
        }else {
          return null
        }
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = function(tcoll) {
  var this__9084 = this;
  if(this__9084.root.edit) {
    if(this__9084.cnt === 0) {
      throw new Error("Can't pop empty vector");
    }else {
      if(1 === this__9084.cnt) {
        this__9084.cnt = 0;
        return tcoll
      }else {
        if((this__9084.cnt - 1 & 31) > 0) {
          this__9084.cnt = this__9084.cnt - 1;
          return tcoll
        }else {
          if("\ufdd0'else") {
            var new_tail__9085 = cljs.core.editable_array_for.call(null, tcoll, this__9084.cnt - 2);
            var new_root__9087 = function() {
              var nr__9086 = cljs.core.tv_pop_tail.call(null, tcoll, this__9084.shift, this__9084.root);
              if(!(nr__9086 == null)) {
                return nr__9086
              }else {
                return new cljs.core.VectorNode(this__9084.root.edit, cljs.core.make_array.call(null, 32))
              }
            }();
            if(function() {
              var and__3822__auto____9088 = 5 < this__9084.shift;
              if(and__3822__auto____9088) {
                return cljs.core.pv_aget.call(null, new_root__9087, 1) == null
              }else {
                return and__3822__auto____9088
              }
            }()) {
              var new_root__9089 = cljs.core.tv_ensure_editable.call(null, this__9084.root.edit, cljs.core.pv_aget.call(null, new_root__9087, 0));
              this__9084.root = new_root__9089;
              this__9084.shift = this__9084.shift - 5;
              this__9084.cnt = this__9084.cnt - 1;
              this__9084.tail = new_tail__9085;
              return tcoll
            }else {
              this__9084.root = new_root__9087;
              this__9084.cnt = this__9084.cnt - 1;
              this__9084.tail = new_tail__9085;
              return tcoll
            }
          }else {
            return null
          }
        }
      }
    }
  }else {
    throw new Error("pop! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__9090 = this;
  return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll, key, val)
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__9091 = this;
  if(this__9091.root.edit) {
    if(this__9091.cnt - cljs.core.tail_off.call(null, tcoll) < 32) {
      this__9091.tail[this__9091.cnt & 31] = o;
      this__9091.cnt = this__9091.cnt + 1;
      return tcoll
    }else {
      var tail_node__9092 = new cljs.core.VectorNode(this__9091.root.edit, this__9091.tail);
      var new_tail__9093 = cljs.core.make_array.call(null, 32);
      new_tail__9093[0] = o;
      this__9091.tail = new_tail__9093;
      if(this__9091.cnt >>> 5 > 1 << this__9091.shift) {
        var new_root_array__9094 = cljs.core.make_array.call(null, 32);
        var new_shift__9095 = this__9091.shift + 5;
        new_root_array__9094[0] = this__9091.root;
        new_root_array__9094[1] = cljs.core.new_path.call(null, this__9091.root.edit, this__9091.shift, tail_node__9092);
        this__9091.root = new cljs.core.VectorNode(this__9091.root.edit, new_root_array__9094);
        this__9091.shift = new_shift__9095;
        this__9091.cnt = this__9091.cnt + 1;
        return tcoll
      }else {
        var new_root__9096 = cljs.core.tv_push_tail.call(null, tcoll, this__9091.shift, this__9091.root, tail_node__9092);
        this__9091.root = new_root__9096;
        this__9091.cnt = this__9091.cnt + 1;
        return tcoll
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__9097 = this;
  if(this__9097.root.edit) {
    this__9097.root.edit = null;
    var len__9098 = this__9097.cnt - cljs.core.tail_off.call(null, tcoll);
    var trimmed_tail__9099 = cljs.core.make_array.call(null, len__9098);
    cljs.core.array_copy.call(null, this__9097.tail, 0, trimmed_tail__9099, 0, len__9098);
    return new cljs.core.PersistentVector(null, this__9097.cnt, this__9097.shift, this__9097.root, trimmed_tail__9099, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientVector;
cljs.core.PersistentQueueSeq = function(meta, front, rear, __hash) {
  this.meta = meta;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31850572
};
cljs.core.PersistentQueueSeq.cljs$lang$type = true;
cljs.core.PersistentQueueSeq.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentQueueSeq")
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9101 = this;
  var h__2287__auto____9102 = this__9101.__hash;
  if(!(h__2287__auto____9102 == null)) {
    return h__2287__auto____9102
  }else {
    var h__2287__auto____9103 = cljs.core.hash_coll.call(null, coll);
    this__9101.__hash = h__2287__auto____9103;
    return h__2287__auto____9103
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__9104 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentQueueSeq.prototype.toString = function() {
  var this__9105 = this;
  var this__9106 = this;
  return cljs.core.pr_str.call(null, this__9106)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__9107 = this;
  return coll
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__9108 = this;
  return cljs.core._first.call(null, this__9108.front)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__9109 = this;
  var temp__3971__auto____9110 = cljs.core.next.call(null, this__9109.front);
  if(temp__3971__auto____9110) {
    var f1__9111 = temp__3971__auto____9110;
    return new cljs.core.PersistentQueueSeq(this__9109.meta, f1__9111, this__9109.rear, null)
  }else {
    if(this__9109.rear == null) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll)
    }else {
      return new cljs.core.PersistentQueueSeq(this__9109.meta, this__9109.rear, null, null)
    }
  }
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9112 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__9113 = this;
  return new cljs.core.PersistentQueueSeq(meta, this__9113.front, this__9113.rear, this__9113.__hash)
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__9114 = this;
  return this__9114.meta
};
cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__9115 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__9115.meta)
};
cljs.core.PersistentQueueSeq;
cljs.core.PersistentQueue = function(meta, count, front, rear, __hash) {
  this.meta = meta;
  this.count = count;
  this.front = front;
  this.rear = rear;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31858766
};
cljs.core.PersistentQueue.cljs$lang$type = true;
cljs.core.PersistentQueue.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentQueue")
};
cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9116 = this;
  var h__2287__auto____9117 = this__9116.__hash;
  if(!(h__2287__auto____9117 == null)) {
    return h__2287__auto____9117
  }else {
    var h__2287__auto____9118 = cljs.core.hash_coll.call(null, coll);
    this__9116.__hash = h__2287__auto____9118;
    return h__2287__auto____9118
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__9119 = this;
  if(cljs.core.truth_(this__9119.front)) {
    return new cljs.core.PersistentQueue(this__9119.meta, this__9119.count + 1, this__9119.front, cljs.core.conj.call(null, function() {
      var or__3824__auto____9120 = this__9119.rear;
      if(cljs.core.truth_(or__3824__auto____9120)) {
        return or__3824__auto____9120
      }else {
        return cljs.core.PersistentVector.EMPTY
      }
    }(), o), null)
  }else {
    return new cljs.core.PersistentQueue(this__9119.meta, this__9119.count + 1, cljs.core.conj.call(null, this__9119.front, o), cljs.core.PersistentVector.EMPTY, null)
  }
};
cljs.core.PersistentQueue.prototype.toString = function() {
  var this__9121 = this;
  var this__9122 = this;
  return cljs.core.pr_str.call(null, this__9122)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__9123 = this;
  var rear__9124 = cljs.core.seq.call(null, this__9123.rear);
  if(cljs.core.truth_(function() {
    var or__3824__auto____9125 = this__9123.front;
    if(cljs.core.truth_(or__3824__auto____9125)) {
      return or__3824__auto____9125
    }else {
      return rear__9124
    }
  }())) {
    return new cljs.core.PersistentQueueSeq(null, this__9123.front, cljs.core.seq.call(null, rear__9124), null)
  }else {
    return null
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__9126 = this;
  return this__9126.count
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = function(coll) {
  var this__9127 = this;
  return cljs.core._first.call(null, this__9127.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = function(coll) {
  var this__9128 = this;
  if(cljs.core.truth_(this__9128.front)) {
    var temp__3971__auto____9129 = cljs.core.next.call(null, this__9128.front);
    if(temp__3971__auto____9129) {
      var f1__9130 = temp__3971__auto____9129;
      return new cljs.core.PersistentQueue(this__9128.meta, this__9128.count - 1, f1__9130, this__9128.rear, null)
    }else {
      return new cljs.core.PersistentQueue(this__9128.meta, this__9128.count - 1, cljs.core.seq.call(null, this__9128.rear), cljs.core.PersistentVector.EMPTY, null)
    }
  }else {
    return coll
  }
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__9131 = this;
  return cljs.core.first.call(null, this__9131.front)
};
cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__9132 = this;
  return cljs.core.rest.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9133 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__9134 = this;
  return new cljs.core.PersistentQueue(meta, this__9134.count, this__9134.front, this__9134.rear, this__9134.__hash)
};
cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__9135 = this;
  return this__9135.meta
};
cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__9136 = this;
  return cljs.core.PersistentQueue.EMPTY
};
cljs.core.PersistentQueue;
cljs.core.PersistentQueue.EMPTY = new cljs.core.PersistentQueue(null, 0, null, cljs.core.PersistentVector.EMPTY, 0);
cljs.core.NeverEquiv = function() {
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2097152
};
cljs.core.NeverEquiv.cljs$lang$type = true;
cljs.core.NeverEquiv.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/NeverEquiv")
};
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__9137 = this;
  return false
};
cljs.core.NeverEquiv;
cljs.core.never_equiv = new cljs.core.NeverEquiv;
cljs.core.equiv_map = function equiv_map(x, y) {
  return cljs.core.boolean$.call(null, cljs.core.map_QMARK_.call(null, y) ? cljs.core.count.call(null, x) === cljs.core.count.call(null, y) ? cljs.core.every_QMARK_.call(null, cljs.core.identity, cljs.core.map.call(null, function(xkv) {
    return cljs.core._EQ_.call(null, cljs.core._lookup.call(null, y, cljs.core.first.call(null, xkv), cljs.core.never_equiv), cljs.core.second.call(null, xkv))
  }, x)) : null : null)
};
cljs.core.scan_array = function scan_array(incr, k, array) {
  var len__9140 = array.length;
  var i__9141 = 0;
  while(true) {
    if(i__9141 < len__9140) {
      if(k === array[i__9141]) {
        return i__9141
      }else {
        var G__9142 = i__9141 + incr;
        i__9141 = G__9142;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.obj_map_compare_keys = function obj_map_compare_keys(a, b) {
  var a__9145 = cljs.core.hash.call(null, a);
  var b__9146 = cljs.core.hash.call(null, b);
  if(a__9145 < b__9146) {
    return-1
  }else {
    if(a__9145 > b__9146) {
      return 1
    }else {
      if("\ufdd0'else") {
        return 0
      }else {
        return null
      }
    }
  }
};
cljs.core.obj_map__GT_hash_map = function obj_map__GT_hash_map(m, k, v) {
  var ks__9154 = m.keys;
  var len__9155 = ks__9154.length;
  var so__9156 = m.strobj;
  var out__9157 = cljs.core.with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, cljs.core.meta.call(null, m));
  var i__9158 = 0;
  var out__9159 = cljs.core.transient$.call(null, out__9157);
  while(true) {
    if(i__9158 < len__9155) {
      var k__9160 = ks__9154[i__9158];
      var G__9161 = i__9158 + 1;
      var G__9162 = cljs.core.assoc_BANG_.call(null, out__9159, k__9160, so__9156[k__9160]);
      i__9158 = G__9161;
      out__9159 = G__9162;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, out__9159, k, v))
    }
    break
  }
};
cljs.core.obj_clone = function obj_clone(obj, ks) {
  var new_obj__9168 = {};
  var l__9169 = ks.length;
  var i__9170 = 0;
  while(true) {
    if(i__9170 < l__9169) {
      var k__9171 = ks[i__9170];
      new_obj__9168[k__9171] = obj[k__9171];
      var G__9172 = i__9170 + 1;
      i__9170 = G__9172;
      continue
    }else {
    }
    break
  }
  return new_obj__9168
};
cljs.core.ObjMap = function(meta, keys, strobj, update_count, __hash) {
  this.meta = meta;
  this.keys = keys;
  this.strobj = strobj;
  this.update_count = update_count;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 1;
  this.cljs$lang$protocol_mask$partition0$ = 15075087
};
cljs.core.ObjMap.cljs$lang$type = true;
cljs.core.ObjMap.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/ObjMap")
};
cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__9175 = this;
  return cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.hash_map.call(null), coll))
};
cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9176 = this;
  var h__2287__auto____9177 = this__9176.__hash;
  if(!(h__2287__auto____9177 == null)) {
    return h__2287__auto____9177
  }else {
    var h__2287__auto____9178 = cljs.core.hash_imap.call(null, coll);
    this__9176.__hash = h__2287__auto____9178;
    return h__2287__auto____9178
  }
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__9179 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, k, null)
};
cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__9180 = this;
  if(function() {
    var and__3822__auto____9181 = goog.isString(k);
    if(and__3822__auto____9181) {
      return!(cljs.core.scan_array.call(null, 1, k, this__9180.keys) == null)
    }else {
      return and__3822__auto____9181
    }
  }()) {
    return this__9180.strobj[k]
  }else {
    return not_found
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__9182 = this;
  if(goog.isString(k)) {
    if(function() {
      var or__3824__auto____9183 = this__9182.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD;
      if(or__3824__auto____9183) {
        return or__3824__auto____9183
      }else {
        return this__9182.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD
      }
    }()) {
      return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
    }else {
      if(!(cljs.core.scan_array.call(null, 1, k, this__9182.keys) == null)) {
        var new_strobj__9184 = cljs.core.obj_clone.call(null, this__9182.strobj, this__9182.keys);
        new_strobj__9184[k] = v;
        return new cljs.core.ObjMap(this__9182.meta, this__9182.keys, new_strobj__9184, this__9182.update_count + 1, null)
      }else {
        var new_strobj__9185 = cljs.core.obj_clone.call(null, this__9182.strobj, this__9182.keys);
        var new_keys__9186 = this__9182.keys.slice();
        new_strobj__9185[k] = v;
        new_keys__9186.push(k);
        return new cljs.core.ObjMap(this__9182.meta, new_keys__9186, new_strobj__9185, this__9182.update_count + 1, null)
      }
    }
  }else {
    return cljs.core.obj_map__GT_hash_map.call(null, coll, k, v)
  }
};
cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__9187 = this;
  if(function() {
    var and__3822__auto____9188 = goog.isString(k);
    if(and__3822__auto____9188) {
      return!(cljs.core.scan_array.call(null, 1, k, this__9187.keys) == null)
    }else {
      return and__3822__auto____9188
    }
  }()) {
    return true
  }else {
    return false
  }
};
cljs.core.ObjMap.prototype.call = function() {
  var G__9210 = null;
  var G__9210__2 = function(this_sym9189, k) {
    var this__9191 = this;
    var this_sym9189__9192 = this;
    var coll__9193 = this_sym9189__9192;
    return coll__9193.cljs$core$ILookup$_lookup$arity$2(coll__9193, k)
  };
  var G__9210__3 = function(this_sym9190, k, not_found) {
    var this__9191 = this;
    var this_sym9190__9194 = this;
    var coll__9195 = this_sym9190__9194;
    return coll__9195.cljs$core$ILookup$_lookup$arity$3(coll__9195, k, not_found)
  };
  G__9210 = function(this_sym9190, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__9210__2.call(this, this_sym9190, k);
      case 3:
        return G__9210__3.call(this, this_sym9190, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__9210
}();
cljs.core.ObjMap.prototype.apply = function(this_sym9173, args9174) {
  var this__9196 = this;
  return this_sym9173.call.apply(this_sym9173, [this_sym9173].concat(args9174.slice()))
};
cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__9197 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.ObjMap.prototype.toString = function() {
  var this__9198 = this;
  var this__9199 = this;
  return cljs.core.pr_str.call(null, this__9199)
};
cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__9200 = this;
  if(this__9200.keys.length > 0) {
    return cljs.core.map.call(null, function(p1__9163_SHARP_) {
      return cljs.core.vector.call(null, p1__9163_SHARP_, this__9200.strobj[p1__9163_SHARP_])
    }, this__9200.keys.sort(cljs.core.obj_map_compare_keys))
  }else {
    return null
  }
};
cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__9201 = this;
  return this__9201.keys.length
};
cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9202 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__9203 = this;
  return new cljs.core.ObjMap(meta, this__9203.keys, this__9203.strobj, this__9203.update_count, this__9203.__hash)
};
cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__9204 = this;
  return this__9204.meta
};
cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__9205 = this;
  return cljs.core.with_meta.call(null, cljs.core.ObjMap.EMPTY, this__9205.meta)
};
cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__9206 = this;
  if(function() {
    var and__3822__auto____9207 = goog.isString(k);
    if(and__3822__auto____9207) {
      return!(cljs.core.scan_array.call(null, 1, k, this__9206.keys) == null)
    }else {
      return and__3822__auto____9207
    }
  }()) {
    var new_keys__9208 = this__9206.keys.slice();
    var new_strobj__9209 = cljs.core.obj_clone.call(null, this__9206.strobj, this__9206.keys);
    new_keys__9208.splice(cljs.core.scan_array.call(null, 1, k, new_keys__9208), 1);
    cljs.core.js_delete.call(null, new_strobj__9209, k);
    return new cljs.core.ObjMap(this__9206.meta, new_keys__9208, new_strobj__9209, this__9206.update_count + 1, null)
  }else {
    return coll
  }
};
cljs.core.ObjMap;
cljs.core.ObjMap.EMPTY = new cljs.core.ObjMap(null, [], {}, 0, 0);
cljs.core.ObjMap.HASHMAP_THRESHOLD = 32;
cljs.core.ObjMap.fromObject = function(ks, obj) {
  return new cljs.core.ObjMap(null, ks, obj, 0, null)
};
cljs.core.HashMap = function(meta, count, hashobj, __hash) {
  this.meta = meta;
  this.count = count;
  this.hashobj = hashobj;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 15075087
};
cljs.core.HashMap.cljs$lang$type = true;
cljs.core.HashMap.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/HashMap")
};
cljs.core.HashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9214 = this;
  var h__2287__auto____9215 = this__9214.__hash;
  if(!(h__2287__auto____9215 == null)) {
    return h__2287__auto____9215
  }else {
    var h__2287__auto____9216 = cljs.core.hash_imap.call(null, coll);
    this__9214.__hash = h__2287__auto____9216;
    return h__2287__auto____9216
  }
};
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__9217 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, k, null)
};
cljs.core.HashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__9218 = this;
  var bucket__9219 = this__9218.hashobj[cljs.core.hash.call(null, k)];
  var i__9220 = cljs.core.truth_(bucket__9219) ? cljs.core.scan_array.call(null, 2, k, bucket__9219) : null;
  if(cljs.core.truth_(i__9220)) {
    return bucket__9219[i__9220 + 1]
  }else {
    return not_found
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__9221 = this;
  var h__9222 = cljs.core.hash.call(null, k);
  var bucket__9223 = this__9221.hashobj[h__9222];
  if(cljs.core.truth_(bucket__9223)) {
    var new_bucket__9224 = bucket__9223.slice();
    var new_hashobj__9225 = goog.object.clone(this__9221.hashobj);
    new_hashobj__9225[h__9222] = new_bucket__9224;
    var temp__3971__auto____9226 = cljs.core.scan_array.call(null, 2, k, new_bucket__9224);
    if(cljs.core.truth_(temp__3971__auto____9226)) {
      var i__9227 = temp__3971__auto____9226;
      new_bucket__9224[i__9227 + 1] = v;
      return new cljs.core.HashMap(this__9221.meta, this__9221.count, new_hashobj__9225, null)
    }else {
      new_bucket__9224.push(k, v);
      return new cljs.core.HashMap(this__9221.meta, this__9221.count + 1, new_hashobj__9225, null)
    }
  }else {
    var new_hashobj__9228 = goog.object.clone(this__9221.hashobj);
    new_hashobj__9228[h__9222] = [k, v];
    return new cljs.core.HashMap(this__9221.meta, this__9221.count + 1, new_hashobj__9228, null)
  }
};
cljs.core.HashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__9229 = this;
  var bucket__9230 = this__9229.hashobj[cljs.core.hash.call(null, k)];
  var i__9231 = cljs.core.truth_(bucket__9230) ? cljs.core.scan_array.call(null, 2, k, bucket__9230) : null;
  if(cljs.core.truth_(i__9231)) {
    return true
  }else {
    return false
  }
};
cljs.core.HashMap.prototype.call = function() {
  var G__9256 = null;
  var G__9256__2 = function(this_sym9232, k) {
    var this__9234 = this;
    var this_sym9232__9235 = this;
    var coll__9236 = this_sym9232__9235;
    return coll__9236.cljs$core$ILookup$_lookup$arity$2(coll__9236, k)
  };
  var G__9256__3 = function(this_sym9233, k, not_found) {
    var this__9234 = this;
    var this_sym9233__9237 = this;
    var coll__9238 = this_sym9233__9237;
    return coll__9238.cljs$core$ILookup$_lookup$arity$3(coll__9238, k, not_found)
  };
  G__9256 = function(this_sym9233, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__9256__2.call(this, this_sym9233, k);
      case 3:
        return G__9256__3.call(this, this_sym9233, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__9256
}();
cljs.core.HashMap.prototype.apply = function(this_sym9212, args9213) {
  var this__9239 = this;
  return this_sym9212.call.apply(this_sym9212, [this_sym9212].concat(args9213.slice()))
};
cljs.core.HashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__9240 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.HashMap.prototype.toString = function() {
  var this__9241 = this;
  var this__9242 = this;
  return cljs.core.pr_str.call(null, this__9242)
};
cljs.core.HashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__9243 = this;
  if(this__9243.count > 0) {
    var hashes__9244 = cljs.core.js_keys.call(null, this__9243.hashobj).sort();
    return cljs.core.mapcat.call(null, function(p1__9211_SHARP_) {
      return cljs.core.map.call(null, cljs.core.vec, cljs.core.partition.call(null, 2, this__9243.hashobj[p1__9211_SHARP_]))
    }, hashes__9244)
  }else {
    return null
  }
};
cljs.core.HashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__9245 = this;
  return this__9245.count
};
cljs.core.HashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9246 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.HashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__9247 = this;
  return new cljs.core.HashMap(meta, this__9247.count, this__9247.hashobj, this__9247.__hash)
};
cljs.core.HashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__9248 = this;
  return this__9248.meta
};
cljs.core.HashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__9249 = this;
  return cljs.core.with_meta.call(null, cljs.core.HashMap.EMPTY, this__9249.meta)
};
cljs.core.HashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__9250 = this;
  var h__9251 = cljs.core.hash.call(null, k);
  var bucket__9252 = this__9250.hashobj[h__9251];
  var i__9253 = cljs.core.truth_(bucket__9252) ? cljs.core.scan_array.call(null, 2, k, bucket__9252) : null;
  if(cljs.core.not.call(null, i__9253)) {
    return coll
  }else {
    var new_hashobj__9254 = goog.object.clone(this__9250.hashobj);
    if(3 > bucket__9252.length) {
      cljs.core.js_delete.call(null, new_hashobj__9254, h__9251)
    }else {
      var new_bucket__9255 = bucket__9252.slice();
      new_bucket__9255.splice(i__9253, 2);
      new_hashobj__9254[h__9251] = new_bucket__9255
    }
    return new cljs.core.HashMap(this__9250.meta, this__9250.count - 1, new_hashobj__9254, null)
  }
};
cljs.core.HashMap;
cljs.core.HashMap.EMPTY = new cljs.core.HashMap(null, 0, {}, 0);
cljs.core.HashMap.fromArrays = function(ks, vs) {
  var len__9257 = ks.length;
  var i__9258 = 0;
  var out__9259 = cljs.core.HashMap.EMPTY;
  while(true) {
    if(i__9258 < len__9257) {
      var G__9260 = i__9258 + 1;
      var G__9261 = cljs.core.assoc.call(null, out__9259, ks[i__9258], vs[i__9258]);
      i__9258 = G__9260;
      out__9259 = G__9261;
      continue
    }else {
      return out__9259
    }
    break
  }
};
cljs.core.array_map_index_of = function array_map_index_of(m, k) {
  var arr__9265 = m.arr;
  var len__9266 = arr__9265.length;
  var i__9267 = 0;
  while(true) {
    if(len__9266 <= i__9267) {
      return-1
    }else {
      if(cljs.core._EQ_.call(null, arr__9265[i__9267], k)) {
        return i__9267
      }else {
        if("\ufdd0'else") {
          var G__9268 = i__9267 + 2;
          i__9267 = G__9268;
          continue
        }else {
          return null
        }
      }
    }
    break
  }
};
cljs.core.PersistentArrayMap = function(meta, cnt, arr, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.arr = arr;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 1;
  this.cljs$lang$protocol_mask$partition0$ = 16123663
};
cljs.core.PersistentArrayMap.cljs$lang$type = true;
cljs.core.PersistentArrayMap.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentArrayMap")
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__9271 = this;
  return new cljs.core.TransientArrayMap({}, this__9271.arr.length, this__9271.arr.slice())
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9272 = this;
  var h__2287__auto____9273 = this__9272.__hash;
  if(!(h__2287__auto____9273 == null)) {
    return h__2287__auto____9273
  }else {
    var h__2287__auto____9274 = cljs.core.hash_imap.call(null, coll);
    this__9272.__hash = h__2287__auto____9274;
    return h__2287__auto____9274
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__9275 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, k, null)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__9276 = this;
  var idx__9277 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__9277 === -1) {
    return not_found
  }else {
    return this__9276.arr[idx__9277 + 1]
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__9278 = this;
  var idx__9279 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__9279 === -1) {
    if(this__9278.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
      return new cljs.core.PersistentArrayMap(this__9278.meta, this__9278.cnt + 1, function() {
        var G__9280__9281 = this__9278.arr.slice();
        G__9280__9281.push(k);
        G__9280__9281.push(v);
        return G__9280__9281
      }(), null)
    }else {
      return cljs.core.persistent_BANG_.call(null, cljs.core.assoc_BANG_.call(null, cljs.core.transient$.call(null, cljs.core.into.call(null, cljs.core.PersistentHashMap.EMPTY, coll)), k, v))
    }
  }else {
    if(v === this__9278.arr[idx__9279 + 1]) {
      return coll
    }else {
      if("\ufdd0'else") {
        return new cljs.core.PersistentArrayMap(this__9278.meta, this__9278.cnt, function() {
          var G__9282__9283 = this__9278.arr.slice();
          G__9282__9283[idx__9279 + 1] = v;
          return G__9282__9283
        }(), null)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__9284 = this;
  return!(cljs.core.array_map_index_of.call(null, coll, k) === -1)
};
cljs.core.PersistentArrayMap.prototype.call = function() {
  var G__9316 = null;
  var G__9316__2 = function(this_sym9285, k) {
    var this__9287 = this;
    var this_sym9285__9288 = this;
    var coll__9289 = this_sym9285__9288;
    return coll__9289.cljs$core$ILookup$_lookup$arity$2(coll__9289, k)
  };
  var G__9316__3 = function(this_sym9286, k, not_found) {
    var this__9287 = this;
    var this_sym9286__9290 = this;
    var coll__9291 = this_sym9286__9290;
    return coll__9291.cljs$core$ILookup$_lookup$arity$3(coll__9291, k, not_found)
  };
  G__9316 = function(this_sym9286, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__9316__2.call(this, this_sym9286, k);
      case 3:
        return G__9316__3.call(this, this_sym9286, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__9316
}();
cljs.core.PersistentArrayMap.prototype.apply = function(this_sym9269, args9270) {
  var this__9292 = this;
  return this_sym9269.call.apply(this_sym9269, [this_sym9269].concat(args9270.slice()))
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__9293 = this;
  var len__9294 = this__9293.arr.length;
  var i__9295 = 0;
  var init__9296 = init;
  while(true) {
    if(i__9295 < len__9294) {
      var init__9297 = f.call(null, init__9296, this__9293.arr[i__9295], this__9293.arr[i__9295 + 1]);
      if(cljs.core.reduced_QMARK_.call(null, init__9297)) {
        return cljs.core.deref.call(null, init__9297)
      }else {
        var G__9317 = i__9295 + 2;
        var G__9318 = init__9297;
        i__9295 = G__9317;
        init__9296 = G__9318;
        continue
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__9298 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentArrayMap.prototype.toString = function() {
  var this__9299 = this;
  var this__9300 = this;
  return cljs.core.pr_str.call(null, this__9300)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__9301 = this;
  if(this__9301.cnt > 0) {
    var len__9302 = this__9301.arr.length;
    var array_map_seq__9303 = function array_map_seq(i) {
      return new cljs.core.LazySeq(null, false, function() {
        if(i < len__9302) {
          return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([this__9301.arr[i], this__9301.arr[i + 1]], true), array_map_seq.call(null, i + 2))
        }else {
          return null
        }
      }, null)
    };
    return array_map_seq__9303.call(null, 0)
  }else {
    return null
  }
};
cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__9304 = this;
  return this__9304.cnt
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9305 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__9306 = this;
  return new cljs.core.PersistentArrayMap(meta, this__9306.cnt, this__9306.arr, this__9306.__hash)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__9307 = this;
  return this__9307.meta
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__9308 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentArrayMap.EMPTY, this__9308.meta)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__9309 = this;
  var idx__9310 = cljs.core.array_map_index_of.call(null, coll, k);
  if(idx__9310 >= 0) {
    var len__9311 = this__9309.arr.length;
    var new_len__9312 = len__9311 - 2;
    if(new_len__9312 === 0) {
      return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll)
    }else {
      var new_arr__9313 = cljs.core.make_array.call(null, new_len__9312);
      var s__9314 = 0;
      var d__9315 = 0;
      while(true) {
        if(s__9314 >= len__9311) {
          return new cljs.core.PersistentArrayMap(this__9309.meta, this__9309.cnt - 1, new_arr__9313, null)
        }else {
          if(cljs.core._EQ_.call(null, k, this__9309.arr[s__9314])) {
            var G__9319 = s__9314 + 2;
            var G__9320 = d__9315;
            s__9314 = G__9319;
            d__9315 = G__9320;
            continue
          }else {
            if("\ufdd0'else") {
              new_arr__9313[d__9315] = this__9309.arr[s__9314];
              new_arr__9313[d__9315 + 1] = this__9309.arr[s__9314 + 1];
              var G__9321 = s__9314 + 2;
              var G__9322 = d__9315 + 2;
              s__9314 = G__9321;
              d__9315 = G__9322;
              continue
            }else {
              return null
            }
          }
        }
        break
      }
    }
  }else {
    return coll
  }
};
cljs.core.PersistentArrayMap;
cljs.core.PersistentArrayMap.EMPTY = new cljs.core.PersistentArrayMap(null, 0, [], null);
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = 16;
cljs.core.PersistentArrayMap.fromArrays = function(ks, vs) {
  var len__9323 = cljs.core.count.call(null, ks);
  var i__9324 = 0;
  var out__9325 = cljs.core.transient$.call(null, cljs.core.PersistentArrayMap.EMPTY);
  while(true) {
    if(i__9324 < len__9323) {
      var G__9326 = i__9324 + 1;
      var G__9327 = cljs.core.assoc_BANG_.call(null, out__9325, ks[i__9324], vs[i__9324]);
      i__9324 = G__9326;
      out__9325 = G__9327;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__9325)
    }
    break
  }
};
cljs.core.TransientArrayMap = function(editable_QMARK_, len, arr) {
  this.editable_QMARK_ = editable_QMARK_;
  this.len = len;
  this.arr = arr;
  this.cljs$lang$protocol_mask$partition1$ = 14;
  this.cljs$lang$protocol_mask$partition0$ = 258
};
cljs.core.TransientArrayMap.cljs$lang$type = true;
cljs.core.TransientArrayMap.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/TransientArrayMap")
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__9328 = this;
  if(cljs.core.truth_(this__9328.editable_QMARK_)) {
    var idx__9329 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__9329 >= 0) {
      this__9328.arr[idx__9329] = this__9328.arr[this__9328.len - 2];
      this__9328.arr[idx__9329 + 1] = this__9328.arr[this__9328.len - 1];
      var G__9330__9331 = this__9328.arr;
      G__9330__9331.pop();
      G__9330__9331.pop();
      G__9330__9331;
      this__9328.len = this__9328.len - 2
    }else {
    }
    return tcoll
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__9332 = this;
  if(cljs.core.truth_(this__9332.editable_QMARK_)) {
    var idx__9333 = cljs.core.array_map_index_of.call(null, tcoll, key);
    if(idx__9333 === -1) {
      if(this__9332.len + 2 <= 2 * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD) {
        this__9332.len = this__9332.len + 2;
        this__9332.arr.push(key);
        this__9332.arr.push(val);
        return tcoll
      }else {
        return cljs.core.assoc_BANG_.call(null, cljs.core.array__GT_transient_hash_map.call(null, this__9332.len, this__9332.arr), key, val)
      }
    }else {
      if(val === this__9332.arr[idx__9333 + 1]) {
        return tcoll
      }else {
        this__9332.arr[idx__9333 + 1] = val;
        return tcoll
      }
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__9334 = this;
  if(cljs.core.truth_(this__9334.editable_QMARK_)) {
    if(function() {
      var G__9335__9336 = o;
      if(G__9335__9336) {
        if(function() {
          var or__3824__auto____9337 = G__9335__9336.cljs$lang$protocol_mask$partition0$ & 2048;
          if(or__3824__auto____9337) {
            return or__3824__auto____9337
          }else {
            return G__9335__9336.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__9335__9336.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__9335__9336)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__9335__9336)
      }
    }()) {
      return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll, cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__9338 = cljs.core.seq.call(null, o);
      var tcoll__9339 = tcoll;
      while(true) {
        var temp__3971__auto____9340 = cljs.core.first.call(null, es__9338);
        if(cljs.core.truth_(temp__3971__auto____9340)) {
          var e__9341 = temp__3971__auto____9340;
          var G__9347 = cljs.core.next.call(null, es__9338);
          var G__9348 = tcoll__9339.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll__9339, cljs.core.key.call(null, e__9341), cljs.core.val.call(null, e__9341));
          es__9338 = G__9347;
          tcoll__9339 = G__9348;
          continue
        }else {
          return tcoll__9339
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__9342 = this;
  if(cljs.core.truth_(this__9342.editable_QMARK_)) {
    this__9342.editable_QMARK_ = false;
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, this__9342.len, 2), this__9342.arr, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__9343 = this;
  return tcoll.cljs$core$ILookup$_lookup$arity$3(tcoll, k, null)
};
cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__9344 = this;
  if(cljs.core.truth_(this__9344.editable_QMARK_)) {
    var idx__9345 = cljs.core.array_map_index_of.call(null, tcoll, k);
    if(idx__9345 === -1) {
      return not_found
    }else {
      return this__9344.arr[idx__9345 + 1]
    }
  }else {
    throw new Error("lookup after persistent!");
  }
};
cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__9346 = this;
  if(cljs.core.truth_(this__9346.editable_QMARK_)) {
    return cljs.core.quot.call(null, this__9346.len, 2)
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientArrayMap;
cljs.core.array__GT_transient_hash_map = function array__GT_transient_hash_map(len, arr) {
  var out__9351 = cljs.core.transient$.call(null, cljs.core.ObjMap.EMPTY);
  var i__9352 = 0;
  while(true) {
    if(i__9352 < len) {
      var G__9353 = cljs.core.assoc_BANG_.call(null, out__9351, arr[i__9352], arr[i__9352 + 1]);
      var G__9354 = i__9352 + 2;
      out__9351 = G__9353;
      i__9352 = G__9354;
      continue
    }else {
      return out__9351
    }
    break
  }
};
cljs.core.Box = function(val) {
  this.val = val
};
cljs.core.Box.cljs$lang$type = true;
cljs.core.Box.cljs$lang$ctorPrSeq = function(this__2405__auto__) {
  return cljs.core.list.call(null, "cljs.core/Box")
};
cljs.core.Box;
cljs.core.key_test = function key_test(key, other) {
  if(goog.isString(key)) {
    return key === other
  }else {
    return cljs.core._EQ_.call(null, key, other)
  }
};
cljs.core.mask = function mask(hash, shift) {
  return hash >>> shift & 31
};
cljs.core.clone_and_set = function() {
  var clone_and_set = null;
  var clone_and_set__3 = function(arr, i, a) {
    var G__9359__9360 = arr.slice();
    G__9359__9360[i] = a;
    return G__9359__9360
  };
  var clone_and_set__5 = function(arr, i, a, j, b) {
    var G__9361__9362 = arr.slice();
    G__9361__9362[i] = a;
    G__9361__9362[j] = b;
    return G__9361__9362
  };
  clone_and_set = function(arr, i, a, j, b) {
    switch(arguments.length) {
      case 3:
        return clone_and_set__3.call(this, arr, i, a);
      case 5:
        return clone_and_set__5.call(this, arr, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  clone_and_set.cljs$lang$arity$3 = clone_and_set__3;
  clone_and_set.cljs$lang$arity$5 = clone_and_set__5;
  return clone_and_set
}();
cljs.core.remove_pair = function remove_pair(arr, i) {
  var new_arr__9364 = cljs.core.make_array.call(null, arr.length - 2);
  cljs.core.array_copy.call(null, arr, 0, new_arr__9364, 0, 2 * i);
  cljs.core.array_copy.call(null, arr, 2 * (i + 1), new_arr__9364, 2 * i, new_arr__9364.length - 2 * i);
  return new_arr__9364
};
cljs.core.bitmap_indexed_node_index = function bitmap_indexed_node_index(bitmap, bit) {
  return cljs.core.bit_count.call(null, bitmap & bit - 1)
};
cljs.core.bitpos = function bitpos(hash, shift) {
  return 1 << (hash >>> shift & 31)
};
cljs.core.edit_and_set = function() {
  var edit_and_set = null;
  var edit_and_set__4 = function(inode, edit, i, a) {
    var editable__9367 = inode.ensure_editable(edit);
    editable__9367.arr[i] = a;
    return editable__9367
  };
  var edit_and_set__6 = function(inode, edit, i, a, j, b) {
    var editable__9368 = inode.ensure_editable(edit);
    editable__9368.arr[i] = a;
    editable__9368.arr[j] = b;
    return editable__9368
  };
  edit_and_set = function(inode, edit, i, a, j, b) {
    switch(arguments.length) {
      case 4:
        return edit_and_set__4.call(this, inode, edit, i, a);
      case 6:
        return edit_and_set__6.call(this, inode, edit, i, a, j, b)
    }
    throw"Invalid arity: " + arguments.length;
  };
  edit_and_set.cljs$lang$arity$4 = edit_and_set__4;
  edit_and_set.cljs$lang$arity$6 = edit_and_set__6;
  return edit_and_set
}();
cljs.core.inode_kv_reduce = function inode_kv_reduce(arr, f, init) {
  var len__9375 = arr.length;
  var i__9376 = 0;
  var init__9377 = init;
  while(true) {
    if(i__9376 < len__9375) {
      var init__9380 = function() {
        var k__9378 = arr[i__9376];
        if(!(k__9378 == null)) {
          return f.call(null, init__9377, k__9378, arr[i__9376 + 1])
        }else {
          var node__9379 = arr[i__9376 + 1];
          if(!(node__9379 == null)) {
            return node__9379.kv_reduce(f, init__9377)
          }else {
            return init__9377
          }
        }
      }();
      if(cljs.core.reduced_QMARK_.call(null, init__9380)) {
        return cljs.core.deref.call(null, init__9380)
      }else {
        var G__9381 = i__9376 + 2;
        var G__9382 = init__9380;
        i__9376 = G__9381;
        init__9377 = G__9382;
        continue
      }
    }else {
      return init__9377
    }
    break
  }
};
cljs.core.BitmapIndexedNode = function(edit, bitmap, arr) {
  this.edit = edit;
  this.bitmap = bitmap;
  this.arr = arr
};
cljs.core.BitmapIndexedNode.cljs$lang$type = true;
cljs.core.BitmapIndexedNode.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/BitmapIndexedNode")
};
cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = function(e, bit, i) {
  var this__9383 = this;
  var inode__9384 = this;
  if(this__9383.bitmap === bit) {
    return null
  }else {
    var editable__9385 = inode__9384.ensure_editable(e);
    var earr__9386 = editable__9385.arr;
    var len__9387 = earr__9386.length;
    editable__9385.bitmap = bit ^ editable__9385.bitmap;
    cljs.core.array_copy.call(null, earr__9386, 2 * (i + 1), earr__9386, 2 * i, len__9387 - 2 * (i + 1));
    earr__9386[len__9387 - 2] = null;
    earr__9386[len__9387 - 1] = null;
    return editable__9385
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__9388 = this;
  var inode__9389 = this;
  var bit__9390 = 1 << (hash >>> shift & 31);
  var idx__9391 = cljs.core.bitmap_indexed_node_index.call(null, this__9388.bitmap, bit__9390);
  if((this__9388.bitmap & bit__9390) === 0) {
    var n__9392 = cljs.core.bit_count.call(null, this__9388.bitmap);
    if(2 * n__9392 < this__9388.arr.length) {
      var editable__9393 = inode__9389.ensure_editable(edit);
      var earr__9394 = editable__9393.arr;
      added_leaf_QMARK_.val = true;
      cljs.core.array_copy_downward.call(null, earr__9394, 2 * idx__9391, earr__9394, 2 * (idx__9391 + 1), 2 * (n__9392 - idx__9391));
      earr__9394[2 * idx__9391] = key;
      earr__9394[2 * idx__9391 + 1] = val;
      editable__9393.bitmap = editable__9393.bitmap | bit__9390;
      return editable__9393
    }else {
      if(n__9392 >= 16) {
        var nodes__9395 = cljs.core.make_array.call(null, 32);
        var jdx__9396 = hash >>> shift & 31;
        nodes__9395[jdx__9396] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
        var i__9397 = 0;
        var j__9398 = 0;
        while(true) {
          if(i__9397 < 32) {
            if((this__9388.bitmap >>> i__9397 & 1) === 0) {
              var G__9451 = i__9397 + 1;
              var G__9452 = j__9398;
              i__9397 = G__9451;
              j__9398 = G__9452;
              continue
            }else {
              nodes__9395[i__9397] = !(this__9388.arr[j__9398] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, cljs.core.hash.call(null, this__9388.arr[j__9398]), this__9388.arr[j__9398], this__9388.arr[j__9398 + 1], added_leaf_QMARK_) : this__9388.arr[j__9398 + 1];
              var G__9453 = i__9397 + 1;
              var G__9454 = j__9398 + 2;
              i__9397 = G__9453;
              j__9398 = G__9454;
              continue
            }
          }else {
          }
          break
        }
        return new cljs.core.ArrayNode(edit, n__9392 + 1, nodes__9395)
      }else {
        if("\ufdd0'else") {
          var new_arr__9399 = cljs.core.make_array.call(null, 2 * (n__9392 + 4));
          cljs.core.array_copy.call(null, this__9388.arr, 0, new_arr__9399, 0, 2 * idx__9391);
          new_arr__9399[2 * idx__9391] = key;
          new_arr__9399[2 * idx__9391 + 1] = val;
          cljs.core.array_copy.call(null, this__9388.arr, 2 * idx__9391, new_arr__9399, 2 * (idx__9391 + 1), 2 * (n__9392 - idx__9391));
          added_leaf_QMARK_.val = true;
          var editable__9400 = inode__9389.ensure_editable(edit);
          editable__9400.arr = new_arr__9399;
          editable__9400.bitmap = editable__9400.bitmap | bit__9390;
          return editable__9400
        }else {
          return null
        }
      }
    }
  }else {
    var key_or_nil__9401 = this__9388.arr[2 * idx__9391];
    var val_or_node__9402 = this__9388.arr[2 * idx__9391 + 1];
    if(key_or_nil__9401 == null) {
      var n__9403 = val_or_node__9402.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__9403 === val_or_node__9402) {
        return inode__9389
      }else {
        return cljs.core.edit_and_set.call(null, inode__9389, edit, 2 * idx__9391 + 1, n__9403)
      }
    }else {
      if(cljs.core.key_test.call(null, key, key_or_nil__9401)) {
        if(val === val_or_node__9402) {
          return inode__9389
        }else {
          return cljs.core.edit_and_set.call(null, inode__9389, edit, 2 * idx__9391 + 1, val)
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_.val = true;
          return cljs.core.edit_and_set.call(null, inode__9389, edit, 2 * idx__9391, null, 2 * idx__9391 + 1, cljs.core.create_node.call(null, edit, shift + 5, key_or_nil__9401, val_or_node__9402, hash, key, val))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_seq = function() {
  var this__9404 = this;
  var inode__9405 = this;
  return cljs.core.create_inode_seq.call(null, this__9404.arr)
};
cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__9406 = this;
  var inode__9407 = this;
  var bit__9408 = 1 << (hash >>> shift & 31);
  if((this__9406.bitmap & bit__9408) === 0) {
    return inode__9407
  }else {
    var idx__9409 = cljs.core.bitmap_indexed_node_index.call(null, this__9406.bitmap, bit__9408);
    var key_or_nil__9410 = this__9406.arr[2 * idx__9409];
    var val_or_node__9411 = this__9406.arr[2 * idx__9409 + 1];
    if(key_or_nil__9410 == null) {
      var n__9412 = val_or_node__9411.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
      if(n__9412 === val_or_node__9411) {
        return inode__9407
      }else {
        if(!(n__9412 == null)) {
          return cljs.core.edit_and_set.call(null, inode__9407, edit, 2 * idx__9409 + 1, n__9412)
        }else {
          if(this__9406.bitmap === bit__9408) {
            return null
          }else {
            if("\ufdd0'else") {
              return inode__9407.edit_and_remove_pair(edit, bit__9408, idx__9409)
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core.key_test.call(null, key, key_or_nil__9410)) {
        removed_leaf_QMARK_[0] = true;
        return inode__9407.edit_and_remove_pair(edit, bit__9408, idx__9409)
      }else {
        if("\ufdd0'else") {
          return inode__9407
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.ensure_editable = function(e) {
  var this__9413 = this;
  var inode__9414 = this;
  if(e === this__9413.edit) {
    return inode__9414
  }else {
    var n__9415 = cljs.core.bit_count.call(null, this__9413.bitmap);
    var new_arr__9416 = cljs.core.make_array.call(null, n__9415 < 0 ? 4 : 2 * (n__9415 + 1));
    cljs.core.array_copy.call(null, this__9413.arr, 0, new_arr__9416, 0, 2 * n__9415);
    return new cljs.core.BitmapIndexedNode(e, this__9413.bitmap, new_arr__9416)
  }
};
cljs.core.BitmapIndexedNode.prototype.kv_reduce = function(f, init) {
  var this__9417 = this;
  var inode__9418 = this;
  return cljs.core.inode_kv_reduce.call(null, this__9417.arr, f, init)
};
cljs.core.BitmapIndexedNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var this__9419 = this;
  var inode__9420 = this;
  var bit__9421 = 1 << (hash >>> shift & 31);
  if((this__9419.bitmap & bit__9421) === 0) {
    return not_found
  }else {
    var idx__9422 = cljs.core.bitmap_indexed_node_index.call(null, this__9419.bitmap, bit__9421);
    var key_or_nil__9423 = this__9419.arr[2 * idx__9422];
    var val_or_node__9424 = this__9419.arr[2 * idx__9422 + 1];
    if(key_or_nil__9423 == null) {
      return val_or_node__9424.inode_find(shift + 5, hash, key, not_found)
    }else {
      if(cljs.core.key_test.call(null, key, key_or_nil__9423)) {
        return cljs.core.PersistentVector.fromArray([key_or_nil__9423, val_or_node__9424], true)
      }else {
        if("\ufdd0'else") {
          return not_found
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_without = function(shift, hash, key) {
  var this__9425 = this;
  var inode__9426 = this;
  var bit__9427 = 1 << (hash >>> shift & 31);
  if((this__9425.bitmap & bit__9427) === 0) {
    return inode__9426
  }else {
    var idx__9428 = cljs.core.bitmap_indexed_node_index.call(null, this__9425.bitmap, bit__9427);
    var key_or_nil__9429 = this__9425.arr[2 * idx__9428];
    var val_or_node__9430 = this__9425.arr[2 * idx__9428 + 1];
    if(key_or_nil__9429 == null) {
      var n__9431 = val_or_node__9430.inode_without(shift + 5, hash, key);
      if(n__9431 === val_or_node__9430) {
        return inode__9426
      }else {
        if(!(n__9431 == null)) {
          return new cljs.core.BitmapIndexedNode(null, this__9425.bitmap, cljs.core.clone_and_set.call(null, this__9425.arr, 2 * idx__9428 + 1, n__9431))
        }else {
          if(this__9425.bitmap === bit__9427) {
            return null
          }else {
            if("\ufdd0'else") {
              return new cljs.core.BitmapIndexedNode(null, this__9425.bitmap ^ bit__9427, cljs.core.remove_pair.call(null, this__9425.arr, idx__9428))
            }else {
              return null
            }
          }
        }
      }
    }else {
      if(cljs.core.key_test.call(null, key, key_or_nil__9429)) {
        return new cljs.core.BitmapIndexedNode(null, this__9425.bitmap ^ bit__9427, cljs.core.remove_pair.call(null, this__9425.arr, idx__9428))
      }else {
        if("\ufdd0'else") {
          return inode__9426
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__9432 = this;
  var inode__9433 = this;
  var bit__9434 = 1 << (hash >>> shift & 31);
  var idx__9435 = cljs.core.bitmap_indexed_node_index.call(null, this__9432.bitmap, bit__9434);
  if((this__9432.bitmap & bit__9434) === 0) {
    var n__9436 = cljs.core.bit_count.call(null, this__9432.bitmap);
    if(n__9436 >= 16) {
      var nodes__9437 = cljs.core.make_array.call(null, 32);
      var jdx__9438 = hash >>> shift & 31;
      nodes__9437[jdx__9438] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      var i__9439 = 0;
      var j__9440 = 0;
      while(true) {
        if(i__9439 < 32) {
          if((this__9432.bitmap >>> i__9439 & 1) === 0) {
            var G__9455 = i__9439 + 1;
            var G__9456 = j__9440;
            i__9439 = G__9455;
            j__9440 = G__9456;
            continue
          }else {
            nodes__9437[i__9439] = !(this__9432.arr[j__9440] == null) ? cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, cljs.core.hash.call(null, this__9432.arr[j__9440]), this__9432.arr[j__9440], this__9432.arr[j__9440 + 1], added_leaf_QMARK_) : this__9432.arr[j__9440 + 1];
            var G__9457 = i__9439 + 1;
            var G__9458 = j__9440 + 2;
            i__9439 = G__9457;
            j__9440 = G__9458;
            continue
          }
        }else {
        }
        break
      }
      return new cljs.core.ArrayNode(null, n__9436 + 1, nodes__9437)
    }else {
      var new_arr__9441 = cljs.core.make_array.call(null, 2 * (n__9436 + 1));
      cljs.core.array_copy.call(null, this__9432.arr, 0, new_arr__9441, 0, 2 * idx__9435);
      new_arr__9441[2 * idx__9435] = key;
      new_arr__9441[2 * idx__9435 + 1] = val;
      cljs.core.array_copy.call(null, this__9432.arr, 2 * idx__9435, new_arr__9441, 2 * (idx__9435 + 1), 2 * (n__9436 - idx__9435));
      added_leaf_QMARK_.val = true;
      return new cljs.core.BitmapIndexedNode(null, this__9432.bitmap | bit__9434, new_arr__9441)
    }
  }else {
    var key_or_nil__9442 = this__9432.arr[2 * idx__9435];
    var val_or_node__9443 = this__9432.arr[2 * idx__9435 + 1];
    if(key_or_nil__9442 == null) {
      var n__9444 = val_or_node__9443.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
      if(n__9444 === val_or_node__9443) {
        return inode__9433
      }else {
        return new cljs.core.BitmapIndexedNode(null, this__9432.bitmap, cljs.core.clone_and_set.call(null, this__9432.arr, 2 * idx__9435 + 1, n__9444))
      }
    }else {
      if(cljs.core.key_test.call(null, key, key_or_nil__9442)) {
        if(val === val_or_node__9443) {
          return inode__9433
        }else {
          return new cljs.core.BitmapIndexedNode(null, this__9432.bitmap, cljs.core.clone_and_set.call(null, this__9432.arr, 2 * idx__9435 + 1, val))
        }
      }else {
        if("\ufdd0'else") {
          added_leaf_QMARK_.val = true;
          return new cljs.core.BitmapIndexedNode(null, this__9432.bitmap, cljs.core.clone_and_set.call(null, this__9432.arr, 2 * idx__9435, null, 2 * idx__9435 + 1, cljs.core.create_node.call(null, shift + 5, key_or_nil__9442, val_or_node__9443, hash, key, val)))
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var this__9445 = this;
  var inode__9446 = this;
  var bit__9447 = 1 << (hash >>> shift & 31);
  if((this__9445.bitmap & bit__9447) === 0) {
    return not_found
  }else {
    var idx__9448 = cljs.core.bitmap_indexed_node_index.call(null, this__9445.bitmap, bit__9447);
    var key_or_nil__9449 = this__9445.arr[2 * idx__9448];
    var val_or_node__9450 = this__9445.arr[2 * idx__9448 + 1];
    if(key_or_nil__9449 == null) {
      return val_or_node__9450.inode_lookup(shift + 5, hash, key, not_found)
    }else {
      if(cljs.core.key_test.call(null, key, key_or_nil__9449)) {
        return val_or_node__9450
      }else {
        if("\ufdd0'else") {
          return not_found
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.BitmapIndexedNode;
cljs.core.BitmapIndexedNode.EMPTY = new cljs.core.BitmapIndexedNode(null, 0, cljs.core.make_array.call(null, 0));
cljs.core.pack_array_node = function pack_array_node(array_node, edit, idx) {
  var arr__9466 = array_node.arr;
  var len__9467 = 2 * (array_node.cnt - 1);
  var new_arr__9468 = cljs.core.make_array.call(null, len__9467);
  var i__9469 = 0;
  var j__9470 = 1;
  var bitmap__9471 = 0;
  while(true) {
    if(i__9469 < len__9467) {
      if(function() {
        var and__3822__auto____9472 = !(i__9469 === idx);
        if(and__3822__auto____9472) {
          return!(arr__9466[i__9469] == null)
        }else {
          return and__3822__auto____9472
        }
      }()) {
        new_arr__9468[j__9470] = arr__9466[i__9469];
        var G__9473 = i__9469 + 1;
        var G__9474 = j__9470 + 2;
        var G__9475 = bitmap__9471 | 1 << i__9469;
        i__9469 = G__9473;
        j__9470 = G__9474;
        bitmap__9471 = G__9475;
        continue
      }else {
        var G__9476 = i__9469 + 1;
        var G__9477 = j__9470;
        var G__9478 = bitmap__9471;
        i__9469 = G__9476;
        j__9470 = G__9477;
        bitmap__9471 = G__9478;
        continue
      }
    }else {
      return new cljs.core.BitmapIndexedNode(edit, bitmap__9471, new_arr__9468)
    }
    break
  }
};
cljs.core.ArrayNode = function(edit, cnt, arr) {
  this.edit = edit;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.ArrayNode.cljs$lang$type = true;
cljs.core.ArrayNode.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/ArrayNode")
};
cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__9479 = this;
  var inode__9480 = this;
  var idx__9481 = hash >>> shift & 31;
  var node__9482 = this__9479.arr[idx__9481];
  if(node__9482 == null) {
    var editable__9483 = cljs.core.edit_and_set.call(null, inode__9480, edit, idx__9481, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_));
    editable__9483.cnt = editable__9483.cnt + 1;
    return editable__9483
  }else {
    var n__9484 = node__9482.inode_assoc_BANG_(edit, shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__9484 === node__9482) {
      return inode__9480
    }else {
      return cljs.core.edit_and_set.call(null, inode__9480, edit, idx__9481, n__9484)
    }
  }
};
cljs.core.ArrayNode.prototype.inode_seq = function() {
  var this__9485 = this;
  var inode__9486 = this;
  return cljs.core.create_array_node_seq.call(null, this__9485.arr)
};
cljs.core.ArrayNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__9487 = this;
  var inode__9488 = this;
  var idx__9489 = hash >>> shift & 31;
  var node__9490 = this__9487.arr[idx__9489];
  if(node__9490 == null) {
    return inode__9488
  }else {
    var n__9491 = node__9490.inode_without_BANG_(edit, shift + 5, hash, key, removed_leaf_QMARK_);
    if(n__9491 === node__9490) {
      return inode__9488
    }else {
      if(n__9491 == null) {
        if(this__9487.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__9488, edit, idx__9489)
        }else {
          var editable__9492 = cljs.core.edit_and_set.call(null, inode__9488, edit, idx__9489, n__9491);
          editable__9492.cnt = editable__9492.cnt - 1;
          return editable__9492
        }
      }else {
        if("\ufdd0'else") {
          return cljs.core.edit_and_set.call(null, inode__9488, edit, idx__9489, n__9491)
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.ArrayNode.prototype.ensure_editable = function(e) {
  var this__9493 = this;
  var inode__9494 = this;
  if(e === this__9493.edit) {
    return inode__9494
  }else {
    return new cljs.core.ArrayNode(e, this__9493.cnt, this__9493.arr.slice())
  }
};
cljs.core.ArrayNode.prototype.kv_reduce = function(f, init) {
  var this__9495 = this;
  var inode__9496 = this;
  var len__9497 = this__9495.arr.length;
  var i__9498 = 0;
  var init__9499 = init;
  while(true) {
    if(i__9498 < len__9497) {
      var node__9500 = this__9495.arr[i__9498];
      if(!(node__9500 == null)) {
        var init__9501 = node__9500.kv_reduce(f, init__9499);
        if(cljs.core.reduced_QMARK_.call(null, init__9501)) {
          return cljs.core.deref.call(null, init__9501)
        }else {
          var G__9520 = i__9498 + 1;
          var G__9521 = init__9501;
          i__9498 = G__9520;
          init__9499 = G__9521;
          continue
        }
      }else {
        return null
      }
    }else {
      return init__9499
    }
    break
  }
};
cljs.core.ArrayNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var this__9502 = this;
  var inode__9503 = this;
  var idx__9504 = hash >>> shift & 31;
  var node__9505 = this__9502.arr[idx__9504];
  if(!(node__9505 == null)) {
    return node__9505.inode_find(shift + 5, hash, key, not_found)
  }else {
    return not_found
  }
};
cljs.core.ArrayNode.prototype.inode_without = function(shift, hash, key) {
  var this__9506 = this;
  var inode__9507 = this;
  var idx__9508 = hash >>> shift & 31;
  var node__9509 = this__9506.arr[idx__9508];
  if(!(node__9509 == null)) {
    var n__9510 = node__9509.inode_without(shift + 5, hash, key);
    if(n__9510 === node__9509) {
      return inode__9507
    }else {
      if(n__9510 == null) {
        if(this__9506.cnt <= 8) {
          return cljs.core.pack_array_node.call(null, inode__9507, null, idx__9508)
        }else {
          return new cljs.core.ArrayNode(null, this__9506.cnt - 1, cljs.core.clone_and_set.call(null, this__9506.arr, idx__9508, n__9510))
        }
      }else {
        if("\ufdd0'else") {
          return new cljs.core.ArrayNode(null, this__9506.cnt, cljs.core.clone_and_set.call(null, this__9506.arr, idx__9508, n__9510))
        }else {
          return null
        }
      }
    }
  }else {
    return inode__9507
  }
};
cljs.core.ArrayNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__9511 = this;
  var inode__9512 = this;
  var idx__9513 = hash >>> shift & 31;
  var node__9514 = this__9511.arr[idx__9513];
  if(node__9514 == null) {
    return new cljs.core.ArrayNode(null, this__9511.cnt + 1, cljs.core.clone_and_set.call(null, this__9511.arr, idx__9513, cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_)))
  }else {
    var n__9515 = node__9514.inode_assoc(shift + 5, hash, key, val, added_leaf_QMARK_);
    if(n__9515 === node__9514) {
      return inode__9512
    }else {
      return new cljs.core.ArrayNode(null, this__9511.cnt, cljs.core.clone_and_set.call(null, this__9511.arr, idx__9513, n__9515))
    }
  }
};
cljs.core.ArrayNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var this__9516 = this;
  var inode__9517 = this;
  var idx__9518 = hash >>> shift & 31;
  var node__9519 = this__9516.arr[idx__9518];
  if(!(node__9519 == null)) {
    return node__9519.inode_lookup(shift + 5, hash, key, not_found)
  }else {
    return not_found
  }
};
cljs.core.ArrayNode;
cljs.core.hash_collision_node_find_index = function hash_collision_node_find_index(arr, cnt, key) {
  var lim__9524 = 2 * cnt;
  var i__9525 = 0;
  while(true) {
    if(i__9525 < lim__9524) {
      if(cljs.core.key_test.call(null, key, arr[i__9525])) {
        return i__9525
      }else {
        var G__9526 = i__9525 + 2;
        i__9525 = G__9526;
        continue
      }
    }else {
      return-1
    }
    break
  }
};
cljs.core.HashCollisionNode = function(edit, collision_hash, cnt, arr) {
  this.edit = edit;
  this.collision_hash = collision_hash;
  this.cnt = cnt;
  this.arr = arr
};
cljs.core.HashCollisionNode.cljs$lang$type = true;
cljs.core.HashCollisionNode.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/HashCollisionNode")
};
cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = function(edit, shift, hash, key, val, added_leaf_QMARK_) {
  var this__9527 = this;
  var inode__9528 = this;
  if(hash === this__9527.collision_hash) {
    var idx__9529 = cljs.core.hash_collision_node_find_index.call(null, this__9527.arr, this__9527.cnt, key);
    if(idx__9529 === -1) {
      if(this__9527.arr.length > 2 * this__9527.cnt) {
        var editable__9530 = cljs.core.edit_and_set.call(null, inode__9528, edit, 2 * this__9527.cnt, key, 2 * this__9527.cnt + 1, val);
        added_leaf_QMARK_.val = true;
        editable__9530.cnt = editable__9530.cnt + 1;
        return editable__9530
      }else {
        var len__9531 = this__9527.arr.length;
        var new_arr__9532 = cljs.core.make_array.call(null, len__9531 + 2);
        cljs.core.array_copy.call(null, this__9527.arr, 0, new_arr__9532, 0, len__9531);
        new_arr__9532[len__9531] = key;
        new_arr__9532[len__9531 + 1] = val;
        added_leaf_QMARK_.val = true;
        return inode__9528.ensure_editable_array(edit, this__9527.cnt + 1, new_arr__9532)
      }
    }else {
      if(this__9527.arr[idx__9529 + 1] === val) {
        return inode__9528
      }else {
        return cljs.core.edit_and_set.call(null, inode__9528, edit, idx__9529 + 1, val)
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(edit, 1 << (this__9527.collision_hash >>> shift & 31), [null, inode__9528, null, null])).inode_assoc_BANG_(edit, shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_seq = function() {
  var this__9533 = this;
  var inode__9534 = this;
  return cljs.core.create_inode_seq.call(null, this__9533.arr)
};
cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = function(edit, shift, hash, key, removed_leaf_QMARK_) {
  var this__9535 = this;
  var inode__9536 = this;
  var idx__9537 = cljs.core.hash_collision_node_find_index.call(null, this__9535.arr, this__9535.cnt, key);
  if(idx__9537 === -1) {
    return inode__9536
  }else {
    removed_leaf_QMARK_[0] = true;
    if(this__9535.cnt === 1) {
      return null
    }else {
      var editable__9538 = inode__9536.ensure_editable(edit);
      var earr__9539 = editable__9538.arr;
      earr__9539[idx__9537] = earr__9539[2 * this__9535.cnt - 2];
      earr__9539[idx__9537 + 1] = earr__9539[2 * this__9535.cnt - 1];
      earr__9539[2 * this__9535.cnt - 1] = null;
      earr__9539[2 * this__9535.cnt - 2] = null;
      editable__9538.cnt = editable__9538.cnt - 1;
      return editable__9538
    }
  }
};
cljs.core.HashCollisionNode.prototype.ensure_editable = function(e) {
  var this__9540 = this;
  var inode__9541 = this;
  if(e === this__9540.edit) {
    return inode__9541
  }else {
    var new_arr__9542 = cljs.core.make_array.call(null, 2 * (this__9540.cnt + 1));
    cljs.core.array_copy.call(null, this__9540.arr, 0, new_arr__9542, 0, 2 * this__9540.cnt);
    return new cljs.core.HashCollisionNode(e, this__9540.collision_hash, this__9540.cnt, new_arr__9542)
  }
};
cljs.core.HashCollisionNode.prototype.kv_reduce = function(f, init) {
  var this__9543 = this;
  var inode__9544 = this;
  return cljs.core.inode_kv_reduce.call(null, this__9543.arr, f, init)
};
cljs.core.HashCollisionNode.prototype.inode_find = function(shift, hash, key, not_found) {
  var this__9545 = this;
  var inode__9546 = this;
  var idx__9547 = cljs.core.hash_collision_node_find_index.call(null, this__9545.arr, this__9545.cnt, key);
  if(idx__9547 < 0) {
    return not_found
  }else {
    if(cljs.core.key_test.call(null, key, this__9545.arr[idx__9547])) {
      return cljs.core.PersistentVector.fromArray([this__9545.arr[idx__9547], this__9545.arr[idx__9547 + 1]], true)
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_without = function(shift, hash, key) {
  var this__9548 = this;
  var inode__9549 = this;
  var idx__9550 = cljs.core.hash_collision_node_find_index.call(null, this__9548.arr, this__9548.cnt, key);
  if(idx__9550 === -1) {
    return inode__9549
  }else {
    if(this__9548.cnt === 1) {
      return null
    }else {
      if("\ufdd0'else") {
        return new cljs.core.HashCollisionNode(null, this__9548.collision_hash, this__9548.cnt - 1, cljs.core.remove_pair.call(null, this__9548.arr, cljs.core.quot.call(null, idx__9550, 2)))
      }else {
        return null
      }
    }
  }
};
cljs.core.HashCollisionNode.prototype.inode_assoc = function(shift, hash, key, val, added_leaf_QMARK_) {
  var this__9551 = this;
  var inode__9552 = this;
  if(hash === this__9551.collision_hash) {
    var idx__9553 = cljs.core.hash_collision_node_find_index.call(null, this__9551.arr, this__9551.cnt, key);
    if(idx__9553 === -1) {
      var len__9554 = this__9551.arr.length;
      var new_arr__9555 = cljs.core.make_array.call(null, len__9554 + 2);
      cljs.core.array_copy.call(null, this__9551.arr, 0, new_arr__9555, 0, len__9554);
      new_arr__9555[len__9554] = key;
      new_arr__9555[len__9554 + 1] = val;
      added_leaf_QMARK_.val = true;
      return new cljs.core.HashCollisionNode(null, this__9551.collision_hash, this__9551.cnt + 1, new_arr__9555)
    }else {
      if(cljs.core._EQ_.call(null, this__9551.arr[idx__9553], val)) {
        return inode__9552
      }else {
        return new cljs.core.HashCollisionNode(null, this__9551.collision_hash, this__9551.cnt, cljs.core.clone_and_set.call(null, this__9551.arr, idx__9553 + 1, val))
      }
    }
  }else {
    return(new cljs.core.BitmapIndexedNode(null, 1 << (this__9551.collision_hash >>> shift & 31), [null, inode__9552])).inode_assoc(shift, hash, key, val, added_leaf_QMARK_)
  }
};
cljs.core.HashCollisionNode.prototype.inode_lookup = function(shift, hash, key, not_found) {
  var this__9556 = this;
  var inode__9557 = this;
  var idx__9558 = cljs.core.hash_collision_node_find_index.call(null, this__9556.arr, this__9556.cnt, key);
  if(idx__9558 < 0) {
    return not_found
  }else {
    if(cljs.core.key_test.call(null, key, this__9556.arr[idx__9558])) {
      return this__9556.arr[idx__9558 + 1]
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.HashCollisionNode.prototype.ensure_editable_array = function(e, count, array) {
  var this__9559 = this;
  var inode__9560 = this;
  if(e === this__9559.edit) {
    this__9559.arr = array;
    this__9559.cnt = count;
    return inode__9560
  }else {
    return new cljs.core.HashCollisionNode(this__9559.edit, this__9559.collision_hash, count, array)
  }
};
cljs.core.HashCollisionNode;
cljs.core.create_node = function() {
  var create_node = null;
  var create_node__6 = function(shift, key1, val1, key2hash, key2, val2) {
    var key1hash__9565 = cljs.core.hash.call(null, key1);
    if(key1hash__9565 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__9565, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___9566 = new cljs.core.Box(false);
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift, key1hash__9565, key1, val1, added_leaf_QMARK___9566).inode_assoc(shift, key2hash, key2, val2, added_leaf_QMARK___9566)
    }
  };
  var create_node__7 = function(edit, shift, key1, val1, key2hash, key2, val2) {
    var key1hash__9567 = cljs.core.hash.call(null, key1);
    if(key1hash__9567 === key2hash) {
      return new cljs.core.HashCollisionNode(null, key1hash__9567, 2, [key1, val1, key2, val2])
    }else {
      var added_leaf_QMARK___9568 = new cljs.core.Box(false);
      return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit, shift, key1hash__9567, key1, val1, added_leaf_QMARK___9568).inode_assoc_BANG_(edit, shift, key2hash, key2, val2, added_leaf_QMARK___9568)
    }
  };
  create_node = function(edit, shift, key1, val1, key2hash, key2, val2) {
    switch(arguments.length) {
      case 6:
        return create_node__6.call(this, edit, shift, key1, val1, key2hash, key2);
      case 7:
        return create_node__7.call(this, edit, shift, key1, val1, key2hash, key2, val2)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_node.cljs$lang$arity$6 = create_node__6;
  create_node.cljs$lang$arity$7 = create_node__7;
  return create_node
}();
cljs.core.NodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31850572
};
cljs.core.NodeSeq.cljs$lang$type = true;
cljs.core.NodeSeq.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/NodeSeq")
};
cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9569 = this;
  var h__2287__auto____9570 = this__9569.__hash;
  if(!(h__2287__auto____9570 == null)) {
    return h__2287__auto____9570
  }else {
    var h__2287__auto____9571 = cljs.core.hash_coll.call(null, coll);
    this__9569.__hash = h__2287__auto____9571;
    return h__2287__auto____9571
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__9572 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.NodeSeq.prototype.toString = function() {
  var this__9573 = this;
  var this__9574 = this;
  return cljs.core.pr_str.call(null, this__9574)
};
cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__9575 = this;
  return this$
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__9576 = this;
  if(this__9576.s == null) {
    return cljs.core.PersistentVector.fromArray([this__9576.nodes[this__9576.i], this__9576.nodes[this__9576.i + 1]], true)
  }else {
    return cljs.core.first.call(null, this__9576.s)
  }
};
cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__9577 = this;
  if(this__9577.s == null) {
    return cljs.core.create_inode_seq.call(null, this__9577.nodes, this__9577.i + 2, null)
  }else {
    return cljs.core.create_inode_seq.call(null, this__9577.nodes, this__9577.i, cljs.core.next.call(null, this__9577.s))
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9578 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__9579 = this;
  return new cljs.core.NodeSeq(meta, this__9579.nodes, this__9579.i, this__9579.s, this__9579.__hash)
};
cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__9580 = this;
  return this__9580.meta
};
cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__9581 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__9581.meta)
};
cljs.core.NodeSeq;
cljs.core.create_inode_seq = function() {
  var create_inode_seq = null;
  var create_inode_seq__1 = function(nodes) {
    return create_inode_seq.call(null, nodes, 0, null)
  };
  var create_inode_seq__3 = function(nodes, i, s) {
    if(s == null) {
      var len__9588 = nodes.length;
      var j__9589 = i;
      while(true) {
        if(j__9589 < len__9588) {
          if(!(nodes[j__9589] == null)) {
            return new cljs.core.NodeSeq(null, nodes, j__9589, null, null)
          }else {
            var temp__3971__auto____9590 = nodes[j__9589 + 1];
            if(cljs.core.truth_(temp__3971__auto____9590)) {
              var node__9591 = temp__3971__auto____9590;
              var temp__3971__auto____9592 = node__9591.inode_seq();
              if(cljs.core.truth_(temp__3971__auto____9592)) {
                var node_seq__9593 = temp__3971__auto____9592;
                return new cljs.core.NodeSeq(null, nodes, j__9589 + 2, node_seq__9593, null)
              }else {
                var G__9594 = j__9589 + 2;
                j__9589 = G__9594;
                continue
              }
            }else {
              var G__9595 = j__9589 + 2;
              j__9589 = G__9595;
              continue
            }
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.NodeSeq(null, nodes, i, s, null)
    }
  };
  create_inode_seq = function(nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_inode_seq__1.call(this, nodes);
      case 3:
        return create_inode_seq__3.call(this, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_inode_seq.cljs$lang$arity$1 = create_inode_seq__1;
  create_inode_seq.cljs$lang$arity$3 = create_inode_seq__3;
  return create_inode_seq
}();
cljs.core.ArrayNodeSeq = function(meta, nodes, i, s, __hash) {
  this.meta = meta;
  this.nodes = nodes;
  this.i = i;
  this.s = s;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31850572
};
cljs.core.ArrayNodeSeq.cljs$lang$type = true;
cljs.core.ArrayNodeSeq.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/ArrayNodeSeq")
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9596 = this;
  var h__2287__auto____9597 = this__9596.__hash;
  if(!(h__2287__auto____9597 == null)) {
    return h__2287__auto____9597
  }else {
    var h__2287__auto____9598 = cljs.core.hash_coll.call(null, coll);
    this__9596.__hash = h__2287__auto____9598;
    return h__2287__auto____9598
  }
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__9599 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.ArrayNodeSeq.prototype.toString = function() {
  var this__9600 = this;
  var this__9601 = this;
  return cljs.core.pr_str.call(null, this__9601)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__9602 = this;
  return this$
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(coll) {
  var this__9603 = this;
  return cljs.core.first.call(null, this__9603.s)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(coll) {
  var this__9604 = this;
  return cljs.core.create_array_node_seq.call(null, null, this__9604.nodes, this__9604.i, cljs.core.next.call(null, this__9604.s))
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9605 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__9606 = this;
  return new cljs.core.ArrayNodeSeq(meta, this__9606.nodes, this__9606.i, this__9606.s, this__9606.__hash)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__9607 = this;
  return this__9607.meta
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__9608 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__9608.meta)
};
cljs.core.ArrayNodeSeq;
cljs.core.create_array_node_seq = function() {
  var create_array_node_seq = null;
  var create_array_node_seq__1 = function(nodes) {
    return create_array_node_seq.call(null, null, nodes, 0, null)
  };
  var create_array_node_seq__4 = function(meta, nodes, i, s) {
    if(s == null) {
      var len__9615 = nodes.length;
      var j__9616 = i;
      while(true) {
        if(j__9616 < len__9615) {
          var temp__3971__auto____9617 = nodes[j__9616];
          if(cljs.core.truth_(temp__3971__auto____9617)) {
            var nj__9618 = temp__3971__auto____9617;
            var temp__3971__auto____9619 = nj__9618.inode_seq();
            if(cljs.core.truth_(temp__3971__auto____9619)) {
              var ns__9620 = temp__3971__auto____9619;
              return new cljs.core.ArrayNodeSeq(meta, nodes, j__9616 + 1, ns__9620, null)
            }else {
              var G__9621 = j__9616 + 1;
              j__9616 = G__9621;
              continue
            }
          }else {
            var G__9622 = j__9616 + 1;
            j__9616 = G__9622;
            continue
          }
        }else {
          return null
        }
        break
      }
    }else {
      return new cljs.core.ArrayNodeSeq(meta, nodes, i, s, null)
    }
  };
  create_array_node_seq = function(meta, nodes, i, s) {
    switch(arguments.length) {
      case 1:
        return create_array_node_seq__1.call(this, meta);
      case 4:
        return create_array_node_seq__4.call(this, meta, nodes, i, s)
    }
    throw"Invalid arity: " + arguments.length;
  };
  create_array_node_seq.cljs$lang$arity$1 = create_array_node_seq__1;
  create_array_node_seq.cljs$lang$arity$4 = create_array_node_seq__4;
  return create_array_node_seq
}();
cljs.core.PersistentHashMap = function(meta, cnt, root, has_nil_QMARK_, nil_val, __hash) {
  this.meta = meta;
  this.cnt = cnt;
  this.root = root;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 1;
  this.cljs$lang$protocol_mask$partition0$ = 16123663
};
cljs.core.PersistentHashMap.cljs$lang$type = true;
cljs.core.PersistentHashMap.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentHashMap")
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__9625 = this;
  return new cljs.core.TransientHashMap({}, this__9625.root, this__9625.cnt, this__9625.has_nil_QMARK_, this__9625.nil_val)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9626 = this;
  var h__2287__auto____9627 = this__9626.__hash;
  if(!(h__2287__auto____9627 == null)) {
    return h__2287__auto____9627
  }else {
    var h__2287__auto____9628 = cljs.core.hash_imap.call(null, coll);
    this__9626.__hash = h__2287__auto____9628;
    return h__2287__auto____9628
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__9629 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, k, null)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__9630 = this;
  if(k == null) {
    if(this__9630.has_nil_QMARK_) {
      return this__9630.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__9630.root == null) {
      return not_found
    }else {
      if("\ufdd0'else") {
        return this__9630.root.inode_lookup(0, cljs.core.hash.call(null, k), k, not_found)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__9631 = this;
  if(k == null) {
    if(function() {
      var and__3822__auto____9632 = this__9631.has_nil_QMARK_;
      if(and__3822__auto____9632) {
        return v === this__9631.nil_val
      }else {
        return and__3822__auto____9632
      }
    }()) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__9631.meta, this__9631.has_nil_QMARK_ ? this__9631.cnt : this__9631.cnt + 1, this__9631.root, true, v, null)
    }
  }else {
    var added_leaf_QMARK___9633 = new cljs.core.Box(false);
    var new_root__9634 = (this__9631.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__9631.root).inode_assoc(0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___9633);
    if(new_root__9634 === this__9631.root) {
      return coll
    }else {
      return new cljs.core.PersistentHashMap(this__9631.meta, added_leaf_QMARK___9633.val ? this__9631.cnt + 1 : this__9631.cnt, new_root__9634, this__9631.has_nil_QMARK_, this__9631.nil_val, null)
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__9635 = this;
  if(k == null) {
    return this__9635.has_nil_QMARK_
  }else {
    if(this__9635.root == null) {
      return false
    }else {
      if("\ufdd0'else") {
        return!(this__9635.root.inode_lookup(0, cljs.core.hash.call(null, k), k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.call = function() {
  var G__9658 = null;
  var G__9658__2 = function(this_sym9636, k) {
    var this__9638 = this;
    var this_sym9636__9639 = this;
    var coll__9640 = this_sym9636__9639;
    return coll__9640.cljs$core$ILookup$_lookup$arity$2(coll__9640, k)
  };
  var G__9658__3 = function(this_sym9637, k, not_found) {
    var this__9638 = this;
    var this_sym9637__9641 = this;
    var coll__9642 = this_sym9637__9641;
    return coll__9642.cljs$core$ILookup$_lookup$arity$3(coll__9642, k, not_found)
  };
  G__9658 = function(this_sym9637, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__9658__2.call(this, this_sym9637, k);
      case 3:
        return G__9658__3.call(this, this_sym9637, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__9658
}();
cljs.core.PersistentHashMap.prototype.apply = function(this_sym9623, args9624) {
  var this__9643 = this;
  return this_sym9623.call.apply(this_sym9623, [this_sym9623].concat(args9624.slice()))
};
cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__9644 = this;
  var init__9645 = this__9644.has_nil_QMARK_ ? f.call(null, init, null, this__9644.nil_val) : init;
  if(cljs.core.reduced_QMARK_.call(null, init__9645)) {
    return cljs.core.deref.call(null, init__9645)
  }else {
    if(!(this__9644.root == null)) {
      return this__9644.root.kv_reduce(f, init__9645)
    }else {
      if("\ufdd0'else") {
        return init__9645
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__9646 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentHashMap.prototype.toString = function() {
  var this__9647 = this;
  var this__9648 = this;
  return cljs.core.pr_str.call(null, this__9648)
};
cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__9649 = this;
  if(this__9649.cnt > 0) {
    var s__9650 = !(this__9649.root == null) ? this__9649.root.inode_seq() : null;
    if(this__9649.has_nil_QMARK_) {
      return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([null, this__9649.nil_val], true), s__9650)
    }else {
      return s__9650
    }
  }else {
    return null
  }
};
cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__9651 = this;
  return this__9651.cnt
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9652 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__9653 = this;
  return new cljs.core.PersistentHashMap(meta, this__9653.cnt, this__9653.root, this__9653.has_nil_QMARK_, this__9653.nil_val, this__9653.__hash)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__9654 = this;
  return this__9654.meta
};
cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__9655 = this;
  return cljs.core._with_meta.call(null, cljs.core.PersistentHashMap.EMPTY, this__9655.meta)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__9656 = this;
  if(k == null) {
    if(this__9656.has_nil_QMARK_) {
      return new cljs.core.PersistentHashMap(this__9656.meta, this__9656.cnt - 1, this__9656.root, false, null, null)
    }else {
      return coll
    }
  }else {
    if(this__9656.root == null) {
      return coll
    }else {
      if("\ufdd0'else") {
        var new_root__9657 = this__9656.root.inode_without(0, cljs.core.hash.call(null, k), k);
        if(new_root__9657 === this__9656.root) {
          return coll
        }else {
          return new cljs.core.PersistentHashMap(this__9656.meta, this__9656.cnt - 1, new_root__9657, this__9656.has_nil_QMARK_, this__9656.nil_val, null)
        }
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentHashMap;
cljs.core.PersistentHashMap.EMPTY = new cljs.core.PersistentHashMap(null, 0, null, false, null, 0);
cljs.core.PersistentHashMap.fromArrays = function(ks, vs) {
  var len__9659 = ks.length;
  var i__9660 = 0;
  var out__9661 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
  while(true) {
    if(i__9660 < len__9659) {
      var G__9662 = i__9660 + 1;
      var G__9663 = cljs.core.assoc_BANG_.call(null, out__9661, ks[i__9660], vs[i__9660]);
      i__9660 = G__9662;
      out__9661 = G__9663;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__9661)
    }
    break
  }
};
cljs.core.TransientHashMap = function(edit, root, count, has_nil_QMARK_, nil_val) {
  this.edit = edit;
  this.root = root;
  this.count = count;
  this.has_nil_QMARK_ = has_nil_QMARK_;
  this.nil_val = nil_val;
  this.cljs$lang$protocol_mask$partition1$ = 14;
  this.cljs$lang$protocol_mask$partition0$ = 258
};
cljs.core.TransientHashMap.cljs$lang$type = true;
cljs.core.TransientHashMap.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/TransientHashMap")
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = function(tcoll, key) {
  var this__9664 = this;
  return tcoll.without_BANG_(key)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = function(tcoll, key, val) {
  var this__9665 = this;
  return tcoll.assoc_BANG_(key, val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, val) {
  var this__9666 = this;
  return tcoll.conj_BANG_(val)
};
cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__9667 = this;
  return tcoll.persistent_BANG_()
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, k) {
  var this__9668 = this;
  if(k == null) {
    if(this__9668.has_nil_QMARK_) {
      return this__9668.nil_val
    }else {
      return null
    }
  }else {
    if(this__9668.root == null) {
      return null
    }else {
      return this__9668.root.inode_lookup(0, cljs.core.hash.call(null, k), k)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, k, not_found) {
  var this__9669 = this;
  if(k == null) {
    if(this__9669.has_nil_QMARK_) {
      return this__9669.nil_val
    }else {
      return not_found
    }
  }else {
    if(this__9669.root == null) {
      return not_found
    }else {
      return this__9669.root.inode_lookup(0, cljs.core.hash.call(null, k), k, not_found)
    }
  }
};
cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__9670 = this;
  if(this__9670.edit) {
    return this__9670.count
  }else {
    throw new Error("count after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.conj_BANG_ = function(o) {
  var this__9671 = this;
  var tcoll__9672 = this;
  if(this__9671.edit) {
    if(function() {
      var G__9673__9674 = o;
      if(G__9673__9674) {
        if(function() {
          var or__3824__auto____9675 = G__9673__9674.cljs$lang$protocol_mask$partition0$ & 2048;
          if(or__3824__auto____9675) {
            return or__3824__auto____9675
          }else {
            return G__9673__9674.cljs$core$IMapEntry$
          }
        }()) {
          return true
        }else {
          if(!G__9673__9674.cljs$lang$protocol_mask$partition0$) {
            return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__9673__9674)
          }else {
            return false
          }
        }
      }else {
        return cljs.core.type_satisfies_.call(null, cljs.core.IMapEntry, G__9673__9674)
      }
    }()) {
      return tcoll__9672.assoc_BANG_(cljs.core.key.call(null, o), cljs.core.val.call(null, o))
    }else {
      var es__9676 = cljs.core.seq.call(null, o);
      var tcoll__9677 = tcoll__9672;
      while(true) {
        var temp__3971__auto____9678 = cljs.core.first.call(null, es__9676);
        if(cljs.core.truth_(temp__3971__auto____9678)) {
          var e__9679 = temp__3971__auto____9678;
          var G__9690 = cljs.core.next.call(null, es__9676);
          var G__9691 = tcoll__9677.assoc_BANG_(cljs.core.key.call(null, e__9679), cljs.core.val.call(null, e__9679));
          es__9676 = G__9690;
          tcoll__9677 = G__9691;
          continue
        }else {
          return tcoll__9677
        }
        break
      }
    }
  }else {
    throw new Error("conj! after persistent");
  }
};
cljs.core.TransientHashMap.prototype.assoc_BANG_ = function(k, v) {
  var this__9680 = this;
  var tcoll__9681 = this;
  if(this__9680.edit) {
    if(k == null) {
      if(this__9680.nil_val === v) {
      }else {
        this__9680.nil_val = v
      }
      if(this__9680.has_nil_QMARK_) {
      }else {
        this__9680.count = this__9680.count + 1;
        this__9680.has_nil_QMARK_ = true
      }
      return tcoll__9681
    }else {
      var added_leaf_QMARK___9682 = new cljs.core.Box(false);
      var node__9683 = (this__9680.root == null ? cljs.core.BitmapIndexedNode.EMPTY : this__9680.root).inode_assoc_BANG_(this__9680.edit, 0, cljs.core.hash.call(null, k), k, v, added_leaf_QMARK___9682);
      if(node__9683 === this__9680.root) {
      }else {
        this__9680.root = node__9683
      }
      if(added_leaf_QMARK___9682.val) {
        this__9680.count = this__9680.count + 1
      }else {
      }
      return tcoll__9681
    }
  }else {
    throw new Error("assoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.without_BANG_ = function(k) {
  var this__9684 = this;
  var tcoll__9685 = this;
  if(this__9684.edit) {
    if(k == null) {
      if(this__9684.has_nil_QMARK_) {
        this__9684.has_nil_QMARK_ = false;
        this__9684.nil_val = null;
        this__9684.count = this__9684.count - 1;
        return tcoll__9685
      }else {
        return tcoll__9685
      }
    }else {
      if(this__9684.root == null) {
        return tcoll__9685
      }else {
        var removed_leaf_QMARK___9686 = new cljs.core.Box(false);
        var node__9687 = this__9684.root.inode_without_BANG_(this__9684.edit, 0, cljs.core.hash.call(null, k), k, removed_leaf_QMARK___9686);
        if(node__9687 === this__9684.root) {
        }else {
          this__9684.root = node__9687
        }
        if(cljs.core.truth_(removed_leaf_QMARK___9686[0])) {
          this__9684.count = this__9684.count - 1
        }else {
        }
        return tcoll__9685
      }
    }
  }else {
    throw new Error("dissoc! after persistent!");
  }
};
cljs.core.TransientHashMap.prototype.persistent_BANG_ = function() {
  var this__9688 = this;
  var tcoll__9689 = this;
  if(this__9688.edit) {
    this__9688.edit = null;
    return new cljs.core.PersistentHashMap(null, this__9688.count, this__9688.root, this__9688.has_nil_QMARK_, this__9688.nil_val, null)
  }else {
    throw new Error("persistent! called twice");
  }
};
cljs.core.TransientHashMap;
cljs.core.tree_map_seq_push = function tree_map_seq_push(node, stack, ascending_QMARK_) {
  var t__9694 = node;
  var stack__9695 = stack;
  while(true) {
    if(!(t__9694 == null)) {
      var G__9696 = ascending_QMARK_ ? t__9694.left : t__9694.right;
      var G__9697 = cljs.core.conj.call(null, stack__9695, t__9694);
      t__9694 = G__9696;
      stack__9695 = G__9697;
      continue
    }else {
      return stack__9695
    }
    break
  }
};
cljs.core.PersistentTreeMapSeq = function(meta, stack, ascending_QMARK_, cnt, __hash) {
  this.meta = meta;
  this.stack = stack;
  this.ascending_QMARK_ = ascending_QMARK_;
  this.cnt = cnt;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 31850570
};
cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;
cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentTreeMapSeq")
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9698 = this;
  var h__2287__auto____9699 = this__9698.__hash;
  if(!(h__2287__auto____9699 == null)) {
    return h__2287__auto____9699
  }else {
    var h__2287__auto____9700 = cljs.core.hash_coll.call(null, coll);
    this__9698.__hash = h__2287__auto____9700;
    return h__2287__auto____9700
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__9701 = this;
  return cljs.core.cons.call(null, o, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.toString = function() {
  var this__9702 = this;
  var this__9703 = this;
  return cljs.core.pr_str.call(null, this__9703)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = function(this$) {
  var this__9704 = this;
  return this$
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__9705 = this;
  if(this__9705.cnt < 0) {
    return cljs.core.count.call(null, cljs.core.next.call(null, coll)) + 1
  }else {
    return this__9705.cnt
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = function(this$) {
  var this__9706 = this;
  return cljs.core.peek.call(null, this__9706.stack)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = function(this$) {
  var this__9707 = this;
  var t__9708 = cljs.core.first.call(null, this__9707.stack);
  var next_stack__9709 = cljs.core.tree_map_seq_push.call(null, this__9707.ascending_QMARK_ ? t__9708.right : t__9708.left, cljs.core.next.call(null, this__9707.stack), this__9707.ascending_QMARK_);
  if(!(next_stack__9709 == null)) {
    return new cljs.core.PersistentTreeMapSeq(null, next_stack__9709, this__9707.ascending_QMARK_, this__9707.cnt - 1, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9710 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__9711 = this;
  return new cljs.core.PersistentTreeMapSeq(meta, this__9711.stack, this__9711.ascending_QMARK_, this__9711.cnt, this__9711.__hash)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__9712 = this;
  return this__9712.meta
};
cljs.core.PersistentTreeMapSeq;
cljs.core.create_tree_map_seq = function create_tree_map_seq(tree, ascending_QMARK_, cnt) {
  return new cljs.core.PersistentTreeMapSeq(null, cljs.core.tree_map_seq_push.call(null, tree, null, ascending_QMARK_), ascending_QMARK_, cnt, null)
};
cljs.core.balance_left = function balance_left(key, val, ins, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
      return new cljs.core.RedNode(ins.key, ins.val, ins.left.blacken(), new cljs.core.BlackNode(key, val, ins.right, right, null), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
        return new cljs.core.RedNode(ins.right.key, ins.right.val, new cljs.core.BlackNode(ins.key, ins.val, ins.left, ins.right.left, null), new cljs.core.BlackNode(key, val, ins.right.right, right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, ins, right, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, ins, right, null)
  }
};
cljs.core.balance_right = function balance_right(key, val, left, ins) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins)) {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.right)) {
      return new cljs.core.RedNode(ins.key, ins.val, new cljs.core.BlackNode(key, val, left, ins.left, null), ins.right.blacken(), null)
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, ins.left)) {
        return new cljs.core.RedNode(ins.left.key, ins.left.val, new cljs.core.BlackNode(key, val, left, ins.left.left, null), new cljs.core.BlackNode(ins.key, ins.val, ins.left.right, ins.right, null), null)
      }else {
        if("\ufdd0'else") {
          return new cljs.core.BlackNode(key, val, left, ins, null)
        }else {
          return null
        }
      }
    }
  }else {
    return new cljs.core.BlackNode(key, val, left, ins, null)
  }
};
cljs.core.balance_left_del = function balance_left_del(key, val, del, right) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, del.blacken(), right, null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right)) {
      return cljs.core.balance_right.call(null, key, val, del, right.redden())
    }else {
      if(function() {
        var and__3822__auto____9714 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right);
        if(and__3822__auto____9714) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, right.left)
        }else {
          return and__3822__auto____9714
        }
      }()) {
        return new cljs.core.RedNode(right.left.key, right.left.val, new cljs.core.BlackNode(key, val, del, right.left.left, null), cljs.core.balance_right.call(null, right.key, right.val, right.left.right, right.right.redden()), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.balance_right_del = function balance_right_del(key, val, left, del) {
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, del)) {
    return new cljs.core.RedNode(key, val, left, del.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left)) {
      return cljs.core.balance_left.call(null, key, val, left.redden(), del)
    }else {
      if(function() {
        var and__3822__auto____9716 = cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left);
        if(and__3822__auto____9716) {
          return cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, left.right)
        }else {
          return and__3822__auto____9716
        }
      }()) {
        return new cljs.core.RedNode(left.right.key, left.right.val, cljs.core.balance_left.call(null, left.key, left.val, left.left.redden(), left.right.left), new cljs.core.BlackNode(key, val, left.right.right, del, null), null)
      }else {
        if("\ufdd0'else") {
          throw new Error("red-black tree invariant violation");
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_kv_reduce = function tree_map_kv_reduce(node, f, init) {
  var init__9720 = f.call(null, init, node.key, node.val);
  if(cljs.core.reduced_QMARK_.call(null, init__9720)) {
    return cljs.core.deref.call(null, init__9720)
  }else {
    var init__9721 = !(node.left == null) ? tree_map_kv_reduce.call(null, node.left, f, init__9720) : init__9720;
    if(cljs.core.reduced_QMARK_.call(null, init__9721)) {
      return cljs.core.deref.call(null, init__9721)
    }else {
      var init__9722 = !(node.right == null) ? tree_map_kv_reduce.call(null, node.right, f, init__9721) : init__9721;
      if(cljs.core.reduced_QMARK_.call(null, init__9722)) {
        return cljs.core.deref.call(null, init__9722)
      }else {
        return init__9722
      }
    }
  }
};
cljs.core.BlackNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32402207
};
cljs.core.BlackNode.cljs$lang$type = true;
cljs.core.BlackNode.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/BlackNode")
};
cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9725 = this;
  var h__2287__auto____9726 = this__9725.__hash;
  if(!(h__2287__auto____9726 == null)) {
    return h__2287__auto____9726
  }else {
    var h__2287__auto____9727 = cljs.core.hash_coll.call(null, coll);
    this__9725.__hash = h__2287__auto____9727;
    return h__2287__auto____9727
  }
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__9728 = this;
  return node.cljs$core$IIndexed$_nth$arity$3(node, k, null)
};
cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__9729 = this;
  return node.cljs$core$IIndexed$_nth$arity$3(node, k, not_found)
};
cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__9730 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__9730.key, this__9730.val], true), k, v)
};
cljs.core.BlackNode.prototype.call = function() {
  var G__9778 = null;
  var G__9778__2 = function(this_sym9731, k) {
    var this__9733 = this;
    var this_sym9731__9734 = this;
    var node__9735 = this_sym9731__9734;
    return node__9735.cljs$core$ILookup$_lookup$arity$2(node__9735, k)
  };
  var G__9778__3 = function(this_sym9732, k, not_found) {
    var this__9733 = this;
    var this_sym9732__9736 = this;
    var node__9737 = this_sym9732__9736;
    return node__9737.cljs$core$ILookup$_lookup$arity$3(node__9737, k, not_found)
  };
  G__9778 = function(this_sym9732, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__9778__2.call(this, this_sym9732, k);
      case 3:
        return G__9778__3.call(this, this_sym9732, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__9778
}();
cljs.core.BlackNode.prototype.apply = function(this_sym9723, args9724) {
  var this__9738 = this;
  return this_sym9723.call.apply(this_sym9723, [this_sym9723].concat(args9724.slice()))
};
cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__9739 = this;
  return cljs.core.PersistentVector.fromArray([this__9739.key, this__9739.val, o], true)
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__9740 = this;
  return this__9740.key
};
cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__9741 = this;
  return this__9741.val
};
cljs.core.BlackNode.prototype.add_right = function(ins) {
  var this__9742 = this;
  var node__9743 = this;
  return ins.balance_right(node__9743)
};
cljs.core.BlackNode.prototype.redden = function() {
  var this__9744 = this;
  var node__9745 = this;
  return new cljs.core.RedNode(this__9744.key, this__9744.val, this__9744.left, this__9744.right, null)
};
cljs.core.BlackNode.prototype.remove_right = function(del) {
  var this__9746 = this;
  var node__9747 = this;
  return cljs.core.balance_right_del.call(null, this__9746.key, this__9746.val, this__9746.left, del)
};
cljs.core.BlackNode.prototype.replace = function(key, val, left, right) {
  var this__9748 = this;
  var node__9749 = this;
  return new cljs.core.BlackNode(key, val, left, right, null)
};
cljs.core.BlackNode.prototype.kv_reduce = function(f, init) {
  var this__9750 = this;
  var node__9751 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__9751, f, init)
};
cljs.core.BlackNode.prototype.remove_left = function(del) {
  var this__9752 = this;
  var node__9753 = this;
  return cljs.core.balance_left_del.call(null, this__9752.key, this__9752.val, del, this__9752.right)
};
cljs.core.BlackNode.prototype.add_left = function(ins) {
  var this__9754 = this;
  var node__9755 = this;
  return ins.balance_left(node__9755)
};
cljs.core.BlackNode.prototype.balance_left = function(parent) {
  var this__9756 = this;
  var node__9757 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, node__9757, parent.right, null)
};
cljs.core.BlackNode.prototype.toString = function() {
  var G__9779 = null;
  var G__9779__0 = function() {
    var this__9758 = this;
    var this__9760 = this;
    return cljs.core.pr_str.call(null, this__9760)
  };
  G__9779 = function() {
    switch(arguments.length) {
      case 0:
        return G__9779__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__9779
}();
cljs.core.BlackNode.prototype.balance_right = function(parent) {
  var this__9761 = this;
  var node__9762 = this;
  return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__9762, null)
};
cljs.core.BlackNode.prototype.blacken = function() {
  var this__9763 = this;
  var node__9764 = this;
  return node__9764
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__9765 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__9766 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__9767 = this;
  return cljs.core.list.call(null, this__9767.key, this__9767.val)
};
cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__9768 = this;
  return 2
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__9769 = this;
  return this__9769.val
};
cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__9770 = this;
  return cljs.core.PersistentVector.fromArray([this__9770.key], true)
};
cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__9771 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__9771.key, this__9771.val], true), n, v)
};
cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9772 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__9773 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__9773.key, this__9773.val], true), meta)
};
cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__9774 = this;
  return null
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__9775 = this;
  if(n === 0) {
    return this__9775.key
  }else {
    if(n === 1) {
      return this__9775.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__9776 = this;
  if(n === 0) {
    return this__9776.key
  }else {
    if(n === 1) {
      return this__9776.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__9777 = this;
  return cljs.core.PersistentVector.EMPTY
};
cljs.core.BlackNode;
cljs.core.RedNode = function(key, val, left, right, __hash) {
  this.key = key;
  this.val = val;
  this.left = left;
  this.right = right;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32402207
};
cljs.core.RedNode.cljs$lang$type = true;
cljs.core.RedNode.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/RedNode")
};
cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9782 = this;
  var h__2287__auto____9783 = this__9782.__hash;
  if(!(h__2287__auto____9783 == null)) {
    return h__2287__auto____9783
  }else {
    var h__2287__auto____9784 = cljs.core.hash_coll.call(null, coll);
    this__9782.__hash = h__2287__auto____9784;
    return h__2287__auto____9784
  }
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = function(node, k) {
  var this__9785 = this;
  return node.cljs$core$IIndexed$_nth$arity$3(node, k, null)
};
cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = function(node, k, not_found) {
  var this__9786 = this;
  return node.cljs$core$IIndexed$_nth$arity$3(node, k, not_found)
};
cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(node, k, v) {
  var this__9787 = this;
  return cljs.core.assoc.call(null, cljs.core.PersistentVector.fromArray([this__9787.key, this__9787.val], true), k, v)
};
cljs.core.RedNode.prototype.call = function() {
  var G__9835 = null;
  var G__9835__2 = function(this_sym9788, k) {
    var this__9790 = this;
    var this_sym9788__9791 = this;
    var node__9792 = this_sym9788__9791;
    return node__9792.cljs$core$ILookup$_lookup$arity$2(node__9792, k)
  };
  var G__9835__3 = function(this_sym9789, k, not_found) {
    var this__9790 = this;
    var this_sym9789__9793 = this;
    var node__9794 = this_sym9789__9793;
    return node__9794.cljs$core$ILookup$_lookup$arity$3(node__9794, k, not_found)
  };
  G__9835 = function(this_sym9789, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__9835__2.call(this, this_sym9789, k);
      case 3:
        return G__9835__3.call(this, this_sym9789, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__9835
}();
cljs.core.RedNode.prototype.apply = function(this_sym9780, args9781) {
  var this__9795 = this;
  return this_sym9780.call.apply(this_sym9780, [this_sym9780].concat(args9781.slice()))
};
cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = function(node, o) {
  var this__9796 = this;
  return cljs.core.PersistentVector.fromArray([this__9796.key, this__9796.val, o], true)
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = function(node) {
  var this__9797 = this;
  return this__9797.key
};
cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = function(node) {
  var this__9798 = this;
  return this__9798.val
};
cljs.core.RedNode.prototype.add_right = function(ins) {
  var this__9799 = this;
  var node__9800 = this;
  return new cljs.core.RedNode(this__9799.key, this__9799.val, this__9799.left, ins, null)
};
cljs.core.RedNode.prototype.redden = function() {
  var this__9801 = this;
  var node__9802 = this;
  throw new Error("red-black tree invariant violation");
};
cljs.core.RedNode.prototype.remove_right = function(del) {
  var this__9803 = this;
  var node__9804 = this;
  return new cljs.core.RedNode(this__9803.key, this__9803.val, this__9803.left, del, null)
};
cljs.core.RedNode.prototype.replace = function(key, val, left, right) {
  var this__9805 = this;
  var node__9806 = this;
  return new cljs.core.RedNode(key, val, left, right, null)
};
cljs.core.RedNode.prototype.kv_reduce = function(f, init) {
  var this__9807 = this;
  var node__9808 = this;
  return cljs.core.tree_map_kv_reduce.call(null, node__9808, f, init)
};
cljs.core.RedNode.prototype.remove_left = function(del) {
  var this__9809 = this;
  var node__9810 = this;
  return new cljs.core.RedNode(this__9809.key, this__9809.val, del, this__9809.right, null)
};
cljs.core.RedNode.prototype.add_left = function(ins) {
  var this__9811 = this;
  var node__9812 = this;
  return new cljs.core.RedNode(this__9811.key, this__9811.val, ins, this__9811.right, null)
};
cljs.core.RedNode.prototype.balance_left = function(parent) {
  var this__9813 = this;
  var node__9814 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__9813.left)) {
    return new cljs.core.RedNode(this__9813.key, this__9813.val, this__9813.left.blacken(), new cljs.core.BlackNode(parent.key, parent.val, this__9813.right, parent.right, null), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__9813.right)) {
      return new cljs.core.RedNode(this__9813.right.key, this__9813.right.val, new cljs.core.BlackNode(this__9813.key, this__9813.val, this__9813.left, this__9813.right.left, null), new cljs.core.BlackNode(parent.key, parent.val, this__9813.right.right, parent.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, node__9814, parent.right, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.toString = function() {
  var G__9836 = null;
  var G__9836__0 = function() {
    var this__9815 = this;
    var this__9817 = this;
    return cljs.core.pr_str.call(null, this__9817)
  };
  G__9836 = function() {
    switch(arguments.length) {
      case 0:
        return G__9836__0.call(this)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__9836
}();
cljs.core.RedNode.prototype.balance_right = function(parent) {
  var this__9818 = this;
  var node__9819 = this;
  if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__9818.right)) {
    return new cljs.core.RedNode(this__9818.key, this__9818.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__9818.left, null), this__9818.right.blacken(), null)
  }else {
    if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, this__9818.left)) {
      return new cljs.core.RedNode(this__9818.left.key, this__9818.left.val, new cljs.core.BlackNode(parent.key, parent.val, parent.left, this__9818.left.left, null), new cljs.core.BlackNode(this__9818.key, this__9818.val, this__9818.left.right, this__9818.right, null), null)
    }else {
      if("\ufdd0'else") {
        return new cljs.core.BlackNode(parent.key, parent.val, parent.left, node__9819, null)
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.blacken = function() {
  var this__9820 = this;
  var node__9821 = this;
  return new cljs.core.BlackNode(this__9820.key, this__9820.val, this__9820.left, this__9820.right, null)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = function(node, f) {
  var this__9822 = this;
  return cljs.core.ci_reduce.call(null, node, f)
};
cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = function(node, f, start) {
  var this__9823 = this;
  return cljs.core.ci_reduce.call(null, node, f, start)
};
cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = function(node) {
  var this__9824 = this;
  return cljs.core.list.call(null, this__9824.key, this__9824.val)
};
cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = function(node) {
  var this__9825 = this;
  return 2
};
cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = function(node) {
  var this__9826 = this;
  return this__9826.val
};
cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = function(node) {
  var this__9827 = this;
  return cljs.core.PersistentVector.fromArray([this__9827.key], true)
};
cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = function(node, n, v) {
  var this__9828 = this;
  return cljs.core._assoc_n.call(null, cljs.core.PersistentVector.fromArray([this__9828.key, this__9828.val], true), n, v)
};
cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9829 = this;
  return cljs.core.equiv_sequential.call(null, coll, other)
};
cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(node, meta) {
  var this__9830 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentVector.fromArray([this__9830.key, this__9830.val], true), meta)
};
cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = function(node) {
  var this__9831 = this;
  return null
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = function(node, n) {
  var this__9832 = this;
  if(n === 0) {
    return this__9832.key
  }else {
    if(n === 1) {
      return this__9832.val
    }else {
      if("\ufdd0'else") {
        return null
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = function(node, n, not_found) {
  var this__9833 = this;
  if(n === 0) {
    return this__9833.key
  }else {
    if(n === 1) {
      return this__9833.val
    }else {
      if("\ufdd0'else") {
        return not_found
      }else {
        return null
      }
    }
  }
};
cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(node) {
  var this__9834 = this;
  return cljs.core.PersistentVector.EMPTY
};
cljs.core.RedNode;
cljs.core.tree_map_add = function tree_map_add(comp, tree, k, v, found) {
  if(tree == null) {
    return new cljs.core.RedNode(k, v, null, null, null)
  }else {
    var c__9840 = comp.call(null, k, tree.key);
    if(c__9840 === 0) {
      found[0] = tree;
      return null
    }else {
      if(c__9840 < 0) {
        var ins__9841 = tree_map_add.call(null, comp, tree.left, k, v, found);
        if(!(ins__9841 == null)) {
          return tree.add_left(ins__9841)
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var ins__9842 = tree_map_add.call(null, comp, tree.right, k, v, found);
          if(!(ins__9842 == null)) {
            return tree.add_right(ins__9842)
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }
};
cljs.core.tree_map_append = function tree_map_append(left, right) {
  if(left == null) {
    return right
  }else {
    if(right == null) {
      return left
    }else {
      if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, left)) {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          var app__9845 = tree_map_append.call(null, left.right, right.left);
          if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__9845)) {
            return new cljs.core.RedNode(app__9845.key, app__9845.val, new cljs.core.RedNode(left.key, left.val, left.left, app__9845.left, null), new cljs.core.RedNode(right.key, right.val, app__9845.right, right.right, null), null)
          }else {
            return new cljs.core.RedNode(left.key, left.val, left.left, new cljs.core.RedNode(right.key, right.val, app__9845, right.right, null), null)
          }
        }else {
          return new cljs.core.RedNode(left.key, left.val, left.left, tree_map_append.call(null, left.right, right), null)
        }
      }else {
        if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, right)) {
          return new cljs.core.RedNode(right.key, right.val, tree_map_append.call(null, left, right.left), right.right, null)
        }else {
          if("\ufdd0'else") {
            var app__9846 = tree_map_append.call(null, left.right, right.left);
            if(cljs.core.instance_QMARK_.call(null, cljs.core.RedNode, app__9846)) {
              return new cljs.core.RedNode(app__9846.key, app__9846.val, new cljs.core.BlackNode(left.key, left.val, left.left, app__9846.left, null), new cljs.core.BlackNode(right.key, right.val, app__9846.right, right.right, null), null)
            }else {
              return cljs.core.balance_left_del.call(null, left.key, left.val, left.left, new cljs.core.BlackNode(right.key, right.val, app__9846, right.right, null))
            }
          }else {
            return null
          }
        }
      }
    }
  }
};
cljs.core.tree_map_remove = function tree_map_remove(comp, tree, k, found) {
  if(!(tree == null)) {
    var c__9852 = comp.call(null, k, tree.key);
    if(c__9852 === 0) {
      found[0] = tree;
      return cljs.core.tree_map_append.call(null, tree.left, tree.right)
    }else {
      if(c__9852 < 0) {
        var del__9853 = tree_map_remove.call(null, comp, tree.left, k, found);
        if(function() {
          var or__3824__auto____9854 = !(del__9853 == null);
          if(or__3824__auto____9854) {
            return or__3824__auto____9854
          }else {
            return!(found[0] == null)
          }
        }()) {
          if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.left)) {
            return cljs.core.balance_left_del.call(null, tree.key, tree.val, del__9853, tree.right)
          }else {
            return new cljs.core.RedNode(tree.key, tree.val, del__9853, tree.right, null)
          }
        }else {
          return null
        }
      }else {
        if("\ufdd0'else") {
          var del__9855 = tree_map_remove.call(null, comp, tree.right, k, found);
          if(function() {
            var or__3824__auto____9856 = !(del__9855 == null);
            if(or__3824__auto____9856) {
              return or__3824__auto____9856
            }else {
              return!(found[0] == null)
            }
          }()) {
            if(cljs.core.instance_QMARK_.call(null, cljs.core.BlackNode, tree.right)) {
              return cljs.core.balance_right_del.call(null, tree.key, tree.val, tree.left, del__9855)
            }else {
              return new cljs.core.RedNode(tree.key, tree.val, tree.left, del__9855, null)
            }
          }else {
            return null
          }
        }else {
          return null
        }
      }
    }
  }else {
    return null
  }
};
cljs.core.tree_map_replace = function tree_map_replace(comp, tree, k, v) {
  var tk__9859 = tree.key;
  var c__9860 = comp.call(null, k, tk__9859);
  if(c__9860 === 0) {
    return tree.replace(tk__9859, v, tree.left, tree.right)
  }else {
    if(c__9860 < 0) {
      return tree.replace(tk__9859, tree.val, tree_map_replace.call(null, comp, tree.left, k, v), tree.right)
    }else {
      if("\ufdd0'else") {
        return tree.replace(tk__9859, tree.val, tree.left, tree_map_replace.call(null, comp, tree.right, k, v))
      }else {
        return null
      }
    }
  }
};
cljs.core.PersistentTreeMap = function(comp, tree, cnt, meta, __hash) {
  this.comp = comp;
  this.tree = tree;
  this.cnt = cnt;
  this.meta = meta;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 418776847
};
cljs.core.PersistentTreeMap.cljs$lang$type = true;
cljs.core.PersistentTreeMap.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentTreeMap")
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9863 = this;
  var h__2287__auto____9864 = this__9863.__hash;
  if(!(h__2287__auto____9864 == null)) {
    return h__2287__auto____9864
  }else {
    var h__2287__auto____9865 = cljs.core.hash_imap.call(null, coll);
    this__9863.__hash = h__2287__auto____9865;
    return h__2287__auto____9865
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, k) {
  var this__9866 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, k, null)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, k, not_found) {
  var this__9867 = this;
  var n__9868 = coll.entry_at(k);
  if(!(n__9868 == null)) {
    return n__9868.val
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = function(coll, k, v) {
  var this__9869 = this;
  var found__9870 = [null];
  var t__9871 = cljs.core.tree_map_add.call(null, this__9869.comp, this__9869.tree, k, v, found__9870);
  if(t__9871 == null) {
    var found_node__9872 = cljs.core.nth.call(null, found__9870, 0);
    if(cljs.core._EQ_.call(null, v, found_node__9872.val)) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__9869.comp, cljs.core.tree_map_replace.call(null, this__9869.comp, this__9869.tree, k, v), this__9869.cnt, this__9869.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__9869.comp, t__9871.blacken(), this__9869.cnt + 1, this__9869.meta, null)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = function(coll, k) {
  var this__9873 = this;
  return!(coll.entry_at(k) == null)
};
cljs.core.PersistentTreeMap.prototype.call = function() {
  var G__9907 = null;
  var G__9907__2 = function(this_sym9874, k) {
    var this__9876 = this;
    var this_sym9874__9877 = this;
    var coll__9878 = this_sym9874__9877;
    return coll__9878.cljs$core$ILookup$_lookup$arity$2(coll__9878, k)
  };
  var G__9907__3 = function(this_sym9875, k, not_found) {
    var this__9876 = this;
    var this_sym9875__9879 = this;
    var coll__9880 = this_sym9875__9879;
    return coll__9880.cljs$core$ILookup$_lookup$arity$3(coll__9880, k, not_found)
  };
  G__9907 = function(this_sym9875, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__9907__2.call(this, this_sym9875, k);
      case 3:
        return G__9907__3.call(this, this_sym9875, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__9907
}();
cljs.core.PersistentTreeMap.prototype.apply = function(this_sym9861, args9862) {
  var this__9881 = this;
  return this_sym9861.call.apply(this_sym9861, [this_sym9861].concat(args9862.slice()))
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = function(coll, f, init) {
  var this__9882 = this;
  if(!(this__9882.tree == null)) {
    return cljs.core.tree_map_kv_reduce.call(null, this__9882.tree, f, init)
  }else {
    return init
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, entry) {
  var this__9883 = this;
  if(cljs.core.vector_QMARK_.call(null, entry)) {
    return coll.cljs$core$IAssociative$_assoc$arity$3(coll, cljs.core._nth.call(null, entry, 0), cljs.core._nth.call(null, entry, 1))
  }else {
    return cljs.core.reduce.call(null, cljs.core._conj, coll, entry)
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__9884 = this;
  if(this__9884.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__9884.tree, false, this__9884.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.toString = function() {
  var this__9885 = this;
  var this__9886 = this;
  return cljs.core.pr_str.call(null, this__9886)
};
cljs.core.PersistentTreeMap.prototype.entry_at = function(k) {
  var this__9887 = this;
  var coll__9888 = this;
  var t__9889 = this__9887.tree;
  while(true) {
    if(!(t__9889 == null)) {
      var c__9890 = this__9887.comp.call(null, k, t__9889.key);
      if(c__9890 === 0) {
        return t__9889
      }else {
        if(c__9890 < 0) {
          var G__9908 = t__9889.left;
          t__9889 = G__9908;
          continue
        }else {
          if("\ufdd0'else") {
            var G__9909 = t__9889.right;
            t__9889 = G__9909;
            continue
          }else {
            return null
          }
        }
      }
    }else {
      return null
    }
    break
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__9891 = this;
  if(this__9891.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__9891.tree, ascending_QMARK_, this__9891.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__9892 = this;
  if(this__9892.cnt > 0) {
    var stack__9893 = null;
    var t__9894 = this__9892.tree;
    while(true) {
      if(!(t__9894 == null)) {
        var c__9895 = this__9892.comp.call(null, k, t__9894.key);
        if(c__9895 === 0) {
          return new cljs.core.PersistentTreeMapSeq(null, cljs.core.conj.call(null, stack__9893, t__9894), ascending_QMARK_, -1, null)
        }else {
          if(cljs.core.truth_(ascending_QMARK_)) {
            if(c__9895 < 0) {
              var G__9910 = cljs.core.conj.call(null, stack__9893, t__9894);
              var G__9911 = t__9894.left;
              stack__9893 = G__9910;
              t__9894 = G__9911;
              continue
            }else {
              var G__9912 = stack__9893;
              var G__9913 = t__9894.right;
              stack__9893 = G__9912;
              t__9894 = G__9913;
              continue
            }
          }else {
            if("\ufdd0'else") {
              if(c__9895 > 0) {
                var G__9914 = cljs.core.conj.call(null, stack__9893, t__9894);
                var G__9915 = t__9894.right;
                stack__9893 = G__9914;
                t__9894 = G__9915;
                continue
              }else {
                var G__9916 = stack__9893;
                var G__9917 = t__9894.left;
                stack__9893 = G__9916;
                t__9894 = G__9917;
                continue
              }
            }else {
              return null
            }
          }
        }
      }else {
        if(stack__9893 == null) {
          return new cljs.core.PersistentTreeMapSeq(null, stack__9893, ascending_QMARK_, -1, null)
        }else {
          return null
        }
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__9896 = this;
  return cljs.core.key.call(null, entry)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__9897 = this;
  return this__9897.comp
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__9898 = this;
  if(this__9898.cnt > 0) {
    return cljs.core.create_tree_map_seq.call(null, this__9898.tree, true, this__9898.cnt)
  }else {
    return null
  }
};
cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__9899 = this;
  return this__9899.cnt
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9900 = this;
  return cljs.core.equiv_map.call(null, coll, other)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__9901 = this;
  return new cljs.core.PersistentTreeMap(this__9901.comp, this__9901.tree, this__9901.cnt, meta, this__9901.__hash)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__9902 = this;
  return this__9902.meta
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__9903 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeMap.EMPTY, this__9903.meta)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = function(coll, k) {
  var this__9904 = this;
  var found__9905 = [null];
  var t__9906 = cljs.core.tree_map_remove.call(null, this__9904.comp, this__9904.tree, k, found__9905);
  if(t__9906 == null) {
    if(cljs.core.nth.call(null, found__9905, 0) == null) {
      return coll
    }else {
      return new cljs.core.PersistentTreeMap(this__9904.comp, null, 0, this__9904.meta, null)
    }
  }else {
    return new cljs.core.PersistentTreeMap(this__9904.comp, t__9906.blacken(), this__9904.cnt - 1, this__9904.meta, null)
  }
};
cljs.core.PersistentTreeMap;
cljs.core.PersistentTreeMap.EMPTY = new cljs.core.PersistentTreeMap(cljs.core.compare, null, 0, null, 0);
cljs.core.hash_map = function() {
  var hash_map__delegate = function(keyvals) {
    var in__9920 = cljs.core.seq.call(null, keyvals);
    var out__9921 = cljs.core.transient$.call(null, cljs.core.PersistentHashMap.EMPTY);
    while(true) {
      if(in__9920) {
        var G__9922 = cljs.core.nnext.call(null, in__9920);
        var G__9923 = cljs.core.assoc_BANG_.call(null, out__9921, cljs.core.first.call(null, in__9920), cljs.core.second.call(null, in__9920));
        in__9920 = G__9922;
        out__9921 = G__9923;
        continue
      }else {
        return cljs.core.persistent_BANG_.call(null, out__9921)
      }
      break
    }
  };
  var hash_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return hash_map__delegate.call(this, keyvals)
  };
  hash_map.cljs$lang$maxFixedArity = 0;
  hash_map.cljs$lang$applyTo = function(arglist__9924) {
    var keyvals = cljs.core.seq(arglist__9924);
    return hash_map__delegate(keyvals)
  };
  hash_map.cljs$lang$arity$variadic = hash_map__delegate;
  return hash_map
}();
cljs.core.array_map = function() {
  var array_map__delegate = function(keyvals) {
    return new cljs.core.PersistentArrayMap(null, cljs.core.quot.call(null, cljs.core.count.call(null, keyvals), 2), cljs.core.apply.call(null, cljs.core.array, keyvals), null)
  };
  var array_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return array_map__delegate.call(this, keyvals)
  };
  array_map.cljs$lang$maxFixedArity = 0;
  array_map.cljs$lang$applyTo = function(arglist__9925) {
    var keyvals = cljs.core.seq(arglist__9925);
    return array_map__delegate(keyvals)
  };
  array_map.cljs$lang$arity$variadic = array_map__delegate;
  return array_map
}();
cljs.core.obj_map = function() {
  var obj_map__delegate = function(keyvals) {
    var ks__9929 = [];
    var obj__9930 = {};
    var kvs__9931 = cljs.core.seq.call(null, keyvals);
    while(true) {
      if(kvs__9931) {
        ks__9929.push(cljs.core.first.call(null, kvs__9931));
        obj__9930[cljs.core.first.call(null, kvs__9931)] = cljs.core.second.call(null, kvs__9931);
        var G__9932 = cljs.core.nnext.call(null, kvs__9931);
        kvs__9931 = G__9932;
        continue
      }else {
        return cljs.core.ObjMap.fromObject.call(null, ks__9929, obj__9930)
      }
      break
    }
  };
  var obj_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return obj_map__delegate.call(this, keyvals)
  };
  obj_map.cljs$lang$maxFixedArity = 0;
  obj_map.cljs$lang$applyTo = function(arglist__9933) {
    var keyvals = cljs.core.seq(arglist__9933);
    return obj_map__delegate(keyvals)
  };
  obj_map.cljs$lang$arity$variadic = obj_map__delegate;
  return obj_map
}();
cljs.core.sorted_map = function() {
  var sorted_map__delegate = function(keyvals) {
    var in__9936 = cljs.core.seq.call(null, keyvals);
    var out__9937 = cljs.core.PersistentTreeMap.EMPTY;
    while(true) {
      if(in__9936) {
        var G__9938 = cljs.core.nnext.call(null, in__9936);
        var G__9939 = cljs.core.assoc.call(null, out__9937, cljs.core.first.call(null, in__9936), cljs.core.second.call(null, in__9936));
        in__9936 = G__9938;
        out__9937 = G__9939;
        continue
      }else {
        return out__9937
      }
      break
    }
  };
  var sorted_map = function(var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_map__delegate.call(this, keyvals)
  };
  sorted_map.cljs$lang$maxFixedArity = 0;
  sorted_map.cljs$lang$applyTo = function(arglist__9940) {
    var keyvals = cljs.core.seq(arglist__9940);
    return sorted_map__delegate(keyvals)
  };
  sorted_map.cljs$lang$arity$variadic = sorted_map__delegate;
  return sorted_map
}();
cljs.core.sorted_map_by = function() {
  var sorted_map_by__delegate = function(comparator, keyvals) {
    var in__9943 = cljs.core.seq.call(null, keyvals);
    var out__9944 = new cljs.core.PersistentTreeMap(comparator, null, 0, null, 0);
    while(true) {
      if(in__9943) {
        var G__9945 = cljs.core.nnext.call(null, in__9943);
        var G__9946 = cljs.core.assoc.call(null, out__9944, cljs.core.first.call(null, in__9943), cljs.core.second.call(null, in__9943));
        in__9943 = G__9945;
        out__9944 = G__9946;
        continue
      }else {
        return out__9944
      }
      break
    }
  };
  var sorted_map_by = function(comparator, var_args) {
    var keyvals = null;
    if(goog.isDef(var_args)) {
      keyvals = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_map_by__delegate.call(this, comparator, keyvals)
  };
  sorted_map_by.cljs$lang$maxFixedArity = 1;
  sorted_map_by.cljs$lang$applyTo = function(arglist__9947) {
    var comparator = cljs.core.first(arglist__9947);
    var keyvals = cljs.core.rest(arglist__9947);
    return sorted_map_by__delegate(comparator, keyvals)
  };
  sorted_map_by.cljs$lang$arity$variadic = sorted_map_by__delegate;
  return sorted_map_by
}();
cljs.core.keys = function keys(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.first, hash_map))
};
cljs.core.key = function key(map_entry) {
  return cljs.core._key.call(null, map_entry)
};
cljs.core.vals = function vals(hash_map) {
  return cljs.core.seq.call(null, cljs.core.map.call(null, cljs.core.second, hash_map))
};
cljs.core.val = function val(map_entry) {
  return cljs.core._val.call(null, map_entry)
};
cljs.core.merge = function() {
  var merge__delegate = function(maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      return cljs.core.reduce.call(null, function(p1__9948_SHARP_, p2__9949_SHARP_) {
        return cljs.core.conj.call(null, function() {
          var or__3824__auto____9951 = p1__9948_SHARP_;
          if(cljs.core.truth_(or__3824__auto____9951)) {
            return or__3824__auto____9951
          }else {
            return cljs.core.ObjMap.EMPTY
          }
        }(), p2__9949_SHARP_)
      }, maps)
    }else {
      return null
    }
  };
  var merge = function(var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return merge__delegate.call(this, maps)
  };
  merge.cljs$lang$maxFixedArity = 0;
  merge.cljs$lang$applyTo = function(arglist__9952) {
    var maps = cljs.core.seq(arglist__9952);
    return merge__delegate(maps)
  };
  merge.cljs$lang$arity$variadic = merge__delegate;
  return merge
}();
cljs.core.merge_with = function() {
  var merge_with__delegate = function(f, maps) {
    if(cljs.core.truth_(cljs.core.some.call(null, cljs.core.identity, maps))) {
      var merge_entry__9960 = function(m, e) {
        var k__9958 = cljs.core.first.call(null, e);
        var v__9959 = cljs.core.second.call(null, e);
        if(cljs.core.contains_QMARK_.call(null, m, k__9958)) {
          return cljs.core.assoc.call(null, m, k__9958, f.call(null, cljs.core._lookup.call(null, m, k__9958, null), v__9959))
        }else {
          return cljs.core.assoc.call(null, m, k__9958, v__9959)
        }
      };
      var merge2__9962 = function(m1, m2) {
        return cljs.core.reduce.call(null, merge_entry__9960, function() {
          var or__3824__auto____9961 = m1;
          if(cljs.core.truth_(or__3824__auto____9961)) {
            return or__3824__auto____9961
          }else {
            return cljs.core.ObjMap.EMPTY
          }
        }(), cljs.core.seq.call(null, m2))
      };
      return cljs.core.reduce.call(null, merge2__9962, maps)
    }else {
      return null
    }
  };
  var merge_with = function(f, var_args) {
    var maps = null;
    if(goog.isDef(var_args)) {
      maps = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return merge_with__delegate.call(this, f, maps)
  };
  merge_with.cljs$lang$maxFixedArity = 1;
  merge_with.cljs$lang$applyTo = function(arglist__9963) {
    var f = cljs.core.first(arglist__9963);
    var maps = cljs.core.rest(arglist__9963);
    return merge_with__delegate(f, maps)
  };
  merge_with.cljs$lang$arity$variadic = merge_with__delegate;
  return merge_with
}();
cljs.core.select_keys = function select_keys(map, keyseq) {
  var ret__9968 = cljs.core.ObjMap.EMPTY;
  var keys__9969 = cljs.core.seq.call(null, keyseq);
  while(true) {
    if(keys__9969) {
      var key__9970 = cljs.core.first.call(null, keys__9969);
      var entry__9971 = cljs.core._lookup.call(null, map, key__9970, "\ufdd0'cljs.core/not-found");
      var G__9972 = cljs.core.not_EQ_.call(null, entry__9971, "\ufdd0'cljs.core/not-found") ? cljs.core.assoc.call(null, ret__9968, key__9970, entry__9971) : ret__9968;
      var G__9973 = cljs.core.next.call(null, keys__9969);
      ret__9968 = G__9972;
      keys__9969 = G__9973;
      continue
    }else {
      return ret__9968
    }
    break
  }
};
cljs.core.PersistentHashSet = function(meta, hash_map, __hash) {
  this.meta = meta;
  this.hash_map = hash_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 1;
  this.cljs$lang$protocol_mask$partition0$ = 15077647
};
cljs.core.PersistentHashSet.cljs$lang$type = true;
cljs.core.PersistentHashSet.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentHashSet")
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = function(coll) {
  var this__9977 = this;
  return new cljs.core.TransientHashSet(cljs.core.transient$.call(null, this__9977.hash_map))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__9978 = this;
  var h__2287__auto____9979 = this__9978.__hash;
  if(!(h__2287__auto____9979 == null)) {
    return h__2287__auto____9979
  }else {
    var h__2287__auto____9980 = cljs.core.hash_iset.call(null, coll);
    this__9978.__hash = h__2287__auto____9980;
    return h__2287__auto____9980
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__9981 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, v, null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__9982 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__9982.hash_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentHashSet.prototype.call = function() {
  var G__10003 = null;
  var G__10003__2 = function(this_sym9983, k) {
    var this__9985 = this;
    var this_sym9983__9986 = this;
    var coll__9987 = this_sym9983__9986;
    return coll__9987.cljs$core$ILookup$_lookup$arity$2(coll__9987, k)
  };
  var G__10003__3 = function(this_sym9984, k, not_found) {
    var this__9985 = this;
    var this_sym9984__9988 = this;
    var coll__9989 = this_sym9984__9988;
    return coll__9989.cljs$core$ILookup$_lookup$arity$3(coll__9989, k, not_found)
  };
  G__10003 = function(this_sym9984, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10003__2.call(this, this_sym9984, k);
      case 3:
        return G__10003__3.call(this, this_sym9984, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__10003
}();
cljs.core.PersistentHashSet.prototype.apply = function(this_sym9975, args9976) {
  var this__9990 = this;
  return this_sym9975.call.apply(this_sym9975, [this_sym9975].concat(args9976.slice()))
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__9991 = this;
  return new cljs.core.PersistentHashSet(this__9991.meta, cljs.core.assoc.call(null, this__9991.hash_map, o, null), null)
};
cljs.core.PersistentHashSet.prototype.toString = function() {
  var this__9992 = this;
  var this__9993 = this;
  return cljs.core.pr_str.call(null, this__9993)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__9994 = this;
  return cljs.core.keys.call(null, this__9994.hash_map)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__9995 = this;
  return new cljs.core.PersistentHashSet(this__9995.meta, cljs.core.dissoc.call(null, this__9995.hash_map, v), null)
};
cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__9996 = this;
  return cljs.core.count.call(null, cljs.core.seq.call(null, coll))
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__9997 = this;
  var and__3822__auto____9998 = cljs.core.set_QMARK_.call(null, other);
  if(and__3822__auto____9998) {
    var and__3822__auto____9999 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3822__auto____9999) {
      return cljs.core.every_QMARK_.call(null, function(p1__9974_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__9974_SHARP_)
      }, other)
    }else {
      return and__3822__auto____9999
    }
  }else {
    return and__3822__auto____9998
  }
};
cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__10000 = this;
  return new cljs.core.PersistentHashSet(meta, this__10000.hash_map, this__10000.__hash)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__10001 = this;
  return this__10001.meta
};
cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__10002 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentHashSet.EMPTY, this__10002.meta)
};
cljs.core.PersistentHashSet;
cljs.core.PersistentHashSet.EMPTY = new cljs.core.PersistentHashSet(null, cljs.core.hash_map.call(null), 0);
cljs.core.PersistentHashSet.fromArray = function(items) {
  var len__10004 = cljs.core.count.call(null, items);
  var i__10005 = 0;
  var out__10006 = cljs.core.transient$.call(null, cljs.core.PersistentHashSet.EMPTY);
  while(true) {
    if(i__10005 < len__10004) {
      var G__10007 = i__10005 + 1;
      var G__10008 = cljs.core.conj_BANG_.call(null, out__10006, items[i__10005]);
      i__10005 = G__10007;
      out__10006 = G__10008;
      continue
    }else {
      return cljs.core.persistent_BANG_.call(null, out__10006)
    }
    break
  }
};
cljs.core.TransientHashSet = function(transient_map) {
  this.transient_map = transient_map;
  this.cljs$lang$protocol_mask$partition0$ = 259;
  this.cljs$lang$protocol_mask$partition1$ = 34
};
cljs.core.TransientHashSet.cljs$lang$type = true;
cljs.core.TransientHashSet.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/TransientHashSet")
};
cljs.core.TransientHashSet.prototype.call = function() {
  var G__10026 = null;
  var G__10026__2 = function(this_sym10012, k) {
    var this__10014 = this;
    var this_sym10012__10015 = this;
    var tcoll__10016 = this_sym10012__10015;
    if(cljs.core._lookup.call(null, this__10014.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return null
    }else {
      return k
    }
  };
  var G__10026__3 = function(this_sym10013, k, not_found) {
    var this__10014 = this;
    var this_sym10013__10017 = this;
    var tcoll__10018 = this_sym10013__10017;
    if(cljs.core._lookup.call(null, this__10014.transient_map, k, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
      return not_found
    }else {
      return k
    }
  };
  G__10026 = function(this_sym10013, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10026__2.call(this, this_sym10013, k);
      case 3:
        return G__10026__3.call(this, this_sym10013, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__10026
}();
cljs.core.TransientHashSet.prototype.apply = function(this_sym10010, args10011) {
  var this__10019 = this;
  return this_sym10010.call.apply(this_sym10010, [this_sym10010].concat(args10011.slice()))
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(tcoll, v) {
  var this__10020 = this;
  return tcoll.cljs$core$ILookup$_lookup$arity$3(tcoll, v, null)
};
cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(tcoll, v, not_found) {
  var this__10021 = this;
  if(cljs.core._lookup.call(null, this__10021.transient_map, v, cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel) {
    return not_found
  }else {
    return v
  }
};
cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = function(tcoll) {
  var this__10022 = this;
  return cljs.core.count.call(null, this__10022.transient_map)
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = function(tcoll, v) {
  var this__10023 = this;
  this__10023.transient_map = cljs.core.dissoc_BANG_.call(null, this__10023.transient_map, v);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = function(tcoll, o) {
  var this__10024 = this;
  this__10024.transient_map = cljs.core.assoc_BANG_.call(null, this__10024.transient_map, o, null);
  return tcoll
};
cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = function(tcoll) {
  var this__10025 = this;
  return new cljs.core.PersistentHashSet(null, cljs.core.persistent_BANG_.call(null, this__10025.transient_map), null)
};
cljs.core.TransientHashSet;
cljs.core.PersistentTreeSet = function(meta, tree_map, __hash) {
  this.meta = meta;
  this.tree_map = tree_map;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 417730831
};
cljs.core.PersistentTreeSet.cljs$lang$type = true;
cljs.core.PersistentTreeSet.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/PersistentTreeSet")
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = function(coll) {
  var this__10029 = this;
  var h__2287__auto____10030 = this__10029.__hash;
  if(!(h__2287__auto____10030 == null)) {
    return h__2287__auto____10030
  }else {
    var h__2287__auto____10031 = cljs.core.hash_iset.call(null, coll);
    this__10029.__hash = h__2287__auto____10031;
    return h__2287__auto____10031
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = function(coll, v) {
  var this__10032 = this;
  return coll.cljs$core$ILookup$_lookup$arity$3(coll, v, null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = function(coll, v, not_found) {
  var this__10033 = this;
  if(cljs.core.truth_(cljs.core._contains_key_QMARK_.call(null, this__10033.tree_map, v))) {
    return v
  }else {
    return not_found
  }
};
cljs.core.PersistentTreeSet.prototype.call = function() {
  var G__10059 = null;
  var G__10059__2 = function(this_sym10034, k) {
    var this__10036 = this;
    var this_sym10034__10037 = this;
    var coll__10038 = this_sym10034__10037;
    return coll__10038.cljs$core$ILookup$_lookup$arity$2(coll__10038, k)
  };
  var G__10059__3 = function(this_sym10035, k, not_found) {
    var this__10036 = this;
    var this_sym10035__10039 = this;
    var coll__10040 = this_sym10035__10039;
    return coll__10040.cljs$core$ILookup$_lookup$arity$3(coll__10040, k, not_found)
  };
  G__10059 = function(this_sym10035, k, not_found) {
    switch(arguments.length) {
      case 2:
        return G__10059__2.call(this, this_sym10035, k);
      case 3:
        return G__10059__3.call(this, this_sym10035, k, not_found)
    }
    throw"Invalid arity: " + arguments.length;
  };
  return G__10059
}();
cljs.core.PersistentTreeSet.prototype.apply = function(this_sym10027, args10028) {
  var this__10041 = this;
  return this_sym10027.call.apply(this_sym10027, [this_sym10027].concat(args10028.slice()))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = function(coll, o) {
  var this__10042 = this;
  return new cljs.core.PersistentTreeSet(this__10042.meta, cljs.core.assoc.call(null, this__10042.tree_map, o, null), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = function(coll) {
  var this__10043 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core.rseq.call(null, this__10043.tree_map))
};
cljs.core.PersistentTreeSet.prototype.toString = function() {
  var this__10044 = this;
  var this__10045 = this;
  return cljs.core.pr_str.call(null, this__10045)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = function(coll, ascending_QMARK_) {
  var this__10046 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq.call(null, this__10046.tree_map, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = function(coll, k, ascending_QMARK_) {
  var this__10047 = this;
  return cljs.core.map.call(null, cljs.core.key, cljs.core._sorted_seq_from.call(null, this__10047.tree_map, k, ascending_QMARK_))
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = function(coll, entry) {
  var this__10048 = this;
  return entry
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = function(coll) {
  var this__10049 = this;
  return cljs.core._comparator.call(null, this__10049.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = function(coll) {
  var this__10050 = this;
  return cljs.core.keys.call(null, this__10050.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = function(coll, v) {
  var this__10051 = this;
  return new cljs.core.PersistentTreeSet(this__10051.meta, cljs.core.dissoc.call(null, this__10051.tree_map, v), null)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = function(coll) {
  var this__10052 = this;
  return cljs.core.count.call(null, this__10052.tree_map)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(coll, other) {
  var this__10053 = this;
  var and__3822__auto____10054 = cljs.core.set_QMARK_.call(null, other);
  if(and__3822__auto____10054) {
    var and__3822__auto____10055 = cljs.core.count.call(null, coll) === cljs.core.count.call(null, other);
    if(and__3822__auto____10055) {
      return cljs.core.every_QMARK_.call(null, function(p1__10009_SHARP_) {
        return cljs.core.contains_QMARK_.call(null, coll, p1__10009_SHARP_)
      }, other)
    }else {
      return and__3822__auto____10055
    }
  }else {
    return and__3822__auto____10054
  }
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(coll, meta) {
  var this__10056 = this;
  return new cljs.core.PersistentTreeSet(meta, this__10056.tree_map, this__10056.__hash)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = function(coll) {
  var this__10057 = this;
  return this__10057.meta
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(coll) {
  var this__10058 = this;
  return cljs.core.with_meta.call(null, cljs.core.PersistentTreeSet.EMPTY, this__10058.meta)
};
cljs.core.PersistentTreeSet;
cljs.core.PersistentTreeSet.EMPTY = new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map.call(null), 0);
cljs.core.hash_set = function() {
  var hash_set = null;
  var hash_set__0 = function() {
    return cljs.core.PersistentHashSet.EMPTY
  };
  var hash_set__1 = function() {
    var G__10064__delegate = function(keys) {
      var in__10062 = cljs.core.seq.call(null, keys);
      var out__10063 = cljs.core.transient$.call(null, cljs.core.PersistentHashSet.EMPTY);
      while(true) {
        if(cljs.core.seq.call(null, in__10062)) {
          var G__10065 = cljs.core.next.call(null, in__10062);
          var G__10066 = cljs.core.conj_BANG_.call(null, out__10063, cljs.core.first.call(null, in__10062));
          in__10062 = G__10065;
          out__10063 = G__10066;
          continue
        }else {
          return cljs.core.persistent_BANG_.call(null, out__10063)
        }
        break
      }
    };
    var G__10064 = function(var_args) {
      var keys = null;
      if(goog.isDef(var_args)) {
        keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__10064__delegate.call(this, keys)
    };
    G__10064.cljs$lang$maxFixedArity = 0;
    G__10064.cljs$lang$applyTo = function(arglist__10067) {
      var keys = cljs.core.seq(arglist__10067);
      return G__10064__delegate(keys)
    };
    G__10064.cljs$lang$arity$variadic = G__10064__delegate;
    return G__10064
  }();
  hash_set = function(var_args) {
    var keys = var_args;
    switch(arguments.length) {
      case 0:
        return hash_set__0.call(this);
      default:
        return hash_set__1.cljs$lang$arity$variadic(cljs.core.array_seq(arguments, 0))
    }
    throw"Invalid arity: " + arguments.length;
  };
  hash_set.cljs$lang$maxFixedArity = 0;
  hash_set.cljs$lang$applyTo = hash_set__1.cljs$lang$applyTo;
  hash_set.cljs$lang$arity$0 = hash_set__0;
  hash_set.cljs$lang$arity$variadic = hash_set__1.cljs$lang$arity$variadic;
  return hash_set
}();
cljs.core.set = function set(coll) {
  return cljs.core.apply.call(null, cljs.core.hash_set, coll)
};
cljs.core.sorted_set = function() {
  var sorted_set__delegate = function(keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, cljs.core.PersistentTreeSet.EMPTY, keys)
  };
  var sorted_set = function(var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return sorted_set__delegate.call(this, keys)
  };
  sorted_set.cljs$lang$maxFixedArity = 0;
  sorted_set.cljs$lang$applyTo = function(arglist__10068) {
    var keys = cljs.core.seq(arglist__10068);
    return sorted_set__delegate(keys)
  };
  sorted_set.cljs$lang$arity$variadic = sorted_set__delegate;
  return sorted_set
}();
cljs.core.sorted_set_by = function() {
  var sorted_set_by__delegate = function(comparator, keys) {
    return cljs.core.reduce.call(null, cljs.core._conj, new cljs.core.PersistentTreeSet(null, cljs.core.sorted_map_by.call(null, comparator), 0), keys)
  };
  var sorted_set_by = function(comparator, var_args) {
    var keys = null;
    if(goog.isDef(var_args)) {
      keys = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return sorted_set_by__delegate.call(this, comparator, keys)
  };
  sorted_set_by.cljs$lang$maxFixedArity = 1;
  sorted_set_by.cljs$lang$applyTo = function(arglist__10070) {
    var comparator = cljs.core.first(arglist__10070);
    var keys = cljs.core.rest(arglist__10070);
    return sorted_set_by__delegate(comparator, keys)
  };
  sorted_set_by.cljs$lang$arity$variadic = sorted_set_by__delegate;
  return sorted_set_by
}();
cljs.core.replace = function replace(smap, coll) {
  if(cljs.core.vector_QMARK_.call(null, coll)) {
    var n__10076 = cljs.core.count.call(null, coll);
    return cljs.core.reduce.call(null, function(v, i) {
      var temp__3971__auto____10077 = cljs.core.find.call(null, smap, cljs.core.nth.call(null, v, i));
      if(cljs.core.truth_(temp__3971__auto____10077)) {
        var e__10078 = temp__3971__auto____10077;
        return cljs.core.assoc.call(null, v, i, cljs.core.second.call(null, e__10078))
      }else {
        return v
      }
    }, coll, cljs.core.take.call(null, n__10076, cljs.core.iterate.call(null, cljs.core.inc, 0)))
  }else {
    return cljs.core.map.call(null, function(p1__10069_SHARP_) {
      var temp__3971__auto____10079 = cljs.core.find.call(null, smap, p1__10069_SHARP_);
      if(cljs.core.truth_(temp__3971__auto____10079)) {
        var e__10080 = temp__3971__auto____10079;
        return cljs.core.second.call(null, e__10080)
      }else {
        return p1__10069_SHARP_
      }
    }, coll)
  }
};
cljs.core.distinct = function distinct(coll) {
  var step__10110 = function step(xs, seen) {
    return new cljs.core.LazySeq(null, false, function() {
      return function(p__10103, seen) {
        while(true) {
          var vec__10104__10105 = p__10103;
          var f__10106 = cljs.core.nth.call(null, vec__10104__10105, 0, null);
          var xs__10107 = vec__10104__10105;
          var temp__3974__auto____10108 = cljs.core.seq.call(null, xs__10107);
          if(temp__3974__auto____10108) {
            var s__10109 = temp__3974__auto____10108;
            if(cljs.core.contains_QMARK_.call(null, seen, f__10106)) {
              var G__10111 = cljs.core.rest.call(null, s__10109);
              var G__10112 = seen;
              p__10103 = G__10111;
              seen = G__10112;
              continue
            }else {
              return cljs.core.cons.call(null, f__10106, step.call(null, cljs.core.rest.call(null, s__10109), cljs.core.conj.call(null, seen, f__10106)))
            }
          }else {
            return null
          }
          break
        }
      }.call(null, xs, seen)
    }, null)
  };
  return step__10110.call(null, coll, cljs.core.PersistentHashSet.EMPTY)
};
cljs.core.butlast = function butlast(s) {
  var ret__10115 = cljs.core.PersistentVector.EMPTY;
  var s__10116 = s;
  while(true) {
    if(cljs.core.next.call(null, s__10116)) {
      var G__10117 = cljs.core.conj.call(null, ret__10115, cljs.core.first.call(null, s__10116));
      var G__10118 = cljs.core.next.call(null, s__10116);
      ret__10115 = G__10117;
      s__10116 = G__10118;
      continue
    }else {
      return cljs.core.seq.call(null, ret__10115)
    }
    break
  }
};
cljs.core.name = function name(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(function() {
      var or__3824__auto____10121 = cljs.core.keyword_QMARK_.call(null, x);
      if(or__3824__auto____10121) {
        return or__3824__auto____10121
      }else {
        return cljs.core.symbol_QMARK_.call(null, x)
      }
    }()) {
      var i__10122 = x.lastIndexOf("/");
      if(i__10122 < 0) {
        return cljs.core.subs.call(null, x, 2)
      }else {
        return cljs.core.subs.call(null, x, i__10122 + 1)
      }
    }else {
      if("\ufdd0'else") {
        throw new Error([cljs.core.str("Doesn't support name: "), cljs.core.str(x)].join(""));
      }else {
        return null
      }
    }
  }
};
cljs.core.namespace = function namespace(x) {
  if(function() {
    var or__3824__auto____10125 = cljs.core.keyword_QMARK_.call(null, x);
    if(or__3824__auto____10125) {
      return or__3824__auto____10125
    }else {
      return cljs.core.symbol_QMARK_.call(null, x)
    }
  }()) {
    var i__10126 = x.lastIndexOf("/");
    if(i__10126 > -1) {
      return cljs.core.subs.call(null, x, 2, i__10126)
    }else {
      return null
    }
  }else {
    throw new Error([cljs.core.str("Doesn't support namespace: "), cljs.core.str(x)].join(""));
  }
};
cljs.core.zipmap = function zipmap(keys, vals) {
  var map__10133 = cljs.core.ObjMap.EMPTY;
  var ks__10134 = cljs.core.seq.call(null, keys);
  var vs__10135 = cljs.core.seq.call(null, vals);
  while(true) {
    if(function() {
      var and__3822__auto____10136 = ks__10134;
      if(and__3822__auto____10136) {
        return vs__10135
      }else {
        return and__3822__auto____10136
      }
    }()) {
      var G__10137 = cljs.core.assoc.call(null, map__10133, cljs.core.first.call(null, ks__10134), cljs.core.first.call(null, vs__10135));
      var G__10138 = cljs.core.next.call(null, ks__10134);
      var G__10139 = cljs.core.next.call(null, vs__10135);
      map__10133 = G__10137;
      ks__10134 = G__10138;
      vs__10135 = G__10139;
      continue
    }else {
      return map__10133
    }
    break
  }
};
cljs.core.max_key = function() {
  var max_key = null;
  var max_key__2 = function(k, x) {
    return x
  };
  var max_key__3 = function(k, x, y) {
    if(k.call(null, x) > k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var max_key__4 = function() {
    var G__10142__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__10127_SHARP_, p2__10128_SHARP_) {
        return max_key.call(null, k, p1__10127_SHARP_, p2__10128_SHARP_)
      }, max_key.call(null, k, x, y), more)
    };
    var G__10142 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__10142__delegate.call(this, k, x, y, more)
    };
    G__10142.cljs$lang$maxFixedArity = 3;
    G__10142.cljs$lang$applyTo = function(arglist__10143) {
      var k = cljs.core.first(arglist__10143);
      var x = cljs.core.first(cljs.core.next(arglist__10143));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__10143)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__10143)));
      return G__10142__delegate(k, x, y, more)
    };
    G__10142.cljs$lang$arity$variadic = G__10142__delegate;
    return G__10142
  }();
  max_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return max_key__2.call(this, k, x);
      case 3:
        return max_key__3.call(this, k, x, y);
      default:
        return max_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  max_key.cljs$lang$maxFixedArity = 3;
  max_key.cljs$lang$applyTo = max_key__4.cljs$lang$applyTo;
  max_key.cljs$lang$arity$2 = max_key__2;
  max_key.cljs$lang$arity$3 = max_key__3;
  max_key.cljs$lang$arity$variadic = max_key__4.cljs$lang$arity$variadic;
  return max_key
}();
cljs.core.min_key = function() {
  var min_key = null;
  var min_key__2 = function(k, x) {
    return x
  };
  var min_key__3 = function(k, x, y) {
    if(k.call(null, x) < k.call(null, y)) {
      return x
    }else {
      return y
    }
  };
  var min_key__4 = function() {
    var G__10144__delegate = function(k, x, y, more) {
      return cljs.core.reduce.call(null, function(p1__10140_SHARP_, p2__10141_SHARP_) {
        return min_key.call(null, k, p1__10140_SHARP_, p2__10141_SHARP_)
      }, min_key.call(null, k, x, y), more)
    };
    var G__10144 = function(k, x, y, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__10144__delegate.call(this, k, x, y, more)
    };
    G__10144.cljs$lang$maxFixedArity = 3;
    G__10144.cljs$lang$applyTo = function(arglist__10145) {
      var k = cljs.core.first(arglist__10145);
      var x = cljs.core.first(cljs.core.next(arglist__10145));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(arglist__10145)));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__10145)));
      return G__10144__delegate(k, x, y, more)
    };
    G__10144.cljs$lang$arity$variadic = G__10144__delegate;
    return G__10144
  }();
  min_key = function(k, x, y, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return min_key__2.call(this, k, x);
      case 3:
        return min_key__3.call(this, k, x, y);
      default:
        return min_key__4.cljs$lang$arity$variadic(k, x, y, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  min_key.cljs$lang$maxFixedArity = 3;
  min_key.cljs$lang$applyTo = min_key__4.cljs$lang$applyTo;
  min_key.cljs$lang$arity$2 = min_key__2;
  min_key.cljs$lang$arity$3 = min_key__3;
  min_key.cljs$lang$arity$variadic = min_key__4.cljs$lang$arity$variadic;
  return min_key
}();
cljs.core.partition_all = function() {
  var partition_all = null;
  var partition_all__2 = function(n, coll) {
    return partition_all.call(null, n, n, coll)
  };
  var partition_all__3 = function(n, step, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____10148 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____10148) {
        var s__10149 = temp__3974__auto____10148;
        return cljs.core.cons.call(null, cljs.core.take.call(null, n, s__10149), partition_all.call(null, n, step, cljs.core.drop.call(null, step, s__10149)))
      }else {
        return null
      }
    }, null)
  };
  partition_all = function(n, step, coll) {
    switch(arguments.length) {
      case 2:
        return partition_all__2.call(this, n, step);
      case 3:
        return partition_all__3.call(this, n, step, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  partition_all.cljs$lang$arity$2 = partition_all__2;
  partition_all.cljs$lang$arity$3 = partition_all__3;
  return partition_all
}();
cljs.core.take_while = function take_while(pred, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3974__auto____10152 = cljs.core.seq.call(null, coll);
    if(temp__3974__auto____10152) {
      var s__10153 = temp__3974__auto____10152;
      if(cljs.core.truth_(pred.call(null, cljs.core.first.call(null, s__10153)))) {
        return cljs.core.cons.call(null, cljs.core.first.call(null, s__10153), take_while.call(null, pred, cljs.core.rest.call(null, s__10153)))
      }else {
        return null
      }
    }else {
      return null
    }
  }, null)
};
cljs.core.mk_bound_fn = function mk_bound_fn(sc, test, key) {
  return function(e) {
    var comp__10155 = cljs.core._comparator.call(null, sc);
    return test.call(null, comp__10155.call(null, cljs.core._entry_key.call(null, sc, e), key), 0)
  }
};
cljs.core.subseq = function() {
  var subseq = null;
  var subseq__3 = function(sc, test, key) {
    var include__10167 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_, cljs.core._GT__EQ_]).call(null, test))) {
      var temp__3974__auto____10168 = cljs.core._sorted_seq_from.call(null, sc, key, true);
      if(cljs.core.truth_(temp__3974__auto____10168)) {
        var vec__10169__10170 = temp__3974__auto____10168;
        var e__10171 = cljs.core.nth.call(null, vec__10169__10170, 0, null);
        var s__10172 = vec__10169__10170;
        if(cljs.core.truth_(include__10167.call(null, e__10171))) {
          return s__10172
        }else {
          return cljs.core.next.call(null, s__10172)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__10167, cljs.core._sorted_seq.call(null, sc, true))
    }
  };
  var subseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3974__auto____10173 = cljs.core._sorted_seq_from.call(null, sc, start_key, true);
    if(cljs.core.truth_(temp__3974__auto____10173)) {
      var vec__10174__10175 = temp__3974__auto____10173;
      var e__10176 = cljs.core.nth.call(null, vec__10174__10175, 0, null);
      var s__10177 = vec__10174__10175;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, end_test, end_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, start_test, start_key).call(null, e__10176)) ? s__10177 : cljs.core.next.call(null, s__10177))
    }else {
      return null
    }
  };
  subseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return subseq__3.call(this, sc, start_test, start_key);
      case 5:
        return subseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  subseq.cljs$lang$arity$3 = subseq__3;
  subseq.cljs$lang$arity$5 = subseq__5;
  return subseq
}();
cljs.core.rsubseq = function() {
  var rsubseq = null;
  var rsubseq__3 = function(sc, test, key) {
    var include__10189 = cljs.core.mk_bound_fn.call(null, sc, test, key);
    if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_, cljs.core._LT__EQ_]).call(null, test))) {
      var temp__3974__auto____10190 = cljs.core._sorted_seq_from.call(null, sc, key, false);
      if(cljs.core.truth_(temp__3974__auto____10190)) {
        var vec__10191__10192 = temp__3974__auto____10190;
        var e__10193 = cljs.core.nth.call(null, vec__10191__10192, 0, null);
        var s__10194 = vec__10191__10192;
        if(cljs.core.truth_(include__10189.call(null, e__10193))) {
          return s__10194
        }else {
          return cljs.core.next.call(null, s__10194)
        }
      }else {
        return null
      }
    }else {
      return cljs.core.take_while.call(null, include__10189, cljs.core._sorted_seq.call(null, sc, false))
    }
  };
  var rsubseq__5 = function(sc, start_test, start_key, end_test, end_key) {
    var temp__3974__auto____10195 = cljs.core._sorted_seq_from.call(null, sc, end_key, false);
    if(cljs.core.truth_(temp__3974__auto____10195)) {
      var vec__10196__10197 = temp__3974__auto____10195;
      var e__10198 = cljs.core.nth.call(null, vec__10196__10197, 0, null);
      var s__10199 = vec__10196__10197;
      return cljs.core.take_while.call(null, cljs.core.mk_bound_fn.call(null, sc, start_test, start_key), cljs.core.truth_(cljs.core.mk_bound_fn.call(null, sc, end_test, end_key).call(null, e__10198)) ? s__10199 : cljs.core.next.call(null, s__10199))
    }else {
      return null
    }
  };
  rsubseq = function(sc, start_test, start_key, end_test, end_key) {
    switch(arguments.length) {
      case 3:
        return rsubseq__3.call(this, sc, start_test, start_key);
      case 5:
        return rsubseq__5.call(this, sc, start_test, start_key, end_test, end_key)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rsubseq.cljs$lang$arity$3 = rsubseq__3;
  rsubseq.cljs$lang$arity$5 = rsubseq__5;
  return rsubseq
}();
cljs.core.Range = function(meta, start, end, step, __hash) {
  this.meta = meta;
  this.start = start;
  this.end = end;
  this.step = step;
  this.__hash = __hash;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 32375006
};
cljs.core.Range.cljs$lang$type = true;
cljs.core.Range.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/Range")
};
cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = function(rng) {
  var this__10200 = this;
  var h__2287__auto____10201 = this__10200.__hash;
  if(!(h__2287__auto____10201 == null)) {
    return h__2287__auto____10201
  }else {
    var h__2287__auto____10202 = cljs.core.hash_coll.call(null, rng);
    this__10200.__hash = h__2287__auto____10202;
    return h__2287__auto____10202
  }
};
cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = function(rng) {
  var this__10203 = this;
  if(this__10203.step > 0) {
    if(this__10203.start + this__10203.step < this__10203.end) {
      return new cljs.core.Range(this__10203.meta, this__10203.start + this__10203.step, this__10203.end, this__10203.step, null)
    }else {
      return null
    }
  }else {
    if(this__10203.start + this__10203.step > this__10203.end) {
      return new cljs.core.Range(this__10203.meta, this__10203.start + this__10203.step, this__10203.end, this__10203.step, null)
    }else {
      return null
    }
  }
};
cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = function(rng, o) {
  var this__10204 = this;
  return cljs.core.cons.call(null, o, rng)
};
cljs.core.Range.prototype.toString = function() {
  var this__10205 = this;
  var this__10206 = this;
  return cljs.core.pr_str.call(null, this__10206)
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = function(rng, f) {
  var this__10207 = this;
  return cljs.core.ci_reduce.call(null, rng, f)
};
cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = function(rng, f, s) {
  var this__10208 = this;
  return cljs.core.ci_reduce.call(null, rng, f, s)
};
cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = function(rng) {
  var this__10209 = this;
  if(this__10209.step > 0) {
    if(this__10209.start < this__10209.end) {
      return rng
    }else {
      return null
    }
  }else {
    if(this__10209.start > this__10209.end) {
      return rng
    }else {
      return null
    }
  }
};
cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = function(rng) {
  var this__10210 = this;
  if(cljs.core.not.call(null, rng.cljs$core$ISeqable$_seq$arity$1(rng))) {
    return 0
  }else {
    return Math.ceil((this__10210.end - this__10210.start) / this__10210.step)
  }
};
cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = function(rng) {
  var this__10211 = this;
  return this__10211.start
};
cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = function(rng) {
  var this__10212 = this;
  if(!(rng.cljs$core$ISeqable$_seq$arity$1(rng) == null)) {
    return new cljs.core.Range(this__10212.meta, this__10212.start + this__10212.step, this__10212.end, this__10212.step, null)
  }else {
    return cljs.core.List.EMPTY
  }
};
cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(rng, other) {
  var this__10213 = this;
  return cljs.core.equiv_sequential.call(null, rng, other)
};
cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = function(rng, meta) {
  var this__10214 = this;
  return new cljs.core.Range(meta, this__10214.start, this__10214.end, this__10214.step, this__10214.__hash)
};
cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = function(rng) {
  var this__10215 = this;
  return this__10215.meta
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = function(rng, n) {
  var this__10216 = this;
  if(n < rng.cljs$core$ICounted$_count$arity$1(rng)) {
    return this__10216.start + n * this__10216.step
  }else {
    if(function() {
      var and__3822__auto____10217 = this__10216.start > this__10216.end;
      if(and__3822__auto____10217) {
        return this__10216.step === 0
      }else {
        return and__3822__auto____10217
      }
    }()) {
      return this__10216.start
    }else {
      throw new Error("Index out of bounds");
    }
  }
};
cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = function(rng, n, not_found) {
  var this__10218 = this;
  if(n < rng.cljs$core$ICounted$_count$arity$1(rng)) {
    return this__10218.start + n * this__10218.step
  }else {
    if(function() {
      var and__3822__auto____10219 = this__10218.start > this__10218.end;
      if(and__3822__auto____10219) {
        return this__10218.step === 0
      }else {
        return and__3822__auto____10219
      }
    }()) {
      return this__10218.start
    }else {
      return not_found
    }
  }
};
cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = function(rng) {
  var this__10220 = this;
  return cljs.core.with_meta.call(null, cljs.core.List.EMPTY, this__10220.meta)
};
cljs.core.Range;
cljs.core.range = function() {
  var range = null;
  var range__0 = function() {
    return range.call(null, 0, Number.MAX_VALUE, 1)
  };
  var range__1 = function(end) {
    return range.call(null, 0, end, 1)
  };
  var range__2 = function(start, end) {
    return range.call(null, start, end, 1)
  };
  var range__3 = function(start, end, step) {
    return new cljs.core.Range(null, start, end, step, null)
  };
  range = function(start, end, step) {
    switch(arguments.length) {
      case 0:
        return range__0.call(this);
      case 1:
        return range__1.call(this, start);
      case 2:
        return range__2.call(this, start, end);
      case 3:
        return range__3.call(this, start, end, step)
    }
    throw"Invalid arity: " + arguments.length;
  };
  range.cljs$lang$arity$0 = range__0;
  range.cljs$lang$arity$1 = range__1;
  range.cljs$lang$arity$2 = range__2;
  range.cljs$lang$arity$3 = range__3;
  return range
}();
cljs.core.take_nth = function take_nth(n, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3974__auto____10223 = cljs.core.seq.call(null, coll);
    if(temp__3974__auto____10223) {
      var s__10224 = temp__3974__auto____10223;
      return cljs.core.cons.call(null, cljs.core.first.call(null, s__10224), take_nth.call(null, n, cljs.core.drop.call(null, n, s__10224)))
    }else {
      return null
    }
  }, null)
};
cljs.core.split_with = function split_with(pred, coll) {
  return cljs.core.PersistentVector.fromArray([cljs.core.take_while.call(null, pred, coll), cljs.core.drop_while.call(null, pred, coll)], true)
};
cljs.core.partition_by = function partition_by(f, coll) {
  return new cljs.core.LazySeq(null, false, function() {
    var temp__3974__auto____10231 = cljs.core.seq.call(null, coll);
    if(temp__3974__auto____10231) {
      var s__10232 = temp__3974__auto____10231;
      var fst__10233 = cljs.core.first.call(null, s__10232);
      var fv__10234 = f.call(null, fst__10233);
      var run__10235 = cljs.core.cons.call(null, fst__10233, cljs.core.take_while.call(null, function(p1__10225_SHARP_) {
        return cljs.core._EQ_.call(null, fv__10234, f.call(null, p1__10225_SHARP_))
      }, cljs.core.next.call(null, s__10232)));
      return cljs.core.cons.call(null, run__10235, partition_by.call(null, f, cljs.core.seq.call(null, cljs.core.drop.call(null, cljs.core.count.call(null, run__10235), s__10232))))
    }else {
      return null
    }
  }, null)
};
cljs.core.frequencies = function frequencies(coll) {
  return cljs.core.persistent_BANG_.call(null, cljs.core.reduce.call(null, function(counts, x) {
    return cljs.core.assoc_BANG_.call(null, counts, x, cljs.core._lookup.call(null, counts, x, 0) + 1)
  }, cljs.core.transient$.call(null, cljs.core.ObjMap.EMPTY), coll))
};
cljs.core.reductions = function() {
  var reductions = null;
  var reductions__2 = function(f, coll) {
    return new cljs.core.LazySeq(null, false, function() {
      var temp__3971__auto____10250 = cljs.core.seq.call(null, coll);
      if(temp__3971__auto____10250) {
        var s__10251 = temp__3971__auto____10250;
        return reductions.call(null, f, cljs.core.first.call(null, s__10251), cljs.core.rest.call(null, s__10251))
      }else {
        return cljs.core.list.call(null, f.call(null))
      }
    }, null)
  };
  var reductions__3 = function(f, init, coll) {
    return cljs.core.cons.call(null, init, new cljs.core.LazySeq(null, false, function() {
      var temp__3974__auto____10252 = cljs.core.seq.call(null, coll);
      if(temp__3974__auto____10252) {
        var s__10253 = temp__3974__auto____10252;
        return reductions.call(null, f, f.call(null, init, cljs.core.first.call(null, s__10253)), cljs.core.rest.call(null, s__10253))
      }else {
        return null
      }
    }, null))
  };
  reductions = function(f, init, coll) {
    switch(arguments.length) {
      case 2:
        return reductions__2.call(this, f, init);
      case 3:
        return reductions__3.call(this, f, init, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  reductions.cljs$lang$arity$2 = reductions__2;
  reductions.cljs$lang$arity$3 = reductions__3;
  return reductions
}();
cljs.core.juxt = function() {
  var juxt = null;
  var juxt__1 = function(f) {
    return function() {
      var G__10256 = null;
      var G__10256__0 = function() {
        return cljs.core.vector.call(null, f.call(null))
      };
      var G__10256__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x))
      };
      var G__10256__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y))
      };
      var G__10256__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z))
      };
      var G__10256__4 = function() {
        var G__10257__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args))
        };
        var G__10257 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__10257__delegate.call(this, x, y, z, args)
        };
        G__10257.cljs$lang$maxFixedArity = 3;
        G__10257.cljs$lang$applyTo = function(arglist__10258) {
          var x = cljs.core.first(arglist__10258);
          var y = cljs.core.first(cljs.core.next(arglist__10258));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__10258)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__10258)));
          return G__10257__delegate(x, y, z, args)
        };
        G__10257.cljs$lang$arity$variadic = G__10257__delegate;
        return G__10257
      }();
      G__10256 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__10256__0.call(this);
          case 1:
            return G__10256__1.call(this, x);
          case 2:
            return G__10256__2.call(this, x, y);
          case 3:
            return G__10256__3.call(this, x, y, z);
          default:
            return G__10256__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__10256.cljs$lang$maxFixedArity = 3;
      G__10256.cljs$lang$applyTo = G__10256__4.cljs$lang$applyTo;
      return G__10256
    }()
  };
  var juxt__2 = function(f, g) {
    return function() {
      var G__10259 = null;
      var G__10259__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null))
      };
      var G__10259__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x))
      };
      var G__10259__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y))
      };
      var G__10259__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z))
      };
      var G__10259__4 = function() {
        var G__10260__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args))
        };
        var G__10260 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__10260__delegate.call(this, x, y, z, args)
        };
        G__10260.cljs$lang$maxFixedArity = 3;
        G__10260.cljs$lang$applyTo = function(arglist__10261) {
          var x = cljs.core.first(arglist__10261);
          var y = cljs.core.first(cljs.core.next(arglist__10261));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__10261)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__10261)));
          return G__10260__delegate(x, y, z, args)
        };
        G__10260.cljs$lang$arity$variadic = G__10260__delegate;
        return G__10260
      }();
      G__10259 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__10259__0.call(this);
          case 1:
            return G__10259__1.call(this, x);
          case 2:
            return G__10259__2.call(this, x, y);
          case 3:
            return G__10259__3.call(this, x, y, z);
          default:
            return G__10259__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__10259.cljs$lang$maxFixedArity = 3;
      G__10259.cljs$lang$applyTo = G__10259__4.cljs$lang$applyTo;
      return G__10259
    }()
  };
  var juxt__3 = function(f, g, h) {
    return function() {
      var G__10262 = null;
      var G__10262__0 = function() {
        return cljs.core.vector.call(null, f.call(null), g.call(null), h.call(null))
      };
      var G__10262__1 = function(x) {
        return cljs.core.vector.call(null, f.call(null, x), g.call(null, x), h.call(null, x))
      };
      var G__10262__2 = function(x, y) {
        return cljs.core.vector.call(null, f.call(null, x, y), g.call(null, x, y), h.call(null, x, y))
      };
      var G__10262__3 = function(x, y, z) {
        return cljs.core.vector.call(null, f.call(null, x, y, z), g.call(null, x, y, z), h.call(null, x, y, z))
      };
      var G__10262__4 = function() {
        var G__10263__delegate = function(x, y, z, args) {
          return cljs.core.vector.call(null, cljs.core.apply.call(null, f, x, y, z, args), cljs.core.apply.call(null, g, x, y, z, args), cljs.core.apply.call(null, h, x, y, z, args))
        };
        var G__10263 = function(x, y, z, var_args) {
          var args = null;
          if(goog.isDef(var_args)) {
            args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
          }
          return G__10263__delegate.call(this, x, y, z, args)
        };
        G__10263.cljs$lang$maxFixedArity = 3;
        G__10263.cljs$lang$applyTo = function(arglist__10264) {
          var x = cljs.core.first(arglist__10264);
          var y = cljs.core.first(cljs.core.next(arglist__10264));
          var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__10264)));
          var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__10264)));
          return G__10263__delegate(x, y, z, args)
        };
        G__10263.cljs$lang$arity$variadic = G__10263__delegate;
        return G__10263
      }();
      G__10262 = function(x, y, z, var_args) {
        var args = var_args;
        switch(arguments.length) {
          case 0:
            return G__10262__0.call(this);
          case 1:
            return G__10262__1.call(this, x);
          case 2:
            return G__10262__2.call(this, x, y);
          case 3:
            return G__10262__3.call(this, x, y, z);
          default:
            return G__10262__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
        }
        throw"Invalid arity: " + arguments.length;
      };
      G__10262.cljs$lang$maxFixedArity = 3;
      G__10262.cljs$lang$applyTo = G__10262__4.cljs$lang$applyTo;
      return G__10262
    }()
  };
  var juxt__4 = function() {
    var G__10265__delegate = function(f, g, h, fs) {
      var fs__10255 = cljs.core.list_STAR_.call(null, f, g, h, fs);
      return function() {
        var G__10266 = null;
        var G__10266__0 = function() {
          return cljs.core.reduce.call(null, function(p1__10236_SHARP_, p2__10237_SHARP_) {
            return cljs.core.conj.call(null, p1__10236_SHARP_, p2__10237_SHARP_.call(null))
          }, cljs.core.PersistentVector.EMPTY, fs__10255)
        };
        var G__10266__1 = function(x) {
          return cljs.core.reduce.call(null, function(p1__10238_SHARP_, p2__10239_SHARP_) {
            return cljs.core.conj.call(null, p1__10238_SHARP_, p2__10239_SHARP_.call(null, x))
          }, cljs.core.PersistentVector.EMPTY, fs__10255)
        };
        var G__10266__2 = function(x, y) {
          return cljs.core.reduce.call(null, function(p1__10240_SHARP_, p2__10241_SHARP_) {
            return cljs.core.conj.call(null, p1__10240_SHARP_, p2__10241_SHARP_.call(null, x, y))
          }, cljs.core.PersistentVector.EMPTY, fs__10255)
        };
        var G__10266__3 = function(x, y, z) {
          return cljs.core.reduce.call(null, function(p1__10242_SHARP_, p2__10243_SHARP_) {
            return cljs.core.conj.call(null, p1__10242_SHARP_, p2__10243_SHARP_.call(null, x, y, z))
          }, cljs.core.PersistentVector.EMPTY, fs__10255)
        };
        var G__10266__4 = function() {
          var G__10267__delegate = function(x, y, z, args) {
            return cljs.core.reduce.call(null, function(p1__10244_SHARP_, p2__10245_SHARP_) {
              return cljs.core.conj.call(null, p1__10244_SHARP_, cljs.core.apply.call(null, p2__10245_SHARP_, x, y, z, args))
            }, cljs.core.PersistentVector.EMPTY, fs__10255)
          };
          var G__10267 = function(x, y, z, var_args) {
            var args = null;
            if(goog.isDef(var_args)) {
              args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
            }
            return G__10267__delegate.call(this, x, y, z, args)
          };
          G__10267.cljs$lang$maxFixedArity = 3;
          G__10267.cljs$lang$applyTo = function(arglist__10268) {
            var x = cljs.core.first(arglist__10268);
            var y = cljs.core.first(cljs.core.next(arglist__10268));
            var z = cljs.core.first(cljs.core.next(cljs.core.next(arglist__10268)));
            var args = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__10268)));
            return G__10267__delegate(x, y, z, args)
          };
          G__10267.cljs$lang$arity$variadic = G__10267__delegate;
          return G__10267
        }();
        G__10266 = function(x, y, z, var_args) {
          var args = var_args;
          switch(arguments.length) {
            case 0:
              return G__10266__0.call(this);
            case 1:
              return G__10266__1.call(this, x);
            case 2:
              return G__10266__2.call(this, x, y);
            case 3:
              return G__10266__3.call(this, x, y, z);
            default:
              return G__10266__4.cljs$lang$arity$variadic(x, y, z, cljs.core.array_seq(arguments, 3))
          }
          throw"Invalid arity: " + arguments.length;
        };
        G__10266.cljs$lang$maxFixedArity = 3;
        G__10266.cljs$lang$applyTo = G__10266__4.cljs$lang$applyTo;
        return G__10266
      }()
    };
    var G__10265 = function(f, g, h, var_args) {
      var fs = null;
      if(goog.isDef(var_args)) {
        fs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
      }
      return G__10265__delegate.call(this, f, g, h, fs)
    };
    G__10265.cljs$lang$maxFixedArity = 3;
    G__10265.cljs$lang$applyTo = function(arglist__10269) {
      var f = cljs.core.first(arglist__10269);
      var g = cljs.core.first(cljs.core.next(arglist__10269));
      var h = cljs.core.first(cljs.core.next(cljs.core.next(arglist__10269)));
      var fs = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__10269)));
      return G__10265__delegate(f, g, h, fs)
    };
    G__10265.cljs$lang$arity$variadic = G__10265__delegate;
    return G__10265
  }();
  juxt = function(f, g, h, var_args) {
    var fs = var_args;
    switch(arguments.length) {
      case 1:
        return juxt__1.call(this, f);
      case 2:
        return juxt__2.call(this, f, g);
      case 3:
        return juxt__3.call(this, f, g, h);
      default:
        return juxt__4.cljs$lang$arity$variadic(f, g, h, cljs.core.array_seq(arguments, 3))
    }
    throw"Invalid arity: " + arguments.length;
  };
  juxt.cljs$lang$maxFixedArity = 3;
  juxt.cljs$lang$applyTo = juxt__4.cljs$lang$applyTo;
  juxt.cljs$lang$arity$1 = juxt__1;
  juxt.cljs$lang$arity$2 = juxt__2;
  juxt.cljs$lang$arity$3 = juxt__3;
  juxt.cljs$lang$arity$variadic = juxt__4.cljs$lang$arity$variadic;
  return juxt
}();
cljs.core.dorun = function() {
  var dorun = null;
  var dorun__1 = function(coll) {
    while(true) {
      if(cljs.core.seq.call(null, coll)) {
        var G__10272 = cljs.core.next.call(null, coll);
        coll = G__10272;
        continue
      }else {
        return null
      }
      break
    }
  };
  var dorun__2 = function(n, coll) {
    while(true) {
      if(cljs.core.truth_(function() {
        var and__3822__auto____10271 = cljs.core.seq.call(null, coll);
        if(and__3822__auto____10271) {
          return n > 0
        }else {
          return and__3822__auto____10271
        }
      }())) {
        var G__10273 = n - 1;
        var G__10274 = cljs.core.next.call(null, coll);
        n = G__10273;
        coll = G__10274;
        continue
      }else {
        return null
      }
      break
    }
  };
  dorun = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return dorun__1.call(this, n);
      case 2:
        return dorun__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  dorun.cljs$lang$arity$1 = dorun__1;
  dorun.cljs$lang$arity$2 = dorun__2;
  return dorun
}();
cljs.core.doall = function() {
  var doall = null;
  var doall__1 = function(coll) {
    cljs.core.dorun.call(null, coll);
    return coll
  };
  var doall__2 = function(n, coll) {
    cljs.core.dorun.call(null, n, coll);
    return coll
  };
  doall = function(n, coll) {
    switch(arguments.length) {
      case 1:
        return doall__1.call(this, n);
      case 2:
        return doall__2.call(this, n, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  doall.cljs$lang$arity$1 = doall__1;
  doall.cljs$lang$arity$2 = doall__2;
  return doall
}();
cljs.core.regexp_QMARK_ = function regexp_QMARK_(o) {
  return o instanceof RegExp
};
cljs.core.re_matches = function re_matches(re, s) {
  var matches__10276 = re.exec(s);
  if(cljs.core._EQ_.call(null, cljs.core.first.call(null, matches__10276), s)) {
    if(cljs.core.count.call(null, matches__10276) === 1) {
      return cljs.core.first.call(null, matches__10276)
    }else {
      return cljs.core.vec.call(null, matches__10276)
    }
  }else {
    return null
  }
};
cljs.core.re_find = function re_find(re, s) {
  var matches__10278 = re.exec(s);
  if(matches__10278 == null) {
    return null
  }else {
    if(cljs.core.count.call(null, matches__10278) === 1) {
      return cljs.core.first.call(null, matches__10278)
    }else {
      return cljs.core.vec.call(null, matches__10278)
    }
  }
};
cljs.core.re_seq = function re_seq(re, s) {
  var match_data__10283 = cljs.core.re_find.call(null, re, s);
  var match_idx__10284 = s.search(re);
  var match_str__10285 = cljs.core.coll_QMARK_.call(null, match_data__10283) ? cljs.core.first.call(null, match_data__10283) : match_data__10283;
  var post_match__10286 = cljs.core.subs.call(null, s, match_idx__10284 + cljs.core.count.call(null, match_str__10285));
  if(cljs.core.truth_(match_data__10283)) {
    return new cljs.core.LazySeq(null, false, function() {
      return cljs.core.cons.call(null, match_data__10283, re_seq.call(null, re, post_match__10286))
    }, null)
  }else {
    return null
  }
};
cljs.core.re_pattern = function re_pattern(s) {
  var vec__10293__10294 = cljs.core.re_find.call(null, /^(?:\(\?([idmsux]*)\))?(.*)/, s);
  var ___10295 = cljs.core.nth.call(null, vec__10293__10294, 0, null);
  var flags__10296 = cljs.core.nth.call(null, vec__10293__10294, 1, null);
  var pattern__10297 = cljs.core.nth.call(null, vec__10293__10294, 2, null);
  return new RegExp(pattern__10297, flags__10296)
};
cljs.core.pr_sequential = function pr_sequential(print_one, begin, sep, end, opts, coll) {
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray([begin], true), cljs.core.flatten1.call(null, cljs.core.interpose.call(null, cljs.core.PersistentVector.fromArray([sep], true), cljs.core.map.call(null, function(p1__10287_SHARP_) {
    return print_one.call(null, p1__10287_SHARP_, opts)
  }, coll))), cljs.core.PersistentVector.fromArray([end], true))
};
cljs.core.string_print = function string_print(x) {
  cljs.core._STAR_print_fn_STAR_.call(null, x);
  return null
};
cljs.core.flush = function flush() {
  return null
};
cljs.core.pr_seq = function pr_seq(obj, opts) {
  if(obj == null) {
    return cljs.core.list.call(null, "nil")
  }else {
    if(void 0 === obj) {
      return cljs.core.list.call(null, "#<undefined>")
    }else {
      if("\ufdd0'else") {
        return cljs.core.concat.call(null, cljs.core.truth_(function() {
          var and__3822__auto____10307 = cljs.core._lookup.call(null, opts, "\ufdd0'meta", null);
          if(cljs.core.truth_(and__3822__auto____10307)) {
            var and__3822__auto____10311 = function() {
              var G__10308__10309 = obj;
              if(G__10308__10309) {
                if(function() {
                  var or__3824__auto____10310 = G__10308__10309.cljs$lang$protocol_mask$partition0$ & 131072;
                  if(or__3824__auto____10310) {
                    return or__3824__auto____10310
                  }else {
                    return G__10308__10309.cljs$core$IMeta$
                  }
                }()) {
                  return true
                }else {
                  if(!G__10308__10309.cljs$lang$protocol_mask$partition0$) {
                    return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__10308__10309)
                  }else {
                    return false
                  }
                }
              }else {
                return cljs.core.type_satisfies_.call(null, cljs.core.IMeta, G__10308__10309)
              }
            }();
            if(cljs.core.truth_(and__3822__auto____10311)) {
              return cljs.core.meta.call(null, obj)
            }else {
              return and__3822__auto____10311
            }
          }else {
            return and__3822__auto____10307
          }
        }()) ? cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["^"], true), pr_seq.call(null, cljs.core.meta.call(null, obj), opts), cljs.core.PersistentVector.fromArray([" "], true)) : null, function() {
          var and__3822__auto____10312 = !(obj == null);
          if(and__3822__auto____10312) {
            return obj.cljs$lang$type
          }else {
            return and__3822__auto____10312
          }
        }() ? obj.cljs$lang$ctorPrSeq(obj) : function() {
          var G__10313__10314 = obj;
          if(G__10313__10314) {
            if(function() {
              var or__3824__auto____10315 = G__10313__10314.cljs$lang$protocol_mask$partition0$ & 536870912;
              if(or__3824__auto____10315) {
                return or__3824__auto____10315
              }else {
                return G__10313__10314.cljs$core$IPrintable$
              }
            }()) {
              return true
            }else {
              if(!G__10313__10314.cljs$lang$protocol_mask$partition0$) {
                return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__10313__10314)
              }else {
                return false
              }
            }
          }else {
            return cljs.core.type_satisfies_.call(null, cljs.core.IPrintable, G__10313__10314)
          }
        }() ? cljs.core._pr_seq.call(null, obj, opts) : cljs.core.truth_(cljs.core.regexp_QMARK_.call(null, obj)) ? cljs.core.list.call(null, '#"', obj.source, '"') : "\ufdd0'else" ? cljs.core.list.call(null, "#<", [cljs.core.str(obj)].join(""), ">") : null)
      }else {
        return null
      }
    }
  }
};
cljs.core.pr_sb = function pr_sb(objs, opts) {
  var sb__10335 = new goog.string.StringBuffer;
  var G__10336__10337 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, cljs.core.first.call(null, objs), opts));
  if(G__10336__10337) {
    var string__10338 = cljs.core.first.call(null, G__10336__10337);
    var G__10336__10339 = G__10336__10337;
    while(true) {
      sb__10335.append(string__10338);
      var temp__3974__auto____10340 = cljs.core.next.call(null, G__10336__10339);
      if(temp__3974__auto____10340) {
        var G__10336__10341 = temp__3974__auto____10340;
        var G__10354 = cljs.core.first.call(null, G__10336__10341);
        var G__10355 = G__10336__10341;
        string__10338 = G__10354;
        G__10336__10339 = G__10355;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__10342__10343 = cljs.core.seq.call(null, cljs.core.next.call(null, objs));
  if(G__10342__10343) {
    var obj__10344 = cljs.core.first.call(null, G__10342__10343);
    var G__10342__10345 = G__10342__10343;
    while(true) {
      sb__10335.append(" ");
      var G__10346__10347 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__10344, opts));
      if(G__10346__10347) {
        var string__10348 = cljs.core.first.call(null, G__10346__10347);
        var G__10346__10349 = G__10346__10347;
        while(true) {
          sb__10335.append(string__10348);
          var temp__3974__auto____10350 = cljs.core.next.call(null, G__10346__10349);
          if(temp__3974__auto____10350) {
            var G__10346__10351 = temp__3974__auto____10350;
            var G__10356 = cljs.core.first.call(null, G__10346__10351);
            var G__10357 = G__10346__10351;
            string__10348 = G__10356;
            G__10346__10349 = G__10357;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3974__auto____10352 = cljs.core.next.call(null, G__10342__10345);
      if(temp__3974__auto____10352) {
        var G__10342__10353 = temp__3974__auto____10352;
        var G__10358 = cljs.core.first.call(null, G__10342__10353);
        var G__10359 = G__10342__10353;
        obj__10344 = G__10358;
        G__10342__10345 = G__10359;
        continue
      }else {
      }
      break
    }
  }else {
  }
  return sb__10335
};
cljs.core.pr_str_with_opts = function pr_str_with_opts(objs, opts) {
  return[cljs.core.str(cljs.core.pr_sb.call(null, objs, opts))].join("")
};
cljs.core.prn_str_with_opts = function prn_str_with_opts(objs, opts) {
  var sb__10361 = cljs.core.pr_sb.call(null, objs, opts);
  sb__10361.append("\n");
  return[cljs.core.str(sb__10361)].join("")
};
cljs.core.pr_with_opts = function pr_with_opts(objs, opts) {
  var G__10380__10381 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, cljs.core.first.call(null, objs), opts));
  if(G__10380__10381) {
    var string__10382 = cljs.core.first.call(null, G__10380__10381);
    var G__10380__10383 = G__10380__10381;
    while(true) {
      cljs.core.string_print.call(null, string__10382);
      var temp__3974__auto____10384 = cljs.core.next.call(null, G__10380__10383);
      if(temp__3974__auto____10384) {
        var G__10380__10385 = temp__3974__auto____10384;
        var G__10398 = cljs.core.first.call(null, G__10380__10385);
        var G__10399 = G__10380__10385;
        string__10382 = G__10398;
        G__10380__10383 = G__10399;
        continue
      }else {
      }
      break
    }
  }else {
  }
  var G__10386__10387 = cljs.core.seq.call(null, cljs.core.next.call(null, objs));
  if(G__10386__10387) {
    var obj__10388 = cljs.core.first.call(null, G__10386__10387);
    var G__10386__10389 = G__10386__10387;
    while(true) {
      cljs.core.string_print.call(null, " ");
      var G__10390__10391 = cljs.core.seq.call(null, cljs.core.pr_seq.call(null, obj__10388, opts));
      if(G__10390__10391) {
        var string__10392 = cljs.core.first.call(null, G__10390__10391);
        var G__10390__10393 = G__10390__10391;
        while(true) {
          cljs.core.string_print.call(null, string__10392);
          var temp__3974__auto____10394 = cljs.core.next.call(null, G__10390__10393);
          if(temp__3974__auto____10394) {
            var G__10390__10395 = temp__3974__auto____10394;
            var G__10400 = cljs.core.first.call(null, G__10390__10395);
            var G__10401 = G__10390__10395;
            string__10392 = G__10400;
            G__10390__10393 = G__10401;
            continue
          }else {
          }
          break
        }
      }else {
      }
      var temp__3974__auto____10396 = cljs.core.next.call(null, G__10386__10389);
      if(temp__3974__auto____10396) {
        var G__10386__10397 = temp__3974__auto____10396;
        var G__10402 = cljs.core.first.call(null, G__10386__10397);
        var G__10403 = G__10386__10397;
        obj__10388 = G__10402;
        G__10386__10389 = G__10403;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.newline = function newline(opts) {
  cljs.core.string_print.call(null, "\n");
  if(cljs.core.truth_(cljs.core._lookup.call(null, opts, "\ufdd0'flush-on-newline", null))) {
    return cljs.core.flush.call(null)
  }else {
    return null
  }
};
cljs.core._STAR_flush_on_newline_STAR_ = true;
cljs.core._STAR_print_readably_STAR_ = true;
cljs.core._STAR_print_meta_STAR_ = false;
cljs.core._STAR_print_dup_STAR_ = false;
cljs.core.pr_opts = function pr_opts() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'flush-on-newline", "\ufdd0'readably", "\ufdd0'meta", "\ufdd0'dup"], {"\ufdd0'flush-on-newline":cljs.core._STAR_flush_on_newline_STAR_, "\ufdd0'readably":cljs.core._STAR_print_readably_STAR_, "\ufdd0'meta":cljs.core._STAR_print_meta_STAR_, "\ufdd0'dup":cljs.core._STAR_print_dup_STAR_})
};
cljs.core.pr_str = function() {
  var pr_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr_str__delegate.call(this, objs)
  };
  pr_str.cljs$lang$maxFixedArity = 0;
  pr_str.cljs$lang$applyTo = function(arglist__10404) {
    var objs = cljs.core.seq(arglist__10404);
    return pr_str__delegate(objs)
  };
  pr_str.cljs$lang$arity$variadic = pr_str__delegate;
  return pr_str
}();
cljs.core.prn_str = function() {
  var prn_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var prn_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn_str__delegate.call(this, objs)
  };
  prn_str.cljs$lang$maxFixedArity = 0;
  prn_str.cljs$lang$applyTo = function(arglist__10405) {
    var objs = cljs.core.seq(arglist__10405);
    return prn_str__delegate(objs)
  };
  prn_str.cljs$lang$arity$variadic = prn_str__delegate;
  return prn_str
}();
cljs.core.pr = function() {
  var pr__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null))
  };
  var pr = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return pr__delegate.call(this, objs)
  };
  pr.cljs$lang$maxFixedArity = 0;
  pr.cljs$lang$applyTo = function(arglist__10406) {
    var objs = cljs.core.seq(arglist__10406);
    return pr__delegate(objs)
  };
  pr.cljs$lang$arity$variadic = pr__delegate;
  return pr
}();
cljs.core.print = function() {
  var cljs_core_print__delegate = function(objs) {
    return cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var cljs_core_print = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return cljs_core_print__delegate.call(this, objs)
  };
  cljs_core_print.cljs$lang$maxFixedArity = 0;
  cljs_core_print.cljs$lang$applyTo = function(arglist__10407) {
    var objs = cljs.core.seq(arglist__10407);
    return cljs_core_print__delegate(objs)
  };
  cljs_core_print.cljs$lang$arity$variadic = cljs_core_print__delegate;
  return cljs_core_print
}();
cljs.core.print_str = function() {
  var print_str__delegate = function(objs) {
    return cljs.core.pr_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var print_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return print_str__delegate.call(this, objs)
  };
  print_str.cljs$lang$maxFixedArity = 0;
  print_str.cljs$lang$applyTo = function(arglist__10408) {
    var objs = cljs.core.seq(arglist__10408);
    return print_str__delegate(objs)
  };
  print_str.cljs$lang$arity$variadic = print_str__delegate;
  return print_str
}();
cljs.core.println = function() {
  var println__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var println = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println__delegate.call(this, objs)
  };
  println.cljs$lang$maxFixedArity = 0;
  println.cljs$lang$applyTo = function(arglist__10409) {
    var objs = cljs.core.seq(arglist__10409);
    return println__delegate(objs)
  };
  println.cljs$lang$arity$variadic = println__delegate;
  return println
}();
cljs.core.println_str = function() {
  var println_str__delegate = function(objs) {
    return cljs.core.prn_str_with_opts.call(null, objs, cljs.core.assoc.call(null, cljs.core.pr_opts.call(null), "\ufdd0'readably", false))
  };
  var println_str = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return println_str__delegate.call(this, objs)
  };
  println_str.cljs$lang$maxFixedArity = 0;
  println_str.cljs$lang$applyTo = function(arglist__10410) {
    var objs = cljs.core.seq(arglist__10410);
    return println_str__delegate(objs)
  };
  println_str.cljs$lang$arity$variadic = println_str__delegate;
  return println_str
}();
cljs.core.prn = function() {
  var prn__delegate = function(objs) {
    cljs.core.pr_with_opts.call(null, objs, cljs.core.pr_opts.call(null));
    return cljs.core.newline.call(null, cljs.core.pr_opts.call(null))
  };
  var prn = function(var_args) {
    var objs = null;
    if(goog.isDef(var_args)) {
      objs = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return prn__delegate.call(this, objs)
  };
  prn.cljs$lang$maxFixedArity = 0;
  prn.cljs$lang$applyTo = function(arglist__10411) {
    var objs = cljs.core.seq(arglist__10411);
    return prn__delegate(objs)
  };
  prn.cljs$lang$arity$variadic = prn__delegate;
  return prn
}();
cljs.core.printf = function() {
  var printf__delegate = function(fmt, args) {
    return cljs.core.print.call(null, cljs.core.apply.call(null, cljs.core.format, fmt, args))
  };
  var printf = function(fmt, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return printf__delegate.call(this, fmt, args)
  };
  printf.cljs$lang$maxFixedArity = 1;
  printf.cljs$lang$applyTo = function(arglist__10412) {
    var fmt = cljs.core.first(arglist__10412);
    var args = cljs.core.rest(arglist__10412);
    return printf__delegate(fmt, args)
  };
  printf.cljs$lang$arity$variadic = printf__delegate;
  return printf
}();
cljs.core.HashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.HashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__10413 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__10413, "{", ", ", "}", opts, coll)
};
cljs.core.IPrintable["number"] = true;
cljs.core._pr_seq["number"] = function(n, opts) {
  return cljs.core.list.call(null, [cljs.core.str(n)].join(""))
};
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.IndexedSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Subvec.prototype.cljs$core$IPrintable$ = true;
cljs.core.Subvec.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.ChunkedCons.prototype.cljs$core$IPrintable$ = true;
cljs.core.ChunkedCons.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__10414 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__10414, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__10415 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__10415, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentQueue.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#queue [", " ", "]", opts, cljs.core.seq.call(null, coll))
};
cljs.core.LazySeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.LazySeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.RSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.RSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.IPrintable["boolean"] = true;
cljs.core._pr_seq["boolean"] = function(bool, opts) {
  return cljs.core.list.call(null, [cljs.core.str(bool)].join(""))
};
cljs.core.IPrintable["string"] = true;
cljs.core._pr_seq["string"] = function(obj, opts) {
  if(cljs.core.keyword_QMARK_.call(null, obj)) {
    return cljs.core.list.call(null, [cljs.core.str(":"), cljs.core.str(function() {
      var temp__3974__auto____10416 = cljs.core.namespace.call(null, obj);
      if(cljs.core.truth_(temp__3974__auto____10416)) {
        var nspc__10417 = temp__3974__auto____10416;
        return[cljs.core.str(nspc__10417), cljs.core.str("/")].join("")
      }else {
        return null
      }
    }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
  }else {
    if(cljs.core.symbol_QMARK_.call(null, obj)) {
      return cljs.core.list.call(null, [cljs.core.str(function() {
        var temp__3974__auto____10418 = cljs.core.namespace.call(null, obj);
        if(cljs.core.truth_(temp__3974__auto____10418)) {
          var nspc__10419 = temp__3974__auto____10418;
          return[cljs.core.str(nspc__10419), cljs.core.str("/")].join("")
        }else {
          return null
        }
      }()), cljs.core.str(cljs.core.name.call(null, obj))].join(""))
    }else {
      if("\ufdd0'else") {
        return cljs.core.list.call(null, cljs.core.truth_((new cljs.core.Keyword("\ufdd0'readably")).call(null, opts)) ? goog.string.quote(obj) : obj)
      }else {
        return null
      }
    }
  }
};
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.NodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.RedNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.RedNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.ChunkedSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.ChunkedSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__10420 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__10420, "{", ", ", "}", opts, coll)
};
cljs.core.Vector.prototype.cljs$core$IPrintable$ = true;
cljs.core.Vector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentHashSet.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#{", " ", "}", opts, coll)
};
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
cljs.core.List.prototype.cljs$core$IPrintable$ = true;
cljs.core.List.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.IPrintable["array"] = true;
cljs.core._pr_seq["array"] = function(a, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "#<Array [", ", ", "]>", opts, a)
};
cljs.core.IPrintable["function"] = true;
cljs.core._pr_seq["function"] = function(this$) {
  return cljs.core.list.call(null, "#<", [cljs.core.str(this$)].join(""), ">")
};
cljs.core.EmptyList.prototype.cljs$core$IPrintable$ = true;
cljs.core.EmptyList.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.list.call(null, "()")
};
cljs.core.BlackNode.prototype.cljs$core$IPrintable$ = true;
cljs.core.BlackNode.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "[", " ", "]", opts, coll)
};
Date.prototype.cljs$core$IPrintable$ = true;
Date.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(d, _) {
  var normalize__10422 = function(n, len) {
    var ns__10421 = [cljs.core.str(n)].join("");
    while(true) {
      if(cljs.core.count.call(null, ns__10421) < len) {
        var G__10424 = [cljs.core.str("0"), cljs.core.str(ns__10421)].join("");
        ns__10421 = G__10424;
        continue
      }else {
        return ns__10421
      }
      break
    }
  };
  return cljs.core.list.call(null, [cljs.core.str('#inst "'), cljs.core.str(d.getUTCFullYear()), cljs.core.str("-"), cljs.core.str(normalize__10422.call(null, d.getUTCMonth() + 1, 2)), cljs.core.str("-"), cljs.core.str(normalize__10422.call(null, d.getUTCDate(), 2)), cljs.core.str("T"), cljs.core.str(normalize__10422.call(null, d.getUTCHours(), 2)), cljs.core.str(":"), cljs.core.str(normalize__10422.call(null, d.getUTCMinutes(), 2)), cljs.core.str(":"), cljs.core.str(normalize__10422.call(null, d.getUTCSeconds(), 
  2)), cljs.core.str("."), cljs.core.str(normalize__10422.call(null, d.getUTCMilliseconds(), 3)), cljs.core.str("-"), cljs.core.str('00:00"')].join(""))
};
cljs.core.Cons.prototype.cljs$core$IPrintable$ = true;
cljs.core.Cons.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.Range.prototype.cljs$core$IPrintable$ = true;
cljs.core.Range.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.ObjMap.prototype.cljs$core$IPrintable$ = true;
cljs.core.ObjMap.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  var pr_pair__10423 = function(keyval) {
    return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "", " ", "", opts, keyval)
  };
  return cljs.core.pr_sequential.call(null, pr_pair__10423, "{", ", ", "}", opts, coll)
};
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$ = true;
cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(coll, opts) {
  return cljs.core.pr_sequential.call(null, cljs.core.pr_seq, "(", " ", ")", opts, coll)
};
cljs.core.PersistentVector.prototype.cljs$core$IComparable$ = true;
cljs.core.PersistentVector.prototype.cljs$core$IComparable$_compare$arity$2 = function(x, y) {
  return cljs.core.compare_indexed.call(null, x, y)
};
cljs.core.Atom = function(state, meta, validator, watches) {
  this.state = state;
  this.meta = meta;
  this.validator = validator;
  this.watches = watches;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 2690809856
};
cljs.core.Atom.cljs$lang$type = true;
cljs.core.Atom.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/Atom")
};
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__10425 = this;
  return goog.getUid(this$)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = function(this$, oldval, newval) {
  var this__10426 = this;
  var G__10427__10428 = cljs.core.seq.call(null, this__10426.watches);
  if(G__10427__10428) {
    var G__10430__10432 = cljs.core.first.call(null, G__10427__10428);
    var vec__10431__10433 = G__10430__10432;
    var key__10434 = cljs.core.nth.call(null, vec__10431__10433, 0, null);
    var f__10435 = cljs.core.nth.call(null, vec__10431__10433, 1, null);
    var G__10427__10436 = G__10427__10428;
    var G__10430__10437 = G__10430__10432;
    var G__10427__10438 = G__10427__10436;
    while(true) {
      var vec__10439__10440 = G__10430__10437;
      var key__10441 = cljs.core.nth.call(null, vec__10439__10440, 0, null);
      var f__10442 = cljs.core.nth.call(null, vec__10439__10440, 1, null);
      var G__10427__10443 = G__10427__10438;
      f__10442.call(null, key__10441, this$, oldval, newval);
      var temp__3974__auto____10444 = cljs.core.next.call(null, G__10427__10443);
      if(temp__3974__auto____10444) {
        var G__10427__10445 = temp__3974__auto____10444;
        var G__10452 = cljs.core.first.call(null, G__10427__10445);
        var G__10453 = G__10427__10445;
        G__10430__10437 = G__10452;
        G__10427__10438 = G__10453;
        continue
      }else {
        return null
      }
      break
    }
  }else {
    return null
  }
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = function(this$, key, f) {
  var this__10446 = this;
  return this$.watches = cljs.core.assoc.call(null, this__10446.watches, key, f)
};
cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = function(this$, key) {
  var this__10447 = this;
  return this$.watches = cljs.core.dissoc.call(null, this__10447.watches, key)
};
cljs.core.Atom.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(a, opts) {
  var this__10448 = this;
  return cljs.core.concat.call(null, cljs.core.PersistentVector.fromArray(["#<Atom: "], true), cljs.core._pr_seq.call(null, this__10448.state, opts), ">")
};
cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = function(_) {
  var this__10449 = this;
  return this__10449.meta
};
cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__10450 = this;
  return this__10450.state
};
cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(o, other) {
  var this__10451 = this;
  return o === other
};
cljs.core.Atom;
cljs.core.atom = function() {
  var atom = null;
  var atom__1 = function(x) {
    return new cljs.core.Atom(x, null, null, null)
  };
  var atom__2 = function() {
    var G__10465__delegate = function(x, p__10454) {
      var map__10460__10461 = p__10454;
      var map__10460__10462 = cljs.core.seq_QMARK_.call(null, map__10460__10461) ? cljs.core.apply.call(null, cljs.core.hash_map, map__10460__10461) : map__10460__10461;
      var validator__10463 = cljs.core._lookup.call(null, map__10460__10462, "\ufdd0'validator", null);
      var meta__10464 = cljs.core._lookup.call(null, map__10460__10462, "\ufdd0'meta", null);
      return new cljs.core.Atom(x, meta__10464, validator__10463, null)
    };
    var G__10465 = function(x, var_args) {
      var p__10454 = null;
      if(goog.isDef(var_args)) {
        p__10454 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__10465__delegate.call(this, x, p__10454)
    };
    G__10465.cljs$lang$maxFixedArity = 1;
    G__10465.cljs$lang$applyTo = function(arglist__10466) {
      var x = cljs.core.first(arglist__10466);
      var p__10454 = cljs.core.rest(arglist__10466);
      return G__10465__delegate(x, p__10454)
    };
    G__10465.cljs$lang$arity$variadic = G__10465__delegate;
    return G__10465
  }();
  atom = function(x, var_args) {
    var p__10454 = var_args;
    switch(arguments.length) {
      case 1:
        return atom__1.call(this, x);
      default:
        return atom__2.cljs$lang$arity$variadic(x, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  atom.cljs$lang$maxFixedArity = 1;
  atom.cljs$lang$applyTo = atom__2.cljs$lang$applyTo;
  atom.cljs$lang$arity$1 = atom__1;
  atom.cljs$lang$arity$variadic = atom__2.cljs$lang$arity$variadic;
  return atom
}();
cljs.core.reset_BANG_ = function reset_BANG_(a, new_value) {
  var temp__3974__auto____10470 = a.validator;
  if(cljs.core.truth_(temp__3974__auto____10470)) {
    var validate__10471 = temp__3974__auto____10470;
    if(cljs.core.truth_(validate__10471.call(null, new_value))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str("Validator rejected reference state"), cljs.core.str("\n"), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'validate", "\ufdd1'new-value"), cljs.core.hash_map("\ufdd0'line", 6440))))].join(""));
    }
  }else {
  }
  var old_value__10472 = a.state;
  a.state = new_value;
  cljs.core._notify_watches.call(null, a, old_value__10472, new_value);
  return new_value
};
cljs.core.swap_BANG_ = function() {
  var swap_BANG_ = null;
  var swap_BANG___2 = function(a, f) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state))
  };
  var swap_BANG___3 = function(a, f, x) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x))
  };
  var swap_BANG___4 = function(a, f, x, y) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y))
  };
  var swap_BANG___5 = function(a, f, x, y, z) {
    return cljs.core.reset_BANG_.call(null, a, f.call(null, a.state, x, y, z))
  };
  var swap_BANG___6 = function() {
    var G__10473__delegate = function(a, f, x, y, z, more) {
      return cljs.core.reset_BANG_.call(null, a, cljs.core.apply.call(null, f, a.state, x, y, z, more))
    };
    var G__10473 = function(a, f, x, y, z, var_args) {
      var more = null;
      if(goog.isDef(var_args)) {
        more = cljs.core.array_seq(Array.prototype.slice.call(arguments, 5), 0)
      }
      return G__10473__delegate.call(this, a, f, x, y, z, more)
    };
    G__10473.cljs$lang$maxFixedArity = 5;
    G__10473.cljs$lang$applyTo = function(arglist__10474) {
      var a = cljs.core.first(arglist__10474);
      var f = cljs.core.first(cljs.core.next(arglist__10474));
      var x = cljs.core.first(cljs.core.next(cljs.core.next(arglist__10474)));
      var y = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(arglist__10474))));
      var z = cljs.core.first(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__10474)))));
      var more = cljs.core.rest(cljs.core.next(cljs.core.next(cljs.core.next(cljs.core.next(arglist__10474)))));
      return G__10473__delegate(a, f, x, y, z, more)
    };
    G__10473.cljs$lang$arity$variadic = G__10473__delegate;
    return G__10473
  }();
  swap_BANG_ = function(a, f, x, y, z, var_args) {
    var more = var_args;
    switch(arguments.length) {
      case 2:
        return swap_BANG___2.call(this, a, f);
      case 3:
        return swap_BANG___3.call(this, a, f, x);
      case 4:
        return swap_BANG___4.call(this, a, f, x, y);
      case 5:
        return swap_BANG___5.call(this, a, f, x, y, z);
      default:
        return swap_BANG___6.cljs$lang$arity$variadic(a, f, x, y, z, cljs.core.array_seq(arguments, 5))
    }
    throw"Invalid arity: " + arguments.length;
  };
  swap_BANG_.cljs$lang$maxFixedArity = 5;
  swap_BANG_.cljs$lang$applyTo = swap_BANG___6.cljs$lang$applyTo;
  swap_BANG_.cljs$lang$arity$2 = swap_BANG___2;
  swap_BANG_.cljs$lang$arity$3 = swap_BANG___3;
  swap_BANG_.cljs$lang$arity$4 = swap_BANG___4;
  swap_BANG_.cljs$lang$arity$5 = swap_BANG___5;
  swap_BANG_.cljs$lang$arity$variadic = swap_BANG___6.cljs$lang$arity$variadic;
  return swap_BANG_
}();
cljs.core.compare_and_set_BANG_ = function compare_and_set_BANG_(a, oldval, newval) {
  if(cljs.core._EQ_.call(null, a.state, oldval)) {
    cljs.core.reset_BANG_.call(null, a, newval);
    return true
  }else {
    return false
  }
};
cljs.core.deref = function deref(o) {
  return cljs.core._deref.call(null, o)
};
cljs.core.set_validator_BANG_ = function set_validator_BANG_(iref, val) {
  return iref.validator = val
};
cljs.core.get_validator = function get_validator(iref) {
  return iref.validator
};
cljs.core.alter_meta_BANG_ = function() {
  var alter_meta_BANG___delegate = function(iref, f, args) {
    return iref.meta = cljs.core.apply.call(null, f, iref.meta, args)
  };
  var alter_meta_BANG_ = function(iref, f, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 2), 0)
    }
    return alter_meta_BANG___delegate.call(this, iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
  alter_meta_BANG_.cljs$lang$applyTo = function(arglist__10475) {
    var iref = cljs.core.first(arglist__10475);
    var f = cljs.core.first(cljs.core.next(arglist__10475));
    var args = cljs.core.rest(cljs.core.next(arglist__10475));
    return alter_meta_BANG___delegate(iref, f, args)
  };
  alter_meta_BANG_.cljs$lang$arity$variadic = alter_meta_BANG___delegate;
  return alter_meta_BANG_
}();
cljs.core.reset_meta_BANG_ = function reset_meta_BANG_(iref, m) {
  return iref.meta = m
};
cljs.core.add_watch = function add_watch(iref, key, f) {
  return cljs.core._add_watch.call(null, iref, key, f)
};
cljs.core.remove_watch = function remove_watch(iref, key) {
  return cljs.core._remove_watch.call(null, iref, key)
};
cljs.core.gensym_counter = null;
cljs.core.gensym = function() {
  var gensym = null;
  var gensym__0 = function() {
    return gensym.call(null, "G__")
  };
  var gensym__1 = function(prefix_string) {
    if(cljs.core.gensym_counter == null) {
      cljs.core.gensym_counter = cljs.core.atom.call(null, 0)
    }else {
    }
    return cljs.core.symbol.call(null, [cljs.core.str(prefix_string), cljs.core.str(cljs.core.swap_BANG_.call(null, cljs.core.gensym_counter, cljs.core.inc))].join(""))
  };
  gensym = function(prefix_string) {
    switch(arguments.length) {
      case 0:
        return gensym__0.call(this);
      case 1:
        return gensym__1.call(this, prefix_string)
    }
    throw"Invalid arity: " + arguments.length;
  };
  gensym.cljs$lang$arity$0 = gensym__0;
  gensym.cljs$lang$arity$1 = gensym__1;
  return gensym
}();
cljs.core.fixture1 = 1;
cljs.core.fixture2 = 2;
cljs.core.Delay = function(state, f) {
  this.state = state;
  this.f = f;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 1073774592
};
cljs.core.Delay.cljs$lang$type = true;
cljs.core.Delay.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/Delay")
};
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = function(d) {
  var this__10476 = this;
  return(new cljs.core.Keyword("\ufdd0'done")).call(null, cljs.core.deref.call(null, this__10476.state))
};
cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = function(_) {
  var this__10477 = this;
  return(new cljs.core.Keyword("\ufdd0'value")).call(null, cljs.core.swap_BANG_.call(null, this__10477.state, function(p__10478) {
    var map__10479__10480 = p__10478;
    var map__10479__10481 = cljs.core.seq_QMARK_.call(null, map__10479__10480) ? cljs.core.apply.call(null, cljs.core.hash_map, map__10479__10480) : map__10479__10480;
    var curr_state__10482 = map__10479__10481;
    var done__10483 = cljs.core._lookup.call(null, map__10479__10481, "\ufdd0'done", null);
    if(cljs.core.truth_(done__10483)) {
      return curr_state__10482
    }else {
      return cljs.core.ObjMap.fromObject(["\ufdd0'done", "\ufdd0'value"], {"\ufdd0'done":true, "\ufdd0'value":this__10477.f.call(null)})
    }
  }))
};
cljs.core.Delay;
cljs.core.delay_QMARK_ = function delay_QMARK_(x) {
  return cljs.core.instance_QMARK_.call(null, cljs.core.Delay, x)
};
cljs.core.force = function force(x) {
  if(cljs.core.delay_QMARK_.call(null, x)) {
    return cljs.core.deref.call(null, x)
  }else {
    return x
  }
};
cljs.core.realized_QMARK_ = function realized_QMARK_(d) {
  return cljs.core._realized_QMARK_.call(null, d)
};
cljs.core.js__GT_clj = function() {
  var js__GT_clj__delegate = function(x, options) {
    var map__10504__10505 = options;
    var map__10504__10506 = cljs.core.seq_QMARK_.call(null, map__10504__10505) ? cljs.core.apply.call(null, cljs.core.hash_map, map__10504__10505) : map__10504__10505;
    var keywordize_keys__10507 = cljs.core._lookup.call(null, map__10504__10506, "\ufdd0'keywordize-keys", null);
    var keyfn__10508 = cljs.core.truth_(keywordize_keys__10507) ? cljs.core.keyword : cljs.core.str;
    var f__10523 = function thisfn(x) {
      if(cljs.core.seq_QMARK_.call(null, x)) {
        return cljs.core.doall.call(null, cljs.core.map.call(null, thisfn, x))
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.into.call(null, cljs.core.empty.call(null, x), cljs.core.map.call(null, thisfn, x))
        }else {
          if(cljs.core.truth_(goog.isArray(x))) {
            return cljs.core.vec.call(null, cljs.core.map.call(null, thisfn, x))
          }else {
            if(cljs.core.type.call(null, x) === Object) {
              return cljs.core.into.call(null, cljs.core.ObjMap.EMPTY, function() {
                var iter__2557__auto____10522 = function iter__10516(s__10517) {
                  return new cljs.core.LazySeq(null, false, function() {
                    var s__10517__10520 = s__10517;
                    while(true) {
                      if(cljs.core.seq.call(null, s__10517__10520)) {
                        var k__10521 = cljs.core.first.call(null, s__10517__10520);
                        return cljs.core.cons.call(null, cljs.core.PersistentVector.fromArray([keyfn__10508.call(null, k__10521), thisfn.call(null, x[k__10521])], true), iter__10516.call(null, cljs.core.rest.call(null, s__10517__10520)))
                      }else {
                        return null
                      }
                      break
                    }
                  }, null)
                };
                return iter__2557__auto____10522.call(null, cljs.core.js_keys.call(null, x))
              }())
            }else {
              if("\ufdd0'else") {
                return x
              }else {
                return null
              }
            }
          }
        }
      }
    };
    return f__10523.call(null, x)
  };
  var js__GT_clj = function(x, var_args) {
    var options = null;
    if(goog.isDef(var_args)) {
      options = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return js__GT_clj__delegate.call(this, x, options)
  };
  js__GT_clj.cljs$lang$maxFixedArity = 1;
  js__GT_clj.cljs$lang$applyTo = function(arglist__10524) {
    var x = cljs.core.first(arglist__10524);
    var options = cljs.core.rest(arglist__10524);
    return js__GT_clj__delegate(x, options)
  };
  js__GT_clj.cljs$lang$arity$variadic = js__GT_clj__delegate;
  return js__GT_clj
}();
cljs.core.memoize = function memoize(f) {
  var mem__10529 = cljs.core.atom.call(null, cljs.core.ObjMap.EMPTY);
  return function() {
    var G__10533__delegate = function(args) {
      var temp__3971__auto____10530 = cljs.core._lookup.call(null, cljs.core.deref.call(null, mem__10529), args, null);
      if(cljs.core.truth_(temp__3971__auto____10530)) {
        var v__10531 = temp__3971__auto____10530;
        return v__10531
      }else {
        var ret__10532 = cljs.core.apply.call(null, f, args);
        cljs.core.swap_BANG_.call(null, mem__10529, cljs.core.assoc, args, ret__10532);
        return ret__10532
      }
    };
    var G__10533 = function(var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__10533__delegate.call(this, args)
    };
    G__10533.cljs$lang$maxFixedArity = 0;
    G__10533.cljs$lang$applyTo = function(arglist__10534) {
      var args = cljs.core.seq(arglist__10534);
      return G__10533__delegate(args)
    };
    G__10533.cljs$lang$arity$variadic = G__10533__delegate;
    return G__10533
  }()
};
cljs.core.trampoline = function() {
  var trampoline = null;
  var trampoline__1 = function(f) {
    while(true) {
      var ret__10536 = f.call(null);
      if(cljs.core.fn_QMARK_.call(null, ret__10536)) {
        var G__10537 = ret__10536;
        f = G__10537;
        continue
      }else {
        return ret__10536
      }
      break
    }
  };
  var trampoline__2 = function() {
    var G__10538__delegate = function(f, args) {
      return trampoline.call(null, function() {
        return cljs.core.apply.call(null, f, args)
      })
    };
    var G__10538 = function(f, var_args) {
      var args = null;
      if(goog.isDef(var_args)) {
        args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
      }
      return G__10538__delegate.call(this, f, args)
    };
    G__10538.cljs$lang$maxFixedArity = 1;
    G__10538.cljs$lang$applyTo = function(arglist__10539) {
      var f = cljs.core.first(arglist__10539);
      var args = cljs.core.rest(arglist__10539);
      return G__10538__delegate(f, args)
    };
    G__10538.cljs$lang$arity$variadic = G__10538__delegate;
    return G__10538
  }();
  trampoline = function(f, var_args) {
    var args = var_args;
    switch(arguments.length) {
      case 1:
        return trampoline__1.call(this, f);
      default:
        return trampoline__2.cljs$lang$arity$variadic(f, cljs.core.array_seq(arguments, 1))
    }
    throw"Invalid arity: " + arguments.length;
  };
  trampoline.cljs$lang$maxFixedArity = 1;
  trampoline.cljs$lang$applyTo = trampoline__2.cljs$lang$applyTo;
  trampoline.cljs$lang$arity$1 = trampoline__1;
  trampoline.cljs$lang$arity$variadic = trampoline__2.cljs$lang$arity$variadic;
  return trampoline
}();
cljs.core.rand = function() {
  var rand = null;
  var rand__0 = function() {
    return rand.call(null, 1)
  };
  var rand__1 = function(n) {
    return Math.random.call(null) * n
  };
  rand = function(n) {
    switch(arguments.length) {
      case 0:
        return rand__0.call(this);
      case 1:
        return rand__1.call(this, n)
    }
    throw"Invalid arity: " + arguments.length;
  };
  rand.cljs$lang$arity$0 = rand__0;
  rand.cljs$lang$arity$1 = rand__1;
  return rand
}();
cljs.core.rand_int = function rand_int(n) {
  return Math.floor.call(null, Math.random.call(null) * n)
};
cljs.core.rand_nth = function rand_nth(coll) {
  return cljs.core.nth.call(null, coll, cljs.core.rand_int.call(null, cljs.core.count.call(null, coll)))
};
cljs.core.group_by = function group_by(f, coll) {
  return cljs.core.reduce.call(null, function(ret, x) {
    var k__10541 = f.call(null, x);
    return cljs.core.assoc.call(null, ret, k__10541, cljs.core.conj.call(null, cljs.core._lookup.call(null, ret, k__10541, cljs.core.PersistentVector.EMPTY), x))
  }, cljs.core.ObjMap.EMPTY, coll)
};
cljs.core.make_hierarchy = function make_hierarchy() {
  return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'descendants", "\ufdd0'ancestors"], {"\ufdd0'parents":cljs.core.ObjMap.EMPTY, "\ufdd0'descendants":cljs.core.ObjMap.EMPTY, "\ufdd0'ancestors":cljs.core.ObjMap.EMPTY})
};
cljs.core.global_hierarchy = cljs.core.atom.call(null, cljs.core.make_hierarchy.call(null));
cljs.core.isa_QMARK_ = function() {
  var isa_QMARK_ = null;
  var isa_QMARK___2 = function(child, parent) {
    return isa_QMARK_.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), child, parent)
  };
  var isa_QMARK___3 = function(h, child, parent) {
    var or__3824__auto____10550 = cljs.core._EQ_.call(null, child, parent);
    if(or__3824__auto____10550) {
      return or__3824__auto____10550
    }else {
      var or__3824__auto____10551 = cljs.core.contains_QMARK_.call(null, (new cljs.core.Keyword("\ufdd0'ancestors")).call(null, h).call(null, child), parent);
      if(or__3824__auto____10551) {
        return or__3824__auto____10551
      }else {
        var and__3822__auto____10552 = cljs.core.vector_QMARK_.call(null, parent);
        if(and__3822__auto____10552) {
          var and__3822__auto____10553 = cljs.core.vector_QMARK_.call(null, child);
          if(and__3822__auto____10553) {
            var and__3822__auto____10554 = cljs.core.count.call(null, parent) === cljs.core.count.call(null, child);
            if(and__3822__auto____10554) {
              var ret__10555 = true;
              var i__10556 = 0;
              while(true) {
                if(function() {
                  var or__3824__auto____10557 = cljs.core.not.call(null, ret__10555);
                  if(or__3824__auto____10557) {
                    return or__3824__auto____10557
                  }else {
                    return i__10556 === cljs.core.count.call(null, parent)
                  }
                }()) {
                  return ret__10555
                }else {
                  var G__10558 = isa_QMARK_.call(null, h, child.call(null, i__10556), parent.call(null, i__10556));
                  var G__10559 = i__10556 + 1;
                  ret__10555 = G__10558;
                  i__10556 = G__10559;
                  continue
                }
                break
              }
            }else {
              return and__3822__auto____10554
            }
          }else {
            return and__3822__auto____10553
          }
        }else {
          return and__3822__auto____10552
        }
      }
    }
  };
  isa_QMARK_ = function(h, child, parent) {
    switch(arguments.length) {
      case 2:
        return isa_QMARK___2.call(this, h, child);
      case 3:
        return isa_QMARK___3.call(this, h, child, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  isa_QMARK_.cljs$lang$arity$2 = isa_QMARK___2;
  isa_QMARK_.cljs$lang$arity$3 = isa_QMARK___3;
  return isa_QMARK_
}();
cljs.core.parents = function() {
  var parents = null;
  var parents__1 = function(tag) {
    return parents.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var parents__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core._lookup.call(null, (new cljs.core.Keyword("\ufdd0'parents")).call(null, h), tag, null))
  };
  parents = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return parents__1.call(this, h);
      case 2:
        return parents__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  parents.cljs$lang$arity$1 = parents__1;
  parents.cljs$lang$arity$2 = parents__2;
  return parents
}();
cljs.core.ancestors = function() {
  var ancestors = null;
  var ancestors__1 = function(tag) {
    return ancestors.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var ancestors__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core._lookup.call(null, (new cljs.core.Keyword("\ufdd0'ancestors")).call(null, h), tag, null))
  };
  ancestors = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return ancestors__1.call(this, h);
      case 2:
        return ancestors__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  ancestors.cljs$lang$arity$1 = ancestors__1;
  ancestors.cljs$lang$arity$2 = ancestors__2;
  return ancestors
}();
cljs.core.descendants = function() {
  var descendants = null;
  var descendants__1 = function(tag) {
    return descendants.call(null, cljs.core.deref.call(null, cljs.core.global_hierarchy), tag)
  };
  var descendants__2 = function(h, tag) {
    return cljs.core.not_empty.call(null, cljs.core._lookup.call(null, (new cljs.core.Keyword("\ufdd0'descendants")).call(null, h), tag, null))
  };
  descendants = function(h, tag) {
    switch(arguments.length) {
      case 1:
        return descendants__1.call(this, h);
      case 2:
        return descendants__2.call(this, h, tag)
    }
    throw"Invalid arity: " + arguments.length;
  };
  descendants.cljs$lang$arity$1 = descendants__1;
  descendants.cljs$lang$arity$2 = descendants__2;
  return descendants
}();
cljs.core.derive = function() {
  var derive = null;
  var derive__2 = function(tag, parent) {
    if(cljs.core.truth_(cljs.core.namespace.call(null, parent))) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'namespace", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6724))))].join(""));
    }
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, derive, tag, parent);
    return null
  };
  var derive__3 = function(h, tag, parent) {
    if(cljs.core.not_EQ_.call(null, tag, parent)) {
    }else {
      throw new Error([cljs.core.str("Assert failed: "), cljs.core.str(cljs.core.pr_str.call(null, cljs.core.with_meta(cljs.core.list("\ufdd1'not=", "\ufdd1'tag", "\ufdd1'parent"), cljs.core.hash_map("\ufdd0'line", 6728))))].join(""));
    }
    var tp__10568 = (new cljs.core.Keyword("\ufdd0'parents")).call(null, h);
    var td__10569 = (new cljs.core.Keyword("\ufdd0'descendants")).call(null, h);
    var ta__10570 = (new cljs.core.Keyword("\ufdd0'ancestors")).call(null, h);
    var tf__10571 = function(m, source, sources, target, targets) {
      return cljs.core.reduce.call(null, function(ret, k) {
        return cljs.core.assoc.call(null, ret, k, cljs.core.reduce.call(null, cljs.core.conj, cljs.core._lookup.call(null, targets, k, cljs.core.PersistentHashSet.EMPTY), cljs.core.cons.call(null, target, targets.call(null, target))))
      }, m, cljs.core.cons.call(null, source, sources.call(null, source)))
    };
    var or__3824__auto____10572 = cljs.core.contains_QMARK_.call(null, tp__10568.call(null, tag), parent) ? null : function() {
      if(cljs.core.contains_QMARK_.call(null, ta__10570.call(null, tag), parent)) {
        throw new Error([cljs.core.str(tag), cljs.core.str("already has"), cljs.core.str(parent), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      if(cljs.core.contains_QMARK_.call(null, ta__10570.call(null, parent), tag)) {
        throw new Error([cljs.core.str("Cyclic derivation:"), cljs.core.str(parent), cljs.core.str("has"), cljs.core.str(tag), cljs.core.str("as ancestor")].join(""));
      }else {
      }
      return cljs.core.ObjMap.fromObject(["\ufdd0'parents", "\ufdd0'ancestors", "\ufdd0'descendants"], {"\ufdd0'parents":cljs.core.assoc.call(null, (new cljs.core.Keyword("\ufdd0'parents")).call(null, h), tag, cljs.core.conj.call(null, cljs.core._lookup.call(null, tp__10568, tag, cljs.core.PersistentHashSet.EMPTY), parent)), "\ufdd0'ancestors":tf__10571.call(null, (new cljs.core.Keyword("\ufdd0'ancestors")).call(null, h), tag, td__10569, parent, ta__10570), "\ufdd0'descendants":tf__10571.call(null, 
      (new cljs.core.Keyword("\ufdd0'descendants")).call(null, h), parent, ta__10570, tag, td__10569)})
    }();
    if(cljs.core.truth_(or__3824__auto____10572)) {
      return or__3824__auto____10572
    }else {
      return h
    }
  };
  derive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return derive__2.call(this, h, tag);
      case 3:
        return derive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  derive.cljs$lang$arity$2 = derive__2;
  derive.cljs$lang$arity$3 = derive__3;
  return derive
}();
cljs.core.underive = function() {
  var underive = null;
  var underive__2 = function(tag, parent) {
    cljs.core.swap_BANG_.call(null, cljs.core.global_hierarchy, underive, tag, parent);
    return null
  };
  var underive__3 = function(h, tag, parent) {
    var parentMap__10577 = (new cljs.core.Keyword("\ufdd0'parents")).call(null, h);
    var childsParents__10578 = cljs.core.truth_(parentMap__10577.call(null, tag)) ? cljs.core.disj.call(null, parentMap__10577.call(null, tag), parent) : cljs.core.PersistentHashSet.EMPTY;
    var newParents__10579 = cljs.core.truth_(cljs.core.not_empty.call(null, childsParents__10578)) ? cljs.core.assoc.call(null, parentMap__10577, tag, childsParents__10578) : cljs.core.dissoc.call(null, parentMap__10577, tag);
    var deriv_seq__10580 = cljs.core.flatten.call(null, cljs.core.map.call(null, function(p1__10560_SHARP_) {
      return cljs.core.cons.call(null, cljs.core.first.call(null, p1__10560_SHARP_), cljs.core.interpose.call(null, cljs.core.first.call(null, p1__10560_SHARP_), cljs.core.second.call(null, p1__10560_SHARP_)))
    }, cljs.core.seq.call(null, newParents__10579)));
    if(cljs.core.contains_QMARK_.call(null, parentMap__10577.call(null, tag), parent)) {
      return cljs.core.reduce.call(null, function(p1__10561_SHARP_, p2__10562_SHARP_) {
        return cljs.core.apply.call(null, cljs.core.derive, p1__10561_SHARP_, p2__10562_SHARP_)
      }, cljs.core.make_hierarchy.call(null), cljs.core.partition.call(null, 2, deriv_seq__10580))
    }else {
      return h
    }
  };
  underive = function(h, tag, parent) {
    switch(arguments.length) {
      case 2:
        return underive__2.call(this, h, tag);
      case 3:
        return underive__3.call(this, h, tag, parent)
    }
    throw"Invalid arity: " + arguments.length;
  };
  underive.cljs$lang$arity$2 = underive__2;
  underive.cljs$lang$arity$3 = underive__3;
  return underive
}();
cljs.core.reset_cache = function reset_cache(method_cache, method_table, cached_hierarchy, hierarchy) {
  cljs.core.swap_BANG_.call(null, method_cache, function(_) {
    return cljs.core.deref.call(null, method_table)
  });
  return cljs.core.swap_BANG_.call(null, cached_hierarchy, function(_) {
    return cljs.core.deref.call(null, hierarchy)
  })
};
cljs.core.prefers_STAR_ = function prefers_STAR_(x, y, prefer_table) {
  var xprefs__10588 = cljs.core.deref.call(null, prefer_table).call(null, x);
  var or__3824__auto____10590 = cljs.core.truth_(function() {
    var and__3822__auto____10589 = xprefs__10588;
    if(cljs.core.truth_(and__3822__auto____10589)) {
      return xprefs__10588.call(null, y)
    }else {
      return and__3822__auto____10589
    }
  }()) ? true : null;
  if(cljs.core.truth_(or__3824__auto____10590)) {
    return or__3824__auto____10590
  }else {
    var or__3824__auto____10592 = function() {
      var ps__10591 = cljs.core.parents.call(null, y);
      while(true) {
        if(cljs.core.count.call(null, ps__10591) > 0) {
          if(cljs.core.truth_(prefers_STAR_.call(null, x, cljs.core.first.call(null, ps__10591), prefer_table))) {
          }else {
          }
          var G__10595 = cljs.core.rest.call(null, ps__10591);
          ps__10591 = G__10595;
          continue
        }else {
          return null
        }
        break
      }
    }();
    if(cljs.core.truth_(or__3824__auto____10592)) {
      return or__3824__auto____10592
    }else {
      var or__3824__auto____10594 = function() {
        var ps__10593 = cljs.core.parents.call(null, x);
        while(true) {
          if(cljs.core.count.call(null, ps__10593) > 0) {
            if(cljs.core.truth_(prefers_STAR_.call(null, cljs.core.first.call(null, ps__10593), y, prefer_table))) {
            }else {
            }
            var G__10596 = cljs.core.rest.call(null, ps__10593);
            ps__10593 = G__10596;
            continue
          }else {
            return null
          }
          break
        }
      }();
      if(cljs.core.truth_(or__3824__auto____10594)) {
        return or__3824__auto____10594
      }else {
        return false
      }
    }
  }
};
cljs.core.dominates = function dominates(x, y, prefer_table) {
  var or__3824__auto____10598 = cljs.core.prefers_STAR_.call(null, x, y, prefer_table);
  if(cljs.core.truth_(or__3824__auto____10598)) {
    return or__3824__auto____10598
  }else {
    return cljs.core.isa_QMARK_.call(null, x, y)
  }
};
cljs.core.find_and_cache_best_method = function find_and_cache_best_method(name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  var best_entry__10616 = cljs.core.reduce.call(null, function(be, p__10608) {
    var vec__10609__10610 = p__10608;
    var k__10611 = cljs.core.nth.call(null, vec__10609__10610, 0, null);
    var ___10612 = cljs.core.nth.call(null, vec__10609__10610, 1, null);
    var e__10613 = vec__10609__10610;
    if(cljs.core.isa_QMARK_.call(null, dispatch_val, k__10611)) {
      var be2__10615 = cljs.core.truth_(function() {
        var or__3824__auto____10614 = be == null;
        if(or__3824__auto____10614) {
          return or__3824__auto____10614
        }else {
          return cljs.core.dominates.call(null, k__10611, cljs.core.first.call(null, be), prefer_table)
        }
      }()) ? e__10613 : be;
      if(cljs.core.truth_(cljs.core.dominates.call(null, cljs.core.first.call(null, be2__10615), k__10611, prefer_table))) {
      }else {
        throw new Error([cljs.core.str("Multiple methods in multimethod '"), cljs.core.str(name), cljs.core.str("' match dispatch value: "), cljs.core.str(dispatch_val), cljs.core.str(" -> "), cljs.core.str(k__10611), cljs.core.str(" and "), cljs.core.str(cljs.core.first.call(null, be2__10615)), cljs.core.str(", and neither is preferred")].join(""));
      }
      return be2__10615
    }else {
      return be
    }
  }, null, cljs.core.deref.call(null, method_table));
  if(cljs.core.truth_(best_entry__10616)) {
    if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, cached_hierarchy), cljs.core.deref.call(null, hierarchy))) {
      cljs.core.swap_BANG_.call(null, method_cache, cljs.core.assoc, dispatch_val, cljs.core.second.call(null, best_entry__10616));
      return cljs.core.second.call(null, best_entry__10616)
    }else {
      cljs.core.reset_cache.call(null, method_cache, method_table, cached_hierarchy, hierarchy);
      return find_and_cache_best_method.call(null, name, dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy)
    }
  }else {
    return null
  }
};
cljs.core.IMultiFn = {};
cljs.core._reset = function _reset(mf) {
  if(function() {
    var and__3822__auto____10621 = mf;
    if(and__3822__auto____10621) {
      return mf.cljs$core$IMultiFn$_reset$arity$1
    }else {
      return and__3822__auto____10621
    }
  }()) {
    return mf.cljs$core$IMultiFn$_reset$arity$1(mf)
  }else {
    var x__2458__auto____10622 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____10623 = cljs.core._reset[goog.typeOf(x__2458__auto____10622)];
      if(or__3824__auto____10623) {
        return or__3824__auto____10623
      }else {
        var or__3824__auto____10624 = cljs.core._reset["_"];
        if(or__3824__auto____10624) {
          return or__3824__auto____10624
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-reset", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._add_method = function _add_method(mf, dispatch_val, method) {
  if(function() {
    var and__3822__auto____10629 = mf;
    if(and__3822__auto____10629) {
      return mf.cljs$core$IMultiFn$_add_method$arity$3
    }else {
      return and__3822__auto____10629
    }
  }()) {
    return mf.cljs$core$IMultiFn$_add_method$arity$3(mf, dispatch_val, method)
  }else {
    var x__2458__auto____10630 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____10631 = cljs.core._add_method[goog.typeOf(x__2458__auto____10630)];
      if(or__3824__auto____10631) {
        return or__3824__auto____10631
      }else {
        var or__3824__auto____10632 = cljs.core._add_method["_"];
        if(or__3824__auto____10632) {
          return or__3824__auto____10632
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-add-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, method)
  }
};
cljs.core._remove_method = function _remove_method(mf, dispatch_val) {
  if(function() {
    var and__3822__auto____10637 = mf;
    if(and__3822__auto____10637) {
      return mf.cljs$core$IMultiFn$_remove_method$arity$2
    }else {
      return and__3822__auto____10637
    }
  }()) {
    return mf.cljs$core$IMultiFn$_remove_method$arity$2(mf, dispatch_val)
  }else {
    var x__2458__auto____10638 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____10639 = cljs.core._remove_method[goog.typeOf(x__2458__auto____10638)];
      if(or__3824__auto____10639) {
        return or__3824__auto____10639
      }else {
        var or__3824__auto____10640 = cljs.core._remove_method["_"];
        if(or__3824__auto____10640) {
          return or__3824__auto____10640
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-remove-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._prefer_method = function _prefer_method(mf, dispatch_val, dispatch_val_y) {
  if(function() {
    var and__3822__auto____10645 = mf;
    if(and__3822__auto____10645) {
      return mf.cljs$core$IMultiFn$_prefer_method$arity$3
    }else {
      return and__3822__auto____10645
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefer_method$arity$3(mf, dispatch_val, dispatch_val_y)
  }else {
    var x__2458__auto____10646 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____10647 = cljs.core._prefer_method[goog.typeOf(x__2458__auto____10646)];
      if(or__3824__auto____10647) {
        return or__3824__auto____10647
      }else {
        var or__3824__auto____10648 = cljs.core._prefer_method["_"];
        if(or__3824__auto____10648) {
          return or__3824__auto____10648
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefer-method", mf);
        }
      }
    }().call(null, mf, dispatch_val, dispatch_val_y)
  }
};
cljs.core._get_method = function _get_method(mf, dispatch_val) {
  if(function() {
    var and__3822__auto____10653 = mf;
    if(and__3822__auto____10653) {
      return mf.cljs$core$IMultiFn$_get_method$arity$2
    }else {
      return and__3822__auto____10653
    }
  }()) {
    return mf.cljs$core$IMultiFn$_get_method$arity$2(mf, dispatch_val)
  }else {
    var x__2458__auto____10654 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____10655 = cljs.core._get_method[goog.typeOf(x__2458__auto____10654)];
      if(or__3824__auto____10655) {
        return or__3824__auto____10655
      }else {
        var or__3824__auto____10656 = cljs.core._get_method["_"];
        if(or__3824__auto____10656) {
          return or__3824__auto____10656
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-get-method", mf);
        }
      }
    }().call(null, mf, dispatch_val)
  }
};
cljs.core._methods = function _methods(mf) {
  if(function() {
    var and__3822__auto____10661 = mf;
    if(and__3822__auto____10661) {
      return mf.cljs$core$IMultiFn$_methods$arity$1
    }else {
      return and__3822__auto____10661
    }
  }()) {
    return mf.cljs$core$IMultiFn$_methods$arity$1(mf)
  }else {
    var x__2458__auto____10662 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____10663 = cljs.core._methods[goog.typeOf(x__2458__auto____10662)];
      if(or__3824__auto____10663) {
        return or__3824__auto____10663
      }else {
        var or__3824__auto____10664 = cljs.core._methods["_"];
        if(or__3824__auto____10664) {
          return or__3824__auto____10664
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-methods", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._prefers = function _prefers(mf) {
  if(function() {
    var and__3822__auto____10669 = mf;
    if(and__3822__auto____10669) {
      return mf.cljs$core$IMultiFn$_prefers$arity$1
    }else {
      return and__3822__auto____10669
    }
  }()) {
    return mf.cljs$core$IMultiFn$_prefers$arity$1(mf)
  }else {
    var x__2458__auto____10670 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____10671 = cljs.core._prefers[goog.typeOf(x__2458__auto____10670)];
      if(or__3824__auto____10671) {
        return or__3824__auto____10671
      }else {
        var or__3824__auto____10672 = cljs.core._prefers["_"];
        if(or__3824__auto____10672) {
          return or__3824__auto____10672
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-prefers", mf);
        }
      }
    }().call(null, mf)
  }
};
cljs.core._dispatch = function _dispatch(mf, args) {
  if(function() {
    var and__3822__auto____10677 = mf;
    if(and__3822__auto____10677) {
      return mf.cljs$core$IMultiFn$_dispatch$arity$2
    }else {
      return and__3822__auto____10677
    }
  }()) {
    return mf.cljs$core$IMultiFn$_dispatch$arity$2(mf, args)
  }else {
    var x__2458__auto____10678 = mf == null ? null : mf;
    return function() {
      var or__3824__auto____10679 = cljs.core._dispatch[goog.typeOf(x__2458__auto____10678)];
      if(or__3824__auto____10679) {
        return or__3824__auto____10679
      }else {
        var or__3824__auto____10680 = cljs.core._dispatch["_"];
        if(or__3824__auto____10680) {
          return or__3824__auto____10680
        }else {
          throw cljs.core.missing_protocol.call(null, "IMultiFn.-dispatch", mf);
        }
      }
    }().call(null, mf, args)
  }
};
cljs.core.do_dispatch = function do_dispatch(mf, dispatch_fn, args) {
  var dispatch_val__10683 = cljs.core.apply.call(null, dispatch_fn, args);
  var target_fn__10684 = cljs.core._get_method.call(null, mf, dispatch_val__10683);
  if(cljs.core.truth_(target_fn__10684)) {
  }else {
    throw new Error([cljs.core.str("No method in multimethod '"), cljs.core.str(cljs.core.name), cljs.core.str("' for dispatch value: "), cljs.core.str(dispatch_val__10683)].join(""));
  }
  return cljs.core.apply.call(null, target_fn__10684, args)
};
cljs.core.MultiFn = function(name, dispatch_fn, default_dispatch_val, hierarchy, method_table, prefer_table, method_cache, cached_hierarchy) {
  this.name = name;
  this.dispatch_fn = dispatch_fn;
  this.default_dispatch_val = default_dispatch_val;
  this.hierarchy = hierarchy;
  this.method_table = method_table;
  this.prefer_table = prefer_table;
  this.method_cache = method_cache;
  this.cached_hierarchy = cached_hierarchy;
  this.cljs$lang$protocol_mask$partition0$ = 4194304;
  this.cljs$lang$protocol_mask$partition1$ = 64
};
cljs.core.MultiFn.cljs$lang$type = true;
cljs.core.MultiFn.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/MultiFn")
};
cljs.core.MultiFn.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__10685 = this;
  return goog.getUid(this$)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_reset$arity$1 = function(mf) {
  var this__10686 = this;
  cljs.core.swap_BANG_.call(null, this__10686.method_table, function(mf) {
    return cljs.core.ObjMap.EMPTY
  });
  cljs.core.swap_BANG_.call(null, this__10686.method_cache, function(mf) {
    return cljs.core.ObjMap.EMPTY
  });
  cljs.core.swap_BANG_.call(null, this__10686.prefer_table, function(mf) {
    return cljs.core.ObjMap.EMPTY
  });
  cljs.core.swap_BANG_.call(null, this__10686.cached_hierarchy, function(mf) {
    return null
  });
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_add_method$arity$3 = function(mf, dispatch_val, method) {
  var this__10687 = this;
  cljs.core.swap_BANG_.call(null, this__10687.method_table, cljs.core.assoc, dispatch_val, method);
  cljs.core.reset_cache.call(null, this__10687.method_cache, this__10687.method_table, this__10687.cached_hierarchy, this__10687.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_remove_method$arity$2 = function(mf, dispatch_val) {
  var this__10688 = this;
  cljs.core.swap_BANG_.call(null, this__10688.method_table, cljs.core.dissoc, dispatch_val);
  cljs.core.reset_cache.call(null, this__10688.method_cache, this__10688.method_table, this__10688.cached_hierarchy, this__10688.hierarchy);
  return mf
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_get_method$arity$2 = function(mf, dispatch_val) {
  var this__10689 = this;
  if(cljs.core._EQ_.call(null, cljs.core.deref.call(null, this__10689.cached_hierarchy), cljs.core.deref.call(null, this__10689.hierarchy))) {
  }else {
    cljs.core.reset_cache.call(null, this__10689.method_cache, this__10689.method_table, this__10689.cached_hierarchy, this__10689.hierarchy)
  }
  var temp__3971__auto____10690 = cljs.core.deref.call(null, this__10689.method_cache).call(null, dispatch_val);
  if(cljs.core.truth_(temp__3971__auto____10690)) {
    var target_fn__10691 = temp__3971__auto____10690;
    return target_fn__10691
  }else {
    var temp__3971__auto____10692 = cljs.core.find_and_cache_best_method.call(null, this__10689.name, dispatch_val, this__10689.hierarchy, this__10689.method_table, this__10689.prefer_table, this__10689.method_cache, this__10689.cached_hierarchy);
    if(cljs.core.truth_(temp__3971__auto____10692)) {
      var target_fn__10693 = temp__3971__auto____10692;
      return target_fn__10693
    }else {
      return cljs.core.deref.call(null, this__10689.method_table).call(null, this__10689.default_dispatch_val)
    }
  }
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefer_method$arity$3 = function(mf, dispatch_val_x, dispatch_val_y) {
  var this__10694 = this;
  if(cljs.core.truth_(cljs.core.prefers_STAR_.call(null, dispatch_val_x, dispatch_val_y, this__10694.prefer_table))) {
    throw new Error([cljs.core.str("Preference conflict in multimethod '"), cljs.core.str(this__10694.name), cljs.core.str("': "), cljs.core.str(dispatch_val_y), cljs.core.str(" is already preferred to "), cljs.core.str(dispatch_val_x)].join(""));
  }else {
  }
  cljs.core.swap_BANG_.call(null, this__10694.prefer_table, function(old) {
    return cljs.core.assoc.call(null, old, dispatch_val_x, cljs.core.conj.call(null, cljs.core._lookup.call(null, old, dispatch_val_x, cljs.core.PersistentHashSet.EMPTY), dispatch_val_y))
  });
  return cljs.core.reset_cache.call(null, this__10694.method_cache, this__10694.method_table, this__10694.cached_hierarchy, this__10694.hierarchy)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_methods$arity$1 = function(mf) {
  var this__10695 = this;
  return cljs.core.deref.call(null, this__10695.method_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_prefers$arity$1 = function(mf) {
  var this__10696 = this;
  return cljs.core.deref.call(null, this__10696.prefer_table)
};
cljs.core.MultiFn.prototype.cljs$core$IMultiFn$_dispatch$arity$2 = function(mf, args) {
  var this__10697 = this;
  return cljs.core.do_dispatch.call(null, mf, this__10697.dispatch_fn, args)
};
cljs.core.MultiFn;
cljs.core.MultiFn.prototype.call = function() {
  var G__10699__delegate = function(_, args) {
    var self__10698 = this;
    return cljs.core._dispatch.call(null, self__10698, args)
  };
  var G__10699 = function(_, var_args) {
    var args = null;
    if(goog.isDef(var_args)) {
      args = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return G__10699__delegate.call(this, _, args)
  };
  G__10699.cljs$lang$maxFixedArity = 1;
  G__10699.cljs$lang$applyTo = function(arglist__10700) {
    var _ = cljs.core.first(arglist__10700);
    var args = cljs.core.rest(arglist__10700);
    return G__10699__delegate(_, args)
  };
  G__10699.cljs$lang$arity$variadic = G__10699__delegate;
  return G__10699
}();
cljs.core.MultiFn.prototype.apply = function(_, args) {
  var self__10701 = this;
  return cljs.core._dispatch.call(null, self__10701, args)
};
cljs.core.remove_all_methods = function remove_all_methods(multifn) {
  return cljs.core._reset.call(null, multifn)
};
cljs.core.remove_method = function remove_method(multifn, dispatch_val) {
  return cljs.core._remove_method.call(null, multifn, dispatch_val)
};
cljs.core.prefer_method = function prefer_method(multifn, dispatch_val_x, dispatch_val_y) {
  return cljs.core._prefer_method.call(null, multifn, dispatch_val_x, dispatch_val_y)
};
cljs.core.methods$ = function methods$(multifn) {
  return cljs.core._methods.call(null, multifn)
};
cljs.core.get_method = function get_method(multifn, dispatch_val) {
  return cljs.core._get_method.call(null, multifn, dispatch_val)
};
cljs.core.prefers = function prefers(multifn) {
  return cljs.core._prefers.call(null, multifn)
};
cljs.core.UUID = function(uuid) {
  this.uuid = uuid;
  this.cljs$lang$protocol_mask$partition1$ = 0;
  this.cljs$lang$protocol_mask$partition0$ = 543162368
};
cljs.core.UUID.cljs$lang$type = true;
cljs.core.UUID.cljs$lang$ctorPrSeq = function(this__2404__auto__) {
  return cljs.core.list.call(null, "cljs.core/UUID")
};
cljs.core.UUID.prototype.cljs$core$IHash$_hash$arity$1 = function(this$) {
  var this__10702 = this;
  return goog.string.hashCode(cljs.core.pr_str.call(null, this$))
};
cljs.core.UUID.prototype.cljs$core$IPrintable$_pr_seq$arity$2 = function(_10704, _) {
  var this__10703 = this;
  return cljs.core.list.call(null, [cljs.core.str('#uuid "'), cljs.core.str(this__10703.uuid), cljs.core.str('"')].join(""))
};
cljs.core.UUID.prototype.cljs$core$IEquiv$_equiv$arity$2 = function(_, other) {
  var this__10705 = this;
  var and__3822__auto____10706 = cljs.core.instance_QMARK_.call(null, cljs.core.UUID, other);
  if(and__3822__auto____10706) {
    return this__10705.uuid === other.uuid
  }else {
    return and__3822__auto____10706
  }
};
cljs.core.UUID.prototype.toString = function() {
  var this__10707 = this;
  var this__10708 = this;
  return cljs.core.pr_str.call(null, this__10708)
};
cljs.core.UUID;
goog.provide("goog.userAgent");
goog.require("goog.string");
goog.userAgent.ASSUME_IE = false;
goog.userAgent.ASSUME_GECKO = false;
goog.userAgent.ASSUME_WEBKIT = false;
goog.userAgent.ASSUME_MOBILE_WEBKIT = false;
goog.userAgent.ASSUME_OPERA = false;
goog.userAgent.BROWSER_KNOWN_ = goog.userAgent.ASSUME_IE || goog.userAgent.ASSUME_GECKO || goog.userAgent.ASSUME_MOBILE_WEBKIT || goog.userAgent.ASSUME_WEBKIT || goog.userAgent.ASSUME_OPERA;
goog.userAgent.getUserAgentString = function() {
  return goog.global["navigator"] ? goog.global["navigator"].userAgent : null
};
goog.userAgent.getNavigator = function() {
  return goog.global["navigator"]
};
goog.userAgent.init_ = function() {
  goog.userAgent.detectedOpera_ = false;
  goog.userAgent.detectedIe_ = false;
  goog.userAgent.detectedWebkit_ = false;
  goog.userAgent.detectedMobile_ = false;
  goog.userAgent.detectedGecko_ = false;
  var ua;
  if(!goog.userAgent.BROWSER_KNOWN_ && (ua = goog.userAgent.getUserAgentString())) {
    var navigator = goog.userAgent.getNavigator();
    goog.userAgent.detectedOpera_ = ua.indexOf("Opera") == 0;
    goog.userAgent.detectedIe_ = !goog.userAgent.detectedOpera_ && ua.indexOf("MSIE") != -1;
    goog.userAgent.detectedWebkit_ = !goog.userAgent.detectedOpera_ && ua.indexOf("WebKit") != -1;
    goog.userAgent.detectedMobile_ = goog.userAgent.detectedWebkit_ && ua.indexOf("Mobile") != -1;
    goog.userAgent.detectedGecko_ = !goog.userAgent.detectedOpera_ && !goog.userAgent.detectedWebkit_ && navigator.product == "Gecko"
  }
};
if(!goog.userAgent.BROWSER_KNOWN_) {
  goog.userAgent.init_()
}
goog.userAgent.OPERA = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_OPERA : goog.userAgent.detectedOpera_;
goog.userAgent.IE = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_IE : goog.userAgent.detectedIe_;
goog.userAgent.GECKO = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_GECKO : goog.userAgent.detectedGecko_;
goog.userAgent.WEBKIT = goog.userAgent.BROWSER_KNOWN_ ? goog.userAgent.ASSUME_WEBKIT || goog.userAgent.ASSUME_MOBILE_WEBKIT : goog.userAgent.detectedWebkit_;
goog.userAgent.MOBILE = goog.userAgent.ASSUME_MOBILE_WEBKIT || goog.userAgent.detectedMobile_;
goog.userAgent.SAFARI = goog.userAgent.WEBKIT;
goog.userAgent.determinePlatform_ = function() {
  var navigator = goog.userAgent.getNavigator();
  return navigator && navigator.platform || ""
};
goog.userAgent.PLATFORM = goog.userAgent.determinePlatform_();
goog.userAgent.ASSUME_MAC = false;
goog.userAgent.ASSUME_WINDOWS = false;
goog.userAgent.ASSUME_LINUX = false;
goog.userAgent.ASSUME_X11 = false;
goog.userAgent.PLATFORM_KNOWN_ = goog.userAgent.ASSUME_MAC || goog.userAgent.ASSUME_WINDOWS || goog.userAgent.ASSUME_LINUX || goog.userAgent.ASSUME_X11;
goog.userAgent.initPlatform_ = function() {
  goog.userAgent.detectedMac_ = goog.string.contains(goog.userAgent.PLATFORM, "Mac");
  goog.userAgent.detectedWindows_ = goog.string.contains(goog.userAgent.PLATFORM, "Win");
  goog.userAgent.detectedLinux_ = goog.string.contains(goog.userAgent.PLATFORM, "Linux");
  goog.userAgent.detectedX11_ = !!goog.userAgent.getNavigator() && goog.string.contains(goog.userAgent.getNavigator()["appVersion"] || "", "X11")
};
if(!goog.userAgent.PLATFORM_KNOWN_) {
  goog.userAgent.initPlatform_()
}
goog.userAgent.MAC = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_MAC : goog.userAgent.detectedMac_;
goog.userAgent.WINDOWS = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_WINDOWS : goog.userAgent.detectedWindows_;
goog.userAgent.LINUX = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_LINUX : goog.userAgent.detectedLinux_;
goog.userAgent.X11 = goog.userAgent.PLATFORM_KNOWN_ ? goog.userAgent.ASSUME_X11 : goog.userAgent.detectedX11_;
goog.userAgent.determineVersion_ = function() {
  var version = "", re;
  if(goog.userAgent.OPERA && goog.global["opera"]) {
    var operaVersion = goog.global["opera"].version;
    version = typeof operaVersion == "function" ? operaVersion() : operaVersion
  }else {
    if(goog.userAgent.GECKO) {
      re = /rv\:([^\);]+)(\)|;)/
    }else {
      if(goog.userAgent.IE) {
        re = /MSIE\s+([^\);]+)(\)|;)/
      }else {
        if(goog.userAgent.WEBKIT) {
          re = /WebKit\/(\S+)/
        }
      }
    }
    if(re) {
      var arr = re.exec(goog.userAgent.getUserAgentString());
      version = arr ? arr[1] : ""
    }
  }
  if(goog.userAgent.IE) {
    var docMode = goog.userAgent.getDocumentMode_();
    if(docMode > parseFloat(version)) {
      return String(docMode)
    }
  }
  return version
};
goog.userAgent.getDocumentMode_ = function() {
  var doc = goog.global["document"];
  return doc ? doc["documentMode"] : undefined
};
goog.userAgent.VERSION = goog.userAgent.determineVersion_();
goog.userAgent.compare = function(v1, v2) {
  return goog.string.compareVersions(v1, v2)
};
goog.userAgent.isVersionCache_ = {};
goog.userAgent.isVersion = function(version) {
  return goog.userAgent.isVersionCache_[version] || (goog.userAgent.isVersionCache_[version] = goog.string.compareVersions(goog.userAgent.VERSION, version) >= 0)
};
goog.userAgent.isDocumentModeCache_ = {};
goog.userAgent.isDocumentMode = function(documentMode) {
  return goog.userAgent.isDocumentModeCache_[documentMode] || (goog.userAgent.isDocumentModeCache_[documentMode] = goog.userAgent.IE && document.documentMode && document.documentMode >= documentMode)
};
goog.provide("goog.dom.BrowserFeature");
goog.require("goog.userAgent");
goog.dom.BrowserFeature = {CAN_ADD_NAME_OR_TYPE_ATTRIBUTES:!goog.userAgent.IE || goog.userAgent.isDocumentMode(9), CAN_USE_CHILDREN_ATTRIBUTE:!goog.userAgent.GECKO && !goog.userAgent.IE || goog.userAgent.IE && goog.userAgent.isDocumentMode(9) || goog.userAgent.GECKO && goog.userAgent.isVersion("1.9.1"), CAN_USE_INNER_TEXT:goog.userAgent.IE && !goog.userAgent.isVersion("9"), INNER_HTML_NEEDS_SCOPED_ELEMENT:goog.userAgent.IE};
goog.provide("goog.dom.TagName");
goog.dom.TagName = {A:"A", ABBR:"ABBR", ACRONYM:"ACRONYM", ADDRESS:"ADDRESS", APPLET:"APPLET", AREA:"AREA", B:"B", BASE:"BASE", BASEFONT:"BASEFONT", BDO:"BDO", BIG:"BIG", BLOCKQUOTE:"BLOCKQUOTE", BODY:"BODY", BR:"BR", BUTTON:"BUTTON", CANVAS:"CANVAS", CAPTION:"CAPTION", CENTER:"CENTER", CITE:"CITE", CODE:"CODE", COL:"COL", COLGROUP:"COLGROUP", DD:"DD", DEL:"DEL", DFN:"DFN", DIR:"DIR", DIV:"DIV", DL:"DL", DT:"DT", EM:"EM", FIELDSET:"FIELDSET", FONT:"FONT", FORM:"FORM", FRAME:"FRAME", FRAMESET:"FRAMESET", 
H1:"H1", H2:"H2", H3:"H3", H4:"H4", H5:"H5", H6:"H6", HEAD:"HEAD", HR:"HR", HTML:"HTML", I:"I", IFRAME:"IFRAME", IMG:"IMG", INPUT:"INPUT", INS:"INS", ISINDEX:"ISINDEX", KBD:"KBD", LABEL:"LABEL", LEGEND:"LEGEND", LI:"LI", LINK:"LINK", MAP:"MAP", MENU:"MENU", META:"META", NOFRAMES:"NOFRAMES", NOSCRIPT:"NOSCRIPT", OBJECT:"OBJECT", OL:"OL", OPTGROUP:"OPTGROUP", OPTION:"OPTION", P:"P", PARAM:"PARAM", PRE:"PRE", Q:"Q", S:"S", SAMP:"SAMP", SCRIPT:"SCRIPT", SELECT:"SELECT", SMALL:"SMALL", SPAN:"SPAN", STRIKE:"STRIKE", 
STRONG:"STRONG", STYLE:"STYLE", SUB:"SUB", SUP:"SUP", TABLE:"TABLE", TBODY:"TBODY", TD:"TD", TEXTAREA:"TEXTAREA", TFOOT:"TFOOT", TH:"TH", THEAD:"THEAD", TITLE:"TITLE", TR:"TR", TT:"TT", U:"U", UL:"UL", VAR:"VAR"};
goog.provide("goog.dom.classes");
goog.require("goog.array");
goog.dom.classes.set = function(element, className) {
  element.className = className
};
goog.dom.classes.get = function(element) {
  var className = element.className;
  return className && typeof className.split == "function" ? className.split(/\s+/) : []
};
goog.dom.classes.add = function(element, var_args) {
  var classes = goog.dom.classes.get(element);
  var args = goog.array.slice(arguments, 1);
  var b = goog.dom.classes.add_(classes, args);
  element.className = classes.join(" ");
  return b
};
goog.dom.classes.remove = function(element, var_args) {
  var classes = goog.dom.classes.get(element);
  var args = goog.array.slice(arguments, 1);
  var b = goog.dom.classes.remove_(classes, args);
  element.className = classes.join(" ");
  return b
};
goog.dom.classes.add_ = function(classes, args) {
  var rv = 0;
  for(var i = 0;i < args.length;i++) {
    if(!goog.array.contains(classes, args[i])) {
      classes.push(args[i]);
      rv++
    }
  }
  return rv == args.length
};
goog.dom.classes.remove_ = function(classes, args) {
  var rv = 0;
  for(var i = 0;i < classes.length;i++) {
    if(goog.array.contains(args, classes[i])) {
      goog.array.splice(classes, i--, 1);
      rv++
    }
  }
  return rv == args.length
};
goog.dom.classes.swap = function(element, fromClass, toClass) {
  var classes = goog.dom.classes.get(element);
  var removed = false;
  for(var i = 0;i < classes.length;i++) {
    if(classes[i] == fromClass) {
      goog.array.splice(classes, i--, 1);
      removed = true
    }
  }
  if(removed) {
    classes.push(toClass);
    element.className = classes.join(" ")
  }
  return removed
};
goog.dom.classes.addRemove = function(element, classesToRemove, classesToAdd) {
  var classes = goog.dom.classes.get(element);
  if(goog.isString(classesToRemove)) {
    goog.array.remove(classes, classesToRemove)
  }else {
    if(goog.isArray(classesToRemove)) {
      goog.dom.classes.remove_(classes, classesToRemove)
    }
  }
  if(goog.isString(classesToAdd) && !goog.array.contains(classes, classesToAdd)) {
    classes.push(classesToAdd)
  }else {
    if(goog.isArray(classesToAdd)) {
      goog.dom.classes.add_(classes, classesToAdd)
    }
  }
  element.className = classes.join(" ")
};
goog.dom.classes.has = function(element, className) {
  return goog.array.contains(goog.dom.classes.get(element), className)
};
goog.dom.classes.enable = function(element, className, enabled) {
  if(enabled) {
    goog.dom.classes.add(element, className)
  }else {
    goog.dom.classes.remove(element, className)
  }
};
goog.dom.classes.toggle = function(element, className) {
  var add = !goog.dom.classes.has(element, className);
  goog.dom.classes.enable(element, className, add);
  return add
};
goog.provide("goog.math.Coordinate");
goog.math.Coordinate = function(opt_x, opt_y) {
  this.x = goog.isDef(opt_x) ? opt_x : 0;
  this.y = goog.isDef(opt_y) ? opt_y : 0
};
goog.math.Coordinate.prototype.clone = function() {
  return new goog.math.Coordinate(this.x, this.y)
};
if(goog.DEBUG) {
  goog.math.Coordinate.prototype.toString = function() {
    return"(" + this.x + ", " + this.y + ")"
  }
}
goog.math.Coordinate.equals = function(a, b) {
  if(a == b) {
    return true
  }
  if(!a || !b) {
    return false
  }
  return a.x == b.x && a.y == b.y
};
goog.math.Coordinate.distance = function(a, b) {
  var dx = a.x - b.x;
  var dy = a.y - b.y;
  return Math.sqrt(dx * dx + dy * dy)
};
goog.math.Coordinate.squaredDistance = function(a, b) {
  var dx = a.x - b.x;
  var dy = a.y - b.y;
  return dx * dx + dy * dy
};
goog.math.Coordinate.difference = function(a, b) {
  return new goog.math.Coordinate(a.x - b.x, a.y - b.y)
};
goog.math.Coordinate.sum = function(a, b) {
  return new goog.math.Coordinate(a.x + b.x, a.y + b.y)
};
goog.provide("goog.math.Size");
goog.math.Size = function(width, height) {
  this.width = width;
  this.height = height
};
goog.math.Size.equals = function(a, b) {
  if(a == b) {
    return true
  }
  if(!a || !b) {
    return false
  }
  return a.width == b.width && a.height == b.height
};
goog.math.Size.prototype.clone = function() {
  return new goog.math.Size(this.width, this.height)
};
if(goog.DEBUG) {
  goog.math.Size.prototype.toString = function() {
    return"(" + this.width + " x " + this.height + ")"
  }
}
goog.math.Size.prototype.getLongest = function() {
  return Math.max(this.width, this.height)
};
goog.math.Size.prototype.getShortest = function() {
  return Math.min(this.width, this.height)
};
goog.math.Size.prototype.area = function() {
  return this.width * this.height
};
goog.math.Size.prototype.perimeter = function() {
  return(this.width + this.height) * 2
};
goog.math.Size.prototype.aspectRatio = function() {
  return this.width / this.height
};
goog.math.Size.prototype.isEmpty = function() {
  return!this.area()
};
goog.math.Size.prototype.ceil = function() {
  this.width = Math.ceil(this.width);
  this.height = Math.ceil(this.height);
  return this
};
goog.math.Size.prototype.fitsInside = function(target) {
  return this.width <= target.width && this.height <= target.height
};
goog.math.Size.prototype.floor = function() {
  this.width = Math.floor(this.width);
  this.height = Math.floor(this.height);
  return this
};
goog.math.Size.prototype.round = function() {
  this.width = Math.round(this.width);
  this.height = Math.round(this.height);
  return this
};
goog.math.Size.prototype.scale = function(s) {
  this.width *= s;
  this.height *= s;
  return this
};
goog.math.Size.prototype.scaleToFit = function(target) {
  var s = this.aspectRatio() > target.aspectRatio() ? target.width / this.width : target.height / this.height;
  return this.scale(s)
};
goog.provide("goog.dom");
goog.provide("goog.dom.DomHelper");
goog.provide("goog.dom.NodeType");
goog.require("goog.array");
goog.require("goog.dom.BrowserFeature");
goog.require("goog.dom.TagName");
goog.require("goog.dom.classes");
goog.require("goog.math.Coordinate");
goog.require("goog.math.Size");
goog.require("goog.object");
goog.require("goog.string");
goog.require("goog.userAgent");
goog.dom.ASSUME_QUIRKS_MODE = false;
goog.dom.ASSUME_STANDARDS_MODE = false;
goog.dom.COMPAT_MODE_KNOWN_ = goog.dom.ASSUME_QUIRKS_MODE || goog.dom.ASSUME_STANDARDS_MODE;
goog.dom.NodeType = {ELEMENT:1, ATTRIBUTE:2, TEXT:3, CDATA_SECTION:4, ENTITY_REFERENCE:5, ENTITY:6, PROCESSING_INSTRUCTION:7, COMMENT:8, DOCUMENT:9, DOCUMENT_TYPE:10, DOCUMENT_FRAGMENT:11, NOTATION:12};
goog.dom.getDomHelper = function(opt_element) {
  return opt_element ? new goog.dom.DomHelper(goog.dom.getOwnerDocument(opt_element)) : goog.dom.defaultDomHelper_ || (goog.dom.defaultDomHelper_ = new goog.dom.DomHelper)
};
goog.dom.defaultDomHelper_;
goog.dom.getDocument = function() {
  return document
};
goog.dom.getElement = function(element) {
  return goog.isString(element) ? document.getElementById(element) : element
};
goog.dom.$ = goog.dom.getElement;
goog.dom.getElementsByTagNameAndClass = function(opt_tag, opt_class, opt_el) {
  return goog.dom.getElementsByTagNameAndClass_(document, opt_tag, opt_class, opt_el)
};
goog.dom.getElementsByClass = function(className, opt_el) {
  var parent = opt_el || document;
  if(goog.dom.canUseQuerySelector_(parent)) {
    return parent.querySelectorAll("." + className)
  }else {
    if(parent.getElementsByClassName) {
      return parent.getElementsByClassName(className)
    }
  }
  return goog.dom.getElementsByTagNameAndClass_(document, "*", className, opt_el)
};
goog.dom.getElementByClass = function(className, opt_el) {
  var parent = opt_el || document;
  var retVal = null;
  if(goog.dom.canUseQuerySelector_(parent)) {
    retVal = parent.querySelector("." + className)
  }else {
    retVal = goog.dom.getElementsByClass(className, opt_el)[0]
  }
  return retVal || null
};
goog.dom.canUseQuerySelector_ = function(parent) {
  return parent.querySelectorAll && parent.querySelector && (!goog.userAgent.WEBKIT || goog.dom.isCss1CompatMode_(document) || goog.userAgent.isVersion("528"))
};
goog.dom.getElementsByTagNameAndClass_ = function(doc, opt_tag, opt_class, opt_el) {
  var parent = opt_el || doc;
  var tagName = opt_tag && opt_tag != "*" ? opt_tag.toUpperCase() : "";
  if(goog.dom.canUseQuerySelector_(parent) && (tagName || opt_class)) {
    var query = tagName + (opt_class ? "." + opt_class : "");
    return parent.querySelectorAll(query)
  }
  if(opt_class && parent.getElementsByClassName) {
    var els = parent.getElementsByClassName(opt_class);
    if(tagName) {
      var arrayLike = {};
      var len = 0;
      for(var i = 0, el;el = els[i];i++) {
        if(tagName == el.nodeName) {
          arrayLike[len++] = el
        }
      }
      arrayLike.length = len;
      return arrayLike
    }else {
      return els
    }
  }
  var els = parent.getElementsByTagName(tagName || "*");
  if(opt_class) {
    var arrayLike = {};
    var len = 0;
    for(var i = 0, el;el = els[i];i++) {
      var className = el.className;
      if(typeof className.split == "function" && goog.array.contains(className.split(/\s+/), opt_class)) {
        arrayLike[len++] = el
      }
    }
    arrayLike.length = len;
    return arrayLike
  }else {
    return els
  }
};
goog.dom.$$ = goog.dom.getElementsByTagNameAndClass;
goog.dom.setProperties = function(element, properties) {
  goog.object.forEach(properties, function(val, key) {
    if(key == "style") {
      element.style.cssText = val
    }else {
      if(key == "class") {
        element.className = val
      }else {
        if(key == "for") {
          element.htmlFor = val
        }else {
          if(key in goog.dom.DIRECT_ATTRIBUTE_MAP_) {
            element.setAttribute(goog.dom.DIRECT_ATTRIBUTE_MAP_[key], val)
          }else {
            if(goog.string.startsWith(key, "aria-")) {
              element.setAttribute(key, val)
            }else {
              element[key] = val
            }
          }
        }
      }
    }
  })
};
goog.dom.DIRECT_ATTRIBUTE_MAP_ = {"cellpadding":"cellPadding", "cellspacing":"cellSpacing", "colspan":"colSpan", "rowspan":"rowSpan", "valign":"vAlign", "height":"height", "width":"width", "usemap":"useMap", "frameborder":"frameBorder", "maxlength":"maxLength", "type":"type"};
goog.dom.getViewportSize = function(opt_window) {
  return goog.dom.getViewportSize_(opt_window || window)
};
goog.dom.getViewportSize_ = function(win) {
  var doc = win.document;
  if(goog.userAgent.WEBKIT && !goog.userAgent.isVersion("500") && !goog.userAgent.MOBILE) {
    if(typeof win.innerHeight == "undefined") {
      win = window
    }
    var innerHeight = win.innerHeight;
    var scrollHeight = win.document.documentElement.scrollHeight;
    if(win == win.top) {
      if(scrollHeight < innerHeight) {
        innerHeight -= 15
      }
    }
    return new goog.math.Size(win.innerWidth, innerHeight)
  }
  var el = goog.dom.isCss1CompatMode_(doc) ? doc.documentElement : doc.body;
  return new goog.math.Size(el.clientWidth, el.clientHeight)
};
goog.dom.getDocumentHeight = function() {
  return goog.dom.getDocumentHeight_(window)
};
goog.dom.getDocumentHeight_ = function(win) {
  var doc = win.document;
  var height = 0;
  if(doc) {
    var vh = goog.dom.getViewportSize_(win).height;
    var body = doc.body;
    var docEl = doc.documentElement;
    if(goog.dom.isCss1CompatMode_(doc) && docEl.scrollHeight) {
      height = docEl.scrollHeight != vh ? docEl.scrollHeight : docEl.offsetHeight
    }else {
      var sh = docEl.scrollHeight;
      var oh = docEl.offsetHeight;
      if(docEl.clientHeight != oh) {
        sh = body.scrollHeight;
        oh = body.offsetHeight
      }
      if(sh > vh) {
        height = sh > oh ? sh : oh
      }else {
        height = sh < oh ? sh : oh
      }
    }
  }
  return height
};
goog.dom.getPageScroll = function(opt_window) {
  var win = opt_window || goog.global || window;
  return goog.dom.getDomHelper(win.document).getDocumentScroll()
};
goog.dom.getDocumentScroll = function() {
  return goog.dom.getDocumentScroll_(document)
};
goog.dom.getDocumentScroll_ = function(doc) {
  var el = goog.dom.getDocumentScrollElement_(doc);
  var win = goog.dom.getWindow_(doc);
  return new goog.math.Coordinate(win.pageXOffset || el.scrollLeft, win.pageYOffset || el.scrollTop)
};
goog.dom.getDocumentScrollElement = function() {
  return goog.dom.getDocumentScrollElement_(document)
};
goog.dom.getDocumentScrollElement_ = function(doc) {
  return!goog.userAgent.WEBKIT && goog.dom.isCss1CompatMode_(doc) ? doc.documentElement : doc.body
};
goog.dom.getWindow = function(opt_doc) {
  return opt_doc ? goog.dom.getWindow_(opt_doc) : window
};
goog.dom.getWindow_ = function(doc) {
  return doc.parentWindow || doc.defaultView
};
goog.dom.createDom = function(tagName, opt_attributes, var_args) {
  return goog.dom.createDom_(document, arguments)
};
goog.dom.createDom_ = function(doc, args) {
  var tagName = args[0];
  var attributes = args[1];
  if(!goog.dom.BrowserFeature.CAN_ADD_NAME_OR_TYPE_ATTRIBUTES && attributes && (attributes.name || attributes.type)) {
    var tagNameArr = ["<", tagName];
    if(attributes.name) {
      tagNameArr.push(' name="', goog.string.htmlEscape(attributes.name), '"')
    }
    if(attributes.type) {
      tagNameArr.push(' type="', goog.string.htmlEscape(attributes.type), '"');
      var clone = {};
      goog.object.extend(clone, attributes);
      attributes = clone;
      delete attributes.type
    }
    tagNameArr.push(">");
    tagName = tagNameArr.join("")
  }
  var element = doc.createElement(tagName);
  if(attributes) {
    if(goog.isString(attributes)) {
      element.className = attributes
    }else {
      if(goog.isArray(attributes)) {
        goog.dom.classes.add.apply(null, [element].concat(attributes))
      }else {
        goog.dom.setProperties(element, attributes)
      }
    }
  }
  if(args.length > 2) {
    goog.dom.append_(doc, element, args, 2)
  }
  return element
};
goog.dom.append_ = function(doc, parent, args, startIndex) {
  function childHandler(child) {
    if(child) {
      parent.appendChild(goog.isString(child) ? doc.createTextNode(child) : child)
    }
  }
  for(var i = startIndex;i < args.length;i++) {
    var arg = args[i];
    if(goog.isArrayLike(arg) && !goog.dom.isNodeLike(arg)) {
      goog.array.forEach(goog.dom.isNodeList(arg) ? goog.array.clone(arg) : arg, childHandler)
    }else {
      childHandler(arg)
    }
  }
};
goog.dom.$dom = goog.dom.createDom;
goog.dom.createElement = function(name) {
  return document.createElement(name)
};
goog.dom.createTextNode = function(content) {
  return document.createTextNode(content)
};
goog.dom.createTable = function(rows, columns, opt_fillWithNbsp) {
  return goog.dom.createTable_(document, rows, columns, !!opt_fillWithNbsp)
};
goog.dom.createTable_ = function(doc, rows, columns, fillWithNbsp) {
  var rowHtml = ["<tr>"];
  for(var i = 0;i < columns;i++) {
    rowHtml.push(fillWithNbsp ? "<td>&nbsp;</td>" : "<td></td>")
  }
  rowHtml.push("</tr>");
  rowHtml = rowHtml.join("");
  var totalHtml = ["<table>"];
  for(i = 0;i < rows;i++) {
    totalHtml.push(rowHtml)
  }
  totalHtml.push("</table>");
  var elem = doc.createElement(goog.dom.TagName.DIV);
  elem.innerHTML = totalHtml.join("");
  return elem.removeChild(elem.firstChild)
};
goog.dom.htmlToDocumentFragment = function(htmlString) {
  return goog.dom.htmlToDocumentFragment_(document, htmlString)
};
goog.dom.htmlToDocumentFragment_ = function(doc, htmlString) {
  var tempDiv = doc.createElement("div");
  if(goog.dom.BrowserFeature.INNER_HTML_NEEDS_SCOPED_ELEMENT) {
    tempDiv.innerHTML = "<br>" + htmlString;
    tempDiv.removeChild(tempDiv.firstChild)
  }else {
    tempDiv.innerHTML = htmlString
  }
  if(tempDiv.childNodes.length == 1) {
    return tempDiv.removeChild(tempDiv.firstChild)
  }else {
    var fragment = doc.createDocumentFragment();
    while(tempDiv.firstChild) {
      fragment.appendChild(tempDiv.firstChild)
    }
    return fragment
  }
};
goog.dom.getCompatMode = function() {
  return goog.dom.isCss1CompatMode() ? "CSS1Compat" : "BackCompat"
};
goog.dom.isCss1CompatMode = function() {
  return goog.dom.isCss1CompatMode_(document)
};
goog.dom.isCss1CompatMode_ = function(doc) {
  if(goog.dom.COMPAT_MODE_KNOWN_) {
    return goog.dom.ASSUME_STANDARDS_MODE
  }
  return doc.compatMode == "CSS1Compat"
};
goog.dom.canHaveChildren = function(node) {
  if(node.nodeType != goog.dom.NodeType.ELEMENT) {
    return false
  }
  switch(node.tagName) {
    case goog.dom.TagName.APPLET:
    ;
    case goog.dom.TagName.AREA:
    ;
    case goog.dom.TagName.BASE:
    ;
    case goog.dom.TagName.BR:
    ;
    case goog.dom.TagName.COL:
    ;
    case goog.dom.TagName.FRAME:
    ;
    case goog.dom.TagName.HR:
    ;
    case goog.dom.TagName.IMG:
    ;
    case goog.dom.TagName.INPUT:
    ;
    case goog.dom.TagName.IFRAME:
    ;
    case goog.dom.TagName.ISINDEX:
    ;
    case goog.dom.TagName.LINK:
    ;
    case goog.dom.TagName.NOFRAMES:
    ;
    case goog.dom.TagName.NOSCRIPT:
    ;
    case goog.dom.TagName.META:
    ;
    case goog.dom.TagName.OBJECT:
    ;
    case goog.dom.TagName.PARAM:
    ;
    case goog.dom.TagName.SCRIPT:
    ;
    case goog.dom.TagName.STYLE:
      return false
  }
  return true
};
goog.dom.appendChild = function(parent, child) {
  parent.appendChild(child)
};
goog.dom.append = function(parent, var_args) {
  goog.dom.append_(goog.dom.getOwnerDocument(parent), parent, arguments, 1)
};
goog.dom.removeChildren = function(node) {
  var child;
  while(child = node.firstChild) {
    node.removeChild(child)
  }
};
goog.dom.insertSiblingBefore = function(newNode, refNode) {
  if(refNode.parentNode) {
    refNode.parentNode.insertBefore(newNode, refNode)
  }
};
goog.dom.insertSiblingAfter = function(newNode, refNode) {
  if(refNode.parentNode) {
    refNode.parentNode.insertBefore(newNode, refNode.nextSibling)
  }
};
goog.dom.insertChildAt = function(parent, child, index) {
  parent.insertBefore(child, parent.childNodes[index] || null)
};
goog.dom.removeNode = function(node) {
  return node && node.parentNode ? node.parentNode.removeChild(node) : null
};
goog.dom.replaceNode = function(newNode, oldNode) {
  var parent = oldNode.parentNode;
  if(parent) {
    parent.replaceChild(newNode, oldNode)
  }
};
goog.dom.flattenElement = function(element) {
  var child, parent = element.parentNode;
  if(parent && parent.nodeType != goog.dom.NodeType.DOCUMENT_FRAGMENT) {
    if(element.removeNode) {
      return element.removeNode(false)
    }else {
      while(child = element.firstChild) {
        parent.insertBefore(child, element)
      }
      return goog.dom.removeNode(element)
    }
  }
};
goog.dom.getChildren = function(element) {
  if(goog.dom.BrowserFeature.CAN_USE_CHILDREN_ATTRIBUTE && element.children != undefined) {
    return element.children
  }
  return goog.array.filter(element.childNodes, function(node) {
    return node.nodeType == goog.dom.NodeType.ELEMENT
  })
};
goog.dom.getFirstElementChild = function(node) {
  if(node.firstElementChild != undefined) {
    return node.firstElementChild
  }
  return goog.dom.getNextElementNode_(node.firstChild, true)
};
goog.dom.getLastElementChild = function(node) {
  if(node.lastElementChild != undefined) {
    return node.lastElementChild
  }
  return goog.dom.getNextElementNode_(node.lastChild, false)
};
goog.dom.getNextElementSibling = function(node) {
  if(node.nextElementSibling != undefined) {
    return node.nextElementSibling
  }
  return goog.dom.getNextElementNode_(node.nextSibling, true)
};
goog.dom.getPreviousElementSibling = function(node) {
  if(node.previousElementSibling != undefined) {
    return node.previousElementSibling
  }
  return goog.dom.getNextElementNode_(node.previousSibling, false)
};
goog.dom.getNextElementNode_ = function(node, forward) {
  while(node && node.nodeType != goog.dom.NodeType.ELEMENT) {
    node = forward ? node.nextSibling : node.previousSibling
  }
  return node
};
goog.dom.getNextNode = function(node) {
  if(!node) {
    return null
  }
  if(node.firstChild) {
    return node.firstChild
  }
  while(node && !node.nextSibling) {
    node = node.parentNode
  }
  return node ? node.nextSibling : null
};
goog.dom.getPreviousNode = function(node) {
  if(!node) {
    return null
  }
  if(!node.previousSibling) {
    return node.parentNode
  }
  node = node.previousSibling;
  while(node && node.lastChild) {
    node = node.lastChild
  }
  return node
};
goog.dom.isNodeLike = function(obj) {
  return goog.isObject(obj) && obj.nodeType > 0
};
goog.dom.isElement = function(obj) {
  return goog.isObject(obj) && obj.nodeType == goog.dom.NodeType.ELEMENT
};
goog.dom.isWindow = function(obj) {
  return goog.isObject(obj) && obj["window"] == obj
};
goog.dom.contains = function(parent, descendant) {
  if(parent.contains && descendant.nodeType == goog.dom.NodeType.ELEMENT) {
    return parent == descendant || parent.contains(descendant)
  }
  if(typeof parent.compareDocumentPosition != "undefined") {
    return parent == descendant || Boolean(parent.compareDocumentPosition(descendant) & 16)
  }
  while(descendant && parent != descendant) {
    descendant = descendant.parentNode
  }
  return descendant == parent
};
goog.dom.compareNodeOrder = function(node1, node2) {
  if(node1 == node2) {
    return 0
  }
  if(node1.compareDocumentPosition) {
    return node1.compareDocumentPosition(node2) & 2 ? 1 : -1
  }
  if("sourceIndex" in node1 || node1.parentNode && "sourceIndex" in node1.parentNode) {
    var isElement1 = node1.nodeType == goog.dom.NodeType.ELEMENT;
    var isElement2 = node2.nodeType == goog.dom.NodeType.ELEMENT;
    if(isElement1 && isElement2) {
      return node1.sourceIndex - node2.sourceIndex
    }else {
      var parent1 = node1.parentNode;
      var parent2 = node2.parentNode;
      if(parent1 == parent2) {
        return goog.dom.compareSiblingOrder_(node1, node2)
      }
      if(!isElement1 && goog.dom.contains(parent1, node2)) {
        return-1 * goog.dom.compareParentsDescendantNodeIe_(node1, node2)
      }
      if(!isElement2 && goog.dom.contains(parent2, node1)) {
        return goog.dom.compareParentsDescendantNodeIe_(node2, node1)
      }
      return(isElement1 ? node1.sourceIndex : parent1.sourceIndex) - (isElement2 ? node2.sourceIndex : parent2.sourceIndex)
    }
  }
  var doc = goog.dom.getOwnerDocument(node1);
  var range1, range2;
  range1 = doc.createRange();
  range1.selectNode(node1);
  range1.collapse(true);
  range2 = doc.createRange();
  range2.selectNode(node2);
  range2.collapse(true);
  return range1.compareBoundaryPoints(goog.global["Range"].START_TO_END, range2)
};
goog.dom.compareParentsDescendantNodeIe_ = function(textNode, node) {
  var parent = textNode.parentNode;
  if(parent == node) {
    return-1
  }
  var sibling = node;
  while(sibling.parentNode != parent) {
    sibling = sibling.parentNode
  }
  return goog.dom.compareSiblingOrder_(sibling, textNode)
};
goog.dom.compareSiblingOrder_ = function(node1, node2) {
  var s = node2;
  while(s = s.previousSibling) {
    if(s == node1) {
      return-1
    }
  }
  return 1
};
goog.dom.findCommonAncestor = function(var_args) {
  var i, count = arguments.length;
  if(!count) {
    return null
  }else {
    if(count == 1) {
      return arguments[0]
    }
  }
  var paths = [];
  var minLength = Infinity;
  for(i = 0;i < count;i++) {
    var ancestors = [];
    var node = arguments[i];
    while(node) {
      ancestors.unshift(node);
      node = node.parentNode
    }
    paths.push(ancestors);
    minLength = Math.min(minLength, ancestors.length)
  }
  var output = null;
  for(i = 0;i < minLength;i++) {
    var first = paths[0][i];
    for(var j = 1;j < count;j++) {
      if(first != paths[j][i]) {
        return output
      }
    }
    output = first
  }
  return output
};
goog.dom.getOwnerDocument = function(node) {
  return node.nodeType == goog.dom.NodeType.DOCUMENT ? node : node.ownerDocument || node.document
};
goog.dom.getFrameContentDocument = function(frame) {
  var doc = frame.contentDocument || frame.contentWindow.document;
  return doc
};
goog.dom.getFrameContentWindow = function(frame) {
  return frame.contentWindow || goog.dom.getWindow_(goog.dom.getFrameContentDocument(frame))
};
goog.dom.setTextContent = function(element, text) {
  if("textContent" in element) {
    element.textContent = text
  }else {
    if(element.firstChild && element.firstChild.nodeType == goog.dom.NodeType.TEXT) {
      while(element.lastChild != element.firstChild) {
        element.removeChild(element.lastChild)
      }
      element.firstChild.data = text
    }else {
      goog.dom.removeChildren(element);
      var doc = goog.dom.getOwnerDocument(element);
      element.appendChild(doc.createTextNode(text))
    }
  }
};
goog.dom.getOuterHtml = function(element) {
  if("outerHTML" in element) {
    return element.outerHTML
  }else {
    var doc = goog.dom.getOwnerDocument(element);
    var div = doc.createElement("div");
    div.appendChild(element.cloneNode(true));
    return div.innerHTML
  }
};
goog.dom.findNode = function(root, p) {
  var rv = [];
  var found = goog.dom.findNodes_(root, p, rv, true);
  return found ? rv[0] : undefined
};
goog.dom.findNodes = function(root, p) {
  var rv = [];
  goog.dom.findNodes_(root, p, rv, false);
  return rv
};
goog.dom.findNodes_ = function(root, p, rv, findOne) {
  if(root != null) {
    var child = root.firstChild;
    while(child) {
      if(p(child)) {
        rv.push(child);
        if(findOne) {
          return true
        }
      }
      if(goog.dom.findNodes_(child, p, rv, findOne)) {
        return true
      }
      child = child.nextSibling
    }
  }
  return false
};
goog.dom.TAGS_TO_IGNORE_ = {"SCRIPT":1, "STYLE":1, "HEAD":1, "IFRAME":1, "OBJECT":1};
goog.dom.PREDEFINED_TAG_VALUES_ = {"IMG":" ", "BR":"\n"};
goog.dom.isFocusableTabIndex = function(element) {
  var attrNode = element.getAttributeNode("tabindex");
  if(attrNode && attrNode.specified) {
    var index = element.tabIndex;
    return goog.isNumber(index) && index >= 0 && index < 32768
  }
  return false
};
goog.dom.setFocusableTabIndex = function(element, enable) {
  if(enable) {
    element.tabIndex = 0
  }else {
    element.tabIndex = -1;
    element.removeAttribute("tabIndex")
  }
};
goog.dom.getTextContent = function(node) {
  var textContent;
  if(goog.dom.BrowserFeature.CAN_USE_INNER_TEXT && "innerText" in node) {
    textContent = goog.string.canonicalizeNewlines(node.innerText)
  }else {
    var buf = [];
    goog.dom.getTextContent_(node, buf, true);
    textContent = buf.join("")
  }
  textContent = textContent.replace(/ \xAD /g, " ").replace(/\xAD/g, "");
  textContent = textContent.replace(/\u200B/g, "");
  if(!goog.dom.BrowserFeature.CAN_USE_INNER_TEXT) {
    textContent = textContent.replace(/ +/g, " ")
  }
  if(textContent != " ") {
    textContent = textContent.replace(/^\s*/, "")
  }
  return textContent
};
goog.dom.getRawTextContent = function(node) {
  var buf = [];
  goog.dom.getTextContent_(node, buf, false);
  return buf.join("")
};
goog.dom.getTextContent_ = function(node, buf, normalizeWhitespace) {
  if(node.nodeName in goog.dom.TAGS_TO_IGNORE_) {
  }else {
    if(node.nodeType == goog.dom.NodeType.TEXT) {
      if(normalizeWhitespace) {
        buf.push(String(node.nodeValue).replace(/(\r\n|\r|\n)/g, ""))
      }else {
        buf.push(node.nodeValue)
      }
    }else {
      if(node.nodeName in goog.dom.PREDEFINED_TAG_VALUES_) {
        buf.push(goog.dom.PREDEFINED_TAG_VALUES_[node.nodeName])
      }else {
        var child = node.firstChild;
        while(child) {
          goog.dom.getTextContent_(child, buf, normalizeWhitespace);
          child = child.nextSibling
        }
      }
    }
  }
};
goog.dom.getNodeTextLength = function(node) {
  return goog.dom.getTextContent(node).length
};
goog.dom.getNodeTextOffset = function(node, opt_offsetParent) {
  var root = opt_offsetParent || goog.dom.getOwnerDocument(node).body;
  var buf = [];
  while(node && node != root) {
    var cur = node;
    while(cur = cur.previousSibling) {
      buf.unshift(goog.dom.getTextContent(cur))
    }
    node = node.parentNode
  }
  return goog.string.trimLeft(buf.join("")).replace(/ +/g, " ").length
};
goog.dom.getNodeAtOffset = function(parent, offset, opt_result) {
  var stack = [parent], pos = 0, cur;
  while(stack.length > 0 && pos < offset) {
    cur = stack.pop();
    if(cur.nodeName in goog.dom.TAGS_TO_IGNORE_) {
    }else {
      if(cur.nodeType == goog.dom.NodeType.TEXT) {
        var text = cur.nodeValue.replace(/(\r\n|\r|\n)/g, "").replace(/ +/g, " ");
        pos += text.length
      }else {
        if(cur.nodeName in goog.dom.PREDEFINED_TAG_VALUES_) {
          pos += goog.dom.PREDEFINED_TAG_VALUES_[cur.nodeName].length
        }else {
          for(var i = cur.childNodes.length - 1;i >= 0;i--) {
            stack.push(cur.childNodes[i])
          }
        }
      }
    }
  }
  if(goog.isObject(opt_result)) {
    opt_result.remainder = cur ? cur.nodeValue.length + offset - pos - 1 : 0;
    opt_result.node = cur
  }
  return cur
};
goog.dom.isNodeList = function(val) {
  if(val && typeof val.length == "number") {
    if(goog.isObject(val)) {
      return typeof val.item == "function" || typeof val.item == "string"
    }else {
      if(goog.isFunction(val)) {
        return typeof val.item == "function"
      }
    }
  }
  return false
};
goog.dom.getAncestorByTagNameAndClass = function(element, opt_tag, opt_class) {
  var tagName = opt_tag ? opt_tag.toUpperCase() : null;
  return goog.dom.getAncestor(element, function(node) {
    return(!tagName || node.nodeName == tagName) && (!opt_class || goog.dom.classes.has(node, opt_class))
  }, true)
};
goog.dom.getAncestorByClass = function(element, opt_class) {
  return goog.dom.getAncestorByTagNameAndClass(element, null, opt_class)
};
goog.dom.getAncestor = function(element, matcher, opt_includeNode, opt_maxSearchSteps) {
  if(!opt_includeNode) {
    element = element.parentNode
  }
  var ignoreSearchSteps = opt_maxSearchSteps == null;
  var steps = 0;
  while(element && (ignoreSearchSteps || steps <= opt_maxSearchSteps)) {
    if(matcher(element)) {
      return element
    }
    element = element.parentNode;
    steps++
  }
  return null
};
goog.dom.getActiveElement = function(doc) {
  try {
    return doc && doc.activeElement
  }catch(e) {
  }
  return null
};
goog.dom.DomHelper = function(opt_document) {
  this.document_ = opt_document || goog.global.document || document
};
goog.dom.DomHelper.prototype.getDomHelper = goog.dom.getDomHelper;
goog.dom.DomHelper.prototype.setDocument = function(document) {
  this.document_ = document
};
goog.dom.DomHelper.prototype.getDocument = function() {
  return this.document_
};
goog.dom.DomHelper.prototype.getElement = function(element) {
  if(goog.isString(element)) {
    return this.document_.getElementById(element)
  }else {
    return element
  }
};
goog.dom.DomHelper.prototype.$ = goog.dom.DomHelper.prototype.getElement;
goog.dom.DomHelper.prototype.getElementsByTagNameAndClass = function(opt_tag, opt_class, opt_el) {
  return goog.dom.getElementsByTagNameAndClass_(this.document_, opt_tag, opt_class, opt_el)
};
goog.dom.DomHelper.prototype.getElementsByClass = function(className, opt_el) {
  var doc = opt_el || this.document_;
  return goog.dom.getElementsByClass(className, doc)
};
goog.dom.DomHelper.prototype.getElementByClass = function(className, opt_el) {
  var doc = opt_el || this.document_;
  return goog.dom.getElementByClass(className, doc)
};
goog.dom.DomHelper.prototype.$$ = goog.dom.DomHelper.prototype.getElementsByTagNameAndClass;
goog.dom.DomHelper.prototype.setProperties = goog.dom.setProperties;
goog.dom.DomHelper.prototype.getViewportSize = function(opt_window) {
  return goog.dom.getViewportSize(opt_window || this.getWindow())
};
goog.dom.DomHelper.prototype.getDocumentHeight = function() {
  return goog.dom.getDocumentHeight_(this.getWindow())
};
goog.dom.Appendable;
goog.dom.DomHelper.prototype.createDom = function(tagName, opt_attributes, var_args) {
  return goog.dom.createDom_(this.document_, arguments)
};
goog.dom.DomHelper.prototype.$dom = goog.dom.DomHelper.prototype.createDom;
goog.dom.DomHelper.prototype.createElement = function(name) {
  return this.document_.createElement(name)
};
goog.dom.DomHelper.prototype.createTextNode = function(content) {
  return this.document_.createTextNode(content)
};
goog.dom.DomHelper.prototype.createTable = function(rows, columns, opt_fillWithNbsp) {
  return goog.dom.createTable_(this.document_, rows, columns, !!opt_fillWithNbsp)
};
goog.dom.DomHelper.prototype.htmlToDocumentFragment = function(htmlString) {
  return goog.dom.htmlToDocumentFragment_(this.document_, htmlString)
};
goog.dom.DomHelper.prototype.getCompatMode = function() {
  return this.isCss1CompatMode() ? "CSS1Compat" : "BackCompat"
};
goog.dom.DomHelper.prototype.isCss1CompatMode = function() {
  return goog.dom.isCss1CompatMode_(this.document_)
};
goog.dom.DomHelper.prototype.getWindow = function() {
  return goog.dom.getWindow_(this.document_)
};
goog.dom.DomHelper.prototype.getDocumentScrollElement = function() {
  return goog.dom.getDocumentScrollElement_(this.document_)
};
goog.dom.DomHelper.prototype.getDocumentScroll = function() {
  return goog.dom.getDocumentScroll_(this.document_)
};
goog.dom.DomHelper.prototype.appendChild = goog.dom.appendChild;
goog.dom.DomHelper.prototype.append = goog.dom.append;
goog.dom.DomHelper.prototype.removeChildren = goog.dom.removeChildren;
goog.dom.DomHelper.prototype.insertSiblingBefore = goog.dom.insertSiblingBefore;
goog.dom.DomHelper.prototype.insertSiblingAfter = goog.dom.insertSiblingAfter;
goog.dom.DomHelper.prototype.removeNode = goog.dom.removeNode;
goog.dom.DomHelper.prototype.replaceNode = goog.dom.replaceNode;
goog.dom.DomHelper.prototype.flattenElement = goog.dom.flattenElement;
goog.dom.DomHelper.prototype.getFirstElementChild = goog.dom.getFirstElementChild;
goog.dom.DomHelper.prototype.getLastElementChild = goog.dom.getLastElementChild;
goog.dom.DomHelper.prototype.getNextElementSibling = goog.dom.getNextElementSibling;
goog.dom.DomHelper.prototype.getPreviousElementSibling = goog.dom.getPreviousElementSibling;
goog.dom.DomHelper.prototype.getNextNode = goog.dom.getNextNode;
goog.dom.DomHelper.prototype.getPreviousNode = goog.dom.getPreviousNode;
goog.dom.DomHelper.prototype.isNodeLike = goog.dom.isNodeLike;
goog.dom.DomHelper.prototype.contains = goog.dom.contains;
goog.dom.DomHelper.prototype.getOwnerDocument = goog.dom.getOwnerDocument;
goog.dom.DomHelper.prototype.getFrameContentDocument = goog.dom.getFrameContentDocument;
goog.dom.DomHelper.prototype.getFrameContentWindow = goog.dom.getFrameContentWindow;
goog.dom.DomHelper.prototype.setTextContent = goog.dom.setTextContent;
goog.dom.DomHelper.prototype.findNode = goog.dom.findNode;
goog.dom.DomHelper.prototype.findNodes = goog.dom.findNodes;
goog.dom.DomHelper.prototype.getTextContent = goog.dom.getTextContent;
goog.dom.DomHelper.prototype.getNodeTextLength = goog.dom.getNodeTextLength;
goog.dom.DomHelper.prototype.getNodeTextOffset = goog.dom.getNodeTextOffset;
goog.dom.DomHelper.prototype.getAncestorByTagNameAndClass = goog.dom.getAncestorByTagNameAndClass;
goog.dom.DomHelper.prototype.getAncestorByClass = goog.dom.getAncestorByClass;
goog.dom.DomHelper.prototype.getAncestor = goog.dom.getAncestor;
goog.provide("goog.math.Box");
goog.require("goog.math.Coordinate");
goog.math.Box = function(top, right, bottom, left) {
  this.top = top;
  this.right = right;
  this.bottom = bottom;
  this.left = left
};
goog.math.Box.boundingBox = function(var_args) {
  var box = new goog.math.Box(arguments[0].y, arguments[0].x, arguments[0].y, arguments[0].x);
  for(var i = 1;i < arguments.length;i++) {
    var coord = arguments[i];
    box.top = Math.min(box.top, coord.y);
    box.right = Math.max(box.right, coord.x);
    box.bottom = Math.max(box.bottom, coord.y);
    box.left = Math.min(box.left, coord.x)
  }
  return box
};
goog.math.Box.prototype.clone = function() {
  return new goog.math.Box(this.top, this.right, this.bottom, this.left)
};
if(goog.DEBUG) {
  goog.math.Box.prototype.toString = function() {
    return"(" + this.top + "t, " + this.right + "r, " + this.bottom + "b, " + this.left + "l)"
  }
}
goog.math.Box.prototype.contains = function(other) {
  return goog.math.Box.contains(this, other)
};
goog.math.Box.prototype.expand = function(top, opt_right, opt_bottom, opt_left) {
  if(goog.isObject(top)) {
    this.top -= top.top;
    this.right += top.right;
    this.bottom += top.bottom;
    this.left -= top.left
  }else {
    this.top -= top;
    this.right += opt_right;
    this.bottom += opt_bottom;
    this.left -= opt_left
  }
  return this
};
goog.math.Box.prototype.expandToInclude = function(box) {
  this.left = Math.min(this.left, box.left);
  this.top = Math.min(this.top, box.top);
  this.right = Math.max(this.right, box.right);
  this.bottom = Math.max(this.bottom, box.bottom)
};
goog.math.Box.equals = function(a, b) {
  if(a == b) {
    return true
  }
  if(!a || !b) {
    return false
  }
  return a.top == b.top && a.right == b.right && a.bottom == b.bottom && a.left == b.left
};
goog.math.Box.contains = function(box, other) {
  if(!box || !other) {
    return false
  }
  if(other instanceof goog.math.Box) {
    return other.left >= box.left && other.right <= box.right && other.top >= box.top && other.bottom <= box.bottom
  }
  return other.x >= box.left && other.x <= box.right && other.y >= box.top && other.y <= box.bottom
};
goog.math.Box.distance = function(box, coord) {
  if(coord.x >= box.left && coord.x <= box.right) {
    if(coord.y >= box.top && coord.y <= box.bottom) {
      return 0
    }
    return coord.y < box.top ? box.top - coord.y : coord.y - box.bottom
  }
  if(coord.y >= box.top && coord.y <= box.bottom) {
    return coord.x < box.left ? box.left - coord.x : coord.x - box.right
  }
  return goog.math.Coordinate.distance(coord, new goog.math.Coordinate(coord.x < box.left ? box.left : box.right, coord.y < box.top ? box.top : box.bottom))
};
goog.math.Box.intersects = function(a, b) {
  return a.left <= b.right && b.left <= a.right && a.top <= b.bottom && b.top <= a.bottom
};
goog.math.Box.intersectsWithPadding = function(a, b, padding) {
  return a.left <= b.right + padding && b.left <= a.right + padding && a.top <= b.bottom + padding && b.top <= a.bottom + padding
};
goog.provide("goog.math.Rect");
goog.require("goog.math.Box");
goog.require("goog.math.Size");
goog.math.Rect = function(x, y, w, h) {
  this.left = x;
  this.top = y;
  this.width = w;
  this.height = h
};
goog.math.Rect.prototype.clone = function() {
  return new goog.math.Rect(this.left, this.top, this.width, this.height)
};
goog.math.Rect.prototype.toBox = function() {
  var right = this.left + this.width;
  var bottom = this.top + this.height;
  return new goog.math.Box(this.top, right, bottom, this.left)
};
goog.math.Rect.createFromBox = function(box) {
  return new goog.math.Rect(box.left, box.top, box.right - box.left, box.bottom - box.top)
};
if(goog.DEBUG) {
  goog.math.Rect.prototype.toString = function() {
    return"(" + this.left + ", " + this.top + " - " + this.width + "w x " + this.height + "h)"
  }
}
goog.math.Rect.equals = function(a, b) {
  if(a == b) {
    return true
  }
  if(!a || !b) {
    return false
  }
  return a.left == b.left && a.width == b.width && a.top == b.top && a.height == b.height
};
goog.math.Rect.prototype.intersection = function(rect) {
  var x0 = Math.max(this.left, rect.left);
  var x1 = Math.min(this.left + this.width, rect.left + rect.width);
  if(x0 <= x1) {
    var y0 = Math.max(this.top, rect.top);
    var y1 = Math.min(this.top + this.height, rect.top + rect.height);
    if(y0 <= y1) {
      this.left = x0;
      this.top = y0;
      this.width = x1 - x0;
      this.height = y1 - y0;
      return true
    }
  }
  return false
};
goog.math.Rect.intersection = function(a, b) {
  var x0 = Math.max(a.left, b.left);
  var x1 = Math.min(a.left + a.width, b.left + b.width);
  if(x0 <= x1) {
    var y0 = Math.max(a.top, b.top);
    var y1 = Math.min(a.top + a.height, b.top + b.height);
    if(y0 <= y1) {
      return new goog.math.Rect(x0, y0, x1 - x0, y1 - y0)
    }
  }
  return null
};
goog.math.Rect.intersects = function(a, b) {
  return a.left <= b.left + b.width && b.left <= a.left + a.width && a.top <= b.top + b.height && b.top <= a.top + a.height
};
goog.math.Rect.prototype.intersects = function(rect) {
  return goog.math.Rect.intersects(this, rect)
};
goog.math.Rect.difference = function(a, b) {
  var intersection = goog.math.Rect.intersection(a, b);
  if(!intersection || !intersection.height || !intersection.width) {
    return[a.clone()]
  }
  var result = [];
  var top = a.top;
  var height = a.height;
  var ar = a.left + a.width;
  var ab = a.top + a.height;
  var br = b.left + b.width;
  var bb = b.top + b.height;
  if(b.top > a.top) {
    result.push(new goog.math.Rect(a.left, a.top, a.width, b.top - a.top));
    top = b.top;
    height -= b.top - a.top
  }
  if(bb < ab) {
    result.push(new goog.math.Rect(a.left, bb, a.width, ab - bb));
    height = bb - top
  }
  if(b.left > a.left) {
    result.push(new goog.math.Rect(a.left, top, b.left - a.left, height))
  }
  if(br < ar) {
    result.push(new goog.math.Rect(br, top, ar - br, height))
  }
  return result
};
goog.math.Rect.prototype.difference = function(rect) {
  return goog.math.Rect.difference(this, rect)
};
goog.math.Rect.prototype.boundingRect = function(rect) {
  var right = Math.max(this.left + this.width, rect.left + rect.width);
  var bottom = Math.max(this.top + this.height, rect.top + rect.height);
  this.left = Math.min(this.left, rect.left);
  this.top = Math.min(this.top, rect.top);
  this.width = right - this.left;
  this.height = bottom - this.top
};
goog.math.Rect.boundingRect = function(a, b) {
  if(!a || !b) {
    return null
  }
  var clone = a.clone();
  clone.boundingRect(b);
  return clone
};
goog.math.Rect.prototype.contains = function(another) {
  if(another instanceof goog.math.Rect) {
    return this.left <= another.left && this.left + this.width >= another.left + another.width && this.top <= another.top && this.top + this.height >= another.top + another.height
  }else {
    return another.x >= this.left && another.x <= this.left + this.width && another.y >= this.top && another.y <= this.top + this.height
  }
};
goog.math.Rect.prototype.getSize = function() {
  return new goog.math.Size(this.width, this.height)
};
goog.provide("goog.style");
goog.require("goog.array");
goog.require("goog.dom");
goog.require("goog.math.Box");
goog.require("goog.math.Coordinate");
goog.require("goog.math.Rect");
goog.require("goog.math.Size");
goog.require("goog.object");
goog.require("goog.string");
goog.require("goog.userAgent");
goog.style.setStyle = function(element, style, opt_value) {
  if(goog.isString(style)) {
    goog.style.setStyle_(element, opt_value, style)
  }else {
    goog.object.forEach(style, goog.partial(goog.style.setStyle_, element))
  }
};
goog.style.setStyle_ = function(element, value, style) {
  element.style[goog.string.toCamelCase(style)] = value
};
goog.style.getStyle = function(element, property) {
  return element.style[goog.string.toCamelCase(property)] || ""
};
goog.style.getComputedStyle = function(element, property) {
  var doc = goog.dom.getOwnerDocument(element);
  if(doc.defaultView && doc.defaultView.getComputedStyle) {
    var styles = doc.defaultView.getComputedStyle(element, null);
    if(styles) {
      return styles[property] || styles.getPropertyValue(property)
    }
  }
  return""
};
goog.style.getCascadedStyle = function(element, style) {
  return element.currentStyle ? element.currentStyle[style] : null
};
goog.style.getStyle_ = function(element, style) {
  return goog.style.getComputedStyle(element, style) || goog.style.getCascadedStyle(element, style) || element.style[style]
};
goog.style.getComputedPosition = function(element) {
  return goog.style.getStyle_(element, "position")
};
goog.style.getBackgroundColor = function(element) {
  return goog.style.getStyle_(element, "backgroundColor")
};
goog.style.getComputedOverflowX = function(element) {
  return goog.style.getStyle_(element, "overflowX")
};
goog.style.getComputedOverflowY = function(element) {
  return goog.style.getStyle_(element, "overflowY")
};
goog.style.getComputedZIndex = function(element) {
  return goog.style.getStyle_(element, "zIndex")
};
goog.style.getComputedTextAlign = function(element) {
  return goog.style.getStyle_(element, "textAlign")
};
goog.style.getComputedCursor = function(element) {
  return goog.style.getStyle_(element, "cursor")
};
goog.style.setPosition = function(el, arg1, opt_arg2) {
  var x, y;
  var buggyGeckoSubPixelPos = goog.userAgent.GECKO && (goog.userAgent.MAC || goog.userAgent.X11) && goog.userAgent.isVersion("1.9");
  if(arg1 instanceof goog.math.Coordinate) {
    x = arg1.x;
    y = arg1.y
  }else {
    x = arg1;
    y = opt_arg2
  }
  el.style.left = goog.style.getPixelStyleValue_(x, buggyGeckoSubPixelPos);
  el.style.top = goog.style.getPixelStyleValue_(y, buggyGeckoSubPixelPos)
};
goog.style.getPosition = function(element) {
  return new goog.math.Coordinate(element.offsetLeft, element.offsetTop)
};
goog.style.getClientViewportElement = function(opt_node) {
  var doc;
  if(opt_node) {
    if(opt_node.nodeType == goog.dom.NodeType.DOCUMENT) {
      doc = opt_node
    }else {
      doc = goog.dom.getOwnerDocument(opt_node)
    }
  }else {
    doc = goog.dom.getDocument()
  }
  if(goog.userAgent.IE && !goog.userAgent.isDocumentMode(9) && !goog.dom.getDomHelper(doc).isCss1CompatMode()) {
    return doc.body
  }
  return doc.documentElement
};
goog.style.getBoundingClientRect_ = function(el) {
  var rect = el.getBoundingClientRect();
  if(goog.userAgent.IE) {
    var doc = el.ownerDocument;
    rect.left -= doc.documentElement.clientLeft + doc.body.clientLeft;
    rect.top -= doc.documentElement.clientTop + doc.body.clientTop
  }
  return rect
};
goog.style.getOffsetParent = function(element) {
  if(goog.userAgent.IE) {
    return element.offsetParent
  }
  var doc = goog.dom.getOwnerDocument(element);
  var positionStyle = goog.style.getStyle_(element, "position");
  var skipStatic = positionStyle == "fixed" || positionStyle == "absolute";
  for(var parent = element.parentNode;parent && parent != doc;parent = parent.parentNode) {
    positionStyle = goog.style.getStyle_(parent, "position");
    skipStatic = skipStatic && positionStyle == "static" && parent != doc.documentElement && parent != doc.body;
    if(!skipStatic && (parent.scrollWidth > parent.clientWidth || parent.scrollHeight > parent.clientHeight || positionStyle == "fixed" || positionStyle == "absolute" || positionStyle == "relative")) {
      return parent
    }
  }
  return null
};
goog.style.getVisibleRectForElement = function(element) {
  var visibleRect = new goog.math.Box(0, Infinity, Infinity, 0);
  var dom = goog.dom.getDomHelper(element);
  var body = dom.getDocument().body;
  var documentElement = dom.getDocument().documentElement;
  var scrollEl = dom.getDocumentScrollElement();
  for(var el = element;el = goog.style.getOffsetParent(el);) {
    if((!goog.userAgent.IE || el.clientWidth != 0) && (!goog.userAgent.WEBKIT || el.clientHeight != 0 || el != body) && el != body && el != documentElement && goog.style.getStyle_(el, "overflow") != "visible") {
      var pos = goog.style.getPageOffset(el);
      var client = goog.style.getClientLeftTop(el);
      pos.x += client.x;
      pos.y += client.y;
      visibleRect.top = Math.max(visibleRect.top, pos.y);
      visibleRect.right = Math.min(visibleRect.right, pos.x + el.clientWidth);
      visibleRect.bottom = Math.min(visibleRect.bottom, pos.y + el.clientHeight);
      visibleRect.left = Math.max(visibleRect.left, pos.x)
    }
  }
  var scrollX = scrollEl.scrollLeft, scrollY = scrollEl.scrollTop;
  visibleRect.left = Math.max(visibleRect.left, scrollX);
  visibleRect.top = Math.max(visibleRect.top, scrollY);
  var winSize = dom.getViewportSize();
  visibleRect.right = Math.min(visibleRect.right, scrollX + winSize.width);
  visibleRect.bottom = Math.min(visibleRect.bottom, scrollY + winSize.height);
  return visibleRect.top >= 0 && visibleRect.left >= 0 && visibleRect.bottom > visibleRect.top && visibleRect.right > visibleRect.left ? visibleRect : null
};
goog.style.scrollIntoContainerView = function(element, container, opt_center) {
  var elementPos = goog.style.getPageOffset(element);
  var containerPos = goog.style.getPageOffset(container);
  var containerBorder = goog.style.getBorderBox(container);
  var relX = elementPos.x - containerPos.x - containerBorder.left;
  var relY = elementPos.y - containerPos.y - containerBorder.top;
  var spaceX = container.clientWidth - element.offsetWidth;
  var spaceY = container.clientHeight - element.offsetHeight;
  if(opt_center) {
    container.scrollLeft += relX - spaceX / 2;
    container.scrollTop += relY - spaceY / 2
  }else {
    container.scrollLeft += Math.min(relX, Math.max(relX - spaceX, 0));
    container.scrollTop += Math.min(relY, Math.max(relY - spaceY, 0))
  }
};
goog.style.getClientLeftTop = function(el) {
  if(goog.userAgent.GECKO && !goog.userAgent.isVersion("1.9")) {
    var left = parseFloat(goog.style.getComputedStyle(el, "borderLeftWidth"));
    if(goog.style.isRightToLeft(el)) {
      var scrollbarWidth = el.offsetWidth - el.clientWidth - left - parseFloat(goog.style.getComputedStyle(el, "borderRightWidth"));
      left += scrollbarWidth
    }
    return new goog.math.Coordinate(left, parseFloat(goog.style.getComputedStyle(el, "borderTopWidth")))
  }
  return new goog.math.Coordinate(el.clientLeft, el.clientTop)
};
goog.style.getPageOffset = function(el) {
  var box, doc = goog.dom.getOwnerDocument(el);
  var positionStyle = goog.style.getStyle_(el, "position");
  var BUGGY_GECKO_BOX_OBJECT = goog.userAgent.GECKO && doc.getBoxObjectFor && !el.getBoundingClientRect && positionStyle == "absolute" && (box = doc.getBoxObjectFor(el)) && (box.screenX < 0 || box.screenY < 0);
  var pos = new goog.math.Coordinate(0, 0);
  var viewportElement = goog.style.getClientViewportElement(doc);
  if(el == viewportElement) {
    return pos
  }
  if(el.getBoundingClientRect) {
    box = goog.style.getBoundingClientRect_(el);
    var scrollCoord = goog.dom.getDomHelper(doc).getDocumentScroll();
    pos.x = box.left + scrollCoord.x;
    pos.y = box.top + scrollCoord.y
  }else {
    if(doc.getBoxObjectFor && !BUGGY_GECKO_BOX_OBJECT) {
      box = doc.getBoxObjectFor(el);
      var vpBox = doc.getBoxObjectFor(viewportElement);
      pos.x = box.screenX - vpBox.screenX;
      pos.y = box.screenY - vpBox.screenY
    }else {
      var parent = el;
      do {
        pos.x += parent.offsetLeft;
        pos.y += parent.offsetTop;
        if(parent != el) {
          pos.x += parent.clientLeft || 0;
          pos.y += parent.clientTop || 0
        }
        if(goog.userAgent.WEBKIT && goog.style.getComputedPosition(parent) == "fixed") {
          pos.x += doc.body.scrollLeft;
          pos.y += doc.body.scrollTop;
          break
        }
        parent = parent.offsetParent
      }while(parent && parent != el);
      if(goog.userAgent.OPERA || goog.userAgent.WEBKIT && positionStyle == "absolute") {
        pos.y -= doc.body.offsetTop
      }
      for(parent = el;(parent = goog.style.getOffsetParent(parent)) && parent != doc.body && parent != viewportElement;) {
        pos.x -= parent.scrollLeft;
        if(!goog.userAgent.OPERA || parent.tagName != "TR") {
          pos.y -= parent.scrollTop
        }
      }
    }
  }
  return pos
};
goog.style.getPageOffsetLeft = function(el) {
  return goog.style.getPageOffset(el).x
};
goog.style.getPageOffsetTop = function(el) {
  return goog.style.getPageOffset(el).y
};
goog.style.getFramedPageOffset = function(el, relativeWin) {
  var position = new goog.math.Coordinate(0, 0);
  var currentWin = goog.dom.getWindow(goog.dom.getOwnerDocument(el));
  var currentEl = el;
  do {
    var offset = currentWin == relativeWin ? goog.style.getPageOffset(currentEl) : goog.style.getClientPosition(currentEl);
    position.x += offset.x;
    position.y += offset.y
  }while(currentWin && currentWin != relativeWin && (currentEl = currentWin.frameElement) && (currentWin = currentWin.parent));
  return position
};
goog.style.translateRectForAnotherFrame = function(rect, origBase, newBase) {
  if(origBase.getDocument() != newBase.getDocument()) {
    var body = origBase.getDocument().body;
    var pos = goog.style.getFramedPageOffset(body, newBase.getWindow());
    pos = goog.math.Coordinate.difference(pos, goog.style.getPageOffset(body));
    if(goog.userAgent.IE && !origBase.isCss1CompatMode()) {
      pos = goog.math.Coordinate.difference(pos, origBase.getDocumentScroll())
    }
    rect.left += pos.x;
    rect.top += pos.y
  }
};
goog.style.getRelativePosition = function(a, b) {
  var ap = goog.style.getClientPosition(a);
  var bp = goog.style.getClientPosition(b);
  return new goog.math.Coordinate(ap.x - bp.x, ap.y - bp.y)
};
goog.style.getClientPosition = function(el) {
  var pos = new goog.math.Coordinate;
  if(el.nodeType == goog.dom.NodeType.ELEMENT) {
    if(el.getBoundingClientRect) {
      var box = goog.style.getBoundingClientRect_(el);
      pos.x = box.left;
      pos.y = box.top
    }else {
      var scrollCoord = goog.dom.getDomHelper(el).getDocumentScroll();
      var pageCoord = goog.style.getPageOffset(el);
      pos.x = pageCoord.x - scrollCoord.x;
      pos.y = pageCoord.y - scrollCoord.y
    }
  }else {
    var isAbstractedEvent = goog.isFunction(el.getBrowserEvent);
    var targetEvent = el;
    if(el.targetTouches) {
      targetEvent = el.targetTouches[0]
    }else {
      if(isAbstractedEvent && el.getBrowserEvent().targetTouches) {
        targetEvent = el.getBrowserEvent().targetTouches[0]
      }
    }
    pos.x = targetEvent.clientX;
    pos.y = targetEvent.clientY
  }
  return pos
};
goog.style.setPageOffset = function(el, x, opt_y) {
  var cur = goog.style.getPageOffset(el);
  if(x instanceof goog.math.Coordinate) {
    opt_y = x.y;
    x = x.x
  }
  var dx = x - cur.x;
  var dy = opt_y - cur.y;
  goog.style.setPosition(el, el.offsetLeft + dx, el.offsetTop + dy)
};
goog.style.setSize = function(element, w, opt_h) {
  var h;
  if(w instanceof goog.math.Size) {
    h = w.height;
    w = w.width
  }else {
    if(opt_h == undefined) {
      throw Error("missing height argument");
    }
    h = opt_h
  }
  goog.style.setWidth(element, w);
  goog.style.setHeight(element, h)
};
goog.style.getPixelStyleValue_ = function(value, round) {
  if(typeof value == "number") {
    value = (round ? Math.round(value) : value) + "px"
  }
  return value
};
goog.style.setHeight = function(element, height) {
  element.style.height = goog.style.getPixelStyleValue_(height, true)
};
goog.style.setWidth = function(element, width) {
  element.style.width = goog.style.getPixelStyleValue_(width, true)
};
goog.style.getSize = function(element) {
  if(goog.style.getStyle_(element, "display") != "none") {
    return goog.style.getSizeWithDisplay_(element)
  }
  var style = element.style;
  var originalDisplay = style.display;
  var originalVisibility = style.visibility;
  var originalPosition = style.position;
  style.visibility = "hidden";
  style.position = "absolute";
  style.display = "inline";
  var size = goog.style.getSizeWithDisplay_(element);
  style.display = originalDisplay;
  style.position = originalPosition;
  style.visibility = originalVisibility;
  return size
};
goog.style.getSizeWithDisplay_ = function(element) {
  var offsetWidth = element.offsetWidth;
  var offsetHeight = element.offsetHeight;
  var webkitOffsetsZero = goog.userAgent.WEBKIT && !offsetWidth && !offsetHeight;
  if((!goog.isDef(offsetWidth) || webkitOffsetsZero) && element.getBoundingClientRect) {
    var clientRect = goog.style.getBoundingClientRect_(element);
    return new goog.math.Size(clientRect.right - clientRect.left, clientRect.bottom - clientRect.top)
  }
  return new goog.math.Size(offsetWidth, offsetHeight)
};
goog.style.getBounds = function(element) {
  var o = goog.style.getPageOffset(element);
  var s = goog.style.getSize(element);
  return new goog.math.Rect(o.x, o.y, s.width, s.height)
};
goog.style.toCamelCase = function(selector) {
  return goog.string.toCamelCase(String(selector))
};
goog.style.toSelectorCase = function(selector) {
  return goog.string.toSelectorCase(selector)
};
goog.style.getOpacity = function(el) {
  var style = el.style;
  var result = "";
  if("opacity" in style) {
    result = style.opacity
  }else {
    if("MozOpacity" in style) {
      result = style.MozOpacity
    }else {
      if("filter" in style) {
        var match = style.filter.match(/alpha\(opacity=([\d.]+)\)/);
        if(match) {
          result = String(match[1] / 100)
        }
      }
    }
  }
  return result == "" ? result : Number(result)
};
goog.style.setOpacity = function(el, alpha) {
  var style = el.style;
  if("opacity" in style) {
    style.opacity = alpha
  }else {
    if("MozOpacity" in style) {
      style.MozOpacity = alpha
    }else {
      if("filter" in style) {
        if(alpha === "") {
          style.filter = ""
        }else {
          style.filter = "alpha(opacity=" + alpha * 100 + ")"
        }
      }
    }
  }
};
goog.style.setTransparentBackgroundImage = function(el, src) {
  var style = el.style;
  if(goog.userAgent.IE && !goog.userAgent.isVersion("8")) {
    style.filter = "progid:DXImageTransform.Microsoft.AlphaImageLoader(" + 'src="' + src + '", sizingMethod="crop")'
  }else {
    style.backgroundImage = "url(" + src + ")";
    style.backgroundPosition = "top left";
    style.backgroundRepeat = "no-repeat"
  }
};
goog.style.clearTransparentBackgroundImage = function(el) {
  var style = el.style;
  if("filter" in style) {
    style.filter = ""
  }else {
    style.backgroundImage = "none"
  }
};
goog.style.showElement = function(el, display) {
  el.style.display = display ? "" : "none"
};
goog.style.isElementShown = function(el) {
  return el.style.display != "none"
};
goog.style.installStyles = function(stylesString, opt_node) {
  var dh = goog.dom.getDomHelper(opt_node);
  var styleSheet = null;
  if(goog.userAgent.IE) {
    styleSheet = dh.getDocument().createStyleSheet();
    goog.style.setStyles(styleSheet, stylesString)
  }else {
    var head = dh.getElementsByTagNameAndClass("head")[0];
    if(!head) {
      var body = dh.getElementsByTagNameAndClass("body")[0];
      head = dh.createDom("head");
      body.parentNode.insertBefore(head, body)
    }
    styleSheet = dh.createDom("style");
    goog.style.setStyles(styleSheet, stylesString);
    dh.appendChild(head, styleSheet)
  }
  return styleSheet
};
goog.style.uninstallStyles = function(styleSheet) {
  var node = styleSheet.ownerNode || styleSheet.owningElement || styleSheet;
  goog.dom.removeNode(node)
};
goog.style.setStyles = function(element, stylesString) {
  if(goog.userAgent.IE) {
    element.cssText = stylesString
  }else {
    var propToSet = goog.userAgent.WEBKIT ? "innerText" : "innerHTML";
    element[propToSet] = stylesString
  }
};
goog.style.setPreWrap = function(el) {
  var style = el.style;
  if(goog.userAgent.IE && !goog.userAgent.isVersion("8")) {
    style.whiteSpace = "pre";
    style.wordWrap = "break-word"
  }else {
    if(goog.userAgent.GECKO) {
      style.whiteSpace = "-moz-pre-wrap"
    }else {
      style.whiteSpace = "pre-wrap"
    }
  }
};
goog.style.setInlineBlock = function(el) {
  var style = el.style;
  style.position = "relative";
  if(goog.userAgent.IE && !goog.userAgent.isVersion("8")) {
    style.zoom = "1";
    style.display = "inline"
  }else {
    if(goog.userAgent.GECKO) {
      style.display = goog.userAgent.isVersion("1.9a") ? "inline-block" : "-moz-inline-box"
    }else {
      style.display = "inline-block"
    }
  }
};
goog.style.isRightToLeft = function(el) {
  return"rtl" == goog.style.getStyle_(el, "direction")
};
goog.style.unselectableStyle_ = goog.userAgent.GECKO ? "MozUserSelect" : goog.userAgent.WEBKIT ? "WebkitUserSelect" : null;
goog.style.isUnselectable = function(el) {
  if(goog.style.unselectableStyle_) {
    return el.style[goog.style.unselectableStyle_].toLowerCase() == "none"
  }else {
    if(goog.userAgent.IE || goog.userAgent.OPERA) {
      return el.getAttribute("unselectable") == "on"
    }
  }
  return false
};
goog.style.setUnselectable = function(el, unselectable, opt_noRecurse) {
  var descendants = !opt_noRecurse ? el.getElementsByTagName("*") : null;
  var name = goog.style.unselectableStyle_;
  if(name) {
    var value = unselectable ? "none" : "";
    el.style[name] = value;
    if(descendants) {
      for(var i = 0, descendant;descendant = descendants[i];i++) {
        descendant.style[name] = value
      }
    }
  }else {
    if(goog.userAgent.IE || goog.userAgent.OPERA) {
      var value = unselectable ? "on" : "";
      el.setAttribute("unselectable", value);
      if(descendants) {
        for(var i = 0, descendant;descendant = descendants[i];i++) {
          descendant.setAttribute("unselectable", value)
        }
      }
    }
  }
};
goog.style.getBorderBoxSize = function(element) {
  return new goog.math.Size(element.offsetWidth, element.offsetHeight)
};
goog.style.setBorderBoxSize = function(element, size) {
  var doc = goog.dom.getOwnerDocument(element);
  var isCss1CompatMode = goog.dom.getDomHelper(doc).isCss1CompatMode();
  if(goog.userAgent.IE && (!isCss1CompatMode || !goog.userAgent.isVersion("8"))) {
    var style = element.style;
    if(isCss1CompatMode) {
      var paddingBox = goog.style.getPaddingBox(element);
      var borderBox = goog.style.getBorderBox(element);
      style.pixelWidth = size.width - borderBox.left - paddingBox.left - paddingBox.right - borderBox.right;
      style.pixelHeight = size.height - borderBox.top - paddingBox.top - paddingBox.bottom - borderBox.bottom
    }else {
      style.pixelWidth = size.width;
      style.pixelHeight = size.height
    }
  }else {
    goog.style.setBoxSizingSize_(element, size, "border-box")
  }
};
goog.style.getContentBoxSize = function(element) {
  var doc = goog.dom.getOwnerDocument(element);
  var ieCurrentStyle = goog.userAgent.IE && element.currentStyle;
  if(ieCurrentStyle && goog.dom.getDomHelper(doc).isCss1CompatMode() && ieCurrentStyle.width != "auto" && ieCurrentStyle.height != "auto" && !ieCurrentStyle.boxSizing) {
    var width = goog.style.getIePixelValue_(element, ieCurrentStyle.width, "width", "pixelWidth");
    var height = goog.style.getIePixelValue_(element, ieCurrentStyle.height, "height", "pixelHeight");
    return new goog.math.Size(width, height)
  }else {
    var borderBoxSize = goog.style.getBorderBoxSize(element);
    var paddingBox = goog.style.getPaddingBox(element);
    var borderBox = goog.style.getBorderBox(element);
    return new goog.math.Size(borderBoxSize.width - borderBox.left - paddingBox.left - paddingBox.right - borderBox.right, borderBoxSize.height - borderBox.top - paddingBox.top - paddingBox.bottom - borderBox.bottom)
  }
};
goog.style.setContentBoxSize = function(element, size) {
  var doc = goog.dom.getOwnerDocument(element);
  var isCss1CompatMode = goog.dom.getDomHelper(doc).isCss1CompatMode();
  if(goog.userAgent.IE && (!isCss1CompatMode || !goog.userAgent.isVersion("8"))) {
    var style = element.style;
    if(isCss1CompatMode) {
      style.pixelWidth = size.width;
      style.pixelHeight = size.height
    }else {
      var paddingBox = goog.style.getPaddingBox(element);
      var borderBox = goog.style.getBorderBox(element);
      style.pixelWidth = size.width + borderBox.left + paddingBox.left + paddingBox.right + borderBox.right;
      style.pixelHeight = size.height + borderBox.top + paddingBox.top + paddingBox.bottom + borderBox.bottom
    }
  }else {
    goog.style.setBoxSizingSize_(element, size, "content-box")
  }
};
goog.style.setBoxSizingSize_ = function(element, size, boxSizing) {
  var style = element.style;
  if(goog.userAgent.GECKO) {
    style.MozBoxSizing = boxSizing
  }else {
    if(goog.userAgent.WEBKIT) {
      style.WebkitBoxSizing = boxSizing
    }else {
      style.boxSizing = boxSizing
    }
  }
  style.width = size.width + "px";
  style.height = size.height + "px"
};
goog.style.getIePixelValue_ = function(element, value, name, pixelName) {
  if(/^\d+px?$/.test(value)) {
    return parseInt(value, 10)
  }else {
    var oldStyleValue = element.style[name];
    var oldRuntimeValue = element.runtimeStyle[name];
    element.runtimeStyle[name] = element.currentStyle[name];
    element.style[name] = value;
    var pixelValue = element.style[pixelName];
    element.style[name] = oldStyleValue;
    element.runtimeStyle[name] = oldRuntimeValue;
    return pixelValue
  }
};
goog.style.getIePixelDistance_ = function(element, propName) {
  return goog.style.getIePixelValue_(element, goog.style.getCascadedStyle(element, propName), "left", "pixelLeft")
};
goog.style.getBox_ = function(element, stylePrefix) {
  if(goog.userAgent.IE) {
    var left = goog.style.getIePixelDistance_(element, stylePrefix + "Left");
    var right = goog.style.getIePixelDistance_(element, stylePrefix + "Right");
    var top = goog.style.getIePixelDistance_(element, stylePrefix + "Top");
    var bottom = goog.style.getIePixelDistance_(element, stylePrefix + "Bottom");
    return new goog.math.Box(top, right, bottom, left)
  }else {
    var left = goog.style.getComputedStyle(element, stylePrefix + "Left");
    var right = goog.style.getComputedStyle(element, stylePrefix + "Right");
    var top = goog.style.getComputedStyle(element, stylePrefix + "Top");
    var bottom = goog.style.getComputedStyle(element, stylePrefix + "Bottom");
    return new goog.math.Box(parseFloat(top), parseFloat(right), parseFloat(bottom), parseFloat(left))
  }
};
goog.style.getPaddingBox = function(element) {
  return goog.style.getBox_(element, "padding")
};
goog.style.getMarginBox = function(element) {
  return goog.style.getBox_(element, "margin")
};
goog.style.ieBorderWidthKeywords_ = {"thin":2, "medium":4, "thick":6};
goog.style.getIePixelBorder_ = function(element, prop) {
  if(goog.style.getCascadedStyle(element, prop + "Style") == "none") {
    return 0
  }
  var width = goog.style.getCascadedStyle(element, prop + "Width");
  if(width in goog.style.ieBorderWidthKeywords_) {
    return goog.style.ieBorderWidthKeywords_[width]
  }
  return goog.style.getIePixelValue_(element, width, "left", "pixelLeft")
};
goog.style.getBorderBox = function(element) {
  if(goog.userAgent.IE) {
    var left = goog.style.getIePixelBorder_(element, "borderLeft");
    var right = goog.style.getIePixelBorder_(element, "borderRight");
    var top = goog.style.getIePixelBorder_(element, "borderTop");
    var bottom = goog.style.getIePixelBorder_(element, "borderBottom");
    return new goog.math.Box(top, right, bottom, left)
  }else {
    var left = goog.style.getComputedStyle(element, "borderLeftWidth");
    var right = goog.style.getComputedStyle(element, "borderRightWidth");
    var top = goog.style.getComputedStyle(element, "borderTopWidth");
    var bottom = goog.style.getComputedStyle(element, "borderBottomWidth");
    return new goog.math.Box(parseFloat(top), parseFloat(right), parseFloat(bottom), parseFloat(left))
  }
};
goog.style.getFontFamily = function(el) {
  var doc = goog.dom.getOwnerDocument(el);
  var font = "";
  if(doc.body.createTextRange) {
    var range = doc.body.createTextRange();
    range.moveToElementText(el);
    try {
      font = range.queryCommandValue("FontName")
    }catch(e) {
      font = ""
    }
  }
  if(!font) {
    font = goog.style.getStyle_(el, "fontFamily")
  }
  var fontsArray = font.split(",");
  if(fontsArray.length > 1) {
    font = fontsArray[0]
  }
  return goog.string.stripQuotes(font, "\"'")
};
goog.style.lengthUnitRegex_ = /[^\d]+$/;
goog.style.getLengthUnits = function(value) {
  var units = value.match(goog.style.lengthUnitRegex_);
  return units && units[0] || null
};
goog.style.ABSOLUTE_CSS_LENGTH_UNITS_ = {"cm":1, "in":1, "mm":1, "pc":1, "pt":1};
goog.style.CONVERTIBLE_RELATIVE_CSS_UNITS_ = {"em":1, "ex":1};
goog.style.getFontSize = function(el) {
  var fontSize = goog.style.getStyle_(el, "fontSize");
  var sizeUnits = goog.style.getLengthUnits(fontSize);
  if(fontSize && "px" == sizeUnits) {
    return parseInt(fontSize, 10)
  }
  if(goog.userAgent.IE) {
    if(sizeUnits in goog.style.ABSOLUTE_CSS_LENGTH_UNITS_) {
      return goog.style.getIePixelValue_(el, fontSize, "left", "pixelLeft")
    }else {
      if(el.parentNode && el.parentNode.nodeType == goog.dom.NodeType.ELEMENT && sizeUnits in goog.style.CONVERTIBLE_RELATIVE_CSS_UNITS_) {
        var parentElement = el.parentNode;
        var parentSize = goog.style.getStyle_(parentElement, "fontSize");
        return goog.style.getIePixelValue_(parentElement, fontSize == parentSize ? "1em" : fontSize, "left", "pixelLeft")
      }
    }
  }
  var sizeElement = goog.dom.createDom("span", {"style":"visibility:hidden;position:absolute;" + "line-height:0;padding:0;margin:0;border:0;height:1em;"});
  goog.dom.appendChild(el, sizeElement);
  fontSize = sizeElement.offsetHeight;
  goog.dom.removeNode(sizeElement);
  return fontSize
};
goog.style.parseStyleAttribute = function(value) {
  var result = {};
  goog.array.forEach(value.split(/\s*;\s*/), function(pair) {
    var keyValue = pair.split(/\s*:\s*/);
    if(keyValue.length == 2) {
      result[goog.string.toCamelCase(keyValue[0].toLowerCase())] = keyValue[1]
    }
  });
  return result
};
goog.style.toStyleAttribute = function(obj) {
  var buffer = [];
  goog.object.forEach(obj, function(value, key) {
    buffer.push(goog.string.toSelectorCase(key), ":", value, ";")
  });
  return buffer.join("")
};
goog.style.setFloat = function(el, value) {
  el.style[goog.userAgent.IE ? "styleFloat" : "cssFloat"] = value
};
goog.style.getFloat = function(el) {
  return el.style[goog.userAgent.IE ? "styleFloat" : "cssFloat"] || ""
};
goog.style.getScrollbarWidth = function(opt_className) {
  var outerDiv = goog.dom.createElement("div");
  if(opt_className) {
    outerDiv.className = opt_className
  }
  outerDiv.style.cssText = "visiblity:hidden;overflow:auto;" + "position:absolute;top:0;width:100px;height:100px";
  var innerDiv = goog.dom.createElement("div");
  goog.style.setSize(innerDiv, "200px", "200px");
  outerDiv.appendChild(innerDiv);
  goog.dom.appendChild(goog.dom.getDocument().body, outerDiv);
  var width = outerDiv.offsetWidth - outerDiv.clientWidth;
  goog.dom.removeNode(outerDiv);
  return width
};
goog.provide("cljs_d3.tooltip");
goog.require("cljs.core");
goog.require("goog.style");
goog.require("goog.dom");
cljs_d3.tooltip.tooltip_id = "cljs-d3-tooltip";
cljs_d3.tooltip.init_BANG_ = function init_BANG_() {
  if(cljs.core.not.call(null, goog.dom.getElement(cljs_d3.tooltip.tooltip_id))) {
    var tt__6756 = goog.dom.createDom("div", cljs.core.ObjMap.fromObject(["id", "style"], {"id":cljs_d3.tooltip.tooltip_id, "style":"position: absolute;"}).strobj());
    goog.dom.appendChild(document.body(), tt__6756);
    return tt__6756
  }else {
    return null
  }
};
cljs_d3.tooltip.show_BANG_ = function() {
  var show_BANG___delegate = function(left, top, html, p__6757) {
    var map__6763__6764 = p__6757;
    var map__6763__6765 = cljs.core.seq_QMARK_.call(null, map__6763__6764) ? cljs.core.apply.call(null, cljs.core.hash_map, map__6763__6764) : map__6763__6764;
    var margin__6766 = cljs.core._lookup.call(null, map__6763__6765, "\ufdd0'margin", cljs.core.PersistentVector.fromArray([0, 0], true));
    var tt__6767 = goog.dom.getElement(cljs_d3.tooltip.tooltip_id);
    goog.style.setPosition(tt__6767, left + margin__6766.call(null, 0), top + margin__6766.call(null, 1));
    return goog.style.showElement(tt__6767, true)
  };
  var show_BANG_ = function(left, top, html, var_args) {
    var p__6757 = null;
    if(goog.isDef(var_args)) {
      p__6757 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 3), 0)
    }
    return show_BANG___delegate.call(this, left, top, html, p__6757)
  };
  show_BANG_.cljs$lang$maxFixedArity = 3;
  show_BANG_.cljs$lang$applyTo = function(arglist__6768) {
    var left = cljs.core.first(arglist__6768);
    var top = cljs.core.first(cljs.core.next(arglist__6768));
    var html = cljs.core.first(cljs.core.next(cljs.core.next(arglist__6768)));
    var p__6757 = cljs.core.rest(cljs.core.next(cljs.core.next(arglist__6768)));
    return show_BANG___delegate(left, top, html, p__6757)
  };
  show_BANG_.cljs$lang$arity$variadic = show_BANG___delegate;
  return show_BANG_
}();
cljs_d3.tooltip.hide_BANG_ = function hide_BANG_() {
  return goog.style.showElement(goog.dom.getElement(cljs_d3.tooltip.tooltip_id), false)
};
goog.provide("clojure.string");
goog.require("cljs.core");
goog.require("goog.string.StringBuffer");
goog.require("goog.string");
clojure.string.seq_reverse = function seq_reverse(coll) {
  return cljs.core.reduce.call(null, cljs.core.conj, cljs.core.List.EMPTY, coll)
};
clojure.string.reverse = function reverse(s) {
  return s.split("").reverse().join("")
};
clojure.string.replace = function replace(s, match, replacement) {
  if(cljs.core.string_QMARK_.call(null, match)) {
    return s.replace(new RegExp(goog.string.regExpEscape(match), "g"), replacement)
  }else {
    if(cljs.core.truth_(match.hasOwnProperty("source"))) {
      return s.replace(new RegExp(match.source, "g"), replacement)
    }else {
      if("\ufdd0'else") {
        throw[cljs.core.str("Invalid match arg: "), cljs.core.str(match)].join("");
      }else {
        return null
      }
    }
  }
};
clojure.string.replace_first = function replace_first(s, match, replacement) {
  return s.replace(match, replacement)
};
clojure.string.join = function() {
  var join = null;
  var join__1 = function(coll) {
    return cljs.core.apply.call(null, cljs.core.str, coll)
  };
  var join__2 = function(separator, coll) {
    return cljs.core.apply.call(null, cljs.core.str, cljs.core.interpose.call(null, separator, coll))
  };
  join = function(separator, coll) {
    switch(arguments.length) {
      case 1:
        return join__1.call(this, separator);
      case 2:
        return join__2.call(this, separator, coll)
    }
    throw"Invalid arity: " + arguments.length;
  };
  join.cljs$lang$arity$1 = join__1;
  join.cljs$lang$arity$2 = join__2;
  return join
}();
clojure.string.upper_case = function upper_case(s) {
  return s.toUpperCase()
};
clojure.string.lower_case = function lower_case(s) {
  return s.toLowerCase()
};
clojure.string.capitalize = function capitalize(s) {
  if(cljs.core.count.call(null, s) < 2) {
    return clojure.string.upper_case.call(null, s)
  }else {
    return[cljs.core.str(clojure.string.upper_case.call(null, cljs.core.subs.call(null, s, 0, 1))), cljs.core.str(clojure.string.lower_case.call(null, cljs.core.subs.call(null, s, 1)))].join("")
  }
};
clojure.string.split = function() {
  var split = null;
  var split__2 = function(s, re) {
    return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
  };
  var split__3 = function(s, re, limit) {
    if(limit < 1) {
      return cljs.core.vec.call(null, [cljs.core.str(s)].join("").split(re))
    }else {
      var s__10715 = s;
      var limit__10716 = limit;
      var parts__10717 = cljs.core.PersistentVector.EMPTY;
      while(true) {
        if(cljs.core._EQ_.call(null, limit__10716, 1)) {
          return cljs.core.conj.call(null, parts__10717, s__10715)
        }else {
          var temp__3971__auto____10718 = cljs.core.re_find.call(null, re, s__10715);
          if(cljs.core.truth_(temp__3971__auto____10718)) {
            var m__10719 = temp__3971__auto____10718;
            var index__10720 = s__10715.indexOf(m__10719);
            var G__10721 = s__10715.substring(index__10720 + cljs.core.count.call(null, m__10719));
            var G__10722 = limit__10716 - 1;
            var G__10723 = cljs.core.conj.call(null, parts__10717, s__10715.substring(0, index__10720));
            s__10715 = G__10721;
            limit__10716 = G__10722;
            parts__10717 = G__10723;
            continue
          }else {
            return cljs.core.conj.call(null, parts__10717, s__10715)
          }
        }
        break
      }
    }
  };
  split = function(s, re, limit) {
    switch(arguments.length) {
      case 2:
        return split__2.call(this, s, re);
      case 3:
        return split__3.call(this, s, re, limit)
    }
    throw"Invalid arity: " + arguments.length;
  };
  split.cljs$lang$arity$2 = split__2;
  split.cljs$lang$arity$3 = split__3;
  return split
}();
clojure.string.split_lines = function split_lines(s) {
  return clojure.string.split.call(null, s, /\n|\r\n/)
};
clojure.string.trim = function trim(s) {
  return goog.string.trim(s)
};
clojure.string.triml = function triml(s) {
  return goog.string.trimLeft(s)
};
clojure.string.trimr = function trimr(s) {
  return goog.string.trimRight(s)
};
clojure.string.trim_newline = function trim_newline(s) {
  var index__10727 = s.length;
  while(true) {
    if(index__10727 === 0) {
      return""
    }else {
      var ch__10728 = cljs.core._lookup.call(null, s, index__10727 - 1, null);
      if(function() {
        var or__3824__auto____10729 = cljs.core._EQ_.call(null, ch__10728, "\n");
        if(or__3824__auto____10729) {
          return or__3824__auto____10729
        }else {
          return cljs.core._EQ_.call(null, ch__10728, "\r")
        }
      }()) {
        var G__10730 = index__10727 - 1;
        index__10727 = G__10730;
        continue
      }else {
        return s.substring(0, index__10727)
      }
    }
    break
  }
};
clojure.string.blank_QMARK_ = function blank_QMARK_(s) {
  var s__10734 = [cljs.core.str(s)].join("");
  if(cljs.core.truth_(function() {
    var or__3824__auto____10735 = cljs.core.not.call(null, s__10734);
    if(or__3824__auto____10735) {
      return or__3824__auto____10735
    }else {
      var or__3824__auto____10736 = cljs.core._EQ_.call(null, "", s__10734);
      if(or__3824__auto____10736) {
        return or__3824__auto____10736
      }else {
        return cljs.core.re_matches.call(null, /\s+/, s__10734)
      }
    }
  }())) {
    return true
  }else {
    return false
  }
};
clojure.string.escape = function escape(s, cmap) {
  var buffer__10743 = new goog.string.StringBuffer;
  var length__10744 = s.length;
  var index__10745 = 0;
  while(true) {
    if(cljs.core._EQ_.call(null, length__10744, index__10745)) {
      return buffer__10743.toString()
    }else {
      var ch__10746 = s.charAt(index__10745);
      var temp__3971__auto____10747 = cljs.core._lookup.call(null, cmap, ch__10746, null);
      if(cljs.core.truth_(temp__3971__auto____10747)) {
        var replacement__10748 = temp__3971__auto____10747;
        buffer__10743.append([cljs.core.str(replacement__10748)].join(""))
      }else {
        buffer__10743.append(ch__10746)
      }
      var G__10749 = index__10745 + 1;
      index__10745 = G__10749;
      continue
    }
    break
  }
};
goog.provide("cljs_d3.interop");
goog.require("cljs.core");
cljs_d3.interop.clj__GT_js = function clj__GT_js(x) {
  if(cljs.core.string_QMARK_.call(null, x)) {
    return x
  }else {
    if(cljs.core.keyword_QMARK_.call(null, x)) {
      return cljs.core.name.call(null, x)
    }else {
      if(cljs.core.map_QMARK_.call(null, x)) {
        return cljs.core.reduce.call(null, function(m, p__6732) {
          var vec__6733__6734 = p__6732;
          var k__6735 = cljs.core.nth.call(null, vec__6733__6734, 0, null);
          var v__6736 = cljs.core.nth.call(null, vec__6733__6734, 1, null);
          return cljs.core.assoc.call(null, m, clj__GT_js.call(null, k__6735), clj__GT_js.call(null, v__6736))
        }, cljs.core.ObjMap.EMPTY, x).strobj
      }else {
        if(cljs.core.coll_QMARK_.call(null, x)) {
          return cljs.core.apply.call(null, cljs.core.array, cljs.core.map.call(null, clj__GT_js, x))
        }else {
          if("\ufdd0'else") {
            return x
          }else {
            return null
          }
        }
      }
    }
  }
};
cljs_d3.interop.js_arr = function() {
  var js_arr = null;
  var js_arr__1 = function(sequ) {
    return cljs_d3.interop.clj__GT_js.call(null, sequ)
  };
  var js_arr__2 = function(sequ, else$) {
    if(cljs.core.seq.call(null, sequ)) {
      return js_arr.call(null, sequ)
    }else {
      return else$
    }
  };
  js_arr = function(sequ, else$) {
    switch(arguments.length) {
      case 1:
        return js_arr__1.call(this, sequ);
      case 2:
        return js_arr__2.call(this, sequ, else$)
    }
    throw"Invalid arity: " + arguments.length;
  };
  js_arr.cljs$lang$arity$1 = js_arr__1;
  js_arr.cljs$lang$arity$2 = js_arr__2;
  return js_arr
}();
goog.provide("cljs_d3.core");
goog.require("cljs.core");
goog.require("clojure.string");
goog.require("cljs_d3.interop");
cljs_d3.core.kstr = function kstr(k) {
  if(cljs.core.keyword_QMARK_.call(null, k)) {
    return cljs.core.name.call(null, k)
  }else {
    return k
  }
};
cljs_d3.core.pxstr = function pxstr(v) {
  if(cljs.core.number_QMARK_.call(null, v)) {
    return[cljs.core.str(v), cljs.core.str("px")].join("")
  }else {
    return v
  }
};
cljs_d3.core.jsArr_QMARK_ = function jsArr_QMARK_(x) {
  return!(x.length() == null)
};
cljs_d3.core.p = function p(x) {
  console.log(cljs.core.sequential_QMARK_.call(null, x) ? cljs_d3.interop.clj__GT_js.call(null, x) : cljs.core.map_QMARK_.call(null, x) ? cljs_d3.interop.clj__GT_js.call(null, x) : "\ufdd0'else" ? x : null);
  return x
};
cljs_d3.core.d3 = d3;
cljs_d3.core.event = function event() {
  return d3.event()
};
cljs_d3.core.select = function() {
  var select = null;
  var select__1 = function(sel__6296__auto__) {
    return sel__6296__auto__.select()
  };
  var select__2 = function(sel__6296__auto__, a1__6297__auto__) {
    return sel__6296__auto__.select(a1__6297__auto__)
  };
  var select__3 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__) {
    return sel__6296__auto__.select(a1__6297__auto__, a2__6298__auto__)
  };
  var select__4 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    return sel__6296__auto__.select(a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
  };
  select = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    switch(arguments.length) {
      case 1:
        return select__1.call(this, sel__6296__auto__);
      case 2:
        return select__2.call(this, sel__6296__auto__, a1__6297__auto__);
      case 3:
        return select__3.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__);
      case 4:
        return select__4.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  select.cljs$lang$arity$1 = select__1;
  select.cljs$lang$arity$2 = select__2;
  select.cljs$lang$arity$3 = select__3;
  select.cljs$lang$arity$4 = select__4;
  return select
}();
cljs_d3.core.selectAll = function() {
  var selectAll = null;
  var selectAll__1 = function(sel__6296__auto__) {
    return sel__6296__auto__.selectAll()
  };
  var selectAll__2 = function(sel__6296__auto__, a1__6297__auto__) {
    return sel__6296__auto__.selectAll(a1__6297__auto__)
  };
  var selectAll__3 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__) {
    return sel__6296__auto__.selectAll(a1__6297__auto__, a2__6298__auto__)
  };
  var selectAll__4 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    return sel__6296__auto__.selectAll(a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
  };
  selectAll = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    switch(arguments.length) {
      case 1:
        return selectAll__1.call(this, sel__6296__auto__);
      case 2:
        return selectAll__2.call(this, sel__6296__auto__, a1__6297__auto__);
      case 3:
        return selectAll__3.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__);
      case 4:
        return selectAll__4.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  selectAll.cljs$lang$arity$1 = selectAll__1;
  selectAll.cljs$lang$arity$2 = selectAll__2;
  selectAll.cljs$lang$arity$3 = selectAll__3;
  selectAll.cljs$lang$arity$4 = selectAll__4;
  return selectAll
}();
cljs_d3.core.classed = function() {
  var classed = null;
  var classed__1 = function(sel__6296__auto__) {
    return sel__6296__auto__.classed()
  };
  var classed__2 = function(sel__6296__auto__, a1__6297__auto__) {
    return sel__6296__auto__.classed(a1__6297__auto__)
  };
  var classed__3 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__) {
    return sel__6296__auto__.classed(a1__6297__auto__, a2__6298__auto__)
  };
  var classed__4 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    return sel__6296__auto__.classed(a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
  };
  classed = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    switch(arguments.length) {
      case 1:
        return classed__1.call(this, sel__6296__auto__);
      case 2:
        return classed__2.call(this, sel__6296__auto__, a1__6297__auto__);
      case 3:
        return classed__3.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__);
      case 4:
        return classed__4.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  classed.cljs$lang$arity$1 = classed__1;
  classed.cljs$lang$arity$2 = classed__2;
  classed.cljs$lang$arity$3 = classed__3;
  classed.cljs$lang$arity$4 = classed__4;
  return classed
}();
cljs_d3.core.property = function() {
  var property = null;
  var property__1 = function(sel__6296__auto__) {
    return sel__6296__auto__.property()
  };
  var property__2 = function(sel__6296__auto__, a1__6297__auto__) {
    return sel__6296__auto__.property(a1__6297__auto__)
  };
  var property__3 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__) {
    return sel__6296__auto__.property(a1__6297__auto__, a2__6298__auto__)
  };
  var property__4 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    return sel__6296__auto__.property(a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
  };
  property = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    switch(arguments.length) {
      case 1:
        return property__1.call(this, sel__6296__auto__);
      case 2:
        return property__2.call(this, sel__6296__auto__, a1__6297__auto__);
      case 3:
        return property__3.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__);
      case 4:
        return property__4.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  property.cljs$lang$arity$1 = property__1;
  property.cljs$lang$arity$2 = property__2;
  property.cljs$lang$arity$3 = property__3;
  property.cljs$lang$arity$4 = property__4;
  return property
}();
cljs_d3.core.text = function() {
  var text = null;
  var text__1 = function(sel__6296__auto__) {
    return sel__6296__auto__.text()
  };
  var text__2 = function(sel__6296__auto__, a1__6297__auto__) {
    return sel__6296__auto__.text(a1__6297__auto__)
  };
  var text__3 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__) {
    return sel__6296__auto__.text(a1__6297__auto__, a2__6298__auto__)
  };
  var text__4 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    return sel__6296__auto__.text(a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
  };
  text = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    switch(arguments.length) {
      case 1:
        return text__1.call(this, sel__6296__auto__);
      case 2:
        return text__2.call(this, sel__6296__auto__, a1__6297__auto__);
      case 3:
        return text__3.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__);
      case 4:
        return text__4.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  text.cljs$lang$arity$1 = text__1;
  text.cljs$lang$arity$2 = text__2;
  text.cljs$lang$arity$3 = text__3;
  text.cljs$lang$arity$4 = text__4;
  return text
}();
cljs_d3.core.html = function() {
  var html = null;
  var html__1 = function(sel__6296__auto__) {
    return sel__6296__auto__.html()
  };
  var html__2 = function(sel__6296__auto__, a1__6297__auto__) {
    return sel__6296__auto__.html(a1__6297__auto__)
  };
  var html__3 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__) {
    return sel__6296__auto__.html(a1__6297__auto__, a2__6298__auto__)
  };
  var html__4 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    return sel__6296__auto__.html(a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
  };
  html = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    switch(arguments.length) {
      case 1:
        return html__1.call(this, sel__6296__auto__);
      case 2:
        return html__2.call(this, sel__6296__auto__, a1__6297__auto__);
      case 3:
        return html__3.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__);
      case 4:
        return html__4.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  html.cljs$lang$arity$1 = html__1;
  html.cljs$lang$arity$2 = html__2;
  html.cljs$lang$arity$3 = html__3;
  html.cljs$lang$arity$4 = html__4;
  return html
}();
cljs_d3.core.node = function() {
  var node = null;
  var node__1 = function(sel__6296__auto__) {
    return sel__6296__auto__.node()
  };
  var node__2 = function(sel__6296__auto__, a1__6297__auto__) {
    return sel__6296__auto__.node(a1__6297__auto__)
  };
  var node__3 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__) {
    return sel__6296__auto__.node(a1__6297__auto__, a2__6298__auto__)
  };
  var node__4 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    return sel__6296__auto__.node(a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
  };
  node = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    switch(arguments.length) {
      case 1:
        return node__1.call(this, sel__6296__auto__);
      case 2:
        return node__2.call(this, sel__6296__auto__, a1__6297__auto__);
      case 3:
        return node__3.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__);
      case 4:
        return node__4.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  node.cljs$lang$arity$1 = node__1;
  node.cljs$lang$arity$2 = node__2;
  node.cljs$lang$arity$3 = node__3;
  node.cljs$lang$arity$4 = node__4;
  return node
}();
cljs_d3.core.call = function() {
  var call = null;
  var call__1 = function(sel__6296__auto__) {
    return sel__6296__auto__.call()
  };
  var call__2 = function(sel__6296__auto__, a1__6297__auto__) {
    return sel__6296__auto__.call(a1__6297__auto__)
  };
  var call__3 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__) {
    return sel__6296__auto__.call(a1__6297__auto__, a2__6298__auto__)
  };
  var call__4 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    return sel__6296__auto__.call(a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
  };
  call = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    switch(arguments.length) {
      case 1:
        return call__1.call(this, sel__6296__auto__);
      case 2:
        return call__2.call(this, sel__6296__auto__, a1__6297__auto__);
      case 3:
        return call__3.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__);
      case 4:
        return call__4.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  call.cljs$lang$arity$1 = call__1;
  call.cljs$lang$arity$2 = call__2;
  call.cljs$lang$arity$3 = call__3;
  call.cljs$lang$arity$4 = call__4;
  return call
}();
cljs_d3.core.each = function() {
  var each = null;
  var each__1 = function(sel__6296__auto__) {
    return sel__6296__auto__.each()
  };
  var each__2 = function(sel__6296__auto__, a1__6297__auto__) {
    return sel__6296__auto__.each(a1__6297__auto__)
  };
  var each__3 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__) {
    return sel__6296__auto__.each(a1__6297__auto__, a2__6298__auto__)
  };
  var each__4 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    return sel__6296__auto__.each(a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
  };
  each = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    switch(arguments.length) {
      case 1:
        return each__1.call(this, sel__6296__auto__);
      case 2:
        return each__2.call(this, sel__6296__auto__, a1__6297__auto__);
      case 3:
        return each__3.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__);
      case 4:
        return each__4.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  each.cljs$lang$arity$1 = each__1;
  each.cljs$lang$arity$2 = each__2;
  each.cljs$lang$arity$3 = each__3;
  each.cljs$lang$arity$4 = each__4;
  return each
}();
cljs_d3.core.insert = function() {
  var insert = null;
  var insert__1 = function(sel__6296__auto__) {
    return sel__6296__auto__.insert()
  };
  var insert__2 = function(sel__6296__auto__, a1__6297__auto__) {
    return sel__6296__auto__.insert(a1__6297__auto__)
  };
  var insert__3 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__) {
    return sel__6296__auto__.insert(a1__6297__auto__, a2__6298__auto__)
  };
  var insert__4 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    return sel__6296__auto__.insert(a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
  };
  insert = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    switch(arguments.length) {
      case 1:
        return insert__1.call(this, sel__6296__auto__);
      case 2:
        return insert__2.call(this, sel__6296__auto__, a1__6297__auto__);
      case 3:
        return insert__3.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__);
      case 4:
        return insert__4.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  insert.cljs$lang$arity$1 = insert__1;
  insert.cljs$lang$arity$2 = insert__2;
  insert.cljs$lang$arity$3 = insert__3;
  insert.cljs$lang$arity$4 = insert__4;
  return insert
}();
cljs_d3.core.remove = function() {
  var remove = null;
  var remove__1 = function(sel__6296__auto__) {
    return sel__6296__auto__.remove()
  };
  var remove__2 = function(sel__6296__auto__, a1__6297__auto__) {
    return sel__6296__auto__.remove(a1__6297__auto__)
  };
  var remove__3 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__) {
    return sel__6296__auto__.remove(a1__6297__auto__, a2__6298__auto__)
  };
  var remove__4 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    return sel__6296__auto__.remove(a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
  };
  remove = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    switch(arguments.length) {
      case 1:
        return remove__1.call(this, sel__6296__auto__);
      case 2:
        return remove__2.call(this, sel__6296__auto__, a1__6297__auto__);
      case 3:
        return remove__3.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__);
      case 4:
        return remove__4.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  remove.cljs$lang$arity$1 = remove__1;
  remove.cljs$lang$arity$2 = remove__2;
  remove.cljs$lang$arity$3 = remove__3;
  remove.cljs$lang$arity$4 = remove__4;
  return remove
}();
cljs_d3.core.on = function() {
  var on = null;
  var on__1 = function(sel__6296__auto__) {
    return sel__6296__auto__.on()
  };
  var on__2 = function(sel__6296__auto__, a1__6297__auto__) {
    return sel__6296__auto__.on(a1__6297__auto__)
  };
  var on__3 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__) {
    return sel__6296__auto__.on(a1__6297__auto__, a2__6298__auto__)
  };
  var on__4 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    return sel__6296__auto__.on(a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
  };
  on = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    switch(arguments.length) {
      case 1:
        return on__1.call(this, sel__6296__auto__);
      case 2:
        return on__2.call(this, sel__6296__auto__, a1__6297__auto__);
      case 3:
        return on__3.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__);
      case 4:
        return on__4.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  on.cljs$lang$arity$1 = on__1;
  on.cljs$lang$arity$2 = on__2;
  on.cljs$lang$arity$3 = on__3;
  on.cljs$lang$arity$4 = on__4;
  return on
}();
cljs_d3.core.enter = function() {
  var enter = null;
  var enter__1 = function(sel__6296__auto__) {
    return sel__6296__auto__.enter()
  };
  var enter__2 = function(sel__6296__auto__, a1__6297__auto__) {
    return sel__6296__auto__.enter(a1__6297__auto__)
  };
  var enter__3 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__) {
    return sel__6296__auto__.enter(a1__6297__auto__, a2__6298__auto__)
  };
  var enter__4 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    return sel__6296__auto__.enter(a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
  };
  enter = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    switch(arguments.length) {
      case 1:
        return enter__1.call(this, sel__6296__auto__);
      case 2:
        return enter__2.call(this, sel__6296__auto__, a1__6297__auto__);
      case 3:
        return enter__3.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__);
      case 4:
        return enter__4.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  enter.cljs$lang$arity$1 = enter__1;
  enter.cljs$lang$arity$2 = enter__2;
  enter.cljs$lang$arity$3 = enter__3;
  enter.cljs$lang$arity$4 = enter__4;
  return enter
}();
cljs_d3.core.exit = function() {
  var exit = null;
  var exit__1 = function(sel__6296__auto__) {
    return sel__6296__auto__.exit()
  };
  var exit__2 = function(sel__6296__auto__, a1__6297__auto__) {
    return sel__6296__auto__.exit(a1__6297__auto__)
  };
  var exit__3 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__) {
    return sel__6296__auto__.exit(a1__6297__auto__, a2__6298__auto__)
  };
  var exit__4 = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    return sel__6296__auto__.exit(a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
  };
  exit = function(sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__) {
    switch(arguments.length) {
      case 1:
        return exit__1.call(this, sel__6296__auto__);
      case 2:
        return exit__2.call(this, sel__6296__auto__, a1__6297__auto__);
      case 3:
        return exit__3.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__);
      case 4:
        return exit__4.call(this, sel__6296__auto__, a1__6297__auto__, a2__6298__auto__, a3__6299__auto__)
    }
    throw"Invalid arity: " + arguments.length;
  };
  exit.cljs$lang$arity$1 = exit__1;
  exit.cljs$lang$arity$2 = exit__2;
  exit.cljs$lang$arity$3 = exit__3;
  exit.cljs$lang$arity$4 = exit__4;
  return exit
}();
cljs_d3.core.ns_abbv = function ns_abbv(namespace_uri) {
  var pred__6554__6557 = cljs.core._EQ_;
  var expr__6555__6558 = namespace_uri;
  if(pred__6554__6557.call(null, "http://www.w3.org/2000/svg", expr__6555__6558)) {
    return"\ufdd0'svg"
  }else {
    if(pred__6554__6557.call(null, "http://www.w3.org/1999/xhtml", expr__6555__6558)) {
      return"\ufdd0'xhtml"
    }else {
      if(pred__6554__6557.call(null, "http://www.w3.org/1999/xlink", expr__6555__6558)) {
        return"\ufdd0'xlink"
      }else {
        if(pred__6554__6557.call(null, "http://www.w3.org/XML/1998/namespace", expr__6555__6558)) {
          return"\ufdd0'xml"
        }else {
          if(pred__6554__6557.call(null, "http://www.w3.org/2000/xmlns/", expr__6555__6558)) {
            return"\ufdd0'xmlns"
          }else {
            throw[cljs.core.str("No abbreviation for namespace-uri "), cljs.core.str(namespace_uri)].join("");
          }
        }
      }
    }
  }
};
cljs_d3.core.append_node = function append_node(sel, child) {
  cljs_d3.core.node.call(null, sel).appendChild(child);
  return cljs_d3.core.select.call(null, cljs_d3.core.d3, child)
};
cljs_d3.core.append_svg = function append_svg(sel) {
  return sel.append("svg:svg").attr("xmlns", "http://www.w3.org/2000/svg").attr("xmlns:xmlns:ev", "http://www.w3.org/2001/xml-events").attr("xmlns:xmlns:xlink", "http://www.w3.org/1999/xlink")
};
cljs_d3.core.attr = function() {
  var attr = null;
  var attr__2 = function(sel, x) {
    if(cljs.core.map_QMARK_.call(null, x)) {
      var G__6578__6579 = cljs.core.seq.call(null, x);
      if(G__6578__6579) {
        var G__6581__6583 = cljs.core.first.call(null, G__6578__6579);
        var vec__6582__6584 = G__6581__6583;
        var k__6585 = cljs.core.nth.call(null, vec__6582__6584, 0, null);
        var v__6586 = cljs.core.nth.call(null, vec__6582__6584, 1, null);
        var G__6578__6587 = G__6578__6579;
        var G__6581__6588 = G__6581__6583;
        var G__6578__6589 = G__6578__6587;
        while(true) {
          var vec__6590__6591 = G__6581__6588;
          var k__6592 = cljs.core.nth.call(null, vec__6590__6591, 0, null);
          var v__6593 = cljs.core.nth.call(null, vec__6590__6591, 1, null);
          var G__6578__6594 = G__6578__6589;
          sel.attr(cljs_d3.core.kstr.call(null, k__6592), v__6593);
          var temp__3974__auto____6595 = cljs.core.next.call(null, G__6578__6594);
          if(temp__3974__auto____6595) {
            var G__6578__6596 = temp__3974__auto____6595;
            var G__6597 = cljs.core.first.call(null, G__6578__6596);
            var G__6598 = G__6578__6596;
            G__6581__6588 = G__6597;
            G__6578__6589 = G__6598;
            continue
          }else {
          }
          break
        }
      }else {
      }
    }else {
      sel.attr(x)
    }
    return sel
  };
  var attr__3 = function(sel, k, v) {
    return sel.attr(cljs_d3.core.kstr.call(null, k), v)
  };
  attr = function(sel, k, v) {
    switch(arguments.length) {
      case 2:
        return attr__2.call(this, sel, k);
      case 3:
        return attr__3.call(this, sel, k, v)
    }
    throw"Invalid arity: " + arguments.length;
  };
  attr.cljs$lang$arity$2 = attr__2;
  attr.cljs$lang$arity$3 = attr__3;
  return attr
}();
cljs_d3.core.style = function() {
  var style = null;
  var style__2 = function(sel, x) {
    if(cljs.core.map_QMARK_.call(null, x)) {
      var G__6619__6620 = cljs.core.seq.call(null, x);
      if(G__6619__6620) {
        var G__6622__6624 = cljs.core.first.call(null, G__6619__6620);
        var vec__6623__6625 = G__6622__6624;
        var k__6626 = cljs.core.nth.call(null, vec__6623__6625, 0, null);
        var v__6627 = cljs.core.nth.call(null, vec__6623__6625, 1, null);
        var G__6619__6628 = G__6619__6620;
        var G__6622__6629 = G__6622__6624;
        var G__6619__6630 = G__6619__6628;
        while(true) {
          var vec__6631__6632 = G__6622__6629;
          var k__6633 = cljs.core.nth.call(null, vec__6631__6632, 0, null);
          var v__6634 = cljs.core.nth.call(null, vec__6631__6632, 1, null);
          var G__6619__6635 = G__6619__6630;
          sel.style(cljs_d3.core.kstr.call(null, k__6633), cljs_d3.core.pxstr.call(null, v__6634));
          var temp__3974__auto____6636 = cljs.core.next.call(null, G__6619__6635);
          if(temp__3974__auto____6636) {
            var G__6619__6637 = temp__3974__auto____6636;
            var G__6638 = cljs.core.first.call(null, G__6619__6637);
            var G__6639 = G__6619__6637;
            G__6622__6629 = G__6638;
            G__6619__6630 = G__6639;
            continue
          }else {
          }
          break
        }
      }else {
      }
    }else {
      sel.style(cljs_d3.core.pxstr.call(null, x))
    }
    return sel
  };
  var style__3 = function(sel, k, v) {
    return sel.style(cljs_d3.core.kstr.call(null, k), cljs_d3.core.pxstr.call(null, v))
  };
  style = function(sel, k, v) {
    switch(arguments.length) {
      case 2:
        return style__2.call(this, sel, k);
      case 3:
        return style__3.call(this, sel, k, v)
    }
    throw"Invalid arity: " + arguments.length;
  };
  style.cljs$lang$arity$2 = style__2;
  style.cljs$lang$arity$3 = style__3;
  return style
}();
cljs_d3.core.data = function data(sel, x) {
  return sel.data(cljs.core.fn_QMARK_.call(null, x) ? function() {
    var G__6640__delegate = function(rest__6599_SHARP_) {
      return cljs_d3.interop.clj__GT_js.call(null, cljs.core.apply.call(null, x, rest__6599_SHARP_))
    };
    var G__6640 = function(var_args) {
      var rest__6599_SHARP_ = null;
      if(goog.isDef(var_args)) {
        rest__6599_SHARP_ = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
      }
      return G__6640__delegate.call(this, rest__6599_SHARP_)
    };
    G__6640.cljs$lang$maxFixedArity = 0;
    G__6640.cljs$lang$applyTo = function(arglist__6641) {
      var rest__6599_SHARP_ = cljs.core.seq(arglist__6641);
      return G__6640__delegate(rest__6599_SHARP_)
    };
    G__6640.cljs$lang$arity$variadic = G__6640__delegate;
    return G__6640
  }() : cljs_d3.interop.clj__GT_js.call(null, x))
};
cljs_d3.core.transition = function() {
  var transition__delegate = function(sel, p__6642) {
    var map__6648__6649 = p__6642;
    var map__6648__6650 = cljs.core.seq_QMARK_.call(null, map__6648__6649) ? cljs.core.apply.call(null, cljs.core.hash_map, map__6648__6649) : map__6648__6649;
    var delay__6651 = cljs.core._lookup.call(null, map__6648__6650, "\ufdd0'delay", 0);
    var duration__6652 = cljs.core._lookup.call(null, map__6648__6650, "\ufdd0'duration", 250);
    return sel.transition().duration(duration__6652).delay(delay__6651)
  };
  var transition = function(sel, var_args) {
    var p__6642 = null;
    if(goog.isDef(var_args)) {
      p__6642 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return transition__delegate.call(this, sel, p__6642)
  };
  transition.cljs$lang$maxFixedArity = 1;
  transition.cljs$lang$applyTo = function(arglist__6653) {
    var sel = cljs.core.first(arglist__6653);
    var p__6642 = cljs.core.rest(arglist__6653);
    return transition__delegate(sel, p__6642)
  };
  transition.cljs$lang$arity$variadic = transition__delegate;
  return transition
}();
cljs_d3.core.append = function append(sel, node_type, attr_map) {
  var new_el__6664 = cljs.core._EQ_.call(null, "\ufdd0'svg", node_type) ? cljs_d3.core.append_svg.call(null, sel) : cljs.core.truth_(node_type.nodeName()) ? cljs_d3.core.append_node.call(null, sel, node_type) : true ? function() {
    var vec__6660__6661 = cljs.core.truth_(cljs.core.re_find.call(null, /:/, node_type)) ? clojure.string.split.call(null, node_type, /:/, 2) : cljs.core.truth_(sel.node()) ? cljs.core.PersistentVector.fromArray([cljs_d3.core.ns_abbv.call(null, sel.node().namespaceURI()), node_type], true) : true ? cljs.core.PersistentVector.fromArray([null, node_type], true) : null;
    var namespace__6662 = cljs.core.nth.call(null, vec__6660__6661, 0, null);
    var nt__6663 = cljs.core.nth.call(null, vec__6660__6661, 1, null);
    return sel.append(namespace__6662 == null ? nt__6663 : [cljs.core.str(cljs.core.name.call(null, namespace__6662)), cljs.core.str(":"), cljs.core.str(nt__6663)].join(""))
  }() : null;
  return cljs_d3.core.attr.call(null, new_el__6664, function() {
    var or__3824__auto____6665 = attr_map;
    if(cljs.core.truth_(or__3824__auto____6665)) {
      return or__3824__auto____6665
    }else {
      return cljs.core.ObjMap.EMPTY
    }
  }())
};
cljs_d3.core.append_STAR_ = function append_STAR_(sel, node_type, attr_map) {
  cljs_d3.core.append.call(null, sel, node_type, attr_map);
  return sel
};
cljs_d3.core.make_last_child = function make_last_child(el) {
  return el.parentNode().appendChild(el)
};
cljs_d3.core.min_max = function() {
  var min_max__delegate = function(data, p__6666) {
    var map__6672__6673 = p__6666;
    var map__6672__6674 = cljs.core.seq_QMARK_.call(null, map__6672__6673) ? cljs.core.apply.call(null, cljs.core.hash_map, map__6672__6673) : map__6672__6673;
    var dimension__6675 = cljs.core._lookup.call(null, map__6672__6674, "\ufdd0'dimension", null);
    var vals__6676 = cljs.core.truth_(dimension__6675) ? cljs.core.map.call(null, dimension__6675, data) : data;
    return cljs.core.PersistentVector.fromArray([cljs.core.apply.call(null, cljs.core.min, vals__6676), cljs.core.apply.call(null, cljs.core.max, vals__6676)], true)
  };
  var min_max = function(data, var_args) {
    var p__6666 = null;
    if(goog.isDef(var_args)) {
      p__6666 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return min_max__delegate.call(this, data, p__6666)
  };
  min_max.cljs$lang$maxFixedArity = 1;
  min_max.cljs$lang$applyTo = function(arglist__6677) {
    var data = cljs.core.first(arglist__6677);
    var p__6666 = cljs.core.rest(arglist__6677);
    return min_max__delegate(data, p__6666)
  };
  min_max.cljs$lang$arity$variadic = min_max__delegate;
  return min_max
}();
cljs_d3.core.min_0_max = function() {
  var min_0_max__delegate = function(data, p__6678) {
    var map__6684__6685 = p__6678;
    var map__6684__6686 = cljs.core.seq_QMARK_.call(null, map__6684__6685) ? cljs.core.apply.call(null, cljs.core.hash_map, map__6684__6685) : map__6684__6685;
    var dimension__6687 = cljs.core._lookup.call(null, map__6684__6686, "\ufdd0'dimension", null);
    var mm__6688 = cljs_d3.core.min_max.call(null, data, "\ufdd0'dimension", dimension__6687);
    return cljs.core.PersistentVector.fromArray([cljs.core.nth.call(null, mm__6688, 0), 0, cljs.core.nth.call(null, mm__6688, 1)], true)
  };
  var min_0_max = function(data, var_args) {
    var p__6678 = null;
    if(goog.isDef(var_args)) {
      p__6678 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return min_0_max__delegate.call(this, data, p__6678)
  };
  min_0_max.cljs$lang$maxFixedArity = 1;
  min_0_max.cljs$lang$applyTo = function(arglist__6689) {
    var data = cljs.core.first(arglist__6689);
    var p__6678 = cljs.core.rest(arglist__6689);
    return min_0_max__delegate(data, p__6678)
  };
  min_0_max.cljs$lang$arity$variadic = min_0_max__delegate;
  return min_0_max
}();
cljs_d3.core.avg = function() {
  var avg__delegate = function(data, p__6691) {
    var map__6697__6698 = p__6691;
    var map__6697__6699 = cljs.core.seq_QMARK_.call(null, map__6697__6698) ? cljs.core.apply.call(null, cljs.core.hash_map, map__6697__6698) : map__6697__6698;
    var dimension__6700 = cljs.core._lookup.call(null, map__6697__6699, "\ufdd0'dimension", null);
    var vals__6701 = cljs.core.truth_(dimension__6700) ? cljs.core.map.call(null, dimension__6700, data) : data;
    return cljs.core.apply.call(null, cljs.core._PLUS_, vals__6701) / cljs.core.count.call(null, vals__6701)
  };
  var avg = function(data, var_args) {
    var p__6691 = null;
    if(goog.isDef(var_args)) {
      p__6691 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return avg__delegate.call(this, data, p__6691)
  };
  avg.cljs$lang$maxFixedArity = 1;
  avg.cljs$lang$applyTo = function(arglist__6702) {
    var data = cljs.core.first(arglist__6702);
    var p__6691 = cljs.core.rest(arglist__6702);
    return avg__delegate(data, p__6691)
  };
  avg.cljs$lang$arity$variadic = avg__delegate;
  return avg
}();
cljs_d3.core.quantile = function() {
  var quantile__delegate = function(data, p__6703) {
    var map__6715__6716 = p__6703;
    var map__6715__6717 = cljs.core.seq_QMARK_.call(null, map__6715__6716) ? cljs.core.apply.call(null, cljs.core.hash_map, map__6715__6716) : map__6715__6716;
    var probs__6718 = cljs.core._lookup.call(null, map__6715__6717, "\ufdd0'probs", cljs.core.PersistentVector.fromArray([0, 0.25, 0.5, 0.75, 1], true));
    var dimension__6719 = cljs.core._lookup.call(null, map__6715__6717, "\ufdd0'dimension", cljs.core.identity);
    var vals__6720 = cljs.core.into.call(null, cljs.core.PersistentVector.EMPTY, cljs.core.sort.call(null, cljs.core.map.call(null, dimension__6719, data)));
    var n_1__6721 = cljs.core.count.call(null, vals__6720) - 1;
    return cljs.core.map.call(null, function(p1__6690_SHARP_) {
      var index__6722 = 1 + p1__6690_SHARP_ * n_1__6721;
      var lo__6723 = Math.floor(index__6722);
      var h__6724 = index__6722 - lo__6723;
      var a__6725 = vals__6720.call(null, lo__6723 - 1);
      if(cljs.core._EQ_.call(null, h__6724, 0)) {
        return a__6725
      }else {
        return a__6725 + h__6724 * (vals__6720.call(null, lo__6723) - a__6725)
      }
    }, probs__6718)
  };
  var quantile = function(data, var_args) {
    var p__6703 = null;
    if(goog.isDef(var_args)) {
      p__6703 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return quantile__delegate.call(this, data, p__6703)
  };
  quantile.cljs$lang$maxFixedArity = 1;
  quantile.cljs$lang$applyTo = function(arglist__6726) {
    var data = cljs.core.first(arglist__6726);
    var p__6703 = cljs.core.rest(arglist__6726);
    return quantile__delegate(data, p__6703)
  };
  quantile.cljs$lang$arity$variadic = quantile__delegate;
  return quantile
}();
goog.provide("cljs_d3.svg");
goog.require("cljs.core");
goog.require("cljs_d3.core");
cljs_d3.svg.axis = function() {
  var axis__delegate = function(scale, p__6533) {
    var map__6541__6542 = p__6533;
    var map__6541__6543 = cljs.core.seq_QMARK_.call(null, map__6541__6542) ? cljs.core.apply.call(null, cljs.core.hash_map, map__6541__6542) : map__6541__6542;
    var tick_size__6544 = cljs.core._lookup.call(null, map__6541__6543, "\ufdd0'tick-size", null);
    var tick_format__6545 = cljs.core._lookup.call(null, map__6541__6543, "\ufdd0'tick-format", null);
    var ticks__6546 = cljs.core._lookup.call(null, map__6541__6543, "\ufdd0'ticks", null);
    var orient__6547 = cljs.core._lookup.call(null, map__6541__6543, "\ufdd0'orient", null);
    return function(x__6312__auto__, arg__6313__auto__) {
      if(cljs.core.truth_(arg__6313__auto__)) {
        return x__6312__auto__.tickFormat(arg__6313__auto__)
      }else {
        return x__6312__auto__
      }
    }.call(null, function(x__6312__auto__, arg__6313__auto__) {
      if(cljs.core.truth_(arg__6313__auto__)) {
        return x__6312__auto__.ticks(arg__6313__auto__)
      }else {
        return x__6312__auto__
      }
    }.call(null, function(x__6312__auto__, arg__6313__auto__) {
      if(cljs.core.truth_(arg__6313__auto__)) {
        return x__6312__auto__.tickSize(arg__6313__auto__)
      }else {
        return x__6312__auto__
      }
    }.call(null, function(x__6312__auto__, arg__6313__auto__) {
      if(cljs.core.truth_(arg__6313__auto__)) {
        return x__6312__auto__.orient(arg__6313__auto__)
      }else {
        return x__6312__auto__
      }
    }.call(null, cljs_d3.core.d3.svg().axis().scale(scale), orient__6547), tick_size__6544), ticks__6546), tick_format__6545)
  };
  var axis = function(scale, var_args) {
    var p__6533 = null;
    if(goog.isDef(var_args)) {
      p__6533 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1), 0)
    }
    return axis__delegate.call(this, scale, p__6533)
  };
  axis.cljs$lang$maxFixedArity = 1;
  axis.cljs$lang$applyTo = function(arglist__6548) {
    var scale = cljs.core.first(arglist__6548);
    var p__6533 = cljs.core.rest(arglist__6548);
    return axis__delegate(scale, p__6533)
  };
  axis.cljs$lang$arity$variadic = axis__delegate;
  return axis
}();
goog.provide("cljs_d3.scale");
goog.require("cljs.core");
goog.require("cljs_d3.core");
cljs_d3.scale.linear = function() {
  var linear__delegate = function(p__6737) {
    var map__6746__6747 = p__6737;
    var map__6746__6748 = cljs.core.seq_QMARK_.call(null, map__6746__6747) ? cljs.core.apply.call(null, cljs.core.hash_map, map__6746__6747) : map__6746__6747;
    var clamp__6749 = cljs.core._lookup.call(null, map__6746__6748, "\ufdd0'clamp", null);
    var range_round__6750 = cljs.core._lookup.call(null, map__6746__6748, "\ufdd0'range-round", null);
    var nice__6751 = cljs.core._lookup.call(null, map__6746__6748, "\ufdd0'nice", null);
    var range__6752 = cljs.core._lookup.call(null, map__6746__6748, "\ufdd0'range", null);
    var domain__6753 = cljs.core._lookup.call(null, map__6746__6748, "\ufdd0'domain", null);
    return function(x__6305__auto__, test__6306__auto__) {
      if(cljs.core.truth_(test__6306__auto__)) {
        return x__6305__auto__.nice()
      }else {
        return x__6305__auto__
      }
    }.call(null, function(x__6312__auto__, arg__6313__auto__) {
      if(cljs.core.truth_(arg__6313__auto__)) {
        return x__6312__auto__.clamp(arg__6313__auto__)
      }else {
        return x__6312__auto__
      }
    }.call(null, function(x__6312__auto__, arg__6313__auto__) {
      if(cljs.core.truth_(arg__6313__auto__)) {
        return x__6312__auto__.rangeRound(arg__6313__auto__)
      }else {
        return x__6312__auto__
      }
    }.call(null, d3.scale(linear.call(null)).domain(cljs_d3.core.jsArr.call(null, domain__6753)).range(cljs_d3.core.jsArr.call(null, range__6752)), cljs_d3.core.jsArr.call(null, range_round__6750, null)), clamp__6749), nice__6751)
  };
  var linear = function(var_args) {
    var p__6737 = null;
    if(goog.isDef(var_args)) {
      p__6737 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return linear__delegate.call(this, p__6737)
  };
  linear.cljs$lang$maxFixedArity = 0;
  linear.cljs$lang$applyTo = function(arglist__6754) {
    var p__6737 = cljs.core.seq(arglist__6754);
    return linear__delegate(p__6737)
  };
  linear.cljs$lang$arity$variadic = linear__delegate;
  return linear
}();
goog.provide("cljs_d3.layout");
goog.require("cljs.core");
goog.require("cljs_d3.interop");
goog.require("cljs_d3.core");
cljs_d3.layout.histogram = function() {
  var histogram__delegate = function(p__6505) {
    var map__6519__6520 = p__6505;
    var map__6519__6521 = cljs.core.seq_QMARK_.call(null, map__6519__6520) ? cljs.core.apply.call(null, cljs.core.hash_map, map__6519__6520) : map__6519__6520;
    var frequency__6522 = cljs.core._lookup.call(null, map__6519__6521, "\ufdd0'frequency", null);
    var bins__6523 = cljs.core._lookup.call(null, map__6519__6521, "\ufdd0'bins", null);
    var range__6524 = cljs.core._lookup.call(null, map__6519__6521, "\ufdd0'range", null);
    var value__6525 = cljs.core._lookup.call(null, map__6519__6521, "\ufdd0'value", null);
    var h__6526 = function(x__6312__auto__, arg__6313__auto__) {
      if(cljs.core.truth_(arg__6313__auto__)) {
        return x__6312__auto__.frequency(arg__6313__auto__)
      }else {
        return x__6312__auto__
      }
    }.call(null, function(x__6312__auto__, arg__6313__auto__) {
      if(cljs.core.truth_(arg__6313__auto__)) {
        return x__6312__auto__.bins(arg__6313__auto__)
      }else {
        return x__6312__auto__
      }
    }.call(null, function(x__6312__auto__, arg__6313__auto__) {
      if(cljs.core.truth_(arg__6313__auto__)) {
        return x__6312__auto__.range(arg__6313__auto__)
      }else {
        return x__6312__auto__
      }
    }.call(null, function(x__6312__auto__, arg__6313__auto__) {
      if(cljs.core.truth_(arg__6313__auto__)) {
        return x__6312__auto__.value(arg__6313__auto__)
      }else {
        return x__6312__auto__
      }
    }.call(null, cljs_d3.core.d3.layout().histogram(), value__6525), cljs.core.fn_QMARK_.call(null, range__6524) ? function(vals) {
      return cljs_d3.interop.js_arr.call(null, range__6524.call(null, vals), null)
    } : cljs_d3.interop.js_arr.call(null, range__6524, null)), cljs.core.number_QMARK_.call(null, bins__6523) ? bins__6523 : cljs_d3.core.js_arr.call(null, bins__6523, null)), frequency__6522);
    return function(x) {
      var pred__6527__6530 = cljs.core._EQ_;
      var expr__6528__6531 = x;
      if(pred__6527__6530.call(null, "\ufdd0'value", expr__6528__6531)) {
        return h__6526.value()
      }else {
        if(pred__6527__6530.call(null, "\ufdd0'range", expr__6528__6531)) {
          return function(p1__6196_SHARP_) {
            return h__6526.range().call(null, cljs_d3.core.jsArr.call(null, p1__6196_SHARP_))
          }
        }else {
          if(pred__6527__6530.call(null, "\ufdd0'bins", expr__6528__6531)) {
            return h__6526.bins()
          }else {
            if(pred__6527__6530.call(null, "\ufdd0'frequency", expr__6528__6531)) {
              return h__6526.frequency()
            }else {
              return h__6526.call(null, cljs_d3.core.jsArr.call(null, x))
            }
          }
        }
      }
    }
  };
  var histogram = function(var_args) {
    var p__6505 = null;
    if(goog.isDef(var_args)) {
      p__6505 = cljs.core.array_seq(Array.prototype.slice.call(arguments, 0), 0)
    }
    return histogram__delegate.call(this, p__6505)
  };
  histogram.cljs$lang$maxFixedArity = 0;
  histogram.cljs$lang$applyTo = function(arglist__6532) {
    var p__6505 = cljs.core.seq(arglist__6532);
    return histogram__delegate(p__6505)
  };
  histogram.cljs$lang$arity$variadic = histogram__delegate;
  return histogram
}();
