(ns aws.sdk.eip
  "AWS EIP support"
  (:require 
    [clojure.java.data :refer (from-java)]
    [aws.sdk.ec2 :refer (ec2-client aws-filter)])
  (:import 
    com.amazonaws.services.ec2.model.AssociateAddressRequest  
    com.amazonaws.services.ec2.model.DescribeAddressesRequest))

(defn assoc-pub-ip 
  "Associates elastic public ip to instnace"
  [cred instance-id ip]
  (.associateAddress (ec2-client cred) (AssociateAddressRequest. instance-id ip)))

(defn describe-eip
  "Returns instance Elastic IP's listing"
  [creds id] 
  (from-java
    (.describeAddresses (ec2-client creds) 
       (.withFilters (DescribeAddressesRequest.) (aws-filter "instance-id" id)))))
