(ns aws.sdk.ebs
  "EBS volume managment"
  (:require 
    [clojure.java.data :refer (from-java)]
    [aws.sdk.ec2 :refer (ec2-client)])
  (:import 
    com.amazonaws.services.ec2.model.CreateVolumeRequest
    com.amazonaws.services.ec2.model.DeleteVolumeRequest
    com.amazonaws.services.ec2.model.AttachVolumeRequest
    com.amazonaws.services.ec2.model.DetachVolumeRequest
    com.amazonaws.services.ec2.model.DescribeVolumesRequest))

(defn create-volume 
   "Creates an EBS volume, size is in GB" 
   [creds size zone]
    (-> (.createVolume (ec2-client creds) (CreateVolumeRequest. (int size) zone)) (.getVolume) bean))

(defn delete-volume 
   "Deletes an EBS volume" 
   [creds vid]
  (.deleteVolume (ec2-client creds) (DeleteVolumeRequest. vid)))

(defn attach-volume 
   "Attach an EBS volume to an instance" 
   [creds vid instance device]
    (.attachVolume (ec2-client creds) (AttachVolumeRequest. vid instance device)))

(defn detach-volume 
   "Detached a volume from a running instance" 
   [creds vid]
  (.detachVolume (ec2-client creds) (DetachVolumeRequest. vid)))

(defn attachment-status [creds vid]
  (-> (.describeVolumes (ec2-client creds) (DescribeVolumesRequest. [vid]))
     from-java :volumes first :attachments first :state))

(defn state [creds vid]
  (-> (.describeVolumes (ec2-client creds) (DescribeVolumesRequest. [vid])) from-java :volumes first :state) )
