/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.AFn;
import clojure.lang.ARef;
import clojure.lang.Associative;
import clojure.lang.IFn;
import clojure.lang.IMapEntry;
import clojure.lang.IPersistentMap;
import clojure.lang.IRef;
import clojure.lang.ISeq;
import clojure.lang.Keyword;
import clojure.lang.Namespace;
import clojure.lang.PersistentArrayMap;
import clojure.lang.PersistentHashMap;
import clojure.lang.RT;
import clojure.lang.Settable;
import clojure.lang.Symbol;
import java.util.concurrent.atomic.AtomicBoolean;

public final class Var
extends ARef
implements IFn,
IRef,
Settable {
    static final ThreadLocal<Frame> dvals = new ThreadLocal<Frame>(){

        @Override
        protected Frame initialValue() {
            return new Frame();
        }
    };
    public static volatile int rev = 0;
    static Keyword privateKey = Keyword.intern(null, "private");
    static IPersistentMap privateMeta = new PersistentArrayMap(new Object[]{privateKey, Boolean.TRUE});
    static Keyword macroKey = Keyword.intern(null, "macro");
    static Keyword nameKey = Keyword.intern(null, "name");
    static Keyword nsKey = Keyword.intern(null, "ns");
    volatile Object root;
    volatile boolean dynamic = false;
    final transient AtomicBoolean threadBound;
    public final Symbol sym;
    public final Namespace ns;
    static IFn assoc = new AFn(){

        public Object invoke(Object m, Object k, Object v) throws Exception {
            return RT.assoc(m, k, v);
        }
    };
    static IFn dissoc = new AFn(){

        public Object invoke(Object c, Object k) throws Exception {
            return RT.dissoc(c, k);
        }
    };

    public static Object getThreadBindingFrame() {
        Frame f = dvals.get();
        if (f != null) {
            return f;
        }
        return new Frame();
    }

    public static Object cloneThreadBindingFrame() {
        Frame f = dvals.get();
        if (f != null) {
            return f.clone();
        }
        return new Frame();
    }

    public static void resetThreadBindingFrame(Object frame) {
        dvals.set((Frame)frame);
    }

    public Var setDynamic() {
        this.dynamic = true;
        return this;
    }

    public Var setDynamic(boolean b) {
        this.dynamic = b;
        return this;
    }

    public final boolean isDynamic() {
        return this.dynamic;
    }

    public static Var intern(Namespace ns2, Symbol sym, Object root2) {
        return Var.intern(ns2, sym, root2, true);
    }

    public static Var intern(Namespace ns2, Symbol sym, Object root2, boolean replaceRoot) {
        Var dvout = ns2.intern(sym);
        if (!dvout.hasRoot() || replaceRoot) {
            dvout.bindRoot(root2);
        }
        return dvout;
    }

    public String toString() {
        if (this.ns != null) {
            return "#'" + this.ns.name + "/" + this.sym;
        }
        return "#<Var: " + (this.sym != null ? this.sym.toString() : "--unnamed--") + ">";
    }

    public static Var find(Symbol nsQualifiedSym) {
        if (nsQualifiedSym.ns == null) {
            throw new IllegalArgumentException("Symbol must be namespace-qualified");
        }
        Namespace ns2 = Namespace.find(Symbol.intern(nsQualifiedSym.ns));
        if (ns2 == null) {
            throw new IllegalArgumentException("No such namespace: " + nsQualifiedSym.ns);
        }
        return ns2.findInternedVar(Symbol.intern(nsQualifiedSym.name));
    }

    public static Var intern(Symbol nsName, Symbol sym) {
        Namespace ns2 = Namespace.findOrCreate(nsName);
        return Var.intern(ns2, sym);
    }

    public static Var internPrivate(String nsName, String sym) {
        Namespace ns2 = Namespace.findOrCreate(Symbol.intern(nsName));
        Var ret = Var.intern(ns2, Symbol.intern(sym));
        ret.setMeta(privateMeta);
        return ret;
    }

    public static Var intern(Namespace ns2, Symbol sym) {
        return ns2.intern(sym);
    }

    public static Var create() {
        return new Var(null, null);
    }

    public static Var create(Object root2) {
        return new Var(null, null, root2);
    }

    Var(Namespace ns2, Symbol sym) {
        this.ns = ns2;
        this.sym = sym;
        this.threadBound = new AtomicBoolean(false);
        this.root = new Unbound(this);
        this.setMeta(PersistentHashMap.EMPTY);
    }

    Var(Namespace ns2, Symbol sym, Object root2) {
        this(ns2, sym);
        this.root = root2;
        ++rev;
    }

    public boolean isBound() {
        return this.hasRoot() || this.threadBound.get() && Var.dvals.get().bindings.containsKey(this);
    }

    public final Object get() {
        if (!this.threadBound.get()) {
            return this.root;
        }
        return this.deref();
    }

    public final Object deref() {
        TBox b = this.getThreadBinding();
        if (b != null) {
            return b.val;
        }
        return this.root;
    }

    public void setValidator(IFn vf) {
        if (this.hasRoot()) {
            this.validate(vf, this.root);
        }
        this.validator = vf;
    }

    public Object alter(IFn fn2, ISeq args) throws Exception {
        this.set(fn2.applyTo(RT.cons(this.deref(), args)));
        return this;
    }

    public Object set(Object val2) {
        this.validate(this.getValidator(), val2);
        TBox b = this.getThreadBinding();
        if (b != null) {
            if (Thread.currentThread() != b.thread) {
                throw new IllegalStateException(String.format("Can't set!: %s from non-binding thread", this.sym));
            }
            b.val = val2;
            return b.val;
        }
        throw new IllegalStateException(String.format("Can't change/establish root binding of: %s with set", this.sym));
    }

    public Object doSet(Object val2) throws Exception {
        return this.set(val2);
    }

    public Object doReset(Object val2) throws Exception {
        this.bindRoot(val2);
        return val2;
    }

    public void setMeta(IPersistentMap m) {
        this.resetMeta(m.assoc(nameKey, this.sym).assoc(nsKey, this.ns));
    }

    public void setMacro() {
        try {
            this.alterMeta(assoc, RT.list(macroKey, RT.T));
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public boolean isMacro() {
        return RT.booleanCast(this.meta().valAt(macroKey));
    }

    public boolean isPublic() {
        return !RT.booleanCast(this.meta().valAt(privateKey));
    }

    public final Object getRawRoot() {
        return this.root;
    }

    public Object getTag() {
        return this.meta().valAt(RT.TAG_KEY);
    }

    public void setTag(Symbol tag) {
        try {
            this.alterMeta(assoc, RT.list(RT.TAG_KEY, tag));
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public final boolean hasRoot() {
        return !(this.root instanceof Unbound);
    }

    public synchronized void bindRoot(Object root2) {
        this.validate(this.getValidator(), root2);
        Object oldroot = this.root;
        this.root = root2;
        ++rev;
        try {
            this.alterMeta(dissoc, RT.list(macroKey));
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
        this.notifyWatches(oldroot, this.root);
    }

    synchronized void swapRoot(Object root2) {
        this.validate(this.getValidator(), root2);
        Object oldroot = this.root;
        this.root = root2;
        ++rev;
        this.notifyWatches(oldroot, root2);
    }

    public synchronized void unbindRoot() {
        this.root = new Unbound(this);
        ++rev;
    }

    public synchronized void commuteRoot(IFn fn2) throws Exception {
        Object newRoot = fn2.invoke(this.root);
        this.validate(this.getValidator(), newRoot);
        Object oldroot = this.root;
        this.root = newRoot;
        ++rev;
        this.notifyWatches(oldroot, newRoot);
    }

    public synchronized Object alterRoot(IFn fn2, ISeq args) throws Exception {
        Object newRoot = fn2.applyTo(RT.cons(this.root, args));
        this.validate(this.getValidator(), newRoot);
        Object oldroot = this.root;
        this.root = newRoot;
        ++rev;
        this.notifyWatches(oldroot, newRoot);
        return newRoot;
    }

    public static void pushThreadBindings(Associative bindings) {
        Frame f = dvals.get();
        Associative bmap = f.bindings;
        for (ISeq bs = bindings.seq(); bs != null; bs = bs.next()) {
            IMapEntry e2 = (IMapEntry)bs.first();
            Var v = (Var)e2.key();
            if (!v.dynamic) {
                throw new IllegalStateException(String.format("Can't dynamically bind non-dynamic var: %s/%s", v.ns, v.sym));
            }
            v.validate(v.getValidator(), e2.val());
            v.threadBound.set(true);
            bmap = bmap.assoc(v, new TBox(Thread.currentThread(), e2.val()));
        }
        dvals.set(new Frame(bmap, f));
    }

    public static void popThreadBindings() {
        Frame f = dvals.get();
        if (f.prev == null) {
            throw new IllegalStateException("Pop without matching push");
        }
        dvals.set(f.prev);
    }

    public static Associative getThreadBindings() {
        Frame f = dvals.get();
        IPersistentMap ret = PersistentHashMap.EMPTY;
        for (ISeq bs = f.bindings.seq(); bs != null; bs = bs.next()) {
            IMapEntry e2 = (IMapEntry)bs.first();
            Var v = (Var)e2.key();
            TBox b = (TBox)e2.val();
            ret = ret.assoc(v, b.val);
        }
        return ret;
    }

    public final TBox getThreadBinding() {
        IMapEntry e2;
        if (this.threadBound.get() && (e2 = Var.dvals.get().bindings.entryAt(this)) != null) {
            return (TBox)e2.val();
        }
        return null;
    }

    public final IFn fn() {
        return (IFn)this.deref();
    }

    public Object call() throws Exception {
        return this.invoke();
    }

    public void run() {
        try {
            this.invoke();
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public Object invoke() throws Exception {
        return this.fn().invoke();
    }

    public Object invoke(Object arg1) throws Exception {
        return this.fn().invoke(arg1);
    }

    public Object invoke(Object arg1, Object arg2) throws Exception {
        return this.fn().invoke(arg1, arg2);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20);
    }

    public Object invoke(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14, Object arg15, Object arg16, Object arg17, Object arg18, Object arg19, Object arg20, Object ... args) throws Exception {
        return this.fn().invoke(arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, arg9, arg10, arg11, arg12, arg13, arg14, arg15, arg16, arg17, arg18, arg19, arg20, args);
    }

    public Object applyTo(ISeq arglist) throws Exception {
        return AFn.applyToHelper(this, arglist);
    }

    static class Frame {
        Associative bindings;
        Frame prev;

        public Frame() {
            this(PersistentHashMap.EMPTY, null);
        }

        public Frame(Associative bindings, Frame prev2) {
            this.bindings = bindings;
            this.prev = prev2;
        }

        protected Object clone() {
            Frame f = new Frame();
            f.bindings = this.bindings;
            return f;
        }
    }

    public static class Unbound
    extends AFn {
        public final Var v;

        public Unbound(Var v) {
            this.v = v;
        }

        public String toString() {
            return "Unbound: " + this.v;
        }

        public Object throwArity(int n) {
            throw new IllegalStateException("Attempting to call unbound fn: " + this.v);
        }
    }

    static class TBox {
        volatile Object val;
        final Thread thread;

        public TBox(Thread t, Object val2) {
            this.thread = t;
            this.val = val2;
        }
    }
}

