/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.BigInt;
import clojure.lang.IHashEq;
import clojure.lang.IPersistentCollection;
import clojure.lang.ISeq;
import clojure.lang.Numbers;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static boolean equiv(Object k1, Object k2) {
        if (k1 == k2) {
            return true;
        }
        if (k1 != null) {
            if (k1 instanceof Number && k2 instanceof Number) {
                return Numbers.equal((Number)k1, (Number)k2);
            }
            if (k1 instanceof IPersistentCollection || k2 instanceof IPersistentCollection) {
                return Util.pcequiv(k1, k2);
            }
            return k1.equals(k2);
        }
        return false;
    }

    public static boolean equiv(long k1, long k2) {
        return k1 == k2;
    }

    public static boolean equiv(Object k1, long k2) {
        return Util.equiv(k1, (Object)k2);
    }

    public static boolean equiv(long k1, Object k2) {
        return Util.equiv((Object)k1, k2);
    }

    public static boolean equiv(double k1, double k2) {
        return k1 == k2;
    }

    public static boolean equiv(Object k1, double k2) {
        return Util.equiv(k1, (Object)k2);
    }

    public static boolean equiv(double k1, Object k2) {
        return Util.equiv((Object)k1, k2);
    }

    public static boolean equiv(boolean k1, boolean k2) {
        return k1 == k2;
    }

    public static boolean equiv(Object k1, boolean k2) {
        return Util.equiv(k1, (Object)k2);
    }

    public static boolean equiv(boolean k1, Object k2) {
        return Util.equiv((Object)k1, k2);
    }

    public static boolean equiv(char c1, char c2) {
        return c1 == c2;
    }

    public static boolean pcequiv(Object k1, Object k2) {
        if (k1 instanceof IPersistentCollection) {
            return ((IPersistentCollection)k1).equiv(k2);
        }
        return ((IPersistentCollection)k2).equiv(k1);
    }

    public static boolean equals(Object k1, Object k2) {
        if (k1 == k2) {
            return true;
        }
        return k1 != null && k1.equals(k2);
    }

    public static boolean identical(Object k1, Object k2) {
        return k1 == k2;
    }

    public static Class classOf(Object x) {
        if (x != null) {
            return x.getClass();
        }
        return null;
    }

    public static int compare(Object k1, Object k2) {
        if (k1 == k2) {
            return 0;
        }
        if (k1 != null) {
            if (k2 == null) {
                return 1;
            }
            if (k1 instanceof Number) {
                return Numbers.compare((Number)k1, (Number)k2);
            }
            return ((Comparable)k1).compareTo(k2);
        }
        return -1;
    }

    public static int hash(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    public static int hasheq(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return Numbers.hasheq((Number)o);
        }
        if (o instanceof IHashEq) {
            return ((IHashEq)o).hasheq();
        }
        return o.hashCode();
    }

    public static int hashCombine(int seed, int hash2) {
        seed ^= hash2 + -1640531527 + (seed << 6) + (seed >> 2);
        return seed;
    }

    public static boolean isPrimitive(Class c) {
        return c != null && c.isPrimitive() && c != Void.TYPE;
    }

    public static boolean isInteger(Object x) {
        return x instanceof Integer || x instanceof Long || x instanceof BigInt || x instanceof BigInteger;
    }

    public static Object ret1(Object ret, Object nil) {
        return ret;
    }

    public static ISeq ret1(ISeq ret, Object nil) {
        return ret;
    }

    public static <K, V> void clearCache(ReferenceQueue rq, ConcurrentHashMap<K, Reference<V>> cache) {
        if (rq.poll() != null) {
            while (rq.poll() != null) {
            }
            for (Map.Entry<K, Reference<V>> e2 : cache.entrySet()) {
                Reference<V> val2 = e2.getValue();
                if (val2 == null || val2.get() != null) continue;
                cache.remove(e2.getKey(), val2);
            }
        }
    }
}

