(ns clojure-potrubi.utils.atoms)

;; **********************
;; BEG: is atom functions
;; **********************

(defn is-atom?
  [a] (instance? clojure.lang.Atom a))

;; **********************
;; FIN: is atom functions
;; **********************

;; **************************
;; BEG: update atom functions
;; **************************

(defn atom-swapper-one-arg [current-value new-value] new-value)

(defn update-atom-one-arg
  [atom-instance new-value]
  (swap! atom-instance
         atom-swapper-one-arg
         new-value))

(defn maybe-update-atom-one-arg
  [atom-instance new-value]
  {:pre [(is-atom? atom-instance)]}
  (if new-value (update-atom-one-arg atom-instance new-value)))

;; **************************
;; FIN: update atom functions
;; **************************

;; ************************
;; BEG: find atom functions
;; ************************

(defn make-fn-find-atom
  ([] (make-fn-find-atom (atom nil)))
  ([value]
       {:pre [(is-atom? value)] :post [(fn? %)]}
       (fn [] value)))

;; ************************
;; FIN: find atom functions
;; ************************
