(ns {{namespace}}
  (:gen-class)
  (:use [org.httpkit.server :only [run-server]]
        [compojure.core :only [defroutes GET POST]]
        [compojure.handler :only [site]]
        [compojure.route :only [not-found]]
        [ring.middleware.reload :only [wrap-reload]]))

(defn index [req]
  {:status  200
   :headers {"Content-Type" "text/html"}
   :body    "hello HTTP!"})

(defroutes app
  (GET "/" [] index)
  (route/not-found "<p>Page not found.</p>"))

(def app (-> app
            site
            wrap-reload))

(defn -main
  [& args]
  (run-server app {:port 8080}))
