(ns {{namespace}}
  (:gen-class)
  (:use [org.httpkit.server :only [run-server]])
  (:require [ring.middleware.reload :as reload]
            [compojure.handler :only [site]]
            [compojure.core :only [defroutes GET POST]]))

(defn app [req]
  {:status  200
   :headers {"Content-Type" "text/html"}
   :body    "hello HTTP!"})

(defroutes all-routes
  (GET "/" [] app)
  (route/not-found "<p>Page not found.</p>"))

(defn -main
  "I don't do a whole lot ... yet."
  [& args]
  (let [handler (reload/wrap-reload (site #'all-routes))]
    (run-server handler {:port 8080})))
