(ns {{name}}.core
    (:use [compojure.route :only [files not-found]]
          [compojure.handler :only [site]]
          [compojure.core :only [defroutes GET]]
          org.httpkit.server))

(defn index [req]
  {:status  200
   :headers {"Content-Type" "text/html"}
   :body    "Hello world!"})

(defroutes app
  (GET "/" [] index)
  (route/files "/static/")
  (route/not-found "<p>Page not found.</p>"))

(run-server (site #'app) {:port 8080})
