(ns lonocloud.syst
  (:require [n01se.deltype :refer [deftype]])
  (:refer-clojure :exclude [deftype]))

(defrecord SystRef [focus])

(defprotocol Focusable
  (focus [_] "return the current focus")
  (refocus [_ v] "Update with new focus."))

(deftype SystRef
  [foc]
  Focusable
  (focus [_] foc)
  (refocus [_ new-foc]
    (SystRef. new-foc))
  Object
  (toString [_]
    (str foc)))

(deftype Syst [foc, sys-map]

  Focusable
  (focus [_] foc)
  (refocus [_ new-foc]
    (Syst. new-foc sys-map))

  n01se.deltype.IMap

  (valAt [self k]
    (.valAt self k nil))

  (valAt [self k d]
    (let [m (get sys-map foc)]
      (if (contains? m k)
        (let [v (get m k)]
          (if (instance? SystRef v)
            (do
              (println foc "->" (focus v))
              (refocus self (focus v)))

            v))
        d)))

  (assoc [self k v]
    (if (and (instance? Syst v) ;; The value is a syst
             (instance? SystRef ;; The old value is a systref
                        (get-in sys-map [foc k])))
      (do
        (println foc "<-" (focus v))
        (refocus v foc)) ;; Use the new value.
      ;; else update the sys-map.
      (Syst. foc (assoc-in sys-map [foc k] v))))

  (empty [_] (empty (get sys-map foc)))
  (count [_] (count (get sys-map foc)))
  (seq [_] (seq (get sys-map foc)))
  (meta [_] (meta (get sys-map foc)))

  )

(defn syst [m]
  (Syst. nil (assoc m nil
                    (->>
                      (keys m)
                      (map #(vector % (SystRef. %)))
                      (into {})))))

(def sample-syst
  (syst {:a {:x 1},
         :b {:x 2,
             :y 2,
             :a1 (SystRef. :a),
             :a2 (SystRef. :a)},
         :c {:x 3,
             :y 3,
             :z 3,
             :b1 (SystRef. :b)}}))

