(defproject mx.roads.forgotten/app-server "0.0.1-SNAPSHOT"
  :description "The FRMX App Server"
  :url "https://gitlab.org/forgotten-roads/app-server"
  :scm {
    :name "git"
    :url  "https://gitlab.org/forgotten-roads/app-server"}
  :license {
    :name "Apache License, Version 2.0"
    :url "http://www.apache.org/licenses/LICENSE-2.0"}
  :dependencies [
    [org.clojure/clojure "1.8.0"]
    ;; Nginx
    [nginx-clojure "0.4.4"]
    ;; Support & Util libs
    [clojusc/twig "0.2.6"]
    [potemkin "0.4.3"]]
  :profiles {
    :uber {
      :aot :all}
    :test {
      :plugins [
        [jonase/eastwood "0.2.3" :exclusions [org.clojure/clojure]]
        [lein-kibit "0.1.2" :exclusions [org.clojure/clojure]]]
      :source-paths ["test"]
        :test-selectors {
        :default :unit
        :unit :unit
        :system :system
        :integration :integration}
    }
    :doc {
      :plugins [
        [lein-codox "0.10.1"]]
      :codox {
        :project {:name "FRMX App Server"}
        :output-path "docs/master/current"
        :doc-paths ["docs/source"]
        :namespaces [#"^mx.roads.forgotten.app-server\."]
        :metadata {
          :doc/format :markdown
          :doc "Documentation forthcoming"}}}
    :dev {
      :dependencies [
        [org.clojure/tools.namespace "0.2.11" :exclusions [org.clojure/clojure]]
        [lein-simpleton "1.3.0" :exclusions [org.clojure/clojure]]]
      :source-paths ["dev-resources/src"]
      :repl-options {:init-ns mx.roads.forgotten.app-server.dev}}})
