(defproject mvxcvi/multihash "2.0.1"
  :description "Native Clojure implementation of the multihash standard."
  :url "https://github.com/greglook/clj-multihash"
  :license {:name "Public Domain"
            :url "http://unlicense.org/"}

  :deploy-branches ["master"]
  :pedantic? :abort

  :aliases
  {"cljs-repl" ["run" "-m" "clojure.main" "cljs_repl.clj"]
   "cljs-test" ["doo" "phantom" "test" "once"]
   "coverage" ["with-profile" "+test,+coverage" "cloverage"]}

  :plugins
  [[lein-cljsbuild "1.1.2"]
   [lein-doo "0.1.6" :exclusions [org.clojure/clojurescript]]]

  :dependencies
  [[mvxcvi/alphabase "0.2.1"]]

  :cljsbuild
  {:builds {:test {:source-paths ["src" "test"]
                   :compiler {:output-dir "target/cljs/out"
                              :output-to "target/cljs/tests.js"
                   :main multihash.test-runner
                   :optimizations :whitespace}}}}

  :codox
  {:metadata {:doc/format :markdown}
   :source-uri "https://github.com/greglook/clj-multihash/blob/master/{filepath}#L{line}"
   :doc-paths ["doc/extra"]
   :output-path "doc/api"}

  :whidbey
  {:tag-types {'multihash.core.Multihash {'data/hash 'multihash.core/base58}}}

  :profiles
  {:dev
   {:dependencies [[org.clojure/clojure "1.8.0"]
                   [org.clojure/clojurescript "1.9.93"]]}

   :coverage
   {:plugins [[rfkm/lein-cloverage "1.0.8"]]
    :dependencies [[org.clojure/tools.reader "1.0.0-beta1"]]}})
