/*
 * Decompiled with CFR 0.152.
 */
package alphabase.codec;

public class Base16 {
    private static final char[] ALPHABET = "0123456789ABCDEF".toCharArray();

    private Base16() {
    }

    public static String encode(byte[] byArray) {
        char[] cArray = new char[2 * byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            int n = 2 * i;
            cArray[n] = ALPHABET[(by & 0xF0) >>> 4];
            cArray[n + 1] = ALPHABET[by & 0xF];
        }
        return new String(cArray);
    }

    private static int decodeNybble(String string, int n) {
        char c = string.charAt(n);
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        throw new IllegalArgumentException("Character '" + c + "' at index " + n + " is not a valid hexadecimal digit");
    }

    public static byte[] decode(String string) {
        int n = string.length() / 2;
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            int n2 = 2 * i;
            int n3 = Base16.decodeNybble(string, n2) << 4 | Base16.decodeNybble(string, n2 + 1);
            byArray[i] = (byte)n3;
        }
        return byArray;
    }
}

