
(ns verbosely.core
  (:require [clojure.string :as string]))

(defmacro verbosely! [f & args]
  (let [f-name (str f)
        arg-names (string/join " " (map str args))]
    `(let [~'result (~f ~@args)]
      (println "Calling:" (str "(" ~f-name " " ~arg-names ")"))
      (println "With:" ~@args)
      (println "Returns:" ~'result)
      ~'result)))
