
(ns respo.util.format
  (:require [clojure.string :as string]))

(defn dashed->camel
  ([x] (dashed->camel "" x false))
  ([acc piece promoted?]
    (if (= piece "")
      acc
      (let [cursor (get piece 0) piece-followed (subs piece 1)]
        (if (= cursor "-")
          (recur acc piece-followed true)
          (recur
            (str acc (if promoted? (string/upper-case cursor) cursor))
            piece-followed
            false))))))

(defn prop->attr [x] (case x "class-name" "class" x))

(defn event->string [x] (subs (name x) 3))

(defn event->edn [event]
  (comment .log js/console "simplify event:" event)
  (case
    (.-type event)
    "click"
    {:type :click}
    "keydown"
    {:key-code (.-keyCode event), :type :keydown}
    "input"
    {:value (.-value (.-target event)), :type :input}
    {:msg "not recognized event", :type (.-type event)}))

(defn purify-events [events]
  (->>
    events
    (map (fn [entry] [(key entry) true]))
    (into (sorted-map))))

(defn purify-element [element]
  (if (some? element)
    (-> element
     (assoc :events (purify-events (:events element)))
     (assoc
       :children
       (->>
         (:children element)
         (map (fn [entry] [(key entry) (purify-element (val entry))]))
         (into (sorted-map))))
     (dissoc :c-updater)
     (dissoc :c-coord)
     (dissoc :c-cost)
     (dissoc :c-props)
     (dissoc :c-state)
     (dissoc :c-creator))
    nil))
