// Compiled by ClojureScript 1.9.521 {}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('cljs_http.core');
goog.require('cljs_http.util');
goog.require('cljs.core.async');
goog.require('cljs.reader');
goog.require('clojure.string');
goog.require('goog.Uri');
goog.require('no.en.core');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__6346__auto__ = v;
if(cljs.core.truth_(and__6346__auto__)){
return (v > (0));
} else {
return and__6346__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(!(clojure.string.blank_QMARK_.call(null,s))){
return cljs.core.reduce.call(null,(function (p1__14780_SHARP_,p2__14779_SHARP_){
var vec__14784 = clojure.string.split.call(null,p2__14779_SHARP_,/=/);
var k = cljs.core.nth.call(null,vec__14784,(0),null);
var v = cljs.core.nth.call(null,vec__14784,(1),null);
return cljs.core.assoc.call(null,p1__14780_SHARP_,cljs.core.keyword.call(null,no.en.core.url_decode.call(null,k)),no.en.core.url_decode.call(null,v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(!(clojure.string.blank_QMARK_.call(null,url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [new cljs.core.Keyword(null,"scheme","scheme",90199613),cljs.core.keyword.call(null,uri.getScheme()),new cljs.core.Keyword(null,"server-name","server-name",-1012104295),uri.getDomain(),new cljs.core.Keyword(null,"server-port","server-port",663745648),cljs_http.client.if_pos.call(null,uri.getPort()),new cljs.core.Keyword(null,"uri","uri",-774711847),uri.getPath(),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),((cljs.core.not.call(null,query_data.isEmpty()))?[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join(''):null),new cljs.core.Keyword(null,"query-params","query-params",900640534),((cljs.core.not.call(null,query_data.isEmpty()))?cljs_http.client.parse_query_params.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode.call(null,cljs.core.name.call(null,k))),cljs.core.str.cljs$core$IFn$_invoke$arity$1("="),cljs.core.str.cljs$core$IFn$_invoke$arity$1(no.en.core.url_encode.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,(function (p1__14787_SHARP_){
return cljs_http.client.encode_val.call(null,k,p1__14787_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__14788){
var vec__14792 = p__14788;
var k = cljs.core.nth.call(null,vec__14792,(0),null);
var v = cljs.core.nth.call(null,vec__14792,(1),null);
if(cljs.core.coll_QMARK_.call(null,v)){
return cljs_http.client.encode_vals.call(null,k,v);
} else {
return cljs_http.client.encode_val.call(null,k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.call(null,"&",cljs.core.map.call(null,cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap.call(null,esc_chars,cljs.core.map.call(null,((function (esc_chars){
return (function (p1__14795_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1("\\"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__14795_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.call(null,cljs.core.str,cljs.core.replace.call(null,cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__6346__auto__ = cljs.core.not_EQ_.call(null,new cljs.core.Keyword(null,"head","head",-771383919),request_method);
if(and__6346__auto__){
var and__6346__auto____$1 = cljs.core.not_EQ_.call(null,(204),new cljs.core.Keyword(null,"status","status",-1997798413).cljs$core$IFn$_invoke$arity$1(response));
if(and__6346__auto____$1){
return cljs.core.re_find.call(null,cljs.core.re_pattern.call(null,[cljs.core.str.cljs$core$IFn$_invoke$arity$1("(?i)"),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs_http.client.escape_special.call(null,content_type))].join('')),[cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.get.call(null,new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__6346__auto____$1;
}
} else {
return and__6346__auto__;
}
})())){
return cljs.core.update_in.call(null,response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"body","body",-2049205669)], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"edn-params","edn-params",894273052).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/edn"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"edn-params","edn-params",894273052)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs.core.pr_str.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__14796_SHARP_){
return cljs_http.client.decode_body.call(null,p1__14796_SHARP_,cljs.reader.read_string,"application/edn",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_default_headers = (function cljs_http$client$wrap_default_headers(var_args){
var args__7478__auto__ = [];
var len__7471__auto___14803 = arguments.length;
var i__7472__auto___14804 = (0);
while(true){
if((i__7472__auto___14804 < len__7471__auto___14803)){
args__7478__auto__.push((arguments[i__7472__auto___14804]));

var G__14805 = (i__7472__auto___14804 + (1));
i__7472__auto___14804 = G__14805;
continue;
} else {
}
break;
}

var argseq__7479__auto__ = ((((1) < args__7478__auto__.length))?(new cljs.core.IndexedSeq(args__7478__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7479__auto__);
});

cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__14799){
var vec__14800 = p__14799;
var default_headers = cljs.core.nth.call(null,vec__14800,(0),null);
return ((function (vec__14800,default_headers){
return (function (request){
var temp__4655__auto__ = (function (){var or__6358__auto__ = new cljs.core.Keyword(null,"default-headers","default-headers",-43146094).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__6358__auto__)){
return or__6358__auto__;
} else {
return default_headers;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var default_headers__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc.call(null,request,new cljs.core.Keyword(null,"default-headers","default-headers",-43146094),default_headers__$1));
} else {
return client.call(null,request);
}
});
;})(vec__14800,default_headers))
});

cljs_http.client.wrap_default_headers.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_default_headers.cljs$lang$applyTo = (function (seq14797){
var G__14798 = cljs.core.first.call(null,seq14797);
var seq14797__$1 = cljs.core.next.call(null,seq14797);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic(G__14798,seq14797__$1);
});

cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(var_args){
var args__7478__auto__ = [];
var len__7471__auto___14812 = arguments.length;
var i__7472__auto___14813 = (0);
while(true){
if((i__7472__auto___14813 < len__7471__auto___14812)){
args__7478__auto__.push((arguments[i__7472__auto___14813]));

var G__14814 = (i__7472__auto___14813 + (1));
i__7472__auto___14813 = G__14814;
continue;
} else {
}
break;
}

var argseq__7479__auto__ = ((((1) < args__7478__auto__.length))?(new cljs.core.IndexedSeq(args__7478__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7479__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__14808){
var vec__14809 = p__14808;
var accept = cljs.core.nth.call(null,vec__14809,(0),null);
return ((function (vec__14809,accept){
return (function (request){
var temp__4655__auto__ = (function (){var or__6358__auto__ = new cljs.core.Keyword(null,"accept","accept",1874130431).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__6358__auto__)){
return or__6358__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var accept__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"accept"], null),accept__$1));
} else {
return client.call(null,request);
}
});
;})(vec__14809,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq14806){
var G__14807 = cljs.core.first.call(null,seq14806);
var seq14806__$1 = cljs.core.next.call(null,seq14806);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__14807,seq14806__$1);
});

cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(var_args){
var args__7478__auto__ = [];
var len__7471__auto___14821 = arguments.length;
var i__7472__auto___14822 = (0);
while(true){
if((i__7472__auto___14822 < len__7471__auto___14821)){
args__7478__auto__.push((arguments[i__7472__auto___14822]));

var G__14823 = (i__7472__auto___14822 + (1));
i__7472__auto___14822 = G__14823;
continue;
} else {
}
break;
}

var argseq__7479__auto__ = ((((1) < args__7478__auto__.length))?(new cljs.core.IndexedSeq(args__7478__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7479__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__14817){
var vec__14818 = p__14817;
var content_type = cljs.core.nth.call(null,vec__14818,(0),null);
return ((function (vec__14818,content_type){
return (function (request){
var temp__4655__auto__ = (function (){var or__6358__auto__ = new cljs.core.Keyword(null,"content-type","content-type",-508222634).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(or__6358__auto__)){
return or__6358__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__4655__auto__)){
var content_type__$1 = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,request,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"content-type"], null),content_type__$1));
} else {
return client.call(null,request);
}
});
;})(vec__14818,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq14815){
var G__14816 = cljs.core.first.call(null,seq14815);
var seq14815__$1 = cljs.core.next.call(null,seq14815);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__14816,seq14815__$1);
});

cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"encoding","encoding",1728578272),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"decoding","decoding",-568180903),new cljs.core.Keyword(null,"json","json",1279968570),new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140),cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 *   Content Type header.
 * 
 *   A :transit-opts map can be optionally provided with the following keys:
 * 
 *   :encoding                #{:json, :json-verbose}
 *   :decoding                #{:json, :json-verbose}
 *   :encoding/decoding-opts  appropriate map of options to be passed to
 *                         transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"transit-params","transit-params",357261095).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var map__14826 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__14826__$1 = ((((!((map__14826 == null)))?((((map__14826.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14826.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14826):map__14826);
var encoding = cljs.core.get.call(null,map__14826__$1,new cljs.core.Keyword(null,"encoding","encoding",1728578272));
var encoding_opts = cljs.core.get.call(null,map__14826__$1,new cljs.core.Keyword(null,"encoding-opts","encoding-opts",-1805664631));
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/transit+json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"transit-params","transit-params",357261095)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.transit_encode.call(null,params,encoding,encoding_opts)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request){
var map__14832 = cljs.core.merge.call(null,cljs_http.client.default_transit_opts,new cljs.core.Keyword(null,"transit-opts","transit-opts",1104386010).cljs$core$IFn$_invoke$arity$1(request));
var map__14832__$1 = ((((!((map__14832 == null)))?((((map__14832.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14832.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14832):map__14832);
var decoding = cljs.core.get.call(null,map__14832__$1,new cljs.core.Keyword(null,"decoding","decoding",-568180903));
var decoding_opts = cljs.core.get.call(null,map__14832__$1,new cljs.core.Keyword(null,"decoding-opts","decoding-opts",1050289140));
var transit_decode = ((function (map__14832,map__14832__$1,decoding,decoding_opts){
return (function (p1__14828_SHARP_){
return cljs_http.util.transit_decode.call(null,p1__14828_SHARP_,decoding,decoding_opts);
});})(map__14832,map__14832__$1,decoding,decoding_opts))
;
return cljs.core.async.map.call(null,((function (map__14832,map__14832__$1,decoding,decoding_opts,transit_decode){
return (function (p1__14829_SHARP_){
return cljs_http.client.decode_body.call(null,p1__14829_SHARP_,transit_decode,"application/transit+json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
});})(map__14832,map__14832__$1,decoding,decoding_opts,transit_decode))
,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"json-params","json-params",-1112693596).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var params = temp__4655__auto__;
var headers = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/json"], null),new cljs.core.Keyword(null,"headers","headers",-835030129).cljs$core$IFn$_invoke$arity$1(request));
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"json-params","json-params",-1112693596)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.util.json_encode.call(null,params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers));
} else {
return client.call(null,request);
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request){
return cljs.core.async.map.call(null,(function (p1__14834_SHARP_){
return cljs_http.client.decode_body.call(null,p1__14834_SHARP_,cljs_http.util.json_decode,"application/json",new cljs.core.Keyword(null,"request-method","request-method",1764796830).cljs$core$IFn$_invoke$arity$1(request));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [client.call(null,request)], null));
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__14838){
var map__14839 = p__14838;
var map__14839__$1 = ((((!((map__14839 == null)))?((((map__14839.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14839.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14839):map__14839);
var req = map__14839__$1;
var query_params = cljs.core.get.call(null,map__14839__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
if(cljs.core.truth_(query_params)){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"query-params","query-params",900640534)),new cljs.core.Keyword(null,"query-string","query-string",-1018845061),cljs_http.client.generate_query_string.call(null,query_params)));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__14844){
var map__14845 = p__14844;
var map__14845__$1 = ((((!((map__14845 == null)))?((((map__14845.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14845.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14845):map__14845);
var request = map__14845__$1;
var form_params = cljs.core.get.call(null,map__14845__$1,new cljs.core.Keyword(null,"form-params","form-params",1884296467));
var request_method = cljs.core.get.call(null,map__14845__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
var headers = cljs.core.get.call(null,map__14845__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
if(cljs.core.truth_((function (){var and__6346__auto__ = form_params;
if(cljs.core.truth_(and__6346__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__6346__auto__;
}
})())){
var headers__$1 = cljs.core.merge.call(null,new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/x-www-form-urlencoded"], null),headers);
return client.call(null,cljs.core.assoc.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"form-params","form-params",1884296467)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_query_string.call(null,form_params)),new cljs.core.Keyword(null,"headers","headers",-835030129),headers__$1));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.generate_form_data = (function cljs_http$client$generate_form_data(params){
var form_data = (new FormData());
var seq__14857_14867 = cljs.core.seq.call(null,params);
var chunk__14858_14868 = null;
var count__14859_14869 = (0);
var i__14860_14870 = (0);
while(true){
if((i__14860_14870 < count__14859_14869)){
var vec__14861_14871 = cljs.core._nth.call(null,chunk__14858_14868,i__14860_14870);
var k_14872 = cljs.core.nth.call(null,vec__14861_14871,(0),null);
var v_14873 = cljs.core.nth.call(null,vec__14861_14871,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_14873)){
form_data.append(cljs.core.name.call(null,k_14872),cljs.core.first.call(null,v_14873),cljs.core.second.call(null,v_14873));
} else {
form_data.append(cljs.core.name.call(null,k_14872),v_14873);
}

var G__14874 = seq__14857_14867;
var G__14875 = chunk__14858_14868;
var G__14876 = count__14859_14869;
var G__14877 = (i__14860_14870 + (1));
seq__14857_14867 = G__14874;
chunk__14858_14868 = G__14875;
count__14859_14869 = G__14876;
i__14860_14870 = G__14877;
continue;
} else {
var temp__4657__auto___14878 = cljs.core.seq.call(null,seq__14857_14867);
if(temp__4657__auto___14878){
var seq__14857_14879__$1 = temp__4657__auto___14878;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__14857_14879__$1)){
var c__7177__auto___14880 = cljs.core.chunk_first.call(null,seq__14857_14879__$1);
var G__14881 = cljs.core.chunk_rest.call(null,seq__14857_14879__$1);
var G__14882 = c__7177__auto___14880;
var G__14883 = cljs.core.count.call(null,c__7177__auto___14880);
var G__14884 = (0);
seq__14857_14867 = G__14881;
chunk__14858_14868 = G__14882;
count__14859_14869 = G__14883;
i__14860_14870 = G__14884;
continue;
} else {
var vec__14864_14885 = cljs.core.first.call(null,seq__14857_14879__$1);
var k_14886 = cljs.core.nth.call(null,vec__14864_14885,(0),null);
var v_14887 = cljs.core.nth.call(null,vec__14864_14885,(1),null);
if(cljs.core.coll_QMARK_.call(null,v_14887)){
form_data.append(cljs.core.name.call(null,k_14886),cljs.core.first.call(null,v_14887),cljs.core.second.call(null,v_14887));
} else {
form_data.append(cljs.core.name.call(null,k_14886),v_14887);
}

var G__14888 = cljs.core.next.call(null,seq__14857_14879__$1);
var G__14889 = null;
var G__14890 = (0);
var G__14891 = (0);
seq__14857_14867 = G__14888;
chunk__14858_14868 = G__14889;
count__14859_14869 = G__14890;
i__14860_14870 = G__14891;
continue;
}
} else {
}
}
break;
}

return form_data;
});
cljs_http.client.wrap_multipart_params = (function cljs_http$client$wrap_multipart_params(client){
return (function (p__14895){
var map__14896 = p__14895;
var map__14896__$1 = ((((!((map__14896 == null)))?((((map__14896.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14896.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14896):map__14896);
var request = map__14896__$1;
var multipart_params = cljs.core.get.call(null,map__14896__$1,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707));
var request_method = cljs.core.get.call(null,map__14896__$1,new cljs.core.Keyword(null,"request-method","request-method",1764796830));
if(cljs.core.truth_((function (){var and__6346__auto__ = multipart_params;
if(cljs.core.truth_(and__6346__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [new cljs.core.Keyword(null,"patch","patch",380775109),null,new cljs.core.Keyword(null,"delete","delete",-1768633620),null,new cljs.core.Keyword(null,"post","post",269697687),null,new cljs.core.Keyword(null,"put","put",1299772570),null], null), null).call(null,request_method);
} else {
return and__6346__auto__;
}
})())){
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,request,new cljs.core.Keyword(null,"multipart-params","multipart-params",-1033508707)),new cljs.core.Keyword(null,"body","body",-2049205669),cljs_http.client.generate_form_data.call(null,multipart_params)));
} else {
return client.call(null,request);
}
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__4655__auto__ = new cljs.core.Keyword(null,"method","method",55703592).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4655__auto__)){
var m = temp__4655__auto__;
return client.call(null,cljs.core.assoc.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"method","method",55703592)),new cljs.core.Keyword(null,"request-method","request-method",1764796830),m));
} else {
return client.call(null,req);
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__14898_SHARP_){
return client.call(null,cljs.core.assoc.call(null,p1__14898_SHARP_,new cljs.core.Keyword(null,"server-name","server-name",-1012104295),server_name));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__14903){
var map__14904 = p__14903;
var map__14904__$1 = ((((!((map__14904 == null)))?((((map__14904.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__14904.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__14904):map__14904);
var req = map__14904__$1;
var query_params = cljs.core.get.call(null,map__14904__$1,new cljs.core.Keyword(null,"query-params","query-params",900640534));
var temp__4655__auto__ = cljs_http.client.parse_url.call(null,new cljs.core.Keyword(null,"url","url",276297046).cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__4655__auto__)){
var spec = temp__4655__auto__;
return client.call(null,cljs.core.update_in.call(null,cljs.core.dissoc.call(null,cljs.core.merge.call(null,req,spec),new cljs.core.Keyword(null,"url","url",276297046)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"query-params","query-params",900640534)], null),((function (spec,temp__4655__auto__,map__14904,map__14904__$1,req,query_params){
return (function (p1__14899_SHARP_){
return cljs.core.merge.call(null,p1__14899_SHARP_,query_params);
});})(spec,temp__4655__auto__,map__14904,map__14904__$1,req,query_params))
));
} else {
return client.call(null,req);
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 *   an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(var_args){
var args__7478__auto__ = [];
var len__7471__auto___14912 = arguments.length;
var i__7472__auto___14913 = (0);
while(true){
if((i__7472__auto___14913 < len__7471__auto___14912)){
args__7478__auto__.push((arguments[i__7472__auto___14913]));

var G__14914 = (i__7472__auto___14913 + (1));
i__7472__auto___14913 = G__14914;
continue;
} else {
}
break;
}

var argseq__7479__auto__ = ((((1) < args__7478__auto__.length))?(new cljs.core.IndexedSeq(args__7478__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7479__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__14908){
var vec__14909 = p__14908;
var credentials = cljs.core.nth.call(null,vec__14909,(0),null);
return ((function (vec__14909,credentials){
return (function (req){
var credentials__$1 = (function (){var or__6358__auto__ = new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__6358__auto__)){
return or__6358__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_.call(null,credentials__$1))){
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"basic-auth","basic-auth",-673163332)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),cljs_http.util.basic_auth.call(null,credentials__$1)));
} else {
return client.call(null,req);
}
});
;})(vec__14909,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq14906){
var G__14907 = cljs.core.first.call(null,seq14906);
var seq14906__$1 = cljs.core.next.call(null,seq14906);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__14907,seq14906__$1);
});

/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__4655__auto__ = new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191).cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__4655__auto__)){
var oauth_token = temp__4655__auto__;
return client.call(null,cljs.core.assoc_in.call(null,cljs.core.dissoc.call(null,req,new cljs.core.Keyword(null,"oauth-token","oauth-token",311415191)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"authorization"], null),[cljs.core.str.cljs$core$IFn$_invoke$arity$1("Bearer "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(oauth_token)].join('')));
} else {
return client.call(null,req);
}
});
});
/**
 * Pipe the response-channel into the request-map's
 * custom channel (e.g. to enable transducers)
 */
cljs_http.client.wrap_channel_from_request_map = (function cljs_http$client$wrap_channel_from_request_map(client){
return (function (request){
var temp__4655__auto__ = new cljs.core.Keyword(null,"channel","channel",734187692).cljs$core$IFn$_invoke$arity$1(request);
if(cljs.core.truth_(temp__4655__auto__)){
var custom_channel = temp__4655__auto__;
return cljs.core.async.pipe.call(null,client.call(null,request),custom_channel);
} else {
return client.call(null,request);
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/request
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request){
return cljs_http.client.wrap_default_headers.call(null,cljs_http.client.wrap_channel_from_request_map.call(null,cljs_http.client.wrap_url.call(null,cljs_http.client.wrap_method.call(null,cljs_http.client.wrap_oauth.call(null,cljs_http.client.wrap_basic_auth.call(null,cljs_http.client.wrap_query_params.call(null,cljs_http.client.wrap_content_type.call(null,cljs_http.client.wrap_json_response.call(null,cljs_http.client.wrap_json_params.call(null,cljs_http.client.wrap_transit_response.call(null,cljs_http.client.wrap_transit_params.call(null,cljs_http.client.wrap_edn_response.call(null,cljs_http.client.wrap_edn_params.call(null,cljs_http.client.wrap_multipart_params.call(null,cljs_http.client.wrap_form_params.call(null,cljs_http.client.wrap_accept.call(null,request)))))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request.call(null,cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(var_args){
var args__7478__auto__ = [];
var len__7471__auto___14921 = arguments.length;
var i__7472__auto___14922 = (0);
while(true){
if((i__7472__auto___14922 < len__7471__auto___14921)){
args__7478__auto__.push((arguments[i__7472__auto___14922]));

var G__14923 = (i__7472__auto___14922 + (1));
i__7472__auto___14922 = G__14923;
continue;
} else {
}
break;
}

var argseq__7479__auto__ = ((((1) < args__7478__auto__.length))?(new cljs.core.IndexedSeq(args__7478__auto__.slice((1)),(0),null)):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7479__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__14917){
var vec__14918 = p__14917;
var req = cljs.core.nth.call(null,vec__14918,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"delete","delete",-1768633620),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq14915){
var G__14916 = cljs.core.first.call(null,seq14915);
var seq14915__$1 = cljs.core.next.call(null,seq14915);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__14916,seq14915__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(var_args){
var args__7478__auto__ = [];
var len__7471__auto___14930 = arguments.length;
var i__7472__auto___14931 = (0);
while(true){
if((i__7472__auto___14931 < len__7471__auto___14930)){
args__7478__auto__.push((arguments[i__7472__auto___14931]));

var G__14932 = (i__7472__auto___14931 + (1));
i__7472__auto___14931 = G__14932;
continue;
} else {
}
break;
}

var argseq__7479__auto__ = ((((1) < args__7478__auto__.length))?(new cljs.core.IndexedSeq(args__7478__auto__.slice((1)),(0),null)):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7479__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__14926){
var vec__14927 = p__14926;
var req = cljs.core.nth.call(null,vec__14927,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"get","get",1683182755),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq14924){
var G__14925 = cljs.core.first.call(null,seq14924);
var seq14924__$1 = cljs.core.next.call(null,seq14924);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__14925,seq14924__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(var_args){
var args__7478__auto__ = [];
var len__7471__auto___14939 = arguments.length;
var i__7472__auto___14940 = (0);
while(true){
if((i__7472__auto___14940 < len__7471__auto___14939)){
args__7478__auto__.push((arguments[i__7472__auto___14940]));

var G__14941 = (i__7472__auto___14940 + (1));
i__7472__auto___14940 = G__14941;
continue;
} else {
}
break;
}

var argseq__7479__auto__ = ((((1) < args__7478__auto__.length))?(new cljs.core.IndexedSeq(args__7478__auto__.slice((1)),(0),null)):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7479__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__14935){
var vec__14936 = p__14935;
var req = cljs.core.nth.call(null,vec__14936,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"head","head",-771383919),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq14933){
var G__14934 = cljs.core.first.call(null,seq14933);
var seq14933__$1 = cljs.core.next.call(null,seq14933);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__14934,seq14933__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.jsonp = (function cljs_http$client$jsonp(var_args){
var args__7478__auto__ = [];
var len__7471__auto___14948 = arguments.length;
var i__7472__auto___14949 = (0);
while(true){
if((i__7472__auto___14949 < len__7471__auto___14948)){
args__7478__auto__.push((arguments[i__7472__auto___14949]));

var G__14950 = (i__7472__auto___14949 + (1));
i__7472__auto___14949 = G__14950;
continue;
} else {
}
break;
}

var argseq__7479__auto__ = ((((1) < args__7478__auto__.length))?(new cljs.core.IndexedSeq(args__7478__auto__.slice((1)),(0),null)):null);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7479__auto__);
});

cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__14944){
var vec__14945 = p__14944;
var req = cljs.core.nth.call(null,vec__14945,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"jsonp","jsonp",226119588),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.jsonp.cljs$lang$maxFixedArity = (1);

cljs_http.client.jsonp.cljs$lang$applyTo = (function (seq14942){
var G__14943 = cljs.core.first.call(null,seq14942);
var seq14942__$1 = cljs.core.next.call(null,seq14942);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic(G__14943,seq14942__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(var_args){
var args__7478__auto__ = [];
var len__7471__auto___14957 = arguments.length;
var i__7472__auto___14958 = (0);
while(true){
if((i__7472__auto___14958 < len__7471__auto___14957)){
args__7478__auto__.push((arguments[i__7472__auto___14958]));

var G__14959 = (i__7472__auto___14958 + (1));
i__7472__auto___14958 = G__14959;
continue;
} else {
}
break;
}

var argseq__7479__auto__ = ((((1) < args__7478__auto__.length))?(new cljs.core.IndexedSeq(args__7478__auto__.slice((1)),(0),null)):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7479__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__14953){
var vec__14954 = p__14953;
var req = cljs.core.nth.call(null,vec__14954,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"move","move",-2110884309),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq14951){
var G__14952 = cljs.core.first.call(null,seq14951);
var seq14951__$1 = cljs.core.next.call(null,seq14951);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__14952,seq14951__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(var_args){
var args__7478__auto__ = [];
var len__7471__auto___14966 = arguments.length;
var i__7472__auto___14967 = (0);
while(true){
if((i__7472__auto___14967 < len__7471__auto___14966)){
args__7478__auto__.push((arguments[i__7472__auto___14967]));

var G__14968 = (i__7472__auto___14967 + (1));
i__7472__auto___14967 = G__14968;
continue;
} else {
}
break;
}

var argseq__7479__auto__ = ((((1) < args__7478__auto__.length))?(new cljs.core.IndexedSeq(args__7478__auto__.slice((1)),(0),null)):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7479__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__14962){
var vec__14963 = p__14962;
var req = cljs.core.nth.call(null,vec__14963,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"options","options",99638489),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq14960){
var G__14961 = cljs.core.first.call(null,seq14960);
var seq14960__$1 = cljs.core.next.call(null,seq14960);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__14961,seq14960__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(var_args){
var args__7478__auto__ = [];
var len__7471__auto___14975 = arguments.length;
var i__7472__auto___14976 = (0);
while(true){
if((i__7472__auto___14976 < len__7471__auto___14975)){
args__7478__auto__.push((arguments[i__7472__auto___14976]));

var G__14977 = (i__7472__auto___14976 + (1));
i__7472__auto___14976 = G__14977;
continue;
} else {
}
break;
}

var argseq__7479__auto__ = ((((1) < args__7478__auto__.length))?(new cljs.core.IndexedSeq(args__7478__auto__.slice((1)),(0),null)):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7479__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__14971){
var vec__14972 = p__14971;
var req = cljs.core.nth.call(null,vec__14972,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"patch","patch",380775109),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq14969){
var G__14970 = cljs.core.first.call(null,seq14969);
var seq14969__$1 = cljs.core.next.call(null,seq14969);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__14970,seq14969__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(var_args){
var args__7478__auto__ = [];
var len__7471__auto___14984 = arguments.length;
var i__7472__auto___14985 = (0);
while(true){
if((i__7472__auto___14985 < len__7471__auto___14984)){
args__7478__auto__.push((arguments[i__7472__auto___14985]));

var G__14986 = (i__7472__auto___14985 + (1));
i__7472__auto___14985 = G__14986;
continue;
} else {
}
break;
}

var argseq__7479__auto__ = ((((1) < args__7478__auto__.length))?(new cljs.core.IndexedSeq(args__7478__auto__.slice((1)),(0),null)):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7479__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__14980){
var vec__14981 = p__14980;
var req = cljs.core.nth.call(null,vec__14981,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"post","post",269697687),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq14978){
var G__14979 = cljs.core.first.call(null,seq14978);
var seq14978__$1 = cljs.core.next.call(null,seq14978);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__14979,seq14978__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(var_args){
var args__7478__auto__ = [];
var len__7471__auto___14993 = arguments.length;
var i__7472__auto___14994 = (0);
while(true){
if((i__7472__auto___14994 < len__7471__auto___14993)){
args__7478__auto__.push((arguments[i__7472__auto___14994]));

var G__14995 = (i__7472__auto___14994 + (1));
i__7472__auto___14994 = G__14995;
continue;
} else {
}
break;
}

var argseq__7479__auto__ = ((((1) < args__7478__auto__.length))?(new cljs.core.IndexedSeq(args__7478__auto__.slice((1)),(0),null)):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7479__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__14989){
var vec__14990 = p__14989;
var req = cljs.core.nth.call(null,vec__14990,(0),null);
return cljs_http.client.request.call(null,cljs.core.merge.call(null,req,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"method","method",55703592),new cljs.core.Keyword(null,"put","put",1299772570),new cljs.core.Keyword(null,"url","url",276297046),url], null)));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq14987){
var G__14988 = cljs.core.first.call(null,seq14987);
var seq14987__$1 = cljs.core.next.call(null,seq14987);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__14988,seq14987__$1);
});


//# sourceMappingURL=client.js.map