// Compiled by ClojureScript 1.9.521 {}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var args11869 = [];
var len__7471__auto___11875 = arguments.length;
var i__7472__auto___11876 = (0);
while(true){
if((i__7472__auto___11876 < len__7471__auto___11875)){
args11869.push((arguments[i__7472__auto___11876]));

var G__11877 = (i__7472__auto___11876 + (1));
i__7472__auto___11876 = G__11877;
continue;
} else {
}
break;
}

var G__11871 = args11869.length;
switch (G__11871) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11869.length)].join('')));

}
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.call(null,f,true);
});

cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if(typeof cljs.core.async.t_cljs$core$async11872 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11872 = (function (f,blockable,meta11873){
this.f = f;
this.blockable = blockable;
this.meta11873 = meta11873;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11872.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11874,meta11873__$1){
var self__ = this;
var _11874__$1 = this;
return (new cljs.core.async.t_cljs$core$async11872(self__.f,self__.blockable,meta11873__$1));
});

cljs.core.async.t_cljs$core$async11872.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11874){
var self__ = this;
var _11874__$1 = this;
return self__.meta11873;
});

cljs.core.async.t_cljs$core$async11872.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async11872.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11872.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
});

cljs.core.async.t_cljs$core$async11872.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
});

cljs.core.async.t_cljs$core$async11872.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta11873","meta11873",-1728160045,null)], null);
});

cljs.core.async.t_cljs$core$async11872.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11872.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11872";

cljs.core.async.t_cljs$core$async11872.cljs$lang$ctorPrWriter = (function (this__6969__auto__,writer__6970__auto__,opt__6971__auto__){
return cljs.core._write.call(null,writer__6970__auto__,"cljs.core.async/t_cljs$core$async11872");
});

cljs.core.async.__GT_t_cljs$core$async11872 = (function cljs$core$async$__GT_t_cljs$core$async11872(f__$1,blockable__$1,meta11873){
return (new cljs.core.async.t_cljs$core$async11872(f__$1,blockable__$1,meta11873));
});

}

return (new cljs.core.async.t_cljs$core$async11872(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
});

cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2;

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer.call(null,n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer.call(null,n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if(!((buff == null))){
if((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_.call(null,cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var args11881 = [];
var len__7471__auto___11884 = arguments.length;
var i__7472__auto___11885 = (0);
while(true){
if((i__7472__auto___11885 < len__7471__auto___11884)){
args11881.push((arguments[i__7472__auto___11885]));

var G__11886 = (i__7472__auto___11885 + (1));
i__7472__auto___11885 = G__11886;
continue;
} else {
}
break;
}

var G__11883 = args11881.length;
switch (G__11883) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11881.length)].join('')));

}
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.call(null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.call(null,buf_or_n,null,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.call(null,buf_or_n,xform,null);
});

cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.call(null,buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buffer must be supplied when transducer is"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("buf-or-n")].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.call(null,((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer.call(null,buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
});

cljs.core.async.chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var args11888 = [];
var len__7471__auto___11891 = arguments.length;
var i__7472__auto___11892 = (0);
while(true){
if((i__7472__auto___11892 < len__7471__auto___11891)){
args11888.push((arguments[i__7472__auto___11892]));

var G__11893 = (i__7472__auto___11892 + (1));
i__7472__auto___11892 = G__11893;
continue;
} else {
}
break;
}

var G__11890 = args11888.length;
switch (G__11890) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11888.length)].join('')));

}
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.call(null,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.call(null,xform,null);
});

cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.call(null,cljs.core.async.impl.buffers.promise_buffer.call(null),xform,ex_handler);
});

cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout.call(null,msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var args11895 = [];
var len__7471__auto___11898 = arguments.length;
var i__7472__auto___11899 = (0);
while(true){
if((i__7472__auto___11899 < len__7471__auto___11898)){
args11895.push((arguments[i__7472__auto___11899]));

var G__11900 = (i__7472__auto___11899 + (1));
i__7472__auto___11899 = G__11900;
continue;
} else {
}
break;
}

var G__11897 = args11895.length;
switch (G__11897) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11895.length)].join('')));

}
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.call(null,port,fn1,true);
});

cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(ret)){
var val_11902 = cljs.core.deref.call(null,ret);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,val_11902);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (val_11902,ret){
return (function (){
return fn1.call(null,val_11902);
});})(val_11902,ret))
);
}
} else {
}

return null;
});

cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3;

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.call(null,cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn0 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn0 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var args11903 = [];
var len__7471__auto___11906 = arguments.length;
var i__7472__auto___11907 = (0);
while(true){
if((i__7472__auto___11907 < len__7471__auto___11906)){
args11903.push((arguments[i__7472__auto___11907]));

var G__11908 = (i__7472__auto___11907 + (1));
i__7472__auto___11907 = G__11908;
continue;
} else {
}
break;
}

var G__11905 = args11903.length;
switch (G__11905) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11903.length)].join('')));

}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__4655__auto__)){
var ret = temp__4655__auto__;
return cljs.core.deref.call(null,ret);
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.call(null,port,val,fn1,true);
});

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__4655__auto__ = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,fn1));
if(cljs.core.truth_(temp__4655__auto__)){
var retb = temp__4655__auto__;
var ret = cljs.core.deref.call(null,retb);
if(cljs.core.truth_(on_caller_QMARK_)){
fn1.call(null,ret);
} else {
cljs.core.async.impl.dispatch.run.call(null,((function (ret,retb,temp__4655__auto__){
return (function (){
return fn1.call(null,ret);
});})(ret,retb,temp__4655__auto__))
);
}

return ret;
} else {
return true;
}
});

cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4;

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_.call(null,port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__7281__auto___11910 = n;
var x_11911 = (0);
while(true){
if((x_11911 < n__7281__auto___11910)){
(a[x_11911] = (0));

var G__11912 = (x_11911 + (1));
x_11911 = G__11912;
continue;
} else {
}
break;
}

var i = (1);
while(true){
if(cljs.core._EQ_.call(null,i,n)){
return a;
} else {
var j = cljs.core.rand_int.call(null,i);
(a[i] = (a[j]));

(a[j] = i);

var G__11913 = (i + (1));
i = G__11913;
continue;
}
break;
}
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.call(null,true);
if(typeof cljs.core.async.t_cljs$core$async11917 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11917 = (function (flag,meta11918){
this.flag = flag;
this.meta11918 = meta11918;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11917.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (flag){
return (function (_11919,meta11918__$1){
var self__ = this;
var _11919__$1 = this;
return (new cljs.core.async.t_cljs$core$async11917(self__.flag,meta11918__$1));
});})(flag))
;

cljs.core.async.t_cljs$core$async11917.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (flag){
return (function (_11919){
var self__ = this;
var _11919__$1 = this;
return self__.meta11918;
});})(flag))
;

cljs.core.async.t_cljs$core$async11917.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async11917.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref.call(null,self__.flag);
});})(flag))
;

cljs.core.async.t_cljs$core$async11917.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11917.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (flag){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.flag,null);

return true;
});})(flag))
;

cljs.core.async.t_cljs$core$async11917.getBasis = ((function (flag){
return (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta11918","meta11918",1781871490,null)], null);
});})(flag))
;

cljs.core.async.t_cljs$core$async11917.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11917.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11917";

cljs.core.async.t_cljs$core$async11917.cljs$lang$ctorPrWriter = ((function (flag){
return (function (this__6969__auto__,writer__6970__auto__,opt__6971__auto__){
return cljs.core._write.call(null,writer__6970__auto__,"cljs.core.async/t_cljs$core$async11917");
});})(flag))
;

cljs.core.async.__GT_t_cljs$core$async11917 = ((function (flag){
return (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async11917(flag__$1,meta11918){
return (new cljs.core.async.t_cljs$core$async11917(flag__$1,meta11918));
});})(flag))
;

}

return (new cljs.core.async.t_cljs$core$async11917(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if(typeof cljs.core.async.t_cljs$core$async11923 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async11923 = (function (flag,cb,meta11924){
this.flag = flag;
this.cb = cb;
this.meta11924 = meta11924;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async11923.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_11925,meta11924__$1){
var self__ = this;
var _11925__$1 = this;
return (new cljs.core.async.t_cljs$core$async11923(self__.flag,self__.cb,meta11924__$1));
});

cljs.core.async.t_cljs$core$async11923.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_11925){
var self__ = this;
var _11925__$1 = this;
return self__.meta11924;
});

cljs.core.async.t_cljs$core$async11923.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async11923.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.flag);
});

cljs.core.async.t_cljs$core$async11923.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
});

cljs.core.async.t_cljs$core$async11923.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit.call(null,self__.flag);

return self__.cb;
});

cljs.core.async.t_cljs$core$async11923.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta11924","meta11924",-979142379,null)], null);
});

cljs.core.async.t_cljs$core$async11923.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async11923.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async11923";

cljs.core.async.t_cljs$core$async11923.cljs$lang$ctorPrWriter = (function (this__6969__auto__,writer__6970__auto__,opt__6971__auto__){
return cljs.core._write.call(null,writer__6970__auto__,"cljs.core.async/t_cljs$core$async11923");
});

cljs.core.async.__GT_t_cljs$core$async11923 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async11923(flag__$1,cb__$1,meta11924){
return (new cljs.core.async.t_cljs$core$async11923(flag__$1,cb__$1,meta11924));
});

}

return (new cljs.core.async.t_cljs$core$async11923(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
var flag = cljs.core.async.alt_flag.call(null);
var n = cljs.core.count.call(null,ports);
var idxs = cljs.core.async.random_array.call(null,n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.call(null,ports,idx);
var wport = ((cljs.core.vector_QMARK_.call(null,port))?port.call(null,(0)):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = port.call(null,(1));
return cljs.core.async.impl.protocols.put_BANG_.call(null,wport,val,cljs.core.async.alt_handler.call(null,flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11926_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11926_SHARP_,wport], null));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.alt_handler.call(null,flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__11927_SHARP_){
return fret.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__11927_SHARP_,port], null));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref.call(null,vbox),(function (){var or__6358__auto__ = wport;
if(cljs.core.truth_(or__6358__auto__)){
return or__6358__auto__;
} else {
return port;
}
})()], null));
} else {
var G__11928 = (i + (1));
i = G__11928;
continue;
}
} else {
return null;
}
break;
}
})();
var or__6358__auto__ = ret;
if(cljs.core.truth_(or__6358__auto__)){
return or__6358__auto__;
} else {
if(cljs.core.contains_QMARK_.call(null,opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__4657__auto__ = (function (){var and__6346__auto__ = cljs.core.async.impl.protocols.active_QMARK_.call(null,flag);
if(cljs.core.truth_(and__6346__auto__)){
return cljs.core.async.impl.protocols.commit.call(null,flag);
} else {
return and__6346__auto__;
}
})();
if(cljs.core.truth_(temp__4657__auto__)){
var got = temp__4657__auto__;
return cljs.core.async.impl.channels.box.call(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__7478__auto__ = [];
var len__7471__auto___11934 = arguments.length;
var i__7472__auto___11935 = (0);
while(true){
if((i__7472__auto___11935 < len__7471__auto___11934)){
args__7478__auto__.push((arguments[i__7472__auto___11935]));

var G__11936 = (i__7472__auto___11935 + (1));
i__7472__auto___11935 = G__11936;
continue;
} else {
}
break;
}

var argseq__7479__auto__ = ((((1) < args__7478__auto__.length))?(new cljs.core.IndexedSeq(args__7478__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7479__auto__);
});

cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__11931){
var map__11932 = p__11931;
var map__11932__$1 = ((((!((map__11932 == null)))?((((map__11932.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__11932.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__11932):map__11932);
var opts = map__11932__$1;
throw (new Error("alts! used not in (go ...) block"));
});

cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1);

cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq11929){
var G__11930 = cljs.core.first.call(null,seq11929);
var seq11929__$1 = cljs.core.next.call(null,seq11929);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__11930,seq11929__$1);
});

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_.call(null,port,val,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,port,cljs.core.async.fn_handler.call(null,cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref.call(null,ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var args11937 = [];
var len__7471__auto___11987 = arguments.length;
var i__7472__auto___11988 = (0);
while(true){
if((i__7472__auto___11988 < len__7471__auto___11987)){
args11937.push((arguments[i__7472__auto___11988]));

var G__11989 = (i__7472__auto___11988 + (1));
i__7472__auto___11988 = G__11989;
continue;
} else {
}
break;
}

var G__11939 = args11937.length;
switch (G__11939) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args11937.length)].join('')));

}
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.call(null,from,to,true);
});

cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__11824__auto___11991 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11824__auto___11991){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (c__11824__auto___11991){
return (function (state_11963){
var state_val_11964 = (state_11963[(1)]);
if((state_val_11964 === (7))){
var inst_11959 = (state_11963[(2)]);
var state_11963__$1 = state_11963;
var statearr_11965_11992 = state_11963__$1;
(statearr_11965_11992[(2)] = inst_11959);

(statearr_11965_11992[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11964 === (1))){
var state_11963__$1 = state_11963;
var statearr_11966_11993 = state_11963__$1;
(statearr_11966_11993[(2)] = null);

(statearr_11966_11993[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11964 === (4))){
var inst_11942 = (state_11963[(7)]);
var inst_11942__$1 = (state_11963[(2)]);
var inst_11943 = (inst_11942__$1 == null);
var state_11963__$1 = (function (){var statearr_11967 = state_11963;
(statearr_11967[(7)] = inst_11942__$1);

return statearr_11967;
})();
if(cljs.core.truth_(inst_11943)){
var statearr_11968_11994 = state_11963__$1;
(statearr_11968_11994[(1)] = (5));

} else {
var statearr_11969_11995 = state_11963__$1;
(statearr_11969_11995[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11964 === (13))){
var state_11963__$1 = state_11963;
var statearr_11970_11996 = state_11963__$1;
(statearr_11970_11996[(2)] = null);

(statearr_11970_11996[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11964 === (6))){
var inst_11942 = (state_11963[(7)]);
var state_11963__$1 = state_11963;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_11963__$1,(11),to,inst_11942);
} else {
if((state_val_11964 === (3))){
var inst_11961 = (state_11963[(2)]);
var state_11963__$1 = state_11963;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_11963__$1,inst_11961);
} else {
if((state_val_11964 === (12))){
var state_11963__$1 = state_11963;
var statearr_11971_11997 = state_11963__$1;
(statearr_11971_11997[(2)] = null);

(statearr_11971_11997[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11964 === (2))){
var state_11963__$1 = state_11963;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_11963__$1,(4),from);
} else {
if((state_val_11964 === (11))){
var inst_11952 = (state_11963[(2)]);
var state_11963__$1 = state_11963;
if(cljs.core.truth_(inst_11952)){
var statearr_11972_11998 = state_11963__$1;
(statearr_11972_11998[(1)] = (12));

} else {
var statearr_11973_11999 = state_11963__$1;
(statearr_11973_11999[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11964 === (9))){
var state_11963__$1 = state_11963;
var statearr_11974_12000 = state_11963__$1;
(statearr_11974_12000[(2)] = null);

(statearr_11974_12000[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11964 === (5))){
var state_11963__$1 = state_11963;
if(cljs.core.truth_(close_QMARK_)){
var statearr_11975_12001 = state_11963__$1;
(statearr_11975_12001[(1)] = (8));

} else {
var statearr_11976_12002 = state_11963__$1;
(statearr_11976_12002[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11964 === (14))){
var inst_11957 = (state_11963[(2)]);
var state_11963__$1 = state_11963;
var statearr_11977_12003 = state_11963__$1;
(statearr_11977_12003[(2)] = inst_11957);

(statearr_11977_12003[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11964 === (10))){
var inst_11949 = (state_11963[(2)]);
var state_11963__$1 = state_11963;
var statearr_11978_12004 = state_11963__$1;
(statearr_11978_12004[(2)] = inst_11949);

(statearr_11978_12004[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_11964 === (8))){
var inst_11946 = cljs.core.async.close_BANG_.call(null,to);
var state_11963__$1 = state_11963;
var statearr_11979_12005 = state_11963__$1;
(statearr_11979_12005[(2)] = inst_11946);

(statearr_11979_12005[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11824__auto___11991))
;
return ((function (switch__11712__auto__,c__11824__auto___11991){
return (function() {
var cljs$core$async$state_machine__11713__auto__ = null;
var cljs$core$async$state_machine__11713__auto____0 = (function (){
var statearr_11983 = [null,null,null,null,null,null,null,null];
(statearr_11983[(0)] = cljs$core$async$state_machine__11713__auto__);

(statearr_11983[(1)] = (1));

return statearr_11983;
});
var cljs$core$async$state_machine__11713__auto____1 = (function (state_11963){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_11963);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e11984){if((e11984 instanceof Object)){
var ex__11716__auto__ = e11984;
var statearr_11985_12006 = state_11963;
(statearr_11985_12006[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_11963);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e11984;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12007 = state_11963;
state_11963 = G__12007;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$state_machine__11713__auto__ = function(state_11963){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11713__auto____1.call(this,state_11963);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11713__auto____0;
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11713__auto____1;
return cljs$core$async$state_machine__11713__auto__;
})()
;})(switch__11712__auto__,c__11824__auto___11991))
})();
var state__11826__auto__ = (function (){var statearr_11986 = f__11825__auto__.call(null);
(statearr_11986[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto___11991);

return statearr_11986;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(c__11824__auto___11991))
);


return to;
});

cljs.core.async.pipe.cljs$lang$maxFixedArity = 3;

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.call(null,n);
var results = cljs.core.async.chan.call(null,n);
var process = ((function (jobs,results){
return (function (p__12195){
var vec__12196 = p__12195;
var v = cljs.core.nth.call(null,vec__12196,(0),null);
var p = cljs.core.nth.call(null,vec__12196,(1),null);
var job = vec__12196;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1),xf,ex_handler);
var c__11824__auto___12382 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11824__auto___12382,res,vec__12196,v,p,job,jobs,results){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (c__11824__auto___12382,res,vec__12196,v,p,job,jobs,results){
return (function (state_12203){
var state_val_12204 = (state_12203[(1)]);
if((state_val_12204 === (1))){
var state_12203__$1 = state_12203;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12203__$1,(2),res,v);
} else {
if((state_val_12204 === (2))){
var inst_12200 = (state_12203[(2)]);
var inst_12201 = cljs.core.async.close_BANG_.call(null,res);
var state_12203__$1 = (function (){var statearr_12205 = state_12203;
(statearr_12205[(7)] = inst_12200);

return statearr_12205;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12203__$1,inst_12201);
} else {
return null;
}
}
});})(c__11824__auto___12382,res,vec__12196,v,p,job,jobs,results))
;
return ((function (switch__11712__auto__,c__11824__auto___12382,res,vec__12196,v,p,job,jobs,results){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____0 = (function (){
var statearr_12209 = [null,null,null,null,null,null,null,null];
(statearr_12209[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__);

(statearr_12209[(1)] = (1));

return statearr_12209;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____1 = (function (state_12203){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_12203);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e12210){if((e12210 instanceof Object)){
var ex__11716__auto__ = e12210;
var statearr_12211_12383 = state_12203;
(statearr_12211_12383[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12203);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12210;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12384 = state_12203;
state_12203 = G__12384;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__ = function(state_12203){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____1.call(this,state_12203);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__;
})()
;})(switch__11712__auto__,c__11824__auto___12382,res,vec__12196,v,p,job,jobs,results))
})();
var state__11826__auto__ = (function (){var statearr_12212 = f__11825__auto__.call(null);
(statearr_12212[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto___12382);

return statearr_12212;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(c__11824__auto___12382,res,vec__12196,v,p,job,jobs,results))
);


cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results))
;
var async = ((function (jobs,results,process){
return (function (p__12213){
var vec__12214 = p__12213;
var v = cljs.core.nth.call(null,vec__12214,(0),null);
var p = cljs.core.nth.call(null,vec__12214,(1),null);
var job = vec__12214;
if((job == null)){
cljs.core.async.close_BANG_.call(null,results);

return null;
} else {
var res = cljs.core.async.chan.call(null,(1));
xf.call(null,v,res);

cljs.core.async.put_BANG_.call(null,p,res);

return true;
}
});})(jobs,results,process))
;
var n__7281__auto___12385 = n;
var __12386 = (0);
while(true){
if((__12386 < n__7281__auto___12385)){
var G__12217_12387 = (((type instanceof cljs.core.Keyword))?type.fqn:null);
switch (G__12217_12387) {
case "compute":
var c__11824__auto___12389 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12386,c__11824__auto___12389,G__12217_12387,n__7281__auto___12385,jobs,results,process,async){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (__12386,c__11824__auto___12389,G__12217_12387,n__7281__auto___12385,jobs,results,process,async){
return (function (state_12230){
var state_val_12231 = (state_12230[(1)]);
if((state_val_12231 === (1))){
var state_12230__$1 = state_12230;
var statearr_12232_12390 = state_12230__$1;
(statearr_12232_12390[(2)] = null);

(statearr_12232_12390[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (2))){
var state_12230__$1 = state_12230;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12230__$1,(4),jobs);
} else {
if((state_val_12231 === (3))){
var inst_12228 = (state_12230[(2)]);
var state_12230__$1 = state_12230;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12230__$1,inst_12228);
} else {
if((state_val_12231 === (4))){
var inst_12220 = (state_12230[(2)]);
var inst_12221 = process.call(null,inst_12220);
var state_12230__$1 = state_12230;
if(cljs.core.truth_(inst_12221)){
var statearr_12233_12391 = state_12230__$1;
(statearr_12233_12391[(1)] = (5));

} else {
var statearr_12234_12392 = state_12230__$1;
(statearr_12234_12392[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (5))){
var state_12230__$1 = state_12230;
var statearr_12235_12393 = state_12230__$1;
(statearr_12235_12393[(2)] = null);

(statearr_12235_12393[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (6))){
var state_12230__$1 = state_12230;
var statearr_12236_12394 = state_12230__$1;
(statearr_12236_12394[(2)] = null);

(statearr_12236_12394[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12231 === (7))){
var inst_12226 = (state_12230[(2)]);
var state_12230__$1 = state_12230;
var statearr_12237_12395 = state_12230__$1;
(statearr_12237_12395[(2)] = inst_12226);

(statearr_12237_12395[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12386,c__11824__auto___12389,G__12217_12387,n__7281__auto___12385,jobs,results,process,async))
;
return ((function (__12386,switch__11712__auto__,c__11824__auto___12389,G__12217_12387,n__7281__auto___12385,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____0 = (function (){
var statearr_12241 = [null,null,null,null,null,null,null];
(statearr_12241[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__);

(statearr_12241[(1)] = (1));

return statearr_12241;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____1 = (function (state_12230){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_12230);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e12242){if((e12242 instanceof Object)){
var ex__11716__auto__ = e12242;
var statearr_12243_12396 = state_12230;
(statearr_12243_12396[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12230);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12242;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12397 = state_12230;
state_12230 = G__12397;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__ = function(state_12230){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____1.call(this,state_12230);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__;
})()
;})(__12386,switch__11712__auto__,c__11824__auto___12389,G__12217_12387,n__7281__auto___12385,jobs,results,process,async))
})();
var state__11826__auto__ = (function (){var statearr_12244 = f__11825__auto__.call(null);
(statearr_12244[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto___12389);

return statearr_12244;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(__12386,c__11824__auto___12389,G__12217_12387,n__7281__auto___12385,jobs,results,process,async))
);


break;
case "async":
var c__11824__auto___12398 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (__12386,c__11824__auto___12398,G__12217_12387,n__7281__auto___12385,jobs,results,process,async){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (__12386,c__11824__auto___12398,G__12217_12387,n__7281__auto___12385,jobs,results,process,async){
return (function (state_12257){
var state_val_12258 = (state_12257[(1)]);
if((state_val_12258 === (1))){
var state_12257__$1 = state_12257;
var statearr_12259_12399 = state_12257__$1;
(statearr_12259_12399[(2)] = null);

(statearr_12259_12399[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12258 === (2))){
var state_12257__$1 = state_12257;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12257__$1,(4),jobs);
} else {
if((state_val_12258 === (3))){
var inst_12255 = (state_12257[(2)]);
var state_12257__$1 = state_12257;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12257__$1,inst_12255);
} else {
if((state_val_12258 === (4))){
var inst_12247 = (state_12257[(2)]);
var inst_12248 = async.call(null,inst_12247);
var state_12257__$1 = state_12257;
if(cljs.core.truth_(inst_12248)){
var statearr_12260_12400 = state_12257__$1;
(statearr_12260_12400[(1)] = (5));

} else {
var statearr_12261_12401 = state_12257__$1;
(statearr_12261_12401[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12258 === (5))){
var state_12257__$1 = state_12257;
var statearr_12262_12402 = state_12257__$1;
(statearr_12262_12402[(2)] = null);

(statearr_12262_12402[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12258 === (6))){
var state_12257__$1 = state_12257;
var statearr_12263_12403 = state_12257__$1;
(statearr_12263_12403[(2)] = null);

(statearr_12263_12403[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12258 === (7))){
var inst_12253 = (state_12257[(2)]);
var state_12257__$1 = state_12257;
var statearr_12264_12404 = state_12257__$1;
(statearr_12264_12404[(2)] = inst_12253);

(statearr_12264_12404[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__12386,c__11824__auto___12398,G__12217_12387,n__7281__auto___12385,jobs,results,process,async))
;
return ((function (__12386,switch__11712__auto__,c__11824__auto___12398,G__12217_12387,n__7281__auto___12385,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____0 = (function (){
var statearr_12268 = [null,null,null,null,null,null,null];
(statearr_12268[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__);

(statearr_12268[(1)] = (1));

return statearr_12268;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____1 = (function (state_12257){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_12257);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e12269){if((e12269 instanceof Object)){
var ex__11716__auto__ = e12269;
var statearr_12270_12405 = state_12257;
(statearr_12270_12405[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12257);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12269;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12406 = state_12257;
state_12257 = G__12406;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__ = function(state_12257){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____1.call(this,state_12257);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__;
})()
;})(__12386,switch__11712__auto__,c__11824__auto___12398,G__12217_12387,n__7281__auto___12385,jobs,results,process,async))
})();
var state__11826__auto__ = (function (){var statearr_12271 = f__11825__auto__.call(null);
(statearr_12271[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto___12398);

return statearr_12271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(__12386,c__11824__auto___12398,G__12217_12387,n__7281__auto___12385,jobs,results,process,async))
);


break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("No matching clause: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)].join('')));

}

var G__12407 = (__12386 + (1));
__12386 = G__12407;
continue;
} else {
}
break;
}

var c__11824__auto___12408 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11824__auto___12408,jobs,results,process,async){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (c__11824__auto___12408,jobs,results,process,async){
return (function (state_12293){
var state_val_12294 = (state_12293[(1)]);
if((state_val_12294 === (1))){
var state_12293__$1 = state_12293;
var statearr_12295_12409 = state_12293__$1;
(statearr_12295_12409[(2)] = null);

(statearr_12295_12409[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12294 === (2))){
var state_12293__$1 = state_12293;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12293__$1,(4),from);
} else {
if((state_val_12294 === (3))){
var inst_12291 = (state_12293[(2)]);
var state_12293__$1 = state_12293;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12293__$1,inst_12291);
} else {
if((state_val_12294 === (4))){
var inst_12274 = (state_12293[(7)]);
var inst_12274__$1 = (state_12293[(2)]);
var inst_12275 = (inst_12274__$1 == null);
var state_12293__$1 = (function (){var statearr_12296 = state_12293;
(statearr_12296[(7)] = inst_12274__$1);

return statearr_12296;
})();
if(cljs.core.truth_(inst_12275)){
var statearr_12297_12410 = state_12293__$1;
(statearr_12297_12410[(1)] = (5));

} else {
var statearr_12298_12411 = state_12293__$1;
(statearr_12298_12411[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12294 === (5))){
var inst_12277 = cljs.core.async.close_BANG_.call(null,jobs);
var state_12293__$1 = state_12293;
var statearr_12299_12412 = state_12293__$1;
(statearr_12299_12412[(2)] = inst_12277);

(statearr_12299_12412[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12294 === (6))){
var inst_12279 = (state_12293[(8)]);
var inst_12274 = (state_12293[(7)]);
var inst_12279__$1 = cljs.core.async.chan.call(null,(1));
var inst_12280 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_12281 = [inst_12274,inst_12279__$1];
var inst_12282 = (new cljs.core.PersistentVector(null,2,(5),inst_12280,inst_12281,null));
var state_12293__$1 = (function (){var statearr_12300 = state_12293;
(statearr_12300[(8)] = inst_12279__$1);

return statearr_12300;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12293__$1,(8),jobs,inst_12282);
} else {
if((state_val_12294 === (7))){
var inst_12289 = (state_12293[(2)]);
var state_12293__$1 = state_12293;
var statearr_12301_12413 = state_12293__$1;
(statearr_12301_12413[(2)] = inst_12289);

(statearr_12301_12413[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12294 === (8))){
var inst_12279 = (state_12293[(8)]);
var inst_12284 = (state_12293[(2)]);
var state_12293__$1 = (function (){var statearr_12302 = state_12293;
(statearr_12302[(9)] = inst_12284);

return statearr_12302;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12293__$1,(9),results,inst_12279);
} else {
if((state_val_12294 === (9))){
var inst_12286 = (state_12293[(2)]);
var state_12293__$1 = (function (){var statearr_12303 = state_12293;
(statearr_12303[(10)] = inst_12286);

return statearr_12303;
})();
var statearr_12304_12414 = state_12293__$1;
(statearr_12304_12414[(2)] = null);

(statearr_12304_12414[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
});})(c__11824__auto___12408,jobs,results,process,async))
;
return ((function (switch__11712__auto__,c__11824__auto___12408,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____0 = (function (){
var statearr_12308 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_12308[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__);

(statearr_12308[(1)] = (1));

return statearr_12308;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____1 = (function (state_12293){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_12293);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e12309){if((e12309 instanceof Object)){
var ex__11716__auto__ = e12309;
var statearr_12310_12415 = state_12293;
(statearr_12310_12415[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12293);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12309;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12416 = state_12293;
state_12293 = G__12416;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__ = function(state_12293){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____1.call(this,state_12293);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__;
})()
;})(switch__11712__auto__,c__11824__auto___12408,jobs,results,process,async))
})();
var state__11826__auto__ = (function (){var statearr_12311 = f__11825__auto__.call(null);
(statearr_12311[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto___12408);

return statearr_12311;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(c__11824__auto___12408,jobs,results,process,async))
);


var c__11824__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11824__auto__,jobs,results,process,async){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (c__11824__auto__,jobs,results,process,async){
return (function (state_12349){
var state_val_12350 = (state_12349[(1)]);
if((state_val_12350 === (7))){
var inst_12345 = (state_12349[(2)]);
var state_12349__$1 = state_12349;
var statearr_12351_12417 = state_12349__$1;
(statearr_12351_12417[(2)] = inst_12345);

(statearr_12351_12417[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12350 === (20))){
var state_12349__$1 = state_12349;
var statearr_12352_12418 = state_12349__$1;
(statearr_12352_12418[(2)] = null);

(statearr_12352_12418[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12350 === (1))){
var state_12349__$1 = state_12349;
var statearr_12353_12419 = state_12349__$1;
(statearr_12353_12419[(2)] = null);

(statearr_12353_12419[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12350 === (4))){
var inst_12314 = (state_12349[(7)]);
var inst_12314__$1 = (state_12349[(2)]);
var inst_12315 = (inst_12314__$1 == null);
var state_12349__$1 = (function (){var statearr_12354 = state_12349;
(statearr_12354[(7)] = inst_12314__$1);

return statearr_12354;
})();
if(cljs.core.truth_(inst_12315)){
var statearr_12355_12420 = state_12349__$1;
(statearr_12355_12420[(1)] = (5));

} else {
var statearr_12356_12421 = state_12349__$1;
(statearr_12356_12421[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12350 === (15))){
var inst_12327 = (state_12349[(8)]);
var state_12349__$1 = state_12349;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12349__$1,(18),to,inst_12327);
} else {
if((state_val_12350 === (21))){
var inst_12340 = (state_12349[(2)]);
var state_12349__$1 = state_12349;
var statearr_12357_12422 = state_12349__$1;
(statearr_12357_12422[(2)] = inst_12340);

(statearr_12357_12422[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12350 === (13))){
var inst_12342 = (state_12349[(2)]);
var state_12349__$1 = (function (){var statearr_12358 = state_12349;
(statearr_12358[(9)] = inst_12342);

return statearr_12358;
})();
var statearr_12359_12423 = state_12349__$1;
(statearr_12359_12423[(2)] = null);

(statearr_12359_12423[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12350 === (6))){
var inst_12314 = (state_12349[(7)]);
var state_12349__$1 = state_12349;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12349__$1,(11),inst_12314);
} else {
if((state_val_12350 === (17))){
var inst_12335 = (state_12349[(2)]);
var state_12349__$1 = state_12349;
if(cljs.core.truth_(inst_12335)){
var statearr_12360_12424 = state_12349__$1;
(statearr_12360_12424[(1)] = (19));

} else {
var statearr_12361_12425 = state_12349__$1;
(statearr_12361_12425[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12350 === (3))){
var inst_12347 = (state_12349[(2)]);
var state_12349__$1 = state_12349;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12349__$1,inst_12347);
} else {
if((state_val_12350 === (12))){
var inst_12324 = (state_12349[(10)]);
var state_12349__$1 = state_12349;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12349__$1,(14),inst_12324);
} else {
if((state_val_12350 === (2))){
var state_12349__$1 = state_12349;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12349__$1,(4),results);
} else {
if((state_val_12350 === (19))){
var state_12349__$1 = state_12349;
var statearr_12362_12426 = state_12349__$1;
(statearr_12362_12426[(2)] = null);

(statearr_12362_12426[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12350 === (11))){
var inst_12324 = (state_12349[(2)]);
var state_12349__$1 = (function (){var statearr_12363 = state_12349;
(statearr_12363[(10)] = inst_12324);

return statearr_12363;
})();
var statearr_12364_12427 = state_12349__$1;
(statearr_12364_12427[(2)] = null);

(statearr_12364_12427[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12350 === (9))){
var state_12349__$1 = state_12349;
var statearr_12365_12428 = state_12349__$1;
(statearr_12365_12428[(2)] = null);

(statearr_12365_12428[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12350 === (5))){
var state_12349__$1 = state_12349;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12366_12429 = state_12349__$1;
(statearr_12366_12429[(1)] = (8));

} else {
var statearr_12367_12430 = state_12349__$1;
(statearr_12367_12430[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12350 === (14))){
var inst_12329 = (state_12349[(11)]);
var inst_12327 = (state_12349[(8)]);
var inst_12327__$1 = (state_12349[(2)]);
var inst_12328 = (inst_12327__$1 == null);
var inst_12329__$1 = cljs.core.not.call(null,inst_12328);
var state_12349__$1 = (function (){var statearr_12368 = state_12349;
(statearr_12368[(11)] = inst_12329__$1);

(statearr_12368[(8)] = inst_12327__$1);

return statearr_12368;
})();
if(inst_12329__$1){
var statearr_12369_12431 = state_12349__$1;
(statearr_12369_12431[(1)] = (15));

} else {
var statearr_12370_12432 = state_12349__$1;
(statearr_12370_12432[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12350 === (16))){
var inst_12329 = (state_12349[(11)]);
var state_12349__$1 = state_12349;
var statearr_12371_12433 = state_12349__$1;
(statearr_12371_12433[(2)] = inst_12329);

(statearr_12371_12433[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12350 === (10))){
var inst_12321 = (state_12349[(2)]);
var state_12349__$1 = state_12349;
var statearr_12372_12434 = state_12349__$1;
(statearr_12372_12434[(2)] = inst_12321);

(statearr_12372_12434[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12350 === (18))){
var inst_12332 = (state_12349[(2)]);
var state_12349__$1 = state_12349;
var statearr_12373_12435 = state_12349__$1;
(statearr_12373_12435[(2)] = inst_12332);

(statearr_12373_12435[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12350 === (8))){
var inst_12318 = cljs.core.async.close_BANG_.call(null,to);
var state_12349__$1 = state_12349;
var statearr_12374_12436 = state_12349__$1;
(statearr_12374_12436[(2)] = inst_12318);

(statearr_12374_12436[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11824__auto__,jobs,results,process,async))
;
return ((function (switch__11712__auto__,c__11824__auto__,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____0 = (function (){
var statearr_12378 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_12378[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__);

(statearr_12378[(1)] = (1));

return statearr_12378;
});
var cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____1 = (function (state_12349){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_12349);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e12379){if((e12379 instanceof Object)){
var ex__11716__auto__ = e12379;
var statearr_12380_12437 = state_12349;
(statearr_12380_12437[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12349);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12379;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12438 = state_12349;
state_12349 = G__12438;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__ = function(state_12349){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____1.call(this,state_12349);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__11713__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__11713__auto__;
})()
;})(switch__11712__auto__,c__11824__auto__,jobs,results,process,async))
})();
var state__11826__auto__ = (function (){var statearr_12381 = f__11825__auto__.call(null);
(statearr_12381[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto__);

return statearr_12381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(c__11824__auto__,jobs,results,process,async))
);

return c__11824__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var args12439 = [];
var len__7471__auto___12442 = arguments.length;
var i__7472__auto___12443 = (0);
while(true){
if((i__7472__auto___12443 < len__7471__auto___12442)){
args12439.push((arguments[i__7472__auto___12443]));

var G__12444 = (i__7472__auto___12443 + (1));
i__7472__auto___12443 = G__12444;
continue;
} else {
}
break;
}

var G__12441 = args12439.length;
switch (G__12441) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12439.length)].join('')));

}
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.call(null,n,to,af,from,true);
});

cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_.call(null,n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
});

cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5;

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var args12446 = [];
var len__7471__auto___12449 = arguments.length;
var i__7472__auto___12450 = (0);
while(true){
if((i__7472__auto___12450 < len__7471__auto___12449)){
args12446.push((arguments[i__7472__auto___12450]));

var G__12451 = (i__7472__auto___12450 + (1));
i__7472__auto___12450 = G__12451;
continue;
} else {
}
break;
}

var G__12448 = args12446.length;
switch (G__12448) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12446.length)].join('')));

}
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.call(null,n,to,xf,from,true);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.call(null,n,to,xf,from,close_QMARK_,null);
});

cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_.call(null,n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
});

cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6;

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var args12453 = [];
var len__7471__auto___12506 = arguments.length;
var i__7472__auto___12507 = (0);
while(true){
if((i__7472__auto___12507 < len__7471__auto___12506)){
args12453.push((arguments[i__7472__auto___12507]));

var G__12508 = (i__7472__auto___12507 + (1));
i__7472__auto___12507 = G__12508;
continue;
} else {
}
break;
}

var G__12455 = args12453.length;
switch (G__12455) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12453.length)].join('')));

}
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.call(null,p,ch,null,null);
});

cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.call(null,t_buf_or_n);
var fc = cljs.core.async.chan.call(null,f_buf_or_n);
var c__11824__auto___12510 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11824__auto___12510,tc,fc){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (c__11824__auto___12510,tc,fc){
return (function (state_12481){
var state_val_12482 = (state_12481[(1)]);
if((state_val_12482 === (7))){
var inst_12477 = (state_12481[(2)]);
var state_12481__$1 = state_12481;
var statearr_12483_12511 = state_12481__$1;
(statearr_12483_12511[(2)] = inst_12477);

(statearr_12483_12511[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12482 === (1))){
var state_12481__$1 = state_12481;
var statearr_12484_12512 = state_12481__$1;
(statearr_12484_12512[(2)] = null);

(statearr_12484_12512[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12482 === (4))){
var inst_12458 = (state_12481[(7)]);
var inst_12458__$1 = (state_12481[(2)]);
var inst_12459 = (inst_12458__$1 == null);
var state_12481__$1 = (function (){var statearr_12485 = state_12481;
(statearr_12485[(7)] = inst_12458__$1);

return statearr_12485;
})();
if(cljs.core.truth_(inst_12459)){
var statearr_12486_12513 = state_12481__$1;
(statearr_12486_12513[(1)] = (5));

} else {
var statearr_12487_12514 = state_12481__$1;
(statearr_12487_12514[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12482 === (13))){
var state_12481__$1 = state_12481;
var statearr_12488_12515 = state_12481__$1;
(statearr_12488_12515[(2)] = null);

(statearr_12488_12515[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12482 === (6))){
var inst_12458 = (state_12481[(7)]);
var inst_12464 = p.call(null,inst_12458);
var state_12481__$1 = state_12481;
if(cljs.core.truth_(inst_12464)){
var statearr_12489_12516 = state_12481__$1;
(statearr_12489_12516[(1)] = (9));

} else {
var statearr_12490_12517 = state_12481__$1;
(statearr_12490_12517[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12482 === (3))){
var inst_12479 = (state_12481[(2)]);
var state_12481__$1 = state_12481;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12481__$1,inst_12479);
} else {
if((state_val_12482 === (12))){
var state_12481__$1 = state_12481;
var statearr_12491_12518 = state_12481__$1;
(statearr_12491_12518[(2)] = null);

(statearr_12491_12518[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12482 === (2))){
var state_12481__$1 = state_12481;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12481__$1,(4),ch);
} else {
if((state_val_12482 === (11))){
var inst_12458 = (state_12481[(7)]);
var inst_12468 = (state_12481[(2)]);
var state_12481__$1 = state_12481;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12481__$1,(8),inst_12468,inst_12458);
} else {
if((state_val_12482 === (9))){
var state_12481__$1 = state_12481;
var statearr_12492_12519 = state_12481__$1;
(statearr_12492_12519[(2)] = tc);

(statearr_12492_12519[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12482 === (5))){
var inst_12461 = cljs.core.async.close_BANG_.call(null,tc);
var inst_12462 = cljs.core.async.close_BANG_.call(null,fc);
var state_12481__$1 = (function (){var statearr_12493 = state_12481;
(statearr_12493[(8)] = inst_12461);

return statearr_12493;
})();
var statearr_12494_12520 = state_12481__$1;
(statearr_12494_12520[(2)] = inst_12462);

(statearr_12494_12520[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12482 === (14))){
var inst_12475 = (state_12481[(2)]);
var state_12481__$1 = state_12481;
var statearr_12495_12521 = state_12481__$1;
(statearr_12495_12521[(2)] = inst_12475);

(statearr_12495_12521[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12482 === (10))){
var state_12481__$1 = state_12481;
var statearr_12496_12522 = state_12481__$1;
(statearr_12496_12522[(2)] = fc);

(statearr_12496_12522[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12482 === (8))){
var inst_12470 = (state_12481[(2)]);
var state_12481__$1 = state_12481;
if(cljs.core.truth_(inst_12470)){
var statearr_12497_12523 = state_12481__$1;
(statearr_12497_12523[(1)] = (12));

} else {
var statearr_12498_12524 = state_12481__$1;
(statearr_12498_12524[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11824__auto___12510,tc,fc))
;
return ((function (switch__11712__auto__,c__11824__auto___12510,tc,fc){
return (function() {
var cljs$core$async$state_machine__11713__auto__ = null;
var cljs$core$async$state_machine__11713__auto____0 = (function (){
var statearr_12502 = [null,null,null,null,null,null,null,null,null];
(statearr_12502[(0)] = cljs$core$async$state_machine__11713__auto__);

(statearr_12502[(1)] = (1));

return statearr_12502;
});
var cljs$core$async$state_machine__11713__auto____1 = (function (state_12481){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_12481);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e12503){if((e12503 instanceof Object)){
var ex__11716__auto__ = e12503;
var statearr_12504_12525 = state_12481;
(statearr_12504_12525[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12481);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12503;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12526 = state_12481;
state_12481 = G__12526;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$state_machine__11713__auto__ = function(state_12481){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11713__auto____1.call(this,state_12481);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11713__auto____0;
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11713__auto____1;
return cljs$core$async$state_machine__11713__auto__;
})()
;})(switch__11712__auto__,c__11824__auto___12510,tc,fc))
})();
var state__11826__auto__ = (function (){var statearr_12505 = f__11825__auto__.call(null);
(statearr_12505[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto___12510);

return statearr_12505;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(c__11824__auto___12510,tc,fc))
);


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
});

cljs.core.async.split.cljs$lang$maxFixedArity = 4;

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__11824__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11824__auto__){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (c__11824__auto__){
return (function (state_12590){
var state_val_12591 = (state_12590[(1)]);
if((state_val_12591 === (7))){
var inst_12586 = (state_12590[(2)]);
var state_12590__$1 = state_12590;
var statearr_12592_12613 = state_12590__$1;
(statearr_12592_12613[(2)] = inst_12586);

(statearr_12592_12613[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12591 === (1))){
var inst_12570 = init;
var state_12590__$1 = (function (){var statearr_12593 = state_12590;
(statearr_12593[(7)] = inst_12570);

return statearr_12593;
})();
var statearr_12594_12614 = state_12590__$1;
(statearr_12594_12614[(2)] = null);

(statearr_12594_12614[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12591 === (4))){
var inst_12573 = (state_12590[(8)]);
var inst_12573__$1 = (state_12590[(2)]);
var inst_12574 = (inst_12573__$1 == null);
var state_12590__$1 = (function (){var statearr_12595 = state_12590;
(statearr_12595[(8)] = inst_12573__$1);

return statearr_12595;
})();
if(cljs.core.truth_(inst_12574)){
var statearr_12596_12615 = state_12590__$1;
(statearr_12596_12615[(1)] = (5));

} else {
var statearr_12597_12616 = state_12590__$1;
(statearr_12597_12616[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12591 === (6))){
var inst_12570 = (state_12590[(7)]);
var inst_12573 = (state_12590[(8)]);
var inst_12577 = (state_12590[(9)]);
var inst_12577__$1 = f.call(null,inst_12570,inst_12573);
var inst_12578 = cljs.core.reduced_QMARK_.call(null,inst_12577__$1);
var state_12590__$1 = (function (){var statearr_12598 = state_12590;
(statearr_12598[(9)] = inst_12577__$1);

return statearr_12598;
})();
if(inst_12578){
var statearr_12599_12617 = state_12590__$1;
(statearr_12599_12617[(1)] = (8));

} else {
var statearr_12600_12618 = state_12590__$1;
(statearr_12600_12618[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12591 === (3))){
var inst_12588 = (state_12590[(2)]);
var state_12590__$1 = state_12590;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12590__$1,inst_12588);
} else {
if((state_val_12591 === (2))){
var state_12590__$1 = state_12590;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12590__$1,(4),ch);
} else {
if((state_val_12591 === (9))){
var inst_12577 = (state_12590[(9)]);
var inst_12570 = inst_12577;
var state_12590__$1 = (function (){var statearr_12601 = state_12590;
(statearr_12601[(7)] = inst_12570);

return statearr_12601;
})();
var statearr_12602_12619 = state_12590__$1;
(statearr_12602_12619[(2)] = null);

(statearr_12602_12619[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12591 === (5))){
var inst_12570 = (state_12590[(7)]);
var state_12590__$1 = state_12590;
var statearr_12603_12620 = state_12590__$1;
(statearr_12603_12620[(2)] = inst_12570);

(statearr_12603_12620[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12591 === (10))){
var inst_12584 = (state_12590[(2)]);
var state_12590__$1 = state_12590;
var statearr_12604_12621 = state_12590__$1;
(statearr_12604_12621[(2)] = inst_12584);

(statearr_12604_12621[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12591 === (8))){
var inst_12577 = (state_12590[(9)]);
var inst_12580 = cljs.core.deref.call(null,inst_12577);
var state_12590__$1 = state_12590;
var statearr_12605_12622 = state_12590__$1;
(statearr_12605_12622[(2)] = inst_12580);

(statearr_12605_12622[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});})(c__11824__auto__))
;
return ((function (switch__11712__auto__,c__11824__auto__){
return (function() {
var cljs$core$async$reduce_$_state_machine__11713__auto__ = null;
var cljs$core$async$reduce_$_state_machine__11713__auto____0 = (function (){
var statearr_12609 = [null,null,null,null,null,null,null,null,null,null];
(statearr_12609[(0)] = cljs$core$async$reduce_$_state_machine__11713__auto__);

(statearr_12609[(1)] = (1));

return statearr_12609;
});
var cljs$core$async$reduce_$_state_machine__11713__auto____1 = (function (state_12590){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_12590);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e12610){if((e12610 instanceof Object)){
var ex__11716__auto__ = e12610;
var statearr_12611_12623 = state_12590;
(statearr_12611_12623[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12590);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12610;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12624 = state_12590;
state_12590 = G__12624;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__11713__auto__ = function(state_12590){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__11713__auto____1.call(this,state_12590);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$reduce_$_state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__11713__auto____0;
cljs$core$async$reduce_$_state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__11713__auto____1;
return cljs$core$async$reduce_$_state_machine__11713__auto__;
})()
;})(switch__11712__auto__,c__11824__auto__))
})();
var state__11826__auto__ = (function (){var statearr_12612 = f__11825__auto__.call(null);
(statearr_12612[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto__);

return statearr_12612;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(c__11824__auto__))
);

return c__11824__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = xform.call(null,f);
var c__11824__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11824__auto__,f__$1){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (c__11824__auto__,f__$1){
return (function (state_12644){
var state_val_12645 = (state_12644[(1)]);
if((state_val_12645 === (1))){
var inst_12639 = cljs.core.async.reduce.call(null,f__$1,init,ch);
var state_12644__$1 = state_12644;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_12644__$1,(2),inst_12639);
} else {
if((state_val_12645 === (2))){
var inst_12641 = (state_12644[(2)]);
var inst_12642 = f__$1.call(null,inst_12641);
var state_12644__$1 = state_12644;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12644__$1,inst_12642);
} else {
return null;
}
}
});})(c__11824__auto__,f__$1))
;
return ((function (switch__11712__auto__,c__11824__auto__,f__$1){
return (function() {
var cljs$core$async$transduce_$_state_machine__11713__auto__ = null;
var cljs$core$async$transduce_$_state_machine__11713__auto____0 = (function (){
var statearr_12649 = [null,null,null,null,null,null,null];
(statearr_12649[(0)] = cljs$core$async$transduce_$_state_machine__11713__auto__);

(statearr_12649[(1)] = (1));

return statearr_12649;
});
var cljs$core$async$transduce_$_state_machine__11713__auto____1 = (function (state_12644){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_12644);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e12650){if((e12650 instanceof Object)){
var ex__11716__auto__ = e12650;
var statearr_12651_12653 = state_12644;
(statearr_12651_12653[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12644);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12650;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12654 = state_12644;
state_12644 = G__12654;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__11713__auto__ = function(state_12644){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__11713__auto____1.call(this,state_12644);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$transduce_$_state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__11713__auto____0;
cljs$core$async$transduce_$_state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__11713__auto____1;
return cljs$core$async$transduce_$_state_machine__11713__auto__;
})()
;})(switch__11712__auto__,c__11824__auto__,f__$1))
})();
var state__11826__auto__ = (function (){var statearr_12652 = f__11825__auto__.call(null);
(statearr_12652[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto__);

return statearr_12652;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(c__11824__auto__,f__$1))
);

return c__11824__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var args12655 = [];
var len__7471__auto___12707 = arguments.length;
var i__7472__auto___12708 = (0);
while(true){
if((i__7472__auto___12708 < len__7471__auto___12707)){
args12655.push((arguments[i__7472__auto___12708]));

var G__12709 = (i__7472__auto___12708 + (1));
i__7472__auto___12708 = G__12709;
continue;
} else {
}
break;
}

var G__12657 = args12655.length;
switch (G__12657) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args12655.length)].join('')));

}
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan.call(null,ch,coll,true);
});

cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__11824__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11824__auto__){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (c__11824__auto__){
return (function (state_12682){
var state_val_12683 = (state_12682[(1)]);
if((state_val_12683 === (7))){
var inst_12664 = (state_12682[(2)]);
var state_12682__$1 = state_12682;
var statearr_12684_12711 = state_12682__$1;
(statearr_12684_12711[(2)] = inst_12664);

(statearr_12684_12711[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12683 === (1))){
var inst_12658 = cljs.core.seq.call(null,coll);
var inst_12659 = inst_12658;
var state_12682__$1 = (function (){var statearr_12685 = state_12682;
(statearr_12685[(7)] = inst_12659);

return statearr_12685;
})();
var statearr_12686_12712 = state_12682__$1;
(statearr_12686_12712[(2)] = null);

(statearr_12686_12712[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12683 === (4))){
var inst_12659 = (state_12682[(7)]);
var inst_12662 = cljs.core.first.call(null,inst_12659);
var state_12682__$1 = state_12682;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_12682__$1,(7),ch,inst_12662);
} else {
if((state_val_12683 === (13))){
var inst_12676 = (state_12682[(2)]);
var state_12682__$1 = state_12682;
var statearr_12687_12713 = state_12682__$1;
(statearr_12687_12713[(2)] = inst_12676);

(statearr_12687_12713[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12683 === (6))){
var inst_12667 = (state_12682[(2)]);
var state_12682__$1 = state_12682;
if(cljs.core.truth_(inst_12667)){
var statearr_12688_12714 = state_12682__$1;
(statearr_12688_12714[(1)] = (8));

} else {
var statearr_12689_12715 = state_12682__$1;
(statearr_12689_12715[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12683 === (3))){
var inst_12680 = (state_12682[(2)]);
var state_12682__$1 = state_12682;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_12682__$1,inst_12680);
} else {
if((state_val_12683 === (12))){
var state_12682__$1 = state_12682;
var statearr_12690_12716 = state_12682__$1;
(statearr_12690_12716[(2)] = null);

(statearr_12690_12716[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12683 === (2))){
var inst_12659 = (state_12682[(7)]);
var state_12682__$1 = state_12682;
if(cljs.core.truth_(inst_12659)){
var statearr_12691_12717 = state_12682__$1;
(statearr_12691_12717[(1)] = (4));

} else {
var statearr_12692_12718 = state_12682__$1;
(statearr_12692_12718[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12683 === (11))){
var inst_12673 = cljs.core.async.close_BANG_.call(null,ch);
var state_12682__$1 = state_12682;
var statearr_12693_12719 = state_12682__$1;
(statearr_12693_12719[(2)] = inst_12673);

(statearr_12693_12719[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12683 === (9))){
var state_12682__$1 = state_12682;
if(cljs.core.truth_(close_QMARK_)){
var statearr_12694_12720 = state_12682__$1;
(statearr_12694_12720[(1)] = (11));

} else {
var statearr_12695_12721 = state_12682__$1;
(statearr_12695_12721[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12683 === (5))){
var inst_12659 = (state_12682[(7)]);
var state_12682__$1 = state_12682;
var statearr_12696_12722 = state_12682__$1;
(statearr_12696_12722[(2)] = inst_12659);

(statearr_12696_12722[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12683 === (10))){
var inst_12678 = (state_12682[(2)]);
var state_12682__$1 = state_12682;
var statearr_12697_12723 = state_12682__$1;
(statearr_12697_12723[(2)] = inst_12678);

(statearr_12697_12723[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_12683 === (8))){
var inst_12659 = (state_12682[(7)]);
var inst_12669 = cljs.core.next.call(null,inst_12659);
var inst_12659__$1 = inst_12669;
var state_12682__$1 = (function (){var statearr_12698 = state_12682;
(statearr_12698[(7)] = inst_12659__$1);

return statearr_12698;
})();
var statearr_12699_12724 = state_12682__$1;
(statearr_12699_12724[(2)] = null);

(statearr_12699_12724[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11824__auto__))
;
return ((function (switch__11712__auto__,c__11824__auto__){
return (function() {
var cljs$core$async$state_machine__11713__auto__ = null;
var cljs$core$async$state_machine__11713__auto____0 = (function (){
var statearr_12703 = [null,null,null,null,null,null,null,null];
(statearr_12703[(0)] = cljs$core$async$state_machine__11713__auto__);

(statearr_12703[(1)] = (1));

return statearr_12703;
});
var cljs$core$async$state_machine__11713__auto____1 = (function (state_12682){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_12682);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e12704){if((e12704 instanceof Object)){
var ex__11716__auto__ = e12704;
var statearr_12705_12725 = state_12682;
(statearr_12705_12725[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_12682);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e12704;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__12726 = state_12682;
state_12682 = G__12726;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$state_machine__11713__auto__ = function(state_12682){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11713__auto____1.call(this,state_12682);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11713__auto____0;
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11713__auto____1;
return cljs$core$async$state_machine__11713__auto__;
})()
;})(switch__11712__auto__,c__11824__auto__))
})();
var state__11826__auto__ = (function (){var statearr_12706 = f__11825__auto__.call(null);
(statearr_12706[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto__);

return statearr_12706;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(c__11824__auto__))
);

return c__11824__auto__;
});

cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3;

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
var ch = cljs.core.async.chan.call(null,cljs.core.bounded_count.call(null,(100),coll));
cljs.core.async.onto_chan.call(null,ch,coll);

return ch;
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((!((_ == null))) && (!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
var x__7026__auto__ = (((_ == null))?null:_);
var m__7027__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__7026__auto__)]);
if(!((m__7027__auto__ == null))){
return m__7027__auto__.call(null,_);
} else {
var m__7027__auto____$1 = (cljs.core.async.muxch_STAR_["_"]);
if(!((m__7027__auto____$1 == null))){
return m__7027__auto____$1.call(null,_);
} else {
throw cljs.core.missing_protocol.call(null,"Mux.muxch*",_);
}
}
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((!((m == null))) && (!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
var x__7026__auto__ = (((m == null))?null:m);
var m__7027__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__7026__auto__)]);
if(!((m__7027__auto__ == null))){
return m__7027__auto__.call(null,m,ch,close_QMARK_);
} else {
var m__7027__auto____$1 = (cljs.core.async.tap_STAR_["_"]);
if(!((m__7027__auto____$1 == null))){
return m__7027__auto____$1.call(null,m,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.tap*",m);
}
}
}
});

cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
var x__7026__auto__ = (((m == null))?null:m);
var m__7027__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__7026__auto__)]);
if(!((m__7027__auto__ == null))){
return m__7027__auto__.call(null,m,ch);
} else {
var m__7027__auto____$1 = (cljs.core.async.untap_STAR_["_"]);
if(!((m__7027__auto____$1 == null))){
return m__7027__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap*",m);
}
}
}
});

cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
var x__7026__auto__ = (((m == null))?null:m);
var m__7027__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__7026__auto__)]);
if(!((m__7027__auto__ == null))){
return m__7027__auto__.call(null,m);
} else {
var m__7027__auto____$1 = (cljs.core.async.untap_all_STAR_["_"]);
if(!((m__7027__auto____$1 == null))){
return m__7027__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mult.untap-all*",m);
}
}
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async12952 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async12952 = (function (ch,cs,meta12953){
this.ch = ch;
this.cs = cs;
this.meta12953 = meta12953;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async12952.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs){
return (function (_12954,meta12953__$1){
var self__ = this;
var _12954__$1 = this;
return (new cljs.core.async.t_cljs$core$async12952(self__.ch,self__.cs,meta12953__$1));
});})(cs))
;

cljs.core.async.t_cljs$core$async12952.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs){
return (function (_12954){
var self__ = this;
var _12954__$1 = this;
return self__.meta12953;
});})(cs))
;

cljs.core.async.t_cljs$core$async12952.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12952.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(cs))
;

cljs.core.async.t_cljs$core$async12952.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async12952.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = ((function (cs){
return (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12952.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = ((function (cs){
return (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch__$1);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12952.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = ((function (cs){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
});})(cs))
;

cljs.core.async.t_cljs$core$async12952.getBasis = ((function (cs){
return (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta12953","meta12953",915839804,null)], null);
});})(cs))
;

cljs.core.async.t_cljs$core$async12952.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async12952.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async12952";

cljs.core.async.t_cljs$core$async12952.cljs$lang$ctorPrWriter = ((function (cs){
return (function (this__6969__auto__,writer__6970__auto__,opt__6971__auto__){
return cljs.core._write.call(null,writer__6970__auto__,"cljs.core.async/t_cljs$core$async12952");
});})(cs))
;

cljs.core.async.__GT_t_cljs$core$async12952 = ((function (cs){
return (function cljs$core$async$mult_$___GT_t_cljs$core$async12952(ch__$1,cs__$1,meta12953){
return (new cljs.core.async.t_cljs$core$async12952(ch__$1,cs__$1,meta12953));
});})(cs))
;

}

return (new cljs.core.async.t_cljs$core$async12952(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = ((function (cs,m,dchan,dctr){
return (function (_){
if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,true);
} else {
return null;
}
});})(cs,m,dchan,dctr))
;
var c__11824__auto___13177 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11824__auto___13177,cs,m,dchan,dctr,done){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (c__11824__auto___13177,cs,m,dchan,dctr,done){
return (function (state_13089){
var state_val_13090 = (state_13089[(1)]);
if((state_val_13090 === (7))){
var inst_13085 = (state_13089[(2)]);
var state_13089__$1 = state_13089;
var statearr_13091_13178 = state_13089__$1;
(statearr_13091_13178[(2)] = inst_13085);

(statearr_13091_13178[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (20))){
var inst_12988 = (state_13089[(7)]);
var inst_13000 = cljs.core.first.call(null,inst_12988);
var inst_13001 = cljs.core.nth.call(null,inst_13000,(0),null);
var inst_13002 = cljs.core.nth.call(null,inst_13000,(1),null);
var state_13089__$1 = (function (){var statearr_13092 = state_13089;
(statearr_13092[(8)] = inst_13001);

return statearr_13092;
})();
if(cljs.core.truth_(inst_13002)){
var statearr_13093_13179 = state_13089__$1;
(statearr_13093_13179[(1)] = (22));

} else {
var statearr_13094_13180 = state_13089__$1;
(statearr_13094_13180[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (27))){
var inst_12957 = (state_13089[(9)]);
var inst_13032 = (state_13089[(10)]);
var inst_13030 = (state_13089[(11)]);
var inst_13037 = (state_13089[(12)]);
var inst_13037__$1 = cljs.core._nth.call(null,inst_13030,inst_13032);
var inst_13038 = cljs.core.async.put_BANG_.call(null,inst_13037__$1,inst_12957,done);
var state_13089__$1 = (function (){var statearr_13095 = state_13089;
(statearr_13095[(12)] = inst_13037__$1);

return statearr_13095;
})();
if(cljs.core.truth_(inst_13038)){
var statearr_13096_13181 = state_13089__$1;
(statearr_13096_13181[(1)] = (30));

} else {
var statearr_13097_13182 = state_13089__$1;
(statearr_13097_13182[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (1))){
var state_13089__$1 = state_13089;
var statearr_13098_13183 = state_13089__$1;
(statearr_13098_13183[(2)] = null);

(statearr_13098_13183[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (24))){
var inst_12988 = (state_13089[(7)]);
var inst_13007 = (state_13089[(2)]);
var inst_13008 = cljs.core.next.call(null,inst_12988);
var inst_12966 = inst_13008;
var inst_12967 = null;
var inst_12968 = (0);
var inst_12969 = (0);
var state_13089__$1 = (function (){var statearr_13099 = state_13089;
(statearr_13099[(13)] = inst_13007);

(statearr_13099[(14)] = inst_12966);

(statearr_13099[(15)] = inst_12969);

(statearr_13099[(16)] = inst_12967);

(statearr_13099[(17)] = inst_12968);

return statearr_13099;
})();
var statearr_13100_13184 = state_13089__$1;
(statearr_13100_13184[(2)] = null);

(statearr_13100_13184[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (39))){
var state_13089__$1 = state_13089;
var statearr_13104_13185 = state_13089__$1;
(statearr_13104_13185[(2)] = null);

(statearr_13104_13185[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (4))){
var inst_12957 = (state_13089[(9)]);
var inst_12957__$1 = (state_13089[(2)]);
var inst_12958 = (inst_12957__$1 == null);
var state_13089__$1 = (function (){var statearr_13105 = state_13089;
(statearr_13105[(9)] = inst_12957__$1);

return statearr_13105;
})();
if(cljs.core.truth_(inst_12958)){
var statearr_13106_13186 = state_13089__$1;
(statearr_13106_13186[(1)] = (5));

} else {
var statearr_13107_13187 = state_13089__$1;
(statearr_13107_13187[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (15))){
var inst_12966 = (state_13089[(14)]);
var inst_12969 = (state_13089[(15)]);
var inst_12967 = (state_13089[(16)]);
var inst_12968 = (state_13089[(17)]);
var inst_12984 = (state_13089[(2)]);
var inst_12985 = (inst_12969 + (1));
var tmp13101 = inst_12966;
var tmp13102 = inst_12967;
var tmp13103 = inst_12968;
var inst_12966__$1 = tmp13101;
var inst_12967__$1 = tmp13102;
var inst_12968__$1 = tmp13103;
var inst_12969__$1 = inst_12985;
var state_13089__$1 = (function (){var statearr_13108 = state_13089;
(statearr_13108[(14)] = inst_12966__$1);

(statearr_13108[(15)] = inst_12969__$1);

(statearr_13108[(16)] = inst_12967__$1);

(statearr_13108[(18)] = inst_12984);

(statearr_13108[(17)] = inst_12968__$1);

return statearr_13108;
})();
var statearr_13109_13188 = state_13089__$1;
(statearr_13109_13188[(2)] = null);

(statearr_13109_13188[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (21))){
var inst_13011 = (state_13089[(2)]);
var state_13089__$1 = state_13089;
var statearr_13113_13189 = state_13089__$1;
(statearr_13113_13189[(2)] = inst_13011);

(statearr_13113_13189[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (31))){
var inst_13037 = (state_13089[(12)]);
var inst_13041 = done.call(null,null);
var inst_13042 = cljs.core.async.untap_STAR_.call(null,m,inst_13037);
var state_13089__$1 = (function (){var statearr_13114 = state_13089;
(statearr_13114[(19)] = inst_13041);

return statearr_13114;
})();
var statearr_13115_13190 = state_13089__$1;
(statearr_13115_13190[(2)] = inst_13042);

(statearr_13115_13190[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (32))){
var inst_13031 = (state_13089[(20)]);
var inst_13032 = (state_13089[(10)]);
var inst_13029 = (state_13089[(21)]);
var inst_13030 = (state_13089[(11)]);
var inst_13044 = (state_13089[(2)]);
var inst_13045 = (inst_13032 + (1));
var tmp13110 = inst_13031;
var tmp13111 = inst_13029;
var tmp13112 = inst_13030;
var inst_13029__$1 = tmp13111;
var inst_13030__$1 = tmp13112;
var inst_13031__$1 = tmp13110;
var inst_13032__$1 = inst_13045;
var state_13089__$1 = (function (){var statearr_13116 = state_13089;
(statearr_13116[(20)] = inst_13031__$1);

(statearr_13116[(10)] = inst_13032__$1);

(statearr_13116[(21)] = inst_13029__$1);

(statearr_13116[(11)] = inst_13030__$1);

(statearr_13116[(22)] = inst_13044);

return statearr_13116;
})();
var statearr_13117_13191 = state_13089__$1;
(statearr_13117_13191[(2)] = null);

(statearr_13117_13191[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (40))){
var inst_13057 = (state_13089[(23)]);
var inst_13061 = done.call(null,null);
var inst_13062 = cljs.core.async.untap_STAR_.call(null,m,inst_13057);
var state_13089__$1 = (function (){var statearr_13118 = state_13089;
(statearr_13118[(24)] = inst_13061);

return statearr_13118;
})();
var statearr_13119_13192 = state_13089__$1;
(statearr_13119_13192[(2)] = inst_13062);

(statearr_13119_13192[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (33))){
var inst_13048 = (state_13089[(25)]);
var inst_13050 = cljs.core.chunked_seq_QMARK_.call(null,inst_13048);
var state_13089__$1 = state_13089;
if(inst_13050){
var statearr_13120_13193 = state_13089__$1;
(statearr_13120_13193[(1)] = (36));

} else {
var statearr_13121_13194 = state_13089__$1;
(statearr_13121_13194[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (13))){
var inst_12978 = (state_13089[(26)]);
var inst_12981 = cljs.core.async.close_BANG_.call(null,inst_12978);
var state_13089__$1 = state_13089;
var statearr_13122_13195 = state_13089__$1;
(statearr_13122_13195[(2)] = inst_12981);

(statearr_13122_13195[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (22))){
var inst_13001 = (state_13089[(8)]);
var inst_13004 = cljs.core.async.close_BANG_.call(null,inst_13001);
var state_13089__$1 = state_13089;
var statearr_13123_13196 = state_13089__$1;
(statearr_13123_13196[(2)] = inst_13004);

(statearr_13123_13196[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (36))){
var inst_13048 = (state_13089[(25)]);
var inst_13052 = cljs.core.chunk_first.call(null,inst_13048);
var inst_13053 = cljs.core.chunk_rest.call(null,inst_13048);
var inst_13054 = cljs.core.count.call(null,inst_13052);
var inst_13029 = inst_13053;
var inst_13030 = inst_13052;
var inst_13031 = inst_13054;
var inst_13032 = (0);
var state_13089__$1 = (function (){var statearr_13124 = state_13089;
(statearr_13124[(20)] = inst_13031);

(statearr_13124[(10)] = inst_13032);

(statearr_13124[(21)] = inst_13029);

(statearr_13124[(11)] = inst_13030);

return statearr_13124;
})();
var statearr_13125_13197 = state_13089__$1;
(statearr_13125_13197[(2)] = null);

(statearr_13125_13197[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (41))){
var inst_13048 = (state_13089[(25)]);
var inst_13064 = (state_13089[(2)]);
var inst_13065 = cljs.core.next.call(null,inst_13048);
var inst_13029 = inst_13065;
var inst_13030 = null;
var inst_13031 = (0);
var inst_13032 = (0);
var state_13089__$1 = (function (){var statearr_13126 = state_13089;
(statearr_13126[(20)] = inst_13031);

(statearr_13126[(27)] = inst_13064);

(statearr_13126[(10)] = inst_13032);

(statearr_13126[(21)] = inst_13029);

(statearr_13126[(11)] = inst_13030);

return statearr_13126;
})();
var statearr_13127_13198 = state_13089__$1;
(statearr_13127_13198[(2)] = null);

(statearr_13127_13198[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (43))){
var state_13089__$1 = state_13089;
var statearr_13128_13199 = state_13089__$1;
(statearr_13128_13199[(2)] = null);

(statearr_13128_13199[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (29))){
var inst_13073 = (state_13089[(2)]);
var state_13089__$1 = state_13089;
var statearr_13129_13200 = state_13089__$1;
(statearr_13129_13200[(2)] = inst_13073);

(statearr_13129_13200[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (44))){
var inst_13082 = (state_13089[(2)]);
var state_13089__$1 = (function (){var statearr_13130 = state_13089;
(statearr_13130[(28)] = inst_13082);

return statearr_13130;
})();
var statearr_13131_13201 = state_13089__$1;
(statearr_13131_13201[(2)] = null);

(statearr_13131_13201[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (6))){
var inst_13021 = (state_13089[(29)]);
var inst_13020 = cljs.core.deref.call(null,cs);
var inst_13021__$1 = cljs.core.keys.call(null,inst_13020);
var inst_13022 = cljs.core.count.call(null,inst_13021__$1);
var inst_13023 = cljs.core.reset_BANG_.call(null,dctr,inst_13022);
var inst_13028 = cljs.core.seq.call(null,inst_13021__$1);
var inst_13029 = inst_13028;
var inst_13030 = null;
var inst_13031 = (0);
var inst_13032 = (0);
var state_13089__$1 = (function (){var statearr_13132 = state_13089;
(statearr_13132[(20)] = inst_13031);

(statearr_13132[(30)] = inst_13023);

(statearr_13132[(10)] = inst_13032);

(statearr_13132[(21)] = inst_13029);

(statearr_13132[(11)] = inst_13030);

(statearr_13132[(29)] = inst_13021__$1);

return statearr_13132;
})();
var statearr_13133_13202 = state_13089__$1;
(statearr_13133_13202[(2)] = null);

(statearr_13133_13202[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (28))){
var inst_13048 = (state_13089[(25)]);
var inst_13029 = (state_13089[(21)]);
var inst_13048__$1 = cljs.core.seq.call(null,inst_13029);
var state_13089__$1 = (function (){var statearr_13134 = state_13089;
(statearr_13134[(25)] = inst_13048__$1);

return statearr_13134;
})();
if(inst_13048__$1){
var statearr_13135_13203 = state_13089__$1;
(statearr_13135_13203[(1)] = (33));

} else {
var statearr_13136_13204 = state_13089__$1;
(statearr_13136_13204[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (25))){
var inst_13031 = (state_13089[(20)]);
var inst_13032 = (state_13089[(10)]);
var inst_13034 = (inst_13032 < inst_13031);
var inst_13035 = inst_13034;
var state_13089__$1 = state_13089;
if(cljs.core.truth_(inst_13035)){
var statearr_13137_13205 = state_13089__$1;
(statearr_13137_13205[(1)] = (27));

} else {
var statearr_13138_13206 = state_13089__$1;
(statearr_13138_13206[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (34))){
var state_13089__$1 = state_13089;
var statearr_13139_13207 = state_13089__$1;
(statearr_13139_13207[(2)] = null);

(statearr_13139_13207[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (17))){
var state_13089__$1 = state_13089;
var statearr_13140_13208 = state_13089__$1;
(statearr_13140_13208[(2)] = null);

(statearr_13140_13208[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (3))){
var inst_13087 = (state_13089[(2)]);
var state_13089__$1 = state_13089;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13089__$1,inst_13087);
} else {
if((state_val_13090 === (12))){
var inst_13016 = (state_13089[(2)]);
var state_13089__$1 = state_13089;
var statearr_13141_13209 = state_13089__$1;
(statearr_13141_13209[(2)] = inst_13016);

(statearr_13141_13209[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (2))){
var state_13089__$1 = state_13089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13089__$1,(4),ch);
} else {
if((state_val_13090 === (23))){
var state_13089__$1 = state_13089;
var statearr_13142_13210 = state_13089__$1;
(statearr_13142_13210[(2)] = null);

(statearr_13142_13210[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (35))){
var inst_13071 = (state_13089[(2)]);
var state_13089__$1 = state_13089;
var statearr_13143_13211 = state_13089__$1;
(statearr_13143_13211[(2)] = inst_13071);

(statearr_13143_13211[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (19))){
var inst_12988 = (state_13089[(7)]);
var inst_12992 = cljs.core.chunk_first.call(null,inst_12988);
var inst_12993 = cljs.core.chunk_rest.call(null,inst_12988);
var inst_12994 = cljs.core.count.call(null,inst_12992);
var inst_12966 = inst_12993;
var inst_12967 = inst_12992;
var inst_12968 = inst_12994;
var inst_12969 = (0);
var state_13089__$1 = (function (){var statearr_13144 = state_13089;
(statearr_13144[(14)] = inst_12966);

(statearr_13144[(15)] = inst_12969);

(statearr_13144[(16)] = inst_12967);

(statearr_13144[(17)] = inst_12968);

return statearr_13144;
})();
var statearr_13145_13212 = state_13089__$1;
(statearr_13145_13212[(2)] = null);

(statearr_13145_13212[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (11))){
var inst_12966 = (state_13089[(14)]);
var inst_12988 = (state_13089[(7)]);
var inst_12988__$1 = cljs.core.seq.call(null,inst_12966);
var state_13089__$1 = (function (){var statearr_13146 = state_13089;
(statearr_13146[(7)] = inst_12988__$1);

return statearr_13146;
})();
if(inst_12988__$1){
var statearr_13147_13213 = state_13089__$1;
(statearr_13147_13213[(1)] = (16));

} else {
var statearr_13148_13214 = state_13089__$1;
(statearr_13148_13214[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (9))){
var inst_13018 = (state_13089[(2)]);
var state_13089__$1 = state_13089;
var statearr_13149_13215 = state_13089__$1;
(statearr_13149_13215[(2)] = inst_13018);

(statearr_13149_13215[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (5))){
var inst_12964 = cljs.core.deref.call(null,cs);
var inst_12965 = cljs.core.seq.call(null,inst_12964);
var inst_12966 = inst_12965;
var inst_12967 = null;
var inst_12968 = (0);
var inst_12969 = (0);
var state_13089__$1 = (function (){var statearr_13150 = state_13089;
(statearr_13150[(14)] = inst_12966);

(statearr_13150[(15)] = inst_12969);

(statearr_13150[(16)] = inst_12967);

(statearr_13150[(17)] = inst_12968);

return statearr_13150;
})();
var statearr_13151_13216 = state_13089__$1;
(statearr_13151_13216[(2)] = null);

(statearr_13151_13216[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (14))){
var state_13089__$1 = state_13089;
var statearr_13152_13217 = state_13089__$1;
(statearr_13152_13217[(2)] = null);

(statearr_13152_13217[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (45))){
var inst_13079 = (state_13089[(2)]);
var state_13089__$1 = state_13089;
var statearr_13153_13218 = state_13089__$1;
(statearr_13153_13218[(2)] = inst_13079);

(statearr_13153_13218[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (26))){
var inst_13021 = (state_13089[(29)]);
var inst_13075 = (state_13089[(2)]);
var inst_13076 = cljs.core.seq.call(null,inst_13021);
var state_13089__$1 = (function (){var statearr_13154 = state_13089;
(statearr_13154[(31)] = inst_13075);

return statearr_13154;
})();
if(inst_13076){
var statearr_13155_13219 = state_13089__$1;
(statearr_13155_13219[(1)] = (42));

} else {
var statearr_13156_13220 = state_13089__$1;
(statearr_13156_13220[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (16))){
var inst_12988 = (state_13089[(7)]);
var inst_12990 = cljs.core.chunked_seq_QMARK_.call(null,inst_12988);
var state_13089__$1 = state_13089;
if(inst_12990){
var statearr_13157_13221 = state_13089__$1;
(statearr_13157_13221[(1)] = (19));

} else {
var statearr_13158_13222 = state_13089__$1;
(statearr_13158_13222[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (38))){
var inst_13068 = (state_13089[(2)]);
var state_13089__$1 = state_13089;
var statearr_13159_13223 = state_13089__$1;
(statearr_13159_13223[(2)] = inst_13068);

(statearr_13159_13223[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (30))){
var state_13089__$1 = state_13089;
var statearr_13160_13224 = state_13089__$1;
(statearr_13160_13224[(2)] = null);

(statearr_13160_13224[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (10))){
var inst_12969 = (state_13089[(15)]);
var inst_12967 = (state_13089[(16)]);
var inst_12977 = cljs.core._nth.call(null,inst_12967,inst_12969);
var inst_12978 = cljs.core.nth.call(null,inst_12977,(0),null);
var inst_12979 = cljs.core.nth.call(null,inst_12977,(1),null);
var state_13089__$1 = (function (){var statearr_13161 = state_13089;
(statearr_13161[(26)] = inst_12978);

return statearr_13161;
})();
if(cljs.core.truth_(inst_12979)){
var statearr_13162_13225 = state_13089__$1;
(statearr_13162_13225[(1)] = (13));

} else {
var statearr_13163_13226 = state_13089__$1;
(statearr_13163_13226[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (18))){
var inst_13014 = (state_13089[(2)]);
var state_13089__$1 = state_13089;
var statearr_13164_13227 = state_13089__$1;
(statearr_13164_13227[(2)] = inst_13014);

(statearr_13164_13227[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (42))){
var state_13089__$1 = state_13089;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13089__$1,(45),dchan);
} else {
if((state_val_13090 === (37))){
var inst_13048 = (state_13089[(25)]);
var inst_12957 = (state_13089[(9)]);
var inst_13057 = (state_13089[(23)]);
var inst_13057__$1 = cljs.core.first.call(null,inst_13048);
var inst_13058 = cljs.core.async.put_BANG_.call(null,inst_13057__$1,inst_12957,done);
var state_13089__$1 = (function (){var statearr_13165 = state_13089;
(statearr_13165[(23)] = inst_13057__$1);

return statearr_13165;
})();
if(cljs.core.truth_(inst_13058)){
var statearr_13166_13228 = state_13089__$1;
(statearr_13166_13228[(1)] = (39));

} else {
var statearr_13167_13229 = state_13089__$1;
(statearr_13167_13229[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13090 === (8))){
var inst_12969 = (state_13089[(15)]);
var inst_12968 = (state_13089[(17)]);
var inst_12971 = (inst_12969 < inst_12968);
var inst_12972 = inst_12971;
var state_13089__$1 = state_13089;
if(cljs.core.truth_(inst_12972)){
var statearr_13168_13230 = state_13089__$1;
(statearr_13168_13230[(1)] = (10));

} else {
var statearr_13169_13231 = state_13089__$1;
(statearr_13169_13231[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11824__auto___13177,cs,m,dchan,dctr,done))
;
return ((function (switch__11712__auto__,c__11824__auto___13177,cs,m,dchan,dctr,done){
return (function() {
var cljs$core$async$mult_$_state_machine__11713__auto__ = null;
var cljs$core$async$mult_$_state_machine__11713__auto____0 = (function (){
var statearr_13173 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13173[(0)] = cljs$core$async$mult_$_state_machine__11713__auto__);

(statearr_13173[(1)] = (1));

return statearr_13173;
});
var cljs$core$async$mult_$_state_machine__11713__auto____1 = (function (state_13089){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_13089);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e13174){if((e13174 instanceof Object)){
var ex__11716__auto__ = e13174;
var statearr_13175_13232 = state_13089;
(statearr_13175_13232[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13089);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13174;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13233 = state_13089;
state_13089 = G__13233;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__11713__auto__ = function(state_13089){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__11713__auto____1.call(this,state_13089);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mult_$_state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__11713__auto____0;
cljs$core$async$mult_$_state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__11713__auto____1;
return cljs$core$async$mult_$_state_machine__11713__auto__;
})()
;})(switch__11712__auto__,c__11824__auto___13177,cs,m,dchan,dctr,done))
})();
var state__11826__auto__ = (function (){var statearr_13176 = f__11825__auto__.call(null);
(statearr_13176[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto___13177);

return statearr_13176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(c__11824__auto___13177,cs,m,dchan,dctr,done))
);


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var args13234 = [];
var len__7471__auto___13237 = arguments.length;
var i__7472__auto___13238 = (0);
while(true){
if((i__7472__auto___13238 < len__7471__auto___13237)){
args13234.push((arguments[i__7472__auto___13238]));

var G__13239 = (i__7472__auto___13238 + (1));
i__7472__auto___13238 = G__13239;
continue;
} else {
}
break;
}

var G__13236 = args13234.length;
switch (G__13236) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13234.length)].join('')));

}
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.call(null,mult,ch,true);
});

cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_.call(null,mult,ch,close_QMARK_);

return ch;
});

cljs.core.async.tap.cljs$lang$maxFixedArity = 3;

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_.call(null,mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_.call(null,mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
var x__7026__auto__ = (((m == null))?null:m);
var m__7027__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__7026__auto__)]);
if(!((m__7027__auto__ == null))){
return m__7027__auto__.call(null,m,ch);
} else {
var m__7027__auto____$1 = (cljs.core.async.admix_STAR_["_"]);
if(!((m__7027__auto____$1 == null))){
return m__7027__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.admix*",m);
}
}
}
});

cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
var x__7026__auto__ = (((m == null))?null:m);
var m__7027__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__7026__auto__)]);
if(!((m__7027__auto__ == null))){
return m__7027__auto__.call(null,m,ch);
} else {
var m__7027__auto____$1 = (cljs.core.async.unmix_STAR_["_"]);
if(!((m__7027__auto____$1 == null))){
return m__7027__auto____$1.call(null,m,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix*",m);
}
}
}
});

cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((!((m == null))) && (!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
var x__7026__auto__ = (((m == null))?null:m);
var m__7027__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__7026__auto__)]);
if(!((m__7027__auto__ == null))){
return m__7027__auto__.call(null,m);
} else {
var m__7027__auto____$1 = (cljs.core.async.unmix_all_STAR_["_"]);
if(!((m__7027__auto____$1 == null))){
return m__7027__auto____$1.call(null,m);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.unmix-all*",m);
}
}
}
});

cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((!((m == null))) && (!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
var x__7026__auto__ = (((m == null))?null:m);
var m__7027__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__7026__auto__)]);
if(!((m__7027__auto__ == null))){
return m__7027__auto__.call(null,m,state_map);
} else {
var m__7027__auto____$1 = (cljs.core.async.toggle_STAR_["_"]);
if(!((m__7027__auto____$1 == null))){
return m__7027__auto____$1.call(null,m,state_map);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.toggle*",m);
}
}
}
});

cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((!((m == null))) && (!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
var x__7026__auto__ = (((m == null))?null:m);
var m__7027__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__7026__auto__)]);
if(!((m__7027__auto__ == null))){
return m__7027__auto__.call(null,m,mode);
} else {
var m__7027__auto____$1 = (cljs.core.async.solo_mode_STAR_["_"]);
if(!((m__7027__auto____$1 == null))){
return m__7027__auto____$1.call(null,m,mode);
} else {
throw cljs.core.missing_protocol.call(null,"Mix.solo-mode*",m);
}
}
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__7478__auto__ = [];
var len__7471__auto___13251 = arguments.length;
var i__7472__auto___13252 = (0);
while(true){
if((i__7472__auto___13252 < len__7471__auto___13251)){
args__7478__auto__.push((arguments[i__7472__auto___13252]));

var G__13253 = (i__7472__auto___13252 + (1));
i__7472__auto___13252 = G__13253;
continue;
} else {
}
break;
}

var argseq__7479__auto__ = ((((3) < args__7478__auto__.length))?(new cljs.core.IndexedSeq(args__7478__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7479__auto__);
});

cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__13245){
var map__13246 = p__13245;
var map__13246__$1 = ((((!((map__13246 == null)))?((((map__13246.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__13246.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__13246):map__13246);
var opts = map__13246__$1;
var statearr_13248_13254 = state;
(statearr_13248_13254[cljs.core.async.impl.ioc_helpers.STATE_IDX] = cont_block);


var temp__4657__auto__ = cljs.core.async.do_alts.call(null,((function (map__13246,map__13246__$1,opts){
return (function (val){
var statearr_13249_13255 = state;
(statearr_13249_13255[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state);
});})(map__13246,map__13246__$1,opts))
,ports,opts);
if(cljs.core.truth_(temp__4657__auto__)){
var cb = temp__4657__auto__;
var statearr_13250_13256 = state;
(statearr_13250_13256[cljs.core.async.impl.ioc_helpers.VALUE_IDX] = cljs.core.deref.call(null,cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
});

cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3);

cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq13241){
var G__13242 = cljs.core.first.call(null,seq13241);
var seq13241__$1 = cljs.core.next.call(null,seq13241);
var G__13243 = cljs.core.first.call(null,seq13241__$1);
var seq13241__$2 = cljs.core.next.call(null,seq13241__$1);
var G__13244 = cljs.core.first.call(null,seq13241__$2);
var seq13241__$3 = cljs.core.next.call(null,seq13241__$2);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__13242,G__13243,G__13244,seq13241__$3);
});

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.call(null,solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.call(null);
var changed = ((function (cs,solo_modes,attrs,solo_mode,change){
return (function (){
return cljs.core.async.put_BANG_.call(null,change,true);
});})(cs,solo_modes,attrs,solo_mode,change))
;
var pick = ((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (attr,chs){
return cljs.core.reduce_kv.call(null,((function (cs,solo_modes,attrs,solo_mode,change,changed){
return (function (ret,c,v){
if(cljs.core.truth_(attr.call(null,v))){
return cljs.core.conj.call(null,ret,c);
} else {
return ret;
}
});})(cs,solo_modes,attrs,solo_mode,change,changed))
,cljs.core.PersistentHashSet.EMPTY,chs);
});})(cs,solo_modes,attrs,solo_mode,change,changed))
;
var calc_state = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick){
return (function (){
var chs = cljs.core.deref.call(null,cs);
var mode = cljs.core.deref.call(null,solo_mode);
var solos = pick.call(null,new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick.call(null,new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick.call(null,new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.call(null,(((cljs.core._EQ_.call(null,mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (!(cljs.core.empty_QMARK_.call(null,solos))))?cljs.core.vec.call(null,solos):cljs.core.vec.call(null,cljs.core.remove.call(null,pauses,cljs.core.keys.call(null,chs)))),change)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick))
;
var m = (function (){
if(typeof cljs.core.async.t_cljs$core$async13424 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13424 = (function (out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,meta13425){
this.out = out;
this.cs = cs;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.solo_mode = solo_mode;
this.change = change;
this.changed = changed;
this.pick = pick;
this.calc_state = calc_state;
this.meta13425 = meta13425;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13424.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13426,meta13425__$1){
var self__ = this;
var _13426__$1 = this;
return (new cljs.core.async.t_cljs$core$async13424(self__.out,self__.cs,self__.solo_modes,self__.attrs,self__.solo_mode,self__.change,self__.changed,self__.pick,self__.calc_state,meta13425__$1));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13424.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_13426){
var self__ = this;
var _13426__$1 = this;
return self__.meta13425;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13424.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async13424.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13424.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async13424.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13424.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.dissoc,ch);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13424.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_.call(null,self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13424.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.call(null,self__.cs,cljs.core.partial.call(null,cljs.core.merge_with,cljs.core.merge),state_map);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13424.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.solo_modes.call(null,mode))){
} else {
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Assert failed: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1("mode must be one of: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join('')),cljs.core.str.cljs$core$IFn$_invoke$arity$1("\n"),cljs.core.str.cljs$core$IFn$_invoke$arity$1("(solo-modes mode)")].join('')));
}

cljs.core.reset_BANG_.call(null,self__.solo_mode,mode);

return self__.changed.call(null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13424.getBasis = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"meta13425","meta13425",1359963653,null)], null);
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.t_cljs$core$async13424.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13424.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13424";

cljs.core.async.t_cljs$core$async13424.cljs$lang$ctorPrWriter = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function (this__6969__auto__,writer__6970__auto__,opt__6971__auto__){
return cljs.core._write.call(null,writer__6970__auto__,"cljs.core.async/t_cljs$core$async13424");
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

cljs.core.async.__GT_t_cljs$core$async13424 = ((function (cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state){
return (function cljs$core$async$mix_$___GT_t_cljs$core$async13424(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta13425){
return (new cljs.core.async.t_cljs$core$async13424(out__$1,cs__$1,solo_modes__$1,attrs__$1,solo_mode__$1,change__$1,changed__$1,pick__$1,calc_state__$1,meta13425));
});})(cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state))
;

}

return (new cljs.core.async.t_cljs$core$async13424(out,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11824__auto___13591 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11824__auto___13591,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (c__11824__auto___13591,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function (state_13528){
var state_val_13529 = (state_13528[(1)]);
if((state_val_13529 === (7))){
var inst_13443 = (state_13528[(2)]);
var state_13528__$1 = state_13528;
var statearr_13530_13592 = state_13528__$1;
(statearr_13530_13592[(2)] = inst_13443);

(statearr_13530_13592[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (20))){
var inst_13455 = (state_13528[(7)]);
var state_13528__$1 = state_13528;
var statearr_13531_13593 = state_13528__$1;
(statearr_13531_13593[(2)] = inst_13455);

(statearr_13531_13593[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (27))){
var state_13528__$1 = state_13528;
var statearr_13532_13594 = state_13528__$1;
(statearr_13532_13594[(2)] = null);

(statearr_13532_13594[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (1))){
var inst_13430 = (state_13528[(8)]);
var inst_13430__$1 = calc_state.call(null);
var inst_13432 = (inst_13430__$1 == null);
var inst_13433 = cljs.core.not.call(null,inst_13432);
var state_13528__$1 = (function (){var statearr_13533 = state_13528;
(statearr_13533[(8)] = inst_13430__$1);

return statearr_13533;
})();
if(inst_13433){
var statearr_13534_13595 = state_13528__$1;
(statearr_13534_13595[(1)] = (2));

} else {
var statearr_13535_13596 = state_13528__$1;
(statearr_13535_13596[(1)] = (3));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (24))){
var inst_13479 = (state_13528[(9)]);
var inst_13502 = (state_13528[(10)]);
var inst_13488 = (state_13528[(11)]);
var inst_13502__$1 = inst_13479.call(null,inst_13488);
var state_13528__$1 = (function (){var statearr_13536 = state_13528;
(statearr_13536[(10)] = inst_13502__$1);

return statearr_13536;
})();
if(cljs.core.truth_(inst_13502__$1)){
var statearr_13537_13597 = state_13528__$1;
(statearr_13537_13597[(1)] = (29));

} else {
var statearr_13538_13598 = state_13528__$1;
(statearr_13538_13598[(1)] = (30));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (4))){
var inst_13446 = (state_13528[(2)]);
var state_13528__$1 = state_13528;
if(cljs.core.truth_(inst_13446)){
var statearr_13539_13599 = state_13528__$1;
(statearr_13539_13599[(1)] = (8));

} else {
var statearr_13540_13600 = state_13528__$1;
(statearr_13540_13600[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (15))){
var inst_13473 = (state_13528[(2)]);
var state_13528__$1 = state_13528;
if(cljs.core.truth_(inst_13473)){
var statearr_13541_13601 = state_13528__$1;
(statearr_13541_13601[(1)] = (19));

} else {
var statearr_13542_13602 = state_13528__$1;
(statearr_13542_13602[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (21))){
var inst_13478 = (state_13528[(12)]);
var inst_13478__$1 = (state_13528[(2)]);
var inst_13479 = cljs.core.get.call(null,inst_13478__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13480 = cljs.core.get.call(null,inst_13478__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13481 = cljs.core.get.call(null,inst_13478__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_13528__$1 = (function (){var statearr_13543 = state_13528;
(statearr_13543[(9)] = inst_13479);

(statearr_13543[(12)] = inst_13478__$1);

(statearr_13543[(13)] = inst_13480);

return statearr_13543;
})();
return cljs.core.async.ioc_alts_BANG_.call(null,state_13528__$1,(22),inst_13481);
} else {
if((state_val_13529 === (31))){
var inst_13510 = (state_13528[(2)]);
var state_13528__$1 = state_13528;
if(cljs.core.truth_(inst_13510)){
var statearr_13544_13603 = state_13528__$1;
(statearr_13544_13603[(1)] = (32));

} else {
var statearr_13545_13604 = state_13528__$1;
(statearr_13545_13604[(1)] = (33));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (32))){
var inst_13487 = (state_13528[(14)]);
var state_13528__$1 = state_13528;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13528__$1,(35),out,inst_13487);
} else {
if((state_val_13529 === (33))){
var inst_13478 = (state_13528[(12)]);
var inst_13455 = inst_13478;
var state_13528__$1 = (function (){var statearr_13546 = state_13528;
(statearr_13546[(7)] = inst_13455);

return statearr_13546;
})();
var statearr_13547_13605 = state_13528__$1;
(statearr_13547_13605[(2)] = null);

(statearr_13547_13605[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (13))){
var inst_13455 = (state_13528[(7)]);
var inst_13462 = inst_13455.cljs$lang$protocol_mask$partition0$;
var inst_13463 = (inst_13462 & (64));
var inst_13464 = inst_13455.cljs$core$ISeq$;
var inst_13465 = (cljs.core.PROTOCOL_SENTINEL === inst_13464);
var inst_13466 = (inst_13463) || (inst_13465);
var state_13528__$1 = state_13528;
if(cljs.core.truth_(inst_13466)){
var statearr_13548_13606 = state_13528__$1;
(statearr_13548_13606[(1)] = (16));

} else {
var statearr_13549_13607 = state_13528__$1;
(statearr_13549_13607[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (22))){
var inst_13488 = (state_13528[(11)]);
var inst_13487 = (state_13528[(14)]);
var inst_13486 = (state_13528[(2)]);
var inst_13487__$1 = cljs.core.nth.call(null,inst_13486,(0),null);
var inst_13488__$1 = cljs.core.nth.call(null,inst_13486,(1),null);
var inst_13489 = (inst_13487__$1 == null);
var inst_13490 = cljs.core._EQ_.call(null,inst_13488__$1,change);
var inst_13491 = (inst_13489) || (inst_13490);
var state_13528__$1 = (function (){var statearr_13550 = state_13528;
(statearr_13550[(11)] = inst_13488__$1);

(statearr_13550[(14)] = inst_13487__$1);

return statearr_13550;
})();
if(cljs.core.truth_(inst_13491)){
var statearr_13551_13608 = state_13528__$1;
(statearr_13551_13608[(1)] = (23));

} else {
var statearr_13552_13609 = state_13528__$1;
(statearr_13552_13609[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (36))){
var inst_13478 = (state_13528[(12)]);
var inst_13455 = inst_13478;
var state_13528__$1 = (function (){var statearr_13553 = state_13528;
(statearr_13553[(7)] = inst_13455);

return statearr_13553;
})();
var statearr_13554_13610 = state_13528__$1;
(statearr_13554_13610[(2)] = null);

(statearr_13554_13610[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (29))){
var inst_13502 = (state_13528[(10)]);
var state_13528__$1 = state_13528;
var statearr_13555_13611 = state_13528__$1;
(statearr_13555_13611[(2)] = inst_13502);

(statearr_13555_13611[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (6))){
var state_13528__$1 = state_13528;
var statearr_13556_13612 = state_13528__$1;
(statearr_13556_13612[(2)] = false);

(statearr_13556_13612[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (28))){
var inst_13498 = (state_13528[(2)]);
var inst_13499 = calc_state.call(null);
var inst_13455 = inst_13499;
var state_13528__$1 = (function (){var statearr_13557 = state_13528;
(statearr_13557[(7)] = inst_13455);

(statearr_13557[(15)] = inst_13498);

return statearr_13557;
})();
var statearr_13558_13613 = state_13528__$1;
(statearr_13558_13613[(2)] = null);

(statearr_13558_13613[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (25))){
var inst_13524 = (state_13528[(2)]);
var state_13528__$1 = state_13528;
var statearr_13559_13614 = state_13528__$1;
(statearr_13559_13614[(2)] = inst_13524);

(statearr_13559_13614[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (34))){
var inst_13522 = (state_13528[(2)]);
var state_13528__$1 = state_13528;
var statearr_13560_13615 = state_13528__$1;
(statearr_13560_13615[(2)] = inst_13522);

(statearr_13560_13615[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (17))){
var state_13528__$1 = state_13528;
var statearr_13561_13616 = state_13528__$1;
(statearr_13561_13616[(2)] = false);

(statearr_13561_13616[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (3))){
var state_13528__$1 = state_13528;
var statearr_13562_13617 = state_13528__$1;
(statearr_13562_13617[(2)] = false);

(statearr_13562_13617[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (12))){
var inst_13526 = (state_13528[(2)]);
var state_13528__$1 = state_13528;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13528__$1,inst_13526);
} else {
if((state_val_13529 === (2))){
var inst_13430 = (state_13528[(8)]);
var inst_13435 = inst_13430.cljs$lang$protocol_mask$partition0$;
var inst_13436 = (inst_13435 & (64));
var inst_13437 = inst_13430.cljs$core$ISeq$;
var inst_13438 = (cljs.core.PROTOCOL_SENTINEL === inst_13437);
var inst_13439 = (inst_13436) || (inst_13438);
var state_13528__$1 = state_13528;
if(cljs.core.truth_(inst_13439)){
var statearr_13563_13618 = state_13528__$1;
(statearr_13563_13618[(1)] = (5));

} else {
var statearr_13564_13619 = state_13528__$1;
(statearr_13564_13619[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (23))){
var inst_13487 = (state_13528[(14)]);
var inst_13493 = (inst_13487 == null);
var state_13528__$1 = state_13528;
if(cljs.core.truth_(inst_13493)){
var statearr_13565_13620 = state_13528__$1;
(statearr_13565_13620[(1)] = (26));

} else {
var statearr_13566_13621 = state_13528__$1;
(statearr_13566_13621[(1)] = (27));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (35))){
var inst_13513 = (state_13528[(2)]);
var state_13528__$1 = state_13528;
if(cljs.core.truth_(inst_13513)){
var statearr_13567_13622 = state_13528__$1;
(statearr_13567_13622[(1)] = (36));

} else {
var statearr_13568_13623 = state_13528__$1;
(statearr_13568_13623[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (19))){
var inst_13455 = (state_13528[(7)]);
var inst_13475 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13455);
var state_13528__$1 = state_13528;
var statearr_13569_13624 = state_13528__$1;
(statearr_13569_13624[(2)] = inst_13475);

(statearr_13569_13624[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (11))){
var inst_13455 = (state_13528[(7)]);
var inst_13459 = (inst_13455 == null);
var inst_13460 = cljs.core.not.call(null,inst_13459);
var state_13528__$1 = state_13528;
if(inst_13460){
var statearr_13570_13625 = state_13528__$1;
(statearr_13570_13625[(1)] = (13));

} else {
var statearr_13571_13626 = state_13528__$1;
(statearr_13571_13626[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (9))){
var inst_13430 = (state_13528[(8)]);
var state_13528__$1 = state_13528;
var statearr_13572_13627 = state_13528__$1;
(statearr_13572_13627[(2)] = inst_13430);

(statearr_13572_13627[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (5))){
var state_13528__$1 = state_13528;
var statearr_13573_13628 = state_13528__$1;
(statearr_13573_13628[(2)] = true);

(statearr_13573_13628[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (14))){
var state_13528__$1 = state_13528;
var statearr_13574_13629 = state_13528__$1;
(statearr_13574_13629[(2)] = false);

(statearr_13574_13629[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (26))){
var inst_13488 = (state_13528[(11)]);
var inst_13495 = cljs.core.swap_BANG_.call(null,cs,cljs.core.dissoc,inst_13488);
var state_13528__$1 = state_13528;
var statearr_13575_13630 = state_13528__$1;
(statearr_13575_13630[(2)] = inst_13495);

(statearr_13575_13630[(1)] = (28));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (16))){
var state_13528__$1 = state_13528;
var statearr_13576_13631 = state_13528__$1;
(statearr_13576_13631[(2)] = true);

(statearr_13576_13631[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (38))){
var inst_13518 = (state_13528[(2)]);
var state_13528__$1 = state_13528;
var statearr_13577_13632 = state_13528__$1;
(statearr_13577_13632[(2)] = inst_13518);

(statearr_13577_13632[(1)] = (34));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (30))){
var inst_13479 = (state_13528[(9)]);
var inst_13488 = (state_13528[(11)]);
var inst_13480 = (state_13528[(13)]);
var inst_13505 = cljs.core.empty_QMARK_.call(null,inst_13479);
var inst_13506 = inst_13480.call(null,inst_13488);
var inst_13507 = cljs.core.not.call(null,inst_13506);
var inst_13508 = (inst_13505) && (inst_13507);
var state_13528__$1 = state_13528;
var statearr_13578_13633 = state_13528__$1;
(statearr_13578_13633[(2)] = inst_13508);

(statearr_13578_13633[(1)] = (31));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (10))){
var inst_13430 = (state_13528[(8)]);
var inst_13451 = (state_13528[(2)]);
var inst_13452 = cljs.core.get.call(null,inst_13451,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_13453 = cljs.core.get.call(null,inst_13451,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_13454 = cljs.core.get.call(null,inst_13451,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_13455 = inst_13430;
var state_13528__$1 = (function (){var statearr_13579 = state_13528;
(statearr_13579[(16)] = inst_13454);

(statearr_13579[(7)] = inst_13455);

(statearr_13579[(17)] = inst_13453);

(statearr_13579[(18)] = inst_13452);

return statearr_13579;
})();
var statearr_13580_13634 = state_13528__$1;
(statearr_13580_13634[(2)] = null);

(statearr_13580_13634[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (18))){
var inst_13470 = (state_13528[(2)]);
var state_13528__$1 = state_13528;
var statearr_13581_13635 = state_13528__$1;
(statearr_13581_13635[(2)] = inst_13470);

(statearr_13581_13635[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (37))){
var state_13528__$1 = state_13528;
var statearr_13582_13636 = state_13528__$1;
(statearr_13582_13636[(2)] = null);

(statearr_13582_13636[(1)] = (38));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13529 === (8))){
var inst_13430 = (state_13528[(8)]);
var inst_13448 = cljs.core.apply.call(null,cljs.core.hash_map,inst_13430);
var state_13528__$1 = state_13528;
var statearr_13583_13637 = state_13528__$1;
(statearr_13583_13637[(2)] = inst_13448);

(statearr_13583_13637[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11824__auto___13591,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
;
return ((function (switch__11712__auto__,c__11824__auto___13591,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m){
return (function() {
var cljs$core$async$mix_$_state_machine__11713__auto__ = null;
var cljs$core$async$mix_$_state_machine__11713__auto____0 = (function (){
var statearr_13587 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13587[(0)] = cljs$core$async$mix_$_state_machine__11713__auto__);

(statearr_13587[(1)] = (1));

return statearr_13587;
});
var cljs$core$async$mix_$_state_machine__11713__auto____1 = (function (state_13528){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_13528);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e13588){if((e13588 instanceof Object)){
var ex__11716__auto__ = e13588;
var statearr_13589_13638 = state_13528;
(statearr_13589_13638[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13528);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13588;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13639 = state_13528;
state_13528 = G__13639;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__11713__auto__ = function(state_13528){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__11713__auto____1.call(this,state_13528);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mix_$_state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__11713__auto____0;
cljs$core$async$mix_$_state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__11713__auto____1;
return cljs$core$async$mix_$_state_machine__11713__auto__;
})()
;})(switch__11712__auto__,c__11824__auto___13591,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
})();
var state__11826__auto__ = (function (){var statearr_13590 = f__11825__auto__.call(null);
(statearr_13590[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto___13591);

return statearr_13590;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(c__11824__auto___13591,cs,solo_modes,attrs,solo_mode,change,changed,pick,calc_state,m))
);


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_.call(null,mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_.call(null,mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_.call(null,mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_.call(null,mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_.call(null,mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((!((p == null))) && (!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
var x__7026__auto__ = (((p == null))?null:p);
var m__7027__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__7026__auto__)]);
if(!((m__7027__auto__ == null))){
return m__7027__auto__.call(null,p,v,ch,close_QMARK_);
} else {
var m__7027__auto____$1 = (cljs.core.async.sub_STAR_["_"]);
if(!((m__7027__auto____$1 == null))){
return m__7027__auto____$1.call(null,p,v,ch,close_QMARK_);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.sub*",p);
}
}
}
});

cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
var x__7026__auto__ = (((p == null))?null:p);
var m__7027__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__7026__auto__)]);
if(!((m__7027__auto__ == null))){
return m__7027__auto__.call(null,p,v,ch);
} else {
var m__7027__auto____$1 = (cljs.core.async.unsub_STAR_["_"]);
if(!((m__7027__auto____$1 == null))){
return m__7027__auto____$1.call(null,p,v,ch);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var args13640 = [];
var len__7471__auto___13643 = arguments.length;
var i__7472__auto___13644 = (0);
while(true){
if((i__7472__auto___13644 < len__7471__auto___13643)){
args13640.push((arguments[i__7472__auto___13644]));

var G__13645 = (i__7472__auto___13644 + (1));
i__7472__auto___13644 = G__13645;
continue;
} else {
}
break;
}

var G__13642 = args13640.length;
switch (G__13642) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13640.length)].join('')));

}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
var x__7026__auto__ = (((p == null))?null:p);
var m__7027__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7026__auto__)]);
if(!((m__7027__auto__ == null))){
return m__7027__auto__.call(null,p);
} else {
var m__7027__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7027__auto____$1 == null))){
return m__7027__auto____$1.call(null,p);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((!((p == null))) && (!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
var x__7026__auto__ = (((p == null))?null:p);
var m__7027__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__7026__auto__)]);
if(!((m__7027__auto__ == null))){
return m__7027__auto__.call(null,p,v);
} else {
var m__7027__auto____$1 = (cljs.core.async.unsub_all_STAR_["_"]);
if(!((m__7027__auto____$1 == null))){
return m__7027__auto____$1.call(null,p,v);
} else {
throw cljs.core.missing_protocol.call(null,"Pub.unsub-all*",p);
}
}
}
});

cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2;


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var args13648 = [];
var len__7471__auto___13773 = arguments.length;
var i__7472__auto___13774 = (0);
while(true){
if((i__7472__auto___13774 < len__7471__auto___13773)){
args13648.push((arguments[i__7472__auto___13774]));

var G__13775 = (i__7472__auto___13774 + (1));
i__7472__auto___13774 = G__13775;
continue;
} else {
}
break;
}

var G__13650 = args13648.length;
switch (G__13650) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13648.length)].join('')));

}
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.call(null,ch,topic_fn,cljs.core.constantly.call(null,null));
});

cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.call(null,cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = ((function (mults){
return (function (topic){
var or__6358__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,mults),topic);
if(cljs.core.truth_(or__6358__auto__)){
return or__6358__auto__;
} else {
return cljs.core.get.call(null,cljs.core.swap_BANG_.call(null,mults,((function (or__6358__auto__,mults){
return (function (p1__13647_SHARP_){
if(cljs.core.truth_(p1__13647_SHARP_.call(null,topic))){
return p1__13647_SHARP_;
} else {
return cljs.core.assoc.call(null,p1__13647_SHARP_,topic,cljs.core.async.mult.call(null,cljs.core.async.chan.call(null,buf_fn.call(null,topic))));
}
});})(or__6358__auto__,mults))
),topic);
}
});})(mults))
;
var p = (function (){
if(typeof cljs.core.async.t_cljs$core$async13651 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async13651 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta13652){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta13652 = meta13652;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async13651.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (mults,ensure_mult){
return (function (_13653,meta13652__$1){
var self__ = this;
var _13653__$1 = this;
return (new cljs.core.async.t_cljs$core$async13651(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta13652__$1));
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13651.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (mults,ensure_mult){
return (function (_13653){
var self__ = this;
var _13653__$1 = this;
return self__.meta13652;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13651.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async13651.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13651.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async13651.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = self__.ensure_mult.call(null,topic);
return cljs.core.async.tap.call(null,m,ch__$1,close_QMARK_);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13651.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = ((function (mults,ensure_mult){
return (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__4657__auto__ = cljs.core.get.call(null,cljs.core.deref.call(null,self__.mults),topic);
if(cljs.core.truth_(temp__4657__auto__)){
var m = temp__4657__auto__;
return cljs.core.async.untap.call(null,m,ch__$1);
} else {
return null;
}
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13651.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = ((function (mults,ensure_mult){
return (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_.call(null,self__.mults,cljs.core.PersistentArrayMap.EMPTY);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13651.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = ((function (mults,ensure_mult){
return (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.call(null,self__.mults,cljs.core.dissoc,topic);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13651.getBasis = ((function (mults,ensure_mult){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta13652","meta13652",1061314771,null)], null);
});})(mults,ensure_mult))
;

cljs.core.async.t_cljs$core$async13651.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async13651.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async13651";

cljs.core.async.t_cljs$core$async13651.cljs$lang$ctorPrWriter = ((function (mults,ensure_mult){
return (function (this__6969__auto__,writer__6970__auto__,opt__6971__auto__){
return cljs.core._write.call(null,writer__6970__auto__,"cljs.core.async/t_cljs$core$async13651");
});})(mults,ensure_mult))
;

cljs.core.async.__GT_t_cljs$core$async13651 = ((function (mults,ensure_mult){
return (function cljs$core$async$__GT_t_cljs$core$async13651(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta13652){
return (new cljs.core.async.t_cljs$core$async13651(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta13652));
});})(mults,ensure_mult))
;

}

return (new cljs.core.async.t_cljs$core$async13651(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__11824__auto___13777 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11824__auto___13777,mults,ensure_mult,p){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (c__11824__auto___13777,mults,ensure_mult,p){
return (function (state_13725){
var state_val_13726 = (state_13725[(1)]);
if((state_val_13726 === (7))){
var inst_13721 = (state_13725[(2)]);
var state_13725__$1 = state_13725;
var statearr_13727_13778 = state_13725__$1;
(statearr_13727_13778[(2)] = inst_13721);

(statearr_13727_13778[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (20))){
var state_13725__$1 = state_13725;
var statearr_13728_13779 = state_13725__$1;
(statearr_13728_13779[(2)] = null);

(statearr_13728_13779[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (1))){
var state_13725__$1 = state_13725;
var statearr_13729_13780 = state_13725__$1;
(statearr_13729_13780[(2)] = null);

(statearr_13729_13780[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (24))){
var inst_13704 = (state_13725[(7)]);
var inst_13713 = cljs.core.swap_BANG_.call(null,mults,cljs.core.dissoc,inst_13704);
var state_13725__$1 = state_13725;
var statearr_13730_13781 = state_13725__$1;
(statearr_13730_13781[(2)] = inst_13713);

(statearr_13730_13781[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (4))){
var inst_13656 = (state_13725[(8)]);
var inst_13656__$1 = (state_13725[(2)]);
var inst_13657 = (inst_13656__$1 == null);
var state_13725__$1 = (function (){var statearr_13731 = state_13725;
(statearr_13731[(8)] = inst_13656__$1);

return statearr_13731;
})();
if(cljs.core.truth_(inst_13657)){
var statearr_13732_13782 = state_13725__$1;
(statearr_13732_13782[(1)] = (5));

} else {
var statearr_13733_13783 = state_13725__$1;
(statearr_13733_13783[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (15))){
var inst_13698 = (state_13725[(2)]);
var state_13725__$1 = state_13725;
var statearr_13734_13784 = state_13725__$1;
(statearr_13734_13784[(2)] = inst_13698);

(statearr_13734_13784[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (21))){
var inst_13718 = (state_13725[(2)]);
var state_13725__$1 = (function (){var statearr_13735 = state_13725;
(statearr_13735[(9)] = inst_13718);

return statearr_13735;
})();
var statearr_13736_13785 = state_13725__$1;
(statearr_13736_13785[(2)] = null);

(statearr_13736_13785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (13))){
var inst_13680 = (state_13725[(10)]);
var inst_13682 = cljs.core.chunked_seq_QMARK_.call(null,inst_13680);
var state_13725__$1 = state_13725;
if(inst_13682){
var statearr_13737_13786 = state_13725__$1;
(statearr_13737_13786[(1)] = (16));

} else {
var statearr_13738_13787 = state_13725__$1;
(statearr_13738_13787[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (22))){
var inst_13710 = (state_13725[(2)]);
var state_13725__$1 = state_13725;
if(cljs.core.truth_(inst_13710)){
var statearr_13739_13788 = state_13725__$1;
(statearr_13739_13788[(1)] = (23));

} else {
var statearr_13740_13789 = state_13725__$1;
(statearr_13740_13789[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (6))){
var inst_13706 = (state_13725[(11)]);
var inst_13656 = (state_13725[(8)]);
var inst_13704 = (state_13725[(7)]);
var inst_13704__$1 = topic_fn.call(null,inst_13656);
var inst_13705 = cljs.core.deref.call(null,mults);
var inst_13706__$1 = cljs.core.get.call(null,inst_13705,inst_13704__$1);
var state_13725__$1 = (function (){var statearr_13741 = state_13725;
(statearr_13741[(11)] = inst_13706__$1);

(statearr_13741[(7)] = inst_13704__$1);

return statearr_13741;
})();
if(cljs.core.truth_(inst_13706__$1)){
var statearr_13742_13790 = state_13725__$1;
(statearr_13742_13790[(1)] = (19));

} else {
var statearr_13743_13791 = state_13725__$1;
(statearr_13743_13791[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (25))){
var inst_13715 = (state_13725[(2)]);
var state_13725__$1 = state_13725;
var statearr_13744_13792 = state_13725__$1;
(statearr_13744_13792[(2)] = inst_13715);

(statearr_13744_13792[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (17))){
var inst_13680 = (state_13725[(10)]);
var inst_13689 = cljs.core.first.call(null,inst_13680);
var inst_13690 = cljs.core.async.muxch_STAR_.call(null,inst_13689);
var inst_13691 = cljs.core.async.close_BANG_.call(null,inst_13690);
var inst_13692 = cljs.core.next.call(null,inst_13680);
var inst_13666 = inst_13692;
var inst_13667 = null;
var inst_13668 = (0);
var inst_13669 = (0);
var state_13725__$1 = (function (){var statearr_13745 = state_13725;
(statearr_13745[(12)] = inst_13668);

(statearr_13745[(13)] = inst_13667);

(statearr_13745[(14)] = inst_13691);

(statearr_13745[(15)] = inst_13666);

(statearr_13745[(16)] = inst_13669);

return statearr_13745;
})();
var statearr_13746_13793 = state_13725__$1;
(statearr_13746_13793[(2)] = null);

(statearr_13746_13793[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (3))){
var inst_13723 = (state_13725[(2)]);
var state_13725__$1 = state_13725;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13725__$1,inst_13723);
} else {
if((state_val_13726 === (12))){
var inst_13700 = (state_13725[(2)]);
var state_13725__$1 = state_13725;
var statearr_13747_13794 = state_13725__$1;
(statearr_13747_13794[(2)] = inst_13700);

(statearr_13747_13794[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (2))){
var state_13725__$1 = state_13725;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13725__$1,(4),ch);
} else {
if((state_val_13726 === (23))){
var state_13725__$1 = state_13725;
var statearr_13748_13795 = state_13725__$1;
(statearr_13748_13795[(2)] = null);

(statearr_13748_13795[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (19))){
var inst_13706 = (state_13725[(11)]);
var inst_13656 = (state_13725[(8)]);
var inst_13708 = cljs.core.async.muxch_STAR_.call(null,inst_13706);
var state_13725__$1 = state_13725;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13725__$1,(22),inst_13708,inst_13656);
} else {
if((state_val_13726 === (11))){
var inst_13666 = (state_13725[(15)]);
var inst_13680 = (state_13725[(10)]);
var inst_13680__$1 = cljs.core.seq.call(null,inst_13666);
var state_13725__$1 = (function (){var statearr_13749 = state_13725;
(statearr_13749[(10)] = inst_13680__$1);

return statearr_13749;
})();
if(inst_13680__$1){
var statearr_13750_13796 = state_13725__$1;
(statearr_13750_13796[(1)] = (13));

} else {
var statearr_13751_13797 = state_13725__$1;
(statearr_13751_13797[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (9))){
var inst_13702 = (state_13725[(2)]);
var state_13725__$1 = state_13725;
var statearr_13752_13798 = state_13725__$1;
(statearr_13752_13798[(2)] = inst_13702);

(statearr_13752_13798[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (5))){
var inst_13663 = cljs.core.deref.call(null,mults);
var inst_13664 = cljs.core.vals.call(null,inst_13663);
var inst_13665 = cljs.core.seq.call(null,inst_13664);
var inst_13666 = inst_13665;
var inst_13667 = null;
var inst_13668 = (0);
var inst_13669 = (0);
var state_13725__$1 = (function (){var statearr_13753 = state_13725;
(statearr_13753[(12)] = inst_13668);

(statearr_13753[(13)] = inst_13667);

(statearr_13753[(15)] = inst_13666);

(statearr_13753[(16)] = inst_13669);

return statearr_13753;
})();
var statearr_13754_13799 = state_13725__$1;
(statearr_13754_13799[(2)] = null);

(statearr_13754_13799[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (14))){
var state_13725__$1 = state_13725;
var statearr_13758_13800 = state_13725__$1;
(statearr_13758_13800[(2)] = null);

(statearr_13758_13800[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (16))){
var inst_13680 = (state_13725[(10)]);
var inst_13684 = cljs.core.chunk_first.call(null,inst_13680);
var inst_13685 = cljs.core.chunk_rest.call(null,inst_13680);
var inst_13686 = cljs.core.count.call(null,inst_13684);
var inst_13666 = inst_13685;
var inst_13667 = inst_13684;
var inst_13668 = inst_13686;
var inst_13669 = (0);
var state_13725__$1 = (function (){var statearr_13759 = state_13725;
(statearr_13759[(12)] = inst_13668);

(statearr_13759[(13)] = inst_13667);

(statearr_13759[(15)] = inst_13666);

(statearr_13759[(16)] = inst_13669);

return statearr_13759;
})();
var statearr_13760_13801 = state_13725__$1;
(statearr_13760_13801[(2)] = null);

(statearr_13760_13801[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (10))){
var inst_13668 = (state_13725[(12)]);
var inst_13667 = (state_13725[(13)]);
var inst_13666 = (state_13725[(15)]);
var inst_13669 = (state_13725[(16)]);
var inst_13674 = cljs.core._nth.call(null,inst_13667,inst_13669);
var inst_13675 = cljs.core.async.muxch_STAR_.call(null,inst_13674);
var inst_13676 = cljs.core.async.close_BANG_.call(null,inst_13675);
var inst_13677 = (inst_13669 + (1));
var tmp13755 = inst_13668;
var tmp13756 = inst_13667;
var tmp13757 = inst_13666;
var inst_13666__$1 = tmp13757;
var inst_13667__$1 = tmp13756;
var inst_13668__$1 = tmp13755;
var inst_13669__$1 = inst_13677;
var state_13725__$1 = (function (){var statearr_13761 = state_13725;
(statearr_13761[(12)] = inst_13668__$1);

(statearr_13761[(13)] = inst_13667__$1);

(statearr_13761[(15)] = inst_13666__$1);

(statearr_13761[(17)] = inst_13676);

(statearr_13761[(16)] = inst_13669__$1);

return statearr_13761;
})();
var statearr_13762_13802 = state_13725__$1;
(statearr_13762_13802[(2)] = null);

(statearr_13762_13802[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (18))){
var inst_13695 = (state_13725[(2)]);
var state_13725__$1 = state_13725;
var statearr_13763_13803 = state_13725__$1;
(statearr_13763_13803[(2)] = inst_13695);

(statearr_13763_13803[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13726 === (8))){
var inst_13668 = (state_13725[(12)]);
var inst_13669 = (state_13725[(16)]);
var inst_13671 = (inst_13669 < inst_13668);
var inst_13672 = inst_13671;
var state_13725__$1 = state_13725;
if(cljs.core.truth_(inst_13672)){
var statearr_13764_13804 = state_13725__$1;
(statearr_13764_13804[(1)] = (10));

} else {
var statearr_13765_13805 = state_13725__$1;
(statearr_13765_13805[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11824__auto___13777,mults,ensure_mult,p))
;
return ((function (switch__11712__auto__,c__11824__auto___13777,mults,ensure_mult,p){
return (function() {
var cljs$core$async$state_machine__11713__auto__ = null;
var cljs$core$async$state_machine__11713__auto____0 = (function (){
var statearr_13769 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13769[(0)] = cljs$core$async$state_machine__11713__auto__);

(statearr_13769[(1)] = (1));

return statearr_13769;
});
var cljs$core$async$state_machine__11713__auto____1 = (function (state_13725){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_13725);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e13770){if((e13770 instanceof Object)){
var ex__11716__auto__ = e13770;
var statearr_13771_13806 = state_13725;
(statearr_13771_13806[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13725);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13770;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13807 = state_13725;
state_13725 = G__13807;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$state_machine__11713__auto__ = function(state_13725){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11713__auto____1.call(this,state_13725);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11713__auto____0;
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11713__auto____1;
return cljs$core$async$state_machine__11713__auto__;
})()
;})(switch__11712__auto__,c__11824__auto___13777,mults,ensure_mult,p))
})();
var state__11826__auto__ = (function (){var statearr_13772 = f__11825__auto__.call(null);
(statearr_13772[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto___13777);

return statearr_13772;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(c__11824__auto___13777,mults,ensure_mult,p))
);


return p;
});

cljs.core.async.pub.cljs$lang$maxFixedArity = 3;

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var args13808 = [];
var len__7471__auto___13811 = arguments.length;
var i__7472__auto___13812 = (0);
while(true){
if((i__7472__auto___13812 < len__7471__auto___13811)){
args13808.push((arguments[i__7472__auto___13812]));

var G__13813 = (i__7472__auto___13812 + (1));
i__7472__auto___13812 = G__13813;
continue;
} else {
}
break;
}

var G__13810 = args13808.length;
switch (G__13810) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13808.length)].join('')));

}
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.call(null,p,topic,ch,true);
});

cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_.call(null,p,topic,ch,close_QMARK_);
});

cljs.core.async.sub.cljs$lang$maxFixedArity = 4;

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_.call(null,p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var args13815 = [];
var len__7471__auto___13818 = arguments.length;
var i__7472__auto___13819 = (0);
while(true){
if((i__7472__auto___13819 < len__7471__auto___13818)){
args13815.push((arguments[i__7472__auto___13819]));

var G__13820 = (i__7472__auto___13819 + (1));
i__7472__auto___13819 = G__13820;
continue;
} else {
}
break;
}

var G__13817 = args13815.length;
switch (G__13817) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13815.length)].join('')));

}
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.call(null,p);
});

cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.call(null,p,topic);
});

cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2;

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var args13822 = [];
var len__7471__auto___13893 = arguments.length;
var i__7472__auto___13894 = (0);
while(true){
if((i__7472__auto___13894 < len__7471__auto___13893)){
args13822.push((arguments[i__7472__auto___13894]));

var G__13895 = (i__7472__auto___13894 + (1));
i__7472__auto___13894 = G__13895;
continue;
} else {
}
break;
}

var G__13824 = args13822.length;
switch (G__13824) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13822.length)].join('')));

}
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.call(null,f,chs,null);
});

cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec.call(null,chs);
var out = cljs.core.async.chan.call(null,buf_or_n);
var cnt = cljs.core.count.call(null,chs__$1);
var rets = cljs.core.object_array.call(null,cnt);
var dchan = cljs.core.async.chan.call(null,(1));
var dctr = cljs.core.atom.call(null,null);
var done = cljs.core.mapv.call(null,((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (i){
return ((function (chs__$1,out,cnt,rets,dchan,dctr){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.call(null,dchan,rets.slice((0)));
} else {
return null;
}
});
;})(chs__$1,out,cnt,rets,dchan,dctr))
});})(chs__$1,out,cnt,rets,dchan,dctr))
,cljs.core.range.call(null,cnt));
var c__11824__auto___13897 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11824__auto___13897,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (c__11824__auto___13897,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function (state_13863){
var state_val_13864 = (state_13863[(1)]);
if((state_val_13864 === (7))){
var state_13863__$1 = state_13863;
var statearr_13865_13898 = state_13863__$1;
(statearr_13865_13898[(2)] = null);

(statearr_13865_13898[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13864 === (1))){
var state_13863__$1 = state_13863;
var statearr_13866_13899 = state_13863__$1;
(statearr_13866_13899[(2)] = null);

(statearr_13866_13899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13864 === (4))){
var inst_13827 = (state_13863[(7)]);
var inst_13829 = (inst_13827 < cnt);
var state_13863__$1 = state_13863;
if(cljs.core.truth_(inst_13829)){
var statearr_13867_13900 = state_13863__$1;
(statearr_13867_13900[(1)] = (6));

} else {
var statearr_13868_13901 = state_13863__$1;
(statearr_13868_13901[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13864 === (15))){
var inst_13859 = (state_13863[(2)]);
var state_13863__$1 = state_13863;
var statearr_13869_13902 = state_13863__$1;
(statearr_13869_13902[(2)] = inst_13859);

(statearr_13869_13902[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13864 === (13))){
var inst_13852 = cljs.core.async.close_BANG_.call(null,out);
var state_13863__$1 = state_13863;
var statearr_13870_13903 = state_13863__$1;
(statearr_13870_13903[(2)] = inst_13852);

(statearr_13870_13903[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13864 === (6))){
var state_13863__$1 = state_13863;
var statearr_13871_13904 = state_13863__$1;
(statearr_13871_13904[(2)] = null);

(statearr_13871_13904[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13864 === (3))){
var inst_13861 = (state_13863[(2)]);
var state_13863__$1 = state_13863;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13863__$1,inst_13861);
} else {
if((state_val_13864 === (12))){
var inst_13849 = (state_13863[(8)]);
var inst_13849__$1 = (state_13863[(2)]);
var inst_13850 = cljs.core.some.call(null,cljs.core.nil_QMARK_,inst_13849__$1);
var state_13863__$1 = (function (){var statearr_13872 = state_13863;
(statearr_13872[(8)] = inst_13849__$1);

return statearr_13872;
})();
if(cljs.core.truth_(inst_13850)){
var statearr_13873_13905 = state_13863__$1;
(statearr_13873_13905[(1)] = (13));

} else {
var statearr_13874_13906 = state_13863__$1;
(statearr_13874_13906[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13864 === (2))){
var inst_13826 = cljs.core.reset_BANG_.call(null,dctr,cnt);
var inst_13827 = (0);
var state_13863__$1 = (function (){var statearr_13875 = state_13863;
(statearr_13875[(7)] = inst_13827);

(statearr_13875[(9)] = inst_13826);

return statearr_13875;
})();
var statearr_13876_13907 = state_13863__$1;
(statearr_13876_13907[(2)] = null);

(statearr_13876_13907[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13864 === (11))){
var inst_13827 = (state_13863[(7)]);
var _ = cljs.core.async.impl.ioc_helpers.add_exception_frame.call(null,state_13863,(10),Object,null,(9));
var inst_13836 = chs__$1.call(null,inst_13827);
var inst_13837 = done.call(null,inst_13827);
var inst_13838 = cljs.core.async.take_BANG_.call(null,inst_13836,inst_13837);
var state_13863__$1 = state_13863;
var statearr_13877_13908 = state_13863__$1;
(statearr_13877_13908[(2)] = inst_13838);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13863__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13864 === (9))){
var inst_13827 = (state_13863[(7)]);
var inst_13840 = (state_13863[(2)]);
var inst_13841 = (inst_13827 + (1));
var inst_13827__$1 = inst_13841;
var state_13863__$1 = (function (){var statearr_13878 = state_13863;
(statearr_13878[(7)] = inst_13827__$1);

(statearr_13878[(10)] = inst_13840);

return statearr_13878;
})();
var statearr_13879_13909 = state_13863__$1;
(statearr_13879_13909[(2)] = null);

(statearr_13879_13909[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13864 === (5))){
var inst_13847 = (state_13863[(2)]);
var state_13863__$1 = (function (){var statearr_13880 = state_13863;
(statearr_13880[(11)] = inst_13847);

return statearr_13880;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_13863__$1,(12),dchan);
} else {
if((state_val_13864 === (14))){
var inst_13849 = (state_13863[(8)]);
var inst_13854 = cljs.core.apply.call(null,f,inst_13849);
var state_13863__$1 = state_13863;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13863__$1,(16),out,inst_13854);
} else {
if((state_val_13864 === (16))){
var inst_13856 = (state_13863[(2)]);
var state_13863__$1 = (function (){var statearr_13881 = state_13863;
(statearr_13881[(12)] = inst_13856);

return statearr_13881;
})();
var statearr_13882_13910 = state_13863__$1;
(statearr_13882_13910[(2)] = null);

(statearr_13882_13910[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13864 === (10))){
var inst_13831 = (state_13863[(2)]);
var inst_13832 = cljs.core.swap_BANG_.call(null,dctr,cljs.core.dec);
var state_13863__$1 = (function (){var statearr_13883 = state_13863;
(statearr_13883[(13)] = inst_13831);

return statearr_13883;
})();
var statearr_13884_13911 = state_13863__$1;
(statearr_13884_13911[(2)] = inst_13832);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13863__$1);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13864 === (8))){
var inst_13845 = (state_13863[(2)]);
var state_13863__$1 = state_13863;
var statearr_13885_13912 = state_13863__$1;
(statearr_13885_13912[(2)] = inst_13845);

(statearr_13885_13912[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11824__auto___13897,chs__$1,out,cnt,rets,dchan,dctr,done))
;
return ((function (switch__11712__auto__,c__11824__auto___13897,chs__$1,out,cnt,rets,dchan,dctr,done){
return (function() {
var cljs$core$async$state_machine__11713__auto__ = null;
var cljs$core$async$state_machine__11713__auto____0 = (function (){
var statearr_13889 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13889[(0)] = cljs$core$async$state_machine__11713__auto__);

(statearr_13889[(1)] = (1));

return statearr_13889;
});
var cljs$core$async$state_machine__11713__auto____1 = (function (state_13863){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_13863);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e13890){if((e13890 instanceof Object)){
var ex__11716__auto__ = e13890;
var statearr_13891_13913 = state_13863;
(statearr_13891_13913[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13863);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13890;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13914 = state_13863;
state_13863 = G__13914;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$state_machine__11713__auto__ = function(state_13863){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11713__auto____1.call(this,state_13863);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11713__auto____0;
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11713__auto____1;
return cljs$core$async$state_machine__11713__auto__;
})()
;})(switch__11712__auto__,c__11824__auto___13897,chs__$1,out,cnt,rets,dchan,dctr,done))
})();
var state__11826__auto__ = (function (){var statearr_13892 = f__11825__auto__.call(null);
(statearr_13892[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto___13897);

return statearr_13892;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(c__11824__auto___13897,chs__$1,out,cnt,rets,dchan,dctr,done))
);


return out;
});

cljs.core.async.map.cljs$lang$maxFixedArity = 3;

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var args13916 = [];
var len__7471__auto___13974 = arguments.length;
var i__7472__auto___13975 = (0);
while(true){
if((i__7472__auto___13975 < len__7471__auto___13974)){
args13916.push((arguments[i__7472__auto___13975]));

var G__13976 = (i__7472__auto___13975 + (1));
i__7472__auto___13975 = G__13976;
continue;
} else {
}
break;
}

var G__13918 = args13916.length;
switch (G__13918) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13916.length)].join('')));

}
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.call(null,chs,null);
});

cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11824__auto___13978 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11824__auto___13978,out){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (c__11824__auto___13978,out){
return (function (state_13950){
var state_val_13951 = (state_13950[(1)]);
if((state_val_13951 === (7))){
var inst_13930 = (state_13950[(7)]);
var inst_13929 = (state_13950[(8)]);
var inst_13929__$1 = (state_13950[(2)]);
var inst_13930__$1 = cljs.core.nth.call(null,inst_13929__$1,(0),null);
var inst_13931 = cljs.core.nth.call(null,inst_13929__$1,(1),null);
var inst_13932 = (inst_13930__$1 == null);
var state_13950__$1 = (function (){var statearr_13952 = state_13950;
(statearr_13952[(9)] = inst_13931);

(statearr_13952[(7)] = inst_13930__$1);

(statearr_13952[(8)] = inst_13929__$1);

return statearr_13952;
})();
if(cljs.core.truth_(inst_13932)){
var statearr_13953_13979 = state_13950__$1;
(statearr_13953_13979[(1)] = (8));

} else {
var statearr_13954_13980 = state_13950__$1;
(statearr_13954_13980[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13951 === (1))){
var inst_13919 = cljs.core.vec.call(null,chs);
var inst_13920 = inst_13919;
var state_13950__$1 = (function (){var statearr_13955 = state_13950;
(statearr_13955[(10)] = inst_13920);

return statearr_13955;
})();
var statearr_13956_13981 = state_13950__$1;
(statearr_13956_13981[(2)] = null);

(statearr_13956_13981[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13951 === (4))){
var inst_13920 = (state_13950[(10)]);
var state_13950__$1 = state_13950;
return cljs.core.async.ioc_alts_BANG_.call(null,state_13950__$1,(7),inst_13920);
} else {
if((state_val_13951 === (6))){
var inst_13946 = (state_13950[(2)]);
var state_13950__$1 = state_13950;
var statearr_13957_13982 = state_13950__$1;
(statearr_13957_13982[(2)] = inst_13946);

(statearr_13957_13982[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13951 === (3))){
var inst_13948 = (state_13950[(2)]);
var state_13950__$1 = state_13950;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_13950__$1,inst_13948);
} else {
if((state_val_13951 === (2))){
var inst_13920 = (state_13950[(10)]);
var inst_13922 = cljs.core.count.call(null,inst_13920);
var inst_13923 = (inst_13922 > (0));
var state_13950__$1 = state_13950;
if(cljs.core.truth_(inst_13923)){
var statearr_13959_13983 = state_13950__$1;
(statearr_13959_13983[(1)] = (4));

} else {
var statearr_13960_13984 = state_13950__$1;
(statearr_13960_13984[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13951 === (11))){
var inst_13920 = (state_13950[(10)]);
var inst_13939 = (state_13950[(2)]);
var tmp13958 = inst_13920;
var inst_13920__$1 = tmp13958;
var state_13950__$1 = (function (){var statearr_13961 = state_13950;
(statearr_13961[(11)] = inst_13939);

(statearr_13961[(10)] = inst_13920__$1);

return statearr_13961;
})();
var statearr_13962_13985 = state_13950__$1;
(statearr_13962_13985[(2)] = null);

(statearr_13962_13985[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13951 === (9))){
var inst_13930 = (state_13950[(7)]);
var state_13950__$1 = state_13950;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_13950__$1,(11),out,inst_13930);
} else {
if((state_val_13951 === (5))){
var inst_13944 = cljs.core.async.close_BANG_.call(null,out);
var state_13950__$1 = state_13950;
var statearr_13963_13986 = state_13950__$1;
(statearr_13963_13986[(2)] = inst_13944);

(statearr_13963_13986[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13951 === (10))){
var inst_13942 = (state_13950[(2)]);
var state_13950__$1 = state_13950;
var statearr_13964_13987 = state_13950__$1;
(statearr_13964_13987[(2)] = inst_13942);

(statearr_13964_13987[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_13951 === (8))){
var inst_13931 = (state_13950[(9)]);
var inst_13930 = (state_13950[(7)]);
var inst_13929 = (state_13950[(8)]);
var inst_13920 = (state_13950[(10)]);
var inst_13934 = (function (){var cs = inst_13920;
var vec__13925 = inst_13929;
var v = inst_13930;
var c = inst_13931;
return ((function (cs,vec__13925,v,c,inst_13931,inst_13930,inst_13929,inst_13920,state_val_13951,c__11824__auto___13978,out){
return (function (p1__13915_SHARP_){
return cljs.core.not_EQ_.call(null,c,p1__13915_SHARP_);
});
;})(cs,vec__13925,v,c,inst_13931,inst_13930,inst_13929,inst_13920,state_val_13951,c__11824__auto___13978,out))
})();
var inst_13935 = cljs.core.filterv.call(null,inst_13934,inst_13920);
var inst_13920__$1 = inst_13935;
var state_13950__$1 = (function (){var statearr_13965 = state_13950;
(statearr_13965[(10)] = inst_13920__$1);

return statearr_13965;
})();
var statearr_13966_13988 = state_13950__$1;
(statearr_13966_13988[(2)] = null);

(statearr_13966_13988[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11824__auto___13978,out))
;
return ((function (switch__11712__auto__,c__11824__auto___13978,out){
return (function() {
var cljs$core$async$state_machine__11713__auto__ = null;
var cljs$core$async$state_machine__11713__auto____0 = (function (){
var statearr_13970 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_13970[(0)] = cljs$core$async$state_machine__11713__auto__);

(statearr_13970[(1)] = (1));

return statearr_13970;
});
var cljs$core$async$state_machine__11713__auto____1 = (function (state_13950){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_13950);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e13971){if((e13971 instanceof Object)){
var ex__11716__auto__ = e13971;
var statearr_13972_13989 = state_13950;
(statearr_13972_13989[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_13950);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e13971;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__13990 = state_13950;
state_13950 = G__13990;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$state_machine__11713__auto__ = function(state_13950){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11713__auto____1.call(this,state_13950);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11713__auto____0;
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11713__auto____1;
return cljs$core$async$state_machine__11713__auto__;
})()
;})(switch__11712__auto__,c__11824__auto___13978,out))
})();
var state__11826__auto__ = (function (){var statearr_13973 = f__11825__auto__.call(null);
(statearr_13973[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto___13978);

return statearr_13973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(c__11824__auto___13978,out))
);


return out;
});

cljs.core.async.merge.cljs$lang$maxFixedArity = 2;

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce.call(null,cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var args13991 = [];
var len__7471__auto___14040 = arguments.length;
var i__7472__auto___14041 = (0);
while(true){
if((i__7472__auto___14041 < len__7471__auto___14040)){
args13991.push((arguments[i__7472__auto___14041]));

var G__14042 = (i__7472__auto___14041 + (1));
i__7472__auto___14041 = G__14042;
continue;
} else {
}
break;
}

var G__13993 = args13991.length;
switch (G__13993) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args13991.length)].join('')));

}
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.call(null,n,ch,null);
});

cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11824__auto___14044 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11824__auto___14044,out){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (c__11824__auto___14044,out){
return (function (state_14017){
var state_val_14018 = (state_14017[(1)]);
if((state_val_14018 === (7))){
var inst_13999 = (state_14017[(7)]);
var inst_13999__$1 = (state_14017[(2)]);
var inst_14000 = (inst_13999__$1 == null);
var inst_14001 = cljs.core.not.call(null,inst_14000);
var state_14017__$1 = (function (){var statearr_14019 = state_14017;
(statearr_14019[(7)] = inst_13999__$1);

return statearr_14019;
})();
if(inst_14001){
var statearr_14020_14045 = state_14017__$1;
(statearr_14020_14045[(1)] = (8));

} else {
var statearr_14021_14046 = state_14017__$1;
(statearr_14021_14046[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14018 === (1))){
var inst_13994 = (0);
var state_14017__$1 = (function (){var statearr_14022 = state_14017;
(statearr_14022[(8)] = inst_13994);

return statearr_14022;
})();
var statearr_14023_14047 = state_14017__$1;
(statearr_14023_14047[(2)] = null);

(statearr_14023_14047[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14018 === (4))){
var state_14017__$1 = state_14017;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14017__$1,(7),ch);
} else {
if((state_val_14018 === (6))){
var inst_14012 = (state_14017[(2)]);
var state_14017__$1 = state_14017;
var statearr_14024_14048 = state_14017__$1;
(statearr_14024_14048[(2)] = inst_14012);

(statearr_14024_14048[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14018 === (3))){
var inst_14014 = (state_14017[(2)]);
var inst_14015 = cljs.core.async.close_BANG_.call(null,out);
var state_14017__$1 = (function (){var statearr_14025 = state_14017;
(statearr_14025[(9)] = inst_14014);

return statearr_14025;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14017__$1,inst_14015);
} else {
if((state_val_14018 === (2))){
var inst_13994 = (state_14017[(8)]);
var inst_13996 = (inst_13994 < n);
var state_14017__$1 = state_14017;
if(cljs.core.truth_(inst_13996)){
var statearr_14026_14049 = state_14017__$1;
(statearr_14026_14049[(1)] = (4));

} else {
var statearr_14027_14050 = state_14017__$1;
(statearr_14027_14050[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14018 === (11))){
var inst_13994 = (state_14017[(8)]);
var inst_14004 = (state_14017[(2)]);
var inst_14005 = (inst_13994 + (1));
var inst_13994__$1 = inst_14005;
var state_14017__$1 = (function (){var statearr_14028 = state_14017;
(statearr_14028[(8)] = inst_13994__$1);

(statearr_14028[(10)] = inst_14004);

return statearr_14028;
})();
var statearr_14029_14051 = state_14017__$1;
(statearr_14029_14051[(2)] = null);

(statearr_14029_14051[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14018 === (9))){
var state_14017__$1 = state_14017;
var statearr_14030_14052 = state_14017__$1;
(statearr_14030_14052[(2)] = null);

(statearr_14030_14052[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14018 === (5))){
var state_14017__$1 = state_14017;
var statearr_14031_14053 = state_14017__$1;
(statearr_14031_14053[(2)] = null);

(statearr_14031_14053[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14018 === (10))){
var inst_14009 = (state_14017[(2)]);
var state_14017__$1 = state_14017;
var statearr_14032_14054 = state_14017__$1;
(statearr_14032_14054[(2)] = inst_14009);

(statearr_14032_14054[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14018 === (8))){
var inst_13999 = (state_14017[(7)]);
var state_14017__$1 = state_14017;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14017__$1,(11),out,inst_13999);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11824__auto___14044,out))
;
return ((function (switch__11712__auto__,c__11824__auto___14044,out){
return (function() {
var cljs$core$async$state_machine__11713__auto__ = null;
var cljs$core$async$state_machine__11713__auto____0 = (function (){
var statearr_14036 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14036[(0)] = cljs$core$async$state_machine__11713__auto__);

(statearr_14036[(1)] = (1));

return statearr_14036;
});
var cljs$core$async$state_machine__11713__auto____1 = (function (state_14017){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_14017);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e14037){if((e14037 instanceof Object)){
var ex__11716__auto__ = e14037;
var statearr_14038_14055 = state_14017;
(statearr_14038_14055[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14017);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14037;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14056 = state_14017;
state_14017 = G__14056;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$state_machine__11713__auto__ = function(state_14017){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11713__auto____1.call(this,state_14017);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11713__auto____0;
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11713__auto____1;
return cljs$core$async$state_machine__11713__auto__;
})()
;})(switch__11712__auto__,c__11824__auto___14044,out))
})();
var state__11826__auto__ = (function (){var statearr_14039 = f__11825__auto__.call(null);
(statearr_14039[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto___14044);

return statearr_14039;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(c__11824__auto___14044,out))
);


return out;
});

cljs.core.async.take.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async14064 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14064 = (function (f,ch,meta14065){
this.f = f;
this.ch = ch;
this.meta14065 = meta14065;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14064.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14066,meta14065__$1){
var self__ = this;
var _14066__$1 = this;
return (new cljs.core.async.t_cljs$core$async14064(self__.f,self__.ch,meta14065__$1));
});

cljs.core.async.t_cljs$core$async14064.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14066){
var self__ = this;
var _14066__$1 = this;
return self__.meta14065;
});

cljs.core.async.t_cljs$core$async14064.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async14064.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14064.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14064.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async14064.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,(function (){
if(typeof cljs.core.async.t_cljs$core$async14067 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14067 = (function (f,ch,meta14065,_,fn1,meta14068){
this.f = f;
this.ch = ch;
this.meta14065 = meta14065;
this._ = _;
this.fn1 = fn1;
this.meta14068 = meta14068;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14067.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = ((function (___$1){
return (function (_14069,meta14068__$1){
var self__ = this;
var _14069__$1 = this;
return (new cljs.core.async.t_cljs$core$async14067(self__.f,self__.ch,self__.meta14065,self__._,self__.fn1,meta14068__$1));
});})(___$1))
;

cljs.core.async.t_cljs$core$async14067.prototype.cljs$core$IMeta$_meta$arity$1 = ((function (___$1){
return (function (_14069){
var self__ = this;
var _14069__$1 = this;
return self__.meta14068;
});})(___$1))
;

cljs.core.async.t_cljs$core$async14067.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async14067.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_.call(null,self__.fn1);
});})(___$1))
;

cljs.core.async.t_cljs$core$async14067.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
});})(___$1))
;

cljs.core.async.t_cljs$core$async14067.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = ((function (___$1){
return (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit.call(null,self__.fn1);
return ((function (f1,___$2,___$1){
return (function (p1__14057_SHARP_){
return f1.call(null,(((p1__14057_SHARP_ == null))?null:self__.f.call(null,p1__14057_SHARP_)));
});
;})(f1,___$2,___$1))
});})(___$1))
;

cljs.core.async.t_cljs$core$async14067.getBasis = ((function (___$1){
return (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14065","meta14065",-1986311072,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async14064","cljs.core.async/t_cljs$core$async14064",1456747905,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta14068","meta14068",431680638,null)], null);
});})(___$1))
;

cljs.core.async.t_cljs$core$async14067.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14067.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14067";

cljs.core.async.t_cljs$core$async14067.cljs$lang$ctorPrWriter = ((function (___$1){
return (function (this__6969__auto__,writer__6970__auto__,opt__6971__auto__){
return cljs.core._write.call(null,writer__6970__auto__,"cljs.core.async/t_cljs$core$async14067");
});})(___$1))
;

cljs.core.async.__GT_t_cljs$core$async14067 = ((function (___$1){
return (function cljs$core$async$map_LT__$___GT_t_cljs$core$async14067(f__$1,ch__$1,meta14065__$1,___$2,fn1__$1,meta14068){
return (new cljs.core.async.t_cljs$core$async14067(f__$1,ch__$1,meta14065__$1,___$2,fn1__$1,meta14068));
});})(___$1))
;

}

return (new cljs.core.async.t_cljs$core$async14067(self__.f,self__.ch,self__.meta14065,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__6346__auto__ = ret;
if(cljs.core.truth_(and__6346__auto__)){
return !((cljs.core.deref.call(null,ret) == null));
} else {
return and__6346__auto__;
}
})())){
return cljs.core.async.impl.channels.box.call(null,self__.f.call(null,cljs.core.deref.call(null,ret)));
} else {
return ret;
}
});

cljs.core.async.t_cljs$core$async14064.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async14064.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
});

cljs.core.async.t_cljs$core$async14064.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14065","meta14065",-1986311072,null)], null);
});

cljs.core.async.t_cljs$core$async14064.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14064.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14064";

cljs.core.async.t_cljs$core$async14064.cljs$lang$ctorPrWriter = (function (this__6969__auto__,writer__6970__auto__,opt__6971__auto__){
return cljs.core._write.call(null,writer__6970__auto__,"cljs.core.async/t_cljs$core$async14064");
});

cljs.core.async.__GT_t_cljs$core$async14064 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async14064(f__$1,ch__$1,meta14065){
return (new cljs.core.async.t_cljs$core$async14064(f__$1,ch__$1,meta14065));
});

}

return (new cljs.core.async.t_cljs$core$async14064(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if(typeof cljs.core.async.t_cljs$core$async14073 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14073 = (function (f,ch,meta14074){
this.f = f;
this.ch = ch;
this.meta14074 = meta14074;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14073.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14075,meta14074__$1){
var self__ = this;
var _14075__$1 = this;
return (new cljs.core.async.t_cljs$core$async14073(self__.f,self__.ch,meta14074__$1));
});

cljs.core.async.t_cljs$core$async14073.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14075){
var self__ = this;
var _14075__$1 = this;
return self__.meta14074;
});

cljs.core.async.t_cljs$core$async14073.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async14073.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14073.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async14073.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async14073.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async14073.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,self__.f.call(null,val),fn1);
});

cljs.core.async.t_cljs$core$async14073.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14074","meta14074",2109937196,null)], null);
});

cljs.core.async.t_cljs$core$async14073.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14073.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14073";

cljs.core.async.t_cljs$core$async14073.cljs$lang$ctorPrWriter = (function (this__6969__auto__,writer__6970__auto__,opt__6971__auto__){
return cljs.core._write.call(null,writer__6970__auto__,"cljs.core.async/t_cljs$core$async14073");
});

cljs.core.async.__GT_t_cljs$core$async14073 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async14073(f__$1,ch__$1,meta14074){
return (new cljs.core.async.t_cljs$core$async14073(f__$1,ch__$1,meta14074));
});

}

return (new cljs.core.async.t_cljs$core$async14073(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if(typeof cljs.core.async.t_cljs$core$async14079 !== 'undefined'){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async14079 = (function (p,ch,meta14080){
this.p = p;
this.ch = ch;
this.meta14080 = meta14080;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
})
cljs.core.async.t_cljs$core$async14079.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_14081,meta14080__$1){
var self__ = this;
var _14081__$1 = this;
return (new cljs.core.async.t_cljs$core$async14079(self__.p,self__.ch,meta14080__$1));
});

cljs.core.async.t_cljs$core$async14079.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_14081){
var self__ = this;
var _14081__$1 = this;
return self__.meta14080;
});

cljs.core.async.t_cljs$core$async14079.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async14079.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14079.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch);
});

cljs.core.async.t_cljs$core$async14079.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async14079.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_.call(null,self__.ch,fn1);
});

cljs.core.async.t_cljs$core$async14079.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL;

cljs.core.async.t_cljs$core$async14079.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.p.call(null,val))){
return cljs.core.async.impl.protocols.put_BANG_.call(null,self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box.call(null,cljs.core.not.call(null,cljs.core.async.impl.protocols.closed_QMARK_.call(null,self__.ch)));
}
});

cljs.core.async.t_cljs$core$async14079.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta14080","meta14080",-1188550705,null)], null);
});

cljs.core.async.t_cljs$core$async14079.cljs$lang$type = true;

cljs.core.async.t_cljs$core$async14079.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async14079";

cljs.core.async.t_cljs$core$async14079.cljs$lang$ctorPrWriter = (function (this__6969__auto__,writer__6970__auto__,opt__6971__auto__){
return cljs.core._write.call(null,writer__6970__auto__,"cljs.core.async/t_cljs$core$async14079");
});

cljs.core.async.__GT_t_cljs$core$async14079 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async14079(p__$1,ch__$1,meta14080){
return (new cljs.core.async.t_cljs$core$async14079(p__$1,ch__$1,meta14080));
});

}

return (new cljs.core.async.t_cljs$core$async14079(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_.call(null,cljs.core.complement.call(null,p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var args14082 = [];
var len__7471__auto___14126 = arguments.length;
var i__7472__auto___14127 = (0);
while(true){
if((i__7472__auto___14127 < len__7471__auto___14126)){
args14082.push((arguments[i__7472__auto___14127]));

var G__14128 = (i__7472__auto___14127 + (1));
i__7472__auto___14127 = G__14128;
continue;
} else {
}
break;
}

var G__14084 = args14082.length;
switch (G__14084) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args14082.length)].join('')));

}
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.call(null,p,ch,null);
});

cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11824__auto___14130 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11824__auto___14130,out){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (c__11824__auto___14130,out){
return (function (state_14105){
var state_val_14106 = (state_14105[(1)]);
if((state_val_14106 === (7))){
var inst_14101 = (state_14105[(2)]);
var state_14105__$1 = state_14105;
var statearr_14107_14131 = state_14105__$1;
(statearr_14107_14131[(2)] = inst_14101);

(statearr_14107_14131[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14106 === (1))){
var state_14105__$1 = state_14105;
var statearr_14108_14132 = state_14105__$1;
(statearr_14108_14132[(2)] = null);

(statearr_14108_14132[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14106 === (4))){
var inst_14087 = (state_14105[(7)]);
var inst_14087__$1 = (state_14105[(2)]);
var inst_14088 = (inst_14087__$1 == null);
var state_14105__$1 = (function (){var statearr_14109 = state_14105;
(statearr_14109[(7)] = inst_14087__$1);

return statearr_14109;
})();
if(cljs.core.truth_(inst_14088)){
var statearr_14110_14133 = state_14105__$1;
(statearr_14110_14133[(1)] = (5));

} else {
var statearr_14111_14134 = state_14105__$1;
(statearr_14111_14134[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14106 === (6))){
var inst_14087 = (state_14105[(7)]);
var inst_14092 = p.call(null,inst_14087);
var state_14105__$1 = state_14105;
if(cljs.core.truth_(inst_14092)){
var statearr_14112_14135 = state_14105__$1;
(statearr_14112_14135[(1)] = (8));

} else {
var statearr_14113_14136 = state_14105__$1;
(statearr_14113_14136[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14106 === (3))){
var inst_14103 = (state_14105[(2)]);
var state_14105__$1 = state_14105;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14105__$1,inst_14103);
} else {
if((state_val_14106 === (2))){
var state_14105__$1 = state_14105;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14105__$1,(4),ch);
} else {
if((state_val_14106 === (11))){
var inst_14095 = (state_14105[(2)]);
var state_14105__$1 = state_14105;
var statearr_14114_14137 = state_14105__$1;
(statearr_14114_14137[(2)] = inst_14095);

(statearr_14114_14137[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14106 === (9))){
var state_14105__$1 = state_14105;
var statearr_14115_14138 = state_14105__$1;
(statearr_14115_14138[(2)] = null);

(statearr_14115_14138[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14106 === (5))){
var inst_14090 = cljs.core.async.close_BANG_.call(null,out);
var state_14105__$1 = state_14105;
var statearr_14116_14139 = state_14105__$1;
(statearr_14116_14139[(2)] = inst_14090);

(statearr_14116_14139[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14106 === (10))){
var inst_14098 = (state_14105[(2)]);
var state_14105__$1 = (function (){var statearr_14117 = state_14105;
(statearr_14117[(8)] = inst_14098);

return statearr_14117;
})();
var statearr_14118_14140 = state_14105__$1;
(statearr_14118_14140[(2)] = null);

(statearr_14118_14140[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14106 === (8))){
var inst_14087 = (state_14105[(7)]);
var state_14105__$1 = state_14105;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14105__$1,(11),out,inst_14087);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11824__auto___14130,out))
;
return ((function (switch__11712__auto__,c__11824__auto___14130,out){
return (function() {
var cljs$core$async$state_machine__11713__auto__ = null;
var cljs$core$async$state_machine__11713__auto____0 = (function (){
var statearr_14122 = [null,null,null,null,null,null,null,null,null];
(statearr_14122[(0)] = cljs$core$async$state_machine__11713__auto__);

(statearr_14122[(1)] = (1));

return statearr_14122;
});
var cljs$core$async$state_machine__11713__auto____1 = (function (state_14105){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_14105);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e14123){if((e14123 instanceof Object)){
var ex__11716__auto__ = e14123;
var statearr_14124_14141 = state_14105;
(statearr_14124_14141[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14105);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14123;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14142 = state_14105;
state_14105 = G__14142;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$state_machine__11713__auto__ = function(state_14105){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11713__auto____1.call(this,state_14105);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11713__auto____0;
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11713__auto____1;
return cljs$core$async$state_machine__11713__auto__;
})()
;})(switch__11712__auto__,c__11824__auto___14130,out))
})();
var state__11826__auto__ = (function (){var statearr_14125 = f__11825__auto__.call(null);
(statearr_14125[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto___14130);

return statearr_14125;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(c__11824__auto___14130,out))
);


return out;
});

cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var args14143 = [];
var len__7471__auto___14146 = arguments.length;
var i__7472__auto___14147 = (0);
while(true){
if((i__7472__auto___14147 < len__7471__auto___14146)){
args14143.push((arguments[i__7472__auto___14147]));

var G__14148 = (i__7472__auto___14147 + (1));
i__7472__auto___14147 = G__14148;
continue;
} else {
}
break;
}

var G__14145 = args14143.length;
switch (G__14145) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args14143.length)].join('')));

}
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.call(null,p,ch,null);
});

cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.call(null,cljs.core.complement.call(null,p),ch,buf_or_n);
});

cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3;

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__11824__auto__ = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11824__auto__){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (c__11824__auto__){
return (function (state_14315){
var state_val_14316 = (state_14315[(1)]);
if((state_val_14316 === (7))){
var inst_14311 = (state_14315[(2)]);
var state_14315__$1 = state_14315;
var statearr_14317_14358 = state_14315__$1;
(statearr_14317_14358[(2)] = inst_14311);

(statearr_14317_14358[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14316 === (20))){
var inst_14281 = (state_14315[(7)]);
var inst_14292 = (state_14315[(2)]);
var inst_14293 = cljs.core.next.call(null,inst_14281);
var inst_14267 = inst_14293;
var inst_14268 = null;
var inst_14269 = (0);
var inst_14270 = (0);
var state_14315__$1 = (function (){var statearr_14318 = state_14315;
(statearr_14318[(8)] = inst_14268);

(statearr_14318[(9)] = inst_14270);

(statearr_14318[(10)] = inst_14292);

(statearr_14318[(11)] = inst_14269);

(statearr_14318[(12)] = inst_14267);

return statearr_14318;
})();
var statearr_14319_14359 = state_14315__$1;
(statearr_14319_14359[(2)] = null);

(statearr_14319_14359[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14316 === (1))){
var state_14315__$1 = state_14315;
var statearr_14320_14360 = state_14315__$1;
(statearr_14320_14360[(2)] = null);

(statearr_14320_14360[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14316 === (4))){
var inst_14256 = (state_14315[(13)]);
var inst_14256__$1 = (state_14315[(2)]);
var inst_14257 = (inst_14256__$1 == null);
var state_14315__$1 = (function (){var statearr_14321 = state_14315;
(statearr_14321[(13)] = inst_14256__$1);

return statearr_14321;
})();
if(cljs.core.truth_(inst_14257)){
var statearr_14322_14361 = state_14315__$1;
(statearr_14322_14361[(1)] = (5));

} else {
var statearr_14323_14362 = state_14315__$1;
(statearr_14323_14362[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14316 === (15))){
var state_14315__$1 = state_14315;
var statearr_14327_14363 = state_14315__$1;
(statearr_14327_14363[(2)] = null);

(statearr_14327_14363[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14316 === (21))){
var state_14315__$1 = state_14315;
var statearr_14328_14364 = state_14315__$1;
(statearr_14328_14364[(2)] = null);

(statearr_14328_14364[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14316 === (13))){
var inst_14268 = (state_14315[(8)]);
var inst_14270 = (state_14315[(9)]);
var inst_14269 = (state_14315[(11)]);
var inst_14267 = (state_14315[(12)]);
var inst_14277 = (state_14315[(2)]);
var inst_14278 = (inst_14270 + (1));
var tmp14324 = inst_14268;
var tmp14325 = inst_14269;
var tmp14326 = inst_14267;
var inst_14267__$1 = tmp14326;
var inst_14268__$1 = tmp14324;
var inst_14269__$1 = tmp14325;
var inst_14270__$1 = inst_14278;
var state_14315__$1 = (function (){var statearr_14329 = state_14315;
(statearr_14329[(8)] = inst_14268__$1);

(statearr_14329[(9)] = inst_14270__$1);

(statearr_14329[(11)] = inst_14269__$1);

(statearr_14329[(12)] = inst_14267__$1);

(statearr_14329[(14)] = inst_14277);

return statearr_14329;
})();
var statearr_14330_14365 = state_14315__$1;
(statearr_14330_14365[(2)] = null);

(statearr_14330_14365[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14316 === (22))){
var state_14315__$1 = state_14315;
var statearr_14331_14366 = state_14315__$1;
(statearr_14331_14366[(2)] = null);

(statearr_14331_14366[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14316 === (6))){
var inst_14256 = (state_14315[(13)]);
var inst_14265 = f.call(null,inst_14256);
var inst_14266 = cljs.core.seq.call(null,inst_14265);
var inst_14267 = inst_14266;
var inst_14268 = null;
var inst_14269 = (0);
var inst_14270 = (0);
var state_14315__$1 = (function (){var statearr_14332 = state_14315;
(statearr_14332[(8)] = inst_14268);

(statearr_14332[(9)] = inst_14270);

(statearr_14332[(11)] = inst_14269);

(statearr_14332[(12)] = inst_14267);

return statearr_14332;
})();
var statearr_14333_14367 = state_14315__$1;
(statearr_14333_14367[(2)] = null);

(statearr_14333_14367[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14316 === (17))){
var inst_14281 = (state_14315[(7)]);
var inst_14285 = cljs.core.chunk_first.call(null,inst_14281);
var inst_14286 = cljs.core.chunk_rest.call(null,inst_14281);
var inst_14287 = cljs.core.count.call(null,inst_14285);
var inst_14267 = inst_14286;
var inst_14268 = inst_14285;
var inst_14269 = inst_14287;
var inst_14270 = (0);
var state_14315__$1 = (function (){var statearr_14334 = state_14315;
(statearr_14334[(8)] = inst_14268);

(statearr_14334[(9)] = inst_14270);

(statearr_14334[(11)] = inst_14269);

(statearr_14334[(12)] = inst_14267);

return statearr_14334;
})();
var statearr_14335_14368 = state_14315__$1;
(statearr_14335_14368[(2)] = null);

(statearr_14335_14368[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14316 === (3))){
var inst_14313 = (state_14315[(2)]);
var state_14315__$1 = state_14315;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14315__$1,inst_14313);
} else {
if((state_val_14316 === (12))){
var inst_14301 = (state_14315[(2)]);
var state_14315__$1 = state_14315;
var statearr_14336_14369 = state_14315__$1;
(statearr_14336_14369[(2)] = inst_14301);

(statearr_14336_14369[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14316 === (2))){
var state_14315__$1 = state_14315;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14315__$1,(4),in$);
} else {
if((state_val_14316 === (23))){
var inst_14309 = (state_14315[(2)]);
var state_14315__$1 = state_14315;
var statearr_14337_14370 = state_14315__$1;
(statearr_14337_14370[(2)] = inst_14309);

(statearr_14337_14370[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14316 === (19))){
var inst_14296 = (state_14315[(2)]);
var state_14315__$1 = state_14315;
var statearr_14338_14371 = state_14315__$1;
(statearr_14338_14371[(2)] = inst_14296);

(statearr_14338_14371[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14316 === (11))){
var inst_14281 = (state_14315[(7)]);
var inst_14267 = (state_14315[(12)]);
var inst_14281__$1 = cljs.core.seq.call(null,inst_14267);
var state_14315__$1 = (function (){var statearr_14339 = state_14315;
(statearr_14339[(7)] = inst_14281__$1);

return statearr_14339;
})();
if(inst_14281__$1){
var statearr_14340_14372 = state_14315__$1;
(statearr_14340_14372[(1)] = (14));

} else {
var statearr_14341_14373 = state_14315__$1;
(statearr_14341_14373[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14316 === (9))){
var inst_14303 = (state_14315[(2)]);
var inst_14304 = cljs.core.async.impl.protocols.closed_QMARK_.call(null,out);
var state_14315__$1 = (function (){var statearr_14342 = state_14315;
(statearr_14342[(15)] = inst_14303);

return statearr_14342;
})();
if(cljs.core.truth_(inst_14304)){
var statearr_14343_14374 = state_14315__$1;
(statearr_14343_14374[(1)] = (21));

} else {
var statearr_14344_14375 = state_14315__$1;
(statearr_14344_14375[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14316 === (5))){
var inst_14259 = cljs.core.async.close_BANG_.call(null,out);
var state_14315__$1 = state_14315;
var statearr_14345_14376 = state_14315__$1;
(statearr_14345_14376[(2)] = inst_14259);

(statearr_14345_14376[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14316 === (14))){
var inst_14281 = (state_14315[(7)]);
var inst_14283 = cljs.core.chunked_seq_QMARK_.call(null,inst_14281);
var state_14315__$1 = state_14315;
if(inst_14283){
var statearr_14346_14377 = state_14315__$1;
(statearr_14346_14377[(1)] = (17));

} else {
var statearr_14347_14378 = state_14315__$1;
(statearr_14347_14378[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14316 === (16))){
var inst_14299 = (state_14315[(2)]);
var state_14315__$1 = state_14315;
var statearr_14348_14379 = state_14315__$1;
(statearr_14348_14379[(2)] = inst_14299);

(statearr_14348_14379[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14316 === (10))){
var inst_14268 = (state_14315[(8)]);
var inst_14270 = (state_14315[(9)]);
var inst_14275 = cljs.core._nth.call(null,inst_14268,inst_14270);
var state_14315__$1 = state_14315;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14315__$1,(13),out,inst_14275);
} else {
if((state_val_14316 === (18))){
var inst_14281 = (state_14315[(7)]);
var inst_14290 = cljs.core.first.call(null,inst_14281);
var state_14315__$1 = state_14315;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14315__$1,(20),out,inst_14290);
} else {
if((state_val_14316 === (8))){
var inst_14270 = (state_14315[(9)]);
var inst_14269 = (state_14315[(11)]);
var inst_14272 = (inst_14270 < inst_14269);
var inst_14273 = inst_14272;
var state_14315__$1 = state_14315;
if(cljs.core.truth_(inst_14273)){
var statearr_14349_14380 = state_14315__$1;
(statearr_14349_14380[(1)] = (10));

} else {
var statearr_14350_14381 = state_14315__$1;
(statearr_14350_14381[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11824__auto__))
;
return ((function (switch__11712__auto__,c__11824__auto__){
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__11713__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__11713__auto____0 = (function (){
var statearr_14354 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14354[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__11713__auto__);

(statearr_14354[(1)] = (1));

return statearr_14354;
});
var cljs$core$async$mapcat_STAR__$_state_machine__11713__auto____1 = (function (state_14315){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_14315);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e14355){if((e14355 instanceof Object)){
var ex__11716__auto__ = e14355;
var statearr_14356_14382 = state_14315;
(statearr_14356_14382[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14315);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14355;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14383 = state_14315;
state_14315 = G__14383;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__11713__auto__ = function(state_14315){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__11713__auto____1.call(this,state_14315);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$mapcat_STAR__$_state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__11713__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__11713__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__11713__auto__;
})()
;})(switch__11712__auto__,c__11824__auto__))
})();
var state__11826__auto__ = (function (){var statearr_14357 = f__11825__auto__.call(null);
(statearr_14357[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto__);

return statearr_14357;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(c__11824__auto__))
);

return c__11824__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var args14384 = [];
var len__7471__auto___14387 = arguments.length;
var i__7472__auto___14388 = (0);
while(true){
if((i__7472__auto___14388 < len__7471__auto___14387)){
args14384.push((arguments[i__7472__auto___14388]));

var G__14389 = (i__7472__auto___14388 + (1));
i__7472__auto___14388 = G__14389;
continue;
} else {
}
break;
}

var G__14386 = args14384.length;
switch (G__14386) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args14384.length)].join('')));

}
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.call(null,f,in$,null);
});

cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return out;
});

cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var args14391 = [];
var len__7471__auto___14394 = arguments.length;
var i__7472__auto___14395 = (0);
while(true){
if((i__7472__auto___14395 < len__7471__auto___14394)){
args14391.push((arguments[i__7472__auto___14395]));

var G__14396 = (i__7472__auto___14395 + (1));
i__7472__auto___14395 = G__14396;
continue;
} else {
}
break;
}

var G__14393 = args14391.length;
switch (G__14393) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args14391.length)].join('')));

}
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.call(null,f,out,null);
});

cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.call(null,buf_or_n);
cljs.core.async.mapcat_STAR_.call(null,f,in$,out);

return in$;
});

cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var args14398 = [];
var len__7471__auto___14449 = arguments.length;
var i__7472__auto___14450 = (0);
while(true){
if((i__7472__auto___14450 < len__7471__auto___14449)){
args14398.push((arguments[i__7472__auto___14450]));

var G__14451 = (i__7472__auto___14450 + (1));
i__7472__auto___14450 = G__14451;
continue;
} else {
}
break;
}

var G__14400 = args14398.length;
switch (G__14400) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args14398.length)].join('')));

}
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.call(null,ch,null);
});

cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11824__auto___14453 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11824__auto___14453,out){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (c__11824__auto___14453,out){
return (function (state_14424){
var state_val_14425 = (state_14424[(1)]);
if((state_val_14425 === (7))){
var inst_14419 = (state_14424[(2)]);
var state_14424__$1 = state_14424;
var statearr_14426_14454 = state_14424__$1;
(statearr_14426_14454[(2)] = inst_14419);

(statearr_14426_14454[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14425 === (1))){
var inst_14401 = null;
var state_14424__$1 = (function (){var statearr_14427 = state_14424;
(statearr_14427[(7)] = inst_14401);

return statearr_14427;
})();
var statearr_14428_14455 = state_14424__$1;
(statearr_14428_14455[(2)] = null);

(statearr_14428_14455[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14425 === (4))){
var inst_14404 = (state_14424[(8)]);
var inst_14404__$1 = (state_14424[(2)]);
var inst_14405 = (inst_14404__$1 == null);
var inst_14406 = cljs.core.not.call(null,inst_14405);
var state_14424__$1 = (function (){var statearr_14429 = state_14424;
(statearr_14429[(8)] = inst_14404__$1);

return statearr_14429;
})();
if(inst_14406){
var statearr_14430_14456 = state_14424__$1;
(statearr_14430_14456[(1)] = (5));

} else {
var statearr_14431_14457 = state_14424__$1;
(statearr_14431_14457[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14425 === (6))){
var state_14424__$1 = state_14424;
var statearr_14432_14458 = state_14424__$1;
(statearr_14432_14458[(2)] = null);

(statearr_14432_14458[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14425 === (3))){
var inst_14421 = (state_14424[(2)]);
var inst_14422 = cljs.core.async.close_BANG_.call(null,out);
var state_14424__$1 = (function (){var statearr_14433 = state_14424;
(statearr_14433[(9)] = inst_14421);

return statearr_14433;
})();
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14424__$1,inst_14422);
} else {
if((state_val_14425 === (2))){
var state_14424__$1 = state_14424;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14424__$1,(4),ch);
} else {
if((state_val_14425 === (11))){
var inst_14404 = (state_14424[(8)]);
var inst_14413 = (state_14424[(2)]);
var inst_14401 = inst_14404;
var state_14424__$1 = (function (){var statearr_14434 = state_14424;
(statearr_14434[(7)] = inst_14401);

(statearr_14434[(10)] = inst_14413);

return statearr_14434;
})();
var statearr_14435_14459 = state_14424__$1;
(statearr_14435_14459[(2)] = null);

(statearr_14435_14459[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14425 === (9))){
var inst_14404 = (state_14424[(8)]);
var state_14424__$1 = state_14424;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14424__$1,(11),out,inst_14404);
} else {
if((state_val_14425 === (5))){
var inst_14401 = (state_14424[(7)]);
var inst_14404 = (state_14424[(8)]);
var inst_14408 = cljs.core._EQ_.call(null,inst_14404,inst_14401);
var state_14424__$1 = state_14424;
if(inst_14408){
var statearr_14437_14460 = state_14424__$1;
(statearr_14437_14460[(1)] = (8));

} else {
var statearr_14438_14461 = state_14424__$1;
(statearr_14438_14461[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14425 === (10))){
var inst_14416 = (state_14424[(2)]);
var state_14424__$1 = state_14424;
var statearr_14439_14462 = state_14424__$1;
(statearr_14439_14462[(2)] = inst_14416);

(statearr_14439_14462[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14425 === (8))){
var inst_14401 = (state_14424[(7)]);
var tmp14436 = inst_14401;
var inst_14401__$1 = tmp14436;
var state_14424__$1 = (function (){var statearr_14440 = state_14424;
(statearr_14440[(7)] = inst_14401__$1);

return statearr_14440;
})();
var statearr_14441_14463 = state_14424__$1;
(statearr_14441_14463[(2)] = null);

(statearr_14441_14463[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__11824__auto___14453,out))
;
return ((function (switch__11712__auto__,c__11824__auto___14453,out){
return (function() {
var cljs$core$async$state_machine__11713__auto__ = null;
var cljs$core$async$state_machine__11713__auto____0 = (function (){
var statearr_14445 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_14445[(0)] = cljs$core$async$state_machine__11713__auto__);

(statearr_14445[(1)] = (1));

return statearr_14445;
});
var cljs$core$async$state_machine__11713__auto____1 = (function (state_14424){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_14424);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e14446){if((e14446 instanceof Object)){
var ex__11716__auto__ = e14446;
var statearr_14447_14464 = state_14424;
(statearr_14447_14464[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14424);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14446;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14465 = state_14424;
state_14424 = G__14465;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$state_machine__11713__auto__ = function(state_14424){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11713__auto____1.call(this,state_14424);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11713__auto____0;
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11713__auto____1;
return cljs$core$async$state_machine__11713__auto__;
})()
;})(switch__11712__auto__,c__11824__auto___14453,out))
})();
var state__11826__auto__ = (function (){var statearr_14448 = f__11825__auto__.call(null);
(statearr_14448[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto___14453);

return statearr_14448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(c__11824__auto___14453,out))
);


return out;
});

cljs.core.async.unique.cljs$lang$maxFixedArity = 2;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var args14466 = [];
var len__7471__auto___14536 = arguments.length;
var i__7472__auto___14537 = (0);
while(true){
if((i__7472__auto___14537 < len__7471__auto___14536)){
args14466.push((arguments[i__7472__auto___14537]));

var G__14538 = (i__7472__auto___14537 + (1));
i__7472__auto___14537 = G__14538;
continue;
} else {
}
break;
}

var G__14468 = args14466.length;
switch (G__14468) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args14466.length)].join('')));

}
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.call(null,n,ch,null);
});

cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11824__auto___14540 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11824__auto___14540,out){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (c__11824__auto___14540,out){
return (function (state_14506){
var state_val_14507 = (state_14506[(1)]);
if((state_val_14507 === (7))){
var inst_14502 = (state_14506[(2)]);
var state_14506__$1 = state_14506;
var statearr_14508_14541 = state_14506__$1;
(statearr_14508_14541[(2)] = inst_14502);

(statearr_14508_14541[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14507 === (1))){
var inst_14469 = (new Array(n));
var inst_14470 = inst_14469;
var inst_14471 = (0);
var state_14506__$1 = (function (){var statearr_14509 = state_14506;
(statearr_14509[(7)] = inst_14471);

(statearr_14509[(8)] = inst_14470);

return statearr_14509;
})();
var statearr_14510_14542 = state_14506__$1;
(statearr_14510_14542[(2)] = null);

(statearr_14510_14542[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14507 === (4))){
var inst_14474 = (state_14506[(9)]);
var inst_14474__$1 = (state_14506[(2)]);
var inst_14475 = (inst_14474__$1 == null);
var inst_14476 = cljs.core.not.call(null,inst_14475);
var state_14506__$1 = (function (){var statearr_14511 = state_14506;
(statearr_14511[(9)] = inst_14474__$1);

return statearr_14511;
})();
if(inst_14476){
var statearr_14512_14543 = state_14506__$1;
(statearr_14512_14543[(1)] = (5));

} else {
var statearr_14513_14544 = state_14506__$1;
(statearr_14513_14544[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14507 === (15))){
var inst_14496 = (state_14506[(2)]);
var state_14506__$1 = state_14506;
var statearr_14514_14545 = state_14506__$1;
(statearr_14514_14545[(2)] = inst_14496);

(statearr_14514_14545[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14507 === (13))){
var state_14506__$1 = state_14506;
var statearr_14515_14546 = state_14506__$1;
(statearr_14515_14546[(2)] = null);

(statearr_14515_14546[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14507 === (6))){
var inst_14471 = (state_14506[(7)]);
var inst_14492 = (inst_14471 > (0));
var state_14506__$1 = state_14506;
if(cljs.core.truth_(inst_14492)){
var statearr_14516_14547 = state_14506__$1;
(statearr_14516_14547[(1)] = (12));

} else {
var statearr_14517_14548 = state_14506__$1;
(statearr_14517_14548[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14507 === (3))){
var inst_14504 = (state_14506[(2)]);
var state_14506__$1 = state_14506;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14506__$1,inst_14504);
} else {
if((state_val_14507 === (12))){
var inst_14470 = (state_14506[(8)]);
var inst_14494 = cljs.core.vec.call(null,inst_14470);
var state_14506__$1 = state_14506;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14506__$1,(15),out,inst_14494);
} else {
if((state_val_14507 === (2))){
var state_14506__$1 = state_14506;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14506__$1,(4),ch);
} else {
if((state_val_14507 === (11))){
var inst_14486 = (state_14506[(2)]);
var inst_14487 = (new Array(n));
var inst_14470 = inst_14487;
var inst_14471 = (0);
var state_14506__$1 = (function (){var statearr_14518 = state_14506;
(statearr_14518[(7)] = inst_14471);

(statearr_14518[(8)] = inst_14470);

(statearr_14518[(10)] = inst_14486);

return statearr_14518;
})();
var statearr_14519_14549 = state_14506__$1;
(statearr_14519_14549[(2)] = null);

(statearr_14519_14549[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14507 === (9))){
var inst_14470 = (state_14506[(8)]);
var inst_14484 = cljs.core.vec.call(null,inst_14470);
var state_14506__$1 = state_14506;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14506__$1,(11),out,inst_14484);
} else {
if((state_val_14507 === (5))){
var inst_14471 = (state_14506[(7)]);
var inst_14470 = (state_14506[(8)]);
var inst_14479 = (state_14506[(11)]);
var inst_14474 = (state_14506[(9)]);
var inst_14478 = (inst_14470[inst_14471] = inst_14474);
var inst_14479__$1 = (inst_14471 + (1));
var inst_14480 = (inst_14479__$1 < n);
var state_14506__$1 = (function (){var statearr_14520 = state_14506;
(statearr_14520[(11)] = inst_14479__$1);

(statearr_14520[(12)] = inst_14478);

return statearr_14520;
})();
if(cljs.core.truth_(inst_14480)){
var statearr_14521_14550 = state_14506__$1;
(statearr_14521_14550[(1)] = (8));

} else {
var statearr_14522_14551 = state_14506__$1;
(statearr_14522_14551[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14507 === (14))){
var inst_14499 = (state_14506[(2)]);
var inst_14500 = cljs.core.async.close_BANG_.call(null,out);
var state_14506__$1 = (function (){var statearr_14524 = state_14506;
(statearr_14524[(13)] = inst_14499);

return statearr_14524;
})();
var statearr_14525_14552 = state_14506__$1;
(statearr_14525_14552[(2)] = inst_14500);

(statearr_14525_14552[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14507 === (10))){
var inst_14490 = (state_14506[(2)]);
var state_14506__$1 = state_14506;
var statearr_14526_14553 = state_14506__$1;
(statearr_14526_14553[(2)] = inst_14490);

(statearr_14526_14553[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14507 === (8))){
var inst_14470 = (state_14506[(8)]);
var inst_14479 = (state_14506[(11)]);
var tmp14523 = inst_14470;
var inst_14470__$1 = tmp14523;
var inst_14471 = inst_14479;
var state_14506__$1 = (function (){var statearr_14527 = state_14506;
(statearr_14527[(7)] = inst_14471);

(statearr_14527[(8)] = inst_14470__$1);

return statearr_14527;
})();
var statearr_14528_14554 = state_14506__$1;
(statearr_14528_14554[(2)] = null);

(statearr_14528_14554[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11824__auto___14540,out))
;
return ((function (switch__11712__auto__,c__11824__auto___14540,out){
return (function() {
var cljs$core$async$state_machine__11713__auto__ = null;
var cljs$core$async$state_machine__11713__auto____0 = (function (){
var statearr_14532 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14532[(0)] = cljs$core$async$state_machine__11713__auto__);

(statearr_14532[(1)] = (1));

return statearr_14532;
});
var cljs$core$async$state_machine__11713__auto____1 = (function (state_14506){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_14506);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e14533){if((e14533 instanceof Object)){
var ex__11716__auto__ = e14533;
var statearr_14534_14555 = state_14506;
(statearr_14534_14555[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14506);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14533;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14556 = state_14506;
state_14506 = G__14556;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$state_machine__11713__auto__ = function(state_14506){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11713__auto____1.call(this,state_14506);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11713__auto____0;
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11713__auto____1;
return cljs$core$async$state_machine__11713__auto__;
})()
;})(switch__11712__auto__,c__11824__auto___14540,out))
})();
var state__11826__auto__ = (function (){var statearr_14535 = f__11825__auto__.call(null);
(statearr_14535[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto___14540);

return statearr_14535;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(c__11824__auto___14540,out))
);


return out;
});

cljs.core.async.partition.cljs$lang$maxFixedArity = 3;

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var args14557 = [];
var len__7471__auto___14631 = arguments.length;
var i__7472__auto___14632 = (0);
while(true){
if((i__7472__auto___14632 < len__7471__auto___14631)){
args14557.push((arguments[i__7472__auto___14632]));

var G__14633 = (i__7472__auto___14632 + (1));
i__7472__auto___14632 = G__14633;
continue;
} else {
}
break;
}

var G__14559 = args14557.length;
switch (G__14559) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error([cljs.core.str.cljs$core$IFn$_invoke$arity$1("Invalid arity: "),cljs.core.str.cljs$core$IFn$_invoke$arity$1(args14557.length)].join('')));

}
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.call(null,f,ch,null);
});

cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.call(null,buf_or_n);
var c__11824__auto___14635 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11824__auto___14635,out){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (c__11824__auto___14635,out){
return (function (state_14601){
var state_val_14602 = (state_14601[(1)]);
if((state_val_14602 === (7))){
var inst_14597 = (state_14601[(2)]);
var state_14601__$1 = state_14601;
var statearr_14603_14636 = state_14601__$1;
(statearr_14603_14636[(2)] = inst_14597);

(statearr_14603_14636[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14602 === (1))){
var inst_14560 = [];
var inst_14561 = inst_14560;
var inst_14562 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_14601__$1 = (function (){var statearr_14604 = state_14601;
(statearr_14604[(7)] = inst_14562);

(statearr_14604[(8)] = inst_14561);

return statearr_14604;
})();
var statearr_14605_14637 = state_14601__$1;
(statearr_14605_14637[(2)] = null);

(statearr_14605_14637[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14602 === (4))){
var inst_14565 = (state_14601[(9)]);
var inst_14565__$1 = (state_14601[(2)]);
var inst_14566 = (inst_14565__$1 == null);
var inst_14567 = cljs.core.not.call(null,inst_14566);
var state_14601__$1 = (function (){var statearr_14606 = state_14601;
(statearr_14606[(9)] = inst_14565__$1);

return statearr_14606;
})();
if(inst_14567){
var statearr_14607_14638 = state_14601__$1;
(statearr_14607_14638[(1)] = (5));

} else {
var statearr_14608_14639 = state_14601__$1;
(statearr_14608_14639[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14602 === (15))){
var inst_14591 = (state_14601[(2)]);
var state_14601__$1 = state_14601;
var statearr_14609_14640 = state_14601__$1;
(statearr_14609_14640[(2)] = inst_14591);

(statearr_14609_14640[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14602 === (13))){
var state_14601__$1 = state_14601;
var statearr_14610_14641 = state_14601__$1;
(statearr_14610_14641[(2)] = null);

(statearr_14610_14641[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14602 === (6))){
var inst_14561 = (state_14601[(8)]);
var inst_14586 = inst_14561.length;
var inst_14587 = (inst_14586 > (0));
var state_14601__$1 = state_14601;
if(cljs.core.truth_(inst_14587)){
var statearr_14611_14642 = state_14601__$1;
(statearr_14611_14642[(1)] = (12));

} else {
var statearr_14612_14643 = state_14601__$1;
(statearr_14612_14643[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14602 === (3))){
var inst_14599 = (state_14601[(2)]);
var state_14601__$1 = state_14601;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_14601__$1,inst_14599);
} else {
if((state_val_14602 === (12))){
var inst_14561 = (state_14601[(8)]);
var inst_14589 = cljs.core.vec.call(null,inst_14561);
var state_14601__$1 = state_14601;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14601__$1,(15),out,inst_14589);
} else {
if((state_val_14602 === (2))){
var state_14601__$1 = state_14601;
return cljs.core.async.impl.ioc_helpers.take_BANG_.call(null,state_14601__$1,(4),ch);
} else {
if((state_val_14602 === (11))){
var inst_14565 = (state_14601[(9)]);
var inst_14569 = (state_14601[(10)]);
var inst_14579 = (state_14601[(2)]);
var inst_14580 = [];
var inst_14581 = inst_14580.push(inst_14565);
var inst_14561 = inst_14580;
var inst_14562 = inst_14569;
var state_14601__$1 = (function (){var statearr_14613 = state_14601;
(statearr_14613[(7)] = inst_14562);

(statearr_14613[(8)] = inst_14561);

(statearr_14613[(11)] = inst_14581);

(statearr_14613[(12)] = inst_14579);

return statearr_14613;
})();
var statearr_14614_14644 = state_14601__$1;
(statearr_14614_14644[(2)] = null);

(statearr_14614_14644[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14602 === (9))){
var inst_14561 = (state_14601[(8)]);
var inst_14577 = cljs.core.vec.call(null,inst_14561);
var state_14601__$1 = state_14601;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_14601__$1,(11),out,inst_14577);
} else {
if((state_val_14602 === (5))){
var inst_14562 = (state_14601[(7)]);
var inst_14565 = (state_14601[(9)]);
var inst_14569 = (state_14601[(10)]);
var inst_14569__$1 = f.call(null,inst_14565);
var inst_14570 = cljs.core._EQ_.call(null,inst_14569__$1,inst_14562);
var inst_14571 = cljs.core.keyword_identical_QMARK_.call(null,inst_14562,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var inst_14572 = (inst_14570) || (inst_14571);
var state_14601__$1 = (function (){var statearr_14615 = state_14601;
(statearr_14615[(10)] = inst_14569__$1);

return statearr_14615;
})();
if(cljs.core.truth_(inst_14572)){
var statearr_14616_14645 = state_14601__$1;
(statearr_14616_14645[(1)] = (8));

} else {
var statearr_14617_14646 = state_14601__$1;
(statearr_14617_14646[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14602 === (14))){
var inst_14594 = (state_14601[(2)]);
var inst_14595 = cljs.core.async.close_BANG_.call(null,out);
var state_14601__$1 = (function (){var statearr_14619 = state_14601;
(statearr_14619[(13)] = inst_14594);

return statearr_14619;
})();
var statearr_14620_14647 = state_14601__$1;
(statearr_14620_14647[(2)] = inst_14595);

(statearr_14620_14647[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14602 === (10))){
var inst_14584 = (state_14601[(2)]);
var state_14601__$1 = state_14601;
var statearr_14621_14648 = state_14601__$1;
(statearr_14621_14648[(2)] = inst_14584);

(statearr_14621_14648[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_14602 === (8))){
var inst_14565 = (state_14601[(9)]);
var inst_14561 = (state_14601[(8)]);
var inst_14569 = (state_14601[(10)]);
var inst_14574 = inst_14561.push(inst_14565);
var tmp14618 = inst_14561;
var inst_14561__$1 = tmp14618;
var inst_14562 = inst_14569;
var state_14601__$1 = (function (){var statearr_14622 = state_14601;
(statearr_14622[(7)] = inst_14562);

(statearr_14622[(14)] = inst_14574);

(statearr_14622[(8)] = inst_14561__$1);

return statearr_14622;
})();
var statearr_14623_14649 = state_14601__$1;
(statearr_14623_14649[(2)] = null);

(statearr_14623_14649[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11824__auto___14635,out))
;
return ((function (switch__11712__auto__,c__11824__auto___14635,out){
return (function() {
var cljs$core$async$state_machine__11713__auto__ = null;
var cljs$core$async$state_machine__11713__auto____0 = (function (){
var statearr_14627 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_14627[(0)] = cljs$core$async$state_machine__11713__auto__);

(statearr_14627[(1)] = (1));

return statearr_14627;
});
var cljs$core$async$state_machine__11713__auto____1 = (function (state_14601){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_14601);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e14628){if((e14628 instanceof Object)){
var ex__11716__auto__ = e14628;
var statearr_14629_14650 = state_14601;
(statearr_14629_14650[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_14601);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e14628;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__14651 = state_14601;
state_14601 = G__14651;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
cljs$core$async$state_machine__11713__auto__ = function(state_14601){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__11713__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__11713__auto____1.call(this,state_14601);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__11713__auto____0;
cljs$core$async$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__11713__auto____1;
return cljs$core$async$state_machine__11713__auto__;
})()
;})(switch__11712__auto__,c__11824__auto___14635,out))
})();
var state__11826__auto__ = (function (){var statearr_14630 = f__11825__auto__.call(null);
(statearr_14630[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto___14635);

return statearr_14630;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(c__11824__auto___14635,out))
);


return out;
});

cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3;


//# sourceMappingURL=async.js.map