// Compiled by ClojureScript 1.9.521 {}
goog.provide('chord.client');
goog.require('cljs.core');
goog.require('cljs.core.async');
goog.require('chord.channels');
goog.require('chord.format');
chord.client.close_event__GT_maybe_error = (function chord$client$close_event__GT_maybe_error(ev){
if(cljs.core.truth_(ev.wasClean)){
return null;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"reason","reason",-2070751759),ev.reason,new cljs.core.Keyword(null,"code","code",1586293142),ev.code], null);
}
});
chord.client.create_ws = (function chord$client$create_ws(url,opts){
if(cljs.core.truth_((function (){var and__6346__auto__ = typeof require !== 'undefined';
if(and__6346__auto__){
try{return require("ws");
}catch (e15139){var e = e15139;
return false;
}} else {
return and__6346__auto__;
}
})())){
var ws = require("ws");
if(cljs.core.truth_(opts)){
return (new ws(url,cljs.core.clj__GT_js.call(null,opts)));
} else {
return (new ws(url));
}
} else {
return (new WebSocket(url));

}
});
/**
 * Creates websockets connection and returns a 2-sided channel when the websocket is opened.
 * Arguments:
 *  ws-url           - (required) link to websocket service
 *  opts             - (optional) map to configure reading/writing channels
 *    :read-ch       - (optional) (possibly buffered) channel to use for reading the websocket
 *    :write-ch      - (optional) (possibly buffered) channel to use for writing to the websocket
 *    :format        - (optional) data format to use on the channel, (at the moment)
 *                                either :edn (default), :json, :json-kw or :str.
 *    :ws-opts       - (optional) Other options to be passed to the websocket constructor (NodeJS only)
 *                                see https://github.com/websockets/ws/blob/master/doc/ws.md#new-websocketaddress-protocols-options
 * 
 * Usage:
 *  (:require [cljs.core.async :as a])
 * 
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437"))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))}))
 * 
 *  (a/<! (ws-ch "ws://127.0.0.1:6437" {:read-ch (a/chan (a/sliding-buffer 10))
 *                                        :write-ch (a/chan (a/dropping-buffer 10))}))
 */
chord.client.ws_ch = (function chord$client$ws_ch(var_args){
var args__7478__auto__ = [];
var len__7471__auto___15254 = arguments.length;
var i__7472__auto___15255 = (0);
while(true){
if((i__7472__auto___15255 < len__7471__auto___15254)){
args__7478__auto__.push((arguments[i__7472__auto___15255]));

var G__15256 = (i__7472__auto___15255 + (1));
i__7472__auto___15255 = G__15256;
continue;
} else {
}
break;
}

var argseq__7479__auto__ = ((((1) < args__7478__auto__.length))?(new cljs.core.IndexedSeq(args__7478__auto__.slice((1)),(0),null)):null);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7479__auto__);
});

chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic = (function (ws_url,p__15144){
var vec__15145 = p__15144;
var map__15148 = cljs.core.nth.call(null,vec__15145,(0),null);
var map__15148__$1 = ((((!((map__15148 == null)))?((((map__15148.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15148.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15148):map__15148);
var opts = map__15148__$1;
var read_ch = cljs.core.get.call(null,map__15148__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch = cljs.core.get.call(null,map__15148__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var format = cljs.core.get.call(null,map__15148__$1,new cljs.core.Keyword(null,"format","format",-1306924766));
var ws_opts = cljs.core.get.call(null,map__15148__$1,new cljs.core.Keyword(null,"ws-opts","ws-opts",1487801643));
var web_socket = chord.client.create_ws.call(null,ws_url,ws_opts);
var map__15150 = chord.format.wrap_format.call(null,new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"read-ch","read-ch",-38486414),(function (){var or__6358__auto__ = read_ch;
if(cljs.core.truth_(or__6358__auto__)){
return or__6358__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})(),new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599),(function (){var or__6358__auto__ = write_ch;
if(cljs.core.truth_(or__6358__auto__)){
return or__6358__auto__;
} else {
return cljs.core.async.chan.call(null);
}
})()], null),opts);
var map__15150__$1 = ((((!((map__15150 == null)))?((((map__15150.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__15150.cljs$core$ISeq$)))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__15150):map__15150);
var read_ch__$1 = cljs.core.get.call(null,map__15150__$1,new cljs.core.Keyword(null,"read-ch","read-ch",-38486414));
var write_ch__$1 = cljs.core.get.call(null,map__15150__$1,new cljs.core.Keyword(null,"write-ch","write-ch",-1766585599));
var open_ch = cljs.core.async.chan.call(null);
var close_ch = cljs.core.async.chan.call(null);
web_socket.binaryType = "arraybuffer";

chord.channels.read_from_ws_BANG_.call(null,web_socket,read_ch__$1);

chord.channels.write_to_ws_BANG_.call(null,web_socket,write_ch__$1);

web_socket.onopen = ((function (web_socket,map__15150,map__15150__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__15145,map__15148,map__15148__$1,opts,read_ch,write_ch,format,ws_opts){
return (function (p1__15140_SHARP_){
return cljs.core.async.put_BANG_.call(null,open_ch,p1__15140_SHARP_);
});})(web_socket,map__15150,map__15150__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__15145,map__15148,map__15148__$1,opts,read_ch,write_ch,format,ws_opts))
;

web_socket.onclose = ((function (web_socket,map__15150,map__15150__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__15145,map__15148,map__15148__$1,opts,read_ch,write_ch,format,ws_opts){
return (function (p1__15141_SHARP_){
return cljs.core.async.put_BANG_.call(null,close_ch,p1__15141_SHARP_);
});})(web_socket,map__15150,map__15150__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__15145,map__15148,map__15148__$1,opts,read_ch,write_ch,format,ws_opts))
;

var ws_chan = chord.channels.bidi_ch.call(null,read_ch__$1,write_ch__$1,new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"on-close","on-close",-761178394),((function (web_socket,map__15150,map__15150__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__15145,map__15148,map__15148__$1,opts,read_ch,write_ch,format,ws_opts){
return (function (){
return web_socket.close();
});})(web_socket,map__15150,map__15150__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__15145,map__15148,map__15148__$1,opts,read_ch,write_ch,format,ws_opts))
], null));
var initial_ch = cljs.core.async.chan.call(null);
var c__11824__auto___15257 = cljs.core.async.chan.call(null,(1));
cljs.core.async.impl.dispatch.run.call(null,((function (c__11824__auto___15257,ws_chan,initial_ch,web_socket,map__15150,map__15150__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__15145,map__15148,map__15148__$1,opts,read_ch,write_ch,format,ws_opts){
return (function (){
var f__11825__auto__ = (function (){var switch__11712__auto__ = ((function (c__11824__auto___15257,ws_chan,initial_ch,web_socket,map__15150,map__15150__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__15145,map__15148,map__15148__$1,opts,read_ch,write_ch,format,ws_opts){
return (function (state_15217){
var state_val_15218 = (state_15217[(1)]);
if((state_val_15218 === (7))){
var inst_15213 = (state_15217[(2)]);
var state_15217__$1 = state_15217;
var statearr_15219_15258 = state_15217__$1;
(statearr_15219_15258[(2)] = inst_15213);

(statearr_15219_15258[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15218 === (20))){
var state_15217__$1 = state_15217;
var statearr_15220_15259 = state_15217__$1;
(statearr_15220_15259[(2)] = null);

(statearr_15220_15259[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15218 === (1))){
var inst_15152 = false;
var state_15217__$1 = (function (){var statearr_15221 = state_15217;
(statearr_15221[(7)] = inst_15152);

return statearr_15221;
})();
var statearr_15222_15260 = state_15217__$1;
(statearr_15222_15260[(2)] = null);

(statearr_15222_15260[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15218 === (4))){
var inst_15165 = (state_15217[(8)]);
var inst_15167 = (state_15217[(9)]);
var inst_15165__$1 = (state_15217[(2)]);
var inst_15166 = cljs.core.nth.call(null,inst_15165__$1,(0),null);
var inst_15167__$1 = cljs.core.nth.call(null,inst_15165__$1,(1),null);
var inst_15168 = cljs.core._EQ_.call(null,inst_15167__$1,open_ch);
var state_15217__$1 = (function (){var statearr_15223 = state_15217;
(statearr_15223[(8)] = inst_15165__$1);

(statearr_15223[(9)] = inst_15167__$1);

(statearr_15223[(10)] = inst_15166);

return statearr_15223;
})();
if(inst_15168){
var statearr_15224_15261 = state_15217__$1;
(statearr_15224_15261[(1)] = (5));

} else {
var statearr_15225_15262 = state_15217__$1;
(statearr_15225_15262[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15218 === (15))){
var inst_15198 = (state_15217[(2)]);
var state_15217__$1 = state_15217;
var statearr_15226_15263 = state_15217__$1;
(statearr_15226_15263[(2)] = inst_15198);

(statearr_15226_15263[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15218 === (21))){
var inst_15209 = (state_15217[(2)]);
var state_15217__$1 = state_15217;
var statearr_15227_15264 = state_15217__$1;
(statearr_15227_15264[(2)] = inst_15209);

(statearr_15227_15264[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15218 === (13))){
var state_15217__$1 = state_15217;
var statearr_15228_15265 = state_15217__$1;
(statearr_15228_15265[(2)] = null);

(statearr_15228_15265[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15218 === (6))){
var inst_15167 = (state_15217[(9)]);
var inst_15182 = cljs.core._EQ_.call(null,inst_15167,close_ch);
var state_15217__$1 = state_15217;
if(inst_15182){
var statearr_15229_15266 = state_15217__$1;
(statearr_15229_15266[(1)] = (9));

} else {
var statearr_15230_15267 = state_15217__$1;
(statearr_15230_15267[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15218 === (17))){
var state_15217__$1 = state_15217;
var statearr_15231_15268 = state_15217__$1;
(statearr_15231_15268[(2)] = initial_ch);

(statearr_15231_15268[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15218 === (3))){
var inst_15215 = (state_15217[(2)]);
var state_15217__$1 = state_15217;
return cljs.core.async.impl.ioc_helpers.return_chan.call(null,state_15217__$1,inst_15215);
} else {
if((state_val_15218 === (12))){
var inst_15152 = (state_15217[(7)]);
var state_15217__$1 = state_15217;
if(cljs.core.truth_(inst_15152)){
var statearr_15232_15269 = state_15217__$1;
(statearr_15232_15269[(1)] = (16));

} else {
var statearr_15233_15270 = state_15217__$1;
(statearr_15233_15270[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15218 === (2))){
var inst_15161 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_15162 = [open_ch,close_ch];
var inst_15163 = (new cljs.core.PersistentVector(null,2,(5),inst_15161,inst_15162,null));
var state_15217__$1 = state_15217;
return cljs.core.async.ioc_alts_BANG_.call(null,state_15217__$1,(4),inst_15163);
} else {
if((state_val_15218 === (19))){
var inst_15166 = (state_15217[(10)]);
var state_15217__$1 = state_15217;
var statearr_15234_15271 = state_15217__$1;
(statearr_15234_15271[(2)] = inst_15166);

(statearr_15234_15271[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15218 === (11))){
var inst_15211 = (state_15217[(2)]);
var state_15217__$1 = state_15217;
var statearr_15235_15272 = state_15217__$1;
(statearr_15235_15272[(2)] = inst_15211);

(statearr_15235_15272[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15218 === (9))){
var inst_15165 = (state_15217[(8)]);
var inst_15188 = (state_15217[(11)]);
var inst_15187 = cljs.core.nth.call(null,inst_15165,(0),null);
var inst_15188__$1 = chord.client.close_event__GT_maybe_error.call(null,inst_15187);
var state_15217__$1 = (function (){var statearr_15236 = state_15217;
(statearr_15236[(11)] = inst_15188__$1);

return statearr_15236;
})();
if(cljs.core.truth_(inst_15188__$1)){
var statearr_15237_15273 = state_15217__$1;
(statearr_15237_15273[(1)] = (12));

} else {
var statearr_15238_15274 = state_15217__$1;
(statearr_15238_15274[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15218 === (5))){
var inst_15165 = (state_15217[(8)]);
var inst_15173 = cljs.core.nth.call(null,inst_15165,(0),null);
var inst_15174 = [new cljs.core.Keyword(null,"ws-channel","ws-channel",1643892174)];
var inst_15175 = [ws_chan];
var inst_15176 = cljs.core.PersistentHashMap.fromArrays(inst_15174,inst_15175);
var state_15217__$1 = (function (){var statearr_15239 = state_15217;
(statearr_15239[(12)] = inst_15173);

return statearr_15239;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15217__$1,(8),initial_ch,inst_15176);
} else {
if((state_val_15218 === (14))){
var inst_15201 = (state_15217[(2)]);
var inst_15202 = cljs.core.async.close_BANG_.call(null,ws_chan);
var inst_15203 = cljs.core.async.close_BANG_.call(null,initial_ch);
var state_15217__$1 = (function (){var statearr_15240 = state_15217;
(statearr_15240[(13)] = inst_15202);

(statearr_15240[(14)] = inst_15201);

return statearr_15240;
})();
var statearr_15241_15275 = state_15217__$1;
(statearr_15241_15275[(2)] = inst_15203);

(statearr_15241_15275[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15218 === (16))){
var state_15217__$1 = state_15217;
var statearr_15242_15276 = state_15217__$1;
(statearr_15242_15276[(2)] = read_ch__$1);

(statearr_15242_15276[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15218 === (10))){
var inst_15167 = (state_15217[(9)]);
var inst_15205 = cljs.core._EQ_.call(null,inst_15167,new cljs.core.Keyword(null,"default","default",-1987822328));
var state_15217__$1 = state_15217;
if(inst_15205){
var statearr_15243_15277 = state_15217__$1;
(statearr_15243_15277[(1)] = (19));

} else {
var statearr_15244_15278 = state_15217__$1;
(statearr_15244_15278[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_15218 === (18))){
var inst_15188 = (state_15217[(11)]);
var inst_15193 = (state_15217[(2)]);
var inst_15194 = [new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_15195 = [inst_15188];
var inst_15196 = cljs.core.PersistentHashMap.fromArrays(inst_15194,inst_15195);
var state_15217__$1 = state_15217;
return cljs.core.async.impl.ioc_helpers.put_BANG_.call(null,state_15217__$1,(15),inst_15193,inst_15196);
} else {
if((state_val_15218 === (8))){
var inst_15178 = (state_15217[(2)]);
var inst_15179 = cljs.core.async.close_BANG_.call(null,initial_ch);
var inst_15152 = true;
var state_15217__$1 = (function (){var statearr_15245 = state_15217;
(statearr_15245[(15)] = inst_15178);

(statearr_15245[(7)] = inst_15152);

(statearr_15245[(16)] = inst_15179);

return statearr_15245;
})();
var statearr_15246_15279 = state_15217__$1;
(statearr_15246_15279[(2)] = null);

(statearr_15246_15279[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__11824__auto___15257,ws_chan,initial_ch,web_socket,map__15150,map__15150__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__15145,map__15148,map__15148__$1,opts,read_ch,write_ch,format,ws_opts))
;
return ((function (switch__11712__auto__,c__11824__auto___15257,ws_chan,initial_ch,web_socket,map__15150,map__15150__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__15145,map__15148,map__15148__$1,opts,read_ch,write_ch,format,ws_opts){
return (function() {
var chord$client$state_machine__11713__auto__ = null;
var chord$client$state_machine__11713__auto____0 = (function (){
var statearr_15250 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_15250[(0)] = chord$client$state_machine__11713__auto__);

(statearr_15250[(1)] = (1));

return statearr_15250;
});
var chord$client$state_machine__11713__auto____1 = (function (state_15217){
while(true){
var ret_value__11714__auto__ = (function (){try{while(true){
var result__11715__auto__ = switch__11712__auto__.call(null,state_15217);
if(cljs.core.keyword_identical_QMARK_.call(null,result__11715__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__11715__auto__;
}
break;
}
}catch (e15251){if((e15251 instanceof Object)){
var ex__11716__auto__ = e15251;
var statearr_15252_15280 = state_15217;
(statearr_15252_15280[(5)] = ex__11716__auto__);


cljs.core.async.impl.ioc_helpers.process_exception.call(null,state_15217);

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
throw e15251;

}
}})();
if(cljs.core.keyword_identical_QMARK_.call(null,ret_value__11714__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__15281 = state_15217;
state_15217 = G__15281;
continue;
} else {
return ret_value__11714__auto__;
}
break;
}
});
chord$client$state_machine__11713__auto__ = function(state_15217){
switch(arguments.length){
case 0:
return chord$client$state_machine__11713__auto____0.call(this);
case 1:
return chord$client$state_machine__11713__auto____1.call(this,state_15217);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
chord$client$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$0 = chord$client$state_machine__11713__auto____0;
chord$client$state_machine__11713__auto__.cljs$core$IFn$_invoke$arity$1 = chord$client$state_machine__11713__auto____1;
return chord$client$state_machine__11713__auto__;
})()
;})(switch__11712__auto__,c__11824__auto___15257,ws_chan,initial_ch,web_socket,map__15150,map__15150__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__15145,map__15148,map__15148__$1,opts,read_ch,write_ch,format,ws_opts))
})();
var state__11826__auto__ = (function (){var statearr_15253 = f__11825__auto__.call(null);
(statearr_15253[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__11824__auto___15257);

return statearr_15253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped.call(null,state__11826__auto__);
});})(c__11824__auto___15257,ws_chan,initial_ch,web_socket,map__15150,map__15150__$1,read_ch__$1,write_ch__$1,open_ch,close_ch,vec__15145,map__15148,map__15148__$1,opts,read_ch,write_ch,format,ws_opts))
);


return initial_ch;
});

chord.client.ws_ch.cljs$lang$maxFixedArity = (1);

chord.client.ws_ch.cljs$lang$applyTo = (function (seq15142){
var G__15143 = cljs.core.first.call(null,seq15142);
var seq15142__$1 = cljs.core.next.call(null,seq15142);
return chord.client.ws_ch.cljs$core$IFn$_invoke$arity$variadic(G__15143,seq15142__$1);
});


//# sourceMappingURL=client.js.map