(ns {{project-ns}}.core
  (:gen-class)
  (:require [muon-clojure.server :as mcs]
            [muon-clojure.common :as mcc]
            [clojure.core.async :refer [to-chan]]))

(def mq-url "amqp://localhost") ;; TODO: Set the correct RabbitMQ location
(def service-name "dummy") ;; TODO: Set a name and tags for the service
(def service-tags ["tag-1" "tag-2"])

(defrecord {{capitalized}}Microservice [m]
  mcs/MicroserviceStream
  (expose-stream! [this]
    ;; TODO: provide a proper channel generator function and an endpoint-name
    (mcc/stream-source this "endpoint-name" (fn [params] (to-chan [1 2 3 4 5]))))
  mcs/MicroserviceCommand
  (expose-post! [this]
    ;; TODO: provide proper POST listener functions
    (mcc/on-command this "post-endpoint-1" (fn [resource] "return-value-1"))
    (mcc/on-command this "post-endpoint-2" (fn [resource] "return-value-2"))))

(defn new-microservice [url] 
  (->{{capitalized}}Microservice
      (mcs/muon url service-name service-tags)))

(defn -main [& args]
  (let [ms (new-microservice mq-url)]
    (mcs/start-server! ms)))

