/*
 * Decompiled with CFR 0.152.
 */
package com.github.mpjct.jmpjct.plugin.cache.eh;

import com.github.mpjct.jmpjct.Engine;
import com.github.mpjct.jmpjct.JMP;
import com.github.mpjct.jmpjct.mysql.proto.Column;
import com.github.mpjct.jmpjct.mysql.proto.ERR;
import com.github.mpjct.jmpjct.mysql.proto.OK;
import com.github.mpjct.jmpjct.mysql.proto.ResultSet;
import com.github.mpjct.jmpjct.mysql.proto.Row;
import com.github.mpjct.jmpjct.plugin.Base;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.terracotta.TerracottaNotRunningException;
import org.apache.log4j.Logger;

public class Eh
extends Base {
    private static Ehcache cache = null;
    private static CacheManager cachemanager = null;
    public Logger logger = Logger.getLogger((String)"Plugin.Cache.Eh");
    private int TTL = 0;
    private String key = "";

    public Eh() {
        if (cachemanager == null) {
            this.logger.trace((Object)("Eh - CacheManager: Loading " + JMP.config.getProperty("ehcacheConf")));
            cachemanager = CacheManager.create((String)JMP.config.getProperty("ehcacheConf").trim());
        }
        if (cache == null) {
            this.logger.trace((Object)("Eh - cache: Getting " + JMP.config.getProperty("ehcacheCacheName")));
            cache = cachemanager.getEhcache(JMP.config.getProperty("ehcacheCacheName").trim());
            cache.setSampledStatisticsEnabled(true);
        }
        if (cache == null) {
            this.logger.fatal((Object)("Eh is null! Does instance '" + JMP.config.getProperty("ehcacheCacheName") + "' exist?"));
        }
    }

    @Override
    public void read_query(Engine engine) {
        if (cache == null) {
            return;
        }
        String string = engine.query;
        String string2 = "";
        String string3 = "";
        this.TTL = 0;
        this.key = "";
        if (!string.startsWith("/* ")) {
            return;
        }
        string2 = string.substring(3, string.indexOf("*/")).trim();
        if (string2.indexOf(":") != -1) {
            string3 = string2.substring(string2.indexOf(":") + 1).trim();
            string2 = string2.substring(0, string2.indexOf(":")).trim();
        }
        string = string.substring(string.indexOf("*/") + 2).trim();
        this.key = engine.schema + ":" + string;
        this.logger.info((Object)("Cache Key: '" + this.key + "'"));
        this.logger.trace((Object)("Command: '" + string2 + "'" + " value: '" + string3 + "'"));
        if (string2.equalsIgnoreCase("CACHE")) {
            this.logger.trace((Object)"CACHE");
            this.TTL = Integer.parseInt(string3);
            engine.buffer_result_set();
            cache.acquireWriteLockOnKey((Object)this.key);
            Element element = cache.get((Serializable)((Object)this.key));
            if (element != null) {
                this.logger.trace((Object)"Cache Hit!");
                cache.releaseWriteLockOnKey((Object)this.key);
                engine.clear_buffer();
                engine.buffer = (ArrayList)element.getValue();
                engine.nextMode = 10;
                if (engine.buffer.size() == 0) {
                    ERR eRR = new ERR();
                    eRR.sequenceId = engine.sequenceId + 1L;
                    eRR.errorCode = 1032L;
                    eRR.sqlState = "HY000";
                    eRR.errorMessage = "Can't find record in ehcache";
                    engine.clear_buffer();
                    engine.buffer.add(eRR.toPacket());
                    engine.nextMode = 10;
                    this.logger.fatal((Object)"Cache hit but invalid result!");
                }
            }
        } else if (string2.equalsIgnoreCase("FLUSH")) {
            this.logger.trace((Object)"FLUSH");
            OK oK = new OK();
            boolean bl = cache.remove((Serializable)((Object)this.key));
            if (bl) {
                oK.affectedRows = 1L;
            }
            oK.sequenceId = engine.sequenceId + 1L;
            engine.clear_buffer();
            engine.buffer.add(oK.toPacket());
            engine.nextMode = 10;
        } else if (string2.equalsIgnoreCase("FLUSHALL")) {
            this.logger.trace((Object)"FLUSHALL");
            OK oK = new OK();
            cache.removeAll();
            oK.sequenceId = engine.sequenceId + 1L;
            engine.clear_buffer();
            engine.buffer.add(oK.toPacket());
            engine.nextMode = 10;
        } else if (string2.equalsIgnoreCase("REFRESH")) {
            this.logger.trace((Object)"REFRESH");
            cache.remove((Serializable)((Object)this.key));
            this.TTL = Integer.parseInt(string3);
            engine.buffer_result_set();
        } else if (string2.equalsIgnoreCase("STATS")) {
            this.logger.trace((Object)"STATS");
            ResultSet resultSet = new ResultSet();
            Object var6_14 = null;
            resultSet.addColumn(new Column("Key"));
            resultSet.addColumn(new Column("Value"));
            Statistics statistics = cache.getStatistics();
            resultSet.addRow(new Row("AverageGetTime", statistics.getAverageGetTime()));
            resultSet.addRow(new Row("AverageSearchTime", statistics.getAverageSearchTime()));
            resultSet.addRow(new Row("ObjectCount", statistics.getObjectCount()));
            resultSet.addRow(new Row("MemoryStoreObjectCount", statistics.getMemoryStoreObjectCount()));
            resultSet.addRow(new Row("OffHeapStoreObjectCount", statistics.getOffHeapStoreObjectCount()));
            resultSet.addRow(new Row("DiskStoreObjectCount", statistics.getDiskStoreObjectCount()));
            resultSet.addRow(new Row("CacheHits", statistics.getCacheHits()));
            resultSet.addRow(new Row("CacheMisses", statistics.getCacheMisses()));
            resultSet.addRow(new Row("InMemoryHits", statistics.getInMemoryHits()));
            resultSet.addRow(new Row("InMemoryMisses", statistics.getInMemoryMisses()));
            resultSet.addRow(new Row("OffHeapHits", statistics.getOffHeapHits()));
            resultSet.addRow(new Row("OffHeapMisses", statistics.getOffHeapMisses()));
            resultSet.addRow(new Row("OnDiskHits", statistics.getOnDiskHits()));
            resultSet.addRow(new Row("OnDiskMisses", statistics.getOnDiskMisses()));
            resultSet.addRow(new Row("EvictionCount", statistics.getEvictionCount()));
            resultSet.addRow(new Row("SearchesPerSecond", statistics.getSearchesPerSecond()));
            resultSet.addRow(new Row("WriterQueueSize", statistics.getWriterQueueSize()));
            engine.clear_buffer();
            engine.buffer = resultSet.toPackets();
            engine.nextMode = 10;
        } else if (string2.equalsIgnoreCase("INFO")) {
            this.logger.trace((Object)"INFO");
            ResultSet resultSet = new ResultSet();
            Object var6_15 = null;
            resultSet.addColumn(new Column("Key"));
            resultSet.addColumn(new Column("Value"));
            resultSet.addRow(new Row("getGuid", cache.getGuid()));
            resultSet.addRow(new Row("getName", cache.getName()));
            resultSet.addRow(new Row("getStatus", cache.getStatus().toString()));
            resultSet.addRow(new Row("isDisabled", cache.isDisabled()));
            resultSet.addRow(new Row("isSearchable", cache.isSearchable()));
            try {
                resultSet.addRow(new Row("isNodeBulkLoadEnabled", cache.isNodeBulkLoadEnabled()));
                resultSet.addRow(new Row("isClusterBulkLoadEnabled", cache.isClusterBulkLoadEnabled()));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (TerracottaNotRunningException terracottaNotRunningException) {
                // empty catch block
            }
            resultSet.addRow(new Row("isStatisticsEnabled", cache.isStatisticsEnabled()));
            resultSet.addRow(new Row("isSampledStatisticsEnabled", cache.isSampledStatisticsEnabled()));
            switch (cache.getStatisticsAccuracy()) {
                case 1: {
                    resultSet.addRow(new Row("getStatisticsAccuracy", "STATISTICS_ACCURACY_BEST_EFFORT"));
                    break;
                }
                case 2: {
                    resultSet.addRow(new Row("getStatisticsAccuracy", "STATISTICS_ACCURACY_GUARANTEED"));
                    break;
                }
                case 0: {
                    resultSet.addRow(new Row("getStatisticsAccuracy", "STATISTICS_ACCURACY_NONE"));
                    break;
                }
                default: {
                    resultSet.addRow(new Row("getStatisticsAccuracy", "STATISTICS_ACCURACY_UNKNOWN"));
                }
            }
            resultSet.addRow(new Row("hasAbortedSizeOf", cache.hasAbortedSizeOf()));
            engine.clear_buffer();
            engine.buffer = resultSet.toPackets();
            engine.nextMode = 10;
        } else if (string2.equalsIgnoreCase("DUMP KEYS")) {
            this.logger.trace((Object)"DUMP KEYS");
            List list = cache.getKeysWithExpiryCheck();
            ResultSet resultSet = new ResultSet();
            resultSet.addColumn(new Column("Key"));
            for (Object e : list) {
                this.logger.trace((Object)("Key: '" + e + "'"));
                resultSet.addRow(new Row(e.toString()));
            }
            engine.clear_buffer();
            engine.buffer = resultSet.toPackets();
            engine.nextMode = 10;
        } else {
            this.logger.trace((Object)"FAIL");
            ERR eRR = new ERR();
            eRR.sequenceId = engine.sequenceId + 1L;
            eRR.errorCode = 1047L;
            eRR.sqlState = "08S01";
            eRR.errorMessage = "Unknown command '" + string2 + "'";
            engine.clear_buffer();
            engine.buffer.add(eRR.toPacket());
            engine.nextMode = 10;
            this.logger.fatal((Object)(string2 + " is unknown!"));
        }
    }

    @Override
    public void read_query_result(Engine engine) {
        if (cache == null) {
            return;
        }
        if (this.TTL == 0 || engine.buffer.size() == 0) {
            return;
        }
        Element element = new Element((Serializable)((Object)this.key), engine.buffer);
        element.setTimeToLive(this.TTL);
        cache.put(element);
        cache.releaseWriteLockOnKey((Object)this.key);
    }
}

