/*
 * Decompiled with CFR 0.152.
 */
package com.github.mpjct.jmpjct.mysql.proto;

import com.github.mpjct.jmpjct.mysql.proto.HandshakeResponse;
import com.github.mpjct.jmpjct.mysql.proto.Packet;
import com.github.mpjct.jmpjct.mysql.proto.Proto;
import java.util.ArrayList;

public class SSLRequest
extends Packet {
    public long capabilityFlags = 512L;
    public long maxPacketSize = 0L;
    public long characterSet = 0L;

    public void setCapabilityFlag(long l) {
        this.capabilityFlags |= l;
    }

    public void removeCapabilityFlag(long l) {
        this.capabilityFlags &= l ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public void toggleCapabilityFlag(long l) {
        this.capabilityFlags ^= l;
    }

    public boolean hasCapabilityFlag(long l) {
        return (this.capabilityFlags & l) == l;
    }

    @Override
    public ArrayList<byte[]> getPayload() {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(Proto.build_fixed_int(4, this.capabilityFlags));
        arrayList.add(Proto.build_fixed_int(4, this.maxPacketSize));
        arrayList.add(Proto.build_fixed_int(1, this.characterSet));
        arrayList.add(Proto.build_filler(23));
        return arrayList;
    }

    public static HandshakeResponse loadFromPacket(byte[] byArray) {
        HandshakeResponse handshakeResponse = new HandshakeResponse();
        Proto proto = new Proto(byArray, 3);
        handshakeResponse.capabilityFlags = proto.get_fixed_int(4);
        handshakeResponse.maxPacketSize = proto.get_fixed_int(4);
        handshakeResponse.characterSet = proto.get_fixed_int(1);
        proto.get_filler(23);
        return handshakeResponse;
    }
}

