/*
 * Decompiled with CFR 0.152.
 */
package com.github.mpjct.jmpjct;

import com.github.mpjct.jmpjct.Engine;
import com.github.mpjct.jmpjct.JMP;
import com.github.mpjct.jmpjct.plugin.Base;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class JMP_Thread
implements Runnable {
    public int port;
    public boolean listening = true;
    public ServerSocket listener = null;
    public ArrayList<Base> plugins = new ArrayList();
    public Logger logger = Logger.getLogger((String)"JMP_Thread");

    public JMP_Thread(int n) {
        Thread.currentThread().setName("Listener: " + n);
        this.port = n;
    }

    @Override
    public void run() {
        try {
            this.listener = new ServerSocket(this.port);
        }
        catch (IOException iOException) {
            this.logger.fatal((Object)("Could not listen on port " + this.port));
            System.exit(-1);
        }
        this.logger.info((Object)("Listening on " + this.port));
        String[] stringArray = new String[]{};
        ExecutorService executorService = Executors.newCachedThreadPool();
        if (JMP.config.getProperty("plugins") != null) {
            stringArray = JMP.config.getProperty("plugins").split(",");
        }
        while (this.listening) {
            this.plugins = new ArrayList();
            for (String string : stringArray) {
                try {
                    this.plugins.add((Base)Base.class.getClassLoader().loadClass(string.trim()).newInstance());
                    this.logger.info((Object)("Loaded plugin " + string));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    this.logger.error((Object)("[" + string + "] " + classNotFoundException));
                }
                catch (InstantiationException instantiationException) {
                    this.logger.error((Object)("[" + string + "] " + instantiationException));
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.logger.error((Object)("[" + string + "] " + illegalAccessException));
                }
            }
            try {
                executorService.submit(new Engine(this.port, this.listener.accept(), this.plugins));
            }
            catch (IOException iOException) {
                this.logger.fatal((Object)("Accept fatal " + iOException));
                this.listening = false;
            }
        }
        try {
            executorService.shutdown();
            this.listener.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

